package miiee.xml;

import java.util.*;
import java.io.*;
import java.beans.*;
import org.xml.sax.Attributes;

public class  PropertyList extends Object implements Serializable {

  HashMap _properties = new HashMap(11);
  protected PropertyChangeSupport _pcSupport;
  protected VetoableChangeSupport _vcSupport;
  protected XMLComponent _source;
  private boolean _debug = false;
  StringBuffer _buff = new StringBuffer();
  
  public static final int kAttributes = 0;
  public static final int kProperties = 1;

  public  PropertyList( XMLComponent source )  {
	 _source = source;
  }	

  public Object addAttribute( String attributeName, Object value ) {
	return add( attributeName, value, XMLComponent.kStatic, null, true );
  }

  public Object add( String propertyName, Object value ) {
	return add( propertyName, value, XMLComponent.kMutable, null, false );
  }

  public Object add( String propertyName, Object value, int mutability ) {
	return add( propertyName, value, mutability, null, false );
  }	

  public Object add( String propertyName, Object value, int mutability, String type ) {
	return add( propertyName, value, mutability, type, false );
  }	

  public Object add( String propertyName, Object value, int mutability, String type, boolean isAttribute  ) {
	return add( propertyName, value, mutability, type, isAttribute, false );
  }	
  
  public boolean containsKey( String propertyName ) {
	return _properties.containsKey(propertyName);
  }
  
  public Object add( String propertyName, Object value, int mutability, String type, boolean isAttribute, boolean reportDiscrepancies  ) {
	if( reportDiscrepancies ) {
	  if( _properties.containsKey(propertyName) ) {
		Property  p = (Property) _properties.get(propertyName);
		if( p != null ) {
		  String val0 = p.value.toString();
		  String val1 = value.toString();
		  if( !val0.equals( val1 ) ) {
			System.out.println("Value conflict for property " + propertyName + ": " + val0 + " vs " + val1 + " in " + _source );
		  }
		}
	  }
	}
	Property p = new Property(value,mutability,type,isAttribute);
	synchronized ( _properties ) { _properties.put( propertyName, p ); }
	if( _debug ) { System.out.println("Add property: " + propertyName + " -> " + value ); }
	return p;
  }

  public Object change( String propertyName, Object newValue ) throws XMLException {
	Property  p = (Property) _properties.get(propertyName);
	if( p == null ) {
	  throw new XMLException( " Attempt to change non-existent Property: " + propertyName );
	}
	Object oldValue = p.value;
	if( p.getMutability() == XMLComponent.kVetoable && ( _vcSupport != null )  ) {
	  try {
		_vcSupport.fireVetoableChange( propertyName,  oldValue, newValue );
	  } catch ( PropertyVetoException ex ) {
		return null;
	  }
	}
	if( p.getMutability() >= XMLComponent.kMutable ) {
	   if ( _pcSupport != null ) {
		 _pcSupport.firePropertyChange( propertyName, oldValue, newValue );
	   }
	   p.value = newValue;
	} else {
	  throw new XMLException( " Attempt to change static Property: " + propertyName );
	}
	if( _debug ) { System.out.println("Change property: " + propertyName + " -> " + newValue ); }
	return p;
  } 

  public Object set( String propertyName, Object newValue, int mutability, String type ) throws XMLException {
	return set( propertyName, newValue, mutability, type, false );
  }
  
  public Object set( String propertyName, Object newValue, int mutability, String type, boolean isAttribute ) throws XMLException {
	Object oldValue = null;
	Property  p = (Property) _properties.get(propertyName);
	if( p == null ) {
	  p = (Property) add( propertyName, newValue, mutability, type, isAttribute );
	} else {
	  oldValue = p.value;
	  if( p.getMutability() == XMLComponent.kVetoable && ( _vcSupport != null )  ) {
		try {
		  _vcSupport.fireVetoableChange( propertyName,  oldValue, newValue );
		} catch ( PropertyVetoException ex ) {
		  return null;
		}
	  }
	}
	if( type != null ) {
	  String etype = p.getElementType(); 
	  if( (etype != null ) && !etype.equals(type) ) {
		throw new XMLException( " Illegal Attempt to change Property type: " + propertyName + " -> type " + type );
	  }
	}
	if( p.getMutability() >= XMLComponent.kMutable ) {
	   if ( _pcSupport != null ) {
		 _pcSupport.firePropertyChange( propertyName, oldValue, newValue );
		 if( _debug ) {  
		   System.out.println("Fire property change; " + propertyName + " : " + 
							 ((oldValue != null ) ? oldValue : "(null)") +" -> " + newValue );
		 }
	   }
	   p.value = newValue;
	} else {
	  throw new XMLException( " Attempt to change static Property: " + propertyName );
	}
	if( _debug ) { System.out.println("Set property: " + propertyName + " -> " + newValue ); }
	return p;
  } 
  
  public Object get( String propertyName ) {
	Property  p = (Property) _properties.get(propertyName);
	if( p == null ) return null;
	return p.value;
  }

  public boolean has( String propertyName  ) {
	return _properties.containsKey(propertyName);
  }
 
   public void importProperties( PropertyList atts ) {
	importProperties( atts, true );
  }

  public void importProperties( PropertyList atts, boolean reportDiscrepancies ) {
	if( atts == null ) return;
	Iterator ei = atts.entryIterator();
	while( ei.hasNext() ) {
	  Map.Entry entry = (Map.Entry) ei.next();
	  String name = (String) entry.getKey();
	  Property prop = (Property) entry.getValue();
	  int mut = prop.getMutability();
	  String type = prop.getElementType();
	  boolean isAttr = prop.isAttribute();
	  Object value = prop.value;
	  if( _source.processAttribute( name, value.toString(), type ) ) {
	   add( name, value, mut, type, isAttr, reportDiscrepancies );
	  }
   }
  }
 
  public void importAttributes( Attributes atts ) {
	importAttributes( atts, true );
  }

  public void importAttributes( Attributes atts, boolean reportDiscrepancies ) {
	if( atts == null ) return;
   for (int i = 0; i < atts.getLength(); i++) {
     String name = atts.getQName(i);
//	 int type = javax.swing.text.html.parser.Attributes.name2type(atts.getType(i));
     String value = atts.getValue(i);
     String type = atts.getType(i);
     if( _source.processAttribute( name, value, type ) ) {
	   add( name, value, XMLComponent.kMutable, type, true, reportDiscrepancies );
	 }
   }
  }
/*  
  public boolean propertyConflict( Attributes atts, String propertyName ) {
   Property  p = (Property) _properties.get(propertyName);
   if( p == null ) return false;
   String propertyValue = null;
   for (int i = 0; i < atts.getLength(); i++) {
     if( atts.getName(i).equals(propertyName) ) {
     propertyValue = atts.getValue(i);
     break;
   }
   if( propertyValue == null ) return false;
	if( propertyValue.equals( p.value.toString() ) ) return true; 
	return false;
  }
*/  
  public static Integer getNumberAttribute( String attributeName, Attributes  atts ) throws XMLException {
	 for (int i = 0; i < atts.getLength(); i++) {
	   String name = atts.getQName(i);
	  if( attributeName.equals(name) ) {
		String type = atts.getType(i);
		String value = atts.getValue(i);
		try {
		  return Integer.valueOf(value);
		} catch ( NumberFormatException err ) {
		  throw new XMLException( " Mal-formed NUMBER Attribute " + attributeName + ": " + value );
		}
	  }
	}
	return null;
  } 

  public static String getStringAttribute( String attributeName, Attributes  atts )  {
	 for (int i = 0; i < atts.getLength(); i++) {
	   String name = atts.getQName(i);
		if( attributeName.equals(name) ) {
		  return atts.getValue(i);
		}
	}
	return null;
  } 
  
  public int size() { return _properties.size(); }
  
  public Iterator values() { 
	Iterator iter;
	synchronized ( _properties ) { iter = _properties.values().iterator(); }
	return iter; 
  }
    
  public Iterator entryIterator() { 
	Iterator iter;
	synchronized ( _properties ) { iter = _properties.entrySet().iterator(); }
	return iter; 
  }

   public void writeXML( BufferedWriter out, int format )  throws IOException {
	  writeXML( out, format, null );
  }

   public void writeXML( BufferedWriter out, int format, String propertyName )  throws IOException {
	  Iterator iter = entryIterator();
	  while( iter.hasNext() ) {
		Map.Entry entry = (Map.Entry) iter.next();
		String name = (String) entry.getKey();
		if( (propertyName == null) ||  propertyName.equals(name) ) {
		  Property value = (Property) entry.getValue();
		  if( format == kProperties ) {
			if( !value.isAttribute() ) {
			  out.newLine();  out.write( "\t\t\t\t<" + name + "> "  ); 
			  out.newLine();  out.write( "\t\t\t\t\t" + convertToXML( value.toString() ) );
			  out.newLine();  out.write( "\t\t\t\t </" + name + "> " ); 
			}
		  } else if( format == kAttributes ) {
			if( value.isAttribute() ) {
			  out.write( " " + name + "=\"" + value + "\" " ); 
			}
		  }
		}
	  }  
  }
  
  public String convertToXML( String input ) {
	_buff.setLength(0);
	for( int i=0; i<input.length(); i++ ) {
	   char ctmp = input.charAt(i);
	   if( ctmp      == '<' ) { _buff.append("&lt;");  }
	   else if( ctmp == '>' ) { _buff.append("&gt;");  }
	   else if( ctmp == '&' ) { _buff.append("&amp;"); }
	   else                   { _buff.append(ctmp);    }
	}
	return _buff.toString();
  }
          
  public void dump( Vector keys, Vector values ) {
	Iterator iter; 
	int size=0, cnt=0;
	synchronized ( _properties ) { 
	  iter = _properties.entrySet().iterator(); 
	  size = _properties.size();
	}
	keys.setSize(size);
	values.setSize(size);
	while( iter.hasNext() ) {
	  Map.Entry entry = (Map.Entry) iter.next();
	  keys.setElementAt( entry.getKey(), cnt );
	  values.setElementAt( ((Property)entry.getValue()).value, cnt );
	  cnt++;
	}  
  }

    /**
     * Add a PropertyChangeListener to the listener list.
     * The listener is registered for all properties.
     *
     * @param listener  The PropertyChangeListener to be added
     */

    public synchronized void addPropertyChangeListener( PropertyChangeListener listener) {
	   if( _pcSupport == null ) { _pcSupport = new PropertyChangeSupport( _source ); }
	  _pcSupport.addPropertyChangeListener( listener);
    }

    /**
     * Remove a PropertyChangeListener from the listener list.
     * This removes a PropertyChangeListener that was registered
     * for all properties.
     *
     * @param listener  The PropertyChangeListener to be removed
     */

    public synchronized void removePropertyChangeListener( PropertyChangeListener listener) {
	  _pcSupport.removePropertyChangeListener( listener);
    }

    /**
     * Add a PropertyChangeListener for a specific property.  The listener
     * will be invoked only when a call on firePropertyChange names that
     * specific property.
     *
     * @param propertyName  The name of the property to listen on.
     * @param listener  The PropertyChangeListener to be added
     */

    public synchronized void addPropertyChangeListener( String propertyName, PropertyChangeListener listener) {
	   if( _pcSupport == null ) { _pcSupport = new PropertyChangeSupport( _source ); }
	  _pcSupport.addPropertyChangeListener( propertyName, listener );
    }

    /**
     * Remove a PropertyChangeListener for a specific property.
     *
     * @param propertyName  The name of the property that was listened on.
     * @param listener  The PropertyChangeListener to be removed
     */

    public synchronized void removePropertyChangeListener( String propertyName, PropertyChangeListener listener) {
	  _pcSupport.removePropertyChangeListener( propertyName, listener );
    }

    /**
     * Add a VetoableListener to the listener list.
     * The listener is registered for all properties.
     *
     * @param listener  The VetoableChangeListener to be added
     */

    public synchronized void addVetoableChangeListener( VetoableChangeListener listener) {
	   if( _vcSupport == null ) { _vcSupport = new VetoableChangeSupport( _source ); }
	  _vcSupport.addVetoableChangeListener(listener);
    }

    /**
     * Remove a VetoableChangeListener from the listener list.
     * This removes a PropertyChangeListener that was registered
     * for all properties.
     *
     * @param listener  The VetoableChangeListener to be removed
     */
    public synchronized void removeVetoableChangeListener( VetoableChangeListener listener) {
	  _vcSupport.removeVetoableChangeListener(listener);
    }


    /**
     * Add a VetoableChangeListener for a specific property.  The listener
     * will be invoked only when a call on fireVetoableChange names that
     * specific property.
     *
     * @param propertyName  The name of the property to listen on.
     * @param listener  The VetoableChangeListener to be added
     */

    public synchronized void addVetoableChangeListener( String propertyName, VetoableChangeListener listener) {
	   if( _vcSupport == null ) { _vcSupport = new VetoableChangeSupport( _source ); }
	  _vcSupport.addVetoableChangeListener(propertyName,listener);
    }

    /**
     * Remove a VetoableChangeListener for a specific property.
     *
     * @param propertyName  The name of the property that was listened on.
     * @param listener  The VetoableChangeListener to be removed
     */

    public synchronized void removeVetoableChangeListener( String propertyName, VetoableChangeListener listener) {
	  _vcSupport.removeVetoableChangeListener(propertyName,listener);
    }

  protected class  Property extends Object implements Serializable {

	int _mutability = XMLComponent.kStatic;
	String _elementType;
	boolean _isAttribute = false;
	public Object value;

	Property( Object val )  {
	  super();
	   value = val;
	}	

	Property( Object val, int mutability )  {
	  super();
	   value = val;
	  _mutability = mutability;
	}

	Property( Object val, int mutability, String type, boolean isAttribute  )  {
	  super();
	   value = val;
	  _mutability = mutability;
	  _elementType = type;
	  _isAttribute = isAttribute;
	}
		
	int getMutability() { return _mutability; }	
	String getElementType() { return _elementType; }	
	boolean isAttribute() { return _isAttribute; }
	public String toString() { return (value==null) ? "" : value.toString(); }
  }

}
