package miiee.xml;  

import javax.swing.*;
import miiee.util.SimIO;
import java.io.File;
import javax.swing.table.*;
import java.util.Vector;
import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;
import java.awt.Rectangle;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.event.*;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.*;
import java.beans.*;

public class PropertyTable extends JPanel implements PropertyChangeListener {

    protected PropertyTableModel _dataModel = new PropertyTableModel(); 
    protected TableColumnModel _cm;   
    protected PropertyList _properties;
    protected JTable _table;    
	int _propertyWidth;
	int _valueWidth;    
    
   /**
      * Constructs a new instance of PropertyTable.
      */
    PropertyTable( int propertyWidth, int valueWidth ) {
		super();
		_propertyWidth = propertyWidth;
		_valueWidth = valueWidth;
		_table = new JTable(_dataModel);
		_cm = _table.getColumnModel(); 
		formatColumns();
    }
	
	public static PropertyTable getTablePanel(int propertyWidth, int valueWidth) {
	  PropertyTable p = new PropertyTable(propertyWidth, valueWidth);
	  p.init();
	  return p;
	}
				
	public int getRowCount() { return _dataModel.getRowCount(); }
	public int getColumnCount() { return _dataModel.getColumnCount(); }


	public void setProperties( Vector keys, Vector values ) {
	  _dataModel.setProperties( keys, values );
	  formatColumns();
	}

	public void setProperties( PropertyList pl ) {
	  _dataModel.setProperties( pl );
	  formatColumns();
	}

	public void setProperties( HashMap pl ) {
	  _dataModel.setProperties( pl );
	  formatColumns();
	}
	
	public void addProperty( String key, String value, boolean unique_map ) {
	  _dataModel.addProperty( key, value, unique_map );
	  formatColumns();
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
	   XMLComponent cp =  (XMLComponent) evt.getSource();
	   setProperties( cp.getProperties() );
	}
	
	public String deleteSelectedProperty() {
	  int row = _table.getSelectedRow();
	  String rv = _dataModel.deleteRow(row);
	  formatColumns();
	  return rv;
	}
	
	public void setHeaders( String header0, String header1 ) {
	  _dataModel.setHeaders( header0, header1 );
	}
	
	public  PropertyList getProperties() { 
	  return _properties; 
	}
	
	public int getSelectedRow() { return _table.getSelectedRow(); }
	
	public int getIndexOfProperty( String prop_key ) {
	  return _dataModel.getIndexOfProperty( prop_key );
	}
	
	public Object getValueAt(int row, int col) {
	  return _dataModel.getValueAt( row, col );
	}

	public Object getSelectedObject( int col ) {
	  return _dataModel.getValueAt( _table.getSelectedRow(), col );
	}
		
    public synchronized void init() {   
		JScrollPane scrollpane = new JScrollPane(_table);
		scrollpane.setPreferredSize( new Dimension( _valueWidth + _propertyWidth, 350 ) );
		scrollpane.setBorder( BorderFactory.createLoweredBevelBorder() );
		
		setLayout(new BorderLayout());
		add( "Center", scrollpane );
    }

	void formatColumns() {        
        DefaultTableCellRenderer propertyColumnRenderer = new DefaultTableCellRenderer();
        propertyColumnRenderer.setBackground(Color.yellow);
        propertyColumnRenderer.setHorizontalAlignment(JLabel.CENTER);
               
		TableColumn tableColumn =  _cm.getColumn(0);
		tableColumn.setWidth(_propertyWidth);
		tableColumn.setCellRenderer(propertyColumnRenderer); 
		 
		tableColumn =  _cm.getColumn(1);
		tableColumn.setWidth(_valueWidth); 
		repaint();
	}
	
	void setColumnWidths() {
	  _cm.getColumn(0).setWidth(_propertyWidth);
	  _cm.getColumn(1).setWidth(_valueWidth);
	  repaint();
	}

}

class PropertyTableModel extends AbstractTableModel {
	Vector _keys = new Vector(16,16);
	Vector _values = new Vector(16,16);
	String _header0 = "Property";
	String _header1 = "Value";
	
	PropertyTableModel() {
	  super();
	}
	
	public void setHeaders( String header0, String header1 ) {
	  _header0 = header0;
	  _header1 = header1;
	  fireTableStructureChanged();
	}
	 
	public void setProperties( PropertyList pl ) {
	  if( pl == null ) {
		_keys.clear(); _values.clear();	
	  } else {
		pl.dump( _keys, _values );
	  }
	  fireTableRowsInserted(0,_keys.size()-1);
	}

	public void setProperties( HashMap pl ) {
	  _keys.clear(); _values.clear();	
	  if( pl != null ) {
		_values.addAll( pl.values() );
		_keys.addAll( pl.keySet() );
	  }
	  fireTableRowsInserted(0,_keys.size()-1);
	}
	
	public String deleteRow( int row ) {
		String rv = null;
		try {
		  rv = (String) _keys.get(row);
		  _values.remove(row);
		  _keys.remove(row);
		  fireTableRowsDeleted(row,row);	
		} catch ( ArrayIndexOutOfBoundsException err ) {
		  SimIO.beep();
		}
		return rv;
	}

	public void setProperties( Vector keys, Vector values ) {
	  _keys.clear(); _values.clear();
	  if( keys != null )   {   _keys.addAll(keys);     }
	  if( values != null ) {   _values.addAll(values); }
	  fireTableRowsInserted(0,_keys.size()-1);
	}

	public void addProperty( String key, String value, boolean unique_map ) {
	  int kindex = -1;
	  if( unique_map && ( (kindex = _keys.indexOf(key)) >= 0 ) ) {
		_values.remove(kindex);
		_values.add(kindex,value);
	  } else {
		_keys.add(key); _values.add(value);
		kindex = _keys.size()-1;
	  }
	  fireTableRowsInserted(kindex,kindex);
	}
			
	public String getColumnName(int column) {
	  if( column == 0 ) return _header0;
	  if( column == 1 ) return _header1;
	  return "";
	}
	
	public int getColumnCount() { 
		return 2; 
	}
	
	public int getRowCount() { 
		return  _keys.size();
	}
	
	public Object getValueAt(int row, int col) { 
	  try {
		if( col == 0 ) {
		  return  _keys.get(row);
		} else {
		  return  _values.get(row);
		}
	  } catch (  ArrayIndexOutOfBoundsException err ) {
		return "";
	  }
	}
	
	public int getIndexOfProperty( String prop_key ) {
	  return _keys.indexOf(prop_key);
	}	
	
	public Class getColumnClass(int columnIndex) {
	  return String.class;
	}	
}
