package miiee.xml;

import miiee.util.AttributeValuePair;
import miiee.util.SimIO;
import javax.swing.border.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*; 
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import java.util.Hashtable;
import java.io.*;
import java.util.StringTokenizer;


//---- ScriptExecutable ---------------------------------------------------------

public class ScriptExecutable extends Object implements Runnable {

	StringBuffer _stdout = new StringBuffer();
	StringBuffer _stderr = new StringBuffer();
	Hashtable _attributes = new Hashtable();
	XMLComponent _executer;
	String _script;
	String[] _envp;
	boolean _show_process_monitor = true;
	int _debug = 3;
	
	public ScriptExecutable() { super(); }

	public ScriptExecutable( boolean show_process_monitor ) { super(); _show_process_monitor = show_process_monitor; }
	
	public void execute( String s, String envp[], XMLComponent executer ) {
	   _script = s;
	   _envp = envp; 
	   _executer = executer;
        Thread t = new Thread(this);
        t.start();
	}
	
	public void addAttribute( String name, Object value ) { _attributes.put(name,value); }
	public Object getAttribute( String name ) { return _attributes.get(name); }

	public void execute( String s, XMLComponent executer ) { execute( s, null, executer); }
	
	void collectStdout( Process p ) {
	  InputStream is = p.getInputStream(); 
	  _stdout.setLength(0); 
	  int ch = '\n';
	  try {
		while ( (ch = is.read()) != -1 ) {
		  _stdout.append((char)ch);
		}
		if( ( _debug > 0 ) &&  (  _stdout.length() > 0 ) ) { 
			System.out.println( "\nStandard output: " +  _stdout.toString() ); 
		}
	  } catch ( IOException err ) {;}
	}

	void collectStderr( Process p ) {
	  InputStream is = p.getErrorStream(); 
	  _stdout.setLength(0); 
	  int ch = '\n';
	  try {
		while ( (ch = is.read()) != -1 ) {
		  _stderr.append((char)ch);
		}
		if( ( _debug > 0 ) &&  (  _stderr.length() > 0 ) ) { 
			System.out.println( "\nStandard error: " +  _stderr.toString() ); 
		}
	  } catch ( IOException err ) {;}
	}
	
	public void executionCallback( String stdout, String stderr, XMLComponent executer ) {
	  if( stderr == null ) stderr = "";
	  if( stdout == null ) stdout = "";
	  if( !_show_process_monitor ) {
		if( stdout.length() > 0 ) { System.out.println( "Script standard output: \n" +  stdout ); }
		if( stderr.length() > 0 ) { System.out.println( "Script standard error: \n" +  stderr ); }
	  }
	}

	public void errorCallback( int returnValue, String stdout, String stderr ) { 
	  if( stderr == null ) stderr = "";
	  if( stdout == null ) stdout = "";
	  if( returnValue != 0 ) {
	    System.out.println( "\n\n****************************************************** " );
	    System.out.println( "\nScript registered error " + returnValue + " : " + stderr );
	    System.out.println( "\nScript: " + _script );
		if( stdout.length() > 0 ) { System.out.println( "Script standard output: \n" +  stdout ); }
		if( stderr.length() > 0 ) { System.out.println( "Script standard error: \n" +  stderr ); }
	    System.out.println( "\n****************************************************** " );
	  }	
	}

	boolean hasExecutable( String s ) {
	  for( int i=0; i<s.length(); i++ ) {
		char ch = s.charAt(i);
		if( Character.isLetter(ch) ) return true;
	  }
	  return false;
	}
	
	public void run() {
	  ProcessMonitor pm = new ProcessMonitor();
	  try {
		int rv = 0;
		if( hasExecutable( _script ) ) {
		  StringTokenizer st = new StringTokenizer(_script, ";");
		  if( _show_process_monitor ) { pm.display(); }
		  while( st.hasMoreTokens() ) {
			String current_script = st.nextToken();
			System.out.println( " Executing script: " + current_script );
			Process p = Runtime.getRuntime().exec( current_script, _envp );
			if( _show_process_monitor ) { pm.setProcess(p,current_script); }
			try {
			  p.waitFor();
			} catch ( InterruptedException err ) { 
			  XMLException.show_error( null, "Interrupted while waiting for script execution! ", err  );
			  return; 
			}
			System.out.println( "Done executing script: " +  current_script );
			collectStdout( p );
			collectStderr( p );
			rv = p.exitValue();
			if( rv != 0 ) {
			  errorCallback( rv, _stdout.toString(), _stderr.toString() );	
			  break;		
			}
		  }	
		}		  
		if( _debug > 2 ) { System.out.println( "Doing executionCallback. "  ); }
		if( rv == 0 ) {
			executionCallback( _stdout.toString(), _stderr.toString(), _executer );
		}
	  } catch ( IOException err ) {
		 XMLException.show_error( null, "Script execution error: ", err );
	  }	
	  if( _show_process_monitor ) { pm.close(); }
	}

}

class ProcessMonitor extends Object implements Runnable {

  JDialog _dialog;
  Process _process;
  JTextPane _stdout_Pane = new JTextPane();
  JTextPane _stderr_Pane = new JTextPane();
  StringBuffer _in_sbuff = new StringBuffer();
  StringBuffer _err_sbuff = new StringBuffer();
  JScrollPane scrollpane1 = new JScrollPane();;
  JScrollPane scrollpane2 = new JScrollPane();;
  protected AttributeValuePair 	_ProcessLabel = AttributeValuePair.New( "Executing", false, 50 );
  boolean _reset = false;
  boolean _active = false;
	
  ProcessMonitor() {;}
  
  public void setProcess( Process p, String script ) {
	_process = p;
	_ProcessLabel.setValue(script);
	_reset = true;
  }
  
  public void close() {
	if( _dialog != null ) {
	  _dialog.dispose();
	  _dialog = null;
	}
  }
  
  public void start() {
	_active = true; 
	Thread t = new Thread(this);
	t.start();
  }
  
  public void stop() {
	_active = false; 
  }

  public void run() {
	  InputStream instream = null;
	  InputStream errstream = null;
	  JScrollBar sb1 = scrollpane1.getVerticalScrollBar();
	  JScrollBar sb2 = scrollpane2.getVerticalScrollBar();
	  try {
		while( _active ) {
		  boolean data_available = true;

		  if( _reset ) {
			if( instream != null ) { instream.close(); }  
			instream = _process.getInputStream();   
			if( errstream != null ) { errstream.close(); }
			errstream = _process.getErrorStream(); 
			_in_sbuff.append("\n\n -------------------------------- \n\n");
			_err_sbuff.append("\n\n -------------------------------- \n\n");
		  }
		  
		  while( data_available ) {
			try {  Thread.sleep(200L);   }
			catch (InterruptedException e0) {  return;  }
			int nb0=0, nb1=0;

			if( instream != null ) {
			  nb0 = instream.available();
			  for( int i=0; i<nb0; i++ ) {
				int ch = instream.read();
				System.out.print( (char)ch );
				_in_sbuff.append((char)ch);
				if( ch == '\n' ) {
				  _stdout_Pane.setText( _in_sbuff.toString() );
//				  sb1.setValue( sb1.getMaximum() );
				  break;
				}
			  }
			}

			if( errstream != null ) {
			  nb1 = errstream.available();
			  for( int i=0; i<nb1; i++ ) {
				int ch = errstream.read();
				System.out.print( (char)ch );
				_err_sbuff.append((char)ch);
				if( ch == '\n' ) {
				  _stderr_Pane.setText( _err_sbuff.toString() );
//				  sb2.setValue( sb2.getMaximum() );
				  break;
				}
			  }
			}
			data_available = ((nb0>0) | (nb1>0));
		  }
		}
		
	  } catch ( IOException err ) {
		 XMLException.show_error( null, "Script execution error: ", err );
	  }	
	}

  public void display() {

	_dialog = new JDialog( (Frame)null, "Process Monitor", false );
	WindowListener l = new WindowAdapter() {
		public void windowClosing(WindowEvent e) { stop(); }
		public void windowOpened(WindowEvent e) { start(); }
	};
	_dialog.addWindowListener(l);
	
	Container c = _dialog.getContentPane();     
	BoxLayout bl = new BoxLayout(c, BoxLayout.Y_AXIS );  c.setLayout( bl ); 	   
	EmptyBorder eb5 = new EmptyBorder( 5, 5, 5, 5 );
	Border bb = BorderFactory.createCompoundBorder( eb5, BorderFactory.createLoweredBevelBorder() );

	c.add(_ProcessLabel);
	
	scrollpane1.getViewport().setView(_stdout_Pane);
	scrollpane1.setMinimumSize(new Dimension(200, 200 )); 
	scrollpane1.setPreferredSize(new Dimension(500, 200 )); 
	scrollpane1.setBorder( bb );
	c.add(scrollpane1);

	scrollpane2.getViewport().setView(_stderr_Pane);
	scrollpane2.setMinimumSize(new Dimension(200, 200 )); 
	scrollpane2.setPreferredSize(new Dimension(500, 200 )); 
	scrollpane2.setBorder( bb );
	c.add(scrollpane2);
	
	_dialog.pack();
	_dialog.show();	  	  
  }
  
}    
