package miiee.xml;

import java.io.*;
import java.util.*;
import javax.swing.border.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*; 
import java.awt.*;
import java.awt.event.*;
import java.text.DateFormat;
import org.xml.sax.Attributes;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.*;
import miiee.util.*;

//---- XMLComponent ---------------------------------------------------------

public class XMLComponent extends Object implements Comparable, Serializable {    

  public static final int DECLARATION		= 0;
  public static final int DEFINITION		= 1;
  public static final int DATA				= 2;
  
  public static final String _empty_namespace = "";

  protected PropertyList _properties;
  protected Vector _data = new Vector( );
  private int _debug = 0;
  protected Icon _icon;
  protected int _depth = 0;
  protected int _index = -1;
 
  protected XMLComponent _parent;
  protected XMLData _enabler;
  protected HashMap _dataComponents;
  protected String _namespace = _empty_namespace;
  protected String _location; 
  private boolean _resolved=true;
  private boolean _configured=true;
  protected boolean _visible = true;
  protected Boolean _isOwner;
  private static DateFormat _dateFormat = DateFormat.getInstance();

  public static final int kStatic = 0;
  public static final int kMutable = 1;
  public static final int kVetoable = 2;
	
  public  XMLComponent( )  {
	 super();
	 createPropertyList( null ); 
  }	 
   
  public  XMLComponent( String id )  {
	 super();
	 createPropertyList( null ); 
	 _properties.addAttribute( "id", id ); 
  }	 

  public  XMLComponent( String attribute, String value )  {
	 super();
	 createPropertyList( null ); 
	 _properties.addAttribute( attribute, value ); 
  }	 

  public  XMLComponent( Attributes atts )  {
	 super();
	 createPropertyList( atts ); 
  }	 

  public  XMLComponent( Attributes atts, XMLComponent parent ) throws XMLException {
	 super();
	 createPropertyList( atts ); 
	 setParent( parent );
	 if( parent != null )  { 
		((XMLContainer)parent).addChild( this ); 
	 }
//		   System.out.println("Added child " + ID() + " to Container " + parent.ID() + ", child count: " + ((XMLContainer)parent).getChildCount() );
//		} catch ( miiee.xml.XMLException err ) {
//		   err.show( null, "Error adding Child: " );
//		   err.printStackTrace(System.out);
//		}
  }

  public  XMLComponent( String id, XMLComponent parent ) throws XMLException {
	 super();
	 createPropertyList( null ); 
	 _properties.addAttribute( "id", id ); 
	 setParent( parent );
	 if( parent != null )  { 
		((XMLContainer)parent).addChild( this ); 
	 }
//		   System.out.println("Adding child " + ID() + " to Container " + parent.ID() );
//		} catch ( miiee.xml.XMLException err ) {
//		   err.show( null, "Error adding Child: " );
//		   err.printStackTrace(System.out);
//		}
  }

  void createPropertyList( Attributes atts ) {
	if( _properties == null ) {
	 _properties = new PropertyList(this);
	 _properties.importAttributes( atts );
	}
  }
  
  public void importAttributes( Attributes atts, boolean reportDiscrepancies ) {
	if( _properties == null ) {
	 _properties = new PropertyList(this);
	}
	_properties.importAttributes( atts, reportDiscrepancies );
  }



  public boolean setParent( XMLComponent parent ) {
	if( _parent != null ) {
	  System.out.println("WARNING: Ignored attempt to change parent to " + parent + " in child " + toString() + " of parent " + _parent );
	  return false;
	}
	_parent = parent;
	return true;
  }	 


  
  public void stampComponent() {
	 try {
	   _properties.add( "owner", System.getProperty("user.name"), XMLComponent.kStatic, "string", true, false  );
	 } catch ( AccessControlException err ) {
	   _properties.add( "owner", "miiee", XMLComponent.kStatic, "string", true, false  );
	 }
	 Date d = new Date();
	 _properties.add( "date", _dateFormat.format( d ), XMLComponent.kStatic, "string", true, false  );
  }

  
  public void setTaskData( String role, XMLData data, boolean recursive ) {   //  used to set a XMLData component for a specific role; i.e. "enabler"
	if( _dataComponents  == null ) {
	  _dataComponents = new HashMap(16);
	}
	_dataComponents.put(role,data);
	if( recursive ) {
	  Iterator iter = _data.iterator();
	  while( iter.hasNext() ) {
		 XMLData obj = (XMLData) iter.next();
		 obj.setTaskData( role, data, recursive ); 
	  }
	}
  }
  
  public XMLData getTaskData( String role ) {
	if( _dataComponents  == null ) { return null; }
	return	(XMLData) _dataComponents.get(role);
  }
  

  public synchronized void addPropertyChangeListener( PropertyChangeListener listener) {
	_properties.addPropertyChangeListener(listener);
  }

  public synchronized void addPropertyChangeListener( String property, PropertyChangeListener listener) {
	_properties.addPropertyChangeListener(property,listener);
  }
  
  public void addAttributes( Attributes atts ) {
	_properties.importAttributes( atts );
  }

  public void addProperties( PropertyList props ) {
	_properties.importProperties( props );
  }
  
  public void dumpProperties() {
	 System.out.println("\nProperties for: " + ID() + ":" );
/*
	 for( int i=0; i<_properties.getLength(); i++ ) {
	   System.out.println("\n\t" + _properties.getName(i) + " : " + _properties.getValue(i) );
	 }
*/
  }

  public Object addAttribute( String attributeName, Object value ) {
     if( processAttribute( attributeName, (String) value, "string" ) ) {
	   return _properties.add( attributeName, value, XMLComponent.kMutable, "string" , true, true );
	 }
	 return null;
  }

  public Object addAttribute( String attributeName, Object value, int mutability ) {
     if( processAttribute( attributeName, (String) value, "string" ) ) {
	   return _properties.add( attributeName, value, mutability, "string" , true, true );
	 }
	 return null;
  }

  public Object addProperty( String propertyName, Object value, int mutability, String type  ) {
	return _properties.add( propertyName, value, mutability, type );
  }

  public Object addProperty( String propertyName, Object value, int mutability ) {
	return _properties.add( propertyName, value, mutability );
  }

  public Object addProperty( String propertyName, Object value ) {
	return _properties.add( propertyName, value );
  }
  
  public Object changeProperty( String propertyName, Object newValue ) throws XMLException {
	return _properties.change( propertyName, newValue );
  } 

  public Object setProperty( String propertyName, Object newValue ) throws XMLException {
	return setProperty( propertyName, newValue, XMLComponent.kMutable, null );
  }

  public Object setAttribute( String propertyName, Object newValue ) throws XMLException {
	return setAttribute( propertyName, newValue, XMLComponent.kMutable, null );
  }

  public Object setProperty( String propertyName, Object newValue, int mutability, String type ) throws XMLException {
	return _properties.set( propertyName, newValue, mutability, type );
  } 

  public Object setAttribute( String propertyName, Object newValue, int mutability, String type ) throws XMLException {
	return _properties.set( propertyName, newValue, mutability, type, true );
  } 

  public Object getProperty( String propertyName ) { return getProperty( propertyName, false ); }
  
  public Object getProperty( String propertyName, boolean searchParents ) {
	Object rv =  _properties.get( propertyName );
	if( (rv==null) && ( _parent != null )  && searchParents ) {
	  return _parent.getProperty( propertyName );
	}
	return rv;
  }
  
  public boolean hasProperty( String propertyName  ) {
	return _properties.has(propertyName);
  }
  
  public PropertyList getProperties() { return _properties; }
  
  public void editProperty(String property) {
	PropertyEditor pe = new PropertyEditor(  this, property );
	pe.display();
  }
  
  public boolean editDocumentation() {
	try {
	  String doc = (String) getProperty("doc");
	  DocEditor de = new DocEditor( toString(), doc );
	  if( de.show("Please edit documentation: ") ) {
		 setProperty( "name", de.getLabel() );
		 setProperty( "doc", de.getText() );
		 return true;
	  }
	} catch ( Exception err ) {
	  SimIO.print("editDocumentation: " + err.getMessage() );
	}
	return false;
  }
  
  public boolean processAttribute( String name, String value, String type ) {
	if( name.equals("location") ) {
	  if( ( value != null ) && value.startsWith("~/") ) {
		value = System.getProperty( "user.home" ) +  value.substring(1);
	  }
	  _location = value;
	  return false;
	}
	if( name.equals("id") ) {
	  _properties.addAttribute( "id", value ); 
	  return false;
	}
	if( name.equals("uptodate") ) {
	  _properties.addAttribute( "uptodate", Boolean.valueOf( value ) ); 
	  return false;
	}
	return true;
  }
  
  public String toString() {
	String id = (String) _properties.get( "name" );
	if( id == null ) { id = (String) _properties.get( "id" ); }
	return id;
  } 

  public String ID() {
	String id = (String) _properties.get( "id" );
	if( id == null ) { id = (String) _properties.get( "name" ); }
	return id;
  } 
    
  public boolean equals(Object obj) {
	if( obj == null ) { return false; }
	String id = ((XMLComponent)obj).ID(), id1 =  ID();
	if( (id == null) || (id1 == null) ) { return false; }
	return id1.equals( id );
  }
    
  public XMLComponent getParent() { return _parent; }
  
  public int getIndex() { return _index; }
  void setIndex( int index ) { _index = index; }
  
  void indent(BufferedWriter out) throws IOException { 
	out.newLine(); 
	for( int i=0; i<_depth; i++ ) { out.write('\t'); } 
  }
  
  public void writeXML( String xml_name, String dtd_name, int format ) { 
 	try { 
	  if( !xml_name.endsWith(".xml") ) { xml_name = xml_name + ".xml"; }
	  String xml_file = ( _namespace.length() > 0 ) ?  _namespace + "/" + xml_name : xml_name;
	  if( xml_file.startsWith("file:") ) {
		xml_file = xml_file.substring(5);
	  }
	  FileOutputStream os =  new FileOutputStream( xml_file ); 
	  if( os == null ) {
		System.out.print( "Unable to open xml file " + xml_file  );
		return;
	  } else {
		System.out.println( "Writing to xml file: " + xml_file );
	  }
	  BufferedWriter out = new BufferedWriter(new OutputStreamWriter(os));
	  out.write("<?xml version=\"1.0\"?>");
	  out.newLine(); 	out.newLine(); 
//	  String base_url = SimIO.getBaseURL();
//	  if( !base_url.startsWith("http:") ) { base_url = "http://gannet.cbl.umces.edu:8080/sme"; };
//	  String dtd_file = base_url + "/xml/dtd/" + dtd_name + ".dtd";
	  String et = getElementType(format);
	  if( et == null ) { et = getChildElementType(format); }
	  out.write("<!DOCTYPE " + et + " PUBLIC \"-//" + SimIO.getApplicationID() + "//dtd " 
					 + dtd_name + "//en \" \"http://iee.umces.edu/SME3/dtd/" + dtd_name + ".dtd\">" ); 
//	  out.write("<!DOCTYPE " + et + " SYSTEM \"~/xml/dtd/" + dtd_name + ".dtd\">" ); 
	  out.newLine(); 	out.newLine(); 
	  writeXML( out, format );   
	  out.close();
	} catch( IOException err ) {
	  XMLException.show_error( null, getElementType( format ) + " write error:  ", err );
	}
  }
  
  public String getChildElementType(int format) { return null; }
       
  public void writeXML( BufferedWriter out, int format )  throws IOException { 
	if( format == DECLARATION ) {
	  if(  getElementType(format) != null ) {
		XMLComponent parent = getParent();
		String pnamespace = ( parent == null ) ? ((String)null) : parent.getNamespace();
		String lnamespace = (pnamespace != _namespace) ? _namespace : "";
		indent(out); out.write("<"  + getElementType(format) );
		getProperties().writeXML( out, PropertyList.kAttributes );
//		out.write( " >" );	
		out.write(" location=\"" /* + lnamespace */ + _location + "\" > " ); out.newLine();
		indent(out); out.write(" </" + getElementType(format) + "> " );	out.newLine();
		
//		writeSpecificXML( out, format );
		
//		indent(out); out.write("</"  + getElementType(format) + ">" );	
	  }
	  return;
	} 
	waitUntilResolved();	
	if( getElementType(format) != null ) {
	  String elementType = getElementType( format ); 
	  indent(out); out.write("<" + elementType );
	  _properties.writeXML( out, PropertyList.kAttributes ); 
	  out.write(" >");
	  out.newLine();
	  String property = ( format == DATA ) ? "value" : null;
	  _properties.writeXML( out, PropertyList.kProperties, property );
	  Iterator iter = _data.iterator();
	  while( iter.hasNext() ) {
		 XMLData obj = (XMLData) iter.next();
		 if( obj.isVisible() || ( format != DATA ) ) {
		   obj.writeXML( out, format ); 
		 }
	  }
	}

	writeSpecificXML( out, format );	
	out.newLine();

	if( getElementType(format) != null ) {
	  indent(out); out.write("</" + getElementType(format) + "> ");
	}
  }
  
  public boolean isVisible() { return _visible; }
  public void setVisibility( boolean visible ) { _visible = visible; }
  
  public void writeSpecificXML( BufferedWriter out, int format )  throws IOException {;}
  
  public void setNamespace( String namespace ) { 
	  _namespace = namespace; 
  }  // path to source files
  public String getNamespace() { return _namespace; }
  public  void setLocation(String loc) { _location = loc; } // source file name
  public String getLocation() { return _location; }

  public int compareTo(Object o) {
	return ID().compareTo(((XMLComponent)o).ID());
  }
  
  public void resolve() { _resolved = true; }
  public void unresolve() { _resolved = false; }
  public boolean resolved() { return _resolved; }

  public void configure() { _configured = true; }
  public void unconfigure() { _configured = false; }
  public boolean configured() { return _configured; }
  
  public void waitUntilResolved() {
	if( _resolved ) return;
/*
	if( pushOnExternalsList && (getLocation() != null)  ) {
	  try {
		XMLParser.current().pushOnExternalsList( this );
	  } catch ( XMLException err ) { 
		System.out.println( "XMLComponent:: " + ID() + ": not initialized!"  );
		return; 
	  }
	}
*/
	int cnt = 0;
//	XMLException err = new XMLException( "Wait Until Resolved: " + ID() );
//	err.printStackTrace();
	SimIO.print( "Resolving " + ID() );
	while( !_resolved ) {
	  try {  
		  Thread.sleep(200L); 
		  if( cnt++ >= 500 ) break;
	  }
	  catch (InterruptedException e0) { return; }
	}
  }

  public void clearData() { _data.clear(); }
  
  public void addData( XMLData obj ) throws XMLException {
	int index = getDataIndex(obj);
	if( index >= 0 ) {
	  throw new XMLException("Data " + obj.ID() + " already exists in XMLComponent " + toString() ); 
	}
	_data.addElement( obj );
	obj._parent = this;
	obj.setDepth( _depth+1 );
  }

   public synchronized Object dumpData() {
	int cnt = 0;
	Iterator iter = _data.iterator();
	System.out.println("********* Data Dump: " + ID() );
	while( iter.hasNext() ) {
	  XMLData e = (XMLData)iter.next();
	  System.out.println("\tdata: " + e.toString() );
	}
	return null;
  }
  
  public Iterator dataIterator() { return _data.iterator(); }	
  	

  public synchronized XMLData getData( String id ) {
	if( id != null ) {
	  for( int i=0; i<_data.size(); i++ ) {
		XMLData data = (XMLData) _data.get(i);
		if( data.ID().equals(id) ) return data;
	  }
	}
	return null;
  }
  
  public synchronized XMLData getData( int index ) {
	try {
	  return (XMLData) _data.get(index);
	} catch ( ArrayIndexOutOfBoundsException err ) {;}
	return null;
  }

  public boolean removeData( String id ) {
	int index = getDataIndex( id );
	if( index < 0 ) return false;
	else  {
	  _data.removeElementAt(index); 
	}
	return true;
  }

  public boolean removeData( XMLData c ) {
	int index = getDataIndex( c );
	if( index < 0 ) return false;
	else  {
	  _data.removeElementAt(index); 
	}
	return true;
  }
 
  public synchronized XMLComponent getReference( String ref ) {
	return getData( ref );
  }
  
  public Object getDataProperty( String data_ref, String propertyName ) {
	XMLData comp = getData ( data_ref );
	if( comp == null ) return null;
	return  comp.getProperty( propertyName );
  }
  
  public int getDataCount() {
	 return _data.size();
  }
  
  public Object[] getPath() {
	Vector v = new Vector(64);
	XMLComponent obj = this;
	v.add( obj );
	while( (obj = obj.getParent()) != null ) {
	  v.insertElementAt( obj, 0 ); 
	}
	return v.toArray();
  }

  public synchronized int getDataIndex( XMLData elem ) {
	if (elem != null) {
	  for( int i=0; i<_data.size(); i++ ) {
		XMLData data = (XMLData) _data.get(i);
		if( elem == data ) return i;
	  }
	}
	return -1;
  }

  public synchronized int getDataIndex( String id ) {
	if (id != null) {
	  for( int i=0; i<_data.size(); i++ ) {
		XMLData data = (XMLData) _data.get(i);
		if( data.ID().equals(id) ) return i;
	  }
	}
	return -1;
  }
  
  public int getChildIndex( Object elem ) { return getDataIndex( (XMLData) elem ); }

  public String getElementType( int format ) { return null; }

  public Icon getIcon() {
	if( _icon == null ) {
		_icon   = SimIO.loadIcon(  "Symbol.gif" );	
	}
	return _icon;
  }
  
  public boolean isLeaf() { return false; }

  public void setDepth( int depth ) { _depth = depth; }

  public boolean isOwner() {
	if( _isOwner == null ) {
	  String owner = (String) getProperty("owner");
	  if( owner == null ) {
		 XMLException.show_error( null, " No owner defined for Component: " + ID() );
		 return true;
	  }
	  String me = null;
	  try {
		  me = System.getProperty("user.name");
	  } catch ( AccessControlException err ) {
		  me = "user";
	  }
	  _isOwner = new Boolean( owner.equals(me) );
	}
	return _isOwner.booleanValue();
  }
  
  public boolean isEnabled() throws XMLException {
 	boolean enabled = true;
	if( _enabler == null ) { _enabler = getTaskData("enabler"); }
	if( _enabler != null ) {
	  try {
		Boolean B_enab = (Boolean) _enabler.getObject();
		enabled = B_enab.booleanValue();
		if( _debug > 1 ) { System.out.println("Got enabler: " + ID() + ", value = " + enabled ); }
	  } catch ( ClassCastException err ) {
		throw new XMLException( " Enabler must wrap a boolean value: " + _enabler.ID() );
	  }
	} else {
	  if( _debug > 1 ) { System.out.println("Null enabler: " + ID() ); }
	}	
	return enabled;
 }
  
  public String generateScript( String template ) throws XMLException {  
	boolean enabled = isEnabled();
	StringBuffer script = new StringBuffer();
	StringBuffer refs = new StringBuffer();
	if( template == null ) { template = (String) ( enabled ? getProperty("enabled-template") : getProperty("disabled-template")); }
	if( template == null ) { template = (String)  getProperty("template"); }
	int i=0;  char ch;
	if( template != null ) {
	  while( true ) { 
		try {
		  ch = template.charAt(i++);
		} catch ( StringIndexOutOfBoundsException err ) { break; }
		if( ch == '%' ) {
		  try {
			ch = template.charAt(i++);
		  } catch ( StringIndexOutOfBoundsException err ) { script.append('%'); break; }
		  if( Character.isDigit(ch) ) {
			int index = ch - '0';
			try {
			  String[] args = getScriptArgs();
			  String arg = args[index];
			  script.append( arg );
			} catch ( NullPointerException err ) {
			   throw new XMLException( "Reference to argument " + index + " in script template( " + template + " ): No args defined " ); 
			} catch ( ArrayIndexOutOfBoundsException err ) {
			   throw new XMLException( "Reference to undefined argument " + index + " in script template( " + template + " ) " ); 
			}
		  } else if( (ch == '{') || (ch == '(')  ) {
			refs.setLength(0);
			while( true ) {
			  try {
				ch = template.charAt(i++);
			  } catch ( StringIndexOutOfBoundsException err ) {
				throw new XMLException( "Unterminated reference at char " + i + " in script template: " + template ); 
			  }
			  if( (ch == '}') || ( ch == ')' )  ) {
				break;
			  }
			  refs.append(ch);
			}
			String s1 = null, ref = refs.toString();
			XMLComponent c = getReference( ref );
			if( c == null )  {
			  s1 = (String) getProperty( ref, true );
			  if( (s1 != null) && s1.startsWith("~/") ) {
				s1 = System.getProperty( "user.home" ) + s1.substring(1);
			  }
			} else {
			  s1 =  c.generateScript( null );
			}
			if( s1 == null ) {
			  throw new XMLException( "Unknown reference at char " + i + " in script template( " + template + " ) : " + refs ); 
			}
			script.append( s1 );
		  }
		} else {
		  script.append(ch);
		}
	  }
	}
	return script.toString();
  }

  protected String[] getScriptArgs() { return (( _parent == null ) ? null : _parent.getScriptArgs()); }

  public static String[] shift( String args[], int shift ) {  
	int len = args.length - shift;
	if( len <= 0 ) return null;
	String[] rv = new String[len];
	for( int i=0; i< len ; i++ ) {
	  rv[i] = args[i+shift];
	}
	return rv;
  }
}

class PropertyEditor {

  JDialog _dialog;
  String _result;
  String _property;
  XMLComponent _owner;
  JTextPane _textPane = new JTextPane();
	
  public PropertyEditor(  XMLComponent owner, String property ) {
	_dialog = new JDialog( (Frame)null, "Property Editor", false );
	_owner = owner;
	_property = property;
  }

  
  String getResult() { return _result; }
  
  public void display( ) {
	_result = (String) _owner.getProperty(_property);
	Container c = _dialog.getContentPane();     

	JPanel   buttonsPanel = new JPanel(false);
	buttonsPanel.setLayout(new FlowLayout());
	JButton aButton;

	aButton = new JButton("set");
	aButton.addActionListener( new ActionListener() {
		public void actionPerformed(ActionEvent e) { 
		  _result = _textPane.getText(); 
		  try {
			_owner.setProperty( _property, _result );
		  } catch ( XMLException err ) {
			err.show( _dialog.getContentPane(), "setProperty:" );
			return;
		  }
		  _dialog.dispose();
		}
	});
	buttonsPanel.add( aButton );

	aButton = new JButton("revert");
	aButton.addActionListener( new ActionListener() {
	  public void actionPerformed(ActionEvent e) { 
		if( _result != null ) {
		  _textPane.setText(_result); 
		}
	  }
	}  );
	buttonsPanel.add( aButton );

	aButton = new JButton("clear");
	aButton.addActionListener( new ActionListener() {
	  public void actionPerformed(ActionEvent e) { 
		_textPane.setText(""); 
	  }
	}  );
	buttonsPanel.add( aButton );

	aButton = new JButton("cancel");
	aButton.addActionListener( new ActionListener() {
	  public void actionPerformed(ActionEvent e) { _dialog.dispose(); }
	}  );
	buttonsPanel.add( aButton );

	if( _result != null ) {
	  _textPane.setText(_result);
	}

	Keymap eqn_km = JTextComponent.addKeymap( "equation_km", _textPane.getKeymap() );
	_textPane.setKeymap(eqn_km);
	
//	eqn_km.addActionForKeyStroke(  INSERT_PORT_KS, 
//								   new InsertSelectedPortAction()	 );  

	JPanel labelPanel = new JPanel(false);
	buttonsPanel.setLayout(new FlowLayout());
	labelPanel.add( new JLabel(" Please specify " + _property + ":" ) );

	EmptyBorder eb5 = new EmptyBorder( 5, 5, 5, 5 );
	Border bb = BorderFactory.createCompoundBorder( eb5, BorderFactory.createLoweredBevelBorder() );
	JScrollPane scrollpane1 = new JScrollPane();
	scrollpane1.getViewport().setView(_textPane);
	scrollpane1.setMinimumSize(new Dimension(200, 200 )); 
	scrollpane1.setPreferredSize(new Dimension(500, 200 )); 
	scrollpane1.setBorder( bb );
	
	c.add( "North", labelPanel );				
	c.add( "Center", scrollpane1 );
	c.add( "South", buttonsPanel );				
	
	_dialog.pack();
	_dialog.setLocationRelativeTo(c);
	_dialog.show();	  	  
  }
}

