package miiee.xml;

import org.xml.sax.Attributes;
import java.io.*;
import java.util.*;

public class  XMLContainer extends XMLComponent {
  protected Vector _children = new Vector();
  private int _debug = 0;


  public  XMLContainer( Attributes atts )  {
	 super(atts);
  }  

  public  XMLContainer( String id )  {
	 super(id);
  }  

  public  XMLContainer( Attributes atts, XMLContainer parent ) throws XMLException {
	 super(atts, parent);
  }  

  public  XMLContainer( String id, XMLContainer parent ) throws XMLException {
	 super(id, parent);
  }
     
  public void writeSpecificXML( BufferedWriter out, int format )  throws IOException {  
	System.out.println("  *dbg:  " + ID() + " (" + this + ") Writing children: " );
	Iterator iter = childIterator();
	while( iter.hasNext() ) {
	   XMLComponent obj = (XMLComponent) iter.next();
	   obj.setNamespace(_namespace);
	   System.out.println("  *dbg:  Writing child: " + obj.ID() );
	   if( obj.isVisible() || ( format != DATA ) ) {
		 obj.writeXML( out, format ); 
	   }
	}
  }

  public HashMap getChildren()  {  
	Iterator iter = childIterator();
	HashMap m = new HashMap();
	while( iter.hasNext() ) {
	   XMLComponent obj = (XMLComponent) iter.next();
	   m.put(obj.ID(),obj);
	}
	return m;
  }
  
  public void setChildren( HashMap m ) throws XMLException {
	removeChildren();
	Iterator values = m.values().iterator();
	while( values.hasNext() ) {
	   XMLComponent obj = (XMLComponent) values.next();
	   addChild( obj );
	}
  }

  public void addChild( XMLComponent obj ) throws XMLException { addChild( obj, false ); }
  
  public void addChild( XMLComponent obj, boolean allow_overwrite ) throws XMLException {
	String key = obj.ID();
	if( key == null ) {
	  throw new XMLException( toString() + ".addChild: Null ID in child Component " + obj.toString() ); 
	}
	XMLComponent current = null;
	if( !allow_overwrite ) {
	  current =  getChild(key);
	  if( current != null ) { 
		throw new XMLException("Child with ID " + key + " already exists in XMLComponent " + toString() ); 
	  }
	}
	_children.add(current =  obj);
	if( _debug > 1 ) {
	  System.out.println( "Adding child to " + ID() + ", ID = " + key + " size = " + _children.size() );
	}
	if( obj._parent == null ) { 
	  obj._parent = this; 
	  if( getElementType( 0 ) == null ) { obj.setDepth( _depth ); }
	  else { obj.setDepth( _depth+1 ); }
	}
  }
  
  public void removeChildren() {
	_children.clear();
  }

  public boolean removeChild( String id ) {
	XMLComponent c = getChild(id);	
	return (c==null) ? false : _children.remove(id);
  }

  public boolean removeChild( XMLComponent c ) {
	return _children.remove( c );
  }
  
  public Iterator childIterator() { return _children.iterator(); }	

  public XMLData getData( String key ) {
	 XMLData rv = super.getData( key );
	 if( rv == null ) {
		Iterator iter = childIterator();
		while( iter.hasNext() ) {
		  XMLComponent xc = (XMLComponent) iter.next();
		  rv = xc.getData( key );
		  if( rv != null ) break;
		}
	 }
	 return rv;
  }

  public Object getDataProperty( String data_ref, String propertyName ) {
	Object rv = super.getDataProperty( data_ref, propertyName ) ;
	if( rv != null ) return rv;
	Iterator iter = childIterator();
	while( iter.hasNext() ) {
	  XMLComponent xc = (XMLComponent) iter.next();
	  rv = xc.getDataProperty( data_ref, propertyName ) ;
	  if( rv != null ) return rv;
	}
	return null;
  }
   	
  public XMLComponent getChild( String key ) {
	if( key == null ) return null;
	Iterator iter = childIterator();
	while( iter.hasNext() ) {
	  XMLComponent xc = (XMLComponent)iter.next();
	  if( xc.ID().equals(key) ) return xc;
	}	
	return null;
  }
  
  public String getChildElementType( int format ) { 
	XMLComponent xc = (XMLComponent) getChild( 0 );
	if( xc == null ) return null;
	return xc.getElementType(format);
  }

  
  public synchronized Object getChild( int index ) {
	int cnt = 0;
	Iterator iter = childIterator();
	while( iter.hasNext() ) {
	  XMLComponent xc = (XMLComponent) iter.next();
	  if( cnt++ == index ) {
		return xc;
	  }
	}
	return null;
  }
  
  public synchronized XMLComponent getReference( String ref ) {
	XMLComponent rv = getChild( ref );
	if( rv == null ) rv = super.getReference( ref );
	return rv;
  }
 
   public synchronized Object dumpChildren() {
	int cnt = 0;
	Iterator iter = childIterator();
	System.out.println("********* Child Dump: " + ID() );
	while( iter.hasNext() ) {
	  XMLComponent xc = (XMLComponent) iter.next();
	  System.out.println("\tchild: " + xc.ID()  );
	}
	return null;
  }
  
  public int getChildCount() {
	 return _children.size();
  }

  public synchronized int getChildIndex( Object elem ) {
	if (elem != null) {
	  int cnt = 0;
	  String id0 = ((XMLComponent)elem).ID();
	  Iterator iter = childIterator();
	  while( iter.hasNext() ) {
		XMLComponent xc = (XMLComponent) iter.next();
		String id = xc.ID();
		if (id.equals(id0) ) {
		  return cnt;
		}
		cnt++;
	  }
	}
	return -1;
  }

  public void setTaskData( String role, XMLData data, boolean recursive ) {
	super.setTaskData( role, data, recursive ); 
	if( recursive ) {
	  Iterator iter = childIterator();
	  while( iter.hasNext() ) {
		 XMLComponent obj = (XMLComponent) iter.next();
		 obj.setTaskData( role, data, recursive ); 
	  }
	}
  }
  
  public String getElementType( int format ) { return null; }
  
}
