package miiee.xml;
import java.io.BufferedWriter;
import java.io.IOException;
import org.xml.sax.Attributes;


//---- XMLData ---------------------------------------------------------

public class XMLData extends XMLComponent {

  protected Object _value;
    
  public XMLData( Attributes atts,  XMLComponent parent )  { 
	super( atts );
	setParent( parent );
	try {
	  if( parent != null )  { parent.addData( this ); }
	} catch ( XMLException err ) {
	  System.out.println( err.getMessage() );
	}
  }

  public XMLData( Attributes atts )  { 
	super( atts );
  }
  
  public XMLData( String name )  { 
	super( name );
  }

  public XMLData( String name,  XMLComponent parent )  { 
	super( name );
	setParent( parent );
	try {
	  if( parent != null )  { parent.addData( this ); }
	} catch ( XMLException err ) {
	  System.out.println( err.getMessage() );
	}
  }
  
  public XMLData( Object data )  { 
	super( data.toString() );
  }

  public String getElementType( int format ) { return "data"; }

  public String generateScript( String template ) throws XMLException {
	if( template == null ) {  template = (String) getProperty("template"); }
	if( template != null ) { return super.generateScript( template ); }
	String val = (String) getProperty("value");
	return (val==null) ? "" : val;
  }

  public void setObject( Object v ) { _value = v; }
  public Object getObject() { return _value; }
    
}
