package miiee.xml;

import org.xml.sax.*;
import javax.swing.*;
import miiee.util.*;

public class XMLHandler extends Object implements ContentHandler, ErrorHandler, DTDHandler {
	 
  protected XMLParser _parser;
  protected Locator _locator;
  protected StringBuffer _buffer = new StringBuffer();
  protected XMLComponent _parse_root;
  protected XMLContainer _tree_root;
  protected XMLComponent _current_Component;
  protected XMLComponent _current_Parent;
  protected boolean _isProperty = false;
  protected boolean _firstComponent;
  protected boolean _docEnded = false;
  protected boolean _hasPCData = true;
  protected boolean _create = true;
  protected boolean _clearParseRoot = true;
  protected String    _propertyType;
  protected String _propertyName;
  protected int _mutability = XMLComponent.kStatic;
  private boolean _debug = false;
  protected String  _rootSourceID;
  protected String  _rootURL;

  public XMLHandler( ) {  this(null);  }

  public XMLHandler( XMLComponent top_component ) { 
	super(); 
	try {
	  createTreeRoot( top_component ); 
	} catch ( XMLException err ) {
	  err.show( null, "Error adding Child to root: " );
	}
  }
 
  public XMLComponent getComponentFromName( String name, Attributes atts, XMLComponent parent, boolean create ) throws XMLException {
	return null;
  }
  
  public void setSourceRoot( String path ) { 
	int last_slash = path.lastIndexOf('/') + 1;
	_rootSourceID = path.substring(0,last_slash);
  }

  public void setURLRoot( String path ) { 
	int last_slash = path.lastIndexOf('/') + 1;
	_rootURL = path.substring(0,last_slash);
  }
  
  public void blockUntilReadCompleted() { _parser.waitUntilParseCompleted(); }	
  
  public String getSourceRoot() { return _rootSourceID; }
  public String getURLRoot() { return _rootURL; }

  protected void createTreeRoot( XMLComponent top_component ) throws XMLException { 
	_tree_root = new XMLContainer("root"); 
	if( top_component != null ) {
	  _tree_root.addChild(top_component);
	}
  }
  
  public void setParser( XMLParser parser ) { _parser = parser;  }
  
  public void setParseRoot( XMLComponent c ) { 
	_parse_root = c;
	_clearParseRoot = false;
  }
  
  public void setDocumentLocator(Locator locator) { _locator = locator; }

  public void startDocument() throws SAXException { 
	_current_Component = _tree_root; 
	_current_Parent = null; 
	_firstComponent = true;
	if( _clearParseRoot ) { _parse_root = null; }
	_clearParseRoot = true;
	if( _debug ) { System.out.println( " startDocument, parse root: " + _parse_root ); }
  }

  public void endDocument() throws SAXException { 
	if( _parse_root != null ) {
	  _parse_root.resolve();
	  XMLTreeModel tm = getTreeModel();
	  if( tm != null ) {
		  try {
			  XMLContainer p = (XMLContainer)_parse_root;
			  XMLComponent c = null; int cindex = 0;
			  while( (c = (XMLComponent) p.getChild( cindex++ )) != null ) {
				  tm.fireStructureChanged( p, c, cindex, XMLTreeModel.NODE_ADDED );
			  }
		   } catch ( ClassCastException err ) {;}
	  }
	}
	if( _debug ) { System.out.println( " endDocument "  ); }
	_docEnded = true;
 }

 public boolean docEnded() { return  _docEnded; } 
 
 public void skippedEntity(java.lang.String name ) {;}
 
 public void startPrefixMapping( java.lang.String prefix, java.lang.String uri ) {;}
 public void endPrefixMapping(java.lang.String prefix ) {;}
  
  public void startElement( String namespaceURI, String local_name, String name,  Attributes atts)  throws SAXException {
	_buffer.setLength(0);
	if( _debug ) { System.out.println( " startElement: " + name + ", current_Parent: " +  _current_Parent + " current_Component: " +  _current_Component ); }
	if( _isProperty ) {	
	  throw new SAXException( "Properties can't contain elements: declaring element " + name + " in property " + _propertyName );
	}
	if( _firstComponent && ( _parse_root != null ) ) {
	  _current_Parent = _parse_root.getParent();
	  _current_Component = _parse_root;
	  _current_Component.addAttributes( atts );
	} else {
	  try { 
		XMLComponent comp  = getComponentFromName( name, atts, _current_Component, _create );
		if( comp != null ) {
		  if( _firstComponent ) {
			if( _parse_root == null )  _parse_root = comp;
		  }
		  _current_Parent = _current_Component;
		  _current_Component = comp;
		  if( comp.getLocation() != null ) {
			_parser.addExternalComponent( comp ); 
		  }
		} else {
		  _isProperty = true; 
		  _propertyName = name;
		  _propertyType = PropertyList.getStringAttribute( "type", atts );
		  Integer m = PropertyList.getNumberAttribute( "mutability", atts );
		  _mutability = ( m==null ) ? XMLComponent.kMutable : m.intValue(); 
		}
	  } catch ( XMLException err ) {
		XMLException.show_error( null, " Parsing element " + name + ": ", err );
	  }
	}
	_firstComponent = false;
  }

  public void endElement( String namespaceURI, String local_name, String name )  throws SAXException {
	if( _current_Component == null ) {	
	  throw new SAXException( "Unrecognized Component: " + name );
	}
	if( _debug ) { System.out.println( " endElement: " + name ); }
	if( _isProperty ) {	
	  _isProperty = false; 
	  try {
		String val =  _buffer.toString().trim();
		_current_Component.setProperty( name, val, _mutability, _propertyType );
		if( _debug ) { 
		  System.out.println( _current_Component.ID() + ": Set Property: " + name + " = " + val + " type: " +  _propertyType + " mut: " +  _mutability); 
		}
	  } catch ( XMLException err ) {
		  System.out.println( err.getMessage() );
	  }
	} else { 
	  if( _current_Component.getLocation() == null  ) {
		_current_Component.resolve();
		_current_Component.configure();
		if( _debug ) { System.out.println( " Resolve Element: " + _current_Component.ID() ); }
	  }
	  if( _hasPCData && (_buffer.length() > 0)  ) {
		try {
		  String val_str = _buffer.toString().trim();
		  _current_Component.setProperty( "value", val_str );
		  if( _debug ) { System.out.println( "Adding value property to " + _current_Component.ID() + ": " + val_str ); }
		} catch( XMLException err ) {
		  System.out.println( err.getMessage() );
		}
	  }
	  XMLTreeModel tm = getTreeModel();
	  if( tm != null ) {
		XMLComponent p = (XMLComponent)_current_Component.getParent();
		if( (p != null ) && ( p != _parse_root ) ) {
		  tm.fireStructureChanged( p, _current_Component, p.getChildIndex( _current_Component ), XMLTreeModel.NODE_ADDED );
		}
	  }
	  _current_Component =  _current_Parent;
	  if( _current_Parent != null ) {
		_current_Parent =  _current_Parent.getParent();
	  }
	}
	_buffer.setLength(0);
  }

  public XMLTreeModel getTreeModel() { return null; }

  public XMLContainer readTreeStructure( String  mml_file ) {		  
	System.out.println(" Generating object tree from module markup file: " + mml_file );
	XMLParser p = null;
	try {
	  p = XMLParser.getParser( null, this );
	} catch ( XMLException err ) {
	  System.out.println( err.getMessage() );
	  return null;
	}
	p.parse( mml_file );
	return (XMLContainer) p.getRootComponent();
  }

  public XMLComponent read( String setup_file, String data_file, String parser_class, int format, XMLComponent parse_root ) { 
	return read( setup_file, data_file, parser_class, format, parse_root, null );
  }

  public XMLComponent read( String parser_class, String xml_data, XMLComponent parse_root ) { 
	  XMLParser parser = null;
	  try {
		parser = XMLParser.getParser( parser_class,  this );
	  } catch ( XMLException err ) { 
		System.out.println( err.getMessage() ); 	  
	  } 
/*	  
	  catch (ClassNotFoundException cnf_err ) {
		SimIO.show_error(null,"Must install Java XML standard extension from Sun: ",cnf_err);
	  }
*/	 		
	  if( parser != null ) {
		try { 
		  parser.parseString( xml_data, parse_root );
		} catch( Exception err ) {
		  System.out.println( err.getMessage() ); 
		  err.printStackTrace();	  
		}	
		return getParseRoot();
	  }
	  
	  return null;
  }
  
  public XMLComponent read( String setup_file, String data_file, String parser_class, int format, XMLComponent parse_root, String resource ) { 
	  XMLParser parser = null;
	  try {
		parser = XMLParser.getParser( parser_class,  this );
	  } catch ( XMLException err ) { 
		System.out.println( err.getMessage() ); 	  
	  } 
/*	  
	  catch (ClassNotFoundException cnf_err ) {
		SimIO.show_error(null,"Must install Java XML standard extension from Sun: ",cnf_err);
	  }
*/	 		
	  if( parser != null ) {
		try { 
		  if( (setup_file != null) && !setup_file.equals(data_file) ) {
			System.out.println("Reading defaults file: " + setup_file );
			parser.parse( setup_file, parse_root, resource );
		  }
		  if( data_file != null ) {
			System.out.println("Reading user data file: " + data_file );
			parser.parse( data_file, parse_root, resource );
		  }
		} catch( Exception err ) {
		  System.out.println( err.getMessage() ); 
		  err.printStackTrace();	  
		}	
		return getParseRoot();
	  }
	  
	  return null;
  }

  public void characters(char[] ch, int start, int length)  throws SAXException {
	_buffer.append(ch, start, length);
  }

  public void ignorableWhitespace(char[] ch,    int start, int length)  throws SAXException { ; }
  
  public void processingInstruction(java.lang.String target,   java.lang.String data)   throws SAXException {
	System.out.println("processing Instruction: " + target + " -> " + data );
  }
  
  public XMLContainer getTreeRoot() { 
	if( _tree_root == null ) { 
	  try {
		createTreeRoot( null );
	  } catch ( XMLException err ) {
		err.show( null, "Error adding Child to root: " );
	  }
	}
	return _tree_root; 
  }
  
  protected void clear() { _tree_root = null; _parse_root = null; }
  
  public XMLComponent getParseRoot() { return _parse_root; }

//  org.xml.sax.ErrorHandler interface  ************************************************

//     Receive notification of a warning. 
//     SAX parsers will use this method to report conditions that are not errors or fatal errors as defined by
//     the XML 1.0 recommendation. The default behaviour is to take no action.
//     The SAX parser must continue to provide normal parsing events after invoking this method: it
//     should still be possible for the application to process the document through to the end.
    
  public void warning(SAXParseException exception)  throws SAXException {
	int line = exception.getLineNumber();
	int col =  exception.getColumnNumber();
	System.out.println("Parse warning, line " + line + ", col " + col + ": " + exception.getMessage() ); 
  }

//     Receive notification of a recoverable error. 
//     This corresponds to the definition of "error" in section 1.2 of the W3C XML 1.0 Recommendation.
//     For example, a validating parser would use this callback to report the violation of a validity
//     constraint. The default behaviour is to take no action.
//     The SAX parser must continue to provide normal parsing events after invoking this method: it
//     should still be possible for the application to process the document through to the end. If the
//     application cannot do so, then the parser should report a fatal error even if the XML 1.0
//     recommendation does not require it to do so.

  public void error(SAXParseException exception)  throws SAXException {
	int line = exception.getLineNumber();
	int col =  exception.getColumnNumber();
	System.out.println("Parse error, line " + line + ", col " + col + ": " + exception.getMessage() ); 
  }

//     Receive notification of a non-recoverable error. 
//     This corresponds to the definition of "fatal error" in section 1.2 of the W3C XML 1.0
//     Recommendation. For example, a parser would use this callback to report the violation of a
//     well-formedness constraint.
//     The application must assume that the document is unusable after the parser has invoked this
//     method, and should continue (if at all) only for the sake of collecting addition error messages: in fact,
//     SAX parsers are free to stop reporting any other events once this method has been invoked.

  public void fatalError(SAXParseException exception) throws SAXException {
	int line = exception.getLineNumber();
	int col =  exception.getColumnNumber();
	String pid = exception.getPublicId();
	String sid = exception.getSystemId();
	System.out.println("Parse fatal error, line " + line + ", col " + col + ", parsing " + pid + "(" + sid + "): " + exception.getMessage() ); 
  }


//  org.xml.sax.DTDHandler interface  ******************************************

//     Receive notification of a notation declaration event. 
//     It is up to the application to record the notation for later reference, if necessary.
//     If a system identifier is present, and it is a URL, the SAX parser must resolve it fully before passing it
//     to the application.

//     Parameters:
//          name - The notation name.
//          publicId - The notation's public identifier, or null if none was given.
//          systemId - The notation's system identifier, or null if none was given.

  public void notationDecl(java.lang.String name, java.lang.String publicId, java.lang.String systemId) 
				throws SAXException {	
	  System.out.println("DTD notationDecl: " + " name= " + name  + " publicId= "+ publicId  + " systemId= "+  systemId ); 
  }

//     Receive notification of an unparsed entity declaration event. 
//    Note that the notation name corresponds to a notation reported by the notationDecl() event. It is up to
//     the application to record the entity for later reference, if necessary.
//     If the system identifier is a URL, the parser must resolve it fully before passing it to the application.
//
//     Parameters:
//          name - The unparsed entity's name.
//          publicId - The entity's public identifier, or null if none was given.
//          systemId - The entity's system identifier (it must always have one).
//          notation - name The name of the associated notation.

  public void unparsedEntityDecl(java.lang.String name,  java.lang.String publicId,  java.lang.String systemId, java.lang.String notationName)
				throws SAXException {	
	  System.out.println("DTD unparsedEntityDecl: " + " name= " + name  + " publicId= "+ publicId  + " systemId= " +  systemId + " notationName= " + notationName ); 
  }

  public static Icon getIcon( String name ) {
	return SimIO.loadIcon( name );
  }

  public void showBrowser( String  xml_file ) { System.out.println("No Browser defined for this handler: "  + this ); }
  public void showBrowser( String  xml_file, String resource ) { System.out.println("No Browser defined for this handler: "  + this ); }
  
}
