package miiee.xml;

import org.xml.sax.*;
import java.io.*;
import java.security.*;
import java.util.Stack;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.event.*;
import javax.swing.*;
import javax.xml.parsers.*;
import javax.swing.tree.*;
import java.net.*;
import miiee.util.*;
import javax.xml.parsers.*;
import org.apache.crimson.parser.Resolver;

public class XMLParser extends Object implements Runnable  {

	XMLReader _parser;
//	Parser _parser;
	XMLHandler _xmlHandler;
	Stack _externals = new Stack();
	Thread _resolverThread;
	XMLComponent _archivedFiles;
	boolean _resolve_externals;
	boolean _validating = false;
	boolean _debug = false;
	static XMLParser _current;
	String _resource_root = "workspace/";

	private XMLParser(  String parser_class, XMLHandler handler ) throws XMLException {
	  getParserProperties();
	  try {
            javax.xml.parsers.SAXParserFactory spf = javax.xml.parsers.SAXParserFactory.newInstance();
//            org.apache.crimson.jaxp.SAXParserFactoryImpl spf = new org.apache.crimson.jaxp.SAXParserFactoryImpl();
            if( _debug ) {
			  System.out.println("Using SAXParserFactory: " + spf );
              System.out.println("Setting XML validation: " + _validating );
			}
			spf.setValidating(_validating);

			javax.xml.parsers.SAXParser sp = spf.newSAXParser();
			if( _debug ) { System.out.println("Got Sax parser: " + sp ); }
            _parser = sp.getXMLReader();

	  } catch( javax.xml.parsers.ParserConfigurationException err2 ) {
		  throw new XMLException( err2.getMessage() );
	  } catch( javax.xml.parsers.FactoryConfigurationError err3 ) {
		Exception e = err3.getException();
		System.out.println("FactoryConfigurationError: " + e.toString() + ": " + e.getMessage() );
		e.printStackTrace();
		throw new XMLException( err3.getMessage() );
	  } catch ( org.xml.sax.SAXException err1 ) {
		  throw new XMLException( err1.getMessage() );
	  }
	  _xmlHandler = handler;
	  if( _parser != null ) {
		_parser.setContentHandler( _xmlHandler );
		_parser.setErrorHandler( _xmlHandler );
		_parser.setDTDHandler( _xmlHandler );
		_parser.setEntityResolver( new LocalResolver() );
		start();
	  }
	}
/*
    SAXParserFactory newInstance() {
        String factoryImplName =
            System.getProperty("javax.xml.parsers.SAXParserFactory",
                               "com.sun.xml.parser.SAXParserFactoryImpl");
        SAXParserFactory factoryImpl;
        try {
            Class clazz = Class.forName(factoryImplName);
            factoryImpl = (SAXParserFactory)clazz.newInstance();
        } catch  (ClassNotFoundException cnfe) {
	    throw new FactoryConfigurationError(cnfe);
	} catch (IllegalAccessException iae) {
	    throw new FactoryConfigurationError(iae);
	} catch (InstantiationException ie) {
	    throw new FactoryConfigurationError(ie);
	}
        return factoryImpl;
    }
*/
	void getParserProperties() {
	  String validation = "";
	  try {
		validation = System.getProperty ( "javax.xml.parsers.validation", "false" );
	  } catch( java.security.AccessControlException err ) {;}
	  if( validation.equalsIgnoreCase("true") ) { _validating = true; }
	}

	public static XMLParser getParser( String parser_class, XMLHandler handler ) throws XMLException {
	  _current = new XMLParser( parser_class, handler );
	  handler.setParser( _current );
	  return _current;
	}

	public XMLHandler getHandler() { return _xmlHandler; }


	public static XMLParser current( )  throws XMLException {
	  if( _current == null ) {
		throw new XMLException( "XMLParser:: Parser not initialized. " );
	  }
	  return _current;
	}

	public void addExternalComponent( XMLComponent c ) {
	  _externals.push(c);
	  if( _debug ) {
		System.out.println("Pushing External Component: " + c.ID() + ", location: " + c.getLocation() 
							+ ", resolved: " + c.resolved() + ", configured: " + c.configured()); 
	  }
	}

	 public synchronized void parse ( String source ) {
	   parse(source,null);
	 }

	 public synchronized void parseArchive ( XMLComponent archivedFiles ) {
	 	 _archivedFiles = archivedFiles;
	 	 String rootFile = (String) archivedFiles.getProperty("root");
	 	 if( rootFile != null ) {
		   StringReader sr = new StringReader(rootFile);
		   parse (sr);
		 }
	 }

	 public synchronized void parseString ( String data, XMLComponent root ) {
	   StringReader reader = new StringReader(data);
		_xmlHandler.setParseRoot(root);
		parse( reader );
	 }

	 public synchronized void parseString ( String data ) {
		StringReader reader = new StringReader(data);
		parse( reader );
	 }

	 public synchronized void parse ( Reader reader, XMLComponent root ) {
		_xmlHandler.setParseRoot(root);
		parse( reader );
	 }

	 public synchronized void parse ( Reader reader ) {
		try {
			_parser.parse ( new InputSource(reader) );

		} catch (SAXParseException err) {
			System.out.println ("** Parsing error"
			+ ", line " + err.getLineNumber ()
			+ ", uri " + err.getSystemId ());
			System.out.println("   " + err.getMessage ());
			Exception embed_ex = err.getException();
			if( embed_ex != null ) {
			  embed_ex.printStackTrace ();
			}

		} catch (SAXException e) {
			Exception	x = e;
			if (e.getException () != null)
			x = e.getException ();
			x.printStackTrace ();

		} catch (Throwable t) {
			t.printStackTrace ();
		}
	 }

	 String resolvePath( String source ) {
		if( _debug ) { System.out.println(" Resolving path: " + source ); }
  		if( source.startsWith("~/") ) {
			source = "file:" + System.getProperty( "user.home" ) +  source.substring(1);
		} else if ( source.startsWith("/") ) {
		  source = "file:" + source;
		}

		if ( source.startsWith("http:") || source.startsWith("file:") ) {
		  if( _xmlHandler.getSourceRoot() == null ) {
			_xmlHandler.setSourceRoot(source);
		  }
		} else {
			if( _xmlHandler.getSourceRoot() == null ) {
			  if( SimIO.getApplet() != null ) {
				URL url = SimIO.getApplet().getCodeBase();
				_xmlHandler.setSourceRoot(url.toString());
			  } else {
				_xmlHandler.setSourceRoot(System.getProperty( "user.dir" ));
			  }
			}
			source = _xmlHandler.getSourceRoot() + source;
		}
		source = LocalResolver.normalizePath(source);
		return source;
	 }
	 
    public synchronized void parse ( String source, XMLComponent root ) {
	  parse ( source, root, null );
    }
    
    String getResourceRoot( String resource ) {
	  int li = resource.lastIndexOf('/');
	  return (li < 0) ? resource : resource.substring(0,li+1);
    }

    public synchronized boolean parse ( String source, XMLComponent root, String resource ) {
	  if( _parser == null ) return false;
	  if( root != null ) {
		if( root.resolved() && root.configured() ) {
		  System.out.println(" Root already resolved & configured: " + root );
		  return true;
		}
	  }
	  _xmlHandler.setParseRoot(root);
	    
	  try {
		 LocalResolver lr = new LocalResolver();
		 InputStream ris = null;
		 if( resource != null ) {
		   ris = lr.loadResourceAsStream(resource);
		   System.out.println(" Loading resource: " + resource + " istream: " + ris );
		 }
		 if( ris != null ) {
			InputSource is = lr.createInputSource("text/xml",ris,true,"file");
			_resource_root = getResourceRoot(resource);
			_parser.parse ( is );
			return true;
		 } else if( source != null ) {
			source = resolvePath( source );
			if( _debug ) { System.out.println(" Parsing xml file: " + source ); }
		    _parser.parse ( source );
		    return true;
		  }

	    } catch (SAXParseException err) {
		    System.out.println ("** Parsing error"
		    + ", line " + err.getLineNumber ()
		    + ", uri " + err.getSystemId ());
		    System.out.println("   " + err.getMessage ());
		    Exception embed_ex = err.getException();
		    if( embed_ex != null ) {
		      embed_ex.printStackTrace ();
		    }
	    } catch (SAXException e) {
		    Exception	x = e;
		    if (e.getException () != null)
		    x = e.getException ();
		    x.printStackTrace ();

	    } catch (Throwable t) {
		    t.printStackTrace ();
	    }
	    if( root != null ) {
	      root.resolve();
	    }
	    return false;
	}

	public XMLComponent getRootComponent() { return _xmlHandler.getTreeRoot(); }

	public boolean writeXML( XMLComponent root, String mml_dir ) throws IOException {
	  if( _parser == null ) return false;
	  if( root == null ) { root = _xmlHandler.getTreeRoot(); }
	  if( root == null ) { return false; }
	  root.setNamespace(mml_dir);
	  root.writeXML(null,0);
	  return true;
	}

	public void run() {
	  long sleep_millis = 500L;
	  while( _resolve_externals ) {
		try {  Thread.sleep(sleep_millis); }
		catch (InterruptedException e0) {;}
		try {
		  if( !_externals.empty() ) {
			System.out.print(".");
			XMLComponent ext_comp = (XMLComponent) _externals.pop();
			if( _debug ) { System.out.println(" Processing External Component: " + ext_comp.ID() + 
							", resolved: " + ext_comp.resolved() + ", configured: " + ext_comp.configured()); }
			if( !ext_comp.resolved() || !ext_comp.configured() ) {
			  String location = (String) ext_comp.getLocation();
			  if( location != null ) {
				String resource = _resource_root + location;
				if( _archivedFiles == null ) {
				  String fname = location.endsWith( ".xml" ) ?  location :
						  location + "/" + ext_comp.ID() + "." + ext_comp.getElementType( 0 ) + ".xml";
				  parse( fname, ext_comp, resource );
				} else {
				  String data = (String) _archivedFiles.getProperty(location);
				  if( data != null ) {
					StringReader sr = new StringReader(data);
					parse( sr, ext_comp );
				  }
				}
			  } else {
				System.out.println(" Can't parse xml file (no location): " + ext_comp.ID() );
			  }
			}
			sleep_millis = 200L;
		  } else {
			sleep_millis = 600L;
		  }
		} catch ( java.util.EmptyStackException err ) { ;
		} catch ( NullPointerException err ) { ;
		}
	  }
	}

	public boolean parseCompleted() {
	  return ( _xmlHandler.docEnded() && _externals.empty() );
	}

  public void waitUntilParseCompleted() {
	while( !parseCompleted() ) {
	  try {  Thread.sleep(300L); }
	  catch (InterruptedException e0) { return; }
	}
  }

    public synchronized void start()  {
	  if( _resolverThread == null ) {
		_resolve_externals = true;
		_resolverThread= new Thread(((Runnable)this));
		_resolverThread.setPriority( 4 );
		_resolverThread.start();
	  }
    }

	public void stop() {
	  if( _resolverThread != null ) {
		_resolve_externals = false;
		_resolverThread = null;
	  }
	}

	public synchronized void pushOnExternalsList( XMLComponent obj ) {
	  _externals.push( obj );
	}

}
