package miiee.xml;

import java.util.Vector;
import java.awt.Toolkit;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.util.ListIterator;
import java.awt.*;
import java.awt.event.*;
import org.xml.sax.*;
import java.util.Iterator;
import java.util.Map;
import java.util.HashMap;
import miiee.client.ConfigCommand;
import miiee.util.SimIO;

//---- XMLTree ---------------------------------------------------------

public class XMLTree extends JTree {

	public static final int kNoDataTree = 0;
	public static final int kHasDataTree = 1;
	public static final int kIsDataTree = 2;
	
    protected  Toolkit _toolkit = Toolkit.getDefaultToolkit();
    XMLTreeModel _treeModel;
    XMLTreeModel _dataTreeModel;
    XMLData _dataRoot = new XMLData("Data Structures");
    XMLTree _dataTree;
    PropertyTable _table;
    HashMap _argumentList = new HashMap();
    int _mode = kNoDataTree;
    private int _selected_row = -1;
	private int _selected_element = -1;
	protected DefaultTreeCellRenderer _cellRenderer;
	private XMLComponent _selected_component;
	private boolean _debug = false;
    
    public XMLTree( XMLComponent top ) { 
	  super( new XMLTreeModel(top) ); 
	  _treeModel = (XMLTreeModel) getModel();
	  setCellRenderer( new XMLTreeCellRenderer() ); 
	  _table = PropertyTable.getTablePanel( 80, 500 ); 
	}

    public XMLTree( XMLComponent top, int mode ) { 
	  this(top,mode,null); 
	  _table = PropertyTable.getTablePanel( 80, 500 ); 
	}

    public XMLTree( XMLComponent top, int mode, PropertyTable table ) { 
	  super( (mode==kIsDataTree) ? new XMLTreeModel( top, XMLTreeModel.kDataTree ) : new XMLTreeModel(top) ); 
	  _mode = mode;
	  _table = table;
	  _treeModel = (XMLTreeModel) getModel();
	  if( mode == kHasDataTree ) {
		_table = PropertyTable.getTablePanel( 80, 500 );
		_dataTree = new XMLTree( _dataRoot, kIsDataTree, _table );
		_dataTreeModel = (XMLTreeModel) _dataTree.getModel();
		_cellRenderer = new ListTreeCellRenderer(50);		
		addMouseListener( new MouseAdapter() {
		  public void mousePressed(MouseEvent e) {
			try {
			  int click_X = e.getX();
			  _selected_row = getRowForLocation(e.getX(), e.getY());
			  TreePath tp = getPathForRow( _selected_row );
			  Rectangle r = getPathBounds(tp);
			  _selected_element = ((ListTreeCellRenderer)_cellRenderer).setClickOffset( click_X - r.x );
			  XMLComponent node = (XMLComponent) tp.getLastPathComponent();
			  if( _selected_element > 0 ) {
				_selected_component = (XMLData) node.getData(_selected_element-1); 
			  } else {
				_selected_component = node;
			  }
			  refreshPath( tp );  
			} catch ( NullPointerException err ) { return; }
		  }
		});
	  } else {
		 _cellRenderer = new XMLTreeCellRenderer();
	  }
	  if( _table == null ) { 
		_table = PropertyTable.getTablePanel( 80, 500 ); 
	  }
	  setCellRenderer( _cellRenderer ); 
	}

	public XMLComponent getSelectedComponent() {
	  return ( _mode == kHasDataTree ) ? _selected_component : getSelectedNode();
	}
	
	public static DefaultTreeCellRenderer getListTreeCellRenderer( int maxElements ) {
		return new ListTreeCellRenderer(maxElements);
	}
    
    public XMLComponent getRoot() { return (XMLComponent)(_treeModel.getRoot()); } 
    
	public void setRoot(XMLComponent root) { _treeModel.setRoot(root); }
	
	public void reload(XMLComponent node) { 
	  _treeModel.reload(node); 
	  refreshSelection(node);
	}

	public void reload() { 
	  _treeModel.reload(); 
	}
   
    public int getMode() { return _mode; }
    public XMLTree getDataTree() { return _dataTree; }

   
	public void clear() {
	  if( _mode == kIsDataTree ) {
		 getRoot().clearData();
	  } else {
		  XMLContainer root = ((XMLContainer)getRoot());
		  XMLComponent child = (XMLComponent) root.getChild(0);
		  if( child != null ) {
			root.removeChildren();
			((XMLTreeModel)getModel()).fireStructureChanged( root, child, 0, XMLTreeModel.NODE_DELETED );
		  }
	  }
    }
    
    public void trackPropertyChanges( XMLComponent target ) {
	  target.addPropertyChangeListener( _table );
	}
    
	public void expandPath( XMLComponent c ) {
	  super.expandPath( getPath( c ) );
	}

	public void refreshSelection( XMLComponent c  ) {
	  refreshPath( getPath(c) ) ;
	} 
		
	public void refreshPath( TreePath tp ) {
	  if( tp == null ) return;
	  TreeSelectionModel selListener = getSelectionModel();
	  selListener.removeSelectionPath(tp) ;	
	  selListener.addSelectionPath(tp) ;	
	}

	
	public void expandAll() { expandRecursive( getRoot() ); }

	public void expandRecursive( XMLComponent c ) {
	  super.expandPath( getPath( c ) );
	  try {
		if( _mode == kIsDataTree ) {
		  int ndata = c.getDataCount();
		  for( int i=0; i<ndata; i++ ) {
			expandRecursive( (XMLComponent) c.getData(i) );
		  }
		} else {
		  XMLContainer cc = (XMLContainer)c;
		  int ndata = cc.getChildCount();
		  for( int i=0; i<ndata; i++ ) {
			expandRecursive( (XMLComponent) cc.getChild(i) );
		  }
		}
	  } catch ( ClassCastException err ) { return; }
	}
	
    public static TreePath getPath( XMLComponent c ) {
	   return new TreePath(c.getPath());
    }
    
    public void displayComponentProperties( XMLComponent n ) {
	  _table.setProperties( n.getProperties() );   
    }
	
    // Remove the currently selected node. 
     public void removeCurrentNode( ) { removeCurrentNode(null); }
     
     public void removeCurrentNode( TreePath tp ) {
        TreePath currentSelection = ( tp == null ) ? getSelectionPath() : tp;
        if (currentSelection != null) {
            XMLComponent currentNode = (XMLComponent) (currentSelection.getLastPathComponent());
            XMLContainer parent = (XMLContainer)(currentNode.getParent());
			if( _treeModel.removeChild(parent,currentNode) ) return;
        } 
        // Either there was no selection, or the root was selected.
        _toolkit.beep();
    }
	   
	public XMLComponent getSelectedNode(  int requiredDepth ) { return getSelectedNode( null, requiredDepth ); }
	public XMLComponent getSelectedNode(  ) { return getSelectedNode( null, -1 ); }

	public XMLComponent getSelectedNode( TreePath tp, int requiredDepth ) {
	  TreePath currentSelection = ( tp == null ) ? getSelectionPath() : tp;
	  if ( (currentSelection != null ) && ((requiredDepth<0) || (currentSelection.getPathCount() == requiredDepth ))  ) {
		return (XMLComponent) (currentSelection.getLastPathComponent());
	  } else {     
		_toolkit.beep();     // No component selected selected at requiredDepth
	  }
	  return null;
    }

  public JPanel getDisplayPanel() {

	JPanel pV  = new JPanel(true);
	BoxLayout bl = new BoxLayout(pV, BoxLayout.Y_AXIS );  pV.setLayout( bl ); 	   
	Border bb = new BevelBorder(BevelBorder.LOWERED);  	
	pV.setBorder( bb );

	JScrollPane scrollpane = new JScrollPane();
	scrollpane.getViewport().setView(this);
	scrollpane.setMaximumSize(new Dimension(Short.MAX_VALUE,  Short.MAX_VALUE)); 
	scrollpane.setBorder( BorderFactory.createLoweredBevelBorder() );
	pV.add(scrollpane);

	if( _mode == kHasDataTree ) {
	  scrollpane = new JScrollPane();
	  scrollpane.getViewport().setView( _dataTree );
//	  scrollpane.setMaximumSize(new Dimension(Short.MAX_VALUE,  table_height )); 
	  scrollpane.setPreferredSize(new Dimension(Short.MAX_VALUE,  100 )); 
	  scrollpane.setBorder( BorderFactory.createLoweredBevelBorder() );
	  _dataTree.addTreeSelectionListener( new DocListener( _dataTree ) );
	  pV.add(scrollpane);
	}

	JScrollPane scrollpane1 = new JScrollPane();
	scrollpane1.getViewport().setView(_table);
//	scrollpane1.setMaximumSize(new Dimension(Short.MAX_VALUE,  table_height )); 
	scrollpane1.setPreferredSize(new Dimension(Short.MAX_VALUE,  120 )); 
	scrollpane1.setBorder( BorderFactory.createLoweredBevelBorder() );
	addTreeSelectionListener( new DocListener( this ) );	
	pV.add(scrollpane1);
	
	return pV;
 }
 
 public void processSelectionChange() {
	XMLComponent obj = getSelectedComponent();
	if( obj == null ) {
	  _table.setProperties((PropertyList)null);
	  return;
	}	  	  
	if( _mode == kHasDataTree ) {
	   XMLData data = null;
	   try {
		 data = (XMLData)obj;
	   } catch ( ClassCastException err ) { 
		  _table.setProperties( obj.getProperties() );	
	   }
	   XMLData cdata = (XMLData) data.getProperty("config");
	   if( cdata == null ) { 
		  _table.setProperties( obj.getProperties() );
	   } else {
		 createArgumentList(data,cdata); 
		 data = cdata;
	   }

	  _dataTreeModel.replaceChild( _dataRoot, data );
	  _dataTree.expandPath( data );
	  if( _debug ) { System.out.println( "Set Data display object:" + data ); }
	} else if( _table != null ) {
	  _table.setProperties( obj.getProperties() );
	}
 }
 
 public void createArgumentList( XMLData data, XMLData cmd_spec ) {
   _argumentList.clear();
   ConfigCommand cmd = (ConfigCommand) data.getProperty( "command" );
   int arg_count = cmd_spec.getDataCount();
   if( cmd == null ) {
	 for( int i=0; i<arg_count; i++ ) {
	   XMLData sarg = (XMLData) cmd_spec.getData(i);
	   XMLData marg = (XMLData) data.getData( i ) ;
	   String value = null;
	   if( marg != null ) {
		  value = (String) marg.getProperty("value");
	   }
	   if( value != null ) { 
		 _argumentList.put( sarg.toString(), value );
	   }
	}
   } else {
	 for( int i=0; i<arg_count; i++ ) {
	   XMLData arg = (XMLData) cmd_spec.getData(i);
	   try {
		  String value = (String) cmd.get( i );
		  _argumentList.put( arg.toString(), value );
	   } catch( ArrayIndexOutOfBoundsException err ) {;}
	 }	
   }
   _table.setProperties( _argumentList );
  }
}

class DocListener extends Object implements TreeSelectionListener {
  XMLTree _tree;
  DocListener( XMLTree tree ) { _tree = tree; }
  public void valueChanged(TreeSelectionEvent e) {
	 if( e.isAddedPath() ) {
		_tree.processSelectionChange();
	 }
  }
}

class XMLTreeCellRenderer extends DefaultTreeCellRenderer  {

	public XMLTreeCellRenderer() { 
	  super(); 
	}
	
	void setDefaultIcon( boolean leaf, boolean expanded ) {
		if (leaf) {
			setIcon(getLeafIcon());
		} else if (expanded) {
			setIcon(getOpenIcon());
		} else {
			setIcon(getClosedIcon());
		}
	}
	
    public Component getTreeCellRendererComponent(JTree tree, Object value,
						  boolean sel,
						  boolean expanded,
						  boolean leaf, int row,
						  boolean hasFocus) {

	  String stringValue = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
	  setText(stringValue);
	  if(sel)
		  setForeground(getTextSelectionColor());
	  else
		  setForeground(getTextNonSelectionColor());
		
	  try { 
		XMLComponent comp = (XMLComponent)value;
		setIcon( comp.getIcon() ); 
		
	  } catch ( ClassCastException err ) {
		setDefaultIcon( leaf, expanded );
	  }
	  selected = sel;

	  return this;
    }

}

class ListTreeCellRenderer extends DefaultTreeCellRenderer {
	private int _maxElements =  0;
	Vector _elementList;
	private JPanel _panel = new JPanel(true);
	private int _selectedElement =  -1;
	private int _labelLength =  250;
	private int _labelHeight =  16;
	private int _panelLength =  750;
	private int _spaceLength = 12;
	private JLabel _space = new JLabel("");
	private int _listElementLength =  50;
	private int _nElements = 1;
	
	public final static Color _elementBackgroundColor 	= new Color(255, 255, 150);
	public final static Color _elementSelectionColor 	= new Color(220, 220, 255);

	public ListTreeCellRenderer( int maxElements ) {
		_maxElements = maxElements;
		_elementList = new Vector( _maxElements );
		setOpaque(false);
		_panel.setOpaque(false);
		BoxLayout bl = new BoxLayout(_panel, BoxLayout.X_AXIS );  _panel.setLayout( bl ); 
		Dimension d = new Dimension( _labelLength, _labelHeight );
		Dimension dp = new Dimension( _panelLength, _labelHeight );
		Dimension ds = new Dimension(_spaceLength,_labelHeight);
		setMinimumSize( d ); setPreferredSize( d );  setMaximumSize( d );
		_panel.setPreferredSize( dp ); 
		_panel.add(this);
		
		_space.setVisible(false);
		_space.setMinimumSize( ds ); _space.setPreferredSize( ds );  _space.setMaximumSize( ds );
		_panel.add(_space);
				
		Dimension dE = new Dimension( _listElementLength, _labelHeight );
		Border lineBorder = BorderFactory.createLineBorder(Color.blue,1);
		for( int i=0; i<_maxElements; i++ ) {
		  JLabel l = new JLabel();
		  l.setOpaque(true);
		  l.setVisible(false);
		  l.setHorizontalAlignment(CENTER);
		  l.setBorder( lineBorder );
		  l.setMinimumSize( dE );  l.setPreferredSize( dE );  l.setMaximumSize( dE );
		  _elementList.add(l);
		  _panel.add(l);
		}

	}	
	
	public int setClickOffset( int offset ) { 
	  int loc = offset - ( _labelLength + _spaceLength );
	  return _selectedElement = ( loc > 0 ) ? ( loc/_listElementLength + 1 ) : 0;
	}
	
	public Component getTreeCellRendererComponent(
						JTree tree, Object value, 
						boolean selected, boolean expanded,
						boolean leaf, int row, 
						boolean hasFocus) {
		XMLComponent node = (XMLComponent)value;
		adjustElementList( tree, node, selected );
		setBackgroundSelectionColor( (_selectedElement > 0 ) ? _elementBackgroundColor :  _elementSelectionColor );
		super.getTreeCellRendererComponent( tree, value, selected, expanded, leaf, row, hasFocus);
		Icon icon = node.getIcon();
		if( icon != null ) { setIcon( icon ); }
		return _panel;
	}
	
	void adjustElementList( JTree tree, XMLComponent node, boolean selected ) {
	  int ndata = node.getDataCount();
	  for( int i=0; i<_maxElements; i++ ) {
		JLabel label = (JLabel) _elementList.get(i);
		if( i < ndata ) { 
		  XMLData d = (XMLData) node.getData(i);
		  XMLData cdata = (XMLData) d.getProperty("config");
		  if( cdata == null ) { label.setVisible(false); }
		  else {
			label.setVisible(true);		  
			boolean disabled =  ( (_selectedElement != (i+1) ) || !selected );
			label.setBackground( disabled ? _elementBackgroundColor :  _elementSelectionColor );
  //		  label.setEnabled( !disabled );
			label.setText( d.toString() );
		  }
		} else {
		  label.setVisible(false);
		}
	  }
	}
}
