package miiee.xml;

import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.awt.event.*;

public class XMLTreeModel extends Object implements TreeModel {

	public final static int kDataTree = 0;
	public final static int kChildTree = 1;
	
	XMLComponent _root;
    protected EventListenerList listenerList = new EventListenerList();
	private boolean _debug=false;
	private int _mode = kChildTree;
	
	
	public final static int NODE_DELETED = 0;
	public final static int NODE_ADDED = 1;
	
	public XMLTreeModel( XMLComponent root ) {
	  _root = root;
 	  if( _debug ) { System.out.println("XMLTreeModel:  root= " + root  ); }
	}

	public XMLTreeModel( XMLComponent root, int mode ) {
	  _root = root;
	  _mode = mode;
 	  if( _debug ) { System.out.println("XMLTreeModel:  root= " + root  ); }
	}
	
	
    /**
     * Returns the root of the tree.  Returns null only if the tree has
     * no nodes.
     *
     * @return  the root of the tree
     */
     
    public Object getRoot() { return _root; }

    public void setRoot(XMLComponent root) { _root = root; reload(); }
    
	public void reload() {
	  reload(_root);
    }

    public void reload(XMLComponent node) {
        if(node != null) {
            fireTreeStructureChanged(this, getPathToRoot(node), null, null);
        }
    }

    public XMLComponent[] getPathToRoot(XMLComponent aNode) {
        return getPathToRoot(aNode, 0);
    }

    /**
     * Builds the parents of node up to and including the root node,
     * where the original node is the last element in the returned array.
     * The length of the returned array gives the node's depth in the
     * tree.
     * 
     * @param aNode  the node to get the path for
     * @param depth  an int giving the number of steps already taken towards
     *        the root (on recursive calls), used to size the returned array
     * @return an array of TreeNodes giving the path from the root to the
     *         specified node 
     */
    protected XMLComponent[] getPathToRoot(XMLComponent aNode, int depth) {
        XMLComponent[]              retNodes;
	// This method recurses, traversing towards the root in order
	// size the array. On the way back, it fills in the nodes,
	// starting from the root and working back to the original node.

        /* Check for null, in case someone passed in a null node, or
           they passed in an element that isn't rooted at root. */
        if(aNode == null) {
            if(depth == 0)
                return null;
            else
                retNodes = new XMLComponent[depth];
        }
        else {
            depth++;
            if(aNode == _root)
                retNodes = new XMLComponent[depth];
            else
                retNodes = getPathToRoot(aNode.getParent(), depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    /**
     * Returns the child of <I>parent</I> at index <I>index</I> in the parent's
     * child array.  <I>parent</I> must be a node previously obtained from
     * this data source. This should not return null if <i>index</i>
     * is a valid index for <i>parent</i> (that is <i>index</i> >= 0 &&
     * <i>index</i> < getChildCount(<i>parent</i>)).
     *
     * @param   parent  a node in the tree, obtained from this data source
     * @return  the child of <I>parent</I> at index <I>index</I>
     */
    public Object getChild(Object parent, int index) {
	  XMLComponent rv = null;
	  switch(_mode) {
		case kChildTree: rv = (XMLComponent) ((XMLContainer)parent).getChild( index ); break;
		case kDataTree:  rv = (XMLComponent) ((XMLComponent)parent).getData( index );  break;
	  }
 	  if( _debug ) { System.out.println("getChild: " + parent + ", count= " + index + ", child= " + rv ); }
 	  return rv;
   }


    /**
     * Returns the number of children of <I>parent</I>.  Returns 0 if the node
     * is a leaf or if it has no children.  <I>parent</I> must be a node
     * previously obtained from this data source.
     *
     * @param   parent  a node in the tree, obtained from this data source
     * @return  the number of children of the node <I>parent</I>
     */
    public int getChildCount(Object parent) {
	  int rv = 0;
	  try {
		switch(_mode) {
		   case kChildTree: {
			  XMLContainer targ = (XMLContainer)parent;	
			  targ.waitUntilResolved();
			  rv =  targ.getChildCount(); 
			 } break;
		   case kDataTree:  {
			  XMLComponent targ = (XMLComponent)parent;	
			  targ.waitUntilResolved();
			  rv = targ.getDataCount(); 
			 } break;
		}
		if( _debug ) { System.out.println("getChildCount: " + parent + ", count= " + rv ); }
	  } catch ( ClassCastException err ) { ; }
	  return rv;
    }

    /**
     * Returns true if <I>node</I> is a leaf.  It is possible for this method
     * to return false even if <I>node</I> has no children.  A directory in a
     * filesystem, for example, may contain no files; the node representing
     * the directory is not a leaf, but it also has no children.
     *
     * @param   node    a node in the tree, obtained from this data source
     * @return  true if <I>node</I> is a leaf
     */
    public boolean isLeaf(Object node) {
	  if( node == null ) return true;
	  XMLComponent comp = (XMLComponent)node;
	  return comp.isLeaf();
    }

    /**
      * Messaged when the user has altered the value for the item identified
      * by <I>path</I> to <I>newValue</I>.  If <I>newValue</I> signifies
      * a truly new value the model should post a treeNodesChanged
      * event.
      *
      * @param path path to the node that the user has altered.
      * @param newValue the new value from the TreeCellEditor.
      */
    public void valueForPathChanged(TreePath path, Object newValue)	{
		XMLComponent   aNode = (XMLComponent)path.getLastPathComponent();
//        aNode.setUserObject(newValue);
//        nodeChanged(aNode);
    }


    /**
     * Returns the index of child in parent.
     */
    public int getIndexOfChild(Object parent, Object child) {
	  int index = -1;
	  switch( _mode ) {
		 case kChildTree: 
		   index = ((XMLContainer)parent).getChildIndex(child); 
		   break;
		 case kDataTree:  
		   index = ((XMLComponent)parent).getDataIndex((XMLData)child);  
		   break;
	  }   
	  if( _debug ) { System.out.println("getIndexOfChild: " + parent + ", count= " + index + ", child= " + child ); }
 	  return index;
    }

//
//  Change Events
//

    public void addTreeModelListener(TreeModelListener l) {
        listenerList.add(TreeModelListener.class, l);
    }

    /**
     * Removes a listener previously added with <B>addTreeModelListener()</B>.
     *
     * @see     #addTreeModelListener
     * @param   l       the listener to remove
     */  
    public void removeTreeModelListener(TreeModelListener l) {
        listenerList.remove(TreeModelListener.class, l);
    }

    /*
     * Notify all listeners that have registered interest for
     * notification on this event type.  The event instance 
     * is lazily created using the parameters passed into 
     * the fire method.
     * @see EventListenerList
     */
    protected void fireTreeNodesChanged(Object source, Object[] path, 
                                        int[] childIndices, 
                                        Object[] children) {
        // Guaranteed to return a non-null array
        Object[] listeners = listenerList.getListenerList();
        TreeModelEvent e = null;
        // Process the listeners last to first, notifying
        // those that are interested in this event
        for (int i = listeners.length-2; i>=0; i-=2) {
            if (listeners[i]==TreeModelListener.class) {
                // Lazily create the event:
                if (e == null)
                    e = new TreeModelEvent(source, path, 
                                           childIndices, children);
                ((TreeModelListener)listeners[i+1]).treeNodesChanged(e);
            }          
        }
    }

    /*
     * Notify all listeners that have registered interest for
     * notification on this event type.  The event instance 
     * is lazily created using the parameters passed into 
     * the fire method.
     * @see EventListenerList
     */
    protected void fireTreeNodesInserted(Object source, Object[] path, 
                                        int[] childIndices, 
                                        Object[] children) {
        // Guaranteed to return a non-null array
        Object[] listeners = listenerList.getListenerList();
        TreeModelEvent e = null;
        // Process the listeners last to first, notifying
        // those that are interested in this event
        for (int i = listeners.length-2; i>=0; i-=2) {
            if (listeners[i]==TreeModelListener.class) {
                // Lazily create the event:
                if (e == null)
                    e = new TreeModelEvent(source, path, 
                                           childIndices, children);
                ((TreeModelListener)listeners[i+1]).treeNodesInserted(e);
            }          
        }
    }

    /*
     * Notify all listeners that have registered interest for
     * notification on this event type.  The event instance 
     * is lazily created using the parameters passed into 
     * the fire method.
     * @see EventListenerList
     */
    protected void fireTreeNodesRemoved(Object source, Object[] path, 
                                        int[] childIndices, 
                                        Object[] children) {
        // Guaranteed to return a non-null array
        Object[] listeners = listenerList.getListenerList();
        TreeModelEvent e = null;
        // Process the listeners last to first, notifying
        // those that are interested in this event
        for (int i = listeners.length-2; i>=0; i-=2) {
            if (listeners[i]==TreeModelListener.class) {
                // Lazily create the event:
                if (e == null)
                    e = new TreeModelEvent(source, path, 
                                           childIndices, children);
                ((TreeModelListener)listeners[i+1]).treeNodesRemoved(e);
            }          
        }
    }

    /*
     * Notify all listeners that have registered interest for
     * notification on this event type.  The event instance 
     * is lazily created using the parameters passed into 
     * the fire method.
     * @see EventListenerList
     */
     
    protected void fireTreeStructureChanged(Object source, Object[] path, 
                                        int[] childIndices, 
                                        Object[] children) {
        // Guaranteed to return a non-null array
        Object[] listeners = listenerList.getListenerList();
        TreeModelEvent e = null;
        // Process the listeners last to first, notifying
        // those that are interested in this event
        for (int i = listeners.length-2; i>=0; i-=2) {
            if (listeners[i]==TreeModelListener.class) {
                // Lazily create the event:
                if (e == null)
                    e = new TreeModelEvent(source, path, 
                                           childIndices, children);
                ((TreeModelListener)listeners[i+1]).treeStructureChanged(e);
            }          
        }
    }
    
	public void fireStructureChanged( XMLComponent parent, XMLComponent child, int child_index, int change_type ) {
	  switch( change_type ) {
		case NODE_DELETED: {
		  int[] child_indices = { child_index };
		  Object[] children = { child } ;
		  fireTreeNodesRemoved( this, parent.getPath(),  child_indices,  children );
		} break;
		case NODE_ADDED: {
		  int[] child_indices = { child_index };
		  Object[] children = { child } ;
		  fireTreeStructureChanged( this, parent.getPath(),  child_indices, children ); 
		} break; 
	  }
 	}
/* 	
 	public void fireNodesAdded() {
	  XMLComponent parent
	  fireTreeStructureChanged( this, parent.getPath(),  child_indices, children ); 
	}
*/	
 	public boolean removeChild( XMLComponent parent, XMLComponent child ) {
	   if ( (parent == null) || (child == null) ) return false;
	   int index = -1;
	  switch(_mode) {
		 case kChildTree: {
		   XMLContainer targ = (XMLContainer)parent;
		   index = targ.getChildIndex( child );
		   targ.removeChild(child);
		 } break;
		 case kDataTree: 
		   index = parent.getDataIndex( (XMLData) child );
		   parent.removeData( (XMLData) child);
		 break;
	  }   
	   fireStructureChanged( parent,  child, index, NODE_DELETED );
	   return true;
	}

 	public boolean addChild( XMLComponent parent, XMLComponent child ) {
	  return addChild( parent, child, true );
 	}

 	public boolean addChild( XMLComponent parent, XMLComponent child, boolean show_duplication_errors ) {
	   if ( (parent == null) || (child == null) ) return false;
	   int index = -1;
	   try {
		  switch(_mode) {
			case kChildTree: {
			  XMLContainer targ = (XMLContainer)parent;
			  targ.addChild(child);
			  index = targ.getChildIndex( child );
			} break;
			case kDataTree:  
			  parent.addData( (XMLData)child );
			  index = parent.getDataIndex( (XMLData) child );
			break;
		  }   
	   } catch( XMLException err ) {
		  if(show_duplication_errors) {
			err.show( null, "Error adding Child: " );
			err.printStackTrace(System.out);
		  } 
		  return false;
	   } catch( ClassCastException err ) {
		  System.out.println( "Error adding Child: Non-data added to data tree: " + child );
		  err.printStackTrace(System.out);
		  return false;
	   }
	   fireStructureChanged( parent,  child, index, NODE_ADDED );
	   return true;
	}

	public boolean replaceChild( XMLComponent parent, XMLComponent newChild ) {
	   if ( (parent == null) || (newChild == null) ) return false;
	   XMLComponent oldChild = null;
	   int index = -1;
	   try {
		  switch(_mode) {
			case kChildTree: {
			  XMLContainer targ = (XMLContainer)parent;
			  oldChild = (XMLComponent) targ.getChild(0);
			  targ.removeChildren();			 
			  targ.addChild(newChild);
			  index = targ.getChildIndex( newChild );
			} break;
			case kDataTree:  
			  oldChild = (XMLComponent) parent.getData(0);
			  parent.clearData(); 
			  parent.addData( (XMLData)newChild );
			  index = parent.getDataIndex( (XMLData) newChild );
			break;
		  }   
	   } catch( XMLException err ) {
		  err.show( null, "Error adding Child: " );
		  err.printStackTrace(System.out);
		  return false;
	   } catch( ClassCastException err ) {
		  System.out.println( "Error adding Child: Non-data added to data tree: " + newChild );
		  err.printStackTrace(System.out);
		  return false;
	   }
	   if( oldChild != null ) { fireStructureChanged( parent,  oldChild, 0, NODE_DELETED ); }
	   fireStructureChanged( parent,  newChild, index, NODE_ADDED );
	   return true;
	}

}
