#include "CString.h"
#include "Environ.h"
#include "ExprBuilder.h"
#include "Constructor.h"
int MMLerror (char* s);
int MMLlex(void);
int MMLparse(void);
void init_debug();

extern int MMLleng, MMLdebug;
extern FILE *MMLin, *MMLout;

int main( int argc, char** argv ) {
	int token = 1;
	CString MML_file;

	Env::Startup (argc,argv, Env::kMMLP );
	int nfiles = TConstructor::StartUp(argc,argv);
	MMLout = fopen("parser.out","w");
	init_debug();
	
	for( int i=0; i<nfiles; i++ ) {
		TConstructor::SetInputFileName(i, MML_file);
		sprintf(gMsgStr,"\nParsing input file: %s\n",MML_file.chars());
		gPrintScreen();
		MMLin = fopen( MML_file, "r" );
		if( MMLin ) {
			MMLparse ();
			fclose(MMLin);
		} else gPrintErr( MML_file += ": Can't open input file" );
	}

	ExprBuilder::Print(MMLout);
//	TConstructor::Run();	
}
