%option noyywrap

SPACE   [ \t]*
CNAME	[A-Z][a-zA-Z_]*
QNAME	[a-z_]+
NAME	[a-zA-Z_][a-zA-Z_0-9]*
ANAME	[a-zA-Z_][a-zA-Z_0-9.]*
DIGIT   [0-9]
EXP     [Ee]{SPACE}("-"|"+")*{DIGIT}+
FLOAT   (({DIGIT}+"."{DIGIT}*)|("."{DIGIT}+))({SPACE}{EXP})*
INT     ({DIGIT}+)({SPACE}{EXP})*
SFLOAT   ("-"|"+")*{FLOAT}
SINT     ("-"|"+")*{INT}
NUMBER  {FLOAT}|{INT}
SNUMBER  {SFLOAT}|{SINT}
DIRECTION [NSEWUD]
POINT   {SPACE}{SNUMBER}{SPACE}(","{SPACE}{SNUMBER}{SPACE})+(":"{BC})*
RNAME1    {NAME}{SPACE}"@"{SPACE}"("{POINT}")"
RNAME2    {NAME}{SPACE}"@"{SPACE}{DIRECTION}
RNAME    ({RNAME1})|({RNAME2})
NSN     [^a-zA-Z_0-9]+
NS      [^a-zA-Z_]+
BC      [S0ZCTBP] 


%s CONDITIONAL
%s OBJECT
%s DECL
%s ARRAY_ARG
%s ATTRIBUTE
%s CODE
%s LIST
%s STRING

%{

#define YY_DECL int MMLlex(void)
#define yylval MMLlval
#define yylex MMLlex
#define YY_NEVER_INTERACTIVE 1
#define MMLwrap yywrap
int SS_current_state;

#include "CString.h"
#include "ExprBuilder.h"
#include "MML_parser.h"

int S_line_num = 1;
int list_depth = 0;
CString stringTemp;
CString S_inputBuffer;
int S_inputBuffer_ptr = 0;
CString S_state_label;
int object_depth = 0;
int S_input_block_state = 0;
extern int MMLleng, MMLdebug;

#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( S_input_block_state > 0 ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = S_inputBuffer[ S_inputBuffer_ptr++ ]) != 0 && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		result = n; \
		buf[n++] = '\0'; \
		fprintf(stderr,"Filling lex buffer:%s (size = %d)\n",buf,result); \
		} \
	else if ( ((result = fread( buf, 1, max_size, yyin )) == 0) \
		  && ferror( yyin ) ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );


inline void print_delete(){
#ifdef FLEX_DEBUG
	if(yy_flex_debug) { fprintf(stderr," ***** delete: %s **********\n",yytext); }
#endif
}

inline void print_state(const char* state, int depth=-1, int save_state=1 ) { 
#ifdef FLEX_DEBUG
	if(yy_flex_debug) { 
		fprintf(stderr," ****** MML file line number %d: Entering lexer state %s \n",S_line_num,state);
		if( save_state ) { S_state_label = state; }
		if( depth > -1 ) fprintf(stderr,"depth = %d",depth);
		fprintf(stderr,"\n"); 
	} 
#endif
}

inline int string_full( CString& s ) {
	if( s.length() >= MAX_NAME_LEN-2 ) { 
		Util::ncopy0(s, MMLlval.str, MAX_NAME_LEN-2); 
		s="";
		return 1;
	} 
	return 0;
}

int MMLerror (char* s) {
   printf ("\n\n%s\n Line %d, Parsing: %s\n", s, S_line_num, MMLlval.str );
   return 0;
}	

%}

%%


"//"[^\n]*                /* ignore comments */ 

\n                         S_line_num++; 

<INITIAL>{QNAME}           {    Util::ncopy0( yytext, MMLlval.str, MAX_NAME_LEN-1); 
																return tQNAME;
													 }													 
<OBJECT>{QNAME}            {    Util::ncopy0( yytext, MMLlval.str, MAX_NAME_LEN-1); 
																return tQNAME;
													 }													 
<INITIAL>{CNAME}           {    Util::ncopy0( yytext, MMLlval.str, MAX_NAME_LEN-1);
																BEGIN(DECL); print_state("DECL");
																return tCNAME;
													 }
<OBJECT>{CNAME}            {    Util::ncopy0( yytext, MMLlval.str, MAX_NAME_LEN-1);
																BEGIN(DECL); print_state("DECL");
																return tCNAME;
													 }
													 													 
<DECL>{NAME}               { Util::ncopy0(yytext, MMLlval.str, MAX_NAME_LEN-1);  return tONAME; }
<DECL>":"                 return tPathLink;
<DECL>[ \t]*                 /* ignore */
<DECL>"{"          				 BEGIN(OBJECT); object_depth++; print_state("OBJECT",object_depth); return tOpenObject;
<DECL>"["          				 SS_current_state = YY_START; BEGIN(ARRAY_ARG); print_state( "ARRAY_ARG", object_depth, 0 ); return tOpenArray;
<DECL>"="          				 BEGIN(ATTRIBUTE); print_state("ATTRIBUTE"); return tOpenAttribute;

<ARRAY_ARG>{ANAME}     		{ Util::ncopy0(yytext, MMLlval.str, MAX_NAME_LEN-1);  return tANAME; }
<ARRAY_ARG>","              return ',';
<ARRAY_ARG>"*"              return '~';
<ARRAY_ARG>"]"          	BEGIN(SS_current_state); print_state( S_state_label.chars(), object_depth ); return tCloseArray;

<ATTRIBUTE>";"             { if( object_depth == 0 ) { BEGIN(INITIAL); print_state("INITIAL"); } else { BEGIN(OBJECT); print_state("OBJECT",object_depth); } return tCloseAttribute; }
<OBJECT>"}"                { if( object_depth-- == 0 ) { BEGIN(INITIAL); print_state("INITIAL"); } else { print_state("OBJECT",object_depth); } return tCloseObject; }

<ATTRIBUTE>{ANAME}     		{ Util::ncopy0(yytext, MMLlval.str, MAX_NAME_LEN-1);  return tANAME; }
<ATTRIBUTE>"::"             return tPathLink;
<ATTRIBUTE>{SFLOAT}          strcpy(MMLlval.str,yytext); return tFLOAT;
<ATTRIBUTE>{SINT}            strcpy(MMLlval.str,yytext); return tINT;

<ATTRIBUTE>"("              BEGIN(LIST); print_state("LIST",1); list_depth = 1; return tOpenList;
<LIST>"("                   list_depth++; print_state("LIST",list_depth);  return tOpenList;
<LIST>")"                   if( --list_depth == 0 ) { BEGIN(ATTRIBUTE); print_state("ATTRIBUTE"); } else { print_state("LIST",list_depth); } return tCloseList;
<LIST>","                   return ',';
<LIST>{SFLOAT}          			strcpy(MMLlval.str,yytext); return tFLOAT;
<LIST>{SINT}            			strcpy(MMLlval.str,yytext); return tINT;
<LIST>{ANAME}     					{ Util::ncopy0(yytext, MMLlval.str, MAX_NAME_LEN-1);  return tANAME; }
<LIST>':'             			return tPathLink;

<ATTRIBUTE>"!{"              BEGIN(STRING); print_state("STRING",1); stringTemp=""; return tOpenString;
<STRING>[^}!]								stringTemp += yytext[0];  if( string_full(stringTemp) ) { return tContinueString; }
<STRING>"}!"                BEGIN(ATTRIBUTE); print_state("ATTRIBUTE"); stringTemp += '\0'; Util::scopy( stringTemp, MMLlval.str ); return tCloseString;
<STRING>"}"                 stringTemp += yytext[0]; if( string_full(stringTemp) )  { return tContinueString; }
<STRING>"!"                 stringTemp += yytext[0]; if( string_full(stringTemp) )  { return tContinueString; }

<ATTRIBUTE>"{"             BEGIN(CODE);   print_state("CODE"); return tOpenCode;
<CODE>"}"                  BEGIN(ATTRIBUTE);  print_state("ATTRIBUTE"); return tCloseCode;

<CODE>{RNAME}             { Util::ncopy0(yytext, MMLlval.str, MAX_NAME_LEN-1);  return tRNAME; }
<CODE>{NAME}          		{ Util::ncopy0(yytext, MMLlval.str, MAX_NAME_LEN-1);  return tVNAME; }

<CODE>{FLOAT}          strcpy(MMLlval.str,yytext); return tFLOAT;
<CODE>{INT}            strcpy(MMLlval.str,yytext); return tINT;

<CODE>"::"       			return tPathLink; 
<CODE>"?"       			return tTHEN;  
<CODE>":"       			return tELSE; 

<CODE>">"           MMLlval.etype = kGT;  return tRELATION; 
<CODE>"<"           MMLlval.etype = kLT;  return tRELATION; 
<CODE>">="           MMLlval.etype = kGE;  return tRELATION; 
<CODE>"<="           MMLlval.etype = kLE;  return tRELATION; 
<CODE>"&"             MMLlval.etype = kAnd; return tRELATION_G; 
<CODE>"|"           MMLlval.etype = kOr; return tRELATION_G; 
<CODE>"&&"             MMLlval.etype = kAnd; return tRELATION_G; 
<CODE>"||"           MMLlval.etype = kOr; return tRELATION_G; 
<CODE>"=="             MMLlval.etype = kEq; return tRELATION; 
<CODE>"!="            MMLlval.etype = kNEq; return tRELATION; 
<CODE>"["          	  SS_current_state = YY_START; BEGIN(ARRAY_ARG); print_state( "ARRAY_ARG", object_depth, 0 ); return tOpenArray;

<CODE>"="             MMLlval.etype = kEq; return tEQUAL; 

<CODE>[\+\-\/\*\^\!]             return yytext[0];
<CODE>"("                        return '(';
<CODE>")"                        return ')';
<CODE>";"                        return ';';
<CODE>[ \t]*                     /* ignore */
<CODE>,			   				 return ',';

[ \t]*                           /* ignore */

~                                yyterminate();
.                          fprintf(stderr,"\nLine %d: Unrecognized character!!: %s\n\n\n",S_line_num, yytext); return 0; 

%{


%}

%%

void MMLinitParse( int debug_level, int context ) {
	S_line_num = 1;
	S_input_block_state = context;
	switch( context ) {
		case 1: BEGIN(ATTRIBUTE); print_state("ATTRIBUTE");  break;
	}
#ifdef FLEX_DEBUG
	MML_flex_debug = 0;
	if(debug_level > 0) { MML_flex_debug = 1; }
	MMLdebug = 0;
	if(debug_level > 1) { MMLdebug = 1; }
#endif
}

void MMLSetParseBuffer( CString& s ) {
	MMLin = NULL;
	S_inputBuffer_ptr = 0;
	S_inputBuffer = s;
}
