%option noyywrap

SPACE   [ \t]*
CNAME	[A-Z][a-zA-Z_]*
QNAME	[a-z_]+
NAME	[a-zA-Z_][a-zA-Z_0-9]*
ANAME	[a-zA-Z_][a-zA-Z_0-9.]*
DIGIT   [0-9]
EXP     [Ee]{SPACE}("-"|"+")*{DIGIT}+
FLOAT   (({DIGIT}+"."{DIGIT}*)|("."{DIGIT}+))({SPACE}{EXP})*
INT     ({DIGIT}+)({SPACE}{EXP})*
SFLOAT   ("-"|"+")*{FLOAT}
SINT     ("-"|"+")*{INT}
NUMBER  {FLOAT}|{INT}
SNUMBER  {SFLOAT}|{SINT}
DIRECTION [NSEWUD]
POINT   {SPACE}{SNUMBER}{SPACE}(","{SPACE}{SNUMBER}{SPACE})+(":"{BC})*
RNAME1    {NAME}{SPACE}"@"{SPACE}"("{POINT}")"
RNAME2    {NAME}{SPACE}"@"{SPACE}{DIRECTION}
RNAME    ({RNAME1})|({RNAME2})
NSN     [^a-zA-Z_0-9]+
NS      [^a-zA-Z_]+
BC      [S0ZCTBP] 


%s CONDITIONAL
%s ARRAY_ARG
%s CODE
%s LIST
%s STRING

%{

#define YY_DECL int SMMLlex(void)
#define yylval SMMLlval
#define yylex SMMLlex
#define YY_NEVER_INTERACTIVE 1
#define SMMLwrap yywrap
int SMML_current_state;

#include "CString.h"
#include "ExprBuilder.h"
#include "SMML_parser.h"

int SMML_line_num = 1;
int SMML_ldepth = 0;
CString SMML_stmp;
CString SMML_inputBuffer;
int SMML_inputBuffer_ptr = 0;
CString SMML_state_label;
CString SMML_doc_name;
extern int SMMLleng, SMMLdebug;

#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	int c = '*', n; \
	for ( n = 0; n < max_size && \
			 (c = SMML_inputBuffer[ SMML_inputBuffer_ptr++ ]) != 0 && c != '\n'; ++n ) \
		buf[n] = (char) c; \
	if ( c == '\n' ) \
		buf[n++] = (char) c; \
	result = n; \

#undef yyterminate
#define yyterminate() \
	return YY_NULL

inline void print_delete(){
#ifdef FLEX_DEBUG
	if(yy_flex_debug) { fprintf(stderr," ***** delete: %s **********\n",yytext); }
#endif
}

inline void print_state(const char* state, int save_state=1 ) { 
#ifdef FLEX_DEBUG
	if(yy_flex_debug) { 
		fprintf(stderr,"\n ****** SMML file line number %d: Entering lexer state %s \n",SMML_line_num,state);
		if( save_state ) { SMML_state_label = state; }
	} 
#endif
}

inline int string_full( CString& s ) {
	if( s.length() >= MAX_NAME_LEN-2 ) { 
		Util::ncopy0(s, SMMLlval.str, MAX_NAME_LEN-2); 
		s="";
		return 1;
	} 
	return 0;
}

int SMMLerror (char* s) {
	printf ("\n\n%s\n Line %d, Parsing: %s in doc %s\n", s, SMML_line_num, SMMLlval.str, SMML_doc_name.chars() );
#ifdef FLEX_DEBUG
	if(yy_flex_debug) { 
		fprintf(stderr,"\tLex buffer: %s\n",SMML_inputBuffer.chars()); 
	}
#endif
	Env::debugger_stop_here(); 
   return 0;
}	

%}

%%


"//"[^\n]*                /* ignore comments */ 

\n                         SMML_line_num++; 
<INITIAL>"("               BEGIN(LIST); print_state("LIST",1); SMML_ldepth = 1; return tOpenList;
<INITIAL>"!{"              BEGIN(STRING); print_state("STRING",1); SMML_stmp=""; return tOpenString;
<INITIAL>"{"               BEGIN(CODE);   print_state("CODE"); return tOpenCode;

<ARRAY_ARG>{ANAME}     		{ Util::ncopy0(yytext, SMMLlval.str, MAX_NAME_LEN-1);  return tANAME; }
<ARRAY_ARG>","              return ',';
<ARRAY_ARG>"*"              return '~';
<ARRAY_ARG>"]"          	BEGIN(SMML_current_state); print_state( SMML_state_label.chars() ); return tCloseArray;

<LIST>"("                   SMML_ldepth++; print_state("LIST",SMML_ldepth);  return tOpenList;
<LIST>")"                   if( --SMML_ldepth == 0 ) { BEGIN(INITIAL); print_state("INITIAL"); } else { print_state("LIST",SMML_ldepth); } return tCloseList;
<LIST>","                   return ',';
<LIST>{SFLOAT}          			strcpy(SMMLlval.str,yytext); return tFLOAT;
<LIST>{SINT}            			strcpy(SMMLlval.str,yytext); return tINT;
<LIST>{ANAME}     					{ Util::ncopy0(yytext, SMMLlval.str, MAX_NAME_LEN-1);  return tANAME; }
<LIST>':'             			return tPathLink;

<STRING>[^}!]								SMML_stmp += yytext[0];  if( string_full(SMML_stmp) ) { return tContinueString; }
<STRING>"}!"                BEGIN(INITIAL); print_state("INITIAL"); SMML_stmp += '\0'; Util::scopy( SMML_stmp, SMMLlval.str ); return tCloseString;
<STRING>"}"                 SMML_stmp += yytext[0]; if( string_full(SMML_stmp) )  { return tContinueString; }
<STRING>"!"                 SMML_stmp += yytext[0]; if( string_full(SMML_stmp) )  { return tContinueString; }

<CODE>"}"                  BEGIN(INITIAL);  print_state("INITIAL"); return tCloseCode;

<CODE>{RNAME}             { Util::ncopy0(yytext, SMMLlval.str, MAX_NAME_LEN-1);  return tRNAME; }
<CODE>{NAME}          		{ Util::ncopy0(yytext, SMMLlval.str, MAX_NAME_LEN-1);  return tVNAME; }

<CODE>{FLOAT}          strcpy(SMMLlval.str,yytext); return tFLOAT;
<CODE>{INT}            strcpy(SMMLlval.str,yytext); return tINT;

<CODE>"::"       			return tPathLink; 
<CODE>"?"       			return tTHEN;  
<CODE>":"       			return tELSE; 

<CODE>">"           SMMLlval.etype = kGT;  return tRELATION; 
<CODE>"<"           SMMLlval.etype = kLT;  return tRELATION; 
<CODE>">="           SMMLlval.etype = kGE;  return tRELATION; 
<CODE>"<="           SMMLlval.etype = kLE;  return tRELATION; 
<CODE>"&"             SMMLlval.etype = kAnd; return tRELATION_G; 
<CODE>"|"           SMMLlval.etype = kOr; return tRELATION_G; 
<CODE>"&&"             SMMLlval.etype = kAnd; return tRELATION_G; 
<CODE>"||"           SMMLlval.etype = kOr; return tRELATION_G; 
<CODE>"=="             SMMLlval.etype = kEq; return tRELATION; 
<CODE>"!="            SMMLlval.etype = kNEq; return tRELATION; 
<CODE>"["          	  SMML_current_state = YY_START; BEGIN(ARRAY_ARG); print_state( "ARRAY_ARG", 0 ); return tOpenArray;

<CODE>"="             SMMLlval.etype = kEq; return tEQUAL; 

<CODE>[\+\-\/\*\^\!]             return yytext[0];
<CODE>"("                        return '(';
<CODE>")"                        return ')';
<CODE>";"                        return ';';
<CODE>[ \t]*                     /* ignore */
<CODE>,			   				 return ',';

[ \t]*                           /* ignore */

~                                yyterminate();
.                          fprintf(stderr,"\nLine %d: Unrecognized character!!: %s\n\n\n",SMML_line_num, yytext); return 0; 

%{


%}

%%


void SMMLinitParse( int debug_level, CString& doc_name ) {
	SMML_line_num = 1;
	SMML_doc_name = doc_name;
#ifdef FLEX_DEBUG
	SMML_flex_debug = 0;
	if(debug_level > 0) { SMML_flex_debug = 1; }
	SMMLdebug = 0;
	if(debug_level > 1) { SMMLdebug = 1; }
#endif
}

void SMMLSetParseBuffer( CString& s ) {
	SMMLin = NULL;
	SMML_inputBuffer_ptr = 0;
	SMML_inputBuffer = s;
}
