%{

#include "CString.h"
#include "Environ.h"
#include "ExprBuilder.h"
int yyerror (char* s);
int yylex(void);

%}

/* Parser for STELLA equation file */

%union {
  char str[MAX_NAME_LEN];
  TNode* node;
  ERelationType etype;
}

%token <str> tANAME
%token <str> tONAME
%token <str> tVNAME
%token <str> tCNAME
%token <str> tQNAME
%token <str> tRNAME

%token <str> tOpenArray
%token <str> tCloseArray
%token <str> tOpenList
%token <str> tCloseList
%token <str> tOpenString
%token <str> tContinueString
%token <str> tCloseString
%token <str> tOpenCode
%token <str> tCloseCode

%token <str> tINT
%token <str> tFLOAT
%token <str> tTHEN
%token <str> tELSE
%token <str> tPathLink

%token <etype> tRELATION
%token <etype> tRELATION_G
%token <etype> tEQUAL

%type <node> attr_value
%type <node> data_list
%type <node> data_list_body
%type <node> code_block
%type <node> string_block
%type <node> part_str_blk
%type <node> eqn_list
%type <node> equation
%type <node> data_val
%type <node> variable
%type <node> array_arg
%type <node> slist


%type <node> function
%type <node> conditional
%type <node> expr
%type <node> expr_list
%type <node> cond_expr
     
%left '-' '+'
%left '*' '/'
%left NEG     /* negation--unary minus */
%right '^'    /* exponentiation        */

%%

attr_value:                   data_list										{  ExprBuilder::SetResult( $$ = $1 ); }
							| code_block									{  ExprBuilder::SetResult( $$ = $1 ); }
							| string_block									{  ExprBuilder::SetResult( $$ = $1 ); }

code_block:   	tOpenCode expr tCloseCode								{ $$ = $2; }

data_list:        tOpenList data_list_body tCloseList						{ $$ = $2; }
						| tOpenList  tCloseList							    { $$ = NULL; }

string_block:   tOpenString tCloseString									{ $$ = ExprBuilder::CreateStringNode( $2  ); }
							|	part_str_blk tCloseString					{ ((TStringNode*)$1)->Add($2); $$ = $1; }

part_str_blk:	 tOpenString tContinueString								{ $$ = ExprBuilder::CreateStringNode( $2  );  }
							| part_str_blk tContinueString                  { ((TStringNode*)$1)->Add($2); $$ = $1; }

array_arg:    tOpenArray slist tCloseArray										{ $$ = $2;  } 	
							
slist:        tANAME															{ $$ = ExprBuilder::CreateStringListNode( $1  ); } 
			  | '~'															    { $$ = ExprBuilder::CreateStringListNode( "*" ); } 
			  | slist ',' tANAME												{ ((TStringListNode*)$1)->AddString( $3 ); $$ = $1;  } 

data_list_body:			  data_val										     { $$ = ExprBuilder::CreateListNode( $1  ); }  
					| data_list_body ',' data_val                             { ((TListNode*)$1)->AddNode( $3 ); $$ = $1; } 

							
eqn_list:       equation														{ $$ = ExprBuilder::CreateListNode( $1  ); }  
							| eqn_list equation	                     			{ ((TListNode*)$1)->AddNode( $2 ); $$ = $1; }
							
function:      tVNAME '(' expr_list ')'                                        { $$ = ExprBuilder::CreateFuncNode( $1, (TListNode*) $3 ); }
							| tVNAME tPathLink tVNAME '(' expr_list ')'        { $$ = ExprBuilder::CreateFuncNode( $3, (TListNode*) $5 ); 
																					  ((TFunctionNode*)$$)->SetLibrary( $1 ); 	}
																																
variable:	   tVNAME									    { $$ = ExprBuilder::CreateVarNode( $1 ); } 												
             | tRNAME                                       { $$ = ExprBuilder::CreateVarNode( $1, True ); } 
			 | tVNAME array_arg							    { $$ = ExprBuilder::CreateVarNode( $1 ); 
															  ((TVarNode*)$$)->AddMapList( (TStringListNode*)$2 );  } 												
             | tRNAME array_arg                             { $$ = ExprBuilder::CreateVarNode( $1, True ); 
															  ((TVarNode*)$$)->AddMapList( (TStringListNode*)$2 );  } 		 
             
equation:     variable tEQUAL expr ';'						{ $$ = ExprBuilder::CreateEquationNode( TEquationNode::kUpdate, (TVarNode*) $1, $3  ); } 																																																																																		
conditional:   cond_expr tTHEN expr tELSE expr               { $$ = ExprBuilder::CreateCondNode( $1, $3, $5 ); }   

expr_list:       expr                           		     { $$ = ExprBuilder::CreateListNode( $1  ); }  
			  | expr_list ',' expr							 { ((TListNode*)$1)->AddNode( $3 ); $$ = $1; } 


expr:          tFLOAT                                        { $$ = ExprBuilder::CreateConstNode( kAVFloat, $1 ); } 
             | tINT                                          { $$ = ExprBuilder::CreateConstNode( kAVInt, $1 ); } 
             | variable                                         
             | function                                       
             | conditional                                   
             | expr '+' expr                                 { $$ = ExprBuilder::CreateOpNode( '+', $1, $3 );  }         
             | expr '-' expr                                 { $$ = ExprBuilder::CreateOpNode( '-', $1, $3  ); }                 
             | expr '*' expr                                 { $$ = ExprBuilder::CreateOpNode( '*', $1, $3  ); }                 
             | expr '/' expr                                 { $$ = ExprBuilder::CreateOpNode( '/', $1, $3  ); }                 
             | '-' expr  %prec NEG                           { $$ = ExprBuilder::CreateOpNode( '-', $2 ); }                  
             | expr '^' expr                                 { $$ = ExprBuilder::CreateOpNode( '^', $1, $3  ); }                        
             | '(' expr ')'                                  { $$ = $2; } 

data_val:      tFLOAT                                        { $$ = ExprBuilder::CreateConstNode( kAVFloat, $1 ); } 
             | tINT                                          { $$ = ExprBuilder::CreateConstNode( kAVInt, $1 ); } 
			 | data_list                                     { $$ = $1; } 
			 
cond_expr:     expr tRELATION expr                           { $$ = ExprBuilder::CreateCondExpNode( $1, $2, $3  ); } 
			 | expr tEQUAL expr                              { $$ = ExprBuilder::CreateCondExpNode( $1, $2, $3  ); }                   
             | '(' cond_expr ')'                             { $$ = $2; }                                
             | '!' cond_expr  %prec NEG                      { $$ = ExprBuilder::CreateCondExpNode( NULL, kNot, $2 ); }                               
             |   expr                                        { $$ = $1; }                                
						 | cond_expr tRELATION_G cond_expr               { $$ = ExprBuilder::CreateCondExpNode( $1, $2, $3  ); } 
%%





 
