#include "CString.h"
#include "Environ.h"
#include "ExprBuilder.h"
#include "Constructor.h"
int STELLAerror (char* s);
int STELLAlex(void);
int STELLAparse(void);

extern int STELLAleng, STELLAdebug;
extern FILE *STELLAin, *STELLAout;

int main( int argc, char** argv ) {
	int token = 1;
	CString STELLA_file;

	Env::Startup ( argc, argv, Env::kSTELLAP );
	int nfiles = TConstructor::StartUp(argc,argv);
	STELLAout = fopen("parser.out","w");

	
	for( int i=0; i<nfiles; i++ ) {
		TConstructor::SetSTELLAFileName(i, STELLA_file);
		sprintf(gMsgStr,"\nParsing input file: %s\n",STELLA_file.chars());
		gPrintScreen();
		STELLAin = fopen( STELLA_file, "r" );
		if( STELLAin ) {
			STELLAparse ();
			fclose(STELLAin);
		} else gPrintErr( STELLA_file += ": Can't open input file" );
	}

	ExprBuilder::Print(STELLAout);
//	TConstructor::Run();	
}
