%option noyywrap

SPACE   [ \t]*
NAME	[a-zA-Z_]+[a-zA-Z_0-9]*
SNAMES	([$]*[a-zA-Z_]+([a-zA-Z_0-9]|([ ]/[a-zA-Z_]))*)
SNAME	([$]*[a-zA-Z_]+([a-zA-Z_0-9])*)
DIGIT   [0-9]
EXP     [Ee]{SPACE}("-"|"+")*{DIGIT}+
FLOAT   (({DIGIT}+"."{DIGIT}*)|("."{DIGIT}+))({SPACE}{EXP})*
INT     ({DIGIT}+)({SPACE}{EXP})*
NUMBER  {FLOAT}|{INT}
SNUMBER  ("-"|"+")*{NUMBER}
DIRECTION [NSEWUD]+(":"{BC})*
POINT   {SPACE}{SNUMBER}{SPACE}(","{SPACE}{SNUMBER}{SPACE})+(":"{BC})*
RNAME1    {NAME}{SPACE}"@"{SPACE}"("{POINT}")"
RNAME2    {NAME}{SPACE}"@"{SPACE}{DIRECTION}
RNAME    ({RNAME1})|({RNAME2})
GNAME    ({NAME})|({RNAME})
DTARG   "("{SPACE}t{SPACE}")"
DTTARG  "("{SPACE}t{SPACE}-{SPACE}dt{SPACE}")"
NSN     [^a-zA-Z_0-9]+
NS      [^a-zA-Z_]+ 
BC      [S0ZCTPB]		


%s CONDITIONAL
%s GRAPHSPEC
%s GARG
%s POINTLIST
%x COMMENT
%x MAPLIST
%x DOCUMENT
%x DOCEND0
%x DOCEND1

%{

#define YY_DECL int STELLAlex(void)
#define yylval STELLAlval
#define yylex STELLAlex
#define STELLAwrap yywrap

void print_delete();
void copy_edit(const char* from, char* to, int n);
int SME_line_num = 1;
int SME_import_cnt = 0;
int S_current_state;
#define YY_NEVER_INTERACTIVE 1
#include "CString.h"
#include "ExprBuilder.h"
#include "STELLA_parser.h"
extern int STELLAleng;
// extern int STELLAdebug;

%}

%%

^INFLOWS:                  /* ignore */
^OUTFLOWS:                 /* ignore */
^"OUTFLOW FROM:"[^\n]*     /* ignore */

"{"                        S_current_state = YY_START; BEGIN(COMMENT); 
<COMMENT>[^}]*             /* ignore comments */ 
<COMMENT>"}"               BEGIN(S_current_state);
 
^"DOCUMENT:"                S_current_state = YY_START; BEGIN(DOCUMENT); 
<DOCUMENT>[^\n]+            copy_edit(yytext, yylval.str, MAX_NAME_LEN-1);  return tDOC;
<DOCUMENT>"\n"              BEGIN(DOCEND0);
<DOCEND0>[^\n]+              BEGIN(DOCUMENT); copy_edit(yytext, yylval.str, MAX_NAME_LEN-1);  return tDOC; 
<DOCEND0>"\n"                BEGIN(DOCEND1);
<DOCEND1>[^\n]+              BEGIN(DOCUMENT); copy_edit(yytext, yylval.str, MAX_NAME_LEN-1);  return tDOC; 
<DOCEND1>"\n"                BEGIN(S_current_state);

<GRAPHSPEC>\n              BEGIN(POINTLIST); SME_line_num++; 
<POINTLIST>\n              BEGIN(INITIAL); SME_line_num++; 
\n                         SME_line_num++; 
\r                         SME_line_num++; 
\f                         SME_line_num++; 

{SPACE}IF{SPACE}         return tIF;  
{SPACE}THEN{SPACE}       return tTHEN;  
{SPACE}ELSE{SPACE}       return tELSE; 

""             yylval.etype = kLE; return tRELATION; 
""             yylval.etype = kGE; return tRELATION; 
">"           yylval.etype = kGT;  return tRELATION; 
"<"           yylval.etype = kLT;  return tRELATION; 
">="           yylval.etype = kGE;  return tRELATION; 
"<="           yylval.etype = kLE;  return tRELATION; 
""          yylval.etype = kNEq; return tRELATION; 
"&"             yylval.etype = kAnd; return tRELATION_G; 
"|"           yylval.etype = kOr; return tRELATION_G; 
AND           yylval.etype = kAnd; return tRELATION_G; 
NOT           yylval.etype = kNot; return tRELATION_G; 
"!"           yylval.etype = kNot; return tRELATION_G; 
OR            yylval.etype = kOr; return tRELATION_G; 
"="             yylval.etype = kEq; return tEQUAL; 
"!="            yylval.etype = kNEq; return tRELATION; 

GRAPH                          BEGIN(GRAPHSPEC); return tGRAPH;
<GRAPHSPEC>"("                     BEGIN(GARG); return '(';
<GARG>")"                      BEGIN(GRAPHSPEC); return ')';

^SMEvsSTELLA{SPACE}"="[^\n]*  /* ignore */
^.*"(IN SECTOR:".*            /* ignore */

SMEvsSTELLA								 strcpy(yylval.str,"1"); return tINT;

{DTARG}                    return tDTARG;  
{DTTARG}                   return tDTTARG;

^{SNAME}$                  {    Util::ncopyup( yytext, yylval.str, MAX_NAME_LEN-1); 
																return tMODULE;
													 }
^INIT[ \t]+                return tINIT;
{NAME}                     { Util::ncopyup(yytext, yylval.str, MAX_NAME_LEN-1);  return tNAME; }
{RNAME}                    { Util::ncopyup(yytext, yylval.str, MAX_NAME_LEN-1);  return tRNAME; }
''{NAME}                  { Util::ncopyup( yytext, yylval.str, MAX_NAME_LEN-1);
														 Util::replace_prefix(yylval.str,1,"P_", MAX_NAME_LEN); 
														 return tNAME;
													 }
\245{NAME}                 { Util::ncopyup( yytext, yylval.str, MAX_NAME_LEN-1); 
														 Util::replace_prefix(yylval.str,1,"P1_", MAX_NAME_LEN); 
														 return tNAME;
														}
\306{NAME}                 { Util::ncopyup( yytext, yylval.str, MAX_NAME_LEN-1);
														 Util::replace_prefix(yylval.str,1,"P2_", MAX_NAME_LEN); 
														 return tNAME;
													 }
\225{NAME}                 { Util::ncopyup( yytext, yylval.str, MAX_NAME_LEN-1);
														 Util::replace_prefix(yylval.str,1,"P3_", MAX_NAME_LEN); 
														 return tNAME;
													 }
''{RNAME}                  { Util::ncopyup( yytext, yylval.str, MAX_NAME_LEN-1);
														 Util::replace_prefix(yylval.str,1,"P_", MAX_NAME_LEN); 
														 return tRNAME;
													 }
\245{RNAME}                 { Util::ncopyup( yytext, yylval.str, MAX_NAME_LEN-1); 
														 Util::replace_prefix(yylval.str,1,"P1_", MAX_NAME_LEN); 
														 return tRNAME;
														}
\306{RNAME}                 { Util::ncopyup( yytext, yylval.str, MAX_NAME_LEN-1);
														 Util::replace_prefix(yylval.str,1,"P2_", MAX_NAME_LEN); 
														 return tRNAME;
													 }
\225{RNAME}                 { Util::ncopyup( yytext, yylval.str, MAX_NAME_LEN-1);
														 Util::replace_prefix(yylval.str,1,"P3_", MAX_NAME_LEN); 
														 return tRNAME;
													 }
{FLOAT}                    strcpy(yylval.str,yytext); return tFLOAT;
{INT}                      strcpy(yylval.str,yytext); return tINT;

<POINTLIST>{POINT}         strcpy(yylval.str,yytext); return tPOINT;
[\+\-\/\*\^]               return yytext[0];
"("                        return '(';
")"                        return ')';

"["                        S_current_state = YY_START;  BEGIN(MAPLIST); return '[';
<MAPLIST>"]"                 BEGIN(S_current_state); return ']';
<MAPLIST>","								 return ',';
<MAPLIST>"*"								 return '~';
<MAPLIST>{INT}               strcpy(yylval.str,yytext); return tMINT;
<MAPLIST>[ \t]*              /* ignore */
<MAPLIST>{NAME}              { Util::ncopyup(yytext, yylval.str, MAX_NAME_LEN-1);  return tMNAME; }

[ \t\v\b\a]*                /* ignore */
,			                     return ',';

"Not in a sector"          {    sprintf( yylval.str, "XXXImports%d", SME_import_cnt++ ); 
																return tMODULE;
													 }
" "                          /* ignore */
.                          fprintf(stderr,"\nLine %d: Unrecognized character!!: %s\n\n\n",SME_line_num, yytext); return 0; 

%{

#ifndef LEXTEST
#ifdef FLEX_DEBUG
	if(STELLAout==NULL) STELLAout = fopen("lexer.out","w");
#else
	STELLAout = NULL;
#endif
#endif
		
%}

%%

#ifdef LEXTEST

CString STELLAlval;
main( int argc, char** argv ) {
	int token = 1;

	argv++; --argc;

	if( argc > 0 ) {
		STELLAin = fopen( argv[0], "r" ); 
		printf("\nParsing File %s\n",argv[0]); 
	} else {
		STELLAin = stdin; 
	}

	STELLAout = fopen("lexer.out","w");

	while( token != 0 ) { token = STELLAlex(); }

}

#else

int STELLAerror (char* s) {
   printf ("\n\n%s\nLine %d, State: %d, Parsing: %s\n", s, SME_line_num, YY_START, yylval.str );
   return 0;
}	

#endif

void STELLAinitParse(int debug_level) {
	SME_line_num = 1;
#ifdef FLEX_DEBUG
	STELLA_flex_debug = 0;
	if(debug_level > 0) { STELLA_flex_debug = 1; }
  //	STELLAdebug = 0;
  //	if(debug_level > 1) { STELLAdebug = 1; }
#endif
}



void copy_edit(const char* from, char* to, int n) { 
  if (from != to) {
    while (--n >= 0) { 
	  char ch = toupper(*from++);
	  if( ch == 0 ) break;
	  if( ch ==  '\245' ) {
		  *to++ = 'P'; *to++ = '1'; *to++ = '_'; 
	  } else if( ch ==  '\306' ) {
		  *to++ = 'P'; *to++ = '2'; *to++ = '_'; 
	  } else if( ch ==  '\225' ) {
		  *to++ = 'P'; *to++ = '3'; *to++ = '_'; 
	  } else {
		*to++ = ch; 
	  }
    }
    *to = 0;       // copy n bytes or until null, null-terminate, upcase, convert illegal chars;
  }
}

