%{
#include "CString.h"
#include "Environ.h"
#include "ExprBuilder.h"
//#include "Constructor.h"
int yyerror (char* s);
int yylex(void);

%}

/* Parser for STELLA equation file */

%union {
  char str[MAX_NAME_LEN];
  TNode* node;
  ERelationType etype;
}

%token <str> tFLOAT
%token <str> tNAME
%token <str> tRNAME
%token <str> tMNAME
%token <str> tINT
%token <str> tMINT
%token <str> tPOINT
%token <str> tIF
%token <str> tTHEN
%token <str> tELSE
%token <str> tDTARG
%token <str> tDTTARG
%token <str> tMODULE
%token <str> tGRAPH
%token <str> tDOC
%token <str> tINIT
%token <etype> tRELATION
%token <etype> tRELATION_G
%token <etype> tEQUAL

%type <node> module
%type <node> eq_file

%type <node> function
%type <node> conditional
%type <node> variable
%type <node> expr
%type <node> cond_expr
%type <node> update_eq
%type <node> sv_eq
%type <node> init_eq
%type <node> equation
%type <node> graph
%type <node> point_list
%type <node> eq_list
%type <node> expr_list
%type <node> map_list
%type <node> parm_dep
     
%left '-' '+'
%left '*' '/'
%left NEG     /* negation--unary minus */
%right '^'    /* exponentiation        */

%%

eq_file:       module                                        { $$ = ExprBuilder::CreateRootNode( $1  ); }  
             | eq_file module                                {  ((TListNode*)$1)->AddNode( $2 ); $$ = $1; } 
             | eq_list										 { TNode* n = ExprBuilder::CreateModuleNode( Env::ModelName(), (TListNode*) $1 ); 
															   $$ = ExprBuilder::CreateRootNode( n ); 
															 } 
module:        tMODULE eq_list                               { $$ = ExprBuilder::CreateModuleNode( $1, (TListNode*) $2 ); } 
						 | tMODULE							 { $$ = ExprBuilder::CreateModuleNode( $1, (TListNode*) NULL ); } 
function:      tNAME '(' expr_list ')'                       { Util::downcase($1,MAX_NAME_LEN); $$ = ExprBuilder::CreateFuncNode( $1, (TListNode*) $3 ); }

map_list:				    tMNAME                           { $$ = ExprBuilder::CreateStringListNode( $1 ); } 
					  	|	tMINT                            { $$ = ExprBuilder::CreateStringListNode( $1 ); } 
					  	|	'~'                              { $$ = ExprBuilder::CreateStringListNode( "*" ); } 
					  	| map_list ','  tMNAME               { ((TStringListNode*)$1)->AddString($3); $$ = $1; }    
					  	| map_list ','  tMINT                { ((TStringListNode*)$1)->AddString($3); $$ = $1; } 
					  	| map_list ','  '~'                  { ((TStringListNode*)$1)->AddString("*"); $$ = $1; } 
  

parm_dep:            '['  map_list ']'                       { $$ = $2; } 

variable:      tNAME                                         { $$ = ExprBuilder::CreateVarNode( $1 ); } 
						 | tNAME parm_dep                    { $$ = ExprBuilder::CreateVarNode( $1 ); ((TVarNode*)$$)->AddMapList((TStringListNode*)$2); } 
						 | tRNAME   						 { $$ = ExprBuilder::CreateVarNode( $1, True  ); } 
						 | tRNAME parm_dep    				 { $$ = ExprBuilder::CreateVarNode( $1, True  ); ((TVarNode*)$$)->AddMapList((TStringListNode*)$2); } 
						 
conditional:   tIF cond_expr tTHEN expr tELSE expr           { $$ = ExprBuilder::CreateCondNode( $2, $4, $6 ); }   
expr:          tFLOAT                                        { $$ = ExprBuilder::CreateConstNode( kAVFloat, $1 ); } 
             | tINT                                          { $$ = ExprBuilder::CreateConstNode( kAVInt, $1 ); } 
             | variable                                      { $$ =  $1; }
             | function                                      { $$ =  $1; }                                      
             | conditional                                   { $$ =  $1; }                                  
             | expr '+' expr                                 { $$ = ExprBuilder::CreateOpNode( '+', $1, $3 );  }         
             | expr '-' expr                                 { $$ = ExprBuilder::CreateOpNode( '-', $1, $3  ); }                 
             | expr '*' expr                                 { $$ = ExprBuilder::CreateOpNode( '*', $1, $3  ); }                 
             | expr '/' expr                                 { $$ = ExprBuilder::CreateOpNode( '/', $1, $3  ); }                 
             | '-' expr  %prec NEG                           { $$ = ExprBuilder::CreateOpNode( '-', $2 ); }                  
             | expr '^' expr                                 { $$ = ExprBuilder::CreateOpNode( '^', $1, $3  ); }                        
             | '(' expr ')'                                  { $$ = $2; }    
             
cond_expr:     expr tRELATION expr                           { $$ = ExprBuilder::CreateCondExpNode( $1, $2, $3  ); } 
						 | expr tEQUAL expr                              { $$ = ExprBuilder::CreateCondExpNode( $1, $2, $3  ); }                   
 						 |     expr                                      { $$ = $1 }                   
						 | '(' cond_expr ')'                             { $$ = $2; } 
             |  cond_expr  tRELATION_G cond_expr             { $$ = ExprBuilder::CreateCondExpNode( $1, $2, $3  ); }               
             |  tRELATION_G cond_expr                        { if( $1 != kNot ) { STELLAerror ("Conditional expression syntax error, too few args"); }
																															 $$ = ExprBuilder::CreateCondExpNode( NULL, $1, $2  ); }               
update_eq:     variable tEQUAL expr                          { $$ = ExprBuilder::CreateEquationNode( TEquationNode::kUpdate, (TVarNode*) $1, $3  ); } 
             | variable tEQUAL graph                         { $$ = ExprBuilder::CreateEquationNode( TEquationNode::kUpdate, (TVarNode*) $1, $3  ); } 
sv_eq:         variable tDTARG tEQUAL variable tDTTARG '+' '(' expr ')' '*' tNAME    {    
															  $$ = ExprBuilder::CreateEquationNode( TEquationNode::kStateVar, (TVarNode*) $1, $8  );  
															  ExprBuilder::DeleteNode($4); } 

sv_eq:         variable tDTARG tEQUAL variable tDTTARG        { TNode* cn = ExprBuilder::CreateConstNode( kAVFloat, "0.0" );
																$$ = ExprBuilder::CreateEquationNode( TEquationNode::kStateVar, (TVarNode*) $1, cn  );  
																ExprBuilder::DeleteNode($4); } 

init_eq:       tINIT variable tEQUAL expr                    { $$ = ExprBuilder::CreateEquationNode( TEquationNode::kInit, (TVarNode*) $2, $4  ); } 
             | tINIT variable tEQUAL graph                   { $$ = ExprBuilder::CreateEquationNode( TEquationNode::kInit, (TVarNode*) $2, $4  ); } 
equation:      update_eq                                     { $$ =  $1; }                                                           
             | sv_eq                                         { $$ =  $1; }                                                            
             | init_eq                                       { $$ =  $1; } 
equation:    equation tDOC                                   { ((TEquationNode*)$1)->AddDoc($2); $$ =  $1;}                                    
graph:         tGRAPH '(' expr ')' point_list                { $$ = ExprBuilder::CreateGraphNode( $3, (TListNode*) $5 ); }                         
point_list:    '(' tPOINT ')'                                { TNode* n = ExprBuilder::CreatePointNode( $2  );
                                                               $$ = ExprBuilder::CreateListNode( n ); 
                                                             }     
             | point_list ',' '(' tPOINT  ')'                { TNode* n = ExprBuilder::CreatePointNode( $4 );
																															 ((TListNode*)$1)->AddNode( n ); $$ = $1;   
                                                             } 
eq_list:       equation                                      { $$ = ExprBuilder::CreateListNode( $1  ); } 
             | eq_list equation                              { ((TListNode*)$1)->AddNode( $2 ); $$ = $1;  } 
expr_list:     expr                                          { $$ = ExprBuilder::CreateListNode( $1  ); } 
             | expr_list ',' expr                            { ((TListNode*)$1)->AddNode( $3 ); $$ = $1;  }

%%
