#include "HNMD.h"


void gInitializeModel() {
	TModel::I().GlobalMod(&HNMD_module::I());
	HNMD_module::I().Initialize();
	HNMD_module::I().SetMInfo(TModule::kisGlobal,True);
	ETPM_module::I().Initialize();
	PAR_module::I().Initialize();
	MACROPHYTES_module::I().Initialize();
	XXXImports4_module::I().Initialize();
	DOM_module::I().Initialize();
	ZDIN_module::I().Initialize();
	HYDROLOGY_module::I().Initialize();
	GLOBALS_module::I().Initialize();
	HNMD_module::I().MakeConnections();
	ETPM_module::I().MakeConnections();
	PAR_module::I().MakeConnections();
	MACROPHYTES_module::I().MakeConnections();
	XXXImports4_module::I().MakeConnections();
	DOM_module::I().MakeConnections();
	ZDIN_module::I().MakeConnections();
	HYDROLOGY_module::I().MakeConnections();
	GLOBALS_module::I().MakeConnections();
}

// ---------------------------------------------------------------------------
//                    Class HNMD_module 
// ---------------------------------------------------------------------------
HNMD_module::HNMD_module(char* name) :
	TIME("TIME"),
	TModule(name) {

}	
HNMD_module* HNMD_module::fInstance = NULL;
HNMD_module* HNMD_module::kNullModel = (HNMD_module*)0x1;
int HNMD_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int HNMD_module::InitVars() {
	
	TIME.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int HNMD_module::Initialize() {
	InitVars();
	HNMD_module::I().AddSubModule(&ETPM_module::I());
	HNMD_module::I().AddSubModule(&PAR_module::I());
	HNMD_module::I().AddSubModule(&MACROPHYTES_module::I());
	HNMD_module::I().AddSubModule(&XXXImports4_module::I());
	HNMD_module::I().AddSubModule(&DOM_module::I());
	HNMD_module::I().AddSubModule(&ZDIN_module::I());
	HNMD_module::I().AddSubModule(&HYDROLOGY_module::I());
	HNMD_module::I().AddSubModule(&GLOBALS_module::I());
	Model::I0().ModuleList().Alphabetize();
	return 1;
}

int HNMD_module::MakeConnections() {
	ETPM_module::I().VAP_PRESS.Connect(&(GLOBALS_module::I().VAP_PRESS));
	ETPM_module::I().AIR_TEMP_C.Connect(&(GLOBALS_module::I().AIR_TEMP_C));
	ETPM_module::I().SOLRADATM.Connect(&(PAR_module::I().SOLRADATM));
	ETPM_module::I().CLOUDY.Connect(&(GLOBALS_module::I().CLOUDY));
	ETPM_module::I().MACH.Connect(&(MACROPHYTES_module::I().MACH));
	ETPM_module::I().WIND.Connect(&(GLOBALS_module::I().WIND));
	ETPM_module::I().MACLAI.Connect(&(MACROPHYTES_module::I().MACLAI));
	PAR_module::I().P1_C_LATDEG.Connect(&(GLOBALS_module::I().P1_C_LATDEG));
	PAR_module::I().CLOUDY.Connect(&(GLOBALS_module::I().CLOUDY));
	PAR_module::I().DAYJUL.Connect(&(GLOBALS_module::I().DAYJUL));
	MACROPHYTES_module::I().AIR_TEMP_C.Connect(&(GLOBALS_module::I().AIR_TEMP_C));
	MACROPHYTES_module::I().HABITATMAP.Connect(&(GLOBALS_module::I().HABITATMAP));
	MACROPHYTES_module::I().DAYJUL.Connect(&(GLOBALS_module::I().DAYJUL));
	MACROPHYTES_module::I().DAYLENGTH.Connect(&(GLOBALS_module::I().DAYLENGTH));
	MACROPHYTES_module::I().SOLRADGR.Connect(&(XXXImports4_module::I().SOLRADGR));
	MACROPHYTES_module::I().DIN_AVAILABLE.Connect(&(ZDIN_module::I().DIN_AVAILABLE));
	MACROPHYTES_module::I().ELEVATION.Connect(&(GLOBALS_module::I().ELEVATION));
	MACROPHYTES_module::I().SURFACE_WATER.Connect(&(HYDROLOGY_module::I().SURFACE_WATER));
	MACROPHYTES_module::I().UW_DEPTH.Connect(&(HYDROLOGY_module::I().UW_DEPTH));
	MACROPHYTES_module::I().WATER_AVAIL.Connect(&(HYDROLOGY_module::I().WATER_AVAIL));
	XXXImports4_module::I().DAYJUL.Connect(&(GLOBALS_module::I().DAYJUL));
	DOM_module::I().PHBIO_MORT.Connect(&(MACROPHYTES_module::I().PHBIO_MORT));
	DOM_module::I().PHBIO_HARVEST.Connect(&(MACROPHYTES_module::I().PHBIO_HARVEST));
	DOM_module::I().NPHBIO_MORT.Connect(&(MACROPHYTES_module::I().NPHBIO_MORT));
	DOM_module::I().NPHBIO_HARVEST.Connect(&(MACROPHYTES_module::I().NPHBIO_HARVEST));
	DOM_module::I().AIR_TEMP_C.Connect(&(GLOBALS_module::I().AIR_TEMP_C));
	ZDIN_module::I().DAYJUL.Connect(&(GLOBALS_module::I().DAYJUL));
	ZDIN_module::I().SAT_WATER.Connect(&(HYDROLOGY_module::I().SAT_WATER));
	ZDIN_module::I().UNSAT_WATER.Connect(&(HYDROLOGY_module::I().UNSAT_WATER));
	ZDIN_module::I().UW_FROM_PRECIP.Connect(&(HYDROLOGY_module::I().UW_FROM_PRECIP));
	ZDIN_module::I().SW_TO_SATW_DOWNFLOW.Connect(&(HYDROLOGY_module::I().SW_TO_SATW_DOWNFLOW));
	ZDIN_module::I().SATW_FROM_PRECIP.Connect(&(HYDROLOGY_module::I().SATW_FROM_PRECIP));
	ZDIN_module::I().CELL_SIZE.Connect(&(GLOBALS_module::I().CELL_SIZE));
	ZDIN_module::I().AIR_TEMP_C.Connect(&(GLOBALS_module::I().AIR_TEMP_C));
	ZDIN_module::I().SATW_TO_SW_UPFLOW.Connect(&(HYDROLOGY_module::I().SATW_TO_SW_UPFLOW));
	ZDIN_module::I().PHBIO_NPP.Connect(&(MACROPHYTES_module::I().PHBIO_NPP));
	ZDIN_module::I().UW_DEPTH.Connect(&(HYDROLOGY_module::I().UW_DEPTH));
	ZDIN_module::I().ELEVATION.Connect(&(GLOBALS_module::I().ELEVATION));
	ZDIN_module::I().SATW_OUTFLUX.Connect(&(HYDROLOGY_module::I().SATW_OUTFLUX));
	ZDIN_module::I().SW_OUTFLUX.Connect(&(HYDROLOGY_module::I().SW_OUTFLUX));
	ZDIN_module::I().HABITATMAP.Connect(&(GLOBALS_module::I().HABITATMAP));
	ZDIN_module::I().ROOT_DEPTH.Connect(&(MACROPHYTES_module::I().ROOT_DEPTH));
	ZDIN_module::I().SURFACE_WATER.Connect(&(HYDROLOGY_module::I().SURFACE_WATER));
	ZDIN_module::I().D_DECOMP.Connect(&(DOM_module::I().D_DECOMP));
	ZDIN_module::I().SATW_TRANSP.Connect(&(HYDROLOGY_module::I().SATW_TRANSP));
	ZDIN_module::I().UW_ETRANSP.Connect(&(HYDROLOGY_module::I().UW_ETRANSP));
	HYDROLOGY_module::I().ON_MAP.Connect(&(GLOBALS_module::I().ON_MAP));
	HYDROLOGY_module::I().DIN_SD.Connect(&(ZDIN_module::I().DIN_SD));
	HYDROLOGY_module::I().HABITATMAP.Connect(&(GLOBALS_module::I().HABITATMAP));
	HYDROLOGY_module::I().AIR_TEMP_C.Connect(&(GLOBALS_module::I().AIR_TEMP_C));
	HYDROLOGY_module::I().PRECIP_M.Connect(&(GLOBALS_module::I().PRECIP_M));
	HYDROLOGY_module::I().HYDRO.Connect(&(GLOBALS_module::I().HYDRO));
	HYDROLOGY_module::I().ELEVATION.Connect(&(GLOBALS_module::I().ELEVATION));
	HYDROLOGY_module::I().DIN_SF.Connect(&(ZDIN_module::I().DIN_SF));
	HYDROLOGY_module::I().SOLRADGRD.Connect(&(PAR_module::I().SOLRADGRD));
	HYDROLOGY_module::I().MACLAI.Connect(&(MACROPHYTES_module::I().MACLAI));
	HYDROLOGY_module::I().CELL_SIZE.Connect(&(GLOBALS_module::I().CELL_SIZE));
	HYDROLOGY_module::I().SOIL.Connect(&(GLOBALS_module::I().SOIL));
	HYDROLOGY_module::I().HUMIDITY.Connect(&(GLOBALS_module::I().HUMIDITY));
	HYDROLOGY_module::I().WIND.Connect(&(GLOBALS_module::I().WIND));
	HYDROLOGY_module::I().A_IN.Connect(&(ZDIN_module::I().A_IN));
	HYDROLOGY_module::I().ELEV_MIN.Connect(&(GLOBALS_module::I().ELEV_MIN));
	HYDROLOGY_module::I().ETPM.Connect(&(ETPM_module::I().ETPM));
	HYDROLOGY_module::I().ROOT_DEPTH.Connect(&(MACROPHYTES_module::I().ROOT_DEPTH));
	HYDROLOGY_module::I().P1_DATUM_TO_MSL.Connect(&(GLOBALS_module::I().P1_DATUM_TO_MSL));
	GLOBALS_module::I().SOLRADATM.Connect(&(PAR_module::I().SOLRADATM));
	GLOBALS_module::I().SOLRADGRD.Connect(&(PAR_module::I().SOLRADGRD));
	MACROPHYTES_module::I().SOLRADGR.Connect(&(XXXImports4_module::I().SOLRADGR));
	XXXImports4_module::I().DAYJUL.Connect(&(GLOBALS_module::I().DAYJUL));
	return 0;
}

int HNMD_module::SetupEvents() {
	return 0;
}

int HNMD_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int HNMD_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int HNMD_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int HNMD_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

int HNMD_module::PostInit() {
	PostEventsByType(TEvent::kInit);
	return 1;
}

// ---------------------------------------------------------------------------
//                    Class ETPM_module 
// ---------------------------------------------------------------------------
ETPM_module::ETPM_module(char* name) :
	TIME("TIME"),
	VAP_PRESS("VAP_PRESS"),
	AIR_TEMP_C("AIR_TEMP_C"),
	SOLRADATM("SOLRADATM"),
	CLOUDY("CLOUDY"),
	MACH("MACH"),
	WIND("WIND"),
	MACLAI("MACLAI"),
	ETPM("ETPM"),
	D("D"),
	DELTA("DELTA"),
	ENERGY("ENERGY"),
	ES("ES"),
	GAMMA("GAMMA"),
	LAMBDA("LAMBDA"),
	P("P"),
	RA("RA"),
	RO("RO"),
	RS("RS"),
	TModule(name) {

	VAP_PRESS.SetF(FisImport,True,"CG");
	AIR_TEMP_C.SetF(FisImport,True,"CG");
	SOLRADATM.SetF(FisImport,True,"CG");
	CLOUDY.SetF(FisImport,True,"CG");
	MACH.SetF(FisImport,True,"CG");
	WIND.SetF(FisImport,True,"CG");
	MACLAI.SetF(FisImport,True,"CG");
	ETPM.SetF(FisExport,True,"CG");
}	
int ETPM_module::D_u0_exe() {
	float value;

	switch( D.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = D.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ES.Value(p)-( VAP_PRESS.Value(p)/1000 ) );
			D.Update( p, value );
		}
		D.GrabMemory();
		if( D.GetF(FLinkEdges) ) { D.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ES.Value()-( VAP_PRESS.Value()/1000 ) );
			D.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::DELTA_u1_exe() {
	float value;

	switch( DELTA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DELTA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ((float)4098)*ES.Value(p) )/( 237.3+AIR_TEMP_C.Value(p) ) )/( 237.3+AIR_TEMP_C.Value(p) ) );
			DELTA.Update( p, value );
		}
		DELTA.GrabMemory();
		if( DELTA.GetF(FLinkEdges) ) { DELTA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ((float)4098)*ES.Value() )/( 237.3+AIR_TEMP_C.Value() ) )/( 237.3+AIR_TEMP_C.Value() ) );
			DELTA.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::ENERGY_u2_exe() {
	float value;

	switch( ENERGY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ENERGY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( SOLRADATM.Value(p)/23.9 )*( 0.25+( ( 0.5*( ((float)10)-CLOUDY.Value(p) ) )/10 ) ) )-( ( ( ( ( ( ( 0.9*( ((float)10)-CLOUDY.Value(p) ) )/10 )+0.1 )*( 0.34-( 0.14*SL::Sqrt(VAP_PRESS.Value(p)) ) ) )*4.903 )*pow((double)((float)10),(double)-((float)9) ) )*pow((double)AIR_TEMP_C.Value(p),(double)((float)4) ) ) );
			ENERGY.Update( p, value );
		}
		ENERGY.GrabMemory();
		if( ENERGY.GetF(FLinkEdges) ) { ENERGY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( SOLRADATM.Value()/23.9 )*( 0.25+( ( 0.5*( ((float)10)-CLOUDY.Value() ) )/10 ) ) )-( ( ( ( ( ( ( 0.9*( ((float)10)-CLOUDY.Value() ) )/10 )+0.1 )*( 0.34-( 0.14*SL::Sqrt(VAP_PRESS.Value()) ) ) )*4.903 )*pow((double)((float)10),(double)-((float)9) ) )*pow((double)AIR_TEMP_C.Value(),(double)((float)4) ) ) );
			ENERGY.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::ES_u3_exe() {
	float value;

	switch( ES.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ES.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( 0.6108*SL::Exp(( ( 17.27*AIR_TEMP_C.Value(p) )/( 237.3+AIR_TEMP_C.Value(p) ) )) );
			ES.Update( p, value );
		}
		ES.GrabMemory();
		if( ES.GetF(FLinkEdges) ) { ES.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( 0.6108*SL::Exp(( ( 17.27*AIR_TEMP_C.Value() )/( 237.3+AIR_TEMP_C.Value() ) )) );
			ES.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::ETPM_u4_exe() {
	float value;

	switch( ETPM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ETPM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( DELTA.Value(p)*ENERGY.Value(p) )+( ( ( 1.013*RO.Value(p) )*D.Value(p) )/RA.Value(p) ) )/( DELTA.Value(p)+( GAMMA.Value(p)*( ((float)1)+( RS.Value(p)/RA.Value(p) ) ) ) ) )/LAMBDA.Value(p) )/1000 );
			ETPM.Update( p, value );
		}
		ETPM.GrabMemory();
		if( ETPM.GetF(FLinkEdges) ) { ETPM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( DELTA.Value()*ENERGY.Value() )+( ( ( 1.013*RO.Value() )*D.Value() )/RA.Value() ) )/( DELTA.Value()+( GAMMA.Value()*( ((float)1)+( RS.Value()/RA.Value() ) ) ) ) )/LAMBDA.Value() )/1000 );
			ETPM.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::GAMMA_u5_exe() {
	float value;

	switch( GAMMA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = GAMMA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( 0.0016286*P.Value(p) )/LAMBDA.Value(p) );
			GAMMA.Update( p, value );
		}
		GAMMA.GrabMemory();
		if( GAMMA.GetF(FLinkEdges) ) { GAMMA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( 0.0016286*P.Value() )/LAMBDA.Value() );
			GAMMA.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::LAMBDA_u6_exe() {
	float value;

	switch( LAMBDA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LAMBDA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( 2.501-( 0.002361*( AIR_TEMP_C.Value(p)-((float)3) ) ) );
			LAMBDA.Update( p, value );
		}
		LAMBDA.GrabMemory();
		if( LAMBDA.GetF(FLinkEdges) ) { LAMBDA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( 2.501-( 0.002361*( AIR_TEMP_C.Value()-((float)3) ) ) );
			LAMBDA.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::P_u7_exe() {
	float value;

	switch( P.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  101.300003;
			P.Update( p, P.ParameterValue(value,p) );
		}
		P.GrabMemory();
		if( P.GetF(FLinkEdges) ) { P.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  101.300003;
			P.Update( P.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ETPM_module::RA_u8_exe() {
	float value;

	switch( RA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = RA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( MACH.Value(p) >  0.001 ) ) ? ( ( ( ( ( ( SL::Logn(( ( ( ((float)25)/MACH.Value(p) )-0.67 )/0.123 ))*SL::Logn(( ( ( ((float)25)/MACH.Value(p) )-0.67 )/0.0123 )) )/0.41 )/0.41 )/WIND.Value(p) )/3.6 ) ) : ( pow((double)((float)10),(double)((float)10) ) ) ) ;
			RA.Update( p, value );
		}
		RA.GrabMemory();
		if( RA.GetF(FLinkEdges) ) { RA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( MACH.Value() >  0.001 ) ) ? ( ( ( ( ( ( SL::Logn(( ( ( ((float)25)/MACH.Value() )-0.67 )/0.123 ))*SL::Logn(( ( ( ((float)25)/MACH.Value() )-0.67 )/0.0123 )) )/0.41 )/0.41 )/WIND.Value() )/3.6 ) ) : ( pow((double)((float)10),(double)((float)10) ) ) ) ;
			RA.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::RO_u9_exe() {
	float value;

	switch( RO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = RO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( 3.486*P.Value(p) )/( ((float)275)+AIR_TEMP_C.Value(p) ) );
			RO.Update( p, value );
		}
		RO.GrabMemory();
		if( RO.GetF(FLinkEdges) ) { RO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( 3.486*P.Value() )/( ((float)275)+AIR_TEMP_C.Value() ) );
			RO.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::RS_u10_exe() {
	float value;

	switch( RS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = RS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( MACLAI.Value(p) >  0.01 ) ) ? ( ( ((float)4)/MACLAI.Value(p) ) ) : ( pow((double)((float)10),(double)((float)10) ) ) ) ;
			RS.Update( p, value );
		}
		RS.GrabMemory();
		if( RS.GetF(FLinkEdges) ) { RS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( MACLAI.Value() >  0.01 ) ) ? ( ( ((float)4)/MACLAI.Value() ) ) : ( pow((double)((float)10),(double)((float)10) ) ) ) ;
			RS.Update( value );
	  } break;
	}
	return 0;
}

ETPM_module* ETPM_module::fInstance = NULL;
ETPM_module* ETPM_module::kNullModel = (ETPM_module*)0x1;
int ETPM_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int ETPM_module::InitVars() {
	
	TIME.SSInit(this);
	VAP_PRESS.SSInit(this);
	AIR_TEMP_C.SSInit(this);
	SOLRADATM.SSInit(this);
	CLOUDY.SSInit(this);
	MACH.SSInit(this);
	WIND.SSInit(this);
	MACLAI.SSInit(this);
	ETPM.SSInit(this);
	D.SSInit(this);
	DELTA.SSInit(this);
	ENERGY.SSInit(this);
	ES.SSInit(this);
	GAMMA.SSInit(this);
	LAMBDA.SSInit(this);
	P.SSInit(this);
	RA.SSInit(this);
	RO.SSInit(this);
	RS.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int ETPM_module::SetupEvents() {
	TImportCommand* VAP_PRESS_import = (TImportCommand*) VAP_PRESS.GetCommand("VAP_PRESS_import",TCommand::kUndefined,TCommand::kImport);
	VAP_PRESS_import->Code() = "Import VAP_PRESS from GLOBALS_module";
	VAP_PRESS_import->AddDependency(VAP_PRESS);
	VAP_PRESS_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* AIR_TEMP_C_import = (TImportCommand*) AIR_TEMP_C.GetCommand("AIR_TEMP_C_import",TCommand::kUndefined,TCommand::kImport);
	AIR_TEMP_C_import->Code() = "Import AIR_TEMP_C from GLOBALS_module";
	AIR_TEMP_C_import->AddDependency(AIR_TEMP_C);
	AIR_TEMP_C_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SOLRADATM_import = (TImportCommand*) SOLRADATM.GetCommand("SOLRADATM_import",TCommand::kUndefined,TCommand::kImport);
	SOLRADATM_import->Code() = "Import SOLRADATM from PAR_module";
	SOLRADATM_import->AddDependency(SOLRADATM);
	SOLRADATM_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CLOUDY_import = (TImportCommand*) CLOUDY.GetCommand("CLOUDY_import",TCommand::kUndefined,TCommand::kImport);
	CLOUDY_import->Code() = "Import CLOUDY from GLOBALS_module";
	CLOUDY_import->AddDependency(CLOUDY);
	CLOUDY_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* MACH_import = (TImportCommand*) MACH.GetCommand("MACH_import",TCommand::kUndefined,TCommand::kImport);
	MACH_import->Code() = "Import MACH from MACROPHYTES_module";
	MACH_import->AddDependency(MACH);
	MACH_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* WIND_import = (TImportCommand*) WIND.GetCommand("WIND_import",TCommand::kUndefined,TCommand::kImport);
	WIND_import->Code() = "Import WIND from GLOBALS_module";
	WIND_import->AddDependency(WIND);
	WIND_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* MACLAI_import = (TImportCommand*) MACLAI.GetCommand("MACLAI_import",TCommand::kUndefined,TCommand::kImport);
	MACLAI_import->Code() = "Import MACLAI from MACROPHYTES_module";
	MACLAI_import->AddDependency(MACLAI);
	MACLAI_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u4 = (TExecuteCommand*) ETPM.GetCommand("u4",TCommand::kUpdate,TCommand::kCode);
	u4->SetExecutable(&ETPM_u4_exe_g);
	u4->Code() = "u4 <- ( ( ( ( ( DELTA*ENERGY )+( ( ( 1.013*RO )*D )/RA ) )/( DELTA+( GAMMA*( ((float)1)+( RS/RA ) ) ) ) )/LAMBDA )/1000 )";
	u4->AddDependency(DELTA);
	u4->AddDependency(ENERGY);
	u4->AddDependency(RO);
	u4->AddDependency(D);
	u4->AddDependency(RA);
	u4->AddDependency(GAMMA);
	u4->AddDependency(RS);
	u4->AddDependency(LAMBDA);
	u4->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u0 = (TExecuteCommand*) D.GetCommand("u0",TCommand::kUpdate,TCommand::kCode);
	u0->SetExecutable(&D_u0_exe_g);
	u0->Code() = "u0 <- ( ES-( VAP_PRESS/1000 ) )";
	u0->AddDependency(ES);
	u0->AddDependency(VAP_PRESS);
	u0->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u1 = (TExecuteCommand*) DELTA.GetCommand("u1",TCommand::kUpdate,TCommand::kCode);
	u1->SetExecutable(&DELTA_u1_exe_g);
	u1->Code() = "u1 <- ( ( ( ((float)4098)*ES )/( 237.3+AIR_TEMP_C ) )/( 237.3+AIR_TEMP_C ) )";
	u1->AddDependency(ES);
	u1->AddDependency(AIR_TEMP_C);
	u1->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u2 = (TExecuteCommand*) ENERGY.GetCommand("u2",TCommand::kUpdate,TCommand::kCode);
	u2->SetExecutable(&ENERGY_u2_exe_g);
	u2->Code() = "u2 <- ( ( ( SOLRADATM/23.9 )*( 0.25+( ( 0.5*( ((float)10)-CLOUDY ) )/10 ) ) )-( ( ( ( ( ( ( 0.9*( ((float)10)-CLOUDY ) )/10 )+0.1 )*( 0.34-( 0.14*SL::Sqrt(VAP_PRESS) ) ) )*4.903 )*pow((double)((float)10),(double)-((float)9) ) )*pow((double)AIR_TEMP_C,(double)((float)4) ) ) )";
	u2->AddDependency(SOLRADATM);
	u2->AddDependency(CLOUDY);
	u2->AddDependency(VAP_PRESS);
	u2->AddDependency(AIR_TEMP_C);
	u2->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u3 = (TExecuteCommand*) ES.GetCommand("u3",TCommand::kUpdate,TCommand::kCode);
	u3->SetExecutable(&ES_u3_exe_g);
	u3->Code() = "u3 <- ( 0.6108*SL::Exp(( ( 17.27*AIR_TEMP_C )/( 237.3+AIR_TEMP_C ) )) )";
	u3->AddDependency(AIR_TEMP_C);
	u3->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u5 = (TExecuteCommand*) GAMMA.GetCommand("u5",TCommand::kUpdate,TCommand::kCode);
	u5->SetExecutable(&GAMMA_u5_exe_g);
	u5->Code() = "u5 <- ( ( 0.0016286*P )/LAMBDA )";
	u5->AddDependency(P);
	u5->AddDependency(LAMBDA);
	u5->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u6 = (TExecuteCommand*) LAMBDA.GetCommand("u6",TCommand::kUpdate,TCommand::kCode);
	u6->SetExecutable(&LAMBDA_u6_exe_g);
	u6->Code() = "u6 <- ( 2.501-( 0.002361*( AIR_TEMP_C-((float)3) ) ) )";
	u6->AddDependency(AIR_TEMP_C);
	u6->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u7 = (TExecuteCommand*) P.GetCommand("u7",TCommand::kUpdate,TCommand::kCode);
	u7->SetExecutable(&P_u7_exe_g);
	u7->Code() = "u7 <- 101.300003";
	u7->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u8 = (TExecuteCommand*) RA.GetCommand("u8",TCommand::kUpdate,TCommand::kCode);
	u8->SetExecutable(&RA_u8_exe_g);
	u8->Code() = "u8 <-  ( ( ( MACH >  0.001 ) ) ? ( ( ( ( ( ( SL::Logn(( ( ( ((float)25)/MACH )-0.67 )/0.123 ))*SL::Logn(( ( ( ((float)25)/MACH )-0.67 )/0.0123 )) )/0.41 )/0.41 )/WIND )/3.6 ) ) : ( pow((double)((float)10),(double)((float)10) ) ) ) ";
	u8->AddDependency(MACH);
	u8->AddDependency(WIND);
	u8->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u9 = (TExecuteCommand*) RO.GetCommand("u9",TCommand::kUpdate,TCommand::kCode);
	u9->SetExecutable(&RO_u9_exe_g);
	u9->Code() = "u9 <- ( ( 3.486*P )/( ((float)275)+AIR_TEMP_C ) )";
	u9->AddDependency(P);
	u9->AddDependency(AIR_TEMP_C);
	u9->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u10 = (TExecuteCommand*) RS.GetCommand("u10",TCommand::kUpdate,TCommand::kCode);
	u10->SetExecutable(&RS_u10_exe_g);
	u10->Code() = "u10 <-  ( ( ( MACLAI >  0.01 ) ) ? ( ( ((float)4)/MACLAI ) ) : ( pow((double)((float)10),(double)((float)10) ) ) ) ";
	u10->AddDependency(MACLAI);
	u10->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int ETPM_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int ETPM_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int ETPM_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int ETPM_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class PAR_module 
// ---------------------------------------------------------------------------
PAR_module::PAR_module(char* name) :
	TIME("TIME"),
	SOLRADATM("SOLRADATM"),
	P1_C_LATDEG("P1_C_LATDEG"),
	CLOUDY("CLOUDY"),
	DAYJUL("DAYJUL"),
	SOLRADGRD("SOLRADGRD"),
	A("A"),
	ALPHA("ALPHA"),
	B("B"),
	BETTA("BETTA"),
	C("C"),
	T_RAD("T_RAD"),
	TModule(name) {

	SOLRADATM.SetF(FisExport,True,"CG");
	P1_C_LATDEG.SetF(FisImport,True,"CG");
	CLOUDY.SetF(FisImport,True,"CG");
	DAYJUL.SetF(FisImport,True,"CG");
	SOLRADGRD.SetF(FisExport,True,"CG");
}	
int PAR_module::A_u19_exe() {
	float value;

	switch( A.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = A.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)942)-( 6.68*P1_C_LATDEG.Value(p) ) );
			A.Update( p, value );
		}
		A.GrabMemory();
		if( A.GetF(FLinkEdges) ) { A.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)942)-( 6.68*P1_C_LATDEG.Value() ) );
			A.Update( value );
	  } break;
	}
	return 0;
}

int PAR_module::ALPHA_u20_exe() {
	float value;

	switch( ALPHA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ALPHA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( 32.9835-( 64.884*( ((float)1)-( 1.3614*SL::Cos(( ( ( SL::Int(P1_C_LATDEG.Value(p))+( ( P1_C_LATDEG.Value(p)-SL::Int(P1_C_LATDEG.Value(p)) )*1.16666667 ) )*3.141590 )/180 )) ) ) ) );
			ALPHA.Update( p, value );
		}
		ALPHA.GrabMemory();
		if( ALPHA.GetF(FLinkEdges) ) { ALPHA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( 32.9835-( 64.884*( ((float)1)-( 1.3614*SL::Cos(( ( ( SL::Int(P1_C_LATDEG.Value())+( ( P1_C_LATDEG.Value()-SL::Int(P1_C_LATDEG.Value()) )*1.16666667 ) )*3.141590 )/180 )) ) ) ) );
			ALPHA.Update( value );
	  } break;
	}
	return 0;
}

int PAR_module::B_u21_exe() {
	float value;

	switch( B.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = B.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)147)*pow((double)( P1_C_LATDEG.Value(p)-17.48 ),(double)0.27 ) );
			B.Update( p, value );
		}
		B.GrabMemory();
		if( B.GetF(FLinkEdges) ) { B.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)147)*pow((double)( P1_C_LATDEG.Value()-17.48 ),(double)0.27 ) );
			B.Update( value );
	  } break;
	}
	return 0;
}

int PAR_module::BETTA_u22_exe() {
	float value;

	switch( BETTA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = BETTA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( 0.715-( 0.3183*( ((float)1)-( 1.3614*SL::Cos(( ( ( SL::Int(P1_C_LATDEG.Value(p))+( ( P1_C_LATDEG.Value(p)-SL::Int(P1_C_LATDEG.Value(p)) )*1.16666667 ) )*3.141590 )/180 )) ) ) ) );
			BETTA.Update( p, value );
		}
		BETTA.GrabMemory();
		if( BETTA.GetF(FLinkEdges) ) { BETTA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( 0.715-( 0.3183*( ((float)1)-( 1.3614*SL::Cos(( ( ( SL::Int(P1_C_LATDEG.Value())+( ( P1_C_LATDEG.Value()-SL::Int(P1_C_LATDEG.Value()) )*1.16666667 ) )*3.141590 )/180 )) ) ) ) );
			BETTA.Update( value );
	  } break;
	}
	return 0;
}

int PAR_module::C_u23_exe() {
	float value;

	switch( C.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = C.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)175)-( 3.6*P1_C_LATDEG.Value(p) ) );
			C.Update( p, value );
		}
		C.GrabMemory();
		if( C.GetF(FLinkEdges) ) { C.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)175)-( 3.6*P1_C_LATDEG.Value() ) );
			C.Update( value );
	  } break;
	}
	return 0;
}

int PAR_module::SOLRADATM_u24_exe() {
	float value;

	switch( SOLRADATM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SOLRADATM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( A.Value(p)+( B.Value(p)*SL::Cos(T_RAD.Value(p)) ) )+( C.Value(p)*pow((double)SL::Sin(T_RAD.Value(p)),(double)((float)2) ) ) );
			SOLRADATM.Update( p, value );
		}
		SOLRADATM.GrabMemory();
		if( SOLRADATM.GetF(FLinkEdges) ) { SOLRADATM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( A.Value()+( B.Value()*SL::Cos(T_RAD.Value()) ) )+( C.Value()*pow((double)SL::Sin(T_RAD.Value()),(double)((float)2) ) ) );
			SOLRADATM.Update( value );
	  } break;
	}
	return 0;
}

int PAR_module::SOLRADGRD_u25_exe() {
	float value;

	switch( SOLRADGRD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SOLRADGRD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SOLRADATM.Value(p)*( BETTA.Value(p)-( 0.0326*CLOUDY.Value(p) ) ) )-ALPHA.Value(p) );
			SOLRADGRD.Update( p, value );
		}
		SOLRADGRD.GrabMemory();
		if( SOLRADGRD.GetF(FLinkEdges) ) { SOLRADGRD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SOLRADATM.Value()*( BETTA.Value()-( 0.0326*CLOUDY.Value() ) ) )-ALPHA.Value() );
			SOLRADGRD.Update( value );
	  } break;
	}
	return 0;
}

int PAR_module::T_RAD_u26_exe() {
	float value;

	switch( T_RAD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = T_RAD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ((float)2)/365 )*3.141590 )*( DAYJUL.Value(p)-((float)173) ) );
			T_RAD.Update( p, value );
		}
		T_RAD.GrabMemory();
		if( T_RAD.GetF(FLinkEdges) ) { T_RAD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ((float)2)/365 )*3.141590 )*( DAYJUL.Value()-((float)173) ) );
			T_RAD.Update( value );
	  } break;
	}
	return 0;
}

PAR_module* PAR_module::fInstance = NULL;
PAR_module* PAR_module::kNullModel = (PAR_module*)0x1;
int PAR_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int PAR_module::InitVars() {
	
	TIME.SSInit(this);
	SOLRADATM.SSInit(this);
	P1_C_LATDEG.SSInit(this);
	CLOUDY.SSInit(this);
	DAYJUL.SSInit(this);
	SOLRADGRD.SSInit(this);
	A.SSInit(this);
	ALPHA.SSInit(this);
	B.SSInit(this);
	BETTA.SSInit(this);
	C.SSInit(this);
	T_RAD.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int PAR_module::SetupEvents() {
	TExecuteCommand* u24 = (TExecuteCommand*) SOLRADATM.GetCommand("u24",TCommand::kUpdate,TCommand::kCode);
	u24->SetExecutable(&SOLRADATM_u24_exe_g);
	u24->Code() = "u24 <- ( ( A+( B*SL::Cos(T_RAD) ) )+( C*pow((double)SL::Sin(T_RAD),(double)((float)2) ) ) )";
	u24->AddDependency(A);
	u24->AddDependency(B);
	u24->AddDependency(T_RAD);
	u24->AddDependency(C);
	u24->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_C_LATDEG_import = (TImportCommand*) P1_C_LATDEG.GetCommand("P1_C_LATDEG_import",TCommand::kUndefined,TCommand::kImport);
	P1_C_LATDEG_import->Code() = "Import P1_C_LATDEG from GLOBALS_module";
	P1_C_LATDEG_import->AddDependency(P1_C_LATDEG);
	P1_C_LATDEG_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CLOUDY_import = (TImportCommand*) CLOUDY.GetCommand("CLOUDY_import",TCommand::kUndefined,TCommand::kImport);
	CLOUDY_import->Code() = "Import CLOUDY from GLOBALS_module";
	CLOUDY_import->AddDependency(CLOUDY);
	CLOUDY_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DAYJUL_import = (TImportCommand*) DAYJUL.GetCommand("DAYJUL_import",TCommand::kUndefined,TCommand::kImport);
	DAYJUL_import->Code() = "Import DAYJUL from GLOBALS_module";
	DAYJUL_import->AddDependency(DAYJUL);
	DAYJUL_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u25 = (TExecuteCommand*) SOLRADGRD.GetCommand("u25",TCommand::kUpdate,TCommand::kCode);
	u25->SetExecutable(&SOLRADGRD_u25_exe_g);
	u25->Code() = "u25 <- ( ( SOLRADATM*( BETTA-( 0.0326*CLOUDY ) ) )-ALPHA )";
	u25->AddDependency(SOLRADATM);
	u25->AddDependency(BETTA);
	u25->AddDependency(CLOUDY);
	u25->AddDependency(ALPHA);
	u25->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u19 = (TExecuteCommand*) A.GetCommand("u19",TCommand::kUpdate,TCommand::kCode);
	u19->SetExecutable(&A_u19_exe_g);
	u19->Code() = "u19 <- ( ((float)942)-( 6.68*P1_C_LATDEG ) )";
	u19->AddDependency(P1_C_LATDEG);
	u19->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u20 = (TExecuteCommand*) ALPHA.GetCommand("u20",TCommand::kUpdate,TCommand::kCode);
	u20->SetExecutable(&ALPHA_u20_exe_g);
	u20->Code() = "u20 <- ( 32.9835-( 64.884*( ((float)1)-( 1.3614*SL::Cos(( ( ( SL::Int(P1_C_LATDEG)+( ( P1_C_LATDEG-SL::Int(P1_C_LATDEG) )*1.16666667 ) )*3.141590 )/180 )) ) ) ) )";
	u20->AddDependency(P1_C_LATDEG);
	u20->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u21 = (TExecuteCommand*) B.GetCommand("u21",TCommand::kUpdate,TCommand::kCode);
	u21->SetExecutable(&B_u21_exe_g);
	u21->Code() = "u21 <- ( ((float)147)*pow((double)( P1_C_LATDEG-17.48 ),(double)0.27 ) )";
	u21->AddDependency(P1_C_LATDEG);
	u21->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u22 = (TExecuteCommand*) BETTA.GetCommand("u22",TCommand::kUpdate,TCommand::kCode);
	u22->SetExecutable(&BETTA_u22_exe_g);
	u22->Code() = "u22 <- ( 0.715-( 0.3183*( ((float)1)-( 1.3614*SL::Cos(( ( ( SL::Int(P1_C_LATDEG)+( ( P1_C_LATDEG-SL::Int(P1_C_LATDEG) )*1.16666667 ) )*3.141590 )/180 )) ) ) ) )";
	u22->AddDependency(P1_C_LATDEG);
	u22->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u23 = (TExecuteCommand*) C.GetCommand("u23",TCommand::kUpdate,TCommand::kCode);
	u23->SetExecutable(&C_u23_exe_g);
	u23->Code() = "u23 <- ( ((float)175)-( 3.6*P1_C_LATDEG ) )";
	u23->AddDependency(P1_C_LATDEG);
	u23->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u26 = (TExecuteCommand*) T_RAD.GetCommand("u26",TCommand::kUpdate,TCommand::kCode);
	u26->SetExecutable(&T_RAD_u26_exe_g);
	u26->Code() = "u26 <- ( ( ( ((float)2)/365 )*3.141590 )*( DAYJUL-((float)173) ) )";
	u26->AddDependency(DAYJUL);
	u26->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int PAR_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int PAR_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int PAR_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int PAR_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class MACROPHYTES_module 
// ---------------------------------------------------------------------------
MACROPHYTES_module::MACROPHYTES_module(char* name) :
	TIME("TIME"),
	MACH("MACH"),
	MACLAI("MACLAI"),
	AIR_TEMP_C("AIR_TEMP_C"),
	HABITATMAP("HABITATMAP"),
	DAYJUL("DAYJUL"),
	DAYLENGTH("DAYLENGTH"),
	DIN_AVAILABLE("DIN_AVAILABLE"),
	ELEVATION("ELEVATION"),
	SURFACE_WATER("SURFACE_WATER"),
	UW_DEPTH("UW_DEPTH"),
	WATER_AVAIL("WATER_AVAIL"),
	PHBIO_MORT("PHBIO_MORT"),
	PHBIO_HARVEST("PHBIO_HARVEST"),
	NPHBIO_MORT("NPHBIO_MORT"),
	NPHBIO_HARVEST("NPHBIO_HARVEST"),
	PHBIO_NPP("PHBIO_NPP"),
	ROOT_DEPTH("ROOT_DEPTH"),
	BIO_TIME("BIO_TIME"),
	CF_AIR_TEMP("CF_AIR_TEMP"),
	MAC_NPH_BIOMAS("MAC_NPH_BIOMAS"),
	NPHBIO_PLANTING("NPHBIO_PLANTING"),
	TRANSDOWN("TRANSDOWN"),
	TRANSUP("TRANSUP"),
	MAC_PH_BIOMAS("MAC_PH_BIOMAS"),
	PHBIO_PLANT("PHBIO_PLANT"),
	PH_MAX("PH_MAX"),
	PH_IN("PH_IN"),
	PH_OUT("PH_OUT"),
	TOT_NPP("TOT_NPP"),
	NPP_IN("NPP_IN"),
	YIELD("YIELD"),
	HARVEST("HARVEST"),
	INI_YIELD("INI_YIELD"),
	DAY_LENGTH_PREV("DAY_LENGTH_PREV"),
	FALL_LITTER("FALL_LITTER"),
	FALL_LITTER_CALC("FALL_LITTER_CALC"),
	HARVEST_TIME("HARVEST_TIME"),
	IC_NPHBIO("IC_NPHBIO"),
	IC_PHBIO("IC_PHBIO"),
	LIGHT_CF("LIGHT_CF"),
	MAC_LAI_R("MAC_LAI_R"),
	MAC_PROD_CF("MAC_PROD_CF"),
	MAX_BM("MAX_BM"),
	MAX_NPH("MAX_NPH"),
	MAX_PH("MAX_PH"),
	NPH_AB_BM("NPH_AB_BM"),
	NUTR_CF("NUTR_CF"),
	PHBIO_MORT_WATER("PHBIO_MORT_WATER"),
	PHBIO_NPP_CALC("PHBIO_NPP_CALC"),
	PH_TO_ABBM("PH_TO_ABBM"),
	PLANTIME("PLANTIME"),
	PLANTING("PLANTING"),
	PO4SD_CONCTOT("PO4SD_CONCTOT"),
	REMOVAL_TIME("REMOVAL_TIME"),
	ROOT_BM("ROOT_BM"),
	SPROUTING("SPROUTING"),
	TEMP_CF("TEMP_CF"),
	TOTAL_BIOM("TOTAL_BIOM"),
	TRANSDOWN_RT("TRANSDOWN_RT"),
	WATER_CF("WATER_CF"),
	WAT_STRESS_HIGH("WAT_STRESS_HIGH"),
	WAT_STRESS_LOW("WAT_STRESS_LOW"),
	P1_BIO_END("P1_BIO_END"),
	P1_BIO_REPRO("P1_BIO_REPRO"),
	P1_BIO_START("P1_BIO_START"),
	P1_DAYLENG_RQ("P1_DAYLENG_RQ"),
	P1_EST_HEIGHT("P1_EST_HEIGHT"),
	P1_H_DAY("P1_H_DAY"),
	P1_LIGHTSAT("P1_LIGHTSAT"),
	P1_MAC_KS_N("P1_MAC_KS_N"),
	P1_MAC_KS_P("P1_MAC_KS_P"),
	P1_MAX_AB_BM("P1_MAX_AB_BM"),
	P1_MAX_DENS("P1_MAX_DENS"),
	P1_MAX_HT_BM("P1_MAX_HT_BM"),
	P1_MAX_LAI("P1_MAX_LAI"),
	P1_MAX_PH_ABBM("P1_MAX_PH_ABBM"),
	P1_NPH_ABBM_IC("P1_NPH_ABBM_IC"),
	P1_NPH_AB_BEL("P1_NPH_AB_BEL"),
	P1_NPH_MORT("P1_NPH_MORT"),
	P1_NPH_PR_H("P1_NPH_PR_H"),
	P1_NPP("P1_NPP"),
	P1_PHB_C_REC("P1_PHB_C_REC"),
	P1_PHB_EVGRN("P1_PHB_EVGRN"),
	P1_PHB_L_RT("P1_PHB_L_RT"),
	P1_PHB_MORT("P1_PHB_MORT"),
	P1_PHB_PR_H("P1_PHB_PR_H"),
	P1_PH_TO_REP("P1_PH_TO_REP"),
	P1_PROP_LA_TO_B("P1_PROP_LA_TO_B"),
	P1_P_DAY("P1_P_DAY"),
	P1_P_RATIO("P1_P_RATIO"),
	P1_P_WT("P1_P_WT"),
	P1_ROOT_DENS("P1_ROOT_DENS"),
	P1_SPR_RATE("P1_SPR_RATE"),
	P1_TEMPOPT("P1_TEMPOPT"),
	P1_W_T_MAX("P1_W_T_MAX"),
	P1_W_T_MIN("P1_W_T_MIN"),
	SOLRADGR("SOLRADGR"),
	TModule(name) {

	MACH.SetF(FisExport,True,"CG");
	MACLAI.SetF(FisExport,True,"CG");
	AIR_TEMP_C.SetF(FisImport,True,"CG");
	HABITATMAP.SetF(FisImport,True,"CG");
	DAYJUL.SetF(FisImport,True,"CG");
	DAYLENGTH.SetF(FisImport,True,"CG");
	DIN_AVAILABLE.SetF(FisImport,True,"CG");
	ELEVATION.SetF(FisImport,True,"CG");
	SURFACE_WATER.SetF(FisImport,True,"CG");
	UW_DEPTH.SetF(FisImport,True,"CG");
	WATER_AVAIL.SetF(FisImport,True,"CG");
	PHBIO_MORT.SetF(FisExport,True,"CG");
	PHBIO_HARVEST.SetF(FisExport,True,"CG");
	NPHBIO_MORT.SetF(FisExport,True,"CG");
	NPHBIO_HARVEST.SetF(FisExport,True,"CG");
	PHBIO_NPP.SetF(FisExport,True,"CG");
	ROOT_DEPTH.SetF(FisExport,True,"CG");
	SOLRADGR.SetF(FisImport,True,"CG");
}	
int MACROPHYTES_module::BIO_TIME_I30_exe() {
	float value;

	BIO_TIME.UpdateIntegrator();
	switch( BIO_TIME.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = BIO_TIME.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  CF_AIR_TEMP.Value(p);
			BIO_TIME.Update( p, value, dT() );
		}
		BIO_TIME.GrabMemory();
		if( BIO_TIME.GetF(FLinkEdges) ) { BIO_TIME.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  CF_AIR_TEMP.Value();
			BIO_TIME.Update( value, dT() );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::BIO_TIME_i31_exe() {
	float value;

	BIO_TIME.UpdateIntegrator();
	switch( BIO_TIME.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = BIO_TIME.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			BIO_TIME.InitValue( p, value );
		}
		BIO_TIME.GrabMemory();
		if( BIO_TIME.GetF(FLinkEdges) ) { BIO_TIME.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			BIO_TIME.InitValue( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::CF_AIR_TEMP_u32_exe() {
	float value;

	switch( CF_AIR_TEMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CF_AIR_TEMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( PLANTIME.Value(p) == ((float)1) ) ) ? ( ( -BIO_TIME.Value(p)/dT() ) ) : (  ( ( ( AIR_TEMP_C.Value(p) >  ((float)5) ) ) ? ( AIR_TEMP_C.Value(p) ) : ( ((float)0) ) )  ) ) ;
			CF_AIR_TEMP.Update( p, value );
		}
		CF_AIR_TEMP.GrabMemory();
		if( CF_AIR_TEMP.GetF(FICFlux) ) CF_AIR_TEMP.Cov().Set(0.0); 
		if( CF_AIR_TEMP.GetF(FLinkEdges) ) { CF_AIR_TEMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( PLANTIME.Value() == ((float)1) ) ) ? ( ( -BIO_TIME.Value()/dT() ) ) : (  ( ( ( AIR_TEMP_C.Value() >  ((float)5) ) ) ? ( AIR_TEMP_C.Value() ) : ( ((float)0) ) )  ) ) ;
			CF_AIR_TEMP.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAC_NPH_BIOMAS_I33_exe() {
	float value;

	MAC_NPH_BIOMAS.UpdateIntegrator();
	switch( MAC_NPH_BIOMAS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAC_NPH_BIOMAS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( NPHBIO_PLANTING.Value(p)+TRANSDOWN.Value(p) )-NPHBIO_MORT.Value(p) )-TRANSUP.Value(p) )-NPHBIO_HARVEST.Value(p) );
			MAC_NPH_BIOMAS.Update( p, value, dT() );
		}
		MAC_NPH_BIOMAS.GrabMemory();
		if( MAC_NPH_BIOMAS.GetF(FLinkEdges) ) { MAC_NPH_BIOMAS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( NPHBIO_PLANTING.Value()+TRANSDOWN.Value() )-NPHBIO_MORT.Value() )-TRANSUP.Value() )-NPHBIO_HARVEST.Value() );
			MAC_NPH_BIOMAS.Update( value, dT() );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAC_NPH_BIOMAS_i34_exe() {
	float value;

	MAC_NPH_BIOMAS.UpdateIntegrator();
	switch( MAC_NPH_BIOMAS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAC_NPH_BIOMAS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  IC_NPHBIO.Value(p);
			MAC_NPH_BIOMAS.InitValue( p, value );
		}
		MAC_NPH_BIOMAS.GrabMemory();
		if( MAC_NPH_BIOMAS.GetF(FLinkEdges) ) { MAC_NPH_BIOMAS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  IC_NPHBIO.Value();
			MAC_NPH_BIOMAS.InitValue( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::NPHBIO_PLANTING_u35_exe() {
	float value;

	switch( NPHBIO_PLANTING.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NPHBIO_PLANTING.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PLANTING.Value(p)*( ((float)1)-P1_P_RATIO.Value(p) ) );
			NPHBIO_PLANTING.Update( p, value );
		}
		NPHBIO_PLANTING.GrabMemory();
		if( NPHBIO_PLANTING.GetF(FICFlux) ) NPHBIO_PLANTING.Cov().Set(0.0); 
		if( NPHBIO_PLANTING.GetF(FLinkEdges) ) { NPHBIO_PLANTING.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PLANTING.Value()*( ((float)1)-P1_P_RATIO.Value() ) );
			NPHBIO_PLANTING.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::TRANSDOWN_u36_exe() {
	float value;

	switch( TRANSDOWN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TRANSDOWN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( HARVEST_TIME.Value(p) >  ((float)0) ) ) ? ( ((float)0) ) : ( ( ( TRANSDOWN_RT.Value(p)*( PHBIO_NPP.Value(p)+( P1_PH_TO_REP.Value(p)*MAC_PH_BIOMAS.Value(p) ) ) )+( P1_PHB_C_REC.Value(p)*FALL_LITTER.Value(p) ) ) ) ) ;
			TRANSDOWN.Update( p, value );
		}
		TRANSDOWN.GrabMemory();
		if( TRANSDOWN.GetF(FICFlux) ) TRANSDOWN.Cov().Set(0.0); 
		if( TRANSDOWN.GetF(FLinkEdges) ) { TRANSDOWN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( HARVEST_TIME.Value() >  ((float)0) ) ) ? ( ((float)0) ) : ( ( ( TRANSDOWN_RT.Value()*( PHBIO_NPP.Value()+( P1_PH_TO_REP.Value()*MAC_PH_BIOMAS.Value() ) ) )+( P1_PHB_C_REC.Value()*FALL_LITTER.Value() ) ) ) ) ;
			TRANSDOWN.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::NPHBIO_MORT_u37_exe() {
	float value;

	switch( NPHBIO_MORT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NPHBIO_MORT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( MAC_NPH_BIOMAS.Value(p)*P1_NPH_MORT.Value(p) )+( ( HARVEST_TIME.Delay(  p, dT() )*MAC_NPH_BIOMAS.Value(p) )/dT() ) );
			NPHBIO_MORT.Update( p, value );
		}
		NPHBIO_MORT.GrabMemory();
		if( NPHBIO_MORT.GetF(FICFlux) ) NPHBIO_MORT.Cov().Set(0.0); 
		if( NPHBIO_MORT.GetF(FLinkEdges) ) { NPHBIO_MORT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( MAC_NPH_BIOMAS.Value()*P1_NPH_MORT.Value() )+( ( HARVEST_TIME.Delay( dT() )*MAC_NPH_BIOMAS.Value() )/dT() ) );
			NPHBIO_MORT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::TRANSUP_u38_exe() {
	float value;

	switch( TRANSUP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TRANSUP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SPROUTING.Value(p)*P1_SPR_RATE.Value(p) )*MAC_NPH_BIOMAS.Value(p) );
			TRANSUP.Update( p, value );
		}
		TRANSUP.GrabMemory();
		if( TRANSUP.GetF(FICFlux) ) TRANSUP.Cov().Set(0.0); 
		if( TRANSUP.GetF(FLinkEdges) ) { TRANSUP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SPROUTING.Value()*P1_SPR_RATE.Value() )*MAC_NPH_BIOMAS.Value() );
			TRANSUP.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::NPHBIO_HARVEST_u39_exe() {
	float value;

	switch( NPHBIO_HARVEST.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NPHBIO_HARVEST.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( HARVEST_TIME.Value(p)*P1_NPH_PR_H.Value(p) )*MAC_NPH_BIOMAS.Value(p) )/dT() );
			NPHBIO_HARVEST.Update( p, value );
		}
		NPHBIO_HARVEST.GrabMemory();
		if( NPHBIO_HARVEST.GetF(FICFlux) ) NPHBIO_HARVEST.Cov().Set(0.0); 
		if( NPHBIO_HARVEST.GetF(FLinkEdges) ) { NPHBIO_HARVEST.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( HARVEST_TIME.Value()*P1_NPH_PR_H.Value() )*MAC_NPH_BIOMAS.Value() )/dT() );
			NPHBIO_HARVEST.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAC_PH_BIOMAS_I40_exe() {
	float value;

	MAC_PH_BIOMAS.UpdateIntegrator();
	switch( MAC_PH_BIOMAS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAC_PH_BIOMAS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( PHBIO_NPP.Value(p)+PHBIO_PLANT.Value(p) )+TRANSUP.Value(p) )-PHBIO_MORT.Value(p) )-PHBIO_HARVEST.Value(p) )-TRANSDOWN.Value(p) );
			MAC_PH_BIOMAS.Update( p, value, dT() );
		}
		MAC_PH_BIOMAS.GrabMemory();
		if( MAC_PH_BIOMAS.GetF(FLinkEdges) ) { MAC_PH_BIOMAS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( PHBIO_NPP.Value()+PHBIO_PLANT.Value() )+TRANSUP.Value() )-PHBIO_MORT.Value() )-PHBIO_HARVEST.Value() )-TRANSDOWN.Value() );
			MAC_PH_BIOMAS.Update( value, dT() );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAC_PH_BIOMAS_i41_exe() {
	float value;

	MAC_PH_BIOMAS.UpdateIntegrator();
	switch( MAC_PH_BIOMAS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAC_PH_BIOMAS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  IC_PHBIO.Value(p);
			MAC_PH_BIOMAS.InitValue( p, value );
		}
		MAC_PH_BIOMAS.GrabMemory();
		if( MAC_PH_BIOMAS.GetF(FLinkEdges) ) { MAC_PH_BIOMAS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  IC_PHBIO.Value();
			MAC_PH_BIOMAS.InitValue( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PHBIO_NPP_u42_exe() {
	float value;

	switch( PHBIO_NPP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_NPP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( HARVEST_TIME.Value(p) >  ((float)0) ) ) ? ( ((float)0) ) : ( PHBIO_NPP_CALC.Value(p) ) ) ;
			PHBIO_NPP.Update( p, value );
		}
		PHBIO_NPP.GrabMemory();
		if( PHBIO_NPP.GetF(FICFlux) ) PHBIO_NPP.Cov().Set(0.0); 
		if( PHBIO_NPP.GetF(FLinkEdges) ) { PHBIO_NPP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( HARVEST_TIME.Value() >  ((float)0) ) ) ? ( ((float)0) ) : ( PHBIO_NPP_CALC.Value() ) ) ;
			PHBIO_NPP.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PHBIO_PLANT_u43_exe() {
	float value;

	switch( PHBIO_PLANT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_PLANT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PLANTING.Value(p)*P1_P_RATIO.Value(p) );
			PHBIO_PLANT.Update( p, value );
		}
		PHBIO_PLANT.GrabMemory();
		if( PHBIO_PLANT.GetF(FICFlux) ) PHBIO_PLANT.Cov().Set(0.0); 
		if( PHBIO_PLANT.GetF(FLinkEdges) ) { PHBIO_PLANT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PLANTING.Value()*P1_P_RATIO.Value() );
			PHBIO_PLANT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PHBIO_MORT_u44_exe() {
	float value;

	switch( PHBIO_MORT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_MORT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( HARVEST_TIME.Delay(  p, dT() )*MAC_PH_BIOMAS.Value(p) )/dT() )+( FALL_LITTER.Value(p)*( ((float)1)-P1_PHB_C_REC.Value(p) ) ) )+( MAC_PH_BIOMAS.Value(p)*( PHBIO_MORT_WATER.Value(p)+P1_PHB_MORT.Value(p) ) ) );
			PHBIO_MORT.Update( p, value );
		}
		PHBIO_MORT.GrabMemory();
		if( PHBIO_MORT.GetF(FICFlux) ) PHBIO_MORT.Cov().Set(0.0); 
		if( PHBIO_MORT.GetF(FLinkEdges) ) { PHBIO_MORT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( HARVEST_TIME.Delay( dT() )*MAC_PH_BIOMAS.Value() )/dT() )+( FALL_LITTER.Value()*( ((float)1)-P1_PHB_C_REC.Value() ) ) )+( MAC_PH_BIOMAS.Value()*( PHBIO_MORT_WATER.Value()+P1_PHB_MORT.Value() ) ) );
			PHBIO_MORT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PHBIO_HARVEST_u45_exe() {
	float value;

	switch( PHBIO_HARVEST.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_HARVEST.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( HARVEST_TIME.Value(p)+REMOVAL_TIME.Value(p) )*P1_PHB_PR_H.Value(p) )*MAC_PH_BIOMAS.Value(p) )/dT() );
			PHBIO_HARVEST.Update( p, value );
		}
		PHBIO_HARVEST.GrabMemory();
		if( PHBIO_HARVEST.GetF(FICFlux) ) PHBIO_HARVEST.Cov().Set(0.0); 
		if( PHBIO_HARVEST.GetF(FLinkEdges) ) { PHBIO_HARVEST.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( HARVEST_TIME.Value()+REMOVAL_TIME.Value() )*P1_PHB_PR_H.Value() )*MAC_PH_BIOMAS.Value() )/dT() );
			PHBIO_HARVEST.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PH_MAX_I46_exe() {
	float value;

	PH_MAX.UpdateIntegrator();
	switch( PH_MAX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PH_MAX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PH_IN.Value(p)-PH_OUT.Value(p) );
			PH_MAX.Update( p, value, dT() );
		}
		PH_MAX.GrabMemory();
		if( PH_MAX.GetF(FLinkEdges) ) { PH_MAX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PH_IN.Value()-PH_OUT.Value() );
			PH_MAX.Update( value, dT() );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PH_MAX_i47_exe() {
	float value;

	PH_MAX.UpdateIntegrator();
	switch( PH_MAX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PH_MAX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			PH_MAX.InitValue( p, value );
		}
		PH_MAX.GrabMemory();
		if( PH_MAX.GetF(FLinkEdges) ) { PH_MAX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			PH_MAX.InitValue( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PH_IN_u48_exe() {
	float value;

	switch( PH_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PH_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( MAC_PH_BIOMAS.Value(p) >  PH_MAX.Value(p) ) ) ? ( ( MAC_PH_BIOMAS.Value(p)/dT() ) ) : ( ((float)0) ) ) ;
			PH_IN.Update( p, value );
		}
		PH_IN.GrabMemory();
		if( PH_IN.GetF(FICFlux) ) PH_IN.Cov().Set(0.0); 
		if( PH_IN.GetF(FLinkEdges) ) { PH_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( MAC_PH_BIOMAS.Value() >  PH_MAX.Value() ) ) ? ( ( MAC_PH_BIOMAS.Value()/dT() ) ) : ( ((float)0) ) ) ;
			PH_IN.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PH_OUT_u49_exe() {
	float value;

	switch( PH_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PH_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( MAC_PH_BIOMAS.Value(p) >  PH_MAX.Value(p) ) || ( PLANTIME.Value(p) == ((float)1) ) ) ) ? ( ( PH_MAX.Value(p)/dT() ) ) : ( ((float)0) ) ) ;
			PH_OUT.Update( p, value );
		}
		PH_OUT.GrabMemory();
		if( PH_OUT.GetF(FICFlux) ) PH_OUT.Cov().Set(0.0); 
		if( PH_OUT.GetF(FLinkEdges) ) { PH_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( MAC_PH_BIOMAS.Value() >  PH_MAX.Value() ) || ( PLANTIME.Value() == ((float)1) ) ) ) ? ( ( PH_MAX.Value()/dT() ) ) : ( ((float)0) ) ) ;
			PH_OUT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::TOT_NPP_I50_exe() {
	float value;

	TOT_NPP.UpdateIntegrator();
	switch( TOT_NPP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOT_NPP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  NPP_IN.Value(p);
			TOT_NPP.Update( p, value, dT() );
		}
		TOT_NPP.GrabMemory();
		if( TOT_NPP.GetF(FLinkEdges) ) { TOT_NPP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  NPP_IN.Value();
			TOT_NPP.Update( value, dT() );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::TOT_NPP_i51_exe() {
	float value;

	TOT_NPP.UpdateIntegrator();
	switch( TOT_NPP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOT_NPP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			TOT_NPP.InitValue( p, value );
		}
		TOT_NPP.GrabMemory();
		if( TOT_NPP.GetF(FLinkEdges) ) { TOT_NPP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			TOT_NPP.InitValue( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::NPP_IN_u52_exe() {
	float value;

	switch( NPP_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NPP_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( HABITATMAP.Value(p) == ((float)2) ) ) ? ( PHBIO_NPP.Value(p) ) : ( ((float)0) ) ) ;
			NPP_IN.Update( p, value );
		}
		NPP_IN.GrabMemory();
		if( NPP_IN.GetF(FICFlux) ) NPP_IN.Cov().Set(0.0); 
		if( NPP_IN.GetF(FLinkEdges) ) { NPP_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( HABITATMAP.Value() == ((float)2) ) ) ? ( PHBIO_NPP.Value() ) : ( ((float)0) ) ) ;
			NPP_IN.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::YIELD_I53_exe() {
	float value;

	YIELD.UpdateIntegrator();
	switch( YIELD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = YIELD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( HARVEST.Value(p)-INI_YIELD.Value(p) );
			YIELD.Update( p, value, dT() );
		}
		YIELD.GrabMemory();
		if( YIELD.GetF(FLinkEdges) ) { YIELD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( HARVEST.Value()-INI_YIELD.Value() );
			YIELD.Update( value, dT() );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::YIELD_i54_exe() {
	float value;

	YIELD.UpdateIntegrator();
	switch( YIELD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = YIELD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			YIELD.InitValue( p, value );
		}
		YIELD.GrabMemory();
		if( YIELD.GetF(FLinkEdges) ) { YIELD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			YIELD.InitValue( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::HARVEST_u55_exe() {
	float value;

	switch( HARVEST.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HARVEST.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PHBIO_HARVEST.Value(p)+NPHBIO_HARVEST.Value(p) );
			HARVEST.Update( p, value );
		}
		HARVEST.GrabMemory();
		if( HARVEST.GetF(FICFlux) ) HARVEST.Cov().Set(0.0); 
		if( HARVEST.GetF(FLinkEdges) ) { HARVEST.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PHBIO_HARVEST.Value()+NPHBIO_HARVEST.Value() );
			HARVEST.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::INI_YIELD_u56_exe() {
	float value;

	switch( INI_YIELD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = INI_YIELD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( DAYJUL.Value(p) == ((float)1) ) ) ? ( ( ( YIELD.Value(p)/dT() )*((float)0) ) ) : ( ((float)0) ) ) ;
			INI_YIELD.Update( p, value );
		}
		INI_YIELD.GrabMemory();
		if( INI_YIELD.GetF(FICFlux) ) INI_YIELD.Cov().Set(0.0); 
		if( INI_YIELD.GetF(FLinkEdges) ) { INI_YIELD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( DAYJUL.Value() == ((float)1) ) ) ? ( ( ( YIELD.Value()/dT() )*((float)0) ) ) : ( ((float)0) ) ) ;
			INI_YIELD.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::DAY_LENGTH_PREV_u57_exe() {
	float value;

	switch( DAY_LENGTH_PREV.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DAY_LENGTH_PREV.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  DAYLENGTH.Delay(  p, ((float)1) );
			DAY_LENGTH_PREV.Update( p, value );
		}
		DAY_LENGTH_PREV.GrabMemory();
		if( DAY_LENGTH_PREV.GetF(FLinkEdges) ) { DAY_LENGTH_PREV.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  DAYLENGTH.Delay( ((float)1) );
			DAY_LENGTH_PREV.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::FALL_LITTER_u58_exe() {
	float value;

	switch( FALL_LITTER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FALL_LITTER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(FALL_LITTER_CALC.Value(p), SL::Max(((float)0), ( MAC_PH_BIOMAS.Value(p)-( ( P1_PHB_EVGRN.Value(p)*PH_MAX.Value(p) )/( ((float)1)+P1_PHB_EVGRN.Value(p) ) ) )));
			FALL_LITTER.Update( p, value );
		}
		FALL_LITTER.GrabMemory();
		if( FALL_LITTER.GetF(FLinkEdges) ) { FALL_LITTER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(FALL_LITTER_CALC.Value(), SL::Max(((float)0), ( MAC_PH_BIOMAS.Value()-( ( P1_PHB_EVGRN.Value()*PH_MAX.Value() )/( ((float)1)+P1_PHB_EVGRN.Value() ) ) )));
			FALL_LITTER.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::FALL_LITTER_CALC_u59_exe() {
	float value;

	switch( FALL_LITTER_CALC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FALL_LITTER_CALC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( DAYLENGTH.Value(p) >  P1_DAYLENG_RQ.Value(p) ) || ( DAYLENGTH.Value(p) >= DAY_LENGTH_PREV.Value(p) ) ) ) ? ( ((float)0) ) : (  ( ( ( MAC_PH_BIOMAS.Value(p) <  ( 0.01*( ((float)1)-P1_PHB_EVGRN.Value(p) ) ) ) ) ? ( ( ( ( ((float)1)-P1_PHB_EVGRN.Value(p) )*MAC_PH_BIOMAS.Value(p) )/dT() ) ) : ( ( ( ((float)1)-P1_PHB_EVGRN.Value(p) )*pow((double)( ( PH_MAX.Value(p)*P1_PHB_L_RT.Value(p) )/MAC_PH_BIOMAS.Value(p) ),(double)((float)3) ) ) ) )  ) ) ;
			FALL_LITTER_CALC.Update( p, value );
		}
		FALL_LITTER_CALC.GrabMemory();
		if( FALL_LITTER_CALC.GetF(FLinkEdges) ) { FALL_LITTER_CALC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( DAYLENGTH.Value() >  P1_DAYLENG_RQ.Value() ) || ( DAYLENGTH.Value() >= DAY_LENGTH_PREV.Value() ) ) ) ? ( ((float)0) ) : (  ( ( ( MAC_PH_BIOMAS.Value() <  ( 0.01*( ((float)1)-P1_PHB_EVGRN.Value() ) ) ) ) ? ( ( ( ( ((float)1)-P1_PHB_EVGRN.Value() )*MAC_PH_BIOMAS.Value() )/dT() ) ) : ( ( ( ((float)1)-P1_PHB_EVGRN.Value() )*pow((double)( ( PH_MAX.Value()*P1_PHB_L_RT.Value() )/MAC_PH_BIOMAS.Value() ),(double)((float)3) ) ) ) )  ) ) ;
			FALL_LITTER_CALC.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::HARVEST_TIME_u60_exe() {
	float value;

	switch( HARVEST_TIME.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HARVEST_TIME.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( DAYJUL.Value(p) >  P1_H_DAY.Value(p) ) && ( DAYJUL.Value(p) <  ( P1_H_DAY.Value(p)+((float)3) ) ) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			HARVEST_TIME.Update( p, value );
		}
		HARVEST_TIME.GrabMemory();
		HARVEST_TIME.UpdateDelayData();
		if( HARVEST_TIME.GetF(FLinkEdges) ) { HARVEST_TIME.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( DAYJUL.Value() >  P1_H_DAY.Value() ) && ( DAYJUL.Value() <  ( P1_H_DAY.Value()+((float)3) ) ) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			HARVEST_TIME.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::IC_NPHBIO_u61_exe() {
	float value;

	switch( IC_NPHBIO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = IC_NPHBIO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_NPH_ABBM_IC.Value(p)*( P1_NPH_AB_BEL.Value(p)+((float)1) ) )/P1_NPH_AB_BEL.Value(p) );
			IC_NPHBIO.Update( p, value );
		}
		IC_NPHBIO.GrabMemory();
		if( IC_NPHBIO.GetF(FLinkEdges) ) { IC_NPHBIO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_NPH_ABBM_IC.Value()*( P1_NPH_AB_BEL.Value()+((float)1) ) )/P1_NPH_AB_BEL.Value() );
			IC_NPHBIO.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::IC_PHBIO_u62_exe() {
	float value;

	switch( IC_PHBIO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = IC_PHBIO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( P1_PHB_EVGRN.Value(p)*P1_NPH_ABBM_IC.Value(p) )*P1_MAX_PH_ABBM.Value(p) )/( ((float)1)-P1_MAX_PH_ABBM.Value(p) ) );
			IC_PHBIO.Update( p, value );
		}
		IC_PHBIO.GrabMemory();
		if( IC_PHBIO.GetF(FLinkEdges) ) { IC_PHBIO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( P1_PHB_EVGRN.Value()*P1_NPH_ABBM_IC.Value() )*P1_MAX_PH_ABBM.Value() )/( ((float)1)-P1_MAX_PH_ABBM.Value() ) );
			IC_PHBIO.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::LIGHT_CF_u63_exe() {
	float value;

	switch( LIGHT_CF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LIGHT_CF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SOLRADGR.Value(p)/P1_LIGHTSAT.Value(p) )*SL::Exp(( ((float)1)-( SOLRADGR.Value(p)/P1_LIGHTSAT.Value(p) ) )) );
			LIGHT_CF.Update( p, value );
		}
		LIGHT_CF.GrabMemory();
		if( LIGHT_CF.GetF(FLinkEdges) ) { LIGHT_CF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SOLRADGR.Value()/P1_LIGHTSAT.Value() )*SL::Exp(( ((float)1)-( SOLRADGR.Value()/P1_LIGHTSAT.Value() ) )) );
			LIGHT_CF.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MACH_u64_exe() {
	float value;

	switch( MACH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MACH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_MAX_HT_BM.Value(p)*TOTAL_BIOM.Value(p) )/MAX_BM.Value(p) );
			MACH.Update( p, value );
		}
		MACH.GrabMemory();
		if( MACH.GetF(FLinkEdges) ) { MACH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_MAX_HT_BM.Value()*TOTAL_BIOM.Value() )/MAX_BM.Value() );
			MACH.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MACLAI_u65_exe() {
	float value;

	switch( MACLAI.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MACLAI.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(( MAC_PH_BIOMAS.Value(p)*P1_PROP_LA_TO_B.Value(p) ), P1_MAX_LAI.Value(p));
			MACLAI.Update( p, value );
		}
		MACLAI.GrabMemory();
		if( MACLAI.GetF(FLinkEdges) ) { MACLAI.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(( MAC_PH_BIOMAS.Value()*P1_PROP_LA_TO_B.Value() ), P1_MAX_LAI.Value());
			MACLAI.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAC_LAI_R_u66_exe() {
	float value;

	switch( MAC_LAI_R.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAC_LAI_R.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( MACLAI.Value(p)/P1_MAX_LAI.Value(p) );
			MAC_LAI_R.Update( p, value );
		}
		MAC_LAI_R.GrabMemory();
		if( MAC_LAI_R.GetF(FLinkEdges) ) { MAC_LAI_R.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( MACLAI.Value()/P1_MAX_LAI.Value() );
			MAC_LAI_R.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAC_PROD_CF_u67_exe() {
	float value;

	switch( MAC_PROD_CF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAC_PROD_CF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SL::Min(LIGHT_CF.Value(p), TEMP_CF.Value(p))*WATER_CF.Value(p) )*NUTR_CF.Value(p) );
			MAC_PROD_CF.Update( p, value );
		}
		MAC_PROD_CF.GrabMemory();
		if( MAC_PROD_CF.GetF(FLinkEdges) ) { MAC_PROD_CF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SL::Min(LIGHT_CF.Value(), TEMP_CF.Value())*WATER_CF.Value() )*NUTR_CF.Value() );
			MAC_PROD_CF.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAX_BM_u68_exe() {
	float value;

	switch( MAX_BM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAX_BM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( MAX_NPH.Value(p)+MAX_PH.Value(p) );
			MAX_BM.Update( p, value );
		}
		MAX_BM.GrabMemory();
		if( MAX_BM.GetF(FLinkEdges) ) { MAX_BM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( MAX_NPH.Value()+MAX_PH.Value() );
			MAX_BM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAX_NPH_u69_exe() {
	float value;

	switch( MAX_NPH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAX_NPH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_MAX_AB_BM.Value(p)-MAX_PH.Value(p) )*( ((float)1)+( ((float)1)/P1_NPH_AB_BEL.Value(p) ) ) );
			MAX_NPH.Update( p, value );
		}
		MAX_NPH.GrabMemory();
		if( MAX_NPH.GetF(FLinkEdges) ) { MAX_NPH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_MAX_AB_BM.Value()-MAX_PH.Value() )*( ((float)1)+( ((float)1)/P1_NPH_AB_BEL.Value() ) ) );
			MAX_NPH.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAX_PH_u70_exe() {
	float value;

	switch( MAX_PH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAX_PH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_MAX_AB_BM.Value(p)*P1_MAX_PH_ABBM.Value(p) );
			MAX_PH.Update( p, value );
		}
		MAX_PH.GrabMemory();
		if( MAX_PH.GetF(FLinkEdges) ) { MAX_PH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_MAX_AB_BM.Value()*P1_MAX_PH_ABBM.Value() );
			MAX_PH.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::NPH_AB_BM_u71_exe() {
	float value;

	switch( NPH_AB_BM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NPH_AB_BM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_NPH_AB_BEL.Value(p)*ROOT_BM.Value(p) );
			NPH_AB_BM.Update( p, value );
		}
		NPH_AB_BM.GrabMemory();
		if( NPH_AB_BM.GetF(FLinkEdges) ) { NPH_AB_BM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_NPH_AB_BEL.Value()*ROOT_BM.Value() );
			NPH_AB_BM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::NUTR_CF_u72_exe() {
	float value;

	switch( NUTR_CF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NUTR_CF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(( DIN_AVAILABLE.Value(p)/( DIN_AVAILABLE.Value(p)+P1_MAC_KS_N.Value(p) ) ), ( PO4SD_CONCTOT.Value(p)/( PO4SD_CONCTOT.Value(p)+P1_MAC_KS_P.Value(p) ) ));
			NUTR_CF.Update( p, value );
		}
		NUTR_CF.GrabMemory();
		if( NUTR_CF.GetF(FLinkEdges) ) { NUTR_CF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(( DIN_AVAILABLE.Value()/( DIN_AVAILABLE.Value()+P1_MAC_KS_N.Value() ) ), ( PO4SD_CONCTOT.Value()/( PO4SD_CONCTOT.Value()+P1_MAC_KS_P.Value() ) ));
			NUTR_CF.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PHBIO_MORT_WATER_u73_exe() {
	float value;

	switch( PHBIO_MORT_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_MORT_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( 0.1*SL::Max(((float)0), ( ((float)1)-WATER_CF.Value(p) )) );
			PHBIO_MORT_WATER.Update( p, value );
		}
		PHBIO_MORT_WATER.GrabMemory();
		if( PHBIO_MORT_WATER.GetF(FLinkEdges) ) { PHBIO_MORT_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( 0.1*SL::Max(((float)0), ( ((float)1)-WATER_CF.Value() )) );
			PHBIO_MORT_WATER.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PHBIO_NPP_CALC_u74_exe() {
	float value;

	switch( PHBIO_NPP_CALC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_NPP_CALC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( MAC_PH_BIOMAS.Value(p) <  MAX_PH.Value(p) ) ) ? ( ( ( ( MAC_PROD_CF.Value(p)*P1_NPP.Value(p) )*MAC_PH_BIOMAS.Value(p) )*( ((float)1)-( MAC_PH_BIOMAS.Value(p)/MAX_PH.Value(p) ) ) ) ) : ( ((float)0) ) ) ;
			PHBIO_NPP_CALC.Update( p, value );
		}
		PHBIO_NPP_CALC.GrabMemory();
		if( PHBIO_NPP_CALC.GetF(FLinkEdges) ) { PHBIO_NPP_CALC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( MAC_PH_BIOMAS.Value() <  MAX_PH.Value() ) ) ? ( ( ( ( MAC_PROD_CF.Value()*P1_NPP.Value() )*MAC_PH_BIOMAS.Value() )*( ((float)1)-( MAC_PH_BIOMAS.Value()/MAX_PH.Value() ) ) ) ) : ( ((float)0) ) ) ;
			PHBIO_NPP_CALC.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PH_TO_ABBM_u75_exe() {
	float value;

	switch( PH_TO_ABBM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PH_TO_ABBM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( NPH_AB_BM.Value(p) == ((float)0) ) ) ? ( ((float)0) ) : ( ( MAC_PH_BIOMAS.Value(p)/( MAC_PH_BIOMAS.Value(p)+NPH_AB_BM.Value(p) ) ) ) ) ;
			PH_TO_ABBM.Update( p, value );
		}
		PH_TO_ABBM.GrabMemory();
		if( PH_TO_ABBM.GetF(FLinkEdges) ) { PH_TO_ABBM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( NPH_AB_BM.Value() == ((float)0) ) ) ? ( ((float)0) ) : ( ( MAC_PH_BIOMAS.Value()/( MAC_PH_BIOMAS.Value()+NPH_AB_BM.Value() ) ) ) ) ;
			PH_TO_ABBM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PLANTIME_u76_exe() {
	float value;

	switch( PLANTIME.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PLANTIME.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( DAYJUL.Value(p) == P1_P_DAY.Value(p) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			PLANTIME.Update( p, value );
		}
		PLANTIME.GrabMemory();
		if( PLANTIME.GetF(FLinkEdges) ) { PLANTIME.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( DAYJUL.Value() == P1_P_DAY.Value() ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			PLANTIME.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PLANTING_u77_exe() {
	float value;

	switch( PLANTING.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PLANTING.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( PLANTIME.Value(p)*P1_MAX_DENS.Value(p) )*P1_P_WT.Value(p) );
			PLANTING.Update( p, value );
		}
		PLANTING.GrabMemory();
		if( PLANTING.GetF(FLinkEdges) ) { PLANTING.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( PLANTIME.Value()*P1_MAX_DENS.Value() )*P1_P_WT.Value() );
			PLANTING.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PO4SD_CONCTOT_u78_exe() {
	float value;

	switch( PO4SD_CONCTOT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4SD_CONCTOT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1000;
			PO4SD_CONCTOT.Update( p, PO4SD_CONCTOT.ParameterValue(value,p) );
		}
		PO4SD_CONCTOT.GrabMemory();
		if( PO4SD_CONCTOT.GetF(FLinkEdges) ) { PO4SD_CONCTOT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1000;
			PO4SD_CONCTOT.Update( PO4SD_CONCTOT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::REMOVAL_TIME_u79_exe() {
	float value;

	switch( REMOVAL_TIME.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = REMOVAL_TIME.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( MACH.Value(p)*P1_PHB_PR_H.Value(p) ) >  P1_EST_HEIGHT.Value(p) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			REMOVAL_TIME.Update( p, value );
		}
		REMOVAL_TIME.GrabMemory();
		if( REMOVAL_TIME.GetF(FLinkEdges) ) { REMOVAL_TIME.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( MACH.Value()*P1_PHB_PR_H.Value() ) >  P1_EST_HEIGHT.Value() ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			REMOVAL_TIME.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::ROOT_BM_u80_exe() {
	float value;

	switch( ROOT_BM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ROOT_BM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( MAC_NPH_BIOMAS.Value(p)/( P1_NPH_AB_BEL.Value(p)+((float)1) ) );
			ROOT_BM.Update( p, value );
		}
		ROOT_BM.GrabMemory();
		if( ROOT_BM.GetF(FLinkEdges) ) { ROOT_BM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( MAC_NPH_BIOMAS.Value()/( P1_NPH_AB_BEL.Value()+((float)1) ) );
			ROOT_BM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::ROOT_DEPTH_u81_exe() {
	float value;

	switch( ROOT_DEPTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ROOT_DEPTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(( ELEVATION.Value(p)-((float)1) ), ( ROOT_BM.Value(p)/P1_ROOT_DENS.Value(p) ));
			ROOT_DEPTH.Update( p, value );
		}
		ROOT_DEPTH.GrabMemory();
		if( ROOT_DEPTH.GetF(FLinkEdges) ) { ROOT_DEPTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(( ELEVATION.Value()-((float)1) ), ( ROOT_BM.Value()/P1_ROOT_DENS.Value() ));
			ROOT_DEPTH.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::SPROUTING_u82_exe() {
	float value;

	switch( SPROUTING.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SPROUTING.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( PH_TO_ABBM.Value(p) <  P1_MAX_PH_ABBM.Value(p) ) && ( ( BIO_TIME.Value(p) >  P1_BIO_START.Value(p) ) && ( BIO_TIME.Value(p) <  P1_BIO_END.Value(p) ) ) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			SPROUTING.Update( p, value );
		}
		SPROUTING.GrabMemory();
		if( SPROUTING.GetF(FLinkEdges) ) { SPROUTING.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( PH_TO_ABBM.Value() <  P1_MAX_PH_ABBM.Value() ) && ( ( BIO_TIME.Value() >  P1_BIO_START.Value() ) && ( BIO_TIME.Value() <  P1_BIO_END.Value() ) ) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			SPROUTING.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::TEMP_CF_u83_exe() {
	float value;

	switch( TEMP_CF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TEMP_CF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SL::Exp(( 0.20*( AIR_TEMP_C.Value(p)-P1_TEMPOPT.Value(p) ) ))*pow((double)( ( ((float)40)-AIR_TEMP_C.Value(p) )/( ((float)40)-P1_TEMPOPT.Value(p) ) ),(double)( 0.20*( ((float)40)-P1_TEMPOPT.Value(p) ) ) ) );
			TEMP_CF.Update( p, value );
		}
		TEMP_CF.GrabMemory();
		if( TEMP_CF.GetF(FLinkEdges) ) { TEMP_CF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SL::Exp(( 0.20*( AIR_TEMP_C.Value()-P1_TEMPOPT.Value() ) ))*pow((double)( ( ((float)40)-AIR_TEMP_C.Value() )/( ((float)40)-P1_TEMPOPT.Value() ) ),(double)( 0.20*( ((float)40)-P1_TEMPOPT.Value() ) ) ) );
			TEMP_CF.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::TOTAL_BIOM_u84_exe() {
	float value;

	switch( TOTAL_BIOM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOTAL_BIOM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( MAC_PH_BIOMAS.Value(p)+MAC_NPH_BIOMAS.Value(p) );
			TOTAL_BIOM.Update( p, value );
		}
		TOTAL_BIOM.GrabMemory();
		if( TOTAL_BIOM.GetF(FLinkEdges) ) { TOTAL_BIOM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( MAC_PH_BIOMAS.Value()+MAC_NPH_BIOMAS.Value() );
			TOTAL_BIOM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::TRANSDOWN_RT_u85_exe() {
	float value;

	switch( TRANSDOWN_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TRANSDOWN_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( BIO_TIME.Value(p) >  ( P1_BIO_REPRO.Value(p)+((float)1) ) ) ) ? ( ( ((float)1)-( ((float)1)/pow((double)( BIO_TIME.Value(p)-P1_BIO_REPRO.Value(p) ),(double)0.5 ) ) ) ) : (  ( ( ( PH_TO_ABBM.Value(p) <  P1_MAX_PH_ABBM.Value(p) ) ) ? ( ((float)0) ) : ( pow((double)SL::Cos(( ( ( P1_MAX_PH_ABBM.Value(p)/PH_TO_ABBM.Value(p) )*3.141590 )/2. )),(double)0.1 ) ) )  ) ) ;
			TRANSDOWN_RT.Update( p, value );
		}
		TRANSDOWN_RT.GrabMemory();
		if( TRANSDOWN_RT.GetF(FLinkEdges) ) { TRANSDOWN_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( BIO_TIME.Value() >  ( P1_BIO_REPRO.Value()+((float)1) ) ) ) ? ( ( ((float)1)-( ((float)1)/pow((double)( BIO_TIME.Value()-P1_BIO_REPRO.Value() ),(double)0.5 ) ) ) ) : (  ( ( ( PH_TO_ABBM.Value() <  P1_MAX_PH_ABBM.Value() ) ) ? ( ((float)0) ) : ( pow((double)SL::Cos(( ( ( P1_MAX_PH_ABBM.Value()/PH_TO_ABBM.Value() )*3.141590 )/2. )),(double)0.1 ) ) )  ) ) ;
			TRANSDOWN_RT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::WATER_CF_u86_exe() {
	float value;

	switch( WATER_CF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WATER_CF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(WAT_STRESS_HIGH.Value(p), WAT_STRESS_LOW.Value(p));
			WATER_CF.Update( p, value );
		}
		WATER_CF.GrabMemory();
		if( WATER_CF.GetF(FLinkEdges) ) { WATER_CF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(WAT_STRESS_HIGH.Value(), WAT_STRESS_LOW.Value());
			WATER_CF.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::WAT_STRESS_HIGH_u87_exe() {
	float value;

	switch( WAT_STRESS_HIGH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WAT_STRESS_HIGH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( P1_W_T_MAX.Value(p) <  ((float)0) ) && ( SURFACE_WATER.Value(p) >  -P1_W_T_MAX.Value(p) ) ) ) ? ( SL::Max(((float)0), ( ((float)1)/( ((float)1)+SL::Exp(( SURFACE_WATER.Value(p)+P1_W_T_MAX.Value(p) )) ) )) ) : (  ( ( ( ( P1_W_T_MAX.Value(p) >  ((float)0) ) && ( ROOT_DEPTH.Value(p) >  ((float)0) ) ) ) ? ( SL::Min(((float)1), ( ( UW_DEPTH.Value(p)/ROOT_DEPTH.Value(p) )/P1_W_T_MAX.Value(p) )) ) : ( ((float)1) ) )  ) ) ;
			WAT_STRESS_HIGH.Update( p, value );
		}
		WAT_STRESS_HIGH.GrabMemory();
		if( WAT_STRESS_HIGH.GetF(FLinkEdges) ) { WAT_STRESS_HIGH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( P1_W_T_MAX.Value() <  ((float)0) ) && ( SURFACE_WATER.Value() >  -P1_W_T_MAX.Value() ) ) ) ? ( SL::Max(((float)0), ( ((float)1)/( ((float)1)+SL::Exp(( SURFACE_WATER.Value()+P1_W_T_MAX.Value() )) ) )) ) : (  ( ( ( ( P1_W_T_MAX.Value() >  ((float)0) ) && ( ROOT_DEPTH.Value() >  ((float)0) ) ) ) ? ( SL::Min(((float)1), ( ( UW_DEPTH.Value()/ROOT_DEPTH.Value() )/P1_W_T_MAX.Value() )) ) : ( ((float)1) ) )  ) ) ;
			WAT_STRESS_HIGH.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::WAT_STRESS_LOW_u88_exe() {
	float value;

	switch( WAT_STRESS_LOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WAT_STRESS_LOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  pow((double)SL::Sin(( ( WATER_AVAIL.Value(p)*3.141590 )/2 )),(double)P1_W_T_MIN.Value(p) );
			WAT_STRESS_LOW.Update( p, value );
		}
		WAT_STRESS_LOW.GrabMemory();
		if( WAT_STRESS_LOW.GetF(FLinkEdges) ) { WAT_STRESS_LOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  pow((double)SL::Sin(( ( WATER_AVAIL.Value()*3.141590 )/2 )),(double)P1_W_T_MIN.Value() );
			WAT_STRESS_LOW.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_BIO_END_u89_exe() {
	float value;

	switch( P1_BIO_END.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_BIO_END.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)570);
			P1_BIO_END.Update( p, value );
		}
		P1_BIO_END.GrabMemory();
		if( P1_BIO_END.GetF(FLinkEdges) ) { P1_BIO_END.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)570);
			P1_BIO_END.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_BIO_REPRO_u90_exe() {
	float value;

	switch( P1_BIO_REPRO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_BIO_REPRO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1700);
			P1_BIO_REPRO.Update( p, value );
		}
		P1_BIO_REPRO.GrabMemory();
		if( P1_BIO_REPRO.GetF(FLinkEdges) ) { P1_BIO_REPRO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1700);
			P1_BIO_REPRO.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_BIO_START_u91_exe() {
	float value;

	switch( P1_BIO_START.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_BIO_START.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)500);
			P1_BIO_START.Update( p, value );
		}
		P1_BIO_START.GrabMemory();
		if( P1_BIO_START.GetF(FLinkEdges) ) { P1_BIO_START.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)500);
			P1_BIO_START.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_DAYLENG_RQ_u92_exe() {
	float value;

	switch( P1_DAYLENG_RQ.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DAYLENG_RQ.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)13);
			P1_DAYLENG_RQ.Update( p, value );
		}
		P1_DAYLENG_RQ.GrabMemory();
		if( P1_DAYLENG_RQ.GetF(FLinkEdges) ) { P1_DAYLENG_RQ.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)13);
			P1_DAYLENG_RQ.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_EST_HEIGHT_u93_exe() {
	float value;

	switch( P1_EST_HEIGHT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_EST_HEIGHT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)500);
			P1_EST_HEIGHT.Update( p, value );
		}
		P1_EST_HEIGHT.GrabMemory();
		if( P1_EST_HEIGHT.GetF(FLinkEdges) ) { P1_EST_HEIGHT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)500);
			P1_EST_HEIGHT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_H_DAY_u94_exe() {
	float value;

	switch( P1_H_DAY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_H_DAY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)319);
			P1_H_DAY.Update( p, value );
		}
		P1_H_DAY.GrabMemory();
		if( P1_H_DAY.GetF(FLinkEdges) ) { P1_H_DAY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)319);
			P1_H_DAY.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_LIGHTSAT_u95_exe() {
	float value;

	switch( P1_LIGHTSAT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_LIGHTSAT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)600);
			P1_LIGHTSAT.Update( p, value );
		}
		P1_LIGHTSAT.GrabMemory();
		if( P1_LIGHTSAT.GetF(FLinkEdges) ) { P1_LIGHTSAT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)600);
			P1_LIGHTSAT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_MAC_KS_N_u96_exe() {
	float value;

	switch( P1_MAC_KS_N.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAC_KS_N.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.00265;
			P1_MAC_KS_N.Update( p, value );
		}
		P1_MAC_KS_N.GrabMemory();
		if( P1_MAC_KS_N.GetF(FLinkEdges) ) { P1_MAC_KS_N.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.00265;
			P1_MAC_KS_N.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_MAC_KS_P_u97_exe() {
	float value;

	switch( P1_MAC_KS_P.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAC_KS_P.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000037;
			P1_MAC_KS_P.Update( p, value );
		}
		P1_MAC_KS_P.GrabMemory();
		if( P1_MAC_KS_P.GetF(FLinkEdges) ) { P1_MAC_KS_P.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000037;
			P1_MAC_KS_P.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_MAX_AB_BM_u98_exe() {
	float value;

	switch( P1_MAX_AB_BM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAX_AB_BM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.6;
			P1_MAX_AB_BM.Update( p, value );
		}
		P1_MAX_AB_BM.GrabMemory();
		if( P1_MAX_AB_BM.GetF(FLinkEdges) ) { P1_MAX_AB_BM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.6;
			P1_MAX_AB_BM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_MAX_DENS_u99_exe() {
	float value;

	switch( P1_MAX_DENS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAX_DENS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)40);
			P1_MAX_DENS.Update( p, value );
		}
		P1_MAX_DENS.GrabMemory();
		if( P1_MAX_DENS.GetF(FLinkEdges) ) { P1_MAX_DENS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)40);
			P1_MAX_DENS.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_MAX_HT_BM_u100_exe() {
	float value;

	switch( P1_MAX_HT_BM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAX_HT_BM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.8;
			P1_MAX_HT_BM.Update( p, value );
		}
		P1_MAX_HT_BM.GrabMemory();
		if( P1_MAX_HT_BM.GetF(FLinkEdges) ) { P1_MAX_HT_BM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.8;
			P1_MAX_HT_BM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_MAX_LAI_u101_exe() {
	float value;

	switch( P1_MAX_LAI.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAX_LAI.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)5);
			P1_MAX_LAI.Update( p, value );
		}
		P1_MAX_LAI.GrabMemory();
		if( P1_MAX_LAI.GetF(FLinkEdges) ) { P1_MAX_LAI.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)5);
			P1_MAX_LAI.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_MAX_PH_ABBM_u102_exe() {
	float value;

	switch( P1_MAX_PH_ABBM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAX_PH_ABBM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.75;
			P1_MAX_PH_ABBM.Update( p, value );
		}
		P1_MAX_PH_ABBM.GrabMemory();
		if( P1_MAX_PH_ABBM.GetF(FLinkEdges) ) { P1_MAX_PH_ABBM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.75;
			P1_MAX_PH_ABBM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_NPH_ABBM_IC_u103_exe() {
	float value;

	switch( P1_NPH_ABBM_IC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_NPH_ABBM_IC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_NPH_ABBM_IC.Update( p, value );
		}
		P1_NPH_ABBM_IC.GrabMemory();
		if( P1_NPH_ABBM_IC.GetF(FLinkEdges) ) { P1_NPH_ABBM_IC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_NPH_ABBM_IC.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_NPH_AB_BEL_u104_exe() {
	float value;

	switch( P1_NPH_AB_BEL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_NPH_AB_BEL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.7;
			P1_NPH_AB_BEL.Update( p, value );
		}
		P1_NPH_AB_BEL.GrabMemory();
		if( P1_NPH_AB_BEL.GetF(FLinkEdges) ) { P1_NPH_AB_BEL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.7;
			P1_NPH_AB_BEL.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_NPH_MORT_u105_exe() {
	float value;

	switch( P1_NPH_MORT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_NPH_MORT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.00000053;
			P1_NPH_MORT.Update( p, value );
		}
		P1_NPH_MORT.GrabMemory();
		if( P1_NPH_MORT.GetF(FLinkEdges) ) { P1_NPH_MORT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.00000053;
			P1_NPH_MORT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_NPH_PR_H_u106_exe() {
	float value;

	switch( P1_NPH_PR_H.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_NPH_PR_H.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.85;
			P1_NPH_PR_H.Update( p, value );
		}
		P1_NPH_PR_H.GrabMemory();
		if( P1_NPH_PR_H.GetF(FLinkEdges) ) { P1_NPH_PR_H.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.85;
			P1_NPH_PR_H.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_NPP_u107_exe() {
	float value;

	switch( P1_NPP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_NPP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.25;
			P1_NPP.Update( p, value );
		}
		P1_NPP.GrabMemory();
		if( P1_NPP.GetF(FLinkEdges) ) { P1_NPP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.25;
			P1_NPP.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_PHB_C_REC_u108_exe() {
	float value;

	switch( P1_PHB_C_REC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHB_C_REC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_PHB_C_REC.Update( p, value );
		}
		P1_PHB_C_REC.GrabMemory();
		if( P1_PHB_C_REC.GetF(FLinkEdges) ) { P1_PHB_C_REC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_PHB_C_REC.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_PHB_EVGRN_u109_exe() {
	float value;

	switch( P1_PHB_EVGRN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHB_EVGRN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_PHB_EVGRN.Update( p, value );
		}
		P1_PHB_EVGRN.GrabMemory();
		if( P1_PHB_EVGRN.GetF(FLinkEdges) ) { P1_PHB_EVGRN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_PHB_EVGRN.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_PHB_L_RT_u110_exe() {
	float value;

	switch( P1_PHB_L_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHB_L_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_PHB_L_RT.Update( p, value );
		}
		P1_PHB_L_RT.GrabMemory();
		if( P1_PHB_L_RT.GetF(FLinkEdges) ) { P1_PHB_L_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_PHB_L_RT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_PHB_MORT_u111_exe() {
	float value;

	switch( P1_PHB_MORT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHB_MORT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_PHB_MORT.Update( p, value );
		}
		P1_PHB_MORT.GrabMemory();
		if( P1_PHB_MORT.GetF(FLinkEdges) ) { P1_PHB_MORT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_PHB_MORT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_PHB_PR_H_u112_exe() {
	float value;

	switch( P1_PHB_PR_H.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHB_PR_H.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.8;
			P1_PHB_PR_H.Update( p, value );
		}
		P1_PHB_PR_H.GrabMemory();
		if( P1_PHB_PR_H.GetF(FLinkEdges) ) { P1_PHB_PR_H.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.8;
			P1_PHB_PR_H.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_PH_TO_REP_u113_exe() {
	float value;

	switch( P1_PH_TO_REP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PH_TO_REP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.005;
			P1_PH_TO_REP.Update( p, value );
		}
		P1_PH_TO_REP.GrabMemory();
		if( P1_PH_TO_REP.GetF(FLinkEdges) ) { P1_PH_TO_REP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.005;
			P1_PH_TO_REP.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_PROP_LA_TO_B_u114_exe() {
	float value;

	switch( P1_PROP_LA_TO_B.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PROP_LA_TO_B.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)12);
			P1_PROP_LA_TO_B.Update( p, value );
		}
		P1_PROP_LA_TO_B.GrabMemory();
		if( P1_PROP_LA_TO_B.GetF(FLinkEdges) ) { P1_PROP_LA_TO_B.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)12);
			P1_PROP_LA_TO_B.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_P_DAY_u115_exe() {
	float value;

	switch( P1_P_DAY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_P_DAY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)191);
			P1_P_DAY.Update( p, value );
		}
		P1_P_DAY.GrabMemory();
		if( P1_P_DAY.GetF(FLinkEdges) ) { P1_P_DAY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)191);
			P1_P_DAY.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_P_RATIO_u116_exe() {
	float value;

	switch( P1_P_RATIO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_P_RATIO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_P_RATIO.Update( p, value );
		}
		P1_P_RATIO.GrabMemory();
		if( P1_P_RATIO.GetF(FLinkEdges) ) { P1_P_RATIO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_P_RATIO.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_P_WT_u117_exe() {
	float value;

	switch( P1_P_WT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_P_WT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.0009;
			P1_P_WT.Update( p, value );
		}
		P1_P_WT.GrabMemory();
		if( P1_P_WT.GetF(FLinkEdges) ) { P1_P_WT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.0009;
			P1_P_WT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_ROOT_DENS_u118_exe() {
	float value;

	switch( P1_ROOT_DENS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_ROOT_DENS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)11);
			P1_ROOT_DENS.Update( p, value );
		}
		P1_ROOT_DENS.GrabMemory();
		if( P1_ROOT_DENS.GetF(FLinkEdges) ) { P1_ROOT_DENS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)11);
			P1_ROOT_DENS.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_SPR_RATE_u119_exe() {
	float value;

	switch( P1_SPR_RATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SPR_RATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.01;
			P1_SPR_RATE.Update( p, value );
		}
		P1_SPR_RATE.GrabMemory();
		if( P1_SPR_RATE.GetF(FLinkEdges) ) { P1_SPR_RATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.01;
			P1_SPR_RATE.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_TEMPOPT_u120_exe() {
	float value;

	switch( P1_TEMPOPT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_TEMPOPT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)25);
			P1_TEMPOPT.Update( p, value );
		}
		P1_TEMPOPT.GrabMemory();
		if( P1_TEMPOPT.GetF(FLinkEdges) ) { P1_TEMPOPT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)25);
			P1_TEMPOPT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_W_T_MAX_u121_exe() {
	float value;

	switch( P1_W_T_MAX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_W_T_MAX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.1;
			P1_W_T_MAX.Update( p, value );
		}
		P1_W_T_MAX.GrabMemory();
		if( P1_W_T_MAX.GetF(FLinkEdges) ) { P1_W_T_MAX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.1;
			P1_W_T_MAX.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_W_T_MIN_u122_exe() {
	float value;

	switch( P1_W_T_MIN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_W_T_MIN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.2;
			P1_W_T_MIN.Update( p, value );
		}
		P1_W_T_MIN.GrabMemory();
		if( P1_W_T_MIN.GetF(FLinkEdges) ) { P1_W_T_MIN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.2;
			P1_W_T_MIN.Update( value );
	  } break;
	}
	return 0;
}

MACROPHYTES_module* MACROPHYTES_module::fInstance = NULL;
MACROPHYTES_module* MACROPHYTES_module::kNullModel = (MACROPHYTES_module*)0x1;
int MACROPHYTES_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int MACROPHYTES_module::InitVars() {
	
	TIME.SSInit(this);
	MACH.SSInit(this);
	MACLAI.SSInit(this);
	AIR_TEMP_C.SSInit(this);
	HABITATMAP.SSInit(this);
	DAYJUL.SSInit(this);
	DAYLENGTH.SSInit(this);
	DIN_AVAILABLE.SSInit(this);
	ELEVATION.SSInit(this);
	SURFACE_WATER.SSInit(this);
	UW_DEPTH.SSInit(this);
	WATER_AVAIL.SSInit(this);
	PHBIO_MORT.SSInit(this);
	PHBIO_MORT.SetOrigin(&MAC_PH_BIOMAS);
	PHBIO_HARVEST.SSInit(this);
	PHBIO_HARVEST.SetOrigin(&MAC_PH_BIOMAS);
	NPHBIO_MORT.SSInit(this);
	NPHBIO_MORT.SetOrigin(&MAC_NPH_BIOMAS);
	NPHBIO_HARVEST.SSInit(this);
	NPHBIO_HARVEST.SetOrigin(&MAC_NPH_BIOMAS);
	PHBIO_NPP.SSInit(this);
	PHBIO_NPP.SetDestination(&MAC_PH_BIOMAS);
	ROOT_DEPTH.SSInit(this);
	BIO_TIME.SSInit(this);
	CF_AIR_TEMP.SSInit(this);
	CF_AIR_TEMP.SetDestination(&BIO_TIME);
	MAC_NPH_BIOMAS.SSInit(this);
	NPHBIO_PLANTING.SSInit(this);
	NPHBIO_PLANTING.SetDestination(&MAC_NPH_BIOMAS);
	TRANSDOWN.SSInit(this);
	TRANSDOWN.SetOrigin(&MAC_PH_BIOMAS);
	TRANSDOWN.SetDestination(&MAC_NPH_BIOMAS);
	TRANSUP.SSInit(this);
	TRANSUP.SetOrigin(&MAC_NPH_BIOMAS);
	TRANSUP.SetDestination(&MAC_PH_BIOMAS);
	MAC_PH_BIOMAS.SSInit(this);
	PHBIO_PLANT.SSInit(this);
	PHBIO_PLANT.SetDestination(&MAC_PH_BIOMAS);
	PH_MAX.SSInit(this);
	PH_IN.SSInit(this);
	PH_IN.SetDestination(&PH_MAX);
	PH_OUT.SSInit(this);
	PH_OUT.SetOrigin(&PH_MAX);
	TOT_NPP.SSInit(this);
	NPP_IN.SSInit(this);
	NPP_IN.SetDestination(&TOT_NPP);
	YIELD.SSInit(this);
	HARVEST.SSInit(this);
	HARVEST.SetDestination(&YIELD);
	INI_YIELD.SSInit(this);
	INI_YIELD.SetOrigin(&YIELD);
	DAY_LENGTH_PREV.SSInit(this);
	FALL_LITTER.SSInit(this);
	FALL_LITTER_CALC.SSInit(this);
	HARVEST_TIME.SSInit(this);
	IC_NPHBIO.SSInit(this);
	IC_PHBIO.SSInit(this);
	LIGHT_CF.SSInit(this);
	MAC_LAI_R.SSInit(this);
	MAC_PROD_CF.SSInit(this);
	MAX_BM.SSInit(this);
	MAX_NPH.SSInit(this);
	MAX_PH.SSInit(this);
	NPH_AB_BM.SSInit(this);
	NUTR_CF.SSInit(this);
	PHBIO_MORT_WATER.SSInit(this);
	PHBIO_NPP_CALC.SSInit(this);
	PH_TO_ABBM.SSInit(this);
	PLANTIME.SSInit(this);
	PLANTING.SSInit(this);
	PO4SD_CONCTOT.SSInit(this);
	REMOVAL_TIME.SSInit(this);
	ROOT_BM.SSInit(this);
	SPROUTING.SSInit(this);
	TEMP_CF.SSInit(this);
	TOTAL_BIOM.SSInit(this);
	TRANSDOWN_RT.SSInit(this);
	WATER_CF.SSInit(this);
	WAT_STRESS_HIGH.SSInit(this);
	WAT_STRESS_LOW.SSInit(this);
	P1_BIO_END.SSInit(this);
	P1_BIO_REPRO.SSInit(this);
	P1_BIO_START.SSInit(this);
	P1_DAYLENG_RQ.SSInit(this);
	P1_EST_HEIGHT.SSInit(this);
	P1_H_DAY.SSInit(this);
	P1_LIGHTSAT.SSInit(this);
	P1_MAC_KS_N.SSInit(this);
	P1_MAC_KS_P.SSInit(this);
	P1_MAX_AB_BM.SSInit(this);
	P1_MAX_DENS.SSInit(this);
	P1_MAX_HT_BM.SSInit(this);
	P1_MAX_LAI.SSInit(this);
	P1_MAX_PH_ABBM.SSInit(this);
	P1_NPH_ABBM_IC.SSInit(this);
	P1_NPH_AB_BEL.SSInit(this);
	P1_NPH_MORT.SSInit(this);
	P1_NPH_PR_H.SSInit(this);
	P1_NPP.SSInit(this);
	P1_PHB_C_REC.SSInit(this);
	P1_PHB_EVGRN.SSInit(this);
	P1_PHB_L_RT.SSInit(this);
	P1_PHB_MORT.SSInit(this);
	P1_PHB_PR_H.SSInit(this);
	P1_PH_TO_REP.SSInit(this);
	P1_PROP_LA_TO_B.SSInit(this);
	P1_P_DAY.SSInit(this);
	P1_P_RATIO.SSInit(this);
	P1_P_WT.SSInit(this);
	P1_ROOT_DENS.SSInit(this);
	P1_SPR_RATE.SSInit(this);
	P1_TEMPOPT.SSInit(this);
	P1_W_T_MAX.SSInit(this);
	P1_W_T_MIN.SSInit(this);
	SOLRADGR.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int MACROPHYTES_module::SetupEvents() {
	TExecuteCommand* u64 = (TExecuteCommand*) MACH.GetCommand("u64",TCommand::kUpdate,TCommand::kCode);
	u64->SetExecutable(&MACH_u64_exe_g);
	u64->Code() = "u64 <- ( ( P1_MAX_HT_BM*TOTAL_BIOM )/MAX_BM )";
	u64->AddDependency(HABITATMAP);
	u64->AddDependency(P1_MAX_HT_BM);
	u64->AddDependency(TOTAL_BIOM);
	u64->AddDependency(MAX_BM);
	u64->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u65 = (TExecuteCommand*) MACLAI.GetCommand("u65",TCommand::kUpdate,TCommand::kCode);
	u65->SetExecutable(&MACLAI_u65_exe_g);
	u65->Code() = "u65 <- SL::Min(( MAC_PH_BIOMAS*P1_PROP_LA_TO_B ), P1_MAX_LAI)";
	u65->AddDependency(MAC_PH_BIOMAS);
	u65->AddDependency(HABITATMAP);
	u65->AddDependency(P1_PROP_LA_TO_B);
	u65->AddDependency(P1_MAX_LAI);
	u65->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* AIR_TEMP_C_import = (TImportCommand*) AIR_TEMP_C.GetCommand("AIR_TEMP_C_import",TCommand::kUndefined,TCommand::kImport);
	AIR_TEMP_C_import->Code() = "Import AIR_TEMP_C from GLOBALS_module";
	AIR_TEMP_C_import->AddDependency(AIR_TEMP_C);
	AIR_TEMP_C_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* HABITATMAP_import = (TImportCommand*) HABITATMAP.GetCommand("HABITATMAP_import",TCommand::kUndefined,TCommand::kImport);
	HABITATMAP_import->Code() = "Import HABITATMAP from GLOBALS_module";
	HABITATMAP_import->AddDependency(HABITATMAP);
	HABITATMAP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DAYJUL_import = (TImportCommand*) DAYJUL.GetCommand("DAYJUL_import",TCommand::kUndefined,TCommand::kImport);
	DAYJUL_import->Code() = "Import DAYJUL from GLOBALS_module";
	DAYJUL_import->AddDependency(DAYJUL);
	DAYJUL_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DAYLENGTH_import = (TImportCommand*) DAYLENGTH.GetCommand("DAYLENGTH_import",TCommand::kUndefined,TCommand::kImport);
	DAYLENGTH_import->Code() = "Import DAYLENGTH from GLOBALS_module";
	DAYLENGTH_import->AddDependency(DAYLENGTH);
	DAYLENGTH_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DIN_AVAILABLE_import = (TImportCommand*) DIN_AVAILABLE.GetCommand("DIN_AVAILABLE_import",TCommand::kUndefined,TCommand::kImport);
	DIN_AVAILABLE_import->Code() = "Import DIN_AVAILABLE from ZDIN_module";
	DIN_AVAILABLE_import->AddDependency(DIN_AVAILABLE);
	DIN_AVAILABLE_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ELEVATION_import = (TImportCommand*) ELEVATION.GetCommand("ELEVATION_import",TCommand::kUndefined,TCommand::kImport);
	ELEVATION_import->Code() = "Import ELEVATION from GLOBALS_module";
	ELEVATION_import->AddDependency(ELEVATION);
	ELEVATION_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SURFACE_WATER_import = (TImportCommand*) SURFACE_WATER.GetCommand("SURFACE_WATER_import",TCommand::kUndefined,TCommand::kImport);
	SURFACE_WATER_import->Code() = "Import SURFACE_WATER from HYDROLOGY_module";
	SURFACE_WATER_import->AddDependency(SURFACE_WATER);
	SURFACE_WATER_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* UW_DEPTH_import = (TImportCommand*) UW_DEPTH.GetCommand("UW_DEPTH_import",TCommand::kUndefined,TCommand::kImport);
	UW_DEPTH_import->Code() = "Import UW_DEPTH from HYDROLOGY_module";
	UW_DEPTH_import->AddDependency(UW_DEPTH);
	UW_DEPTH_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* WATER_AVAIL_import = (TImportCommand*) WATER_AVAIL.GetCommand("WATER_AVAIL_import",TCommand::kUndefined,TCommand::kImport);
	WATER_AVAIL_import->Code() = "Import WATER_AVAIL from HYDROLOGY_module";
	WATER_AVAIL_import->AddDependency(WATER_AVAIL);
	WATER_AVAIL_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u44 = (TExecuteCommand*) PHBIO_MORT.GetCommand("u44",TCommand::kUpdate,TCommand::kCode);
	u44->SetExecutable(&PHBIO_MORT_u44_exe_g);
	u44->Code() = "u44 <- ( ( ( ( HARVEST_TIME.Delay( dT() )*MAC_PH_BIOMAS )/dT() )+( FALL_LITTER*( ((float)1)-P1_PHB_C_REC ) ) )+( MAC_PH_BIOMAS*( PHBIO_MORT_WATER+P1_PHB_MORT ) ) )";
	if( PHBIO_MORT.GetF(FisClamped) ) { u44->AddDependency(MAC_PH_BIOMAS); }
	u44->AddDependency(HARVEST_TIME);
	u44->AddDependency(MAC_PH_BIOMAS);
	u44->AddDependency(FALL_LITTER);
	u44->AddDependency(HABITATMAP);
	u44->AddDependency(P1_PHB_C_REC);
	u44->AddDependency(PHBIO_MORT_WATER);
	u44->AddDependency(P1_PHB_MORT);
	u44->SetObjInfo(TCommand::kDepIndex, 2);
	TExecuteCommand* u45 = (TExecuteCommand*) PHBIO_HARVEST.GetCommand("u45",TCommand::kUpdate,TCommand::kCode);
	u45->SetExecutable(&PHBIO_HARVEST_u45_exe_g);
	u45->Code() = "u45 <- ( ( ( ( HARVEST_TIME+REMOVAL_TIME )*P1_PHB_PR_H )*MAC_PH_BIOMAS )/dT() )";
	if( PHBIO_HARVEST.GetF(FisClamped) ) { u45->AddDependency(MAC_PH_BIOMAS); }
	u45->AddDependency(HARVEST_TIME);
	u45->AddDependency(REMOVAL_TIME);
	u45->AddDependency(HABITATMAP);
	u45->AddDependency(P1_PHB_PR_H);
	u45->AddDependency(MAC_PH_BIOMAS);
	u45->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u37 = (TExecuteCommand*) NPHBIO_MORT.GetCommand("u37",TCommand::kUpdate,TCommand::kCode);
	u37->SetExecutable(&NPHBIO_MORT_u37_exe_g);
	u37->Code() = "u37 <- ( ( MAC_NPH_BIOMAS*P1_NPH_MORT )+( ( HARVEST_TIME.Delay( dT() )*MAC_NPH_BIOMAS )/dT() ) )";
	if( NPHBIO_MORT.GetF(FisClamped) ) { u37->AddDependency(MAC_NPH_BIOMAS); }
	u37->AddDependency(MAC_NPH_BIOMAS);
	u37->AddDependency(HABITATMAP);
	u37->AddDependency(P1_NPH_MORT);
	u37->AddDependency(HARVEST_TIME);
	u37->SetObjInfo(TCommand::kDepIndex, 2);
	TExecuteCommand* u39 = (TExecuteCommand*) NPHBIO_HARVEST.GetCommand("u39",TCommand::kUpdate,TCommand::kCode);
	u39->SetExecutable(&NPHBIO_HARVEST_u39_exe_g);
	u39->Code() = "u39 <- ( ( ( HARVEST_TIME*P1_NPH_PR_H )*MAC_NPH_BIOMAS )/dT() )";
	if( NPHBIO_HARVEST.GetF(FisClamped) ) { u39->AddDependency(MAC_NPH_BIOMAS); }
	u39->AddDependency(HARVEST_TIME);
	u39->AddDependency(HABITATMAP);
	u39->AddDependency(P1_NPH_PR_H);
	u39->AddDependency(MAC_NPH_BIOMAS);
	u39->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u42 = (TExecuteCommand*) PHBIO_NPP.GetCommand("u42",TCommand::kUpdate,TCommand::kCode);
	u42->SetExecutable(&PHBIO_NPP_u42_exe_g);
	u42->Code() = "u42 <-  ( ( ( HARVEST_TIME >  ((float)0) ) ) ? ( ((float)0) ) : ( PHBIO_NPP_CALC ) ) ";
	u42->AddDependency(HARVEST_TIME);
	u42->AddDependency(PHBIO_NPP_CALC);
	u42->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u81 = (TExecuteCommand*) ROOT_DEPTH.GetCommand("u81",TCommand::kUpdate,TCommand::kCode);
	u81->SetExecutable(&ROOT_DEPTH_u81_exe_g);
	u81->Code() = "u81 <- SL::Min(( ELEVATION-((float)1) ), ( ROOT_BM/P1_ROOT_DENS ))";
	u81->AddDependency(ELEVATION);
	u81->AddDependency(ROOT_BM);
	u81->AddDependency(HABITATMAP);
	u81->AddDependency(P1_ROOT_DENS);
	u81->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I30 = (TExecuteCommand*) BIO_TIME.GetCommand("I30",TCommand::kIntegrate,TCommand::kCode);
	I30->SetExecutable(&BIO_TIME_I30_exe_g);
	I30->Code() = "I30 <- CF_AIR_TEMP";
	I30->AddDependency(CF_AIR_TEMP);
	I30->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i31 = (TExecuteCommand*) BIO_TIME.GetCommand("i31",TCommand::kInit,TCommand::kCode);
	i31->SetExecutable(&BIO_TIME_i31_exe_g);
	i31->Code() = "i31 <- ((float)0)";
	i31->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u32 = (TExecuteCommand*) CF_AIR_TEMP.GetCommand("u32",TCommand::kUpdate,TCommand::kCode);
	u32->SetExecutable(&CF_AIR_TEMP_u32_exe_g);
	u32->Code() = "u32 <-  ( ( ( PLANTIME == ((float)1) ) ) ? ( ( -BIO_TIME/dT() ) ) : (  ( ( ( AIR_TEMP_C >  ((float)5) ) ) ? ( AIR_TEMP_C ) : ( ((float)0) ) )  ) ) ";
	u32->AddDependency(PLANTIME);
	u32->AddDependency(BIO_TIME);
	u32->AddDependency(AIR_TEMP_C);
	u32->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I33 = (TExecuteCommand*) MAC_NPH_BIOMAS.GetCommand("I33",TCommand::kIntegrate,TCommand::kCode);
	I33->SetExecutable(&MAC_NPH_BIOMAS_I33_exe_g);
	I33->Code() = "I33 <- ( ( ( ( NPHBIO_PLANTING+TRANSDOWN )-NPHBIO_MORT )-TRANSUP )-NPHBIO_HARVEST )";
	I33->AddDependency(NPHBIO_PLANTING);
	I33->AddDependency(TRANSDOWN);
	I33->AddDependency(NPHBIO_MORT);
	I33->AddDependency(TRANSUP);
	I33->AddDependency(NPHBIO_HARVEST);
	I33->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i34 = (TExecuteCommand*) MAC_NPH_BIOMAS.GetCommand("i34",TCommand::kInit,TCommand::kCode);
	i34->SetExecutable(&MAC_NPH_BIOMAS_i34_exe_g);
	i34->Code() = "i34 <- IC_NPHBIO";
	i34->AddDependency(IC_NPHBIO);
	i34->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u35 = (TExecuteCommand*) NPHBIO_PLANTING.GetCommand("u35",TCommand::kUpdate,TCommand::kCode);
	u35->SetExecutable(&NPHBIO_PLANTING_u35_exe_g);
	u35->Code() = "u35 <- ( PLANTING*( ((float)1)-P1_P_RATIO ) )";
	u35->AddDependency(PLANTING);
	u35->AddDependency(HABITATMAP);
	u35->AddDependency(P1_P_RATIO);
	u35->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u36 = (TExecuteCommand*) TRANSDOWN.GetCommand("u36",TCommand::kUpdate,TCommand::kCode);
	u36->SetExecutable(&TRANSDOWN_u36_exe_g);
	u36->Code() = "u36 <-  ( ( ( HARVEST_TIME >  ((float)0) ) ) ? ( ((float)0) ) : ( ( ( TRANSDOWN_RT*( PHBIO_NPP+( P1_PH_TO_REP*MAC_PH_BIOMAS ) ) )+( P1_PHB_C_REC*FALL_LITTER ) ) ) ) ";
	if( TRANSDOWN.GetF(FisClamped) ) { u36->AddDependency(MAC_PH_BIOMAS); }
	u36->AddDependency(HARVEST_TIME);
	u36->AddDependency(TRANSDOWN_RT);
	u36->AddDependency(PHBIO_NPP);
	u36->AddDependency(HABITATMAP);
	u36->AddDependency(P1_PH_TO_REP);
	u36->AddDependency(MAC_PH_BIOMAS);
	u36->AddDependency(P1_PHB_C_REC);
	u36->AddDependency(FALL_LITTER);
	u36->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u38 = (TExecuteCommand*) TRANSUP.GetCommand("u38",TCommand::kUpdate,TCommand::kCode);
	u38->SetExecutable(&TRANSUP_u38_exe_g);
	u38->Code() = "u38 <- ( ( SPROUTING*P1_SPR_RATE )*MAC_NPH_BIOMAS )";
	if( TRANSUP.GetF(FisClamped) ) { u38->AddDependency(MAC_NPH_BIOMAS); }
	u38->AddDependency(SPROUTING);
	u38->AddDependency(HABITATMAP);
	u38->AddDependency(P1_SPR_RATE);
	u38->AddDependency(MAC_NPH_BIOMAS);
	u38->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I40 = (TExecuteCommand*) MAC_PH_BIOMAS.GetCommand("I40",TCommand::kIntegrate,TCommand::kCode);
	I40->SetExecutable(&MAC_PH_BIOMAS_I40_exe_g);
	I40->Code() = "I40 <- ( ( ( ( ( PHBIO_NPP+PHBIO_PLANT )+TRANSUP )-PHBIO_MORT )-PHBIO_HARVEST )-TRANSDOWN )";
	I40->AddDependency(PHBIO_NPP);
	I40->AddDependency(PHBIO_PLANT);
	I40->AddDependency(TRANSUP);
	I40->AddDependency(PHBIO_MORT);
	I40->AddDependency(PHBIO_HARVEST);
	I40->AddDependency(TRANSDOWN);
	I40->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i41 = (TExecuteCommand*) MAC_PH_BIOMAS.GetCommand("i41",TCommand::kInit,TCommand::kCode);
	i41->SetExecutable(&MAC_PH_BIOMAS_i41_exe_g);
	i41->Code() = "i41 <- IC_PHBIO";
	i41->AddDependency(IC_PHBIO);
	i41->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u43 = (TExecuteCommand*) PHBIO_PLANT.GetCommand("u43",TCommand::kUpdate,TCommand::kCode);
	u43->SetExecutable(&PHBIO_PLANT_u43_exe_g);
	u43->Code() = "u43 <- ( PLANTING*P1_P_RATIO )";
	u43->AddDependency(PLANTING);
	u43->AddDependency(HABITATMAP);
	u43->AddDependency(P1_P_RATIO);
	u43->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I46 = (TExecuteCommand*) PH_MAX.GetCommand("I46",TCommand::kIntegrate,TCommand::kCode);
	I46->SetExecutable(&PH_MAX_I46_exe_g);
	I46->Code() = "I46 <- ( PH_IN-PH_OUT )";
	I46->AddDependency(PH_IN);
	I46->AddDependency(PH_OUT);
	I46->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i47 = (TExecuteCommand*) PH_MAX.GetCommand("i47",TCommand::kInit,TCommand::kCode);
	i47->SetExecutable(&PH_MAX_i47_exe_g);
	i47->Code() = "i47 <- ((float)0)";
	i47->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u48 = (TExecuteCommand*) PH_IN.GetCommand("u48",TCommand::kUpdate,TCommand::kCode);
	u48->SetExecutable(&PH_IN_u48_exe_g);
	u48->Code() = "u48 <-  ( ( ( MAC_PH_BIOMAS >  PH_MAX ) ) ? ( ( MAC_PH_BIOMAS/dT() ) ) : ( ((float)0) ) ) ";
	u48->AddDependency(MAC_PH_BIOMAS);
	u48->AddDependency(PH_MAX);
	u48->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u49 = (TExecuteCommand*) PH_OUT.GetCommand("u49",TCommand::kUpdate,TCommand::kCode);
	u49->SetExecutable(&PH_OUT_u49_exe_g);
	u49->Code() = "u49 <-  ( ( ( ( MAC_PH_BIOMAS >  PH_MAX ) || ( PLANTIME == ((float)1) ) ) ) ? ( ( PH_MAX/dT() ) ) : ( ((float)0) ) ) ";
	if( PH_OUT.GetF(FisClamped) ) { u49->AddDependency(PH_MAX); }
	u49->AddDependency(MAC_PH_BIOMAS);
	u49->AddDependency(PH_MAX);
	u49->AddDependency(PLANTIME);
	u49->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I50 = (TExecuteCommand*) TOT_NPP.GetCommand("I50",TCommand::kIntegrate,TCommand::kCode);
	I50->SetExecutable(&TOT_NPP_I50_exe_g);
	I50->Code() = "I50 <- NPP_IN";
	I50->AddDependency(NPP_IN);
	I50->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i51 = (TExecuteCommand*) TOT_NPP.GetCommand("i51",TCommand::kInit,TCommand::kCode);
	i51->SetExecutable(&TOT_NPP_i51_exe_g);
	i51->Code() = "i51 <- ((float)0)";
	i51->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u52 = (TExecuteCommand*) NPP_IN.GetCommand("u52",TCommand::kUpdate,TCommand::kCode);
	u52->SetExecutable(&NPP_IN_u52_exe_g);
	u52->Code() = "u52 <-  ( ( ( HABITATMAP == ((float)2) ) ) ? ( PHBIO_NPP ) : ( ((float)0) ) ) ";
	u52->AddDependency(HABITATMAP);
	u52->AddDependency(PHBIO_NPP);
	u52->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I53 = (TExecuteCommand*) YIELD.GetCommand("I53",TCommand::kIntegrate,TCommand::kCode);
	I53->SetExecutable(&YIELD_I53_exe_g);
	I53->Code() = "I53 <- ( HARVEST-INI_YIELD )";
	I53->AddDependency(HARVEST);
	I53->AddDependency(INI_YIELD);
	I53->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i54 = (TExecuteCommand*) YIELD.GetCommand("i54",TCommand::kInit,TCommand::kCode);
	i54->SetExecutable(&YIELD_i54_exe_g);
	i54->Code() = "i54 <- ((float)0)";
	i54->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u55 = (TExecuteCommand*) HARVEST.GetCommand("u55",TCommand::kUpdate,TCommand::kCode);
	u55->SetExecutable(&HARVEST_u55_exe_g);
	u55->Code() = "u55 <- ( PHBIO_HARVEST+NPHBIO_HARVEST )";
	u55->AddDependency(PHBIO_HARVEST);
	u55->AddDependency(NPHBIO_HARVEST);
	u55->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u56 = (TExecuteCommand*) INI_YIELD.GetCommand("u56",TCommand::kUpdate,TCommand::kCode);
	u56->SetExecutable(&INI_YIELD_u56_exe_g);
	u56->Code() = "u56 <-  ( ( ( DAYJUL == ((float)1) ) ) ? ( ( ( YIELD/dT() )*((float)0) ) ) : ( ((float)0) ) ) ";
	if( INI_YIELD.GetF(FisClamped) ) { u56->AddDependency(YIELD); }
	u56->AddDependency(DAYJUL);
	u56->AddDependency(YIELD);
	u56->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u57 = (TExecuteCommand*) DAY_LENGTH_PREV.GetCommand("u57",TCommand::kUpdate,TCommand::kCode);
	u57->SetExecutable(&DAY_LENGTH_PREV_u57_exe_g);
	u57->Code() = "u57 <- DAYLENGTH.Delay( ((float)1) )";
	u57->AddDependency(DAYLENGTH);
	u57->SetObjInfo(TCommand::kDepIndex, 2);
	TExecuteCommand* u58 = (TExecuteCommand*) FALL_LITTER.GetCommand("u58",TCommand::kUpdate,TCommand::kCode);
	u58->SetExecutable(&FALL_LITTER_u58_exe_g);
	u58->Code() = "u58 <- SL::Min(FALL_LITTER_CALC, SL::Max(((float)0), ( MAC_PH_BIOMAS-( ( P1_PHB_EVGRN*PH_MAX )/( ((float)1)+P1_PHB_EVGRN ) ) )))";
	u58->AddDependency(FALL_LITTER_CALC);
	u58->AddDependency(MAC_PH_BIOMAS);
	u58->AddDependency(HABITATMAP);
	u58->AddDependency(P1_PHB_EVGRN);
	u58->AddDependency(PH_MAX);
	u58->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u59 = (TExecuteCommand*) FALL_LITTER_CALC.GetCommand("u59",TCommand::kUpdate,TCommand::kCode);
	u59->SetExecutable(&FALL_LITTER_CALC_u59_exe_g);
	u59->Code() = "u59 <-  ( ( ( ( DAYLENGTH >  P1_DAYLENG_RQ ) || ( DAYLENGTH >= DAY_LENGTH_PREV ) ) ) ? ( ((float)0) ) : (  ( ( ( MAC_PH_BIOMAS <  ( 0.01*( ((float)1)-P1_PHB_EVGRN ) ) ) ) ? ( ( ( ( ((float)1)-P1_PHB_EVGRN )*MAC_PH_BIOMAS )/dT() ) ) : ( ( ( ((float)1)-P1_PHB_EVGRN )*pow((double)( ( PH_MAX*P1_PHB_L_RT )/MAC_PH_BIOMAS ),(double)((float)3) ) ) ) )  ) ) ";
	u59->AddDependency(DAYLENGTH);
	u59->AddDependency(HABITATMAP);
	u59->AddDependency(P1_DAYLENG_RQ);
	u59->AddDependency(DAY_LENGTH_PREV);
	u59->AddDependency(MAC_PH_BIOMAS);
	u59->AddDependency(P1_PHB_EVGRN);
	u59->AddDependency(PH_MAX);
	u59->AddDependency(P1_PHB_L_RT);
	u59->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u60 = (TExecuteCommand*) HARVEST_TIME.GetCommand("u60",TCommand::kUpdate,TCommand::kCode);
	u60->SetExecutable(&HARVEST_TIME_u60_exe_g);
	u60->Code() = "u60 <-  ( ( ( ( DAYJUL >  P1_H_DAY ) && ( DAYJUL <  ( P1_H_DAY+((float)3) ) ) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ";
	u60->AddDependency(DAYJUL);
	u60->AddDependency(HABITATMAP);
	u60->AddDependency(P1_H_DAY);
	u60->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u61 = (TExecuteCommand*) IC_NPHBIO.GetCommand("u61",TCommand::kUpdate,TCommand::kCode);
	u61->SetExecutable(&IC_NPHBIO_u61_exe_g);
	u61->Code() = "u61 <- ( ( P1_NPH_ABBM_IC*( P1_NPH_AB_BEL+((float)1) ) )/P1_NPH_AB_BEL )";
	u61->AddDependency(HABITATMAP);
	u61->AddDependency(P1_NPH_ABBM_IC);
	u61->AddDependency(P1_NPH_AB_BEL);
	u61->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u62 = (TExecuteCommand*) IC_PHBIO.GetCommand("u62",TCommand::kUpdate,TCommand::kCode);
	u62->SetExecutable(&IC_PHBIO_u62_exe_g);
	u62->Code() = "u62 <- ( ( ( P1_PHB_EVGRN*P1_NPH_ABBM_IC )*P1_MAX_PH_ABBM )/( ((float)1)-P1_MAX_PH_ABBM ) )";
	u62->AddDependency(HABITATMAP);
	u62->AddDependency(P1_PHB_EVGRN);
	u62->AddDependency(P1_NPH_ABBM_IC);
	u62->AddDependency(P1_MAX_PH_ABBM);
	u62->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u63 = (TExecuteCommand*) LIGHT_CF.GetCommand("u63",TCommand::kUpdate,TCommand::kCode);
	u63->SetExecutable(&LIGHT_CF_u63_exe_g);
	u63->Code() = "u63 <- ( ( SOLRADGR/P1_LIGHTSAT )*SL::Exp(( ((float)1)-( SOLRADGR/P1_LIGHTSAT ) )) )";
	u63->AddDependency(SOLRADGR);
	u63->AddDependency(HABITATMAP);
	u63->AddDependency(P1_LIGHTSAT);
	u63->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u66 = (TExecuteCommand*) MAC_LAI_R.GetCommand("u66",TCommand::kUpdate,TCommand::kCode);
	u66->SetExecutable(&MAC_LAI_R_u66_exe_g);
	u66->Code() = "u66 <- ( MACLAI/P1_MAX_LAI )";
	u66->AddDependency(MACLAI);
	u66->AddDependency(HABITATMAP);
	u66->AddDependency(P1_MAX_LAI);
	u66->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u67 = (TExecuteCommand*) MAC_PROD_CF.GetCommand("u67",TCommand::kUpdate,TCommand::kCode);
	u67->SetExecutable(&MAC_PROD_CF_u67_exe_g);
	u67->Code() = "u67 <- ( ( SL::Min(LIGHT_CF, TEMP_CF)*WATER_CF )*NUTR_CF )";
	u67->AddDependency(LIGHT_CF);
	u67->AddDependency(TEMP_CF);
	u67->AddDependency(WATER_CF);
	u67->AddDependency(NUTR_CF);
	u67->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u68 = (TExecuteCommand*) MAX_BM.GetCommand("u68",TCommand::kUpdate,TCommand::kCode);
	u68->SetExecutable(&MAX_BM_u68_exe_g);
	u68->Code() = "u68 <- ( MAX_NPH+MAX_PH )";
	u68->AddDependency(MAX_NPH);
	u68->AddDependency(MAX_PH);
	u68->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u69 = (TExecuteCommand*) MAX_NPH.GetCommand("u69",TCommand::kUpdate,TCommand::kCode);
	u69->SetExecutable(&MAX_NPH_u69_exe_g);
	u69->Code() = "u69 <- ( ( P1_MAX_AB_BM-MAX_PH )*( ((float)1)+( ((float)1)/P1_NPH_AB_BEL ) ) )";
	u69->AddDependency(HABITATMAP);
	u69->AddDependency(P1_MAX_AB_BM);
	u69->AddDependency(MAX_PH);
	u69->AddDependency(P1_NPH_AB_BEL);
	u69->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u70 = (TExecuteCommand*) MAX_PH.GetCommand("u70",TCommand::kUpdate,TCommand::kCode);
	u70->SetExecutable(&MAX_PH_u70_exe_g);
	u70->Code() = "u70 <- ( P1_MAX_AB_BM*P1_MAX_PH_ABBM )";
	u70->AddDependency(HABITATMAP);
	u70->AddDependency(P1_MAX_AB_BM);
	u70->AddDependency(P1_MAX_PH_ABBM);
	u70->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u71 = (TExecuteCommand*) NPH_AB_BM.GetCommand("u71",TCommand::kUpdate,TCommand::kCode);
	u71->SetExecutable(&NPH_AB_BM_u71_exe_g);
	u71->Code() = "u71 <- ( P1_NPH_AB_BEL*ROOT_BM )";
	u71->AddDependency(HABITATMAP);
	u71->AddDependency(P1_NPH_AB_BEL);
	u71->AddDependency(ROOT_BM);
	u71->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u72 = (TExecuteCommand*) NUTR_CF.GetCommand("u72",TCommand::kUpdate,TCommand::kCode);
	u72->SetExecutable(&NUTR_CF_u72_exe_g);
	u72->Code() = "u72 <- SL::Min(( DIN_AVAILABLE/( DIN_AVAILABLE+P1_MAC_KS_N ) ), ( PO4SD_CONCTOT/( PO4SD_CONCTOT+P1_MAC_KS_P ) ))";
	u72->AddDependency(DIN_AVAILABLE);
	u72->AddDependency(HABITATMAP);
	u72->AddDependency(P1_MAC_KS_N);
	u72->AddDependency(PO4SD_CONCTOT);
	u72->AddDependency(P1_MAC_KS_P);
	u72->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u73 = (TExecuteCommand*) PHBIO_MORT_WATER.GetCommand("u73",TCommand::kUpdate,TCommand::kCode);
	u73->SetExecutable(&PHBIO_MORT_WATER_u73_exe_g);
	u73->Code() = "u73 <- ( 0.1*SL::Max(((float)0), ( ((float)1)-WATER_CF )) )";
	u73->AddDependency(WATER_CF);
	u73->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u74 = (TExecuteCommand*) PHBIO_NPP_CALC.GetCommand("u74",TCommand::kUpdate,TCommand::kCode);
	u74->SetExecutable(&PHBIO_NPP_CALC_u74_exe_g);
	u74->Code() = "u74 <-  ( ( ( MAC_PH_BIOMAS <  MAX_PH ) ) ? ( ( ( ( MAC_PROD_CF*P1_NPP )*MAC_PH_BIOMAS )*( ((float)1)-( MAC_PH_BIOMAS/MAX_PH ) ) ) ) : ( ((float)0) ) ) ";
	u74->AddDependency(MAC_PH_BIOMAS);
	u74->AddDependency(MAX_PH);
	u74->AddDependency(MAC_PROD_CF);
	u74->AddDependency(HABITATMAP);
	u74->AddDependency(P1_NPP);
	u74->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u75 = (TExecuteCommand*) PH_TO_ABBM.GetCommand("u75",TCommand::kUpdate,TCommand::kCode);
	u75->SetExecutable(&PH_TO_ABBM_u75_exe_g);
	u75->Code() = "u75 <-  ( ( ( NPH_AB_BM == ((float)0) ) ) ? ( ((float)0) ) : ( ( MAC_PH_BIOMAS/( MAC_PH_BIOMAS+NPH_AB_BM ) ) ) ) ";
	u75->AddDependency(NPH_AB_BM);
	u75->AddDependency(MAC_PH_BIOMAS);
	u75->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u76 = (TExecuteCommand*) PLANTIME.GetCommand("u76",TCommand::kUpdate,TCommand::kCode);
	u76->SetExecutable(&PLANTIME_u76_exe_g);
	u76->Code() = "u76 <-  ( ( ( DAYJUL == P1_P_DAY ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ";
	u76->AddDependency(DAYJUL);
	u76->AddDependency(HABITATMAP);
	u76->AddDependency(P1_P_DAY);
	u76->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u77 = (TExecuteCommand*) PLANTING.GetCommand("u77",TCommand::kUpdate,TCommand::kCode);
	u77->SetExecutable(&PLANTING_u77_exe_g);
	u77->Code() = "u77 <- ( ( PLANTIME*P1_MAX_DENS )*P1_P_WT )";
	u77->AddDependency(PLANTIME);
	u77->AddDependency(HABITATMAP);
	u77->AddDependency(P1_MAX_DENS);
	u77->AddDependency(P1_P_WT);
	u77->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u78 = (TExecuteCommand*) PO4SD_CONCTOT.GetCommand("u78",TCommand::kUpdate,TCommand::kCode);
	u78->SetExecutable(&PO4SD_CONCTOT_u78_exe_g);
	u78->Code() = "u78 <- 1000";
	u78->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u79 = (TExecuteCommand*) REMOVAL_TIME.GetCommand("u79",TCommand::kUpdate,TCommand::kCode);
	u79->SetExecutable(&REMOVAL_TIME_u79_exe_g);
	u79->Code() = "u79 <-  ( ( ( ( MACH*P1_PHB_PR_H ) >  P1_EST_HEIGHT ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ";
	u79->AddDependency(MACH);
	u79->AddDependency(HABITATMAP);
	u79->AddDependency(P1_PHB_PR_H);
	u79->AddDependency(P1_EST_HEIGHT);
	u79->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u80 = (TExecuteCommand*) ROOT_BM.GetCommand("u80",TCommand::kUpdate,TCommand::kCode);
	u80->SetExecutable(&ROOT_BM_u80_exe_g);
	u80->Code() = "u80 <- ( MAC_NPH_BIOMAS/( P1_NPH_AB_BEL+((float)1) ) )";
	u80->AddDependency(MAC_NPH_BIOMAS);
	u80->AddDependency(HABITATMAP);
	u80->AddDependency(P1_NPH_AB_BEL);
	u80->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u82 = (TExecuteCommand*) SPROUTING.GetCommand("u82",TCommand::kUpdate,TCommand::kCode);
	u82->SetExecutable(&SPROUTING_u82_exe_g);
	u82->Code() = "u82 <-  ( ( ( ( PH_TO_ABBM <  P1_MAX_PH_ABBM ) && ( ( BIO_TIME >  P1_BIO_START ) && ( BIO_TIME <  P1_BIO_END ) ) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ";
	u82->AddDependency(PH_TO_ABBM);
	u82->AddDependency(HABITATMAP);
	u82->AddDependency(P1_MAX_PH_ABBM);
	u82->AddDependency(BIO_TIME);
	u82->AddDependency(P1_BIO_START);
	u82->AddDependency(P1_BIO_END);
	u82->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u83 = (TExecuteCommand*) TEMP_CF.GetCommand("u83",TCommand::kUpdate,TCommand::kCode);
	u83->SetExecutable(&TEMP_CF_u83_exe_g);
	u83->Code() = "u83 <- ( SL::Exp(( 0.20*( AIR_TEMP_C-P1_TEMPOPT ) ))*pow((double)( ( ((float)40)-AIR_TEMP_C )/( ((float)40)-P1_TEMPOPT ) ),(double)( 0.20*( ((float)40)-P1_TEMPOPT ) ) ) )";
	u83->AddDependency(AIR_TEMP_C);
	u83->AddDependency(HABITATMAP);
	u83->AddDependency(P1_TEMPOPT);
	u83->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u84 = (TExecuteCommand*) TOTAL_BIOM.GetCommand("u84",TCommand::kUpdate,TCommand::kCode);
	u84->SetExecutable(&TOTAL_BIOM_u84_exe_g);
	u84->Code() = "u84 <- ( MAC_PH_BIOMAS+MAC_NPH_BIOMAS )";
	u84->AddDependency(MAC_PH_BIOMAS);
	u84->AddDependency(MAC_NPH_BIOMAS);
	u84->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u85 = (TExecuteCommand*) TRANSDOWN_RT.GetCommand("u85",TCommand::kUpdate,TCommand::kCode);
	u85->SetExecutable(&TRANSDOWN_RT_u85_exe_g);
	u85->Code() = "u85 <-  ( ( ( BIO_TIME >  ( P1_BIO_REPRO+((float)1) ) ) ) ? ( ( ((float)1)-( ((float)1)/pow((double)( BIO_TIME-P1_BIO_REPRO ),(double)0.5 ) ) ) ) : (  ( ( ( PH_TO_ABBM <  P1_MAX_PH_ABBM ) ) ? ( ((float)0) ) : ( pow((double)SL::Cos(( ( ( P1_MAX_PH_ABBM/PH_TO_ABBM )*3.141590 )/2. )),(double)0.1 ) ) )  ) ) ";
	u85->AddDependency(BIO_TIME);
	u85->AddDependency(HABITATMAP);
	u85->AddDependency(P1_BIO_REPRO);
	u85->AddDependency(PH_TO_ABBM);
	u85->AddDependency(P1_MAX_PH_ABBM);
	u85->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u86 = (TExecuteCommand*) WATER_CF.GetCommand("u86",TCommand::kUpdate,TCommand::kCode);
	u86->SetExecutable(&WATER_CF_u86_exe_g);
	u86->Code() = "u86 <- SL::Min(WAT_STRESS_HIGH, WAT_STRESS_LOW)";
	u86->AddDependency(WAT_STRESS_HIGH);
	u86->AddDependency(WAT_STRESS_LOW);
	u86->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u87 = (TExecuteCommand*) WAT_STRESS_HIGH.GetCommand("u87",TCommand::kUpdate,TCommand::kCode);
	u87->SetExecutable(&WAT_STRESS_HIGH_u87_exe_g);
	u87->Code() = "u87 <-  ( ( ( ( P1_W_T_MAX <  ((float)0) ) && ( SURFACE_WATER >  -P1_W_T_MAX ) ) ) ? ( SL::Max(((float)0), ( ((float)1)/( ((float)1)+SL::Exp(( SURFACE_WATER+P1_W_T_MAX )) ) )) ) : (  ( ( ( ( P1_W_T_MAX >  ((float)0) ) && ( ROOT_DEPTH >  ((float)0) ) ) ) ? ( SL::Min(((float)1), ( ( UW_DEPTH/ROOT_DEPTH )/P1_W_T_MAX )) ) : ( ((float)1) ) )  ) ) ";
	u87->AddDependency(HABITATMAP);
	u87->AddDependency(P1_W_T_MAX);
	u87->AddDependency(SURFACE_WATER);
	u87->AddDependency(ROOT_DEPTH);
	u87->AddDependency(UW_DEPTH);
	u87->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u88 = (TExecuteCommand*) WAT_STRESS_LOW.GetCommand("u88",TCommand::kUpdate,TCommand::kCode);
	u88->SetExecutable(&WAT_STRESS_LOW_u88_exe_g);
	u88->Code() = "u88 <- pow((double)SL::Sin(( ( WATER_AVAIL*3.141590 )/2 )),(double)P1_W_T_MIN )";
	u88->AddDependency(WATER_AVAIL);
	u88->AddDependency(HABITATMAP);
	u88->AddDependency(P1_W_T_MIN);
	u88->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u89 = (TExecuteCommand*) P1_BIO_END.GetCommand("u89",TCommand::kUpdate,TCommand::kCode);
	u89->SetExecutable(&P1_BIO_END_u89_exe_g);
	u89->Code() = "u89 <- ((float)570)";
	u89->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u90 = (TExecuteCommand*) P1_BIO_REPRO.GetCommand("u90",TCommand::kUpdate,TCommand::kCode);
	u90->SetExecutable(&P1_BIO_REPRO_u90_exe_g);
	u90->Code() = "u90 <- ((float)1700)";
	u90->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u91 = (TExecuteCommand*) P1_BIO_START.GetCommand("u91",TCommand::kUpdate,TCommand::kCode);
	u91->SetExecutable(&P1_BIO_START_u91_exe_g);
	u91->Code() = "u91 <- ((float)500)";
	u91->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u92 = (TExecuteCommand*) P1_DAYLENG_RQ.GetCommand("u92",TCommand::kUpdate,TCommand::kCode);
	u92->SetExecutable(&P1_DAYLENG_RQ_u92_exe_g);
	u92->Code() = "u92 <- ((float)13)";
	u92->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u93 = (TExecuteCommand*) P1_EST_HEIGHT.GetCommand("u93",TCommand::kUpdate,TCommand::kCode);
	u93->SetExecutable(&P1_EST_HEIGHT_u93_exe_g);
	u93->Code() = "u93 <- ((float)500)";
	u93->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u94 = (TExecuteCommand*) P1_H_DAY.GetCommand("u94",TCommand::kUpdate,TCommand::kCode);
	u94->SetExecutable(&P1_H_DAY_u94_exe_g);
	u94->Code() = "u94 <- ((float)319)";
	u94->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u95 = (TExecuteCommand*) P1_LIGHTSAT.GetCommand("u95",TCommand::kUpdate,TCommand::kCode);
	u95->SetExecutable(&P1_LIGHTSAT_u95_exe_g);
	u95->Code() = "u95 <- ((float)600)";
	u95->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u96 = (TExecuteCommand*) P1_MAC_KS_N.GetCommand("u96",TCommand::kUpdate,TCommand::kCode);
	u96->SetExecutable(&P1_MAC_KS_N_u96_exe_g);
	u96->Code() = "u96 <- 0.00265";
	u96->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u97 = (TExecuteCommand*) P1_MAC_KS_P.GetCommand("u97",TCommand::kUpdate,TCommand::kCode);
	u97->SetExecutable(&P1_MAC_KS_P_u97_exe_g);
	u97->Code() = "u97 <- 0.000037";
	u97->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u98 = (TExecuteCommand*) P1_MAX_AB_BM.GetCommand("u98",TCommand::kUpdate,TCommand::kCode);
	u98->SetExecutable(&P1_MAX_AB_BM_u98_exe_g);
	u98->Code() = "u98 <- 0.6";
	u98->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u99 = (TExecuteCommand*) P1_MAX_DENS.GetCommand("u99",TCommand::kUpdate,TCommand::kCode);
	u99->SetExecutable(&P1_MAX_DENS_u99_exe_g);
	u99->Code() = "u99 <- ((float)40)";
	u99->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u100 = (TExecuteCommand*) P1_MAX_HT_BM.GetCommand("u100",TCommand::kUpdate,TCommand::kCode);
	u100->SetExecutable(&P1_MAX_HT_BM_u100_exe_g);
	u100->Code() = "u100 <- 0.8";
	u100->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u101 = (TExecuteCommand*) P1_MAX_LAI.GetCommand("u101",TCommand::kUpdate,TCommand::kCode);
	u101->SetExecutable(&P1_MAX_LAI_u101_exe_g);
	u101->Code() = "u101 <- ((float)5)";
	u101->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u102 = (TExecuteCommand*) P1_MAX_PH_ABBM.GetCommand("u102",TCommand::kUpdate,TCommand::kCode);
	u102->SetExecutable(&P1_MAX_PH_ABBM_u102_exe_g);
	u102->Code() = "u102 <- 0.75";
	u102->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u103 = (TExecuteCommand*) P1_NPH_ABBM_IC.GetCommand("u103",TCommand::kUpdate,TCommand::kCode);
	u103->SetExecutable(&P1_NPH_ABBM_IC_u103_exe_g);
	u103->Code() = "u103 <- ((float)0)";
	u103->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u104 = (TExecuteCommand*) P1_NPH_AB_BEL.GetCommand("u104",TCommand::kUpdate,TCommand::kCode);
	u104->SetExecutable(&P1_NPH_AB_BEL_u104_exe_g);
	u104->Code() = "u104 <- 0.7";
	u104->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u105 = (TExecuteCommand*) P1_NPH_MORT.GetCommand("u105",TCommand::kUpdate,TCommand::kCode);
	u105->SetExecutable(&P1_NPH_MORT_u105_exe_g);
	u105->Code() = "u105 <- 0.00000053";
	u105->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u106 = (TExecuteCommand*) P1_NPH_PR_H.GetCommand("u106",TCommand::kUpdate,TCommand::kCode);
	u106->SetExecutable(&P1_NPH_PR_H_u106_exe_g);
	u106->Code() = "u106 <- 0.85";
	u106->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u107 = (TExecuteCommand*) P1_NPP.GetCommand("u107",TCommand::kUpdate,TCommand::kCode);
	u107->SetExecutable(&P1_NPP_u107_exe_g);
	u107->Code() = "u107 <- 0.25";
	u107->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u108 = (TExecuteCommand*) P1_PHB_C_REC.GetCommand("u108",TCommand::kUpdate,TCommand::kCode);
	u108->SetExecutable(&P1_PHB_C_REC_u108_exe_g);
	u108->Code() = "u108 <- ((float)0)";
	u108->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u109 = (TExecuteCommand*) P1_PHB_EVGRN.GetCommand("u109",TCommand::kUpdate,TCommand::kCode);
	u109->SetExecutable(&P1_PHB_EVGRN_u109_exe_g);
	u109->Code() = "u109 <- ((float)0)";
	u109->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u110 = (TExecuteCommand*) P1_PHB_L_RT.GetCommand("u110",TCommand::kUpdate,TCommand::kCode);
	u110->SetExecutable(&P1_PHB_L_RT_u110_exe_g);
	u110->Code() = "u110 <- ((float)0)";
	u110->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u111 = (TExecuteCommand*) P1_PHB_MORT.GetCommand("u111",TCommand::kUpdate,TCommand::kCode);
	u111->SetExecutable(&P1_PHB_MORT_u111_exe_g);
	u111->Code() = "u111 <- ((float)0)";
	u111->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u112 = (TExecuteCommand*) P1_PHB_PR_H.GetCommand("u112",TCommand::kUpdate,TCommand::kCode);
	u112->SetExecutable(&P1_PHB_PR_H_u112_exe_g);
	u112->Code() = "u112 <- 0.8";
	u112->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u113 = (TExecuteCommand*) P1_PH_TO_REP.GetCommand("u113",TCommand::kUpdate,TCommand::kCode);
	u113->SetExecutable(&P1_PH_TO_REP_u113_exe_g);
	u113->Code() = "u113 <- 0.005";
	u113->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u114 = (TExecuteCommand*) P1_PROP_LA_TO_B.GetCommand("u114",TCommand::kUpdate,TCommand::kCode);
	u114->SetExecutable(&P1_PROP_LA_TO_B_u114_exe_g);
	u114->Code() = "u114 <- ((float)12)";
	u114->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u115 = (TExecuteCommand*) P1_P_DAY.GetCommand("u115",TCommand::kUpdate,TCommand::kCode);
	u115->SetExecutable(&P1_P_DAY_u115_exe_g);
	u115->Code() = "u115 <- ((float)191)";
	u115->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u116 = (TExecuteCommand*) P1_P_RATIO.GetCommand("u116",TCommand::kUpdate,TCommand::kCode);
	u116->SetExecutable(&P1_P_RATIO_u116_exe_g);
	u116->Code() = "u116 <- ((float)0)";
	u116->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u117 = (TExecuteCommand*) P1_P_WT.GetCommand("u117",TCommand::kUpdate,TCommand::kCode);
	u117->SetExecutable(&P1_P_WT_u117_exe_g);
	u117->Code() = "u117 <- 0.0009";
	u117->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u118 = (TExecuteCommand*) P1_ROOT_DENS.GetCommand("u118",TCommand::kUpdate,TCommand::kCode);
	u118->SetExecutable(&P1_ROOT_DENS_u118_exe_g);
	u118->Code() = "u118 <- ((float)11)";
	u118->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u119 = (TExecuteCommand*) P1_SPR_RATE.GetCommand("u119",TCommand::kUpdate,TCommand::kCode);
	u119->SetExecutable(&P1_SPR_RATE_u119_exe_g);
	u119->Code() = "u119 <- 0.01";
	u119->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u120 = (TExecuteCommand*) P1_TEMPOPT.GetCommand("u120",TCommand::kUpdate,TCommand::kCode);
	u120->SetExecutable(&P1_TEMPOPT_u120_exe_g);
	u120->Code() = "u120 <- ((float)25)";
	u120->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u121 = (TExecuteCommand*) P1_W_T_MAX.GetCommand("u121",TCommand::kUpdate,TCommand::kCode);
	u121->SetExecutable(&P1_W_T_MAX_u121_exe_g);
	u121->Code() = "u121 <- 0.1";
	u121->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u122 = (TExecuteCommand*) P1_W_T_MIN.GetCommand("u122",TCommand::kUpdate,TCommand::kCode);
	u122->SetExecutable(&P1_W_T_MIN_u122_exe_g);
	u122->Code() = "u122 <- 0.2";
	u122->SetObjInfo(TCommand::kDepIndex, 5);
	TImportCommand* SOLRADGR_import = (TImportCommand*) SOLRADGR.GetCommand("SOLRADGR_import",TCommand::kUndefined,TCommand::kImport);
	SOLRADGR_import->Code() = "Import SOLRADGR from XXXImports4_module";
	SOLRADGR_import->AddDependency(SOLRADGR);
	SOLRADGR_import->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int MACROPHYTES_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int MACROPHYTES_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int MACROPHYTES_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int MACROPHYTES_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class XXXImports4_module 
// ---------------------------------------------------------------------------
XXXImports4_module::XXXImports4_module(char* name) :
	TIME("TIME"),
	SOLRADGR("SOLRADGR"),
	DAYJUL("DAYJUL"),
	TModule(name) {

	SOLRADGR.SetF(FisExport,True,"CG");
	DAYJUL.SetF(FisImport,True,"CG");
}	
int XXXImports4_module::SOLRADGR_u137_exe() {
	float value;

	switch( SOLRADGR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SOLRADGR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph15(DAYJUL.Value(p));
			SOLRADGR.Update( p, value );
		}
		SOLRADGR.GrabMemory();
		if( SOLRADGR.GetF(FLinkEdges) ) { SOLRADGR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph15(DAYJUL.Value());
			SOLRADGR.Update( value );
	  } break;
	}
	return 0;
}

XXXImports4_module* XXXImports4_module::fInstance = NULL;
XXXImports4_module* XXXImports4_module::kNullModel = (XXXImports4_module*)0x1;
int XXXImports4_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int XXXImports4_module::InitVars() {
	
	TIME.SSInit(this);
	SOLRADGR.SSInit(this);
	SOLRADGR.SetF(FisIgnored,False,"InitVars");
	DAYJUL.SSInit(this);
	DAYJUL.SetF(FisIgnored,False,"InitVars");
	fVarList.Alphabetize();
	return 0;
}

int XXXImports4_module::SetupEvents() {
	TExecuteCommand* u137 = (TExecuteCommand*) SOLRADGR.GetCommand("u137",TCommand::kUpdate,TCommand::kCode);
	u137->SetExecutable(&SOLRADGR_u137_exe_g);
	u137->Code() = "u137 <- Graph15(DAYJUL)";
	u137->AddDependency(DAYJUL);
	u137->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DAYJUL_import = (TImportCommand*) DAYJUL.GetCommand("DAYJUL_import",TCommand::kUndefined,TCommand::kImport);
	DAYJUL_import->Code() = "Import DAYJUL from GLOBALS_module";
	DAYJUL_import->AddDependency(DAYJUL);
	DAYJUL_import->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int XXXImports4_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int XXXImports4_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int XXXImports4_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int XXXImports4_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class DOM_module 
// ---------------------------------------------------------------------------
DOM_module::DOM_module(char* name) :
	TIME("TIME"),
	PHBIO_MORT("PHBIO_MORT"),
	PHBIO_HARVEST("PHBIO_HARVEST"),
	NPHBIO_MORT("NPHBIO_MORT"),
	NPHBIO_HARVEST("NPHBIO_HARVEST"),
	AIR_TEMP_C("AIR_TEMP_C"),
	D_DECOMP("D_DECOMP"),
	DEP_ORG_MAT("DEP_ORG_MAT"),
	SD_TO_DOM("SD_TO_DOM"),
	DOM_DECOMP("DOM_DECOMP"),
	LAB_DETRITUS("LAB_DETRITUS"),
	SD_DECOMP("SD_DECOMP"),
	LD_IN("LD_IN"),
	LD_DECOMP("LD_DECOMP"),
	STAB_DETRITUS("STAB_DETRITUS"),
	SD_IN("SD_IN"),
	F_TEMP("F_TEMP"),
	P1_DOM_DEC_RATE("P1_DOM_DEC_RATE"),
	P1_DOM_INIT("P1_DOM_INIT"),
	P1_HARV_NPH_LEFT("P1_HARV_NPH_LEFT"),
	P1_HARV_PH_LEFT("P1_HARV_PH_LEFT"),
	P1_LD_DEC_RATE("P1_LD_DEC_RATE"),
	P1_LD_INIT("P1_LD_INIT"),
	P1_NPH_LIGNIN_CONTENT("P1_NPH_LIGNIN_CONTENT"),
	P1_PH_LIGNIN_CONTENT("P1_PH_LIGNIN_CONTENT"),
	P1_SD_DEC_RATE("P1_SD_DEC_RATE"),
	P1_SD_INIT("P1_SD_INIT"),
	P1_SD_TO_DOM_RATE("P1_SD_TO_DOM_RATE"),
	TModule(name) {

	PHBIO_MORT.SetF(FisImport,True,"CG");
	PHBIO_HARVEST.SetF(FisImport,True,"CG");
	NPHBIO_MORT.SetF(FisImport,True,"CG");
	NPHBIO_HARVEST.SetF(FisImport,True,"CG");
	AIR_TEMP_C.SetF(FisImport,True,"CG");
	D_DECOMP.SetF(FisExport,True,"CG");
}	
int DOM_module::DEP_ORG_MAT_I146_exe() {
	float value;

	DEP_ORG_MAT.UpdateIntegrator();
	switch( DEP_ORG_MAT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DEP_ORG_MAT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SD_TO_DOM.Value(p)-DOM_DECOMP.Value(p) );
			DEP_ORG_MAT.Update( p, value, dT() );
		}
		DEP_ORG_MAT.GrabMemory();
		if( DEP_ORG_MAT.GetF(FLinkEdges) ) { DEP_ORG_MAT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SD_TO_DOM.Value()-DOM_DECOMP.Value() );
			DEP_ORG_MAT.Update( value, dT() );
	  } break;
	}
	return 0;
}

int DOM_module::DEP_ORG_MAT_i147_exe() {
	float value;

	DEP_ORG_MAT.UpdateIntegrator();
	switch( DEP_ORG_MAT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DEP_ORG_MAT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  P1_DOM_INIT.Value(p);
			DEP_ORG_MAT.InitValue( p, value );
		}
		DEP_ORG_MAT.GrabMemory();
		if( DEP_ORG_MAT.GetF(FLinkEdges) ) { DEP_ORG_MAT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  P1_DOM_INIT.Value();
			DEP_ORG_MAT.InitValue( value );
	  } break;
	}
	return 0;
}

int DOM_module::SD_TO_DOM_u148_exe() {
	float value;

	switch( SD_TO_DOM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SD_TO_DOM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_SD_TO_DOM_RATE.Value(p)*STAB_DETRITUS.Value(p) );
			SD_TO_DOM.Update( p, value );
		}
		SD_TO_DOM.GrabMemory();
		if( SD_TO_DOM.GetF(FICFlux) ) SD_TO_DOM.Cov().Set(0.0); 
		if( SD_TO_DOM.GetF(FLinkEdges) ) { SD_TO_DOM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_SD_TO_DOM_RATE.Value()*STAB_DETRITUS.Value() );
			SD_TO_DOM.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::DOM_DECOMP_u149_exe() {
	float value;

	switch( DOM_DECOMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DOM_DECOMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_DOM_DEC_RATE.Value(p)*F_TEMP.Value(p) )*DEP_ORG_MAT.Value(p) );
			DOM_DECOMP.Update( p, value );
		}
		DOM_DECOMP.GrabMemory();
		if( DOM_DECOMP.GetF(FICFlux) ) DOM_DECOMP.Cov().Set(0.0); 
		if( DOM_DECOMP.GetF(FLinkEdges) ) { DOM_DECOMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_DOM_DEC_RATE.Value()*F_TEMP.Value() )*DEP_ORG_MAT.Value() );
			DOM_DECOMP.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::LAB_DETRITUS_I150_exe() {
	float value;

	LAB_DETRITUS.UpdateIntegrator();
	switch( LAB_DETRITUS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LAB_DETRITUS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SD_DECOMP.Value(p)+LD_IN.Value(p) )-LD_DECOMP.Value(p) );
			LAB_DETRITUS.Update( p, value, dT() );
		}
		LAB_DETRITUS.GrabMemory();
		if( LAB_DETRITUS.GetF(FLinkEdges) ) { LAB_DETRITUS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SD_DECOMP.Value()+LD_IN.Value() )-LD_DECOMP.Value() );
			LAB_DETRITUS.Update( value, dT() );
	  } break;
	}
	return 0;
}

int DOM_module::LAB_DETRITUS_i151_exe() {
	float value;

	LAB_DETRITUS.UpdateIntegrator();
	switch( LAB_DETRITUS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LAB_DETRITUS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  P1_LD_INIT.Value(p);
			LAB_DETRITUS.InitValue( p, value );
		}
		LAB_DETRITUS.GrabMemory();
		if( LAB_DETRITUS.GetF(FLinkEdges) ) { LAB_DETRITUS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  P1_LD_INIT.Value();
			LAB_DETRITUS.InitValue( value );
	  } break;
	}
	return 0;
}

int DOM_module::SD_DECOMP_u152_exe() {
	float value;

	switch( SD_DECOMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SD_DECOMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_SD_DEC_RATE.Value(p)*F_TEMP.Value(p) )*STAB_DETRITUS.Value(p) );
			SD_DECOMP.Update( p, value );
		}
		SD_DECOMP.GrabMemory();
		if( SD_DECOMP.GetF(FICFlux) ) SD_DECOMP.Cov().Set(0.0); 
		if( SD_DECOMP.GetF(FLinkEdges) ) { SD_DECOMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_SD_DEC_RATE.Value()*F_TEMP.Value() )*STAB_DETRITUS.Value() );
			SD_DECOMP.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::LD_IN_u153_exe() {
	float value;

	switch( LD_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LD_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ((float)1)-P1_PH_LIGNIN_CONTENT.Value(p) )*( PHBIO_MORT.Value(p)+( PHBIO_HARVEST.Value(p)*P1_HARV_PH_LEFT.Value(p) ) ) )+( ( ((float)1)-P1_NPH_LIGNIN_CONTENT.Value(p) )*( NPHBIO_MORT.Value(p)+( NPHBIO_HARVEST.Value(p)*P1_HARV_NPH_LEFT.Value(p) ) ) ) );
			LD_IN.Update( p, value );
		}
		LD_IN.GrabMemory();
		if( LD_IN.GetF(FICFlux) ) LD_IN.Cov().Set(0.0); 
		if( LD_IN.GetF(FLinkEdges) ) { LD_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ((float)1)-P1_PH_LIGNIN_CONTENT.Value() )*( PHBIO_MORT.Value()+( PHBIO_HARVEST.Value()*P1_HARV_PH_LEFT.Value() ) ) )+( ( ((float)1)-P1_NPH_LIGNIN_CONTENT.Value() )*( NPHBIO_MORT.Value()+( NPHBIO_HARVEST.Value()*P1_HARV_NPH_LEFT.Value() ) ) ) );
			LD_IN.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::LD_DECOMP_u154_exe() {
	float value;

	switch( LD_DECOMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LD_DECOMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_LD_DEC_RATE.Value(p)*F_TEMP.Value(p) )*LAB_DETRITUS.Value(p) );
			LD_DECOMP.Update( p, value );
		}
		LD_DECOMP.GrabMemory();
		if( LD_DECOMP.GetF(FICFlux) ) LD_DECOMP.Cov().Set(0.0); 
		if( LD_DECOMP.GetF(FLinkEdges) ) { LD_DECOMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_LD_DEC_RATE.Value()*F_TEMP.Value() )*LAB_DETRITUS.Value() );
			LD_DECOMP.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::STAB_DETRITUS_I155_exe() {
	float value;

	STAB_DETRITUS.UpdateIntegrator();
	switch( STAB_DETRITUS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = STAB_DETRITUS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SD_IN.Value(p)-SD_DECOMP.Value(p) )-SD_TO_DOM.Value(p) );
			STAB_DETRITUS.Update( p, value, dT() );
		}
		STAB_DETRITUS.GrabMemory();
		if( STAB_DETRITUS.GetF(FLinkEdges) ) { STAB_DETRITUS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SD_IN.Value()-SD_DECOMP.Value() )-SD_TO_DOM.Value() );
			STAB_DETRITUS.Update( value, dT() );
	  } break;
	}
	return 0;
}

int DOM_module::STAB_DETRITUS_i156_exe() {
	float value;

	STAB_DETRITUS.UpdateIntegrator();
	switch( STAB_DETRITUS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = STAB_DETRITUS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  P1_SD_INIT.Value(p);
			STAB_DETRITUS.InitValue( p, value );
		}
		STAB_DETRITUS.GrabMemory();
		if( STAB_DETRITUS.GetF(FLinkEdges) ) { STAB_DETRITUS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  P1_SD_INIT.Value();
			STAB_DETRITUS.InitValue( value );
	  } break;
	}
	return 0;
}

int DOM_module::SD_IN_u157_exe() {
	float value;

	switch( SD_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SD_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_PH_LIGNIN_CONTENT.Value(p)*( PHBIO_MORT.Value(p)+( PHBIO_HARVEST.Value(p)*P1_HARV_PH_LEFT.Value(p) ) ) )+( P1_NPH_LIGNIN_CONTENT.Value(p)*( NPHBIO_MORT.Value(p)+( NPHBIO_HARVEST.Value(p)*P1_HARV_NPH_LEFT.Value(p) ) ) ) );
			SD_IN.Update( p, value );
		}
		SD_IN.GrabMemory();
		if( SD_IN.GetF(FICFlux) ) SD_IN.Cov().Set(0.0); 
		if( SD_IN.GetF(FLinkEdges) ) { SD_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_PH_LIGNIN_CONTENT.Value()*( PHBIO_MORT.Value()+( PHBIO_HARVEST.Value()*P1_HARV_PH_LEFT.Value() ) ) )+( P1_NPH_LIGNIN_CONTENT.Value()*( NPHBIO_MORT.Value()+( NPHBIO_HARVEST.Value()*P1_HARV_NPH_LEFT.Value() ) ) ) );
			SD_IN.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::D_DECOMP_u158_exe() {
	float value;

	switch( D_DECOMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = D_DECOMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DOM_DECOMP.Value(p)+LD_DECOMP.Value(p) );
			D_DECOMP.Update( p, value );
		}
		D_DECOMP.GrabMemory();
		if( D_DECOMP.GetF(FLinkEdges) ) { D_DECOMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DOM_DECOMP.Value()+LD_DECOMP.Value() );
			D_DECOMP.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::F_TEMP_u159_exe() {
	float value;

	switch( F_TEMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = F_TEMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  pow((double)((float)2),(double)( ( AIR_TEMP_C.Value(p)-((float)20) )/10. ) );
			F_TEMP.Update( p, value );
		}
		F_TEMP.GrabMemory();
		if( F_TEMP.GetF(FLinkEdges) ) { F_TEMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  pow((double)((float)2),(double)( ( AIR_TEMP_C.Value()-((float)20) )/10. ) );
			F_TEMP.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::P1_DOM_DEC_RATE_u160_exe() {
	float value;

	switch( P1_DOM_DEC_RATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DOM_DEC_RATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.001000;
			P1_DOM_DEC_RATE.Update( p, P1_DOM_DEC_RATE.ParameterValue(value,p) );
		}
		P1_DOM_DEC_RATE.GrabMemory();
		if( P1_DOM_DEC_RATE.GetF(FLinkEdges) ) { P1_DOM_DEC_RATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.001000;
			P1_DOM_DEC_RATE.Update( P1_DOM_DEC_RATE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_DOM_INIT_u161_exe() {
	float value;

	switch( P1_DOM_INIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DOM_INIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_DOM_INIT.Update( p, P1_DOM_INIT.ParameterValue(value,p) );
		}
		P1_DOM_INIT.GrabMemory();
		if( P1_DOM_INIT.GetF(FLinkEdges) ) { P1_DOM_INIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_DOM_INIT.Update( P1_DOM_INIT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_HARV_NPH_LEFT_u162_exe() {
	float value;

	switch( P1_HARV_NPH_LEFT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_HARV_NPH_LEFT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.800000;
			P1_HARV_NPH_LEFT.Update( p, P1_HARV_NPH_LEFT.ParameterValue(value,p) );
		}
		P1_HARV_NPH_LEFT.GrabMemory();
		if( P1_HARV_NPH_LEFT.GetF(FLinkEdges) ) { P1_HARV_NPH_LEFT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.800000;
			P1_HARV_NPH_LEFT.Update( P1_HARV_NPH_LEFT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_HARV_PH_LEFT_u163_exe() {
	float value;

	switch( P1_HARV_PH_LEFT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_HARV_PH_LEFT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.100000;
			P1_HARV_PH_LEFT.Update( p, P1_HARV_PH_LEFT.ParameterValue(value,p) );
		}
		P1_HARV_PH_LEFT.GrabMemory();
		if( P1_HARV_PH_LEFT.GetF(FLinkEdges) ) { P1_HARV_PH_LEFT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.100000;
			P1_HARV_PH_LEFT.Update( P1_HARV_PH_LEFT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_LD_DEC_RATE_u164_exe() {
	float value;

	switch( P1_LD_DEC_RATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_LD_DEC_RATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.030000;
			P1_LD_DEC_RATE.Update( p, P1_LD_DEC_RATE.ParameterValue(value,p) );
		}
		P1_LD_DEC_RATE.GrabMemory();
		if( P1_LD_DEC_RATE.GetF(FLinkEdges) ) { P1_LD_DEC_RATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.030000;
			P1_LD_DEC_RATE.Update( P1_LD_DEC_RATE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_LD_INIT_u165_exe() {
	float value;

	switch( P1_LD_INIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_LD_INIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.800000;
			P1_LD_INIT.Update( p, P1_LD_INIT.ParameterValue(value,p) );
		}
		P1_LD_INIT.GrabMemory();
		if( P1_LD_INIT.GetF(FLinkEdges) ) { P1_LD_INIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.800000;
			P1_LD_INIT.Update( P1_LD_INIT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_NPH_LIGNIN_CONTENT_u166_exe() {
	float value;

	switch( P1_NPH_LIGNIN_CONTENT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_NPH_LIGNIN_CONTENT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.500000;
			P1_NPH_LIGNIN_CONTENT.Update( p, P1_NPH_LIGNIN_CONTENT.ParameterValue(value,p) );
		}
		P1_NPH_LIGNIN_CONTENT.GrabMemory();
		if( P1_NPH_LIGNIN_CONTENT.GetF(FLinkEdges) ) { P1_NPH_LIGNIN_CONTENT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.500000;
			P1_NPH_LIGNIN_CONTENT.Update( P1_NPH_LIGNIN_CONTENT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_PH_LIGNIN_CONTENT_u167_exe() {
	float value;

	switch( P1_PH_LIGNIN_CONTENT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PH_LIGNIN_CONTENT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.025000;
			P1_PH_LIGNIN_CONTENT.Update( p, P1_PH_LIGNIN_CONTENT.ParameterValue(value,p) );
		}
		P1_PH_LIGNIN_CONTENT.GrabMemory();
		if( P1_PH_LIGNIN_CONTENT.GetF(FLinkEdges) ) { P1_PH_LIGNIN_CONTENT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.025000;
			P1_PH_LIGNIN_CONTENT.Update( P1_PH_LIGNIN_CONTENT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_SD_DEC_RATE_u168_exe() {
	float value;

	switch( P1_SD_DEC_RATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SD_DEC_RATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.001000;
			P1_SD_DEC_RATE.Update( p, P1_SD_DEC_RATE.ParameterValue(value,p) );
		}
		P1_SD_DEC_RATE.GrabMemory();
		if( P1_SD_DEC_RATE.GetF(FLinkEdges) ) { P1_SD_DEC_RATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.001000;
			P1_SD_DEC_RATE.Update( P1_SD_DEC_RATE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_SD_INIT_u169_exe() {
	float value;

	switch( P1_SD_INIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SD_INIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1.200000;
			P1_SD_INIT.Update( p, P1_SD_INIT.ParameterValue(value,p) );
		}
		P1_SD_INIT.GrabMemory();
		if( P1_SD_INIT.GetF(FLinkEdges) ) { P1_SD_INIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1.200000;
			P1_SD_INIT.Update( P1_SD_INIT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_SD_TO_DOM_RATE_u170_exe() {
	float value;

	switch( P1_SD_TO_DOM_RATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SD_TO_DOM_RATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000700;
			P1_SD_TO_DOM_RATE.Update( p, P1_SD_TO_DOM_RATE.ParameterValue(value,p) );
		}
		P1_SD_TO_DOM_RATE.GrabMemory();
		if( P1_SD_TO_DOM_RATE.GetF(FLinkEdges) ) { P1_SD_TO_DOM_RATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000700;
			P1_SD_TO_DOM_RATE.Update( P1_SD_TO_DOM_RATE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

DOM_module* DOM_module::fInstance = NULL;
DOM_module* DOM_module::kNullModel = (DOM_module*)0x1;
int DOM_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int DOM_module::InitVars() {
	
	TIME.SSInit(this);
	PHBIO_MORT.SSInit(this);
	PHBIO_HARVEST.SSInit(this);
	NPHBIO_MORT.SSInit(this);
	NPHBIO_HARVEST.SSInit(this);
	AIR_TEMP_C.SSInit(this);
	D_DECOMP.SSInit(this);
	DEP_ORG_MAT.SSInit(this);
	SD_TO_DOM.SSInit(this);
	SD_TO_DOM.SetOrigin(&STAB_DETRITUS);
	SD_TO_DOM.SetDestination(&DEP_ORG_MAT);
	DOM_DECOMP.SSInit(this);
	DOM_DECOMP.SetOrigin(&DEP_ORG_MAT);
	LAB_DETRITUS.SSInit(this);
	SD_DECOMP.SSInit(this);
	SD_DECOMP.SetOrigin(&STAB_DETRITUS);
	SD_DECOMP.SetDestination(&LAB_DETRITUS);
	LD_IN.SSInit(this);
	LD_IN.SetDestination(&LAB_DETRITUS);
	LD_DECOMP.SSInit(this);
	LD_DECOMP.SetOrigin(&LAB_DETRITUS);
	STAB_DETRITUS.SSInit(this);
	SD_IN.SSInit(this);
	SD_IN.SetDestination(&STAB_DETRITUS);
	F_TEMP.SSInit(this);
	P1_DOM_DEC_RATE.SSInit(this);
	P1_DOM_INIT.SSInit(this);
	P1_HARV_NPH_LEFT.SSInit(this);
	P1_HARV_PH_LEFT.SSInit(this);
	P1_LD_DEC_RATE.SSInit(this);
	P1_LD_INIT.SSInit(this);
	P1_NPH_LIGNIN_CONTENT.SSInit(this);
	P1_PH_LIGNIN_CONTENT.SSInit(this);
	P1_SD_DEC_RATE.SSInit(this);
	P1_SD_INIT.SSInit(this);
	P1_SD_TO_DOM_RATE.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int DOM_module::SetupEvents() {
	TImportCommand* PHBIO_MORT_import = (TImportCommand*) PHBIO_MORT.GetCommand("PHBIO_MORT_import",TCommand::kUndefined,TCommand::kImport);
	PHBIO_MORT_import->Code() = "Import PHBIO_MORT from MACROPHYTES_module";
	PHBIO_MORT_import->AddDependency(PHBIO_MORT);
	PHBIO_MORT_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PHBIO_HARVEST_import = (TImportCommand*) PHBIO_HARVEST.GetCommand("PHBIO_HARVEST_import",TCommand::kUndefined,TCommand::kImport);
	PHBIO_HARVEST_import->Code() = "Import PHBIO_HARVEST from MACROPHYTES_module";
	PHBIO_HARVEST_import->AddDependency(PHBIO_HARVEST);
	PHBIO_HARVEST_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* NPHBIO_MORT_import = (TImportCommand*) NPHBIO_MORT.GetCommand("NPHBIO_MORT_import",TCommand::kUndefined,TCommand::kImport);
	NPHBIO_MORT_import->Code() = "Import NPHBIO_MORT from MACROPHYTES_module";
	NPHBIO_MORT_import->AddDependency(NPHBIO_MORT);
	NPHBIO_MORT_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* NPHBIO_HARVEST_import = (TImportCommand*) NPHBIO_HARVEST.GetCommand("NPHBIO_HARVEST_import",TCommand::kUndefined,TCommand::kImport);
	NPHBIO_HARVEST_import->Code() = "Import NPHBIO_HARVEST from MACROPHYTES_module";
	NPHBIO_HARVEST_import->AddDependency(NPHBIO_HARVEST);
	NPHBIO_HARVEST_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* AIR_TEMP_C_import = (TImportCommand*) AIR_TEMP_C.GetCommand("AIR_TEMP_C_import",TCommand::kUndefined,TCommand::kImport);
	AIR_TEMP_C_import->Code() = "Import AIR_TEMP_C from GLOBALS_module";
	AIR_TEMP_C_import->AddDependency(AIR_TEMP_C);
	AIR_TEMP_C_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u158 = (TExecuteCommand*) D_DECOMP.GetCommand("u158",TCommand::kUpdate,TCommand::kCode);
	u158->SetExecutable(&D_DECOMP_u158_exe_g);
	u158->Code() = "u158 <- ( DOM_DECOMP+LD_DECOMP )";
	u158->AddDependency(DOM_DECOMP);
	u158->AddDependency(LD_DECOMP);
	u158->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I146 = (TExecuteCommand*) DEP_ORG_MAT.GetCommand("I146",TCommand::kIntegrate,TCommand::kCode);
	I146->SetExecutable(&DEP_ORG_MAT_I146_exe_g);
	I146->Code() = "I146 <- ( SD_TO_DOM-DOM_DECOMP )";
	I146->AddDependency(SD_TO_DOM);
	I146->AddDependency(DOM_DECOMP);
	I146->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i147 = (TExecuteCommand*) DEP_ORG_MAT.GetCommand("i147",TCommand::kInit,TCommand::kCode);
	i147->SetExecutable(&DEP_ORG_MAT_i147_exe_g);
	i147->Code() = "i147 <- P1_DOM_INIT";
	i147->AddDependency(P1_DOM_INIT);
	i147->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u148 = (TExecuteCommand*) SD_TO_DOM.GetCommand("u148",TCommand::kUpdate,TCommand::kCode);
	u148->SetExecutable(&SD_TO_DOM_u148_exe_g);
	u148->Code() = "u148 <- ( P1_SD_TO_DOM_RATE*STAB_DETRITUS )";
	if( SD_TO_DOM.GetF(FisClamped) ) { u148->AddDependency(STAB_DETRITUS); }
	u148->AddDependency(P1_SD_TO_DOM_RATE);
	u148->AddDependency(STAB_DETRITUS);
	u148->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u149 = (TExecuteCommand*) DOM_DECOMP.GetCommand("u149",TCommand::kUpdate,TCommand::kCode);
	u149->SetExecutable(&DOM_DECOMP_u149_exe_g);
	u149->Code() = "u149 <- ( ( P1_DOM_DEC_RATE*F_TEMP )*DEP_ORG_MAT )";
	if( DOM_DECOMP.GetF(FisClamped) ) { u149->AddDependency(DEP_ORG_MAT); }
	u149->AddDependency(P1_DOM_DEC_RATE);
	u149->AddDependency(F_TEMP);
	u149->AddDependency(DEP_ORG_MAT);
	u149->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I150 = (TExecuteCommand*) LAB_DETRITUS.GetCommand("I150",TCommand::kIntegrate,TCommand::kCode);
	I150->SetExecutable(&LAB_DETRITUS_I150_exe_g);
	I150->Code() = "I150 <- ( ( SD_DECOMP+LD_IN )-LD_DECOMP )";
	I150->AddDependency(SD_DECOMP);
	I150->AddDependency(LD_IN);
	I150->AddDependency(LD_DECOMP);
	I150->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i151 = (TExecuteCommand*) LAB_DETRITUS.GetCommand("i151",TCommand::kInit,TCommand::kCode);
	i151->SetExecutable(&LAB_DETRITUS_i151_exe_g);
	i151->Code() = "i151 <- P1_LD_INIT";
	i151->AddDependency(P1_LD_INIT);
	i151->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u152 = (TExecuteCommand*) SD_DECOMP.GetCommand("u152",TCommand::kUpdate,TCommand::kCode);
	u152->SetExecutable(&SD_DECOMP_u152_exe_g);
	u152->Code() = "u152 <- ( ( P1_SD_DEC_RATE*F_TEMP )*STAB_DETRITUS )";
	if( SD_DECOMP.GetF(FisClamped) ) { u152->AddDependency(STAB_DETRITUS); }
	u152->AddDependency(P1_SD_DEC_RATE);
	u152->AddDependency(F_TEMP);
	u152->AddDependency(STAB_DETRITUS);
	u152->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u153 = (TExecuteCommand*) LD_IN.GetCommand("u153",TCommand::kUpdate,TCommand::kCode);
	u153->SetExecutable(&LD_IN_u153_exe_g);
	u153->Code() = "u153 <- ( ( ( ((float)1)-P1_PH_LIGNIN_CONTENT )*( PHBIO_MORT+( PHBIO_HARVEST*P1_HARV_PH_LEFT ) ) )+( ( ((float)1)-P1_NPH_LIGNIN_CONTENT )*( NPHBIO_MORT+( NPHBIO_HARVEST*P1_HARV_NPH_LEFT ) ) ) )";
	u153->AddDependency(P1_PH_LIGNIN_CONTENT);
	u153->AddDependency(PHBIO_MORT);
	u153->AddDependency(PHBIO_HARVEST);
	u153->AddDependency(P1_HARV_PH_LEFT);
	u153->AddDependency(P1_NPH_LIGNIN_CONTENT);
	u153->AddDependency(NPHBIO_MORT);
	u153->AddDependency(NPHBIO_HARVEST);
	u153->AddDependency(P1_HARV_NPH_LEFT);
	u153->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u154 = (TExecuteCommand*) LD_DECOMP.GetCommand("u154",TCommand::kUpdate,TCommand::kCode);
	u154->SetExecutable(&LD_DECOMP_u154_exe_g);
	u154->Code() = "u154 <- ( ( P1_LD_DEC_RATE*F_TEMP )*LAB_DETRITUS )";
	if( LD_DECOMP.GetF(FisClamped) ) { u154->AddDependency(LAB_DETRITUS); }
	u154->AddDependency(P1_LD_DEC_RATE);
	u154->AddDependency(F_TEMP);
	u154->AddDependency(LAB_DETRITUS);
	u154->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I155 = (TExecuteCommand*) STAB_DETRITUS.GetCommand("I155",TCommand::kIntegrate,TCommand::kCode);
	I155->SetExecutable(&STAB_DETRITUS_I155_exe_g);
	I155->Code() = "I155 <- ( ( SD_IN-SD_DECOMP )-SD_TO_DOM )";
	I155->AddDependency(SD_IN);
	I155->AddDependency(SD_DECOMP);
	I155->AddDependency(SD_TO_DOM);
	I155->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i156 = (TExecuteCommand*) STAB_DETRITUS.GetCommand("i156",TCommand::kInit,TCommand::kCode);
	i156->SetExecutable(&STAB_DETRITUS_i156_exe_g);
	i156->Code() = "i156 <- P1_SD_INIT";
	i156->AddDependency(P1_SD_INIT);
	i156->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u157 = (TExecuteCommand*) SD_IN.GetCommand("u157",TCommand::kUpdate,TCommand::kCode);
	u157->SetExecutable(&SD_IN_u157_exe_g);
	u157->Code() = "u157 <- ( ( P1_PH_LIGNIN_CONTENT*( PHBIO_MORT+( PHBIO_HARVEST*P1_HARV_PH_LEFT ) ) )+( P1_NPH_LIGNIN_CONTENT*( NPHBIO_MORT+( NPHBIO_HARVEST*P1_HARV_NPH_LEFT ) ) ) )";
	u157->AddDependency(P1_PH_LIGNIN_CONTENT);
	u157->AddDependency(PHBIO_MORT);
	u157->AddDependency(PHBIO_HARVEST);
	u157->AddDependency(P1_HARV_PH_LEFT);
	u157->AddDependency(P1_NPH_LIGNIN_CONTENT);
	u157->AddDependency(NPHBIO_MORT);
	u157->AddDependency(NPHBIO_HARVEST);
	u157->AddDependency(P1_HARV_NPH_LEFT);
	u157->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u159 = (TExecuteCommand*) F_TEMP.GetCommand("u159",TCommand::kUpdate,TCommand::kCode);
	u159->SetExecutable(&F_TEMP_u159_exe_g);
	u159->Code() = "u159 <- pow((double)((float)2),(double)( ( AIR_TEMP_C-((float)20) )/10. ) )";
	u159->AddDependency(AIR_TEMP_C);
	u159->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u160 = (TExecuteCommand*) P1_DOM_DEC_RATE.GetCommand("u160",TCommand::kUpdate,TCommand::kCode);
	u160->SetExecutable(&P1_DOM_DEC_RATE_u160_exe_g);
	u160->Code() = "u160 <- 0.001000";
	u160->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u161 = (TExecuteCommand*) P1_DOM_INIT.GetCommand("u161",TCommand::kUpdate,TCommand::kCode);
	u161->SetExecutable(&P1_DOM_INIT_u161_exe_g);
	u161->Code() = "u161 <- 1";
	u161->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u162 = (TExecuteCommand*) P1_HARV_NPH_LEFT.GetCommand("u162",TCommand::kUpdate,TCommand::kCode);
	u162->SetExecutable(&P1_HARV_NPH_LEFT_u162_exe_g);
	u162->Code() = "u162 <- 0.800000";
	u162->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u163 = (TExecuteCommand*) P1_HARV_PH_LEFT.GetCommand("u163",TCommand::kUpdate,TCommand::kCode);
	u163->SetExecutable(&P1_HARV_PH_LEFT_u163_exe_g);
	u163->Code() = "u163 <- 0.100000";
	u163->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u164 = (TExecuteCommand*) P1_LD_DEC_RATE.GetCommand("u164",TCommand::kUpdate,TCommand::kCode);
	u164->SetExecutable(&P1_LD_DEC_RATE_u164_exe_g);
	u164->Code() = "u164 <- 0.030000";
	u164->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u165 = (TExecuteCommand*) P1_LD_INIT.GetCommand("u165",TCommand::kUpdate,TCommand::kCode);
	u165->SetExecutable(&P1_LD_INIT_u165_exe_g);
	u165->Code() = "u165 <- 0.800000";
	u165->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u166 = (TExecuteCommand*) P1_NPH_LIGNIN_CONTENT.GetCommand("u166",TCommand::kUpdate,TCommand::kCode);
	u166->SetExecutable(&P1_NPH_LIGNIN_CONTENT_u166_exe_g);
	u166->Code() = "u166 <- 0.500000";
	u166->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u167 = (TExecuteCommand*) P1_PH_LIGNIN_CONTENT.GetCommand("u167",TCommand::kUpdate,TCommand::kCode);
	u167->SetExecutable(&P1_PH_LIGNIN_CONTENT_u167_exe_g);
	u167->Code() = "u167 <- 0.025000";
	u167->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u168 = (TExecuteCommand*) P1_SD_DEC_RATE.GetCommand("u168",TCommand::kUpdate,TCommand::kCode);
	u168->SetExecutable(&P1_SD_DEC_RATE_u168_exe_g);
	u168->Code() = "u168 <- 0.001000";
	u168->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u169 = (TExecuteCommand*) P1_SD_INIT.GetCommand("u169",TCommand::kUpdate,TCommand::kCode);
	u169->SetExecutable(&P1_SD_INIT_u169_exe_g);
	u169->Code() = "u169 <- 1.200000";
	u169->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u170 = (TExecuteCommand*) P1_SD_TO_DOM_RATE.GetCommand("u170",TCommand::kUpdate,TCommand::kCode);
	u170->SetExecutable(&P1_SD_TO_DOM_RATE_u170_exe_g);
	u170->Code() = "u170 <- 0.000700";
	u170->SetObjInfo(TCommand::kDepIndex, 5);
	return 0;
}

int DOM_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int DOM_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int DOM_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int DOM_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class ZDIN_module 
// ---------------------------------------------------------------------------
ZDIN_module::ZDIN_module(char* name) :
	TIME("TIME"),
	DIN_AVAILABLE("DIN_AVAILABLE"),
	DAYJUL("DAYJUL"),
	SAT_WATER("SAT_WATER"),
	UNSAT_WATER("UNSAT_WATER"),
	UW_FROM_PRECIP("UW_FROM_PRECIP"),
	SW_TO_SATW_DOWNFLOW("SW_TO_SATW_DOWNFLOW"),
	SATW_FROM_PRECIP("SATW_FROM_PRECIP"),
	CELL_SIZE("CELL_SIZE"),
	AIR_TEMP_C("AIR_TEMP_C"),
	SATW_TO_SW_UPFLOW("SATW_TO_SW_UPFLOW"),
	PHBIO_NPP("PHBIO_NPP"),
	UW_DEPTH("UW_DEPTH"),
	ELEVATION("ELEVATION"),
	SATW_OUTFLUX("SATW_OUTFLUX"),
	SW_OUTFLUX("SW_OUTFLUX"),
	HABITATMAP("HABITATMAP"),
	ROOT_DEPTH("ROOT_DEPTH"),
	SURFACE_WATER("SURFACE_WATER"),
	D_DECOMP("D_DECOMP"),
	SATW_TRANSP("SATW_TRANSP"),
	UW_ETRANSP("UW_ETRANSP"),
	DIN_SD("DIN_SD"),
	DIN_SF("DIN_SF"),
	A_IN("A_IN"),
	ATM_FLOW("ATM_FLOW"),
	DIN_FERT_AV("DIN_FERT_AV"),
	DIN_FERT("DIN_FERT"),
	FERT_AV("FERT_AV"),
	DIN_DNFLOW("DIN_DNFLOW"),
	DINSD_LOAD("DINSD_LOAD"),
	DOM_TO_DINSD("DOM_TO_DINSD"),
	DINSD_DENIT("DINSD_DENIT"),
	DIN_UPFLOW("DIN_UPFLOW"),
	DINSD_UPTAKE("DINSD_UPTAKE"),
	DINSD_HOUT("DINSD_HOUT"),
	DINSF_ATM("DINSF_ATM"),
	DOM_TO_DINSF("DOM_TO_DINSF"),
	DINSF_UPTAKE("DINSF_UPTAKE"),
	DINSF_OUT("DINSF_OUT"),
	F_IN("F_IN"),
	FERT_FLOW("FERT_FLOW"),
	M_IN("M_IN"),
	MINER_FLOW("MINER_FLOW"),
	S_IN("S_IN"),
	SEPTIC_FLOW("SEPTIC_FLOW"),
	COUNTY("COUNTY"),
	CROP("CROP"),
	DINSD_AVAIL("DINSD_AVAIL"),
	DINSD_CONC("DINSD_CONC"),
	DINSD_PR1("DINSD_PR1"),
	DINSD_PR2("DINSD_PR2"),
	DINSD_PR3("DINSD_PR3"),
	DINSF_AVAIL("DINSF_AVAIL"),
	DINSF_CONC("DINSF_CONC"),
	DINSF_PR1("DINSF_PR1"),
	DINSF_PR2("DINSF_PR2"),
	DIN_ATMOS_LOAD("DIN_ATMOS_LOAD"),
	DOM_TO_DIN("DOM_TO_DIN"),
	N_NPOINTSD("N_NPOINTSD"),
	OUTPUTCOL("OUTPUTCOL"),
	OUTPUTROW("OUTPUTROW"),
	OUTPUTVAR("OUTPUTVAR"),
	SR_WATER("SR_WATER"),
	ZONMAP("ZONMAP"),
	P1_BOCOEF("P1_BOCOEF"),
	P1_DINSD_OUT("P1_DINSD_OUT"),
	P1_DINSF_OUT("P1_DINSF_OUT"),
	P1_DIN_CR_SED_MIN("P1_DIN_CR_SED_MIN"),
	P1_DIN_DAY_FERT1("P1_DIN_DAY_FERT1"),
	P1_DIN_DAY_FERT2("P1_DIN_DAY_FERT2"),
	P1_DIN_DIFFCOEF("P1_DIN_DIFFCOEF"),
	P1_DIN_FERT_APP("P1_DIN_FERT_APP"),
	P1_DIN_FERT_DIS("P1_DIN_FERT_DIS"),
	P1_DIN_FERT_HAB1("P1_DIN_FERT_HAB1"),
	P1_DIN_FERT_HAB2("P1_DIN_FERT_HAB2"),
	P1_DIN_GRAD("P1_DIN_GRAD"),
	P1_DIN_ICSED("P1_DIN_ICSED"),
	P1_DIN_ICSF("P1_DIN_ICSF"),
	P1_DIN_K_OF_NH4("P1_DIN_K_OF_NH4"),
	P1_DIN_RCDENIT("P1_DIN_RCDENIT"),
	P1_DOMSD_ANAEROB_Z("P1_DOMSD_ANAEROB_Z"),
	P1_DOM_CTOOM("P1_DOM_CTOOM"),
	P1_DOM_NC("P1_DOM_NC"),
	P1_D_DEP_FACTOR("P1_D_DEP_FACTOR"),
	P1_NPOINTNSF("P1_NPOINTNSF"),
	P1_PHBIO_NC("P1_PHBIO_NC"),
	P1_PHBIO_NC_SF("P1_PHBIO_NC_SF"),
	P1_POINTNSF("P1_POINTNSF"),
	P1_POP_DENS("P1_POP_DENS"),
	P1_R_SUB("P1_R_SUB"),
	P1_SEPTICLOAD("P1_SEPTICLOAD"),
	P1_SEPTIC_RED("P1_SEPTIC_RED"),
	P1_SEWERMAP("P1_SEWERMAP"),
	DIN_IN_RAIN("DIN_IN_RAIN"),
	TModule(name) {

	DIN_AVAILABLE.SetF(FisExport,True,"CG");
	DAYJUL.SetF(FisImport,True,"CG");
	SAT_WATER.SetF(FisImport,True,"CG");
	UNSAT_WATER.SetF(FisImport,True,"CG");
	UW_FROM_PRECIP.SetF(FisImport,True,"CG");
	SW_TO_SATW_DOWNFLOW.SetF(FisImport,True,"CG");
	SATW_FROM_PRECIP.SetF(FisImport,True,"CG");
	CELL_SIZE.SetF(FisImport,True,"CG");
	AIR_TEMP_C.SetF(FisImport,True,"CG");
	SATW_TO_SW_UPFLOW.SetF(FisImport,True,"CG");
	PHBIO_NPP.SetF(FisImport,True,"CG");
	UW_DEPTH.SetF(FisImport,True,"CG");
	ELEVATION.SetF(FisImport,True,"CG");
	SATW_OUTFLUX.SetF(FisImport,True,"CG");
	SW_OUTFLUX.SetF(FisImport,True,"CG");
	HABITATMAP.SetF(FisImport,True,"CG");
	ROOT_DEPTH.SetF(FisImport,True,"CG");
	SURFACE_WATER.SetF(FisImport,True,"CG");
	D_DECOMP.SetF(FisImport,True,"CG");
	SATW_TRANSP.SetF(FisImport,True,"CG");
	UW_ETRANSP.SetF(FisImport,True,"CG");
	DIN_SD.SetF(FisExport,True,"CG");
	DIN_SF.SetF(FisExport,True,"CG");
	A_IN.SetF(FisExport,True,"CG");
}	
int ZDIN_module::A_IN_I177_exe() {
	float value;

	A_IN.UpdateIntegrator();
	switch( A_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = A_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ATM_FLOW.Value(p);
			A_IN.Update( p, value, dT() );
		}
		A_IN.GrabMemory();
		if( A_IN.GetF(FLinkEdges) ) { A_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ATM_FLOW.Value();
			A_IN.Update( value, dT() );
	  } break;
	}
	return 0;
}

int ZDIN_module::A_IN_i178_exe() {
	float value;

	A_IN.UpdateIntegrator();
	switch( A_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = A_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			A_IN.InitValue( p, value );
		}
		A_IN.GrabMemory();
		if( A_IN.GetF(FLinkEdges) ) { A_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			A_IN.InitValue( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::ATM_FLOW_u179_exe() {
	float value;

	switch( ATM_FLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ATM_FLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DINSF_ATM.Value(p)*((float)10) );
			ATM_FLOW.Update( p, value );
		}
		ATM_FLOW.GrabMemory();
		if( ATM_FLOW.GetF(FICFlux) ) ATM_FLOW.Cov().Set(0.0); 
		if( ATM_FLOW.GetF(FLinkEdges) ) { ATM_FLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DINSF_ATM.Value()*((float)10) );
			ATM_FLOW.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_FERT_AV_I180_exe() {
	float value;

	DIN_FERT_AV.UpdateIntegrator();
	switch( DIN_FERT_AV.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_FERT_AV.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DIN_FERT.Value(p)-FERT_AV.Value(p) );
			DIN_FERT_AV.Update( p, value, dT() );
		}
		DIN_FERT_AV.GrabMemory();
		if( DIN_FERT_AV.GetF(FLinkEdges) ) { DIN_FERT_AV.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DIN_FERT.Value()-FERT_AV.Value() );
			DIN_FERT_AV.Update( value, dT() );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_FERT_AV_i181_exe() {
	float value;

	DIN_FERT_AV.UpdateIntegrator();
	switch( DIN_FERT_AV.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_FERT_AV.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			DIN_FERT_AV.InitValue( p, value );
		}
		DIN_FERT_AV.GrabMemory();
		if( DIN_FERT_AV.GetF(FLinkEdges) ) { DIN_FERT_AV.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			DIN_FERT_AV.InitValue( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_FERT_u182_exe() {
	float value;

	switch( DIN_FERT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_FERT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( DAYJUL.Value(p) == P1_DIN_DAY_FERT1.Value(p) ) ) ? ( ( ( P1_DIN_FERT_APP.Value(p)*P1_DIN_FERT_HAB1.Value(p) )*0.1 ) ) : (  ( ( ( DAYJUL.Value(p) == P1_DIN_DAY_FERT2.Value(p) ) ) ? ( ( ( P1_DIN_FERT_APP.Value(p)*P1_DIN_FERT_HAB2.Value(p) )*0.1 ) ) : ( ((float)0) ) )  ) ) ;
			DIN_FERT.Update( p, value );
		}
		DIN_FERT.GrabMemory();
		if( DIN_FERT.GetF(FICFlux) ) DIN_FERT.Cov().Set(0.0); 
		if( DIN_FERT.GetF(FLinkEdges) ) { DIN_FERT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( DAYJUL.Value() == P1_DIN_DAY_FERT1.Value() ) ) ? ( ( ( P1_DIN_FERT_APP.Value()*P1_DIN_FERT_HAB1.Value() )*0.1 ) ) : (  ( ( ( DAYJUL.Value() == P1_DIN_DAY_FERT2.Value() ) ) ? ( ( ( P1_DIN_FERT_APP.Value()*P1_DIN_FERT_HAB2.Value() )*0.1 ) ) : ( ((float)0) ) )  ) ) ;
			DIN_FERT.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::FERT_AV_u183_exe() {
	float value;

	switch( FERT_AV.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FERT_AV.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_DIN_FERT_DIS.Value(p)*DIN_FERT_AV.Value(p) );
			FERT_AV.Update( p, value );
		}
		FERT_AV.GrabMemory();
		if( FERT_AV.GetF(FICFlux) ) FERT_AV.Cov().Set(0.0); 
		if( FERT_AV.GetF(FLinkEdges) ) { FERT_AV.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_DIN_FERT_DIS.Value()*DIN_FERT_AV.Value() );
			FERT_AV.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_SD_I184_exe() {
	float value;

	DIN_SD.UpdateIntegrator();
	switch( DIN_SD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( ( DIN_DNFLOW.Value(p)+DINSD_LOAD.Value(p) )+DOM_TO_DINSD.Value(p) )-DINSD_DENIT.Value(p) )-DIN_UPFLOW.Value(p) )-DINSD_UPTAKE.Value(p) )-DINSD_HOUT.Value(p) );
			DIN_SD.Update( p, value, dT() );
		}
		DIN_SD.GrabMemory();
		if( DIN_SD.GetF(FLinkEdges) ) { DIN_SD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( ( DIN_DNFLOW.Value()+DINSD_LOAD.Value() )+DOM_TO_DINSD.Value() )-DINSD_DENIT.Value() )-DIN_UPFLOW.Value() )-DINSD_UPTAKE.Value() )-DINSD_HOUT.Value() );
			DIN_SD.Update( value, dT() );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_SD_i185_exe() {
	float value;

	DIN_SD.UpdateIntegrator();
	switch( DIN_SD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_DIN_ICSED.Value(p)*( SAT_WATER.Value(p)+UNSAT_WATER.Value(p) ) );
			DIN_SD.InitValue( p, value );
		}
		DIN_SD.GrabMemory();
		if( DIN_SD.GetF(FLinkEdges) ) { DIN_SD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_DIN_ICSED.Value()*( SAT_WATER.Value()+UNSAT_WATER.Value() ) );
			DIN_SD.InitValue( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_DNFLOW_u186_exe() {
	float value;

	switch( DIN_DNFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_DNFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(( DIN_SF.Value(p)/dT() ), ( ( DINSF_CONC.Value(p)*P1_DIN_DIFFCOEF.Value(p) )*( ( UW_FROM_PRECIP.Value(p)+SW_TO_SATW_DOWNFLOW.Value(p) )+SATW_FROM_PRECIP.Value(p) ) ));
			DIN_DNFLOW.Update( p, value );
		}
		DIN_DNFLOW.GrabMemory();
		if( DIN_DNFLOW.GetF(FICFlux) ) DIN_DNFLOW.Cov().Set(0.0); 
		if( DIN_DNFLOW.GetF(FLinkEdges) ) { DIN_DNFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(( DIN_SF.Value()/dT() ), ( ( DINSF_CONC.Value()*P1_DIN_DIFFCOEF.Value() )*( ( UW_FROM_PRECIP.Value()+SW_TO_SATW_DOWNFLOW.Value() )+SATW_FROM_PRECIP.Value() ) ));
			DIN_DNFLOW.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_LOAD_u187_exe() {
	float value;

	switch( DINSD_LOAD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_LOAD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ((float)1000)*N_NPOINTSD.Value(p) )/CELL_SIZE.Value(p) );
			DINSD_LOAD.Update( p, value );
		}
		DINSD_LOAD.GrabMemory();
		if( DINSD_LOAD.GetF(FICFlux) ) DINSD_LOAD.Cov().Set(0.0); 
		if( DINSD_LOAD.GetF(FLinkEdges) ) { DINSD_LOAD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ((float)1000)*N_NPOINTSD.Value() )/CELL_SIZE.Value() );
			DINSD_LOAD.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DOM_TO_DINSD_u188_exe() {
	float value;

	switch( DOM_TO_DINSD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DOM_TO_DINSD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DOM_TO_DIN.Value(p)*( ((float)1)-P1_DIN_GRAD.Value(p) ) );
			DOM_TO_DINSD.Update( p, value );
		}
		DOM_TO_DINSD.GrabMemory();
		if( DOM_TO_DINSD.GetF(FICFlux) ) DOM_TO_DINSD.Cov().Set(0.0); 
		if( DOM_TO_DINSD.GetF(FLinkEdges) ) { DOM_TO_DINSD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DOM_TO_DIN.Value()*( ((float)1)-P1_DIN_GRAD.Value() ) );
			DOM_TO_DINSD.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_DENIT_u189_exe() {
	float value;

	switch( DINSD_DENIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_DENIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(( DIN_SD.Value(p)/dT() ), ( ( ( P1_DIN_RCDENIT.Value(p)*pow((double)1.04,(double)( AIR_TEMP_C.Value(p)-((float)20) ) ) )*P1_DOMSD_ANAEROB_Z.Value(p) )*DIN_SD.Value(p) ));
			DINSD_DENIT.Update( p, value );
		}
		DINSD_DENIT.GrabMemory();
		if( DINSD_DENIT.GetF(FICFlux) ) DINSD_DENIT.Cov().Set(0.0); 
		if( DINSD_DENIT.GetF(FLinkEdges) ) { DINSD_DENIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(( DIN_SD.Value()/dT() ), ( ( ( P1_DIN_RCDENIT.Value()*pow((double)1.04,(double)( AIR_TEMP_C.Value()-((float)20) ) ) )*P1_DOMSD_ANAEROB_Z.Value() )*DIN_SD.Value() ));
			DINSD_DENIT.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_UPFLOW_u190_exe() {
	float value;

	switch( DIN_UPFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_UPFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SD.Value(p)/dT() )-DINSD_PR1.Value(p) )), ( DINSD_CONC.Value(p)*SATW_TO_SW_UPFLOW.Value(p) ));
			DIN_UPFLOW.Update( p, value );
		}
		DIN_UPFLOW.GrabMemory();
		if( DIN_UPFLOW.GetF(FICFlux) ) DIN_UPFLOW.Cov().Set(0.0); 
		if( DIN_UPFLOW.GetF(FLinkEdges) ) { DIN_UPFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SD.Value()/dT() )-DINSD_PR1.Value() )), ( DINSD_CONC.Value()*SATW_TO_SW_UPFLOW.Value() ));
			DIN_UPFLOW.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_UPTAKE_u191_exe() {
	float value;

	switch( DINSD_UPTAKE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_UPTAKE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SD.Value(p)/dT() )-DINSD_PR2.Value(p) )), DINSD_AVAIL.Value(p), ( ( ( PHBIO_NPP.Value(p)*P1_PHBIO_NC.Value(p) )*P1_DIN_K_OF_NH4.Value(p) )*((float)1000) ));
			DINSD_UPTAKE.Update( p, value );
		}
		DINSD_UPTAKE.GrabMemory();
		if( DINSD_UPTAKE.GetF(FICFlux) ) DINSD_UPTAKE.Cov().Set(0.0); 
		if( DINSD_UPTAKE.GetF(FLinkEdges) ) { DINSD_UPTAKE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SD.Value()/dT() )-DINSD_PR2.Value() )), DINSD_AVAIL.Value(), ( ( ( PHBIO_NPP.Value()*P1_PHBIO_NC.Value() )*P1_DIN_K_OF_NH4.Value() )*((float)1000) ));
			DINSD_UPTAKE.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_HOUT_u192_exe() {
	float value;

	switch( DINSD_HOUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_HOUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_DINSD_OUT.Value(p)*SL::Min(SL::Max(((float)0), ( ( DIN_SD.Value(p)/dT() )-DINSD_PR3.Value(p) )),  ( ( ( UW_DEPTH.Value(p) <= P1_R_SUB.Value(p) ) ) ? ( ( ( ( ( DIN_SD.Value(p)*( ( ( ( ((float)2)*ELEVATION.Value(p) )-P1_R_SUB.Value(p) )-UW_DEPTH.Value(p) )-SATW_OUTFLUX.Value(p) ) )*SATW_OUTFLUX.Value(p) )/( ELEVATION.Value(p)-P1_R_SUB.Value(p) ) )/( ELEVATION.Value(p)-UW_DEPTH.Value(p) ) ) ) : ( ( ( ( ( DIN_SD.Value(p)*( ( ( ((float)2)*ELEVATION.Value(p) )-( ((float)2)*UW_DEPTH.Value(p) ) )-SATW_OUTFLUX.Value(p) ) )*SATW_OUTFLUX.Value(p) )/( ( ELEVATION.Value(p)+UW_DEPTH.Value(p) )-( ((float)2)*P1_R_SUB.Value(p) ) ) )/( ELEVATION.Value(p)-UW_DEPTH.Value(p) ) ) ) ) ) );
			DINSD_HOUT.Update( p, value );
		}
		DINSD_HOUT.GrabMemory();
		if( DINSD_HOUT.GetF(FICFlux) ) DINSD_HOUT.Cov().Set(0.0); 
		if( DINSD_HOUT.GetF(FLinkEdges) ) { DINSD_HOUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_DINSD_OUT.Value()*SL::Min(SL::Max(((float)0), ( ( DIN_SD.Value()/dT() )-DINSD_PR3.Value() )),  ( ( ( UW_DEPTH.Value() <= P1_R_SUB.Value() ) ) ? ( ( ( ( ( DIN_SD.Value()*( ( ( ( ((float)2)*ELEVATION.Value() )-P1_R_SUB.Value() )-UW_DEPTH.Value() )-SATW_OUTFLUX.Value() ) )*SATW_OUTFLUX.Value() )/( ELEVATION.Value()-P1_R_SUB.Value() ) )/( ELEVATION.Value()-UW_DEPTH.Value() ) ) ) : ( ( ( ( ( DIN_SD.Value()*( ( ( ((float)2)*ELEVATION.Value() )-( ((float)2)*UW_DEPTH.Value() ) )-SATW_OUTFLUX.Value() ) )*SATW_OUTFLUX.Value() )/( ( ELEVATION.Value()+UW_DEPTH.Value() )-( ((float)2)*P1_R_SUB.Value() ) ) )/( ELEVATION.Value()-UW_DEPTH.Value() ) ) ) ) ) );
			DINSD_HOUT.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_SF_I193_exe() {
	float value;

	DIN_SF.UpdateIntegrator();
	switch( DIN_SF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( ( DINSF_ATM.Value(p)+DIN_UPFLOW.Value(p) )+DOM_TO_DINSF.Value(p) )+FERT_AV.Value(p) )-DIN_DNFLOW.Value(p) )-DINSF_UPTAKE.Value(p) )-DINSF_OUT.Value(p) );
			DIN_SF.Update( p, value, dT() );
		}
		DIN_SF.GrabMemory();
		if( DIN_SF.GetF(FLinkEdges) ) { DIN_SF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( ( DINSF_ATM.Value()+DIN_UPFLOW.Value() )+DOM_TO_DINSF.Value() )+FERT_AV.Value() )-DIN_DNFLOW.Value() )-DINSF_UPTAKE.Value() )-DINSF_OUT.Value() );
			DIN_SF.Update( value, dT() );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_SF_i194_exe() {
	float value;

	DIN_SF.UpdateIntegrator();
	switch( DIN_SF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  P1_DIN_ICSF.Value(p);
			DIN_SF.InitValue( p, value );
		}
		DIN_SF.GrabMemory();
		if( DIN_SF.GetF(FLinkEdges) ) { DIN_SF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  P1_DIN_ICSF.Value();
			DIN_SF.InitValue( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSF_ATM_u195_exe() {
	float value;

	switch( DINSF_ATM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSF_ATM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( P1_POINTNSF.Value(p)/66 )/CELL_SIZE.Value(p) )+P1_NPOINTNSF.Value(p) )+( DIN_ATMOS_LOAD.Value(p)*P1_D_DEP_FACTOR.Value(p) ) );
			DINSF_ATM.Update( p, value );
		}
		DINSF_ATM.GrabMemory();
		if( DINSF_ATM.GetF(FICFlux) ) DINSF_ATM.Cov().Set(0.0); 
		if( DINSF_ATM.GetF(FLinkEdges) ) { DINSF_ATM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( P1_POINTNSF.Value()/66 )/CELL_SIZE.Value() )+P1_NPOINTNSF.Value() )+( DIN_ATMOS_LOAD.Value()*P1_D_DEP_FACTOR.Value() ) );
			DINSF_ATM.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DOM_TO_DINSF_u196_exe() {
	float value;

	switch( DOM_TO_DINSF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DOM_TO_DINSF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DOM_TO_DIN.Value(p)*P1_DIN_GRAD.Value(p) );
			DOM_TO_DINSF.Update( p, value );
		}
		DOM_TO_DINSF.GrabMemory();
		if( DOM_TO_DINSF.GetF(FICFlux) ) DOM_TO_DINSF.Cov().Set(0.0); 
		if( DOM_TO_DINSF.GetF(FLinkEdges) ) { DOM_TO_DINSF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DOM_TO_DIN.Value()*P1_DIN_GRAD.Value() );
			DOM_TO_DINSF.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSF_UPTAKE_u197_exe() {
	float value;

	switch( DINSF_UPTAKE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSF_UPTAKE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SF.Value(p)/dT() )-DINSF_PR1.Value(p) )), DINSF_AVAIL.Value(p), ( ( ( PHBIO_NPP.Value(p)*P1_PHBIO_NC_SF.Value(p) )*P1_DIN_K_OF_NH4.Value(p) )*((float)1000) ));
			DINSF_UPTAKE.Update( p, value );
		}
		DINSF_UPTAKE.GrabMemory();
		if( DINSF_UPTAKE.GetF(FICFlux) ) DINSF_UPTAKE.Cov().Set(0.0); 
		if( DINSF_UPTAKE.GetF(FLinkEdges) ) { DINSF_UPTAKE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SF.Value()/dT() )-DINSF_PR1.Value() )), DINSF_AVAIL.Value(), ( ( ( PHBIO_NPP.Value()*P1_PHBIO_NC_SF.Value() )*P1_DIN_K_OF_NH4.Value() )*((float)1000) ));
			DINSF_UPTAKE.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSF_OUT_u198_exe() {
	float value;

	switch( DINSF_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSF_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SF.Value(p)/dT() )-DINSF_PR2.Value(p) )), ( ( P1_DINSF_OUT.Value(p)*DINSF_CONC.Value(p) )*SW_OUTFLUX.Value(p) ));
			DINSF_OUT.Update( p, value );
		}
		DINSF_OUT.GrabMemory();
		if( DINSF_OUT.GetF(FICFlux) ) DINSF_OUT.Cov().Set(0.0); 
		if( DINSF_OUT.GetF(FLinkEdges) ) { DINSF_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SF.Value()/dT() )-DINSF_PR2.Value() )), ( ( P1_DINSF_OUT.Value()*DINSF_CONC.Value() )*SW_OUTFLUX.Value() ));
			DINSF_OUT.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::F_IN_I199_exe() {
	float value;

	F_IN.UpdateIntegrator();
	switch( F_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = F_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  FERT_FLOW.Value(p);
			F_IN.Update( p, value, dT() );
		}
		F_IN.GrabMemory();
		if( F_IN.GetF(FLinkEdges) ) { F_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  FERT_FLOW.Value();
			F_IN.Update( value, dT() );
	  } break;
	}
	return 0;
}

int ZDIN_module::F_IN_i200_exe() {
	float value;

	F_IN.UpdateIntegrator();
	switch( F_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = F_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			F_IN.InitValue( p, value );
		}
		F_IN.GrabMemory();
		if( F_IN.GetF(FLinkEdges) ) { F_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			F_IN.InitValue( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::FERT_FLOW_u201_exe() {
	float value;

	switch( FERT_FLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FERT_FLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DIN_FERT.Value(p)*((float)10) );
			FERT_FLOW.Update( p, value );
		}
		FERT_FLOW.GrabMemory();
		if( FERT_FLOW.GetF(FICFlux) ) FERT_FLOW.Cov().Set(0.0); 
		if( FERT_FLOW.GetF(FLinkEdges) ) { FERT_FLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DIN_FERT.Value()*((float)10) );
			FERT_FLOW.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::M_IN_I202_exe() {
	float value;

	M_IN.UpdateIntegrator();
	switch( M_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = M_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  MINER_FLOW.Value(p);
			M_IN.Update( p, value, dT() );
		}
		M_IN.GrabMemory();
		if( M_IN.GetF(FLinkEdges) ) { M_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  MINER_FLOW.Value();
			M_IN.Update( value, dT() );
	  } break;
	}
	return 0;
}

int ZDIN_module::M_IN_i203_exe() {
	float value;

	M_IN.UpdateIntegrator();
	switch( M_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = M_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			M_IN.InitValue( p, value );
		}
		M_IN.GrabMemory();
		if( M_IN.GetF(FLinkEdges) ) { M_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			M_IN.InitValue( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::MINER_FLOW_u204_exe() {
	float value;

	switch( MINER_FLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MINER_FLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( DOM_TO_DINSD.Value(p)+DOM_TO_DINSF.Value(p) )*((float)10) );
			MINER_FLOW.Update( p, value );
		}
		MINER_FLOW.GrabMemory();
		if( MINER_FLOW.GetF(FICFlux) ) MINER_FLOW.Cov().Set(0.0); 
		if( MINER_FLOW.GetF(FLinkEdges) ) { MINER_FLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( DOM_TO_DINSD.Value()+DOM_TO_DINSF.Value() )*((float)10) );
			MINER_FLOW.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::S_IN_I205_exe() {
	float value;

	S_IN.UpdateIntegrator();
	switch( S_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = S_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SEPTIC_FLOW.Value(p);
			S_IN.Update( p, value, dT() );
		}
		S_IN.GrabMemory();
		if( S_IN.GetF(FLinkEdges) ) { S_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SEPTIC_FLOW.Value();
			S_IN.Update( value, dT() );
	  } break;
	}
	return 0;
}

int ZDIN_module::S_IN_i206_exe() {
	float value;

	S_IN.UpdateIntegrator();
	switch( S_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = S_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			S_IN.InitValue( p, value );
		}
		S_IN.GrabMemory();
		if( S_IN.GetF(FLinkEdges) ) { S_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			S_IN.InitValue( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::SEPTIC_FLOW_u207_exe() {
	float value;

	switch( SEPTIC_FLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SEPTIC_FLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DINSD_LOAD.Value(p)*((float)10) );
			SEPTIC_FLOW.Update( p, value );
		}
		SEPTIC_FLOW.GrabMemory();
		if( SEPTIC_FLOW.GetF(FICFlux) ) SEPTIC_FLOW.Cov().Set(0.0); 
		if( SEPTIC_FLOW.GetF(FLinkEdges) ) { SEPTIC_FLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DINSD_LOAD.Value()*((float)10) );
			SEPTIC_FLOW.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::COUNTY_u208_exe() {
	float value;

	switch( COUNTY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = COUNTY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)1)+( ((float)0)*HABITATMAP.Value(p) ) );
			COUNTY.Update( p, value );
		}
		COUNTY.GrabMemory();
		if( COUNTY.GetF(FLinkEdges) ) { COUNTY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)1)+( ((float)0)*HABITATMAP.Value() ) );
			COUNTY.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::CROP_u209_exe() {
	float value;

	switch( CROP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CROP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)1)+( ((float)0)*HABITATMAP.Value(p) ) );
			CROP.Update( p, value );
		}
		CROP.GrabMemory();
		if( CROP.GetF(FLinkEdges) ) { CROP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)1)+( ((float)0)*HABITATMAP.Value() ) );
			CROP.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_AVAIL_u210_exe() {
	float value;

	switch( DINSD_AVAIL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_AVAIL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ROOT_DEPTH.Value(p) <= P1_R_SUB.Value(p) ) ) ? ( ((float)0) ) : ( ( DIN_SD.Value(p)* ( ( ( ( ROOT_DEPTH.Value(p) >  P1_R_SUB.Value(p) ) && ( P1_R_SUB.Value(p) >= UW_DEPTH.Value(p) ) ) ) ? ( ( ( ( ( ( ( ((float)2)*ELEVATION.Value(p) )-UW_DEPTH.Value(p) )-ROOT_DEPTH.Value(p) )*( ROOT_DEPTH.Value(p)-P1_R_SUB.Value(p) ) )/( ELEVATION.Value(p)-ROOT_DEPTH.Value(p) ) )/( ELEVATION.Value(p)-UW_DEPTH.Value(p) ) ) ) : (  ( ( ( ( P1_R_SUB.Value(p) <= ROOT_DEPTH.Value(p) ) && ( ROOT_DEPTH.Value(p) <  UW_DEPTH.Value(p) ) ) ) ? ( ( ( ((float)2)*( ROOT_DEPTH.Value(p)-P1_R_SUB.Value(p) ) )/( ELEVATION.Value(p)-P1_R_SUB.Value(p) ) ) ) : ( ( ( ( ((float)2)*( UW_DEPTH.Value(p)-P1_R_SUB.Value(p) ) )+( ( ( ( ( ((float)2)*ELEVATION.Value(p) )-UW_DEPTH.Value(p) )-ROOT_DEPTH.Value(p) )*( ROOT_DEPTH.Value(p)-UW_DEPTH.Value(p) ) )/( ELEVATION.Value(p)-UW_DEPTH.Value(p) ) ) )/( ( ELEVATION.Value(p)+UW_DEPTH.Value(p) )-( ((float)2)*P1_R_SUB.Value(p) ) ) ) ) )  ) )  ) ) ) ;
			DINSD_AVAIL.Update( p, value );
		}
		DINSD_AVAIL.GrabMemory();
		if( DINSD_AVAIL.GetF(FLinkEdges) ) { DINSD_AVAIL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ROOT_DEPTH.Value() <= P1_R_SUB.Value() ) ) ? ( ((float)0) ) : ( ( DIN_SD.Value()* ( ( ( ( ROOT_DEPTH.Value() >  P1_R_SUB.Value() ) && ( P1_R_SUB.Value() >= UW_DEPTH.Value() ) ) ) ? ( ( ( ( ( ( ( ((float)2)*ELEVATION.Value() )-UW_DEPTH.Value() )-ROOT_DEPTH.Value() )*( ROOT_DEPTH.Value()-P1_R_SUB.Value() ) )/( ELEVATION.Value()-ROOT_DEPTH.Value() ) )/( ELEVATION.Value()-UW_DEPTH.Value() ) ) ) : (  ( ( ( ( P1_R_SUB.Value() <= ROOT_DEPTH.Value() ) && ( ROOT_DEPTH.Value() <  UW_DEPTH.Value() ) ) ) ? ( ( ( ((float)2)*( ROOT_DEPTH.Value()-P1_R_SUB.Value() ) )/( ELEVATION.Value()-P1_R_SUB.Value() ) ) ) : ( ( ( ( ((float)2)*( UW_DEPTH.Value()-P1_R_SUB.Value() ) )+( ( ( ( ( ((float)2)*ELEVATION.Value() )-UW_DEPTH.Value() )-ROOT_DEPTH.Value() )*( ROOT_DEPTH.Value()-UW_DEPTH.Value() ) )/( ELEVATION.Value()-UW_DEPTH.Value() ) ) )/( ( ELEVATION.Value()+UW_DEPTH.Value() )-( ((float)2)*P1_R_SUB.Value() ) ) ) ) )  ) )  ) ) ) ;
			DINSD_AVAIL.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_CONC_u211_exe() {
	float value;

	switch( DINSD_CONC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_CONC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DIN_SD.Value(p)/( SAT_WATER.Value(p)+UNSAT_WATER.Value(p) ) );
			DINSD_CONC.Update( p, value );
		}
		DINSD_CONC.GrabMemory();
		if( DINSD_CONC.GetF(FLinkEdges) ) { DINSD_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DIN_SD.Value()/( SAT_WATER.Value()+UNSAT_WATER.Value() ) );
			DINSD_CONC.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_PR1_u212_exe() {
	float value;

	switch( DINSD_PR1.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_PR1.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  DINSD_DENIT.Value(p);
			DINSD_PR1.Update( p, value );
		}
		DINSD_PR1.GrabMemory();
		if( DINSD_PR1.GetF(FLinkEdges) ) { DINSD_PR1.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  DINSD_DENIT.Value();
			DINSD_PR1.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_PR2_u213_exe() {
	float value;

	switch( DINSD_PR2.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_PR2.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DIN_UPFLOW.Value(p)+DINSD_PR1.Value(p) );
			DINSD_PR2.Update( p, value );
		}
		DINSD_PR2.GrabMemory();
		if( DINSD_PR2.GetF(FLinkEdges) ) { DINSD_PR2.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DIN_UPFLOW.Value()+DINSD_PR1.Value() );
			DINSD_PR2.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_PR3_u214_exe() {
	float value;

	switch( DINSD_PR3.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_PR3.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DINSD_UPTAKE.Value(p)+DINSD_PR2.Value(p) );
			DINSD_PR3.Update( p, value );
		}
		DINSD_PR3.GrabMemory();
		if( DINSD_PR3.GetF(FLinkEdges) ) { DINSD_PR3.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DINSD_UPTAKE.Value()+DINSD_PR2.Value() );
			DINSD_PR3.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSF_AVAIL_u215_exe() {
	float value;

	switch( DINSF_AVAIL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSF_AVAIL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SURFACE_WATER.Value(p) >  ((float)0) ) ) ? ( ( DINSF_CONC.Value(p)*( SURFACE_WATER.Value(p)+SR_WATER.Value(p) ) ) ) : ( ( ( DINSF_CONC.Value(p)*( ((float)1)-P1_DIN_DIFFCOEF.Value(p) ) )*SR_WATER.Value(p) ) ) ) ;
			DINSF_AVAIL.Update( p, value );
		}
		DINSF_AVAIL.GrabMemory();
		if( DINSF_AVAIL.GetF(FLinkEdges) ) { DINSF_AVAIL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SURFACE_WATER.Value() >  ((float)0) ) ) ? ( ( DINSF_CONC.Value()*( SURFACE_WATER.Value()+SR_WATER.Value() ) ) ) : ( ( ( DINSF_CONC.Value()*( ((float)1)-P1_DIN_DIFFCOEF.Value() ) )*SR_WATER.Value() ) ) ) ;
			DINSF_AVAIL.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSF_CONC_u216_exe() {
	float value;

	switch( DINSF_CONC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSF_CONC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( SURFACE_WATER.Value(p)+SR_WATER.Value(p) ) >  0.0 ) ) ? ( ( DIN_SF.Value(p)/( SURFACE_WATER.Value(p)+SR_WATER.Value(p) ) ) ) : ( ((float)0) ) ) ;
			DINSF_CONC.Update( p, value );
		}
		DINSF_CONC.GrabMemory();
		if( DINSF_CONC.GetF(FLinkEdges) ) { DINSF_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( SURFACE_WATER.Value()+SR_WATER.Value() ) >  0.0 ) ) ? ( ( DIN_SF.Value()/( SURFACE_WATER.Value()+SR_WATER.Value() ) ) ) : ( ((float)0) ) ) ;
			DINSF_CONC.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSF_PR1_u217_exe() {
	float value;

	switch( DINSF_PR1.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSF_PR1.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  DIN_DNFLOW.Value(p);
			DINSF_PR1.Update( p, value );
		}
		DINSF_PR1.GrabMemory();
		if( DINSF_PR1.GetF(FLinkEdges) ) { DINSF_PR1.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  DIN_DNFLOW.Value();
			DINSF_PR1.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSF_PR2_u218_exe() {
	float value;

	switch( DINSF_PR2.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSF_PR2.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DINSF_PR1.Value(p)+DINSF_UPTAKE.Value(p) );
			DINSF_PR2.Update( p, value );
		}
		DINSF_PR2.GrabMemory();
		if( DINSF_PR2.GetF(FLinkEdges) ) { DINSF_PR2.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DINSF_PR1.Value()+DINSF_UPTAKE.Value() );
			DINSF_PR2.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_ATMOS_LOAD_u219_exe() {
	float value;

	switch( DIN_ATMOS_LOAD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_ATMOS_LOAD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DIN_IN_RAIN.Value(p)/70 );
			DIN_ATMOS_LOAD.Update( p, value );
		}
		DIN_ATMOS_LOAD.GrabMemory();
		if( DIN_ATMOS_LOAD.GetF(FLinkEdges) ) { DIN_ATMOS_LOAD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DIN_IN_RAIN.Value()/70 );
			DIN_ATMOS_LOAD.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_AVAILABLE_u220_exe() {
	float value;

	switch( DIN_AVAILABLE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_AVAILABLE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DINSD_AVAIL.Value(p)+DINSF_AVAIL.Value(p) );
			DIN_AVAILABLE.Update( p, value );
		}
		DIN_AVAILABLE.GrabMemory();
		if( DIN_AVAILABLE.GetF(FLinkEdges) ) { DIN_AVAILABLE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DINSD_AVAIL.Value()+DINSF_AVAIL.Value() );
			DIN_AVAILABLE.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DOM_TO_DIN_u221_exe() {
	float value;

	switch( DOM_TO_DIN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DOM_TO_DIN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( D_DECOMP.Value(p)*P1_DOM_NC.Value(p) )*P1_DOM_CTOOM.Value(p) )*P1_DIN_CR_SED_MIN.Value(p) )*((float)1000) );
			DOM_TO_DIN.Update( p, value );
		}
		DOM_TO_DIN.GrabMemory();
		if( DOM_TO_DIN.GetF(FLinkEdges) ) { DOM_TO_DIN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( D_DECOMP.Value()*P1_DOM_NC.Value() )*P1_DOM_CTOOM.Value() )*P1_DIN_CR_SED_MIN.Value() )*((float)1000) );
			DOM_TO_DIN.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::N_NPOINTSD_u222_exe() {
	float value;

	switch( N_NPOINTSD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = N_NPOINTSD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( P1_SEWERMAP.Value(p) == ((float)3) ) ) ? ( ((float)0) ) : ( ( ( P1_SEPTICLOAD.Value(p)*P1_POP_DENS.Value(p) )*P1_SEPTIC_RED.Value(p) ) ) ) ;
			N_NPOINTSD.Update( p, value );
		}
		N_NPOINTSD.GrabMemory();
		if( N_NPOINTSD.GetF(FLinkEdges) ) { N_NPOINTSD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( P1_SEWERMAP.Value() == ((float)3) ) ) ? ( ((float)0) ) : ( ( ( P1_SEPTICLOAD.Value()*P1_POP_DENS.Value() )*P1_SEPTIC_RED.Value() ) ) ) ;
			N_NPOINTSD.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::OUTPUTCOL_u223_exe() {
	float value;

	switch( OUTPUTCOL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = OUTPUTCOL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  45;
			OUTPUTCOL.Update( p, OUTPUTCOL.ParameterValue(value,p) );
		}
		OUTPUTCOL.GrabMemory();
		if( OUTPUTCOL.GetF(FLinkEdges) ) { OUTPUTCOL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  45;
			OUTPUTCOL.Update( OUTPUTCOL.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::OUTPUTROW_u224_exe() {
	float value;

	switch( OUTPUTROW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = OUTPUTROW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  73;
			OUTPUTROW.Update( p, OUTPUTROW.ParameterValue(value,p) );
		}
		OUTPUTROW.GrabMemory();
		if( OUTPUTROW.GetF(FLinkEdges) ) { OUTPUTROW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  73;
			OUTPUTROW.Update( OUTPUTROW.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::OUTPUTVAR_u225_exe() {
	float value;

	switch( OUTPUTVAR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = OUTPUTVAR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( HABITATMAP.Value(p)*((float)0) );
			OUTPUTVAR.Update( p, value );
		}
		OUTPUTVAR.GrabMemory();
		if( OUTPUTVAR.GetF(FLinkEdges) ) { OUTPUTVAR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( HABITATMAP.Value()*((float)0) );
			OUTPUTVAR.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::OUTPUTVAR_v432_exe() {
	float value;

			 Output_Func(OUTPUTVAR, SATW_FROM_PRECIP, SW_TO_SATW_DOWNFLOW, SATW_TO_SW_UPFLOW, SATW_TRANSP, UW_ETRANSP, UW_FROM_PRECIP, OUTPUTROW, OUTPUTCOL);
	return 0;
}

int ZDIN_module::SR_WATER_u226_exe() {
	float value;

	switch( SR_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SR_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( P1_R_SUB.Value(p) <  UW_DEPTH.Value(p) ) ) ? ( ( ( UNSAT_WATER.Value(p)*P1_R_SUB.Value(p) )/UW_DEPTH.Value(p) ) ) : ( ( UNSAT_WATER.Value(p)+( ( ( P1_R_SUB.Value(p)-UW_DEPTH.Value(p) )/( ELEVATION.Value(p)-UW_DEPTH.Value(p) ) )*SAT_WATER.Value(p) ) ) ) ) ;
			SR_WATER.Update( p, value );
		}
		SR_WATER.GrabMemory();
		if( SR_WATER.GetF(FLinkEdges) ) { SR_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( P1_R_SUB.Value() <  UW_DEPTH.Value() ) ) ? ( ( ( UNSAT_WATER.Value()*P1_R_SUB.Value() )/UW_DEPTH.Value() ) ) : ( ( UNSAT_WATER.Value()+( ( ( P1_R_SUB.Value()-UW_DEPTH.Value() )/( ELEVATION.Value()-UW_DEPTH.Value() ) )*SAT_WATER.Value() ) ) ) ) ;
			SR_WATER.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::ZONMAP_u227_exe() {
	float value;

	switch( ZONMAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ZONMAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)0)+( ((float)0)*HABITATMAP.Value(p) ) );
			ZONMAP.Update( p, value );
		}
		ZONMAP.GrabMemory();
		if( ZONMAP.GetF(FLinkEdges) ) { ZONMAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)0)+( ((float)0)*HABITATMAP.Value() ) );
			ZONMAP.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_BOCOEF_u228_exe() {
	float value;

	switch( P1_BOCOEF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_BOCOEF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  3;
			P1_BOCOEF.Update( p, P1_BOCOEF.ParameterValue(value,p) );
		}
		P1_BOCOEF.GrabMemory();
		if( P1_BOCOEF.GetF(FLinkEdges) ) { P1_BOCOEF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  3;
			P1_BOCOEF.Update( P1_BOCOEF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DINSD_OUT_u229_exe() {
	float value;

	switch( P1_DINSD_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DINSD_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0;
			P1_DINSD_OUT.Update( p, P1_DINSD_OUT.ParameterValue(value,p) );
		}
		P1_DINSD_OUT.GrabMemory();
		if( P1_DINSD_OUT.GetF(FLinkEdges) ) { P1_DINSD_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0;
			P1_DINSD_OUT.Update( P1_DINSD_OUT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DINSF_OUT_u230_exe() {
	float value;

	switch( P1_DINSF_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DINSF_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0;
			P1_DINSF_OUT.Update( p, P1_DINSF_OUT.ParameterValue(value,p) );
		}
		P1_DINSF_OUT.GrabMemory();
		if( P1_DINSF_OUT.GetF(FLinkEdges) ) { P1_DINSF_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0;
			P1_DINSF_OUT.Update( P1_DINSF_OUT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_CR_SED_MIN_u231_exe() {
	float value;

	switch( P1_DIN_CR_SED_MIN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_CR_SED_MIN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.2;
			P1_DIN_CR_SED_MIN.Update( p, P1_DIN_CR_SED_MIN.ParameterValue(value,p) );
		}
		P1_DIN_CR_SED_MIN.GrabMemory();
		if( P1_DIN_CR_SED_MIN.GetF(FLinkEdges) ) { P1_DIN_CR_SED_MIN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.2;
			P1_DIN_CR_SED_MIN.Update( P1_DIN_CR_SED_MIN.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_DAY_FERT1_u232_exe() {
	float value;

	switch( P1_DIN_DAY_FERT1.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_DAY_FERT1.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)191);
			P1_DIN_DAY_FERT1.Update( p, value );
		}
		P1_DIN_DAY_FERT1.GrabMemory();
		if( P1_DIN_DAY_FERT1.GetF(FLinkEdges) ) { P1_DIN_DAY_FERT1.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)191);
			P1_DIN_DAY_FERT1.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_DAY_FERT2_u233_exe() {
	float value;

	switch( P1_DIN_DAY_FERT2.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_DAY_FERT2.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)999);
			P1_DIN_DAY_FERT2.Update( p, value );
		}
		P1_DIN_DAY_FERT2.GrabMemory();
		if( P1_DIN_DAY_FERT2.GetF(FLinkEdges) ) { P1_DIN_DAY_FERT2.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)999);
			P1_DIN_DAY_FERT2.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_DIFFCOEF_u234_exe() {
	float value;

	switch( P1_DIN_DIFFCOEF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_DIFFCOEF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.2;
			P1_DIN_DIFFCOEF.Update( p, P1_DIN_DIFFCOEF.ParameterValue(value,p) );
		}
		P1_DIN_DIFFCOEF.GrabMemory();
		if( P1_DIN_DIFFCOEF.GetF(FLinkEdges) ) { P1_DIN_DIFFCOEF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.2;
			P1_DIN_DIFFCOEF.Update( P1_DIN_DIFFCOEF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_FERT_APP_u235_exe() {
	float value;

	switch( P1_DIN_FERT_APP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_FERT_APP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)145);
			P1_DIN_FERT_APP.Update( p, value );
		}
		P1_DIN_FERT_APP.GrabMemory();
		if( P1_DIN_FERT_APP.GetF(FLinkEdges) ) { P1_DIN_FERT_APP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)145);
			P1_DIN_FERT_APP.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_FERT_DIS_u236_exe() {
	float value;

	switch( P1_DIN_FERT_DIS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_FERT_DIS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.050000;
			P1_DIN_FERT_DIS.Update( p, P1_DIN_FERT_DIS.ParameterValue(value,p) );
		}
		P1_DIN_FERT_DIS.GrabMemory();
		if( P1_DIN_FERT_DIS.GetF(FLinkEdges) ) { P1_DIN_FERT_DIS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.050000;
			P1_DIN_FERT_DIS.Update( P1_DIN_FERT_DIS.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_FERT_HAB1_u237_exe() {
	float value;

	switch( P1_DIN_FERT_HAB1.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_FERT_HAB1.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.75;
			P1_DIN_FERT_HAB1.Update( p, value );
		}
		P1_DIN_FERT_HAB1.GrabMemory();
		if( P1_DIN_FERT_HAB1.GetF(FLinkEdges) ) { P1_DIN_FERT_HAB1.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.75;
			P1_DIN_FERT_HAB1.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_FERT_HAB2_u238_exe() {
	float value;

	switch( P1_DIN_FERT_HAB2.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_FERT_HAB2.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_DIN_FERT_HAB2.Update( p, value );
		}
		P1_DIN_FERT_HAB2.GrabMemory();
		if( P1_DIN_FERT_HAB2.GetF(FLinkEdges) ) { P1_DIN_FERT_HAB2.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_DIN_FERT_HAB2.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_GRAD_u239_exe() {
	float value;

	switch( P1_DIN_GRAD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_GRAD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.7;
			P1_DIN_GRAD.Update( p, P1_DIN_GRAD.ParameterValue(value,p) );
		}
		P1_DIN_GRAD.GrabMemory();
		if( P1_DIN_GRAD.GetF(FLinkEdges) ) { P1_DIN_GRAD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.7;
			P1_DIN_GRAD.Update( P1_DIN_GRAD.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_ICSED_u240_exe() {
	float value;

	switch( P1_DIN_ICSED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_ICSED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.15;
			P1_DIN_ICSED.Update( p, value );
		}
		P1_DIN_ICSED.GrabMemory();
		if( P1_DIN_ICSED.GetF(FLinkEdges) ) { P1_DIN_ICSED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.15;
			P1_DIN_ICSED.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_ICSF_u241_exe() {
	float value;

	switch( P1_DIN_ICSF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_ICSF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.3;
			P1_DIN_ICSF.Update( p, value );
		}
		P1_DIN_ICSF.GrabMemory();
		if( P1_DIN_ICSF.GetF(FLinkEdges) ) { P1_DIN_ICSF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.3;
			P1_DIN_ICSF.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_K_OF_NH4_u242_exe() {
	float value;

	switch( P1_DIN_K_OF_NH4.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_K_OF_NH4.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.5;
			P1_DIN_K_OF_NH4.Update( p, P1_DIN_K_OF_NH4.ParameterValue(value,p) );
		}
		P1_DIN_K_OF_NH4.GrabMemory();
		if( P1_DIN_K_OF_NH4.GetF(FLinkEdges) ) { P1_DIN_K_OF_NH4.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.5;
			P1_DIN_K_OF_NH4.Update( P1_DIN_K_OF_NH4.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_RCDENIT_u243_exe() {
	float value;

	switch( P1_DIN_RCDENIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_RCDENIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.0000;
			P1_DIN_RCDENIT.Update( p, P1_DIN_RCDENIT.ParameterValue(value,p) );
		}
		P1_DIN_RCDENIT.GrabMemory();
		if( P1_DIN_RCDENIT.GetF(FLinkEdges) ) { P1_DIN_RCDENIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.0000;
			P1_DIN_RCDENIT.Update( P1_DIN_RCDENIT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DOMSD_ANAEROB_Z_u244_exe() {
	float value;

	switch( P1_DOMSD_ANAEROB_Z.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DOMSD_ANAEROB_Z.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_DOMSD_ANAEROB_Z.Update( p, P1_DOMSD_ANAEROB_Z.ParameterValue(value,p) );
		}
		P1_DOMSD_ANAEROB_Z.GrabMemory();
		if( P1_DOMSD_ANAEROB_Z.GetF(FLinkEdges) ) { P1_DOMSD_ANAEROB_Z.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_DOMSD_ANAEROB_Z.Update( P1_DOMSD_ANAEROB_Z.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DOM_CTOOM_u245_exe() {
	float value;

	switch( P1_DOM_CTOOM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DOM_CTOOM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.2;
			P1_DOM_CTOOM.Update( p, value );
		}
		P1_DOM_CTOOM.GrabMemory();
		if( P1_DOM_CTOOM.GetF(FLinkEdges) ) { P1_DOM_CTOOM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.2;
			P1_DOM_CTOOM.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DOM_NC_u246_exe() {
	float value;

	switch( P1_DOM_NC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DOM_NC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_DOM_NC.Update( p, value );
		}
		P1_DOM_NC.GrabMemory();
		if( P1_DOM_NC.GetF(FLinkEdges) ) { P1_DOM_NC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_DOM_NC.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_D_DEP_FACTOR_u247_exe() {
	float value;

	switch( P1_D_DEP_FACTOR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_D_DEP_FACTOR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1.7;
			P1_D_DEP_FACTOR.Update( p, P1_D_DEP_FACTOR.ParameterValue(value,p) );
		}
		P1_D_DEP_FACTOR.GrabMemory();
		if( P1_D_DEP_FACTOR.GetF(FLinkEdges) ) { P1_D_DEP_FACTOR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1.7;
			P1_D_DEP_FACTOR.Update( P1_D_DEP_FACTOR.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_NPOINTNSF_u248_exe() {
	float value;

	switch( P1_NPOINTNSF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_NPOINTNSF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0;
			P1_NPOINTNSF.Update( p, P1_NPOINTNSF.ParameterValue(value,p) );
		}
		P1_NPOINTNSF.GrabMemory();
		if( P1_NPOINTNSF.GetF(FLinkEdges) ) { P1_NPOINTNSF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0;
			P1_NPOINTNSF.Update( P1_NPOINTNSF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_PHBIO_NC_u249_exe() {
	float value;

	switch( P1_PHBIO_NC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHBIO_NC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.1;
			P1_PHBIO_NC.Update( p, value );
		}
		P1_PHBIO_NC.GrabMemory();
		if( P1_PHBIO_NC.GetF(FLinkEdges) ) { P1_PHBIO_NC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.1;
			P1_PHBIO_NC.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_PHBIO_NC_SF_u250_exe() {
	float value;

	switch( P1_PHBIO_NC_SF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHBIO_NC_SF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.01;
			P1_PHBIO_NC_SF.Update( p, value );
		}
		P1_PHBIO_NC_SF.GrabMemory();
		if( P1_PHBIO_NC_SF.GetF(FLinkEdges) ) { P1_PHBIO_NC_SF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.01;
			P1_PHBIO_NC_SF.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_POINTNSF_u251_exe() {
	float value;

	switch( P1_POINTNSF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_POINTNSF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0;
			P1_POINTNSF.Update( p, P1_POINTNSF.ParameterValue(value,p) );
		}
		P1_POINTNSF.GrabMemory();
		if( P1_POINTNSF.GetF(FLinkEdges) ) { P1_POINTNSF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0;
			P1_POINTNSF.Update( P1_POINTNSF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_POP_DENS_u252_exe() {
	float value;

	switch( P1_POP_DENS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_POP_DENS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)10);
			P1_POP_DENS.Update( p, value );
		}
		P1_POP_DENS.GrabMemory();
		if( P1_POP_DENS.GetF(FLinkEdges) ) { P1_POP_DENS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)10);
			P1_POP_DENS.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_POP_DENS_v433_exe() {
	float value;

			 DwellMap2(P1_POP_DENS, HABITATMAP, P1_BOCOEF);
	return 0;
}

int ZDIN_module::P1_R_SUB_u253_exe() {
	float value;

	switch( P1_R_SUB.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_R_SUB.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.100000;
			P1_R_SUB.Update( p, P1_R_SUB.ParameterValue(value,p) );
		}
		P1_R_SUB.GrabMemory();
		if( P1_R_SUB.GetF(FLinkEdges) ) { P1_R_SUB.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.100000;
			P1_R_SUB.Update( P1_R_SUB.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_SEPTICLOAD_u254_exe() {
	float value;

	switch( P1_SEPTICLOAD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SEPTICLOAD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.013200;
			P1_SEPTICLOAD.Update( p, P1_SEPTICLOAD.ParameterValue(value,p) );
		}
		P1_SEPTICLOAD.GrabMemory();
		if( P1_SEPTICLOAD.GetF(FLinkEdges) ) { P1_SEPTICLOAD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.013200;
			P1_SEPTICLOAD.Update( P1_SEPTICLOAD.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_SEPTIC_RED_u255_exe() {
	float value;

	switch( P1_SEPTIC_RED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SEPTIC_RED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.800000;
			P1_SEPTIC_RED.Update( p, P1_SEPTIC_RED.ParameterValue(value,p) );
		}
		P1_SEPTIC_RED.GrabMemory();
		if( P1_SEPTIC_RED.GetF(FLinkEdges) ) { P1_SEPTIC_RED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.800000;
			P1_SEPTIC_RED.Update( P1_SEPTIC_RED.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_SEWERMAP_u256_exe() {
	float value;

	switch( P1_SEWERMAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SEWERMAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			P1_SEWERMAP.Update( p, value );
		}
		P1_SEWERMAP.GrabMemory();
		if( P1_SEWERMAP.GetF(FLinkEdges) ) { P1_SEWERMAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			P1_SEWERMAP.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_IN_RAIN_u257_exe() {
	float value;

	switch( DIN_IN_RAIN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_IN_RAIN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph29(DAYJUL.Value(p));
			DIN_IN_RAIN.Update( p, value );
		}
		DIN_IN_RAIN.GrabMemory();
		if( DIN_IN_RAIN.GetF(FLinkEdges) ) { DIN_IN_RAIN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph29(DAYJUL.Value());
			DIN_IN_RAIN.Update( value );
	  } break;
	}
	return 0;
}

ZDIN_module* ZDIN_module::fInstance = NULL;
ZDIN_module* ZDIN_module::kNullModel = (ZDIN_module*)0x1;
int ZDIN_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int ZDIN_module::InitVars() {
	
	TIME.SSInit(this);
	DIN_AVAILABLE.SSInit(this);
	DAYJUL.SSInit(this);
	SAT_WATER.SSInit(this);
	UNSAT_WATER.SSInit(this);
	UW_FROM_PRECIP.SSInit(this);
	UW_FROM_PRECIP.SetLinkEdges();
	SW_TO_SATW_DOWNFLOW.SSInit(this);
	SW_TO_SATW_DOWNFLOW.SetLinkEdges();
	SATW_FROM_PRECIP.SSInit(this);
	SATW_FROM_PRECIP.SetLinkEdges();
	CELL_SIZE.SSInit(this);
	AIR_TEMP_C.SSInit(this);
	SATW_TO_SW_UPFLOW.SSInit(this);
	SATW_TO_SW_UPFLOW.SetLinkEdges();
	PHBIO_NPP.SSInit(this);
	UW_DEPTH.SSInit(this);
	ELEVATION.SSInit(this);
	SATW_OUTFLUX.SSInit(this);
	SW_OUTFLUX.SSInit(this);
	HABITATMAP.SSInit(this);
	HABITATMAP.SetLinkEdges();
	ROOT_DEPTH.SSInit(this);
	SURFACE_WATER.SSInit(this);
	D_DECOMP.SSInit(this);
	SATW_TRANSP.SSInit(this);
	SATW_TRANSP.SetLinkEdges();
	UW_ETRANSP.SSInit(this);
	UW_ETRANSP.SetLinkEdges();
	DIN_SD.SSInit(this);
	DIN_SF.SSInit(this);
	A_IN.SSInit(this);
	ATM_FLOW.SSInit(this);
	ATM_FLOW.SetDestination(&A_IN);
	DIN_FERT_AV.SSInit(this);
	DIN_FERT.SSInit(this);
	DIN_FERT.SetDestination(&DIN_FERT_AV);
	FERT_AV.SSInit(this);
	FERT_AV.SetOrigin(&DIN_FERT_AV);
	FERT_AV.SetDestination(&DIN_SF);
	DIN_DNFLOW.SSInit(this);
	DIN_DNFLOW.SetOrigin(&DIN_SF);
	DIN_DNFLOW.SetDestination(&DIN_SD);
	DINSD_LOAD.SSInit(this);
	DINSD_LOAD.SetDestination(&DIN_SD);
	DOM_TO_DINSD.SSInit(this);
	DOM_TO_DINSD.SetDestination(&DIN_SD);
	DINSD_DENIT.SSInit(this);
	DINSD_DENIT.SetOrigin(&DIN_SD);
	DIN_UPFLOW.SSInit(this);
	DIN_UPFLOW.SetOrigin(&DIN_SD);
	DIN_UPFLOW.SetDestination(&DIN_SF);
	DINSD_UPTAKE.SSInit(this);
	DINSD_UPTAKE.SetOrigin(&DIN_SD);
	DINSD_HOUT.SSInit(this);
	DINSD_HOUT.SetOrigin(&DIN_SD);
	DINSF_ATM.SSInit(this);
	DINSF_ATM.SetDestination(&DIN_SF);
	DOM_TO_DINSF.SSInit(this);
	DOM_TO_DINSF.SetDestination(&DIN_SF);
	DINSF_UPTAKE.SSInit(this);
	DINSF_UPTAKE.SetOrigin(&DIN_SF);
	DINSF_OUT.SSInit(this);
	DINSF_OUT.SetOrigin(&DIN_SF);
	F_IN.SSInit(this);
	FERT_FLOW.SSInit(this);
	FERT_FLOW.SetDestination(&F_IN);
	M_IN.SSInit(this);
	MINER_FLOW.SSInit(this);
	MINER_FLOW.SetDestination(&M_IN);
	S_IN.SSInit(this);
	SEPTIC_FLOW.SSInit(this);
	SEPTIC_FLOW.SetDestination(&S_IN);
	COUNTY.SSInit(this);
	CROP.SSInit(this);
	DINSD_AVAIL.SSInit(this);
	DINSD_CONC.SSInit(this);
	DINSD_PR1.SSInit(this);
	DINSD_PR2.SSInit(this);
	DINSD_PR3.SSInit(this);
	DINSF_AVAIL.SSInit(this);
	DINSF_CONC.SSInit(this);
	DINSF_PR1.SSInit(this);
	DINSF_PR2.SSInit(this);
	DIN_ATMOS_LOAD.SSInit(this);
	DOM_TO_DIN.SSInit(this);
	N_NPOINTSD.SSInit(this);
	OUTPUTCOL.SSInit(this);
	OUTPUTCOL.SetLinkEdges();
	OUTPUTROW.SSInit(this);
	OUTPUTROW.SetLinkEdges();
	OUTPUTVAR.SSInit(this);
	OUTPUTVAR.SetLinkEdges();
	SR_WATER.SSInit(this);
	ZONMAP.SSInit(this);
	P1_BOCOEF.SSInit(this);
	P1_BOCOEF.SetLinkEdges();
	P1_DINSD_OUT.SSInit(this);
	P1_DINSF_OUT.SSInit(this);
	P1_DIN_CR_SED_MIN.SSInit(this);
	P1_DIN_DAY_FERT1.SSInit(this);
	P1_DIN_DAY_FERT2.SSInit(this);
	P1_DIN_DIFFCOEF.SSInit(this);
	P1_DIN_FERT_APP.SSInit(this);
	P1_DIN_FERT_DIS.SSInit(this);
	P1_DIN_FERT_HAB1.SSInit(this);
	P1_DIN_FERT_HAB2.SSInit(this);
	P1_DIN_GRAD.SSInit(this);
	P1_DIN_ICSED.SSInit(this);
	P1_DIN_ICSF.SSInit(this);
	P1_DIN_K_OF_NH4.SSInit(this);
	P1_DIN_RCDENIT.SSInit(this);
	P1_DOMSD_ANAEROB_Z.SSInit(this);
	P1_DOM_CTOOM.SSInit(this);
	P1_DOM_NC.SSInit(this);
	P1_D_DEP_FACTOR.SSInit(this);
	P1_NPOINTNSF.SSInit(this);
	P1_PHBIO_NC.SSInit(this);
	P1_PHBIO_NC_SF.SSInit(this);
	P1_POINTNSF.SSInit(this);
	P1_POP_DENS.SSInit(this);
	P1_POP_DENS.SetLinkEdges();
	P1_R_SUB.SSInit(this);
	P1_SEPTICLOAD.SSInit(this);
	P1_SEPTIC_RED.SSInit(this);
	P1_SEWERMAP.SSInit(this);
	DIN_IN_RAIN.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int ZDIN_module::SetupEvents() {
	TExecuteCommand* u220 = (TExecuteCommand*) DIN_AVAILABLE.GetCommand("u220",TCommand::kUpdate,TCommand::kCode);
	u220->SetExecutable(&DIN_AVAILABLE_u220_exe_g);
	u220->Code() = "u220 <- ( DINSD_AVAIL+DINSF_AVAIL )";
	u220->AddDependency(DINSD_AVAIL);
	u220->AddDependency(DINSF_AVAIL);
	u220->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DAYJUL_import = (TImportCommand*) DAYJUL.GetCommand("DAYJUL_import",TCommand::kUndefined,TCommand::kImport);
	DAYJUL_import->Code() = "Import DAYJUL from GLOBALS_module";
	DAYJUL_import->AddDependency(DAYJUL);
	DAYJUL_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SAT_WATER_import = (TImportCommand*) SAT_WATER.GetCommand("SAT_WATER_import",TCommand::kUndefined,TCommand::kImport);
	SAT_WATER_import->Code() = "Import SAT_WATER from HYDROLOGY_module";
	SAT_WATER_import->AddDependency(SAT_WATER);
	SAT_WATER_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* UNSAT_WATER_import = (TImportCommand*) UNSAT_WATER.GetCommand("UNSAT_WATER_import",TCommand::kUndefined,TCommand::kImport);
	UNSAT_WATER_import->Code() = "Import UNSAT_WATER from HYDROLOGY_module";
	UNSAT_WATER_import->AddDependency(UNSAT_WATER);
	UNSAT_WATER_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* UW_FROM_PRECIP_import = (TImportCommand*) UW_FROM_PRECIP.GetCommand("UW_FROM_PRECIP_import",TCommand::kUndefined,TCommand::kImport);
	UW_FROM_PRECIP_import->Code() = "Import UW_FROM_PRECIP from HYDROLOGY_module";
	UW_FROM_PRECIP_import->AddDependency(UW_FROM_PRECIP);
	UW_FROM_PRECIP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SW_TO_SATW_DOWNFLOW_import = (TImportCommand*) SW_TO_SATW_DOWNFLOW.GetCommand("SW_TO_SATW_DOWNFLOW_import",TCommand::kUndefined,TCommand::kImport);
	SW_TO_SATW_DOWNFLOW_import->Code() = "Import SW_TO_SATW_DOWNFLOW from HYDROLOGY_module";
	SW_TO_SATW_DOWNFLOW_import->AddDependency(SW_TO_SATW_DOWNFLOW);
	SW_TO_SATW_DOWNFLOW_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SATW_FROM_PRECIP_import = (TImportCommand*) SATW_FROM_PRECIP.GetCommand("SATW_FROM_PRECIP_import",TCommand::kUndefined,TCommand::kImport);
	SATW_FROM_PRECIP_import->Code() = "Import SATW_FROM_PRECIP from HYDROLOGY_module";
	SATW_FROM_PRECIP_import->AddDependency(SATW_FROM_PRECIP);
	SATW_FROM_PRECIP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CELL_SIZE_import = (TImportCommand*) CELL_SIZE.GetCommand("CELL_SIZE_import",TCommand::kUndefined,TCommand::kImport);
	CELL_SIZE_import->Code() = "Import CELL_SIZE from GLOBALS_module";
	CELL_SIZE_import->AddDependency(CELL_SIZE);
	CELL_SIZE_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* AIR_TEMP_C_import = (TImportCommand*) AIR_TEMP_C.GetCommand("AIR_TEMP_C_import",TCommand::kUndefined,TCommand::kImport);
	AIR_TEMP_C_import->Code() = "Import AIR_TEMP_C from GLOBALS_module";
	AIR_TEMP_C_import->AddDependency(AIR_TEMP_C);
	AIR_TEMP_C_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SATW_TO_SW_UPFLOW_import = (TImportCommand*) SATW_TO_SW_UPFLOW.GetCommand("SATW_TO_SW_UPFLOW_import",TCommand::kUndefined,TCommand::kImport);
	SATW_TO_SW_UPFLOW_import->Code() = "Import SATW_TO_SW_UPFLOW from HYDROLOGY_module";
	SATW_TO_SW_UPFLOW_import->AddDependency(SATW_TO_SW_UPFLOW);
	SATW_TO_SW_UPFLOW_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PHBIO_NPP_import = (TImportCommand*) PHBIO_NPP.GetCommand("PHBIO_NPP_import",TCommand::kUndefined,TCommand::kImport);
	PHBIO_NPP_import->Code() = "Import PHBIO_NPP from MACROPHYTES_module";
	PHBIO_NPP_import->AddDependency(PHBIO_NPP);
	PHBIO_NPP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* UW_DEPTH_import = (TImportCommand*) UW_DEPTH.GetCommand("UW_DEPTH_import",TCommand::kUndefined,TCommand::kImport);
	UW_DEPTH_import->Code() = "Import UW_DEPTH from HYDROLOGY_module";
	UW_DEPTH_import->AddDependency(UW_DEPTH);
	UW_DEPTH_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ELEVATION_import = (TImportCommand*) ELEVATION.GetCommand("ELEVATION_import",TCommand::kUndefined,TCommand::kImport);
	ELEVATION_import->Code() = "Import ELEVATION from GLOBALS_module";
	ELEVATION_import->AddDependency(ELEVATION);
	ELEVATION_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SATW_OUTFLUX_import = (TImportCommand*) SATW_OUTFLUX.GetCommand("SATW_OUTFLUX_import",TCommand::kUndefined,TCommand::kImport);
	SATW_OUTFLUX_import->Code() = "Import SATW_OUTFLUX from HYDROLOGY_module";
	SATW_OUTFLUX_import->AddDependency(SATW_OUTFLUX);
	SATW_OUTFLUX_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SW_OUTFLUX_import = (TImportCommand*) SW_OUTFLUX.GetCommand("SW_OUTFLUX_import",TCommand::kUndefined,TCommand::kImport);
	SW_OUTFLUX_import->Code() = "Import SW_OUTFLUX from HYDROLOGY_module";
	SW_OUTFLUX_import->AddDependency(SW_OUTFLUX);
	SW_OUTFLUX_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* HABITATMAP_import = (TImportCommand*) HABITATMAP.GetCommand("HABITATMAP_import",TCommand::kUndefined,TCommand::kImport);
	HABITATMAP_import->Code() = "Import HABITATMAP from GLOBALS_module";
	HABITATMAP_import->AddDependency(HABITATMAP);
	HABITATMAP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ROOT_DEPTH_import = (TImportCommand*) ROOT_DEPTH.GetCommand("ROOT_DEPTH_import",TCommand::kUndefined,TCommand::kImport);
	ROOT_DEPTH_import->Code() = "Import ROOT_DEPTH from MACROPHYTES_module";
	ROOT_DEPTH_import->AddDependency(ROOT_DEPTH);
	ROOT_DEPTH_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SURFACE_WATER_import = (TImportCommand*) SURFACE_WATER.GetCommand("SURFACE_WATER_import",TCommand::kUndefined,TCommand::kImport);
	SURFACE_WATER_import->Code() = "Import SURFACE_WATER from HYDROLOGY_module";
	SURFACE_WATER_import->AddDependency(SURFACE_WATER);
	SURFACE_WATER_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* D_DECOMP_import = (TImportCommand*) D_DECOMP.GetCommand("D_DECOMP_import",TCommand::kUndefined,TCommand::kImport);
	D_DECOMP_import->Code() = "Import D_DECOMP from DOM_module";
	D_DECOMP_import->AddDependency(D_DECOMP);
	D_DECOMP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SATW_TRANSP_import = (TImportCommand*) SATW_TRANSP.GetCommand("SATW_TRANSP_import",TCommand::kUndefined,TCommand::kImport);
	SATW_TRANSP_import->Code() = "Import SATW_TRANSP from HYDROLOGY_module";
	SATW_TRANSP_import->AddDependency(SATW_TRANSP);
	SATW_TRANSP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* UW_ETRANSP_import = (TImportCommand*) UW_ETRANSP.GetCommand("UW_ETRANSP_import",TCommand::kUndefined,TCommand::kImport);
	UW_ETRANSP_import->Code() = "Import UW_ETRANSP from HYDROLOGY_module";
	UW_ETRANSP_import->AddDependency(UW_ETRANSP);
	UW_ETRANSP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I184 = (TExecuteCommand*) DIN_SD.GetCommand("I184",TCommand::kIntegrate,TCommand::kCode);
	I184->SetExecutable(&DIN_SD_I184_exe_g);
	I184->Code() = "I184 <- ( ( ( ( ( ( DIN_DNFLOW+DINSD_LOAD )+DOM_TO_DINSD )-DINSD_DENIT )-DIN_UPFLOW )-DINSD_UPTAKE )-DINSD_HOUT )";
	I184->AddDependency(DIN_DNFLOW);
	I184->AddDependency(DINSD_LOAD);
	I184->AddDependency(DOM_TO_DINSD);
	I184->AddDependency(DINSD_DENIT);
	I184->AddDependency(DIN_UPFLOW);
	I184->AddDependency(DINSD_UPTAKE);
	I184->AddDependency(DINSD_HOUT);
	I184->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i185 = (TExecuteCommand*) DIN_SD.GetCommand("i185",TCommand::kInit,TCommand::kCode);
	i185->SetExecutable(&DIN_SD_i185_exe_g);
	i185->Code() = "i185 <- ( P1_DIN_ICSED*( SAT_WATER+UNSAT_WATER ) )";
	i185->AddDependency(HABITATMAP);
	i185->AddDependency(P1_DIN_ICSED);
	i185->AddDependency(SAT_WATER);
	i185->AddDependency(UNSAT_WATER);
	i185->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I193 = (TExecuteCommand*) DIN_SF.GetCommand("I193",TCommand::kIntegrate,TCommand::kCode);
	I193->SetExecutable(&DIN_SF_I193_exe_g);
	I193->Code() = "I193 <- ( ( ( ( ( ( DINSF_ATM+DIN_UPFLOW )+DOM_TO_DINSF )+FERT_AV )-DIN_DNFLOW )-DINSF_UPTAKE )-DINSF_OUT )";
	I193->AddDependency(DINSF_ATM);
	I193->AddDependency(DIN_UPFLOW);
	I193->AddDependency(DOM_TO_DINSF);
	I193->AddDependency(FERT_AV);
	I193->AddDependency(DIN_DNFLOW);
	I193->AddDependency(DINSF_UPTAKE);
	I193->AddDependency(DINSF_OUT);
	I193->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i194 = (TExecuteCommand*) DIN_SF.GetCommand("i194",TCommand::kInit,TCommand::kCode);
	i194->SetExecutable(&DIN_SF_i194_exe_g);
	i194->Code() = "i194 <- P1_DIN_ICSF";
	i194->AddDependency(HABITATMAP);
	i194->AddDependency(P1_DIN_ICSF);
	i194->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I177 = (TExecuteCommand*) A_IN.GetCommand("I177",TCommand::kIntegrate,TCommand::kCode);
	I177->SetExecutable(&A_IN_I177_exe_g);
	I177->Code() = "I177 <- ATM_FLOW";
	I177->AddDependency(ATM_FLOW);
	I177->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i178 = (TExecuteCommand*) A_IN.GetCommand("i178",TCommand::kInit,TCommand::kCode);
	i178->SetExecutable(&A_IN_i178_exe_g);
	i178->Code() = "i178 <- ((float)0)";
	i178->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u179 = (TExecuteCommand*) ATM_FLOW.GetCommand("u179",TCommand::kUpdate,TCommand::kCode);
	u179->SetExecutable(&ATM_FLOW_u179_exe_g);
	u179->Code() = "u179 <- ( DINSF_ATM*((float)10) )";
	u179->AddDependency(DINSF_ATM);
	u179->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I180 = (TExecuteCommand*) DIN_FERT_AV.GetCommand("I180",TCommand::kIntegrate,TCommand::kCode);
	I180->SetExecutable(&DIN_FERT_AV_I180_exe_g);
	I180->Code() = "I180 <- ( DIN_FERT-FERT_AV )";
	I180->AddDependency(DIN_FERT);
	I180->AddDependency(FERT_AV);
	I180->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i181 = (TExecuteCommand*) DIN_FERT_AV.GetCommand("i181",TCommand::kInit,TCommand::kCode);
	i181->SetExecutable(&DIN_FERT_AV_i181_exe_g);
	i181->Code() = "i181 <- ((float)0)";
	i181->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u182 = (TExecuteCommand*) DIN_FERT.GetCommand("u182",TCommand::kUpdate,TCommand::kCode);
	u182->SetExecutable(&DIN_FERT_u182_exe_g);
	u182->Code() = "u182 <-  ( ( ( DAYJUL == P1_DIN_DAY_FERT1 ) ) ? ( ( ( P1_DIN_FERT_APP*P1_DIN_FERT_HAB1 )*0.1 ) ) : (  ( ( ( DAYJUL == P1_DIN_DAY_FERT2 ) ) ? ( ( ( P1_DIN_FERT_APP*P1_DIN_FERT_HAB2 )*0.1 ) ) : ( ((float)0) ) )  ) ) ";
	u182->AddDependency(DAYJUL);
	u182->AddDependency(HABITATMAP);
	u182->AddDependency(P1_DIN_DAY_FERT1);
	u182->AddDependency(P1_DIN_FERT_APP);
	u182->AddDependency(P1_DIN_FERT_HAB1);
	u182->AddDependency(P1_DIN_DAY_FERT2);
	u182->AddDependency(P1_DIN_FERT_HAB2);
	u182->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u183 = (TExecuteCommand*) FERT_AV.GetCommand("u183",TCommand::kUpdate,TCommand::kCode);
	u183->SetExecutable(&FERT_AV_u183_exe_g);
	u183->Code() = "u183 <- ( P1_DIN_FERT_DIS*DIN_FERT_AV )";
	if( FERT_AV.GetF(FisClamped) ) { u183->AddDependency(DIN_FERT_AV); }
	u183->AddDependency(P1_DIN_FERT_DIS);
	u183->AddDependency(DIN_FERT_AV);
	u183->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u186 = (TExecuteCommand*) DIN_DNFLOW.GetCommand("u186",TCommand::kUpdate,TCommand::kCode);
	u186->SetExecutable(&DIN_DNFLOW_u186_exe_g);
	u186->Code() = "u186 <- SL::Min(( DIN_SF/dT() ), ( ( DINSF_CONC*P1_DIN_DIFFCOEF )*( ( UW_FROM_PRECIP+SW_TO_SATW_DOWNFLOW )+SATW_FROM_PRECIP ) ))";
	if( DIN_DNFLOW.GetF(FisClamped) ) { u186->AddDependency(DIN_SF); }
	u186->AddDependency(DIN_SF);
	u186->AddDependency(DINSF_CONC);
	u186->AddDependency(P1_DIN_DIFFCOEF);
	u186->AddDependency(UW_FROM_PRECIP);
	u186->AddDependency(SW_TO_SATW_DOWNFLOW);
	u186->AddDependency(SATW_FROM_PRECIP);
	u186->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u187 = (TExecuteCommand*) DINSD_LOAD.GetCommand("u187",TCommand::kUpdate,TCommand::kCode);
	u187->SetExecutable(&DINSD_LOAD_u187_exe_g);
	u187->Code() = "u187 <- ( ( ((float)1000)*N_NPOINTSD )/CELL_SIZE )";
	u187->AddDependency(N_NPOINTSD);
	u187->AddDependency(CELL_SIZE);
	u187->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u188 = (TExecuteCommand*) DOM_TO_DINSD.GetCommand("u188",TCommand::kUpdate,TCommand::kCode);
	u188->SetExecutable(&DOM_TO_DINSD_u188_exe_g);
	u188->Code() = "u188 <- ( DOM_TO_DIN*( ((float)1)-P1_DIN_GRAD ) )";
	u188->AddDependency(DOM_TO_DIN);
	u188->AddDependency(P1_DIN_GRAD);
	u188->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u189 = (TExecuteCommand*) DINSD_DENIT.GetCommand("u189",TCommand::kUpdate,TCommand::kCode);
	u189->SetExecutable(&DINSD_DENIT_u189_exe_g);
	u189->Code() = "u189 <- SL::Min(( DIN_SD/dT() ), ( ( ( P1_DIN_RCDENIT*pow((double)1.04,(double)( AIR_TEMP_C-((float)20) ) ) )*P1_DOMSD_ANAEROB_Z )*DIN_SD ))";
	if( DINSD_DENIT.GetF(FisClamped) ) { u189->AddDependency(DIN_SD); }
	u189->AddDependency(DIN_SD);
	u189->AddDependency(P1_DIN_RCDENIT);
	u189->AddDependency(AIR_TEMP_C);
	u189->AddDependency(P1_DOMSD_ANAEROB_Z);
	u189->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u190 = (TExecuteCommand*) DIN_UPFLOW.GetCommand("u190",TCommand::kUpdate,TCommand::kCode);
	u190->SetExecutable(&DIN_UPFLOW_u190_exe_g);
	u190->Code() = "u190 <- SL::Min(SL::Max(((float)0), ( ( DIN_SD/dT() )-DINSD_PR1 )), ( DINSD_CONC*SATW_TO_SW_UPFLOW ))";
	if( DIN_UPFLOW.GetF(FisClamped) ) { u190->AddDependency(DIN_SD); }
	u190->AddDependency(DIN_SD);
	u190->AddDependency(DINSD_PR1);
	u190->AddDependency(DINSD_CONC);
	u190->AddDependency(SATW_TO_SW_UPFLOW);
	u190->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u191 = (TExecuteCommand*) DINSD_UPTAKE.GetCommand("u191",TCommand::kUpdate,TCommand::kCode);
	u191->SetExecutable(&DINSD_UPTAKE_u191_exe_g);
	u191->Code() = "u191 <- SL::Min(SL::Max(((float)0), ( ( DIN_SD/dT() )-DINSD_PR2 )), DINSD_AVAIL, ( ( ( PHBIO_NPP*P1_PHBIO_NC )*P1_DIN_K_OF_NH4 )*((float)1000) ))";
	if( DINSD_UPTAKE.GetF(FisClamped) ) { u191->AddDependency(DIN_SD); }
	u191->AddDependency(DIN_SD);
	u191->AddDependency(DINSD_PR2);
	u191->AddDependency(DINSD_AVAIL);
	u191->AddDependency(PHBIO_NPP);
	u191->AddDependency(HABITATMAP);
	u191->AddDependency(P1_PHBIO_NC);
	u191->AddDependency(P1_DIN_K_OF_NH4);
	u191->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u192 = (TExecuteCommand*) DINSD_HOUT.GetCommand("u192",TCommand::kUpdate,TCommand::kCode);
	u192->SetExecutable(&DINSD_HOUT_u192_exe_g);
	u192->Code() = "u192 <- ( P1_DINSD_OUT*SL::Min(SL::Max(((float)0), ( ( DIN_SD/dT() )-DINSD_PR3 )),  ( ( ( UW_DEPTH <= P1_R_SUB ) ) ? ( ( ( ( ( DIN_SD*( ( ( ( ((float)2)*ELEVATION )-P1_R_SUB )-UW_DEPTH )-SATW_OUTFLUX ) )*SATW_OUTFLUX )/( ELEVATION-P1_R_SUB ) )/( ELEVATION-UW_DEPTH ) ) ) : ( ( ( ( ( DIN_SD*( ( ( ((float)2)*ELEVATION )-( ((float)2)*UW_DEPTH ) )-SATW_OUTFLUX ) )*SATW_OUTFLUX )/( ( ELEVATION+UW_DEPTH )-( ((float)2)*P1_R_SUB ) ) )/( ELEVATION-UW_DEPTH ) ) ) ) ) )";
	if( DINSD_HOUT.GetF(FisClamped) ) { u192->AddDependency(DIN_SD); }
	u192->AddDependency(P1_DINSD_OUT);
	u192->AddDependency(DIN_SD);
	u192->AddDependency(DINSD_PR3);
	u192->AddDependency(UW_DEPTH);
	u192->AddDependency(P1_R_SUB);
	u192->AddDependency(ELEVATION);
	u192->AddDependency(SATW_OUTFLUX);
	u192->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u195 = (TExecuteCommand*) DINSF_ATM.GetCommand("u195",TCommand::kUpdate,TCommand::kCode);
	u195->SetExecutable(&DINSF_ATM_u195_exe_g);
	u195->Code() = "u195 <- ( ( ( ( P1_POINTNSF/66 )/CELL_SIZE )+P1_NPOINTNSF )+( DIN_ATMOS_LOAD*P1_D_DEP_FACTOR ) )";
	u195->AddDependency(P1_POINTNSF);
	u195->AddDependency(CELL_SIZE);
	u195->AddDependency(P1_NPOINTNSF);
	u195->AddDependency(DIN_ATMOS_LOAD);
	u195->AddDependency(P1_D_DEP_FACTOR);
	u195->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u196 = (TExecuteCommand*) DOM_TO_DINSF.GetCommand("u196",TCommand::kUpdate,TCommand::kCode);
	u196->SetExecutable(&DOM_TO_DINSF_u196_exe_g);
	u196->Code() = "u196 <- ( DOM_TO_DIN*P1_DIN_GRAD )";
	u196->AddDependency(DOM_TO_DIN);
	u196->AddDependency(P1_DIN_GRAD);
	u196->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u197 = (TExecuteCommand*) DINSF_UPTAKE.GetCommand("u197",TCommand::kUpdate,TCommand::kCode);
	u197->SetExecutable(&DINSF_UPTAKE_u197_exe_g);
	u197->Code() = "u197 <- SL::Min(SL::Max(((float)0), ( ( DIN_SF/dT() )-DINSF_PR1 )), DINSF_AVAIL, ( ( ( PHBIO_NPP*P1_PHBIO_NC_SF )*P1_DIN_K_OF_NH4 )*((float)1000) ))";
	if( DINSF_UPTAKE.GetF(FisClamped) ) { u197->AddDependency(DIN_SF); }
	u197->AddDependency(DIN_SF);
	u197->AddDependency(DINSF_PR1);
	u197->AddDependency(DINSF_AVAIL);
	u197->AddDependency(PHBIO_NPP);
	u197->AddDependency(HABITATMAP);
	u197->AddDependency(P1_PHBIO_NC_SF);
	u197->AddDependency(P1_DIN_K_OF_NH4);
	u197->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u198 = (TExecuteCommand*) DINSF_OUT.GetCommand("u198",TCommand::kUpdate,TCommand::kCode);
	u198->SetExecutable(&DINSF_OUT_u198_exe_g);
	u198->Code() = "u198 <- SL::Min(SL::Max(((float)0), ( ( DIN_SF/dT() )-DINSF_PR2 )), ( ( P1_DINSF_OUT*DINSF_CONC )*SW_OUTFLUX ))";
	if( DINSF_OUT.GetF(FisClamped) ) { u198->AddDependency(DIN_SF); }
	u198->AddDependency(DIN_SF);
	u198->AddDependency(DINSF_PR2);
	u198->AddDependency(P1_DINSF_OUT);
	u198->AddDependency(DINSF_CONC);
	u198->AddDependency(SW_OUTFLUX);
	u198->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I199 = (TExecuteCommand*) F_IN.GetCommand("I199",TCommand::kIntegrate,TCommand::kCode);
	I199->SetExecutable(&F_IN_I199_exe_g);
	I199->Code() = "I199 <- FERT_FLOW";
	I199->AddDependency(FERT_FLOW);
	I199->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i200 = (TExecuteCommand*) F_IN.GetCommand("i200",TCommand::kInit,TCommand::kCode);
	i200->SetExecutable(&F_IN_i200_exe_g);
	i200->Code() = "i200 <- ((float)0)";
	i200->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u201 = (TExecuteCommand*) FERT_FLOW.GetCommand("u201",TCommand::kUpdate,TCommand::kCode);
	u201->SetExecutable(&FERT_FLOW_u201_exe_g);
	u201->Code() = "u201 <- ( DIN_FERT*((float)10) )";
	u201->AddDependency(DIN_FERT);
	u201->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I202 = (TExecuteCommand*) M_IN.GetCommand("I202",TCommand::kIntegrate,TCommand::kCode);
	I202->SetExecutable(&M_IN_I202_exe_g);
	I202->Code() = "I202 <- MINER_FLOW";
	I202->AddDependency(MINER_FLOW);
	I202->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i203 = (TExecuteCommand*) M_IN.GetCommand("i203",TCommand::kInit,TCommand::kCode);
	i203->SetExecutable(&M_IN_i203_exe_g);
	i203->Code() = "i203 <- ((float)0)";
	i203->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u204 = (TExecuteCommand*) MINER_FLOW.GetCommand("u204",TCommand::kUpdate,TCommand::kCode);
	u204->SetExecutable(&MINER_FLOW_u204_exe_g);
	u204->Code() = "u204 <- ( ( DOM_TO_DINSD+DOM_TO_DINSF )*((float)10) )";
	u204->AddDependency(DOM_TO_DINSD);
	u204->AddDependency(DOM_TO_DINSF);
	u204->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I205 = (TExecuteCommand*) S_IN.GetCommand("I205",TCommand::kIntegrate,TCommand::kCode);
	I205->SetExecutable(&S_IN_I205_exe_g);
	I205->Code() = "I205 <- SEPTIC_FLOW";
	I205->AddDependency(SEPTIC_FLOW);
	I205->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i206 = (TExecuteCommand*) S_IN.GetCommand("i206",TCommand::kInit,TCommand::kCode);
	i206->SetExecutable(&S_IN_i206_exe_g);
	i206->Code() = "i206 <- ((float)0)";
	i206->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u207 = (TExecuteCommand*) SEPTIC_FLOW.GetCommand("u207",TCommand::kUpdate,TCommand::kCode);
	u207->SetExecutable(&SEPTIC_FLOW_u207_exe_g);
	u207->Code() = "u207 <- ( DINSD_LOAD*((float)10) )";
	u207->AddDependency(DINSD_LOAD);
	u207->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u208 = (TExecuteCommand*) COUNTY.GetCommand("u208",TCommand::kUpdate,TCommand::kCode);
	u208->SetExecutable(&COUNTY_u208_exe_g);
	u208->Code() = "u208 <- ( ((float)1)+( ((float)0)*HABITATMAP ) )";
	u208->AddDependency(HABITATMAP);
	u208->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u209 = (TExecuteCommand*) CROP.GetCommand("u209",TCommand::kUpdate,TCommand::kCode);
	u209->SetExecutable(&CROP_u209_exe_g);
	u209->Code() = "u209 <- ( ((float)1)+( ((float)0)*HABITATMAP ) )";
	u209->AddDependency(HABITATMAP);
	u209->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u210 = (TExecuteCommand*) DINSD_AVAIL.GetCommand("u210",TCommand::kUpdate,TCommand::kCode);
	u210->SetExecutable(&DINSD_AVAIL_u210_exe_g);
	u210->Code() = "u210 <-  ( ( ( ROOT_DEPTH <= P1_R_SUB ) ) ? ( ((float)0) ) : ( ( DIN_SD* ( ( ( ( ROOT_DEPTH >  P1_R_SUB ) && ( P1_R_SUB >= UW_DEPTH ) ) ) ? ( ( ( ( ( ( ( ((float)2)*ELEVATION )-UW_DEPTH )-ROOT_DEPTH )*( ROOT_DEPTH-P1_R_SUB ) )/( ELEVATION-ROOT_DEPTH ) )/( ELEVATION-UW_DEPTH ) ) ) : (  ( ( ( ( P1_R_SUB <= ROOT_DEPTH ) && ( ROOT_DEPTH <  UW_DEPTH ) ) ) ? ( ( ( ((float)2)*( ROOT_DEPTH-P1_R_SUB ) )/( ELEVATION-P1_R_SUB ) ) ) : ( ( ( ( ((float)2)*( UW_DEPTH-P1_R_SUB ) )+( ( ( ( ( ((float)2)*ELEVATION )-UW_DEPTH )-ROOT_DEPTH )*( ROOT_DEPTH-UW_DEPTH ) )/( ELEVATION-UW_DEPTH ) ) )/( ( ELEVATION+UW_DEPTH )-( ((float)2)*P1_R_SUB ) ) ) ) )  ) )  ) ) ) ";
	u210->AddDependency(ROOT_DEPTH);
	u210->AddDependency(P1_R_SUB);
	u210->AddDependency(DIN_SD);
	u210->AddDependency(UW_DEPTH);
	u210->AddDependency(ELEVATION);
	u210->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u211 = (TExecuteCommand*) DINSD_CONC.GetCommand("u211",TCommand::kUpdate,TCommand::kCode);
	u211->SetExecutable(&DINSD_CONC_u211_exe_g);
	u211->Code() = "u211 <- ( DIN_SD/( SAT_WATER+UNSAT_WATER ) )";
	u211->AddDependency(DIN_SD);
	u211->AddDependency(SAT_WATER);
	u211->AddDependency(UNSAT_WATER);
	u211->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u212 = (TExecuteCommand*) DINSD_PR1.GetCommand("u212",TCommand::kUpdate,TCommand::kCode);
	u212->SetExecutable(&DINSD_PR1_u212_exe_g);
	u212->Code() = "u212 <- DINSD_DENIT";
	u212->AddDependency(DINSD_DENIT);
	u212->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u213 = (TExecuteCommand*) DINSD_PR2.GetCommand("u213",TCommand::kUpdate,TCommand::kCode);
	u213->SetExecutable(&DINSD_PR2_u213_exe_g);
	u213->Code() = "u213 <- ( DIN_UPFLOW+DINSD_PR1 )";
	u213->AddDependency(DIN_UPFLOW);
	u213->AddDependency(DINSD_PR1);
	u213->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u214 = (TExecuteCommand*) DINSD_PR3.GetCommand("u214",TCommand::kUpdate,TCommand::kCode);
	u214->SetExecutable(&DINSD_PR3_u214_exe_g);
	u214->Code() = "u214 <- ( DINSD_UPTAKE+DINSD_PR2 )";
	u214->AddDependency(DINSD_UPTAKE);
	u214->AddDependency(DINSD_PR2);
	u214->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u215 = (TExecuteCommand*) DINSF_AVAIL.GetCommand("u215",TCommand::kUpdate,TCommand::kCode);
	u215->SetExecutable(&DINSF_AVAIL_u215_exe_g);
	u215->Code() = "u215 <-  ( ( ( SURFACE_WATER >  ((float)0) ) ) ? ( ( DINSF_CONC*( SURFACE_WATER+SR_WATER ) ) ) : ( ( ( DINSF_CONC*( ((float)1)-P1_DIN_DIFFCOEF ) )*SR_WATER ) ) ) ";
	u215->AddDependency(SURFACE_WATER);
	u215->AddDependency(DINSF_CONC);
	u215->AddDependency(SR_WATER);
	u215->AddDependency(P1_DIN_DIFFCOEF);
	u215->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u216 = (TExecuteCommand*) DINSF_CONC.GetCommand("u216",TCommand::kUpdate,TCommand::kCode);
	u216->SetExecutable(&DINSF_CONC_u216_exe_g);
	u216->Code() = "u216 <-  ( ( ( ( SURFACE_WATER+SR_WATER ) >  0.0 ) ) ? ( ( DIN_SF/( SURFACE_WATER+SR_WATER ) ) ) : ( ((float)0) ) ) ";
	u216->AddDependency(SURFACE_WATER);
	u216->AddDependency(SR_WATER);
	u216->AddDependency(DIN_SF);
	u216->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u217 = (TExecuteCommand*) DINSF_PR1.GetCommand("u217",TCommand::kUpdate,TCommand::kCode);
	u217->SetExecutable(&DINSF_PR1_u217_exe_g);
	u217->Code() = "u217 <- DIN_DNFLOW";
	u217->AddDependency(DIN_DNFLOW);
	u217->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u218 = (TExecuteCommand*) DINSF_PR2.GetCommand("u218",TCommand::kUpdate,TCommand::kCode);
	u218->SetExecutable(&DINSF_PR2_u218_exe_g);
	u218->Code() = "u218 <- ( DINSF_PR1+DINSF_UPTAKE )";
	u218->AddDependency(DINSF_PR1);
	u218->AddDependency(DINSF_UPTAKE);
	u218->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u219 = (TExecuteCommand*) DIN_ATMOS_LOAD.GetCommand("u219",TCommand::kUpdate,TCommand::kCode);
	u219->SetExecutable(&DIN_ATMOS_LOAD_u219_exe_g);
	u219->Code() = "u219 <- ( DIN_IN_RAIN/70 )";
	u219->AddDependency(DIN_IN_RAIN);
	u219->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u221 = (TExecuteCommand*) DOM_TO_DIN.GetCommand("u221",TCommand::kUpdate,TCommand::kCode);
	u221->SetExecutable(&DOM_TO_DIN_u221_exe_g);
	u221->Code() = "u221 <- ( ( ( ( D_DECOMP*P1_DOM_NC )*P1_DOM_CTOOM )*P1_DIN_CR_SED_MIN )*((float)1000) )";
	u221->AddDependency(D_DECOMP);
	u221->AddDependency(HABITATMAP);
	u221->AddDependency(P1_DOM_NC);
	u221->AddDependency(P1_DOM_CTOOM);
	u221->AddDependency(P1_DIN_CR_SED_MIN);
	u221->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u222 = (TExecuteCommand*) N_NPOINTSD.GetCommand("u222",TCommand::kUpdate,TCommand::kCode);
	u222->SetExecutable(&N_NPOINTSD_u222_exe_g);
	u222->Code() = "u222 <-  ( ( ( P1_SEWERMAP == ((float)3) ) ) ? ( ((float)0) ) : ( ( ( P1_SEPTICLOAD*P1_POP_DENS )*P1_SEPTIC_RED ) ) ) ";
	u222->AddDependency(P1_SEWERMAP);
	u222->AddDependency(P1_SEPTICLOAD);
	u222->AddDependency(P1_POP_DENS);
	u222->AddDependency(P1_SEPTIC_RED);
	u222->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u223 = (TExecuteCommand*) OUTPUTCOL.GetCommand("u223",TCommand::kUpdate,TCommand::kCode);
	u223->SetExecutable(&OUTPUTCOL_u223_exe_g);
	u223->Code() = "u223 <- 45";
	u223->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u224 = (TExecuteCommand*) OUTPUTROW.GetCommand("u224",TCommand::kUpdate,TCommand::kCode);
	u224->SetExecutable(&OUTPUTROW_u224_exe_g);
	u224->Code() = "u224 <- 73";
	u224->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u225 = (TExecuteCommand*) OUTPUTVAR.GetCommand("u225",TCommand::kUpdate,TCommand::kCode);
	u225->SetExecutable(&OUTPUTVAR_u225_exe_g);
	u225->Code() = "u225 <- ( HABITATMAP*((float)0) )";
	u225->AddDependency(HABITATMAP);
	u225->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* v432 = (TExecuteCommand*) OUTPUTVAR.GetCommand("v432",TCommand::kFunction,TCommand::kCode);
	v432->SetExecutable(&OUTPUTVAR_v432_exe_g);
	v432->Code() = "v432 <- Function";
	v432->GetFunction() = 'P';
	v432->AddDependency(OUTPUTVAR);
	v432->AddDependency(SATW_FROM_PRECIP);
	v432->AddDependency(SW_TO_SATW_DOWNFLOW);
	v432->AddDependency(SATW_TO_SW_UPFLOW);
	v432->AddDependency(SATW_TRANSP);
	v432->AddDependency(UW_ETRANSP);
	v432->AddDependency(UW_FROM_PRECIP);
	v432->AddDependency(OUTPUTROW);
	v432->AddDependency(OUTPUTCOL);
	v432->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u226 = (TExecuteCommand*) SR_WATER.GetCommand("u226",TCommand::kUpdate,TCommand::kCode);
	u226->SetExecutable(&SR_WATER_u226_exe_g);
	u226->Code() = "u226 <-  ( ( ( P1_R_SUB <  UW_DEPTH ) ) ? ( ( ( UNSAT_WATER*P1_R_SUB )/UW_DEPTH ) ) : ( ( UNSAT_WATER+( ( ( P1_R_SUB-UW_DEPTH )/( ELEVATION-UW_DEPTH ) )*SAT_WATER ) ) ) ) ";
	u226->AddDependency(P1_R_SUB);
	u226->AddDependency(UW_DEPTH);
	u226->AddDependency(UNSAT_WATER);
	u226->AddDependency(ELEVATION);
	u226->AddDependency(SAT_WATER);
	u226->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u227 = (TExecuteCommand*) ZONMAP.GetCommand("u227",TCommand::kUpdate,TCommand::kCode);
	u227->SetExecutable(&ZONMAP_u227_exe_g);
	u227->Code() = "u227 <- ( ((float)0)+( ((float)0)*HABITATMAP ) )";
	u227->AddDependency(HABITATMAP);
	u227->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u228 = (TExecuteCommand*) P1_BOCOEF.GetCommand("u228",TCommand::kUpdate,TCommand::kCode);
	u228->SetExecutable(&P1_BOCOEF_u228_exe_g);
	u228->Code() = "u228 <- 3";
	u228->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u229 = (TExecuteCommand*) P1_DINSD_OUT.GetCommand("u229",TCommand::kUpdate,TCommand::kCode);
	u229->SetExecutable(&P1_DINSD_OUT_u229_exe_g);
	u229->Code() = "u229 <- 0";
	u229->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u230 = (TExecuteCommand*) P1_DINSF_OUT.GetCommand("u230",TCommand::kUpdate,TCommand::kCode);
	u230->SetExecutable(&P1_DINSF_OUT_u230_exe_g);
	u230->Code() = "u230 <- 0";
	u230->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u231 = (TExecuteCommand*) P1_DIN_CR_SED_MIN.GetCommand("u231",TCommand::kUpdate,TCommand::kCode);
	u231->SetExecutable(&P1_DIN_CR_SED_MIN_u231_exe_g);
	u231->Code() = "u231 <- 0.2";
	u231->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u232 = (TExecuteCommand*) P1_DIN_DAY_FERT1.GetCommand("u232",TCommand::kUpdate,TCommand::kCode);
	u232->SetExecutable(&P1_DIN_DAY_FERT1_u232_exe_g);
	u232->Code() = "u232 <- ((float)191)";
	u232->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u233 = (TExecuteCommand*) P1_DIN_DAY_FERT2.GetCommand("u233",TCommand::kUpdate,TCommand::kCode);
	u233->SetExecutable(&P1_DIN_DAY_FERT2_u233_exe_g);
	u233->Code() = "u233 <- ((float)999)";
	u233->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u234 = (TExecuteCommand*) P1_DIN_DIFFCOEF.GetCommand("u234",TCommand::kUpdate,TCommand::kCode);
	u234->SetExecutable(&P1_DIN_DIFFCOEF_u234_exe_g);
	u234->Code() = "u234 <- 0.2";
	u234->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u235 = (TExecuteCommand*) P1_DIN_FERT_APP.GetCommand("u235",TCommand::kUpdate,TCommand::kCode);
	u235->SetExecutable(&P1_DIN_FERT_APP_u235_exe_g);
	u235->Code() = "u235 <- ((float)145)";
	u235->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u236 = (TExecuteCommand*) P1_DIN_FERT_DIS.GetCommand("u236",TCommand::kUpdate,TCommand::kCode);
	u236->SetExecutable(&P1_DIN_FERT_DIS_u236_exe_g);
	u236->Code() = "u236 <- 0.050000";
	u236->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u237 = (TExecuteCommand*) P1_DIN_FERT_HAB1.GetCommand("u237",TCommand::kUpdate,TCommand::kCode);
	u237->SetExecutable(&P1_DIN_FERT_HAB1_u237_exe_g);
	u237->Code() = "u237 <- 0.75";
	u237->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u238 = (TExecuteCommand*) P1_DIN_FERT_HAB2.GetCommand("u238",TCommand::kUpdate,TCommand::kCode);
	u238->SetExecutable(&P1_DIN_FERT_HAB2_u238_exe_g);
	u238->Code() = "u238 <- ((float)0)";
	u238->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u239 = (TExecuteCommand*) P1_DIN_GRAD.GetCommand("u239",TCommand::kUpdate,TCommand::kCode);
	u239->SetExecutable(&P1_DIN_GRAD_u239_exe_g);
	u239->Code() = "u239 <- 0.7";
	u239->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u240 = (TExecuteCommand*) P1_DIN_ICSED.GetCommand("u240",TCommand::kUpdate,TCommand::kCode);
	u240->SetExecutable(&P1_DIN_ICSED_u240_exe_g);
	u240->Code() = "u240 <- 0.15";
	u240->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u241 = (TExecuteCommand*) P1_DIN_ICSF.GetCommand("u241",TCommand::kUpdate,TCommand::kCode);
	u241->SetExecutable(&P1_DIN_ICSF_u241_exe_g);
	u241->Code() = "u241 <- 0.3";
	u241->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u242 = (TExecuteCommand*) P1_DIN_K_OF_NH4.GetCommand("u242",TCommand::kUpdate,TCommand::kCode);
	u242->SetExecutable(&P1_DIN_K_OF_NH4_u242_exe_g);
	u242->Code() = "u242 <- 0.5";
	u242->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u243 = (TExecuteCommand*) P1_DIN_RCDENIT.GetCommand("u243",TCommand::kUpdate,TCommand::kCode);
	u243->SetExecutable(&P1_DIN_RCDENIT_u243_exe_g);
	u243->Code() = "u243 <- 0.0000";
	u243->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u244 = (TExecuteCommand*) P1_DOMSD_ANAEROB_Z.GetCommand("u244",TCommand::kUpdate,TCommand::kCode);
	u244->SetExecutable(&P1_DOMSD_ANAEROB_Z_u244_exe_g);
	u244->Code() = "u244 <- 1";
	u244->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u245 = (TExecuteCommand*) P1_DOM_CTOOM.GetCommand("u245",TCommand::kUpdate,TCommand::kCode);
	u245->SetExecutable(&P1_DOM_CTOOM_u245_exe_g);
	u245->Code() = "u245 <- 0.2";
	u245->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u246 = (TExecuteCommand*) P1_DOM_NC.GetCommand("u246",TCommand::kUpdate,TCommand::kCode);
	u246->SetExecutable(&P1_DOM_NC_u246_exe_g);
	u246->Code() = "u246 <- ((float)0)";
	u246->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u247 = (TExecuteCommand*) P1_D_DEP_FACTOR.GetCommand("u247",TCommand::kUpdate,TCommand::kCode);
	u247->SetExecutable(&P1_D_DEP_FACTOR_u247_exe_g);
	u247->Code() = "u247 <- 1.7";
	u247->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u248 = (TExecuteCommand*) P1_NPOINTNSF.GetCommand("u248",TCommand::kUpdate,TCommand::kCode);
	u248->SetExecutable(&P1_NPOINTNSF_u248_exe_g);
	u248->Code() = "u248 <- 0";
	u248->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u249 = (TExecuteCommand*) P1_PHBIO_NC.GetCommand("u249",TCommand::kUpdate,TCommand::kCode);
	u249->SetExecutable(&P1_PHBIO_NC_u249_exe_g);
	u249->Code() = "u249 <- 0.1";
	u249->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u250 = (TExecuteCommand*) P1_PHBIO_NC_SF.GetCommand("u250",TCommand::kUpdate,TCommand::kCode);
	u250->SetExecutable(&P1_PHBIO_NC_SF_u250_exe_g);
	u250->Code() = "u250 <- 0.01";
	u250->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u251 = (TExecuteCommand*) P1_POINTNSF.GetCommand("u251",TCommand::kUpdate,TCommand::kCode);
	u251->SetExecutable(&P1_POINTNSF_u251_exe_g);
	u251->Code() = "u251 <- 0";
	u251->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u252 = (TExecuteCommand*) P1_POP_DENS.GetCommand("u252",TCommand::kUpdate,TCommand::kCode);
	u252->SetExecutable(&P1_POP_DENS_u252_exe_g);
	u252->Code() = "u252 <- ((float)10)";
	u252->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* v433 = (TExecuteCommand*) P1_POP_DENS.GetCommand("v433",TCommand::kFunction,TCommand::kCode);
	v433->SetExecutable(&P1_POP_DENS_v433_exe_g);
	v433->Code() = "v433 <- Function";
	v433->GetFunction() = 'P';
	v433->AddDependency(P1_POP_DENS);
	v433->AddDependency(HABITATMAP);
	v433->AddDependency(P1_BOCOEF);
	v433->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u253 = (TExecuteCommand*) P1_R_SUB.GetCommand("u253",TCommand::kUpdate,TCommand::kCode);
	u253->SetExecutable(&P1_R_SUB_u253_exe_g);
	u253->Code() = "u253 <- 0.100000";
	u253->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u254 = (TExecuteCommand*) P1_SEPTICLOAD.GetCommand("u254",TCommand::kUpdate,TCommand::kCode);
	u254->SetExecutable(&P1_SEPTICLOAD_u254_exe_g);
	u254->Code() = "u254 <- 0.013200";
	u254->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u255 = (TExecuteCommand*) P1_SEPTIC_RED.GetCommand("u255",TCommand::kUpdate,TCommand::kCode);
	u255->SetExecutable(&P1_SEPTIC_RED_u255_exe_g);
	u255->Code() = "u255 <- 0.800000";
	u255->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u256 = (TExecuteCommand*) P1_SEWERMAP.GetCommand("u256",TCommand::kUpdate,TCommand::kCode);
	u256->SetExecutable(&P1_SEWERMAP_u256_exe_g);
	u256->Code() = "u256 <- ((float)1)";
	u256->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u257 = (TExecuteCommand*) DIN_IN_RAIN.GetCommand("u257",TCommand::kUpdate,TCommand::kCode);
	u257->SetExecutable(&DIN_IN_RAIN_u257_exe_g);
	u257->Code() = "u257 <- Graph29(DAYJUL)";
	u257->AddDependency(DAYJUL);
	u257->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DIN_IN_RAIN_import = (TImportCommand*) DIN_IN_RAIN.GetCommand("DIN_IN_RAIN_import",TCommand::kUndefined,TCommand::kImport);
	DIN_IN_RAIN_import->Code() = "Import DIN_IN_RAIN from external";
	DIN_IN_RAIN_import->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int ZDIN_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int ZDIN_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int ZDIN_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int ZDIN_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class HYDROLOGY_module 
// ---------------------------------------------------------------------------
HYDROLOGY_module::HYDROLOGY_module(char* name) :
	TIME("TIME"),
	SURFACE_WATER("SURFACE_WATER"),
	UW_DEPTH("UW_DEPTH"),
	WATER_AVAIL("WATER_AVAIL"),
	SAT_WATER("SAT_WATER"),
	UNSAT_WATER("UNSAT_WATER"),
	UW_FROM_PRECIP("UW_FROM_PRECIP"),
	SW_TO_SATW_DOWNFLOW("SW_TO_SATW_DOWNFLOW"),
	SATW_FROM_PRECIP("SATW_FROM_PRECIP"),
	SATW_TO_SW_UPFLOW("SATW_TO_SW_UPFLOW"),
	SATW_OUTFLUX("SATW_OUTFLUX"),
	SW_OUTFLUX("SW_OUTFLUX"),
	SATW_TRANSP("SATW_TRANSP"),
	UW_ETRANSP("UW_ETRANSP"),
	ON_MAP("ON_MAP"),
	DIN_SD("DIN_SD"),
	HABITATMAP("HABITATMAP"),
	AIR_TEMP_C("AIR_TEMP_C"),
	PRECIP_M("PRECIP_M"),
	HYDRO("HYDRO"),
	ELEVATION("ELEVATION"),
	DIN_SF("DIN_SF"),
	SOLRADGRD("SOLRADGRD"),
	MACLAI("MACLAI"),
	CELL_SIZE("CELL_SIZE"),
	SOIL("SOIL"),
	HUMIDITY("HUMIDITY"),
	WIND("WIND"),
	A_IN("A_IN"),
	ELEV_MIN("ELEV_MIN"),
	ETPM("ETPM"),
	ROOT_DEPTH("ROOT_DEPTH"),
	P1_DATUM_TO_MSL("P1_DATUM_TO_MSL"),
	UW_SATW_EXCHANGE("UW_SATW_EXCHANGE"),
	SATW_RECHARGE("SATW_RECHARGE"),
	SATW_UW("SATW_UW"),
	SNOW_ICE("SNOW_ICE"),
	SNOWFALL("SNOWFALL"),
	SW_FREEZE("SW_FREEZE"),
	SNOWMELT("SNOWMELT"),
	SW_FROM_PRECIP("SW_FROM_PRECIP"),
	SW_EVAP("SW_EVAP"),
	TOT_IN("TOT_IN"),
	TOTAL_INFLOW("TOTAL_INFLOW"),
	TOT_OUT("TOT_OUT"),
	TOTAL_OUTFLOW("TOTAL_OUTFLOW"),
	BALANCE("BALANCE"),
	EVAPORATION("EVAPORATION"),
	EVAP_UW("EVAP_UW"),
	H_CONDUCT("H_CONDUCT"),
	IC_SATW("IC_SATW"),
	IC_UW("IC_UW"),
	INFILTRATION("INFILTRATION"),
	INF_COND("INF_COND"),
	INTERCEPT("INTERCEPT"),
	NET_PRECIP("NET_PRECIP"),
	OUT_F_SD("OUT_F_SD"),
	OUT_F_SF("OUT_F_SF"),
	PAN_CH("PAN_CH"),
	PAN_CT("PAN_CT"),
	PAN_CW("PAN_CW"),
	POROSITY("POROSITY"),
	POT_INFILTR("POT_INFILTR"),
	RAINFALL("RAINFALL"),
	SATWMAX("SATWMAX"),
	SATWRUNOFF("SATWRUNOFF"),
	SATW_HEAD("SATW_HEAD"),
	TOTAL_OUT("TOTAL_OUT"),
	TOTAL_PRECIP("TOTAL_PRECIP"),
	TRANSPIRATION("TRANSPIRATION"),
	UNSAT_CAP("UNSAT_CAP"),
	UW_CAPIL_EXP("UW_CAPIL_EXP"),
	UW_DELTA("UW_DELTA"),
	UW_DEPTH_BEFORE("UW_DEPTH_BEFORE"),
	UW_EXCESS("UW_EXCESS"),
	UW_MOIST_PRP("UW_MOIST_PRP"),
	UW_MP_R("UW_MP_R"),
	UW_PERC_RATE("UW_PERC_RATE"),
	UW_TRANS_PR("UW_TRANS_PR"),
	WAT_TABLE("WAT_TABLE"),
	P1_C_EVAP("P1_C_EVAP"),
	P1_C_FIELD_CAP("P1_C_FIELD_CAP"),
	P1_C_HORIZ_HYDR_COND("P1_C_HORIZ_HYDR_COND"),
	P1_C_INFILT("P1_C_INFILT"),
	P1_C_INF_HAB("P1_C_INF_HAB"),
	P1_C_INF_SLOPE("P1_C_INF_SLOPE"),
	P1_C_INF_SOIL("P1_C_INF_SOIL"),
	P1_C_INTERCEP("P1_C_INTERCEP"),
	P1_C_INTERCEPVEG("P1_C_INTERCEPVEG"),
	P1_C_POROSITY("P1_C_POROSITY"),
	P1_C_RECHG("P1_C_RECHG"),
	P1_C_SATW_OUT("P1_C_SATW_OUT"),
	P1_C_SW_MELT("P1_C_SW_MELT"),
	P1_C_SW_OUT("P1_C_SW_OUT"),
	P1_C_TRANSP("P1_C_TRANSP"),
	P1_C_UW_EVAP("P1_C_UW_EVAP"),
	P1_C_VERT_HYDR_COND("P1_C_VERT_HYDR_COND"),
	P1_C_ZIG("P1_C_ZIG"),
	P1_IC_SW_DEPTH("P1_IC_SW_DEPTH"),
	P1_IC_UW_MOIST_PR("P1_IC_UW_MOIST_PR"),
	P1_IC_WT_TABLE("P1_IC_WT_TABLE"),
	TModule(name) {

	SURFACE_WATER.SetF(FisExport,True,"CG");
	UW_DEPTH.SetF(FisExport,True,"CG");
	WATER_AVAIL.SetF(FisExport,True,"CG");
	SAT_WATER.SetF(FisExport,True,"CG");
	UNSAT_WATER.SetF(FisExport,True,"CG");
	UW_FROM_PRECIP.SetF(FisExport,True,"CG");
	SW_TO_SATW_DOWNFLOW.SetF(FisExport,True,"CG");
	SATW_FROM_PRECIP.SetF(FisExport,True,"CG");
	SATW_TO_SW_UPFLOW.SetF(FisExport,True,"CG");
	SATW_OUTFLUX.SetF(FisExport,True,"CG");
	SW_OUTFLUX.SetF(FisExport,True,"CG");
	SATW_TRANSP.SetF(FisExport,True,"CG");
	UW_ETRANSP.SetF(FisExport,True,"CG");
	ON_MAP.SetF(FisImport,True,"CG");
	DIN_SD.SetF(FisImport,True,"CG");
	HABITATMAP.SetF(FisImport,True,"CG");
	AIR_TEMP_C.SetF(FisImport,True,"CG");
	PRECIP_M.SetF(FisImport,True,"CG");
	HYDRO.SetF(FisImport,True,"CG");
	ELEVATION.SetF(FisImport,True,"CG");
	DIN_SF.SetF(FisImport,True,"CG");
	SOLRADGRD.SetF(FisImport,True,"CG");
	MACLAI.SetF(FisImport,True,"CG");
	CELL_SIZE.SetF(FisImport,True,"CG");
	SOIL.SetF(FisImport,True,"CG");
	HUMIDITY.SetF(FisImport,True,"CG");
	WIND.SetF(FisImport,True,"CG");
	A_IN.SetF(FisImport,True,"CG");
	ELEV_MIN.SetF(FisImport,True,"CG");
	ETPM.SetF(FisImport,True,"CG");
	ROOT_DEPTH.SetF(FisImport,True,"CG");
	P1_DATUM_TO_MSL.SetF(FisImport,True,"CG");
}	
int HYDROLOGY_module::SAT_WATER_I281_exe() {
	float value;

	SAT_WATER.UpdateIntegrator();
	switch( SAT_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SAT_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( ( ( UW_SATW_EXCHANGE.Value(p)+SW_TO_SATW_DOWNFLOW.Value(p) )+SATW_FROM_PRECIP.Value(p) )-SATW_RECHARGE.Value(p) )-SATW_TRANSP.Value(p) )-SATW_TO_SW_UPFLOW.Value(p) )-SATW_OUTFLUX.Value(p) )-SATW_UW.Value(p) );
			SAT_WATER.Update( p, value, dT() );
		}
		SAT_WATER.GrabMemory();
		if( SAT_WATER.GetF(FLinkEdges) ) { SAT_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( ( ( UW_SATW_EXCHANGE.Value()+SW_TO_SATW_DOWNFLOW.Value() )+SATW_FROM_PRECIP.Value() )-SATW_RECHARGE.Value() )-SATW_TRANSP.Value() )-SATW_TO_SW_UPFLOW.Value() )-SATW_OUTFLUX.Value() )-SATW_UW.Value() );
			SAT_WATER.Update( value, dT() );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SAT_WATER_i282_exe() {
	float value;

	SAT_WATER.UpdateIntegrator();
	switch( SAT_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SAT_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  IC_SATW.Value(p);
			SAT_WATER.InitValue( p, value );
		}
		SAT_WATER.GrabMemory();
		if( SAT_WATER.GetF(FLinkEdges) ) { SAT_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  IC_SATW.Value();
			SAT_WATER.InitValue( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SAT_WATER_vE434_exe() {
	float value;

			 GWTrans_I(SAT_WATER, POROSITY, H_CONDUCT, ON_MAP, DIN_SD, UNSAT_WATER, OUT_F_SD);
	SAT_WATER.UpdateReserve();
	return 0;
}

int HYDROLOGY_module::UW_SATW_EXCHANGE_u283_exe() {
	float value;

	switch( UW_SATW_EXCHANGE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_SATW_EXCHANGE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( INF_COND.Value(p) == ((float)0) ) ) ? ( ( UNSAT_WATER.Value(p)/dT() ) ) : ( SL::Min(( UNSAT_WATER.Value(p)/dT() ), ( ( SL::Max(((float)0), ( UW_DELTA.Value(p)*UW_MOIST_PRP.Value(p) ))/dT() )+UW_PERC_RATE.Value(p) )) ) ) ;
			UW_SATW_EXCHANGE.Update( p, value );
		}
		UW_SATW_EXCHANGE.GrabMemory();
		if( UW_SATW_EXCHANGE.GetF(FICFlux) ) UW_SATW_EXCHANGE.Cov().Set(0.0); 
		if( UW_SATW_EXCHANGE.GetF(FLinkEdges) ) { UW_SATW_EXCHANGE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( INF_COND.Value() == ((float)0) ) ) ? ( ( UNSAT_WATER.Value()/dT() ) ) : ( SL::Min(( UNSAT_WATER.Value()/dT() ), ( ( SL::Max(((float)0), ( UW_DELTA.Value()*UW_MOIST_PRP.Value() ))/dT() )+UW_PERC_RATE.Value() )) ) ) ;
			UW_SATW_EXCHANGE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SW_TO_SATW_DOWNFLOW_u284_exe() {
	float value;

	switch( SW_TO_SATW_DOWNFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_TO_SATW_DOWNFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( HABITATMAP.Value(p) == ((float)1) ) || ( ( UW_DEPTH_BEFORE.Value(p) == ((float)0) ) && ( UNSAT_CAP.Value(p) >  ((float)0) ) ) ) ) ? ( SL::Min(( UNSAT_CAP.Value(p)/dT() ), ( SURFACE_WATER.Value(p)/dT() )) ) : ( ((float)0) ) ) ;
			SW_TO_SATW_DOWNFLOW.Update( p, value );
		}
		SW_TO_SATW_DOWNFLOW.GrabMemory();
		if( SW_TO_SATW_DOWNFLOW.GetF(FICFlux) ) SW_TO_SATW_DOWNFLOW.Cov().Set(0.0); 
		if( SW_TO_SATW_DOWNFLOW.GetF(FLinkEdges) ) { SW_TO_SATW_DOWNFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( HABITATMAP.Value() == ((float)1) ) || ( ( UW_DEPTH_BEFORE.Value() == ((float)0) ) && ( UNSAT_CAP.Value() >  ((float)0) ) ) ) ) ? ( SL::Min(( UNSAT_CAP.Value()/dT() ), ( SURFACE_WATER.Value()/dT() )) ) : ( ((float)0) ) ) ;
			SW_TO_SATW_DOWNFLOW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATW_FROM_PRECIP_u285_exe() {
	float value;

	switch( SATW_FROM_PRECIP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_FROM_PRECIP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( INF_COND.Value(p) == ((float)0) ) ) ? ( ( ( UNSAT_CAP.Value(p)/dT() )-SW_TO_SATW_DOWNFLOW.Value(p) ) ) : ( ((float)0) ) ) ;
			SATW_FROM_PRECIP.Update( p, value );
		}
		SATW_FROM_PRECIP.GrabMemory();
		if( SATW_FROM_PRECIP.GetF(FICFlux) ) SATW_FROM_PRECIP.Cov().Set(0.0); 
		if( SATW_FROM_PRECIP.GetF(FLinkEdges) ) { SATW_FROM_PRECIP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( INF_COND.Value() == ((float)0) ) ) ? ( ( ( UNSAT_CAP.Value()/dT() )-SW_TO_SATW_DOWNFLOW.Value() ) ) : ( ((float)0) ) ) ;
			SATW_FROM_PRECIP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATW_RECHARGE_u286_exe() {
	float value;

	switch( SATW_RECHARGE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_RECHARGE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  P1_C_RECHG.Value(p);
			SATW_RECHARGE.Update( p, value );
		}
		SATW_RECHARGE.GrabMemory();
		if( SATW_RECHARGE.GetF(FICFlux) ) SATW_RECHARGE.Cov().Set(0.0); 
		if( SATW_RECHARGE.GetF(FLinkEdges) ) { SATW_RECHARGE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  P1_C_RECHG.Value();
			SATW_RECHARGE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATW_TRANSP_u287_exe() {
	float value;

	switch( SATW_TRANSP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_TRANSP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( TRANSPIRATION.Value(p)*( ((float)1)-UW_TRANS_PR.Value(p) ) );
			SATW_TRANSP.Update( p, value );
		}
		SATW_TRANSP.GrabMemory();
		if( SATW_TRANSP.GetF(FICFlux) ) SATW_TRANSP.Cov().Set(0.0); 
		if( SATW_TRANSP.GetF(FLinkEdges) ) { SATW_TRANSP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( TRANSPIRATION.Value()*( ((float)1)-UW_TRANS_PR.Value() ) );
			SATW_TRANSP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATW_TO_SW_UPFLOW_u288_exe() {
	float value;

	switch( SATW_TO_SW_UPFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_TO_SW_UPFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SAT_WATER.Value(p) >  SATWMAX.Value(p) ) ) ? ( ( SAT_WATER.Value(p)-SATWMAX.Value(p) ) ) : (  ( ( ( SAT_WATER.Value(p) >  SATWRUNOFF.Value(p) ) ) ? ( ( ( P1_C_ZIG.Value(p)*( SAT_WATER.Value(p)-SATWRUNOFF.Value(p) ) )*H_CONDUCT.Value(p) ) ) : ( ((float)0) ) )  ) ) ;
			SATW_TO_SW_UPFLOW.Update( p, value );
		}
		SATW_TO_SW_UPFLOW.GrabMemory();
		if( SATW_TO_SW_UPFLOW.GetF(FICFlux) ) SATW_TO_SW_UPFLOW.Cov().Set(0.0); 
		if( SATW_TO_SW_UPFLOW.GetF(FLinkEdges) ) { SATW_TO_SW_UPFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SAT_WATER.Value() >  SATWMAX.Value() ) ) ? ( ( SAT_WATER.Value()-SATWMAX.Value() ) ) : (  ( ( ( SAT_WATER.Value() >  SATWRUNOFF.Value() ) ) ? ( ( ( P1_C_ZIG.Value()*( SAT_WATER.Value()-SATWRUNOFF.Value() ) )*H_CONDUCT.Value() ) ) : ( ((float)0) ) )  ) ) ;
			SATW_TO_SW_UPFLOW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATW_OUTFLUX_u289_exe() {
	float value;

	switch( SATW_OUTFLUX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_OUTFLUX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_C_SATW_OUT.Value(p)*( SAT_WATER.Value(p)-IC_SATW.Value(p) ) );
			SATW_OUTFLUX.Update( p, value );
		}
		SATW_OUTFLUX.GrabMemory();
		if( SATW_OUTFLUX.GetF(FICFlux) ) SATW_OUTFLUX.Cov().Set(0.0); 
		if( SATW_OUTFLUX.GetF(FLinkEdges) ) { SATW_OUTFLUX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_C_SATW_OUT.Value()*( SAT_WATER.Value()-IC_SATW.Value() ) );
			SATW_OUTFLUX.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATW_UW_u290_exe() {
	float value;

	switch( SATW_UW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_UW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Max(((float)0), SL::Min(( -UW_DELTA.Value(p)*P1_C_FIELD_CAP.Value(p) ), ( SAT_WATER.Value(p)/dT() )));
			SATW_UW.Update( p, value );
		}
		SATW_UW.GrabMemory();
		if( SATW_UW.GetF(FICFlux) ) SATW_UW.Cov().Set(0.0); 
		if( SATW_UW.GetF(FLinkEdges) ) { SATW_UW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Max(((float)0), SL::Min(( -UW_DELTA.Value()*P1_C_FIELD_CAP.Value() ), ( SAT_WATER.Value()/dT() )));
			SATW_UW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SNOW_ICE_I291_exe() {
	float value;

	SNOW_ICE.UpdateIntegrator();
	switch( SNOW_ICE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SNOW_ICE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SNOWFALL.Value(p)+SW_FREEZE.Value(p) )-SNOWMELT.Value(p) );
			SNOW_ICE.Update( p, value, dT() );
		}
		SNOW_ICE.GrabMemory();
		if( SNOW_ICE.GetF(FLinkEdges) ) { SNOW_ICE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SNOWFALL.Value()+SW_FREEZE.Value() )-SNOWMELT.Value() );
			SNOW_ICE.Update( value, dT() );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SNOW_ICE_i292_exe() {
	float value;

	SNOW_ICE.UpdateIntegrator();
	switch( SNOW_ICE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SNOW_ICE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			SNOW_ICE.InitValue( p, value );
		}
		SNOW_ICE.GrabMemory();
		if( SNOW_ICE.GetF(FLinkEdges) ) { SNOW_ICE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			SNOW_ICE.InitValue( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SNOWFALL_u293_exe() {
	float value;

	switch( SNOWFALL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SNOWFALL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( AIR_TEMP_C.Value(p) <= ((float)0) ) ) ? ( PRECIP_M.Value(p) ) : ( ((float)0) ) ) ;
			SNOWFALL.Update( p, value );
		}
		SNOWFALL.GrabMemory();
		if( SNOWFALL.GetF(FICFlux) ) SNOWFALL.Cov().Set(0.0); 
		if( SNOWFALL.GetF(FLinkEdges) ) { SNOWFALL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( AIR_TEMP_C.Value() <= ((float)0) ) ) ? ( PRECIP_M.Value() ) : ( ((float)0) ) ) ;
			SNOWFALL.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SW_FREEZE_u294_exe() {
	float value;

	switch( SW_FREEZE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_FREEZE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( AIR_TEMP_C.Value(p) >  ((float)0) ) ) ? ( ((float)0) ) : ( ( ( -AIR_TEMP_C.Value(p)*SURFACE_WATER.Value(p) )*P1_C_SW_MELT.Value(p) ) ) ) ;
			SW_FREEZE.Update( p, value );
		}
		SW_FREEZE.GrabMemory();
		if( SW_FREEZE.GetF(FICFlux) ) SW_FREEZE.Cov().Set(0.0); 
		if( SW_FREEZE.GetF(FLinkEdges) ) { SW_FREEZE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( AIR_TEMP_C.Value() >  ((float)0) ) ) ? ( ((float)0) ) : ( ( ( -AIR_TEMP_C.Value()*SURFACE_WATER.Value() )*P1_C_SW_MELT.Value() ) ) ) ;
			SW_FREEZE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SNOWMELT_u295_exe() {
	float value;

	switch( SNOWMELT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SNOWMELT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( AIR_TEMP_C.Value(p) >  ((float)0) ) ) ? ( SL::Min(( P1_C_SW_MELT.Value(p)*AIR_TEMP_C.Value(p) ), ( SNOW_ICE.Value(p)/dT() )) ) : ( ((float)0) ) ) ;
			SNOWMELT.Update( p, value );
		}
		SNOWMELT.GrabMemory();
		if( SNOWMELT.GetF(FICFlux) ) SNOWMELT.Cov().Set(0.0); 
		if( SNOWMELT.GetF(FLinkEdges) ) { SNOWMELT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( AIR_TEMP_C.Value() >  ((float)0) ) ) ? ( SL::Min(( P1_C_SW_MELT.Value()*AIR_TEMP_C.Value() ), ( SNOW_ICE.Value()/dT() )) ) : ( ((float)0) ) ) ;
			SNOWMELT.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SURFACE_WATER_I296_exe() {
	float value;

	SURFACE_WATER.UpdateIntegrator();
	switch( SURFACE_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SURFACE_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( SW_FROM_PRECIP.Value(p)+SATW_TO_SW_UPFLOW.Value(p) )-SW_EVAP.Value(p) )-SW_TO_SATW_DOWNFLOW.Value(p) )-SW_FREEZE.Value(p) )-SW_OUTFLUX.Value(p) );
			SURFACE_WATER.Update( p, value, dT() );
		}
		SURFACE_WATER.GrabMemory();
		if( SURFACE_WATER.GetF(FLinkEdges) ) { SURFACE_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( SW_FROM_PRECIP.Value()+SATW_TO_SW_UPFLOW.Value() )-SW_EVAP.Value() )-SW_TO_SATW_DOWNFLOW.Value() )-SW_FREEZE.Value() )-SW_OUTFLUX.Value() );
			SURFACE_WATER.Update( value, dT() );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SURFACE_WATER_i297_exe() {
	float value;

	SURFACE_WATER.UpdateIntegrator();
	switch( SURFACE_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SURFACE_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  P1_IC_SW_DEPTH.Value(p);
			SURFACE_WATER.InitValue( p, value );
		}
		SURFACE_WATER.GrabMemory();
		if( SURFACE_WATER.GetF(FLinkEdges) ) { SURFACE_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  P1_IC_SW_DEPTH.Value();
			SURFACE_WATER.InitValue( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SURFACE_WATER_vE435_exe() {
	float value;

			 SWTransML_I(SURFACE_WATER, HYDRO, HABITATMAP, ELEVATION, P1_C_INF_SLOPE, DIN_SF, OUT_F_SF);
	SURFACE_WATER.UpdateReserve();
	return 0;
}

int HYDROLOGY_module::SW_FROM_PRECIP_u298_exe() {
	float value;

	switch( SW_FROM_PRECIP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_FROM_PRECIP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( NET_PRECIP.Value(p)-UW_FROM_PRECIP.Value(p) )-SATW_FROM_PRECIP.Value(p) );
			SW_FROM_PRECIP.Update( p, value );
		}
		SW_FROM_PRECIP.GrabMemory();
		if( SW_FROM_PRECIP.GetF(FICFlux) ) SW_FROM_PRECIP.Cov().Set(0.0); 
		if( SW_FROM_PRECIP.GetF(FLinkEdges) ) { SW_FROM_PRECIP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( NET_PRECIP.Value()-UW_FROM_PRECIP.Value() )-SATW_FROM_PRECIP.Value() );
			SW_FROM_PRECIP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SW_EVAP_u299_exe() {
	float value;

	switch( SW_EVAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_EVAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(SL::Max(EVAPORATION.Value(p), ((float)0)), ( SURFACE_WATER.Value(p)/dT() ));
			SW_EVAP.Update( p, value );
		}
		SW_EVAP.GrabMemory();
		if( SW_EVAP.GetF(FICFlux) ) SW_EVAP.Cov().Set(0.0); 
		if( SW_EVAP.GetF(FLinkEdges) ) { SW_EVAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(SL::Max(EVAPORATION.Value(), ((float)0)), ( SURFACE_WATER.Value()/dT() ));
			SW_EVAP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SW_OUTFLUX_u300_exe() {
	float value;

	switch( SW_OUTFLUX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_OUTFLUX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_C_SW_OUT.Value(p)*SURFACE_WATER.Value(p) )/dT() );
			SW_OUTFLUX.Update( p, value );
		}
		SW_OUTFLUX.GrabMemory();
		if( SW_OUTFLUX.GetF(FICFlux) ) SW_OUTFLUX.Cov().Set(0.0); 
		if( SW_OUTFLUX.GetF(FLinkEdges) ) { SW_OUTFLUX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_C_SW_OUT.Value()*SURFACE_WATER.Value() )/dT() );
			SW_OUTFLUX.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOT_IN_I301_exe() {
	float value;

	TOT_IN.UpdateIntegrator();
	switch( TOT_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOT_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  TOTAL_INFLOW.Value(p);
			TOT_IN.Update( p, value, dT() );
		}
		TOT_IN.GrabMemory();
		if( TOT_IN.GetF(FLinkEdges) ) { TOT_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  TOTAL_INFLOW.Value();
			TOT_IN.Update( value, dT() );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOT_IN_i302_exe() {
	float value;

	TOT_IN.UpdateIntegrator();
	switch( TOT_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOT_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			TOT_IN.InitValue( p, value );
		}
		TOT_IN.GrabMemory();
		if( TOT_IN.GetF(FLinkEdges) ) { TOT_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			TOT_IN.InitValue( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOTAL_INFLOW_u303_exe() {
	float value;

	switch( TOTAL_INFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOTAL_INFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  PRECIP_M.Value(p);
			TOTAL_INFLOW.Update( p, value );
		}
		TOTAL_INFLOW.GrabMemory();
		if( TOTAL_INFLOW.GetF(FICFlux) ) TOTAL_INFLOW.Cov().Set(0.0); 
		if( TOTAL_INFLOW.GetF(FLinkEdges) ) { TOTAL_INFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  PRECIP_M.Value();
			TOTAL_INFLOW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOT_OUT_I304_exe() {
	float value;

	TOT_OUT.UpdateIntegrator();
	switch( TOT_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOT_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  TOTAL_OUTFLOW.Value(p);
			TOT_OUT.Update( p, value, dT() );
		}
		TOT_OUT.GrabMemory();
		if( TOT_OUT.GetF(FLinkEdges) ) { TOT_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  TOTAL_OUTFLOW.Value();
			TOT_OUT.Update( value, dT() );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOT_OUT_i305_exe() {
	float value;

	TOT_OUT.UpdateIntegrator();
	switch( TOT_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOT_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			TOT_OUT.InitValue( p, value );
		}
		TOT_OUT.GrabMemory();
		if( TOT_OUT.GetF(FLinkEdges) ) { TOT_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			TOT_OUT.InitValue( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOTAL_OUTFLOW_u306_exe() {
	float value;

	switch( TOTAL_OUTFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOTAL_OUTFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  TOTAL_OUT.Value(p);
			TOTAL_OUTFLOW.Update( p, value );
		}
		TOTAL_OUTFLOW.GrabMemory();
		if( TOTAL_OUTFLOW.GetF(FICFlux) ) TOTAL_OUTFLOW.Cov().Set(0.0); 
		if( TOTAL_OUTFLOW.GetF(FLinkEdges) ) { TOTAL_OUTFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  TOTAL_OUT.Value();
			TOTAL_OUTFLOW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UNSAT_WATER_I307_exe() {
	float value;

	UNSAT_WATER.UpdateIntegrator();
	switch( UNSAT_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UNSAT_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( UW_FROM_PRECIP.Value(p)+SATW_UW.Value(p) )-UW_SATW_EXCHANGE.Value(p) )-UW_ETRANSP.Value(p) );
			UNSAT_WATER.Update( p, value, dT() );
		}
		UNSAT_WATER.GrabMemory();
		if( UNSAT_WATER.GetF(FLinkEdges) ) { UNSAT_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( UW_FROM_PRECIP.Value()+SATW_UW.Value() )-UW_SATW_EXCHANGE.Value() )-UW_ETRANSP.Value() );
			UNSAT_WATER.Update( value, dT() );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UNSAT_WATER_i308_exe() {
	float value;

	UNSAT_WATER.UpdateIntegrator();
	switch( UNSAT_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UNSAT_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  IC_UW.Value(p);
			UNSAT_WATER.InitValue( p, value );
		}
		UNSAT_WATER.GrabMemory();
		if( UNSAT_WATER.GetF(FLinkEdges) ) { UNSAT_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  IC_UW.Value();
			UNSAT_WATER.InitValue( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_FROM_PRECIP_u309_exe() {
	float value;

	switch( UW_FROM_PRECIP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_FROM_PRECIP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( INF_COND.Value(p) >  ((float)0) ) ) ? ( INFILTRATION.Value(p) ) : ( ((float)0) ) ) ;
			UW_FROM_PRECIP.Update( p, value );
		}
		UW_FROM_PRECIP.GrabMemory();
		if( UW_FROM_PRECIP.GetF(FICFlux) ) UW_FROM_PRECIP.Cov().Set(0.0); 
		if( UW_FROM_PRECIP.GetF(FLinkEdges) ) { UW_FROM_PRECIP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( INF_COND.Value() >  ((float)0) ) ) ? ( INFILTRATION.Value() ) : ( ((float)0) ) ) ;
			UW_FROM_PRECIP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_ETRANSP_u310_exe() {
	float value;

	switch( UW_ETRANSP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_ETRANSP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( TRANSPIRATION.Value(p)*UW_TRANS_PR.Value(p) )+EVAP_UW.Value(p) );
			UW_ETRANSP.Update( p, value );
		}
		UW_ETRANSP.GrabMemory();
		if( UW_ETRANSP.GetF(FICFlux) ) UW_ETRANSP.Cov().Set(0.0); 
		if( UW_ETRANSP.GetF(FLinkEdges) ) { UW_ETRANSP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( TRANSPIRATION.Value()*UW_TRANS_PR.Value() )+EVAP_UW.Value() );
			UW_ETRANSP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::BALANCE_u311_exe() {
	float value;

	switch( BALANCE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = BALANCE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( SAT_WATER.Value(p)+SNOW_ICE.Value(p) )+SURFACE_WATER.Value(p) )+UNSAT_WATER.Value(p) )-TOT_IN.Value(p) )+TOT_OUT.Value(p) );
			BALANCE.Update( p, value );
		}
		BALANCE.GrabMemory();
		if( BALANCE.GetF(FLinkEdges) ) { BALANCE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( SAT_WATER.Value()+SNOW_ICE.Value() )+SURFACE_WATER.Value() )+UNSAT_WATER.Value() )-TOT_IN.Value() )+TOT_OUT.Value() );
			BALANCE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::EVAPORATION_u312_exe() {
	float value;

	switch( EVAPORATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EVAPORATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( P1_C_EVAP.Value(p)*SOLRADGRD.Value(p) )/585 )*PAN_CW.Value(p) )*PAN_CT.Value(p) )*PAN_CH.Value(p) );
			EVAPORATION.Update( p, value );
		}
		EVAPORATION.GrabMemory();
		if( EVAPORATION.GetF(FLinkEdges) ) { EVAPORATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( P1_C_EVAP.Value()*SOLRADGRD.Value() )/585 )*PAN_CW.Value() )*PAN_CT.Value() )*PAN_CH.Value() );
			EVAPORATION.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::EVAP_UW_u313_exe() {
	float value;

	switch( EVAP_UW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EVAP_UW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( P1_C_UW_EVAP.Value(p)*EVAPORATION.Value(p) )*( ((float)1)-SL::Min(((float)1), MACLAI.Value(p)) ) )*UW_MP_R.Value(p) );
			EVAP_UW.Update( p, value );
		}
		EVAP_UW.GrabMemory();
		if( EVAP_UW.GetF(FLinkEdges) ) { EVAP_UW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( P1_C_UW_EVAP.Value()*EVAPORATION.Value() )*( ((float)1)-SL::Min(((float)1), MACLAI.Value()) ) )*UW_MP_R.Value() );
			EVAP_UW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::H_CONDUCT_u314_exe() {
	float value;

	switch( H_CONDUCT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = H_CONDUCT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_C_HORIZ_HYDR_COND.Value(p)/SL::Sqrt(CELL_SIZE.Value(p)) )+( SOIL.Value(p)*0.0 ) );
			H_CONDUCT.Update( p, value );
		}
		H_CONDUCT.GrabMemory();
		if( H_CONDUCT.GetF(FLinkEdges) ) { H_CONDUCT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_C_HORIZ_HYDR_COND.Value()/SL::Sqrt(CELL_SIZE.Value()) )+( SOIL.Value()*0.0 ) );
			H_CONDUCT.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::IC_SATW_u315_exe() {
	float value;

	switch( IC_SATW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = IC_SATW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( WAT_TABLE.Value(p)*P1_C_POROSITY.Value(p) );
			IC_SATW.Update( p, value );
		}
		IC_SATW.GrabMemory();
		if( IC_SATW.GetF(FLinkEdges) ) { IC_SATW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( WAT_TABLE.Value()*P1_C_POROSITY.Value() );
			IC_SATW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::IC_UW_u316_exe() {
	float value;

	switch( IC_UW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = IC_UW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ELEVATION.Value(p) >  WAT_TABLE.Value(p) ) ) ? ( ( ( ELEVATION.Value(p)-WAT_TABLE.Value(p) )*P1_IC_UW_MOIST_PR.Value(p) ) ) : ( ((float)0) ) ) ;
			IC_UW.Update( p, value );
		}
		IC_UW.GrabMemory();
		if( IC_UW.GetF(FLinkEdges) ) { IC_UW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ELEVATION.Value() >  WAT_TABLE.Value() ) ) ? ( ( ( ELEVATION.Value()-WAT_TABLE.Value() )*P1_IC_UW_MOIST_PR.Value() ) ) : ( ((float)0) ) ) ;
			IC_UW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::INFILTRATION_u317_exe() {
	float value;

	switch( INFILTRATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = INFILTRATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(POT_INFILTR.Value(p), NET_PRECIP.Value(p));
			INFILTRATION.Update( p, value );
		}
		INFILTRATION.GrabMemory();
		if( INFILTRATION.GetF(FLinkEdges) ) { INFILTRATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(POT_INFILTR.Value(), NET_PRECIP.Value());
			INFILTRATION.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::INF_COND_u318_exe() {
	float value;

	switch( INF_COND.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = INF_COND.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( SW_TO_SATW_DOWNFLOW.Value(p)*dT() ) == UNSAT_CAP.Value(p) ) ) ? ( ((float)0) ) : ( SL::Max(( UNSAT_CAP.Value(p)-( INFILTRATION.Value(p)*dT() ) ), ((float)0)) ) ) ;
			INF_COND.Update( p, value );
		}
		INF_COND.GrabMemory();
		if( INF_COND.GetF(FLinkEdges) ) { INF_COND.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( SW_TO_SATW_DOWNFLOW.Value()*dT() ) == UNSAT_CAP.Value() ) ) ? ( ((float)0) ) : ( SL::Max(( UNSAT_CAP.Value()-( INFILTRATION.Value()*dT() ) ), ((float)0)) ) ) ;
			INF_COND.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::INTERCEPT_u319_exe() {
	float value;

	switch( INTERCEPT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = INTERCEPT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(TOTAL_PRECIP.Value(p), SL::Max(( P1_C_INTERCEP.Value(p)*TOTAL_PRECIP.Value(p) ), ( P1_C_INTERCEPVEG.Value(p)*MACLAI.Value(p) )));
			INTERCEPT.Update( p, value );
		}
		INTERCEPT.GrabMemory();
		if( INTERCEPT.GetF(FLinkEdges) ) { INTERCEPT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(TOTAL_PRECIP.Value(), SL::Max(( P1_C_INTERCEP.Value()*TOTAL_PRECIP.Value() ), ( P1_C_INTERCEPVEG.Value()*MACLAI.Value() )));
			INTERCEPT.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::NET_PRECIP_u320_exe() {
	float value;

	switch( NET_PRECIP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NET_PRECIP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( TOTAL_PRECIP.Value(p)-INTERCEPT.Value(p) );
			NET_PRECIP.Update( p, value );
		}
		NET_PRECIP.GrabMemory();
		if( NET_PRECIP.GetF(FLinkEdges) ) { NET_PRECIP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( TOTAL_PRECIP.Value()-INTERCEPT.Value() );
			NET_PRECIP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::OUT_F_SD_u321_exe() {
	float value;

	switch( OUT_F_SD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = OUT_F_SD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			OUT_F_SD.Update( p, value );
		}
		OUT_F_SD.GrabMemory();
		if( OUT_F_SD.GetF(FLinkEdges) ) { OUT_F_SD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			OUT_F_SD.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::OUT_F_SF_u322_exe() {
	float value;

	switch( OUT_F_SF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = OUT_F_SF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			OUT_F_SF.Update( p, value );
		}
		OUT_F_SF.GrabMemory();
		if( OUT_F_SF.GetF(FLinkEdges) ) { OUT_F_SF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			OUT_F_SF.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::PAN_CH_u323_exe() {
	float value;

	switch( PAN_CH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PAN_CH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( 1.035+( 0.240*pow((double)( HUMIDITY.Value(p)/60 ),(double)((float)2) ) ) )-( 0.275*pow((double)( HUMIDITY.Value(p)/60 ),(double)((float)3) ) ) );
			PAN_CH.Update( p, value );
		}
		PAN_CH.GrabMemory();
		if( PAN_CH.GetF(FLinkEdges) ) { PAN_CH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( 1.035+( 0.240*pow((double)( HUMIDITY.Value()/60 ),(double)((float)2) ) ) )-( 0.275*pow((double)( HUMIDITY.Value()/60 ),(double)((float)3) ) ) );
			PAN_CH.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::PAN_CT_u324_exe() {
	float value;

	switch( PAN_CT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PAN_CT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( AIR_TEMP_C.Value(p) >  -((float)30) ) ) ? ( ( ( 0.463+( 0.425*( AIR_TEMP_C.Value(p)/20 ) ) )+( 0.112*pow((double)( AIR_TEMP_C.Value(p)/20 ),(double)((float)2) ) ) ) ) : ( ((float)0) ) ) ;
			PAN_CT.Update( p, value );
		}
		PAN_CT.GrabMemory();
		if( PAN_CT.GetF(FLinkEdges) ) { PAN_CT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( AIR_TEMP_C.Value() >  -((float)30) ) ) ? ( ( ( 0.463+( 0.425*( AIR_TEMP_C.Value()/20 ) ) )+( 0.112*pow((double)( AIR_TEMP_C.Value()/20 ),(double)((float)2) ) ) ) ) : ( ((float)0) ) ) ;
			PAN_CT.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::PAN_CW_u325_exe() {
	float value;

	switch( PAN_CW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PAN_CW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( 0.672+( 0.406*( WIND.Value(p)/6.7 ) ) )+( 0.078*pow((double)( WIND.Value(p)/6.7 ),(double)((float)2) ) ) );
			PAN_CW.Update( p, value );
		}
		PAN_CW.GrabMemory();
		if( PAN_CW.GetF(FLinkEdges) ) { PAN_CW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( 0.672+( 0.406*( WIND.Value()/6.7 ) ) )+( 0.078*pow((double)( WIND.Value()/6.7 ),(double)((float)2) ) ) );
			PAN_CW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::POROSITY_u326_exe() {
	float value;

	switch( POROSITY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = POROSITY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_C_POROSITY.Value(p)+( SOIL.Value(p)*0.0 ) );
			POROSITY.Update( p, value );
		}
		POROSITY.GrabMemory();
		if( POROSITY.GetF(FLinkEdges) ) { POROSITY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_C_POROSITY.Value()+( SOIL.Value()*0.0 ) );
			POROSITY.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::POT_INFILTR_u327_exe() {
	float value;

	switch( POT_INFILTR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = POT_INFILTR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( P1_C_INFILT.Value(p)*P1_C_INF_HAB.Value(p) )*P1_C_INF_SOIL.Value(p) )/ ( ( ( P1_C_INF_SLOPE.Value(p) >  ((float)0) ) ) ? ( P1_C_INF_SOIL.Value(p) ) : ( ((float)1) ) )  );
			POT_INFILTR.Update( p, value );
		}
		POT_INFILTR.GrabMemory();
		if( POT_INFILTR.GetF(FLinkEdges) ) { POT_INFILTR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( P1_C_INFILT.Value()*P1_C_INF_HAB.Value() )*P1_C_INF_SOIL.Value() )/ ( ( ( P1_C_INF_SLOPE.Value() >  ((float)0) ) ) ? ( P1_C_INF_SOIL.Value() ) : ( ((float)1) ) )  );
			POT_INFILTR.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::POT_INFILTR_v436_exe() {
	float value;

			 Infilt(POT_INFILTR, PRECIP_M, TOTAL_INFLOW, TOTAL_OUTFLOW, BALANCE, A_IN);
	return 0;
}

int HYDROLOGY_module::RAINFALL_u328_exe() {
	float value;

	switch( RAINFALL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = RAINFALL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( AIR_TEMP_C.Value(p) >  ((float)0) ) ) ? ( PRECIP_M.Value(p) ) : ( ((float)0) ) ) ;
			RAINFALL.Update( p, value );
		}
		RAINFALL.GrabMemory();
		if( RAINFALL.GetF(FLinkEdges) ) { RAINFALL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( AIR_TEMP_C.Value() >  ((float)0) ) ) ? ( PRECIP_M.Value() ) : ( ((float)0) ) ) ;
			RAINFALL.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATWMAX_u329_exe() {
	float value;

	switch( SATWMAX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATWMAX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ELEVATION.Value(p)*P1_C_POROSITY.Value(p) );
			SATWMAX.Update( p, value );
		}
		SATWMAX.GrabMemory();
		if( SATWMAX.GetF(FLinkEdges) ) { SATWMAX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ELEVATION.Value()*P1_C_POROSITY.Value() );
			SATWMAX.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATWRUNOFF_u330_exe() {
	float value;

	switch( SATWRUNOFF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATWRUNOFF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ELEV_MIN.Value(p)*P1_C_POROSITY.Value(p) );
			SATWRUNOFF.Update( p, value );
		}
		SATWRUNOFF.GrabMemory();
		if( SATWRUNOFF.GetF(FLinkEdges) ) { SATWRUNOFF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ELEV_MIN.Value()*P1_C_POROSITY.Value() );
			SATWRUNOFF.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATW_HEAD_u331_exe() {
	float value;

	switch( SATW_HEAD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_HEAD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SAT_WATER.Value(p)/P1_C_POROSITY.Value(p) );
			SATW_HEAD.Update( p, value );
		}
		SATW_HEAD.GrabMemory();
		if( SATW_HEAD.GetF(FLinkEdges) ) { SATW_HEAD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SAT_WATER.Value()/P1_C_POROSITY.Value() );
			SATW_HEAD.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOTAL_OUT_u332_exe() {
	float value;

	switch( TOTAL_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOTAL_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( ( INTERCEPT.Value(p)+SATW_OUTFLUX.Value(p) )+SATW_RECHARGE.Value(p) )+SATW_TRANSP.Value(p) )+SW_EVAP.Value(p) )+SW_OUTFLUX.Value(p) )+UW_ETRANSP.Value(p) );
			TOTAL_OUT.Update( p, value );
		}
		TOTAL_OUT.GrabMemory();
		if( TOTAL_OUT.GetF(FLinkEdges) ) { TOTAL_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( ( INTERCEPT.Value()+SATW_OUTFLUX.Value() )+SATW_RECHARGE.Value() )+SATW_TRANSP.Value() )+SW_EVAP.Value() )+SW_OUTFLUX.Value() )+UW_ETRANSP.Value() );
			TOTAL_OUT.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOTAL_PRECIP_u333_exe() {
	float value;

	switch( TOTAL_PRECIP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOTAL_PRECIP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( RAINFALL.Value(p)+SNOWMELT.Value(p) );
			TOTAL_PRECIP.Update( p, value );
		}
		TOTAL_PRECIP.GrabMemory();
		if( TOTAL_PRECIP.GetF(FLinkEdges) ) { TOTAL_PRECIP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( RAINFALL.Value()+SNOWMELT.Value() );
			TOTAL_PRECIP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TRANSPIRATION_u334_exe() {
	float value;

	switch( TRANSPIRATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TRANSPIRATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( P1_C_TRANSP.Value(p)*SL::Min(((float)1), MACLAI.Value(p)) )*ETPM.Value(p) )*WATER_AVAIL.Value(p) );
			TRANSPIRATION.Update( p, value );
		}
		TRANSPIRATION.GrabMemory();
		if( TRANSPIRATION.GetF(FLinkEdges) ) { TRANSPIRATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( P1_C_TRANSP.Value()*SL::Min(((float)1), MACLAI.Value()) )*ETPM.Value() )*WATER_AVAIL.Value() );
			TRANSPIRATION.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UNSAT_CAP_u335_exe() {
	float value;

	switch( UNSAT_CAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UNSAT_CAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Max(( UW_DEPTH.Value(p)*( P1_C_POROSITY.Value(p)-UW_MOIST_PRP.Value(p) ) ), ((float)0));
			UNSAT_CAP.Update( p, value );
		}
		UNSAT_CAP.GrabMemory();
		if( UNSAT_CAP.GetF(FLinkEdges) ) { UNSAT_CAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Max(( UW_DEPTH.Value()*( P1_C_POROSITY.Value()-UW_MOIST_PRP.Value() ) ), ((float)0));
			UNSAT_CAP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_CAPIL_EXP_u336_exe() {
	float value;

	switch( UW_CAPIL_EXP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_CAPIL_EXP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Exp(( -((float)10)*SL::Max(( UW_DEPTH.Value(p)-ROOT_DEPTH.Value(p) ), ((float)0)) ));
			UW_CAPIL_EXP.Update( p, value );
		}
		UW_CAPIL_EXP.GrabMemory();
		if( UW_CAPIL_EXP.GetF(FLinkEdges) ) { UW_CAPIL_EXP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Exp(( -((float)10)*SL::Max(( UW_DEPTH.Value()-ROOT_DEPTH.Value() ), ((float)0)) ));
			UW_CAPIL_EXP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_DELTA_u337_exe() {
	float value;

	switch( UW_DELTA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_DELTA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( UW_DEPTH_BEFORE.Value(p)-UW_DEPTH.Value(p) );
			UW_DELTA.Update( p, value );
		}
		UW_DELTA.GrabMemory();
		if( UW_DELTA.GetF(FLinkEdges) ) { UW_DELTA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( UW_DEPTH_BEFORE.Value()-UW_DEPTH.Value() );
			UW_DELTA.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_DEPTH_u338_exe() {
	float value;

	switch( UW_DEPTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_DEPTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Max(( ELEVATION.Value(p)-SATW_HEAD.Value(p) ), ((float)0));
			UW_DEPTH.Update( p, value );
		}
		UW_DEPTH.GrabMemory();
		UW_DEPTH.UpdateDelayData();
		if( UW_DEPTH.GetF(FLinkEdges) ) { UW_DEPTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Max(( ELEVATION.Value()-SATW_HEAD.Value() ), ((float)0));
			UW_DEPTH.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_DEPTH_BEFORE_u339_exe() {
	float value;

	switch( UW_DEPTH_BEFORE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_DEPTH_BEFORE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  UW_DEPTH.Delay(  p, dT() );
			UW_DEPTH_BEFORE.Update( p, value );
		}
		UW_DEPTH_BEFORE.GrabMemory();
		if( UW_DEPTH_BEFORE.GetF(FLinkEdges) ) { UW_DEPTH_BEFORE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  UW_DEPTH.Delay( dT() );
			UW_DEPTH_BEFORE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_EXCESS_u340_exe() {
	float value;

	switch( UW_EXCESS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_EXCESS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Max(((float)0), ( UW_MOIST_PRP.Value(p)-P1_C_FIELD_CAP.Value(p) ));
			UW_EXCESS.Update( p, value );
		}
		UW_EXCESS.GrabMemory();
		if( UW_EXCESS.GetF(FLinkEdges) ) { UW_EXCESS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Max(((float)0), ( UW_MOIST_PRP.Value()-P1_C_FIELD_CAP.Value() ));
			UW_EXCESS.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_MOIST_PRP_u341_exe() {
	float value;

	switch( UW_MOIST_PRP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_MOIST_PRP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( UW_DEPTH.Value(p) >  ((float)0) ) ) ? ( ( UNSAT_WATER.Value(p)/UW_DEPTH.Value(p) ) ) : ( ((float)0) ) ) ;
			UW_MOIST_PRP.Update( p, value );
		}
		UW_MOIST_PRP.GrabMemory();
		if( UW_MOIST_PRP.GetF(FLinkEdges) ) { UW_MOIST_PRP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( UW_DEPTH.Value() >  ((float)0) ) ) ? ( ( UNSAT_WATER.Value()/UW_DEPTH.Value() ) ) : ( ((float)0) ) ) ;
			UW_MOIST_PRP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_MP_R_u342_exe() {
	float value;

	switch( UW_MP_R.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_MP_R.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( UW_MOIST_PRP.Value(p)/P1_C_POROSITY.Value(p) );
			UW_MP_R.Update( p, value );
		}
		UW_MP_R.GrabMemory();
		if( UW_MP_R.GetF(FLinkEdges) ) { UW_MP_R.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( UW_MOIST_PRP.Value()/P1_C_POROSITY.Value() );
			UW_MP_R.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_PERC_RATE_u343_exe() {
	float value;

	switch( UW_PERC_RATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_PERC_RATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ((float)2)*P1_C_VERT_HYDR_COND.Value(p) )*P1_C_POROSITY.Value(p) )*pow((double)UW_EXCESS.Value(p),(double)0.4 ) )/( pow((double)( P1_C_POROSITY.Value(p)-P1_C_FIELD_CAP.Value(p) ),(double)0.4 )+pow((double)UW_EXCESS.Value(p),(double)0.4 ) ) );
			UW_PERC_RATE.Update( p, value );
		}
		UW_PERC_RATE.GrabMemory();
		if( UW_PERC_RATE.GetF(FLinkEdges) ) { UW_PERC_RATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ((float)2)*P1_C_VERT_HYDR_COND.Value() )*P1_C_POROSITY.Value() )*pow((double)UW_EXCESS.Value(),(double)0.4 ) )/( pow((double)( P1_C_POROSITY.Value()-P1_C_FIELD_CAP.Value() ),(double)0.4 )+pow((double)UW_EXCESS.Value(),(double)0.4 ) ) );
			UW_PERC_RATE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_TRANS_PR_u344_exe() {
	float value;

	switch( UW_TRANS_PR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_TRANS_PR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( ROOT_DEPTH.Value(p)+0.1 ) <  UW_DEPTH.Value(p) ) ) ? ( ((float)1) ) : (  ( ( ( UW_DEPTH.Value(p) >  ((float)0) ) ) ? ( ( WATER_AVAIL.Value(p)*( UW_DEPTH.Value(p)/( ROOT_DEPTH.Value(p)+UW_CAPIL_EXP.Value(p) ) ) ) ) : ( ((float)0) ) )  ) ) ;
			UW_TRANS_PR.Update( p, value );
		}
		UW_TRANS_PR.GrabMemory();
		if( UW_TRANS_PR.GetF(FLinkEdges) ) { UW_TRANS_PR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( ROOT_DEPTH.Value()+0.1 ) <  UW_DEPTH.Value() ) ) ? ( ((float)1) ) : (  ( ( ( UW_DEPTH.Value() >  ((float)0) ) ) ? ( ( WATER_AVAIL.Value()*( UW_DEPTH.Value()/( ROOT_DEPTH.Value()+UW_CAPIL_EXP.Value() ) ) ) ) : ( ((float)0) ) )  ) ) ;
			UW_TRANS_PR.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::WATER_AVAIL_u345_exe() {
	float value;

	switch( WATER_AVAIL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WATER_AVAIL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(1.0, ( UW_CAPIL_EXP.Value(p)+ ( ( ( UW_MOIST_PRP.Value(p) <  ( 0.1*P1_C_FIELD_CAP.Value(p) ) ) ) ? ( ((float)0) ) : (  ( ( ( UW_MOIST_PRP.Value(p) >  ( 0.6*P1_C_FIELD_CAP.Value(p) ) ) ) ? ( ((float)1) ) : ( ( ( ( UW_MOIST_PRP.Value(p)-( 0.1*P1_C_FIELD_CAP.Value(p) ) )/0.5 )/P1_C_FIELD_CAP.Value(p) ) ) )  ) )  ));
			WATER_AVAIL.Update( p, value );
		}
		WATER_AVAIL.GrabMemory();
		if( WATER_AVAIL.GetF(FLinkEdges) ) { WATER_AVAIL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(1.0, ( UW_CAPIL_EXP.Value()+ ( ( ( UW_MOIST_PRP.Value() <  ( 0.1*P1_C_FIELD_CAP.Value() ) ) ) ? ( ((float)0) ) : (  ( ( ( UW_MOIST_PRP.Value() >  ( 0.6*P1_C_FIELD_CAP.Value() ) ) ) ? ( ((float)1) ) : ( ( ( ( UW_MOIST_PRP.Value()-( 0.1*P1_C_FIELD_CAP.Value() ) )/0.5 )/P1_C_FIELD_CAP.Value() ) ) )  ) )  ));
			WATER_AVAIL.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::WAT_TABLE_u346_exe() {
	float value;

	switch( WAT_TABLE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WAT_TABLE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_IC_WT_TABLE.Value(p)+P1_DATUM_TO_MSL.Value(p) );
			WAT_TABLE.Update( p, value );
		}
		WAT_TABLE.GrabMemory();
		if( WAT_TABLE.GetF(FLinkEdges) ) { WAT_TABLE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_IC_WT_TABLE.Value()+P1_DATUM_TO_MSL.Value() );
			WAT_TABLE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_EVAP_u347_exe() {
	float value;

	switch( P1_C_EVAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_EVAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000482;
			P1_C_EVAP.Update( p, value );
		}
		P1_C_EVAP.GrabMemory();
		if( P1_C_EVAP.GetF(FLinkEdges) ) { P1_C_EVAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000482;
			P1_C_EVAP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_FIELD_CAP_u348_exe() {
	float value;

	switch( P1_C_FIELD_CAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_FIELD_CAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.25;
			P1_C_FIELD_CAP.Update( p, value );
		}
		P1_C_FIELD_CAP.GrabMemory();
		if( P1_C_FIELD_CAP.GetF(FLinkEdges) ) { P1_C_FIELD_CAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.25;
			P1_C_FIELD_CAP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_HORIZ_HYDR_COND_u349_exe() {
	float value;

	switch( P1_C_HORIZ_HYDR_COND.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_HORIZ_HYDR_COND.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)5);
			P1_C_HORIZ_HYDR_COND.Update( p, value );
		}
		P1_C_HORIZ_HYDR_COND.GrabMemory();
		if( P1_C_HORIZ_HYDR_COND.GetF(FLinkEdges) ) { P1_C_HORIZ_HYDR_COND.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)5);
			P1_C_HORIZ_HYDR_COND.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_INFILT_u350_exe() {
	float value;

	switch( P1_C_INFILT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_INFILT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.04;
			P1_C_INFILT.Update( p, P1_C_INFILT.ParameterValue(value,p) );
		}
		P1_C_INFILT.GrabMemory();
		if( P1_C_INFILT.GetF(FLinkEdges) ) { P1_C_INFILT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.04;
			P1_C_INFILT.Update( P1_C_INFILT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_INF_HAB_u351_exe() {
	float value;

	switch( P1_C_INF_HAB.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_INF_HAB.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			P1_C_INF_HAB.Update( p, value );
		}
		P1_C_INF_HAB.GrabMemory();
		if( P1_C_INF_HAB.GetF(FLinkEdges) ) { P1_C_INF_HAB.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			P1_C_INF_HAB.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_INF_SLOPE_u352_exe() {
	float value;

	switch( P1_C_INF_SLOPE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_INF_SLOPE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)5);
			P1_C_INF_SLOPE.Update( p, value );
		}
		P1_C_INF_SLOPE.GrabMemory();
		if( P1_C_INF_SLOPE.GetF(FLinkEdges) ) { P1_C_INF_SLOPE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)5);
			P1_C_INF_SLOPE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_INF_SOIL_u353_exe() {
	float value;

	switch( P1_C_INF_SOIL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_INF_SOIL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  4.00;
			P1_C_INF_SOIL.Update( p, value );
		}
		P1_C_INF_SOIL.GrabMemory();
		if( P1_C_INF_SOIL.GetF(FLinkEdges) ) { P1_C_INF_SOIL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  4.00;
			P1_C_INF_SOIL.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_INTERCEP_u354_exe() {
	float value;

	switch( P1_C_INTERCEP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_INTERCEP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.002;
			P1_C_INTERCEP.Update( p, value );
		}
		P1_C_INTERCEP.GrabMemory();
		if( P1_C_INTERCEP.GetF(FLinkEdges) ) { P1_C_INTERCEP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.002;
			P1_C_INTERCEP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_INTERCEPVEG_u355_exe() {
	float value;

	switch( P1_C_INTERCEPVEG.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_INTERCEPVEG.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.001;
			P1_C_INTERCEPVEG.Update( p, value );
		}
		P1_C_INTERCEPVEG.GrabMemory();
		if( P1_C_INTERCEPVEG.GetF(FLinkEdges) ) { P1_C_INTERCEPVEG.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.001;
			P1_C_INTERCEPVEG.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_POROSITY_u356_exe() {
	float value;

	switch( P1_C_POROSITY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_POROSITY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.41;
			P1_C_POROSITY.Update( p, value );
		}
		P1_C_POROSITY.GrabMemory();
		if( P1_C_POROSITY.GetF(FLinkEdges) ) { P1_C_POROSITY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.41;
			P1_C_POROSITY.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_RECHG_u357_exe() {
	float value;

	switch( P1_C_RECHG.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_RECHG.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.00001;
			P1_C_RECHG.Update( p, P1_C_RECHG.ParameterValue(value,p) );
		}
		P1_C_RECHG.GrabMemory();
		if( P1_C_RECHG.GetF(FLinkEdges) ) { P1_C_RECHG.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.00001;
			P1_C_RECHG.Update( P1_C_RECHG.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_SATW_OUT_u358_exe() {
	float value;

	switch( P1_C_SATW_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_SATW_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.;
			P1_C_SATW_OUT.Update( p, P1_C_SATW_OUT.ParameterValue(value,p) );
		}
		P1_C_SATW_OUT.GrabMemory();
		if( P1_C_SATW_OUT.GetF(FLinkEdges) ) { P1_C_SATW_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.;
			P1_C_SATW_OUT.Update( P1_C_SATW_OUT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_SW_MELT_u359_exe() {
	float value;

	switch( P1_C_SW_MELT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_SW_MELT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.005;
			P1_C_SW_MELT.Update( p, P1_C_SW_MELT.ParameterValue(value,p) );
		}
		P1_C_SW_MELT.GrabMemory();
		if( P1_C_SW_MELT.GetF(FLinkEdges) ) { P1_C_SW_MELT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.005;
			P1_C_SW_MELT.Update( P1_C_SW_MELT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_SW_OUT_u360_exe() {
	float value;

	switch( P1_C_SW_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_SW_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.;
			P1_C_SW_OUT.Update( p, P1_C_SW_OUT.ParameterValue(value,p) );
		}
		P1_C_SW_OUT.GrabMemory();
		if( P1_C_SW_OUT.GetF(FLinkEdges) ) { P1_C_SW_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.;
			P1_C_SW_OUT.Update( P1_C_SW_OUT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_TRANSP_u361_exe() {
	float value;

	switch( P1_C_TRANSP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_TRANSP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.5;
			P1_C_TRANSP.Update( p, value );
		}
		P1_C_TRANSP.GrabMemory();
		if( P1_C_TRANSP.GetF(FLinkEdges) ) { P1_C_TRANSP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.5;
			P1_C_TRANSP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_UW_EVAP_u362_exe() {
	float value;

	switch( P1_C_UW_EVAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_UW_EVAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.5;
			P1_C_UW_EVAP.Update( p, value );
		}
		P1_C_UW_EVAP.GrabMemory();
		if( P1_C_UW_EVAP.GetF(FLinkEdges) ) { P1_C_UW_EVAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.5;
			P1_C_UW_EVAP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_VERT_HYDR_COND_u363_exe() {
	float value;

	switch( P1_C_VERT_HYDR_COND.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_VERT_HYDR_COND.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.007;
			P1_C_VERT_HYDR_COND.Update( p, value );
		}
		P1_C_VERT_HYDR_COND.GrabMemory();
		if( P1_C_VERT_HYDR_COND.GetF(FLinkEdges) ) { P1_C_VERT_HYDR_COND.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.007;
			P1_C_VERT_HYDR_COND.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_ZIG_u364_exe() {
	float value;

	switch( P1_C_ZIG.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_ZIG.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)25);
			P1_C_ZIG.Update( p, value );
		}
		P1_C_ZIG.GrabMemory();
		if( P1_C_ZIG.GetF(FLinkEdges) ) { P1_C_ZIG.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)25);
			P1_C_ZIG.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_IC_SW_DEPTH_u365_exe() {
	float value;

	switch( P1_IC_SW_DEPTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_IC_SW_DEPTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_IC_SW_DEPTH.Update( p, value );
		}
		P1_IC_SW_DEPTH.GrabMemory();
		if( P1_IC_SW_DEPTH.GetF(FLinkEdges) ) { P1_IC_SW_DEPTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_IC_SW_DEPTH.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_IC_UW_MOIST_PR_u366_exe() {
	float value;

	switch( P1_IC_UW_MOIST_PR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_IC_UW_MOIST_PR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.3;
			P1_IC_UW_MOIST_PR.Update( p, P1_IC_UW_MOIST_PR.ParameterValue(value,p) );
		}
		P1_IC_UW_MOIST_PR.GrabMemory();
		if( P1_IC_UW_MOIST_PR.GetF(FLinkEdges) ) { P1_IC_UW_MOIST_PR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.3;
			P1_IC_UW_MOIST_PR.Update( P1_IC_UW_MOIST_PR.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_IC_WT_TABLE_u367_exe() {
	float value;

	switch( P1_IC_WT_TABLE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_IC_WT_TABLE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)25);
			P1_IC_WT_TABLE.Update( p, value );
		}
		P1_IC_WT_TABLE.GrabMemory();
		if( P1_IC_WT_TABLE.GetF(FLinkEdges) ) { P1_IC_WT_TABLE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)25);
			P1_IC_WT_TABLE.Update( value );
	  } break;
	}
	return 0;
}

HYDROLOGY_module* HYDROLOGY_module::fInstance = NULL;
HYDROLOGY_module* HYDROLOGY_module::kNullModel = (HYDROLOGY_module*)0x1;
int HYDROLOGY_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int HYDROLOGY_module::InitVars() {
	
	TIME.SSInit(this);
	SURFACE_WATER.SSInit(this);
	SURFACE_WATER.SetLinkEdges();
	UW_DEPTH.SSInit(this);
	WATER_AVAIL.SSInit(this);
	SAT_WATER.SSInit(this);
	SAT_WATER.SetLinkEdges();
	UNSAT_WATER.SSInit(this);
	UNSAT_WATER.SetLinkEdges();
	UW_FROM_PRECIP.SSInit(this);
	UW_FROM_PRECIP.SetDestination(&UNSAT_WATER);
	SW_TO_SATW_DOWNFLOW.SSInit(this);
	SW_TO_SATW_DOWNFLOW.SetOrigin(&SURFACE_WATER);
	SW_TO_SATW_DOWNFLOW.SetDestination(&SAT_WATER);
	SATW_FROM_PRECIP.SSInit(this);
	SATW_FROM_PRECIP.SetDestination(&SAT_WATER);
	SATW_TO_SW_UPFLOW.SSInit(this);
	SATW_TO_SW_UPFLOW.SetOrigin(&SAT_WATER);
	SATW_TO_SW_UPFLOW.SetDestination(&SURFACE_WATER);
	SATW_OUTFLUX.SSInit(this);
	SATW_OUTFLUX.SetOrigin(&SAT_WATER);
	SW_OUTFLUX.SSInit(this);
	SW_OUTFLUX.SetOrigin(&SURFACE_WATER);
	SATW_TRANSP.SSInit(this);
	SATW_TRANSP.SetOrigin(&SAT_WATER);
	UW_ETRANSP.SSInit(this);
	UW_ETRANSP.SetOrigin(&UNSAT_WATER);
	ON_MAP.SSInit(this);
	ON_MAP.SetLinkEdges();
	DIN_SD.SSInit(this);
	DIN_SD.SetLinkEdges();
	HABITATMAP.SSInit(this);
	HABITATMAP.SetLinkEdges();
	AIR_TEMP_C.SSInit(this);
	PRECIP_M.SSInit(this);
	PRECIP_M.SetLinkEdges();
	HYDRO.SSInit(this);
	HYDRO.SetLinkEdges();
	ELEVATION.SSInit(this);
	ELEVATION.SetLinkEdges();
	DIN_SF.SSInit(this);
	DIN_SF.SetLinkEdges();
	SOLRADGRD.SSInit(this);
	MACLAI.SSInit(this);
	CELL_SIZE.SSInit(this);
	SOIL.SSInit(this);
	HUMIDITY.SSInit(this);
	WIND.SSInit(this);
	A_IN.SSInit(this);
	A_IN.SetLinkEdges();
	ELEV_MIN.SSInit(this);
	ETPM.SSInit(this);
	ROOT_DEPTH.SSInit(this);
	P1_DATUM_TO_MSL.SSInit(this);
	UW_SATW_EXCHANGE.SSInit(this);
	UW_SATW_EXCHANGE.SetOrigin(&UNSAT_WATER);
	UW_SATW_EXCHANGE.SetDestination(&SAT_WATER);
	SATW_RECHARGE.SSInit(this);
	SATW_RECHARGE.SetOrigin(&SAT_WATER);
	SATW_UW.SSInit(this);
	SATW_UW.SetOrigin(&SAT_WATER);
	SATW_UW.SetDestination(&UNSAT_WATER);
	SNOW_ICE.SSInit(this);
	SNOWFALL.SSInit(this);
	SNOWFALL.SetDestination(&SNOW_ICE);
	SW_FREEZE.SSInit(this);
	SW_FREEZE.SetOrigin(&SURFACE_WATER);
	SW_FREEZE.SetDestination(&SNOW_ICE);
	SNOWMELT.SSInit(this);
	SNOWMELT.SetOrigin(&SNOW_ICE);
	SW_FROM_PRECIP.SSInit(this);
	SW_FROM_PRECIP.SetDestination(&SURFACE_WATER);
	SW_EVAP.SSInit(this);
	SW_EVAP.SetOrigin(&SURFACE_WATER);
	TOT_IN.SSInit(this);
	TOTAL_INFLOW.SSInit(this);
	TOTAL_INFLOW.SetLinkEdges();
	TOTAL_INFLOW.SetDestination(&TOT_IN);
	TOT_OUT.SSInit(this);
	TOTAL_OUTFLOW.SSInit(this);
	TOTAL_OUTFLOW.SetLinkEdges();
	TOTAL_OUTFLOW.SetDestination(&TOT_OUT);
	BALANCE.SSInit(this);
	BALANCE.SetLinkEdges();
	EVAPORATION.SSInit(this);
	EVAP_UW.SSInit(this);
	H_CONDUCT.SSInit(this);
	H_CONDUCT.SetLinkEdges();
	IC_SATW.SSInit(this);
	IC_UW.SSInit(this);
	INFILTRATION.SSInit(this);
	INF_COND.SSInit(this);
	INTERCEPT.SSInit(this);
	NET_PRECIP.SSInit(this);
	OUT_F_SD.SSInit(this);
	OUT_F_SD.SetLinkEdges();
	OUT_F_SF.SSInit(this);
	OUT_F_SF.SetLinkEdges();
	PAN_CH.SSInit(this);
	PAN_CT.SSInit(this);
	PAN_CW.SSInit(this);
	POROSITY.SSInit(this);
	POROSITY.SetLinkEdges();
	POT_INFILTR.SSInit(this);
	POT_INFILTR.SetLinkEdges();
	RAINFALL.SSInit(this);
	SATWMAX.SSInit(this);
	SATWRUNOFF.SSInit(this);
	SATW_HEAD.SSInit(this);
	TOTAL_OUT.SSInit(this);
	TOTAL_PRECIP.SSInit(this);
	TRANSPIRATION.SSInit(this);
	UNSAT_CAP.SSInit(this);
	UW_CAPIL_EXP.SSInit(this);
	UW_DELTA.SSInit(this);
	UW_DEPTH_BEFORE.SSInit(this);
	UW_EXCESS.SSInit(this);
	UW_MOIST_PRP.SSInit(this);
	UW_MP_R.SSInit(this);
	UW_PERC_RATE.SSInit(this);
	UW_TRANS_PR.SSInit(this);
	WAT_TABLE.SSInit(this);
	P1_C_EVAP.SSInit(this);
	P1_C_FIELD_CAP.SSInit(this);
	P1_C_HORIZ_HYDR_COND.SSInit(this);
	P1_C_INFILT.SSInit(this);
	P1_C_INF_HAB.SSInit(this);
	P1_C_INF_SLOPE.SSInit(this);
	P1_C_INF_SLOPE.SetLinkEdges();
	P1_C_INF_SOIL.SSInit(this);
	P1_C_INTERCEP.SSInit(this);
	P1_C_INTERCEPVEG.SSInit(this);
	P1_C_POROSITY.SSInit(this);
	P1_C_RECHG.SSInit(this);
	P1_C_SATW_OUT.SSInit(this);
	P1_C_SW_MELT.SSInit(this);
	P1_C_SW_OUT.SSInit(this);
	P1_C_TRANSP.SSInit(this);
	P1_C_UW_EVAP.SSInit(this);
	P1_C_VERT_HYDR_COND.SSInit(this);
	P1_C_ZIG.SSInit(this);
	P1_IC_SW_DEPTH.SSInit(this);
	P1_IC_UW_MOIST_PR.SSInit(this);
	P1_IC_WT_TABLE.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int HYDROLOGY_module::SetupEvents() {
	TExecuteCommand* I296 = (TExecuteCommand*) SURFACE_WATER.GetCommand("I296",TCommand::kIntegrate,TCommand::kCode);
	I296->SetExecutable(&SURFACE_WATER_I296_exe_g);
	I296->Code() = "I296 <- ( ( ( ( ( SW_FROM_PRECIP+SATW_TO_SW_UPFLOW )-SW_EVAP )-SW_TO_SATW_DOWNFLOW )-SW_FREEZE )-SW_OUTFLUX )";
	I296->AddDependency(SW_FROM_PRECIP);
	I296->AddDependency(SATW_TO_SW_UPFLOW);
	I296->AddDependency(SW_EVAP);
	I296->AddDependency(SW_TO_SATW_DOWNFLOW);
	I296->AddDependency(SW_FREEZE);
	I296->AddDependency(SW_OUTFLUX);
	I296->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i297 = (TExecuteCommand*) SURFACE_WATER.GetCommand("i297",TCommand::kInit,TCommand::kCode);
	i297->SetExecutable(&SURFACE_WATER_i297_exe_g);
	i297->Code() = "i297 <- P1_IC_SW_DEPTH";
	i297->AddDependency(P1_IC_SW_DEPTH);
	i297->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* vE435 = (TExecuteCommand*) SURFACE_WATER.GetCommand("vE435",TCommand::kFunction,TCommand::kCode);
	vE435->SetExecutable(&SURFACE_WATER_vE435_exe_g);
	vE435->Code() = "vE435 <- Function";
	vE435->GetFunction() = 'P';
	vE435->AddDependency(SURFACE_WATER);
	vE435->AddDependency(HYDRO);
	vE435->AddDependency(HABITATMAP);
	vE435->AddDependency(ELEVATION);
	vE435->AddDependency(P1_C_INF_SLOPE);
	vE435->AddDependency(DIN_SF);
	vE435->AddDependency(OUT_F_SF);
	vE435->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u338 = (TExecuteCommand*) UW_DEPTH.GetCommand("u338",TCommand::kUpdate,TCommand::kCode);
	u338->SetExecutable(&UW_DEPTH_u338_exe_g);
	u338->Code() = "u338 <- SL::Max(( ELEVATION-SATW_HEAD ), ((float)0))";
	u338->AddDependency(ELEVATION);
	u338->AddDependency(SATW_HEAD);
	u338->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u345 = (TExecuteCommand*) WATER_AVAIL.GetCommand("u345",TCommand::kUpdate,TCommand::kCode);
	u345->SetExecutable(&WATER_AVAIL_u345_exe_g);
	u345->Code() = "u345 <- SL::Min(1.0, ( UW_CAPIL_EXP+ ( ( ( UW_MOIST_PRP <  ( 0.1*P1_C_FIELD_CAP ) ) ) ? ( ((float)0) ) : (  ( ( ( UW_MOIST_PRP >  ( 0.6*P1_C_FIELD_CAP ) ) ) ? ( ((float)1) ) : ( ( ( ( UW_MOIST_PRP-( 0.1*P1_C_FIELD_CAP ) )/0.5 )/P1_C_FIELD_CAP ) ) )  ) )  ))";
	u345->AddDependency(UW_CAPIL_EXP);
	u345->AddDependency(UW_MOIST_PRP);
	u345->AddDependency(SOIL);
	u345->AddDependency(P1_C_FIELD_CAP);
	u345->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I281 = (TExecuteCommand*) SAT_WATER.GetCommand("I281",TCommand::kIntegrate,TCommand::kCode);
	I281->SetExecutable(&SAT_WATER_I281_exe_g);
	I281->Code() = "I281 <- ( ( ( ( ( ( ( UW_SATW_EXCHANGE+SW_TO_SATW_DOWNFLOW )+SATW_FROM_PRECIP )-SATW_RECHARGE )-SATW_TRANSP )-SATW_TO_SW_UPFLOW )-SATW_OUTFLUX )-SATW_UW )";
	I281->AddDependency(UW_SATW_EXCHANGE);
	I281->AddDependency(SW_TO_SATW_DOWNFLOW);
	I281->AddDependency(SATW_FROM_PRECIP);
	I281->AddDependency(SATW_RECHARGE);
	I281->AddDependency(SATW_TRANSP);
	I281->AddDependency(SATW_TO_SW_UPFLOW);
	I281->AddDependency(SATW_OUTFLUX);
	I281->AddDependency(SATW_UW);
	I281->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i282 = (TExecuteCommand*) SAT_WATER.GetCommand("i282",TCommand::kInit,TCommand::kCode);
	i282->SetExecutable(&SAT_WATER_i282_exe_g);
	i282->Code() = "i282 <- IC_SATW";
	i282->AddDependency(IC_SATW);
	i282->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* vE434 = (TExecuteCommand*) SAT_WATER.GetCommand("vE434",TCommand::kFunction,TCommand::kCode);
	vE434->SetExecutable(&SAT_WATER_vE434_exe_g);
	vE434->Code() = "vE434 <- Function";
	vE434->GetFunction() = 'P';
	vE434->AddDependency(SAT_WATER);
	vE434->AddDependency(POROSITY);
	vE434->AddDependency(H_CONDUCT);
	vE434->AddDependency(ON_MAP);
	vE434->AddDependency(DIN_SD);
	vE434->AddDependency(UNSAT_WATER);
	vE434->AddDependency(OUT_F_SD);
	vE434->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* I307 = (TExecuteCommand*) UNSAT_WATER.GetCommand("I307",TCommand::kIntegrate,TCommand::kCode);
	I307->SetExecutable(&UNSAT_WATER_I307_exe_g);
	I307->Code() = "I307 <- ( ( ( UW_FROM_PRECIP+SATW_UW )-UW_SATW_EXCHANGE )-UW_ETRANSP )";
	I307->AddDependency(UW_FROM_PRECIP);
	I307->AddDependency(SATW_UW);
	I307->AddDependency(UW_SATW_EXCHANGE);
	I307->AddDependency(UW_ETRANSP);
	I307->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i308 = (TExecuteCommand*) UNSAT_WATER.GetCommand("i308",TCommand::kInit,TCommand::kCode);
	i308->SetExecutable(&UNSAT_WATER_i308_exe_g);
	i308->Code() = "i308 <- IC_UW";
	i308->AddDependency(IC_UW);
	i308->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u309 = (TExecuteCommand*) UW_FROM_PRECIP.GetCommand("u309",TCommand::kUpdate,TCommand::kCode);
	u309->SetExecutable(&UW_FROM_PRECIP_u309_exe_g);
	u309->Code() = "u309 <-  ( ( ( INF_COND >  ((float)0) ) ) ? ( INFILTRATION ) : ( ((float)0) ) ) ";
	u309->AddDependency(INF_COND);
	u309->AddDependency(INFILTRATION);
	u309->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u284 = (TExecuteCommand*) SW_TO_SATW_DOWNFLOW.GetCommand("u284",TCommand::kUpdate,TCommand::kCode);
	u284->SetExecutable(&SW_TO_SATW_DOWNFLOW_u284_exe_g);
	u284->Code() = "u284 <-  ( ( ( ( HABITATMAP == ((float)1) ) || ( ( UW_DEPTH_BEFORE == ((float)0) ) && ( UNSAT_CAP >  ((float)0) ) ) ) ) ? ( SL::Min(( UNSAT_CAP/dT() ), ( SURFACE_WATER/dT() )) ) : ( ((float)0) ) ) ";
	if( SW_TO_SATW_DOWNFLOW.GetF(FisClamped) ) { u284->AddDependency(SURFACE_WATER); }
	u284->AddDependency(HABITATMAP);
	u284->AddDependency(UW_DEPTH_BEFORE);
	u284->AddDependency(UNSAT_CAP);
	u284->AddDependency(SURFACE_WATER);
	u284->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u285 = (TExecuteCommand*) SATW_FROM_PRECIP.GetCommand("u285",TCommand::kUpdate,TCommand::kCode);
	u285->SetExecutable(&SATW_FROM_PRECIP_u285_exe_g);
	u285->Code() = "u285 <-  ( ( ( INF_COND == ((float)0) ) ) ? ( ( ( UNSAT_CAP/dT() )-SW_TO_SATW_DOWNFLOW ) ) : ( ((float)0) ) ) ";
	u285->AddDependency(INF_COND);
	u285->AddDependency(UNSAT_CAP);
	u285->AddDependency(SW_TO_SATW_DOWNFLOW);
	u285->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u288 = (TExecuteCommand*) SATW_TO_SW_UPFLOW.GetCommand("u288",TCommand::kUpdate,TCommand::kCode);
	u288->SetExecutable(&SATW_TO_SW_UPFLOW_u288_exe_g);
	u288->Code() = "u288 <-  ( ( ( SAT_WATER >  SATWMAX ) ) ? ( ( SAT_WATER-SATWMAX ) ) : (  ( ( ( SAT_WATER >  SATWRUNOFF ) ) ? ( ( ( P1_C_ZIG*( SAT_WATER-SATWRUNOFF ) )*H_CONDUCT ) ) : ( ((float)0) ) )  ) ) ";
	if( SATW_TO_SW_UPFLOW.GetF(FisClamped) ) { u288->AddDependency(SAT_WATER); }
	u288->AddDependency(SAT_WATER);
	u288->AddDependency(SATWMAX);
	u288->AddDependency(SATWRUNOFF);
	u288->AddDependency(HABITATMAP);
	u288->AddDependency(P1_C_ZIG);
	u288->AddDependency(H_CONDUCT);
	u288->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u289 = (TExecuteCommand*) SATW_OUTFLUX.GetCommand("u289",TCommand::kUpdate,TCommand::kCode);
	u289->SetExecutable(&SATW_OUTFLUX_u289_exe_g);
	u289->Code() = "u289 <- ( P1_C_SATW_OUT*( SAT_WATER-IC_SATW ) )";
	if( SATW_OUTFLUX.GetF(FisClamped) ) { u289->AddDependency(SAT_WATER); }
	u289->AddDependency(P1_C_SATW_OUT);
	u289->AddDependency(SAT_WATER);
	u289->AddDependency(IC_SATW);
	u289->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u300 = (TExecuteCommand*) SW_OUTFLUX.GetCommand("u300",TCommand::kUpdate,TCommand::kCode);
	u300->SetExecutable(&SW_OUTFLUX_u300_exe_g);
	u300->Code() = "u300 <- ( ( P1_C_SW_OUT*SURFACE_WATER )/dT() )";
	if( SW_OUTFLUX.GetF(FisClamped) ) { u300->AddDependency(SURFACE_WATER); }
	u300->AddDependency(P1_C_SW_OUT);
	u300->AddDependency(SURFACE_WATER);
	u300->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u287 = (TExecuteCommand*) SATW_TRANSP.GetCommand("u287",TCommand::kUpdate,TCommand::kCode);
	u287->SetExecutable(&SATW_TRANSP_u287_exe_g);
	u287->Code() = "u287 <- ( TRANSPIRATION*( ((float)1)-UW_TRANS_PR ) )";
	if( SATW_TRANSP.GetF(FisClamped) ) { u287->AddDependency(SAT_WATER); }
	u287->AddDependency(TRANSPIRATION);
	u287->AddDependency(UW_TRANS_PR);
	u287->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u310 = (TExecuteCommand*) UW_ETRANSP.GetCommand("u310",TCommand::kUpdate,TCommand::kCode);
	u310->SetExecutable(&UW_ETRANSP_u310_exe_g);
	u310->Code() = "u310 <- ( ( TRANSPIRATION*UW_TRANS_PR )+EVAP_UW )";
	if( UW_ETRANSP.GetF(FisClamped) ) { u310->AddDependency(UNSAT_WATER); }
	u310->AddDependency(TRANSPIRATION);
	u310->AddDependency(UW_TRANS_PR);
	u310->AddDependency(EVAP_UW);
	u310->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ON_MAP_import = (TImportCommand*) ON_MAP.GetCommand("ON_MAP_import",TCommand::kUndefined,TCommand::kImport);
	ON_MAP_import->Code() = "Import ON_MAP from GLOBALS_module";
	ON_MAP_import->AddDependency(ON_MAP);
	ON_MAP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DIN_SD_import = (TImportCommand*) DIN_SD.GetCommand("DIN_SD_import",TCommand::kUndefined,TCommand::kImport);
	DIN_SD_import->Code() = "Import DIN_SD from ZDIN_module";
	DIN_SD_import->AddDependency(DIN_SD);
	DIN_SD_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* HABITATMAP_import = (TImportCommand*) HABITATMAP.GetCommand("HABITATMAP_import",TCommand::kUndefined,TCommand::kImport);
	HABITATMAP_import->Code() = "Import HABITATMAP from GLOBALS_module";
	HABITATMAP_import->AddDependency(HABITATMAP);
	HABITATMAP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* AIR_TEMP_C_import = (TImportCommand*) AIR_TEMP_C.GetCommand("AIR_TEMP_C_import",TCommand::kUndefined,TCommand::kImport);
	AIR_TEMP_C_import->Code() = "Import AIR_TEMP_C from GLOBALS_module";
	AIR_TEMP_C_import->AddDependency(AIR_TEMP_C);
	AIR_TEMP_C_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PRECIP_M_import = (TImportCommand*) PRECIP_M.GetCommand("PRECIP_M_import",TCommand::kUndefined,TCommand::kImport);
	PRECIP_M_import->Code() = "Import PRECIP_M from GLOBALS_module";
	PRECIP_M_import->AddDependency(PRECIP_M);
	PRECIP_M_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* HYDRO_import = (TImportCommand*) HYDRO.GetCommand("HYDRO_import",TCommand::kUndefined,TCommand::kImport);
	HYDRO_import->Code() = "Import HYDRO from GLOBALS_module";
	HYDRO_import->AddDependency(HYDRO);
	HYDRO_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ELEVATION_import = (TImportCommand*) ELEVATION.GetCommand("ELEVATION_import",TCommand::kUndefined,TCommand::kImport);
	ELEVATION_import->Code() = "Import ELEVATION from GLOBALS_module";
	ELEVATION_import->AddDependency(ELEVATION);
	ELEVATION_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DIN_SF_import = (TImportCommand*) DIN_SF.GetCommand("DIN_SF_import",TCommand::kUndefined,TCommand::kImport);
	DIN_SF_import->Code() = "Import DIN_SF from ZDIN_module";
	DIN_SF_import->AddDependency(DIN_SF);
	DIN_SF_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SOLRADGRD_import = (TImportCommand*) SOLRADGRD.GetCommand("SOLRADGRD_import",TCommand::kUndefined,TCommand::kImport);
	SOLRADGRD_import->Code() = "Import SOLRADGRD from PAR_module";
	SOLRADGRD_import->AddDependency(SOLRADGRD);
	SOLRADGRD_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* MACLAI_import = (TImportCommand*) MACLAI.GetCommand("MACLAI_import",TCommand::kUndefined,TCommand::kImport);
	MACLAI_import->Code() = "Import MACLAI from MACROPHYTES_module";
	MACLAI_import->AddDependency(MACLAI);
	MACLAI_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CELL_SIZE_import = (TImportCommand*) CELL_SIZE.GetCommand("CELL_SIZE_import",TCommand::kUndefined,TCommand::kImport);
	CELL_SIZE_import->Code() = "Import CELL_SIZE from GLOBALS_module";
	CELL_SIZE_import->AddDependency(CELL_SIZE);
	CELL_SIZE_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SOIL_import = (TImportCommand*) SOIL.GetCommand("SOIL_import",TCommand::kUndefined,TCommand::kImport);
	SOIL_import->Code() = "Import SOIL from GLOBALS_module";
	SOIL_import->AddDependency(SOIL);
	SOIL_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* HUMIDITY_import = (TImportCommand*) HUMIDITY.GetCommand("HUMIDITY_import",TCommand::kUndefined,TCommand::kImport);
	HUMIDITY_import->Code() = "Import HUMIDITY from GLOBALS_module";
	HUMIDITY_import->AddDependency(HUMIDITY);
	HUMIDITY_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* WIND_import = (TImportCommand*) WIND.GetCommand("WIND_import",TCommand::kUndefined,TCommand::kImport);
	WIND_import->Code() = "Import WIND from GLOBALS_module";
	WIND_import->AddDependency(WIND);
	WIND_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* A_IN_import = (TImportCommand*) A_IN.GetCommand("A_IN_import",TCommand::kUndefined,TCommand::kImport);
	A_IN_import->Code() = "Import A_IN from ZDIN_module";
	A_IN_import->AddDependency(A_IN);
	A_IN_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ELEV_MIN_import = (TImportCommand*) ELEV_MIN.GetCommand("ELEV_MIN_import",TCommand::kUndefined,TCommand::kImport);
	ELEV_MIN_import->Code() = "Import ELEV_MIN from GLOBALS_module";
	ELEV_MIN_import->AddDependency(ELEV_MIN);
	ELEV_MIN_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ETPM_import = (TImportCommand*) ETPM.GetCommand("ETPM_import",TCommand::kUndefined,TCommand::kImport);
	ETPM_import->Code() = "Import ETPM from ETPM_module";
	ETPM_import->AddDependency(ETPM);
	ETPM_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ROOT_DEPTH_import = (TImportCommand*) ROOT_DEPTH.GetCommand("ROOT_DEPTH_import",TCommand::kUndefined,TCommand::kImport);
	ROOT_DEPTH_import->Code() = "Import ROOT_DEPTH from MACROPHYTES_module";
	ROOT_DEPTH_import->AddDependency(ROOT_DEPTH);
	ROOT_DEPTH_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_DATUM_TO_MSL_import = (TImportCommand*) P1_DATUM_TO_MSL.GetCommand("P1_DATUM_TO_MSL_import",TCommand::kUndefined,TCommand::kImport);
	P1_DATUM_TO_MSL_import->Code() = "Import P1_DATUM_TO_MSL from GLOBALS_module";
	P1_DATUM_TO_MSL_import->AddDependency(P1_DATUM_TO_MSL);
	P1_DATUM_TO_MSL_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u283 = (TExecuteCommand*) UW_SATW_EXCHANGE.GetCommand("u283",TCommand::kUpdate,TCommand::kCode);
	u283->SetExecutable(&UW_SATW_EXCHANGE_u283_exe_g);
	u283->Code() = "u283 <-  ( ( ( INF_COND == ((float)0) ) ) ? ( ( UNSAT_WATER/dT() ) ) : ( SL::Min(( UNSAT_WATER/dT() ), ( ( SL::Max(((float)0), ( UW_DELTA*UW_MOIST_PRP ))/dT() )+UW_PERC_RATE )) ) ) ";
	if( UW_SATW_EXCHANGE.GetF(FisClamped) ) { u283->AddDependency(UNSAT_WATER); }
	u283->AddDependency(INF_COND);
	u283->AddDependency(UNSAT_WATER);
	u283->AddDependency(UW_DELTA);
	u283->AddDependency(UW_MOIST_PRP);
	u283->AddDependency(UW_PERC_RATE);
	u283->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u286 = (TExecuteCommand*) SATW_RECHARGE.GetCommand("u286",TCommand::kUpdate,TCommand::kCode);
	u286->SetExecutable(&SATW_RECHARGE_u286_exe_g);
	u286->Code() = "u286 <- P1_C_RECHG";
	if( SATW_RECHARGE.GetF(FisClamped) ) { u286->AddDependency(SAT_WATER); }
	u286->AddDependency(P1_C_RECHG);
	u286->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u290 = (TExecuteCommand*) SATW_UW.GetCommand("u290",TCommand::kUpdate,TCommand::kCode);
	u290->SetExecutable(&SATW_UW_u290_exe_g);
	u290->Code() = "u290 <- SL::Max(((float)0), SL::Min(( -UW_DELTA*P1_C_FIELD_CAP ), ( SAT_WATER/dT() )))";
	if( SATW_UW.GetF(FisClamped) ) { u290->AddDependency(SAT_WATER); }
	u290->AddDependency(UW_DELTA);
	u290->AddDependency(SOIL);
	u290->AddDependency(P1_C_FIELD_CAP);
	u290->AddDependency(SAT_WATER);
	u290->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I291 = (TExecuteCommand*) SNOW_ICE.GetCommand("I291",TCommand::kIntegrate,TCommand::kCode);
	I291->SetExecutable(&SNOW_ICE_I291_exe_g);
	I291->Code() = "I291 <- ( ( SNOWFALL+SW_FREEZE )-SNOWMELT )";
	I291->AddDependency(SNOWFALL);
	I291->AddDependency(SW_FREEZE);
	I291->AddDependency(SNOWMELT);
	I291->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i292 = (TExecuteCommand*) SNOW_ICE.GetCommand("i292",TCommand::kInit,TCommand::kCode);
	i292->SetExecutable(&SNOW_ICE_i292_exe_g);
	i292->Code() = "i292 <- ((float)0)";
	i292->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u293 = (TExecuteCommand*) SNOWFALL.GetCommand("u293",TCommand::kUpdate,TCommand::kCode);
	u293->SetExecutable(&SNOWFALL_u293_exe_g);
	u293->Code() = "u293 <-  ( ( ( AIR_TEMP_C <= ((float)0) ) ) ? ( PRECIP_M ) : ( ((float)0) ) ) ";
	u293->AddDependency(AIR_TEMP_C);
	u293->AddDependency(PRECIP_M);
	u293->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u294 = (TExecuteCommand*) SW_FREEZE.GetCommand("u294",TCommand::kUpdate,TCommand::kCode);
	u294->SetExecutable(&SW_FREEZE_u294_exe_g);
	u294->Code() = "u294 <-  ( ( ( AIR_TEMP_C >  ((float)0) ) ) ? ( ((float)0) ) : ( ( ( -AIR_TEMP_C*SURFACE_WATER )*P1_C_SW_MELT ) ) ) ";
	if( SW_FREEZE.GetF(FisClamped) ) { u294->AddDependency(SURFACE_WATER); }
	u294->AddDependency(AIR_TEMP_C);
	u294->AddDependency(SURFACE_WATER);
	u294->AddDependency(P1_C_SW_MELT);
	u294->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u295 = (TExecuteCommand*) SNOWMELT.GetCommand("u295",TCommand::kUpdate,TCommand::kCode);
	u295->SetExecutable(&SNOWMELT_u295_exe_g);
	u295->Code() = "u295 <-  ( ( ( AIR_TEMP_C >  ((float)0) ) ) ? ( SL::Min(( P1_C_SW_MELT*AIR_TEMP_C ), ( SNOW_ICE/dT() )) ) : ( ((float)0) ) ) ";
	if( SNOWMELT.GetF(FisClamped) ) { u295->AddDependency(SNOW_ICE); }
	u295->AddDependency(AIR_TEMP_C);
	u295->AddDependency(P1_C_SW_MELT);
	u295->AddDependency(SNOW_ICE);
	u295->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u298 = (TExecuteCommand*) SW_FROM_PRECIP.GetCommand("u298",TCommand::kUpdate,TCommand::kCode);
	u298->SetExecutable(&SW_FROM_PRECIP_u298_exe_g);
	u298->Code() = "u298 <- ( ( NET_PRECIP-UW_FROM_PRECIP )-SATW_FROM_PRECIP )";
	u298->AddDependency(NET_PRECIP);
	u298->AddDependency(UW_FROM_PRECIP);
	u298->AddDependency(SATW_FROM_PRECIP);
	u298->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u299 = (TExecuteCommand*) SW_EVAP.GetCommand("u299",TCommand::kUpdate,TCommand::kCode);
	u299->SetExecutable(&SW_EVAP_u299_exe_g);
	u299->Code() = "u299 <- SL::Min(SL::Max(EVAPORATION, ((float)0)), ( SURFACE_WATER/dT() ))";
	if( SW_EVAP.GetF(FisClamped) ) { u299->AddDependency(SURFACE_WATER); }
	u299->AddDependency(EVAPORATION);
	u299->AddDependency(SURFACE_WATER);
	u299->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I301 = (TExecuteCommand*) TOT_IN.GetCommand("I301",TCommand::kIntegrate,TCommand::kCode);
	I301->SetExecutable(&TOT_IN_I301_exe_g);
	I301->Code() = "I301 <- TOTAL_INFLOW";
	I301->AddDependency(TOTAL_INFLOW);
	I301->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i302 = (TExecuteCommand*) TOT_IN.GetCommand("i302",TCommand::kInit,TCommand::kCode);
	i302->SetExecutable(&TOT_IN_i302_exe_g);
	i302->Code() = "i302 <- ((float)0)";
	i302->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u303 = (TExecuteCommand*) TOTAL_INFLOW.GetCommand("u303",TCommand::kUpdate,TCommand::kCode);
	u303->SetExecutable(&TOTAL_INFLOW_u303_exe_g);
	u303->Code() = "u303 <- PRECIP_M";
	u303->AddDependency(PRECIP_M);
	u303->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I304 = (TExecuteCommand*) TOT_OUT.GetCommand("I304",TCommand::kIntegrate,TCommand::kCode);
	I304->SetExecutable(&TOT_OUT_I304_exe_g);
	I304->Code() = "I304 <- TOTAL_OUTFLOW";
	I304->AddDependency(TOTAL_OUTFLOW);
	I304->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i305 = (TExecuteCommand*) TOT_OUT.GetCommand("i305",TCommand::kInit,TCommand::kCode);
	i305->SetExecutable(&TOT_OUT_i305_exe_g);
	i305->Code() = "i305 <- ((float)0)";
	i305->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u306 = (TExecuteCommand*) TOTAL_OUTFLOW.GetCommand("u306",TCommand::kUpdate,TCommand::kCode);
	u306->SetExecutable(&TOTAL_OUTFLOW_u306_exe_g);
	u306->Code() = "u306 <- TOTAL_OUT";
	u306->AddDependency(TOTAL_OUT);
	u306->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u311 = (TExecuteCommand*) BALANCE.GetCommand("u311",TCommand::kUpdate,TCommand::kCode);
	u311->SetExecutable(&BALANCE_u311_exe_g);
	u311->Code() = "u311 <- ( ( ( ( ( SAT_WATER+SNOW_ICE )+SURFACE_WATER )+UNSAT_WATER )-TOT_IN )+TOT_OUT )";
	u311->AddDependency(SAT_WATER);
	u311->AddDependency(SNOW_ICE);
	u311->AddDependency(SURFACE_WATER);
	u311->AddDependency(UNSAT_WATER);
	u311->AddDependency(TOT_IN);
	u311->AddDependency(TOT_OUT);
	u311->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u312 = (TExecuteCommand*) EVAPORATION.GetCommand("u312",TCommand::kUpdate,TCommand::kCode);
	u312->SetExecutable(&EVAPORATION_u312_exe_g);
	u312->Code() = "u312 <- ( ( ( ( ( P1_C_EVAP*SOLRADGRD )/585 )*PAN_CW )*PAN_CT )*PAN_CH )";
	u312->AddDependency(HABITATMAP);
	u312->AddDependency(P1_C_EVAP);
	u312->AddDependency(SOLRADGRD);
	u312->AddDependency(PAN_CW);
	u312->AddDependency(PAN_CT);
	u312->AddDependency(PAN_CH);
	u312->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u313 = (TExecuteCommand*) EVAP_UW.GetCommand("u313",TCommand::kUpdate,TCommand::kCode);
	u313->SetExecutable(&EVAP_UW_u313_exe_g);
	u313->Code() = "u313 <- ( ( ( P1_C_UW_EVAP*EVAPORATION )*( ((float)1)-SL::Min(((float)1), MACLAI) ) )*UW_MP_R )";
	u313->AddDependency(HABITATMAP);
	u313->AddDependency(P1_C_UW_EVAP);
	u313->AddDependency(EVAPORATION);
	u313->AddDependency(MACLAI);
	u313->AddDependency(UW_MP_R);
	u313->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u314 = (TExecuteCommand*) H_CONDUCT.GetCommand("u314",TCommand::kUpdate,TCommand::kCode);
	u314->SetExecutable(&H_CONDUCT_u314_exe_g);
	u314->Code() = "u314 <- ( ( P1_C_HORIZ_HYDR_COND/SL::Sqrt(CELL_SIZE) )+( SOIL*0.0 ) )";
	u314->AddDependency(SOIL);
	u314->AddDependency(P1_C_HORIZ_HYDR_COND);
	u314->AddDependency(CELL_SIZE);
	u314->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u315 = (TExecuteCommand*) IC_SATW.GetCommand("u315",TCommand::kUpdate,TCommand::kCode);
	u315->SetExecutable(&IC_SATW_u315_exe_g);
	u315->Code() = "u315 <- ( WAT_TABLE*P1_C_POROSITY )";
	u315->AddDependency(WAT_TABLE);
	u315->AddDependency(SOIL);
	u315->AddDependency(P1_C_POROSITY);
	u315->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u316 = (TExecuteCommand*) IC_UW.GetCommand("u316",TCommand::kUpdate,TCommand::kCode);
	u316->SetExecutable(&IC_UW_u316_exe_g);
	u316->Code() = "u316 <-  ( ( ( ELEVATION >  WAT_TABLE ) ) ? ( ( ( ELEVATION-WAT_TABLE )*P1_IC_UW_MOIST_PR ) ) : ( ((float)0) ) ) ";
	u316->AddDependency(ELEVATION);
	u316->AddDependency(WAT_TABLE);
	u316->AddDependency(P1_IC_UW_MOIST_PR);
	u316->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u317 = (TExecuteCommand*) INFILTRATION.GetCommand("u317",TCommand::kUpdate,TCommand::kCode);
	u317->SetExecutable(&INFILTRATION_u317_exe_g);
	u317->Code() = "u317 <- SL::Min(POT_INFILTR, NET_PRECIP)";
	u317->AddDependency(POT_INFILTR);
	u317->AddDependency(NET_PRECIP);
	u317->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u318 = (TExecuteCommand*) INF_COND.GetCommand("u318",TCommand::kUpdate,TCommand::kCode);
	u318->SetExecutable(&INF_COND_u318_exe_g);
	u318->Code() = "u318 <-  ( ( ( ( SW_TO_SATW_DOWNFLOW*dT() ) == UNSAT_CAP ) ) ? ( ((float)0) ) : ( SL::Max(( UNSAT_CAP-( INFILTRATION*dT() ) ), ((float)0)) ) ) ";
	u318->AddDependency(SW_TO_SATW_DOWNFLOW);
	u318->AddDependency(UNSAT_CAP);
	u318->AddDependency(INFILTRATION);
	u318->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u319 = (TExecuteCommand*) INTERCEPT.GetCommand("u319",TCommand::kUpdate,TCommand::kCode);
	u319->SetExecutable(&INTERCEPT_u319_exe_g);
	u319->Code() = "u319 <- SL::Min(TOTAL_PRECIP, SL::Max(( P1_C_INTERCEP*TOTAL_PRECIP ), ( P1_C_INTERCEPVEG*MACLAI )))";
	u319->AddDependency(TOTAL_PRECIP);
	u319->AddDependency(HABITATMAP);
	u319->AddDependency(P1_C_INTERCEP);
	u319->AddDependency(P1_C_INTERCEPVEG);
	u319->AddDependency(MACLAI);
	u319->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u320 = (TExecuteCommand*) NET_PRECIP.GetCommand("u320",TCommand::kUpdate,TCommand::kCode);
	u320->SetExecutable(&NET_PRECIP_u320_exe_g);
	u320->Code() = "u320 <- ( TOTAL_PRECIP-INTERCEPT )";
	u320->AddDependency(TOTAL_PRECIP);
	u320->AddDependency(INTERCEPT);
	u320->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u321 = (TExecuteCommand*) OUT_F_SD.GetCommand("u321",TCommand::kUpdate,TCommand::kCode);
	u321->SetExecutable(&OUT_F_SD_u321_exe_g);
	u321->Code() = "u321 <- ((float)0)";
	u321->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u322 = (TExecuteCommand*) OUT_F_SF.GetCommand("u322",TCommand::kUpdate,TCommand::kCode);
	u322->SetExecutable(&OUT_F_SF_u322_exe_g);
	u322->Code() = "u322 <- ((float)0)";
	u322->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u323 = (TExecuteCommand*) PAN_CH.GetCommand("u323",TCommand::kUpdate,TCommand::kCode);
	u323->SetExecutable(&PAN_CH_u323_exe_g);
	u323->Code() = "u323 <- ( ( 1.035+( 0.240*pow((double)( HUMIDITY/60 ),(double)((float)2) ) ) )-( 0.275*pow((double)( HUMIDITY/60 ),(double)((float)3) ) ) )";
	u323->AddDependency(HUMIDITY);
	u323->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u324 = (TExecuteCommand*) PAN_CT.GetCommand("u324",TCommand::kUpdate,TCommand::kCode);
	u324->SetExecutable(&PAN_CT_u324_exe_g);
	u324->Code() = "u324 <-  ( ( ( AIR_TEMP_C >  -((float)30) ) ) ? ( ( ( 0.463+( 0.425*( AIR_TEMP_C/20 ) ) )+( 0.112*pow((double)( AIR_TEMP_C/20 ),(double)((float)2) ) ) ) ) : ( ((float)0) ) ) ";
	u324->AddDependency(AIR_TEMP_C);
	u324->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u325 = (TExecuteCommand*) PAN_CW.GetCommand("u325",TCommand::kUpdate,TCommand::kCode);
	u325->SetExecutable(&PAN_CW_u325_exe_g);
	u325->Code() = "u325 <- ( ( 0.672+( 0.406*( WIND/6.7 ) ) )+( 0.078*pow((double)( WIND/6.7 ),(double)((float)2) ) ) )";
	u325->AddDependency(WIND);
	u325->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u326 = (TExecuteCommand*) POROSITY.GetCommand("u326",TCommand::kUpdate,TCommand::kCode);
	u326->SetExecutable(&POROSITY_u326_exe_g);
	u326->Code() = "u326 <- ( P1_C_POROSITY+( SOIL*0.0 ) )";
	u326->AddDependency(SOIL);
	u326->AddDependency(P1_C_POROSITY);
	u326->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u327 = (TExecuteCommand*) POT_INFILTR.GetCommand("u327",TCommand::kUpdate,TCommand::kCode);
	u327->SetExecutable(&POT_INFILTR_u327_exe_g);
	u327->Code() = "u327 <- ( ( ( P1_C_INFILT*P1_C_INF_HAB )*P1_C_INF_SOIL )/ ( ( ( P1_C_INF_SLOPE >  ((float)0) ) ) ? ( P1_C_INF_SOIL ) : ( ((float)1) ) )  )";
	u327->AddDependency(P1_C_INFILT);
	u327->AddDependency(HABITATMAP);
	u327->AddDependency(P1_C_INF_HAB);
	u327->AddDependency(SOIL);
	u327->AddDependency(P1_C_INF_SOIL);
	u327->AddDependency(P1_C_INF_SLOPE);
	u327->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* v436 = (TExecuteCommand*) POT_INFILTR.GetCommand("v436",TCommand::kFunction,TCommand::kCode);
	v436->SetExecutable(&POT_INFILTR_v436_exe_g);
	v436->Code() = "v436 <- Function";
	v436->GetFunction() = 'P';
	v436->AddDependency(POT_INFILTR);
	v436->AddDependency(PRECIP_M);
	v436->AddDependency(TOTAL_INFLOW);
	v436->AddDependency(TOTAL_OUTFLOW);
	v436->AddDependency(BALANCE);
	v436->AddDependency(A_IN);
	v436->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u328 = (TExecuteCommand*) RAINFALL.GetCommand("u328",TCommand::kUpdate,TCommand::kCode);
	u328->SetExecutable(&RAINFALL_u328_exe_g);
	u328->Code() = "u328 <-  ( ( ( AIR_TEMP_C >  ((float)0) ) ) ? ( PRECIP_M ) : ( ((float)0) ) ) ";
	u328->AddDependency(AIR_TEMP_C);
	u328->AddDependency(PRECIP_M);
	u328->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u329 = (TExecuteCommand*) SATWMAX.GetCommand("u329",TCommand::kUpdate,TCommand::kCode);
	u329->SetExecutable(&SATWMAX_u329_exe_g);
	u329->Code() = "u329 <- ( ELEVATION*P1_C_POROSITY )";
	u329->AddDependency(ELEVATION);
	u329->AddDependency(SOIL);
	u329->AddDependency(P1_C_POROSITY);
	u329->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u330 = (TExecuteCommand*) SATWRUNOFF.GetCommand("u330",TCommand::kUpdate,TCommand::kCode);
	u330->SetExecutable(&SATWRUNOFF_u330_exe_g);
	u330->Code() = "u330 <- ( ELEV_MIN*P1_C_POROSITY )";
	u330->AddDependency(ELEV_MIN);
	u330->AddDependency(SOIL);
	u330->AddDependency(P1_C_POROSITY);
	u330->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u331 = (TExecuteCommand*) SATW_HEAD.GetCommand("u331",TCommand::kUpdate,TCommand::kCode);
	u331->SetExecutable(&SATW_HEAD_u331_exe_g);
	u331->Code() = "u331 <- ( SAT_WATER/P1_C_POROSITY )";
	u331->AddDependency(SAT_WATER);
	u331->AddDependency(SOIL);
	u331->AddDependency(P1_C_POROSITY);
	u331->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u332 = (TExecuteCommand*) TOTAL_OUT.GetCommand("u332",TCommand::kUpdate,TCommand::kCode);
	u332->SetExecutable(&TOTAL_OUT_u332_exe_g);
	u332->Code() = "u332 <- ( ( ( ( ( ( INTERCEPT+SATW_OUTFLUX )+SATW_RECHARGE )+SATW_TRANSP )+SW_EVAP )+SW_OUTFLUX )+UW_ETRANSP )";
	u332->AddDependency(INTERCEPT);
	u332->AddDependency(SATW_OUTFLUX);
	u332->AddDependency(SATW_RECHARGE);
	u332->AddDependency(SATW_TRANSP);
	u332->AddDependency(SW_EVAP);
	u332->AddDependency(SW_OUTFLUX);
	u332->AddDependency(UW_ETRANSP);
	u332->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u333 = (TExecuteCommand*) TOTAL_PRECIP.GetCommand("u333",TCommand::kUpdate,TCommand::kCode);
	u333->SetExecutable(&TOTAL_PRECIP_u333_exe_g);
	u333->Code() = "u333 <- ( RAINFALL+SNOWMELT )";
	u333->AddDependency(RAINFALL);
	u333->AddDependency(SNOWMELT);
	u333->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u334 = (TExecuteCommand*) TRANSPIRATION.GetCommand("u334",TCommand::kUpdate,TCommand::kCode);
	u334->SetExecutable(&TRANSPIRATION_u334_exe_g);
	u334->Code() = "u334 <- ( ( ( P1_C_TRANSP*SL::Min(((float)1), MACLAI) )*ETPM )*WATER_AVAIL )";
	u334->AddDependency(HABITATMAP);
	u334->AddDependency(P1_C_TRANSP);
	u334->AddDependency(MACLAI);
	u334->AddDependency(ETPM);
	u334->AddDependency(WATER_AVAIL);
	u334->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u335 = (TExecuteCommand*) UNSAT_CAP.GetCommand("u335",TCommand::kUpdate,TCommand::kCode);
	u335->SetExecutable(&UNSAT_CAP_u335_exe_g);
	u335->Code() = "u335 <- SL::Max(( UW_DEPTH*( P1_C_POROSITY-UW_MOIST_PRP ) ), ((float)0))";
	u335->AddDependency(UW_DEPTH);
	u335->AddDependency(SOIL);
	u335->AddDependency(P1_C_POROSITY);
	u335->AddDependency(UW_MOIST_PRP);
	u335->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u336 = (TExecuteCommand*) UW_CAPIL_EXP.GetCommand("u336",TCommand::kUpdate,TCommand::kCode);
	u336->SetExecutable(&UW_CAPIL_EXP_u336_exe_g);
	u336->Code() = "u336 <- SL::Exp(( -((float)10)*SL::Max(( UW_DEPTH-ROOT_DEPTH ), ((float)0)) ))";
	u336->AddDependency(UW_DEPTH);
	u336->AddDependency(ROOT_DEPTH);
	u336->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u337 = (TExecuteCommand*) UW_DELTA.GetCommand("u337",TCommand::kUpdate,TCommand::kCode);
	u337->SetExecutable(&UW_DELTA_u337_exe_g);
	u337->Code() = "u337 <- ( UW_DEPTH_BEFORE-UW_DEPTH )";
	u337->AddDependency(UW_DEPTH_BEFORE);
	u337->AddDependency(UW_DEPTH);
	u337->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u339 = (TExecuteCommand*) UW_DEPTH_BEFORE.GetCommand("u339",TCommand::kUpdate,TCommand::kCode);
	u339->SetExecutable(&UW_DEPTH_BEFORE_u339_exe_g);
	u339->Code() = "u339 <- UW_DEPTH.Delay( dT() )";
	u339->AddDependency(UW_DEPTH);
	u339->SetObjInfo(TCommand::kDepIndex, 2);
	TExecuteCommand* u340 = (TExecuteCommand*) UW_EXCESS.GetCommand("u340",TCommand::kUpdate,TCommand::kCode);
	u340->SetExecutable(&UW_EXCESS_u340_exe_g);
	u340->Code() = "u340 <- SL::Max(((float)0), ( UW_MOIST_PRP-P1_C_FIELD_CAP ))";
	u340->AddDependency(UW_MOIST_PRP);
	u340->AddDependency(SOIL);
	u340->AddDependency(P1_C_FIELD_CAP);
	u340->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u341 = (TExecuteCommand*) UW_MOIST_PRP.GetCommand("u341",TCommand::kUpdate,TCommand::kCode);
	u341->SetExecutable(&UW_MOIST_PRP_u341_exe_g);
	u341->Code() = "u341 <-  ( ( ( UW_DEPTH >  ((float)0) ) ) ? ( ( UNSAT_WATER/UW_DEPTH ) ) : ( ((float)0) ) ) ";
	u341->AddDependency(UW_DEPTH);
	u341->AddDependency(UNSAT_WATER);
	u341->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u342 = (TExecuteCommand*) UW_MP_R.GetCommand("u342",TCommand::kUpdate,TCommand::kCode);
	u342->SetExecutable(&UW_MP_R_u342_exe_g);
	u342->Code() = "u342 <- ( UW_MOIST_PRP/P1_C_POROSITY )";
	u342->AddDependency(UW_MOIST_PRP);
	u342->AddDependency(SOIL);
	u342->AddDependency(P1_C_POROSITY);
	u342->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u343 = (TExecuteCommand*) UW_PERC_RATE.GetCommand("u343",TCommand::kUpdate,TCommand::kCode);
	u343->SetExecutable(&UW_PERC_RATE_u343_exe_g);
	u343->Code() = "u343 <- ( ( ( ( ((float)2)*P1_C_VERT_HYDR_COND )*P1_C_POROSITY )*pow((double)UW_EXCESS,(double)0.4 ) )/( pow((double)( P1_C_POROSITY-P1_C_FIELD_CAP ),(double)0.4 )+pow((double)UW_EXCESS,(double)0.4 ) ) )";
	u343->AddDependency(SOIL);
	u343->AddDependency(P1_C_VERT_HYDR_COND);
	u343->AddDependency(P1_C_POROSITY);
	u343->AddDependency(UW_EXCESS);
	u343->AddDependency(P1_C_FIELD_CAP);
	u343->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u344 = (TExecuteCommand*) UW_TRANS_PR.GetCommand("u344",TCommand::kUpdate,TCommand::kCode);
	u344->SetExecutable(&UW_TRANS_PR_u344_exe_g);
	u344->Code() = "u344 <-  ( ( ( ( ROOT_DEPTH+0.1 ) <  UW_DEPTH ) ) ? ( ((float)1) ) : (  ( ( ( UW_DEPTH >  ((float)0) ) ) ? ( ( WATER_AVAIL*( UW_DEPTH/( ROOT_DEPTH+UW_CAPIL_EXP ) ) ) ) : ( ((float)0) ) )  ) ) ";
	u344->AddDependency(ROOT_DEPTH);
	u344->AddDependency(UW_DEPTH);
	u344->AddDependency(WATER_AVAIL);
	u344->AddDependency(UW_CAPIL_EXP);
	u344->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u346 = (TExecuteCommand*) WAT_TABLE.GetCommand("u346",TCommand::kUpdate,TCommand::kCode);
	u346->SetExecutable(&WAT_TABLE_u346_exe_g);
	u346->Code() = "u346 <- ( P1_IC_WT_TABLE+P1_DATUM_TO_MSL )";
	u346->AddDependency(P1_IC_WT_TABLE);
	u346->AddDependency(P1_DATUM_TO_MSL);
	u346->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u347 = (TExecuteCommand*) P1_C_EVAP.GetCommand("u347",TCommand::kUpdate,TCommand::kCode);
	u347->SetExecutable(&P1_C_EVAP_u347_exe_g);
	u347->Code() = "u347 <- 0.000482";
	u347->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u348 = (TExecuteCommand*) P1_C_FIELD_CAP.GetCommand("u348",TCommand::kUpdate,TCommand::kCode);
	u348->SetExecutable(&P1_C_FIELD_CAP_u348_exe_g);
	u348->Code() = "u348 <- 0.25";
	u348->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u349 = (TExecuteCommand*) P1_C_HORIZ_HYDR_COND.GetCommand("u349",TCommand::kUpdate,TCommand::kCode);
	u349->SetExecutable(&P1_C_HORIZ_HYDR_COND_u349_exe_g);
	u349->Code() = "u349 <- ((float)5)";
	u349->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u350 = (TExecuteCommand*) P1_C_INFILT.GetCommand("u350",TCommand::kUpdate,TCommand::kCode);
	u350->SetExecutable(&P1_C_INFILT_u350_exe_g);
	u350->Code() = "u350 <- 0.04";
	u350->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u351 = (TExecuteCommand*) P1_C_INF_HAB.GetCommand("u351",TCommand::kUpdate,TCommand::kCode);
	u351->SetExecutable(&P1_C_INF_HAB_u351_exe_g);
	u351->Code() = "u351 <- ((float)1)";
	u351->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u352 = (TExecuteCommand*) P1_C_INF_SLOPE.GetCommand("u352",TCommand::kUpdate,TCommand::kCode);
	u352->SetExecutable(&P1_C_INF_SLOPE_u352_exe_g);
	u352->Code() = "u352 <- ((float)5)";
	u352->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u353 = (TExecuteCommand*) P1_C_INF_SOIL.GetCommand("u353",TCommand::kUpdate,TCommand::kCode);
	u353->SetExecutable(&P1_C_INF_SOIL_u353_exe_g);
	u353->Code() = "u353 <- 4.00";
	u353->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u354 = (TExecuteCommand*) P1_C_INTERCEP.GetCommand("u354",TCommand::kUpdate,TCommand::kCode);
	u354->SetExecutable(&P1_C_INTERCEP_u354_exe_g);
	u354->Code() = "u354 <- 0.002";
	u354->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u355 = (TExecuteCommand*) P1_C_INTERCEPVEG.GetCommand("u355",TCommand::kUpdate,TCommand::kCode);
	u355->SetExecutable(&P1_C_INTERCEPVEG_u355_exe_g);
	u355->Code() = "u355 <- 0.001";
	u355->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u356 = (TExecuteCommand*) P1_C_POROSITY.GetCommand("u356",TCommand::kUpdate,TCommand::kCode);
	u356->SetExecutable(&P1_C_POROSITY_u356_exe_g);
	u356->Code() = "u356 <- 0.41";
	u356->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u357 = (TExecuteCommand*) P1_C_RECHG.GetCommand("u357",TCommand::kUpdate,TCommand::kCode);
	u357->SetExecutable(&P1_C_RECHG_u357_exe_g);
	u357->Code() = "u357 <- 0.00001";
	u357->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u358 = (TExecuteCommand*) P1_C_SATW_OUT.GetCommand("u358",TCommand::kUpdate,TCommand::kCode);
	u358->SetExecutable(&P1_C_SATW_OUT_u358_exe_g);
	u358->Code() = "u358 <- 0.";
	u358->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u359 = (TExecuteCommand*) P1_C_SW_MELT.GetCommand("u359",TCommand::kUpdate,TCommand::kCode);
	u359->SetExecutable(&P1_C_SW_MELT_u359_exe_g);
	u359->Code() = "u359 <- 0.005";
	u359->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u360 = (TExecuteCommand*) P1_C_SW_OUT.GetCommand("u360",TCommand::kUpdate,TCommand::kCode);
	u360->SetExecutable(&P1_C_SW_OUT_u360_exe_g);
	u360->Code() = "u360 <- 0.";
	u360->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u361 = (TExecuteCommand*) P1_C_TRANSP.GetCommand("u361",TCommand::kUpdate,TCommand::kCode);
	u361->SetExecutable(&P1_C_TRANSP_u361_exe_g);
	u361->Code() = "u361 <- 0.5";
	u361->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u362 = (TExecuteCommand*) P1_C_UW_EVAP.GetCommand("u362",TCommand::kUpdate,TCommand::kCode);
	u362->SetExecutable(&P1_C_UW_EVAP_u362_exe_g);
	u362->Code() = "u362 <- 0.5";
	u362->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u363 = (TExecuteCommand*) P1_C_VERT_HYDR_COND.GetCommand("u363",TCommand::kUpdate,TCommand::kCode);
	u363->SetExecutable(&P1_C_VERT_HYDR_COND_u363_exe_g);
	u363->Code() = "u363 <- 0.007";
	u363->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u364 = (TExecuteCommand*) P1_C_ZIG.GetCommand("u364",TCommand::kUpdate,TCommand::kCode);
	u364->SetExecutable(&P1_C_ZIG_u364_exe_g);
	u364->Code() = "u364 <- ((float)25)";
	u364->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u365 = (TExecuteCommand*) P1_IC_SW_DEPTH.GetCommand("u365",TCommand::kUpdate,TCommand::kCode);
	u365->SetExecutable(&P1_IC_SW_DEPTH_u365_exe_g);
	u365->Code() = "u365 <- ((float)0)";
	u365->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u366 = (TExecuteCommand*) P1_IC_UW_MOIST_PR.GetCommand("u366",TCommand::kUpdate,TCommand::kCode);
	u366->SetExecutable(&P1_IC_UW_MOIST_PR_u366_exe_g);
	u366->Code() = "u366 <- 0.3";
	u366->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u367 = (TExecuteCommand*) P1_IC_WT_TABLE.GetCommand("u367",TCommand::kUpdate,TCommand::kCode);
	u367->SetExecutable(&P1_IC_WT_TABLE_u367_exe_g);
	u367->Code() = "u367 <- ((float)25)";
	u367->SetObjInfo(TCommand::kDepIndex, 5);
	return 0;
}

int HYDROLOGY_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int HYDROLOGY_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int HYDROLOGY_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int HYDROLOGY_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class GLOBALS_module 
// ---------------------------------------------------------------------------
GLOBALS_module::GLOBALS_module(char* name) :
	TIME("TIME"),
	VAP_PRESS("VAP_PRESS"),
	AIR_TEMP_C("AIR_TEMP_C"),
	CLOUDY("CLOUDY"),
	WIND("WIND"),
	P1_C_LATDEG("P1_C_LATDEG"),
	DAYJUL("DAYJUL"),
	HABITATMAP("HABITATMAP"),
	DAYLENGTH("DAYLENGTH"),
	ELEVATION("ELEVATION"),
	CELL_SIZE("CELL_SIZE"),
	ON_MAP("ON_MAP"),
	PRECIP_M("PRECIP_M"),
	HYDRO("HYDRO"),
	SOIL("SOIL"),
	HUMIDITY("HUMIDITY"),
	ELEV_MIN("ELEV_MIN"),
	P1_DATUM_TO_MSL("P1_DATUM_TO_MSL"),
	SOLRADATM("SOLRADATM"),
	SOLRADGRD("SOLRADGRD"),
	AMPL("AMPL"),
	LENGTH("LENGTH"),
	PAR("PAR"),
	PAR_G("PAR_G"),
	ROADS("ROADS"),
	VAP_SAT_DEFICIT("VAP_SAT_DEFICIT"),
	P1_C_SURF_DELTA("P1_C_SURF_DELTA"),
	P1_DEPTH_MSL_MAP("P1_DEPTH_MSL_MAP"),
	P1_ELEV_MSL_MAP("P1_ELEV_MSL_MAP"),
	P1_POP_DENS("P1_POP_DENS"),
	P1_RAD_CONV("P1_RAD_CONV"),
	P1_RAIN_CONV("P1_RAIN_CONV"),
	P1_SEWERMAP("P1_SEWERMAP"),
	P1_WIND_CONV("P1_WIND_CONV"),
	AIR_TEMP_MAX("AIR_TEMP_MAX"),
	AIR_TEMP_MIN("AIR_TEMP_MIN"),
	PRECIPITATION("PRECIPITATION"),
	WIND_SPEED("WIND_SPEED"),
	TModule(name) {

	VAP_PRESS.SetF(FisExport,True,"CG");
	AIR_TEMP_C.SetF(FisExport,True,"CG");
	CLOUDY.SetF(FisExport,True,"CG");
	WIND.SetF(FisExport,True,"CG");
	P1_C_LATDEG.SetF(FisExport,True,"CG");
	DAYJUL.SetF(FisExport,True,"CG");
	HABITATMAP.SetF(FisExport,True,"CG");
	DAYLENGTH.SetF(FisExport,True,"CG");
	ELEVATION.SetF(FisExport,True,"CG");
	CELL_SIZE.SetF(FisExport,True,"CG");
	ON_MAP.SetF(FisExport,True,"CG");
	PRECIP_M.SetF(FisExport,True,"CG");
	HYDRO.SetF(FisExport,True,"CG");
	SOIL.SetF(FisExport,True,"CG");
	HUMIDITY.SetF(FisExport,True,"CG");
	ELEV_MIN.SetF(FisExport,True,"CG");
	P1_DATUM_TO_MSL.SetF(FisExport,True,"CG");
	SOLRADATM.SetF(FisImport,True,"CG");
	SOLRADGRD.SetF(FisImport,True,"CG");
}	
int GLOBALS_module::AIR_TEMP_C_u395_exe() {
	float value;

	switch( AIR_TEMP_C.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = AIR_TEMP_C.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( AIR_TEMP_MAX.Value(p)+AIR_TEMP_MIN.Value(p) )/2. )-((float)32) )*((float)5) )/9 );
			AIR_TEMP_C.Update( p, value );
		}
		AIR_TEMP_C.GrabMemory();
		if( AIR_TEMP_C.GetF(FLinkEdges) ) { AIR_TEMP_C.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( AIR_TEMP_MAX.Value()+AIR_TEMP_MIN.Value() )/2. )-((float)32) )*((float)5) )/9 );
			AIR_TEMP_C.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::AMPL_u396_exe() {
	float value;

	switch( AMPL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = AMPL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SL::Exp(( 7.42+( 0.045*P1_C_LATDEG.Value(p) ) ))/3600 );
			AMPL.Update( p, value );
		}
		AMPL.GrabMemory();
		if( AMPL.GetF(FLinkEdges) ) { AMPL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SL::Exp(( 7.42+( 0.045*P1_C_LATDEG.Value() ) ))/3600 );
			AMPL.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::CELL_SIZE_u397_exe() {
	float value;

	switch( CELL_SIZE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CELL_SIZE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1000000;
			CELL_SIZE.Update( p, CELL_SIZE.ParameterValue(value,p) );
		}
		CELL_SIZE.GrabMemory();
		if( CELL_SIZE.GetF(FLinkEdges) ) { CELL_SIZE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1000000;
			CELL_SIZE.Update( CELL_SIZE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::CLOUDY_u398_exe() {
	float value;

	switch( CLOUDY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CLOUDY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( PRECIP_M.Value(p) >  ((float)0) ) ) ? ( SL::Max(((float)0), ( ((float)10)-( 1.155*pow((double)( VAP_PRESS.Value(p)/( ( PRECIP_M.Value(p)*25.4 )*((float)30) ) ),(double)0.5 ) ) )) ) : ( ((float)0) ) ) ;
			CLOUDY.Update( p, value );
		}
		CLOUDY.GrabMemory();
		if( CLOUDY.GetF(FLinkEdges) ) { CLOUDY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( PRECIP_M.Value() >  ((float)0) ) ) ? ( SL::Max(((float)0), ( ((float)10)-( 1.155*pow((double)( VAP_PRESS.Value()/( ( PRECIP_M.Value()*25.4 )*((float)30) ) ),(double)0.5 ) ) )) ) : ( ((float)0) ) ) ;
			CLOUDY.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::DAYJUL_u399_exe() {
	float value;

	switch( DAYJUL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DAYJUL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SL::Mod(( TIME.Value()-dT() ), ((float)365))+((float)1) );
			DAYJUL.Update( p, value );
		}
		DAYJUL.GrabMemory();
		if( DAYJUL.GetF(FLinkEdges) ) { DAYJUL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SL::Mod(( TIME.Value()-dT() ), ((float)365))+((float)1) );
			DAYJUL.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::DAYLENGTH_u400_exe() {
	float value;

	switch( DAYLENGTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DAYLENGTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( AMPL.Value(p)*SL::Sin(( ( DAYJUL.Value(p)-((float)79) )*0.01721 )) )+((float)12) );
			DAYLENGTH.Update( p, value );
		}
		DAYLENGTH.GrabMemory();
		if( DAYLENGTH.GetF(FLinkEdges) ) { DAYLENGTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( AMPL.Value()*SL::Sin(( ( DAYJUL.Value()-((float)79) )*0.01721 )) )+((float)12) );
			DAYLENGTH.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::ELEVATION_u401_exe() {
	float value;

	switch( ELEVATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ELEVATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( P1_DEPTH_MSL_MAP.Value(p) >  ((float)0) ) ) ? ( ( P1_DATUM_TO_MSL.Value(p)-P1_DEPTH_MSL_MAP.Value(p) ) ) : ( ( P1_ELEV_MSL_MAP.Value(p)+P1_DATUM_TO_MSL.Value(p) ) ) ) ;
			ELEVATION.Update( p, value );
		}
		ELEVATION.GrabMemory();
		if( ELEVATION.GetF(FLinkEdges) ) { ELEVATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( P1_DEPTH_MSL_MAP.Value() >  ((float)0) ) ) ? ( ( P1_DATUM_TO_MSL.Value()-P1_DEPTH_MSL_MAP.Value() ) ) : ( ( P1_ELEV_MSL_MAP.Value()+P1_DATUM_TO_MSL.Value() ) ) ) ;
			ELEVATION.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::ELEV_MIN_u402_exe() {
	float value;

	switch( ELEV_MIN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ELEV_MIN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( HABITATMAP.Value(p) == ((float)1) ) ) ? ( ELEVATION.Value(p) ) : (  ( ( ( P1_ELEV_MSL_MAP.Value(p) >  ( 2.*P1_C_SURF_DELTA.Value(p) ) ) ) ? ( ( ELEVATION.Value(p)-P1_C_SURF_DELTA.Value(p) ) ) : ( ( ELEVATION.Value(p)-( P1_ELEV_MSL_MAP.Value(p)/2. ) ) ) )  ) ) ;
			ELEV_MIN.Update( p, value );
		}
		ELEV_MIN.GrabMemory();
		if( ELEV_MIN.GetF(FLinkEdges) ) { ELEV_MIN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( HABITATMAP.Value() == ((float)1) ) ) ? ( ELEVATION.Value() ) : (  ( ( ( P1_ELEV_MSL_MAP.Value() >  ( 2.*P1_C_SURF_DELTA.Value() ) ) ) ? ( ( ELEVATION.Value()-P1_C_SURF_DELTA.Value() ) ) : ( ( ELEVATION.Value()-( P1_ELEV_MSL_MAP.Value()/2. ) ) ) )  ) ) ;
			ELEV_MIN.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::HABITATMAP_u403_exe() {
	float value;

	switch( HABITATMAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HABITATMAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)2);
			HABITATMAP.Update( p, value );
		}
		HABITATMAP.GrabMemory();
		if( HABITATMAP.GetF(FLinkEdges) ) { HABITATMAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)2);
			HABITATMAP.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::HYDRO_u404_exe() {
	float value;

	switch( HYDRO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HYDRO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			HYDRO.Update( p, value );
		}
		HYDRO.GrabMemory();
		if( HYDRO.GetF(FLinkEdges) ) { HYDRO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			HYDRO.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::LENGTH_u405_exe() {
	float value;

	switch( LENGTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LENGTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  300;
			LENGTH.Update( p, LENGTH.ParameterValue(value,p) );
		}
		LENGTH.GrabMemory();
		if( LENGTH.GetF(FLinkEdges) ) { LENGTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  300;
			LENGTH.Update( LENGTH.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::ON_MAP_u406_exe() {
	float value;

	switch( ON_MAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ON_MAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			ON_MAP.Update( p, value );
		}
		ON_MAP.GrabMemory();
		if( ON_MAP.GetF(FLinkEdges) ) { ON_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			ON_MAP.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::PAR_u407_exe() {
	float value;

	switch( PAR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PAR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_RAD_CONV.Value(p)*SOLRADATM.Value(p) );
			PAR.Update( p, value );
		}
		PAR.GrabMemory();
		if( PAR.GetF(FLinkEdges) ) { PAR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_RAD_CONV.Value()*SOLRADATM.Value() );
			PAR.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::PAR_G_u408_exe() {
	float value;

	switch( PAR_G.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PAR_G.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_RAD_CONV.Value(p)*SOLRADGRD.Value(p) );
			PAR_G.Update( p, value );
		}
		PAR_G.GrabMemory();
		if( PAR_G.GetF(FLinkEdges) ) { PAR_G.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_RAD_CONV.Value()*SOLRADGRD.Value() );
			PAR_G.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::PRECIP_M_u409_exe() {
	float value;

	switch( PRECIP_M.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PRECIP_M.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_RAIN_CONV.Value(p)*PRECIPITATION.Value(p) );
			PRECIP_M.Update( p, value );
		}
		PRECIP_M.GrabMemory();
		if( PRECIP_M.GetF(FLinkEdges) ) { PRECIP_M.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_RAIN_CONV.Value()*PRECIPITATION.Value() );
			PRECIP_M.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::ROADS_u410_exe() {
	float value;

	switch( ROADS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ROADS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			ROADS.Update( p, value );
		}
		ROADS.GrabMemory();
		if( ROADS.GetF(FLinkEdges) ) { ROADS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			ROADS.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::SOIL_u411_exe() {
	float value;

	switch( SOIL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SOIL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			SOIL.Update( p, value );
		}
		SOIL.GrabMemory();
		if( SOIL.GetF(FLinkEdges) ) { SOIL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			SOIL.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::VAP_PRESS_u412_exe() {
	float value;

	switch( VAP_PRESS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = VAP_PRESS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( HUMIDITY.Value(p)*6.1078 )*SL::Exp(( ( 17.269*AIR_TEMP_C.Value(p) )/( AIR_TEMP_C.Value(p)+237.3 ) )) );
			VAP_PRESS.Update( p, value );
		}
		VAP_PRESS.GrabMemory();
		if( VAP_PRESS.GetF(FLinkEdges) ) { VAP_PRESS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( HUMIDITY.Value()*6.1078 )*SL::Exp(( ( 17.269*AIR_TEMP_C.Value() )/( AIR_TEMP_C.Value()+237.3 ) )) );
			VAP_PRESS.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::VAP_SAT_DEFICIT_u413_exe() {
	float value;

	switch( VAP_SAT_DEFICIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = VAP_SAT_DEFICIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)1)-( HUMIDITY.Value(p)/100 ) );
			VAP_SAT_DEFICIT.Update( p, value );
		}
		VAP_SAT_DEFICIT.GrabMemory();
		if( VAP_SAT_DEFICIT.GetF(FLinkEdges) ) { VAP_SAT_DEFICIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)1)-( HUMIDITY.Value()/100 ) );
			VAP_SAT_DEFICIT.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::WIND_u414_exe() {
	float value;

	switch( WIND.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WIND.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( WIND_SPEED.Value(p)*P1_WIND_CONV.Value(p) );
			WIND.Update( p, value );
		}
		WIND.GrabMemory();
		if( WIND.GetF(FLinkEdges) ) { WIND.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( WIND_SPEED.Value()*P1_WIND_CONV.Value() );
			WIND.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_C_LATDEG_u415_exe() {
	float value;

	switch( P1_C_LATDEG.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_LATDEG.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  39.0;
			P1_C_LATDEG.Update( p, P1_C_LATDEG.ParameterValue(value,p) );
		}
		P1_C_LATDEG.GrabMemory();
		if( P1_C_LATDEG.GetF(FLinkEdges) ) { P1_C_LATDEG.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  39.0;
			P1_C_LATDEG.Update( P1_C_LATDEG.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_C_SURF_DELTA_u416_exe() {
	float value;

	switch( P1_C_SURF_DELTA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_SURF_DELTA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  5.0;
			P1_C_SURF_DELTA.Update( p, P1_C_SURF_DELTA.ParameterValue(value,p) );
		}
		P1_C_SURF_DELTA.GrabMemory();
		if( P1_C_SURF_DELTA.GetF(FLinkEdges) ) { P1_C_SURF_DELTA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  5.0;
			P1_C_SURF_DELTA.Update( P1_C_SURF_DELTA.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_DATUM_TO_MSL_u417_exe() {
	float value;

	switch( P1_DATUM_TO_MSL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DATUM_TO_MSL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  20;
			P1_DATUM_TO_MSL.Update( p, P1_DATUM_TO_MSL.ParameterValue(value,p) );
		}
		P1_DATUM_TO_MSL.GrabMemory();
		if( P1_DATUM_TO_MSL.GetF(FLinkEdges) ) { P1_DATUM_TO_MSL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  20;
			P1_DATUM_TO_MSL.Update( P1_DATUM_TO_MSL.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_DEPTH_MSL_MAP_u418_exe() {
	float value;

	switch( P1_DEPTH_MSL_MAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DEPTH_MSL_MAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_DEPTH_MSL_MAP.Update( p, value );
		}
		P1_DEPTH_MSL_MAP.GrabMemory();
		if( P1_DEPTH_MSL_MAP.GetF(FLinkEdges) ) { P1_DEPTH_MSL_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_DEPTH_MSL_MAP.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_ELEV_MSL_MAP_u419_exe() {
	float value;

	switch( P1_ELEV_MSL_MAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_ELEV_MSL_MAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)30);
			P1_ELEV_MSL_MAP.Update( p, value );
		}
		P1_ELEV_MSL_MAP.GrabMemory();
		if( P1_ELEV_MSL_MAP.GetF(FLinkEdges) ) { P1_ELEV_MSL_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)30);
			P1_ELEV_MSL_MAP.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_POP_DENS_u420_exe() {
	float value;

	switch( P1_POP_DENS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_POP_DENS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  10;
			P1_POP_DENS.Update( p, P1_POP_DENS.ParameterValue(value,p) );
		}
		P1_POP_DENS.GrabMemory();
		if( P1_POP_DENS.GetF(FLinkEdges) ) { P1_POP_DENS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  10;
			P1_POP_DENS.Update( P1_POP_DENS.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_RAD_CONV_u421_exe() {
	float value;

	switch( P1_RAD_CONV.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_RAD_CONV.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_RAD_CONV.Update( p, P1_RAD_CONV.ParameterValue(value,p) );
		}
		P1_RAD_CONV.GrabMemory();
		if( P1_RAD_CONV.GetF(FLinkEdges) ) { P1_RAD_CONV.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_RAD_CONV.Update( P1_RAD_CONV.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_RAIN_CONV_u422_exe() {
	float value;

	switch( P1_RAIN_CONV.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_RAIN_CONV.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.0254;
			P1_RAIN_CONV.Update( p, P1_RAIN_CONV.ParameterValue(value,p) );
		}
		P1_RAIN_CONV.GrabMemory();
		if( P1_RAIN_CONV.GetF(FLinkEdges) ) { P1_RAIN_CONV.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.0254;
			P1_RAIN_CONV.Update( P1_RAIN_CONV.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_SEWERMAP_u423_exe() {
	float value;

	switch( P1_SEWERMAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SEWERMAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_SEWERMAP.Update( p, P1_SEWERMAP.ParameterValue(value,p) );
		}
		P1_SEWERMAP.GrabMemory();
		if( P1_SEWERMAP.GetF(FLinkEdges) ) { P1_SEWERMAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_SEWERMAP.Update( P1_SEWERMAP.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_WIND_CONV_u424_exe() {
	float value;

	switch( P1_WIND_CONV.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_WIND_CONV.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.077;
			P1_WIND_CONV.Update( p, P1_WIND_CONV.ParameterValue(value,p) );
		}
		P1_WIND_CONV.GrabMemory();
		if( P1_WIND_CONV.GetF(FLinkEdges) ) { P1_WIND_CONV.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.077;
			P1_WIND_CONV.Update( P1_WIND_CONV.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::AIR_TEMP_MAX_u425_exe() {
	float value;

	switch( AIR_TEMP_MAX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = AIR_TEMP_MAX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph54(DAYJUL.Value(p));
			AIR_TEMP_MAX.Update( p, value );
		}
		AIR_TEMP_MAX.GrabMemory();
		if( AIR_TEMP_MAX.GetF(FLinkEdges) ) { AIR_TEMP_MAX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph54(DAYJUL.Value());
			AIR_TEMP_MAX.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::AIR_TEMP_MIN_u426_exe() {
	float value;

	switch( AIR_TEMP_MIN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = AIR_TEMP_MIN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph55(DAYJUL.Value(p));
			AIR_TEMP_MIN.Update( p, value );
		}
		AIR_TEMP_MIN.GrabMemory();
		if( AIR_TEMP_MIN.GetF(FLinkEdges) ) { AIR_TEMP_MIN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph55(DAYJUL.Value());
			AIR_TEMP_MIN.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::HUMIDITY_u427_exe() {
	float value;

	switch( HUMIDITY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HUMIDITY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph56(DAYJUL.Value(p));
			HUMIDITY.Update( p, value );
		}
		HUMIDITY.GrabMemory();
		if( HUMIDITY.GetF(FLinkEdges) ) { HUMIDITY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph56(DAYJUL.Value());
			HUMIDITY.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::PRECIPITATION_u428_exe() {
	float value;

	switch( PRECIPITATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PRECIPITATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph57(DAYJUL.Value(p));
			PRECIPITATION.Update( p, value );
		}
		PRECIPITATION.GrabMemory();
		if( PRECIPITATION.GetF(FLinkEdges) ) { PRECIPITATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph57(DAYJUL.Value());
			PRECIPITATION.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::WIND_SPEED_u429_exe() {
	float value;

	switch( WIND_SPEED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WIND_SPEED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph58(DAYJUL.Value(p));
			WIND_SPEED.Update( p, value );
		}
		WIND_SPEED.GrabMemory();
		if( WIND_SPEED.GetF(FLinkEdges) ) { WIND_SPEED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph58(DAYJUL.Value());
			WIND_SPEED.Update( value );
	  } break;
	}
	return 0;
}

GLOBALS_module* GLOBALS_module::fInstance = NULL;
GLOBALS_module* GLOBALS_module::kNullModel = (GLOBALS_module*)0x1;
int GLOBALS_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int GLOBALS_module::InitVars() {
	
	TIME.SSInit(this);
	VAP_PRESS.SSInit(this);
	AIR_TEMP_C.SSInit(this);
	CLOUDY.SSInit(this);
	WIND.SSInit(this);
	P1_C_LATDEG.SSInit(this);
	DAYJUL.SSInit(this);
	HABITATMAP.SSInit(this);
	DAYLENGTH.SSInit(this);
	ELEVATION.SSInit(this);
	CELL_SIZE.SSInit(this);
	ON_MAP.SSInit(this);
	PRECIP_M.SSInit(this);
	HYDRO.SSInit(this);
	SOIL.SSInit(this);
	HUMIDITY.SSInit(this);
	ELEV_MIN.SSInit(this);
	P1_DATUM_TO_MSL.SSInit(this);
	SOLRADATM.SSInit(this);
	SOLRADGRD.SSInit(this);
	AMPL.SSInit(this);
	LENGTH.SSInit(this);
	PAR.SSInit(this);
	PAR_G.SSInit(this);
	ROADS.SSInit(this);
	VAP_SAT_DEFICIT.SSInit(this);
	P1_C_SURF_DELTA.SSInit(this);
	P1_DEPTH_MSL_MAP.SSInit(this);
	P1_ELEV_MSL_MAP.SSInit(this);
	P1_POP_DENS.SSInit(this);
	P1_RAD_CONV.SSInit(this);
	P1_RAIN_CONV.SSInit(this);
	P1_SEWERMAP.SSInit(this);
	P1_WIND_CONV.SSInit(this);
	AIR_TEMP_MAX.SSInit(this);
	AIR_TEMP_MIN.SSInit(this);
	PRECIPITATION.SSInit(this);
	WIND_SPEED.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int GLOBALS_module::SetupEvents() {
	TExecuteCommand* u412 = (TExecuteCommand*) VAP_PRESS.GetCommand("u412",TCommand::kUpdate,TCommand::kCode);
	u412->SetExecutable(&VAP_PRESS_u412_exe_g);
	u412->Code() = "u412 <- ( ( HUMIDITY*6.1078 )*SL::Exp(( ( 17.269*AIR_TEMP_C )/( AIR_TEMP_C+237.3 ) )) )";
	u412->AddDependency(HUMIDITY);
	u412->AddDependency(AIR_TEMP_C);
	u412->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u395 = (TExecuteCommand*) AIR_TEMP_C.GetCommand("u395",TCommand::kUpdate,TCommand::kCode);
	u395->SetExecutable(&AIR_TEMP_C_u395_exe_g);
	u395->Code() = "u395 <- ( ( ( ( ( AIR_TEMP_MAX+AIR_TEMP_MIN )/2. )-((float)32) )*((float)5) )/9 )";
	u395->AddDependency(AIR_TEMP_MAX);
	u395->AddDependency(AIR_TEMP_MIN);
	u395->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u398 = (TExecuteCommand*) CLOUDY.GetCommand("u398",TCommand::kUpdate,TCommand::kCode);
	u398->SetExecutable(&CLOUDY_u398_exe_g);
	u398->Code() = "u398 <-  ( ( ( PRECIP_M >  ((float)0) ) ) ? ( SL::Max(((float)0), ( ((float)10)-( 1.155*pow((double)( VAP_PRESS/( ( PRECIP_M*25.4 )*((float)30) ) ),(double)0.5 ) ) )) ) : ( ((float)0) ) ) ";
	u398->AddDependency(PRECIP_M);
	u398->AddDependency(VAP_PRESS);
	u398->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u414 = (TExecuteCommand*) WIND.GetCommand("u414",TCommand::kUpdate,TCommand::kCode);
	u414->SetExecutable(&WIND_u414_exe_g);
	u414->Code() = "u414 <- ( WIND_SPEED*P1_WIND_CONV )";
	u414->AddDependency(WIND_SPEED);
	u414->AddDependency(P1_WIND_CONV);
	u414->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u415 = (TExecuteCommand*) P1_C_LATDEG.GetCommand("u415",TCommand::kUpdate,TCommand::kCode);
	u415->SetExecutable(&P1_C_LATDEG_u415_exe_g);
	u415->Code() = "u415 <- 39.0";
	u415->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u399 = (TExecuteCommand*) DAYJUL.GetCommand("u399",TCommand::kUpdate,TCommand::kCode);
	u399->SetExecutable(&DAYJUL_u399_exe_g);
	u399->Code() = "u399 <- ( SL::Mod(( TIME-dT() ), ((float)365))+((float)1) )";
	u399->AddDependency(TIME);
	u399->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u403 = (TExecuteCommand*) HABITATMAP.GetCommand("u403",TCommand::kUpdate,TCommand::kCode);
	u403->SetExecutable(&HABITATMAP_u403_exe_g);
	u403->Code() = "u403 <- ((float)2)";
	u403->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u400 = (TExecuteCommand*) DAYLENGTH.GetCommand("u400",TCommand::kUpdate,TCommand::kCode);
	u400->SetExecutable(&DAYLENGTH_u400_exe_g);
	u400->Code() = "u400 <- ( ( AMPL*SL::Sin(( ( DAYJUL-((float)79) )*0.01721 )) )+((float)12) )";
	u400->AddDependency(AMPL);
	u400->AddDependency(DAYJUL);
	u400->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u401 = (TExecuteCommand*) ELEVATION.GetCommand("u401",TCommand::kUpdate,TCommand::kCode);
	u401->SetExecutable(&ELEVATION_u401_exe_g);
	u401->Code() = "u401 <-  ( ( ( P1_DEPTH_MSL_MAP >  ((float)0) ) ) ? ( ( P1_DATUM_TO_MSL-P1_DEPTH_MSL_MAP ) ) : ( ( P1_ELEV_MSL_MAP+P1_DATUM_TO_MSL ) ) ) ";
	u401->AddDependency(P1_DEPTH_MSL_MAP);
	u401->AddDependency(P1_DATUM_TO_MSL);
	u401->AddDependency(P1_ELEV_MSL_MAP);
	u401->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u397 = (TExecuteCommand*) CELL_SIZE.GetCommand("u397",TCommand::kUpdate,TCommand::kCode);
	u397->SetExecutable(&CELL_SIZE_u397_exe_g);
	u397->Code() = "u397 <- 1000000";
	u397->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u406 = (TExecuteCommand*) ON_MAP.GetCommand("u406",TCommand::kUpdate,TCommand::kCode);
	u406->SetExecutable(&ON_MAP_u406_exe_g);
	u406->Code() = "u406 <- ((float)1)";
	u406->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u409 = (TExecuteCommand*) PRECIP_M.GetCommand("u409",TCommand::kUpdate,TCommand::kCode);
	u409->SetExecutable(&PRECIP_M_u409_exe_g);
	u409->Code() = "u409 <- ( P1_RAIN_CONV*PRECIPITATION )";
	u409->AddDependency(P1_RAIN_CONV);
	u409->AddDependency(PRECIPITATION);
	u409->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u404 = (TExecuteCommand*) HYDRO.GetCommand("u404",TCommand::kUpdate,TCommand::kCode);
	u404->SetExecutable(&HYDRO_u404_exe_g);
	u404->Code() = "u404 <- ((float)1)";
	u404->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u411 = (TExecuteCommand*) SOIL.GetCommand("u411",TCommand::kUpdate,TCommand::kCode);
	u411->SetExecutable(&SOIL_u411_exe_g);
	u411->Code() = "u411 <- ((float)1)";
	u411->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u427 = (TExecuteCommand*) HUMIDITY.GetCommand("u427",TCommand::kUpdate,TCommand::kCode);
	u427->SetExecutable(&HUMIDITY_u427_exe_g);
	u427->Code() = "u427 <- Graph56(DAYJUL)";
	u427->AddDependency(DAYJUL);
	u427->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* HUMIDITY_import = (TImportCommand*) HUMIDITY.GetCommand("HUMIDITY_import",TCommand::kUndefined,TCommand::kImport);
	HUMIDITY_import->Code() = "Import HUMIDITY from external";
	HUMIDITY_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u402 = (TExecuteCommand*) ELEV_MIN.GetCommand("u402",TCommand::kUpdate,TCommand::kCode);
	u402->SetExecutable(&ELEV_MIN_u402_exe_g);
	u402->Code() = "u402 <-  ( ( ( HABITATMAP == ((float)1) ) ) ? ( ELEVATION ) : (  ( ( ( P1_ELEV_MSL_MAP >  ( 2.*P1_C_SURF_DELTA ) ) ) ? ( ( ELEVATION-P1_C_SURF_DELTA ) ) : ( ( ELEVATION-( P1_ELEV_MSL_MAP/2. ) ) ) )  ) ) ";
	u402->AddDependency(HABITATMAP);
	u402->AddDependency(ELEVATION);
	u402->AddDependency(P1_ELEV_MSL_MAP);
	u402->AddDependency(P1_C_SURF_DELTA);
	u402->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u417 = (TExecuteCommand*) P1_DATUM_TO_MSL.GetCommand("u417",TCommand::kUpdate,TCommand::kCode);
	u417->SetExecutable(&P1_DATUM_TO_MSL_u417_exe_g);
	u417->Code() = "u417 <- 20";
	u417->SetObjInfo(TCommand::kDepIndex, 5);
	TImportCommand* SOLRADATM_import = (TImportCommand*) SOLRADATM.GetCommand("SOLRADATM_import",TCommand::kUndefined,TCommand::kImport);
	SOLRADATM_import->Code() = "Import SOLRADATM from PAR_module";
	SOLRADATM_import->AddDependency(SOLRADATM);
	SOLRADATM_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SOLRADGRD_import = (TImportCommand*) SOLRADGRD.GetCommand("SOLRADGRD_import",TCommand::kUndefined,TCommand::kImport);
	SOLRADGRD_import->Code() = "Import SOLRADGRD from PAR_module";
	SOLRADGRD_import->AddDependency(SOLRADGRD);
	SOLRADGRD_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u396 = (TExecuteCommand*) AMPL.GetCommand("u396",TCommand::kUpdate,TCommand::kCode);
	u396->SetExecutable(&AMPL_u396_exe_g);
	u396->Code() = "u396 <- ( SL::Exp(( 7.42+( 0.045*P1_C_LATDEG ) ))/3600 )";
	u396->AddDependency(P1_C_LATDEG);
	u396->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u405 = (TExecuteCommand*) LENGTH.GetCommand("u405",TCommand::kUpdate,TCommand::kCode);
	u405->SetExecutable(&LENGTH_u405_exe_g);
	u405->Code() = "u405 <- 300";
	u405->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u407 = (TExecuteCommand*) PAR.GetCommand("u407",TCommand::kUpdate,TCommand::kCode);
	u407->SetExecutable(&PAR_u407_exe_g);
	u407->Code() = "u407 <- ( P1_RAD_CONV*SOLRADATM )";
	u407->AddDependency(P1_RAD_CONV);
	u407->AddDependency(SOLRADATM);
	u407->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u408 = (TExecuteCommand*) PAR_G.GetCommand("u408",TCommand::kUpdate,TCommand::kCode);
	u408->SetExecutable(&PAR_G_u408_exe_g);
	u408->Code() = "u408 <- ( P1_RAD_CONV*SOLRADGRD )";
	u408->AddDependency(P1_RAD_CONV);
	u408->AddDependency(SOLRADGRD);
	u408->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u410 = (TExecuteCommand*) ROADS.GetCommand("u410",TCommand::kUpdate,TCommand::kCode);
	u410->SetExecutable(&ROADS_u410_exe_g);
	u410->Code() = "u410 <- ((float)1)";
	u410->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u413 = (TExecuteCommand*) VAP_SAT_DEFICIT.GetCommand("u413",TCommand::kUpdate,TCommand::kCode);
	u413->SetExecutable(&VAP_SAT_DEFICIT_u413_exe_g);
	u413->Code() = "u413 <- ( ((float)1)-( HUMIDITY/100 ) )";
	u413->AddDependency(HUMIDITY);
	u413->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u416 = (TExecuteCommand*) P1_C_SURF_DELTA.GetCommand("u416",TCommand::kUpdate,TCommand::kCode);
	u416->SetExecutable(&P1_C_SURF_DELTA_u416_exe_g);
	u416->Code() = "u416 <- 5.0";
	u416->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u418 = (TExecuteCommand*) P1_DEPTH_MSL_MAP.GetCommand("u418",TCommand::kUpdate,TCommand::kCode);
	u418->SetExecutable(&P1_DEPTH_MSL_MAP_u418_exe_g);
	u418->Code() = "u418 <- ((float)0)";
	u418->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u419 = (TExecuteCommand*) P1_ELEV_MSL_MAP.GetCommand("u419",TCommand::kUpdate,TCommand::kCode);
	u419->SetExecutable(&P1_ELEV_MSL_MAP_u419_exe_g);
	u419->Code() = "u419 <- ((float)30)";
	u419->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u420 = (TExecuteCommand*) P1_POP_DENS.GetCommand("u420",TCommand::kUpdate,TCommand::kCode);
	u420->SetExecutable(&P1_POP_DENS_u420_exe_g);
	u420->Code() = "u420 <- 10";
	u420->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u421 = (TExecuteCommand*) P1_RAD_CONV.GetCommand("u421",TCommand::kUpdate,TCommand::kCode);
	u421->SetExecutable(&P1_RAD_CONV_u421_exe_g);
	u421->Code() = "u421 <- 1";
	u421->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u422 = (TExecuteCommand*) P1_RAIN_CONV.GetCommand("u422",TCommand::kUpdate,TCommand::kCode);
	u422->SetExecutable(&P1_RAIN_CONV_u422_exe_g);
	u422->Code() = "u422 <- 0.0254";
	u422->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u423 = (TExecuteCommand*) P1_SEWERMAP.GetCommand("u423",TCommand::kUpdate,TCommand::kCode);
	u423->SetExecutable(&P1_SEWERMAP_u423_exe_g);
	u423->Code() = "u423 <- 1";
	u423->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u424 = (TExecuteCommand*) P1_WIND_CONV.GetCommand("u424",TCommand::kUpdate,TCommand::kCode);
	u424->SetExecutable(&P1_WIND_CONV_u424_exe_g);
	u424->Code() = "u424 <- 0.077";
	u424->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u425 = (TExecuteCommand*) AIR_TEMP_MAX.GetCommand("u425",TCommand::kUpdate,TCommand::kCode);
	u425->SetExecutable(&AIR_TEMP_MAX_u425_exe_g);
	u425->Code() = "u425 <- Graph54(DAYJUL)";
	u425->AddDependency(DAYJUL);
	u425->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* AIR_TEMP_MAX_import = (TImportCommand*) AIR_TEMP_MAX.GetCommand("AIR_TEMP_MAX_import",TCommand::kUndefined,TCommand::kImport);
	AIR_TEMP_MAX_import->Code() = "Import AIR_TEMP_MAX from external";
	AIR_TEMP_MAX_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u426 = (TExecuteCommand*) AIR_TEMP_MIN.GetCommand("u426",TCommand::kUpdate,TCommand::kCode);
	u426->SetExecutable(&AIR_TEMP_MIN_u426_exe_g);
	u426->Code() = "u426 <- Graph55(DAYJUL)";
	u426->AddDependency(DAYJUL);
	u426->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* AIR_TEMP_MIN_import = (TImportCommand*) AIR_TEMP_MIN.GetCommand("AIR_TEMP_MIN_import",TCommand::kUndefined,TCommand::kImport);
	AIR_TEMP_MIN_import->Code() = "Import AIR_TEMP_MIN from external";
	AIR_TEMP_MIN_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u428 = (TExecuteCommand*) PRECIPITATION.GetCommand("u428",TCommand::kUpdate,TCommand::kCode);
	u428->SetExecutable(&PRECIPITATION_u428_exe_g);
	u428->Code() = "u428 <- Graph57(DAYJUL)";
	u428->AddDependency(DAYJUL);
	u428->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PRECIPITATION_import = (TImportCommand*) PRECIPITATION.GetCommand("PRECIPITATION_import",TCommand::kUndefined,TCommand::kImport);
	PRECIPITATION_import->Code() = "Import PRECIPITATION from external";
	PRECIPITATION_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u429 = (TExecuteCommand*) WIND_SPEED.GetCommand("u429",TCommand::kUpdate,TCommand::kCode);
	u429->SetExecutable(&WIND_SPEED_u429_exe_g);
	u429->Code() = "u429 <- Graph58(DAYJUL)";
	u429->AddDependency(DAYJUL);
	u429->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* WIND_SPEED_import = (TImportCommand*) WIND_SPEED.GetCommand("WIND_SPEED_import",TCommand::kUndefined,TCommand::kImport);
	WIND_SPEED_import->Code() = "Import WIND_SPEED from external";
	WIND_SPEED_import->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int GLOBALS_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int GLOBALS_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int GLOBALS_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int GLOBALS_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}
