#ifndef __ModelEqns__
#define __ModelEqns__

#include "SpaceSim.h"
#include "UCode.h"
#include "GWater.h"
#include "SWater.h"

// ---------------------------------------------------------------------------
//                    Class HNMD_module 
// ---------------------------------------------------------------------------

int kA__Wildcard = -99;

class HNMD_module : public TModule {
protected:

	HNMD_module(char* name);

public:

	TTime TIME;
protected:

	static HNMD_module* fInstance;
	static HNMD_module* kNullModel;
public:
	inline static HNMD_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new HNMD_module("HNMD_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (HNMD_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize();
	int MakeConnections();
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit();
};


// ---------------------------------------------------------------------------
//                    Class ETPM_module 
// ---------------------------------------------------------------------------

class ETPM_module : public TModule {
protected:

	ETPM_module(char* name);

public:

	TTime TIME;
	CAuxVariable VAP_PRESS;
	CAuxVariable AIR_TEMP_C;
	CAuxVariable SOLRADATM;
	CAuxVariable CLOUDY;
	CAuxVariable MACH;
	CAuxVariable WIND;
	CAuxVariable MACLAI;
	CAuxVariable ETPM;
	CAuxVariable D;
	CAuxVariable DELTA;
	CAuxVariable ENERGY;
	CAuxVariable ES;
	CAuxVariable GAMMA;
	CAuxVariable LAMBDA;
	CAuxVariable P;
	CAuxVariable RA;
	CAuxVariable RO;
	CAuxVariable RS;
protected:

	int D_u0_exe();
	friend int D_u0_exe_g( Variable* v );
	int DELTA_u1_exe();
	friend int DELTA_u1_exe_g( Variable* v );
	int ENERGY_u2_exe();
	friend int ENERGY_u2_exe_g( Variable* v );
	int ES_u3_exe();
	friend int ES_u3_exe_g( Variable* v );
	int ETPM_u4_exe();
	friend int ETPM_u4_exe_g( Variable* v );
	int GAMMA_u5_exe();
	friend int GAMMA_u5_exe_g( Variable* v );
	int LAMBDA_u6_exe();
	friend int LAMBDA_u6_exe_g( Variable* v );
	int P_u7_exe();
	friend int P_u7_exe_g( Variable* v );
	int RA_u8_exe();
	friend int RA_u8_exe_g( Variable* v );
	int RO_u9_exe();
	friend int RO_u9_exe_g( Variable* v );
	int RS_u10_exe();
	friend int RS_u10_exe_g( Variable* v );
	static ETPM_module* fInstance;
	static ETPM_module* kNullModel;
public:
	inline static ETPM_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new ETPM_module("ETPM_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (ETPM_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int D_u0_exe_g(Variable* obj) { return ETPM_module::I().D_u0_exe(); }
int DELTA_u1_exe_g(Variable* obj) { return ETPM_module::I().DELTA_u1_exe(); }
int ENERGY_u2_exe_g(Variable* obj) { return ETPM_module::I().ENERGY_u2_exe(); }
int ES_u3_exe_g(Variable* obj) { return ETPM_module::I().ES_u3_exe(); }
int ETPM_u4_exe_g(Variable* obj) { return ETPM_module::I().ETPM_u4_exe(); }
int GAMMA_u5_exe_g(Variable* obj) { return ETPM_module::I().GAMMA_u5_exe(); }
int LAMBDA_u6_exe_g(Variable* obj) { return ETPM_module::I().LAMBDA_u6_exe(); }
int P_u7_exe_g(Variable* obj) { return ETPM_module::I().P_u7_exe(); }
int RA_u8_exe_g(Variable* obj) { return ETPM_module::I().RA_u8_exe(); }
int RO_u9_exe_g(Variable* obj) { return ETPM_module::I().RO_u9_exe(); }
int RS_u10_exe_g(Variable* obj) { return ETPM_module::I().RS_u10_exe(); }
// ---------------------------------------------------------------------------
//                    Class PAR_module 
// ---------------------------------------------------------------------------

class PAR_module : public TModule {
protected:

	PAR_module(char* name);

public:

	TTime TIME;
	CAuxVariable SOLRADATM;
	CAuxVariable P1_C_LATDEG;
	CAuxVariable CLOUDY;
	CAuxVariable DAYJUL;
	CAuxVariable SOLRADGRD;
	CAuxVariable A;
	CAuxVariable ALPHA;
	CAuxVariable B;
	CAuxVariable BETTA;
	CAuxVariable C;
	CAuxVariable T_RAD;
protected:

	int A_u19_exe();
	friend int A_u19_exe_g( Variable* v );
	int ALPHA_u20_exe();
	friend int ALPHA_u20_exe_g( Variable* v );
	int B_u21_exe();
	friend int B_u21_exe_g( Variable* v );
	int BETTA_u22_exe();
	friend int BETTA_u22_exe_g( Variable* v );
	int C_u23_exe();
	friend int C_u23_exe_g( Variable* v );
	int SOLRADATM_u24_exe();
	friend int SOLRADATM_u24_exe_g( Variable* v );
	int SOLRADGRD_u25_exe();
	friend int SOLRADGRD_u25_exe_g( Variable* v );
	int T_RAD_u26_exe();
	friend int T_RAD_u26_exe_g( Variable* v );
	static PAR_module* fInstance;
	static PAR_module* kNullModel;
public:
	inline static PAR_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new PAR_module("PAR_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (PAR_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int A_u19_exe_g(Variable* obj) { return PAR_module::I().A_u19_exe(); }
int ALPHA_u20_exe_g(Variable* obj) { return PAR_module::I().ALPHA_u20_exe(); }
int B_u21_exe_g(Variable* obj) { return PAR_module::I().B_u21_exe(); }
int BETTA_u22_exe_g(Variable* obj) { return PAR_module::I().BETTA_u22_exe(); }
int C_u23_exe_g(Variable* obj) { return PAR_module::I().C_u23_exe(); }
int SOLRADATM_u24_exe_g(Variable* obj) { return PAR_module::I().SOLRADATM_u24_exe(); }
int SOLRADGRD_u25_exe_g(Variable* obj) { return PAR_module::I().SOLRADGRD_u25_exe(); }
int T_RAD_u26_exe_g(Variable* obj) { return PAR_module::I().T_RAD_u26_exe(); }
// ---------------------------------------------------------------------------
//                    Class MACROPHYTES_module 
// ---------------------------------------------------------------------------

class MACROPHYTES_module : public TModule {
protected:

	MACROPHYTES_module(char* name);

public:

	TTime TIME;
	CAuxVariable MACH;
	CAuxVariable MACLAI;
	CAuxVariable AIR_TEMP_C;
	CAuxVariable HABITATMAP;
	CAuxVariable DAYJUL;
	CAuxVariable DAYLENGTH;
	CAuxVariable DIN_AVAILABLE;
	CAuxVariable ELEVATION;
	CStateVariable SURFACE_WATER;
	CAuxVariable UW_DEPTH;
	CAuxVariable WATER_AVAIL;
	CFluxVariable PHBIO_MORT;
	CFluxVariable PHBIO_HARVEST;
	CFluxVariable NPHBIO_MORT;
	CFluxVariable NPHBIO_HARVEST;
	CFluxVariable PHBIO_NPP;
	CAuxVariable ROOT_DEPTH;
	CStateVariable BIO_TIME;
	CFluxVariable CF_AIR_TEMP;
	CStateVariable MAC_NPH_BIOMAS;
	CFluxVariable NPHBIO_PLANTING;
	CFluxVariable TRANSDOWN;
	CFluxVariable TRANSUP;
	CStateVariable MAC_PH_BIOMAS;
	CFluxVariable PHBIO_PLANT;
	CStateVariable PH_MAX;
	CFluxVariable PH_IN;
	CFluxVariable PH_OUT;
	CStateVariable TOT_NPP;
	CFluxVariable NPP_IN;
	CStateVariable YIELD;
	CFluxVariable HARVEST;
	CFluxVariable INI_YIELD;
	CAuxVariable DAY_LENGTH_PREV;
	CAuxVariable FALL_LITTER;
	CAuxVariable FALL_LITTER_CALC;
	CAuxVariable HARVEST_TIME;
	CAuxVariable IC_NPHBIO;
	CAuxVariable IC_PHBIO;
	CAuxVariable LIGHT_CF;
	CAuxVariable MAC_LAI_R;
	CAuxVariable MAC_PROD_CF;
	CAuxVariable MAX_BM;
	CAuxVariable MAX_NPH;
	CAuxVariable MAX_PH;
	CAuxVariable NPH_AB_BM;
	CAuxVariable NUTR_CF;
	CAuxVariable PHBIO_MORT_WATER;
	CAuxVariable PHBIO_NPP_CALC;
	CAuxVariable PH_TO_ABBM;
	CAuxVariable PLANTIME;
	CAuxVariable PLANTING;
	CAuxVariable PO4SD_CONCTOT;
	CAuxVariable REMOVAL_TIME;
	CAuxVariable ROOT_BM;
	CAuxVariable SPROUTING;
	CAuxVariable TEMP_CF;
	CAuxVariable TOTAL_BIOM;
	CAuxVariable TRANSDOWN_RT;
	CAuxVariable WATER_CF;
	CAuxVariable WAT_STRESS_HIGH;
	CAuxVariable WAT_STRESS_LOW;
	CAuxVariable P1_BIO_END;
	CAuxVariable P1_BIO_REPRO;
	CAuxVariable P1_BIO_START;
	CAuxVariable P1_DAYLENG_RQ;
	CAuxVariable P1_EST_HEIGHT;
	CAuxVariable P1_H_DAY;
	CAuxVariable P1_LIGHTSAT;
	CAuxVariable P1_MAC_KS_N;
	CAuxVariable P1_MAC_KS_P;
	CAuxVariable P1_MAX_AB_BM;
	CAuxVariable P1_MAX_DENS;
	CAuxVariable P1_MAX_HT_BM;
	CAuxVariable P1_MAX_LAI;
	CAuxVariable P1_MAX_PH_ABBM;
	CAuxVariable P1_NPH_ABBM_IC;
	CAuxVariable P1_NPH_AB_BEL;
	CAuxVariable P1_NPH_MORT;
	CAuxVariable P1_NPH_PR_H;
	CAuxVariable P1_NPP;
	CAuxVariable P1_PHB_C_REC;
	CAuxVariable P1_PHB_EVGRN;
	CAuxVariable P1_PHB_L_RT;
	CAuxVariable P1_PHB_MORT;
	CAuxVariable P1_PHB_PR_H;
	CAuxVariable P1_PH_TO_REP;
	CAuxVariable P1_PROP_LA_TO_B;
	CAuxVariable P1_P_DAY;
	CAuxVariable P1_P_RATIO;
	CAuxVariable P1_P_WT;
	CAuxVariable P1_ROOT_DENS;
	CAuxVariable P1_SPR_RATE;
	CAuxVariable P1_TEMPOPT;
	CAuxVariable P1_W_T_MAX;
	CAuxVariable P1_W_T_MIN;
	CAuxVariable SOLRADGR;
protected:

	int BIO_TIME_I30_exe();
	friend int BIO_TIME_I30_exe_g( Variable* v );
	int BIO_TIME_i31_exe();
	friend int BIO_TIME_i31_exe_g( Variable* v );
	int CF_AIR_TEMP_u32_exe();
	friend int CF_AIR_TEMP_u32_exe_g( Variable* v );
	int MAC_NPH_BIOMAS_I33_exe();
	friend int MAC_NPH_BIOMAS_I33_exe_g( Variable* v );
	int MAC_NPH_BIOMAS_i34_exe();
	friend int MAC_NPH_BIOMAS_i34_exe_g( Variable* v );
	int NPHBIO_PLANTING_u35_exe();
	friend int NPHBIO_PLANTING_u35_exe_g( Variable* v );
	int TRANSDOWN_u36_exe();
	friend int TRANSDOWN_u36_exe_g( Variable* v );
	int NPHBIO_MORT_u37_exe();
	friend int NPHBIO_MORT_u37_exe_g( Variable* v );
	int TRANSUP_u38_exe();
	friend int TRANSUP_u38_exe_g( Variable* v );
	int NPHBIO_HARVEST_u39_exe();
	friend int NPHBIO_HARVEST_u39_exe_g( Variable* v );
	int MAC_PH_BIOMAS_I40_exe();
	friend int MAC_PH_BIOMAS_I40_exe_g( Variable* v );
	int MAC_PH_BIOMAS_i41_exe();
	friend int MAC_PH_BIOMAS_i41_exe_g( Variable* v );
	int PHBIO_NPP_u42_exe();
	friend int PHBIO_NPP_u42_exe_g( Variable* v );
	int PHBIO_PLANT_u43_exe();
	friend int PHBIO_PLANT_u43_exe_g( Variable* v );
	int PHBIO_MORT_u44_exe();
	friend int PHBIO_MORT_u44_exe_g( Variable* v );
	int PHBIO_HARVEST_u45_exe();
	friend int PHBIO_HARVEST_u45_exe_g( Variable* v );
	int PH_MAX_I46_exe();
	friend int PH_MAX_I46_exe_g( Variable* v );
	int PH_MAX_i47_exe();
	friend int PH_MAX_i47_exe_g( Variable* v );
	int PH_IN_u48_exe();
	friend int PH_IN_u48_exe_g( Variable* v );
	int PH_OUT_u49_exe();
	friend int PH_OUT_u49_exe_g( Variable* v );
	int TOT_NPP_I50_exe();
	friend int TOT_NPP_I50_exe_g( Variable* v );
	int TOT_NPP_i51_exe();
	friend int TOT_NPP_i51_exe_g( Variable* v );
	int NPP_IN_u52_exe();
	friend int NPP_IN_u52_exe_g( Variable* v );
	int YIELD_I53_exe();
	friend int YIELD_I53_exe_g( Variable* v );
	int YIELD_i54_exe();
	friend int YIELD_i54_exe_g( Variable* v );
	int HARVEST_u55_exe();
	friend int HARVEST_u55_exe_g( Variable* v );
	int INI_YIELD_u56_exe();
	friend int INI_YIELD_u56_exe_g( Variable* v );
	int DAY_LENGTH_PREV_u57_exe();
	friend int DAY_LENGTH_PREV_u57_exe_g( Variable* v );
	int FALL_LITTER_u58_exe();
	friend int FALL_LITTER_u58_exe_g( Variable* v );
	int FALL_LITTER_CALC_u59_exe();
	friend int FALL_LITTER_CALC_u59_exe_g( Variable* v );
	int HARVEST_TIME_u60_exe();
	friend int HARVEST_TIME_u60_exe_g( Variable* v );
	int IC_NPHBIO_u61_exe();
	friend int IC_NPHBIO_u61_exe_g( Variable* v );
	int IC_PHBIO_u62_exe();
	friend int IC_PHBIO_u62_exe_g( Variable* v );
	int LIGHT_CF_u63_exe();
	friend int LIGHT_CF_u63_exe_g( Variable* v );
	int MACH_u64_exe();
	friend int MACH_u64_exe_g( Variable* v );
	int MACLAI_u65_exe();
	friend int MACLAI_u65_exe_g( Variable* v );
	int MAC_LAI_R_u66_exe();
	friend int MAC_LAI_R_u66_exe_g( Variable* v );
	int MAC_PROD_CF_u67_exe();
	friend int MAC_PROD_CF_u67_exe_g( Variable* v );
	int MAX_BM_u68_exe();
	friend int MAX_BM_u68_exe_g( Variable* v );
	int MAX_NPH_u69_exe();
	friend int MAX_NPH_u69_exe_g( Variable* v );
	int MAX_PH_u70_exe();
	friend int MAX_PH_u70_exe_g( Variable* v );
	int NPH_AB_BM_u71_exe();
	friend int NPH_AB_BM_u71_exe_g( Variable* v );
	int NUTR_CF_u72_exe();
	friend int NUTR_CF_u72_exe_g( Variable* v );
	int PHBIO_MORT_WATER_u73_exe();
	friend int PHBIO_MORT_WATER_u73_exe_g( Variable* v );
	int PHBIO_NPP_CALC_u74_exe();
	friend int PHBIO_NPP_CALC_u74_exe_g( Variable* v );
	int PH_TO_ABBM_u75_exe();
	friend int PH_TO_ABBM_u75_exe_g( Variable* v );
	int PLANTIME_u76_exe();
	friend int PLANTIME_u76_exe_g( Variable* v );
	int PLANTING_u77_exe();
	friend int PLANTING_u77_exe_g( Variable* v );
	int PO4SD_CONCTOT_u78_exe();
	friend int PO4SD_CONCTOT_u78_exe_g( Variable* v );
	int REMOVAL_TIME_u79_exe();
	friend int REMOVAL_TIME_u79_exe_g( Variable* v );
	int ROOT_BM_u80_exe();
	friend int ROOT_BM_u80_exe_g( Variable* v );
	int ROOT_DEPTH_u81_exe();
	friend int ROOT_DEPTH_u81_exe_g( Variable* v );
	int SPROUTING_u82_exe();
	friend int SPROUTING_u82_exe_g( Variable* v );
	int TEMP_CF_u83_exe();
	friend int TEMP_CF_u83_exe_g( Variable* v );
	int TOTAL_BIOM_u84_exe();
	friend int TOTAL_BIOM_u84_exe_g( Variable* v );
	int TRANSDOWN_RT_u85_exe();
	friend int TRANSDOWN_RT_u85_exe_g( Variable* v );
	int WATER_CF_u86_exe();
	friend int WATER_CF_u86_exe_g( Variable* v );
	int WAT_STRESS_HIGH_u87_exe();
	friend int WAT_STRESS_HIGH_u87_exe_g( Variable* v );
	int WAT_STRESS_LOW_u88_exe();
	friend int WAT_STRESS_LOW_u88_exe_g( Variable* v );
	int P1_BIO_END_u89_exe();
	friend int P1_BIO_END_u89_exe_g( Variable* v );
	int P1_BIO_REPRO_u90_exe();
	friend int P1_BIO_REPRO_u90_exe_g( Variable* v );
	int P1_BIO_START_u91_exe();
	friend int P1_BIO_START_u91_exe_g( Variable* v );
	int P1_DAYLENG_RQ_u92_exe();
	friend int P1_DAYLENG_RQ_u92_exe_g( Variable* v );
	int P1_EST_HEIGHT_u93_exe();
	friend int P1_EST_HEIGHT_u93_exe_g( Variable* v );
	int P1_H_DAY_u94_exe();
	friend int P1_H_DAY_u94_exe_g( Variable* v );
	int P1_LIGHTSAT_u95_exe();
	friend int P1_LIGHTSAT_u95_exe_g( Variable* v );
	int P1_MAC_KS_N_u96_exe();
	friend int P1_MAC_KS_N_u96_exe_g( Variable* v );
	int P1_MAC_KS_P_u97_exe();
	friend int P1_MAC_KS_P_u97_exe_g( Variable* v );
	int P1_MAX_AB_BM_u98_exe();
	friend int P1_MAX_AB_BM_u98_exe_g( Variable* v );
	int P1_MAX_DENS_u99_exe();
	friend int P1_MAX_DENS_u99_exe_g( Variable* v );
	int P1_MAX_HT_BM_u100_exe();
	friend int P1_MAX_HT_BM_u100_exe_g( Variable* v );
	int P1_MAX_LAI_u101_exe();
	friend int P1_MAX_LAI_u101_exe_g( Variable* v );
	int P1_MAX_PH_ABBM_u102_exe();
	friend int P1_MAX_PH_ABBM_u102_exe_g( Variable* v );
	int P1_NPH_ABBM_IC_u103_exe();
	friend int P1_NPH_ABBM_IC_u103_exe_g( Variable* v );
	int P1_NPH_AB_BEL_u104_exe();
	friend int P1_NPH_AB_BEL_u104_exe_g( Variable* v );
	int P1_NPH_MORT_u105_exe();
	friend int P1_NPH_MORT_u105_exe_g( Variable* v );
	int P1_NPH_PR_H_u106_exe();
	friend int P1_NPH_PR_H_u106_exe_g( Variable* v );
	int P1_NPP_u107_exe();
	friend int P1_NPP_u107_exe_g( Variable* v );
	int P1_PHB_C_REC_u108_exe();
	friend int P1_PHB_C_REC_u108_exe_g( Variable* v );
	int P1_PHB_EVGRN_u109_exe();
	friend int P1_PHB_EVGRN_u109_exe_g( Variable* v );
	int P1_PHB_L_RT_u110_exe();
	friend int P1_PHB_L_RT_u110_exe_g( Variable* v );
	int P1_PHB_MORT_u111_exe();
	friend int P1_PHB_MORT_u111_exe_g( Variable* v );
	int P1_PHB_PR_H_u112_exe();
	friend int P1_PHB_PR_H_u112_exe_g( Variable* v );
	int P1_PH_TO_REP_u113_exe();
	friend int P1_PH_TO_REP_u113_exe_g( Variable* v );
	int P1_PROP_LA_TO_B_u114_exe();
	friend int P1_PROP_LA_TO_B_u114_exe_g( Variable* v );
	int P1_P_DAY_u115_exe();
	friend int P1_P_DAY_u115_exe_g( Variable* v );
	int P1_P_RATIO_u116_exe();
	friend int P1_P_RATIO_u116_exe_g( Variable* v );
	int P1_P_WT_u117_exe();
	friend int P1_P_WT_u117_exe_g( Variable* v );
	int P1_ROOT_DENS_u118_exe();
	friend int P1_ROOT_DENS_u118_exe_g( Variable* v );
	int P1_SPR_RATE_u119_exe();
	friend int P1_SPR_RATE_u119_exe_g( Variable* v );
	int P1_TEMPOPT_u120_exe();
	friend int P1_TEMPOPT_u120_exe_g( Variable* v );
	int P1_W_T_MAX_u121_exe();
	friend int P1_W_T_MAX_u121_exe_g( Variable* v );
	int P1_W_T_MIN_u122_exe();
	friend int P1_W_T_MIN_u122_exe_g( Variable* v );
	static MACROPHYTES_module* fInstance;
	static MACROPHYTES_module* kNullModel;
public:
	inline static MACROPHYTES_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new MACROPHYTES_module("MACROPHYTES_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (MACROPHYTES_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int BIO_TIME_I30_exe_g(Variable* obj) { return MACROPHYTES_module::I().BIO_TIME_I30_exe(); }
int BIO_TIME_i31_exe_g(Variable* obj) { return MACROPHYTES_module::I().BIO_TIME_i31_exe(); }
int CF_AIR_TEMP_u32_exe_g(Variable* obj) { return MACROPHYTES_module::I().CF_AIR_TEMP_u32_exe(); }
int MAC_NPH_BIOMAS_I33_exe_g(Variable* obj) { return MACROPHYTES_module::I().MAC_NPH_BIOMAS_I33_exe(); }
int MAC_NPH_BIOMAS_i34_exe_g(Variable* obj) { return MACROPHYTES_module::I().MAC_NPH_BIOMAS_i34_exe(); }
int NPHBIO_PLANTING_u35_exe_g(Variable* obj) { return MACROPHYTES_module::I().NPHBIO_PLANTING_u35_exe(); }
int TRANSDOWN_u36_exe_g(Variable* obj) { return MACROPHYTES_module::I().TRANSDOWN_u36_exe(); }
int NPHBIO_MORT_u37_exe_g(Variable* obj) { return MACROPHYTES_module::I().NPHBIO_MORT_u37_exe(); }
int TRANSUP_u38_exe_g(Variable* obj) { return MACROPHYTES_module::I().TRANSUP_u38_exe(); }
int NPHBIO_HARVEST_u39_exe_g(Variable* obj) { return MACROPHYTES_module::I().NPHBIO_HARVEST_u39_exe(); }
int MAC_PH_BIOMAS_I40_exe_g(Variable* obj) { return MACROPHYTES_module::I().MAC_PH_BIOMAS_I40_exe(); }
int MAC_PH_BIOMAS_i41_exe_g(Variable* obj) { return MACROPHYTES_module::I().MAC_PH_BIOMAS_i41_exe(); }
int PHBIO_NPP_u42_exe_g(Variable* obj) { return MACROPHYTES_module::I().PHBIO_NPP_u42_exe(); }
int PHBIO_PLANT_u43_exe_g(Variable* obj) { return MACROPHYTES_module::I().PHBIO_PLANT_u43_exe(); }
int PHBIO_MORT_u44_exe_g(Variable* obj) { return MACROPHYTES_module::I().PHBIO_MORT_u44_exe(); }
int PHBIO_HARVEST_u45_exe_g(Variable* obj) { return MACROPHYTES_module::I().PHBIO_HARVEST_u45_exe(); }
int PH_MAX_I46_exe_g(Variable* obj) { return MACROPHYTES_module::I().PH_MAX_I46_exe(); }
int PH_MAX_i47_exe_g(Variable* obj) { return MACROPHYTES_module::I().PH_MAX_i47_exe(); }
int PH_IN_u48_exe_g(Variable* obj) { return MACROPHYTES_module::I().PH_IN_u48_exe(); }
int PH_OUT_u49_exe_g(Variable* obj) { return MACROPHYTES_module::I().PH_OUT_u49_exe(); }
int TOT_NPP_I50_exe_g(Variable* obj) { return MACROPHYTES_module::I().TOT_NPP_I50_exe(); }
int TOT_NPP_i51_exe_g(Variable* obj) { return MACROPHYTES_module::I().TOT_NPP_i51_exe(); }
int NPP_IN_u52_exe_g(Variable* obj) { return MACROPHYTES_module::I().NPP_IN_u52_exe(); }
int YIELD_I53_exe_g(Variable* obj) { return MACROPHYTES_module::I().YIELD_I53_exe(); }
int YIELD_i54_exe_g(Variable* obj) { return MACROPHYTES_module::I().YIELD_i54_exe(); }
int HARVEST_u55_exe_g(Variable* obj) { return MACROPHYTES_module::I().HARVEST_u55_exe(); }
int INI_YIELD_u56_exe_g(Variable* obj) { return MACROPHYTES_module::I().INI_YIELD_u56_exe(); }
int DAY_LENGTH_PREV_u57_exe_g(Variable* obj) { return MACROPHYTES_module::I().DAY_LENGTH_PREV_u57_exe(); }
int FALL_LITTER_u58_exe_g(Variable* obj) { return MACROPHYTES_module::I().FALL_LITTER_u58_exe(); }
int FALL_LITTER_CALC_u59_exe_g(Variable* obj) { return MACROPHYTES_module::I().FALL_LITTER_CALC_u59_exe(); }
int HARVEST_TIME_u60_exe_g(Variable* obj) { return MACROPHYTES_module::I().HARVEST_TIME_u60_exe(); }
int IC_NPHBIO_u61_exe_g(Variable* obj) { return MACROPHYTES_module::I().IC_NPHBIO_u61_exe(); }
int IC_PHBIO_u62_exe_g(Variable* obj) { return MACROPHYTES_module::I().IC_PHBIO_u62_exe(); }
int LIGHT_CF_u63_exe_g(Variable* obj) { return MACROPHYTES_module::I().LIGHT_CF_u63_exe(); }
int MACH_u64_exe_g(Variable* obj) { return MACROPHYTES_module::I().MACH_u64_exe(); }
int MACLAI_u65_exe_g(Variable* obj) { return MACROPHYTES_module::I().MACLAI_u65_exe(); }
int MAC_LAI_R_u66_exe_g(Variable* obj) { return MACROPHYTES_module::I().MAC_LAI_R_u66_exe(); }
int MAC_PROD_CF_u67_exe_g(Variable* obj) { return MACROPHYTES_module::I().MAC_PROD_CF_u67_exe(); }
int MAX_BM_u68_exe_g(Variable* obj) { return MACROPHYTES_module::I().MAX_BM_u68_exe(); }
int MAX_NPH_u69_exe_g(Variable* obj) { return MACROPHYTES_module::I().MAX_NPH_u69_exe(); }
int MAX_PH_u70_exe_g(Variable* obj) { return MACROPHYTES_module::I().MAX_PH_u70_exe(); }
int NPH_AB_BM_u71_exe_g(Variable* obj) { return MACROPHYTES_module::I().NPH_AB_BM_u71_exe(); }
int NUTR_CF_u72_exe_g(Variable* obj) { return MACROPHYTES_module::I().NUTR_CF_u72_exe(); }
int PHBIO_MORT_WATER_u73_exe_g(Variable* obj) { return MACROPHYTES_module::I().PHBIO_MORT_WATER_u73_exe(); }
int PHBIO_NPP_CALC_u74_exe_g(Variable* obj) { return MACROPHYTES_module::I().PHBIO_NPP_CALC_u74_exe(); }
int PH_TO_ABBM_u75_exe_g(Variable* obj) { return MACROPHYTES_module::I().PH_TO_ABBM_u75_exe(); }
int PLANTIME_u76_exe_g(Variable* obj) { return MACROPHYTES_module::I().PLANTIME_u76_exe(); }
int PLANTING_u77_exe_g(Variable* obj) { return MACROPHYTES_module::I().PLANTING_u77_exe(); }
int PO4SD_CONCTOT_u78_exe_g(Variable* obj) { return MACROPHYTES_module::I().PO4SD_CONCTOT_u78_exe(); }
int REMOVAL_TIME_u79_exe_g(Variable* obj) { return MACROPHYTES_module::I().REMOVAL_TIME_u79_exe(); }
int ROOT_BM_u80_exe_g(Variable* obj) { return MACROPHYTES_module::I().ROOT_BM_u80_exe(); }
int ROOT_DEPTH_u81_exe_g(Variable* obj) { return MACROPHYTES_module::I().ROOT_DEPTH_u81_exe(); }
int SPROUTING_u82_exe_g(Variable* obj) { return MACROPHYTES_module::I().SPROUTING_u82_exe(); }
int TEMP_CF_u83_exe_g(Variable* obj) { return MACROPHYTES_module::I().TEMP_CF_u83_exe(); }
int TOTAL_BIOM_u84_exe_g(Variable* obj) { return MACROPHYTES_module::I().TOTAL_BIOM_u84_exe(); }
int TRANSDOWN_RT_u85_exe_g(Variable* obj) { return MACROPHYTES_module::I().TRANSDOWN_RT_u85_exe(); }
int WATER_CF_u86_exe_g(Variable* obj) { return MACROPHYTES_module::I().WATER_CF_u86_exe(); }
int WAT_STRESS_HIGH_u87_exe_g(Variable* obj) { return MACROPHYTES_module::I().WAT_STRESS_HIGH_u87_exe(); }
int WAT_STRESS_LOW_u88_exe_g(Variable* obj) { return MACROPHYTES_module::I().WAT_STRESS_LOW_u88_exe(); }
int P1_BIO_END_u89_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_BIO_END_u89_exe(); }
int P1_BIO_REPRO_u90_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_BIO_REPRO_u90_exe(); }
int P1_BIO_START_u91_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_BIO_START_u91_exe(); }
int P1_DAYLENG_RQ_u92_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_DAYLENG_RQ_u92_exe(); }
int P1_EST_HEIGHT_u93_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_EST_HEIGHT_u93_exe(); }
int P1_H_DAY_u94_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_H_DAY_u94_exe(); }
int P1_LIGHTSAT_u95_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_LIGHTSAT_u95_exe(); }
int P1_MAC_KS_N_u96_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_MAC_KS_N_u96_exe(); }
int P1_MAC_KS_P_u97_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_MAC_KS_P_u97_exe(); }
int P1_MAX_AB_BM_u98_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_MAX_AB_BM_u98_exe(); }
int P1_MAX_DENS_u99_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_MAX_DENS_u99_exe(); }
int P1_MAX_HT_BM_u100_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_MAX_HT_BM_u100_exe(); }
int P1_MAX_LAI_u101_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_MAX_LAI_u101_exe(); }
int P1_MAX_PH_ABBM_u102_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_MAX_PH_ABBM_u102_exe(); }
int P1_NPH_ABBM_IC_u103_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_NPH_ABBM_IC_u103_exe(); }
int P1_NPH_AB_BEL_u104_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_NPH_AB_BEL_u104_exe(); }
int P1_NPH_MORT_u105_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_NPH_MORT_u105_exe(); }
int P1_NPH_PR_H_u106_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_NPH_PR_H_u106_exe(); }
int P1_NPP_u107_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_NPP_u107_exe(); }
int P1_PHB_C_REC_u108_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_PHB_C_REC_u108_exe(); }
int P1_PHB_EVGRN_u109_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_PHB_EVGRN_u109_exe(); }
int P1_PHB_L_RT_u110_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_PHB_L_RT_u110_exe(); }
int P1_PHB_MORT_u111_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_PHB_MORT_u111_exe(); }
int P1_PHB_PR_H_u112_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_PHB_PR_H_u112_exe(); }
int P1_PH_TO_REP_u113_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_PH_TO_REP_u113_exe(); }
int P1_PROP_LA_TO_B_u114_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_PROP_LA_TO_B_u114_exe(); }
int P1_P_DAY_u115_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_P_DAY_u115_exe(); }
int P1_P_RATIO_u116_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_P_RATIO_u116_exe(); }
int P1_P_WT_u117_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_P_WT_u117_exe(); }
int P1_ROOT_DENS_u118_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_ROOT_DENS_u118_exe(); }
int P1_SPR_RATE_u119_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_SPR_RATE_u119_exe(); }
int P1_TEMPOPT_u120_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_TEMPOPT_u120_exe(); }
int P1_W_T_MAX_u121_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_W_T_MAX_u121_exe(); }
int P1_W_T_MIN_u122_exe_g(Variable* obj) { return MACROPHYTES_module::I().P1_W_T_MIN_u122_exe(); }
// ---------------------------------------------------------------------------
//                    Class XXXImports4_module 
// ---------------------------------------------------------------------------

class XXXImports4_module : public TModule {
protected:

	XXXImports4_module(char* name);

public:

	TTime TIME;
	CAuxVariable SOLRADGR;
	CAuxVariable DAYJUL;
protected:

	int SOLRADGR_u137_exe();
	friend int SOLRADGR_u137_exe_g( Variable* v );
	static XXXImports4_module* fInstance;
	static XXXImports4_module* kNullModel;
public:
	inline static XXXImports4_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new XXXImports4_module("XXXImports4_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (XXXImports4_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}

	inline double Graph8(double x) { 
		static double g[366][2] = {
			{ 0.0000E+00, 0.000000E+00},{ 1.0000E+00, 0.000000E+00},{ 2.0000E+00, 0.000000E+00},{ 3.0000E+00, 2.500000E+00},
			{ 4.0000E+00, 1.110000E+00},{ 5.0000E+00, 0.000000E+00},{ 6.0000E+00, 0.000000E+00},{ 7.0000E+00, 3.330000E+00},
			{ 8.0000E+00, 0.000000E+00},{ 9.0000E+00, 0.000000E+00},{ 1.0000E+01, 1.670000E+00},{ 1.1000E+01, 1.940000E+00},
			{ 1.2000E+01, 8.300000E-01},{ 1.3000E+01, 2.500000E+00},{ 1.4000E+01, 0.000000E+00},{ 1.5000E+01, 1.390000E+00},
			{ 1.6000E+01, 6.110000E+00},{ 1.7000E+01, 7.220000E+00},{ 1.8000E+01, 2.500000E+00},{ 1.9000E+01, 1.110000E+00},
			{ 2.0000E+01, 6.390000E+00},{ 2.1000E+01, 8.330000E+00},{ 2.2000E+01, 0.000000E+00},{ 2.3000E+01, 0.000000E+00},
			{ 2.4000E+01, 0.000000E+00},{ 2.5000E+01, 0.000000E+00},{ 2.6000E+01, 0.000000E+00},{ 2.7000E+01, 0.000000E+00},
			{ 2.8000E+01, 2.500000E+00},{ 2.9000E+01, 3.890000E+00},{ 3.0000E+01, 5.000000E+00},{ 3.1000E+01, 7.780000E+00},
			{ 3.2000E+01, 0.000000E+00},{ 3.3000E+01, 8.300000E-01},{ 3.4000E+01, 4.440000E+00},{ 3.5000E+01, 7.780000E+00},
			{ 3.6000E+01, 1.000000E+01},{ 3.7000E+01, 1.330000E+01},{ 3.8000E+01, 9.720000E+00},{ 3.9000E+01, 8.330000E+00},
			{ 4.0000E+01, 4.170000E+00},{ 4.1000E+01, 3.330000E+00},{ 4.2000E+01, 5.000000E+00},{ 4.3000E+01, 0.000000E+00},
			{ 4.4000E+01, 0.000000E+00},{ 4.5000E+01, 5.830000E+00},{ 4.6000E+01, 6.390000E+00},{ 4.7000E+01, 0.000000E+00},
			{ 4.8000E+01, 0.000000E+00},{ 4.9000E+01, 2.220000E+00},{ 5.0000E+01, 6.670000E+00},{ 5.1000E+01, 1.310000E+01},
			{ 5.2000E+01, 8.610000E+00},{ 5.3000E+01, 7.500000E+00},{ 5.4000E+01, 1.030000E+01},{ 5.5000E+01, 0.000000E+00},
			{ 5.6000E+01, 5.280000E+00},{ 5.7000E+01, 4.440000E+00},{ 5.8000E+01, 1.110000E+00},{ 5.9000E+01, 5.600000E-01},
			{ 6.0000E+01, 5.830000E+00},{ 6.1000E+01, 1.140000E+01},{ 6.2000E+01, 1.580000E+01},{ 6.3000E+01, 1.220000E+01},
			{ 6.4000E+01, 5.560000E+00},{ 6.5000E+01, 6.670000E+00},{ 6.6000E+01, 1.060000E+01},{ 6.7000E+01, 4.440000E+00},
			{ 6.8000E+01, 3.060000E+00},{ 6.9000E+01, 1.940000E+00},{ 7.0000E+01, 4.720000E+00},{ 7.1000E+01, 1.670000E+00},
			{ 7.2000E+01, 2.500000E+00},{ 7.3000E+01, 8.300000E-01},{ 7.4000E+01, 1.940000E+00},{ 7.5000E+01, 3.060000E+00},
			{ 7.6000E+01, 4.440000E+00},{ 7.7000E+01, 1.080000E+01},{ 7.8000E+01, 1.030000E+01},{ 7.9000E+01, 6.670000E+00},
			{ 8.0000E+01, 1.110000E+01},{ 8.1000E+01, 1.190000E+01},{ 8.2000E+01, 8.610000E+00},{ 8.3000E+01, 7.780000E+00},
			{ 8.4000E+01, 1.170000E+01},{ 8.5000E+01, 6.940000E+00},{ 8.6000E+01, 1.080000E+01},{ 8.7000E+01, 1.530000E+01},
			{ 8.8000E+01, 1.670000E+01},{ 8.9000E+01, 6.390000E+00},{ 9.0000E+01, 2.500000E+00},{ 9.1000E+01, 4.440000E+00},
			{ 9.2000E+01, 6.390000E+00},{ 9.3000E+01, 4.170000E+00},{ 9.4000E+01, 6.670000E+00},{ 9.5000E+01, 1.310000E+01},
			{ 9.6000E+01, 1.170000E+01},{ 9.7000E+01, 1.580000E+01},{ 9.8000E+01, 1.970000E+01},{ 9.9000E+01, 2.170000E+01},
			{ 1.0000E+02, 2.110000E+01},{ 1.0100E+02, 1.330000E+01},{ 1.0200E+02, 1.000000E+01},{ 1.0300E+02, 1.000000E+01},
			{ 1.0400E+02, 7.780000E+00},{ 1.0500E+02, 7.500000E+00},{ 1.0600E+02, 9.720000E+00},{ 1.0700E+02, 1.690000E+01},
			{ 1.0800E+02, 1.940000E+01},{ 1.0900E+02, 1.190000E+01},{ 1.1000E+02, 8.890000E+00},{ 1.1100E+02, 8.610000E+00},
			{ 1.1200E+02, 8.330000E+00},{ 1.1300E+02, 8.330000E+00},{ 1.1400E+02, 1.220000E+01},{ 1.1500E+02, 1.360000E+01},
			{ 1.1600E+02, 1.530000E+01},{ 1.1700E+02, 1.720000E+01},{ 1.1800E+02, 2.110000E+01},{ 1.1900E+02, 1.780000E+01},
			{ 1.2000E+02, 1.420000E+01},{ 1.2100E+02, 1.780000E+01},{ 1.2200E+02, 1.890000E+01},{ 1.2300E+02, 1.330000E+01},
			{ 1.2400E+02, 1.250000E+01},{ 1.2500E+02, 1.500000E+01},{ 1.2600E+02, 1.970000E+01},{ 1.2700E+02, 1.810000E+01},
			{ 1.2800E+02, 1.330000E+01},{ 1.2900E+02, 1.830000E+01},{ 1.3000E+02, 1.470000E+01},{ 1.3100E+02, 1.830000E+01},
			{ 1.3200E+02, 1.810000E+01},{ 1.3300E+02, 2.330000E+01},{ 1.3400E+02, 2.470000E+01},{ 1.3500E+02, 2.390000E+01},
			{ 1.3600E+02, 2.250000E+01},{ 1.3700E+02, 2.250000E+01},{ 1.3800E+02, 2.440000E+01},{ 1.3900E+02, 1.720000E+01},
			{ 1.4000E+02, 1.250000E+01},{ 1.4100E+02, 1.640000E+01},{ 1.4200E+02, 2.060000E+01},{ 1.4300E+02, 2.330000E+01},
			{ 1.4400E+02, 2.420000E+01},{ 1.4500E+02, 2.530000E+01},{ 1.4600E+02, 2.690000E+01},{ 1.4700E+02, 2.720000E+01},
			{ 1.4800E+02, 2.750000E+01},{ 1.4900E+02, 2.610000E+01},{ 1.5000E+02, 2.670000E+01},{ 1.5100E+02, 2.860000E+01},
			{ 1.5200E+02, 2.750000E+01},{ 1.5300E+02, 2.560000E+01},{ 1.5400E+02, 2.470000E+01},{ 1.5500E+02, 2.360000E+01},
			{ 1.5600E+02, 1.920000E+01},{ 1.5700E+02, 1.580000E+01},{ 1.5800E+02, 1.640000E+01},{ 1.5900E+02, 1.810000E+01},
			{ 1.6000E+02, 2.060000E+01},{ 1.6100E+02, 2.310000E+01},{ 1.6200E+02, 2.470000E+01},{ 1.6300E+02, 2.640000E+01},
			{ 1.6400E+02, 2.280000E+01},{ 1.6500E+02, 1.830000E+01},{ 1.6600E+02, 2.170000E+01},{ 1.6700E+02, 2.940000E+01},
			{ 1.6800E+02, 2.920000E+01},{ 1.6900E+02, 2.640000E+01},{ 1.7000E+02, 1.890000E+01},{ 1.7100E+02, 2.000000E+01},
			{ 1.7200E+02, 2.500000E+01},{ 1.7300E+02, 2.720000E+01},{ 1.7400E+02, 2.060000E+01},{ 1.7500E+02, 1.560000E+01},
			{ 1.7600E+02, 2.000000E+01},{ 1.7700E+02, 1.890000E+01},{ 1.7800E+02, 2.110000E+01},{ 1.7900E+02, 2.440000E+01},
			{ 1.8000E+02, 2.810000E+01},{ 1.8100E+02, 2.940000E+01},{ 1.8200E+02, 2.830000E+01},{ 1.8300E+02, 2.530000E+01},
			{ 1.8400E+02, 2.690000E+01},{ 1.8500E+02, 2.580000E+01},{ 1.8600E+02, 2.220000E+01},{ 1.8700E+02, 2.310000E+01},
			{ 1.8800E+02, 2.720000E+01},{ 1.8900E+02, 2.780000E+01},{ 1.9000E+02, 2.750000E+01},{ 1.9100E+02, 2.420000E+01},
			{ 1.9200E+02, 2.250000E+01},{ 1.9300E+02, 2.390000E+01},{ 1.9400E+02, 2.750000E+01},{ 1.9500E+02, 2.610000E+01},
			{ 1.9600E+02, 2.360000E+01},{ 1.9700E+02, 2.330000E+01},{ 1.9800E+02, 2.530000E+01},{ 1.9900E+02, 2.830000E+01},
			{ 2.0000E+02, 3.030000E+01},{ 2.0100E+02, 2.940000E+01},{ 2.0200E+02, 3.000000E+01},{ 2.0300E+02, 3.030000E+01},
			{ 2.0400E+02, 2.920000E+01},{ 2.0500E+02, 2.970000E+01},{ 2.0600E+02, 2.670000E+01},{ 2.0700E+02, 2.500000E+01},
			{ 2.0800E+02, 2.640000E+01},{ 2.0900E+02, 2.030000E+01},{ 2.1000E+02, 2.420000E+01},{ 2.1100E+02, 2.360000E+01},
			{ 2.1200E+02, 2.220000E+01},{ 2.1300E+02, 2.330000E+01},{ 2.1400E+02, 2.670000E+01},{ 2.1500E+02, 2.890000E+01},
			{ 2.1600E+02, 3.060000E+01},{ 2.1700E+02, 2.470000E+01},{ 2.1800E+02, 2.190000E+01},{ 2.1900E+02, 2.470000E+01},
			{ 2.2000E+02, 2.280000E+01},{ 2.2100E+02, 2.580000E+01},{ 2.2200E+02, 2.500000E+01},{ 2.2300E+02, 2.190000E+01},
			{ 2.2400E+02, 2.220000E+01},{ 2.2500E+02, 2.330000E+01},{ 2.2600E+02, 2.470000E+01},{ 2.2700E+02, 2.500000E+01},
			{ 2.2800E+02, 2.310000E+01},{ 2.2900E+02, 2.500000E+01},{ 2.3000E+02, 2.560000E+01},{ 2.3100E+02, 2.720000E+01},
			{ 2.3200E+02, 2.530000E+01},{ 2.3300E+02, 2.220000E+01},{ 2.3400E+02, 2.030000E+01},{ 2.3500E+02, 2.190000E+01},
			{ 2.3600E+02, 2.440000E+01},{ 2.3700E+02, 2.440000E+01},{ 2.3800E+02, 2.170000E+01},{ 2.3900E+02, 2.280000E+01},
			{ 2.4000E+02, 2.420000E+01},{ 2.4100E+02, 2.690000E+01},{ 2.4200E+02, 2.810000E+01},{ 2.4300E+02, 2.940000E+01},
			{ 2.4400E+02, 2.500000E+01},{ 2.4500E+02, 1.690000E+01},{ 2.4600E+02, 1.780000E+01},{ 2.4700E+02, 2.030000E+01},
			{ 2.4800E+02, 2.470000E+01},{ 2.4900E+02, 2.360000E+01},{ 2.5000E+02, 1.830000E+01},{ 2.5100E+02, 2.220000E+01},
			{ 2.5200E+02, 2.280000E+01},{ 2.5300E+02, 2.440000E+01},{ 2.5400E+02, 2.470000E+01},{ 2.5500E+02, 2.220000E+01},
			{ 2.5600E+02, 1.830000E+01},{ 2.5700E+02, 2.110000E+01},{ 2.5800E+02, 2.360000E+01},{ 2.5900E+02, 2.500000E+01},
			{ 2.6000E+02, 2.860000E+01},{ 2.6100E+02, 2.860000E+01},{ 2.6200E+02, 2.640000E+01},{ 2.6300E+02, 1.810000E+01},
			{ 2.6400E+02, 1.280000E+01},{ 2.6500E+02, 1.170000E+01},{ 2.6600E+02, 1.580000E+01},{ 2.6700E+02, 1.830000E+01},
			{ 2.6800E+02, 2.000000E+01},{ 2.6900E+02, 1.690000E+01},{ 2.7000E+02, 1.420000E+01},{ 2.7100E+02, 1.080000E+01},
			{ 2.7200E+02, 1.330000E+01},{ 2.7300E+02, 1.780000E+01},{ 2.7400E+02, 1.560000E+01},{ 2.7500E+02, 2.110000E+01},
			{ 2.7600E+02, 2.250000E+01},{ 2.7700E+02, 2.080000E+01},{ 2.7800E+02, 2.280000E+01},{ 2.7900E+02, 1.940000E+01},
			{ 2.8000E+02, 1.110000E+01},{ 2.8100E+02, 8.330000E+00},{ 2.8200E+02, 1.080000E+01},{ 2.8300E+02, 1.280000E+01},
			{ 2.8400E+02, 1.610000E+01},{ 2.8500E+02, 1.190000E+01},{ 2.8600E+02, 1.220000E+01},{ 2.8700E+02, 8.890000E+00},
			{ 2.8800E+02, 1.060000E+01},{ 2.8900E+02, 1.610000E+01},{ 2.9000E+02, 1.250000E+01},{ 2.9100E+02, 6.940000E+00},
			{ 2.9200E+02, 1.420000E+01},{ 2.9300E+02, 1.440000E+01},{ 2.9400E+02, 5.560000E+00},{ 2.9500E+02, 7.500000E+00},
			{ 2.9600E+02, 1.280000E+01},{ 2.9700E+02, 1.720000E+01},{ 2.9800E+02, 1.670000E+01},{ 2.9900E+02, 1.690000E+01},
			{ 3.0000E+02, 1.690000E+01},{ 3.0100E+02, 1.690000E+01},{ 3.0200E+02, 1.140000E+01},{ 3.0300E+02, 6.670000E+00},
			{ 3.0400E+02, 1.170000E+01},{ 3.0500E+02, 1.190000E+01},{ 3.0600E+02, 1.420000E+01},{ 3.0700E+02, 1.000000E+01},
			{ 3.0800E+02, 6.110000E+00},{ 3.0900E+02, 0.000000E+00},{ 3.1000E+02, 0.000000E+00},{ 3.1100E+02, 3.610000E+00},
			{ 3.1200E+02, 6.940000E+00},{ 3.1300E+02, 2.780000E+00},{ 3.1400E+02, 2.780000E+00},{ 3.1500E+02, 4.170000E+00},
			{ 3.1600E+02, 3.610000E+00},{ 3.1700E+02, 5.280000E+00},{ 3.1800E+02, 4.720000E+00},{ 3.1900E+02, 9.440000E+00},
			{ 3.2000E+02, 1.470000E+01},{ 3.2100E+02, 1.000000E+01},{ 3.2200E+02, 3.890000E+00},{ 3.2300E+02, 6.670000E+00},
			{ 3.2400E+02, 1.140000E+01},{ 3.2500E+02, 1.890000E+01},{ 3.2600E+02, 1.970000E+01},{ 3.2700E+02, 1.560000E+01},
			{ 3.2800E+02, 1.220000E+01},{ 3.2900E+02, 5.830000E+00},{ 3.3000E+02, 5.600000E-01},{ 3.3100E+02, 0.000000E+00},
			{ 3.3200E+02, 8.300000E-01},{ 3.3300E+02, 9.440000E+00},{ 3.3400E+02, 1.390000E+01},{ 3.3500E+02, 1.810000E+01},
			{ 3.3600E+02, 1.310000E+01},{ 3.3700E+02, 8.060000E+00},{ 3.3800E+02, 7.220000E+00},{ 3.3900E+02, 0.000000E+00},
			{ 3.4000E+02, 0.000000E+00},{ 3.4100E+02, 3.330000E+00},{ 3.4200E+02, 5.280000E+00},{ 3.4300E+02, 8.330000E+00},
			{ 3.4400E+02, 1.250000E+01},{ 3.4500E+02, 4.440000E+00},{ 3.4600E+02, 6.390000E+00},{ 3.4700E+02, 9.170000E+00},
			{ 3.4800E+02, 1.420000E+01},{ 3.4900E+02, 9.440000E+00},{ 3.5000E+02, 0.000000E+00},{ 3.5100E+02, 0.000000E+00},
			{ 3.5200E+02, 3.610000E+00},{ 3.5300E+02, 0.000000E+00},{ 3.5400E+02, 0.000000E+00},{ 3.5500E+02, 2.800000E-01},
			{ 3.5600E+02, 2.780000E+00},{ 3.5700E+02, 3.890000E+00},{ 3.5800E+02, 2.780000E+00},{ 3.5900E+02, 0.000000E+00},
			{ 3.6000E+02, 0.000000E+00},{ 3.6100E+02, 8.300000E-01},{ 3.6200E+02, 1.390000E+00},{ 3.6300E+02, 2.780000E+00},
			{ 3.6400E+02, 5.830000E+00},{ 3.6500E+02, 1.390000E+00}, };
		return SL::Graph( 0, x, 365, g); 
	}

	inline double Graph9(double x) { 
		static double g[366][2] = {
			{ 0.0000E+00, 9.380000E+00},{ 1.0000E+00, 9.390000E+00},{ 2.0000E+00, 9.400000E+00},{ 3.0000E+00, 9.410000E+00},
			{ 4.0000E+00, 9.420000E+00},{ 5.0000E+00, 9.440000E+00},{ 6.0000E+00, 9.450000E+00},{ 7.0000E+00, 9.460000E+00},
			{ 8.0000E+00, 9.480000E+00},{ 9.0000E+00, 9.500000E+00},{ 1.0000E+01, 9.510000E+00},{ 1.1000E+01, 9.530000E+00},
			{ 1.2000E+01, 9.550000E+00},{ 1.3000E+01, 9.570000E+00},{ 1.4000E+01, 9.590000E+00},{ 1.5000E+01, 9.610000E+00},
			{ 1.6000E+01, 9.630000E+00},{ 1.7000E+01, 9.650000E+00},{ 1.8000E+01, 9.670000E+00},{ 1.9000E+01, 9.700000E+00},
			{ 2.0000E+01, 9.720000E+00},{ 2.1000E+01, 9.750000E+00},{ 2.2000E+01, 9.770000E+00},{ 2.3000E+01, 9.800000E+00},
			{ 2.4000E+01, 9.820000E+00},{ 2.5000E+01, 9.850000E+00},{ 2.6000E+01, 9.880000E+00},{ 2.7000E+01, 9.910000E+00},
			{ 2.8000E+01, 9.940000E+00},{ 2.9000E+01, 9.970000E+00},{ 3.0000E+01, 1.000000E+01},{ 3.1000E+01, 1.000000E+01},
			{ 3.2000E+01, 1.010000E+01},{ 3.3000E+01, 1.010000E+01},{ 3.4000E+01, 1.010000E+01},{ 3.5000E+01, 1.020000E+01},
			{ 3.6000E+01, 1.020000E+01},{ 3.7000E+01, 1.020000E+01},{ 3.8000E+01, 1.030000E+01},{ 3.9000E+01, 1.030000E+01},
			{ 4.0000E+01, 1.030000E+01},{ 4.1000E+01, 1.040000E+01},{ 4.2000E+01, 1.040000E+01},{ 4.3000E+01, 1.040000E+01},
			{ 4.4000E+01, 1.050000E+01},{ 4.5000E+01, 1.050000E+01},{ 4.6000E+01, 1.060000E+01},{ 4.7000E+01, 1.060000E+01},
			{ 4.8000E+01, 1.060000E+01},{ 4.9000E+01, 1.070000E+01},{ 5.0000E+01, 1.070000E+01},{ 5.1000E+01, 1.080000E+01},
			{ 5.2000E+01, 1.080000E+01},{ 5.3000E+01, 1.080000E+01},{ 5.4000E+01, 1.090000E+01},{ 5.5000E+01, 1.090000E+01},
			{ 5.6000E+01, 1.100000E+01},{ 5.7000E+01, 1.100000E+01},{ 5.8000E+01, 1.110000E+01},{ 5.9000E+01, 1.110000E+01},
			{ 6.0000E+01, 1.110000E+01},{ 6.1000E+01, 1.120000E+01},{ 6.2000E+01, 1.120000E+01},{ 6.3000E+01, 1.130000E+01},
			{ 6.4000E+01, 1.130000E+01},{ 6.5000E+01, 1.140000E+01},{ 6.6000E+01, 1.140000E+01},{ 6.7000E+01, 1.140000E+01},
			{ 6.8000E+01, 1.150000E+01},{ 6.9000E+01, 1.150000E+01},{ 7.0000E+01, 1.160000E+01},{ 7.1000E+01, 1.160000E+01},
			{ 7.2000E+01, 1.170000E+01},{ 7.3000E+01, 1.170000E+01},{ 7.4000E+01, 1.180000E+01},{ 7.5000E+01, 1.180000E+01},
			{ 7.6000E+01, 1.190000E+01},{ 7.7000E+01, 1.190000E+01},{ 7.8000E+01, 1.190000E+01},{ 7.9000E+01, 1.200000E+01},
			{ 8.0000E+01, 1.210000E+01},{ 8.1000E+01, 1.210000E+01},{ 8.2000E+01, 1.210000E+01},{ 8.3000E+01, 1.220000E+01},
			{ 8.4000E+01, 1.220000E+01},{ 8.5000E+01, 1.230000E+01},{ 8.6000E+01, 1.230000E+01},{ 8.7000E+01, 1.240000E+01},
			{ 8.8000E+01, 1.240000E+01},{ 8.9000E+01, 1.250000E+01},{ 9.0000E+01, 1.250000E+01},{ 9.1000E+01, 1.260000E+01},
			{ 9.2000E+01, 1.260000E+01},{ 9.3000E+01, 1.260000E+01},{ 9.4000E+01, 1.270000E+01},{ 9.5000E+01, 1.270000E+01},
			{ 9.6000E+01, 1.280000E+01},{ 9.7000E+01, 1.280000E+01},{ 9.8000E+01, 1.290000E+01},{ 9.9000E+01, 1.290000E+01},
			{ 1.0000E+02, 1.290000E+01},{ 1.0100E+02, 1.300000E+01},{ 1.0200E+02, 1.300000E+01},{ 1.0300E+02, 1.310000E+01},
			{ 1.0400E+02, 1.310000E+01},{ 1.0500E+02, 1.320000E+01},{ 1.0600E+02, 1.320000E+01},{ 1.0700E+02, 1.320000E+01},
			{ 1.0800E+02, 1.330000E+01},{ 1.0900E+02, 1.330000E+01},{ 1.1000E+02, 1.340000E+01},{ 1.1100E+02, 1.340000E+01},
			{ 1.1200E+02, 1.340000E+01},{ 1.1300E+02, 1.350000E+01},{ 1.1400E+02, 1.350000E+01},{ 1.1500E+02, 1.360000E+01},
			{ 1.1600E+02, 1.360000E+01},{ 1.1700E+02, 1.360000E+01},{ 1.1800E+02, 1.370000E+01},{ 1.1900E+02, 1.370000E+01},
			{ 1.2000E+02, 1.370000E+01},{ 1.2100E+02, 1.380000E+01},{ 1.2200E+02, 1.380000E+01},{ 1.2300E+02, 1.380000E+01},
			{ 1.2400E+02, 1.390000E+01},{ 1.2500E+02, 1.390000E+01},{ 1.2600E+02, 1.390000E+01},{ 1.2700E+02, 1.400000E+01},
			{ 1.2800E+02, 1.400000E+01},{ 1.2900E+02, 1.400000E+01},{ 1.3000E+02, 1.410000E+01},{ 1.3100E+02, 1.410000E+01},
			{ 1.3200E+02, 1.410000E+01},{ 1.3300E+02, 1.420000E+01},{ 1.3400E+02, 1.420000E+01},{ 1.3500E+02, 1.420000E+01},
			{ 1.3600E+02, 1.420000E+01},{ 1.3700E+02, 1.420000E+01},{ 1.3800E+02, 1.430000E+01},{ 1.3900E+02, 1.430000E+01},
			{ 1.4000E+02, 1.430000E+01},{ 1.4100E+02, 1.430000E+01},{ 1.4200E+02, 1.440000E+01},{ 1.4300E+02, 1.440000E+01},
			{ 1.4400E+02, 1.440000E+01},{ 1.4500E+02, 1.440000E+01},{ 1.4600E+02, 1.440000E+01},{ 1.4700E+02, 1.450000E+01},
			{ 1.4800E+02, 1.450000E+01},{ 1.4900E+02, 1.450000E+01},{ 1.5000E+02, 1.450000E+01},{ 1.5100E+02, 1.450000E+01},
			{ 1.5200E+02, 1.460000E+01},{ 1.5300E+02, 1.460000E+01},{ 1.5400E+02, 1.460000E+01},{ 1.5500E+02, 1.460000E+01},
			{ 1.5600E+02, 1.460000E+01},{ 1.5700E+02, 1.460000E+01},{ 1.5800E+02, 1.460000E+01},{ 1.5900E+02, 1.460000E+01},
			{ 1.6000E+02, 1.460000E+01},{ 1.6100E+02, 1.470000E+01},{ 1.6200E+02, 1.470000E+01},{ 1.6300E+02, 1.470000E+01},
			{ 1.6400E+02, 1.470000E+01},{ 1.6500E+02, 1.470000E+01},{ 1.6600E+02, 1.470000E+01},{ 1.6700E+02, 1.470000E+01},
			{ 1.6800E+02, 1.470000E+01},{ 1.6900E+02, 1.470000E+01},{ 1.7000E+02, 1.470000E+01},{ 1.7100E+02, 1.470000E+01},
			{ 1.7200E+02, 1.470000E+01},{ 1.7300E+02, 1.470000E+01},{ 1.7400E+02, 1.470000E+01},{ 1.7500E+02, 1.470000E+01},
			{ 1.7600E+02, 1.470000E+01},{ 1.7700E+02, 1.470000E+01},{ 1.7800E+02, 1.470000E+01},{ 1.7900E+02, 1.470000E+01},
			{ 1.8000E+02, 1.460000E+01},{ 1.8100E+02, 1.460000E+01},{ 1.8200E+02, 1.460000E+01},{ 1.8300E+02, 1.460000E+01},
			{ 1.8400E+02, 1.460000E+01},{ 1.8500E+02, 1.460000E+01},{ 1.8600E+02, 1.460000E+01},{ 1.8700E+02, 1.460000E+01},
			{ 1.8800E+02, 1.460000E+01},{ 1.8900E+02, 1.450000E+01},{ 1.9000E+02, 1.450000E+01},{ 1.9100E+02, 1.450000E+01},
			{ 1.9200E+02, 1.450000E+01},{ 1.9300E+02, 1.450000E+01},{ 1.9400E+02, 1.450000E+01},{ 1.9500E+02, 1.440000E+01},
			{ 1.9600E+02, 1.440000E+01},{ 1.9700E+02, 1.440000E+01},{ 1.9800E+02, 1.440000E+01},{ 1.9900E+02, 1.440000E+01},
			{ 2.0000E+02, 1.430000E+01},{ 2.0100E+02, 1.430000E+01},{ 2.0200E+02, 1.430000E+01},{ 2.0300E+02, 1.430000E+01},
			{ 2.0400E+02, 1.420000E+01},{ 2.0500E+02, 1.420000E+01},{ 2.0600E+02, 1.420000E+01},{ 2.0700E+02, 1.420000E+01},
			{ 2.0800E+02, 1.410000E+01},{ 2.0900E+02, 1.410000E+01},{ 2.1000E+02, 1.410000E+01},{ 2.1100E+02, 1.410000E+01},
			{ 2.1200E+02, 1.400000E+01},{ 2.1300E+02, 1.400000E+01},{ 2.1400E+02, 1.400000E+01},{ 2.1500E+02, 1.390000E+01},
			{ 2.1600E+02, 1.390000E+01},{ 2.1700E+02, 1.390000E+01},{ 2.1800E+02, 1.380000E+01},{ 2.1900E+02, 1.380000E+01},
			{ 2.2000E+02, 1.380000E+01},{ 2.2100E+02, 1.370000E+01},{ 2.2200E+02, 1.370000E+01},{ 2.2300E+02, 1.370000E+01},
			{ 2.2400E+02, 1.360000E+01},{ 2.2500E+02, 1.360000E+01},{ 2.2600E+02, 1.350000E+01},{ 2.2700E+02, 1.350000E+01},
			{ 2.2800E+02, 1.350000E+01},{ 2.2900E+02, 1.340000E+01},{ 2.3000E+02, 1.340000E+01},{ 2.3100E+02, 1.330000E+01},
			{ 2.3200E+02, 1.330000E+01},{ 2.3300E+02, 1.330000E+01},{ 2.3400E+02, 1.320000E+01},{ 2.3500E+02, 1.320000E+01},
			{ 2.3600E+02, 1.310000E+01},{ 2.3700E+02, 1.310000E+01},{ 2.3800E+02, 1.310000E+01},{ 2.3900E+02, 1.300000E+01},
			{ 2.4000E+02, 1.300000E+01},{ 2.4100E+02, 1.290000E+01},{ 2.4200E+02, 1.290000E+01},{ 2.4300E+02, 1.280000E+01},
			{ 2.4400E+02, 1.280000E+01},{ 2.4500E+02, 1.280000E+01},{ 2.4600E+02, 1.270000E+01},{ 2.4700E+02, 1.270000E+01},
			{ 2.4800E+02, 1.260000E+01},{ 2.4900E+02, 1.260000E+01},{ 2.5000E+02, 1.250000E+01},{ 2.5100E+02, 1.250000E+01},
			{ 2.5200E+02, 1.240000E+01},{ 2.5300E+02, 1.240000E+01},{ 2.5400E+02, 1.230000E+01},{ 2.5500E+02, 1.230000E+01},
			{ 2.5600E+02, 1.230000E+01},{ 2.5700E+02, 1.220000E+01},{ 2.5800E+02, 1.220000E+01},{ 2.5900E+02, 1.210000E+01},
			{ 2.6000E+02, 1.210000E+01},{ 2.6100E+02, 1.200000E+01},{ 2.6200E+02, 1.200000E+01},{ 2.6300E+02, 1.190000E+01},
			{ 2.6400E+02, 1.190000E+01},{ 2.6500E+02, 1.180000E+01},{ 2.6600E+02, 1.180000E+01},{ 2.6700E+02, 1.180000E+01},
			{ 2.6800E+02, 1.170000E+01},{ 2.6900E+02, 1.170000E+01},{ 2.7000E+02, 1.160000E+01},{ 2.7100E+02, 1.160000E+01},
			{ 2.7200E+02, 1.150000E+01},{ 2.7300E+02, 1.150000E+01},{ 2.7400E+02, 1.140000E+01},{ 2.7500E+02, 1.140000E+01},
			{ 2.7600E+02, 1.130000E+01},{ 2.7700E+02, 1.130000E+01},{ 2.7800E+02, 1.120000E+01},{ 2.7900E+02, 1.120000E+01},
			{ 2.8000E+02, 1.120000E+01},{ 2.8100E+02, 1.110000E+01},{ 2.8200E+02, 1.110000E+01},{ 2.8300E+02, 1.100000E+01},
			{ 2.8400E+02, 1.100000E+01},{ 2.8500E+02, 1.090000E+01},{ 2.8600E+02, 1.090000E+01},{ 2.8700E+02, 1.090000E+01},
			{ 2.8800E+02, 1.080000E+01},{ 2.8900E+02, 1.080000E+01},{ 2.9000E+02, 1.070000E+01},{ 2.9100E+02, 1.070000E+01},
			{ 2.9200E+02, 1.070000E+01},{ 2.9300E+02, 1.060000E+01},{ 2.9400E+02, 1.060000E+01},{ 2.9500E+02, 1.050000E+01},
			{ 2.9600E+02, 1.050000E+01},{ 2.9700E+02, 1.050000E+01},{ 2.9800E+02, 1.040000E+01},{ 2.9900E+02, 1.040000E+01},
			{ 3.0000E+02, 1.030000E+01},{ 3.0100E+02, 1.030000E+01},{ 3.0200E+02, 1.030000E+01},{ 3.0300E+02, 1.020000E+01},
			{ 3.0400E+02, 1.020000E+01},{ 3.0500E+02, 1.020000E+01},{ 3.0600E+02, 1.010000E+01},{ 3.0700E+02, 1.010000E+01},
			{ 3.0800E+02, 1.010000E+01},{ 3.0900E+02, 1.010000E+01},{ 3.1000E+02, 1.000000E+01},{ 3.1100E+02, 9.980000E+00},
			{ 3.1200E+02, 9.950000E+00},{ 3.1300E+02, 9.920000E+00},{ 3.1400E+02, 9.900000E+00},{ 3.1500E+02, 9.870000E+00},
			{ 3.1600E+02, 9.840000E+00},{ 3.1700E+02, 9.810000E+00},{ 3.1800E+02, 9.790000E+00},{ 3.1900E+02, 9.760000E+00},
			{ 3.2000E+02, 9.740000E+00},{ 3.2100E+02, 9.710000E+00},{ 3.2200E+02, 9.690000E+00},{ 3.2300E+02, 9.660000E+00},
			{ 3.2400E+02, 9.640000E+00},{ 3.2500E+02, 9.620000E+00},{ 3.2600E+02, 9.600000E+00},{ 3.2700E+02, 9.580000E+00},
			{ 3.2800E+02, 9.560000E+00},{ 3.2900E+02, 9.540000E+00},{ 3.3000E+02, 9.520000E+00},{ 3.3100E+02, 9.510000E+00},
			{ 3.3200E+02, 9.490000E+00},{ 3.3300E+02, 9.470000E+00},{ 3.3400E+02, 9.460000E+00},{ 3.3500E+02, 9.440000E+00},
			{ 3.3600E+02, 9.430000E+00},{ 3.3700E+02, 9.420000E+00},{ 3.3800E+02, 9.410000E+00},{ 3.3900E+02, 9.390000E+00},
			{ 3.4000E+02, 9.380000E+00},{ 3.4100E+02, 9.370000E+00},{ 3.4200E+02, 9.370000E+00},{ 3.4300E+02, 9.360000E+00},
			{ 3.4400E+02, 9.350000E+00},{ 3.4500E+02, 9.340000E+00},{ 3.4600E+02, 9.340000E+00},{ 3.4700E+02, 9.330000E+00},
			{ 3.4800E+02, 9.330000E+00},{ 3.4900E+02, 9.320000E+00},{ 3.5000E+02, 9.320000E+00},{ 3.5100E+02, 9.320000E+00},
			{ 3.5200E+02, 9.320000E+00},{ 3.5300E+02, 9.320000E+00},{ 3.5400E+02, 9.320000E+00},{ 3.5500E+02, 9.320000E+00},
			{ 3.5600E+02, 9.320000E+00},{ 3.5700E+02, 9.330000E+00},{ 3.5800E+02, 9.330000E+00},{ 3.5900E+02, 9.330000E+00},
			{ 3.6000E+02, 9.340000E+00},{ 3.6100E+02, 9.350000E+00},{ 3.6200E+02, 9.350000E+00},{ 3.6300E+02, 9.360000E+00},
			{ 3.6400E+02, 9.370000E+00},{ 3.6500E+02, 9.380000E+00}, };
		return SL::Graph( 0, x, 365, g); 
	}

	inline double Graph10(double x) { 
		static double g[366][2] = {
			{ 0.0000E+00, 9.100000E-04},{ 1.0000E+00, 9.260000E-04},{ 2.0000E+00, 9.460000E-04},{ 3.0000E+00, 9.680000E-04},
			{ 4.0000E+00, 9.900000E-04},{ 5.0000E+00, 6.860000E-01},{ 6.0000E+00, 3.710000E-02},{ 7.0000E+00, 2.070000E-02},
			{ 8.0000E+00, 3.640000E-02},{ 9.0000E+00, 1.150000E-03},{ 1.0000E+01, 1.170000E-03},{ 1.1000E+01, 1.190000E-02},
			{ 1.2000E+01, 1.140000E-02},{ 1.3000E+01, 1.600000E-01},{ 1.4000E+01, 1.260000E-03},{ 1.5000E+01, 4.160000E-02},
			{ 1.6000E+01, 2.850000E-02},{ 1.7000E+01, 9.160000E-02},{ 1.8000E+01, 1.340000E-03},{ 1.9000E+01, 1.360000E-03},
			{ 2.0000E+01, 3.540000E-01},{ 2.1000E+01, 3.590000E-01},{ 2.2000E+01, 1.400000E-03},{ 2.3000E+01, 1.420000E-03},
			{ 2.4000E+01, 1.430000E-03},{ 2.5000E+01, 1.440000E-03},{ 2.6000E+01, 1.450000E-03},{ 2.7000E+01, 1.460000E-03},
			{ 2.8000E+01, 1.470000E-03},{ 2.9000E+01, 1.480000E-03},{ 3.0000E+01, 4.050000E-01},{ 3.1000E+01, 4.190000E-01},
			{ 3.2000E+01, 1.500000E-03},{ 3.3000E+01, 1.500000E-03},{ 3.4000E+01, 1.510000E-03},{ 3.5000E+01, 1.510000E-03},
			{ 3.6000E+01, 8.850000E-01},{ 3.7000E+01, 4.060000E-02},{ 3.8000E+01, 4.480000E-02},{ 3.9000E+01, 5.140000E-01},
			{ 4.0000E+01, 1.570000E-03},{ 4.1000E+01, 1.570000E-03},{ 4.2000E+01, 1.570000E-03},{ 4.3000E+01, 1.570000E-03},
			{ 4.4000E+01, 4.710000E-02},{ 4.5000E+01, 4.880000E-02},{ 4.6000E+01, 1.560000E-03},{ 4.7000E+01, 1.560000E-03},
			{ 4.8000E+01, 1.460000E-01},{ 4.9000E+01, 6.440000E-02},{ 5.0000E+01, 6.100000E-02},{ 5.1000E+01, 1.110000E-01},
			{ 5.2000E+01, 1.550000E-03},{ 5.3000E+01, 1.550000E-03},{ 5.4000E+01, 1.550000E-03},{ 5.5000E+01, 1.540000E-03},
			{ 5.6000E+01, 1.620000E+00},{ 5.7000E+01, 1.650000E+00},{ 5.8000E+01, 1.540000E-03},{ 5.9000E+01, 1.540000E-03},
			{ 6.0000E+01, 1.280000E-01},{ 6.1000E+01, 5.650000E-02},{ 6.2000E+01, 8.680000E-03},{ 6.3000E+01, 8.400000E-03},
			{ 6.4000E+01, 4.690000E-02},{ 6.5000E+01, 3.630000E-02},{ 6.6000E+01, 4.010000E-02},{ 6.7000E+01, 1.550000E-03},
			{ 6.8000E+01, 1.550000E-03},{ 6.9000E+01, 1.540000E-03},{ 7.0000E+01, 1.540000E-03},{ 7.1000E+01, 1.540000E-03},
			{ 7.2000E+01, 3.050000E-02},{ 7.3000E+01, 2.240000E-02},{ 7.4000E+01, 7.280000E-02},{ 7.5000E+01, 1.540000E-03},
			{ 7.6000E+01, 8.390000E-03},{ 7.7000E+01, 8.880000E-03},{ 7.8000E+01, 6.880000E-01},{ 7.9000E+01, 1.000000E-01},
			{ 8.0000E+01, 5.910000E-02},{ 8.1000E+01, 2.320000E-03},{ 8.2000E+01, 2.520000E-03},{ 8.3000E+01, 5.590000E-03},
			{ 8.4000E+01, 5.950000E-02},{ 8.5000E+01, 8.140000E-03},{ 8.6000E+01, 1.320000E-02},{ 8.7000E+01, 2.890000E-02},
			{ 8.8000E+01, 2.920000E-03},{ 8.9000E+01, 3.900000E-03},{ 9.0000E+01, 1.550000E-03},{ 9.1000E+01, 1.550000E-03},
			{ 9.2000E+01, 1.560000E-03},{ 9.3000E+01, 1.560000E-03},{ 9.4000E+01, 1.560000E-03},{ 9.5000E+01, 8.750000E-02},
			{ 9.6000E+01, 1.020000E-01},{ 9.7000E+01, 1.560000E-03},{ 9.8000E+01, 1.560000E-03},{ 9.9000E+01, 1.560000E-03},
			{ 1.0000E+02, 1.560000E-03},{ 1.0100E+02, 1.560000E-03},{ 1.0200E+02, 1.560000E-03},{ 1.0300E+02, 3.600000E-02},
			{ 1.0400E+02, 2.850000E-02},{ 1.0500E+02, 4.990000E-02},{ 1.0600E+02, 7.700000E-02},{ 1.0700E+02, 1.560000E-03},
			{ 1.0800E+02, 1.550000E-03},{ 1.0900E+02, 7.460000E-01},{ 1.1000E+02, 1.270000E-01},{ 1.1100E+02, 2.610000E-02},
			{ 1.1200E+02, 3.330000E-02},{ 1.1300E+02, 1.590000E-03},{ 1.1400E+02, 7.050000E-02},{ 1.1500E+02, 7.490000E-02},
			{ 1.1600E+02, 1.580000E-03},{ 1.1700E+02, 3.150000E-02},{ 1.1800E+02, 1.270000E-02},{ 1.1900E+02, 1.670000E-02},
			{ 1.2000E+02, 5.330000E-02},{ 1.2100E+02, 6.640000E-02},{ 1.2200E+02, 8.820000E-02},{ 1.2300E+02, 1.900000E-03},
			{ 1.2400E+02, 1.880000E-03},{ 1.2500E+02, 2.640000E-02},{ 1.2600E+02, 2.150000E-02},{ 1.2700E+02, 8.910000E-02},
			{ 1.2800E+02, 1.850000E-03},{ 1.2900E+02, 9.540000E-02},{ 1.3000E+02, 1.010000E-01},{ 1.3100E+02, 1.820000E-03},
			{ 1.3200E+02, 1.820000E-03},{ 1.3300E+02, 1.820000E-03},{ 1.3400E+02, 1.820000E-03},{ 1.3500E+02, 1.810000E-03},
			{ 1.3600E+02, 1.800000E-03},{ 1.3700E+02, 1.920000E-02},{ 1.3800E+02, 1.850000E-02},{ 1.3900E+02, 2.750000E-01},
			{ 1.4000E+02, 1.750000E-03},{ 1.4100E+02, 1.740000E-03},{ 1.4200E+02, 1.740000E-03},{ 1.4300E+02, 1.730000E-03},
			{ 1.4400E+02, 1.730000E-03},{ 1.4500E+02, 1.730000E-03},{ 1.4600E+02, 1.730000E-03},{ 1.4700E+02, 1.710000E+00},
			{ 1.4800E+02, 1.750000E+00},{ 1.4900E+02, 1.730000E-03},{ 1.5000E+02, 1.730000E-03},{ 1.5100E+02, 1.730000E-03},
			{ 1.5200E+02, 1.260000E-01},{ 1.5300E+02, 1.300000E-01},{ 1.5400E+02, 1.700000E-03},{ 1.5500E+02, 1.680000E-03},
			{ 1.5600E+02, 1.670000E-03},{ 1.5700E+02, 1.650000E-03},{ 1.5800E+02, 1.640000E-03},{ 1.5900E+02, 1.640000E-03},
			{ 1.6000E+02, 1.630000E-03},{ 1.6100E+02, 1.630000E-03},{ 1.6200E+02, 1.630000E-03},{ 1.6300E+02, 1.620000E-03},
			{ 1.6400E+02, 1.600000E-03},{ 1.6500E+02, 1.600000E-03},{ 1.6600E+02, 1.600000E-03},{ 1.6700E+02, 1.590000E-03},
			{ 1.6800E+02, 5.300000E-02},{ 1.6900E+02, 4.930000E-02},{ 1.7000E+02, 6.920000E-01},{ 1.7100E+02, 1.550000E-03},
			{ 1.7200E+02, 1.540000E-03},{ 1.7300E+02, 2.150000E-01},{ 1.7400E+02, 1.720000E-01},{ 1.7500E+02, 9.270000E-01},
			{ 1.7600E+02, 1.490000E-03},{ 1.7700E+02, 1.480000E-03},{ 1.7800E+02, 1.480000E-03},{ 1.7900E+02, 1.480000E-03},
			{ 1.8000E+02, 1.860000E-03},{ 1.8100E+02, 1.850000E-03},{ 1.8200E+02, 1.830000E-03},{ 1.8300E+02, 1.420000E-01},
			{ 1.8400E+02, 1.410000E-01},{ 1.8500E+02, 2.560000E+00},{ 1.8600E+02, 8.480000E-01},{ 1.8700E+02, 6.690000E-02},
			{ 1.8800E+02, 6.720000E-03},{ 1.8900E+02, 6.630000E-03},{ 1.9000E+02, 1.570000E-02},{ 1.9100E+02, 1.060000E-01},
			{ 1.9200E+02, 1.780000E-01},{ 1.9300E+02, 9.890000E-02},{ 1.9400E+02, 1.270000E-01},{ 1.9500E+02, 1.970000E-03},
			{ 1.9600E+02, 1.960000E-03},{ 1.9700E+02, 1.960000E-03},{ 1.9800E+02, 1.960000E-03},{ 1.9900E+02, 1.960000E-03},
			{ 2.0000E+02, 1.970000E-03},{ 2.0100E+02, 1.970000E-03},{ 2.0200E+02, 2.390000E-01},{ 2.0300E+02, 1.100000E-01},
			{ 2.0400E+02, 1.190000E-02},{ 2.0500E+02, 4.260000E-03},{ 2.0600E+02, 5.660000E-03},{ 2.0700E+02, 4.320000E-02},
			{ 2.0800E+02, 6.410000E-02},{ 2.0900E+02, 5.100000E-02},{ 2.1000E+02, 2.460000E-02},{ 2.1100E+02, 4.950000E-02},
			{ 2.1200E+02, 1.950000E-03},{ 2.1300E+02, 1.950000E-03},{ 2.1400E+02, 1.950000E-03},{ 2.1500E+02, 1.950000E-03},
			{ 2.1600E+02, 1.940000E-03},{ 2.1700E+02, 1.930000E-03},{ 2.1800E+02, 1.920000E-03},{ 2.1900E+02, 1.900000E-03},
			{ 2.2000E+02, 1.850000E-02},{ 2.2100E+02, 1.450000E-02},{ 2.2200E+02, 5.430000E-02},{ 2.2300E+02, 1.860000E-03},
			{ 2.2400E+02, 1.850000E-03},{ 2.2500E+02, 1.850000E-03},{ 2.2600E+02, 1.270000E+00},{ 2.2700E+02, 3.740000E-03},
			{ 2.2800E+02, 6.250000E-03},{ 2.2900E+02, 1.890000E-03},{ 2.3000E+02, 1.880000E-03},{ 2.3100E+02, 1.050000E-01},
			{ 2.3200E+02, 5.790000E-03},{ 2.3300E+02, 8.570000E-03},{ 2.3400E+02, 1.850000E-03},{ 2.3500E+02, 1.840000E-03},
			{ 2.3600E+02, 1.840000E-03},{ 2.3700E+02, 1.820000E-03},{ 2.3800E+02, 1.810000E-03},{ 2.3900E+02, 7.410000E-02},
			{ 2.4000E+02, 7.860000E-02},{ 2.4100E+02, 1.800000E-03},{ 2.4200E+02, 1.800000E-03},{ 2.4300E+02, 1.800000E-03},
			{ 2.4400E+02, 1.780000E-03},{ 2.4500E+02, 1.760000E-03},{ 2.4600E+02, 1.740000E-03},{ 2.4700E+02, 5.120000E-02},
			{ 2.4800E+02, 5.080000E-02},{ 2.4900E+02, 1.360000E+00},{ 2.5000E+02, 1.690000E-03},{ 2.5100E+02, 1.690000E-03},
			{ 2.5200E+02, 1.680000E-03},{ 2.5300E+02, 1.670000E-03},{ 2.5400E+02, 1.660000E-03},{ 2.5500E+02, 1.640000E-03},
			{ 2.5600E+02, 8.690000E-01},{ 2.5700E+02, 8.830000E-01},{ 2.5800E+02, 1.620000E-03},{ 2.5900E+02, 1.620000E-03},
			{ 2.6000E+02, 1.040000E-01},{ 2.6100E+02, 9.640000E-02},{ 2.6200E+02, 1.590000E-01},{ 2.6300E+02, 1.600000E-01},
			{ 2.6400E+02, 1.550000E-03},{ 2.6500E+02, 1.530000E-03},{ 2.6600E+02, 1.140000E+00},{ 2.6700E+02, 2.120000E-03},
			{ 2.6800E+02, 2.700000E-03},{ 2.6900E+02, 8.560000E-03},{ 2.7000E+02, 1.540000E-03},{ 2.7100E+02, 1.520000E-03},
			{ 2.7200E+02, 1.510000E-03},{ 2.7300E+02, 1.490000E-03},{ 2.7400E+02, 1.480000E-03},{ 2.7500E+02, 2.920000E-01},
			{ 2.7600E+02, 1.150000E-01},{ 2.7700E+02, 1.460000E-03},{ 2.7800E+02, 3.060000E-03},{ 2.7900E+02, 3.710000E-03},
			{ 2.8000E+02, 1.420000E-03},{ 2.8100E+02, 1.420000E-03},{ 2.8200E+02, 1.410000E-03},{ 2.8300E+02, 1.400000E-03},
			{ 2.8400E+02, 1.400000E-03},{ 2.8500E+02, 1.390000E-03},{ 2.8600E+02, 5.010000E-02},{ 2.8700E+02, 3.750000E-02},
			{ 2.8800E+02, 1.500000E-02},{ 2.8900E+02, 7.950000E-03},{ 2.9000E+02, 3.570000E-03},{ 2.9100E+02, 4.440000E-03},
			{ 2.9200E+02, 1.380000E-03},{ 2.9300E+02, 1.380000E-03},{ 2.9400E+02, 1.380000E-03},{ 2.9500E+02, 1.380000E-03},
			{ 2.9600E+02, 1.380000E-03},{ 2.9700E+02, 4.820000E-01},{ 2.9800E+02, 5.170000E-01},{ 2.9900E+02, 1.380000E-03},
			{ 3.0000E+02, 5.760000E-01},{ 3.0100E+02, 6.150000E-01},{ 3.0200E+02, 1.390000E-03},{ 3.0300E+02, 1.390000E-03},
			{ 3.0400E+02, 1.390000E-03},{ 3.0500E+02, 1.390000E-03},{ 3.0600E+02, 1.390000E-03},{ 3.0700E+02, 1.390000E-03},
			{ 3.0800E+02, 1.390000E-03},{ 3.0900E+02, 1.390000E-03},{ 3.1000E+02, 1.390000E-03},{ 3.1100E+02, 1.390000E-03},
			{ 3.1200E+02, 1.390000E-03},{ 3.1300E+02, 6.770000E-01},{ 3.1400E+02, 7.310000E-02},{ 3.1500E+02, 9.080000E-03},
			{ 3.1600E+02, 9.510000E-03},{ 3.1700E+02, 4.440000E-02},{ 3.1800E+02, 1.450000E-03},{ 3.1900E+02, 1.450000E-03},
			{ 3.2000E+02, 1.450000E-03},{ 3.2100E+02, 1.450000E-03},{ 3.2200E+02, 1.450000E-03},{ 3.2300E+02, 1.450000E-03},
			{ 3.2400E+02, 1.450000E-03},{ 3.2500E+02, 1.540000E-02},{ 3.2600E+02, 7.400000E-03},{ 3.2700E+02, 1.300000E-02},
			{ 3.2800E+02, 1.440000E-03},{ 3.2900E+02, 1.450000E-03},{ 3.3000E+02, 1.450000E-03},{ 3.3100E+02, 1.450000E-03},
			{ 3.3200E+02, 1.450000E-03},{ 3.3300E+02, 1.450000E-03},{ 3.3400E+02, 3.180000E-02},{ 3.3500E+02, 1.350000E-02},
			{ 3.3600E+02, 7.320000E-03},{ 3.3700E+02, 6.770000E-03},{ 3.3800E+02, 1.730000E-02},{ 3.3900E+02, 1.460000E-03},
			{ 3.4000E+02, 1.470000E-03},{ 3.4100E+02, 1.470000E-03},{ 3.4200E+02, 2.570000E-01},{ 3.4300E+02, 1.970000E-03},
			{ 3.4400E+02, 2.610000E-03},{ 3.4500E+02, 1.500000E-03},{ 3.4600E+02, 3.170000E-01},{ 3.4700E+02, 4.220000E-03},
			{ 3.4800E+02, 7.330000E-03},{ 3.4900E+02, 5.100000E-02},{ 3.5000E+02, 1.530000E-03},{ 3.5100E+02, 1.530000E-03},
			{ 3.5200E+02, 1.530000E-03},{ 3.5300E+02, 1.540000E-03},{ 3.5400E+02, 5.230000E-01},{ 3.5500E+02, 3.180000E-01},
			{ 3.5600E+02, 1.560000E-03},{ 3.5700E+02, 6.180000E-03},{ 3.5800E+02, 8.780000E-03},{ 3.5900E+02, 1.570000E-03},
			{ 3.6000E+02, 1.570000E-03},{ 3.6100E+02, 3.710000E-01},{ 3.6200E+02, 1.950000E-03},{ 3.6300E+02, 2.670000E-03},
			{ 3.6400E+02, 1.670000E-02},{ 3.6500E+02, 1.580000E-03}, };
		return SL::Graph( 0, x, 365, g); 
	}

	inline double Graph11(double x) { 
		static double g[364][2] = {
			{ 0.0000E+00, 0.000000E+00},{ 1.0100E+00, 0.000000E+00},{ 2.0100E+00, 0.000000E+00},{ 3.0200E+00, 0.000000E+00},
			{ 4.0200E+00, 0.000000E+00},{ 5.0300E+00, 0.000000E+00},{ 6.0300E+00, 0.000000E+00},{ 7.0400E+00, 0.000000E+00},
			{ 8.0400E+00, 0.000000E+00},{ 9.0500E+00, 0.000000E+00},{ 1.0100E+01, 0.000000E+00},{ 1.1100E+01, 0.000000E+00},
			{ 1.2100E+01, 0.000000E+00},{ 1.3100E+01, 0.000000E+00},{ 1.4100E+01, 0.000000E+00},{ 1.5100E+01, 0.000000E+00},
			{ 1.6100E+01, 0.000000E+00},{ 1.7100E+01, 0.000000E+00},{ 1.8100E+01, 0.000000E+00},{ 1.9100E+01, 0.000000E+00},
			{ 2.0100E+01, 0.000000E+00},{ 2.1100E+01, 0.000000E+00},{ 2.2100E+01, 0.000000E+00},{ 2.3100E+01, 0.000000E+00},
			{ 2.4100E+01, 0.000000E+00},{ 2.5100E+01, 0.000000E+00},{ 2.6100E+01, 0.000000E+00},{ 2.7100E+01, 0.000000E+00},
			{ 2.8200E+01, 0.000000E+00},{ 2.9200E+01, 0.000000E+00},{ 3.0200E+01, 0.000000E+00},{ 3.1200E+01, 0.000000E+00},
			{ 3.2200E+01, 0.000000E+00},{ 3.3200E+01, 0.000000E+00},{ 3.4200E+01, 0.000000E+00},{ 3.5200E+01, 0.000000E+00},
			{ 3.6200E+01, 0.000000E+00},{ 3.7200E+01, 0.000000E+00},{ 3.8200E+01, 0.000000E+00},{ 3.9200E+01, 0.000000E+00},
			{ 4.0200E+01, 0.000000E+00},{ 4.1200E+01, 0.000000E+00},{ 4.2200E+01, 0.000000E+00},{ 4.3200E+01, 0.000000E+00},
			{ 4.4200E+01, 0.000000E+00},{ 4.5200E+01, 0.000000E+00},{ 4.6300E+01, 0.000000E+00},{ 4.7300E+01, 0.000000E+00},
			{ 4.8300E+01, 0.000000E+00},{ 4.9300E+01, 0.000000E+00},{ 5.0300E+01, 0.000000E+00},{ 5.1300E+01, 0.000000E+00},
			{ 5.2300E+01, 0.000000E+00},{ 5.3300E+01, 0.000000E+00},{ 5.4300E+01, 0.000000E+00},{ 5.5300E+01, 0.000000E+00},
			{ 5.6300E+01, 0.000000E+00},{ 5.7300E+01, 0.000000E+00},{ 5.8300E+01, 0.000000E+00},{ 5.9300E+01, 0.000000E+00},
			{ 6.0300E+01, 0.000000E+00},{ 6.1300E+01, 0.000000E+00},{ 6.2300E+01, 0.000000E+00},{ 6.3300E+01, 0.000000E+00},
			{ 6.4400E+01, 0.000000E+00},{ 6.5400E+01, 0.000000E+00},{ 6.6400E+01, 0.000000E+00},{ 6.7400E+01, 0.000000E+00},
			{ 6.8400E+01, 0.000000E+00},{ 6.9400E+01, 0.000000E+00},{ 7.0400E+01, 0.000000E+00},{ 7.1400E+01, 0.000000E+00},
			{ 7.2400E+01, 0.000000E+00},{ 7.3400E+01, 0.000000E+00},{ 7.4400E+01, 0.000000E+00},{ 7.5400E+01, 0.000000E+00},
			{ 7.6400E+01, 0.000000E+00},{ 7.7400E+01, 0.000000E+00},{ 7.8400E+01, 0.000000E+00},{ 7.9400E+01, 0.000000E+00},
			{ 8.0400E+01, 0.000000E+00},{ 8.1400E+01, 0.000000E+00},{ 8.2500E+01, 0.000000E+00},{ 8.3500E+01, 0.000000E+00},
			{ 8.4500E+01, 0.000000E+00},{ 8.5500E+01, 0.000000E+00},{ 8.6500E+01, 0.000000E+00},{ 8.7500E+01, 0.000000E+00},
			{ 8.8500E+01, 0.000000E+00},{ 8.9500E+01, 0.000000E+00},{ 9.0500E+01, 0.000000E+00},{ 9.1500E+01, 0.000000E+00},
			{ 9.2500E+01, 0.000000E+00},{ 9.3500E+01, 0.000000E+00},{ 9.4500E+01, 0.000000E+00},{ 9.5500E+01, 0.000000E+00},
			{ 9.6500E+01, 0.000000E+00},{ 9.7500E+01, 0.000000E+00},{ 9.8500E+01, 0.000000E+00},{ 9.9500E+01, 0.000000E+00},
			{ 1.0100E+02, 0.000000E+00},{ 1.0200E+02, 0.000000E+00},{ 1.0300E+02, 0.000000E+00},{ 1.0400E+02, 0.000000E+00},
			{ 1.0500E+02, 0.000000E+00},{ 1.0600E+02, 0.000000E+00},{ 1.0700E+02, 0.000000E+00},{ 1.0800E+02, 0.000000E+00},
			{ 1.0900E+02, 0.000000E+00},{ 1.1000E+02, 0.000000E+00},{ 1.1100E+02, 0.000000E+00},{ 1.1200E+02, 0.000000E+00},
			{ 1.1300E+02, 0.000000E+00},{ 1.1400E+02, 0.000000E+00},{ 1.1500E+02, 0.000000E+00},{ 1.1600E+02, 0.000000E+00},
			{ 1.1700E+02, 0.000000E+00},{ 1.1800E+02, 0.000000E+00},{ 1.1900E+02, 0.000000E+00},{ 1.2000E+02, 0.000000E+00},
			{ 1.2100E+02, 0.000000E+00},{ 1.2200E+02, 0.000000E+00},{ 1.2300E+02, 0.000000E+00},{ 1.2400E+02, 0.000000E+00},
			{ 1.2500E+02, 0.000000E+00},{ 1.2600E+02, 0.000000E+00},{ 1.2700E+02, 0.000000E+00},{ 1.2800E+02, 0.000000E+00},
			{ 1.2900E+02, 0.000000E+00},{ 1.3000E+02, 0.000000E+00},{ 1.3100E+02, 0.000000E+00},{ 1.3200E+02, 0.000000E+00},
			{ 1.3300E+02, 0.000000E+00},{ 1.3400E+02, 0.000000E+00},{ 1.3500E+02, 0.000000E+00},{ 1.3600E+02, 0.000000E+00},
			{ 1.3700E+02, 0.000000E+00},{ 1.3800E+02, 0.000000E+00},{ 1.3900E+02, 0.000000E+00},{ 1.4000E+02, 0.000000E+00},
			{ 1.4100E+02, 0.000000E+00},{ 1.4200E+02, 0.000000E+00},{ 1.4300E+02, 0.000000E+00},{ 1.4400E+02, 0.000000E+00},
			{ 1.4500E+02, 0.000000E+00},{ 1.4600E+02, 0.000000E+00},{ 1.4700E+02, 0.000000E+00},{ 1.4800E+02, 0.000000E+00},
			{ 1.4900E+02, 0.000000E+00},{ 1.5000E+02, 0.000000E+00},{ 1.5100E+02, 0.000000E+00},{ 1.5200E+02, 0.000000E+00},
			{ 1.5300E+02, 0.000000E+00},{ 1.5400E+02, 0.000000E+00},{ 1.5500E+02, 0.000000E+00},{ 1.5600E+02, 0.000000E+00},
			{ 1.5700E+02, 0.000000E+00},{ 1.5800E+02, 0.000000E+00},{ 1.5900E+02, 0.000000E+00},{ 1.6000E+02, 0.000000E+00},
			{ 1.6100E+02, 0.000000E+00},{ 1.6200E+02, 0.000000E+00},{ 1.6300E+02, 0.000000E+00},{ 1.6400E+02, 0.000000E+00},
			{ 1.6500E+02, 0.000000E+00},{ 1.6600E+02, 0.000000E+00},{ 1.6700E+02, 0.000000E+00},{ 1.6800E+02, 0.000000E+00},
			{ 1.6900E+02, 0.000000E+00},{ 1.7000E+02, 0.000000E+00},{ 1.7100E+02, 0.000000E+00},{ 1.7200E+02, 0.000000E+00},
			{ 1.7300E+02, 0.000000E+00},{ 1.7400E+02, 0.000000E+00},{ 1.7500E+02, 0.000000E+00},{ 1.7600E+02, 0.000000E+00},
			{ 1.7700E+02, 0.000000E+00},{ 1.7800E+02, 0.000000E+00},{ 1.7900E+02, 0.000000E+00},{ 1.8000E+02, 0.000000E+00},
			{ 1.8100E+02, 0.000000E+00},{ 1.8200E+02, 0.000000E+00},{ 1.8300E+02, 0.000000E+00},{ 1.8400E+02, 0.000000E+00},
			{ 1.8500E+02, 0.000000E+00},{ 1.8600E+02, 0.000000E+00},{ 1.8700E+02, 0.000000E+00},{ 1.8800E+02, 0.000000E+00},
			{ 1.8900E+02, 0.000000E+00},{ 1.9000E+02, 0.000000E+00},{ 1.9100E+02, 0.000000E+00},{ 1.9200E+02, 0.000000E+00},
			{ 1.9300E+02, 0.000000E+00},{ 1.9400E+02, 0.000000E+00},{ 1.9500E+02, 0.000000E+00},{ 1.9600E+02, 0.000000E+00},
			{ 1.9700E+02, 0.000000E+00},{ 1.9800E+02, 0.000000E+00},{ 1.9900E+02, 0.000000E+00},{ 2.0000E+02, 0.000000E+00},
			{ 2.0100E+02, 0.000000E+00},{ 2.0200E+02, 0.000000E+00},{ 2.0300E+02, 0.000000E+00},{ 2.0400E+02, 0.000000E+00},
			{ 2.0500E+02, 0.000000E+00},{ 2.0600E+02, 0.000000E+00},{ 2.0700E+02, 0.000000E+00},{ 2.0800E+02, 0.000000E+00},
			{ 2.0900E+02, 0.000000E+00},{ 2.1000E+02, 0.000000E+00},{ 2.1100E+02, 0.000000E+00},{ 2.1200E+02, 0.000000E+00},
			{ 2.1300E+02, 0.000000E+00},{ 2.1400E+02, 0.000000E+00},{ 2.1500E+02, 0.000000E+00},{ 2.1600E+02, 0.000000E+00},
			{ 2.1700E+02, 0.000000E+00},{ 2.1800E+02, 0.000000E+00},{ 2.1900E+02, 0.000000E+00},{ 2.2000E+02, 0.000000E+00},
			{ 2.2100E+02, 0.000000E+00},{ 2.2200E+02, 0.000000E+00},{ 2.2300E+02, 0.000000E+00},{ 2.2400E+02, 0.000000E+00},
			{ 2.2500E+02, 0.000000E+00},{ 2.2600E+02, 0.000000E+00},{ 2.2700E+02, 0.000000E+00},{ 2.2800E+02, 0.000000E+00},
			{ 2.2900E+02, 0.000000E+00},{ 2.3000E+02, 0.000000E+00},{ 2.3100E+02, 0.000000E+00},{ 2.3200E+02, 0.000000E+00},
			{ 2.3300E+02, 0.000000E+00},{ 2.3400E+02, 0.000000E+00},{ 2.3500E+02, 0.000000E+00},{ 2.3600E+02, 0.000000E+00},
			{ 2.3700E+02, 0.000000E+00},{ 2.3800E+02, 0.000000E+00},{ 2.3900E+02, 0.000000E+00},{ 2.4000E+02, 0.000000E+00},
			{ 2.4100E+02, 0.000000E+00},{ 2.4200E+02, 0.000000E+00},{ 2.4300E+02, 0.000000E+00},{ 2.4400E+02, 0.000000E+00},
			{ 2.4500E+02, 0.000000E+00},{ 2.4600E+02, 0.000000E+00},{ 2.4700E+02, 0.000000E+00},{ 2.4800E+02, 0.000000E+00},
			{ 2.4900E+02, 0.000000E+00},{ 2.5000E+02, 0.000000E+00},{ 2.5100E+02, 0.000000E+00},{ 2.5200E+02, 0.000000E+00},
			{ 2.5300E+02, 0.000000E+00},{ 2.5400E+02, 0.000000E+00},{ 2.5500E+02, 0.000000E+00},{ 2.5600E+02, 0.000000E+00},
			{ 2.5700E+02, 0.000000E+00},{ 2.5800E+02, 0.000000E+00},{ 2.5900E+02, 0.000000E+00},{ 2.6000E+02, 0.000000E+00},
			{ 2.6100E+02, 0.000000E+00},{ 2.6200E+02, 0.000000E+00},{ 2.6300E+02, 0.000000E+00},{ 2.6400E+02, 0.000000E+00},
			{ 2.6500E+02, 0.000000E+00},{ 2.6600E+02, 0.000000E+00},{ 2.6700E+02, 0.000000E+00},{ 2.6800E+02, 0.000000E+00},
			{ 2.6900E+02, 0.000000E+00},{ 2.7000E+02, 0.000000E+00},{ 2.7100E+02, 0.000000E+00},{ 2.7200E+02, 0.000000E+00},
			{ 2.7300E+02, 0.000000E+00},{ 2.7500E+02, 0.000000E+00},{ 2.7600E+02, 0.000000E+00},{ 2.7700E+02, 0.000000E+00},
			{ 2.7800E+02, 0.000000E+00},{ 2.7900E+02, 0.000000E+00},{ 2.8000E+02, 0.000000E+00},{ 2.8100E+02, 0.000000E+00},
			{ 2.8200E+02, 0.000000E+00},{ 2.8300E+02, 0.000000E+00},{ 2.8400E+02, 0.000000E+00},{ 2.8500E+02, 0.000000E+00},
			{ 2.8600E+02, 0.000000E+00},{ 2.8700E+02, 0.000000E+00},{ 2.8800E+02, 0.000000E+00},{ 2.8900E+02, 0.000000E+00},
			{ 2.9000E+02, 0.000000E+00},{ 2.9100E+02, 0.000000E+00},{ 2.9200E+02, 0.000000E+00},{ 2.9300E+02, 0.000000E+00},
			{ 2.9400E+02, 0.000000E+00},{ 2.9500E+02, 0.000000E+00},{ 2.9600E+02, 0.000000E+00},{ 2.9700E+02, 0.000000E+00},
			{ 2.9800E+02, 0.000000E+00},{ 2.9900E+02, 0.000000E+00},{ 3.0000E+02, 0.000000E+00},{ 3.0100E+02, 0.000000E+00},
			{ 3.0200E+02, 0.000000E+00},{ 3.0300E+02, 0.000000E+00},{ 3.0400E+02, 0.000000E+00},{ 3.0500E+02, 0.000000E+00},
			{ 3.0600E+02, 0.000000E+00},{ 3.0700E+02, 0.000000E+00},{ 3.0800E+02, 0.000000E+00},{ 3.0900E+02, 0.000000E+00},
			{ 3.1000E+02, 0.000000E+00},{ 3.1100E+02, 0.000000E+00},{ 3.1200E+02, 0.000000E+00},{ 3.1300E+02, 0.000000E+00},
			{ 3.1400E+02, 0.000000E+00},{ 3.1500E+02, 0.000000E+00},{ 3.1600E+02, 0.000000E+00},{ 3.1700E+02, 0.000000E+00},
			{ 3.1800E+02, 0.000000E+00},{ 3.1900E+02, 0.000000E+00},{ 3.2000E+02, 0.000000E+00},{ 3.2100E+02, 0.000000E+00},
			{ 3.2200E+02, 0.000000E+00},{ 3.2300E+02, 0.000000E+00},{ 3.2400E+02, 0.000000E+00},{ 3.2500E+02, 0.000000E+00},
			{ 3.2600E+02, 0.000000E+00},{ 3.2700E+02, 0.000000E+00},{ 3.2800E+02, 0.000000E+00},{ 3.2900E+02, 0.000000E+00},
			{ 3.3000E+02, 0.000000E+00},{ 3.3100E+02, 0.000000E+00},{ 3.3200E+02, 0.000000E+00},{ 3.3300E+02, 0.000000E+00},
			{ 3.3400E+02, 0.000000E+00},{ 3.3500E+02, 0.000000E+00},{ 3.3600E+02, 0.000000E+00},{ 3.3700E+02, 0.000000E+00},
			{ 3.3800E+02, 0.000000E+00},{ 3.3900E+02, 0.000000E+00},{ 3.4000E+02, 0.000000E+00},{ 3.4100E+02, 0.000000E+00},
			{ 3.4200E+02, 0.000000E+00},{ 3.4300E+02, 0.000000E+00},{ 3.4400E+02, 0.000000E+00},{ 3.4500E+02, 0.000000E+00},
			{ 3.4600E+02, 0.000000E+00},{ 3.4700E+02, 0.000000E+00},{ 3.4800E+02, 0.000000E+00},{ 3.4900E+02, 0.000000E+00},
			{ 3.5000E+02, 0.000000E+00},{ 3.5100E+02, 0.000000E+00},{ 3.5200E+02, 0.000000E+00},{ 3.5300E+02, 0.000000E+00},
			{ 3.5400E+02, 0.000000E+00},{ 3.5500E+02, 0.000000E+00},{ 3.5600E+02, 0.000000E+00},{ 3.5700E+02, 0.000000E+00},
			{ 3.5800E+02, 0.000000E+00},{ 3.5900E+02, 0.000000E+00},{ 3.6000E+02, 0.000000E+00},{ 3.6100E+02, 0.000000E+00},
			{ 3.6200E+02, 0.000000E+00},{ 3.6300E+02, 0.000000E+00},{ 3.6400E+02, 0.000000E+00},{ 3.6500E+02, 0.000000E+00},
			 };
		return SL::Graph( 0, x, 363, g); 
	}

	inline double Graph12(double x) { 
		static double g[364][2] = {
			{ 0.0000E+00, 2.920000E-04},{ 1.0000E+00, 1.230000E-03},{ 2.0000E+00, 2.400000E-03},{ 3.0000E+00, 3.590000E-03},
			{ 4.0000E+00, 4.740000E-03},{ 5.0000E+00, 5.810000E-03},{ 6.0000E+00, 6.820000E-03},{ 7.0000E+00, 7.750000E-03},
			{ 8.0000E+00, 8.600000E-03},{ 9.0000E+00, 9.380000E-03},{ 1.0000E+01, 1.010000E-02},{ 1.1000E+01, 1.080000E-02},
			{ 1.2000E+01, 1.140000E-02},{ 1.3000E+01, 1.200000E-02},{ 1.4000E+01, 1.250000E-02},{ 1.5000E+01, 1.290000E-02},
			{ 1.6000E+01, 1.340000E-02},{ 1.7000E+01, 1.370000E-02},{ 1.8000E+01, 1.400000E-02},{ 1.9000E+01, 1.430000E-02},
			{ 2.0000E+01, 1.450000E-02},{ 2.1000E+01, 1.460000E-02},{ 2.2000E+01, 1.470000E-02},{ 2.3000E+01, 1.480000E-02},
			{ 2.4000E+01, 1.490000E-02},{ 2.5000E+01, 1.490000E-02},{ 2.6000E+01, 1.480000E-02},{ 2.7000E+01, 1.480000E-02},
			{ 2.8000E+01, 1.470000E-02},{ 2.9000E+01, 1.460000E-02},{ 3.0000E+01, 1.450000E-02},{ 3.1000E+01, 1.430000E-02},
			{ 3.2000E+01, 1.420000E-02},{ 3.3000E+01, 1.400000E-02},{ 3.4000E+01, 1.380000E-02},{ 3.5000E+01, 1.350000E-02},
			{ 3.6000E+01, 1.330000E-02},{ 3.7000E+01, 1.310000E-02},{ 3.8000E+01, 1.280000E-02},{ 3.9000E+01, 1.250000E-02},
			{ 4.0000E+01, 1.230000E-02},{ 4.1000E+01, 1.200000E-02},{ 4.2000E+01, 1.170000E-02},{ 4.3000E+01, 1.140000E-02},
			{ 4.4000E+01, 1.110000E-02},{ 4.5000E+01, 1.080000E-02},{ 4.6000E+01, 1.050000E-02},{ 4.7000E+01, 1.020000E-02},
			{ 4.8000E+01, 9.870000E-03},{ 4.9000E+01, 9.580000E-03},{ 5.0000E+01, 9.290000E-03},{ 5.1000E+01, 9.000000E-03},
			{ 5.2000E+01, 8.720000E-03},{ 5.3000E+01, 8.430000E-03},{ 5.4000E+01, 8.150000E-03},{ 5.5000E+01, 7.870000E-03},
			{ 5.6000E+01, 7.590000E-03},{ 5.7000E+01, 7.320000E-03},{ 5.8000E+01, 7.060000E-03},{ 5.9000E+01, 6.800000E-03},
			{ 6.0000E+01, 6.560000E-03},{ 6.1000E+01, 6.320000E-03},{ 6.2000E+01, 6.100000E-03},{ 6.3000E+01, 5.900000E-03},
			{ 6.4000E+01, 5.700000E-03},{ 6.5000E+01, 5.510000E-03},{ 6.6000E+01, 5.330000E-03},{ 6.7000E+01, 5.140000E-03},
			{ 6.8000E+01, 4.960000E-03},{ 6.9000E+01, 4.790000E-03},{ 7.0000E+01, 4.610000E-03},{ 7.1000E+01, 4.450000E-03},
			{ 7.2000E+01, 4.290000E-03},{ 7.3000E+01, 4.150000E-03},{ 7.4000E+01, 4.010000E-03},{ 7.5000E+01, 3.870000E-03},
			{ 7.6000E+01, 3.760000E-03},{ 7.7000E+01, 3.670000E-03},{ 7.8000E+01, 3.570000E-03},{ 7.9000E+01, 3.480000E-03},
			{ 8.0000E+01, 3.390000E-03},{ 8.1000E+01, 3.320000E-03},{ 8.2000E+01, 3.280000E-03},{ 8.3000E+01, 3.240000E-03},
			{ 8.4000E+01, 3.210000E-03},{ 8.5000E+01, 3.170000E-03},{ 8.6000E+01, 3.140000E-03},{ 8.7000E+01, 3.110000E-03},
			{ 8.8000E+01, 3.090000E-03},{ 8.9000E+01, 3.090000E-03},{ 9.0000E+01, 3.080000E-03},{ 9.1000E+01, 3.060000E-03},
			{ 9.2000E+01, 3.040000E-03},{ 9.3000E+01, 3.010000E-03},{ 9.4000E+01, 2.980000E-03},{ 9.5000E+01, 2.950000E-03},
			{ 9.6000E+01, 2.910000E-03},{ 9.7000E+01, 2.870000E-03},{ 9.8000E+01, 2.830000E-03},{ 9.9000E+01, 2.780000E-03},
			{ 1.0000E+02, 2.730000E-03},{ 1.0100E+02, 2.680000E-03},{ 1.0200E+02, 2.630000E-03},{ 1.0300E+02, 2.600000E-03},
			{ 1.0400E+02, 2.570000E-03},{ 1.0500E+02, 2.550000E-03},{ 1.0600E+02, 2.530000E-03},{ 1.0700E+02, 2.510000E-03},
			{ 1.0800E+02, 2.490000E-03},{ 1.0900E+02, 2.460000E-03},{ 1.1000E+02, 2.430000E-03},{ 1.1100E+02, 2.400000E-03},
			{ 1.1200E+02, 2.370000E-03},{ 1.1300E+02, 2.340000E-03},{ 1.1400E+02, 2.310000E-03},{ 1.1500E+02, 2.280000E-03},
			{ 1.1600E+02, 2.240000E-03},{ 1.1700E+02, 2.220000E-03},{ 1.1800E+02, 2.200000E-03},{ 1.1900E+02, 2.190000E-03},
			{ 1.2000E+02, 2.180000E-03},{ 1.2100E+02, 2.170000E-03},{ 1.2200E+02, 2.160000E-03},{ 1.2300E+02, 2.140000E-03},
			{ 1.2400E+02, 2.120000E-03},{ 1.2500E+02, 2.120000E-03},{ 1.2600E+02, 2.120000E-03},{ 1.2700E+02, 2.120000E-03},
			{ 1.2800E+02, 2.110000E-03},{ 1.2900E+02, 2.110000E-03},{ 1.3000E+02, 2.100000E-03},{ 1.3100E+02, 2.090000E-03},
			{ 1.3200E+02, 2.070000E-03},{ 1.3300E+02, 2.050000E-03},{ 1.3400E+02, 2.030000E-03},{ 1.3500E+02, 2.010000E-03},
			{ 1.3600E+02, 1.980000E-03},{ 1.3700E+02, 1.980000E-03},{ 1.3800E+02, 1.980000E-03},{ 1.3900E+02, 1.990000E-03},
			{ 1.4000E+02, 1.990000E-03},{ 1.4100E+02, 1.990000E-03},{ 1.4200E+02, 1.980000E-03},{ 1.4300E+02, 1.970000E-03},
			{ 1.4400E+02, 1.950000E-03},{ 1.4500E+02, 1.930000E-03},{ 1.4600E+02, 1.910000E-03},{ 1.4700E+02, 1.880000E-03},
			{ 1.4800E+02, 1.850000E-03},{ 1.4900E+02, 1.820000E-03},{ 1.5000E+02, 1.790000E-03},{ 1.5100E+02, 1.760000E-03},
			{ 1.5200E+02, 1.730000E-03},{ 1.5300E+02, 1.710000E-03},{ 1.5400E+02, 1.690000E-03},{ 1.5500E+02, 1.660000E-03},
			{ 1.5600E+02, 1.630000E-03},{ 1.5700E+02, 1.600000E-03},{ 1.5800E+02, 1.570000E-03},{ 1.5900E+02, 1.540000E-03},
			{ 1.6000E+02, 1.500000E-03},{ 1.6100E+02, 1.470000E-03},{ 1.6200E+02, 1.430000E-03},{ 1.6300E+02, 1.390000E-03},
			{ 1.6400E+02, 1.350000E-03},{ 1.6500E+02, 1.310000E-03},{ 1.6600E+02, 1.270000E-03},{ 1.6700E+02, 1.230000E-03},
			{ 1.6800E+02, 1.220000E-03},{ 1.6900E+02, 1.220000E-03},{ 1.7000E+02, 1.220000E-03},{ 1.7100E+02, 1.220000E-03},
			{ 1.7200E+02, 1.220000E-03},{ 1.7300E+02, 1.220000E-03},{ 1.7400E+02, 1.230000E-03},{ 1.7500E+02, 1.240000E-03},
			{ 1.7600E+02, 1.240000E-03},{ 1.7700E+02, 1.240000E-03},{ 1.7800E+02, 1.230000E-03},{ 1.7900E+02, 1.230000E-03},
			{ 1.8000E+02, 1.220000E-03},{ 1.8100E+02, 1.200000E-03},{ 1.8200E+02, 1.190000E-03},{ 1.8300E+02, 1.190000E-03},
			{ 1.8400E+02, 1.200000E-03},{ 1.8500E+02, 1.210000E-03},{ 1.8600E+02, 1.210000E-03},{ 1.8700E+02, 1.220000E-03},
			{ 1.8800E+02, 1.230000E-03},{ 1.8900E+02, 1.250000E-03},{ 1.9000E+02, 1.270000E-03},{ 1.9100E+02, 1.290000E-03},
			{ 1.9200E+02, 1.310000E-03},{ 1.9300E+02, 1.320000E-03},{ 1.9400E+02, 1.330000E-03},{ 1.9500E+02, 1.340000E-03},
			{ 1.9600E+02, 1.340000E-03},{ 1.9700E+02, 1.340000E-03},{ 1.9800E+02, 1.330000E-03},{ 1.9900E+02, 1.330000E-03},
			{ 2.0000E+02, 1.320000E-03},{ 2.0100E+02, 1.300000E-03},{ 2.0200E+02, 1.290000E-03},{ 2.0300E+02, 1.280000E-03},
			{ 2.0400E+02, 1.280000E-03},{ 2.0500E+02, 1.300000E-03},{ 2.0600E+02, 1.340000E-03},{ 2.0700E+02, 1.370000E-03},
			{ 2.0800E+02, 1.410000E-03},{ 2.0900E+02, 1.440000E-03},{ 2.1000E+02, 1.480000E-03},{ 2.1100E+02, 1.520000E-03},
			{ 2.1200E+02, 1.550000E-03},{ 2.1300E+02, 1.570000E-03},{ 2.1400E+02, 1.590000E-03},{ 2.1500E+02, 1.600000E-03},
			{ 2.1600E+02, 1.600000E-03},{ 2.1700E+02, 1.610000E-03},{ 2.1800E+02, 1.600000E-03},{ 2.1900E+02, 1.600000E-03},
			{ 2.2000E+02, 1.620000E-03},{ 2.2100E+02, 1.660000E-03},{ 2.2200E+02, 1.690000E-03},{ 2.2300E+02, 1.720000E-03},
			{ 2.2400E+02, 1.750000E-03},{ 2.2500E+02, 1.770000E-03},{ 2.2600E+02, 1.780000E-03},{ 2.2700E+02, 1.810000E-03},
			{ 2.2800E+02, 1.840000E-03},{ 2.2900E+02, 1.860000E-03},{ 2.3000E+02, 1.880000E-03},{ 2.3100E+02, 1.900000E-03},
			{ 2.3200E+02, 1.930000E-03},{ 2.3300E+02, 1.970000E-03},{ 2.3400E+02, 2.000000E-03},{ 2.3500E+02, 2.030000E-03},
			{ 2.3600E+02, 2.050000E-03},{ 2.3700E+02, 2.060000E-03},{ 2.3800E+02, 2.070000E-03},{ 2.3900E+02, 2.080000E-03},
			{ 2.4000E+02, 2.090000E-03},{ 2.4100E+02, 2.090000E-03},{ 2.4200E+02, 2.090000E-03},{ 2.4300E+02, 2.080000E-03},
			{ 2.4400E+02, 2.070000E-03},{ 2.4500E+02, 2.050000E-03},{ 2.4600E+02, 2.040000E-03},{ 2.4700E+02, 2.030000E-03},
			{ 2.4800E+02, 2.030000E-03},{ 2.4900E+02, 2.020000E-03},{ 2.5000E+02, 2.020000E-03},{ 2.5100E+02, 2.000000E-03},
			{ 2.5200E+02, 1.990000E-03},{ 2.5300E+02, 1.970000E-03},{ 2.5400E+02, 1.940000E-03},{ 2.5500E+02, 1.920000E-03},
			{ 2.5600E+02, 1.890000E-03},{ 2.5700E+02, 1.860000E-03},{ 2.5800E+02, 1.830000E-03},{ 2.5900E+02, 1.800000E-03},
			{ 2.6000E+02, 1.780000E-03},{ 2.6100E+02, 1.760000E-03},{ 2.6200E+02, 1.740000E-03},{ 2.6300E+02, 1.730000E-03},
			{ 2.6400E+02, 1.710000E-03},{ 2.6500E+02, 1.690000E-03},{ 2.6600E+02, 1.670000E-03},{ 2.6700E+02, 1.680000E-03},
			{ 2.6800E+02, 1.700000E-03},{ 2.6900E+02, 1.720000E-03},{ 2.7000E+02, 1.740000E-03},{ 2.7100E+02, 1.750000E-03},
			{ 2.7200E+02, 1.760000E-03},{ 2.7300E+02, 1.770000E-03},{ 2.7400E+02, 1.770000E-03},{ 2.7500E+02, 1.760000E-03},
			{ 2.7600E+02, 1.760000E-03},{ 2.7700E+02, 1.750000E-03},{ 2.7800E+02, 1.760000E-03},{ 2.7900E+02, 1.790000E-03},
			{ 2.8000E+02, 1.800000E-03},{ 2.8100E+02, 1.820000E-03},{ 2.8200E+02, 1.830000E-03},{ 2.8300E+02, 1.830000E-03},
			{ 2.8400E+02, 1.830000E-03},{ 2.8500E+02, 1.820000E-03},{ 2.8600E+02, 1.820000E-03},{ 2.8700E+02, 1.810000E-03},
			{ 2.8800E+02, 1.820000E-03},{ 2.8900E+02, 1.830000E-03},{ 2.9000E+02, 1.870000E-03},{ 2.9100E+02, 1.910000E-03},
			{ 2.9200E+02, 1.940000E-03},{ 2.9300E+02, 1.970000E-03},{ 2.9400E+02, 1.990000E-03},{ 2.9500E+02, 2.010000E-03},
			{ 2.9600E+02, 2.020000E-03},{ 2.9700E+02, 2.030000E-03},{ 2.9800E+02, 2.030000E-03},{ 2.9900E+02, 2.030000E-03},
			{ 3.0000E+02, 2.020000E-03},{ 3.0100E+02, 2.010000E-03},{ 3.0200E+02, 2.000000E-03},{ 3.0300E+02, 1.980000E-03},
			{ 3.0400E+02, 1.960000E-03},{ 3.0500E+02, 1.930000E-03},{ 3.0600E+02, 1.910000E-03},{ 3.0700E+02, 1.880000E-03},
			{ 3.0800E+02, 1.850000E-03},{ 3.0900E+02, 1.810000E-03},{ 3.1000E+02, 1.780000E-03},{ 3.1100E+02, 1.740000E-03},
			{ 3.1200E+02, 1.700000E-03},{ 3.1300E+02, 1.670000E-03},{ 3.1400E+02, 1.630000E-03},{ 3.1500E+02, 1.600000E-03},
			{ 3.1600E+02, 1.570000E-03},{ 3.1700E+02, 1.550000E-03},{ 3.1800E+02, 1.520000E-03},{ 3.1900E+02, 1.490000E-03},
			{ 3.2000E+02, 1.460000E-03},{ 3.2100E+02, 1.430000E-03},{ 3.2200E+02, 1.390000E-03},{ 3.2300E+02, 1.360000E-03},
			{ 3.2400E+02, 1.330000E-03},{ 3.2500E+02, 1.310000E-03},{ 3.2600E+02, 1.320000E-03},{ 3.2700E+02, 1.340000E-03},
			{ 3.2800E+02, 1.360000E-03},{ 3.2900E+02, 1.370000E-03},{ 3.3000E+02, 1.380000E-03},{ 3.3100E+02, 1.380000E-03},
			{ 3.3200E+02, 1.380000E-03},{ 3.3300E+02, 1.380000E-03},{ 3.3400E+02, 1.390000E-03},{ 3.3500E+02, 1.420000E-03},
			{ 3.3600E+02, 1.460000E-03},{ 3.3700E+02, 1.530000E-03},{ 3.3800E+02, 1.600000E-03},{ 3.3900E+02, 1.660000E-03},
			{ 3.4000E+02, 1.710000E-03},{ 3.4100E+02, 1.750000E-03},{ 3.4200E+02, 1.800000E-03},{ 3.4300E+02, 1.850000E-03},
			{ 3.4400E+02, 1.920000E-03},{ 3.4500E+02, 1.980000E-03},{ 3.4600E+02, 2.030000E-03},{ 3.4700E+02, 2.070000E-03},
			{ 3.4800E+02, 2.120000E-03},{ 3.4900E+02, 2.160000E-03},{ 3.5000E+02, 2.190000E-03},{ 3.5100E+02, 2.220000E-03},
			{ 3.5200E+02, 2.230000E-03},{ 3.5300E+02, 2.250000E-03},{ 3.5400E+02, 2.250000E-03},{ 3.5500E+02, 2.250000E-03},
			{ 3.5600E+02, 2.250000E-03},{ 3.5700E+02, 2.250000E-03},{ 3.5800E+02, 2.240000E-03},{ 3.5900E+02, 2.240000E-03},
			{ 3.6000E+02, 2.230000E-03},{ 3.6100E+02, 2.210000E-03},{ 3.6200E+02, 2.220000E-03},{ 3.6300E+02, 2.230000E-03},
			 };
		return SL::Graph( 0, x, 363, g); 
	}

	inline double Graph13(double x) { 
		static double g[364][2] = {
			{ 0.0000E+00, 0.000000E+00},{ 1.0000E+00, 0.000000E+00},{ 2.0000E+00, 0.000000E+00},{ 3.0000E+00, 0.000000E+00},
			{ 4.0000E+00, 0.000000E+00},{ 5.0000E+00, 0.000000E+00},{ 6.0000E+00, 0.000000E+00},{ 7.0000E+00, 0.000000E+00},
			{ 8.0000E+00, 0.000000E+00},{ 9.0000E+00, 0.000000E+00},{ 1.0000E+01, 0.000000E+00},{ 1.1000E+01, 0.000000E+00},
			{ 1.2000E+01, 0.000000E+00},{ 1.3000E+01, 0.000000E+00},{ 1.4000E+01, 0.000000E+00},{ 1.5000E+01, 0.000000E+00},
			{ 1.6000E+01, 0.000000E+00},{ 1.7000E+01, 0.000000E+00},{ 1.8000E+01, 0.000000E+00},{ 1.9000E+01, 0.000000E+00},
			{ 2.0000E+01, 0.000000E+00},{ 2.1000E+01, 0.000000E+00},{ 2.2000E+01, 0.000000E+00},{ 2.3000E+01, 0.000000E+00},
			{ 2.4000E+01, 0.000000E+00},{ 2.5000E+01, 0.000000E+00},{ 2.6000E+01, 0.000000E+00},{ 2.7000E+01, 0.000000E+00},
			{ 2.8000E+01, 0.000000E+00},{ 2.9000E+01, 0.000000E+00},{ 3.0000E+01, 0.000000E+00},{ 3.1000E+01, 0.000000E+00},
			{ 3.2000E+01, 0.000000E+00},{ 3.3000E+01, 0.000000E+00},{ 3.4000E+01, 0.000000E+00},{ 3.5000E+01, 0.000000E+00},
			{ 3.6000E+01, 0.000000E+00},{ 3.7000E+01, 0.000000E+00},{ 3.8000E+01, 0.000000E+00},{ 3.9000E+01, 0.000000E+00},
			{ 4.0000E+01, 0.000000E+00},{ 4.1000E+01, 0.000000E+00},{ 4.2000E+01, 0.000000E+00},{ 4.3000E+01, 0.000000E+00},
			{ 4.4000E+01, 0.000000E+00},{ 4.5000E+01, 0.000000E+00},{ 4.6000E+01, 0.000000E+00},{ 4.7000E+01, 0.000000E+00},
			{ 4.8000E+01, 0.000000E+00},{ 4.9000E+01, 0.000000E+00},{ 5.0000E+01, 0.000000E+00},{ 5.1000E+01, 0.000000E+00},
			{ 5.2000E+01, 0.000000E+00},{ 5.3000E+01, 0.000000E+00},{ 5.4000E+01, 0.000000E+00},{ 5.5000E+01, 0.000000E+00},
			{ 5.6000E+01, 0.000000E+00},{ 5.7000E+01, 0.000000E+00},{ 5.8000E+01, 0.000000E+00},{ 5.9000E+01, 0.000000E+00},
			{ 6.0000E+01, 0.000000E+00},{ 6.1000E+01, 0.000000E+00},{ 6.2000E+01, 0.000000E+00},{ 6.3000E+01, 0.000000E+00},
			{ 6.4000E+01, 0.000000E+00},{ 6.5000E+01, 0.000000E+00},{ 6.6000E+01, 0.000000E+00},{ 6.7000E+01, 0.000000E+00},
			{ 6.8000E+01, 0.000000E+00},{ 6.9000E+01, 0.000000E+00},{ 7.0000E+01, 0.000000E+00},{ 7.1000E+01, 0.000000E+00},
			{ 7.2000E+01, 0.000000E+00},{ 7.3000E+01, 0.000000E+00},{ 7.4000E+01, 0.000000E+00},{ 7.5000E+01, 0.000000E+00},
			{ 7.6000E+01, 0.000000E+00},{ 7.7000E+01, 0.000000E+00},{ 7.8000E+01, 0.000000E+00},{ 7.9000E+01, 0.000000E+00},
			{ 8.0000E+01, 0.000000E+00},{ 8.1000E+01, 0.000000E+00},{ 8.2000E+01, 0.000000E+00},{ 8.3000E+01, 0.000000E+00},
			{ 8.4000E+01, 0.000000E+00},{ 8.5000E+01, 0.000000E+00},{ 8.6000E+01, 0.000000E+00},{ 8.7000E+01, 0.000000E+00},
			{ 8.8000E+01, 0.000000E+00},{ 8.9000E+01, 0.000000E+00},{ 9.0000E+01, 0.000000E+00},{ 9.1000E+01, 0.000000E+00},
			{ 9.2000E+01, 0.000000E+00},{ 9.3000E+01, 0.000000E+00},{ 9.4000E+01, 0.000000E+00},{ 9.5000E+01, 0.000000E+00},
			{ 9.6000E+01, 0.000000E+00},{ 9.7000E+01, 0.000000E+00},{ 9.8000E+01, 0.000000E+00},{ 9.9000E+01, 0.000000E+00},
			{ 1.0000E+02, 0.000000E+00},{ 1.0100E+02, 0.000000E+00},{ 1.0200E+02, 0.000000E+00},{ 1.0300E+02, 0.000000E+00},
			{ 1.0400E+02, 0.000000E+00},{ 1.0500E+02, 0.000000E+00},{ 1.0600E+02, 0.000000E+00},{ 1.0700E+02, 0.000000E+00},
			{ 1.0800E+02, 0.000000E+00},{ 1.0900E+02, 0.000000E+00},{ 1.1000E+02, 0.000000E+00},{ 1.1100E+02, 0.000000E+00},
			{ 1.1200E+02, 0.000000E+00},{ 1.1300E+02, 0.000000E+00},{ 1.1400E+02, 0.000000E+00},{ 1.1500E+02, 0.000000E+00},
			{ 1.1600E+02, 0.000000E+00},{ 1.1700E+02, 0.000000E+00},{ 1.1800E+02, 0.000000E+00},{ 1.1900E+02, 0.000000E+00},
			{ 1.2000E+02, 0.000000E+00},{ 1.2100E+02, 0.000000E+00},{ 1.2200E+02, 0.000000E+00},{ 1.2300E+02, 0.000000E+00},
			{ 1.2400E+02, 0.000000E+00},{ 1.2500E+02, 0.000000E+00},{ 1.2600E+02, 0.000000E+00},{ 1.2700E+02, 0.000000E+00},
			{ 1.2800E+02, 0.000000E+00},{ 1.2900E+02, 0.000000E+00},{ 1.3000E+02, 0.000000E+00},{ 1.3100E+02, 0.000000E+00},
			{ 1.3200E+02, 0.000000E+00},{ 1.3300E+02, 0.000000E+00},{ 1.3400E+02, 0.000000E+00},{ 1.3500E+02, 0.000000E+00},
			{ 1.3600E+02, 0.000000E+00},{ 1.3700E+02, 0.000000E+00},{ 1.3800E+02, 0.000000E+00},{ 1.3900E+02, 0.000000E+00},
			{ 1.4000E+02, 0.000000E+00},{ 1.4100E+02, 0.000000E+00},{ 1.4200E+02, 0.000000E+00},{ 1.4300E+02, 0.000000E+00},
			{ 1.4400E+02, 0.000000E+00},{ 1.4500E+02, 0.000000E+00},{ 1.4600E+02, 0.000000E+00},{ 1.4700E+02, 0.000000E+00},
			{ 1.4800E+02, 0.000000E+00},{ 1.4900E+02, 0.000000E+00},{ 1.5000E+02, 0.000000E+00},{ 1.5100E+02, 0.000000E+00},
			{ 1.5200E+02, 0.000000E+00},{ 1.5300E+02, 0.000000E+00},{ 1.5400E+02, 0.000000E+00},{ 1.5500E+02, 0.000000E+00},
			{ 1.5600E+02, 0.000000E+00},{ 1.5700E+02, 0.000000E+00},{ 1.5800E+02, 0.000000E+00},{ 1.5900E+02, 0.000000E+00},
			{ 1.6000E+02, 0.000000E+00},{ 1.6100E+02, 0.000000E+00},{ 1.6200E+02, 0.000000E+00},{ 1.6300E+02, 0.000000E+00},
			{ 1.6400E+02, 0.000000E+00},{ 1.6500E+02, 0.000000E+00},{ 1.6600E+02, 0.000000E+00},{ 1.6700E+02, 0.000000E+00},
			{ 1.6800E+02, 0.000000E+00},{ 1.6900E+02, 0.000000E+00},{ 1.7000E+02, 0.000000E+00},{ 1.7100E+02, 0.000000E+00},
			{ 1.7200E+02, 0.000000E+00},{ 1.7300E+02, 0.000000E+00},{ 1.7400E+02, 0.000000E+00},{ 1.7500E+02, 0.000000E+00},
			{ 1.7600E+02, 0.000000E+00},{ 1.7700E+02, 0.000000E+00},{ 1.7800E+02, 0.000000E+00},{ 1.7900E+02, 0.000000E+00},
			{ 1.8000E+02, 0.000000E+00},{ 1.8100E+02, 0.000000E+00},{ 1.8200E+02, 0.000000E+00},{ 1.8300E+02, 0.000000E+00},
			{ 1.8400E+02, 0.000000E+00},{ 1.8500E+02, 0.000000E+00},{ 1.8600E+02, 0.000000E+00},{ 1.8700E+02, 0.000000E+00},
			{ 1.8800E+02, 0.000000E+00},{ 1.8900E+02, 0.000000E+00},{ 1.9000E+02, 0.000000E+00},{ 1.9100E+02, 0.000000E+00},
			{ 1.9200E+02, 0.000000E+00},{ 1.9300E+02, 0.000000E+00},{ 1.9400E+02, 0.000000E+00},{ 1.9500E+02, 0.000000E+00},
			{ 1.9600E+02, 0.000000E+00},{ 1.9700E+02, 0.000000E+00},{ 1.9800E+02, 0.000000E+00},{ 1.9900E+02, 0.000000E+00},
			{ 2.0000E+02, 0.000000E+00},{ 2.0100E+02, 0.000000E+00},{ 2.0200E+02, 0.000000E+00},{ 2.0300E+02, 0.000000E+00},
			{ 2.0400E+02, 0.000000E+00},{ 2.0500E+02, 0.000000E+00},{ 2.0600E+02, 0.000000E+00},{ 2.0700E+02, 0.000000E+00},
			{ 2.0800E+02, 0.000000E+00},{ 2.0900E+02, 0.000000E+00},{ 2.1000E+02, 0.000000E+00},{ 2.1100E+02, 0.000000E+00},
			{ 2.1200E+02, 0.000000E+00},{ 2.1300E+02, 0.000000E+00},{ 2.1400E+02, 0.000000E+00},{ 2.1500E+02, 0.000000E+00},
			{ 2.1600E+02, 0.000000E+00},{ 2.1700E+02, 0.000000E+00},{ 2.1800E+02, 0.000000E+00},{ 2.1900E+02, 0.000000E+00},
			{ 2.2000E+02, 0.000000E+00},{ 2.2100E+02, 0.000000E+00},{ 2.2200E+02, 0.000000E+00},{ 2.2300E+02, 0.000000E+00},
			{ 2.2400E+02, 0.000000E+00},{ 2.2500E+02, 0.000000E+00},{ 2.2600E+02, 0.000000E+00},{ 2.2700E+02, 0.000000E+00},
			{ 2.2800E+02, 0.000000E+00},{ 2.2900E+02, 0.000000E+00},{ 2.3000E+02, 0.000000E+00},{ 2.3100E+02, 0.000000E+00},
			{ 2.3200E+02, 0.000000E+00},{ 2.3300E+02, 0.000000E+00},{ 2.3400E+02, 0.000000E+00},{ 2.3500E+02, 0.000000E+00},
			{ 2.3600E+02, 0.000000E+00},{ 2.3700E+02, 0.000000E+00},{ 2.3800E+02, 0.000000E+00},{ 2.3900E+02, 0.000000E+00},
			{ 2.4000E+02, 0.000000E+00},{ 2.4100E+02, 0.000000E+00},{ 2.4200E+02, 0.000000E+00},{ 2.4300E+02, 0.000000E+00},
			{ 2.4400E+02, 0.000000E+00},{ 2.4500E+02, 0.000000E+00},{ 2.4600E+02, 0.000000E+00},{ 2.4700E+02, 0.000000E+00},
			{ 2.4800E+02, 0.000000E+00},{ 2.4900E+02, 0.000000E+00},{ 2.5000E+02, 0.000000E+00},{ 2.5100E+02, 0.000000E+00},
			{ 2.5200E+02, 0.000000E+00},{ 2.5300E+02, 0.000000E+00},{ 2.5400E+02, 0.000000E+00},{ 2.5500E+02, 0.000000E+00},
			{ 2.5600E+02, 0.000000E+00},{ 2.5700E+02, 0.000000E+00},{ 2.5800E+02, 0.000000E+00},{ 2.5900E+02, 0.000000E+00},
			{ 2.6000E+02, 0.000000E+00},{ 2.6100E+02, 0.000000E+00},{ 2.6200E+02, 0.000000E+00},{ 2.6300E+02, 0.000000E+00},
			{ 2.6400E+02, 0.000000E+00},{ 2.6500E+02, 0.000000E+00},{ 2.6600E+02, 0.000000E+00},{ 2.6700E+02, 0.000000E+00},
			{ 2.6800E+02, 0.000000E+00},{ 2.6900E+02, 0.000000E+00},{ 2.7000E+02, 0.000000E+00},{ 2.7100E+02, 0.000000E+00},
			{ 2.7200E+02, 0.000000E+00},{ 2.7300E+02, 0.000000E+00},{ 2.7400E+02, 0.000000E+00},{ 2.7500E+02, 0.000000E+00},
			{ 2.7600E+02, 0.000000E+00},{ 2.7700E+02, 0.000000E+00},{ 2.7800E+02, 0.000000E+00},{ 2.7900E+02, 0.000000E+00},
			{ 2.8000E+02, 0.000000E+00},{ 2.8100E+02, 0.000000E+00},{ 2.8200E+02, 0.000000E+00},{ 2.8300E+02, 0.000000E+00},
			{ 2.8400E+02, 0.000000E+00},{ 2.8500E+02, 0.000000E+00},{ 2.8600E+02, 0.000000E+00},{ 2.8700E+02, 0.000000E+00},
			{ 2.8800E+02, 0.000000E+00},{ 2.8900E+02, 0.000000E+00},{ 2.9000E+02, 0.000000E+00},{ 2.9100E+02, 0.000000E+00},
			{ 2.9200E+02, 0.000000E+00},{ 2.9300E+02, 0.000000E+00},{ 2.9400E+02, 0.000000E+00},{ 2.9500E+02, 0.000000E+00},
			{ 2.9600E+02, 0.000000E+00},{ 2.9700E+02, 0.000000E+00},{ 2.9800E+02, 0.000000E+00},{ 2.9900E+02, 0.000000E+00},
			{ 3.0000E+02, 0.000000E+00},{ 3.0100E+02, 0.000000E+00},{ 3.0200E+02, 0.000000E+00},{ 3.0300E+02, 0.000000E+00},
			{ 3.0400E+02, 0.000000E+00},{ 3.0500E+02, 0.000000E+00},{ 3.0600E+02, 0.000000E+00},{ 3.0700E+02, 0.000000E+00},
			{ 3.0800E+02, 0.000000E+00},{ 3.0900E+02, 0.000000E+00},{ 3.1000E+02, 0.000000E+00},{ 3.1100E+02, 0.000000E+00},
			{ 3.1200E+02, 0.000000E+00},{ 3.1300E+02, 0.000000E+00},{ 3.1400E+02, 0.000000E+00},{ 3.1500E+02, 0.000000E+00},
			{ 3.1600E+02, 0.000000E+00},{ 3.1700E+02, 0.000000E+00},{ 3.1800E+02, 0.000000E+00},{ 3.1900E+02, 0.000000E+00},
			{ 3.2000E+02, 0.000000E+00},{ 3.2100E+02, 0.000000E+00},{ 3.2200E+02, 0.000000E+00},{ 3.2300E+02, 0.000000E+00},
			{ 3.2400E+02, 0.000000E+00},{ 3.2500E+02, 0.000000E+00},{ 3.2600E+02, 0.000000E+00},{ 3.2700E+02, 0.000000E+00},
			{ 3.2800E+02, 0.000000E+00},{ 3.2900E+02, 0.000000E+00},{ 3.3000E+02, 0.000000E+00},{ 3.3100E+02, 0.000000E+00},
			{ 3.3200E+02, 0.000000E+00},{ 3.3300E+02, 0.000000E+00},{ 3.3400E+02, 0.000000E+00},{ 3.3500E+02, 0.000000E+00},
			{ 3.3600E+02, 0.000000E+00},{ 3.3700E+02, 0.000000E+00},{ 3.3800E+02, 0.000000E+00},{ 3.3900E+02, 0.000000E+00},
			{ 3.4000E+02, 0.000000E+00},{ 3.4100E+02, 0.000000E+00},{ 3.4200E+02, 0.000000E+00},{ 3.4300E+02, 0.000000E+00},
			{ 3.4400E+02, 0.000000E+00},{ 3.4500E+02, 0.000000E+00},{ 3.4600E+02, 0.000000E+00},{ 3.4700E+02, 0.000000E+00},
			{ 3.4800E+02, 0.000000E+00},{ 3.4900E+02, 0.000000E+00},{ 3.5000E+02, 0.000000E+00},{ 3.5100E+02, 0.000000E+00},
			{ 3.5200E+02, 0.000000E+00},{ 3.5300E+02, 0.000000E+00},{ 3.5400E+02, 0.000000E+00},{ 3.5500E+02, 0.000000E+00},
			{ 3.5600E+02, 0.000000E+00},{ 3.5700E+02, 0.000000E+00},{ 3.5800E+02, 0.000000E+00},{ 3.5900E+02, 0.000000E+00},
			{ 3.6000E+02, 0.000000E+00},{ 3.6100E+02, 0.000000E+00},{ 3.6200E+02, 0.000000E+00},{ 3.6300E+02, 0.000000E+00},
			 };
		return SL::Graph( 0, x, 363, g); 
	}

	inline double Graph14(double x) { 
		static double g[365][2] = {
			{ 0.0000E+00, 2.260000E+01},{ 1.0000E+00, 2.260000E+01},{ 2.0000E+00, 2.260000E+01},{ 3.0000E+00, 2.270000E+01},
			{ 4.0000E+00, 2.280000E+01},{ 5.0000E+00, 2.280000E+01},{ 6.0000E+00, 2.290000E+01},{ 7.0000E+00, 2.290000E+01},
			{ 8.0000E+00, 2.300000E+01},{ 9.0000E+00, 2.300000E+01},{ 1.0000E+01, 2.300000E+01},{ 1.1000E+01, 2.310000E+01},
			{ 1.2000E+01, 2.310000E+01},{ 1.3000E+01, 2.310000E+01},{ 1.4000E+01, 2.320000E+01},{ 1.5000E+01, 2.320000E+01},
			{ 1.6000E+01, 2.320000E+01},{ 1.7000E+01, 2.320000E+01},{ 1.8000E+01, 2.320000E+01},{ 1.9000E+01, 2.330000E+01},
			{ 2.0000E+01, 2.330000E+01},{ 2.1000E+01, 2.330000E+01},{ 2.2000E+01, 2.330000E+01},{ 2.3000E+01, 2.330000E+01},
			{ 2.4000E+01, 2.330000E+01},{ 2.5000E+01, 2.330000E+01},{ 2.6000E+01, 2.330000E+01},{ 2.7000E+01, 2.330000E+01},
			{ 2.8000E+01, 2.330000E+01},{ 2.9000E+01, 2.330000E+01},{ 3.0000E+01, 2.330000E+01},{ 3.1000E+01, 2.330000E+01},
			{ 3.2000E+01, 2.330000E+01},{ 3.3000E+01, 2.330000E+01},{ 3.4000E+01, 2.320000E+01},{ 3.5000E+01, 2.320000E+01},
			{ 3.6000E+01, 2.320000E+01},{ 3.7000E+01, 2.320000E+01},{ 3.8000E+01, 2.320000E+01},{ 3.9000E+01, 2.320000E+01},
			{ 4.0000E+01, 2.320000E+01},{ 4.1000E+01, 2.320000E+01},{ 4.2000E+01, 2.310000E+01},{ 4.3000E+01, 2.310000E+01},
			{ 4.4000E+01, 2.310000E+01},{ 4.5000E+01, 2.310000E+01},{ 4.6000E+01, 2.310000E+01},{ 4.7000E+01, 2.310000E+01},
			{ 4.8000E+01, 2.310000E+01},{ 4.9000E+01, 2.300000E+01},{ 5.0000E+01, 2.300000E+01},{ 5.1000E+01, 2.300000E+01},
			{ 5.2000E+01, 2.300000E+01},{ 5.3000E+01, 2.300000E+01},{ 5.4000E+01, 2.300000E+01},{ 5.5000E+01, 2.290000E+01},
			{ 5.6000E+01, 2.290000E+01},{ 5.7000E+01, 2.290000E+01},{ 5.8000E+01, 2.290000E+01},{ 5.9000E+01, 2.290000E+01},
			{ 6.0000E+01, 2.290000E+01},{ 6.1000E+01, 2.290000E+01},{ 6.2000E+01, 2.290000E+01},{ 6.3000E+01, 2.280000E+01},
			{ 6.4000E+01, 2.280000E+01},{ 6.5000E+01, 2.280000E+01},{ 6.6000E+01, 2.280000E+01},{ 6.7000E+01, 2.280000E+01},
			{ 6.8000E+01, 2.280000E+01},{ 6.9000E+01, 2.280000E+01},{ 7.0000E+01, 2.280000E+01},{ 7.1000E+01, 2.280000E+01},
			{ 7.2000E+01, 2.280000E+01},{ 7.3000E+01, 2.280000E+01},{ 7.4000E+01, 2.280000E+01},{ 7.5000E+01, 2.270000E+01},
			{ 7.6000E+01, 2.270000E+01},{ 7.7000E+01, 2.270000E+01},{ 7.8000E+01, 2.270000E+01},{ 7.9000E+01, 2.270000E+01},
			{ 8.0000E+01, 2.270000E+01},{ 8.1000E+01, 2.270000E+01},{ 8.2000E+01, 2.270000E+01},{ 8.3000E+01, 2.270000E+01},
			{ 8.4000E+01, 2.270000E+01},{ 8.5000E+01, 2.270000E+01},{ 8.6000E+01, 2.270000E+01},{ 8.7000E+01, 2.270000E+01},
			{ 8.8000E+01, 2.270000E+01},{ 8.9000E+01, 2.270000E+01},{ 9.0000E+01, 2.270000E+01},{ 9.1000E+01, 2.270000E+01},
			{ 9.2000E+01, 2.270000E+01},{ 9.3000E+01, 2.270000E+01},{ 9.4000E+01, 2.270000E+01},{ 9.5000E+01, 2.270000E+01},
			{ 9.6000E+01, 2.270000E+01},{ 9.7000E+01, 2.270000E+01},{ 9.8000E+01, 2.270000E+01},{ 9.9000E+01, 2.270000E+01},
			{ 1.0000E+02, 2.270000E+01},{ 1.0100E+02, 2.270000E+01},{ 1.0200E+02, 2.270000E+01},{ 1.0300E+02, 2.270000E+01},
			{ 1.0400E+02, 2.270000E+01},{ 1.0500E+02, 2.270000E+01},{ 1.0600E+02, 2.270000E+01},{ 1.0700E+02, 2.270000E+01},
			{ 1.0800E+02, 2.270000E+01},{ 1.0900E+02, 2.270000E+01},{ 1.1000E+02, 2.270000E+01},{ 1.1100E+02, 2.270000E+01},
			{ 1.1200E+02, 2.270000E+01},{ 1.1300E+02, 2.270000E+01},{ 1.1400E+02, 2.270000E+01},{ 1.1500E+02, 2.270000E+01},
			{ 1.1600E+02, 2.270000E+01},{ 1.1700E+02, 2.270000E+01},{ 1.1800E+02, 2.270000E+01},{ 1.1900E+02, 2.270000E+01},
			{ 1.2000E+02, 2.270000E+01},{ 1.2100E+02, 2.270000E+01},{ 1.2200E+02, 2.270000E+01},{ 1.2300E+02, 2.270000E+01},
			{ 1.2400E+02, 2.270000E+01},{ 1.2500E+02, 2.270000E+01},{ 1.2600E+02, 2.270000E+01},{ 1.2700E+02, 2.270000E+01},
			{ 1.2800E+02, 2.270000E+01},{ 1.2900E+02, 2.270000E+01},{ 1.3000E+02, 2.270000E+01},{ 1.3100E+02, 2.270000E+01},
			{ 1.3200E+02, 2.270000E+01},{ 1.3300E+02, 2.270000E+01},{ 1.3400E+02, 2.270000E+01},{ 1.3500E+02, 2.270000E+01},
			{ 1.3600E+02, 2.260000E+01},{ 1.3700E+02, 2.260000E+01},{ 1.3800E+02, 2.260000E+01},{ 1.3900E+02, 2.260000E+01},
			{ 1.4000E+02, 2.260000E+01},{ 1.4100E+02, 2.260000E+01},{ 1.4200E+02, 2.260000E+01},{ 1.4300E+02, 2.260000E+01},
			{ 1.4400E+02, 2.260000E+01},{ 1.4500E+02, 2.260000E+01},{ 1.4600E+02, 2.260000E+01},{ 1.4700E+02, 2.260000E+01},
			{ 1.4800E+02, 2.260000E+01},{ 1.4900E+02, 2.260000E+01},{ 1.5000E+02, 2.260000E+01},{ 1.5100E+02, 2.260000E+01},
			{ 1.5200E+02, 2.260000E+01},{ 1.5300E+02, 2.260000E+01},{ 1.5400E+02, 2.260000E+01},{ 1.5500E+02, 2.260000E+01},
			{ 1.5600E+02, 2.260000E+01},{ 1.5700E+02, 2.260000E+01},{ 1.5800E+02, 2.260000E+01},{ 1.5900E+02, 2.260000E+01},
			{ 1.6000E+02, 2.260000E+01},{ 1.6100E+02, 2.260000E+01},{ 1.6200E+02, 2.260000E+01},{ 1.6300E+02, 2.260000E+01},
			{ 1.6400E+02, 2.260000E+01},{ 1.6500E+02, 2.260000E+01},{ 1.6600E+02, 2.260000E+01},{ 1.6700E+02, 2.260000E+01},
			{ 1.6800E+02, 2.260000E+01},{ 1.6900E+02, 2.260000E+01},{ 1.7000E+02, 2.260000E+01},{ 1.7100E+02, 2.260000E+01},
			{ 1.7200E+02, 2.260000E+01},{ 1.7300E+02, 2.260000E+01},{ 1.7400E+02, 2.260000E+01},{ 1.7500E+02, 2.260000E+01},
			{ 1.7600E+02, 2.260000E+01},{ 1.7700E+02, 2.260000E+01},{ 1.7800E+02, 2.260000E+01},{ 1.7900E+02, 2.260000E+01},
			{ 1.8000E+02, 2.260000E+01},{ 1.8100E+02, 2.260000E+01},{ 1.8200E+02, 2.260000E+01},{ 1.8300E+02, 2.260000E+01},
			{ 1.8400E+02, 2.260000E+01},{ 1.8500E+02, 2.260000E+01},{ 1.8600E+02, 2.260000E+01},{ 1.8700E+02, 2.260000E+01},
			{ 1.8800E+02, 2.260000E+01},{ 1.8900E+02, 2.260000E+01},{ 1.9000E+02, 2.260000E+01},{ 1.9100E+02, 2.260000E+01},
			{ 1.9200E+02, 2.260000E+01},{ 1.9300E+02, 2.260000E+01},{ 1.9400E+02, 2.260000E+01},{ 1.9500E+02, 2.260000E+01},
			{ 1.9600E+02, 2.260000E+01},{ 1.9700E+02, 2.260000E+01},{ 1.9800E+02, 2.260000E+01},{ 1.9900E+02, 2.260000E+01},
			{ 2.0000E+02, 2.260000E+01},{ 2.0100E+02, 2.260000E+01},{ 2.0200E+02, 2.260000E+01},{ 2.0300E+02, 2.260000E+01},
			{ 2.0400E+02, 2.260000E+01},{ 2.0500E+02, 2.260000E+01},{ 2.0600E+02, 2.260000E+01},{ 2.0700E+02, 2.260000E+01},
			{ 2.0800E+02, 2.260000E+01},{ 2.0900E+02, 2.260000E+01},{ 2.1000E+02, 2.260000E+01},{ 2.1100E+02, 2.260000E+01},
			{ 2.1200E+02, 2.260000E+01},{ 2.1300E+02, 2.260000E+01},{ 2.1400E+02, 2.260000E+01},{ 2.1500E+02, 2.260000E+01},
			{ 2.1600E+02, 2.260000E+01},{ 2.1700E+02, 2.260000E+01},{ 2.1800E+02, 2.260000E+01},{ 2.1900E+02, 2.260000E+01},
			{ 2.2000E+02, 2.260000E+01},{ 2.2100E+02, 2.260000E+01},{ 2.2200E+02, 2.260000E+01},{ 2.2300E+02, 2.260000E+01},
			{ 2.2400E+02, 2.260000E+01},{ 2.2500E+02, 2.260000E+01},{ 2.2600E+02, 2.260000E+01},{ 2.2700E+02, 2.260000E+01},
			{ 2.2800E+02, 2.260000E+01},{ 2.2900E+02, 2.260000E+01},{ 2.3000E+02, 2.260000E+01},{ 2.3100E+02, 2.260000E+01},
			{ 2.3200E+02, 2.260000E+01},{ 2.3300E+02, 2.260000E+01},{ 2.3400E+02, 2.260000E+01},{ 2.3500E+02, 2.270000E+01},
			{ 2.3600E+02, 2.270000E+01},{ 2.3700E+02, 2.270000E+01},{ 2.3800E+02, 2.270000E+01},{ 2.3900E+02, 2.270000E+01},
			{ 2.4000E+02, 2.270000E+01},{ 2.4100E+02, 2.270000E+01},{ 2.4200E+02, 2.270000E+01},{ 2.4300E+02, 2.270000E+01},
			{ 2.4400E+02, 2.270000E+01},{ 2.4500E+02, 2.270000E+01},{ 2.4600E+02, 2.270000E+01},{ 2.4700E+02, 2.270000E+01},
			{ 2.4800E+02, 2.270000E+01},{ 2.4900E+02, 2.270000E+01},{ 2.5000E+02, 2.270000E+01},{ 2.5100E+02, 2.270000E+01},
			{ 2.5200E+02, 2.260000E+01},{ 2.5300E+02, 2.260000E+01},{ 2.5400E+02, 2.260000E+01},{ 2.5500E+02, 2.260000E+01},
			{ 2.5600E+02, 2.260000E+01},{ 2.5700E+02, 2.260000E+01},{ 2.5800E+02, 2.260000E+01},{ 2.5900E+02, 2.260000E+01},
			{ 2.6000E+02, 2.260000E+01},{ 2.6100E+02, 2.260000E+01},{ 2.6200E+02, 2.260000E+01},{ 2.6300E+02, 2.260000E+01},
			{ 2.6400E+02, 2.260000E+01},{ 2.6500E+02, 2.260000E+01},{ 2.6600E+02, 2.260000E+01},{ 2.6700E+02, 2.260000E+01},
			{ 2.6800E+02, 2.260000E+01},{ 2.6900E+02, 2.260000E+01},{ 2.7000E+02, 2.260000E+01},{ 2.7100E+02, 2.260000E+01},
			{ 2.7200E+02, 2.260000E+01},{ 2.7300E+02, 2.260000E+01},{ 2.7400E+02, 2.260000E+01},{ 2.7500E+02, 2.260000E+01},
			{ 2.7600E+02, 2.260000E+01},{ 2.7700E+02, 2.260000E+01},{ 2.7800E+02, 2.260000E+01},{ 2.7900E+02, 2.260000E+01},
			{ 2.8000E+02, 2.260000E+01},{ 2.8100E+02, 2.260000E+01},{ 2.8200E+02, 2.260000E+01},{ 2.8300E+02, 2.260000E+01},
			{ 2.8400E+02, 2.260000E+01},{ 2.8500E+02, 2.260000E+01},{ 2.8600E+02, 2.260000E+01},{ 2.8700E+02, 2.260000E+01},
			{ 2.8800E+02, 2.260000E+01},{ 2.8900E+02, 2.260000E+01},{ 2.9000E+02, 2.260000E+01},{ 2.9100E+02, 2.260000E+01},
			{ 2.9200E+02, 2.260000E+01},{ 2.9300E+02, 2.260000E+01},{ 2.9400E+02, 2.260000E+01},{ 2.9500E+02, 2.270000E+01},
			{ 2.9600E+02, 2.270000E+01},{ 2.9700E+02, 2.270000E+01},{ 2.9800E+02, 2.270000E+01},{ 2.9900E+02, 2.270000E+01},
			{ 3.0000E+02, 2.270000E+01},{ 3.0100E+02, 2.270000E+01},{ 3.0200E+02, 2.270000E+01},{ 3.0300E+02, 2.260000E+01},
			{ 3.0400E+02, 2.260000E+01},{ 3.0500E+02, 2.260000E+01},{ 3.0600E+02, 2.260000E+01},{ 3.0700E+02, 2.260000E+01},
			{ 3.0800E+02, 2.260000E+01},{ 3.0900E+02, 2.260000E+01},{ 3.1000E+02, 2.260000E+01},{ 3.1100E+02, 2.260000E+01},
			{ 3.1200E+02, 2.260000E+01},{ 3.1300E+02, 2.260000E+01},{ 3.1400E+02, 2.260000E+01},{ 3.1500E+02, 2.260000E+01},
			{ 3.1600E+02, 2.260000E+01},{ 3.1700E+02, 2.260000E+01},{ 3.1800E+02, 2.260000E+01},{ 3.1900E+02, 2.260000E+01},
			{ 3.2000E+02, 2.260000E+01},{ 3.2100E+02, 2.260000E+01},{ 3.2200E+02, 2.260000E+01},{ 3.2300E+02, 2.260000E+01},
			{ 3.2400E+02, 2.260000E+01},{ 3.2500E+02, 2.260000E+01},{ 3.2600E+02, 2.260000E+01},{ 3.2700E+02, 2.260000E+01},
			{ 3.2800E+02, 2.260000E+01},{ 3.2900E+02, 2.260000E+01},{ 3.3000E+02, 2.260000E+01},{ 3.3100E+02, 2.260000E+01},
			{ 3.3200E+02, 2.260000E+01},{ 3.3300E+02, 2.260000E+01},{ 3.3400E+02, 2.260000E+01},{ 3.3500E+02, 2.260000E+01},
			{ 3.3600E+02, 2.260000E+01},{ 3.3700E+02, 2.260000E+01},{ 3.3800E+02, 2.260000E+01},{ 3.3900E+02, 2.260000E+01},
			{ 3.4000E+02, 2.260000E+01},{ 3.4100E+02, 2.260000E+01},{ 3.4200E+02, 2.260000E+01},{ 3.4300E+02, 2.260000E+01},
			{ 3.4400E+02, 2.260000E+01},{ 3.4500E+02, 2.260000E+01},{ 3.4600E+02, 2.270000E+01},{ 3.4700E+02, 2.270000E+01},
			{ 3.4800E+02, 2.270000E+01},{ 3.4900E+02, 2.270000E+01},{ 3.5000E+02, 2.270000E+01},{ 3.5100E+02, 2.270000E+01},
			{ 3.5200E+02, 2.270000E+01},{ 3.5300E+02, 2.270000E+01},{ 3.5400E+02, 2.270000E+01},{ 3.5500E+02, 2.270000E+01},
			{ 3.5600E+02, 2.270000E+01},{ 3.5700E+02, 2.270000E+01},{ 3.5800E+02, 2.270000E+01},{ 3.5900E+02, 2.270000E+01},
			{ 3.6000E+02, 2.270000E+01},{ 3.6100E+02, 2.270000E+01},{ 3.6200E+02, 2.270000E+01},{ 3.6300E+02, 2.270000E+01},
			{ 3.6400E+02, 2.270000E+01}, };
		return SL::Graph( 0, x, 364, g); 
	}

	inline double Graph15(double x) { 
		static double g[366][2] = {
			{ 0.0000E+00, 2.220000E+02},{ 1.0000E+00, 2.220000E+02},{ 2.0000E+00, 2.230000E+02},{ 3.0000E+00, 2.250000E+02},
			{ 4.0000E+00, 2.260000E+02},{ 5.0000E+00, 2.270000E+02},{ 6.0000E+00, 1.640000E+02},{ 7.0000E+00, 1.350000E+02},
			{ 8.0000E+00, 1.310000E+02},{ 9.0000E+00, 2.330000E+02},{ 1.0000E+01, 2.350000E+02},{ 1.1000E+01, 2.360000E+02},
			{ 1.2000E+01, 1.290000E+02},{ 1.3000E+01, 1.540000E+02},{ 1.4000E+01, 2.420000E+02},{ 1.5000E+01, 2.440000E+02},
			{ 1.6000E+01, 1.510000E+02},{ 1.7000E+01, 1.590000E+02},{ 1.8000E+01, 2.510000E+02},{ 1.9000E+01, 2.540000E+02},
			{ 2.0000E+01, 2.560000E+02},{ 2.1000E+01, 2.020000E+02},{ 2.2000E+01, 2.610000E+02},{ 2.3000E+01, 2.640000E+02},
			{ 2.4000E+01, 2.670000E+02},{ 2.5000E+01, 2.700000E+02},{ 2.6000E+01, 2.730000E+02},{ 2.7000E+01, 2.760000E+02},
			{ 2.8000E+01, 2.790000E+02},{ 2.9000E+01, 2.820000E+02},{ 3.0000E+01, 2.850000E+02},{ 3.1000E+01, 2.040000E+02},
			{ 3.2000E+01, 2.920000E+02},{ 3.3000E+01, 2.950000E+02},{ 3.4000E+01, 2.980000E+02},{ 3.5000E+01, 3.020000E+02},
			{ 3.6000E+01, 3.050000E+02},{ 3.7000E+01, 2.890000E+02},{ 3.8000E+01, 2.060000E+02},{ 3.9000E+01, 2.900000E+02},
			{ 4.0000E+01, 3.200000E+02},{ 4.1000E+01, 3.240000E+02},{ 4.2000E+01, 3.270000E+02},{ 4.3000E+01, 3.310000E+02},
			{ 4.4000E+01, 3.350000E+02},{ 4.5000E+01, 2.030000E+02},{ 4.6000E+01, 3.430000E+02},{ 4.7000E+01, 3.470000E+02},
			{ 4.8000E+01, 3.510000E+02},{ 4.9000E+01, 2.350000E+02},{ 5.0000E+01, 2.550000E+02},{ 5.1000E+01, 2.500000E+02},
			{ 5.2000E+01, 3.670000E+02},{ 5.3000E+01, 3.720000E+02},{ 5.4000E+01, 3.760000E+02},{ 5.5000E+01, 3.800000E+02},
			{ 5.6000E+01, 3.840000E+02},{ 5.7000E+01, 3.800000E+02},{ 5.8000E+01, 3.930000E+02},{ 5.9000E+01, 3.970000E+02},
			{ 6.0000E+01, 4.010000E+02},{ 6.1000E+01, 2.790000E+02},{ 6.2000E+01, 4.100000E+02},{ 6.3000E+01, 2.420000E+02},
			{ 6.4000E+01, 2.610000E+02},{ 6.5000E+01, 4.230000E+02},{ 6.6000E+01, 2.740000E+02},{ 6.7000E+01, 4.310000E+02},
			{ 6.8000E+01, 4.360000E+02},{ 6.9000E+01, 4.400000E+02},{ 7.0000E+01, 4.440000E+02},{ 7.1000E+01, 4.490000E+02},
			{ 7.2000E+01, 4.530000E+02},{ 7.3000E+01, 2.690000E+02},{ 7.4000E+01, 2.900000E+02},{ 7.5000E+01, 4.660000E+02},
			{ 7.6000E+01, 4.700000E+02},{ 7.7000E+01, 2.720000E+02},{ 7.8000E+01, 4.790000E+02},{ 7.9000E+01, 4.830000E+02},
			{ 8.0000E+01, 4.870000E+02},{ 8.1000E+01, 4.910000E+02},{ 8.2000E+01, 2.770000E+02},{ 8.3000E+01, 2.820000E+02},
			{ 8.4000E+01, 5.040000E+02},{ 8.5000E+01, 5.080000E+02},{ 8.6000E+01, 3.350000E+02},{ 8.7000E+01, 5.160000E+02},
			{ 8.8000E+01, 3.970000E+02},{ 8.9000E+01, 2.910000E+02},{ 9.0000E+01, 5.280000E+02},{ 9.1000E+01, 5.320000E+02},
			{ 9.2000E+01, 5.360000E+02},{ 9.3000E+01, 5.400000E+02},{ 9.4000E+01, 5.440000E+02},{ 9.5000E+01, 5.480000E+02},
			{ 9.6000E+01, 3.850000E+02},{ 9.7000E+01, 5.550000E+02},{ 9.8000E+01, 5.590000E+02},{ 9.9000E+01, 5.630000E+02},
			{ 1.0000E+02, 5.660000E+02},{ 1.0100E+02, 5.700000E+02},{ 1.0200E+02, 5.730000E+02},{ 1.0300E+02, 5.770000E+02},
			{ 1.0400E+02, 3.410000E+02},{ 1.0500E+02, 4.030000E+02},{ 1.0600E+02, 3.580000E+02},{ 1.0700E+02, 5.910000E+02},
			{ 1.0800E+02, 5.940000E+02},{ 1.0900E+02, 5.970000E+02},{ 1.1000E+02, 5.270000E+02},{ 1.1100E+02, 5.800000E+02},
			{ 1.1200E+02, 3.840000E+02},{ 1.1300E+02, 6.100000E+02},{ 1.1400E+02, 6.130000E+02},{ 1.1500E+02, 4.240000E+02},
			{ 1.1600E+02, 6.190000E+02},{ 1.1700E+02, 6.220000E+02},{ 1.1800E+02, 4.300000E+02},{ 1.1900E+02, 4.090000E+02},
			{ 1.2000E+02, 4.530000E+02},{ 1.2100E+02, 6.270000E+02},{ 1.2200E+02, 4.580000E+02},{ 1.2300E+02, 6.380000E+02},
			{ 1.2400E+02, 6.410000E+02},{ 1.2500E+02, 6.430000E+02},{ 1.2600E+02, 4.110000E+02},{ 1.2700E+02, 4.480000E+02},
			{ 1.2800E+02, 6.500000E+02},{ 1.2900E+02, 6.530000E+02},{ 1.3000E+02, 4.490000E+02},{ 1.3100E+02, 6.570000E+02},
			{ 1.3200E+02, 6.590000E+02},{ 1.3300E+02, 6.610000E+02},{ 1.3400E+02, 6.630000E+02},{ 1.3500E+02, 6.650000E+02},
			{ 1.3600E+02, 6.670000E+02},{ 1.3700E+02, 6.690000E+02},{ 1.3800E+02, 3.960000E+02},{ 1.3900E+02, 5.050000E+02},
			{ 1.4000E+02, 6.750000E+02},{ 1.4100E+02, 6.760000E+02},{ 1.4200E+02, 6.780000E+02},{ 1.4300E+02, 6.790000E+02},
			{ 1.4400E+02, 6.810000E+02},{ 1.4500E+02, 6.820000E+02},{ 1.4600E+02, 6.840000E+02},{ 1.4700E+02, 6.850000E+02},
			{ 1.4800E+02, 6.870000E+02},{ 1.4900E+02, 6.880000E+02},{ 1.5000E+02, 6.890000E+02},{ 1.5100E+02, 6.900000E+02},
			{ 1.5200E+02, 6.910000E+02},{ 1.5300E+02, 4.590000E+02},{ 1.5400E+02, 6.930000E+02},{ 1.5500E+02, 6.940000E+02},
			{ 1.5600E+02, 6.950000E+02},{ 1.5700E+02, 6.960000E+02},{ 1.5800E+02, 6.970000E+02},{ 1.5900E+02, 6.980000E+02},
			{ 1.6000E+02, 6.980000E+02},{ 1.6100E+02, 6.990000E+02},{ 1.6200E+02, 7.000000E+02},{ 1.6300E+02, 7.000000E+02},
			{ 1.6400E+02, 7.010000E+02},{ 1.6500E+02, 7.010000E+02},{ 1.6600E+02, 7.010000E+02},{ 1.6700E+02, 7.020000E+02},
			{ 1.6800E+02, 7.020000E+02},{ 1.6900E+02, 4.270000E+02},{ 1.7000E+02, 5.650000E+02},{ 1.7100E+02, 7.030000E+02},
			{ 1.7200E+02, 7.030000E+02},{ 1.7300E+02, 7.030000E+02},{ 1.7400E+02, 4.740000E+02},{ 1.7500E+02, 5.410000E+02},
			{ 1.7600E+02, 7.020000E+02},{ 1.7700E+02, 7.020000E+02},{ 1.7800E+02, 7.020000E+02},{ 1.7900E+02, 7.020000E+02},
			{ 1.8000E+02, 7.010000E+02},{ 1.8100E+02, 7.010000E+02},{ 1.8200E+02, 7.010000E+02},{ 1.8300E+02, 7.000000E+02},
			{ 1.8400E+02, 4.550000E+02},{ 1.8500E+02, 6.990000E+02},{ 1.8600E+02, 6.980000E+02},{ 1.8700E+02, 6.980000E+02},
			{ 1.8800E+02, 6.970000E+02},{ 1.8900E+02, 4.780000E+02},{ 1.9000E+02, 4.610000E+02},{ 1.9100E+02, 6.940000E+02},
			{ 1.9200E+02, 6.800000E+02},{ 1.9300E+02, 6.920000E+02},{ 1.9400E+02, 6.490000E+02},{ 1.9500E+02, 6.900000E+02},
			{ 1.9600E+02, 6.890000E+02},{ 1.9700E+02, 6.880000E+02},{ 1.9800E+02, 6.870000E+02},{ 1.9900E+02, 6.850000E+02},
			{ 2.0000E+02, 6.840000E+02},{ 2.0100E+02, 6.820000E+02},{ 2.0200E+02, 6.810000E+02},{ 2.0300E+02, 5.720000E+02},
			{ 2.0400E+02, 6.780000E+02},{ 2.0500E+02, 4.460000E+02},{ 2.0600E+02, 3.900000E+02},{ 2.0700E+02, 5.980000E+02},
			{ 2.0800E+02, 5.160000E+02},{ 2.0900E+02, 6.690000E+02},{ 2.1000E+02, 5.040000E+02},{ 2.1100E+02, 4.830000E+02},
			{ 2.1200E+02, 6.630000E+02},{ 2.1300E+02, 6.610000E+02},{ 2.1400E+02, 6.590000E+02},{ 2.1500E+02, 6.570000E+02},
			{ 2.1600E+02, 6.550000E+02},{ 2.1700E+02, 6.530000E+02},{ 2.1800E+02, 6.500000E+02},{ 2.1900E+02, 6.480000E+02},
			{ 2.2000E+02, 6.460000E+02},{ 2.2100E+02, 3.900000E+02},{ 2.2200E+02, 4.180000E+02},{ 2.2300E+02, 6.380000E+02},
			{ 2.2400E+02, 6.350000E+02},{ 2.2500E+02, 6.330000E+02},{ 2.2600E+02, 6.300000E+02},{ 2.2700E+02, 6.270000E+02},
			{ 2.2800E+02, 3.920000E+02},{ 2.2900E+02, 6.220000E+02},{ 2.3000E+02, 6.190000E+02},{ 2.3100E+02, 6.160000E+02},
			{ 2.3200E+02, 5.390000E+02},{ 2.3300E+02, 3.640000E+02},{ 2.3400E+02, 6.070000E+02},{ 2.3500E+02, 6.040000E+02},
			{ 2.3600E+02, 6.000000E+02},{ 2.3700E+02, 5.970000E+02},{ 2.3800E+02, 5.940000E+02},{ 2.3900E+02, 5.910000E+02},
			{ 2.4000E+02, 4.170000E+02},{ 2.4100E+02, 5.840000E+02},{ 2.4200E+02, 5.800000E+02},{ 2.4300E+02, 5.770000E+02},
			{ 2.4400E+02, 5.730000E+02},{ 2.4500E+02, 5.700000E+02},{ 2.4600E+02, 5.660000E+02},{ 2.4700E+02, 5.630000E+02},
			{ 2.4800E+02, 3.560000E+02},{ 2.4900E+02, 5.550000E+02},{ 2.5000E+02, 5.510000E+02},{ 2.5100E+02, 5.480000E+02},
			{ 2.5200E+02, 5.440000E+02},{ 2.5300E+02, 5.400000E+02},{ 2.5400E+02, 5.360000E+02},{ 2.5500E+02, 5.320000E+02},
			{ 2.5600E+02, 5.280000E+02},{ 2.5700E+02, 5.040000E+02},{ 2.5800E+02, 5.200000E+02},{ 2.5900E+02, 5.160000E+02},
			{ 2.6000E+02, 5.120000E+02},{ 2.6100E+02, 3.590000E+02},{ 2.6200E+02, 5.040000E+02},{ 2.6300E+02, 3.320000E+02},
			{ 2.6400E+02, 4.960000E+02},{ 2.6500E+02, 4.910000E+02},{ 2.6600E+02, 4.870000E+02},{ 2.6700E+02, 4.780000E+02},
			{ 2.6800E+02, 2.840000E+02},{ 2.6900E+02, 2.930000E+02},{ 2.7000E+02, 4.700000E+02},{ 2.7100E+02, 4.660000E+02},
			{ 2.7200E+02, 4.620000E+02},{ 2.7300E+02, 4.570000E+02},{ 2.7400E+02, 4.530000E+02},{ 2.7500E+02, 4.490000E+02},
			{ 2.7600E+02, 4.440000E+02},{ 2.7700E+02, 4.400000E+02},{ 2.7800E+02, 4.360000E+02},{ 2.7900E+02, 2.460000E+02},
			{ 2.8000E+02, 4.270000E+02},{ 2.8100E+02, 4.230000E+02},{ 2.8200E+02, 4.180000E+02},{ 2.8300E+02, 4.140000E+02},
			{ 2.8400E+02, 4.100000E+02},{ 2.8500E+02, 4.060000E+02},{ 2.8600E+02, 4.010000E+02},{ 2.8700E+02, 2.580000E+02},
			{ 2.8800E+02, 3.930000E+02},{ 2.8900E+02, 2.430000E+02},{ 2.9000E+02, 2.540000E+02},{ 2.9100E+02, 2.070000E+02},
			{ 2.9200E+02, 3.760000E+02},{ 2.9300E+02, 3.720000E+02},{ 2.9400E+02, 3.670000E+02},{ 2.9500E+02, 3.630000E+02},
			{ 2.9600E+02, 3.590000E+02},{ 2.9700E+02, 3.550000E+02},{ 2.9800E+02, 3.510000E+02},{ 2.9900E+02, 3.470000E+02},
			{ 3.0000E+02, 3.430000E+02},{ 3.0100E+02, 3.390000E+02},{ 3.0200E+02, 3.350000E+02},{ 3.0300E+02, 3.310000E+02},
			{ 3.0400E+02, 3.270000E+02},{ 3.0500E+02, 3.240000E+02},{ 3.0600E+02, 3.200000E+02},{ 3.0700E+02, 3.160000E+02},
			{ 3.0800E+02, 3.120000E+02},{ 3.0900E+02, 3.090000E+02},{ 3.1000E+02, 3.050000E+02},{ 3.1100E+02, 3.020000E+02},
			{ 3.1200E+02, 2.980000E+02},{ 3.1300E+02, 2.950000E+02},{ 3.1400E+02, 2.300000E+02},{ 3.1500E+02, 2.560000E+02},
			{ 3.1600E+02, 1.740000E+02},{ 3.1700E+02, 2.030000E+02},{ 3.1800E+02, 2.790000E+02},{ 3.1900E+02, 2.760000E+02},
			{ 3.2000E+02, 2.730000E+02},{ 3.2100E+02, 2.700000E+02},{ 3.2200E+02, 2.670000E+02},{ 3.2300E+02, 2.640000E+02},
			{ 3.2400E+02, 2.610000E+02},{ 3.2500E+02, 2.590000E+02},{ 3.2600E+02, 1.620000E+02},{ 3.2700E+02, 1.510000E+02},
			{ 3.2800E+02, 2.510000E+02},{ 3.2900E+02, 2.490000E+02},{ 3.3000E+02, 2.470000E+02},{ 3.3100E+02, 2.440000E+02},
			{ 3.3200E+02, 2.420000E+02},{ 3.3300E+02, 2.400000E+02},{ 3.3400E+02, 2.380000E+02},{ 3.3500E+02, 1.530000E+02},
			{ 3.3600E+02, 1.490000E+02},{ 3.3700E+02, 1.330000E+02},{ 3.3800E+02, 1.320000E+02},{ 3.3900E+02, 2.300000E+02},
			{ 3.4000E+02, 2.280000E+02},{ 3.4100E+02, 2.270000E+02},{ 3.4200E+02, 2.260000E+02},{ 3.4300E+02, 1.840000E+02},
			{ 3.4400E+02, 1.260000E+02},{ 3.4500E+02, 2.220000E+02},{ 3.4600E+02, 2.220000E+02},{ 3.4700E+02, 2.210000E+02},
			{ 3.4800E+02, 1.430000E+02},{ 3.4900E+02, 1.520000E+02},{ 3.5000E+02, 2.190000E+02},{ 3.5100E+02, 2.180000E+02},
			{ 3.5200E+02, 2.180000E+02},{ 3.5300E+02, 2.180000E+02},{ 3.5400E+02, 2.170000E+02},{ 3.5500E+02, 1.870000E+02},
			{ 3.5600E+02, 2.170000E+02},{ 3.5700E+02, 2.170000E+02},{ 3.5800E+02, 1.300000E+02},{ 3.5900E+02, 2.180000E+02},
			{ 3.6000E+02, 2.180000E+02},{ 3.6100E+02, 2.190000E+02},{ 3.6200E+02, 2.150000E+02},{ 3.6300E+02, 1.230000E+02},
			{ 3.6400E+02, 1.440000E+02},{ 3.6500E+02, 2.220000E+02}, };
		return SL::Graph( 0, x, 365, g); 
	}

	inline double Graph16(double x) { 
		static double g[365][2] = {
			{ 0.0000E+00, 0.000000E+00},{ 1.0000E+00, 0.000000E+00},{ 2.0000E+00, 0.000000E+00},{ 3.0000E+00, 0.000000E+00},
			{ 4.0000E+00, 0.000000E+00},{ 5.0000E+00, 4.190000E-05},{ 6.0000E+00, 3.080000E-05},{ 7.0000E+00, 0.000000E+00},
			{ 8.0000E+00, 0.000000E+00},{ 9.0000E+00, 4.510000E-05},{ 1.0000E+01, 1.260000E-03},{ 1.1000E+01, 4.560000E-03},
			{ 1.2000E+01, 0.000000E+00},{ 1.3000E+01, 0.000000E+00},{ 1.4000E+01, 1.940000E-05},{ 1.5000E+01, 2.800000E-05},
			{ 1.6000E+01, 8.600000E-06},{ 1.7000E+01, 0.000000E+00},{ 1.8000E+01, 0.000000E+00},{ 1.9000E+01, 2.540000E-06},
			{ 2.0000E+01, 2.540000E-06},{ 2.1000E+01, 0.000000E+00},{ 2.2000E+01, 0.000000E+00},{ 2.3000E+01, 0.000000E+00},
			{ 2.4000E+01, 0.000000E+00},{ 2.5000E+01, 0.000000E+00},{ 2.6000E+01, 1.890000E-11},{ 2.7000E+01, 0.000000E+00},
			{ 2.8000E+01, 0.000000E+00},{ 2.9000E+01, 3.180000E-06},{ 3.0000E+01, 3.180000E-06},{ 3.1000E+01, 0.000000E+00},
			{ 3.2000E+01, 0.000000E+00},{ 3.3000E+01, 0.000000E+00},{ 3.4000E+01, 0.000000E+00},{ 3.5000E+01, 1.900000E-06},
			{ 3.6000E+01, 1.460000E-05},{ 3.7000E+01, 1.400000E-05},{ 3.8000E+01, 0.000000E+00},{ 3.9000E+01, 0.000000E+00},
			{ 4.0000E+01, 0.000000E+00},{ 4.1000E+01, 0.000000E+00},{ 4.2000E+01, 0.000000E+00},{ 4.3000E+01, 1.900000E-05},
			{ 4.4000E+01, 1.900000E-05},{ 4.5000E+01, 0.000000E+00},{ 4.6000E+01, 0.000000E+00},{ 4.7000E+01, 0.000000E+00},
			{ 4.8000E+01, 2.140000E-05},{ 4.9000E+01, 2.080000E-05},{ 5.0000E+01, 1.470000E-05},{ 5.1000E+01, 0.000000E+00},
			{ 5.2000E+01, 0.000000E+00},{ 5.3000E+01, 0.000000E+00},{ 5.4000E+01, 4.260000E-10},{ 5.5000E+01, 6.350000E-07},
			{ 5.6000E+01, 6.350000E-07},{ 5.7000E+01, 0.000000E+00},{ 5.8000E+01, 0.000000E+00},{ 5.9000E+01, 8.250000E-06},
			{ 6.0000E+01, 8.250000E-06},{ 6.1000E+01, 3.920000E-05},{ 6.2000E+01, 3.630000E-04},{ 6.3000E+01, 0.000000E+00},
			{ 6.4000E+01, 1.020000E-05},{ 6.5000E+01, 1.020000E-05},{ 6.6000E+01, 0.000000E+00},{ 6.7000E+01, 0.000000E+00},
			{ 6.8000E+01, 0.000000E+00},{ 6.9000E+01, 0.000000E+00},{ 7.0000E+01, 0.000000E+00},{ 7.1000E+01, 2.160000E-05},
			{ 7.2000E+01, 2.980000E-05},{ 7.3000E+01, 8.250000E-06},{ 7.4000E+01, 0.000000E+00},{ 7.5000E+01, 5.780000E-05},
			{ 7.6000E+01, 1.190000E-03},{ 7.7000E+01, 0.000000E+00},{ 7.8000E+01, 6.350000E-07},{ 7.9000E+01, 6.350000E-07},
			{ 8.0000E+01, 1.040000E-03},{ 8.1000E+01, 5.950000E-03},{ 8.2000E+01, 2.060000E-03},{ 8.3000E+01, 0.000000E+00},
			{ 8.4000E+01, 1.210000E-05},{ 8.5000E+01, 1.210000E-05},{ 8.6000E+01, 2.700000E-06},{ 8.7000E+01, 6.430000E-05},
			{ 8.8000E+01, 1.380000E-03},{ 8.9000E+01, 0.000000E+00},{ 9.0000E+01, 0.000000E+00},{ 9.1000E+01, 0.000000E+00},
			{ 9.2000E+01, 0.000000E+00},{ 9.3000E+01, 0.000000E+00},{ 9.4000E+01, 6.350000E-06},{ 9.5000E+01, 6.350000E-06},
			{ 9.6000E+01, 0.000000E+00},{ 9.7000E+01, 0.000000E+00},{ 9.8000E+01, 0.000000E+00},{ 9.9000E+01, 0.000000E+00},
			{ 1.0000E+02, 0.000000E+00},{ 1.0100E+02, 0.000000E+00},{ 1.0200E+02, 3.560000E-05},{ 1.0300E+02, 7.800000E-05},
			{ 1.0400E+02, 0.000000E+00},{ 1.0500E+02, 4.440000E-06},{ 1.0600E+02, 0.000000E+00},{ 1.0700E+02, 0.000000E+00},
			{ 1.0800E+02, 1.900000E-06},{ 1.0900E+02, 3.180000E-06},{ 1.1000E+02, 1.210000E-05},{ 1.1100E+02, 1.080000E-05},
			{ 1.1200E+02, 0.000000E+00},{ 1.1300E+02, 6.350000E-06},{ 1.1400E+02, 6.350000E-06},{ 1.1500E+02, 0.000000E+00},
			{ 1.1600E+02, 1.590000E-05},{ 1.1700E+02, 3.810000E-05},{ 1.1800E+02, 3.050000E-05},{ 1.1900E+02, 9.520000E-06},
			{ 1.2000E+02, 9.840000E-06},{ 1.2100E+02, 8.570000E-06},{ 1.2200E+02, 0.000000E+00},{ 1.2300E+02, 0.000000E+00},
			{ 1.2400E+02, 2.980000E-05},{ 1.2500E+02, 3.940000E-05},{ 1.2600E+02, 1.020000E-05},{ 1.2700E+02, 0.000000E+00},
			{ 1.2800E+02, 9.520000E-06},{ 1.2900E+02, 9.520000E-06},{ 1.3000E+02, 0.000000E+00},{ 1.3100E+02, 0.000000E+00},
			{ 1.3200E+02, 0.000000E+00},{ 1.3300E+02, 0.000000E+00},{ 1.3400E+02, 0.000000E+00},{ 1.3500E+02, 0.000000E+00},
			{ 1.3600E+02, 7.910000E-04},{ 1.3700E+02, 2.490000E-03},{ 1.3800E+02, 0.000000E+00},{ 1.3900E+02, 0.000000E+00},
			{ 1.4000E+02, 0.000000E+00},{ 1.4100E+02, 0.000000E+00},{ 1.4200E+02, 0.000000E+00},{ 1.4300E+02, 0.000000E+00},
			{ 1.4400E+02, 0.000000E+00},{ 1.4500E+02, 0.000000E+00},{ 1.4600E+02, 1.270000E-06},{ 1.4700E+02, 1.270000E-06},
			{ 1.4800E+02, 0.000000E+00},{ 1.4900E+02, 0.000000E+00},{ 1.5000E+02, 0.000000E+00},{ 1.5100E+02, 2.100000E-05},
			{ 1.5200E+02, 2.100000E-05},{ 1.5300E+02, 0.000000E+00},{ 1.5400E+02, 0.000000E+00},{ 1.5500E+02, 0.000000E+00},
			{ 1.5600E+02, 0.000000E+00},{ 1.5700E+02, 0.000000E+00},{ 1.5800E+02, 0.000000E+00},{ 1.5900E+02, 0.000000E+00},
			{ 1.6000E+02, 0.000000E+00},{ 1.6100E+02, 0.000000E+00},{ 1.6200E+02, 0.000000E+00},{ 1.6300E+02, 0.000000E+00},
			{ 1.6400E+02, 0.000000E+00},{ 1.6500E+02, 0.000000E+00},{ 1.6600E+02, 0.000000E+00},{ 1.6700E+02, 3.780000E-04},
			{ 1.6800E+02, 2.080000E-03},{ 1.6900E+02, 0.000000E+00},{ 1.7000E+02, 0.000000E+00},{ 1.7100E+02, 0.000000E+00},
			{ 1.7200E+02, 1.900000E-05},{ 1.7300E+02, 2.350000E-05},{ 1.7400E+02, 7.300000E-06},{ 1.7500E+02, 0.000000E+00},
			{ 1.7600E+02, 0.000000E+00},{ 1.7700E+02, 0.000000E+00},{ 1.7800E+02, 0.000000E+00},{ 1.7900E+02, 0.000000E+00},
			{ 1.8000E+02, 0.000000E+00},{ 1.8100E+02, 0.000000E+00},{ 1.8200E+02, 3.490000E-05},{ 1.8300E+02, 4.620000E-05},
			{ 1.8400E+02, 0.000000E+00},{ 1.8500E+02, 1.900000E-06},{ 1.8600E+02, 9.520000E-07},{ 1.8700E+02, 2.140000E-05},
			{ 1.8800E+02, 3.980000E-05},{ 1.8900E+02, 1.940000E-05},{ 1.9000E+02, 0.000000E+00},{ 1.9100E+02, 3.170000E-07},
			{ 1.9200E+02, 3.730000E-06},{ 1.9300E+02, 3.770000E-06},{ 1.9400E+02, 0.000000E+00},{ 1.9500E+02, 0.000000E+00},
			{ 1.9600E+02, 0.000000E+00},{ 1.9700E+02, 0.000000E+00},{ 1.9800E+02, 0.000000E+00},{ 1.9900E+02, 0.000000E+00},
			{ 2.0000E+02, 0.000000E+00},{ 2.0100E+02, 6.350000E-06},{ 2.0200E+02, 6.350000E-06},{ 2.0300E+02, 2.250000E-05},
			{ 2.0400E+02, 4.120000E-03},{ 2.0500E+02, 7.210000E-03},{ 2.0600E+02, 1.820000E-03},{ 2.0700E+02, 0.000000E+00},
			{ 2.0800E+02, 1.080000E-05},{ 2.0900E+02, 2.290000E-05},{ 2.1000E+02, 1.210000E-05},{ 2.1100E+02, 0.000000E+00},
			{ 2.1200E+02, 0.000000E+00},{ 2.1300E+02, 0.000000E+00},{ 2.1400E+02, 0.000000E+00},{ 2.1500E+02, 0.000000E+00},
			{ 2.1600E+02, 0.000000E+00},{ 2.1700E+02, 0.000000E+00},{ 2.1800E+02, 0.000000E+00},{ 2.1900E+02, 2.510000E-04},
			{ 2.2000E+02, 1.950000E-03},{ 2.2100E+02, 5.130000E-04},{ 2.2200E+02, 0.000000E+00},{ 2.2300E+02, 0.000000E+00},
			{ 2.2400E+02, 0.000000E+00},{ 2.2500E+02, 1.270000E-06},{ 2.2600E+02, 3.430000E-05},{ 2.2700E+02, 3.300000E-05},
			{ 2.2800E+02, 0.000000E+00},{ 2.2900E+02, 0.000000E+00},{ 2.3000E+02, 5.080000E-06},{ 2.3100E+02, 6.160000E-05},
			{ 2.3200E+02, 1.130000E-03},{ 2.3300E+02, 0.000000E+00},{ 2.3400E+02, 0.000000E+00},{ 2.3500E+02, 0.000000E+00},
			{ 2.3600E+02, 0.000000E+00},{ 2.3700E+02, 0.000000E+00},{ 2.3800E+02, 1.400000E-05},{ 2.3900E+02, 1.400000E-05},
			{ 2.4000E+02, 0.000000E+00},{ 2.4100E+02, 0.000000E+00},{ 2.4200E+02, 0.000000E+00},{ 2.4300E+02, 0.000000E+00},
			{ 2.4400E+02, 0.000000E+00},{ 2.4500E+02, 0.000000E+00},{ 2.4600E+02, 3.240000E-05},{ 2.4700E+02, 3.370000E-05},
			{ 2.4800E+02, 0.000000E+00},{ 2.4900E+02, 0.000000E+00},{ 2.5000E+02, 0.000000E+00},{ 2.5100E+02, 0.000000E+00},
			{ 2.5200E+02, 0.000000E+00},{ 2.5300E+02, 0.000000E+00},{ 2.5400E+02, 0.000000E+00},{ 2.5500E+02, 2.540000E-06},
			{ 2.5600E+02, 2.540000E-06},{ 2.5700E+02, 0.000000E+00},{ 2.5800E+02, 0.000000E+00},{ 2.5900E+02, 2.160000E-05},
			{ 2.6000E+02, 2.160000E-05},{ 2.6100E+02, 7.300000E-06},{ 2.6200E+02, 1.000000E-05},{ 2.6300E+02, 0.000000E+00},
			{ 2.6400E+02, 0.000000E+00},{ 2.6500E+02, 1.900000E-06},{ 2.6600E+02, 6.920000E-05},{ 2.6700E+02, 2.040000E-03},
			{ 2.6800E+02, 0.000000E+00},{ 2.6900E+02, 0.000000E+00},{ 2.7000E+02, 0.000000E+00},{ 2.7100E+02, 0.000000E+00},
			{ 2.7200E+02, 0.000000E+00},{ 2.7300E+02, 0.000000E+00},{ 2.7400E+02, 1.900000E-06},{ 2.7500E+02, 1.900000E-06},
			{ 2.7600E+02, 0.000000E+00},{ 2.7700E+02, 6.640000E-04},{ 2.7800E+02, 2.360000E-03},{ 2.7900E+02, 0.000000E+00},
			{ 2.8000E+02, 0.000000E+00},{ 2.8100E+02, 0.000000E+00},{ 2.8200E+02, 0.000000E+00},{ 2.8300E+02, 0.000000E+00},
			{ 2.8400E+02, 0.000000E+00},{ 2.8500E+02, 1.020000E-05},{ 2.8600E+02, 1.020000E-05},{ 2.8700E+02, 1.840000E-05},
			{ 2.8800E+02, 3.050000E-05},{ 2.8900E+02, 1.420000E-03},{ 2.9000E+02, 2.920000E-03},{ 2.9100E+02, 0.000000E+00},
			{ 2.9200E+02, 0.000000E+00},{ 2.9300E+02, 0.000000E+00},{ 2.9400E+02, 0.000000E+00},{ 2.9500E+02, 0.000000E+00},
			{ 2.9600E+02, 1.270000E-06},{ 2.9700E+02, 1.270000E-06},{ 2.9800E+02, 0.000000E+00},{ 2.9900E+02, 1.270000E-06},
			{ 3.0000E+02, 1.270000E-06},{ 3.0100E+02, 0.000000E+00},{ 3.0200E+02, 0.000000E+00},{ 3.0300E+02, 0.000000E+00},
			{ 3.0400E+02, 0.000000E+00},{ 3.0500E+02, 0.000000E+00},{ 3.0600E+02, 0.000000E+00},{ 3.0700E+02, 0.000000E+00},
			{ 3.0800E+02, 0.000000E+00},{ 3.0900E+02, 0.000000E+00},{ 3.1000E+02, 0.000000E+00},{ 3.1100E+02, 0.000000E+00},
			{ 3.1200E+02, 1.900000E-06},{ 3.1300E+02, 3.180000E-06},{ 3.1400E+02, 1.400000E-05},{ 3.1500E+02, 1.650000E-05},
			{ 3.1600E+02, 4.440000E-06},{ 3.1700E+02, 0.000000E+00},{ 3.1800E+02, 0.000000E+00},{ 3.1900E+02, 0.000000E+00},
			{ 3.2000E+02, 0.000000E+00},{ 3.2100E+02, 0.000000E+00},{ 3.2200E+02, 0.000000E+00},{ 3.2300E+02, 0.000000E+00},
			{ 3.2400E+02, 3.560000E-05},{ 3.2500E+02, 6.640000E-04},{ 3.2600E+02, 5.860000E-04},{ 3.2700E+02, 0.000000E+00},
			{ 3.2800E+02, 0.000000E+00},{ 3.2900E+02, 0.000000E+00},{ 3.3000E+02, 0.000000E+00},{ 3.3100E+02, 0.000000E+00},
			{ 3.3200E+02, 0.000000E+00},{ 3.3300E+02, 2.600000E-05},{ 3.3400E+02, 4.760000E-05},{ 3.3500E+02, 6.010000E-04},
			{ 3.3600E+02, 2.020000E-03},{ 3.3700E+02, 0.000000E+00},{ 3.3800E+02, 0.000000E+00},{ 3.3900E+02, 0.000000E+00},
			{ 3.4000E+02, 0.000000E+00},{ 3.4100E+02, 2.540000E-06},{ 3.4200E+02, 5.370000E-04},{ 3.4300E+02, 2.310000E-03},
			{ 3.4400E+02, 0.000000E+00},{ 3.4500E+02, 6.350000E-07},{ 3.4600E+02, 1.520000E-05},{ 3.4700E+02, 1.780000E-05},
			{ 3.4800E+02, 5.720000E-06},{ 3.4900E+02, 0.000000E+00},{ 3.5000E+02, 0.000000E+00},{ 3.5100E+02, 0.000000E+00},
			{ 3.5200E+02, 0.000000E+00},{ 3.5300E+02, 0.000000E+00},{ 3.5400E+02, 1.430000E-06},{ 3.5500E+02, 0.000000E+00},
			{ 3.5600E+02, 1.400000E-05},{ 3.5700E+02, 1.400000E-05},{ 3.5800E+02, 0.000000E+00},{ 3.5900E+02, 6.200000E-10},
			{ 3.6000E+02, 6.350000E-07},{ 3.6100E+02, 5.650000E-05},{ 3.6200E+02, 1.090000E-03},{ 3.6300E+02, 0.000000E+00},
			{ 3.6400E+02, 0.000000E+00}, };
		return SL::Graph( 0, x, 364, g); 
	}

	inline double Graph17(double x) { 
		static double g[364][2] = {
			{ 0.0000E+00, 0.000000E+00},{ 1.0000E+00, 0.000000E+00},{ 2.0000E+00, 0.000000E+00},{ 3.0000E+00, 0.000000E+00},
			{ 4.0000E+00, 4.190000E-05},{ 5.0000E+00, 1.380000E-04},{ 6.0000E+00, 0.000000E+00},{ 7.0000E+00, 0.000000E+00},
			{ 8.0000E+00, 1.280000E-04},{ 9.0000E+00, 1.390000E-03},{ 1.0000E+01, 1.620000E-02},{ 1.1000E+01, 1.870000E-03},
			{ 1.2000E+01, 7.590000E-06},{ 1.3000E+01, 2.060000E-05},{ 1.4000E+01, 1.270000E-04},{ 1.5000E+01, 7.310000E-05},
			{ 1.6000E+01, 8.900000E-06},{ 1.7000E+01, 3.640000E-09},{ 1.8000E+01, 2.540000E-06},{ 1.9000E+01, 1.520000E-05},
			{ 2.0000E+01, 2.540000E-06},{ 2.1000E+01, 0.000000E+00},{ 2.2000E+01, 0.000000E+00},{ 2.3000E+01, 0.000000E+00},
			{ 2.4000E+01, 0.000000E+00},{ 2.5000E+01, 1.890000E-11},{ 2.6000E+01, 1.420000E-11},{ 2.7000E+01, 3.550000E-12},
			{ 2.8000E+01, 3.180000E-06},{ 2.9000E+01, 1.900000E-05},{ 3.0000E+01, 3.180000E-06},{ 3.1000E+01, 2.770000E-14},
			{ 3.2000E+01, 6.940000E-15},{ 3.3000E+01, 1.730000E-15},{ 3.4000E+01, 1.900000E-06},{ 3.5000E+01, 2.410000E-05},
			{ 3.6000E+01, 7.940000E-05},{ 3.7000E+01, 2.030000E-05},{ 3.8000E+01, 1.270000E-06},{ 3.9000E+01, 4.230000E-19},
			{ 4.0000E+01, 1.060000E-19},{ 4.1000E+01, 1.760000E-20},{ 4.2000E+01, 1.900000E-05},{ 4.3000E+01, 1.140000E-04},
			{ 4.4000E+01, 1.900000E-05},{ 4.5000E+01, 2.760000E-22},{ 4.6000E+01, 0.000000E+00},{ 4.7000E+01, 5.290000E-05},
			{ 4.8000E+01, 5.020000E-05},{ 4.9000E+01, 5.180000E-05},{ 5.0000E+01, 7.700000E-06},{ 5.1000E+01, 2.050000E-08},
			{ 5.2000E+01, 5.120000E-09},{ 5.3000E+01, 1.280000E-09},{ 5.4000E+01, 6.350000E-07},{ 5.5000E+01, 3.810000E-06},
			{ 5.6000E+01, 6.350000E-07},{ 5.7000E+01, 5.000000E-12},{ 5.8000E+01, 8.260000E-06},{ 5.9000E+01, 4.950000E-05},
			{ 6.0000E+01, 4.950000E-05},{ 6.1000E+01, 1.550000E-03},{ 6.2000E+01, 8.700000E-05},{ 6.3000E+01, 1.780000E-05},
			{ 6.4000E+01, 6.100000E-05},{ 6.5000E+01, 1.020000E-05},{ 6.6000E+01, 1.910000E-17},{ 6.7000E+01, 4.760000E-18},
			{ 6.8000E+01, 1.190000E-18},{ 6.9000E+01, 2.980000E-19},{ 7.0000E+01, 2.160000E-05},{ 7.1000E+01, 1.380000E-04},
			{ 7.2000E+01, 7.110000E-05},{ 7.3000E+01, 8.250000E-06},{ 7.4000E+01, 5.780000E-05},{ 7.5000E+01, 4.870000E-03},
			{ 7.6000E+01, 6.160000E-05},{ 7.7000E+01, 1.270000E-06},{ 7.8000E+01, 3.810000E-06},{ 7.9000E+01, 1.050000E-03},
			{ 8.0000E+01, 1.570000E-02},{ 8.1000E+01, 7.320000E-03},{ 8.2000E+01, 5.590000E-05},{ 8.3000E+01, 1.270000E-05},
			{ 8.4000E+01, 7.240000E-05},{ 8.5000E+01, 1.780000E-05},{ 8.6000E+01, 9.590000E-05},{ 8.7000E+01, 5.650000E-03},
			{ 8.8000E+01, 6.160000E-05},{ 8.9000E+01, 2.710000E-31},{ 9.0000E+01, 6.770000E-32},{ 9.1000E+01, 1.690000E-32},
			{ 9.2000E+01, 4.230000E-33},{ 9.3000E+01, 6.350000E-06},{ 9.4000E+01, 3.810000E-05},{ 9.5000E+01, 6.350000E-06},
			{ 9.6000E+01, 1.650000E-35},{ 9.7000E+01, 4.130000E-36},{ 9.8000E+01, 1.030000E-36},{ 9.9000E+01, 2.580000E-37},
			{ 1.0000E+02, 6.460000E-38},{ 1.0100E+02, 3.560000E-05},{ 1.0200E+02, 3.910000E-04},{ 1.0300E+02, 9.780000E-05},
			{ 1.0400E+02, 1.070000E-04},{ 1.0500E+02, 1.650000E-05},{ 1.0600E+02, 1.579964E-41},{ 1.0700E+02, 1.900000E-06},
			{ 1.0800E+02, 1.270000E-05},{ 1.0900E+02, 2.030000E-05},{ 1.1000E+02, 6.600000E-05},{ 1.1100E+02, 1.080000E-05},
			{ 1.1200E+02, 6.350000E-06},{ 1.1300E+02, 3.810000E-05},{ 1.1400E+02, 6.350000E-06},{ 1.1500E+02, 1.590000E-05},
			{ 1.1600E+02, 1.170000E-04},{ 1.1700E+02, 1.570000E-04},{ 1.1800E+02, 7.300000E-05},{ 1.1900E+02, 2.220000E-05},
			{ 1.2000E+02, 3.940000E-05},{ 1.2100E+02, 6.350000E-06},{ 1.2200E+02, 0.000000E+00},{ 1.2300E+02, 2.980000E-05},
			{ 1.2400E+02, 1.890000E-04},{ 1.2500E+02, 8.700000E-05},{ 1.2600E+02, 9.520000E-06},{ 1.2700E+02, 9.520000E-06},
			{ 1.2800E+02, 5.720000E-05},{ 1.2900E+02, 9.520000E-06},{ 1.3000E+02, 0.000000E+00},{ 1.3100E+02, 0.000000E+00},
			{ 1.3200E+02, 0.000000E+00},{ 1.3300E+02, 0.000000E+00},{ 1.3400E+02, 0.000000E+00},{ 1.3500E+02, 7.910000E-04},
			{ 1.3600E+02, 1.180000E-02},{ 1.3700E+02, 1.110000E-03},{ 1.3800E+02, 5.720000E-06},{ 1.3900E+02, 0.000000E+00},
			{ 1.4000E+02, 0.000000E+00},{ 1.4100E+02, 0.000000E+00},{ 1.4200E+02, 0.000000E+00},{ 1.4300E+02, 0.000000E+00},
			{ 1.4400E+02, 0.000000E+00},{ 1.4500E+02, 1.270000E-06},{ 1.4600E+02, 7.620000E-06},{ 1.4700E+02, 1.270000E-06},
			{ 1.4800E+02, 0.000000E+00},{ 1.4900E+02, 0.000000E+00},{ 1.5000E+02, 2.100000E-05},{ 1.5100E+02, 1.260000E-04},
			{ 1.5200E+02, 2.100000E-05},{ 1.5300E+02, 0.000000E+00},{ 1.5400E+02, 0.000000E+00},{ 1.5500E+02, 0.000000E+00},
			{ 1.5600E+02, 0.000000E+00},{ 1.5700E+02, 0.000000E+00},{ 1.5800E+02, 0.000000E+00},{ 1.5900E+02, 0.000000E+00},
			{ 1.6000E+02, 0.000000E+00},{ 1.6100E+02, 0.000000E+00},{ 1.6200E+02, 0.000000E+00},{ 1.6300E+02, 0.000000E+00},
			{ 1.6400E+02, 0.000000E+00},{ 1.6500E+02, 0.000000E+00},{ 1.6600E+02, 3.780000E-04},{ 1.6700E+02, 9.360000E-03},
			{ 1.6800E+02, 6.930000E-04},{ 1.6900E+02, 5.720000E-06},{ 1.7000E+02, 0.000000E+00},{ 1.7100E+02, 1.900000E-05},
			{ 1.7200E+02, 1.190000E-04},{ 1.7300E+02, 4.570000E-05},{ 1.7400E+02, 4.440000E-06},{ 1.7500E+02, 0.000000E+00},
			{ 1.7600E+02, 0.000000E+00},{ 1.7700E+02, 0.000000E+00},{ 1.7800E+02, 0.000000E+00},{ 1.7900E+02, 0.000000E+00},
			{ 1.8000E+02, 0.000000E+00},{ 1.8100E+02, 3.490000E-05},{ 1.8200E+02, 2.550000E-04},{ 1.8300E+02, 3.680000E-05},
			{ 1.8400E+02, 1.330000E-05},{ 1.8500E+02, 1.330000E-05},{ 1.8600E+02, 2.350000E-05},{ 1.8700E+02, 1.480000E-04},
			{ 1.8800E+02, 1.330000E-04},{ 1.8900E+02, 2.790000E-05},{ 1.9000E+02, 1.270000E-05},{ 1.9100E+02, 5.720000E-06},
			{ 1.9200E+02, 2.290000E-05},{ 1.9300E+02, 3.810000E-06},{ 1.9400E+02, 0.000000E+00},{ 1.9500E+02, 0.000000E+00},
			{ 1.9600E+02, 0.000000E+00},{ 1.9700E+02, 0.000000E+00},{ 1.9800E+02, 0.000000E+00},{ 1.9900E+02, 0.000000E+00},
			{ 2.0000E+02, 6.350000E-06},{ 2.0100E+02, 3.810000E-05},{ 2.0200E+02, 3.050000E-05},{ 2.0300E+02, 4.250000E-03},
			{ 2.0400E+02, 2.580000E-02},{ 2.0500E+02, 3.210000E-03},{ 2.0600E+02, 6.220000E-05},{ 2.0700E+02, 2.030000E-05},
			{ 2.0800E+02, 7.680000E-05},{ 2.0900E+02, 8.320000E-05},{ 2.1000E+02, 1.210000E-05},{ 2.1100E+02, 0.000000E+00},
			{ 2.1200E+02, 0.000000E+00},{ 2.1300E+02, 0.000000E+00},{ 2.1400E+02, 0.000000E+00},{ 2.1500E+02, 0.000000E+00},
			{ 2.1600E+02, 0.000000E+00},{ 2.1700E+02, 0.000000E+00},{ 2.1800E+02, 2.510000E-04},{ 2.1900E+02, 9.550000E-03},
			{ 2.2000E+02, 1.610000E-03},{ 2.2100E+02, 2.480000E-05},{ 2.2200E+02, 0.000000E+00},{ 2.2300E+02, 0.000000E+00},
			{ 2.2400E+02, 1.270000E-06},{ 2.2500E+02, 4.060000E-05},{ 2.2600E+02, 1.990000E-04},{ 2.2700E+02, 3.300000E-05},
			{ 2.2800E+02, 0.000000E+00},{ 2.2900E+02, 5.080000E-06},{ 2.3000E+02, 8.700000E-05},{ 2.3100E+02, 4.620000E-03},
			{ 2.3200E+02, 5.650000E-05},{ 2.3300E+02, 0.000000E+00},{ 2.3400E+02, 0.000000E+00},{ 2.3500E+02, 0.000000E+00},
			{ 2.3600E+02, 0.000000E+00},{ 2.3700E+02, 1.400000E-05},{ 2.3800E+02, 8.380000E-05},{ 2.3900E+02, 1.400000E-05},
			{ 2.4000E+02, 0.000000E+00},{ 2.4100E+02, 0.000000E+00},{ 2.4200E+02, 0.000000E+00},{ 2.4300E+02, 0.000000E+00},
			{ 2.4400E+02, 0.000000E+00},{ 2.4500E+02, 3.240000E-05},{ 2.4600E+02, 1.960000E-04},{ 2.4700E+02, 4.000000E-05},
			{ 2.4800E+02, 1.270000E-06},{ 2.4900E+02, 0.000000E+00},{ 2.5000E+02, 0.000000E+00},{ 2.5100E+02, 0.000000E+00},
			{ 2.5200E+02, 0.000000E+00},{ 2.5300E+02, 0.000000E+00},{ 2.5400E+02, 2.540000E-06},{ 2.5500E+02, 1.520000E-05},
			{ 2.5600E+02, 2.540000E-06},{ 2.5700E+02, 0.000000E+00},{ 2.5800E+02, 2.160000E-05},{ 2.5900E+02, 1.300000E-04},
			{ 2.6000E+02, 3.430000E-05},{ 2.6100E+02, 7.620000E-05},{ 2.6200E+02, 1.270000E-05},{ 2.6300E+02, 0.000000E+00},
			{ 2.6400E+02, 1.900000E-06},{ 2.6500E+02, 7.870000E-05},{ 2.6600E+02, 7.930000E-03},{ 2.6700E+02, 1.330000E-03},
			{ 2.6800E+02, 2.480000E-05},{ 2.6900E+02, 0.000000E+00},{ 2.7000E+02, 0.000000E+00},{ 2.7100E+02, 0.000000E+00},
			{ 2.7200E+02, 0.000000E+00},{ 2.7300E+02, 1.900000E-06},{ 2.7400E+02, 1.140000E-05},{ 2.7500E+02, 1.900000E-06},
			{ 2.7600E+02, 6.640000E-04},{ 2.7700E+02, 1.080000E-02},{ 2.7800E+02, 6.640000E-04},{ 2.7900E+02, 0.000000E+00},
			{ 2.8000E+02, 0.000000E+00},{ 2.8100E+02, 0.000000E+00},{ 2.8200E+02, 0.000000E+00},{ 2.8300E+02, 0.000000E+00},
			{ 2.8400E+02, 1.020000E-05},{ 2.8500E+02, 6.100000E-05},{ 2.8600E+02, 3.110000E-05},{ 2.8700E+02, 1.380000E-04},
			{ 2.8800E+02, 1.510000E-03},{ 2.8900E+02, 1.230000E-02},{ 2.9000E+02, 8.230000E-04},{ 2.9100E+02, 0.000000E+00},
			{ 2.9200E+02, 0.000000E+00},{ 2.9300E+02, 0.000000E+00},{ 2.9400E+02, 0.000000E+00},{ 2.9500E+02, 1.270000E-06},
			{ 2.9600E+02, 7.620000E-06},{ 2.9700E+02, 1.270000E-06},{ 2.9800E+02, 1.270000E-06},{ 2.9900E+02, 7.620000E-06},
			{ 3.0000E+02, 1.270000E-06},{ 3.0100E+02, 0.000000E+00},{ 3.0200E+02, 0.000000E+00},{ 3.0300E+02, 0.000000E+00},
			{ 3.0400E+02, 0.000000E+00},{ 3.0500E+02, 0.000000E+00},{ 3.0600E+02, 0.000000E+00},{ 3.0700E+02, 0.000000E+00},
			{ 3.0800E+02, 0.000000E+00},{ 3.0900E+02, 0.000000E+00},{ 3.1000E+02, 0.000000E+00},{ 3.1100E+02, 1.900000E-06},
			{ 3.1200E+02, 1.270000E-05},{ 3.1300E+02, 2.220000E-05},{ 3.1400E+02, 8.130000E-05},{ 3.1500E+02, 3.560000E-05},
			{ 3.1600E+02, 3.810000E-06},{ 3.1700E+02, 0.000000E+00},{ 3.1800E+02, 0.000000E+00},{ 3.1900E+02, 0.000000E+00},
			{ 3.2000E+02, 0.000000E+00},{ 3.2100E+02, 0.000000E+00},{ 3.2200E+02, 0.000000E+00},{ 3.2300E+02, 3.560000E-05},
			{ 3.2400E+02, 1.010000E-03},{ 3.2500E+02, 3.050000E-03},{ 3.2600E+02, 4.570000E-05},{ 3.2700E+02, 0.000000E+00},
			{ 3.2800E+02, 0.000000E+00},{ 3.2900E+02, 0.000000E+00},{ 3.3000E+02, 0.000000E+00},{ 3.3100E+02, 0.000000E+00},
			{ 3.3200E+02, 2.600000E-05},{ 3.3300E+02, 1.780000E-04},{ 3.3400E+02, 7.340000E-04},{ 3.3500E+02, 6.620000E-03},
			{ 3.3600E+02, 1.300000E-03},{ 3.3700E+02, 3.240000E-05},{ 3.3800E+02, 0.000000E+00},{ 3.3900E+02, 0.000000E+00},
			{ 3.4000E+02, 2.540000E-06},{ 3.4100E+02, 5.500000E-04},{ 3.4200E+02, 9.390000E-03},{ 3.4300E+02, 4.100000E-04},
			{ 3.4400E+02, 6.350000E-07},{ 3.4500E+02, 1.840000E-05},{ 3.4600E+02, 9.140000E-05},{ 3.4700E+02, 3.370000E-05},
			{ 3.4800E+02, 3.180000E-06},{ 3.4900E+02, 0.000000E+00},{ 3.5000E+02, 0.000000E+00},{ 3.5100E+02, 0.000000E+00},
			{ 3.5200E+02, 0.000000E+00},{ 3.5300E+02, 4.290000E-06},{ 3.5400E+02, 7.540000E-07},{ 3.5500E+02, 1.400000E-05},
			{ 3.5600E+02, 8.380000E-05},{ 3.5700E+02, 1.400000E-05},{ 3.5800E+02, 6.200000E-10},{ 3.5900E+02, 6.350000E-07},
			{ 3.6000E+02, 5.970000E-05},{ 3.6100E+02, 4.500000E-03},{ 3.6200E+02, 1.020000E-04},{ 3.6300E+02, 7.620000E-06},
			 };
		return SL::Graph( 0, x, 363, g); 
	}

	inline double Graph18(double x) { 
		static double g[364][2] = {
			{ 0.0000E+00, 0.000000E+00},{ 1.0000E+00, 0.000000E+00},{ 2.0000E+00, 0.000000E+00},{ 3.0000E+00, 0.000000E+00},
			{ 4.0000E+00, 0.000000E+00},{ 5.0000E+00, 6.320000E-05},{ 6.0000E+00, 0.000000E+00},{ 7.0000E+00, 0.000000E+00},
			{ 8.0000E+00, 4.170000E-05},{ 9.0000E+00, 8.490000E-05},{ 1.0000E+01, 1.220000E-02},{ 1.1000E+01, 5.030000E-03},
			{ 1.2000E+01, 0.000000E+00},{ 1.3000E+01, 6.210000E-07},{ 1.4000E+01, 5.930000E-05},{ 1.5000E+01, 4.610000E-05},
			{ 1.6000E+01, 4.300000E-06},{ 1.7000E+01, 0.000000E+00},{ 1.8000E+01, 3.030000E-10},{ 1.9000E+01, 7.620000E-06},
			{ 2.0000E+01, 1.270000E-06},{ 2.1000E+01, 0.000000E+00},{ 2.2000E+01, 0.000000E+00},{ 2.3000E+01, 0.000000E+00},
			{ 2.4000E+01, 0.000000E+00},{ 2.5000E+01, 0.000000E+00},{ 2.6000E+01, 9.470000E-12},{ 2.7000E+01, 0.000000E+00},
			{ 2.8000E+01, 2.960000E-13},{ 2.9000E+01, 9.520000E-06},{ 3.0000E+01, 1.590000E-06},{ 3.1000E+01, 9.250000E-15},
			{ 3.2000E+01, 0.000000E+00},{ 3.3000E+01, 0.000000E+00},{ 3.4000E+01, 1.440000E-16},{ 3.5000E+01, 5.720000E-06},
			{ 3.6000E+01, 4.000000E-05},{ 3.7000E+01, 1.330000E-05},{ 3.8000E+01, 0.000000E+00},{ 3.9000E+01, 0.000000E+00},
			{ 4.0000E+01, 0.000000E+00},{ 4.1000E+01, 0.000000E+00},{ 4.2000E+01, 0.000000E+00},{ 4.3000E+01, 5.720000E-05},
			{ 4.4000E+01, 9.520000E-06},{ 4.5000E+01, 0.000000E+00},{ 4.6000E+01, 0.000000E+00},{ 4.7000E+01, 1.570000E-05},
			{ 4.8000E+01, 2.540000E-05},{ 4.9000E+01, 2.890000E-05},{ 5.0000E+01, 7.380000E-06},{ 5.1000E+01, 0.000000E+00},
			{ 5.2000E+01, 0.000000E+00},{ 5.3000E+01, 0.000000E+00},{ 5.4000E+01, 3.200000E-10},{ 5.5000E+01, 1.900000E-06},
			{ 5.6000E+01, 3.170000E-07},{ 5.7000E+01, 0.000000E+00},{ 5.8000E+01, 4.160000E-13},{ 5.9000E+01, 2.480000E-05},
			{ 6.0000E+01, 6.190000E-06},{ 6.1000E+01, 4.530000E-04},{ 6.2000E+01, 7.180000E-05},{ 6.3000E+01, 4.070000E-16},
			{ 6.4000E+01, 3.050000E-05},{ 6.5000E+01, 5.080000E-06},{ 6.6000E+01, 0.000000E+00},{ 6.7000E+01, 0.000000E+00},
			{ 6.8000E+01, 0.000000E+00},{ 6.9000E+01, 0.000000E+00},{ 7.0000E+01, 2.480000E-20},{ 7.1000E+01, 6.480000E-05},
			{ 7.2000E+01, 4.640000E-05},{ 7.3000E+01, 4.130000E-06},{ 7.4000E+01, 9.690000E-23},{ 7.5000E+01, 2.240000E-03},
			{ 7.6000E+01, 6.030000E-05},{ 7.7000E+01, 1.510000E-24},{ 7.8000E+01, 1.900000E-06},{ 7.9000E+01, 4.760000E-07},
			{ 8.0000E+01, 9.070000E-03},{ 8.1000E+01, 8.430000E-03},{ 8.2000E+01, 1.530000E-04},{ 8.3000E+01, 3.700000E-28},
			{ 8.4000E+01, 3.620000E-05},{ 8.5000E+01, 9.050000E-06},{ 8.6000E+01, 1.710000E-05},{ 8.7000E+01, 2.350000E-03},
			{ 8.8000E+01, 6.160000E-05},{ 8.9000E+01, 0.000000E+00},{ 9.0000E+01, 0.000000E+00},{ 9.1000E+01, 0.000000E+00},
			{ 9.2000E+01, 0.000000E+00},{ 9.3000E+01, 3.530000E-34},{ 9.4000E+01, 1.900000E-05},{ 9.5000E+01, 3.180000E-06},
			{ 9.6000E+01, 0.000000E+00},{ 9.7000E+01, 0.000000E+00},{ 9.8000E+01, 0.000000E+00},{ 9.9000E+01, 0.000000E+00},
			{ 1.0000E+02, 0.000000E+00},{ 1.0100E+02, 5.380000E-39},{ 1.0200E+02, 1.570000E-04},{ 1.0300E+02, 8.260000E-05},
			{ 1.0400E+02, 4.510000E-05},{ 1.0500E+02, 2.220000E-06},{ 1.0600E+02, 0.000000E+00},{ 1.0700E+02, 1.310214E-42},
			{ 1.0800E+02, 5.720000E-06},{ 1.0900E+02, 5.720000E-06},{ 1.1000E+02, 3.370000E-05},{ 1.1100E+02, 5.400000E-06},
			{ 1.1200E+02, 1.401298E-45},{ 1.1300E+02, 1.900000E-05},{ 1.1400E+02, 3.180000E-06},{ 1.1500E+02, 0.000000E+00},
			{ 1.1600E+02, 4.760000E-05},{ 1.1700E+02, 8.260000E-05},{ 1.1800E+02, 4.700000E-05},{ 1.1900E+02, 9.840000E-06},
			{ 1.2000E+02, 2.030000E-05},{ 1.2100E+02, 4.290000E-06},{ 1.2200E+02, 0.000000E+00},{ 1.2300E+02, 0.000000E+00},
			{ 1.2400E+02, 8.950000E-05},{ 1.2500E+02, 5.780000E-05},{ 1.2600E+02, 5.080000E-06},{ 1.2700E+02, 0.000000E+00},
			{ 1.2800E+02, 2.860000E-05},{ 1.2900E+02, 4.760000E-06},{ 1.3000E+02, 0.000000E+00},{ 1.3100E+02, 0.000000E+00},
			{ 1.3200E+02, 0.000000E+00},{ 1.3300E+02, 0.000000E+00},{ 1.3400E+02, 0.000000E+00},{ 1.3500E+02, 0.000000E+00},
			{ 1.3600E+02, 5.820000E-03},{ 1.3700E+02, 1.090000E-03},{ 1.3800E+02, 0.000000E+00},{ 1.3900E+02, 0.000000E+00},
			{ 1.4000E+02, 0.000000E+00},{ 1.4100E+02, 0.000000E+00},{ 1.4200E+02, 0.000000E+00},{ 1.4300E+02, 0.000000E+00},
			{ 1.4400E+02, 0.000000E+00},{ 1.4500E+02, 0.000000E+00},{ 1.4600E+02, 3.810000E-06},{ 1.4700E+02, 6.350000E-07},
			{ 1.4800E+02, 0.000000E+00},{ 1.4900E+02, 0.000000E+00},{ 1.5000E+02, 0.000000E+00},{ 1.5100E+02, 6.290000E-05},
			{ 1.5200E+02, 1.050000E-05},{ 1.5300E+02, 0.000000E+00},{ 1.5400E+02, 0.000000E+00},{ 1.5500E+02, 0.000000E+00},
			{ 1.5600E+02, 0.000000E+00},{ 1.5700E+02, 0.000000E+00},{ 1.5800E+02, 0.000000E+00},{ 1.5900E+02, 0.000000E+00},
			{ 1.6000E+02, 0.000000E+00},{ 1.6100E+02, 0.000000E+00},{ 1.6200E+02, 0.000000E+00},{ 1.6300E+02, 0.000000E+00},
			{ 1.6400E+02, 0.000000E+00},{ 1.6500E+02, 0.000000E+00},{ 1.6600E+02, 0.000000E+00},{ 1.6700E+02, 4.310000E-03},
			{ 1.6800E+02, 6.810000E-04},{ 1.6900E+02, 0.000000E+00},{ 1.7000E+02, 0.000000E+00},{ 1.7100E+02, 0.000000E+00},
			{ 1.7200E+02, 5.720000E-05},{ 1.7300E+02, 2.950000E-05},{ 1.7400E+02, 3.650000E-06},{ 1.7500E+02, 0.000000E+00},
			{ 1.7600E+02, 0.000000E+00},{ 1.7700E+02, 0.000000E+00},{ 1.7800E+02, 0.000000E+00},{ 1.7900E+02, 0.000000E+00},
			{ 1.8000E+02, 0.000000E+00},{ 1.8100E+02, 0.000000E+00},{ 1.8200E+02, 1.160000E-04},{ 1.8300E+02, 2.500000E-05},
			{ 1.8400E+02, 5.720000E-06},{ 1.8500E+02, 6.670000E-06},{ 1.8600E+02, 7.140000E-07},{ 1.8700E+02, 6.480000E-05},
			{ 1.8800E+02, 7.680000E-05},{ 1.8900E+02, 1.800000E-05},{ 1.9000E+02, 5.400000E-06},{ 1.9100E+02, 2.380000E-07},
			{ 1.9200E+02, 1.140000E-05},{ 1.9300E+02, 1.890000E-06},{ 1.9400E+02, 0.000000E+00},{ 1.9500E+02, 0.000000E+00},
			{ 1.9600E+02, 0.000000E+00},{ 1.9700E+02, 0.000000E+00},{ 1.9800E+02, 0.000000E+00},{ 1.9900E+02, 0.000000E+00},
			{ 2.0000E+02, 0.000000E+00},{ 2.0100E+02, 1.900000E-05},{ 2.0200E+02, 4.760000E-06},{ 2.0300E+02, 7.240000E-05},
			{ 2.0400E+02, 1.780000E-02},{ 2.0500E+02, 4.690000E-03},{ 2.0600E+02, 4.320000E-05},{ 2.0700E+02, 0.000000E+00},
			{ 2.0800E+02, 3.240000E-05},{ 2.0900E+02, 4.700000E-05},{ 2.1000E+02, 6.030000E-06},{ 2.1100E+02, 0.000000E+00},
			{ 2.1200E+02, 0.000000E+00},{ 2.1300E+02, 0.000000E+00},{ 2.1400E+02, 0.000000E+00},{ 2.1500E+02, 0.000000E+00},
			{ 2.1600E+02, 0.000000E+00},{ 2.1700E+02, 0.000000E+00},{ 2.1800E+02, 0.000000E+00},{ 2.1900E+02, 4.930000E-03},
			{ 2.2000E+02, 1.070000E-03},{ 2.2100E+02, 2.480000E-05},{ 2.2200E+02, 0.000000E+00},{ 2.2300E+02, 0.000000E+00},
			{ 2.2400E+02, 0.000000E+00},{ 2.2500E+02, 3.810000E-06},{ 2.2600E+02, 1.000000E-04},{ 2.2700E+02, 1.650000E-05},
			{ 2.2800E+02, 0.000000E+00},{ 2.2900E+02, 0.000000E+00},{ 2.3000E+02, 1.520000E-05},{ 2.3100E+02, 1.240000E-03},
			{ 2.3200E+02, 5.650000E-05},{ 2.3300E+02, 0.000000E+00},{ 2.3400E+02, 0.000000E+00},{ 2.3500E+02, 0.000000E+00},
			{ 2.3600E+02, 0.000000E+00},{ 2.3700E+02, 0.000000E+00},{ 2.3800E+02, 4.190000E-05},{ 2.3900E+02, 6.990000E-06},
			{ 2.4000E+02, 0.000000E+00},{ 2.4100E+02, 0.000000E+00},{ 2.4200E+02, 0.000000E+00},{ 2.4300E+02, 0.000000E+00},
			{ 2.4400E+02, 0.000000E+00},{ 2.4500E+02, 0.000000E+00},{ 2.4600E+02, 9.720000E-05},{ 2.4700E+02, 2.320000E-05},
			{ 2.4800E+02, 0.000000E+00},{ 2.4900E+02, 0.000000E+00},{ 2.5000E+02, 0.000000E+00},{ 2.5100E+02, 0.000000E+00},
			{ 2.5200E+02, 0.000000E+00},{ 2.5300E+02, 0.000000E+00},{ 2.5400E+02, 0.000000E+00},{ 2.5500E+02, 7.620000E-06},
			{ 2.5600E+02, 1.270000E-06},{ 2.5700E+02, 0.000000E+00},{ 2.5800E+02, 0.000000E+00},{ 2.5900E+02, 6.480000E-05},
			{ 2.6000E+02, 1.620000E-05},{ 2.6100E+02, 3.540000E-05},{ 2.6200E+02, 5.000000E-06},{ 2.6300E+02, 0.000000E+00},
			{ 2.6400E+02, 0.000000E+00},{ 2.6500E+02, 5.720000E-06},{ 2.6600E+02, 4.460000E-03},{ 2.6700E+02, 1.140000E-03},
			{ 2.6800E+02, 0.000000E+00},{ 2.6900E+02, 0.000000E+00},{ 2.7000E+02, 0.000000E+00},{ 2.7100E+02, 0.000000E+00},
			{ 2.7200E+02, 0.000000E+00},{ 2.7300E+02, 0.000000E+00},{ 2.7400E+02, 5.720000E-06},{ 2.7500E+02, 9.520000E-07},
			{ 2.7600E+02, 0.000000E+00},{ 2.7700E+02, 6.390000E-03},{ 2.7800E+02, 9.700000E-04},{ 2.7900E+02, 0.000000E+00},
			{ 2.8000E+02, 0.000000E+00},{ 2.8100E+02, 0.000000E+00},{ 2.8200E+02, 0.000000E+00},{ 2.8300E+02, 0.000000E+00},
			{ 2.8400E+02, 0.000000E+00},{ 2.8500E+02, 3.050000E-05},{ 2.8600E+02, 7.620000E-06},{ 2.8700E+02, 6.290000E-05},
			{ 2.8800E+02, 5.720000E-05},{ 2.8900E+02, 8.740000E-03},{ 2.9000E+02, 1.460000E-03},{ 2.9100E+02, 0.000000E+00},
			{ 2.9200E+02, 0.000000E+00},{ 2.9300E+02, 0.000000E+00},{ 2.9400E+02, 0.000000E+00},{ 2.9500E+02, 0.000000E+00},
			{ 2.9600E+02, 3.810000E-06},{ 2.9700E+02, 6.350000E-07},{ 2.9800E+02, 0.000000E+00},{ 2.9900E+02, 3.810000E-06},
			{ 3.0000E+02, 6.350000E-07},{ 3.0100E+02, 0.000000E+00},{ 3.0200E+02, 0.000000E+00},{ 3.0300E+02, 0.000000E+00},
			{ 3.0400E+02, 0.000000E+00},{ 3.0500E+02, 0.000000E+00},{ 3.0600E+02, 0.000000E+00},{ 3.0700E+02, 0.000000E+00},
			{ 3.0800E+02, 0.000000E+00},{ 3.0900E+02, 0.000000E+00},{ 3.1000E+02, 0.000000E+00},{ 3.1100E+02, 0.000000E+00},
			{ 3.1200E+02, 5.720000E-06},{ 3.1300E+02, 5.720000E-06},{ 3.1400E+02, 3.940000E-05},{ 3.1500E+02, 2.350000E-05},
			{ 3.1600E+02, 2.220000E-06},{ 3.1700E+02, 0.000000E+00},{ 3.1800E+02, 0.000000E+00},{ 3.1900E+02, 0.000000E+00},
			{ 3.2000E+02, 0.000000E+00},{ 3.2100E+02, 0.000000E+00},{ 3.2200E+02, 0.000000E+00},{ 3.2300E+02, 0.000000E+00},
			{ 3.2400E+02, 1.920000E-04},{ 3.2500E+02, 1.660000E-03},{ 3.2600E+02, 4.570000E-05},{ 3.2700E+02, 0.000000E+00},
			{ 3.2800E+02, 0.000000E+00},{ 3.2900E+02, 0.000000E+00},{ 3.3000E+02, 0.000000E+00},{ 3.3100E+02, 0.000000E+00},
			{ 3.3200E+02, 0.000000E+00},{ 3.3300E+02, 7.810000E-05},{ 3.3400E+02, 9.080000E-05},{ 3.3500E+02, 4.260000E-03},
			{ 3.3600E+02, 1.280000E-03},{ 3.3700E+02, 0.000000E+00},{ 3.3800E+02, 0.000000E+00},{ 3.3900E+02, 0.000000E+00},
			{ 3.4000E+02, 0.000000E+00},{ 3.4100E+02, 7.620000E-06},{ 3.4200E+02, 6.570000E-03},{ 3.4300E+02, 1.870000E-03},
			{ 3.4400E+02, 0.000000E+00},{ 3.4500E+02, 1.900000E-06},{ 3.4600E+02, 4.450000E-05},{ 3.4700E+02, 2.160000E-05},
			{ 3.4800E+02, 2.860000E-06},{ 3.4900E+02, 0.000000E+00},{ 3.5000E+02, 0.000000E+00},{ 3.5100E+02, 0.000000E+00},
			{ 3.5200E+02, 0.000000E+00},{ 3.5300E+02, 1.430000E-06},{ 3.5400E+02, 7.140000E-07},{ 3.5500E+02, 9.920000E-09},
			{ 3.5600E+02, 4.190000E-05},{ 3.5700E+02, 6.980000E-06},{ 3.5800E+02, 0.000000E+00},{ 3.5900E+02, 4.650000E-10},
			{ 3.6000E+02, 1.910000E-06},{ 3.6100E+02, 3.010000E-03},{ 3.6200E+02, 4.870000E-04},{ 3.6300E+02, 0.000000E+00},
			 };
		return SL::Graph( 0, x, 363, g); 
	}

	inline double Graph19(double x) { 
		static double g[364][2] = {
			{ 0.0000E+00, 0.000000E+00},{ 1.0000E+00, 0.000000E+00},{ 2.0000E+00, 0.000000E+00},{ 3.0000E+00, 0.000000E+00},
			{ 4.0000E+00, 0.000000E+00},{ 5.0000E+00, 0.000000E+00},{ 6.0000E+00, 0.000000E+00},{ 7.0000E+00, 0.000000E+00},
			{ 8.0000E+00, 0.000000E+00},{ 9.0000E+00, 0.000000E+00},{ 1.0000E+01, 0.000000E+00},{ 1.1000E+01, 0.000000E+00},
			{ 1.2000E+01, 0.000000E+00},{ 1.3000E+01, 0.000000E+00},{ 1.4000E+01, 0.000000E+00},{ 1.5000E+01, 0.000000E+00},
			{ 1.6000E+01, 0.000000E+00},{ 1.7000E+01, 0.000000E+00},{ 1.8000E+01, 0.000000E+00},{ 1.9000E+01, 0.000000E+00},
			{ 2.0000E+01, 0.000000E+00},{ 2.1000E+01, 0.000000E+00},{ 2.2000E+01, 0.000000E+00},{ 2.3000E+01, 0.000000E+00},
			{ 2.4000E+01, 0.000000E+00},{ 2.5000E+01, 0.000000E+00},{ 2.6000E+01, 0.000000E+00},{ 2.7000E+01, 0.000000E+00},
			{ 2.8000E+01, 0.000000E+00},{ 2.9000E+01, 0.000000E+00},{ 3.0000E+01, 0.000000E+00},{ 3.1000E+01, 0.000000E+00},
			{ 3.2000E+01, 0.000000E+00},{ 3.3000E+01, 0.000000E+00},{ 3.4000E+01, 0.000000E+00},{ 3.5000E+01, 0.000000E+00},
			{ 3.6000E+01, 0.000000E+00},{ 3.7000E+01, 0.000000E+00},{ 3.8000E+01, 0.000000E+00},{ 3.9000E+01, 0.000000E+00},
			{ 4.0000E+01, 0.000000E+00},{ 4.1000E+01, 0.000000E+00},{ 4.2000E+01, 0.000000E+00},{ 4.3000E+01, 0.000000E+00},
			{ 4.4000E+01, 0.000000E+00},{ 4.5000E+01, 0.000000E+00},{ 4.6000E+01, 0.000000E+00},{ 4.7000E+01, 0.000000E+00},
			{ 4.8000E+01, 0.000000E+00},{ 4.9000E+01, 0.000000E+00},{ 5.0000E+01, 0.000000E+00},{ 5.1000E+01, 0.000000E+00},
			{ 5.2000E+01, 0.000000E+00},{ 5.3000E+01, 0.000000E+00},{ 5.4000E+01, 0.000000E+00},{ 5.5000E+01, 0.000000E+00},
			{ 5.6000E+01, 0.000000E+00},{ 5.7000E+01, 0.000000E+00},{ 5.8000E+01, 0.000000E+00},{ 5.9000E+01, 0.000000E+00},
			{ 6.0000E+01, 0.000000E+00},{ 6.1000E+01, 0.000000E+00},{ 6.2000E+01, 0.000000E+00},{ 6.3000E+01, 0.000000E+00},
			{ 6.4000E+01, 0.000000E+00},{ 6.5000E+01, 0.000000E+00},{ 6.6000E+01, 0.000000E+00},{ 6.7000E+01, 0.000000E+00},
			{ 6.8000E+01, 0.000000E+00},{ 6.9000E+01, 0.000000E+00},{ 7.0000E+01, 0.000000E+00},{ 7.1000E+01, 0.000000E+00},
			{ 7.2000E+01, 0.000000E+00},{ 7.3000E+01, 0.000000E+00},{ 7.4000E+01, 0.000000E+00},{ 7.5000E+01, 0.000000E+00},
			{ 7.6000E+01, 0.000000E+00},{ 7.7000E+01, 0.000000E+00},{ 7.8000E+01, 0.000000E+00},{ 7.9000E+01, 0.000000E+00},
			{ 8.0000E+01, 0.000000E+00},{ 8.1000E+01, 0.000000E+00},{ 8.2000E+01, 0.000000E+00},{ 8.3000E+01, 0.000000E+00},
			{ 8.4000E+01, 0.000000E+00},{ 8.5000E+01, 0.000000E+00},{ 8.6000E+01, 0.000000E+00},{ 8.7000E+01, 0.000000E+00},
			{ 8.8000E+01, 0.000000E+00},{ 8.9000E+01, 0.000000E+00},{ 9.0000E+01, 0.000000E+00},{ 9.1000E+01, 0.000000E+00},
			{ 9.2000E+01, 0.000000E+00},{ 9.3000E+01, 0.000000E+00},{ 9.4000E+01, 0.000000E+00},{ 9.5000E+01, 0.000000E+00},
			{ 9.6000E+01, 0.000000E+00},{ 9.7000E+01, 0.000000E+00},{ 9.8000E+01, 0.000000E+00},{ 9.9000E+01, 0.000000E+00},
			{ 1.0000E+02, 0.000000E+00},{ 1.0100E+02, 0.000000E+00},{ 1.0200E+02, 0.000000E+00},{ 1.0300E+02, 0.000000E+00},
			{ 1.0400E+02, 0.000000E+00},{ 1.0500E+02, 0.000000E+00},{ 1.0600E+02, 0.000000E+00},{ 1.0700E+02, 0.000000E+00},
			{ 1.0800E+02, 0.000000E+00},{ 1.0900E+02, 0.000000E+00},{ 1.1000E+02, 0.000000E+00},{ 1.1100E+02, 0.000000E+00},
			{ 1.1200E+02, 0.000000E+00},{ 1.1300E+02, 0.000000E+00},{ 1.1400E+02, 0.000000E+00},{ 1.1500E+02, 0.000000E+00},
			{ 1.1600E+02, 0.000000E+00},{ 1.1700E+02, 0.000000E+00},{ 1.1800E+02, 0.000000E+00},{ 1.1900E+02, 0.000000E+00},
			{ 1.2000E+02, 0.000000E+00},{ 1.2100E+02, 0.000000E+00},{ 1.2200E+02, 0.000000E+00},{ 1.2300E+02, 0.000000E+00},
			{ 1.2400E+02, 0.000000E+00},{ 1.2500E+02, 0.000000E+00},{ 1.2600E+02, 0.000000E+00},{ 1.2700E+02, 0.000000E+00},
			{ 1.2800E+02, 0.000000E+00},{ 1.2900E+02, 0.000000E+00},{ 1.3000E+02, 0.000000E+00},{ 1.3100E+02, 0.000000E+00},
			{ 1.3200E+02, 0.000000E+00},{ 1.3300E+02, 0.000000E+00},{ 1.3400E+02, 0.000000E+00},{ 1.3500E+02, 0.000000E+00},
			{ 1.3600E+02, 0.000000E+00},{ 1.3700E+02, 0.000000E+00},{ 1.3800E+02, 0.000000E+00},{ 1.3900E+02, 0.000000E+00},
			{ 1.4000E+02, 0.000000E+00},{ 1.4100E+02, 0.000000E+00},{ 1.4200E+02, 0.000000E+00},{ 1.4300E+02, 0.000000E+00},
			{ 1.4400E+02, 0.000000E+00},{ 1.4500E+02, 0.000000E+00},{ 1.4600E+02, 0.000000E+00},{ 1.4700E+02, 0.000000E+00},
			{ 1.4800E+02, 0.000000E+00},{ 1.4900E+02, 0.000000E+00},{ 1.5000E+02, 0.000000E+00},{ 1.5100E+02, 0.000000E+00},
			{ 1.5200E+02, 0.000000E+00},{ 1.5300E+02, 0.000000E+00},{ 1.5400E+02, 0.000000E+00},{ 1.5500E+02, 0.000000E+00},
			{ 1.5600E+02, 0.000000E+00},{ 1.5700E+02, 0.000000E+00},{ 1.5800E+02, 0.000000E+00},{ 1.5900E+02, 0.000000E+00},
			{ 1.6000E+02, 0.000000E+00},{ 1.6100E+02, 0.000000E+00},{ 1.6200E+02, 0.000000E+00},{ 1.6300E+02, 0.000000E+00},
			{ 1.6400E+02, 0.000000E+00},{ 1.6500E+02, 0.000000E+00},{ 1.6600E+02, 0.000000E+00},{ 1.6700E+02, 0.000000E+00},
			{ 1.6800E+02, 0.000000E+00},{ 1.6900E+02, 0.000000E+00},{ 1.7000E+02, 0.000000E+00},{ 1.7100E+02, 0.000000E+00},
			{ 1.7200E+02, 0.000000E+00},{ 1.7300E+02, 0.000000E+00},{ 1.7400E+02, 0.000000E+00},{ 1.7500E+02, 0.000000E+00},
			{ 1.7600E+02, 0.000000E+00},{ 1.7700E+02, 0.000000E+00},{ 1.7800E+02, 0.000000E+00},{ 1.7900E+02, 0.000000E+00},
			{ 1.8000E+02, 0.000000E+00},{ 1.8100E+02, 0.000000E+00},{ 1.8200E+02, 0.000000E+00},{ 1.8300E+02, 0.000000E+00},
			{ 1.8400E+02, 0.000000E+00},{ 1.8500E+02, 0.000000E+00},{ 1.8600E+02, 0.000000E+00},{ 1.8700E+02, 0.000000E+00},
			{ 1.8800E+02, 0.000000E+00},{ 1.8900E+02, 0.000000E+00},{ 1.9000E+02, 0.000000E+00},{ 1.9100E+02, 0.000000E+00},
			{ 1.9200E+02, 0.000000E+00},{ 1.9300E+02, 0.000000E+00},{ 1.9400E+02, 0.000000E+00},{ 1.9500E+02, 0.000000E+00},
			{ 1.9600E+02, 0.000000E+00},{ 1.9700E+02, 0.000000E+00},{ 1.9800E+02, 0.000000E+00},{ 1.9900E+02, 0.000000E+00},
			{ 2.0000E+02, 0.000000E+00},{ 2.0100E+02, 0.000000E+00},{ 2.0200E+02, 0.000000E+00},{ 2.0300E+02, 0.000000E+00},
			{ 2.0400E+02, 0.000000E+00},{ 2.0500E+02, 0.000000E+00},{ 2.0600E+02, 0.000000E+00},{ 2.0700E+02, 0.000000E+00},
			{ 2.0800E+02, 0.000000E+00},{ 2.0900E+02, 0.000000E+00},{ 2.1000E+02, 0.000000E+00},{ 2.1100E+02, 0.000000E+00},
			{ 2.1200E+02, 0.000000E+00},{ 2.1300E+02, 0.000000E+00},{ 2.1400E+02, 0.000000E+00},{ 2.1500E+02, 0.000000E+00},
			{ 2.1600E+02, 0.000000E+00},{ 2.1700E+02, 0.000000E+00},{ 2.1800E+02, 0.000000E+00},{ 2.1900E+02, 0.000000E+00},
			{ 2.2000E+02, 0.000000E+00},{ 2.2100E+02, 0.000000E+00},{ 2.2200E+02, 0.000000E+00},{ 2.2300E+02, 0.000000E+00},
			{ 2.2400E+02, 0.000000E+00},{ 2.2500E+02, 0.000000E+00},{ 2.2600E+02, 0.000000E+00},{ 2.2700E+02, 0.000000E+00},
			{ 2.2800E+02, 0.000000E+00},{ 2.2900E+02, 0.000000E+00},{ 2.3000E+02, 0.000000E+00},{ 2.3100E+02, 0.000000E+00},
			{ 2.3200E+02, 0.000000E+00},{ 2.3300E+02, 0.000000E+00},{ 2.3400E+02, 0.000000E+00},{ 2.3500E+02, 0.000000E+00},
			{ 2.3600E+02, 0.000000E+00},{ 2.3700E+02, 0.000000E+00},{ 2.3800E+02, 0.000000E+00},{ 2.3900E+02, 0.000000E+00},
			{ 2.4000E+02, 0.000000E+00},{ 2.4100E+02, 0.000000E+00},{ 2.4200E+02, 0.000000E+00},{ 2.4300E+02, 0.000000E+00},
			{ 2.4400E+02, 0.000000E+00},{ 2.4500E+02, 0.000000E+00},{ 2.4600E+02, 0.000000E+00},{ 2.4700E+02, 0.000000E+00},
			{ 2.4800E+02, 0.000000E+00},{ 2.4900E+02, 0.000000E+00},{ 2.5000E+02, 0.000000E+00},{ 2.5100E+02, 0.000000E+00},
			{ 2.5200E+02, 0.000000E+00},{ 2.5300E+02, 0.000000E+00},{ 2.5400E+02, 0.000000E+00},{ 2.5500E+02, 0.000000E+00},
			{ 2.5600E+02, 0.000000E+00},{ 2.5700E+02, 0.000000E+00},{ 2.5800E+02, 0.000000E+00},{ 2.5900E+02, 0.000000E+00},
			{ 2.6000E+02, 0.000000E+00},{ 2.6100E+02, 0.000000E+00},{ 2.6200E+02, 0.000000E+00},{ 2.6300E+02, 0.000000E+00},
			{ 2.6400E+02, 0.000000E+00},{ 2.6500E+02, 0.000000E+00},{ 2.6600E+02, 0.000000E+00},{ 2.6700E+02, 0.000000E+00},
			{ 2.6800E+02, 0.000000E+00},{ 2.6900E+02, 0.000000E+00},{ 2.7000E+02, 0.000000E+00},{ 2.7100E+02, 0.000000E+00},
			{ 2.7200E+02, 0.000000E+00},{ 2.7300E+02, 0.000000E+00},{ 2.7400E+02, 0.000000E+00},{ 2.7500E+02, 0.000000E+00},
			{ 2.7600E+02, 0.000000E+00},{ 2.7700E+02, 0.000000E+00},{ 2.7800E+02, 0.000000E+00},{ 2.7900E+02, 0.000000E+00},
			{ 2.8000E+02, 0.000000E+00},{ 2.8100E+02, 0.000000E+00},{ 2.8200E+02, 0.000000E+00},{ 2.8300E+02, 0.000000E+00},
			{ 2.8400E+02, 0.000000E+00},{ 2.8500E+02, 0.000000E+00},{ 2.8600E+02, 0.000000E+00},{ 2.8700E+02, 0.000000E+00},
			{ 2.8800E+02, 0.000000E+00},{ 2.8900E+02, 0.000000E+00},{ 2.9000E+02, 0.000000E+00},{ 2.9100E+02, 0.000000E+00},
			{ 2.9200E+02, 0.000000E+00},{ 2.9300E+02, 0.000000E+00},{ 2.9400E+02, 0.000000E+00},{ 2.9500E+02, 0.000000E+00},
			{ 2.9600E+02, 0.000000E+00},{ 2.9700E+02, 0.000000E+00},{ 2.9800E+02, 0.000000E+00},{ 2.9900E+02, 0.000000E+00},
			{ 3.0000E+02, 0.000000E+00},{ 3.0100E+02, 0.000000E+00},{ 3.0200E+02, 0.000000E+00},{ 3.0300E+02, 0.000000E+00},
			{ 3.0400E+02, 0.000000E+00},{ 3.0500E+02, 0.000000E+00},{ 3.0600E+02, 0.000000E+00},{ 3.0700E+02, 0.000000E+00},
			{ 3.0800E+02, 0.000000E+00},{ 3.0900E+02, 0.000000E+00},{ 3.1000E+02, 0.000000E+00},{ 3.1100E+02, 0.000000E+00},
			{ 3.1200E+02, 0.000000E+00},{ 3.1300E+02, 0.000000E+00},{ 3.1400E+02, 0.000000E+00},{ 3.1500E+02, 0.000000E+00},
			{ 3.1600E+02, 0.000000E+00},{ 3.1700E+02, 0.000000E+00},{ 3.1800E+02, 0.000000E+00},{ 3.1900E+02, 0.000000E+00},
			{ 3.2000E+02, 0.000000E+00},{ 3.2100E+02, 0.000000E+00},{ 3.2200E+02, 0.000000E+00},{ 3.2300E+02, 0.000000E+00},
			{ 3.2400E+02, 0.000000E+00},{ 3.2500E+02, 0.000000E+00},{ 3.2600E+02, 0.000000E+00},{ 3.2700E+02, 0.000000E+00},
			{ 3.2800E+02, 0.000000E+00},{ 3.2900E+02, 0.000000E+00},{ 3.3000E+02, 0.000000E+00},{ 3.3100E+02, 0.000000E+00},
			{ 3.3200E+02, 0.000000E+00},{ 3.3300E+02, 0.000000E+00},{ 3.3400E+02, 0.000000E+00},{ 3.3500E+02, 0.000000E+00},
			{ 3.3600E+02, 0.000000E+00},{ 3.3700E+02, 0.000000E+00},{ 3.3800E+02, 0.000000E+00},{ 3.3900E+02, 0.000000E+00},
			{ 3.4000E+02, 0.000000E+00},{ 3.4100E+02, 0.000000E+00},{ 3.4200E+02, 0.000000E+00},{ 3.4300E+02, 0.000000E+00},
			{ 3.4400E+02, 0.000000E+00},{ 3.4500E+02, 0.000000E+00},{ 3.4600E+02, 0.000000E+00},{ 3.4700E+02, 0.000000E+00},
			{ 3.4800E+02, 0.000000E+00},{ 3.4900E+02, 0.000000E+00},{ 3.5000E+02, 0.000000E+00},{ 3.5100E+02, 0.000000E+00},
			{ 3.5200E+02, 0.000000E+00},{ 3.5300E+02, 0.000000E+00},{ 3.5400E+02, 0.000000E+00},{ 3.5500E+02, 0.000000E+00},
			{ 3.5600E+02, 0.000000E+00},{ 3.5700E+02, 0.000000E+00},{ 3.5800E+02, 0.000000E+00},{ 3.5900E+02, 0.000000E+00},
			{ 3.6000E+02, 0.000000E+00},{ 3.6100E+02, 0.000000E+00},{ 3.6200E+02, 0.000000E+00},{ 3.6300E+02, 0.000000E+00},
			 };
		return SL::Graph( 0, x, 363, g); 
	}

	inline double Graph20(double x) { 
		static double g[365][2] = {
			{ 0.0000E+00, 1.950000E+00},{ 1.0000E+00, 1.910000E+00},{ 2.0000E+00, 1.850000E+00},{ 3.0000E+00, 1.790000E+00},
			{ 4.0000E+00, 1.730000E+00},{ 5.0000E+00, 1.670000E+00},{ 6.0000E+00, 1.620000E+00},{ 7.0000E+00, 1.560000E+00},
			{ 8.0000E+00, 1.510000E+00},{ 9.0000E+00, 1.470000E+00},{ 1.0000E+01, 1.430000E+00},{ 1.1000E+01, 1.400000E+00},
			{ 1.2000E+01, 1.360000E+00},{ 1.3000E+01, 1.320000E+00},{ 1.4000E+01, 1.280000E+00},{ 1.5000E+01, 1.250000E+00},
			{ 1.6000E+01, 1.220000E+00},{ 1.7000E+01, 1.190000E+00},{ 1.8000E+01, 1.160000E+00},{ 1.9000E+01, 1.130000E+00},
			{ 2.0000E+01, 1.110000E+00},{ 2.1000E+01, 1.080000E+00},{ 2.2000E+01, 1.060000E+00},{ 2.3000E+01, 1.040000E+00},
			{ 2.4000E+01, 1.020000E+00},{ 2.5000E+01, 1.010000E+00},{ 2.6000E+01, 9.940000E-01},{ 2.7000E+01, 9.810000E-01},
			{ 2.8000E+01, 9.700000E-01},{ 2.9000E+01, 9.600000E-01},{ 3.0000E+01, 9.520000E-01},{ 3.1000E+01, 9.440000E-01},
			{ 3.2000E+01, 9.370000E-01},{ 3.3000E+01, 9.320000E-01},{ 3.4000E+01, 9.280000E-01},{ 3.5000E+01, 9.250000E-01},
			{ 3.6000E+01, 9.240000E-01},{ 3.7000E+01, 9.270000E-01},{ 3.8000E+01, 9.270000E-01},{ 3.9000E+01, 9.270000E-01},
			{ 4.0000E+01, 9.280000E-01},{ 4.1000E+01, 9.300000E-01},{ 4.2000E+01, 9.330000E-01},{ 4.3000E+01, 9.370000E-01},
			{ 4.4000E+01, 9.460000E-01},{ 4.5000E+01, 9.510000E-01},{ 4.6000E+01, 9.550000E-01},{ 4.7000E+01, 9.590000E-01},
			{ 4.8000E+01, 9.670000E-01},{ 4.9000E+01, 9.740000E-01},{ 5.0000E+01, 9.810000E-01},{ 5.1000E+01, 9.870000E-01},
			{ 5.2000E+01, 9.920000E-01},{ 5.3000E+01, 9.970000E-01},{ 5.4000E+01, 1.000000E+00},{ 5.5000E+01, 1.010000E+00},
			{ 5.6000E+01, 1.020000E+00},{ 5.7000E+01, 1.020000E+00},{ 5.8000E+01, 1.030000E+00},{ 5.9000E+01, 1.030000E+00},
			{ 6.0000E+01, 1.040000E+00},{ 6.1000E+01, 1.050000E+00},{ 6.2000E+01, 1.070000E+00},{ 6.3000E+01, 1.070000E+00},
			{ 6.4000E+01, 1.080000E+00},{ 6.5000E+01, 1.090000E+00},{ 6.6000E+01, 1.090000E+00},{ 6.7000E+01, 1.090000E+00},
			{ 6.8000E+01, 1.100000E+00},{ 6.9000E+01, 1.100000E+00},{ 7.0000E+01, 1.110000E+00},{ 7.1000E+01, 1.110000E+00},
			{ 7.2000E+01, 1.120000E+00},{ 7.3000E+01, 1.130000E+00},{ 7.4000E+01, 1.130000E+00},{ 7.5000E+01, 1.140000E+00},
			{ 7.6000E+01, 1.150000E+00},{ 7.7000E+01, 1.150000E+00},{ 7.8000E+01, 1.160000E+00},{ 7.9000E+01, 1.160000E+00},
			{ 8.0000E+01, 1.160000E+00},{ 8.1000E+01, 1.180000E+00},{ 8.2000E+01, 1.190000E+00},{ 8.3000E+01, 1.190000E+00},
			{ 8.4000E+01, 1.190000E+00},{ 8.5000E+01, 1.190000E+00},{ 8.6000E+01, 1.190000E+00},{ 8.7000E+01, 1.190000E+00},
			{ 8.8000E+01, 1.200000E+00},{ 8.9000E+01, 1.200000E+00},{ 9.0000E+01, 1.200000E+00},{ 9.1000E+01, 1.200000E+00},
			{ 9.2000E+01, 1.200000E+00},{ 9.3000E+01, 1.190000E+00},{ 9.4000E+01, 1.190000E+00},{ 9.5000E+01, 1.190000E+00},
			{ 9.6000E+01, 1.190000E+00},{ 9.7000E+01, 1.190000E+00},{ 9.8000E+01, 1.190000E+00},{ 9.9000E+01, 1.190000E+00},
			{ 1.0000E+02, 1.190000E+00},{ 1.0100E+02, 1.190000E+00},{ 1.0200E+02, 1.190000E+00},{ 1.0300E+02, 1.200000E+00},
			{ 1.0400E+02, 1.200000E+00},{ 1.0500E+02, 1.210000E+00},{ 1.0600E+02, 1.210000E+00},{ 1.0700E+02, 1.200000E+00},
			{ 1.0800E+02, 1.200000E+00},{ 1.0900E+02, 1.200000E+00},{ 1.1000E+02, 1.200000E+00},{ 1.1100E+02, 1.200000E+00},
			{ 1.1200E+02, 1.200000E+00},{ 1.1300E+02, 1.200000E+00},{ 1.1400E+02, 1.200000E+00},{ 1.1500E+02, 1.200000E+00},
			{ 1.1600E+02, 1.200000E+00},{ 1.1700E+02, 1.210000E+00},{ 1.1800E+02, 1.210000E+00},{ 1.1900E+02, 1.220000E+00},
			{ 1.2000E+02, 1.210000E+00},{ 1.2100E+02, 1.210000E+00},{ 1.2200E+02, 1.210000E+00},{ 1.2300E+02, 1.210000E+00},
			{ 1.2400E+02, 1.210000E+00},{ 1.2500E+02, 1.220000E+00},{ 1.2600E+02, 1.220000E+00},{ 1.2700E+02, 1.220000E+00},
			{ 1.2800E+02, 1.220000E+00},{ 1.2900E+02, 1.220000E+00},{ 1.3000E+02, 1.220000E+00},{ 1.3100E+02, 1.220000E+00},
			{ 1.3200E+02, 1.210000E+00},{ 1.3300E+02, 1.210000E+00},{ 1.3400E+02, 1.210000E+00},{ 1.3500E+02, 1.210000E+00},
			{ 1.3600E+02, 1.210000E+00},{ 1.3700E+02, 1.220000E+00},{ 1.3800E+02, 1.230000E+00},{ 1.3900E+02, 1.220000E+00},
			{ 1.4000E+02, 1.220000E+00},{ 1.4100E+02, 1.220000E+00},{ 1.4200E+02, 1.220000E+00},{ 1.4300E+02, 1.220000E+00},
			{ 1.4400E+02, 1.210000E+00},{ 1.4500E+02, 1.210000E+00},{ 1.4600E+02, 1.210000E+00},{ 1.4700E+02, 1.210000E+00},
			{ 1.4800E+02, 1.210000E+00},{ 1.4900E+02, 1.210000E+00},{ 1.5000E+02, 1.210000E+00},{ 1.5100E+02, 1.210000E+00},
			{ 1.5200E+02, 1.220000E+00},{ 1.5300E+02, 1.220000E+00},{ 1.5400E+02, 1.220000E+00},{ 1.5500E+02, 1.210000E+00},
			{ 1.5600E+02, 1.210000E+00},{ 1.5700E+02, 1.210000E+00},{ 1.5800E+02, 1.210000E+00},{ 1.5900E+02, 1.210000E+00},
			{ 1.6000E+02, 1.210000E+00},{ 1.6100E+02, 1.210000E+00},{ 1.6200E+02, 1.210000E+00},{ 1.6300E+02, 1.210000E+00},
			{ 1.6400E+02, 1.210000E+00},{ 1.6500E+02, 1.210000E+00},{ 1.6600E+02, 1.210000E+00},{ 1.6700E+02, 1.220000E+00},
			{ 1.6800E+02, 1.230000E+00},{ 1.6900E+02, 1.240000E+00},{ 1.7000E+02, 1.230000E+00},{ 1.7100E+02, 1.230000E+00},
			{ 1.7200E+02, 1.230000E+00},{ 1.7300E+02, 1.240000E+00},{ 1.7400E+02, 1.240000E+00},{ 1.7500E+02, 1.240000E+00},
			{ 1.7600E+02, 1.230000E+00},{ 1.7700E+02, 1.230000E+00},{ 1.7800E+02, 1.230000E+00},{ 1.7900E+02, 1.230000E+00},
			{ 1.8000E+02, 1.230000E+00},{ 1.8100E+02, 1.230000E+00},{ 1.8200E+02, 1.230000E+00},{ 1.8300E+02, 1.240000E+00},
			{ 1.8400E+02, 1.240000E+00},{ 1.8500E+02, 1.240000E+00},{ 1.8600E+02, 1.240000E+00},{ 1.8700E+02, 1.240000E+00},
			{ 1.8800E+02, 1.240000E+00},{ 1.8900E+02, 1.250000E+00},{ 1.9000E+02, 1.240000E+00},{ 1.9100E+02, 1.240000E+00},
			{ 1.9200E+02, 1.240000E+00},{ 1.9300E+02, 1.240000E+00},{ 1.9400E+02, 1.240000E+00},{ 1.9500E+02, 1.230000E+00},
			{ 1.9600E+02, 1.230000E+00},{ 1.9700E+02, 1.230000E+00},{ 1.9800E+02, 1.230000E+00},{ 1.9900E+02, 1.230000E+00},
			{ 2.0000E+02, 1.230000E+00},{ 2.0100E+02, 1.230000E+00},{ 2.0200E+02, 1.230000E+00},{ 2.0300E+02, 1.230000E+00},
			{ 2.0400E+02, 1.240000E+00},{ 2.0500E+02, 1.250000E+00},{ 2.0600E+02, 1.250000E+00},{ 2.0700E+02, 1.250000E+00},
			{ 2.0800E+02, 1.250000E+00},{ 2.0900E+02, 1.250000E+00},{ 2.1000E+02, 1.250000E+00},{ 2.1100E+02, 1.240000E+00},
			{ 2.1200E+02, 1.240000E+00},{ 2.1300E+02, 1.240000E+00},{ 2.1400E+02, 1.240000E+00},{ 2.1500E+02, 1.230000E+00},
			{ 2.1600E+02, 1.230000E+00},{ 2.1700E+02, 1.230000E+00},{ 2.1800E+02, 1.230000E+00},{ 2.1900E+02, 1.230000E+00},
			{ 2.2000E+02, 1.240000E+00},{ 2.2100E+02, 1.250000E+00},{ 2.2200E+02, 1.240000E+00},{ 2.2300E+02, 1.240000E+00},
			{ 2.2400E+02, 1.240000E+00},{ 2.2500E+02, 1.230000E+00},{ 2.2600E+02, 1.230000E+00},{ 2.2700E+02, 1.240000E+00},
			{ 2.2800E+02, 1.240000E+00},{ 2.2900E+02, 1.230000E+00},{ 2.3000E+02, 1.230000E+00},{ 2.3100E+02, 1.230000E+00},
			{ 2.3200E+02, 1.240000E+00},{ 2.3300E+02, 1.240000E+00},{ 2.3400E+02, 1.240000E+00},{ 2.3500E+02, 1.230000E+00},
			{ 2.3600E+02, 1.230000E+00},{ 2.3700E+02, 1.230000E+00},{ 2.3800E+02, 1.220000E+00},{ 2.3900E+02, 1.230000E+00},
			{ 2.4000E+02, 1.220000E+00},{ 2.4100E+02, 1.220000E+00},{ 2.4200E+02, 1.220000E+00},{ 2.4300E+02, 1.220000E+00},
			{ 2.4400E+02, 1.220000E+00},{ 2.4500E+02, 1.210000E+00},{ 2.4600E+02, 1.210000E+00},{ 2.4700E+02, 1.220000E+00},
			{ 2.4800E+02, 1.220000E+00},{ 2.4900E+02, 1.220000E+00},{ 2.5000E+02, 1.220000E+00},{ 2.5100E+02, 1.220000E+00},
			{ 2.5200E+02, 1.210000E+00},{ 2.5300E+02, 1.210000E+00},{ 2.5400E+02, 1.210000E+00},{ 2.5500E+02, 1.210000E+00},
			{ 2.5600E+02, 1.210000E+00},{ 2.5700E+02, 1.210000E+00},{ 2.5800E+02, 1.210000E+00},{ 2.5900E+02, 1.210000E+00},
			{ 2.6000E+02, 1.220000E+00},{ 2.6100E+02, 1.220000E+00},{ 2.6200E+02, 1.220000E+00},{ 2.6300E+02, 1.220000E+00},
			{ 2.6400E+02, 1.220000E+00},{ 2.6500E+02, 1.220000E+00},{ 2.6600E+02, 1.220000E+00},{ 2.6700E+02, 1.230000E+00},
			{ 2.6800E+02, 1.240000E+00},{ 2.6900E+02, 1.240000E+00},{ 2.7000E+02, 1.230000E+00},{ 2.7100E+02, 1.230000E+00},
			{ 2.7200E+02, 1.230000E+00},{ 2.7300E+02, 1.230000E+00},{ 2.7400E+02, 1.230000E+00},{ 2.7500E+02, 1.220000E+00},
			{ 2.7600E+02, 1.220000E+00},{ 2.7700E+02, 1.220000E+00},{ 2.7800E+02, 1.240000E+00},{ 2.7900E+02, 1.240000E+00},
			{ 2.8000E+02, 1.230000E+00},{ 2.8100E+02, 1.230000E+00},{ 2.8200E+02, 1.230000E+00},{ 2.8300E+02, 1.230000E+00},
			{ 2.8400E+02, 1.220000E+00},{ 2.8500E+02, 1.220000E+00},{ 2.8600E+02, 1.220000E+00},{ 2.8700E+02, 1.220000E+00},
			{ 2.8800E+02, 1.230000E+00},{ 2.8900E+02, 1.230000E+00},{ 2.9000E+02, 1.240000E+00},{ 2.9100E+02, 1.240000E+00},
			{ 2.9200E+02, 1.240000E+00},{ 2.9300E+02, 1.240000E+00},{ 2.9400E+02, 1.230000E+00},{ 2.9500E+02, 1.230000E+00},
			{ 2.9600E+02, 1.230000E+00},{ 2.9700E+02, 1.220000E+00},{ 2.9800E+02, 1.220000E+00},{ 2.9900E+02, 1.220000E+00},
			{ 3.0000E+02, 1.220000E+00},{ 3.0100E+02, 1.220000E+00},{ 3.0200E+02, 1.220000E+00},{ 3.0300E+02, 1.210000E+00},
			{ 3.0400E+02, 1.210000E+00},{ 3.0500E+02, 1.210000E+00},{ 3.0600E+02, 1.210000E+00},{ 3.0700E+02, 1.210000E+00},
			{ 3.0800E+02, 1.210000E+00},{ 3.0900E+02, 1.210000E+00},{ 3.1000E+02, 1.210000E+00},{ 3.1100E+02, 1.210000E+00},
			{ 3.1200E+02, 1.210000E+00},{ 3.1300E+02, 1.210000E+00},{ 3.1400E+02, 1.210000E+00},{ 3.1500E+02, 1.220000E+00},
			{ 3.1600E+02, 1.220000E+00},{ 3.1700E+02, 1.220000E+00},{ 3.1800E+02, 1.220000E+00},{ 3.1900E+02, 1.220000E+00},
			{ 3.2000E+02, 1.220000E+00},{ 3.2100E+02, 1.220000E+00},{ 3.2200E+02, 1.220000E+00},{ 3.2300E+02, 1.220000E+00},
			{ 3.2400E+02, 1.220000E+00},{ 3.2500E+02, 1.230000E+00},{ 3.2600E+02, 1.240000E+00},{ 3.2700E+02, 1.240000E+00},
			{ 3.2800E+02, 1.240000E+00},{ 3.2900E+02, 1.240000E+00},{ 3.3000E+02, 1.230000E+00},{ 3.3100E+02, 1.230000E+00},
			{ 3.3200E+02, 1.230000E+00},{ 3.3300E+02, 1.230000E+00},{ 3.3400E+02, 1.240000E+00},{ 3.3500E+02, 1.250000E+00},
			{ 3.3600E+02, 1.260000E+00},{ 3.3700E+02, 1.260000E+00},{ 3.3800E+02, 1.260000E+00},{ 3.3900E+02, 1.250000E+00},
			{ 3.4000E+02, 1.250000E+00},{ 3.4100E+02, 1.250000E+00},{ 3.4200E+02, 1.250000E+00},{ 3.4300E+02, 1.260000E+00},
			{ 3.4400E+02, 1.250000E+00},{ 3.4500E+02, 1.250000E+00},{ 3.4600E+02, 1.240000E+00},{ 3.4700E+02, 1.240000E+00},
			{ 3.4800E+02, 1.240000E+00},{ 3.4900E+02, 1.240000E+00},{ 3.5000E+02, 1.230000E+00},{ 3.5100E+02, 1.230000E+00},
			{ 3.5200E+02, 1.230000E+00},{ 3.5300E+02, 1.220000E+00},{ 3.5400E+02, 1.220000E+00},{ 3.5500E+02, 1.220000E+00},
			{ 3.5600E+02, 1.220000E+00},{ 3.5700E+02, 1.220000E+00},{ 3.5800E+02, 1.220000E+00},{ 3.5900E+02, 1.210000E+00},
			{ 3.6000E+02, 1.210000E+00},{ 3.6100E+02, 1.210000E+00},{ 3.6200E+02, 1.220000E+00},{ 3.6300E+02, 1.230000E+00},
			{ 3.6400E+02, 1.220000E+00}, };
		return SL::Graph( 0, x, 364, g); 
	}

	inline double Graph21(double x) { 
		static double g[11][2] = {
			{ 0.0000E+00, 2.200000E+00},{ 3.6500E+01, 4.500000E+00},{ 7.3000E+01, 9.100000E+00},{ 1.1000E+02, 1.340000E+01},
			{ 1.4600E+02, 1.690000E+01},{ 1.8200E+02, 1.850000E+01},{ 2.1900E+02, 1.880000E+01},{ 2.5600E+02, 1.800000E+01},
			{ 2.9200E+02, 1.190000E+01},{ 3.2800E+02, 3.400000E+00},{ 3.6500E+02, 1.500000E+00}, };
		return SL::Graph( 0, x, 10, g); 
	}

	inline double Graph22(double x) { 
		static double g[364][2] = {
			{ 0.0000E+00, 0.000000E+00},{ 1.0000E+00, 0.000000E+00},{ 2.0000E+00, 0.000000E+00},{ 3.0000E+00, 0.000000E+00},
			{ 4.0000E+00, 2.050000E-03},{ 5.0000E+00, 6.770000E-03},{ 6.0000E+00, 0.000000E+00},{ 7.0000E+00, 0.000000E+00},
			{ 8.0000E+00, 6.300000E-03},{ 9.0000E+00, 9.240000E-03},{ 1.0000E+01, 1.360000E-02},{ 1.1000E+01, 5.080000E-03},
			{ 1.2000E+01, 3.720000E-04},{ 1.3000E+01, 1.010000E-03},{ 1.4000E+01, 6.230000E-03},{ 1.5000E+01, 3.580000E-03},
			{ 1.6000E+01, 4.360000E-04},{ 1.7000E+01, 1.780000E-07},{ 1.8000E+01, 1.250000E-04},{ 1.9000E+01, 7.470000E-04},
			{ 2.0000E+01, 1.240000E-04},{ 2.1000E+01, 0.000000E+00},{ 2.2000E+01, 0.000000E+00},{ 2.3000E+01, 0.000000E+00},
			{ 2.4000E+01, 0.000000E+00},{ 2.5000E+01, 9.280000E-10},{ 2.6000E+01, 6.960000E-10},{ 2.7000E+01, 1.740000E-10},
			{ 2.8000E+01, 1.560000E-04},{ 2.9000E+01, 9.330000E-04},{ 3.0000E+01, 1.560000E-04},{ 3.1000E+01, 1.360000E-12},
			{ 3.2000E+01, 3.400000E-13},{ 3.3000E+01, 8.500000E-14},{ 3.4000E+01, 9.330000E-05},{ 3.5000E+01, 1.180000E-03},
			{ 3.6000E+01, 3.890000E-03},{ 3.7000E+01, 9.960000E-04},{ 3.8000E+01, 6.220000E-05},{ 3.9000E+01, 2.070000E-17},
			{ 4.0000E+01, 5.190000E-18},{ 4.1000E+01, 8.640000E-19},{ 4.2000E+01, 9.330000E-04},{ 4.3000E+01, 5.600000E-03},
			{ 4.4000E+01, 9.330000E-04},{ 4.5000E+01, 1.350000E-20},{ 4.6000E+01, 0.000000E+00},{ 4.7000E+01, 2.590000E-03},
			{ 4.8000E+01, 2.460000E-03},{ 4.9000E+01, 2.540000E-03},{ 5.0000E+01, 3.770000E-04},{ 5.1000E+01, 1.000000E-06},
			{ 5.2000E+01, 2.510000E-07},{ 5.3000E+01, 6.270000E-08},{ 5.4000E+01, 3.110000E-05},{ 5.5000E+01, 1.870000E-04},
			{ 5.6000E+01, 3.110000E-05},{ 5.7000E+01, 2.450000E-10},{ 5.8000E+01, 4.040000E-04},{ 5.9000E+01, 2.430000E-03},
			{ 6.0000E+01, 2.430000E-03},{ 6.1000E+01, 1.120000E-02},{ 6.2000E+01, 4.260000E-03},{ 6.3000E+01, 8.710000E-04},
			{ 6.4000E+01, 2.990000E-03},{ 6.5000E+01, 4.980000E-04},{ 6.6000E+01, 9.340000E-16},{ 6.7000E+01, 2.330000E-16},
			{ 6.8000E+01, 5.840000E-17},{ 6.9000E+01, 1.460000E-17},{ 7.0000E+01, 1.060000E-03},{ 7.1000E+01, 6.750000E-03},
			{ 7.2000E+01, 3.480000E-03},{ 7.3000E+01, 4.040000E-04},{ 7.4000E+01, 2.830000E-03},{ 7.5000E+01, 1.250000E-02},
			{ 7.6000E+01, 3.020000E-03},{ 7.7000E+01, 6.220000E-05},{ 7.8000E+01, 1.870000E-04},{ 7.9000E+01, 3.430000E-03},
			{ 8.0000E+01, 1.360000E-02},{ 8.1000E+01, 1.280000E-02},{ 8.2000E+01, 2.740000E-03},{ 8.3000E+01, 6.220000E-04},
			{ 8.4000E+01, 3.550000E-03},{ 8.5000E+01, 8.710000E-04},{ 8.6000E+01, 4.700000E-03},{ 8.7000E+01, 1.310000E-02},
			{ 8.8000E+01, 3.020000E-03},{ 8.9000E+01, 1.330000E-29},{ 9.0000E+01, 3.320000E-30},{ 9.1000E+01, 8.290000E-31},
			{ 9.2000E+01, 2.070000E-31},{ 9.3000E+01, 3.110000E-04},{ 9.4000E+01, 1.870000E-03},{ 9.5000E+01, 3.110000E-04},
			{ 9.6000E+01, 8.100000E-34},{ 9.7000E+01, 2.020000E-34},{ 9.8000E+01, 5.060000E-35},{ 9.9000E+01, 1.270000E-35},
			{ 1.0000E+02, 3.160000E-36},{ 1.0100E+02, 1.740000E-03},{ 1.0200E+02, 1.070000E-02},{ 1.0300E+02, 4.790000E-03},
			{ 1.0400E+02, 5.230000E-03},{ 1.0500E+02, 8.090000E-04},{ 1.0600E+02, 7.720005E-40},{ 1.0700E+02, 9.330000E-05},
			{ 1.0800E+02, 6.220000E-04},{ 1.0900E+02, 9.960000E-04},{ 1.1000E+02, 3.240000E-03},{ 1.1100E+02, 5.290000E-04},
			{ 1.1200E+02, 3.110000E-04},{ 1.1300E+02, 1.870000E-03},{ 1.1400E+02, 3.110000E-04},{ 1.1500E+02, 7.780000E-04},
			{ 1.1600E+02, 5.760000E-03},{ 1.1700E+02, 7.720000E-03},{ 1.1800E+02, 3.580000E-03},{ 1.1900E+02, 1.090000E-03},
			{ 1.2000E+02, 1.930000E-03},{ 1.2100E+02, 3.110000E-04},{ 1.2200E+02, 0.000000E+00},{ 1.2300E+02, 1.460000E-03},
			{ 1.2400E+02, 9.240000E-03},{ 1.2500E+02, 4.260000E-03},{ 1.2600E+02, 4.670000E-04},{ 1.2700E+02, 4.670000E-04},
			{ 1.2800E+02, 2.800000E-03},{ 1.2900E+02, 4.670000E-04},{ 1.3000E+02, 0.000000E+00},{ 1.3100E+02, 0.000000E+00},
			{ 1.3200E+02, 0.000000E+00},{ 1.3300E+02, 0.000000E+00},{ 1.3400E+02, 0.000000E+00},{ 1.3500E+02, 3.400000E-03},
			{ 1.3600E+02, 1.360000E-02},{ 1.3700E+02, 4.800000E-03},{ 1.3800E+02, 2.800000E-04},{ 1.3900E+02, 0.000000E+00},
			{ 1.4000E+02, 0.000000E+00},{ 1.4100E+02, 0.000000E+00},{ 1.4200E+02, 0.000000E+00},{ 1.4300E+02, 0.000000E+00},
			{ 1.4400E+02, 0.000000E+00},{ 1.4500E+02, 6.220000E-05},{ 1.4600E+02, 3.730000E-04},{ 1.4700E+02, 6.220000E-05},
			{ 1.4800E+02, 0.000000E+00},{ 1.4900E+02, 0.000000E+00},{ 1.5000E+02, 1.030000E-03},{ 1.5100E+02, 6.160000E-03},
			{ 1.5200E+02, 1.030000E-03},{ 1.5300E+02, 0.000000E+00},{ 1.5400E+02, 0.000000E+00},{ 1.5500E+02, 0.000000E+00},
			{ 1.5600E+02, 0.000000E+00},{ 1.5700E+02, 0.000000E+00},{ 1.5800E+02, 0.000000E+00},{ 1.5900E+02, 0.000000E+00},
			{ 1.6000E+02, 0.000000E+00},{ 1.6100E+02, 0.000000E+00},{ 1.6200E+02, 0.000000E+00},{ 1.6300E+02, 0.000000E+00},
			{ 1.6400E+02, 0.000000E+00},{ 1.6500E+02, 0.000000E+00},{ 1.6600E+02, 3.400000E-03},{ 1.6700E+02, 1.360000E-02},
			{ 1.6800E+02, 4.800000E-03},{ 1.6900E+02, 2.800000E-04},{ 1.7000E+02, 0.000000E+00},{ 1.7100E+02, 9.330000E-04},
			{ 1.7200E+02, 5.820000E-03},{ 1.7300E+02, 2.240000E-03},{ 1.7400E+02, 2.180000E-04},{ 1.7500E+02, 0.000000E+00},
			{ 1.7600E+02, 0.000000E+00},{ 1.7700E+02, 0.000000E+00},{ 1.7800E+02, 0.000000E+00},{ 1.7900E+02, 0.000000E+00},
			{ 1.8000E+02, 0.000000E+00},{ 1.8100E+02, 1.710000E-03},{ 1.8200E+02, 1.020000E-02},{ 1.8300E+02, 1.800000E-03},
			{ 1.8400E+02, 6.530000E-04},{ 1.8500E+02, 6.530000E-04},{ 1.8600E+02, 1.150000E-03},{ 1.8700E+02, 7.250000E-03},
			{ 1.8800E+02, 6.530000E-03},{ 1.8900E+02, 1.370000E-03},{ 1.9000E+02, 6.220000E-04},{ 1.9100E+02, 2.800000E-04},
			{ 1.9200E+02, 1.120000E-03},{ 1.9300E+02, 1.870000E-04},{ 1.9400E+02, 0.000000E+00},{ 1.9500E+02, 0.000000E+00},
			{ 1.9600E+02, 0.000000E+00},{ 1.9700E+02, 0.000000E+00},{ 1.9800E+02, 0.000000E+00},{ 1.9900E+02, 0.000000E+00},
			{ 2.0000E+02, 3.110000E-04},{ 2.0100E+02, 1.870000E-03},{ 2.0200E+02, 1.490000E-03},{ 2.0300E+02, 9.310000E-03},
			{ 2.0400E+02, 1.360000E-02},{ 2.0500E+02, 5.110000E-03},{ 2.0600E+02, 3.050000E-03},{ 2.0700E+02, 9.960000E-04},
			{ 2.0800E+02, 3.760000E-03},{ 2.0900E+02, 4.080000E-03},{ 2.1000E+02, 5.910000E-04},{ 2.1100E+02, 0.000000E+00},
			{ 2.1200E+02, 0.000000E+00},{ 2.1300E+02, 0.000000E+00},{ 2.1400E+02, 0.000000E+00},{ 2.1500E+02, 0.000000E+00},
			{ 2.1600E+02, 0.000000E+00},{ 2.1700E+02, 0.000000E+00},{ 2.1800E+02, 3.400000E-03},{ 2.1900E+02, 1.360000E-02},
			{ 2.2000E+02, 9.470000E-03},{ 2.2100E+02, 1.210000E-03},{ 2.2200E+02, 0.000000E+00},{ 2.2300E+02, 0.000000E+00},
			{ 2.2400E+02, 6.220000E-05},{ 2.2500E+02, 1.990000E-03},{ 2.2600E+02, 9.770000E-03},{ 2.2700E+02, 1.620000E-03},
			{ 2.2800E+02, 0.000000E+00},{ 2.2900E+02, 2.490000E-04},{ 2.3000E+02, 4.260000E-03},{ 2.3100E+02, 1.260000E-02},
			{ 2.3200E+02, 2.770000E-03},{ 2.3300E+02, 0.000000E+00},{ 2.3400E+02, 0.000000E+00},{ 2.3500E+02, 0.000000E+00},
			{ 2.3600E+02, 0.000000E+00},{ 2.3700E+02, 6.850000E-04},{ 2.3800E+02, 4.110000E-03},{ 2.3900E+02, 6.850000E-04},
			{ 2.4000E+02, 0.000000E+00},{ 2.4100E+02, 0.000000E+00},{ 2.4200E+02, 0.000000E+00},{ 2.4300E+02, 0.000000E+00},
			{ 2.4400E+02, 0.000000E+00},{ 2.4500E+02, 1.590000E-03},{ 2.4600E+02, 9.580000E-03},{ 2.4700E+02, 1.960000E-03},
			{ 2.4800E+02, 6.220000E-05},{ 2.4900E+02, 0.000000E+00},{ 2.5000E+02, 0.000000E+00},{ 2.5100E+02, 0.000000E+00},
			{ 2.5200E+02, 0.000000E+00},{ 2.5300E+02, 0.000000E+00},{ 2.5400E+02, 1.240000E-04},{ 2.5500E+02, 7.470000E-04},
			{ 2.5600E+02, 1.240000E-04},{ 2.5700E+02, 0.000000E+00},{ 2.5800E+02, 1.060000E-03},{ 2.5900E+02, 6.350000E-03},
			{ 2.6000E+02, 1.680000E-03},{ 2.6100E+02, 3.730000E-03},{ 2.6200E+02, 6.220000E-04},{ 2.6300E+02, 0.000000E+00},
			{ 2.6400E+02, 9.330000E-05},{ 2.6500E+02, 3.860000E-03},{ 2.6600E+02, 1.360000E-02},{ 2.6700E+02, 9.470000E-03},
			{ 2.6800E+02, 1.210000E-03},{ 2.6900E+02, 0.000000E+00},{ 2.7000E+02, 0.000000E+00},{ 2.7100E+02, 0.000000E+00},
			{ 2.7200E+02, 0.000000E+00},{ 2.7300E+02, 9.330000E-05},{ 2.7400E+02, 5.600000E-04},{ 2.7500E+02, 9.330000E-05},
			{ 2.7600E+02, 3.400000E-03},{ 2.7700E+02, 1.360000E-02},{ 2.7800E+02, 3.400000E-03},{ 2.7900E+02, 0.000000E+00},
			{ 2.8000E+02, 0.000000E+00},{ 2.8100E+02, 0.000000E+00},{ 2.8200E+02, 0.000000E+00},{ 2.8300E+02, 0.000000E+00},
			{ 2.8400E+02, 4.980000E-04},{ 2.8500E+02, 2.990000E-03},{ 2.8600E+02, 1.520000E-03},{ 2.8700E+02, 6.750000E-03},
			{ 2.8800E+02, 7.380000E-03},{ 2.8900E+02, 1.360000E-02},{ 2.9000E+02, 3.400000E-03},{ 2.9100E+02, 0.000000E+00},
			{ 2.9200E+02, 0.000000E+00},{ 2.9300E+02, 0.000000E+00},{ 2.9400E+02, 0.000000E+00},{ 2.9500E+02, 6.220000E-05},
			{ 2.9600E+02, 3.730000E-04},{ 2.9700E+02, 6.220000E-05},{ 2.9800E+02, 6.220000E-05},{ 2.9900E+02, 3.730000E-04},
			{ 3.0000E+02, 6.220000E-05},{ 3.0100E+02, 0.000000E+00},{ 3.0200E+02, 0.000000E+00},{ 3.0300E+02, 0.000000E+00},
			{ 3.0400E+02, 0.000000E+00},{ 3.0500E+02, 0.000000E+00},{ 3.0600E+02, 0.000000E+00},{ 3.0700E+02, 0.000000E+00},
			{ 3.0800E+02, 0.000000E+00},{ 3.0900E+02, 0.000000E+00},{ 3.1000E+02, 0.000000E+00},{ 3.1100E+02, 9.330000E-05},
			{ 3.1200E+02, 6.220000E-04},{ 3.1300E+02, 1.090000E-03},{ 3.1400E+02, 3.980000E-03},{ 3.1500E+02, 1.740000E-03},
			{ 3.1600E+02, 1.870000E-04},{ 3.1700E+02, 0.000000E+00},{ 3.1800E+02, 0.000000E+00},{ 3.1900E+02, 0.000000E+00},
			{ 3.2000E+02, 0.000000E+00},{ 3.2100E+02, 0.000000E+00},{ 3.2200E+02, 0.000000E+00},{ 3.2300E+02, 1.740000E-03},
			{ 3.2400E+02, 1.190000E-02},{ 3.2500E+02, 1.240000E-02},{ 3.2600E+02, 2.240000E-03},{ 3.2700E+02, 0.000000E+00},
			{ 3.2800E+02, 0.000000E+00},{ 3.2900E+02, 0.000000E+00},{ 3.3000E+02, 0.000000E+00},{ 3.3100E+02, 0.000000E+00},
			{ 3.3200E+02, 1.280000E-03},{ 3.3300E+02, 8.710000E-03},{ 3.3400E+02, 9.970000E-03},{ 3.3500E+02, 1.360000E-02},
			{ 3.3600E+02, 1.130000E-02},{ 3.3700E+02, 1.590000E-03},{ 3.3800E+02, 0.000000E+00},{ 3.3900E+02, 0.000000E+00},
			{ 3.4000E+02, 1.240000E-04},{ 3.4100E+02, 4.020000E-03},{ 3.4200E+02, 1.360000E-02},{ 3.4300E+02, 3.400000E-03},
			{ 3.4400E+02, 3.110000E-05},{ 3.4500E+02, 9.020000E-04},{ 3.4600E+02, 4.480000E-03},{ 3.4700E+02, 1.650000E-03},
			{ 3.4800E+02, 1.560000E-04},{ 3.4900E+02, 0.000000E+00},{ 3.5000E+02, 0.000000E+00},{ 3.5100E+02, 0.000000E+00},
			{ 3.5200E+02, 0.000000E+00},{ 3.5300E+02, 2.100000E-04},{ 3.5400E+02, 3.690000E-05},{ 3.5500E+02, 6.860000E-04},
			{ 3.5600E+02, 4.110000E-03},{ 3.5700E+02, 6.850000E-04},{ 3.5800E+02, 3.040000E-08},{ 3.5900E+02, 3.110000E-05},
			{ 3.6000E+02, 2.920000E-03},{ 3.6100E+02, 1.270000E-02},{ 3.6200E+02, 4.980000E-03},{ 3.6300E+02, 3.730000E-04},
			 };
		return SL::Graph( 0, x, 363, g); 
	}

	inline double Graph23(double x) { 
		static double g[11][2] = {
			{ 0.0000E+00, 8.900000E-01},{ 3.6500E+01, 8.900000E-01},{ 7.3000E+01, 8.950000E-01},{ 1.1000E+02, 8.950000E-01},
			{ 1.4600E+02, 8.950000E-01},{ 1.8200E+02, 9.050000E-01},{ 2.1900E+02, 9.250000E-01},{ 2.5600E+02, 9.600000E-01},
			{ 2.9200E+02, 9.700000E-01},{ 3.2800E+02, 9.550000E-01},{ 3.6500E+02, 8.900000E-01}, };
		return SL::Graph( 0, x, 10, g); 
	}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int SOLRADGR_u137_exe_g(Variable* obj) { return XXXImports4_module::I().SOLRADGR_u137_exe(); }
// ---------------------------------------------------------------------------
//                    Class DOM_module 
// ---------------------------------------------------------------------------

class DOM_module : public TModule {
protected:

	DOM_module(char* name);

public:

	TTime TIME;
	CFluxVariable PHBIO_MORT;
	CFluxVariable PHBIO_HARVEST;
	CFluxVariable NPHBIO_MORT;
	CFluxVariable NPHBIO_HARVEST;
	CAuxVariable AIR_TEMP_C;
	CAuxVariable D_DECOMP;
	CStateVariable DEP_ORG_MAT;
	CFluxVariable SD_TO_DOM;
	CFluxVariable DOM_DECOMP;
	CStateVariable LAB_DETRITUS;
	CFluxVariable SD_DECOMP;
	CFluxVariable LD_IN;
	CFluxVariable LD_DECOMP;
	CStateVariable STAB_DETRITUS;
	CFluxVariable SD_IN;
	CAuxVariable F_TEMP;
	CAuxVariable P1_DOM_DEC_RATE;
	CAuxVariable P1_DOM_INIT;
	CAuxVariable P1_HARV_NPH_LEFT;
	CAuxVariable P1_HARV_PH_LEFT;
	CAuxVariable P1_LD_DEC_RATE;
	CAuxVariable P1_LD_INIT;
	CAuxVariable P1_NPH_LIGNIN_CONTENT;
	CAuxVariable P1_PH_LIGNIN_CONTENT;
	CAuxVariable P1_SD_DEC_RATE;
	CAuxVariable P1_SD_INIT;
	CAuxVariable P1_SD_TO_DOM_RATE;
protected:

	int DEP_ORG_MAT_I146_exe();
	friend int DEP_ORG_MAT_I146_exe_g( Variable* v );
	int DEP_ORG_MAT_i147_exe();
	friend int DEP_ORG_MAT_i147_exe_g( Variable* v );
	int SD_TO_DOM_u148_exe();
	friend int SD_TO_DOM_u148_exe_g( Variable* v );
	int DOM_DECOMP_u149_exe();
	friend int DOM_DECOMP_u149_exe_g( Variable* v );
	int LAB_DETRITUS_I150_exe();
	friend int LAB_DETRITUS_I150_exe_g( Variable* v );
	int LAB_DETRITUS_i151_exe();
	friend int LAB_DETRITUS_i151_exe_g( Variable* v );
	int SD_DECOMP_u152_exe();
	friend int SD_DECOMP_u152_exe_g( Variable* v );
	int LD_IN_u153_exe();
	friend int LD_IN_u153_exe_g( Variable* v );
	int LD_DECOMP_u154_exe();
	friend int LD_DECOMP_u154_exe_g( Variable* v );
	int STAB_DETRITUS_I155_exe();
	friend int STAB_DETRITUS_I155_exe_g( Variable* v );
	int STAB_DETRITUS_i156_exe();
	friend int STAB_DETRITUS_i156_exe_g( Variable* v );
	int SD_IN_u157_exe();
	friend int SD_IN_u157_exe_g( Variable* v );
	int D_DECOMP_u158_exe();
	friend int D_DECOMP_u158_exe_g( Variable* v );
	int F_TEMP_u159_exe();
	friend int F_TEMP_u159_exe_g( Variable* v );
	int P1_DOM_DEC_RATE_u160_exe();
	friend int P1_DOM_DEC_RATE_u160_exe_g( Variable* v );
	int P1_DOM_INIT_u161_exe();
	friend int P1_DOM_INIT_u161_exe_g( Variable* v );
	int P1_HARV_NPH_LEFT_u162_exe();
	friend int P1_HARV_NPH_LEFT_u162_exe_g( Variable* v );
	int P1_HARV_PH_LEFT_u163_exe();
	friend int P1_HARV_PH_LEFT_u163_exe_g( Variable* v );
	int P1_LD_DEC_RATE_u164_exe();
	friend int P1_LD_DEC_RATE_u164_exe_g( Variable* v );
	int P1_LD_INIT_u165_exe();
	friend int P1_LD_INIT_u165_exe_g( Variable* v );
	int P1_NPH_LIGNIN_CONTENT_u166_exe();
	friend int P1_NPH_LIGNIN_CONTENT_u166_exe_g( Variable* v );
	int P1_PH_LIGNIN_CONTENT_u167_exe();
	friend int P1_PH_LIGNIN_CONTENT_u167_exe_g( Variable* v );
	int P1_SD_DEC_RATE_u168_exe();
	friend int P1_SD_DEC_RATE_u168_exe_g( Variable* v );
	int P1_SD_INIT_u169_exe();
	friend int P1_SD_INIT_u169_exe_g( Variable* v );
	int P1_SD_TO_DOM_RATE_u170_exe();
	friend int P1_SD_TO_DOM_RATE_u170_exe_g( Variable* v );
	static DOM_module* fInstance;
	static DOM_module* kNullModel;
public:
	inline static DOM_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new DOM_module("DOM_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (DOM_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int DEP_ORG_MAT_I146_exe_g(Variable* obj) { return DOM_module::I().DEP_ORG_MAT_I146_exe(); }
int DEP_ORG_MAT_i147_exe_g(Variable* obj) { return DOM_module::I().DEP_ORG_MAT_i147_exe(); }
int SD_TO_DOM_u148_exe_g(Variable* obj) { return DOM_module::I().SD_TO_DOM_u148_exe(); }
int DOM_DECOMP_u149_exe_g(Variable* obj) { return DOM_module::I().DOM_DECOMP_u149_exe(); }
int LAB_DETRITUS_I150_exe_g(Variable* obj) { return DOM_module::I().LAB_DETRITUS_I150_exe(); }
int LAB_DETRITUS_i151_exe_g(Variable* obj) { return DOM_module::I().LAB_DETRITUS_i151_exe(); }
int SD_DECOMP_u152_exe_g(Variable* obj) { return DOM_module::I().SD_DECOMP_u152_exe(); }
int LD_IN_u153_exe_g(Variable* obj) { return DOM_module::I().LD_IN_u153_exe(); }
int LD_DECOMP_u154_exe_g(Variable* obj) { return DOM_module::I().LD_DECOMP_u154_exe(); }
int STAB_DETRITUS_I155_exe_g(Variable* obj) { return DOM_module::I().STAB_DETRITUS_I155_exe(); }
int STAB_DETRITUS_i156_exe_g(Variable* obj) { return DOM_module::I().STAB_DETRITUS_i156_exe(); }
int SD_IN_u157_exe_g(Variable* obj) { return DOM_module::I().SD_IN_u157_exe(); }
int D_DECOMP_u158_exe_g(Variable* obj) { return DOM_module::I().D_DECOMP_u158_exe(); }
int F_TEMP_u159_exe_g(Variable* obj) { return DOM_module::I().F_TEMP_u159_exe(); }
int P1_DOM_DEC_RATE_u160_exe_g(Variable* obj) { return DOM_module::I().P1_DOM_DEC_RATE_u160_exe(); }
int P1_DOM_INIT_u161_exe_g(Variable* obj) { return DOM_module::I().P1_DOM_INIT_u161_exe(); }
int P1_HARV_NPH_LEFT_u162_exe_g(Variable* obj) { return DOM_module::I().P1_HARV_NPH_LEFT_u162_exe(); }
int P1_HARV_PH_LEFT_u163_exe_g(Variable* obj) { return DOM_module::I().P1_HARV_PH_LEFT_u163_exe(); }
int P1_LD_DEC_RATE_u164_exe_g(Variable* obj) { return DOM_module::I().P1_LD_DEC_RATE_u164_exe(); }
int P1_LD_INIT_u165_exe_g(Variable* obj) { return DOM_module::I().P1_LD_INIT_u165_exe(); }
int P1_NPH_LIGNIN_CONTENT_u166_exe_g(Variable* obj) { return DOM_module::I().P1_NPH_LIGNIN_CONTENT_u166_exe(); }
int P1_PH_LIGNIN_CONTENT_u167_exe_g(Variable* obj) { return DOM_module::I().P1_PH_LIGNIN_CONTENT_u167_exe(); }
int P1_SD_DEC_RATE_u168_exe_g(Variable* obj) { return DOM_module::I().P1_SD_DEC_RATE_u168_exe(); }
int P1_SD_INIT_u169_exe_g(Variable* obj) { return DOM_module::I().P1_SD_INIT_u169_exe(); }
int P1_SD_TO_DOM_RATE_u170_exe_g(Variable* obj) { return DOM_module::I().P1_SD_TO_DOM_RATE_u170_exe(); }
// ---------------------------------------------------------------------------
//                    Class ZDIN_module 
// ---------------------------------------------------------------------------

class ZDIN_module : public TModule {
protected:

	ZDIN_module(char* name);

public:

	TTime TIME;
	CAuxVariable DIN_AVAILABLE;
	CAuxVariable DAYJUL;
	CStateVariable SAT_WATER;
	CStateVariable UNSAT_WATER;
	CFluxVariable UW_FROM_PRECIP;
	CFluxVariable SW_TO_SATW_DOWNFLOW;
	CFluxVariable SATW_FROM_PRECIP;
	CAuxVariable CELL_SIZE;
	CAuxVariable AIR_TEMP_C;
	CFluxVariable SATW_TO_SW_UPFLOW;
	CFluxVariable PHBIO_NPP;
	CAuxVariable UW_DEPTH;
	CAuxVariable ELEVATION;
	CFluxVariable SATW_OUTFLUX;
	CFluxVariable SW_OUTFLUX;
	CAuxVariable HABITATMAP;
	CAuxVariable ROOT_DEPTH;
	CStateVariable SURFACE_WATER;
	CAuxVariable D_DECOMP;
	CFluxVariable SATW_TRANSP;
	CFluxVariable UW_ETRANSP;
	CStateVariable DIN_SD;
	CStateVariable DIN_SF;
	CStateVariable A_IN;
	CFluxVariable ATM_FLOW;
	CStateVariable DIN_FERT_AV;
	CFluxVariable DIN_FERT;
	CFluxVariable FERT_AV;
	CFluxVariable DIN_DNFLOW;
	CFluxVariable DINSD_LOAD;
	CFluxVariable DOM_TO_DINSD;
	CFluxVariable DINSD_DENIT;
	CFluxVariable DIN_UPFLOW;
	CFluxVariable DINSD_UPTAKE;
	CFluxVariable DINSD_HOUT;
	CFluxVariable DINSF_ATM;
	CFluxVariable DOM_TO_DINSF;
	CFluxVariable DINSF_UPTAKE;
	CFluxVariable DINSF_OUT;
	CStateVariable F_IN;
	CFluxVariable FERT_FLOW;
	CStateVariable M_IN;
	CFluxVariable MINER_FLOW;
	CStateVariable S_IN;
	CFluxVariable SEPTIC_FLOW;
	CAuxVariable COUNTY;
	CAuxVariable CROP;
	CAuxVariable DINSD_AVAIL;
	CAuxVariable DINSD_CONC;
	CAuxVariable DINSD_PR1;
	CAuxVariable DINSD_PR2;
	CAuxVariable DINSD_PR3;
	CAuxVariable DINSF_AVAIL;
	CAuxVariable DINSF_CONC;
	CAuxVariable DINSF_PR1;
	CAuxVariable DINSF_PR2;
	CAuxVariable DIN_ATMOS_LOAD;
	CAuxVariable DOM_TO_DIN;
	CAuxVariable N_NPOINTSD;
	CAuxVariable OUTPUTCOL;
	CAuxVariable OUTPUTROW;
	CAuxVariable OUTPUTVAR;
	CAuxVariable SR_WATER;
	CAuxVariable ZONMAP;
	CAuxVariable P1_BOCOEF;
	CAuxVariable P1_DINSD_OUT;
	CAuxVariable P1_DINSF_OUT;
	CAuxVariable P1_DIN_CR_SED_MIN;
	CAuxVariable P1_DIN_DAY_FERT1;
	CAuxVariable P1_DIN_DAY_FERT2;
	CAuxVariable P1_DIN_DIFFCOEF;
	CAuxVariable P1_DIN_FERT_APP;
	CAuxVariable P1_DIN_FERT_DIS;
	CAuxVariable P1_DIN_FERT_HAB1;
	CAuxVariable P1_DIN_FERT_HAB2;
	CAuxVariable P1_DIN_GRAD;
	CAuxVariable P1_DIN_ICSED;
	CAuxVariable P1_DIN_ICSF;
	CAuxVariable P1_DIN_K_OF_NH4;
	CAuxVariable P1_DIN_RCDENIT;
	CAuxVariable P1_DOMSD_ANAEROB_Z;
	CAuxVariable P1_DOM_CTOOM;
	CAuxVariable P1_DOM_NC;
	CAuxVariable P1_D_DEP_FACTOR;
	CAuxVariable P1_NPOINTNSF;
	CAuxVariable P1_PHBIO_NC;
	CAuxVariable P1_PHBIO_NC_SF;
	CAuxVariable P1_POINTNSF;
	CAuxVariable P1_POP_DENS;
	CAuxVariable P1_R_SUB;
	CAuxVariable P1_SEPTICLOAD;
	CAuxVariable P1_SEPTIC_RED;
	CAuxVariable P1_SEWERMAP;
	CAuxVariable DIN_IN_RAIN;
protected:

	int A_IN_I177_exe();
	friend int A_IN_I177_exe_g( Variable* v );
	int A_IN_i178_exe();
	friend int A_IN_i178_exe_g( Variable* v );
	int ATM_FLOW_u179_exe();
	friend int ATM_FLOW_u179_exe_g( Variable* v );
	int DIN_FERT_AV_I180_exe();
	friend int DIN_FERT_AV_I180_exe_g( Variable* v );
	int DIN_FERT_AV_i181_exe();
	friend int DIN_FERT_AV_i181_exe_g( Variable* v );
	int DIN_FERT_u182_exe();
	friend int DIN_FERT_u182_exe_g( Variable* v );
	int FERT_AV_u183_exe();
	friend int FERT_AV_u183_exe_g( Variable* v );
	int DIN_SD_I184_exe();
	friend int DIN_SD_I184_exe_g( Variable* v );
	int DIN_SD_i185_exe();
	friend int DIN_SD_i185_exe_g( Variable* v );
	int DIN_DNFLOW_u186_exe();
	friend int DIN_DNFLOW_u186_exe_g( Variable* v );
	int DINSD_LOAD_u187_exe();
	friend int DINSD_LOAD_u187_exe_g( Variable* v );
	int DOM_TO_DINSD_u188_exe();
	friend int DOM_TO_DINSD_u188_exe_g( Variable* v );
	int DINSD_DENIT_u189_exe();
	friend int DINSD_DENIT_u189_exe_g( Variable* v );
	int DIN_UPFLOW_u190_exe();
	friend int DIN_UPFLOW_u190_exe_g( Variable* v );
	int DINSD_UPTAKE_u191_exe();
	friend int DINSD_UPTAKE_u191_exe_g( Variable* v );
	int DINSD_HOUT_u192_exe();
	friend int DINSD_HOUT_u192_exe_g( Variable* v );
	int DIN_SF_I193_exe();
	friend int DIN_SF_I193_exe_g( Variable* v );
	int DIN_SF_i194_exe();
	friend int DIN_SF_i194_exe_g( Variable* v );
	int DINSF_ATM_u195_exe();
	friend int DINSF_ATM_u195_exe_g( Variable* v );
	int DOM_TO_DINSF_u196_exe();
	friend int DOM_TO_DINSF_u196_exe_g( Variable* v );
	int DINSF_UPTAKE_u197_exe();
	friend int DINSF_UPTAKE_u197_exe_g( Variable* v );
	int DINSF_OUT_u198_exe();
	friend int DINSF_OUT_u198_exe_g( Variable* v );
	int F_IN_I199_exe();
	friend int F_IN_I199_exe_g( Variable* v );
	int F_IN_i200_exe();
	friend int F_IN_i200_exe_g( Variable* v );
	int FERT_FLOW_u201_exe();
	friend int FERT_FLOW_u201_exe_g( Variable* v );
	int M_IN_I202_exe();
	friend int M_IN_I202_exe_g( Variable* v );
	int M_IN_i203_exe();
	friend int M_IN_i203_exe_g( Variable* v );
	int MINER_FLOW_u204_exe();
	friend int MINER_FLOW_u204_exe_g( Variable* v );
	int S_IN_I205_exe();
	friend int S_IN_I205_exe_g( Variable* v );
	int S_IN_i206_exe();
	friend int S_IN_i206_exe_g( Variable* v );
	int SEPTIC_FLOW_u207_exe();
	friend int SEPTIC_FLOW_u207_exe_g( Variable* v );
	int COUNTY_u208_exe();
	friend int COUNTY_u208_exe_g( Variable* v );
	int CROP_u209_exe();
	friend int CROP_u209_exe_g( Variable* v );
	int DINSD_AVAIL_u210_exe();
	friend int DINSD_AVAIL_u210_exe_g( Variable* v );
	int DINSD_CONC_u211_exe();
	friend int DINSD_CONC_u211_exe_g( Variable* v );
	int DINSD_PR1_u212_exe();
	friend int DINSD_PR1_u212_exe_g( Variable* v );
	int DINSD_PR2_u213_exe();
	friend int DINSD_PR2_u213_exe_g( Variable* v );
	int DINSD_PR3_u214_exe();
	friend int DINSD_PR3_u214_exe_g( Variable* v );
	int DINSF_AVAIL_u215_exe();
	friend int DINSF_AVAIL_u215_exe_g( Variable* v );
	int DINSF_CONC_u216_exe();
	friend int DINSF_CONC_u216_exe_g( Variable* v );
	int DINSF_PR1_u217_exe();
	friend int DINSF_PR1_u217_exe_g( Variable* v );
	int DINSF_PR2_u218_exe();
	friend int DINSF_PR2_u218_exe_g( Variable* v );
	int DIN_ATMOS_LOAD_u219_exe();
	friend int DIN_ATMOS_LOAD_u219_exe_g( Variable* v );
	int DIN_AVAILABLE_u220_exe();
	friend int DIN_AVAILABLE_u220_exe_g( Variable* v );
	int DOM_TO_DIN_u221_exe();
	friend int DOM_TO_DIN_u221_exe_g( Variable* v );
	int N_NPOINTSD_u222_exe();
	friend int N_NPOINTSD_u222_exe_g( Variable* v );
	int OUTPUTCOL_u223_exe();
	friend int OUTPUTCOL_u223_exe_g( Variable* v );
	int OUTPUTROW_u224_exe();
	friend int OUTPUTROW_u224_exe_g( Variable* v );
	int OUTPUTVAR_u225_exe();
	friend int OUTPUTVAR_u225_exe_g( Variable* v );
	int OUTPUTVAR_v432_exe();
	friend int OUTPUTVAR_v432_exe_g( Variable* v );
	int SR_WATER_u226_exe();
	friend int SR_WATER_u226_exe_g( Variable* v );
	int ZONMAP_u227_exe();
	friend int ZONMAP_u227_exe_g( Variable* v );
	int P1_BOCOEF_u228_exe();
	friend int P1_BOCOEF_u228_exe_g( Variable* v );
	int P1_DINSD_OUT_u229_exe();
	friend int P1_DINSD_OUT_u229_exe_g( Variable* v );
	int P1_DINSF_OUT_u230_exe();
	friend int P1_DINSF_OUT_u230_exe_g( Variable* v );
	int P1_DIN_CR_SED_MIN_u231_exe();
	friend int P1_DIN_CR_SED_MIN_u231_exe_g( Variable* v );
	int P1_DIN_DAY_FERT1_u232_exe();
	friend int P1_DIN_DAY_FERT1_u232_exe_g( Variable* v );
	int P1_DIN_DAY_FERT2_u233_exe();
	friend int P1_DIN_DAY_FERT2_u233_exe_g( Variable* v );
	int P1_DIN_DIFFCOEF_u234_exe();
	friend int P1_DIN_DIFFCOEF_u234_exe_g( Variable* v );
	int P1_DIN_FERT_APP_u235_exe();
	friend int P1_DIN_FERT_APP_u235_exe_g( Variable* v );
	int P1_DIN_FERT_DIS_u236_exe();
	friend int P1_DIN_FERT_DIS_u236_exe_g( Variable* v );
	int P1_DIN_FERT_HAB1_u237_exe();
	friend int P1_DIN_FERT_HAB1_u237_exe_g( Variable* v );
	int P1_DIN_FERT_HAB2_u238_exe();
	friend int P1_DIN_FERT_HAB2_u238_exe_g( Variable* v );
	int P1_DIN_GRAD_u239_exe();
	friend int P1_DIN_GRAD_u239_exe_g( Variable* v );
	int P1_DIN_ICSED_u240_exe();
	friend int P1_DIN_ICSED_u240_exe_g( Variable* v );
	int P1_DIN_ICSF_u241_exe();
	friend int P1_DIN_ICSF_u241_exe_g( Variable* v );
	int P1_DIN_K_OF_NH4_u242_exe();
	friend int P1_DIN_K_OF_NH4_u242_exe_g( Variable* v );
	int P1_DIN_RCDENIT_u243_exe();
	friend int P1_DIN_RCDENIT_u243_exe_g( Variable* v );
	int P1_DOMSD_ANAEROB_Z_u244_exe();
	friend int P1_DOMSD_ANAEROB_Z_u244_exe_g( Variable* v );
	int P1_DOM_CTOOM_u245_exe();
	friend int P1_DOM_CTOOM_u245_exe_g( Variable* v );
	int P1_DOM_NC_u246_exe();
	friend int P1_DOM_NC_u246_exe_g( Variable* v );
	int P1_D_DEP_FACTOR_u247_exe();
	friend int P1_D_DEP_FACTOR_u247_exe_g( Variable* v );
	int P1_NPOINTNSF_u248_exe();
	friend int P1_NPOINTNSF_u248_exe_g( Variable* v );
	int P1_PHBIO_NC_u249_exe();
	friend int P1_PHBIO_NC_u249_exe_g( Variable* v );
	int P1_PHBIO_NC_SF_u250_exe();
	friend int P1_PHBIO_NC_SF_u250_exe_g( Variable* v );
	int P1_POINTNSF_u251_exe();
	friend int P1_POINTNSF_u251_exe_g( Variable* v );
	int P1_POP_DENS_u252_exe();
	friend int P1_POP_DENS_u252_exe_g( Variable* v );
	int P1_POP_DENS_v433_exe();
	friend int P1_POP_DENS_v433_exe_g( Variable* v );
	int P1_R_SUB_u253_exe();
	friend int P1_R_SUB_u253_exe_g( Variable* v );
	int P1_SEPTICLOAD_u254_exe();
	friend int P1_SEPTICLOAD_u254_exe_g( Variable* v );
	int P1_SEPTIC_RED_u255_exe();
	friend int P1_SEPTIC_RED_u255_exe_g( Variable* v );
	int P1_SEWERMAP_u256_exe();
	friend int P1_SEWERMAP_u256_exe_g( Variable* v );
	int DIN_IN_RAIN_u257_exe();
	friend int DIN_IN_RAIN_u257_exe_g( Variable* v );
	static ZDIN_module* fInstance;
	static ZDIN_module* kNullModel;
public:
	inline static ZDIN_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new ZDIN_module("ZDIN_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (ZDIN_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}

	inline double Graph29(double x) { 
		static double g[53][2] = {
			{ 0.0000E+00, 5.680000E-01},{ 7.0200E+00, 1.150000E+00},{ 1.4000E+01, 1.110000E-01},{ 2.1100E+01, 1.520000E-01},
			{ 2.8100E+01, 9.600000E-01},{ 3.5100E+01, 3.540000E-01},{ 4.2100E+01, 2.640000E-01},{ 4.9100E+01, 5.520000E-02},
			{ 5.6200E+01, 3.110000E-01},{ 6.3200E+01, 5.440000E-03},{ 7.0200E+01, 3.100000E-01},{ 7.7200E+01, 9.020000E-01},
			{ 8.4200E+01, 3.170000E-01},{ 9.1200E+01, 1.060000E+00},{ 9.8300E+01, 5.800000E-01},{ 1.0500E+02, 2.510000E-01},
			{ 1.1200E+02, 2.610000E-01},{ 1.1900E+02, 6.600000E-01},{ 1.2600E+02, 6.150000E-01},{ 1.3300E+02, 3.970000E-01},
			{ 1.4000E+02, 2.370000E-01},{ 1.4700E+02, 1.410000E+00},{ 1.5400E+02, 6.570000E-02},{ 1.6100E+02, 3.140000E-01},
			{ 1.6800E+02, 4.400000E-01},{ 1.7500E+02, 2.840000E-01},{ 1.8300E+02, 1.050000E-01},{ 1.9000E+02, 6.970000E-02},
			{ 1.9700E+02, 2.700000E+00},{ 2.0400E+02, 5.980000E-01},{ 2.1100E+02, 3.760000E-03},{ 2.1800E+02, 6.460000E-01},
			{ 2.2500E+02, 5.140000E-01},{ 2.3200E+02, 5.410000E-01},{ 2.3900E+02, 5.090000E-01},{ 2.4600E+02, 7.310000E-02},
			{ 2.5300E+02, 9.000000E-03},{ 2.6000E+02, 3.970000E-01},{ 2.6700E+02, 5.300000E-01},{ 2.7400E+02, 8.280000E-02},
			{ 2.8100E+02, 5.120000E-01},{ 2.8800E+02, 2.950000E-01},{ 2.9500E+02, 4.210000E-01},{ 3.0200E+02, 1.240000E-01},
			{ 3.0900E+02, 1.160000E-01},{ 3.1600E+02, 2.080000E-01},{ 3.2300E+02, 9.120000E-02},{ 3.3000E+02, 1.100000E-01},
			{ 3.3700E+02, 8.200000E-01},{ 3.4400E+02, 0.000000E+00},{ 3.5100E+02, 2.080000E-01},{ 3.5800E+02, 6.010000E-01},
			{ 3.6500E+02, 6.010000E-01}, };
		return SL::Graph( 0, x, 52, g); 
	}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int A_IN_I177_exe_g(Variable* obj) { return ZDIN_module::I().A_IN_I177_exe(); }
int A_IN_i178_exe_g(Variable* obj) { return ZDIN_module::I().A_IN_i178_exe(); }
int ATM_FLOW_u179_exe_g(Variable* obj) { return ZDIN_module::I().ATM_FLOW_u179_exe(); }
int DIN_FERT_AV_I180_exe_g(Variable* obj) { return ZDIN_module::I().DIN_FERT_AV_I180_exe(); }
int DIN_FERT_AV_i181_exe_g(Variable* obj) { return ZDIN_module::I().DIN_FERT_AV_i181_exe(); }
int DIN_FERT_u182_exe_g(Variable* obj) { return ZDIN_module::I().DIN_FERT_u182_exe(); }
int FERT_AV_u183_exe_g(Variable* obj) { return ZDIN_module::I().FERT_AV_u183_exe(); }
int DIN_SD_I184_exe_g(Variable* obj) { return ZDIN_module::I().DIN_SD_I184_exe(); }
int DIN_SD_i185_exe_g(Variable* obj) { return ZDIN_module::I().DIN_SD_i185_exe(); }
int DIN_DNFLOW_u186_exe_g(Variable* obj) { return ZDIN_module::I().DIN_DNFLOW_u186_exe(); }
int DINSD_LOAD_u187_exe_g(Variable* obj) { return ZDIN_module::I().DINSD_LOAD_u187_exe(); }
int DOM_TO_DINSD_u188_exe_g(Variable* obj) { return ZDIN_module::I().DOM_TO_DINSD_u188_exe(); }
int DINSD_DENIT_u189_exe_g(Variable* obj) { return ZDIN_module::I().DINSD_DENIT_u189_exe(); }
int DIN_UPFLOW_u190_exe_g(Variable* obj) { return ZDIN_module::I().DIN_UPFLOW_u190_exe(); }
int DINSD_UPTAKE_u191_exe_g(Variable* obj) { return ZDIN_module::I().DINSD_UPTAKE_u191_exe(); }
int DINSD_HOUT_u192_exe_g(Variable* obj) { return ZDIN_module::I().DINSD_HOUT_u192_exe(); }
int DIN_SF_I193_exe_g(Variable* obj) { return ZDIN_module::I().DIN_SF_I193_exe(); }
int DIN_SF_i194_exe_g(Variable* obj) { return ZDIN_module::I().DIN_SF_i194_exe(); }
int DINSF_ATM_u195_exe_g(Variable* obj) { return ZDIN_module::I().DINSF_ATM_u195_exe(); }
int DOM_TO_DINSF_u196_exe_g(Variable* obj) { return ZDIN_module::I().DOM_TO_DINSF_u196_exe(); }
int DINSF_UPTAKE_u197_exe_g(Variable* obj) { return ZDIN_module::I().DINSF_UPTAKE_u197_exe(); }
int DINSF_OUT_u198_exe_g(Variable* obj) { return ZDIN_module::I().DINSF_OUT_u198_exe(); }
int F_IN_I199_exe_g(Variable* obj) { return ZDIN_module::I().F_IN_I199_exe(); }
int F_IN_i200_exe_g(Variable* obj) { return ZDIN_module::I().F_IN_i200_exe(); }
int FERT_FLOW_u201_exe_g(Variable* obj) { return ZDIN_module::I().FERT_FLOW_u201_exe(); }
int M_IN_I202_exe_g(Variable* obj) { return ZDIN_module::I().M_IN_I202_exe(); }
int M_IN_i203_exe_g(Variable* obj) { return ZDIN_module::I().M_IN_i203_exe(); }
int MINER_FLOW_u204_exe_g(Variable* obj) { return ZDIN_module::I().MINER_FLOW_u204_exe(); }
int S_IN_I205_exe_g(Variable* obj) { return ZDIN_module::I().S_IN_I205_exe(); }
int S_IN_i206_exe_g(Variable* obj) { return ZDIN_module::I().S_IN_i206_exe(); }
int SEPTIC_FLOW_u207_exe_g(Variable* obj) { return ZDIN_module::I().SEPTIC_FLOW_u207_exe(); }
int COUNTY_u208_exe_g(Variable* obj) { return ZDIN_module::I().COUNTY_u208_exe(); }
int CROP_u209_exe_g(Variable* obj) { return ZDIN_module::I().CROP_u209_exe(); }
int DINSD_AVAIL_u210_exe_g(Variable* obj) { return ZDIN_module::I().DINSD_AVAIL_u210_exe(); }
int DINSD_CONC_u211_exe_g(Variable* obj) { return ZDIN_module::I().DINSD_CONC_u211_exe(); }
int DINSD_PR1_u212_exe_g(Variable* obj) { return ZDIN_module::I().DINSD_PR1_u212_exe(); }
int DINSD_PR2_u213_exe_g(Variable* obj) { return ZDIN_module::I().DINSD_PR2_u213_exe(); }
int DINSD_PR3_u214_exe_g(Variable* obj) { return ZDIN_module::I().DINSD_PR3_u214_exe(); }
int DINSF_AVAIL_u215_exe_g(Variable* obj) { return ZDIN_module::I().DINSF_AVAIL_u215_exe(); }
int DINSF_CONC_u216_exe_g(Variable* obj) { return ZDIN_module::I().DINSF_CONC_u216_exe(); }
int DINSF_PR1_u217_exe_g(Variable* obj) { return ZDIN_module::I().DINSF_PR1_u217_exe(); }
int DINSF_PR2_u218_exe_g(Variable* obj) { return ZDIN_module::I().DINSF_PR2_u218_exe(); }
int DIN_ATMOS_LOAD_u219_exe_g(Variable* obj) { return ZDIN_module::I().DIN_ATMOS_LOAD_u219_exe(); }
int DIN_AVAILABLE_u220_exe_g(Variable* obj) { return ZDIN_module::I().DIN_AVAILABLE_u220_exe(); }
int DOM_TO_DIN_u221_exe_g(Variable* obj) { return ZDIN_module::I().DOM_TO_DIN_u221_exe(); }
int N_NPOINTSD_u222_exe_g(Variable* obj) { return ZDIN_module::I().N_NPOINTSD_u222_exe(); }
int OUTPUTCOL_u223_exe_g(Variable* obj) { return ZDIN_module::I().OUTPUTCOL_u223_exe(); }
int OUTPUTROW_u224_exe_g(Variable* obj) { return ZDIN_module::I().OUTPUTROW_u224_exe(); }
int OUTPUTVAR_u225_exe_g(Variable* obj) { return ZDIN_module::I().OUTPUTVAR_u225_exe(); }
int OUTPUTVAR_v432_exe_g(Variable* obj) { return ZDIN_module::I().OUTPUTVAR_v432_exe(); }
int SR_WATER_u226_exe_g(Variable* obj) { return ZDIN_module::I().SR_WATER_u226_exe(); }
int ZONMAP_u227_exe_g(Variable* obj) { return ZDIN_module::I().ZONMAP_u227_exe(); }
int P1_BOCOEF_u228_exe_g(Variable* obj) { return ZDIN_module::I().P1_BOCOEF_u228_exe(); }
int P1_DINSD_OUT_u229_exe_g(Variable* obj) { return ZDIN_module::I().P1_DINSD_OUT_u229_exe(); }
int P1_DINSF_OUT_u230_exe_g(Variable* obj) { return ZDIN_module::I().P1_DINSF_OUT_u230_exe(); }
int P1_DIN_CR_SED_MIN_u231_exe_g(Variable* obj) { return ZDIN_module::I().P1_DIN_CR_SED_MIN_u231_exe(); }
int P1_DIN_DAY_FERT1_u232_exe_g(Variable* obj) { return ZDIN_module::I().P1_DIN_DAY_FERT1_u232_exe(); }
int P1_DIN_DAY_FERT2_u233_exe_g(Variable* obj) { return ZDIN_module::I().P1_DIN_DAY_FERT2_u233_exe(); }
int P1_DIN_DIFFCOEF_u234_exe_g(Variable* obj) { return ZDIN_module::I().P1_DIN_DIFFCOEF_u234_exe(); }
int P1_DIN_FERT_APP_u235_exe_g(Variable* obj) { return ZDIN_module::I().P1_DIN_FERT_APP_u235_exe(); }
int P1_DIN_FERT_DIS_u236_exe_g(Variable* obj) { return ZDIN_module::I().P1_DIN_FERT_DIS_u236_exe(); }
int P1_DIN_FERT_HAB1_u237_exe_g(Variable* obj) { return ZDIN_module::I().P1_DIN_FERT_HAB1_u237_exe(); }
int P1_DIN_FERT_HAB2_u238_exe_g(Variable* obj) { return ZDIN_module::I().P1_DIN_FERT_HAB2_u238_exe(); }
int P1_DIN_GRAD_u239_exe_g(Variable* obj) { return ZDIN_module::I().P1_DIN_GRAD_u239_exe(); }
int P1_DIN_ICSED_u240_exe_g(Variable* obj) { return ZDIN_module::I().P1_DIN_ICSED_u240_exe(); }
int P1_DIN_ICSF_u241_exe_g(Variable* obj) { return ZDIN_module::I().P1_DIN_ICSF_u241_exe(); }
int P1_DIN_K_OF_NH4_u242_exe_g(Variable* obj) { return ZDIN_module::I().P1_DIN_K_OF_NH4_u242_exe(); }
int P1_DIN_RCDENIT_u243_exe_g(Variable* obj) { return ZDIN_module::I().P1_DIN_RCDENIT_u243_exe(); }
int P1_DOMSD_ANAEROB_Z_u244_exe_g(Variable* obj) { return ZDIN_module::I().P1_DOMSD_ANAEROB_Z_u244_exe(); }
int P1_DOM_CTOOM_u245_exe_g(Variable* obj) { return ZDIN_module::I().P1_DOM_CTOOM_u245_exe(); }
int P1_DOM_NC_u246_exe_g(Variable* obj) { return ZDIN_module::I().P1_DOM_NC_u246_exe(); }
int P1_D_DEP_FACTOR_u247_exe_g(Variable* obj) { return ZDIN_module::I().P1_D_DEP_FACTOR_u247_exe(); }
int P1_NPOINTNSF_u248_exe_g(Variable* obj) { return ZDIN_module::I().P1_NPOINTNSF_u248_exe(); }
int P1_PHBIO_NC_u249_exe_g(Variable* obj) { return ZDIN_module::I().P1_PHBIO_NC_u249_exe(); }
int P1_PHBIO_NC_SF_u250_exe_g(Variable* obj) { return ZDIN_module::I().P1_PHBIO_NC_SF_u250_exe(); }
int P1_POINTNSF_u251_exe_g(Variable* obj) { return ZDIN_module::I().P1_POINTNSF_u251_exe(); }
int P1_POP_DENS_u252_exe_g(Variable* obj) { return ZDIN_module::I().P1_POP_DENS_u252_exe(); }
int P1_POP_DENS_v433_exe_g(Variable* obj) { return ZDIN_module::I().P1_POP_DENS_v433_exe(); }
int P1_R_SUB_u253_exe_g(Variable* obj) { return ZDIN_module::I().P1_R_SUB_u253_exe(); }
int P1_SEPTICLOAD_u254_exe_g(Variable* obj) { return ZDIN_module::I().P1_SEPTICLOAD_u254_exe(); }
int P1_SEPTIC_RED_u255_exe_g(Variable* obj) { return ZDIN_module::I().P1_SEPTIC_RED_u255_exe(); }
int P1_SEWERMAP_u256_exe_g(Variable* obj) { return ZDIN_module::I().P1_SEWERMAP_u256_exe(); }
int DIN_IN_RAIN_u257_exe_g(Variable* obj) { return ZDIN_module::I().DIN_IN_RAIN_u257_exe(); }
// ---------------------------------------------------------------------------
//                    Class HYDROLOGY_module 
// ---------------------------------------------------------------------------

class HYDROLOGY_module : public TModule {
protected:

	HYDROLOGY_module(char* name);

public:

	TTime TIME;
	CStateVariable SURFACE_WATER;
	CAuxVariable UW_DEPTH;
	CAuxVariable WATER_AVAIL;
	CStateVariable SAT_WATER;
	CStateVariable UNSAT_WATER;
	CFluxVariable UW_FROM_PRECIP;
	CFluxVariable SW_TO_SATW_DOWNFLOW;
	CFluxVariable SATW_FROM_PRECIP;
	CFluxVariable SATW_TO_SW_UPFLOW;
	CFluxVariable SATW_OUTFLUX;
	CFluxVariable SW_OUTFLUX;
	CFluxVariable SATW_TRANSP;
	CFluxVariable UW_ETRANSP;
	CAuxVariable ON_MAP;
	CStateVariable DIN_SD;
	CAuxVariable HABITATMAP;
	CAuxVariable AIR_TEMP_C;
	CAuxVariable PRECIP_M;
	CAuxVariable HYDRO;
	CAuxVariable ELEVATION;
	CStateVariable DIN_SF;
	CAuxVariable SOLRADGRD;
	CAuxVariable MACLAI;
	CAuxVariable CELL_SIZE;
	CAuxVariable SOIL;
	CAuxVariable HUMIDITY;
	CAuxVariable WIND;
	CStateVariable A_IN;
	CAuxVariable ELEV_MIN;
	CAuxVariable ETPM;
	CAuxVariable ROOT_DEPTH;
	CAuxVariable P1_DATUM_TO_MSL;
	CFluxVariable UW_SATW_EXCHANGE;
	CFluxVariable SATW_RECHARGE;
	CFluxVariable SATW_UW;
	CStateVariable SNOW_ICE;
	CFluxVariable SNOWFALL;
	CFluxVariable SW_FREEZE;
	CFluxVariable SNOWMELT;
	CFluxVariable SW_FROM_PRECIP;
	CFluxVariable SW_EVAP;
	CStateVariable TOT_IN;
	CFluxVariable TOTAL_INFLOW;
	CStateVariable TOT_OUT;
	CFluxVariable TOTAL_OUTFLOW;
	CAuxVariable BALANCE;
	CAuxVariable EVAPORATION;
	CAuxVariable EVAP_UW;
	CAuxVariable H_CONDUCT;
	CAuxVariable IC_SATW;
	CAuxVariable IC_UW;
	CAuxVariable INFILTRATION;
	CAuxVariable INF_COND;
	CAuxVariable INTERCEPT;
	CAuxVariable NET_PRECIP;
	CAuxVariable OUT_F_SD;
	CAuxVariable OUT_F_SF;
	CAuxVariable PAN_CH;
	CAuxVariable PAN_CT;
	CAuxVariable PAN_CW;
	CAuxVariable POROSITY;
	CAuxVariable POT_INFILTR;
	CAuxVariable RAINFALL;
	CAuxVariable SATWMAX;
	CAuxVariable SATWRUNOFF;
	CAuxVariable SATW_HEAD;
	CAuxVariable TOTAL_OUT;
	CAuxVariable TOTAL_PRECIP;
	CAuxVariable TRANSPIRATION;
	CAuxVariable UNSAT_CAP;
	CAuxVariable UW_CAPIL_EXP;
	CAuxVariable UW_DELTA;
	CAuxVariable UW_DEPTH_BEFORE;
	CAuxVariable UW_EXCESS;
	CAuxVariable UW_MOIST_PRP;
	CAuxVariable UW_MP_R;
	CAuxVariable UW_PERC_RATE;
	CAuxVariable UW_TRANS_PR;
	CAuxVariable WAT_TABLE;
	CAuxVariable P1_C_EVAP;
	CAuxVariable P1_C_FIELD_CAP;
	CAuxVariable P1_C_HORIZ_HYDR_COND;
	CAuxVariable P1_C_INFILT;
	CAuxVariable P1_C_INF_HAB;
	CAuxVariable P1_C_INF_SLOPE;
	CAuxVariable P1_C_INF_SOIL;
	CAuxVariable P1_C_INTERCEP;
	CAuxVariable P1_C_INTERCEPVEG;
	CAuxVariable P1_C_POROSITY;
	CAuxVariable P1_C_RECHG;
	CAuxVariable P1_C_SATW_OUT;
	CAuxVariable P1_C_SW_MELT;
	CAuxVariable P1_C_SW_OUT;
	CAuxVariable P1_C_TRANSP;
	CAuxVariable P1_C_UW_EVAP;
	CAuxVariable P1_C_VERT_HYDR_COND;
	CAuxVariable P1_C_ZIG;
	CAuxVariable P1_IC_SW_DEPTH;
	CAuxVariable P1_IC_UW_MOIST_PR;
	CAuxVariable P1_IC_WT_TABLE;
protected:

	int SAT_WATER_I281_exe();
	friend int SAT_WATER_I281_exe_g( Variable* v );
	int SAT_WATER_i282_exe();
	friend int SAT_WATER_i282_exe_g( Variable* v );
	int SAT_WATER_vE434_exe();
	friend int SAT_WATER_vE434_exe_g( Variable* v );
	int UW_SATW_EXCHANGE_u283_exe();
	friend int UW_SATW_EXCHANGE_u283_exe_g( Variable* v );
	int SW_TO_SATW_DOWNFLOW_u284_exe();
	friend int SW_TO_SATW_DOWNFLOW_u284_exe_g( Variable* v );
	int SATW_FROM_PRECIP_u285_exe();
	friend int SATW_FROM_PRECIP_u285_exe_g( Variable* v );
	int SATW_RECHARGE_u286_exe();
	friend int SATW_RECHARGE_u286_exe_g( Variable* v );
	int SATW_TRANSP_u287_exe();
	friend int SATW_TRANSP_u287_exe_g( Variable* v );
	int SATW_TO_SW_UPFLOW_u288_exe();
	friend int SATW_TO_SW_UPFLOW_u288_exe_g( Variable* v );
	int SATW_OUTFLUX_u289_exe();
	friend int SATW_OUTFLUX_u289_exe_g( Variable* v );
	int SATW_UW_u290_exe();
	friend int SATW_UW_u290_exe_g( Variable* v );
	int SNOW_ICE_I291_exe();
	friend int SNOW_ICE_I291_exe_g( Variable* v );
	int SNOW_ICE_i292_exe();
	friend int SNOW_ICE_i292_exe_g( Variable* v );
	int SNOWFALL_u293_exe();
	friend int SNOWFALL_u293_exe_g( Variable* v );
	int SW_FREEZE_u294_exe();
	friend int SW_FREEZE_u294_exe_g( Variable* v );
	int SNOWMELT_u295_exe();
	friend int SNOWMELT_u295_exe_g( Variable* v );
	int SURFACE_WATER_I296_exe();
	friend int SURFACE_WATER_I296_exe_g( Variable* v );
	int SURFACE_WATER_i297_exe();
	friend int SURFACE_WATER_i297_exe_g( Variable* v );
	int SURFACE_WATER_vE435_exe();
	friend int SURFACE_WATER_vE435_exe_g( Variable* v );
	int SW_FROM_PRECIP_u298_exe();
	friend int SW_FROM_PRECIP_u298_exe_g( Variable* v );
	int SW_EVAP_u299_exe();
	friend int SW_EVAP_u299_exe_g( Variable* v );
	int SW_OUTFLUX_u300_exe();
	friend int SW_OUTFLUX_u300_exe_g( Variable* v );
	int TOT_IN_I301_exe();
	friend int TOT_IN_I301_exe_g( Variable* v );
	int TOT_IN_i302_exe();
	friend int TOT_IN_i302_exe_g( Variable* v );
	int TOTAL_INFLOW_u303_exe();
	friend int TOTAL_INFLOW_u303_exe_g( Variable* v );
	int TOT_OUT_I304_exe();
	friend int TOT_OUT_I304_exe_g( Variable* v );
	int TOT_OUT_i305_exe();
	friend int TOT_OUT_i305_exe_g( Variable* v );
	int TOTAL_OUTFLOW_u306_exe();
	friend int TOTAL_OUTFLOW_u306_exe_g( Variable* v );
	int UNSAT_WATER_I307_exe();
	friend int UNSAT_WATER_I307_exe_g( Variable* v );
	int UNSAT_WATER_i308_exe();
	friend int UNSAT_WATER_i308_exe_g( Variable* v );
	int UW_FROM_PRECIP_u309_exe();
	friend int UW_FROM_PRECIP_u309_exe_g( Variable* v );
	int UW_ETRANSP_u310_exe();
	friend int UW_ETRANSP_u310_exe_g( Variable* v );
	int BALANCE_u311_exe();
	friend int BALANCE_u311_exe_g( Variable* v );
	int EVAPORATION_u312_exe();
	friend int EVAPORATION_u312_exe_g( Variable* v );
	int EVAP_UW_u313_exe();
	friend int EVAP_UW_u313_exe_g( Variable* v );
	int H_CONDUCT_u314_exe();
	friend int H_CONDUCT_u314_exe_g( Variable* v );
	int IC_SATW_u315_exe();
	friend int IC_SATW_u315_exe_g( Variable* v );
	int IC_UW_u316_exe();
	friend int IC_UW_u316_exe_g( Variable* v );
	int INFILTRATION_u317_exe();
	friend int INFILTRATION_u317_exe_g( Variable* v );
	int INF_COND_u318_exe();
	friend int INF_COND_u318_exe_g( Variable* v );
	int INTERCEPT_u319_exe();
	friend int INTERCEPT_u319_exe_g( Variable* v );
	int NET_PRECIP_u320_exe();
	friend int NET_PRECIP_u320_exe_g( Variable* v );
	int OUT_F_SD_u321_exe();
	friend int OUT_F_SD_u321_exe_g( Variable* v );
	int OUT_F_SF_u322_exe();
	friend int OUT_F_SF_u322_exe_g( Variable* v );
	int PAN_CH_u323_exe();
	friend int PAN_CH_u323_exe_g( Variable* v );
	int PAN_CT_u324_exe();
	friend int PAN_CT_u324_exe_g( Variable* v );
	int PAN_CW_u325_exe();
	friend int PAN_CW_u325_exe_g( Variable* v );
	int POROSITY_u326_exe();
	friend int POROSITY_u326_exe_g( Variable* v );
	int POT_INFILTR_u327_exe();
	friend int POT_INFILTR_u327_exe_g( Variable* v );
	int POT_INFILTR_v436_exe();
	friend int POT_INFILTR_v436_exe_g( Variable* v );
	int RAINFALL_u328_exe();
	friend int RAINFALL_u328_exe_g( Variable* v );
	int SATWMAX_u329_exe();
	friend int SATWMAX_u329_exe_g( Variable* v );
	int SATWRUNOFF_u330_exe();
	friend int SATWRUNOFF_u330_exe_g( Variable* v );
	int SATW_HEAD_u331_exe();
	friend int SATW_HEAD_u331_exe_g( Variable* v );
	int TOTAL_OUT_u332_exe();
	friend int TOTAL_OUT_u332_exe_g( Variable* v );
	int TOTAL_PRECIP_u333_exe();
	friend int TOTAL_PRECIP_u333_exe_g( Variable* v );
	int TRANSPIRATION_u334_exe();
	friend int TRANSPIRATION_u334_exe_g( Variable* v );
	int UNSAT_CAP_u335_exe();
	friend int UNSAT_CAP_u335_exe_g( Variable* v );
	int UW_CAPIL_EXP_u336_exe();
	friend int UW_CAPIL_EXP_u336_exe_g( Variable* v );
	int UW_DELTA_u337_exe();
	friend int UW_DELTA_u337_exe_g( Variable* v );
	int UW_DEPTH_u338_exe();
	friend int UW_DEPTH_u338_exe_g( Variable* v );
	int UW_DEPTH_BEFORE_u339_exe();
	friend int UW_DEPTH_BEFORE_u339_exe_g( Variable* v );
	int UW_EXCESS_u340_exe();
	friend int UW_EXCESS_u340_exe_g( Variable* v );
	int UW_MOIST_PRP_u341_exe();
	friend int UW_MOIST_PRP_u341_exe_g( Variable* v );
	int UW_MP_R_u342_exe();
	friend int UW_MP_R_u342_exe_g( Variable* v );
	int UW_PERC_RATE_u343_exe();
	friend int UW_PERC_RATE_u343_exe_g( Variable* v );
	int UW_TRANS_PR_u344_exe();
	friend int UW_TRANS_PR_u344_exe_g( Variable* v );
	int WATER_AVAIL_u345_exe();
	friend int WATER_AVAIL_u345_exe_g( Variable* v );
	int WAT_TABLE_u346_exe();
	friend int WAT_TABLE_u346_exe_g( Variable* v );
	int P1_C_EVAP_u347_exe();
	friend int P1_C_EVAP_u347_exe_g( Variable* v );
	int P1_C_FIELD_CAP_u348_exe();
	friend int P1_C_FIELD_CAP_u348_exe_g( Variable* v );
	int P1_C_HORIZ_HYDR_COND_u349_exe();
	friend int P1_C_HORIZ_HYDR_COND_u349_exe_g( Variable* v );
	int P1_C_INFILT_u350_exe();
	friend int P1_C_INFILT_u350_exe_g( Variable* v );
	int P1_C_INF_HAB_u351_exe();
	friend int P1_C_INF_HAB_u351_exe_g( Variable* v );
	int P1_C_INF_SLOPE_u352_exe();
	friend int P1_C_INF_SLOPE_u352_exe_g( Variable* v );
	int P1_C_INF_SOIL_u353_exe();
	friend int P1_C_INF_SOIL_u353_exe_g( Variable* v );
	int P1_C_INTERCEP_u354_exe();
	friend int P1_C_INTERCEP_u354_exe_g( Variable* v );
	int P1_C_INTERCEPVEG_u355_exe();
	friend int P1_C_INTERCEPVEG_u355_exe_g( Variable* v );
	int P1_C_POROSITY_u356_exe();
	friend int P1_C_POROSITY_u356_exe_g( Variable* v );
	int P1_C_RECHG_u357_exe();
	friend int P1_C_RECHG_u357_exe_g( Variable* v );
	int P1_C_SATW_OUT_u358_exe();
	friend int P1_C_SATW_OUT_u358_exe_g( Variable* v );
	int P1_C_SW_MELT_u359_exe();
	friend int P1_C_SW_MELT_u359_exe_g( Variable* v );
	int P1_C_SW_OUT_u360_exe();
	friend int P1_C_SW_OUT_u360_exe_g( Variable* v );
	int P1_C_TRANSP_u361_exe();
	friend int P1_C_TRANSP_u361_exe_g( Variable* v );
	int P1_C_UW_EVAP_u362_exe();
	friend int P1_C_UW_EVAP_u362_exe_g( Variable* v );
	int P1_C_VERT_HYDR_COND_u363_exe();
	friend int P1_C_VERT_HYDR_COND_u363_exe_g( Variable* v );
	int P1_C_ZIG_u364_exe();
	friend int P1_C_ZIG_u364_exe_g( Variable* v );
	int P1_IC_SW_DEPTH_u365_exe();
	friend int P1_IC_SW_DEPTH_u365_exe_g( Variable* v );
	int P1_IC_UW_MOIST_PR_u366_exe();
	friend int P1_IC_UW_MOIST_PR_u366_exe_g( Variable* v );
	int P1_IC_WT_TABLE_u367_exe();
	friend int P1_IC_WT_TABLE_u367_exe_g( Variable* v );
	static HYDROLOGY_module* fInstance;
	static HYDROLOGY_module* kNullModel;
public:
	inline static HYDROLOGY_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new HYDROLOGY_module("HYDROLOGY_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (HYDROLOGY_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int SAT_WATER_I281_exe_g(Variable* obj) { return HYDROLOGY_module::I().SAT_WATER_I281_exe(); }
int SAT_WATER_i282_exe_g(Variable* obj) { return HYDROLOGY_module::I().SAT_WATER_i282_exe(); }
int SAT_WATER_vE434_exe_g(Variable* obj) { return HYDROLOGY_module::I().SAT_WATER_vE434_exe(); }
int UW_SATW_EXCHANGE_u283_exe_g(Variable* obj) { return HYDROLOGY_module::I().UW_SATW_EXCHANGE_u283_exe(); }
int SW_TO_SATW_DOWNFLOW_u284_exe_g(Variable* obj) { return HYDROLOGY_module::I().SW_TO_SATW_DOWNFLOW_u284_exe(); }
int SATW_FROM_PRECIP_u285_exe_g(Variable* obj) { return HYDROLOGY_module::I().SATW_FROM_PRECIP_u285_exe(); }
int SATW_RECHARGE_u286_exe_g(Variable* obj) { return HYDROLOGY_module::I().SATW_RECHARGE_u286_exe(); }
int SATW_TRANSP_u287_exe_g(Variable* obj) { return HYDROLOGY_module::I().SATW_TRANSP_u287_exe(); }
int SATW_TO_SW_UPFLOW_u288_exe_g(Variable* obj) { return HYDROLOGY_module::I().SATW_TO_SW_UPFLOW_u288_exe(); }
int SATW_OUTFLUX_u289_exe_g(Variable* obj) { return HYDROLOGY_module::I().SATW_OUTFLUX_u289_exe(); }
int SATW_UW_u290_exe_g(Variable* obj) { return HYDROLOGY_module::I().SATW_UW_u290_exe(); }
int SNOW_ICE_I291_exe_g(Variable* obj) { return HYDROLOGY_module::I().SNOW_ICE_I291_exe(); }
int SNOW_ICE_i292_exe_g(Variable* obj) { return HYDROLOGY_module::I().SNOW_ICE_i292_exe(); }
int SNOWFALL_u293_exe_g(Variable* obj) { return HYDROLOGY_module::I().SNOWFALL_u293_exe(); }
int SW_FREEZE_u294_exe_g(Variable* obj) { return HYDROLOGY_module::I().SW_FREEZE_u294_exe(); }
int SNOWMELT_u295_exe_g(Variable* obj) { return HYDROLOGY_module::I().SNOWMELT_u295_exe(); }
int SURFACE_WATER_I296_exe_g(Variable* obj) { return HYDROLOGY_module::I().SURFACE_WATER_I296_exe(); }
int SURFACE_WATER_i297_exe_g(Variable* obj) { return HYDROLOGY_module::I().SURFACE_WATER_i297_exe(); }
int SURFACE_WATER_vE435_exe_g(Variable* obj) { return HYDROLOGY_module::I().SURFACE_WATER_vE435_exe(); }
int SW_FROM_PRECIP_u298_exe_g(Variable* obj) { return HYDROLOGY_module::I().SW_FROM_PRECIP_u298_exe(); }
int SW_EVAP_u299_exe_g(Variable* obj) { return HYDROLOGY_module::I().SW_EVAP_u299_exe(); }
int SW_OUTFLUX_u300_exe_g(Variable* obj) { return HYDROLOGY_module::I().SW_OUTFLUX_u300_exe(); }
int TOT_IN_I301_exe_g(Variable* obj) { return HYDROLOGY_module::I().TOT_IN_I301_exe(); }
int TOT_IN_i302_exe_g(Variable* obj) { return HYDROLOGY_module::I().TOT_IN_i302_exe(); }
int TOTAL_INFLOW_u303_exe_g(Variable* obj) { return HYDROLOGY_module::I().TOTAL_INFLOW_u303_exe(); }
int TOT_OUT_I304_exe_g(Variable* obj) { return HYDROLOGY_module::I().TOT_OUT_I304_exe(); }
int TOT_OUT_i305_exe_g(Variable* obj) { return HYDROLOGY_module::I().TOT_OUT_i305_exe(); }
int TOTAL_OUTFLOW_u306_exe_g(Variable* obj) { return HYDROLOGY_module::I().TOTAL_OUTFLOW_u306_exe(); }
int UNSAT_WATER_I307_exe_g(Variable* obj) { return HYDROLOGY_module::I().UNSAT_WATER_I307_exe(); }
int UNSAT_WATER_i308_exe_g(Variable* obj) { return HYDROLOGY_module::I().UNSAT_WATER_i308_exe(); }
int UW_FROM_PRECIP_u309_exe_g(Variable* obj) { return HYDROLOGY_module::I().UW_FROM_PRECIP_u309_exe(); }
int UW_ETRANSP_u310_exe_g(Variable* obj) { return HYDROLOGY_module::I().UW_ETRANSP_u310_exe(); }
int BALANCE_u311_exe_g(Variable* obj) { return HYDROLOGY_module::I().BALANCE_u311_exe(); }
int EVAPORATION_u312_exe_g(Variable* obj) { return HYDROLOGY_module::I().EVAPORATION_u312_exe(); }
int EVAP_UW_u313_exe_g(Variable* obj) { return HYDROLOGY_module::I().EVAP_UW_u313_exe(); }
int H_CONDUCT_u314_exe_g(Variable* obj) { return HYDROLOGY_module::I().H_CONDUCT_u314_exe(); }
int IC_SATW_u315_exe_g(Variable* obj) { return HYDROLOGY_module::I().IC_SATW_u315_exe(); }
int IC_UW_u316_exe_g(Variable* obj) { return HYDROLOGY_module::I().IC_UW_u316_exe(); }
int INFILTRATION_u317_exe_g(Variable* obj) { return HYDROLOGY_module::I().INFILTRATION_u317_exe(); }
int INF_COND_u318_exe_g(Variable* obj) { return HYDROLOGY_module::I().INF_COND_u318_exe(); }
int INTERCEPT_u319_exe_g(Variable* obj) { return HYDROLOGY_module::I().INTERCEPT_u319_exe(); }
int NET_PRECIP_u320_exe_g(Variable* obj) { return HYDROLOGY_module::I().NET_PRECIP_u320_exe(); }
int OUT_F_SD_u321_exe_g(Variable* obj) { return HYDROLOGY_module::I().OUT_F_SD_u321_exe(); }
int OUT_F_SF_u322_exe_g(Variable* obj) { return HYDROLOGY_module::I().OUT_F_SF_u322_exe(); }
int PAN_CH_u323_exe_g(Variable* obj) { return HYDROLOGY_module::I().PAN_CH_u323_exe(); }
int PAN_CT_u324_exe_g(Variable* obj) { return HYDROLOGY_module::I().PAN_CT_u324_exe(); }
int PAN_CW_u325_exe_g(Variable* obj) { return HYDROLOGY_module::I().PAN_CW_u325_exe(); }
int POROSITY_u326_exe_g(Variable* obj) { return HYDROLOGY_module::I().POROSITY_u326_exe(); }
int POT_INFILTR_u327_exe_g(Variable* obj) { return HYDROLOGY_module::I().POT_INFILTR_u327_exe(); }
int POT_INFILTR_v436_exe_g(Variable* obj) { return HYDROLOGY_module::I().POT_INFILTR_v436_exe(); }
int RAINFALL_u328_exe_g(Variable* obj) { return HYDROLOGY_module::I().RAINFALL_u328_exe(); }
int SATWMAX_u329_exe_g(Variable* obj) { return HYDROLOGY_module::I().SATWMAX_u329_exe(); }
int SATWRUNOFF_u330_exe_g(Variable* obj) { return HYDROLOGY_module::I().SATWRUNOFF_u330_exe(); }
int SATW_HEAD_u331_exe_g(Variable* obj) { return HYDROLOGY_module::I().SATW_HEAD_u331_exe(); }
int TOTAL_OUT_u332_exe_g(Variable* obj) { return HYDROLOGY_module::I().TOTAL_OUT_u332_exe(); }
int TOTAL_PRECIP_u333_exe_g(Variable* obj) { return HYDROLOGY_module::I().TOTAL_PRECIP_u333_exe(); }
int TRANSPIRATION_u334_exe_g(Variable* obj) { return HYDROLOGY_module::I().TRANSPIRATION_u334_exe(); }
int UNSAT_CAP_u335_exe_g(Variable* obj) { return HYDROLOGY_module::I().UNSAT_CAP_u335_exe(); }
int UW_CAPIL_EXP_u336_exe_g(Variable* obj) { return HYDROLOGY_module::I().UW_CAPIL_EXP_u336_exe(); }
int UW_DELTA_u337_exe_g(Variable* obj) { return HYDROLOGY_module::I().UW_DELTA_u337_exe(); }
int UW_DEPTH_u338_exe_g(Variable* obj) { return HYDROLOGY_module::I().UW_DEPTH_u338_exe(); }
int UW_DEPTH_BEFORE_u339_exe_g(Variable* obj) { return HYDROLOGY_module::I().UW_DEPTH_BEFORE_u339_exe(); }
int UW_EXCESS_u340_exe_g(Variable* obj) { return HYDROLOGY_module::I().UW_EXCESS_u340_exe(); }
int UW_MOIST_PRP_u341_exe_g(Variable* obj) { return HYDROLOGY_module::I().UW_MOIST_PRP_u341_exe(); }
int UW_MP_R_u342_exe_g(Variable* obj) { return HYDROLOGY_module::I().UW_MP_R_u342_exe(); }
int UW_PERC_RATE_u343_exe_g(Variable* obj) { return HYDROLOGY_module::I().UW_PERC_RATE_u343_exe(); }
int UW_TRANS_PR_u344_exe_g(Variable* obj) { return HYDROLOGY_module::I().UW_TRANS_PR_u344_exe(); }
int WATER_AVAIL_u345_exe_g(Variable* obj) { return HYDROLOGY_module::I().WATER_AVAIL_u345_exe(); }
int WAT_TABLE_u346_exe_g(Variable* obj) { return HYDROLOGY_module::I().WAT_TABLE_u346_exe(); }
int P1_C_EVAP_u347_exe_g(Variable* obj) { return HYDROLOGY_module::I().P1_C_EVAP_u347_exe(); }
int P1_C_FIELD_CAP_u348_exe_g(Variable* obj) { return HYDROLOGY_module::I().P1_C_FIELD_CAP_u348_exe(); }
int P1_C_HORIZ_HYDR_COND_u349_exe_g(Variable* obj) { return HYDROLOGY_module::I().P1_C_HORIZ_HYDR_COND_u349_exe(); }
int P1_C_INFILT_u350_exe_g(Variable* obj) { return HYDROLOGY_module::I().P1_C_INFILT_u350_exe(); }
int P1_C_INF_HAB_u351_exe_g(Variable* obj) { return HYDROLOGY_module::I().P1_C_INF_HAB_u351_exe(); }
int P1_C_INF_SLOPE_u352_exe_g(Variable* obj) { return HYDROLOGY_module::I().P1_C_INF_SLOPE_u352_exe(); }
int P1_C_INF_SOIL_u353_exe_g(Variable* obj) { return HYDROLOGY_module::I().P1_C_INF_SOIL_u353_exe(); }
int P1_C_INTERCEP_u354_exe_g(Variable* obj) { return HYDROLOGY_module::I().P1_C_INTERCEP_u354_exe(); }
int P1_C_INTERCEPVEG_u355_exe_g(Variable* obj) { return HYDROLOGY_module::I().P1_C_INTERCEPVEG_u355_exe(); }
int P1_C_POROSITY_u356_exe_g(Variable* obj) { return HYDROLOGY_module::I().P1_C_POROSITY_u356_exe(); }
int P1_C_RECHG_u357_exe_g(Variable* obj) { return HYDROLOGY_module::I().P1_C_RECHG_u357_exe(); }
int P1_C_SATW_OUT_u358_exe_g(Variable* obj) { return HYDROLOGY_module::I().P1_C_SATW_OUT_u358_exe(); }
int P1_C_SW_MELT_u359_exe_g(Variable* obj) { return HYDROLOGY_module::I().P1_C_SW_MELT_u359_exe(); }
int P1_C_SW_OUT_u360_exe_g(Variable* obj) { return HYDROLOGY_module::I().P1_C_SW_OUT_u360_exe(); }
int P1_C_TRANSP_u361_exe_g(Variable* obj) { return HYDROLOGY_module::I().P1_C_TRANSP_u361_exe(); }
int P1_C_UW_EVAP_u362_exe_g(Variable* obj) { return HYDROLOGY_module::I().P1_C_UW_EVAP_u362_exe(); }
int P1_C_VERT_HYDR_COND_u363_exe_g(Variable* obj) { return HYDROLOGY_module::I().P1_C_VERT_HYDR_COND_u363_exe(); }
int P1_C_ZIG_u364_exe_g(Variable* obj) { return HYDROLOGY_module::I().P1_C_ZIG_u364_exe(); }
int P1_IC_SW_DEPTH_u365_exe_g(Variable* obj) { return HYDROLOGY_module::I().P1_IC_SW_DEPTH_u365_exe(); }
int P1_IC_UW_MOIST_PR_u366_exe_g(Variable* obj) { return HYDROLOGY_module::I().P1_IC_UW_MOIST_PR_u366_exe(); }
int P1_IC_WT_TABLE_u367_exe_g(Variable* obj) { return HYDROLOGY_module::I().P1_IC_WT_TABLE_u367_exe(); }
// ---------------------------------------------------------------------------
//                    Class GLOBALS_module 
// ---------------------------------------------------------------------------

class GLOBALS_module : public TModule {
protected:

	GLOBALS_module(char* name);

public:

	TTime TIME;
	CAuxVariable VAP_PRESS;
	CAuxVariable AIR_TEMP_C;
	CAuxVariable CLOUDY;
	CAuxVariable WIND;
	CAuxVariable P1_C_LATDEG;
	CAuxVariable DAYJUL;
	CAuxVariable HABITATMAP;
	CAuxVariable DAYLENGTH;
	CAuxVariable ELEVATION;
	CAuxVariable CELL_SIZE;
	CAuxVariable ON_MAP;
	CAuxVariable PRECIP_M;
	CAuxVariable HYDRO;
	CAuxVariable SOIL;
	CAuxVariable HUMIDITY;
	CAuxVariable ELEV_MIN;
	CAuxVariable P1_DATUM_TO_MSL;
	CAuxVariable SOLRADATM;
	CAuxVariable SOLRADGRD;
	CAuxVariable AMPL;
	CAuxVariable LENGTH;
	CAuxVariable PAR;
	CAuxVariable PAR_G;
	CAuxVariable ROADS;
	CAuxVariable VAP_SAT_DEFICIT;
	CAuxVariable P1_C_SURF_DELTA;
	CAuxVariable P1_DEPTH_MSL_MAP;
	CAuxVariable P1_ELEV_MSL_MAP;
	CAuxVariable P1_POP_DENS;
	CAuxVariable P1_RAD_CONV;
	CAuxVariable P1_RAIN_CONV;
	CAuxVariable P1_SEWERMAP;
	CAuxVariable P1_WIND_CONV;
	CAuxVariable AIR_TEMP_MAX;
	CAuxVariable AIR_TEMP_MIN;
	CAuxVariable PRECIPITATION;
	CAuxVariable WIND_SPEED;
protected:

	int AIR_TEMP_C_u395_exe();
	friend int AIR_TEMP_C_u395_exe_g( Variable* v );
	int AMPL_u396_exe();
	friend int AMPL_u396_exe_g( Variable* v );
	int CELL_SIZE_u397_exe();
	friend int CELL_SIZE_u397_exe_g( Variable* v );
	int CLOUDY_u398_exe();
	friend int CLOUDY_u398_exe_g( Variable* v );
	int DAYJUL_u399_exe();
	friend int DAYJUL_u399_exe_g( Variable* v );
	int DAYLENGTH_u400_exe();
	friend int DAYLENGTH_u400_exe_g( Variable* v );
	int ELEVATION_u401_exe();
	friend int ELEVATION_u401_exe_g( Variable* v );
	int ELEV_MIN_u402_exe();
	friend int ELEV_MIN_u402_exe_g( Variable* v );
	int HABITATMAP_u403_exe();
	friend int HABITATMAP_u403_exe_g( Variable* v );
	int HYDRO_u404_exe();
	friend int HYDRO_u404_exe_g( Variable* v );
	int LENGTH_u405_exe();
	friend int LENGTH_u405_exe_g( Variable* v );
	int ON_MAP_u406_exe();
	friend int ON_MAP_u406_exe_g( Variable* v );
	int PAR_u407_exe();
	friend int PAR_u407_exe_g( Variable* v );
	int PAR_G_u408_exe();
	friend int PAR_G_u408_exe_g( Variable* v );
	int PRECIP_M_u409_exe();
	friend int PRECIP_M_u409_exe_g( Variable* v );
	int ROADS_u410_exe();
	friend int ROADS_u410_exe_g( Variable* v );
	int SOIL_u411_exe();
	friend int SOIL_u411_exe_g( Variable* v );
	int VAP_PRESS_u412_exe();
	friend int VAP_PRESS_u412_exe_g( Variable* v );
	int VAP_SAT_DEFICIT_u413_exe();
	friend int VAP_SAT_DEFICIT_u413_exe_g( Variable* v );
	int WIND_u414_exe();
	friend int WIND_u414_exe_g( Variable* v );
	int P1_C_LATDEG_u415_exe();
	friend int P1_C_LATDEG_u415_exe_g( Variable* v );
	int P1_C_SURF_DELTA_u416_exe();
	friend int P1_C_SURF_DELTA_u416_exe_g( Variable* v );
	int P1_DATUM_TO_MSL_u417_exe();
	friend int P1_DATUM_TO_MSL_u417_exe_g( Variable* v );
	int P1_DEPTH_MSL_MAP_u418_exe();
	friend int P1_DEPTH_MSL_MAP_u418_exe_g( Variable* v );
	int P1_ELEV_MSL_MAP_u419_exe();
	friend int P1_ELEV_MSL_MAP_u419_exe_g( Variable* v );
	int P1_POP_DENS_u420_exe();
	friend int P1_POP_DENS_u420_exe_g( Variable* v );
	int P1_RAD_CONV_u421_exe();
	friend int P1_RAD_CONV_u421_exe_g( Variable* v );
	int P1_RAIN_CONV_u422_exe();
	friend int P1_RAIN_CONV_u422_exe_g( Variable* v );
	int P1_SEWERMAP_u423_exe();
	friend int P1_SEWERMAP_u423_exe_g( Variable* v );
	int P1_WIND_CONV_u424_exe();
	friend int P1_WIND_CONV_u424_exe_g( Variable* v );
	int AIR_TEMP_MAX_u425_exe();
	friend int AIR_TEMP_MAX_u425_exe_g( Variable* v );
	int AIR_TEMP_MIN_u426_exe();
	friend int AIR_TEMP_MIN_u426_exe_g( Variable* v );
	int HUMIDITY_u427_exe();
	friend int HUMIDITY_u427_exe_g( Variable* v );
	int PRECIPITATION_u428_exe();
	friend int PRECIPITATION_u428_exe_g( Variable* v );
	int WIND_SPEED_u429_exe();
	friend int WIND_SPEED_u429_exe_g( Variable* v );
	static GLOBALS_module* fInstance;
	static GLOBALS_module* kNullModel;
public:
	inline static GLOBALS_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new GLOBALS_module("GLOBALS_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (GLOBALS_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}

	inline double Graph54(double x) { 
		static double g[365][2] = {
			{ 1.0000E+00, 4.400000E+01},{ 2.0000E+00, 4.200000E+01},{ 3.0000E+00, 5.100000E+01},{ 4.0000E+00, 4.200000E+01},
			{ 5.0000E+00, 3.800000E+01},{ 6.0000E+00, 4.300000E+01},{ 7.0000E+00, 4.400000E+01},{ 8.0000E+00, 3.300000E+01},
			{ 9.0000E+00, 3.300000E+01},{ 1.0000E+01, 4.000000E+01},{ 1.1000E+01, 4.300000E+01},{ 1.2000E+01, 3.900000E+01},
			{ 1.3000E+01, 4.100000E+01},{ 1.4000E+01, 3.700000E+01},{ 1.5000E+01, 4.400000E+01},{ 1.6000E+01, 5.700000E+01},
			{ 1.7000E+01, 5.200000E+01},{ 1.8000E+01, 4.800000E+01},{ 1.9000E+01, 4.600000E+01},{ 2.0000E+01, 5.500000E+01},
			{ 2.1000E+01, 5.600000E+01},{ 2.2000E+01, 4.200000E+01},{ 2.3000E+01, 2.600000E+01},{ 2.4000E+01, 4.000000E+01},
			{ 2.5000E+01, 4.300000E+01},{ 2.6000E+01, 3.100000E+01},{ 2.7000E+01, 4.000000E+01},{ 2.8000E+01, 4.800000E+01},
			{ 2.9000E+01, 5.400000E+01},{ 3.0000E+01, 5.500000E+01},{ 3.1000E+01, 5.600000E+01},{ 3.2000E+01, 4.000000E+01},
			{ 3.3000E+01, 4.400000E+01},{ 3.4000E+01, 5.600000E+01},{ 3.5000E+01, 6.600000E+01},{ 3.6000E+01, 6.900000E+01},
			{ 3.7000E+01, 7.400000E+01},{ 3.8000E+01, 5.400000E+01},{ 3.9000E+01, 5.200000E+01},{ 4.0000E+01, 4.900000E+01},
			{ 4.1000E+01, 4.900000E+01},{ 4.2000E+01, 4.900000E+01},{ 4.3000E+01, 4.100000E+01},{ 4.4000E+01, 3.600000E+01},
			{ 4.5000E+01, 5.000000E+01},{ 4.6000E+01, 5.800000E+01},{ 4.7000E+01, 3.500000E+01},{ 4.8000E+01, 3.100000E+01},
			{ 4.9000E+01, 4.200000E+01},{ 5.0000E+01, 4.800000E+01},{ 5.1000E+01, 6.400000E+01},{ 5.2000E+01, 6.500000E+01},
			{ 5.3000E+01, 6.100000E+01},{ 5.4000E+01, 7.000000E+01},{ 5.5000E+01, 4.000000E+01},{ 5.6000E+01, 5.200000E+01},
			{ 5.7000E+01, 4.900000E+01},{ 5.8000E+01, 4.300000E+01},{ 5.9000E+01, 4.300000E+01},{ 6.0000E+01, 5.800000E+01},
			{ 6.1000E+01, 6.800000E+01},{ 6.2000E+01, 7.000000E+01},{ 6.3000E+01, 6.500000E+01},{ 6.4000E+01, 4.900000E+01},
			{ 6.5000E+01, 5.900000E+01},{ 6.6000E+01, 6.200000E+01},{ 6.7000E+01, 5.300000E+01},{ 6.8000E+01, 5.300000E+01},
			{ 6.9000E+01, 4.800000E+01},{ 7.0000E+01, 5.100000E+01},{ 7.1000E+01, 4.600000E+01},{ 7.2000E+01, 4.600000E+01},
			{ 7.3000E+01, 3.600000E+01},{ 7.4000E+01, 3.800000E+01},{ 7.5000E+01, 4.800000E+01},{ 7.6000E+01, 5.500000E+01},
			{ 7.7000E+01, 6.200000E+01},{ 7.8000E+01, 5.900000E+01},{ 7.9000E+01, 5.500000E+01},{ 8.0000E+01, 6.200000E+01},
			{ 8.1000E+01, 6.400000E+01},{ 8.2000E+01, 5.500000E+01},{ 8.3000E+01, 5.000000E+01},{ 8.4000E+01, 6.400000E+01},
			{ 8.5000E+01, 5.900000E+01},{ 8.6000E+01, 6.000000E+01},{ 8.7000E+01, 7.300000E+01},{ 8.8000E+01, 7.600000E+01},
			{ 8.9000E+01, 5.500000E+01},{ 9.0000E+01, 4.700000E+01},{ 9.1000E+01, 5.200000E+01},{ 9.2000E+01, 5.800000E+01},
			{ 9.3000E+01, 5.300000E+01},{ 9.4000E+01, 5.900000E+01},{ 9.5000E+01, 6.800000E+01},{ 9.6000E+01, 6.400000E+01},
			{ 9.7000E+01, 7.600000E+01},{ 9.8000E+01, 8.500000E+01},{ 9.9000E+01, 8.700000E+01},{ 1.0000E+02, 8.500000E+01},
			{ 1.0100E+02, 7.400000E+01},{ 1.0200E+02, 6.300000E+01},{ 1.0300E+02, 6.000000E+01},{ 1.0400E+02, 4.900000E+01},
			{ 1.0500E+02, 4.800000E+01},{ 1.0600E+02, 5.600000E+01},{ 1.0700E+02, 7.700000E+01},{ 1.0800E+02, 8.500000E+01},
			{ 1.0900E+02, 6.200000E+01},{ 1.1000E+02, 5.300000E+01},{ 1.1100E+02, 5.000000E+01},{ 1.1200E+02, 5.000000E+01},
			{ 1.1300E+02, 6.000000E+01},{ 1.1400E+02, 6.900000E+01},{ 1.1500E+02, 7.000000E+01},{ 1.1600E+02, 7.400000E+01},
			{ 1.1700E+02, 7.700000E+01},{ 1.1800E+02, 8.200000E+01},{ 1.1900E+02, 7.600000E+01},{ 1.2000E+02, 6.200000E+01},
			{ 1.2100E+02, 8.000000E+01},{ 1.2200E+02, 8.200000E+01},{ 1.2300E+02, 6.900000E+01},{ 1.2400E+02, 6.500000E+01},
			{ 1.2500E+02, 7.200000E+01},{ 1.2600E+02, 7.500000E+01},{ 1.2700E+02, 8.100000E+01},{ 1.2800E+02, 7.000000E+01},
			{ 1.2900E+02, 7.600000E+01},{ 1.3000E+02, 6.200000E+01},{ 1.3100E+02, 8.000000E+01},{ 1.3200E+02, 7.600000E+01},
			{ 1.3300E+02, 8.700000E+01},{ 1.3400E+02, 9.000000E+01},{ 1.3500E+02, 8.900000E+01},{ 1.3600E+02, 8.900000E+01},
			{ 1.3700E+02, 8.700000E+01},{ 1.3800E+02, 8.800000E+01},{ 1.3900E+02, 7.500000E+01},{ 1.4000E+02, 6.400000E+01},
			{ 1.4100E+02, 7.100000E+01},{ 1.4200E+02, 8.000000E+01},{ 1.4300E+02, 8.700000E+01},{ 1.4400E+02, 8.900000E+01},
			{ 1.4500E+02, 8.700000E+01},{ 1.4600E+02, 9.200000E+01},{ 1.4700E+02, 9.300000E+01},{ 1.4800E+02, 9.000000E+01},
			{ 1.4900E+02, 9.100000E+01},{ 1.5000E+02, 9.400000E+01},{ 1.5100E+02, 9.600000E+01},{ 1.5200E+02, 9.600000E+01},
			{ 1.5300E+02, 9.300000E+01},{ 1.5400E+02, 8.700000E+01},{ 1.5500E+02, 8.400000E+01},{ 1.5600E+02, 7.900000E+01},
			{ 1.5700E+02, 7.300000E+01},{ 1.5800E+02, 7.500000E+01},{ 1.5900E+02, 7.900000E+01},{ 1.6000E+02, 8.300000E+01},
			{ 1.6100E+02, 8.900000E+01},{ 1.6200E+02, 9.100000E+01},{ 1.6300E+02, 9.100000E+01},{ 1.6400E+02, 8.900000E+01},
			{ 1.6500E+02, 8.200000E+01},{ 1.6600E+02, 8.600000E+01},{ 1.6700E+02, 9.800000E+01},{ 1.6800E+02, 9.800000E+01},
			{ 1.6900E+02, 9.100000E+01},{ 1.7000E+02, 7.000000E+01},{ 1.7100E+02, 7.400000E+01},{ 1.7200E+02, 8.900000E+01},
			{ 1.7300E+02, 9.400000E+01},{ 1.7400E+02, 7.600000E+01},{ 1.7500E+02, 6.700000E+01},{ 1.7600E+02, 8.100000E+01},
			{ 1.7700E+02, 8.100000E+01},{ 1.7800E+02, 8.300000E+01},{ 1.7900E+02, 8.800000E+01},{ 1.8000E+02, 9.400000E+01},
			{ 1.8100E+02, 9.500000E+01},{ 1.8200E+02, 9.600000E+01},{ 1.8300E+02, 8.400000E+01},{ 1.8400E+02, 9.000000E+01},
			{ 1.8500E+02, 8.700000E+01},{ 1.8600E+02, 7.600000E+01},{ 1.8700E+02, 8.200000E+01},{ 1.8800E+02, 9.300000E+01},
			{ 1.8900E+02, 9.500000E+01},{ 1.9000E+02, 9.300000E+01},{ 1.9100E+02, 8.500000E+01},{ 1.9200E+02, 8.100000E+01},
			{ 1.9300E+02, 8.900000E+01},{ 1.9400E+02, 9.100000E+01},{ 1.9500E+02, 9.100000E+01},{ 1.9600E+02, 8.700000E+01},
			{ 1.9700E+02, 8.900000E+01},{ 1.9800E+02, 9.100000E+01},{ 1.9900E+02, 9.500000E+01},{ 2.0000E+02, 9.700000E+01},
			{ 2.0100E+02, 9.700000E+01},{ 2.0200E+02, 9.900000E+01},{ 2.0300E+02, 1.000000E+02},{ 2.0400E+02, 9.600000E+01},
			{ 2.0500E+02, 1.010000E+02},{ 2.0600E+02, 9.200000E+01},{ 2.0700E+02, 8.500000E+01},{ 2.0800E+02, 9.200000E+01},
			{ 2.0900E+02, 7.800000E+01},{ 2.1000E+02, 8.400000E+01},{ 2.1100E+02, 8.400000E+01},{ 2.1200E+02, 7.800000E+01},
			{ 2.1300E+02, 8.800000E+01},{ 2.1400E+02, 9.100000E+01},{ 2.1500E+02, 9.600000E+01},{ 2.1600E+02, 9.800000E+01},
			{ 2.1700E+02, 8.800000E+01},{ 2.1800E+02, 8.500000E+01},{ 2.1900E+02, 8.600000E+01},{ 2.2000E+02, 8.000000E+01},
			{ 2.2100E+02, 8.800000E+01},{ 2.2200E+02, 8.600000E+01},{ 2.2300E+02, 8.500000E+01},{ 2.2400E+02, 8.500000E+01},
			{ 2.2500E+02, 8.700000E+01},{ 2.2600E+02, 8.800000E+01},{ 2.2700E+02, 8.600000E+01},{ 2.2800E+02, 8.500000E+01},
			{ 2.2900E+02, 9.100000E+01},{ 2.3000E+02, 8.900000E+01},{ 2.3100E+02, 9.100000E+01},{ 2.3200E+02, 9.000000E+01},
			{ 2.3300E+02, 8.300000E+01},{ 2.3400E+02, 8.000000E+01},{ 2.3500E+02, 8.500000E+01},{ 2.3600E+02, 8.900000E+01},
			{ 2.3700E+02, 8.600000E+01},{ 2.3800E+02, 8.100000E+01},{ 2.3900E+02, 8.200000E+01},{ 2.4000E+02, 8.500000E+01},
			{ 2.4100E+02, 9.200000E+01},{ 2.4200E+02, 9.600000E+01},{ 2.4300E+02, 9.700000E+01},{ 2.4400E+02, 9.400000E+01},
			{ 2.4500E+02, 7.700000E+01},{ 2.4600E+02, 7.600000E+01},{ 2.4700E+02, 8.200000E+01},{ 2.4800E+02, 8.700000E+01},
			{ 2.4900E+02, 8.500000E+01},{ 2.5000E+02, 7.500000E+01},{ 2.5100E+02, 8.500000E+01},{ 2.5200E+02, 8.800000E+01},
			{ 2.5300E+02, 8.900000E+01},{ 2.5400E+02, 8.500000E+01},{ 2.5500E+02, 8.500000E+01},{ 2.5600E+02, 7.800000E+01},
			{ 2.5700E+02, 8.400000E+01},{ 2.5800E+02, 8.400000E+01},{ 2.5900E+02, 8.600000E+01},{ 2.6000E+02, 9.600000E+01},
			{ 2.6100E+02, 9.600000E+01},{ 2.6200E+02, 8.700000E+01},{ 2.6300E+02, 7.900000E+01},{ 2.6400E+02, 6.500000E+01},
			{ 2.6500E+02, 6.600000E+01},{ 2.6600E+02, 7.200000E+01},{ 2.6700E+02, 7.000000E+01},{ 2.6800E+02, 7.400000E+01},
			{ 2.6900E+02, 7.000000E+01},{ 2.7000E+02, 7.300000E+01},{ 2.7100E+02, 6.500000E+01},{ 2.7200E+02, 6.900000E+01},
			{ 2.7300E+02, 7.800000E+01},{ 2.7400E+02, 6.900000E+01},{ 2.7500E+02, 8.000000E+01},{ 2.7600E+02, 8.200000E+01},
			{ 2.7700E+02, 8.200000E+01},{ 2.7800E+02, 8.600000E+01},{ 2.7900E+02, 8.100000E+01},{ 2.8000E+02, 6.400000E+01},
			{ 2.8100E+02, 6.000000E+01},{ 2.8200E+02, 6.600000E+01},{ 2.8300E+02, 7.000000E+01},{ 2.8400E+02, 7.500000E+01},
			{ 2.8500E+02, 6.600000E+01},{ 2.8600E+02, 6.500000E+01},{ 2.8700E+02, 6.200000E+01},{ 2.8800E+02, 6.500000E+01},
			{ 2.8900E+02, 7.400000E+01},{ 2.9000E+02, 6.600000E+01},{ 2.9100E+02, 5.000000E+01},{ 2.9200E+02, 7.500000E+01},
			{ 2.9300E+02, 8.100000E+01},{ 2.9400E+02, 5.400000E+01},{ 2.9500E+02, 5.600000E+01},{ 2.9600E+02, 7.300000E+01},
			{ 2.9700E+02, 7.400000E+01},{ 2.9800E+02, 7.400000E+01},{ 2.9900E+02, 7.500000E+01},{ 3.0000E+02, 7.000000E+01},
			{ 3.0100E+02, 7.200000E+01},{ 3.0200E+02, 6.700000E+01},{ 3.0300E+02, 5.800000E+01},{ 3.0400E+02, 6.600000E+01},
			{ 3.0500E+02, 6.600000E+01},{ 3.0600E+02, 6.600000E+01},{ 3.0700E+02, 6.700000E+01},{ 3.0800E+02, 5.200000E+01},
			{ 3.0900E+02, 3.800000E+01},{ 3.1000E+02, 4.500000E+01},{ 3.1100E+02, 5.300000E+01},{ 3.1200E+02, 5.600000E+01},
			{ 3.1300E+02, 4.200000E+01},{ 3.1400E+02, 4.100000E+01},{ 3.1500E+02, 4.500000E+01},{ 3.1600E+02, 4.600000E+01},
			{ 3.1700E+02, 5.000000E+01},{ 3.1800E+02, 5.100000E+01},{ 3.1900E+02, 6.400000E+01},{ 3.2000E+02, 7.100000E+01},
			{ 3.2100E+02, 6.800000E+01},{ 3.2200E+02, 5.400000E+01},{ 3.2300E+02, 5.600000E+01},{ 3.2400E+02, 6.500000E+01},
			{ 3.2500E+02, 7.600000E+01},{ 3.2600E+02, 7.400000E+01},{ 3.2700E+02, 6.800000E+01},{ 3.2800E+02, 6.800000E+01},
			{ 3.2900E+02, 5.200000E+01},{ 3.3000E+02, 4.000000E+01},{ 3.3100E+02, 4.000000E+01},{ 3.3200E+02, 4.500000E+01},
			{ 3.3300E+02, 6.100000E+01},{ 3.3400E+02, 7.000000E+01},{ 3.3500E+02, 7.300000E+01},{ 3.3600E+02, 6.000000E+01},
			{ 3.3700E+02, 5.200000E+01},{ 3.3800E+02, 5.500000E+01},{ 3.3900E+02, 3.900000E+01},{ 3.4000E+02, 3.700000E+01},
			{ 3.4100E+02, 5.300000E+01},{ 3.4200E+02, 5.500000E+01},{ 3.4300E+02, 5.400000E+01},{ 3.4400E+02, 6.900000E+01},
			{ 3.4500E+02, 5.100000E+01},{ 3.4600E+02, 5.600000E+01},{ 3.4700E+02, 5.600000E+01},{ 3.4800E+02, 6.100000E+01},
			{ 3.4900E+02, 6.400000E+01},{ 3.5000E+02, 4.000000E+01},{ 3.5100E+02, 3.000000E+01},{ 3.5200E+02, 4.800000E+01},
			{ 3.5300E+02, 3.900000E+01},{ 3.5400E+02, 3.300000E+01},{ 3.5500E+02, 4.800000E+01},{ 3.5600E+02, 5.000000E+01},
			{ 3.5700E+02, 4.900000E+01},{ 3.5800E+02, 4.500000E+01},{ 3.5900E+02, 4.000000E+01},{ 3.6000E+02, 4.400000E+01},
			{ 3.6100E+02, 4.500000E+01},{ 3.6200E+02, 4.700000E+01},{ 3.6300E+02, 4.200000E+01},{ 3.6400E+02, 5.300000E+01},
			{ 3.6500E+02, 4.500000E+01}, };
		return SL::Graph( 0, x, 364, g); 
	}

	inline double Graph55(double x) { 
		static double g[365][2] = {
			{ 1.0000E+00, 1.900000E+01},{ 2.0000E+00, 2.100000E+01},{ 3.0000E+00, 2.200000E+01},{ 4.0000E+00, 2.600000E+01},
			{ 5.0000E+00, 1.900000E+01},{ 6.0000E+00, 2.100000E+01},{ 7.0000E+00, 3.200000E+01},{ 8.0000E+00, 1.700000E+01},
			{ 9.0000E+00, 1.700000E+01},{ 1.0000E+01, 3.000000E+01},{ 1.1000E+01, 2.800000E+01},{ 1.2000E+01, 2.800000E+01},
			{ 1.3000E+01, 3.200000E+01},{ 1.4000E+01, 2.000000E+01},{ 1.5000E+01, 2.500000E+01},{ 1.6000E+01, 2.900000E+01},
			{ 1.7000E+01, 3.800000E+01},{ 1.8000E+01, 2.500000E+01},{ 1.9000E+01, 2.200000E+01},{ 2.0000E+01, 3.200000E+01},
			{ 2.1000E+01, 3.800000E+01},{ 2.2000E+01, 1.500000E+01},{ 2.3000E+01, 9.000000E+00},{ 2.4000E+01, 2.100000E+01},
			{ 2.5000E+01, 1.700000E+01},{ 2.6000E+01, 1.200000E+01},{ 2.7000E+01, 1.700000E+01},{ 2.8000E+01, 2.500000E+01},
			{ 2.9000E+01, 2.400000E+01},{ 3.0000E+01, 2.700000E+01},{ 3.1000E+01, 3.600000E+01},{ 3.2000E+01, 1.800000E+01},
			{ 3.3000E+01, 2.300000E+01},{ 3.4000E+01, 2.400000E+01},{ 3.5000E+01, 2.600000E+01},{ 3.6000E+01, 3.100000E+01},
			{ 3.7000E+01, 3.800000E+01},{ 3.8000E+01, 4.500000E+01},{ 3.9000E+01, 4.200000E+01},{ 4.0000E+01, 3.000000E+01},
			{ 4.1000E+01, 2.700000E+01},{ 4.2000E+01, 3.300000E+01},{ 4.3000E+01, 1.900000E+01},{ 4.4000E+01, 2.500000E+01},
			{ 4.5000E+01, 3.500000E+01},{ 4.6000E+01, 2.900000E+01},{ 4.7000E+01, 1.600000E+01},{ 4.8000E+01, 1.500000E+01},
			{ 4.9000E+01, 3.000000E+01},{ 5.0000E+01, 4.000000E+01},{ 5.1000E+01, 4.700000E+01},{ 5.2000E+01, 3.000000E+01},
			{ 5.3000E+01, 3.000000E+01},{ 5.4000E+01, 3.100000E+01},{ 5.5000E+01, 1.900000E+01},{ 5.6000E+01, 3.100000E+01},
			{ 5.7000E+01, 3.100000E+01},{ 5.8000E+01, 2.500000E+01},{ 5.9000E+01, 2.300000E+01},{ 6.0000E+01, 2.700000E+01},
			{ 6.1000E+01, 3.700000E+01},{ 6.2000E+01, 5.100000E+01},{ 6.3000E+01, 4.300000E+01},{ 6.4000E+01, 3.500000E+01},
			{ 6.5000E+01, 2.900000E+01},{ 6.6000E+01, 4.000000E+01},{ 6.7000E+01, 2.700000E+01},{ 6.8000E+01, 2.200000E+01},
			{ 6.9000E+01, 2.300000E+01},{ 7.0000E+01, 3.000000E+01},{ 7.1000E+01, 2.400000E+01},{ 7.2000E+01, 2.700000E+01},
			{ 7.3000E+01, 3.100000E+01},{ 7.4000E+01, 3.300000E+01},{ 7.5000E+01, 2.700000E+01},{ 7.6000E+01, 2.500000E+01},
			{ 7.7000E+01, 4.100000E+01},{ 7.8000E+01, 4.200000E+01},{ 7.9000E+01, 3.300000E+01},{ 8.0000E+01, 4.200000E+01},
			{ 8.1000E+01, 4.300000E+01},{ 8.2000E+01, 4.000000E+01},{ 8.3000E+01, 4.200000E+01},{ 8.4000E+01, 4.200000E+01},
			{ 8.5000E+01, 3.000000E+01},{ 8.6000E+01, 4.300000E+01},{ 8.7000E+01, 4.600000E+01},{ 8.8000E+01, 4.800000E+01},
			{ 8.9000E+01, 3.200000E+01},{ 9.0000E+01, 2.600000E+01},{ 9.1000E+01, 2.800000E+01},{ 9.2000E+01, 2.900000E+01},
			{ 9.3000E+01, 2.600000E+01},{ 9.4000E+01, 2.900000E+01},{ 9.5000E+01, 4.300000E+01},{ 9.6000E+01, 4.200000E+01},
			{ 9.7000E+01, 4.500000E+01},{ 9.8000E+01, 5.000000E+01},{ 9.9000E+01, 5.500000E+01},{ 1.0000E+02, 5.500000E+01},
			{ 1.0100E+02, 3.800000E+01},{ 1.0200E+02, 3.700000E+01},{ 1.0300E+02, 4.000000E+01},{ 1.0400E+02, 4.300000E+01},
			{ 1.0500E+02, 4.300000E+01},{ 1.0600E+02, 4.300000E+01},{ 1.0700E+02, 4.800000E+01},{ 1.0800E+02, 4.900000E+01},
			{ 1.0900E+02, 4.500000E+01},{ 1.1000E+02, 4.300000E+01},{ 1.1100E+02, 4.500000E+01},{ 1.1200E+02, 4.400000E+01},
			{ 1.1300E+02, 3.400000E+01},{ 1.1400E+02, 3.900000E+01},{ 1.1500E+02, 4.300000E+01},{ 1.1600E+02, 4.500000E+01},
			{ 1.1700E+02, 4.900000E+01},{ 1.1800E+02, 5.800000E+01},{ 1.1900E+02, 5.200000E+01},{ 1.2000E+02, 5.300000E+01},
			{ 1.2100E+02, 4.800000E+01},{ 1.2200E+02, 5.000000E+01},{ 1.2300E+02, 4.300000E+01},{ 1.2400E+02, 4.400000E+01},
			{ 1.2500E+02, 4.600000E+01},{ 1.2600E+02, 6.000000E+01},{ 1.2700E+02, 4.800000E+01},{ 1.2800E+02, 4.200000E+01},
			{ 1.2900E+02, 5.400000E+01},{ 1.3000E+02, 5.500000E+01},{ 1.3100E+02, 5.000000E+01},{ 1.3200E+02, 5.300000E+01},
			{ 1.3300E+02, 6.100000E+01},{ 1.3400E+02, 6.300000E+01},{ 1.3500E+02, 6.100000E+01},{ 1.3600E+02, 5.600000E+01},
			{ 1.3700E+02, 5.800000E+01},{ 1.3800E+02, 6.400000E+01},{ 1.3900E+02, 5.100000E+01},{ 1.4000E+02, 4.500000E+01},
			{ 1.4100E+02, 5.200000E+01},{ 1.4200E+02, 5.800000E+01},{ 1.4300E+02, 6.100000E+01},{ 1.4400E+02, 6.200000E+01},
			{ 1.4500E+02, 6.800000E+01},{ 1.4600E+02, 6.900000E+01},{ 1.4700E+02, 6.900000E+01},{ 1.4800E+02, 7.300000E+01},
			{ 1.4900E+02, 6.700000E+01},{ 1.5000E+02, 6.600000E+01},{ 1.5100E+02, 7.100000E+01},{ 1.5200E+02, 6.700000E+01},
			{ 1.5300E+02, 6.300000E+01},{ 1.5400E+02, 6.600000E+01},{ 1.5500E+02, 6.500000E+01},{ 1.5600E+02, 5.400000E+01},
			{ 1.5700E+02, 4.800000E+01},{ 1.5800E+02, 4.800000E+01},{ 1.5900E+02, 5.000000E+01},{ 1.6000E+02, 5.500000E+01},
			{ 1.6100E+02, 5.800000E+01},{ 1.6200E+02, 6.200000E+01},{ 1.6300E+02, 6.800000E+01},{ 1.6400E+02, 5.700000E+01},
			{ 1.6500E+02, 4.800000E+01},{ 1.6600E+02, 5.600000E+01},{ 1.6700E+02, 7.200000E+01},{ 1.6800E+02, 7.100000E+01},
			{ 1.6900E+02, 6.800000E+01},{ 1.7000E+02, 6.200000E+01},{ 1.7100E+02, 6.200000E+01},{ 1.7200E+02, 6.500000E+01},
			{ 1.7300E+02, 6.800000E+01},{ 1.7400E+02, 6.200000E+01},{ 1.7500E+02, 5.300000E+01},{ 1.7600E+02, 5.500000E+01},
			{ 1.7700E+02, 5.100000E+01},{ 1.7800E+02, 5.700000E+01},{ 1.7900E+02, 6.400000E+01},{ 1.8000E+02, 7.100000E+01},
			{ 1.8100E+02, 7.500000E+01},{ 1.8200E+02, 7.000000E+01},{ 1.8300E+02, 7.100000E+01},{ 1.8400E+02, 7.100000E+01},
			{ 1.8500E+02, 7.000000E+01},{ 1.8600E+02, 6.800000E+01},{ 1.8700E+02, 6.500000E+01},{ 1.8800E+02, 6.900000E+01},
			{ 1.8900E+02, 6.900000E+01},{ 1.9000E+02, 7.000000E+01},{ 1.9100E+02, 6.600000E+01},{ 1.9200E+02, 6.400000E+01},
			{ 1.9300E+02, 6.100000E+01},{ 1.9400E+02, 7.200000E+01},{ 1.9500E+02, 6.700000E+01},{ 1.9600E+02, 6.200000E+01},
			{ 1.9700E+02, 5.900000E+01},{ 1.9800E+02, 6.400000E+01},{ 1.9900E+02, 7.100000E+01},{ 2.0000E+02, 7.600000E+01},
			{ 2.0100E+02, 7.300000E+01},{ 2.0200E+02, 7.300000E+01},{ 2.0300E+02, 7.300000E+01},{ 2.0400E+02, 7.300000E+01},
			{ 2.0500E+02, 7.000000E+01},{ 2.0600E+02, 6.800000E+01},{ 2.0700E+02, 6.900000E+01},{ 2.0800E+02, 6.700000E+01},
			{ 2.0900E+02, 5.900000E+01},{ 2.1000E+02, 6.700000E+01},{ 2.1100E+02, 6.500000E+01},{ 2.1200E+02, 6.600000E+01},
			{ 2.1300E+02, 6.000000E+01},{ 2.1400E+02, 6.900000E+01},{ 2.1500E+02, 7.200000E+01},{ 2.1600E+02, 7.600000E+01},
			{ 2.1700E+02, 6.500000E+01},{ 2.1800E+02, 5.800000E+01},{ 2.1900E+02, 6.700000E+01},{ 2.2000E+02, 6.600000E+01},
			{ 2.2100E+02, 6.900000E+01},{ 2.2200E+02, 6.800000E+01},{ 2.2300E+02, 5.800000E+01},{ 2.2400E+02, 5.900000E+01},
			{ 2.2500E+02, 6.100000E+01},{ 2.2600E+02, 6.500000E+01},{ 2.2700E+02, 6.800000E+01},{ 2.2800E+02, 6.200000E+01},
			{ 2.2900E+02, 6.300000E+01},{ 2.3000E+02, 6.700000E+01},{ 2.3100E+02, 7.100000E+01},{ 2.3200E+02, 6.500000E+01},
			{ 2.3300E+02, 6.100000E+01},{ 2.3400E+02, 5.700000E+01},{ 2.3500E+02, 5.800000E+01},{ 2.3600E+02, 6.300000E+01},
			{ 2.3700E+02, 6.600000E+01},{ 2.3800E+02, 6.100000E+01},{ 2.3900E+02, 6.400000E+01},{ 2.4000E+02, 6.600000E+01},
			{ 2.4100E+02, 6.900000E+01},{ 2.4200E+02, 6.900000E+01},{ 2.4300E+02, 7.300000E+01},{ 2.4400E+02, 6.000000E+01},
			{ 2.4500E+02, 4.800000E+01},{ 2.4600E+02, 5.200000E+01},{ 2.4700E+02, 5.500000E+01},{ 2.4800E+02, 6.600000E+01},
			{ 2.4900E+02, 6.400000E+01},{ 2.5000E+02, 5.500000E+01},{ 2.5100E+02, 5.900000E+01},{ 2.5200E+02, 5.800000E+01},
			{ 2.5300E+02, 6.300000E+01},{ 2.5400E+02, 6.800000E+01},{ 2.5500E+02, 5.900000E+01},{ 2.5600E+02, 5.200000E+01},
			{ 2.5700E+02, 5.600000E+01},{ 2.5800E+02, 6.500000E+01},{ 2.5900E+02, 6.800000E+01},{ 2.6000E+02, 7.100000E+01},
			{ 2.6100E+02, 7.100000E+01},{ 2.6200E+02, 7.200000E+01},{ 2.6300E+02, 5.000000E+01},{ 2.6400E+02, 4.500000E+01},
			{ 2.6500E+02, 4.000000E+01},{ 2.6600E+02, 4.900000E+01},{ 2.6700E+02, 6.000000E+01},{ 2.6800E+02, 6.200000E+01},
			{ 2.6900E+02, 5.500000E+01},{ 2.7000E+02, 4.200000E+01},{ 2.7100E+02, 3.800000E+01},{ 2.7200E+02, 4.300000E+01},
			{ 2.7300E+02, 5.000000E+01},{ 2.7400E+02, 5.100000E+01},{ 2.7500E+02, 6.000000E+01},{ 2.7600E+02, 6.300000E+01},
			{ 2.7700E+02, 5.700000E+01},{ 2.7800E+02, 6.000000E+01},{ 2.7900E+02, 5.300000E+01},{ 2.8000E+02, 4.000000E+01},
			{ 2.8100E+02, 3.400000E+01},{ 2.8200E+02, 3.700000E+01},{ 2.8300E+02, 4.000000E+01},{ 2.8400E+02, 4.700000E+01},
			{ 2.8500E+02, 4.100000E+01},{ 2.8600E+02, 4.300000E+01},{ 2.8700E+02, 3.400000E+01},{ 2.8800E+02, 3.700000E+01},
			{ 2.8900E+02, 4.800000E+01},{ 2.9000E+02, 4.300000E+01},{ 2.9100E+02, 3.900000E+01},{ 2.9200E+02, 4.000000E+01},
			{ 2.9300E+02, 3.500000E+01},{ 2.9400E+02, 3.000000E+01},{ 2.9500E+02, 3.500000E+01},{ 2.9600E+02, 3.700000E+01},
			{ 2.9700E+02, 5.200000E+01},{ 2.9800E+02, 5.000000E+01},{ 2.9900E+02, 5.000000E+01},{ 3.0000E+02, 5.500000E+01},
			{ 3.0100E+02, 5.300000E+01},{ 3.0200E+02, 3.800000E+01},{ 3.0300E+02, 3.000000E+01},{ 3.0400E+02, 4.000000E+01},
			{ 3.0500E+02, 4.100000E+01},{ 3.0600E+02, 4.900000E+01},{ 3.0700E+02, 3.300000E+01},{ 3.0800E+02, 3.400000E+01},
			{ 3.0900E+02, 2.400000E+01},{ 3.1000E+02, 1.900000E+01},{ 3.1100E+02, 2.400000E+01},{ 3.1200E+02, 3.300000E+01},
			{ 3.1300E+02, 3.200000E+01},{ 3.1400E+02, 3.300000E+01},{ 3.1500E+02, 3.400000E+01},{ 3.1600E+02, 3.100000E+01},
			{ 3.1700E+02, 3.300000E+01},{ 3.1800E+02, 3.000000E+01},{ 3.1900E+02, 3.400000E+01},{ 3.2000E+02, 4.600000E+01},
			{ 3.2100E+02, 3.200000E+01},{ 3.2200E+02, 2.400000E+01},{ 3.2300E+02, 3.200000E+01},{ 3.2400E+02, 4.000000E+01},
			{ 3.2500E+02, 5.600000E+01},{ 3.2600E+02, 6.100000E+01},{ 3.2700E+02, 5.200000E+01},{ 3.2800E+02, 4.000000E+01},
			{ 3.2900E+02, 3.300000E+01},{ 3.3000E+02, 2.600000E+01},{ 3.3100E+02, 1.700000E+01},{ 3.3200E+02, 2.200000E+01},
			{ 3.3300E+02, 3.700000E+01},{ 3.3400E+02, 4.400000E+01},{ 3.3500E+02, 5.600000E+01},{ 3.3600E+02, 5.100000E+01},
			{ 3.3700E+02, 4.100000E+01},{ 3.3800E+02, 3.500000E+01},{ 3.3900E+02, 2.200000E+01},{ 3.4000E+02, 2.400000E+01},
			{ 3.4100E+02, 2.300000E+01},{ 3.4200E+02, 2.800000E+01},{ 3.4300E+02, 4.000000E+01},{ 3.4400E+02, 4.000000E+01},
			{ 3.4500E+02, 2.900000E+01},{ 3.4600E+02, 3.100000E+01},{ 3.4700E+02, 4.100000E+01},{ 3.4800E+02, 5.400000E+01},
			{ 3.4900E+02, 3.400000E+01},{ 3.5000E+02, 2.400000E+01},{ 3.5100E+02, 2.300000E+01},{ 3.5200E+02, 2.900000E+01},
			{ 3.5300E+02, 1.700000E+01},{ 3.5400E+02, 1.200000E+01},{ 3.5500E+02, 1.700000E+01},{ 3.5600E+02, 2.400000E+01},
			{ 3.5700E+02, 2.900000E+01},{ 3.5800E+02, 2.900000E+01},{ 3.5900E+02, 2.400000E+01},{ 3.6000E+02, 1.900000E+01},
			{ 3.6100E+02, 2.200000E+01},{ 3.6200E+02, 2.200000E+01},{ 3.6300E+02, 3.200000E+01},{ 3.6400E+02, 3.200000E+01},
			{ 3.6500E+02, 2.400000E+01}, };
		return SL::Graph( 0, x, 364, g); 
	}

	inline double Graph56(double x) { 
		static double g[365][2] = {
			{ 1.0000E+00, 6.700000E+01},{ 2.0000E+00, 7.100000E+01},{ 3.0000E+00, 6.900000E+01},{ 4.0000E+00, 5.000000E+01},
			{ 5.0000E+00, 6.500000E+01},{ 6.0000E+00, 8.800000E+01},{ 7.0000E+00, 9.000000E+01},{ 8.0000E+00, 7.700000E+01},
			{ 9.0000E+00, 8.800000E+01},{ 1.0000E+01, 6.900000E+01},{ 1.1000E+01, 8.900000E+01},{ 1.2000E+01, 9.400000E+01},
			{ 1.3000E+01, 6.100000E+01},{ 1.4000E+01, 6.900000E+01},{ 1.5000E+01, 7.300000E+01},{ 1.6000E+01, 9.400000E+01},
			{ 1.7000E+01, 6.100000E+01},{ 1.8000E+01, 5.400000E+01},{ 1.9000E+01, 4.700000E+01},{ 2.0000E+01, 5.900000E+01},
			{ 2.1000E+01, 6.600000E+01},{ 2.2000E+01, 4.100000E+01},{ 2.3000E+01, 5.500000E+01},{ 2.4000E+01, 4.800000E+01},
			{ 2.5000E+01, 4.200000E+01},{ 2.6000E+01, 5.800000E+01},{ 2.7000E+01, 5.200000E+01},{ 2.8000E+01, 5.100000E+01},
			{ 2.9000E+01, 6.300000E+01},{ 3.0000E+01, 8.400000E+01},{ 3.1000E+01, 4.700000E+01},{ 3.2000E+01, 4.200000E+01},
			{ 3.3000E+01, 4.800000E+01},{ 3.4000E+01, 4.100000E+01},{ 3.5000E+01, 3.900000E+01},{ 3.6000E+01, 4.300000E+01},
			{ 3.7000E+01, 8.500000E+01},{ 3.8000E+01, 9.500000E+01},{ 3.9000E+01, 7.200000E+01},{ 4.0000E+01, 6.000000E+01},
			{ 4.1000E+01, 6.800000E+01},{ 4.2000E+01, 4.300000E+01},{ 4.3000E+01, 4.200000E+01},{ 4.4000E+01, 5.900000E+01},
			{ 4.5000E+01, 7.300000E+01},{ 4.6000E+01, 4.400000E+01},{ 4.7000E+01, 4.200000E+01},{ 4.8000E+01, 4.700000E+01},
			{ 4.9000E+01, 9.100000E+01},{ 5.0000E+01, 9.300000E+01},{ 5.1000E+01, 6.500000E+01},{ 5.2000E+01, 5.300000E+01},
			{ 5.3000E+01, 4.100000E+01},{ 5.4000E+01, 4.000000E+01},{ 5.5000E+01, 6.200000E+01},{ 5.6000E+01, 5.500000E+01},
			{ 5.7000E+01, 6.200000E+01},{ 5.8000E+01, 5.000000E+01},{ 5.9000E+01, 5.300000E+01},{ 6.0000E+01, 4.800000E+01},
			{ 6.1000E+01, 7.700000E+01},{ 6.2000E+01, 8.800000E+01},{ 6.3000E+01, 7.500000E+01},{ 6.4000E+01, 4.700000E+01},
			{ 6.5000E+01, 6.200000E+01},{ 6.6000E+01, 5.800000E+01},{ 6.7000E+01, 4.600000E+01},{ 6.8000E+01, 4.600000E+01},
			{ 6.9000E+01, 5.700000E+01},{ 7.0000E+01, 3.300000E+01},{ 7.1000E+01, 4.000000E+01},{ 7.2000E+01, 7.500000E+01},
			{ 7.3000E+01, 9.200000E+01},{ 7.4000E+01, 7.000000E+01},{ 7.5000E+01, 5.300000E+01},{ 7.6000E+01, 5.100000E+01},
			{ 7.7000E+01, 8.700000E+01},{ 7.8000E+01, 5.600000E+01},{ 7.9000E+01, 5.100000E+01},{ 8.0000E+01, 6.100000E+01},
			{ 8.1000E+01, 8.900000E+01},{ 8.2000E+01, 9.600000E+01},{ 8.3000E+01, 7.300000E+01},{ 8.4000E+01, 5.500000E+01},
			{ 8.5000E+01, 6.700000E+01},{ 8.6000E+01, 7.900000E+01},{ 8.7000E+01, 3.800000E+01},{ 8.8000E+01, 7.500000E+01},
			{ 8.9000E+01, 7.000000E+01},{ 9.0000E+01, 5.100000E+01},{ 9.1000E+01, 5.800000E+01},{ 9.2000E+01, 5.300000E+01},
			{ 9.3000E+01, 5.200000E+01},{ 9.4000E+01, 5.300000E+01},{ 9.5000E+01, 8.200000E+01},{ 9.6000E+01, 6.500000E+01},
			{ 9.7000E+01, 4.900000E+01},{ 9.8000E+01, 5.100000E+01},{ 9.9000E+01, 6.400000E+01},{ 1.0000E+02, 4.800000E+01},
			{ 1.0100E+02, 3.500000E+01},{ 1.0200E+02, 3.300000E+01},{ 1.0300E+02, 8.300000E+01},{ 1.0400E+02, 9.100000E+01},
			{ 1.0500E+02, 9.500000E+01},{ 1.0600E+02, 5.900000E+01},{ 1.0700E+02, 5.600000E+01},{ 1.0800E+02, 7.500000E+01},
			{ 1.0900E+02, 7.200000E+01},{ 1.1000E+02, 8.600000E+01},{ 1.1100E+02, 8.700000E+01},{ 1.1200E+02, 6.300000E+01},
			{ 1.1300E+02, 5.700000E+01},{ 1.1400E+02, 6.900000E+01},{ 1.1500E+02, 5.200000E+01},{ 1.1600E+02, 6.200000E+01},
			{ 1.1700E+02, 7.500000E+01},{ 1.1800E+02, 8.100000E+01},{ 1.1900E+02, 9.100000E+01},{ 1.2000E+02, 8.800000E+01},
			{ 1.2100E+02, 5.400000E+01},{ 1.2200E+02, 5.100000E+01},{ 1.2300E+02, 5.400000E+01},{ 1.2400E+02, 5.300000E+01},
			{ 1.2500E+02, 6.300000E+01},{ 1.2600E+02, 8.800000E+01},{ 1.2700E+02, 6.100000E+01},{ 1.2800E+02, 6.000000E+01},
			{ 1.2900E+02, 7.900000E+01},{ 1.3000E+02, 7.000000E+01},{ 1.3100E+02, 6.200000E+01},{ 1.3200E+02, 6.000000E+01},
			{ 1.3300E+02, 6.300000E+01},{ 1.3400E+02, 7.100000E+01},{ 1.3500E+02, 6.300000E+01},{ 1.3600E+02, 6.400000E+01},
			{ 1.3700E+02, 8.600000E+01},{ 1.3800E+02, 7.900000E+01},{ 1.3900E+02, 6.600000E+01},{ 1.4000E+02, 6.000000E+01},
			{ 1.4100E+02, 6.300000E+01},{ 1.4200E+02, 6.900000E+01},{ 1.4300E+02, 6.300000E+01},{ 1.4400E+02, 6.700000E+01},
			{ 1.4500E+02, 6.400000E+01},{ 1.4600E+02, 6.800000E+01},{ 1.4700E+02, 7.200000E+01},{ 1.4800E+02, 6.600000E+01},
			{ 1.4900E+02, 5.800000E+01},{ 1.5000E+02, 6.100000E+01},{ 1.5100E+02, 5.800000E+01},{ 1.5200E+02, 7.000000E+01},
			{ 1.5300E+02, 6.100000E+01},{ 1.5400E+02, 7.300000E+01},{ 1.5500E+02, 5.900000E+01},{ 1.5600E+02, 5.400000E+01},
			{ 1.5700E+02, 6.200000E+01},{ 1.5800E+02, 5.600000E+01},{ 1.5900E+02, 4.800000E+01},{ 1.6000E+02, 4.800000E+01},
			{ 1.6100E+02, 4.700000E+01},{ 1.6200E+02, 5.600000E+01},{ 1.6300E+02, 6.400000E+01},{ 1.6400E+02, 3.400000E+01},
			{ 1.6500E+02, 4.800000E+01},{ 1.6600E+02, 5.400000E+01},{ 1.6700E+02, 5.800000E+01},{ 1.6800E+02, 6.600000E+01},
			{ 1.6900E+02, 9.200000E+01},{ 1.7000E+02, 8.700000E+01},{ 1.7100E+02, 7.300000E+01},{ 1.7200E+02, 6.800000E+01},
			{ 1.7300E+02, 7.800000E+01},{ 1.7400E+02, 8.700000E+01},{ 1.7500E+02, 6.600000E+01},{ 1.7600E+02, 5.800000E+01},
			{ 1.7700E+02, 6.000000E+01},{ 1.7800E+02, 6.500000E+01},{ 1.7900E+02, 6.100000E+01},{ 1.8000E+02, 5.700000E+01},
			{ 1.8100E+02, 5.500000E+01},{ 1.8200E+02, 6.500000E+01},{ 1.8300E+02, 8.400000E+01},{ 1.8400E+02, 8.000000E+01},
			{ 1.8500E+02, 8.200000E+01},{ 1.8600E+02, 9.000000E+01},{ 1.8700E+02, 6.300000E+01},{ 1.8800E+02, 7.000000E+01},
			{ 1.8900E+02, 7.300000E+01},{ 1.9000E+02, 4.800000E+01},{ 1.9100E+02, 6.400000E+01},{ 1.9200E+02, 5.800000E+01},
			{ 1.9300E+02, 6.900000E+01},{ 1.9400E+02, 7.200000E+01},{ 1.9500E+02, 5.800000E+01},{ 1.9600E+02, 4.900000E+01},
			{ 1.9700E+02, 5.500000E+01},{ 1.9800E+02, 5.600000E+01},{ 1.9900E+02, 5.600000E+01},{ 2.0000E+02, 6.700000E+01},
			{ 2.0100E+02, 6.300000E+01},{ 2.0200E+02, 5.400000E+01},{ 2.0300E+02, 6.200000E+01},{ 2.0400E+02, 6.100000E+01},
			{ 2.0500E+02, 5.300000E+01},{ 2.0600E+02, 8.100000E+01},{ 2.0700E+02, 8.700000E+01},{ 2.0800E+02, 7.200000E+01},
			{ 2.0900E+02, 6.100000E+01},{ 2.1000E+02, 8.400000E+01},{ 2.1100E+02, 7.600000E+01},{ 2.1200E+02, 6.700000E+01},
			{ 2.1300E+02, 6.300000E+01},{ 2.1400E+02, 5.700000E+01},{ 2.1500E+02, 7.100000E+01},{ 2.1600E+02, 6.300000E+01},
			{ 2.1700E+02, 4.400000E+01},{ 2.1800E+02, 4.600000E+01},{ 2.1900E+02, 6.700000E+01},{ 2.2000E+02, 7.300000E+01},
			{ 2.2100E+02, 8.900000E+01},{ 2.2200E+02, 6.500000E+01},{ 2.2300E+02, 5.600000E+01},{ 2.2400E+02, 6.500000E+01},
			{ 2.2500E+02, 6.900000E+01},{ 2.2600E+02, 8.000000E+01},{ 2.2700E+02, 8.300000E+01},{ 2.2800E+02, 6.800000E+01},
			{ 2.2900E+02, 6.800000E+01},{ 2.3000E+02, 7.400000E+01},{ 2.3100E+02, 7.600000E+01},{ 2.3200E+02, 8.200000E+01},
			{ 2.3300E+02, 7.200000E+01},{ 2.3400E+02, 6.600000E+01},{ 2.3500E+02, 6.800000E+01},{ 2.3600E+02, 7.200000E+01},
			{ 2.3700E+02, 7.400000E+01},{ 2.3800E+02, 7.300000E+01},{ 2.3900E+02, 8.100000E+01},{ 2.4000E+02, 7.300000E+01},
			{ 2.4100E+02, 6.800000E+01},{ 2.4200E+02, 6.700000E+01},{ 2.4300E+02, 6.000000E+01},{ 2.4400E+02, 5.100000E+01},
			{ 2.4500E+02, 6.000000E+01},{ 2.4600E+02, 6.800000E+01},{ 2.4700E+02, 7.700000E+01},{ 2.4800E+02, 7.000000E+01},
			{ 2.4900E+02, 7.000000E+01},{ 2.5000E+02, 6.700000E+01},{ 2.5100E+02, 6.400000E+01},{ 2.5200E+02, 6.300000E+01},
			{ 2.5300E+02, 6.600000E+01},{ 2.5400E+02, 6.000000E+01},{ 2.5500E+02, 5.800000E+01},{ 2.5600E+02, 6.600000E+01},
			{ 2.5700E+02, 7.800000E+01},{ 2.5800E+02, 7.900000E+01},{ 2.5900E+02, 7.200000E+01},{ 2.6000E+02, 6.800000E+01},
			{ 2.6100E+02, 8.500000E+01},{ 2.6200E+02, 8.100000E+01},{ 2.6300E+02, 5.900000E+01},{ 2.6400E+02, 5.600000E+01},
			{ 2.6500E+02, 6.300000E+01},{ 2.6600E+02, 7.600000E+01},{ 2.6700E+02, 7.800000E+01},{ 2.6800E+02, 8.900000E+01},
			{ 2.6900E+02, 6.300000E+01},{ 2.7000E+02, 5.500000E+01},{ 2.7100E+02, 6.200000E+01},{ 2.7200E+02, 6.400000E+01},
			{ 2.7300E+02, 6.300000E+01},{ 2.7400E+02, 7.700000E+01},{ 2.7500E+02, 7.500000E+01},{ 2.7600E+02, 7.800000E+01},
			{ 2.7700E+02, 7.500000E+01},{ 2.7800E+02, 8.300000E+01},{ 2.7900E+02, 6.200000E+01},{ 2.8000E+02, 5.000000E+01},
			{ 2.8100E+02, 5.000000E+01},{ 2.8200E+02, 5.700000E+01},{ 2.8300E+02, 7.700000E+01},{ 2.8400E+02, 8.600000E+01},
			{ 2.8500E+02, 7.900000E+01},{ 2.8600E+02, 7.000000E+01},{ 2.8700E+02, 7.300000E+01},{ 2.8800E+02, 8.300000E+01},
			{ 2.8900E+02, 6.400000E+01},{ 2.9000E+02, 7.700000E+01},{ 2.9100E+02, 6.000000E+01},{ 2.9200E+02, 6.500000E+01},
			{ 2.9300E+02, 5.900000E+01},{ 2.9400E+02, 7.000000E+01},{ 2.9500E+02, 7.500000E+01},{ 2.9600E+02, 8.600000E+01},
			{ 2.9700E+02, 8.700000E+01},{ 2.9800E+02, 8.900000E+01},{ 2.9900E+02, 9.600000E+01},{ 3.0000E+02, 9.600000E+01},
			{ 3.0100E+02, 6.300000E+01},{ 3.0200E+02, 5.200000E+01},{ 3.0300E+02, 3.700000E+01},{ 3.0400E+02, 4.300000E+01},
			{ 3.0500E+02, 7.400000E+01},{ 3.0600E+02, 6.600000E+01},{ 3.0700E+02, 5.200000E+01},{ 3.0800E+02, 4.600000E+01},
			{ 3.0900E+02, 4.600000E+01},{ 3.1000E+02, 5.800000E+01},{ 3.1100E+02, 6.300000E+01},{ 3.1200E+02, 5.500000E+01},
			{ 3.1300E+02, 4.900000E+01},{ 3.1400E+02, 7.700000E+01},{ 3.1500E+02, 8.300000E+01},{ 3.1600E+02, 7.200000E+01},
			{ 3.1700E+02, 7.400000E+01},{ 3.1800E+02, 7.100000E+01},{ 3.1900E+02, 6.200000E+01},{ 3.2000E+02, 6.000000E+01},
			{ 3.2100E+02, 4.700000E+01},{ 3.2200E+02, 6.500000E+01},{ 3.2300E+02, 6.800000E+01},{ 3.2400E+02, 7.500000E+01},
			{ 3.2500E+02, 8.100000E+01},{ 3.2600E+02, 9.700000E+01},{ 3.2700E+02, 8.400000E+01},{ 3.2800E+02, 6.900000E+01},
			{ 3.2900E+02, 5.300000E+01},{ 3.3000E+02, 5.800000E+01},{ 3.3100E+02, 6.900000E+01},{ 3.3200E+02, 6.400000E+01},
			{ 3.3300E+02, 4.700000E+01},{ 3.3400E+02, 7.600000E+01},{ 3.3500E+02, 9.800000E+01},{ 3.3600E+02, 9.300000E+01},
			{ 3.3700E+02, 9.800000E+01},{ 3.3800E+02, 5.700000E+01},{ 3.3900E+02, 5.400000E+01},{ 3.4000E+02, 5.100000E+01},
			{ 3.4100E+02, 6.800000E+01},{ 3.4200E+02, 7.200000E+01},{ 3.4300E+02, 8.500000E+01},{ 3.4400E+02, 8.100000E+01},
			{ 3.4500E+02, 8.600000E+01},{ 3.4600E+02, 9.000000E+01},{ 3.4700E+02, 7.900000E+01},{ 3.4800E+02, 7.500000E+01},
			{ 3.4900E+02, 3.600000E+01},{ 3.5000E+02, 4.400000E+01},{ 3.5100E+02, 5.600000E+01},{ 3.5200E+02, 4.400000E+01},
			{ 3.5300E+02, 3.800000E+01},{ 3.5400E+02, 4.600000E+01},{ 3.5500E+02, 4.800000E+01},{ 3.5600E+02, 5.600000E+01},
			{ 3.5700E+02, 8.000000E+01},{ 3.5800E+02, 6.400000E+01},{ 3.5900E+02, 6.300000E+01},{ 3.6000E+02, 7.600000E+01},
			{ 3.6100E+02, 7.100000E+01},{ 3.6200E+02, 7.800000E+01},{ 3.6300E+02, 9.100000E+01},{ 3.6400E+02, 6.700000E+01},
			{ 3.6500E+02, 6.300000E+01}, };
		return SL::Graph( 0, x, 364, g); 
	}

	inline double Graph57(double x) { 
		static double g[365][2] = {
			{ 1.0000E+00, 0.000000E+00},{ 2.0000E+00, 0.000000E+00},{ 3.0000E+00, 0.000000E+00},{ 4.0000E+00, 0.000000E+00},
			{ 5.0000E+00, 0.000000E+00},{ 6.0000E+00, 5.000000E-02},{ 7.0000E+00, 4.100000E-01},{ 8.0000E+00, 4.600000E-01},
			{ 9.0000E+00, 0.000000E+00},{ 1.0000E+01, 0.000000E+00},{ 1.1000E+01, 0.000000E+00},{ 1.2000E+01, 1.470000E+00},
			{ 1.3000E+01, 1.000000E-01},{ 1.4000E+01, 0.000000E+00},{ 1.5000E+01, 0.000000E+00},{ 1.6000E+01, 3.100000E-01},
			{ 1.7000E+01, 1.400000E-01},{ 1.8000E+01, 0.000000E+00},{ 1.9000E+01, 0.000000E+00},{ 2.0000E+01, 0.000000E+00},
			{ 2.1000E+01, 4.000000E-02},{ 2.2000E+01, 0.000000E+00},{ 2.3000E+01, 0.000000E+00},{ 2.4000E+01, 0.000000E+00},
			{ 2.5000E+01, 0.000000E+00},{ 2.6000E+01, 0.000000E+00},{ 2.7000E+01, 0.000000E+00},{ 2.8000E+01, 0.000000E+00},
			{ 2.9000E+01, 0.000000E+00},{ 3.0000E+01, 0.000000E+00},{ 3.1000E+01, 5.000000E-02},{ 3.2000E+01, 0.000000E+00},
			{ 3.3000E+01, 0.000000E+00},{ 3.4000E+01, 0.000000E+00},{ 3.5000E+01, 0.000000E+00},{ 3.6000E+01, 0.000000E+00},
			{ 3.7000E+01, 3.000000E-02},{ 3.8000E+01, 2.000000E-01},{ 3.9000E+01, 2.000000E-02},{ 4.0000E+01, 0.000000E+00},
			{ 4.1000E+01, 0.000000E+00},{ 4.2000E+01, 0.000000E+00},{ 4.3000E+01, 0.000000E+00},{ 4.4000E+01, 0.000000E+00},
			{ 4.5000E+01, 3.000000E-01},{ 4.6000E+01, 0.000000E+00},{ 4.7000E+01, 0.000000E+00},{ 4.8000E+01, 0.000000E+00},
			{ 4.9000E+01, 1.100000E-01},{ 5.0000E+01, 9.000000E-02},{ 5.1000E+01, 1.200000E-01},{ 5.2000E+01, 0.000000E+00},
			{ 5.3000E+01, 0.000000E+00},{ 5.4000E+01, 0.000000E+00},{ 5.5000E+01, 0.000000E+00},{ 5.6000E+01, 0.000000E+00},
			{ 5.7000E+01, 1.000000E-02},{ 5.8000E+01, 0.000000E+00},{ 5.9000E+01, 0.000000E+00},{ 6.0000E+01, 0.000000E+00},
			{ 6.1000E+01, 1.300000E-01},{ 6.2000E+01, 0.000000E+00},{ 6.3000E+01, 6.500000E-01},{ 6.4000E+01, 1.200000E-01},
			{ 6.5000E+01, 0.000000E+00},{ 6.6000E+01, 1.600000E-01},{ 6.7000E+01, 0.000000E+00},{ 6.8000E+01, 0.000000E+00},
			{ 6.9000E+01, 0.000000E+00},{ 7.0000E+01, 0.000000E+00},{ 7.1000E+01, 0.000000E+00},{ 7.2000E+01, 0.000000E+00},
			{ 7.3000E+01, 3.400000E-01},{ 7.4000E+01, 1.300000E-01},{ 7.5000E+01, 0.000000E+00},{ 7.6000E+01, 0.000000E+00},
			{ 7.7000E+01, 9.100000E-01},{ 7.8000E+01, 1.000000E-02},{ 7.9000E+01, 0.000000E+00},{ 8.0000E+01, 1.000000E-02},
			{ 8.1000E+01, 0.000000E+00},{ 8.2000E+01, 1.400000E+00},{ 8.3000E+01, 8.200000E-01},{ 8.4000E+01, 1.000000E-02},
			{ 8.5000E+01, 0.000000E+00},{ 8.6000E+01, 1.900000E-01},{ 8.7000E+01, 0.000000E+00},{ 8.8000E+01, 9.000000E-02},
			{ 8.9000E+01, 9.700000E-01},{ 9.0000E+01, 0.000000E+00},{ 9.1000E+01, 0.000000E+00},{ 9.2000E+01, 0.000000E+00},
			{ 9.3000E+01, 0.000000E+00},{ 9.4000E+01, 0.000000E+00},{ 9.5000E+01, 0.000000E+00},{ 9.6000E+01, 1.000000E-01},
			{ 9.7000E+01, 0.000000E+00},{ 9.8000E+01, 0.000000E+00},{ 9.9000E+01, 0.000000E+00},{ 1.0000E+02, 0.000000E+00},
			{ 1.0100E+02, 0.000000E+00},{ 1.0200E+02, 0.000000E+00},{ 1.0300E+02, 0.000000E+00},{ 1.0400E+02, 5.600000E-01},
			{ 1.0500E+02, 1.200000E-01},{ 1.0600E+02, 2.600000E-01},{ 1.0700E+02, 0.000000E+00},{ 1.0800E+02, 0.000000E+00},
			{ 1.0900E+02, 0.000000E+00},{ 1.1000E+02, 3.000000E-02},{ 1.1100E+02, 2.000000E-02},{ 1.1200E+02, 1.700000E-01},
			{ 1.1300E+02, 0.000000E+00},{ 1.1400E+02, 0.000000E+00},{ 1.1500E+02, 1.000000E-01},{ 1.1600E+02, 0.000000E+00},
			{ 1.1700E+02, 0.000000E+00},{ 1.1800E+02, 2.500000E-01},{ 1.1900E+02, 3.500000E-01},{ 1.2000E+02, 1.300000E-01},
			{ 1.2100E+02, 2.000000E-02},{ 1.2200E+02, 1.000000E-01},{ 1.2300E+02, 0.000000E+00},{ 1.2400E+02, 0.000000E+00},
			{ 1.2500E+02, 0.000000E+00},{ 1.2600E+02, 4.700000E-01},{ 1.2700E+02, 1.500000E-01},{ 1.2800E+02, 0.000000E+00},
			{ 1.2900E+02, 0.000000E+00},{ 1.3000E+02, 1.500000E-01},{ 1.3100E+02, 0.000000E+00},{ 1.3200E+02, 0.000000E+00},
			{ 1.3300E+02, 0.000000E+00},{ 1.3400E+02, 0.000000E+00},{ 1.3500E+02, 0.000000E+00},{ 1.3600E+02, 0.000000E+00},
			{ 1.3700E+02, 0.000000E+00},{ 1.3800E+02, 1.320000E+00},{ 1.3900E+02, 9.000000E-02},{ 1.4000E+02, 0.000000E+00},
			{ 1.4100E+02, 0.000000E+00},{ 1.4200E+02, 0.000000E+00},{ 1.4300E+02, 0.000000E+00},{ 1.4400E+02, 0.000000E+00},
			{ 1.4500E+02, 0.000000E+00},{ 1.4600E+02, 0.000000E+00},{ 1.4700E+02, 0.000000E+00},{ 1.4800E+02, 2.000000E-02},
			{ 1.4900E+02, 0.000000E+00},{ 1.5000E+02, 0.000000E+00},{ 1.5100E+02, 0.000000E+00},{ 1.5200E+02, 0.000000E+00},
			{ 1.5300E+02, 3.300000E-01},{ 1.5400E+02, 0.000000E+00},{ 1.5500E+02, 0.000000E+00},{ 1.5600E+02, 0.000000E+00},
			{ 1.5700E+02, 0.000000E+00},{ 1.5800E+02, 0.000000E+00},{ 1.5900E+02, 0.000000E+00},{ 1.6000E+02, 0.000000E+00},
			{ 1.6100E+02, 0.000000E+00},{ 1.6200E+02, 0.000000E+00},{ 1.6300E+02, 0.000000E+00},{ 1.6400E+02, 0.000000E+00},
			{ 1.6500E+02, 0.000000E+00},{ 1.6600E+02, 0.000000E+00},{ 1.6700E+02, 0.000000E+00},{ 1.6800E+02, 0.000000E+00},
			{ 1.6900E+02, 1.190000E+00},{ 1.7000E+02, 9.000000E-02},{ 1.7100E+02, 0.000000E+00},{ 1.7200E+02, 0.000000E+00},
			{ 1.7300E+02, 0.000000E+00},{ 1.7400E+02, 3.000000E-01},{ 1.7500E+02, 7.000000E-02},{ 1.7600E+02, 0.000000E+00},
			{ 1.7700E+02, 0.000000E+00},{ 1.7800E+02, 0.000000E+00},{ 1.7900E+02, 0.000000E+00},{ 1.8000E+02, 0.000000E+00},
			{ 1.8100E+02, 0.000000E+00},{ 1.8200E+02, 0.000000E+00},{ 1.8300E+02, 0.000000E+00},{ 1.8400E+02, 5.500000E-01},
			{ 1.8500E+02, 0.000000E+00},{ 1.8600E+02, 3.000000E-02},{ 1.8700E+02, 3.000000E-02},{ 1.8800E+02, 0.000000E+00},
			{ 1.8900E+02, 3.400000E-01},{ 1.9000E+02, 2.900000E-01},{ 1.9100E+02, 2.000000E-02},{ 1.9200E+02, 3.000000E-02},
			{ 1.9300E+02, 0.000000E+00},{ 1.9400E+02, 6.000000E-02},{ 1.9500E+02, 0.000000E+00},{ 1.9600E+02, 0.000000E+00},
			{ 1.9700E+02, 0.000000E+00},{ 1.9800E+02, 0.000000E+00},{ 1.9900E+02, 0.000000E+00},{ 2.0000E+02, 0.000000E+00},
			{ 2.0100E+02, 0.000000E+00},{ 2.0200E+02, 0.000000E+00},{ 2.0300E+02, 1.000000E-01},{ 2.0400E+02, 0.000000E+00},
			{ 2.0500E+02, 3.800000E-01},{ 2.0600E+02, 1.990000E+00},{ 2.0700E+02, 8.000000E-02},{ 2.0800E+02, 1.500000E-01},
			{ 2.0900E+02, 0.000000E+00},{ 2.1000E+02, 1.700000E-01},{ 2.1100E+02, 1.900000E-01},{ 2.1200E+02, 0.000000E+00},
			{ 2.1300E+02, 0.000000E+00},{ 2.1400E+02, 0.000000E+00},{ 2.1500E+02, 0.000000E+00},{ 2.1600E+02, 0.000000E+00},
			{ 2.1700E+02, 0.000000E+00},{ 2.1800E+02, 0.000000E+00},{ 2.1900E+02, 0.000000E+00},{ 2.2000E+02, 0.000000E+00},
			{ 2.2100E+02, 1.150000E+00},{ 2.2200E+02, 3.900000E-01},{ 2.2300E+02, 0.000000E+00},{ 2.2400E+02, 0.000000E+00},
			{ 2.2500E+02, 0.000000E+00},{ 2.2600E+02, 0.000000E+00},{ 2.2700E+02, 2.000000E-02},{ 2.2800E+02, 5.200000E-01},
			{ 2.2900E+02, 0.000000E+00},{ 2.3000E+02, 0.000000E+00},{ 2.3100E+02, 0.000000E+00},{ 2.3200E+02, 8.000000E-02},
			{ 2.3300E+02, 8.900000E-01},{ 2.3400E+02, 0.000000E+00},{ 2.3500E+02, 0.000000E+00},{ 2.3600E+02, 0.000000E+00},
			{ 2.3700E+02, 0.000000E+00},{ 2.3800E+02, 0.000000E+00},{ 2.3900E+02, 0.000000E+00},{ 2.4000E+02, 2.200000E-01},
			{ 2.4100E+02, 0.000000E+00},{ 2.4200E+02, 0.000000E+00},{ 2.4300E+02, 0.000000E+00},{ 2.4400E+02, 0.000000E+00},
			{ 2.4500E+02, 0.000000E+00},{ 2.4600E+02, 0.000000E+00},{ 2.4700E+02, 0.000000E+00},{ 2.4800E+02, 5.100000E-01},
			{ 2.4900E+02, 2.000000E-02},{ 2.5000E+02, 0.000000E+00},{ 2.5100E+02, 0.000000E+00},{ 2.5200E+02, 0.000000E+00},
			{ 2.5300E+02, 0.000000E+00},{ 2.5400E+02, 0.000000E+00},{ 2.5500E+02, 0.000000E+00},{ 2.5600E+02, 0.000000E+00},
			{ 2.5700E+02, 4.000000E-02},{ 2.5800E+02, 0.000000E+00},{ 2.5900E+02, 0.000000E+00},{ 2.6000E+02, 0.000000E+00},
			{ 2.6100E+02, 3.400000E-01},{ 2.6200E+02, 0.000000E+00},{ 2.6300E+02, 2.000000E-01},{ 2.6400E+02, 0.000000E+00},
			{ 2.6500E+02, 0.000000E+00},{ 2.6600E+02, 0.000000E+00},{ 2.6700E+02, 3.000000E-02},{ 2.6800E+02, 1.060000E+00},
			{ 2.6900E+02, 3.900000E-01},{ 2.7000E+02, 0.000000E+00},{ 2.7100E+02, 0.000000E+00},{ 2.7200E+02, 0.000000E+00},
			{ 2.7300E+02, 0.000000E+00},{ 2.7400E+02, 0.000000E+00},{ 2.7500E+02, 0.000000E+00},{ 2.7600E+02, 3.000000E-02},
			{ 2.7700E+02, 0.000000E+00},{ 2.7800E+02, 0.000000E+00},{ 2.7900E+02, 1.280000E+00},{ 2.8000E+02, 0.000000E+00},
			{ 2.8100E+02, 0.000000E+00},{ 2.8200E+02, 0.000000E+00},{ 2.8300E+02, 0.000000E+00},{ 2.8400E+02, 0.000000E+00},
			{ 2.8500E+02, 0.000000E+00},{ 2.8600E+02, 0.000000E+00},{ 2.8700E+02, 1.600000E-01},{ 2.8800E+02, 0.000000E+00},
			{ 2.8900E+02, 3.300000E-01},{ 2.9000E+02, 1.900000E-01},{ 2.9100E+02, 1.330000E+00},{ 2.9200E+02, 0.000000E+00},
			{ 2.9300E+02, 0.000000E+00},{ 2.9400E+02, 0.000000E+00},{ 2.9500E+02, 0.000000E+00},{ 2.9600E+02, 0.000000E+00},
			{ 2.9700E+02, 0.000000E+00},{ 2.9800E+02, 2.000000E-02},{ 2.9900E+02, 0.000000E+00},{ 3.0000E+02, 0.000000E+00},
			{ 3.0100E+02, 2.000000E-02},{ 3.0200E+02, 0.000000E+00},{ 3.0300E+02, 0.000000E+00},{ 3.0400E+02, 0.000000E+00},
			{ 3.0500E+02, 0.000000E+00},{ 3.0600E+02, 0.000000E+00},{ 3.0700E+02, 0.000000E+00},{ 3.0800E+02, 0.000000E+00},
			{ 3.0900E+02, 0.000000E+00},{ 3.1000E+02, 0.000000E+00},{ 3.1100E+02, 0.000000E+00},{ 3.1200E+02, 0.000000E+00},
			{ 3.1300E+02, 0.000000E+00},{ 3.1400E+02, 3.000000E-02},{ 3.1500E+02, 2.000000E-02},{ 3.1600E+02, 2.000000E-01},
			{ 3.1700E+02, 6.000000E-02},{ 3.1800E+02, 0.000000E+00},{ 3.1900E+02, 0.000000E+00},{ 3.2000E+02, 0.000000E+00},
			{ 3.2100E+02, 0.000000E+00},{ 3.2200E+02, 0.000000E+00},{ 3.2300E+02, 0.000000E+00},{ 3.2400E+02, 0.000000E+00},
			{ 3.2500E+02, 0.000000E+00},{ 3.2600E+02, 5.600000E-01},{ 3.2700E+02, 7.200000E-01},{ 3.2800E+02, 0.000000E+00},
			{ 3.2900E+02, 0.000000E+00},{ 3.3000E+02, 0.000000E+00},{ 3.3100E+02, 0.000000E+00},{ 3.3200E+02, 0.000000E+00},
			{ 3.3300E+02, 0.000000E+00},{ 3.3400E+02, 0.000000E+00},{ 3.3500E+02, 4.100000E-01},{ 3.3600E+02, 3.400000E-01},
			{ 3.3700E+02, 9.200000E-01},{ 3.3800E+02, 5.100000E-01},{ 3.3900E+02, 0.000000E+00},{ 3.4000E+02, 0.000000E+00},
			{ 3.4100E+02, 0.000000E+00},{ 3.4200E+02, 0.000000E+00},{ 3.4300E+02, 4.000000E-02},{ 3.4400E+02, 1.200000E+00},
			{ 3.4500E+02, 0.000000E+00},{ 3.4600E+02, 0.000000E+00},{ 3.4700E+02, 1.000000E-02},{ 3.4800E+02, 2.300000E-01},
			{ 3.4900E+02, 5.000000E-02},{ 3.5000E+02, 0.000000E+00},{ 3.5100E+02, 0.000000E+00},{ 3.5200E+02, 0.000000E+00},
			{ 3.5300E+02, 0.000000E+00},{ 3.5400E+02, 0.000000E+00},{ 3.5500E+02, 1.000000E-02},{ 3.5600E+02, 0.000000E+00},
			{ 3.5700E+02, 0.000000E+00},{ 3.5800E+02, 2.200000E-01},{ 3.5900E+02, 0.000000E+00},{ 3.6000E+02, 0.000000E+00},
			{ 3.6100E+02, 0.000000E+00},{ 3.6200E+02, 1.000000E-02},{ 3.6300E+02, 8.800000E-01},{ 3.6400E+02, 1.200000E-01},
			{ 3.6500E+02, 0.000000E+00}, };
		return SL::Graph( 0, x, 364, g); 
	}

	inline double Graph58(double x) { 
		static double g[365][2] = {
			{ 1.0000E+00, 1.290000E+02},{ 2.0000E+00, 1.130000E+02},{ 3.0000E+00, 1.480000E+02},{ 4.0000E+00, 1.600000E+02},
			{ 5.0000E+00, 1.020000E+02},{ 6.0000E+00, 6.600000E+01},{ 7.0000E+00, 1.790000E+02},{ 8.0000E+00, 2.250000E+02},
			{ 9.0000E+00, 1.860000E+02},{ 1.0000E+01, 2.010000E+02},{ 1.1000E+01, 3.100000E+02},{ 1.2000E+01, 1.600000E+02},
			{ 1.3000E+01, 2.590000E+02},{ 1.4000E+01, 1.420000E+02},{ 1.5000E+01, 1.100000E+02},{ 1.6000E+01, 1.610000E+02},
			{ 1.7000E+01, 3.240000E+02},{ 1.8000E+01, 2.820000E+02},{ 1.9000E+01, 1.860000E+02},{ 2.0000E+01, 1.650000E+02},
			{ 2.1000E+01, 3.010000E+02},{ 2.2000E+01, 2.330000E+02},{ 2.3000E+01, 2.020000E+02},{ 2.4000E+01, 2.240000E+02},
			{ 2.5000E+01, 1.780000E+02},{ 2.6000E+01, 1.540000E+02},{ 2.7000E+01, 1.890000E+02},{ 2.8000E+01, 1.630000E+02},
			{ 2.9000E+01, 1.220000E+02},{ 3.0000E+01, 8.400000E+01},{ 3.1000E+01, 4.050000E+02},{ 3.2000E+01, 1.680000E+02},
			{ 3.3000E+01, 1.240000E+02},{ 3.4000E+01, 1.660000E+02},{ 3.5000E+01, 1.130000E+02},{ 3.6000E+01, 1.130000E+02},
			{ 3.7000E+01, 1.080000E+02},{ 3.8000E+01, 1.690000E+02},{ 3.9000E+01, 2.300000E+02},{ 4.0000E+01, 1.690000E+02},
			{ 4.1000E+01, 1.700000E+02},{ 4.2000E+01, 2.540000E+02},{ 4.3000E+01, 1.930000E+02},{ 4.4000E+01, 1.220000E+02},
			{ 4.5000E+01, 2.690000E+02},{ 4.6000E+01, 3.960000E+02},{ 4.7000E+01, 3.420000E+02},{ 4.8000E+01, 1.430000E+02},
			{ 4.9000E+01, 1.010000E+02},{ 5.0000E+01, 1.590000E+02},{ 5.1000E+01, 2.950000E+02},{ 5.2000E+01, 1.550000E+02},
			{ 5.3000E+01, 3.000000E+02},{ 5.4000E+01, 2.190000E+02},{ 5.5000E+01, 9.100000E+01},{ 5.6000E+01, 1.720000E+02},
			{ 5.7000E+01, 2.080000E+02},{ 5.8000E+01, 2.180000E+02},{ 5.9000E+01, 1.630000E+02},{ 6.0000E+01, 2.030000E+02},
			{ 6.1000E+01, 2.830000E+02},{ 6.2000E+01, 2.020000E+02},{ 6.3000E+01, 2.880000E+02},{ 6.4000E+01, 2.010000E+02},
			{ 6.5000E+01, 1.490000E+02},{ 6.6000E+01, 3.010000E+02},{ 6.7000E+01, 2.190000E+02},{ 6.8000E+01, 1.580000E+02},
			{ 6.9000E+01, 2.460000E+02},{ 7.0000E+01, 3.080000E+02},{ 7.1000E+01, 2.260000E+02},{ 7.2000E+01, 2.070000E+02},
			{ 7.3000E+01, 2.360000E+02},{ 7.4000E+01, 2.300000E+02},{ 7.5000E+01, 1.790000E+02},{ 7.6000E+01, 1.670000E+02},
			{ 7.7000E+01, 1.590000E+02},{ 7.8000E+01, 3.520000E+02},{ 7.9000E+01, 2.280000E+02},{ 8.0000E+01, 1.650000E+02},
			{ 8.1000E+01, 1.700000E+02},{ 8.2000E+01, 1.760000E+02},{ 8.3000E+01, 1.930000E+02},{ 8.4000E+01, 2.580000E+02},
			{ 8.5000E+01, 1.590000E+02},{ 8.6000E+01, 1.550000E+02},{ 8.7000E+01, 3.640000E+02},{ 8.8000E+01, 1.350000E+02},
			{ 8.9000E+01, 3.190000E+02},{ 9.0000E+01, 1.620000E+02},{ 9.1000E+01, 2.030000E+02},{ 9.2000E+01, 1.930000E+02},
			{ 9.3000E+01, 1.190000E+02},{ 9.4000E+01, 1.860000E+02},{ 9.5000E+01, 1.560000E+02},{ 9.6000E+01, 1.770000E+02},
			{ 9.7000E+01, 1.930000E+02},{ 9.8000E+01, 1.580000E+02},{ 9.9000E+01, 2.380000E+02},{ 1.0000E+02, 2.980000E+02},
			{ 1.0100E+02, 2.690000E+02},{ 1.0200E+02, 1.720000E+02},{ 1.0300E+02, 1.380000E+02},{ 1.0400E+02, 2.310000E+02},
			{ 1.0500E+02, 1.300000E+02},{ 1.0600E+02, 2.230000E+02},{ 1.0700E+02, 1.830000E+02},{ 1.0800E+02, 2.450000E+02},
			{ 1.0900E+02, 2.500000E+02},{ 1.1000E+02, 2.250000E+02},{ 1.1100E+02, 2.790000E+02},{ 1.1200E+02, 2.970000E+02},
			{ 1.1300E+02, 1.790000E+02},{ 1.1400E+02, 1.840000E+02},{ 1.1500E+02, 1.600000E+02},{ 1.1600E+02, 1.450000E+02},
			{ 1.1700E+02, 1.130000E+02},{ 1.1800E+02, 1.900000E+02},{ 1.1900E+02, 1.700000E+02},{ 1.2000E+02, 1.150000E+02},
			{ 1.2100E+02, 1.840000E+02},{ 1.2200E+02, 2.420000E+02},{ 1.2300E+02, 2.460000E+02},{ 1.2400E+02, 1.440000E+02},
			{ 1.2500E+02, 1.730000E+02},{ 1.2600E+02, 1.630000E+02},{ 1.2700E+02, 1.870000E+02},{ 1.2800E+02, 1.640000E+02},
			{ 1.2900E+02, 1.260000E+02},{ 1.3000E+02, 1.510000E+02},{ 1.3100E+02, 1.590000E+02},{ 1.3200E+02, 1.600000E+02},
			{ 1.3300E+02, 1.790000E+02},{ 1.3400E+02, 1.960000E+02},{ 1.3500E+02, 1.580000E+02},{ 1.3600E+02, 1.550000E+02},
			{ 1.3700E+02, 1.710000E+02},{ 1.3800E+02, 2.500000E+02},{ 1.3900E+02, 1.610000E+02},{ 1.4000E+02, 1.400000E+02},
			{ 1.4100E+02, 1.690000E+02},{ 1.4200E+02, 1.530000E+02},{ 1.4300E+02, 1.230000E+02},{ 1.4400E+02, 1.800000E+02},
			{ 1.4500E+02, 1.730000E+02},{ 1.4600E+02, 1.650000E+02},{ 1.4700E+02, 2.070000E+02},{ 1.4800E+02, 1.930000E+02},
			{ 1.4900E+02, 1.850000E+02},{ 1.5000E+02, 1.620000E+02},{ 1.5100E+02, 1.990000E+02},{ 1.5200E+02, 1.800000E+02},
			{ 1.5300E+02, 1.460000E+02},{ 1.5400E+02, 1.250000E+02},{ 1.5500E+02, 2.990000E+02},{ 1.5600E+02, 2.030000E+02},
			{ 1.5700E+02, 1.300000E+02},{ 1.5800E+02, 1.460000E+02},{ 1.5900E+02, 2.000000E+02},{ 1.6000E+02, 1.840000E+02},
			{ 1.6100E+02, 1.910000E+02},{ 1.6200E+02, 2.120000E+02},{ 1.6300E+02, 1.960000E+02},{ 1.6400E+02, 2.340000E+02},
			{ 1.6500E+02, 1.490000E+02},{ 1.6600E+02, 1.420000E+02},{ 1.6700E+02, 2.130000E+02},{ 1.6800E+02, 1.630000E+02},
			{ 1.6900E+02, 2.590000E+02},{ 1.7000E+02, 1.320000E+02},{ 1.7100E+02, 1.090000E+02},{ 1.7200E+02, 1.370000E+02},
			{ 1.7300E+02, 1.650000E+02},{ 1.7400E+02, 1.940000E+02},{ 1.7500E+02, 1.390000E+02},{ 1.7600E+02, 1.860000E+02},
			{ 1.7700E+02, 1.310000E+02},{ 1.7800E+02, 1.470000E+02},{ 1.7900E+02, 1.740000E+02},{ 1.8000E+02, 2.060000E+02},
			{ 1.8100E+02, 2.070000E+02},{ 1.8200E+02, 1.940000E+02},{ 1.8300E+02, 1.450000E+02},{ 1.8400E+02, 1.790000E+02},
			{ 1.8500E+02, 2.140000E+02},{ 1.8600E+02, 1.350000E+02},{ 1.8700E+02, 1.530000E+02},{ 1.8800E+02, 1.810000E+02},
			{ 1.8900E+02, 2.010000E+02},{ 1.9000E+02, 2.120000E+02},{ 1.9100E+02, 1.460000E+02},{ 1.9200E+02, 1.620000E+02},
			{ 1.9300E+02, 1.450000E+02},{ 1.9400E+02, 2.130000E+02},{ 1.9500E+02, 1.970000E+02},{ 1.9600E+02, 1.590000E+02},
			{ 1.9700E+02, 1.240000E+02},{ 1.9800E+02, 2.020000E+02},{ 1.9900E+02, 1.640000E+02},{ 2.0000E+02, 1.680000E+02},
			{ 2.0100E+02, 1.430000E+02},{ 2.0200E+02, 2.180000E+02},{ 2.0300E+02, 1.660000E+02},{ 2.0400E+02, 2.320000E+02},
			{ 2.0500E+02, 1.850000E+02},{ 2.0600E+02, 1.210000E+02},{ 2.0700E+02, 1.240000E+02},{ 2.0800E+02, 1.700000E+02},
			{ 2.0900E+02, 1.550000E+02},{ 2.1000E+02, 1.520000E+02},{ 2.1100E+02, 9.600000E+01},{ 2.1200E+02, 1.070000E+02},
			{ 2.1300E+02, 1.740000E+02},{ 2.1400E+02, 1.710000E+02},{ 2.1500E+02, 1.250000E+02},{ 2.1600E+02, 1.950000E+02},
			{ 2.1700E+02, 2.340000E+02},{ 2.1800E+02, 1.670000E+02},{ 2.1900E+02, 9.500000E+01},{ 2.2000E+02, 1.240000E+02},
			{ 2.2100E+02, 1.760000E+02},{ 2.2200E+02, 1.780000E+02},{ 2.2300E+02, 1.670000E+02},{ 2.2400E+02, 1.410000E+02},
			{ 2.2500E+02, 1.120000E+02},{ 2.2600E+02, 1.640000E+02},{ 2.2700E+02, 1.360000E+02},{ 2.2800E+02, 1.780000E+02},
			{ 2.2900E+02, 1.930000E+02},{ 2.3000E+02, 2.010000E+02},{ 2.3100E+02, 2.080000E+02},{ 2.3200E+02, 1.340000E+02},
			{ 2.3300E+02, 1.740000E+02},{ 2.3400E+02, 1.290000E+02},{ 2.3500E+02, 1.330000E+02},{ 2.3600E+02, 1.090000E+02},
			{ 2.3700E+02, 2.250000E+02},{ 2.3800E+02, 1.620000E+02},{ 2.3900E+02, 1.230000E+02},{ 2.4000E+02, 1.470000E+02},
			{ 2.4100E+02, 1.140000E+02},{ 2.4200E+02, 1.410000E+02},{ 2.4300E+02, 2.220000E+02},{ 2.4400E+02, 2.540000E+02},
			{ 2.4500E+02, 1.240000E+02},{ 2.4600E+02, 1.690000E+02},{ 2.4700E+02, 1.780000E+02},{ 2.4800E+02, 1.440000E+02},
			{ 2.4900E+02, 1.220000E+02},{ 2.5000E+02, 1.140000E+02},{ 2.5100E+02, 1.070000E+02},{ 2.5200E+02, 1.400000E+02},
			{ 2.5300E+02, 1.800000E+02},{ 2.5400E+02, 1.850000E+02},{ 2.5500E+02, 1.280000E+02},{ 2.5600E+02, 9.500000E+01},
			{ 2.5700E+02, 1.520000E+02},{ 2.5800E+02, 1.420000E+02},{ 2.5900E+02, 1.620000E+02},{ 2.6000E+02, 2.030000E+02},
			{ 2.6100E+02, 1.360000E+02},{ 2.6200E+02, 1.890000E+02},{ 2.6300E+02, 1.900000E+02},{ 2.6400E+02, 1.530000E+02},
			{ 2.6500E+02, 1.230000E+02},{ 2.6600E+02, 1.400000E+02},{ 2.6700E+02, 1.430000E+02},{ 2.6800E+02, 1.420000E+02},
			{ 2.6900E+02, 1.880000E+02},{ 2.7000E+02, 1.330000E+02},{ 2.7100E+02, 1.210000E+02},{ 2.7200E+02, 1.530000E+02},
			{ 2.7300E+02, 1.830000E+02},{ 2.7400E+02, 1.420000E+02},{ 2.7500E+02, 1.600000E+02},{ 2.7600E+02, 1.100000E+02},
			{ 2.7700E+02, 1.150000E+02},{ 2.7800E+02, 1.620000E+02},{ 2.7900E+02, 2.310000E+02},{ 2.8000E+02, 1.650000E+02},
			{ 2.8100E+02, 1.420000E+02},{ 2.8200E+02, 1.250000E+02},{ 2.8300E+02, 1.320000E+02},{ 2.8400E+02, 1.170000E+02},
			{ 2.8500E+02, 1.250000E+02},{ 2.8600E+02, 1.790000E+02},{ 2.8700E+02, 1.390000E+02},{ 2.8800E+02, 1.380000E+02},
			{ 2.8900E+02, 2.200000E+02},{ 2.9000E+02, 2.770000E+02},{ 2.9100E+02, 1.620000E+02},{ 2.9200E+02, 1.780000E+02},
			{ 2.9300E+02, 1.480000E+02},{ 2.9400E+02, 1.260000E+02},{ 2.9500E+02, 8.000000E+01},{ 2.9600E+02, 1.080000E+02},
			{ 2.9700E+02, 9.700000E+01},{ 2.9800E+02, 9.200000E+01},{ 2.9900E+02, 7.000000E+01},{ 3.0000E+02, 7.000000E+01},
			{ 3.0100E+02, 2.240000E+02},{ 3.0200E+02, 1.580000E+02},{ 3.0300E+02, 2.060000E+02},{ 3.0400E+02, 2.190000E+02},
			{ 3.0500E+02, 1.170000E+02},{ 3.0600E+02, 1.800000E+02},{ 3.0700E+02, 1.630000E+02},{ 3.0800E+02, 2.310000E+02},
			{ 3.0900E+02, 1.420000E+02},{ 3.1000E+02, 1.070000E+02},{ 3.1100E+02, 9.500000E+01},{ 3.1200E+02, 2.630000E+02},
			{ 3.1300E+02, 2.730000E+02},{ 3.1400E+02, 2.790000E+02},{ 3.1500E+02, 2.400000E+02},{ 3.1600E+02, 1.620000E+02},
			{ 3.1700E+02, 1.690000E+02},{ 3.1800E+02, 1.040000E+02},{ 3.1900E+02, 9.400000E+01},{ 3.2000E+02, 2.130000E+02},
			{ 3.2100E+02, 1.730000E+02},{ 3.2200E+02, 1.200000E+02},{ 3.2300E+02, 9.000000E+01},{ 3.2400E+02, 2.250000E+02},
			{ 3.2500E+02, 2.380000E+02},{ 3.2600E+02, 1.770000E+02},{ 3.2700E+02, 1.620000E+02},{ 3.2800E+02, 2.500000E+02},
			{ 3.2900E+02, 2.530000E+02},{ 3.3000E+02, 1.870000E+02},{ 3.3100E+02, 1.460000E+02},{ 3.3200E+02, 9.500000E+01},
			{ 3.3300E+02, 1.700000E+02},{ 3.3400E+02, 2.610000E+02},{ 3.3500E+02, 1.270000E+02},{ 3.3600E+02, 2.040000E+02},
			{ 3.3700E+02, 1.800000E+02},{ 3.3800E+02, 3.780000E+02},{ 3.3900E+02, 2.100000E+02},{ 3.4000E+02, 2.190000E+02},
			{ 3.4100E+02, 1.350000E+02},{ 3.4200E+02, 1.490000E+02},{ 3.4300E+02, 1.570000E+02},{ 3.4400E+02, 1.810000E+02},
			{ 3.4500E+02, 9.500000E+01},{ 3.4600E+02, 8.400000E+01},{ 3.4700E+02, 2.160000E+02},{ 3.4800E+02, 2.990000E+02},
			{ 3.4900E+02, 3.060000E+02},{ 3.5000E+02, 2.660000E+02},{ 3.5100E+02, 1.340000E+02},{ 3.5200E+02, 2.880000E+02},
			{ 3.5300E+02, 2.490000E+02},{ 3.5400E+02, 1.210000E+02},{ 3.5500E+02, 2.590000E+02},{ 3.5600E+02, 1.760000E+02},
			{ 3.5700E+02, 1.050000E+02},{ 3.5800E+02, 2.190000E+02},{ 3.5900E+02, 2.090000E+02},{ 3.6000E+02, 1.120000E+02},
			{ 3.6100E+02, 1.450000E+02},{ 3.6200E+02, 8.900000E+01},{ 3.6300E+02, 1.580000E+02},{ 3.6400E+02, 2.630000E+02},
			{ 3.6500E+02, 1.480000E+02}, };
		return SL::Graph( 0, x, 364, g); 
	}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int AIR_TEMP_C_u395_exe_g(Variable* obj) { return GLOBALS_module::I().AIR_TEMP_C_u395_exe(); }
int AMPL_u396_exe_g(Variable* obj) { return GLOBALS_module::I().AMPL_u396_exe(); }
int CELL_SIZE_u397_exe_g(Variable* obj) { return GLOBALS_module::I().CELL_SIZE_u397_exe(); }
int CLOUDY_u398_exe_g(Variable* obj) { return GLOBALS_module::I().CLOUDY_u398_exe(); }
int DAYJUL_u399_exe_g(Variable* obj) { return GLOBALS_module::I().DAYJUL_u399_exe(); }
int DAYLENGTH_u400_exe_g(Variable* obj) { return GLOBALS_module::I().DAYLENGTH_u400_exe(); }
int ELEVATION_u401_exe_g(Variable* obj) { return GLOBALS_module::I().ELEVATION_u401_exe(); }
int ELEV_MIN_u402_exe_g(Variable* obj) { return GLOBALS_module::I().ELEV_MIN_u402_exe(); }
int HABITATMAP_u403_exe_g(Variable* obj) { return GLOBALS_module::I().HABITATMAP_u403_exe(); }
int HYDRO_u404_exe_g(Variable* obj) { return GLOBALS_module::I().HYDRO_u404_exe(); }
int LENGTH_u405_exe_g(Variable* obj) { return GLOBALS_module::I().LENGTH_u405_exe(); }
int ON_MAP_u406_exe_g(Variable* obj) { return GLOBALS_module::I().ON_MAP_u406_exe(); }
int PAR_u407_exe_g(Variable* obj) { return GLOBALS_module::I().PAR_u407_exe(); }
int PAR_G_u408_exe_g(Variable* obj) { return GLOBALS_module::I().PAR_G_u408_exe(); }
int PRECIP_M_u409_exe_g(Variable* obj) { return GLOBALS_module::I().PRECIP_M_u409_exe(); }
int ROADS_u410_exe_g(Variable* obj) { return GLOBALS_module::I().ROADS_u410_exe(); }
int SOIL_u411_exe_g(Variable* obj) { return GLOBALS_module::I().SOIL_u411_exe(); }
int VAP_PRESS_u412_exe_g(Variable* obj) { return GLOBALS_module::I().VAP_PRESS_u412_exe(); }
int VAP_SAT_DEFICIT_u413_exe_g(Variable* obj) { return GLOBALS_module::I().VAP_SAT_DEFICIT_u413_exe(); }
int WIND_u414_exe_g(Variable* obj) { return GLOBALS_module::I().WIND_u414_exe(); }
int P1_C_LATDEG_u415_exe_g(Variable* obj) { return GLOBALS_module::I().P1_C_LATDEG_u415_exe(); }
int P1_C_SURF_DELTA_u416_exe_g(Variable* obj) { return GLOBALS_module::I().P1_C_SURF_DELTA_u416_exe(); }
int P1_DATUM_TO_MSL_u417_exe_g(Variable* obj) { return GLOBALS_module::I().P1_DATUM_TO_MSL_u417_exe(); }
int P1_DEPTH_MSL_MAP_u418_exe_g(Variable* obj) { return GLOBALS_module::I().P1_DEPTH_MSL_MAP_u418_exe(); }
int P1_ELEV_MSL_MAP_u419_exe_g(Variable* obj) { return GLOBALS_module::I().P1_ELEV_MSL_MAP_u419_exe(); }
int P1_POP_DENS_u420_exe_g(Variable* obj) { return GLOBALS_module::I().P1_POP_DENS_u420_exe(); }
int P1_RAD_CONV_u421_exe_g(Variable* obj) { return GLOBALS_module::I().P1_RAD_CONV_u421_exe(); }
int P1_RAIN_CONV_u422_exe_g(Variable* obj) { return GLOBALS_module::I().P1_RAIN_CONV_u422_exe(); }
int P1_SEWERMAP_u423_exe_g(Variable* obj) { return GLOBALS_module::I().P1_SEWERMAP_u423_exe(); }
int P1_WIND_CONV_u424_exe_g(Variable* obj) { return GLOBALS_module::I().P1_WIND_CONV_u424_exe(); }
int AIR_TEMP_MAX_u425_exe_g(Variable* obj) { return GLOBALS_module::I().AIR_TEMP_MAX_u425_exe(); }
int AIR_TEMP_MIN_u426_exe_g(Variable* obj) { return GLOBALS_module::I().AIR_TEMP_MIN_u426_exe(); }
int HUMIDITY_u427_exe_g(Variable* obj) { return GLOBALS_module::I().HUMIDITY_u427_exe(); }
int PRECIPITATION_u428_exe_g(Variable* obj) { return GLOBALS_module::I().PRECIPITATION_u428_exe(); }
int WIND_SPEED_u429_exe_g(Variable* obj) { return GLOBALS_module::I().WIND_SPEED_u429_exe(); }

#endif
