#ifndef __ModelEqns__
#define __ModelEqns__

#include "SpaceSim.h"

// ---------------------------------------------------------------------------
//                    Class GrBay_module 
// ---------------------------------------------------------------------------

int kA__Wildcard = -99;

class GrBay_module : public TModule {
protected:

	GrBay_module(char* name);

public:

	TTime TIME;
protected:

	static GrBay_module* fInstance;
	static GrBay_module* kNullModel;
public:
	inline static GrBay_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new GrBay_module("GrBay_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (GrBay_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize();
	int MakeConnections();
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit();
};


// ---------------------------------------------------------------------------
//                    Class CONSUMERS_module 
// ---------------------------------------------------------------------------

class CONSUMERS_module : public TModule {
protected:

	CONSUMERS_module(char* name);

public:

	TTime TIME;
	CAuxVariable P1_CELL_SIZE;
	CStateVariable EPIPHYTES;
	CStateVariable ROOTSRHY;
	CStateVariable SHOOTS;
	CStateVariable PHYTOPLANKTON;
	CStateVariable SEAWEEDS;
	CStateVariable WRACK;
	CAuxVariable P1_IC_MAC_PHBIO;
	CAuxVariable P1_SEPT_TO_JAN_CONV;
	CAuxVariable H2O_TEMP;
	CFluxVariable CONS_EGEST;
	CAuxVariable CONS_INGEST_WR;
	CAuxVariable CONS_INGEST_NPHBIO;
	CAuxVariable CONS_INGEST_PHBIO;
	CAuxVariable CONS_INGEST_EPI;
	CAuxVariable CONS_INGEST_PHT;
	CAuxVariable CONS_INGEST_SW;
	CAuxVariable VEG_STRUCTURE;
	CStateVariable CONSUMERS;
	CFluxVariable CONS_INGEST;
	CFluxVariable CONS_IN_X;
	CFluxVariable CONS_MORTALITY;
	CFluxVariable CONS_RESPIRATION;
	CFluxVariable CONS_OUT_X;
	CAuxVariable CONSDENS;
	CAuxVariable CONSTOE;
	CAuxVariable CONSTON;
	CAuxVariable CONSTOS;
	CAuxVariable CONSTOW;
	CAuxVariable CON_POT_INGEST;
	CAuxVariable DENSITY_X_E;
	CAuxVariable DENSITY_X_N;
	CAuxVariable DENSITY_X_S;
	CAuxVariable DENSITY_X_W;
	CAuxVariable FOOD_X_E;
	CAuxVariable FOOD_X_N;
	CAuxVariable FOOD_X_S;
	CAuxVariable FOOD_X_W;
	CAuxVariable IC_CONSUMER;
	CAuxVariable OMTOTBIO;
	CAuxVariable PREF_TOT;
	CAuxVariable RIVER_CON;
	CAuxVariable P1_CONS_NC;
	CAuxVariable P1_CONS_PC;
	CAuxVariable P1_C_EGEST_EFF;
	CAuxVariable P1_C_MORT_RT;
	CAuxVariable P1_C_RESP_RT;
	CAuxVariable P1_EP_PREF;
	CAuxVariable P1_INGESTION_RT;
	CAuxVariable P1_PH_PREF;
	CAuxVariable P1_RR_PREF;
	CAuxVariable P1_SH_PREF;
	CAuxVariable P1_SW_PREF;
	CAuxVariable P1_TRAVEL_TIME;
	CAuxVariable P1_VEG_DENS_COEFF;
	CAuxVariable P1_WR_PREF;
	CAuxVariable CONS_ACTIVITY;
protected:

	int CONSUMERS_I0_exe();
	friend int CONSUMERS_I0_exe_g( Variable* v );
	int CONSUMERS_i1_exe();
	friend int CONSUMERS_i1_exe_g( Variable* v );
	int CONS_INGEST_u2_exe();
	friend int CONS_INGEST_u2_exe_g( Variable* v );
	int CONS_IN_X_u3_exe();
	friend int CONS_IN_X_u3_exe_g( Variable* v );
	int CONS_EGEST_u4_exe();
	friend int CONS_EGEST_u4_exe_g( Variable* v );
	int CONS_MORTALITY_u5_exe();
	friend int CONS_MORTALITY_u5_exe_g( Variable* v );
	int CONS_RESPIRATION_u6_exe();
	friend int CONS_RESPIRATION_u6_exe_g( Variable* v );
	int CONS_OUT_X_u7_exe();
	friend int CONS_OUT_X_u7_exe_g( Variable* v );
	int CONSDENS_u8_exe();
	friend int CONSDENS_u8_exe_g( Variable* v );
	int CONSTOE_u9_exe();
	friend int CONSTOE_u9_exe_g( Variable* v );
	int CONSTON_u10_exe();
	friend int CONSTON_u10_exe_g( Variable* v );
	int CONSTOS_u11_exe();
	friend int CONSTOS_u11_exe_g( Variable* v );
	int CONSTOW_u12_exe();
	friend int CONSTOW_u12_exe_g( Variable* v );
	int CONS_INGEST_EPI_u13_exe();
	friend int CONS_INGEST_EPI_u13_exe_g( Variable* v );
	int CONS_INGEST_NPHBIO_u14_exe();
	friend int CONS_INGEST_NPHBIO_u14_exe_g( Variable* v );
	int CONS_INGEST_PHBIO_u15_exe();
	friend int CONS_INGEST_PHBIO_u15_exe_g( Variable* v );
	int CONS_INGEST_PHT_u16_exe();
	friend int CONS_INGEST_PHT_u16_exe_g( Variable* v );
	int CONS_INGEST_SW_u17_exe();
	friend int CONS_INGEST_SW_u17_exe_g( Variable* v );
	int CONS_INGEST_WR_u18_exe();
	friend int CONS_INGEST_WR_u18_exe_g( Variable* v );
	int CON_POT_INGEST_u19_exe();
	friend int CON_POT_INGEST_u19_exe_g( Variable* v );
	int DENSITY_X_E_u20_exe();
	friend int DENSITY_X_E_u20_exe_g( Variable* v );
	int DENSITY_X_N_u21_exe();
	friend int DENSITY_X_N_u21_exe_g( Variable* v );
	int DENSITY_X_S_u22_exe();
	friend int DENSITY_X_S_u22_exe_g( Variable* v );
	int DENSITY_X_W_u23_exe();
	friend int DENSITY_X_W_u23_exe_g( Variable* v );
	int FOOD_X_E_u24_exe();
	friend int FOOD_X_E_u24_exe_g( Variable* v );
	int FOOD_X_N_u25_exe();
	friend int FOOD_X_N_u25_exe_g( Variable* v );
	int FOOD_X_S_u26_exe();
	friend int FOOD_X_S_u26_exe_g( Variable* v );
	int FOOD_X_W_u27_exe();
	friend int FOOD_X_W_u27_exe_g( Variable* v );
	int IC_CONSUMER_u28_exe();
	friend int IC_CONSUMER_u28_exe_g( Variable* v );
	int OMTOTBIO_u29_exe();
	friend int OMTOTBIO_u29_exe_g( Variable* v );
	int PREF_TOT_u30_exe();
	friend int PREF_TOT_u30_exe_g( Variable* v );
	int RIVER_CON_u31_exe();
	friend int RIVER_CON_u31_exe_g( Variable* v );
	int VEG_STRUCTURE_u32_exe();
	friend int VEG_STRUCTURE_u32_exe_g( Variable* v );
	int P1_CONS_NC_u33_exe();
	friend int P1_CONS_NC_u33_exe_g( Variable* v );
	int P1_CONS_PC_u34_exe();
	friend int P1_CONS_PC_u34_exe_g( Variable* v );
	int P1_C_EGEST_EFF_u35_exe();
	friend int P1_C_EGEST_EFF_u35_exe_g( Variable* v );
	int P1_C_MORT_RT_u36_exe();
	friend int P1_C_MORT_RT_u36_exe_g( Variable* v );
	int P1_C_RESP_RT_u37_exe();
	friend int P1_C_RESP_RT_u37_exe_g( Variable* v );
	int P1_EP_PREF_u38_exe();
	friend int P1_EP_PREF_u38_exe_g( Variable* v );
	int P1_INGESTION_RT_u39_exe();
	friend int P1_INGESTION_RT_u39_exe_g( Variable* v );
	int P1_PH_PREF_u40_exe();
	friend int P1_PH_PREF_u40_exe_g( Variable* v );
	int P1_RR_PREF_u41_exe();
	friend int P1_RR_PREF_u41_exe_g( Variable* v );
	int P1_SH_PREF_u42_exe();
	friend int P1_SH_PREF_u42_exe_g( Variable* v );
	int P1_SW_PREF_u43_exe();
	friend int P1_SW_PREF_u43_exe_g( Variable* v );
	int P1_TRAVEL_TIME_u44_exe();
	friend int P1_TRAVEL_TIME_u44_exe_g( Variable* v );
	int P1_VEG_DENS_COEFF_u45_exe();
	friend int P1_VEG_DENS_COEFF_u45_exe_g( Variable* v );
	int P1_WR_PREF_u46_exe();
	friend int P1_WR_PREF_u46_exe_g( Variable* v );
	int CONS_ACTIVITY_u47_exe();
	friend int CONS_ACTIVITY_u47_exe_g( Variable* v );
	static CONSUMERS_module* fInstance;
	static CONSUMERS_module* kNullModel;
public:
	inline static CONSUMERS_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new CONSUMERS_module("CONSUMERS_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (CONSUMERS_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}

	inline double Graph0(double x) { 
		static double g[13][2] = {
			{ 1.0000E+00, 2.500000E-02},{ 2.0000E+00, 4.500000E-02},{ 3.0000E+00, 1.050000E-01},{ 4.0000E+00, 1.350000E-01},
			{ 5.0000E+00, 2.800000E-01},{ 6.0000E+00, 5.700000E-01},{ 7.0000E+00, 8.150000E-01},{ 8.0000E+00, 9.600000E-01},
			{ 9.0000E+00, 1.000000E+00},{ 1.0000E+01, 1.000000E+00},{ 1.1000E+01, 9.400000E-01},{ 1.2000E+01, 5.000000E-02},
			{ 1.3000E+01, 4.000000E-02}, };
		return SL::Graph( 0, x, 12, g); 
	}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int CONSUMERS_I0_exe_g(Variable* obj) { return CONSUMERS_module::I().CONSUMERS_I0_exe(); }
int CONSUMERS_i1_exe_g(Variable* obj) { return CONSUMERS_module::I().CONSUMERS_i1_exe(); }
int CONS_INGEST_u2_exe_g(Variable* obj) { return CONSUMERS_module::I().CONS_INGEST_u2_exe(); }
int CONS_IN_X_u3_exe_g(Variable* obj) { return CONSUMERS_module::I().CONS_IN_X_u3_exe(); }
int CONS_EGEST_u4_exe_g(Variable* obj) { return CONSUMERS_module::I().CONS_EGEST_u4_exe(); }
int CONS_MORTALITY_u5_exe_g(Variable* obj) { return CONSUMERS_module::I().CONS_MORTALITY_u5_exe(); }
int CONS_RESPIRATION_u6_exe_g(Variable* obj) { return CONSUMERS_module::I().CONS_RESPIRATION_u6_exe(); }
int CONS_OUT_X_u7_exe_g(Variable* obj) { return CONSUMERS_module::I().CONS_OUT_X_u7_exe(); }
int CONSDENS_u8_exe_g(Variable* obj) { return CONSUMERS_module::I().CONSDENS_u8_exe(); }
int CONSTOE_u9_exe_g(Variable* obj) { return CONSUMERS_module::I().CONSTOE_u9_exe(); }
int CONSTON_u10_exe_g(Variable* obj) { return CONSUMERS_module::I().CONSTON_u10_exe(); }
int CONSTOS_u11_exe_g(Variable* obj) { return CONSUMERS_module::I().CONSTOS_u11_exe(); }
int CONSTOW_u12_exe_g(Variable* obj) { return CONSUMERS_module::I().CONSTOW_u12_exe(); }
int CONS_INGEST_EPI_u13_exe_g(Variable* obj) { return CONSUMERS_module::I().CONS_INGEST_EPI_u13_exe(); }
int CONS_INGEST_NPHBIO_u14_exe_g(Variable* obj) { return CONSUMERS_module::I().CONS_INGEST_NPHBIO_u14_exe(); }
int CONS_INGEST_PHBIO_u15_exe_g(Variable* obj) { return CONSUMERS_module::I().CONS_INGEST_PHBIO_u15_exe(); }
int CONS_INGEST_PHT_u16_exe_g(Variable* obj) { return CONSUMERS_module::I().CONS_INGEST_PHT_u16_exe(); }
int CONS_INGEST_SW_u17_exe_g(Variable* obj) { return CONSUMERS_module::I().CONS_INGEST_SW_u17_exe(); }
int CONS_INGEST_WR_u18_exe_g(Variable* obj) { return CONSUMERS_module::I().CONS_INGEST_WR_u18_exe(); }
int CON_POT_INGEST_u19_exe_g(Variable* obj) { return CONSUMERS_module::I().CON_POT_INGEST_u19_exe(); }
int DENSITY_X_E_u20_exe_g(Variable* obj) { return CONSUMERS_module::I().DENSITY_X_E_u20_exe(); }
int DENSITY_X_N_u21_exe_g(Variable* obj) { return CONSUMERS_module::I().DENSITY_X_N_u21_exe(); }
int DENSITY_X_S_u22_exe_g(Variable* obj) { return CONSUMERS_module::I().DENSITY_X_S_u22_exe(); }
int DENSITY_X_W_u23_exe_g(Variable* obj) { return CONSUMERS_module::I().DENSITY_X_W_u23_exe(); }
int FOOD_X_E_u24_exe_g(Variable* obj) { return CONSUMERS_module::I().FOOD_X_E_u24_exe(); }
int FOOD_X_N_u25_exe_g(Variable* obj) { return CONSUMERS_module::I().FOOD_X_N_u25_exe(); }
int FOOD_X_S_u26_exe_g(Variable* obj) { return CONSUMERS_module::I().FOOD_X_S_u26_exe(); }
int FOOD_X_W_u27_exe_g(Variable* obj) { return CONSUMERS_module::I().FOOD_X_W_u27_exe(); }
int IC_CONSUMER_u28_exe_g(Variable* obj) { return CONSUMERS_module::I().IC_CONSUMER_u28_exe(); }
int OMTOTBIO_u29_exe_g(Variable* obj) { return CONSUMERS_module::I().OMTOTBIO_u29_exe(); }
int PREF_TOT_u30_exe_g(Variable* obj) { return CONSUMERS_module::I().PREF_TOT_u30_exe(); }
int RIVER_CON_u31_exe_g(Variable* obj) { return CONSUMERS_module::I().RIVER_CON_u31_exe(); }
int VEG_STRUCTURE_u32_exe_g(Variable* obj) { return CONSUMERS_module::I().VEG_STRUCTURE_u32_exe(); }
int P1_CONS_NC_u33_exe_g(Variable* obj) { return CONSUMERS_module::I().P1_CONS_NC_u33_exe(); }
int P1_CONS_PC_u34_exe_g(Variable* obj) { return CONSUMERS_module::I().P1_CONS_PC_u34_exe(); }
int P1_C_EGEST_EFF_u35_exe_g(Variable* obj) { return CONSUMERS_module::I().P1_C_EGEST_EFF_u35_exe(); }
int P1_C_MORT_RT_u36_exe_g(Variable* obj) { return CONSUMERS_module::I().P1_C_MORT_RT_u36_exe(); }
int P1_C_RESP_RT_u37_exe_g(Variable* obj) { return CONSUMERS_module::I().P1_C_RESP_RT_u37_exe(); }
int P1_EP_PREF_u38_exe_g(Variable* obj) { return CONSUMERS_module::I().P1_EP_PREF_u38_exe(); }
int P1_INGESTION_RT_u39_exe_g(Variable* obj) { return CONSUMERS_module::I().P1_INGESTION_RT_u39_exe(); }
int P1_PH_PREF_u40_exe_g(Variable* obj) { return CONSUMERS_module::I().P1_PH_PREF_u40_exe(); }
int P1_RR_PREF_u41_exe_g(Variable* obj) { return CONSUMERS_module::I().P1_RR_PREF_u41_exe(); }
int P1_SH_PREF_u42_exe_g(Variable* obj) { return CONSUMERS_module::I().P1_SH_PREF_u42_exe(); }
int P1_SW_PREF_u43_exe_g(Variable* obj) { return CONSUMERS_module::I().P1_SW_PREF_u43_exe(); }
int P1_TRAVEL_TIME_u44_exe_g(Variable* obj) { return CONSUMERS_module::I().P1_TRAVEL_TIME_u44_exe(); }
int P1_VEG_DENS_COEFF_u45_exe_g(Variable* obj) { return CONSUMERS_module::I().P1_VEG_DENS_COEFF_u45_exe(); }
int P1_WR_PREF_u46_exe_g(Variable* obj) { return CONSUMERS_module::I().P1_WR_PREF_u46_exe(); }
int CONS_ACTIVITY_u47_exe_g(Variable* obj) { return CONSUMERS_module::I().CONS_ACTIVITY_u47_exe(); }
// ---------------------------------------------------------------------------
//                    Class DETRITUS_module 
// ---------------------------------------------------------------------------

class DETRITUS_module : public TModule {
protected:

	DETRITUS_module(char* name);

public:

	TTime TIME;
	CStateVariable WRACK;
	CFluxVariable CONS_EGEST;
	CAuxVariable P1_CELL_SIZE;
	CFluxVariable PHBIO_LITTERFALL;
	CAuxVariable CONS_INGEST_WR;
	CAuxVariable P1_ON_MAP;
	CAuxVariable P1_AIR_TEMP;
	CAuxVariable EW_VECTOR;
	CAuxVariable EW_WIND_VECTOR;
	CAuxVariable NS_VECTOR;
	CAuxVariable NS_WIND_VECTOR;
	CStateVariable DAYS;
	CFluxVariable WRACK_OM_DECOMP;
	CAuxVariable P1_WRACK_OM_NC;
	CFluxVariable GEMINATION;
	CAuxVariable P1_WRACK_OM_PC;
	CStateVariable DETRITAL_POOL;
	CFluxVariable WRACK_SINKING;
	CFluxVariable EGESTED_MATTER;
	CStateVariable SEEDS;
	CFluxVariable SEED_DROP_OUT;
	CFluxVariable SEED_LOSS;
	CFluxVariable WRACK_PRODUCED;
	CFluxVariable WRACK_X_IN;
	CFluxVariable WRACK_CONSUMED;
	CFluxVariable WRACK_X_OUT;
	CAuxVariable DECOMP_TEMP_H2O;
	CAuxVariable DECOMP_TEMP_N;
	CAuxVariable EW_WRACK_VECTOR;
	CAuxVariable NS_WRACK_VECTOR;
	CAuxVariable SEED_GERM;
	CAuxVariable VECTOR_ABS_SUM;
	CAuxVariable WRACK_EXPORT_EW;
	CAuxVariable WRACK_EXPORT_NS;
	CAuxVariable WRACK_E_X;
	CAuxVariable WRACK_N_X;
	CAuxVariable WRACK_S_X;
	CAuxVariable WRACK_W_X;
	CAuxVariable P1_HALF_SAT_H2O;
	CAuxVariable P1_HALF_SAT_N;
	CAuxVariable P1_IC_WRACK;
	CAuxVariable P1_SEED_LOSS_RT;
	CAuxVariable P1_SEED_WGT;
	CAuxVariable P1_SHREDDING_BY_CONS;
	CAuxVariable P1_SINK_RT;
	CAuxVariable P1_WIND_WRACK_FACTOR;
	CAuxVariable SEED_PROD;
protected:

	int DETRITAL_POOL_I48_exe();
	friend int DETRITAL_POOL_I48_exe_g( Variable* v );
	int DETRITAL_POOL_i49_exe();
	friend int DETRITAL_POOL_i49_exe_g( Variable* v );
	int WRACK_SINKING_u50_exe();
	friend int WRACK_SINKING_u50_exe_g( Variable* v );
	int EGESTED_MATTER_u51_exe();
	friend int EGESTED_MATTER_u51_exe_g( Variable* v );
	int SEEDS_I52_exe();
	friend int SEEDS_I52_exe_g( Variable* v );
	int SEEDS_i53_exe();
	friend int SEEDS_i53_exe_g( Variable* v );
	int SEED_DROP_OUT_u54_exe();
	friend int SEED_DROP_OUT_u54_exe_g( Variable* v );
	int GEMINATION_u55_exe();
	friend int GEMINATION_u55_exe_g( Variable* v );
	int SEED_LOSS_u56_exe();
	friend int SEED_LOSS_u56_exe_g( Variable* v );
	int WRACK_I57_exe();
	friend int WRACK_I57_exe_g( Variable* v );
	int WRACK_i58_exe();
	friend int WRACK_i58_exe_g( Variable* v );
	int WRACK_PRODUCED_u59_exe();
	friend int WRACK_PRODUCED_u59_exe_g( Variable* v );
	int WRACK_X_IN_u60_exe();
	friend int WRACK_X_IN_u60_exe_g( Variable* v );
	int WRACK_CONSUMED_u61_exe();
	friend int WRACK_CONSUMED_u61_exe_g( Variable* v );
	int WRACK_OM_DECOMP_u62_exe();
	friend int WRACK_OM_DECOMP_u62_exe_g( Variable* v );
	int WRACK_X_OUT_u63_exe();
	friend int WRACK_X_OUT_u63_exe_g( Variable* v );
	int DECOMP_TEMP_H2O_u64_exe();
	friend int DECOMP_TEMP_H2O_u64_exe_g( Variable* v );
	int DECOMP_TEMP_N_u65_exe();
	friend int DECOMP_TEMP_N_u65_exe_g( Variable* v );
	int EW_WRACK_VECTOR_u66_exe();
	friend int EW_WRACK_VECTOR_u66_exe_g( Variable* v );
	int NS_WRACK_VECTOR_u67_exe();
	friend int NS_WRACK_VECTOR_u67_exe_g( Variable* v );
	int SEED_GERM_u68_exe();
	friend int SEED_GERM_u68_exe_g( Variable* v );
	int VECTOR_ABS_SUM_u69_exe();
	friend int VECTOR_ABS_SUM_u69_exe_g( Variable* v );
	int WRACK_EXPORT_EW_u70_exe();
	friend int WRACK_EXPORT_EW_u70_exe_g( Variable* v );
	int WRACK_EXPORT_NS_u71_exe();
	friend int WRACK_EXPORT_NS_u71_exe_g( Variable* v );
	int WRACK_E_X_u72_exe();
	friend int WRACK_E_X_u72_exe_g( Variable* v );
	int WRACK_N_X_u73_exe();
	friend int WRACK_N_X_u73_exe_g( Variable* v );
	int WRACK_S_X_u74_exe();
	friend int WRACK_S_X_u74_exe_g( Variable* v );
	int WRACK_W_X_u75_exe();
	friend int WRACK_W_X_u75_exe_g( Variable* v );
	int P1_HALF_SAT_H2O_u76_exe();
	friend int P1_HALF_SAT_H2O_u76_exe_g( Variable* v );
	int P1_HALF_SAT_N_u77_exe();
	friend int P1_HALF_SAT_N_u77_exe_g( Variable* v );
	int P1_IC_WRACK_u78_exe();
	friend int P1_IC_WRACK_u78_exe_g( Variable* v );
	int P1_SEED_LOSS_RT_u79_exe();
	friend int P1_SEED_LOSS_RT_u79_exe_g( Variable* v );
	int P1_SEED_WGT_u80_exe();
	friend int P1_SEED_WGT_u80_exe_g( Variable* v );
	int P1_SHREDDING_BY_CONS_u81_exe();
	friend int P1_SHREDDING_BY_CONS_u81_exe_g( Variable* v );
	int P1_SINK_RT_u82_exe();
	friend int P1_SINK_RT_u82_exe_g( Variable* v );
	int P1_WIND_WRACK_FACTOR_u83_exe();
	friend int P1_WIND_WRACK_FACTOR_u83_exe_g( Variable* v );
	int P1_WRACK_OM_NC_u84_exe();
	friend int P1_WRACK_OM_NC_u84_exe_g( Variable* v );
	int P1_WRACK_OM_PC_u85_exe();
	friend int P1_WRACK_OM_PC_u85_exe_g( Variable* v );
	int SEED_PROD_u86_exe();
	friend int SEED_PROD_u86_exe_g( Variable* v );
	static DETRITUS_module* fInstance;
	static DETRITUS_module* kNullModel;
public:
	inline static DETRITUS_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new DETRITUS_module("DETRITUS_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (DETRITUS_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}

	inline double Graph1(double x) { 
		static double g[11][2] = {
			{ 0.0000E+00, 0.000000E+00},{ 3.6500E+01, 2.500000E-02},{ 7.3000E+01, 1.100000E-01},{ 1.1000E+02, 9.600000E-01},
			{ 1.4600E+02, 1.750000E-01},{ 1.8200E+02, 1.100000E-01},{ 2.1900E+02, 4.500000E-02},{ 2.5600E+02, 2.000000E-02},
			{ 2.9200E+02, 1.000000E-02},{ 3.2800E+02, 1.000000E-02},{ 3.6500E+02, 1.500000E-02}, };
		return SL::Graph( 0, x, 10, g); 
	}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int DETRITAL_POOL_I48_exe_g(Variable* obj) { return DETRITUS_module::I().DETRITAL_POOL_I48_exe(); }
int DETRITAL_POOL_i49_exe_g(Variable* obj) { return DETRITUS_module::I().DETRITAL_POOL_i49_exe(); }
int WRACK_SINKING_u50_exe_g(Variable* obj) { return DETRITUS_module::I().WRACK_SINKING_u50_exe(); }
int EGESTED_MATTER_u51_exe_g(Variable* obj) { return DETRITUS_module::I().EGESTED_MATTER_u51_exe(); }
int SEEDS_I52_exe_g(Variable* obj) { return DETRITUS_module::I().SEEDS_I52_exe(); }
int SEEDS_i53_exe_g(Variable* obj) { return DETRITUS_module::I().SEEDS_i53_exe(); }
int SEED_DROP_OUT_u54_exe_g(Variable* obj) { return DETRITUS_module::I().SEED_DROP_OUT_u54_exe(); }
int GEMINATION_u55_exe_g(Variable* obj) { return DETRITUS_module::I().GEMINATION_u55_exe(); }
int SEED_LOSS_u56_exe_g(Variable* obj) { return DETRITUS_module::I().SEED_LOSS_u56_exe(); }
int WRACK_I57_exe_g(Variable* obj) { return DETRITUS_module::I().WRACK_I57_exe(); }
int WRACK_i58_exe_g(Variable* obj) { return DETRITUS_module::I().WRACK_i58_exe(); }
int WRACK_PRODUCED_u59_exe_g(Variable* obj) { return DETRITUS_module::I().WRACK_PRODUCED_u59_exe(); }
int WRACK_X_IN_u60_exe_g(Variable* obj) { return DETRITUS_module::I().WRACK_X_IN_u60_exe(); }
int WRACK_CONSUMED_u61_exe_g(Variable* obj) { return DETRITUS_module::I().WRACK_CONSUMED_u61_exe(); }
int WRACK_OM_DECOMP_u62_exe_g(Variable* obj) { return DETRITUS_module::I().WRACK_OM_DECOMP_u62_exe(); }
int WRACK_X_OUT_u63_exe_g(Variable* obj) { return DETRITUS_module::I().WRACK_X_OUT_u63_exe(); }
int DECOMP_TEMP_H2O_u64_exe_g(Variable* obj) { return DETRITUS_module::I().DECOMP_TEMP_H2O_u64_exe(); }
int DECOMP_TEMP_N_u65_exe_g(Variable* obj) { return DETRITUS_module::I().DECOMP_TEMP_N_u65_exe(); }
int EW_WRACK_VECTOR_u66_exe_g(Variable* obj) { return DETRITUS_module::I().EW_WRACK_VECTOR_u66_exe(); }
int NS_WRACK_VECTOR_u67_exe_g(Variable* obj) { return DETRITUS_module::I().NS_WRACK_VECTOR_u67_exe(); }
int SEED_GERM_u68_exe_g(Variable* obj) { return DETRITUS_module::I().SEED_GERM_u68_exe(); }
int VECTOR_ABS_SUM_u69_exe_g(Variable* obj) { return DETRITUS_module::I().VECTOR_ABS_SUM_u69_exe(); }
int WRACK_EXPORT_EW_u70_exe_g(Variable* obj) { return DETRITUS_module::I().WRACK_EXPORT_EW_u70_exe(); }
int WRACK_EXPORT_NS_u71_exe_g(Variable* obj) { return DETRITUS_module::I().WRACK_EXPORT_NS_u71_exe(); }
int WRACK_E_X_u72_exe_g(Variable* obj) { return DETRITUS_module::I().WRACK_E_X_u72_exe(); }
int WRACK_N_X_u73_exe_g(Variable* obj) { return DETRITUS_module::I().WRACK_N_X_u73_exe(); }
int WRACK_S_X_u74_exe_g(Variable* obj) { return DETRITUS_module::I().WRACK_S_X_u74_exe(); }
int WRACK_W_X_u75_exe_g(Variable* obj) { return DETRITUS_module::I().WRACK_W_X_u75_exe(); }
int P1_HALF_SAT_H2O_u76_exe_g(Variable* obj) { return DETRITUS_module::I().P1_HALF_SAT_H2O_u76_exe(); }
int P1_HALF_SAT_N_u77_exe_g(Variable* obj) { return DETRITUS_module::I().P1_HALF_SAT_N_u77_exe(); }
int P1_IC_WRACK_u78_exe_g(Variable* obj) { return DETRITUS_module::I().P1_IC_WRACK_u78_exe(); }
int P1_SEED_LOSS_RT_u79_exe_g(Variable* obj) { return DETRITUS_module::I().P1_SEED_LOSS_RT_u79_exe(); }
int P1_SEED_WGT_u80_exe_g(Variable* obj) { return DETRITUS_module::I().P1_SEED_WGT_u80_exe(); }
int P1_SHREDDING_BY_CONS_u81_exe_g(Variable* obj) { return DETRITUS_module::I().P1_SHREDDING_BY_CONS_u81_exe(); }
int P1_SINK_RT_u82_exe_g(Variable* obj) { return DETRITUS_module::I().P1_SINK_RT_u82_exe(); }
int P1_WIND_WRACK_FACTOR_u83_exe_g(Variable* obj) { return DETRITUS_module::I().P1_WIND_WRACK_FACTOR_u83_exe(); }
int P1_WRACK_OM_NC_u84_exe_g(Variable* obj) { return DETRITUS_module::I().P1_WRACK_OM_NC_u84_exe(); }
int P1_WRACK_OM_PC_u85_exe_g(Variable* obj) { return DETRITUS_module::I().P1_WRACK_OM_PC_u85_exe(); }
int SEED_PROD_u86_exe_g(Variable* obj) { return DETRITUS_module::I().SEED_PROD_u86_exe(); }
// ---------------------------------------------------------------------------
//                    Class DIN_module 
// ---------------------------------------------------------------------------

class DIN_module : public TModule {
protected:

	DIN_module(char* name);

public:

	TTime TIME;
	CAuxVariable SF_WATER;
	CFluxVariable WRACK_OM_DECOMP;
	CAuxVariable P1_WRACK_OM_NC;
	CAuxVariable PHT_NET_PROD;
	CAuxVariable P1_PHT_NC;
	CAuxVariable P1_MAC_PH_NC;
	CAuxVariable PHBIO_NET_PROD;
	CAuxVariable SF_WT_E_X;
	CAuxVariable SF_WT_N_X;
	CAuxVariable SF_WT_S_X;
	CAuxVariable SF_WT_W_X;
	CAuxVariable P1_RIVER_DATA_CF;
	CAuxVariable P1_DIN_SED_CONC_MAP;
	CAuxVariable DIN_CONC;
	CStateVariable DIN_SF_WT;
	CFluxVariable DIN_SF_WT_MINER;
	CFluxVariable DIN_SF_WT_X_IN;
	CFluxVariable DIN_DNFLOW;
	CFluxVariable DIN_SF_WT_UPTAKE;
	CFluxVariable DIN_SF_WT_X_OUT;
	CStateVariable SOIL_NITROGEN;
	CAuxVariable DINEX;
	CAuxVariable DINNX;
	CAuxVariable DINSX;
	CAuxVariable DINWX;
	CAuxVariable RIVER_N;
	CAuxVariable P1_DIN_DIFFUSION_COEFF;
	CAuxVariable P1_IC_DIN_SF_WT;
protected:

	int DIN_SF_WT_I87_exe();
	friend int DIN_SF_WT_I87_exe_g( Variable* v );
	int DIN_SF_WT_i88_exe();
	friend int DIN_SF_WT_i88_exe_g( Variable* v );
	int DIN_SF_WT_MINER_u89_exe();
	friend int DIN_SF_WT_MINER_u89_exe_g( Variable* v );
	int DIN_SF_WT_X_IN_u90_exe();
	friend int DIN_SF_WT_X_IN_u90_exe_g( Variable* v );
	int DIN_DNFLOW_u91_exe();
	friend int DIN_DNFLOW_u91_exe_g( Variable* v );
	int DIN_SF_WT_UPTAKE_u92_exe();
	friend int DIN_SF_WT_UPTAKE_u92_exe_g( Variable* v );
	int DIN_SF_WT_X_OUT_u93_exe();
	friend int DIN_SF_WT_X_OUT_u93_exe_g( Variable* v );
	int SOIL_NITROGEN_I94_exe();
	friend int SOIL_NITROGEN_I94_exe_g( Variable* v );
	int SOIL_NITROGEN_i95_exe();
	friend int SOIL_NITROGEN_i95_exe_g( Variable* v );
	int DINEX_u96_exe();
	friend int DINEX_u96_exe_g( Variable* v );
	int DINNX_u97_exe();
	friend int DINNX_u97_exe_g( Variable* v );
	int DINSX_u98_exe();
	friend int DINSX_u98_exe_g( Variable* v );
	int DINWX_u99_exe();
	friend int DINWX_u99_exe_g( Variable* v );
	int DIN_CONC_u100_exe();
	friend int DIN_CONC_u100_exe_g( Variable* v );
	int RIVER_N_u101_exe();
	friend int RIVER_N_u101_exe_g( Variable* v );
	int P1_DIN_DIFFUSION_COEFF_u102_exe();
	friend int P1_DIN_DIFFUSION_COEFF_u102_exe_g( Variable* v );
	int P1_DIN_SED_CONC_MAP_u103_exe();
	friend int P1_DIN_SED_CONC_MAP_u103_exe_g( Variable* v );
	int P1_IC_DIN_SF_WT_u104_exe();
	friend int P1_IC_DIN_SF_WT_u104_exe_g( Variable* v );
	static DIN_module* fInstance;
	static DIN_module* kNullModel;
public:
	inline static DIN_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new DIN_module("DIN_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (DIN_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int DIN_SF_WT_I87_exe_g(Variable* obj) { return DIN_module::I().DIN_SF_WT_I87_exe(); }
int DIN_SF_WT_i88_exe_g(Variable* obj) { return DIN_module::I().DIN_SF_WT_i88_exe(); }
int DIN_SF_WT_MINER_u89_exe_g(Variable* obj) { return DIN_module::I().DIN_SF_WT_MINER_u89_exe(); }
int DIN_SF_WT_X_IN_u90_exe_g(Variable* obj) { return DIN_module::I().DIN_SF_WT_X_IN_u90_exe(); }
int DIN_DNFLOW_u91_exe_g(Variable* obj) { return DIN_module::I().DIN_DNFLOW_u91_exe(); }
int DIN_SF_WT_UPTAKE_u92_exe_g(Variable* obj) { return DIN_module::I().DIN_SF_WT_UPTAKE_u92_exe(); }
int DIN_SF_WT_X_OUT_u93_exe_g(Variable* obj) { return DIN_module::I().DIN_SF_WT_X_OUT_u93_exe(); }
int SOIL_NITROGEN_I94_exe_g(Variable* obj) { return DIN_module::I().SOIL_NITROGEN_I94_exe(); }
int SOIL_NITROGEN_i95_exe_g(Variable* obj) { return DIN_module::I().SOIL_NITROGEN_i95_exe(); }
int DINEX_u96_exe_g(Variable* obj) { return DIN_module::I().DINEX_u96_exe(); }
int DINNX_u97_exe_g(Variable* obj) { return DIN_module::I().DINNX_u97_exe(); }
int DINSX_u98_exe_g(Variable* obj) { return DIN_module::I().DINSX_u98_exe(); }
int DINWX_u99_exe_g(Variable* obj) { return DIN_module::I().DINWX_u99_exe(); }
int DIN_CONC_u100_exe_g(Variable* obj) { return DIN_module::I().DIN_CONC_u100_exe(); }
int RIVER_N_u101_exe_g(Variable* obj) { return DIN_module::I().RIVER_N_u101_exe(); }
int P1_DIN_DIFFUSION_COEFF_u102_exe_g(Variable* obj) { return DIN_module::I().P1_DIN_DIFFUSION_COEFF_u102_exe(); }
int P1_DIN_SED_CONC_MAP_u103_exe_g(Variable* obj) { return DIN_module::I().P1_DIN_SED_CONC_MAP_u103_exe(); }
int P1_IC_DIN_SF_WT_u104_exe_g(Variable* obj) { return DIN_module::I().P1_IC_DIN_SF_WT_u104_exe(); }
// ---------------------------------------------------------------------------
//                    Class EELGRASS_module 
// ---------------------------------------------------------------------------

class EELGRASS_module : public TModule {
protected:

	EELGRASS_module(char* name);

public:

	TTime TIME;
	CStateVariable ROOTSRHY;
	CStateVariable SHOOTS;
	CAuxVariable P1_IC_MAC_PHBIO;
	CAuxVariable P1_SEPT_TO_JAN_CONV;
	CFluxVariable PHBIO_LITTERFALL;
	CAuxVariable P1_MAC_PH_NC;
	CAuxVariable PHBIO_NET_PROD;
	CAuxVariable P1_CELL_SIZE;
	CAuxVariable CONS_INGEST_NPHBIO;
	CFluxVariable GEMINATION;
	CAuxVariable CONS_INGEST_PHBIO;
	CAuxVariable P1_AIR_TEMP;
	CAuxVariable H2O_TEMP;
	CAuxVariable P1_LEAF_GROW_SEASON;
	CAuxVariable P1_DIN_SED_CONC_MAP;
	CAuxVariable P1_PO4_SED_WT_CONC;
	CAuxVariable ZOSTRA_LIGHT_LIM;
	CStateVariable DAYS;
	CAuxVariable PHBIO_LTTR_RATIO;
	CAuxVariable LEAF_LENGTH;
	CAuxVariable P1_MAC_PHBIO_PC;
	CFluxVariable NPH_MAC_GPP;
	CFluxVariable NPHBIO_RESP;
	CFluxVariable NPHBIO_MORT;
	CFluxVariable NPHBIO_CONSUMED;
	CFluxVariable PH_MAC_GPP;
	CFluxVariable NEW_PLANTS;
	CFluxVariable PHBIO_RESP;
	CFluxVariable PHBIO_CONSUMED;
	CAuxVariable ACTUAL_LEAF_GROWTH;
	CAuxVariable IC_MAC_NPHBIO;
	CAuxVariable LEAF_LIMIT_COEFF;
	CAuxVariable LL_CAL_CF;
	CAuxVariable MAC_NET_PROD;
	CAuxVariable MAC_TEMP_RESP_LIM;
	CAuxVariable NPHBIO_NET_PROD;
	CAuxVariable PHMAC_GROWTH_TO_ROOTS;
	CAuxVariable ROOTS_TO_LEAVES;
	CAuxVariable ZOSTRA_NUT_LIM;
	CAuxVariable ZOSTRA_PROD_LIM;
	CAuxVariable ZOSTRA_TEMP_LIM;
	CAuxVariable P1_BETA;
	CAuxVariable P1_MAC_NONPH_NC;
	CAuxVariable P1_MAC_NONPH_PC;
	CAuxVariable P1_MAC_PP_RATE;
	CAuxVariable P1_MAX_AIR_TEMP;
	CAuxVariable P1_NPHBIO_MORT_RATE;
	CAuxVariable P1_NPHBIO_RESP_RATE;
	CAuxVariable P1_PERC_NPHBIO;
	CAuxVariable P1_PHBIO_RESP_RATE;
	CAuxVariable P1_SAT_N;
	CAuxVariable P1_SAT_P;
	CAuxVariable P1_SWITCH_AIR_TEMP_LIM;
	CAuxVariable P1_SWITCH_LIGHT_LIM;
	CAuxVariable P1_SWITCH_NUTRIENT_LIM;
	CAuxVariable P1_SWITCH_TEMP_LIM;
	CAuxVariable PI_INTERVAL;
protected:

	int ROOTSRHY_I105_exe();
	friend int ROOTSRHY_I105_exe_g( Variable* v );
	int ROOTSRHY_i106_exe();
	friend int ROOTSRHY_i106_exe_g( Variable* v );
	int NPH_MAC_GPP_u107_exe();
	friend int NPH_MAC_GPP_u107_exe_g( Variable* v );
	int NPHBIO_RESP_u108_exe();
	friend int NPHBIO_RESP_u108_exe_g( Variable* v );
	int NPHBIO_MORT_u109_exe();
	friend int NPHBIO_MORT_u109_exe_g( Variable* v );
	int NPHBIO_CONSUMED_u110_exe();
	friend int NPHBIO_CONSUMED_u110_exe_g( Variable* v );
	int SHOOTS_I111_exe();
	friend int SHOOTS_I111_exe_g( Variable* v );
	int SHOOTS_i112_exe();
	friend int SHOOTS_i112_exe_g( Variable* v );
	int PH_MAC_GPP_u113_exe();
	friend int PH_MAC_GPP_u113_exe_g( Variable* v );
	int NEW_PLANTS_u114_exe();
	friend int NEW_PLANTS_u114_exe_g( Variable* v );
	int PHBIO_RESP_u115_exe();
	friend int PHBIO_RESP_u115_exe_g( Variable* v );
	int PHBIO_CONSUMED_u116_exe();
	friend int PHBIO_CONSUMED_u116_exe_g( Variable* v );
	int PHBIO_LITTERFALL_u117_exe();
	friend int PHBIO_LITTERFALL_u117_exe_g( Variable* v );
	int ACTUAL_LEAF_GROWTH_u118_exe();
	friend int ACTUAL_LEAF_GROWTH_u118_exe_g( Variable* v );
	int IC_MAC_NPHBIO_u119_exe();
	friend int IC_MAC_NPHBIO_u119_exe_g( Variable* v );
	int LEAF_LENGTH_u120_exe();
	friend int LEAF_LENGTH_u120_exe_g( Variable* v );
	int LEAF_LIMIT_COEFF_u121_exe();
	friend int LEAF_LIMIT_COEFF_u121_exe_g( Variable* v );
	int LL_CAL_CF_u122_exe();
	friend int LL_CAL_CF_u122_exe_g( Variable* v );
	int MAC_NET_PROD_u123_exe();
	friend int MAC_NET_PROD_u123_exe_g( Variable* v );
	int MAC_TEMP_RESP_LIM_u124_exe();
	friend int MAC_TEMP_RESP_LIM_u124_exe_g( Variable* v );
	int NPHBIO_NET_PROD_u125_exe();
	friend int NPHBIO_NET_PROD_u125_exe_g( Variable* v );
	int PHBIO_LTTR_RATIO_u126_exe();
	friend int PHBIO_LTTR_RATIO_u126_exe_g( Variable* v );
	int PHBIO_NET_PROD_u127_exe();
	friend int PHBIO_NET_PROD_u127_exe_g( Variable* v );
	int PHMAC_GROWTH_TO_ROOTS_u128_exe();
	friend int PHMAC_GROWTH_TO_ROOTS_u128_exe_g( Variable* v );
	int ROOTS_TO_LEAVES_u129_exe();
	friend int ROOTS_TO_LEAVES_u129_exe_g( Variable* v );
	int ZOSTRA_NUT_LIM_u130_exe();
	friend int ZOSTRA_NUT_LIM_u130_exe_g( Variable* v );
	int ZOSTRA_PROD_LIM_u131_exe();
	friend int ZOSTRA_PROD_LIM_u131_exe_g( Variable* v );
	int ZOSTRA_TEMP_LIM_u132_exe();
	friend int ZOSTRA_TEMP_LIM_u132_exe_g( Variable* v );
	int P1_BETA_u133_exe();
	friend int P1_BETA_u133_exe_g( Variable* v );
	int P1_IC_MAC_PHBIO_u134_exe();
	friend int P1_IC_MAC_PHBIO_u134_exe_g( Variable* v );
	int P1_MAC_NONPH_NC_u135_exe();
	friend int P1_MAC_NONPH_NC_u135_exe_g( Variable* v );
	int P1_MAC_NONPH_PC_u136_exe();
	friend int P1_MAC_NONPH_PC_u136_exe_g( Variable* v );
	int P1_MAC_PHBIO_PC_u137_exe();
	friend int P1_MAC_PHBIO_PC_u137_exe_g( Variable* v );
	int P1_MAC_PH_NC_u138_exe();
	friend int P1_MAC_PH_NC_u138_exe_g( Variable* v );
	int P1_MAC_PP_RATE_u139_exe();
	friend int P1_MAC_PP_RATE_u139_exe_g( Variable* v );
	int P1_MAX_AIR_TEMP_u140_exe();
	friend int P1_MAX_AIR_TEMP_u140_exe_g( Variable* v );
	int P1_NPHBIO_MORT_RATE_u141_exe();
	friend int P1_NPHBIO_MORT_RATE_u141_exe_g( Variable* v );
	int P1_NPHBIO_RESP_RATE_u142_exe();
	friend int P1_NPHBIO_RESP_RATE_u142_exe_g( Variable* v );
	int P1_PERC_NPHBIO_u143_exe();
	friend int P1_PERC_NPHBIO_u143_exe_g( Variable* v );
	int P1_PHBIO_RESP_RATE_u144_exe();
	friend int P1_PHBIO_RESP_RATE_u144_exe_g( Variable* v );
	int P1_SAT_N_u145_exe();
	friend int P1_SAT_N_u145_exe_g( Variable* v );
	int P1_SAT_P_u146_exe();
	friend int P1_SAT_P_u146_exe_g( Variable* v );
	int P1_SEPT_TO_JAN_CONV_u147_exe();
	friend int P1_SEPT_TO_JAN_CONV_u147_exe_g( Variable* v );
	int P1_SWITCH_AIR_TEMP_LIM_u148_exe();
	friend int P1_SWITCH_AIR_TEMP_LIM_u148_exe_g( Variable* v );
	int P1_SWITCH_LIGHT_LIM_u149_exe();
	friend int P1_SWITCH_LIGHT_LIM_u149_exe_g( Variable* v );
	int P1_SWITCH_NUTRIENT_LIM_u150_exe();
	friend int P1_SWITCH_NUTRIENT_LIM_u150_exe_g( Variable* v );
	int P1_SWITCH_TEMP_LIM_u151_exe();
	friend int P1_SWITCH_TEMP_LIM_u151_exe_g( Variable* v );
	int PI_INTERVAL_u152_exe();
	friend int PI_INTERVAL_u152_exe_g( Variable* v );
	static EELGRASS_module* fInstance;
	static EELGRASS_module* kNullModel;
public:
	inline static EELGRASS_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new EELGRASS_module("EELGRASS_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (EELGRASS_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}

	inline double Graph2(double x) { 
		static double g[12][2] = {
			{ 1.0000E+00, 2.560000E+01},{ 3.4100E+01, 2.060000E+01},{ 6.7200E+01, 1.550000E+01},{ 1.0000E+02, 7.570000E+00},
			{ 1.3300E+02, 4.930000E+00},{ 1.6600E+02, 4.620000E+00},{ 2.0000E+02, 5.390000E+00},{ 2.3300E+02, 8.490000E+00},
			{ 2.6600E+02, 1.610000E+01},{ 2.9900E+02, 2.140000E+01},{ 3.3200E+02, 2.540000E+01},{ 3.6500E+02, 2.510000E+01},
			 };
		return SL::Graph( 0, x, 11, g); 
	}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int ROOTSRHY_I105_exe_g(Variable* obj) { return EELGRASS_module::I().ROOTSRHY_I105_exe(); }
int ROOTSRHY_i106_exe_g(Variable* obj) { return EELGRASS_module::I().ROOTSRHY_i106_exe(); }
int NPH_MAC_GPP_u107_exe_g(Variable* obj) { return EELGRASS_module::I().NPH_MAC_GPP_u107_exe(); }
int NPHBIO_RESP_u108_exe_g(Variable* obj) { return EELGRASS_module::I().NPHBIO_RESP_u108_exe(); }
int NPHBIO_MORT_u109_exe_g(Variable* obj) { return EELGRASS_module::I().NPHBIO_MORT_u109_exe(); }
int NPHBIO_CONSUMED_u110_exe_g(Variable* obj) { return EELGRASS_module::I().NPHBIO_CONSUMED_u110_exe(); }
int SHOOTS_I111_exe_g(Variable* obj) { return EELGRASS_module::I().SHOOTS_I111_exe(); }
int SHOOTS_i112_exe_g(Variable* obj) { return EELGRASS_module::I().SHOOTS_i112_exe(); }
int PH_MAC_GPP_u113_exe_g(Variable* obj) { return EELGRASS_module::I().PH_MAC_GPP_u113_exe(); }
int NEW_PLANTS_u114_exe_g(Variable* obj) { return EELGRASS_module::I().NEW_PLANTS_u114_exe(); }
int PHBIO_RESP_u115_exe_g(Variable* obj) { return EELGRASS_module::I().PHBIO_RESP_u115_exe(); }
int PHBIO_CONSUMED_u116_exe_g(Variable* obj) { return EELGRASS_module::I().PHBIO_CONSUMED_u116_exe(); }
int PHBIO_LITTERFALL_u117_exe_g(Variable* obj) { return EELGRASS_module::I().PHBIO_LITTERFALL_u117_exe(); }
int ACTUAL_LEAF_GROWTH_u118_exe_g(Variable* obj) { return EELGRASS_module::I().ACTUAL_LEAF_GROWTH_u118_exe(); }
int IC_MAC_NPHBIO_u119_exe_g(Variable* obj) { return EELGRASS_module::I().IC_MAC_NPHBIO_u119_exe(); }
int LEAF_LENGTH_u120_exe_g(Variable* obj) { return EELGRASS_module::I().LEAF_LENGTH_u120_exe(); }
int LEAF_LIMIT_COEFF_u121_exe_g(Variable* obj) { return EELGRASS_module::I().LEAF_LIMIT_COEFF_u121_exe(); }
int LL_CAL_CF_u122_exe_g(Variable* obj) { return EELGRASS_module::I().LL_CAL_CF_u122_exe(); }
int MAC_NET_PROD_u123_exe_g(Variable* obj) { return EELGRASS_module::I().MAC_NET_PROD_u123_exe(); }
int MAC_TEMP_RESP_LIM_u124_exe_g(Variable* obj) { return EELGRASS_module::I().MAC_TEMP_RESP_LIM_u124_exe(); }
int NPHBIO_NET_PROD_u125_exe_g(Variable* obj) { return EELGRASS_module::I().NPHBIO_NET_PROD_u125_exe(); }
int PHBIO_LTTR_RATIO_u126_exe_g(Variable* obj) { return EELGRASS_module::I().PHBIO_LTTR_RATIO_u126_exe(); }
int PHBIO_NET_PROD_u127_exe_g(Variable* obj) { return EELGRASS_module::I().PHBIO_NET_PROD_u127_exe(); }
int PHMAC_GROWTH_TO_ROOTS_u128_exe_g(Variable* obj) { return EELGRASS_module::I().PHMAC_GROWTH_TO_ROOTS_u128_exe(); }
int ROOTS_TO_LEAVES_u129_exe_g(Variable* obj) { return EELGRASS_module::I().ROOTS_TO_LEAVES_u129_exe(); }
int ZOSTRA_NUT_LIM_u130_exe_g(Variable* obj) { return EELGRASS_module::I().ZOSTRA_NUT_LIM_u130_exe(); }
int ZOSTRA_PROD_LIM_u131_exe_g(Variable* obj) { return EELGRASS_module::I().ZOSTRA_PROD_LIM_u131_exe(); }
int ZOSTRA_TEMP_LIM_u132_exe_g(Variable* obj) { return EELGRASS_module::I().ZOSTRA_TEMP_LIM_u132_exe(); }
int P1_BETA_u133_exe_g(Variable* obj) { return EELGRASS_module::I().P1_BETA_u133_exe(); }
int P1_IC_MAC_PHBIO_u134_exe_g(Variable* obj) { return EELGRASS_module::I().P1_IC_MAC_PHBIO_u134_exe(); }
int P1_MAC_NONPH_NC_u135_exe_g(Variable* obj) { return EELGRASS_module::I().P1_MAC_NONPH_NC_u135_exe(); }
int P1_MAC_NONPH_PC_u136_exe_g(Variable* obj) { return EELGRASS_module::I().P1_MAC_NONPH_PC_u136_exe(); }
int P1_MAC_PHBIO_PC_u137_exe_g(Variable* obj) { return EELGRASS_module::I().P1_MAC_PHBIO_PC_u137_exe(); }
int P1_MAC_PH_NC_u138_exe_g(Variable* obj) { return EELGRASS_module::I().P1_MAC_PH_NC_u138_exe(); }
int P1_MAC_PP_RATE_u139_exe_g(Variable* obj) { return EELGRASS_module::I().P1_MAC_PP_RATE_u139_exe(); }
int P1_MAX_AIR_TEMP_u140_exe_g(Variable* obj) { return EELGRASS_module::I().P1_MAX_AIR_TEMP_u140_exe(); }
int P1_NPHBIO_MORT_RATE_u141_exe_g(Variable* obj) { return EELGRASS_module::I().P1_NPHBIO_MORT_RATE_u141_exe(); }
int P1_NPHBIO_RESP_RATE_u142_exe_g(Variable* obj) { return EELGRASS_module::I().P1_NPHBIO_RESP_RATE_u142_exe(); }
int P1_PERC_NPHBIO_u143_exe_g(Variable* obj) { return EELGRASS_module::I().P1_PERC_NPHBIO_u143_exe(); }
int P1_PHBIO_RESP_RATE_u144_exe_g(Variable* obj) { return EELGRASS_module::I().P1_PHBIO_RESP_RATE_u144_exe(); }
int P1_SAT_N_u145_exe_g(Variable* obj) { return EELGRASS_module::I().P1_SAT_N_u145_exe(); }
int P1_SAT_P_u146_exe_g(Variable* obj) { return EELGRASS_module::I().P1_SAT_P_u146_exe(); }
int P1_SEPT_TO_JAN_CONV_u147_exe_g(Variable* obj) { return EELGRASS_module::I().P1_SEPT_TO_JAN_CONV_u147_exe(); }
int P1_SWITCH_AIR_TEMP_LIM_u148_exe_g(Variable* obj) { return EELGRASS_module::I().P1_SWITCH_AIR_TEMP_LIM_u148_exe(); }
int P1_SWITCH_LIGHT_LIM_u149_exe_g(Variable* obj) { return EELGRASS_module::I().P1_SWITCH_LIGHT_LIM_u149_exe(); }
int P1_SWITCH_NUTRIENT_LIM_u150_exe_g(Variable* obj) { return EELGRASS_module::I().P1_SWITCH_NUTRIENT_LIM_u150_exe(); }
int P1_SWITCH_TEMP_LIM_u151_exe_g(Variable* obj) { return EELGRASS_module::I().P1_SWITCH_TEMP_LIM_u151_exe(); }
int PI_INTERVAL_u152_exe_g(Variable* obj) { return EELGRASS_module::I().PI_INTERVAL_u152_exe(); }
// ---------------------------------------------------------------------------
//                    Class EPIPHYTES_module 
// ---------------------------------------------------------------------------

class EPIPHYTES_module : public TModule {
protected:

	EPIPHYTES_module(char* name);

public:

	TTime TIME;
	CStateVariable EPIPHYTES;
	CAuxVariable P1_CELL_SIZE;
	CStateVariable SHOOTS;
	CAuxVariable CONS_INGEST_EPI;
	CAuxVariable PHBIO_LTTR_RATIO;
	CAuxVariable DIN_CONC;
	CAuxVariable PO4_SF_WT_CONC;
	CAuxVariable EPI_LIGHT_LIM;
	CAuxVariable H2O_TEMP;
	CAuxVariable P1_IC_MAC_PHBIO;
	CAuxVariable P1_SEPT_TO_JAN_CONV;
	CFluxVariable EPI_GROSS_PP;
	CFluxVariable EPI_SEEDING;
	CFluxVariable EPI_RESP;
	CFluxVariable EPI_CONSUMED;
	CFluxVariable EPI_MORT;
	CAuxVariable EPI_NET_PROD;
	CAuxVariable EPI_NUT_LIMIT;
	CAuxVariable EPI_PROD_LIM;
	CAuxVariable EPI_TEMP_LIM;
	CAuxVariable IC_EPIPHYTES;
	CAuxVariable P1_EPI_ALPHA;
	CAuxVariable P1_EPI_NC;
	CAuxVariable P1_EPI_N_SAT;
	CAuxVariable P1_EPI_PC;
	CAuxVariable P1_EPI_PP_RT;
	CAuxVariable P1_EPI_P_SAT;
	CAuxVariable P1_EPI_RESP_RT;
	CAuxVariable P1_EPI_SEEDING_RT;
	CAuxVariable P1_EPI_TEMP_COEFF;
	CAuxVariable EPI_SHOOT_LIM;
protected:

	int EPIPHYTES_I153_exe();
	friend int EPIPHYTES_I153_exe_g( Variable* v );
	int EPIPHYTES_i154_exe();
	friend int EPIPHYTES_i154_exe_g( Variable* v );
	int EPI_GROSS_PP_u155_exe();
	friend int EPI_GROSS_PP_u155_exe_g( Variable* v );
	int EPI_SEEDING_u156_exe();
	friend int EPI_SEEDING_u156_exe_g( Variable* v );
	int EPI_RESP_u157_exe();
	friend int EPI_RESP_u157_exe_g( Variable* v );
	int EPI_CONSUMED_u158_exe();
	friend int EPI_CONSUMED_u158_exe_g( Variable* v );
	int EPI_MORT_u159_exe();
	friend int EPI_MORT_u159_exe_g( Variable* v );
	int EPI_NET_PROD_u160_exe();
	friend int EPI_NET_PROD_u160_exe_g( Variable* v );
	int EPI_NUT_LIMIT_u161_exe();
	friend int EPI_NUT_LIMIT_u161_exe_g( Variable* v );
	int EPI_PROD_LIM_u162_exe();
	friend int EPI_PROD_LIM_u162_exe_g( Variable* v );
	int EPI_TEMP_LIM_u163_exe();
	friend int EPI_TEMP_LIM_u163_exe_g( Variable* v );
	int IC_EPIPHYTES_u164_exe();
	friend int IC_EPIPHYTES_u164_exe_g( Variable* v );
	int P1_EPI_ALPHA_u165_exe();
	friend int P1_EPI_ALPHA_u165_exe_g( Variable* v );
	int P1_EPI_NC_u166_exe();
	friend int P1_EPI_NC_u166_exe_g( Variable* v );
	int P1_EPI_N_SAT_u167_exe();
	friend int P1_EPI_N_SAT_u167_exe_g( Variable* v );
	int P1_EPI_PC_u168_exe();
	friend int P1_EPI_PC_u168_exe_g( Variable* v );
	int P1_EPI_PP_RT_u169_exe();
	friend int P1_EPI_PP_RT_u169_exe_g( Variable* v );
	int P1_EPI_P_SAT_u170_exe();
	friend int P1_EPI_P_SAT_u170_exe_g( Variable* v );
	int P1_EPI_RESP_RT_u171_exe();
	friend int P1_EPI_RESP_RT_u171_exe_g( Variable* v );
	int P1_EPI_SEEDING_RT_u172_exe();
	friend int P1_EPI_SEEDING_RT_u172_exe_g( Variable* v );
	int P1_EPI_TEMP_COEFF_u173_exe();
	friend int P1_EPI_TEMP_COEFF_u173_exe_g( Variable* v );
	int EPI_SHOOT_LIM_u174_exe();
	friend int EPI_SHOOT_LIM_u174_exe_g( Variable* v );
	static EPIPHYTES_module* fInstance;
	static EPIPHYTES_module* kNullModel;
public:
	inline static EPIPHYTES_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new EPIPHYTES_module("EPIPHYTES_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (EPIPHYTES_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}

	inline double Graph3(double x) { 
		static double g[11][2] = {
			{ 0.0000E+00, 2.000000E-02},{ 3.0000E+01, 4.500000E-02},{ 6.0000E+01, 7.500000E-02},{ 9.0000E+01, 1.600000E-01},
			{ 1.2000E+02, 2.500000E-01},{ 1.5000E+02, 4.300000E-01},{ 1.8000E+02, 6.100000E-01},{ 2.1000E+02, 7.800000E-01},
			{ 2.4000E+02, 8.950000E-01},{ 2.7000E+02, 9.500000E-01},{ 3.0000E+02, 1.000000E+00}, };
		return SL::Graph( 0, x, 10, g); 
	}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int EPIPHYTES_I153_exe_g(Variable* obj) { return EPIPHYTES_module::I().EPIPHYTES_I153_exe(); }
int EPIPHYTES_i154_exe_g(Variable* obj) { return EPIPHYTES_module::I().EPIPHYTES_i154_exe(); }
int EPI_GROSS_PP_u155_exe_g(Variable* obj) { return EPIPHYTES_module::I().EPI_GROSS_PP_u155_exe(); }
int EPI_SEEDING_u156_exe_g(Variable* obj) { return EPIPHYTES_module::I().EPI_SEEDING_u156_exe(); }
int EPI_RESP_u157_exe_g(Variable* obj) { return EPIPHYTES_module::I().EPI_RESP_u157_exe(); }
int EPI_CONSUMED_u158_exe_g(Variable* obj) { return EPIPHYTES_module::I().EPI_CONSUMED_u158_exe(); }
int EPI_MORT_u159_exe_g(Variable* obj) { return EPIPHYTES_module::I().EPI_MORT_u159_exe(); }
int EPI_NET_PROD_u160_exe_g(Variable* obj) { return EPIPHYTES_module::I().EPI_NET_PROD_u160_exe(); }
int EPI_NUT_LIMIT_u161_exe_g(Variable* obj) { return EPIPHYTES_module::I().EPI_NUT_LIMIT_u161_exe(); }
int EPI_PROD_LIM_u162_exe_g(Variable* obj) { return EPIPHYTES_module::I().EPI_PROD_LIM_u162_exe(); }
int EPI_TEMP_LIM_u163_exe_g(Variable* obj) { return EPIPHYTES_module::I().EPI_TEMP_LIM_u163_exe(); }
int IC_EPIPHYTES_u164_exe_g(Variable* obj) { return EPIPHYTES_module::I().IC_EPIPHYTES_u164_exe(); }
int P1_EPI_ALPHA_u165_exe_g(Variable* obj) { return EPIPHYTES_module::I().P1_EPI_ALPHA_u165_exe(); }
int P1_EPI_NC_u166_exe_g(Variable* obj) { return EPIPHYTES_module::I().P1_EPI_NC_u166_exe(); }
int P1_EPI_N_SAT_u167_exe_g(Variable* obj) { return EPIPHYTES_module::I().P1_EPI_N_SAT_u167_exe(); }
int P1_EPI_PC_u168_exe_g(Variable* obj) { return EPIPHYTES_module::I().P1_EPI_PC_u168_exe(); }
int P1_EPI_PP_RT_u169_exe_g(Variable* obj) { return EPIPHYTES_module::I().P1_EPI_PP_RT_u169_exe(); }
int P1_EPI_P_SAT_u170_exe_g(Variable* obj) { return EPIPHYTES_module::I().P1_EPI_P_SAT_u170_exe(); }
int P1_EPI_RESP_RT_u171_exe_g(Variable* obj) { return EPIPHYTES_module::I().P1_EPI_RESP_RT_u171_exe(); }
int P1_EPI_SEEDING_RT_u172_exe_g(Variable* obj) { return EPIPHYTES_module::I().P1_EPI_SEEDING_RT_u172_exe(); }
int P1_EPI_TEMP_COEFF_u173_exe_g(Variable* obj) { return EPIPHYTES_module::I().P1_EPI_TEMP_COEFF_u173_exe(); }
int EPI_SHOOT_LIM_u174_exe_g(Variable* obj) { return EPIPHYTES_module::I().EPI_SHOOT_LIM_u174_exe(); }
// ---------------------------------------------------------------------------
//                    Class GLOBAL_module 
// ---------------------------------------------------------------------------

class GLOBAL_module : public TModule {
protected:

	GLOBAL_module(char* name);

public:

	TTime TIME;
	CAuxVariable P1_CELL_SIZE;
	CAuxVariable H2O_TEMP;
	CAuxVariable P1_ON_MAP;
	CAuxVariable P1_AIR_TEMP;
	CAuxVariable EW_VECTOR;
	CAuxVariable EW_WIND_VECTOR;
	CAuxVariable NS_VECTOR;
	CAuxVariable NS_WIND_VECTOR;
	CStateVariable DAYS;
	CAuxVariable SF_WATER;
	CAuxVariable SF_WT_E_X;
	CAuxVariable SF_WT_N_X;
	CAuxVariable SF_WT_S_X;
	CAuxVariable SF_WT_W_X;
	CAuxVariable P1_LEAF_GROW_SEASON;
	CAuxVariable ZOSTRA_LIGHT_LIM;
	CAuxVariable EPI_LIGHT_LIM;
	CAuxVariable TSS_CONC;
	CAuxVariable PHT_CONC;
	CAuxVariable LEAF_LENGTH;
	CStateVariable EPIPHYTES;
	CAuxVariable WATER_DEPTH;
	CAuxVariable PHT_LIGHT_LIM;
	CAuxVariable SW_LIGHT_LIM;
	CAuxVariable CURRENT_VELOCITY;
	CAuxVariable SHEAR_STRESS;
	CFluxVariable COUNT_HOURS;
	CAuxVariable ALPHA;
	CAuxVariable ANGLE;
	CAuxVariable CURRENT_DIRECTION;
	CAuxVariable DW_WAVE_L;
	CAuxVariable EC_H2O;
	CAuxVariable EC_PLANTS;
	CAuxVariable EW_CURRENT_VECTOR;
	CAuxVariable FETCH;
	CAuxVariable G_D;
	CAuxVariable G_F;
	CAuxVariable H1;
	CAuxVariable H2;
	CAuxVariable HA;
	CAuxVariable HABB;
	CAuxVariable HOURS;
	CAuxVariable LIGHT_AT_EPIPHYTES;
	CAuxVariable LIGHT_AT_PLANTS;
	CAuxVariable LIGHT_TO_PHYTOPLANKTON;
	CAuxVariable NS_CURRENT_VECTOR;
	CAuxVariable ORBITAL_VELOCITY;
	CAuxVariable PHOTO_PERIOD;
	CAuxVariable RAND;
	CAuxVariable SDCLN;
	CAuxVariable SF_WT_EW_X;
	CAuxVariable SF_WT_NS_X;
	CAuxVariable SURFACE_LIGHT;
	CAuxVariable T1;
	CAuxVariable T1A;
	CAuxVariable T1AB;
	CAuxVariable T2;
	CAuxVariable TIDE;
	CAuxVariable TOTAL_SF_WT_X;
	CAuxVariable UA_UB;
	CAuxVariable WAVE_HEIGHT;
	CAuxVariable WAVE_L;
	CAuxVariable WAVE_PERIOD;
	CAuxVariable P1_CONVERT_CURRENTS;
	CAuxVariable P1_CONVERT_WSPD;
	CAuxVariable P1_EC_COEFF_SED;
	CAuxVariable P1_EC_COEFF_WATER;
	CAuxVariable P1_EPI_LIGHT_K;
	CAuxVariable P1_F_EAST;
	CAuxVariable P1_F_NORTH;
	CAuxVariable P1_F_SOUTH;
	CAuxVariable P1_F_WEST;
	CAuxVariable P1_IC_SED_ELEV;
	CAuxVariable P1_LATITUDE;
	CAuxVariable P1_MAX_EC_COEFF_PLANTS;
	CAuxVariable P1_PHYTO_LIGHT_K;
	CAuxVariable P1_SW_LIGHT_K;
	CAuxVariable P1_ZOSTRA_LIGHT_K;
	CAuxVariable DECLINE;
	CAuxVariable FRIC_COEF;
	CAuxVariable H_ANGLE;
	CAuxVariable SKEW_WEATHER;
	CAuxVariable P1_PRECIPITATION;
	CAuxVariable P1_WIND_DIRECTION;
	CAuxVariable P1_WIND_SPEED;
protected:

	int DAYS_I175_exe();
	friend int DAYS_I175_exe_g( Variable* v );
	int DAYS_i176_exe();
	friend int DAYS_i176_exe_g( Variable* v );
	int COUNT_HOURS_u177_exe();
	friend int COUNT_HOURS_u177_exe_g( Variable* v );
	int ALPHA_u178_exe();
	friend int ALPHA_u178_exe_g( Variable* v );
	int ANGLE_u179_exe();
	friend int ANGLE_u179_exe_g( Variable* v );
	int CURRENT_DIRECTION_u180_exe();
	friend int CURRENT_DIRECTION_u180_exe_g( Variable* v );
	int CURRENT_VELOCITY_u181_exe();
	friend int CURRENT_VELOCITY_u181_exe_g( Variable* v );
	int DW_WAVE_L_u182_exe();
	friend int DW_WAVE_L_u182_exe_g( Variable* v );
	int EC_H2O_u183_exe();
	friend int EC_H2O_u183_exe_g( Variable* v );
	int EC_PLANTS_u184_exe();
	friend int EC_PLANTS_u184_exe_g( Variable* v );
	int EPI_LIGHT_LIM_u185_exe();
	friend int EPI_LIGHT_LIM_u185_exe_g( Variable* v );
	int EW_CURRENT_VECTOR_u186_exe();
	friend int EW_CURRENT_VECTOR_u186_exe_g( Variable* v );
	int EW_VECTOR_u187_exe();
	friend int EW_VECTOR_u187_exe_g( Variable* v );
	int EW_WIND_VECTOR_u188_exe();
	friend int EW_WIND_VECTOR_u188_exe_g( Variable* v );
	int FETCH_u189_exe();
	friend int FETCH_u189_exe_g( Variable* v );
	int G_D_u190_exe();
	friend int G_D_u190_exe_g( Variable* v );
	int G_F_u191_exe();
	friend int G_F_u191_exe_g( Variable* v );
	int H1_u192_exe();
	friend int H1_u192_exe_g( Variable* v );
	int H2_u193_exe();
	friend int H2_u193_exe_g( Variable* v );
	int H2O_TEMP_u194_exe();
	friend int H2O_TEMP_u194_exe_g( Variable* v );
	int HA_u195_exe();
	friend int HA_u195_exe_g( Variable* v );
	int HABB_u196_exe();
	friend int HABB_u196_exe_g( Variable* v );
	int HOURS_u197_exe();
	friend int HOURS_u197_exe_g( Variable* v );
	int LIGHT_AT_EPIPHYTES_u198_exe();
	friend int LIGHT_AT_EPIPHYTES_u198_exe_g( Variable* v );
	int LIGHT_AT_PLANTS_u199_exe();
	friend int LIGHT_AT_PLANTS_u199_exe_g( Variable* v );
	int LIGHT_TO_PHYTOPLANKTON_u200_exe();
	friend int LIGHT_TO_PHYTOPLANKTON_u200_exe_g( Variable* v );
	int NS_CURRENT_VECTOR_u201_exe();
	friend int NS_CURRENT_VECTOR_u201_exe_g( Variable* v );
	int NS_VECTOR_u202_exe();
	friend int NS_VECTOR_u202_exe_g( Variable* v );
	int NS_WIND_VECTOR_u203_exe();
	friend int NS_WIND_VECTOR_u203_exe_g( Variable* v );
	int ORBITAL_VELOCITY_u204_exe();
	friend int ORBITAL_VELOCITY_u204_exe_g( Variable* v );
	int PHOTO_PERIOD_u205_exe();
	friend int PHOTO_PERIOD_u205_exe_g( Variable* v );
	int PHT_LIGHT_LIM_u206_exe();
	friend int PHT_LIGHT_LIM_u206_exe_g( Variable* v );
	int RAND_u207_exe();
	friend int RAND_u207_exe_g( Variable* v );
	int SDCLN_u208_exe();
	friend int SDCLN_u208_exe_g( Variable* v );
	int SF_WATER_u209_exe();
	friend int SF_WATER_u209_exe_g( Variable* v );
	int SF_WT_EW_X_u210_exe();
	friend int SF_WT_EW_X_u210_exe_g( Variable* v );
	int SF_WT_E_X_u211_exe();
	friend int SF_WT_E_X_u211_exe_g( Variable* v );
	int SF_WT_NS_X_u212_exe();
	friend int SF_WT_NS_X_u212_exe_g( Variable* v );
	int SF_WT_N_X_u213_exe();
	friend int SF_WT_N_X_u213_exe_g( Variable* v );
	int SF_WT_S_X_u214_exe();
	friend int SF_WT_S_X_u214_exe_g( Variable* v );
	int SF_WT_W_X_u215_exe();
	friend int SF_WT_W_X_u215_exe_g( Variable* v );
	int SHEAR_STRESS_u216_exe();
	friend int SHEAR_STRESS_u216_exe_g( Variable* v );
	int SURFACE_LIGHT_u217_exe();
	friend int SURFACE_LIGHT_u217_exe_g( Variable* v );
	int SW_LIGHT_LIM_u218_exe();
	friend int SW_LIGHT_LIM_u218_exe_g( Variable* v );
	int T1_u219_exe();
	friend int T1_u219_exe_g( Variable* v );
	int T1A_u220_exe();
	friend int T1A_u220_exe_g( Variable* v );
	int T1AB_u221_exe();
	friend int T1AB_u221_exe_g( Variable* v );
	int T2_u222_exe();
	friend int T2_u222_exe_g( Variable* v );
	int TIDE_u223_exe();
	friend int TIDE_u223_exe_g( Variable* v );
	int TOTAL_SF_WT_X_u224_exe();
	friend int TOTAL_SF_WT_X_u224_exe_g( Variable* v );
	int UA_UB_u225_exe();
	friend int UA_UB_u225_exe_g( Variable* v );
	int WATER_DEPTH_u226_exe();
	friend int WATER_DEPTH_u226_exe_g( Variable* v );
	int WAVE_HEIGHT_u227_exe();
	friend int WAVE_HEIGHT_u227_exe_g( Variable* v );
	int WAVE_L_u228_exe();
	friend int WAVE_L_u228_exe_g( Variable* v );
	int WAVE_PERIOD_u229_exe();
	friend int WAVE_PERIOD_u229_exe_g( Variable* v );
	int ZOSTRA_LIGHT_LIM_u230_exe();
	friend int ZOSTRA_LIGHT_LIM_u230_exe_g( Variable* v );
	int P1_CELL_SIZE_u231_exe();
	friend int P1_CELL_SIZE_u231_exe_g( Variable* v );
	int P1_CONVERT_CURRENTS_u232_exe();
	friend int P1_CONVERT_CURRENTS_u232_exe_g( Variable* v );
	int P1_CONVERT_WSPD_u233_exe();
	friend int P1_CONVERT_WSPD_u233_exe_g( Variable* v );
	int P1_EC_COEFF_SED_u234_exe();
	friend int P1_EC_COEFF_SED_u234_exe_g( Variable* v );
	int P1_EC_COEFF_WATER_u235_exe();
	friend int P1_EC_COEFF_WATER_u235_exe_g( Variable* v );
	int P1_EPI_LIGHT_K_u236_exe();
	friend int P1_EPI_LIGHT_K_u236_exe_g( Variable* v );
	int P1_F_EAST_u237_exe();
	friend int P1_F_EAST_u237_exe_g( Variable* v );
	int P1_F_NORTH_u238_exe();
	friend int P1_F_NORTH_u238_exe_g( Variable* v );
	int P1_F_SOUTH_u239_exe();
	friend int P1_F_SOUTH_u239_exe_g( Variable* v );
	int P1_F_WEST_u240_exe();
	friend int P1_F_WEST_u240_exe_g( Variable* v );
	int P1_IC_SED_ELEV_u241_exe();
	friend int P1_IC_SED_ELEV_u241_exe_g( Variable* v );
	int P1_LATITUDE_u242_exe();
	friend int P1_LATITUDE_u242_exe_g( Variable* v );
	int P1_MAX_EC_COEFF_PLANTS_u243_exe();
	friend int P1_MAX_EC_COEFF_PLANTS_u243_exe_g( Variable* v );
	int P1_ON_MAP_u244_exe();
	friend int P1_ON_MAP_u244_exe_g( Variable* v );
	int P1_PHYTO_LIGHT_K_u245_exe();
	friend int P1_PHYTO_LIGHT_K_u245_exe_g( Variable* v );
	int P1_SW_LIGHT_K_u246_exe();
	friend int P1_SW_LIGHT_K_u246_exe_g( Variable* v );
	int P1_ZOSTRA_LIGHT_K_u247_exe();
	friend int P1_ZOSTRA_LIGHT_K_u247_exe_g( Variable* v );
	int DECLINE_u248_exe();
	friend int DECLINE_u248_exe_g( Variable* v );
	int FRIC_COEF_u249_exe();
	friend int FRIC_COEF_u249_exe_g( Variable* v );
	int H_ANGLE_u250_exe();
	friend int H_ANGLE_u250_exe_g( Variable* v );
	int SKEW_WEATHER_u251_exe();
	friend int SKEW_WEATHER_u251_exe_g( Variable* v );
	int P1_AIR_TEMP_u252_exe();
	friend int P1_AIR_TEMP_u252_exe_g( Variable* v );
	int P1_LEAF_GROW_SEASON_u253_exe();
	friend int P1_LEAF_GROW_SEASON_u253_exe_g( Variable* v );
	int P1_PRECIPITATION_u254_exe();
	friend int P1_PRECIPITATION_u254_exe_g( Variable* v );
	int P1_WIND_DIRECTION_u255_exe();
	friend int P1_WIND_DIRECTION_u255_exe_g( Variable* v );
	int P1_WIND_SPEED_u256_exe();
	friend int P1_WIND_SPEED_u256_exe_g( Variable* v );
	static GLOBAL_module* fInstance;
	static GLOBAL_module* kNullModel;
public:
	inline static GLOBAL_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new GLOBAL_module("GLOBAL_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (GLOBAL_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}

	inline double Graph4(double x) { 
		static double g[9][2] = {
			{ -1.0000E+00, -1.570000E+00},{ -7.5000E-01, -1.120000E+00},{ -5.0000E-01, -6.440000E-01},{ -2.5000E-01, -3.050000E-01},
			{ 0.0000E+00, 0.000000E+00},{ 2.5000E-01, 3.050000E-01},{ 5.0000E-01, 6.440000E-01},{ 7.5000E-01, 1.120000E+00},
			{ 1.0000E+00, 1.570000E+00}, };
		return SL::Graph( 0, x, 8, g); 
	}

	inline double Graph5(double x) { 
		static double g[11][2] = {
			{ 0.0000E+00, 1.250000E-02},{ 1.6000E-01, 1.230000E-02},{ 3.2000E-01, 1.200000E-02},{ 4.8000E-01, 1.150000E-02},
			{ 6.4000E-01, 1.070000E-02},{ 8.0000E-01, 9.430000E-03},{ 9.6000E-01, 8.040000E-03},{ 1.1200E+00, 6.990000E-03},
			{ 1.2800E+00, 6.050000E-03},{ 1.4400E+00, 5.450000E-03},{ 1.6000E+00, 5.080000E-03}, };
		return SL::Graph( 0, x, 10, g); 
	}

	inline double Graph6(double x) { 
		static double g[9][2] = {
			{ -1.0000E+00, 3.140000E+00},{ -7.5000E-01, 2.420000E+00},{ -5.0000E-01, 2.090000E+00},{ -2.5000E-01, 1.820000E+00},
			{ 0.0000E+00, 1.570000E+00},{ 2.5000E-01, 1.320000E+00},{ 5.0000E-01, 1.050000E+00},{ 7.5000E-01, 7.230000E-01},
			{ 1.0000E+00, 0.000000E+00}, };
		return SL::Graph( 0, x, 8, g); 
	}

	inline double Graph7(double x) { 
		static double g[11][2] = {
			{ 0.0000E+00, 0.000000E+00},{ 1.0000E+01, 3.700000E-02},{ 2.0000E+01, 8.000000E-02},{ 3.0000E+01, 1.290000E-01},
			{ 4.0000E+01, 1.880000E-01},{ 5.0000E+01, 2.640000E-01},{ 6.0000E+01, 3.810000E-01},{ 7.0000E+01, 5.090000E-01},
			{ 8.0000E+01, 6.590000E-01},{ 9.0000E+01, 8.040000E-01},{ 1.0000E+02, 9.560000E-01}, };
		return SL::Graph( 0, x, 10, g); 
	}

	inline double Graph8(double x) { 
		static double g[365][2] = {
			{ 0.0000E+00, -7.800000E+00},{ 1.0000E+00, -9.400000E+00},{ 2.0100E+00, -1.110000E+01},{ 3.0100E+00, -8.900000E+00},
			{ 4.0100E+00, -7.800000E+00},{ 5.0100E+00, -8.300000E+00},{ 6.0200E+00, -5.000000E+00},{ 7.0200E+00, -6.100000E+00},
			{ 8.0200E+00, -7.200000E+00},{ 9.0200E+00, -8.900000E+00},{ 1.0000E+01, -9.400000E+00},{ 1.1000E+01, -7.200000E+00},
			{ 1.2000E+01, -7.200000E+00},{ 1.3000E+01, -4.400000E+00},{ 1.4000E+01, -5.000000E+00},{ 1.5000E+01, -5.600000E+00},
			{ 1.6000E+01, -1.220000E+01},{ 1.7000E+01, -1.670000E+01},{ 1.8000E+01, -1.220000E+01},{ 1.9100E+01, -1.330000E+01},
			{ 2.0100E+01, -1.000000E+01},{ 2.1100E+01, -1.060000E+01},{ 2.2100E+01, -8.300000E+00},{ 2.3100E+01, -8.300000E+00},
			{ 2.4100E+01, -1.500000E+01},{ 2.5100E+01, -1.720000E+01},{ 2.6100E+01, -1.670000E+01},{ 2.7100E+01, -1.330000E+01},
			{ 2.8100E+01, -9.400000E+00},{ 2.9100E+01, -1.110000E+01},{ 3.0100E+01, -8.900000E+00},{ 3.1100E+01, -8.300000E+00},
			{ 3.2100E+01, -4.400000E+00},{ 3.3100E+01, -4.400000E+00},{ 3.4100E+01, -6.100000E+00},{ 3.5100E+01, -8.900000E+00},
			{ 3.6100E+01, -8.300000E+00},{ 3.7100E+01, -2.200000E+00},{ 3.8100E+01, -6.100000E+00},{ 3.9100E+01, -7.800000E+00},
			{ 4.0100E+01, -1.000000E+01},{ 4.1100E+01, -1.170000E+01},{ 4.2100E+01, -1.280000E+01},{ 4.3100E+01, -1.330000E+01},
			{ 4.4100E+01, -1.940000E+01},{ 4.5100E+01, -2.060000E+01},{ 4.6100E+01, -1.060000E+01},{ 4.7100E+01, -5.000000E+00},
			{ 4.8100E+01, -7.800000E+00},{ 4.9100E+01, -8.900000E+00},{ 5.0100E+01, -9.400000E+00},{ 5.1100E+01, -6.700000E+00},
			{ 5.2100E+01, -4.400000E+00},{ 5.3100E+01, -5.600000E+00},{ 5.4100E+01, -7.800000E+00},{ 5.5200E+01, -6.700000E+00},
			{ 5.6200E+01, -4.400000E+00},{ 5.7200E+01, -3.300000E+00},{ 5.8200E+01, -1.700000E+00},{ 5.9200E+01, -4.400000E+00},
			{ 6.0200E+01, -9.400000E+00},{ 6.1200E+01, -9.400000E+00},{ 6.2200E+01, -9.400000E+00},{ 6.3200E+01, -6.700000E+00},
			{ 6.4200E+01, -2.800000E+00},{ 6.5200E+01, 2.800000E+00},{ 6.6200E+01, 6.100000E+00},{ 6.7200E+01, -6.000000E-01},
			{ 6.8200E+01, -8.900000E+00},{ 6.9200E+01, -1.000000E+01},{ 7.0200E+01, -7.200000E+00},{ 7.1200E+01, -9.400000E+00},
			{ 7.2200E+01, -6.100000E+00},{ 7.3200E+01, -5.000000E+00},{ 7.4200E+01, -5.600000E+00},{ 7.5200E+01, -7.800000E+00},
			{ 7.6200E+01, -3.300000E+00},{ 7.7200E+01, -4.400000E+00},{ 7.8200E+01, -5.000000E+00},{ 7.9200E+01, -6.100000E+00},
			{ 8.0200E+01, -3.900000E+00},{ 8.1200E+01, -1.700000E+00},{ 8.2200E+01, 7.200000E+00},{ 8.3200E+01, 9.400000E+00},
			{ 8.4200E+01, 3.900000E+00},{ 8.5200E+01, 5.600000E+00},{ 8.6200E+01, 2.800000E+00},{ 8.7200E+01, 6.700000E+00},
			{ 8.8200E+01, 6.700000E+00},{ 8.9200E+01, 2.200000E+00},{ 9.0200E+01, 2.800000E+00},{ 9.1300E+01, 2.200000E+00},
			{ 9.2300E+01, 5.600000E+00},{ 9.3300E+01, 3.300000E+00},{ 9.4300E+01, -6.000000E-01},{ 9.5300E+01, -3.300000E+00},
			{ 9.6300E+01, -3.300000E+00},{ 9.7300E+01, 0.000000E+00},{ 9.8300E+01, 0.000000E+00},{ 9.9300E+01, 9.400000E+00},
			{ 1.0000E+02, 1.280000E+01},{ 1.0100E+02, 1.000000E+01},{ 1.0200E+02, 7.200000E+00},{ 1.0300E+02, 6.100000E+00},
			{ 1.0400E+02, 5.000000E+00},{ 1.0500E+02, 4.400000E+00},{ 1.0600E+02, -3.300000E+00},{ 1.0700E+02, 2.800000E+00},
			{ 1.0800E+02, 8.300000E+00},{ 1.0900E+02, 6.700000E+00},{ 1.1000E+02, 1.220000E+01},{ 1.1100E+02, 1.220000E+01},
			{ 1.1200E+02, 1.700000E+00},{ 1.1300E+02, 8.900000E+00},{ 1.1400E+02, 7.800000E+00},{ 1.1500E+02, 3.300000E+00},
			{ 1.1600E+02, 6.000000E-01},{ 1.1700E+02, -1.700000E+00},{ 1.1800E+02, -1.100000E+00},{ 1.1900E+02, 2.200000E+00},
			{ 1.2000E+02, 5.600000E+00},{ 1.2100E+02, 1.060000E+01},{ 1.2200E+02, 8.300000E+00},{ 1.2300E+02, 5.000000E+00},
			{ 1.2400E+02, -1.100000E+00},{ 1.2500E+02, -1.700000E+00},{ 1.2600E+02, 1.330000E+01},{ 1.2700E+02, 1.110000E+01},
			{ 1.2800E+02, 1.170000E+01},{ 1.2900E+02, 1.940000E+01},{ 1.3000E+02, 1.720000E+01},{ 1.3100E+02, 1.280000E+01},
			{ 1.3200E+02, 1.110000E+01},{ 1.3300E+02, 7.800000E+00},{ 1.3400E+02, 1.060000E+01},{ 1.3500E+02, 1.060000E+01},
			{ 1.3600E+02, 1.280000E+01},{ 1.3700E+02, 1.170000E+01},{ 1.3800E+02, 6.100000E+00},{ 1.3900E+02, 5.600000E+00},
			{ 1.4000E+02, 1.000000E+01},{ 1.4100E+02, 1.780000E+01},{ 1.4200E+02, 1.670000E+01},{ 1.4300E+02, 6.000000E-01},
			{ 1.4400E+02, 7.200000E+00},{ 1.4500E+02, 1.110000E+01},{ 1.4600E+02, 1.000000E+01},{ 1.4700E+02, 1.890000E+01},
			{ 1.4800E+02, 1.940000E+01},{ 1.4900E+02, 2.330000E+01},{ 1.5000E+02, 2.440000E+01},{ 1.5100E+02, 2.000000E+01},
			{ 1.5200E+02, 1.940000E+01},{ 1.5300E+02, 8.300000E+00},{ 1.5400E+02, 5.600000E+00},{ 1.5500E+02, 1.170000E+01},
			{ 1.5600E+02, 1.110000E+01},{ 1.5700E+02, 1.220000E+01},{ 1.5800E+02, 1.170000E+01},{ 1.5900E+02, 1.330000E+01},
			{ 1.6000E+02, 1.170000E+01},{ 1.6100E+02, 1.500000E+01},{ 1.6200E+02, 1.440000E+01},{ 1.6300E+02, 1.780000E+01},
			{ 1.6400E+02, 1.830000E+01},{ 1.6500E+02, 1.890000E+01},{ 1.6600E+02, 1.890000E+01},{ 1.6700E+02, 1.780000E+01},
			{ 1.6800E+02, 1.670000E+01},{ 1.6900E+02, 2.000000E+01},{ 1.7000E+02, 2.000000E+01},{ 1.7100E+02, 1.780000E+01},
			{ 1.7200E+02, 1.330000E+01},{ 1.7300E+02, 8.300000E+00},{ 1.7400E+02, 1.890000E+01},{ 1.7500E+02, 1.830000E+01},
			{ 1.7600E+02, 7.200000E+00},{ 1.7700E+02, 6.100000E+00},{ 1.7800E+02, 1.440000E+01},{ 1.7900E+02, 1.780000E+01},
			{ 1.8000E+02, 1.940000E+01},{ 1.8100E+02, 1.720000E+01},{ 1.8200E+02, 1.280000E+01},{ 1.8400E+02, 8.300000E+00},
			{ 1.8500E+02, 1.940000E+01},{ 1.8600E+02, 1.780000E+01},{ 1.8700E+02, 1.780000E+01},{ 1.8800E+02, 1.610000E+01},
			{ 1.8900E+02, 1.500000E+01},{ 1.9000E+02, 2.060000E+01},{ 1.9100E+02, 1.830000E+01},{ 1.9200E+02, 1.560000E+01},
			{ 1.9300E+02, 1.560000E+01},{ 1.9400E+02, 1.560000E+01},{ 1.9500E+02, 1.670000E+01},{ 1.9600E+02, 1.670000E+01},
			{ 1.9700E+02, 1.330000E+01},{ 1.9800E+02, 1.670000E+01},{ 1.9900E+02, 2.220000E+01},{ 2.0000E+02, 2.060000E+01},
			{ 2.0100E+02, 1.610000E+01},{ 2.0200E+02, 1.440000E+01},{ 2.0300E+02, 1.500000E+01},{ 2.0400E+02, 1.890000E+01},
			{ 2.0500E+02, 2.330000E+01},{ 2.0600E+02, 2.280000E+01},{ 2.0700E+02, 1.940000E+01},{ 2.0800E+02, 1.830000E+01},
			{ 2.0900E+02, 1.500000E+01},{ 2.1000E+02, 1.280000E+01},{ 2.1100E+02, 1.610000E+01},{ 2.1200E+02, 1.500000E+01},
			{ 2.1300E+02, 1.560000E+01},{ 2.1400E+02, 1.500000E+01},{ 2.1500E+02, 1.610000E+01},{ 2.1600E+02, 1.830000E+01},
			{ 2.1700E+02, 1.560000E+01},{ 2.1800E+02, 1.440000E+01},{ 2.1900E+02, 1.440000E+01},{ 2.2000E+02, 2.000000E+01},
			{ 2.2100E+02, 1.720000E+01},{ 2.2200E+02, 1.060000E+01},{ 2.2300E+02, 1.560000E+01},{ 2.2400E+02, 1.440000E+01},
			{ 2.2500E+02, 1.500000E+01},{ 2.2600E+02, 1.780000E+01},{ 2.2700E+02, 1.940000E+01},{ 2.2800E+02, 2.330000E+01},
			{ 2.2900E+02, 2.440000E+01},{ 2.3000E+02, 2.330000E+01},{ 2.3100E+02, 2.110000E+01},{ 2.3200E+02, 1.780000E+01},
			{ 2.3300E+02, 1.720000E+01},{ 2.3400E+02, 1.560000E+01},{ 2.3500E+02, 1.170000E+01},{ 2.3600E+02, 1.060000E+01},
			{ 2.3700E+02, 1.330000E+01},{ 2.3800E+02, 1.220000E+01},{ 2.3900E+02, 1.220000E+01},{ 2.4000E+02, 7.800000E+00},
			{ 2.4100E+02, 6.100000E+00},{ 2.4200E+02, 1.440000E+01},{ 2.4300E+02, 1.560000E+01},{ 2.4400E+02, 1.390000E+01},
			{ 2.4500E+02, 1.170000E+01},{ 2.4600E+02, 1.060000E+01},{ 2.4700E+02, 1.110000E+01},{ 2.4800E+02, 1.500000E+01},
			{ 2.4900E+02, 1.390000E+01},{ 2.5000E+02, 1.330000E+01},{ 2.5100E+02, 1.670000E+01},{ 2.5200E+02, 1.670000E+01},
			{ 2.5300E+02, 1.780000E+01},{ 2.5400E+02, 1.500000E+01},{ 2.5500E+02, 1.000000E+01},{ 2.5600E+02, 7.200000E+00},
			{ 2.5700E+02, 1.440000E+01},{ 2.5800E+02, 1.280000E+01},{ 2.5900E+02, 1.500000E+01},{ 2.6000E+02, 1.330000E+01},
			{ 2.6100E+02, 6.700000E+00},{ 2.6200E+02, 3.900000E+00},{ 2.6300E+02, 2.800000E+00},{ 2.6400E+02, 6.100000E+00},
			{ 2.6500E+02, 7.200000E+00},{ 2.6600E+02, 1.000000E+01},{ 2.6700E+02, 8.300000E+00},{ 2.6800E+02, 7.200000E+00},
			{ 2.6900E+02, 8.900000E+00},{ 2.7000E+02, 7.200000E+00},{ 2.7100E+02, 1.280000E+01},{ 2.7200E+02, 1.670000E+01},
			{ 2.7300E+02, 1.330000E+01},{ 2.7400E+02, 7.800000E+00},{ 2.7500E+02, 9.400000E+00},{ 2.7600E+02, 1.110000E+01},
			{ 2.7700E+02, 7.200000E+00},{ 2.7800E+02, 8.300000E+00},{ 2.7900E+02, 1.060000E+01},{ 2.8000E+02, 7.800000E+00},
			{ 2.8100E+02, 6.700000E+00},{ 2.8200E+02, 3.300000E+00},{ 2.8300E+02, 8.300000E+00},{ 2.8400E+02, 5.600000E+00},
			{ 2.8500E+02, -6.000000E-01},{ 2.8600E+02, 2.200000E+00},{ 2.8700E+02, 3.300000E+00},{ 2.8800E+02, 7.800000E+00},
			{ 2.8900E+02, 5.600000E+00},{ 2.9000E+02, 6.100000E+00},{ 2.9100E+02, 9.400000E+00},{ 2.9200E+02, 8.300000E+00},
			{ 2.9300E+02, 3.900000E+00},{ 2.9400E+02, 7.200000E+00},{ 2.9500E+02, 0.000000E+00},{ 2.9600E+02, 2.800000E+00},
			{ 2.9700E+02, 7.800000E+00},{ 2.9800E+02, 4.400000E+00},{ 2.9900E+02, 2.800000E+00},{ 3.0000E+02, 1.700000E+00},
			{ 3.0100E+02, 6.700000E+00},{ 3.0200E+02, 3.300000E+00},{ 3.0300E+02, 1.700000E+00},{ 3.0400E+02, 2.200000E+00},
			{ 3.0500E+02, 2.800000E+00},{ 3.0600E+02, -6.000000E-01},{ 3.0700E+02, 2.200000E+00},{ 3.0800E+02, 1.330000E+01},
			{ 3.0900E+02, 7.800000E+00},{ 3.1000E+02, 6.000000E-01},{ 3.1100E+02, -4.400000E+00},{ 3.1200E+02, 1.100000E+00},
			{ 3.1300E+02, 6.700000E+00},{ 3.1400E+02, 3.900000E+00},{ 3.1500E+02, -9.400000E+00},{ 3.1600E+02, -6.700000E+00},
			{ 3.1700E+02, -6.000000E-01},{ 3.1800E+02, 2.200000E+00},{ 3.1900E+02, 6.000000E-01},{ 3.2000E+02, -1.100000E+00},
			{ 3.2100E+02, 6.000000E-01},{ 3.2200E+02, 1.110000E+01},{ 3.2300E+02, 5.600000E+00},{ 3.2400E+02, -4.400000E+00},
			{ 3.2500E+02, -5.000000E+00},{ 3.2600E+02, -1.000000E+01},{ 3.2700E+02, -4.400000E+00},{ 3.2800E+02, 3.900000E+00},
			{ 3.2900E+02, -2.200000E+00},{ 3.3000E+02, -3.300000E+00},{ 3.3100E+02, -3.300000E+00},{ 3.3200E+02, -7.800000E+00},
			{ 3.3300E+02, -5.600000E+00},{ 3.3400E+02, 2.200000E+00},{ 3.3500E+02, 2.200000E+00},{ 3.3600E+02, -3.300000E+00},
			{ 3.3700E+02, -6.100000E+00},{ 3.3800E+02, -8.900000E+00},{ 3.3900E+02, -8.900000E+00},{ 3.4000E+02, -7.800000E+00},
			{ 3.4100E+02, -1.700000E+00},{ 3.4200E+02, -2.800000E+00},{ 3.4300E+02, 2.800000E+00},{ 3.4400E+02, 2.800000E+00},
			{ 3.4500E+02, -2.800000E+00},{ 3.4600E+02, -5.000000E+00},{ 3.4700E+02, -4.400000E+00},{ 3.4800E+02, -3.300000E+00},
			{ 3.4900E+02, -6.700000E+00},{ 3.5000E+02, -8.900000E+00},{ 3.5100E+02, -1.000000E+01},{ 3.5200E+02, -1.220000E+01},
			{ 3.5300E+02, -7.800000E+00},{ 3.5400E+02, -8.900000E+00},{ 3.5500E+02, -4.400000E+00},{ 3.5600E+02, -5.000000E+00},
			{ 3.5700E+02, -4.400000E+00},{ 3.5800E+02, -5.000000E+00},{ 3.5900E+02, -5.600000E+00},{ 3.6000E+02, -5.600000E+00},
			{ 3.6100E+02, -8.300000E+00},{ 3.6200E+02, -1.060000E+01},{ 3.6300E+02, -1.560000E+01},{ 3.6400E+02, -2.000000E+01},
			{ 3.6500E+02, -1.060000E+01}, };
		return SL::Graph( 0, x, 364, g); 
	}

	inline double Graph9(double x) { 
		static double g[11][2] = {
			{ 1.0000E+00, 4.000000E-02},{ 3.7400E+01, 4.500000E-02},{ 7.3800E+01, 5.500000E-02},{ 1.1000E+02, 7.000000E-02},
			{ 1.4700E+02, 1.450000E-01},{ 1.8300E+02, 3.300000E-01},{ 2.1900E+02, 9.900000E-01},{ 2.5600E+02, 9.800000E-01},
			{ 2.9200E+02, 6.350000E-01},{ 3.2900E+02, 3.050000E-01},{ 3.6500E+02, 1.100000E-01}, };
		return SL::Graph( 0, x, 10, g); 
	}

	inline double Graph10(double x) { 
		static double g[11][2] = {
			{ 0.0000E+00, 0.000000E+00},{ 1.0000E+01, 0.000000E+00},{ 2.0000E+01, 0.000000E+00},{ 3.0000E+01, 0.000000E+00},
			{ 4.0000E+01, 0.000000E+00},{ 5.0000E+01, 0.000000E+00},{ 6.0000E+01, 0.000000E+00},{ 7.0000E+01, 0.000000E+00},
			{ 8.0000E+01, 0.000000E+00},{ 9.0000E+01, 0.000000E+00},{ 1.0000E+02, 0.000000E+00}, };
		return SL::Graph( 0, x, 10, g); 
	}

	inline double Graph11(double x) { 
		static double g[365][2] = {
			{ 1.0000E+00, 2.530000E+02},{ 2.0000E+00, 2.280000E+02},{ 3.0000E+00, 2.120000E+02},{ 4.0000E+00, 2.370000E+02},
			{ 5.0000E+00, 2.040000E+02},{ 6.0000E+00, 2.410000E+02},{ 7.0000E+00, 2.750000E+02},{ 8.0000E+00, 2.830000E+02},
			{ 9.0000E+00, 2.200000E+02},{ 1.0000E+01, 2.370000E+02},{ 1.1000E+01, 2.670000E+02},{ 1.2000E+01, 2.010000E+02},
			{ 1.3000E+01, 2.510000E+02},{ 1.4000E+01, 3.280000E+02},{ 1.5000E+01, 2.860000E+02},{ 1.6000E+01, 2.470000E+02},
			{ 1.7000E+01, 1.780000E+02},{ 1.8000E+01, 2.040000E+02},{ 1.9000E+01, 1.470000E+02},{ 2.0000E+01, 1.840000E+02},
			{ 2.1000E+01, 2.570000E+02},{ 2.2000E+01, 1.840000E+02},{ 2.3000E+01, 2.990000E+02},{ 2.4000E+01, 2.730000E+02},
			{ 2.5000E+01, 2.500000E+02},{ 2.6000E+01, 1.480000E+02},{ 2.7000E+01, 1.630000E+02},{ 2.8000E+01, 2.620000E+02},
			{ 2.9000E+01, 2.410000E+02},{ 3.0000E+01, 2.070000E+02},{ 3.1000E+01, 2.590000E+02},{ 3.2000E+01, 2.180000E+02},
			{ 3.3000E+01, 2.410000E+02},{ 3.4000E+01, 2.690000E+02},{ 3.5000E+01, 1.860000E+02},{ 3.6000E+01, 2.850000E+02},
			{ 3.7000E+01, 2.980000E+02},{ 3.8000E+01, 2.250000E+02},{ 3.9000E+01, 2.570000E+02},{ 4.0000E+01, 1.990000E+02},
			{ 4.1000E+01, 2.220000E+02},{ 4.2000E+01, 2.890000E+02},{ 4.3000E+01, 2.870000E+02},{ 4.4000E+01, 2.410000E+02},
			{ 4.5000E+01, 1.800000E+02},{ 4.6000E+01, 2.950000E+02},{ 4.7000E+01, 2.720000E+02},{ 4.8000E+01, 1.970000E+02},
			{ 4.9000E+01, 8.600000E+01},{ 5.0000E+01, 1.710000E+02},{ 5.1000E+01, 1.850000E+02},{ 5.2000E+01, 1.570000E+02},
			{ 5.3000E+01, 2.770000E+02},{ 5.4000E+01, 2.230000E+02},{ 5.5000E+01, 2.350000E+02},{ 5.6000E+01, 3.090000E+02},
			{ 5.7000E+01, 2.750000E+02},{ 5.8000E+01, 2.580000E+02},{ 5.9000E+01, 2.410000E+02},{ 6.0000E+01, 2.240000E+02},
			{ 6.1000E+01, 2.930000E+02},{ 6.2000E+01, 1.770000E+02},{ 6.3000E+01, 1.850000E+02},{ 6.4000E+01, 2.080000E+02},
			{ 6.5000E+01, 1.290000E+02},{ 6.6000E+01, 2.530000E+02},{ 6.7000E+01, 2.950000E+02},{ 6.8000E+01, 2.050000E+02},
			{ 6.9000E+01, 2.070000E+02},{ 7.0000E+01, 2.790000E+02},{ 7.1000E+01, 2.140000E+02},{ 7.2000E+01, 8.200000E+01},
			{ 7.3000E+01, 1.870000E+02},{ 7.4000E+01, 1.700000E+02},{ 7.5000E+01, 1.420000E+02},{ 7.6000E+01, 2.520000E+02},
			{ 7.7000E+01, 2.110000E+02},{ 7.8000E+01, 1.860000E+02},{ 7.9000E+01, 2.790000E+02},{ 8.0000E+01, 2.700000E+02},
			{ 8.1000E+01, 2.150000E+02},{ 8.2000E+01, 1.850000E+02},{ 8.3000E+01, 2.680000E+02},{ 8.4000E+01, 2.010000E+02},
			{ 8.5000E+01, 1.850000E+02},{ 8.6000E+01, 1.810000E+02},{ 8.7000E+01, 2.610000E+02},{ 8.8000E+01, 1.980000E+02},
			{ 8.9000E+01, 1.480000E+02},{ 9.0000E+01, 2.910000E+02},{ 9.1000E+01, 1.960000E+02},{ 9.2000E+01, 2.450000E+02},
			{ 9.3000E+01, 2.840000E+02},{ 9.4000E+01, 2.010000E+02},{ 9.5000E+01, 1.000000E+02},{ 9.6000E+01, 1.430000E+02},
			{ 9.7000E+01, 6.500000E+01},{ 9.8000E+01, 1.470000E+02},{ 9.9000E+01, 1.890000E+02},{ 1.0000E+02, 2.690000E+02},
			{ 1.0100E+02, 1.530000E+02},{ 1.0200E+02, 1.810000E+02},{ 1.0300E+02, 1.980000E+02},{ 1.0400E+02, 1.720000E+02},
			{ 1.0500E+02, 1.780000E+02},{ 1.0600E+02, 1.980000E+02},{ 1.0700E+02, 1.390000E+02},{ 1.0800E+02, 1.010000E+02},
			{ 1.0900E+02, 1.380000E+02},{ 1.1000E+02, 1.540000E+02},{ 1.1100E+02, 1.390000E+02},{ 1.1200E+02, 2.490000E+02},
			{ 1.1300E+02, 1.750000E+02},{ 1.1400E+02, 1.520000E+02},{ 1.1500E+02, 1.160000E+02},{ 1.1600E+02, 1.140000E+02},
			{ 1.1700E+02, 1.610000E+02},{ 1.1800E+02, 1.520000E+02},{ 1.1900E+02, 1.520000E+02},{ 1.2000E+02, 1.180000E+02},
			{ 1.2100E+02, 1.810000E+02},{ 1.2200E+02, 2.560000E+02},{ 1.2300E+02, 2.990000E+02},{ 1.2400E+02, 2.560000E+02},
			{ 1.2500E+02, 1.670000E+02},{ 1.2600E+02, 7.900000E+01},{ 1.2700E+02, 9.100000E+01},{ 1.2800E+02, 1.380000E+02},
			{ 1.2900E+02, 1.390000E+02},{ 1.3000E+02, 1.850000E+02},{ 1.3100E+02, 1.190000E+02},{ 1.3200E+02, 1.110000E+02},
			{ 1.3300E+02, 1.420000E+02},{ 1.3400E+02, 1.330000E+02},{ 1.3500E+02, 2.010000E+02},{ 1.3600E+02, 1.280000E+02},
			{ 1.3700E+02, 1.220000E+02},{ 1.3800E+02, 1.150000E+02},{ 1.3900E+02, 1.430000E+02},{ 1.4000E+02, 8.800000E+01},
			{ 1.4100E+02, 1.360000E+02},{ 1.4200E+02, 8.500000E+01},{ 1.4300E+02, 1.270000E+02},{ 1.4400E+02, 1.710000E+02},
			{ 1.4500E+02, 1.540000E+02},{ 1.4600E+02, 1.030000E+02},{ 1.4700E+02, 1.750000E+02},{ 1.4800E+02, 2.210000E+02},
			{ 1.4900E+02, 2.030000E+02},{ 1.5000E+02, 2.540000E+02},{ 1.5100E+02, 1.300000E+02},{ 1.5200E+02, 1.340000E+02},
			{ 1.5300E+02, 2.320000E+02},{ 1.5400E+02, 2.630000E+02},{ 1.5500E+02, 1.910000E+02},{ 1.5600E+02, 1.660000E+02},
			{ 1.5700E+02, 1.650000E+02},{ 1.5800E+02, 1.220000E+02},{ 1.5900E+02, 1.970000E+02},{ 1.6000E+02, 2.820000E+02},
			{ 1.6100E+02, 2.080000E+02},{ 1.6200E+02, 1.670000E+02},{ 1.6300E+02, 7.100000E+01},{ 1.6400E+02, 2.180000E+02},
			{ 1.6500E+02, 2.130000E+02},{ 1.6600E+02, 2.140000E+02},{ 1.6700E+02, 1.610000E+02},{ 1.6800E+02, 2.850000E+02},
			{ 1.6900E+02, 2.650000E+02},{ 1.7000E+02, 2.500000E+02},{ 1.7100E+02, 1.250000E+02},{ 1.7200E+02, 1.720000E+02},
			{ 1.7300E+02, 1.360000E+02},{ 1.7400E+02, 1.620000E+02},{ 1.7500E+02, 2.230000E+02},{ 1.7600E+02, 2.810000E+02},
			{ 1.7700E+02, 2.630000E+02},{ 1.7800E+02, 1.560000E+02},{ 1.7900E+02, 2.270000E+02},{ 1.8000E+02, 2.570000E+02},
			{ 1.8100E+02, 2.900000E+02},{ 1.8200E+02, 2.540000E+02},{ 1.8300E+02, 1.970000E+02},{ 1.8400E+02, 2.470000E+02},
			{ 1.8500E+02, 2.220000E+02},{ 1.8600E+02, 1.980000E+02},{ 1.8700E+02, 1.430000E+02},{ 1.8800E+02, 1.580000E+02},
			{ 1.8900E+02, 2.490000E+02},{ 1.9000E+02, 2.650000E+02},{ 1.9100E+02, 2.870000E+02},{ 1.9200E+02, 2.750000E+02},
			{ 1.9300E+02, 1.590000E+02},{ 1.9400E+02, 1.150000E+02},{ 1.9500E+02, 1.200000E+02},{ 1.9600E+02, 2.790000E+02},
			{ 1.9700E+02, 1.950000E+02},{ 1.9800E+02, 2.110000E+02},{ 1.9900E+02, 1.620000E+02},{ 2.0000E+02, 9.100000E+01},
			{ 2.0100E+02, 1.890000E+02},{ 2.0200E+02, 2.710000E+02},{ 2.0300E+02, 1.550000E+02},{ 2.0400E+02, 1.890000E+02},
			{ 2.0500E+02, 2.030000E+02},{ 2.0600E+02, 1.910000E+02},{ 2.0700E+02, 1.770000E+02},{ 2.0800E+02, 1.720000E+02},
			{ 2.0900E+02, 1.820000E+02},{ 2.1000E+02, 1.190000E+02},{ 2.1100E+02, 9.500000E+01},{ 2.1200E+02, 1.500000E+02},
			{ 2.1300E+02, 1.710000E+02},{ 2.1400E+02, 1.780000E+02},{ 2.1500E+02, 1.630000E+02},{ 2.1600E+02, 2.720000E+02},
			{ 2.1700E+02, 2.230000E+02},{ 2.1800E+02, 1.840000E+02},{ 2.1900E+02, 1.820000E+02},{ 2.2000E+02, 1.920000E+02},
			{ 2.2100E+02, 2.450000E+02},{ 2.2200E+02, 2.180000E+02},{ 2.2300E+02, 2.150000E+02},{ 2.2400E+02, 2.050000E+02},
			{ 2.2500E+02, 1.970000E+02},{ 2.2600E+02, 1.530000E+02},{ 2.2700E+02, 1.750000E+02},{ 2.2800E+02, 2.160000E+02},
			{ 2.2900E+02, 1.470000E+02},{ 2.3000E+02, 6.100000E+01},{ 2.3100E+02, 2.000000E+02},{ 2.3200E+02, 1.590000E+02},
			{ 2.3300E+02, 1.700000E+02},{ 2.3400E+02, 2.860000E+02},{ 2.3500E+02, 2.000000E+02},{ 2.3600E+02, 2.440000E+02},
			{ 2.3700E+02, 2.770000E+02},{ 2.3800E+02, 2.250000E+02},{ 2.3900E+02, 2.190000E+02},{ 2.4000E+02, 2.910000E+02},
			{ 2.4100E+02, 2.280000E+02},{ 2.4200E+02, 2.340000E+02},{ 2.4300E+02, 1.910000E+02},{ 2.4400E+02, 1.960000E+02},
			{ 2.4500E+02, 1.450000E+02},{ 2.4600E+02, 5.400000E+01},{ 2.4700E+02, 1.300000E+02},{ 2.4800E+02, 1.620000E+02},
			{ 2.4900E+02, 2.160000E+02},{ 2.5000E+02, 2.620000E+02},{ 2.5100E+02, 2.020000E+02},{ 2.5200E+02, 2.180000E+02},
			{ 2.5300E+02, 1.980000E+02},{ 2.5400E+02, 1.970000E+02},{ 2.5500E+02, 1.890000E+02},{ 2.5600E+02, 2.560000E+02},
			{ 2.5700E+02, 2.830000E+02},{ 2.5800E+02, 2.610000E+02},{ 2.5900E+02, 2.280000E+02},{ 2.6000E+02, 2.730000E+02},
			{ 2.6100E+02, 2.180000E+02},{ 2.6200E+02, 2.050000E+02},{ 2.6300E+02, 1.220000E+02},{ 2.6400E+02, 1.340000E+02},
			{ 2.6500E+02, 1.880000E+02},{ 2.6600E+02, 1.570000E+02},{ 2.6700E+02, 1.420000E+02},{ 2.6800E+02, 2.650000E+02},
			{ 2.6900E+02, 2.140000E+02},{ 2.7000E+02, 1.390000E+02},{ 2.7100E+02, 2.200000E+02},{ 2.7200E+02, 1.400000E+02},
			{ 2.7300E+02, 1.980000E+02},{ 2.7400E+02, 2.710000E+02},{ 2.7500E+02, 1.490000E+02},{ 2.7600E+02, 1.770000E+02},
			{ 2.7700E+02, 2.520000E+02},{ 2.7800E+02, 3.020000E+02},{ 2.7900E+02, 2.480000E+02},{ 2.8000E+02, 2.340000E+02},
			{ 2.8100E+02, 1.910000E+02},{ 2.8200E+02, 2.770000E+02},{ 2.8300E+02, 3.120000E+02},{ 2.8400E+02, 1.700000E+02},
			{ 2.8500E+02, 1.820000E+02},{ 2.8600E+02, 1.980000E+02},{ 2.8700E+02, 1.560000E+02},{ 2.8800E+02, 2.450000E+02},
			{ 2.8900E+02, 2.100000E+02},{ 2.9000E+02, 1.000000E+02},{ 2.9100E+02, 2.530000E+02},{ 2.9200E+02, 2.370000E+02},
			{ 2.9300E+02, 1.630000E+02},{ 2.9400E+02, 2.090000E+02},{ 2.9500E+02, 2.110000E+02},{ 2.9600E+02, 2.520000E+02},
			{ 2.9700E+02, 3.110000E+02},{ 2.9800E+02, 2.200000E+02},{ 2.9900E+02, 1.530000E+02},{ 3.0000E+02, 2.150000E+02},
			{ 3.0100E+02, 2.620000E+02},{ 3.0200E+02, 2.000000E+02},{ 3.0300E+02, 2.670000E+02},{ 3.0400E+02, 2.190000E+02},
			{ 3.0500E+02, 2.170000E+02},{ 3.0600E+02, 2.180000E+02},{ 3.0700E+02, 2.200000E+02},{ 3.0800E+02, 2.550000E+02},
			{ 3.0900E+02, 1.880000E+02},{ 3.1000E+02, 2.710000E+02},{ 3.1100E+02, 2.080000E+02},{ 3.1200E+02, 1.880000E+02},
			{ 3.1300E+02, 2.240000E+02},{ 3.1400E+02, 2.850000E+02},{ 3.1500E+02, 1.820000E+02},{ 3.1600E+02, 2.350000E+02},
			{ 3.1700E+02, 2.700000E+02},{ 3.1800E+02, 2.430000E+02},{ 3.1900E+02, 2.210000E+02},{ 3.2000E+02, 1.880000E+02},
			{ 3.2100E+02, 2.110000E+02},{ 3.2200E+02, 2.150000E+02},{ 3.2300E+02, 1.960000E+02},{ 3.2400E+02, 2.190000E+02},
			{ 3.2500E+02, 2.050000E+02},{ 3.2600E+02, 2.840000E+02},{ 3.2700E+02, 1.930000E+02},{ 3.2800E+02, 2.250000E+02},
			{ 3.2900E+02, 2.960000E+02},{ 3.3000E+02, 2.300000E+02},{ 3.3100E+02, 2.840000E+02},{ 3.3200E+02, 2.220000E+02},
			{ 3.3300E+02, 2.340000E+02},{ 3.3400E+02, 3.250000E+02},{ 3.3500E+02, 3.250000E+02},{ 3.3600E+02, 2.120000E+02},
			{ 3.3700E+02, 1.720000E+02},{ 3.3800E+02, 2.390000E+02},{ 3.3900E+02, 2.520000E+02},{ 3.4000E+02, 2.230000E+02},
			{ 3.4100E+02, 2.410000E+02},{ 3.4200E+02, 2.460000E+02},{ 3.4300E+02, 1.670000E+02},{ 3.4400E+02, 2.270000E+02},
			{ 3.4500E+02, 2.250000E+02},{ 3.4600E+02, 2.420000E+02},{ 3.4700E+02, 3.040000E+02},{ 3.4800E+02, 2.270000E+02},
			{ 3.4900E+02, 2.340000E+02},{ 3.5000E+02, 1.480000E+02},{ 3.5100E+02, 1.350000E+02},{ 3.5200E+02, 1.650000E+02},
			{ 3.5300E+02, 1.850000E+02},{ 3.5400E+02, 3.180000E+02},{ 3.5500E+02, 2.860000E+02},{ 3.5600E+02, 2.070000E+02},
			{ 3.5700E+02, 2.250000E+02},{ 3.5800E+02, 1.840000E+02},{ 3.5900E+02, 1.510000E+02},{ 3.6000E+02, 2.770000E+02},
			{ 3.6100E+02, 2.810000E+02},{ 3.6200E+02, 2.410000E+02},{ 3.6300E+02, 2.490000E+02},{ 3.6400E+02, 2.020000E+02},
			{ 3.6500E+02, 3.220000E+02}, };
		return SL::Graph( 0, x, 364, g); 
	}

	inline double Graph12(double x) { 
		static double g[365][2] = {
			{ 1.0000E+00, 9.850000E+00},{ 2.0000E+00, 8.780000E+00},{ 3.0000E+00, 1.120000E+01},{ 4.0000E+00, 9.080000E+00},
			{ 5.0000E+00, 1.080000E+01},{ 6.0000E+00, 1.260000E+01},{ 7.0000E+00, 9.460000E+00},{ 8.0000E+00, 1.120000E+01},
			{ 9.0000E+00, 1.290000E+01},{ 1.0000E+01, 1.180000E+01},{ 1.1000E+01, 7.120000E+00},{ 1.2000E+01, 1.330000E+01},
			{ 1.3000E+01, 7.500000E+00},{ 1.4000E+01, 1.480000E+01},{ 1.5000E+01, 1.070000E+01},{ 1.6000E+01, 6.490000E+00},
			{ 1.7000E+01, 6.490000E+00},{ 1.8000E+01, 7.920000E+00},{ 1.9000E+01, 5.630000E+00},{ 2.0000E+01, 6.680000E+00},
			{ 2.1000E+01, 8.420000E+00},{ 2.2000E+01, 6.680000E+00},{ 2.3000E+01, 1.160000E+01},{ 2.4000E+01, 8.500000E+00},
			{ 2.5000E+01, 9.950000E+00},{ 2.6000E+01, 2.060000E+01},{ 2.7000E+01, 1.640000E+01},{ 2.8000E+01, 1.270000E+01},
			{ 2.9000E+01, 9.560000E+00},{ 3.0000E+01, 8.030000E+00},{ 3.1000E+01, 1.100000E+01},{ 3.2000E+01, 5.440000E+00},
			{ 3.3000E+01, 9.700000E+00},{ 3.4000E+01, 7.260000E+00},{ 3.5000E+01, 7.030000E+00},{ 3.6000E+01, 7.030000E+00},
			{ 3.7000E+01, 1.250000E+01},{ 3.8000E+01, 6.920000E+00},{ 3.9000E+01, 4.670000E+00},{ 4.0000E+01, 4.610000E+00},
			{ 4.1000E+01, 4.730000E+00},{ 4.2000E+01, 6.200000E+00},{ 4.3000E+01, 6.400000E+00},{ 4.4000E+01, 5.640000E+00},
			{ 4.5000E+01, 8.030000E+00},{ 4.6000E+01, 9.220000E+00},{ 4.7000E+01, 7.260000E+00},{ 4.8000E+01, 7.200000E+00},
			{ 4.9000E+01, 1.070000E+01},{ 5.0000E+01, 9.890000E+00},{ 5.1000E+01, 5.730000E+00},{ 5.2000E+01, 9.180000E+00},
			{ 5.3000E+01, 1.440000E+01},{ 5.4000E+01, 8.510000E+00},{ 5.5000E+01, 6.690000E+00},{ 5.6000E+01, 1.100000E+01},
			{ 5.7000E+01, 1.130000E+01},{ 5.8000E+01, 8.980000E+00},{ 5.9000E+01, 6.680000E+00},{ 6.0000E+01, 5.680000E+00},
			{ 6.1000E+01, 7.690000E+00},{ 6.2000E+01, 5.100000E+00},{ 6.3000E+01, 5.820000E+00},{ 6.4000E+01, 5.720000E+00},
			{ 6.5000E+01, 8.980000E+00},{ 6.6000E+01, 1.670000E+01},{ 6.7000E+01, 1.510000E+01},{ 6.8000E+01, 4.920000E+00},
			{ 6.9000E+01, 8.600000E+00},{ 7.0000E+01, 9.750000E+00},{ 7.1000E+01, 7.250000E+00},{ 7.2000E+01, 7.210000E+00},
			{ 7.3000E+01, 9.030000E+00},{ 7.4000E+01, 1.090000E+01},{ 7.5000E+01, 4.530000E+00},{ 7.6000E+01, 7.250000E+00},
			{ 7.7000E+01, 7.640000E+00},{ 7.8000E+01, 1.510000E+01},{ 7.9000E+01, 1.540000E+01},{ 8.0000E+01, 1.120000E+01},
			{ 8.1000E+01, 6.890000E+00},{ 8.2000E+01, 1.300000E+01},{ 8.3000E+01, 1.150000E+01},{ 8.4000E+01, 6.720000E+00},
			{ 8.5000E+01, 1.220000E+01},{ 8.6000E+01, 9.760000E+00},{ 8.7000E+01, 1.130000E+01},{ 8.8000E+01, 1.020000E+01},
			{ 8.9000E+01, 9.890000E+00},{ 9.0000E+01, 1.090000E+01},{ 9.1000E+01, 1.180000E+01},{ 9.2000E+01, 1.180000E+01},
			{ 9.3000E+01, 1.130000E+01},{ 9.4000E+01, 6.780000E+00},{ 9.5000E+01, 1.140000E+01},{ 9.6000E+01, 8.360000E+00},
			{ 9.7000E+01, 1.090000E+01},{ 9.8000E+01, 8.700000E+00},{ 9.9000E+01, 7.450000E+00},{ 1.0000E+02, 7.600000E+00},
			{ 1.0100E+02, 8.930000E+00},{ 1.0200E+02, 7.200000E+00},{ 1.0300E+02, 1.140000E+01},{ 1.0400E+02, 6.620000E+00},
			{ 1.0500E+02, 7.420000E+00},{ 1.0600E+02, 8.170000E+00},{ 1.0700E+02, 1.010000E+01},{ 1.0800E+02, 1.260000E+01},
			{ 1.0900E+02, 9.450000E+00},{ 1.1000E+02, 7.020000E+00},{ 1.1100E+02, 9.700000E+00},{ 1.1200E+02, 9.550000E+00},
			{ 1.1300E+02, 1.200000E+01},{ 1.1400E+02, 1.430000E+01},{ 1.1500E+02, 1.260000E+01},{ 1.1600E+02, 7.300000E+00},
			{ 1.1700E+02, 9.460000E+00},{ 1.1800E+02, 6.920000E+00},{ 1.1900E+02, 6.390000E+00},{ 1.2000E+02, 6.970000E+00},
			{ 1.2100E+02, 9.030000E+00},{ 1.2200E+02, 1.250000E+01},{ 1.2300E+02, 1.210000E+01},{ 1.2400E+02, 8.650000E+00},
			{ 1.2500E+02, 9.040000E+00},{ 1.2600E+02, 7.790000E+00},{ 1.2700E+02, 7.980000E+00},{ 1.2800E+02, 9.170000E+00},
			{ 1.2900E+02, 1.040000E+01},{ 1.3000E+02, 7.210000E+00},{ 1.3100E+02, 8.360000E+00},{ 1.3200E+02, 1.530000E+01},
			{ 1.3300E+02, 1.040000E+01},{ 1.3400E+02, 6.390000E+00},{ 1.3500E+02, 8.940000E+00},{ 1.3600E+02, 6.200000E+00},
			{ 1.3700E+02, 5.680000E+00},{ 1.3800E+02, 7.680000E+00},{ 1.3900E+02, 9.760000E+00},{ 1.4000E+02, 9.470000E+00},
			{ 1.4100E+02, 8.980000E+00},{ 1.4200E+02, 6.020000E+00},{ 1.4300E+02, 6.500000E+00},{ 1.4400E+02, 6.780000E+00},
			{ 1.4500E+02, 9.130000E+00},{ 1.4600E+02, 9.070000E+00},{ 1.4700E+02, 9.990000E+00},{ 1.4800E+02, 8.260000E+00},
			{ 1.4900E+02, 7.530000E+00},{ 1.5000E+02, 8.080000E+00},{ 1.5100E+02, 6.250000E+00},{ 1.5200E+02, 8.830000E+00},
			{ 1.5300E+02, 1.170000E+01},{ 1.5400E+02, 1.200000E+01},{ 1.5500E+02, 1.200000E+01},{ 1.5600E+02, 7.590000E+00},
			{ 1.5700E+02, 7.640000E+00},{ 1.5800E+02, 7.990000E+00},{ 1.5900E+02, 7.930000E+00},{ 1.6000E+02, 1.110000E+01},
			{ 1.6100E+02, 9.170000E+00},{ 1.6200E+02, 6.400000E+00},{ 1.6300E+02, 8.750000E+00},{ 1.6400E+02, 7.030000E+00},
			{ 1.6500E+02, 8.300000E+00},{ 1.6600E+02, 6.680000E+00},{ 1.6700E+02, 9.650000E+00},{ 1.6800E+02, 1.400000E+01},
			{ 1.6900E+02, 1.070000E+01},{ 1.7000E+02, 7.880000E+00},{ 1.7100E+02, 6.390000E+00},{ 1.7200E+02, 8.260000E+00},
			{ 1.7300E+02, 6.100000E+00},{ 1.7400E+02, 6.400000E+00},{ 1.7500E+02, 1.120000E+01},{ 1.7600E+02, 1.310000E+01},
			{ 1.7700E+02, 1.080000E+01},{ 1.7800E+02, 5.920000E+00},{ 1.7900E+02, 6.880000E+00},{ 1.8000E+02, 9.080000E+00},
			{ 1.8100E+02, 9.990000E+00},{ 1.8200E+02, 1.050000E+01},{ 1.8300E+02, 1.040000E+01},{ 1.8400E+02, 6.300000E+00},
			{ 1.8500E+02, 9.600000E+00},{ 1.8600E+02, 6.880000E+00},{ 1.8700E+02, 6.580000E+00},{ 1.8800E+02, 7.250000E+00},
			{ 1.8900E+02, 8.020000E+00},{ 1.9000E+02, 7.210000E+00},{ 1.9100E+02, 9.990000E+00},{ 1.9200E+02, 6.600000E+00},
			{ 1.9300E+02, 5.020000E+00},{ 1.9400E+02, 6.640000E+00},{ 1.9500E+02, 5.630000E+00},{ 1.9600E+02, 8.930000E+00},
			{ 1.9700E+02, 8.020000E+00},{ 1.9800E+02, 7.880000E+00},{ 1.9900E+02, 7.500000E+00},{ 2.0000E+02, 6.110000E+00},
			{ 2.0100E+02, 8.180000E+00},{ 2.0200E+02, 7.930000E+00},{ 2.0300E+02, 7.740000E+00},{ 2.0400E+02, 5.670000E+00},
			{ 2.0500E+02, 8.260000E+00},{ 2.0600E+02, 1.060000E+01},{ 2.0700E+02, 9.550000E+00},{ 2.0800E+02, 6.390000E+00},
			{ 2.0900E+02, 5.720000E+00},{ 2.1000E+02, 5.350000E+00},{ 2.1100E+02, 1.080000E+01},{ 2.1200E+02, 7.350000E+00},
			{ 2.1300E+02, 8.120000E+00},{ 2.1400E+02, 6.580000E+00},{ 2.1500E+02, 5.970000E+00},{ 2.1600E+02, 7.600000E+00},
			{ 2.1700E+02, 8.270000E+00},{ 2.1800E+02, 6.970000E+00},{ 2.1900E+02, 8.460000E+00},{ 2.2000E+02, 6.930000E+00},
			{ 2.2100E+02, 6.300000E+00},{ 2.2200E+02, 7.550000E+00},{ 2.2300E+02, 8.800000E+00},{ 2.2400E+02, 6.730000E+00},
			{ 2.2500E+02, 7.210000E+00},{ 2.2600E+02, 6.400000E+00},{ 2.2700E+02, 7.220000E+00},{ 2.2800E+02, 6.580000E+00},
			{ 2.2900E+02, 6.010000E+00},{ 2.3000E+02, 5.480000E+00},{ 2.3100E+02, 1.010000E+01},{ 2.3200E+02, 7.030000E+00},
			{ 2.3300E+02, 7.210000E+00},{ 2.3400E+02, 8.450000E+00},{ 2.3500E+02, 8.120000E+00},{ 2.3600E+02, 1.600000E+01},
			{ 2.3700E+02, 1.210000E+01},{ 2.3800E+02, 8.220000E+00},{ 2.3900E+02, 1.110000E+01},{ 2.4000E+02, 7.210000E+00},
			{ 2.4100E+02, 6.530000E+00},{ 2.4200E+02, 7.170000E+00},{ 2.4300E+02, 6.320000E+00},{ 2.4400E+02, 6.740000E+00},
			{ 2.4500E+02, 5.540000E+00},{ 2.4600E+02, 9.560000E+00},{ 2.4700E+02, 5.970000E+00},{ 2.4800E+02, 6.670000E+00},
			{ 2.4900E+02, 7.080000E+00},{ 2.5000E+02, 6.880000E+00},{ 2.5100E+02, 6.540000E+00},{ 2.5200E+02, 7.680000E+00},
			{ 2.5300E+02, 7.640000E+00},{ 2.5400E+02, 1.080000E+01},{ 2.5500E+02, 1.030000E+01},{ 2.5600E+02, 8.940000E+00},
			{ 2.5700E+02, 1.000000E+01},{ 2.5800E+02, 8.260000E+00},{ 2.5900E+02, 1.360000E+01},{ 2.6000E+02, 7.970000E+00},
			{ 2.6100E+02, 7.460000E+00},{ 2.6200E+02, 5.150000E+00},{ 2.6300E+02, 5.490000E+00},{ 2.6400E+02, 5.670000E+00},
			{ 2.6500E+02, 6.490000E+00},{ 2.6600E+02, 5.970000E+00},{ 2.6700E+02, 5.730000E+00},{ 2.6800E+02, 8.510000E+00},
			{ 2.6900E+02, 5.730000E+00},{ 2.7000E+02, 8.840000E+00},{ 2.7100E+02, 6.060000E+00},{ 2.7200E+02, 5.150000E+00},
			{ 2.7300E+02, 9.320000E+00},{ 2.7400E+02, 1.010000E+01},{ 2.7500E+02, 5.060000E+00},{ 2.7600E+02, 6.300000E+00},
			{ 2.7700E+02, 8.170000E+00},{ 2.7800E+02, 7.780000E+00},{ 2.7900E+02, 1.320000E+01},{ 2.8000E+02, 7.970000E+00},
			{ 2.8100E+02, 1.080000E+01},{ 2.8200E+02, 1.110000E+01},{ 2.8300E+02, 9.320000E+00},{ 2.8400E+02, 5.680000E+00},
			{ 2.8500E+02, 5.720000E+00},{ 2.8600E+02, 6.210000E+00},{ 2.8700E+02, 5.100000E+00},{ 2.8800E+02, 1.070000E+01},
			{ 2.8900E+02, 5.290000E+00},{ 2.9000E+02, 1.070000E+01},{ 2.9100E+02, 8.790000E+00},{ 2.9200E+02, 4.710000E+00},
			{ 2.9300E+02, 6.590000E+00},{ 2.9400E+02, 7.350000E+00},{ 2.9500E+02, 7.600000E+00},{ 2.9600E+02, 1.280000E+01},
			{ 2.9700E+02, 9.230000E+00},{ 2.9800E+02, 4.820000E+00},{ 2.9900E+02, 5.540000E+00},{ 3.0000E+02, 8.690000E+00},
			{ 3.0100E+02, 4.920000E+00},{ 3.0200E+02, 7.690000E+00},{ 3.0300E+02, 1.120000E+01},{ 3.0400E+02, 7.790000E+00},
			{ 3.0500E+02, 1.090000E+01},{ 3.0600E+02, 7.200000E+00},{ 3.0700E+02, 6.500000E+00},{ 3.0800E+02, 1.250000E+01},
			{ 3.0900E+02, 6.780000E+00},{ 3.1000E+02, 8.790000E+00},{ 3.1100E+02, 5.290000E+00},{ 3.1200E+02, 7.490000E+00},
			{ 3.1300E+02, 7.780000E+00},{ 3.1400E+02, 1.090000E+01},{ 3.1500E+02, 3.370000E+00},{ 3.1600E+02, 4.870000E+00},
			{ 3.1700E+02, 1.270000E+01},{ 3.1800E+02, 1.040000E+01},{ 3.1900E+02, 9.810000E+00},{ 3.2000E+02, 4.430000E+00},
			{ 3.2100E+02, 6.870000E+00},{ 3.2200E+02, 7.780000E+00},{ 3.2300E+02, 1.430000E+01},{ 3.2400E+02, 8.750000E+00},
			{ 3.2500E+02, 1.820000E+01},{ 3.2600E+02, 1.250000E+01},{ 3.2700E+02, 7.540000E+00},{ 3.2800E+02, 1.270000E+01},
			{ 3.2900E+02, 7.780000E+00},{ 3.3000E+02, 8.750000E+00},{ 3.3100E+02, 9.900000E+00},{ 3.3200E+02, 6.110000E+00},
			{ 3.3300E+02, 5.870000E+00},{ 3.3400E+02, 1.290000E+01},{ 3.3500E+02, 9.710000E+00},{ 3.3600E+02, 7.030000E+00},
			{ 3.3700E+02, 1.570000E+01},{ 3.3800E+02, 1.240000E+01},{ 3.3900E+02, 1.170000E+01},{ 3.4000E+02, 9.120000E+00},
			{ 3.4100E+02, 8.930000E+00},{ 3.4200E+02, 1.350000E+01},{ 3.4300E+02, 1.250000E+01},{ 3.4400E+02, 7.550000E+00},
			{ 3.4500E+02, 6.780000E+00},{ 3.4600E+02, 8.460000E+00},{ 3.4700E+02, 1.080000E+01},{ 3.4800E+02, 8.460000E+00},
			{ 3.4900E+02, 9.040000E+00},{ 3.5000E+02, 6.010000E+00},{ 3.5100E+02, 8.220000E+00},{ 3.5200E+02, 1.030000E+01},
			{ 3.5300E+02, 1.460000E+01},{ 3.5400E+02, 8.270000E+00},{ 3.5500E+02, 8.600000E+00},{ 3.5600E+02, 6.780000E+00},
			{ 3.5700E+02, 8.990000E+00},{ 3.5800E+02, 5.200000E+00},{ 3.5900E+02, 1.130000E+01},{ 3.6000E+02, 6.550000E+00},
			{ 3.6100E+02, 4.670000E+00},{ 3.6200E+02, 4.880000E+00},{ 3.6300E+02, 5.530000E+00},{ 3.6400E+02, 7.470000E+00},
			{ 3.6500E+02, 1.360000E+01}, };
		return SL::Graph( 0, x, 364, g); 
	}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int DAYS_I175_exe_g(Variable* obj) { return GLOBAL_module::I().DAYS_I175_exe(); }
int DAYS_i176_exe_g(Variable* obj) { return GLOBAL_module::I().DAYS_i176_exe(); }
int COUNT_HOURS_u177_exe_g(Variable* obj) { return GLOBAL_module::I().COUNT_HOURS_u177_exe(); }
int ALPHA_u178_exe_g(Variable* obj) { return GLOBAL_module::I().ALPHA_u178_exe(); }
int ANGLE_u179_exe_g(Variable* obj) { return GLOBAL_module::I().ANGLE_u179_exe(); }
int CURRENT_DIRECTION_u180_exe_g(Variable* obj) { return GLOBAL_module::I().CURRENT_DIRECTION_u180_exe(); }
int CURRENT_VELOCITY_u181_exe_g(Variable* obj) { return GLOBAL_module::I().CURRENT_VELOCITY_u181_exe(); }
int DW_WAVE_L_u182_exe_g(Variable* obj) { return GLOBAL_module::I().DW_WAVE_L_u182_exe(); }
int EC_H2O_u183_exe_g(Variable* obj) { return GLOBAL_module::I().EC_H2O_u183_exe(); }
int EC_PLANTS_u184_exe_g(Variable* obj) { return GLOBAL_module::I().EC_PLANTS_u184_exe(); }
int EPI_LIGHT_LIM_u185_exe_g(Variable* obj) { return GLOBAL_module::I().EPI_LIGHT_LIM_u185_exe(); }
int EW_CURRENT_VECTOR_u186_exe_g(Variable* obj) { return GLOBAL_module::I().EW_CURRENT_VECTOR_u186_exe(); }
int EW_VECTOR_u187_exe_g(Variable* obj) { return GLOBAL_module::I().EW_VECTOR_u187_exe(); }
int EW_WIND_VECTOR_u188_exe_g(Variable* obj) { return GLOBAL_module::I().EW_WIND_VECTOR_u188_exe(); }
int FETCH_u189_exe_g(Variable* obj) { return GLOBAL_module::I().FETCH_u189_exe(); }
int G_D_u190_exe_g(Variable* obj) { return GLOBAL_module::I().G_D_u190_exe(); }
int G_F_u191_exe_g(Variable* obj) { return GLOBAL_module::I().G_F_u191_exe(); }
int H1_u192_exe_g(Variable* obj) { return GLOBAL_module::I().H1_u192_exe(); }
int H2_u193_exe_g(Variable* obj) { return GLOBAL_module::I().H2_u193_exe(); }
int H2O_TEMP_u194_exe_g(Variable* obj) { return GLOBAL_module::I().H2O_TEMP_u194_exe(); }
int HA_u195_exe_g(Variable* obj) { return GLOBAL_module::I().HA_u195_exe(); }
int HABB_u196_exe_g(Variable* obj) { return GLOBAL_module::I().HABB_u196_exe(); }
int HOURS_u197_exe_g(Variable* obj) { return GLOBAL_module::I().HOURS_u197_exe(); }
int LIGHT_AT_EPIPHYTES_u198_exe_g(Variable* obj) { return GLOBAL_module::I().LIGHT_AT_EPIPHYTES_u198_exe(); }
int LIGHT_AT_PLANTS_u199_exe_g(Variable* obj) { return GLOBAL_module::I().LIGHT_AT_PLANTS_u199_exe(); }
int LIGHT_TO_PHYTOPLANKTON_u200_exe_g(Variable* obj) { return GLOBAL_module::I().LIGHT_TO_PHYTOPLANKTON_u200_exe(); }
int NS_CURRENT_VECTOR_u201_exe_g(Variable* obj) { return GLOBAL_module::I().NS_CURRENT_VECTOR_u201_exe(); }
int NS_VECTOR_u202_exe_g(Variable* obj) { return GLOBAL_module::I().NS_VECTOR_u202_exe(); }
int NS_WIND_VECTOR_u203_exe_g(Variable* obj) { return GLOBAL_module::I().NS_WIND_VECTOR_u203_exe(); }
int ORBITAL_VELOCITY_u204_exe_g(Variable* obj) { return GLOBAL_module::I().ORBITAL_VELOCITY_u204_exe(); }
int PHOTO_PERIOD_u205_exe_g(Variable* obj) { return GLOBAL_module::I().PHOTO_PERIOD_u205_exe(); }
int PHT_LIGHT_LIM_u206_exe_g(Variable* obj) { return GLOBAL_module::I().PHT_LIGHT_LIM_u206_exe(); }
int RAND_u207_exe_g(Variable* obj) { return GLOBAL_module::I().RAND_u207_exe(); }
int SDCLN_u208_exe_g(Variable* obj) { return GLOBAL_module::I().SDCLN_u208_exe(); }
int SF_WATER_u209_exe_g(Variable* obj) { return GLOBAL_module::I().SF_WATER_u209_exe(); }
int SF_WT_EW_X_u210_exe_g(Variable* obj) { return GLOBAL_module::I().SF_WT_EW_X_u210_exe(); }
int SF_WT_E_X_u211_exe_g(Variable* obj) { return GLOBAL_module::I().SF_WT_E_X_u211_exe(); }
int SF_WT_NS_X_u212_exe_g(Variable* obj) { return GLOBAL_module::I().SF_WT_NS_X_u212_exe(); }
int SF_WT_N_X_u213_exe_g(Variable* obj) { return GLOBAL_module::I().SF_WT_N_X_u213_exe(); }
int SF_WT_S_X_u214_exe_g(Variable* obj) { return GLOBAL_module::I().SF_WT_S_X_u214_exe(); }
int SF_WT_W_X_u215_exe_g(Variable* obj) { return GLOBAL_module::I().SF_WT_W_X_u215_exe(); }
int SHEAR_STRESS_u216_exe_g(Variable* obj) { return GLOBAL_module::I().SHEAR_STRESS_u216_exe(); }
int SURFACE_LIGHT_u217_exe_g(Variable* obj) { return GLOBAL_module::I().SURFACE_LIGHT_u217_exe(); }
int SW_LIGHT_LIM_u218_exe_g(Variable* obj) { return GLOBAL_module::I().SW_LIGHT_LIM_u218_exe(); }
int T1_u219_exe_g(Variable* obj) { return GLOBAL_module::I().T1_u219_exe(); }
int T1A_u220_exe_g(Variable* obj) { return GLOBAL_module::I().T1A_u220_exe(); }
int T1AB_u221_exe_g(Variable* obj) { return GLOBAL_module::I().T1AB_u221_exe(); }
int T2_u222_exe_g(Variable* obj) { return GLOBAL_module::I().T2_u222_exe(); }
int TIDE_u223_exe_g(Variable* obj) { return GLOBAL_module::I().TIDE_u223_exe(); }
int TOTAL_SF_WT_X_u224_exe_g(Variable* obj) { return GLOBAL_module::I().TOTAL_SF_WT_X_u224_exe(); }
int UA_UB_u225_exe_g(Variable* obj) { return GLOBAL_module::I().UA_UB_u225_exe(); }
int WATER_DEPTH_u226_exe_g(Variable* obj) { return GLOBAL_module::I().WATER_DEPTH_u226_exe(); }
int WAVE_HEIGHT_u227_exe_g(Variable* obj) { return GLOBAL_module::I().WAVE_HEIGHT_u227_exe(); }
int WAVE_L_u228_exe_g(Variable* obj) { return GLOBAL_module::I().WAVE_L_u228_exe(); }
int WAVE_PERIOD_u229_exe_g(Variable* obj) { return GLOBAL_module::I().WAVE_PERIOD_u229_exe(); }
int ZOSTRA_LIGHT_LIM_u230_exe_g(Variable* obj) { return GLOBAL_module::I().ZOSTRA_LIGHT_LIM_u230_exe(); }
int P1_CELL_SIZE_u231_exe_g(Variable* obj) { return GLOBAL_module::I().P1_CELL_SIZE_u231_exe(); }
int P1_CONVERT_CURRENTS_u232_exe_g(Variable* obj) { return GLOBAL_module::I().P1_CONVERT_CURRENTS_u232_exe(); }
int P1_CONVERT_WSPD_u233_exe_g(Variable* obj) { return GLOBAL_module::I().P1_CONVERT_WSPD_u233_exe(); }
int P1_EC_COEFF_SED_u234_exe_g(Variable* obj) { return GLOBAL_module::I().P1_EC_COEFF_SED_u234_exe(); }
int P1_EC_COEFF_WATER_u235_exe_g(Variable* obj) { return GLOBAL_module::I().P1_EC_COEFF_WATER_u235_exe(); }
int P1_EPI_LIGHT_K_u236_exe_g(Variable* obj) { return GLOBAL_module::I().P1_EPI_LIGHT_K_u236_exe(); }
int P1_F_EAST_u237_exe_g(Variable* obj) { return GLOBAL_module::I().P1_F_EAST_u237_exe(); }
int P1_F_NORTH_u238_exe_g(Variable* obj) { return GLOBAL_module::I().P1_F_NORTH_u238_exe(); }
int P1_F_SOUTH_u239_exe_g(Variable* obj) { return GLOBAL_module::I().P1_F_SOUTH_u239_exe(); }
int P1_F_WEST_u240_exe_g(Variable* obj) { return GLOBAL_module::I().P1_F_WEST_u240_exe(); }
int P1_IC_SED_ELEV_u241_exe_g(Variable* obj) { return GLOBAL_module::I().P1_IC_SED_ELEV_u241_exe(); }
int P1_LATITUDE_u242_exe_g(Variable* obj) { return GLOBAL_module::I().P1_LATITUDE_u242_exe(); }
int P1_MAX_EC_COEFF_PLANTS_u243_exe_g(Variable* obj) { return GLOBAL_module::I().P1_MAX_EC_COEFF_PLANTS_u243_exe(); }
int P1_ON_MAP_u244_exe_g(Variable* obj) { return GLOBAL_module::I().P1_ON_MAP_u244_exe(); }
int P1_PHYTO_LIGHT_K_u245_exe_g(Variable* obj) { return GLOBAL_module::I().P1_PHYTO_LIGHT_K_u245_exe(); }
int P1_SW_LIGHT_K_u246_exe_g(Variable* obj) { return GLOBAL_module::I().P1_SW_LIGHT_K_u246_exe(); }
int P1_ZOSTRA_LIGHT_K_u247_exe_g(Variable* obj) { return GLOBAL_module::I().P1_ZOSTRA_LIGHT_K_u247_exe(); }
int DECLINE_u248_exe_g(Variable* obj) { return GLOBAL_module::I().DECLINE_u248_exe(); }
int FRIC_COEF_u249_exe_g(Variable* obj) { return GLOBAL_module::I().FRIC_COEF_u249_exe(); }
int H_ANGLE_u250_exe_g(Variable* obj) { return GLOBAL_module::I().H_ANGLE_u250_exe(); }
int SKEW_WEATHER_u251_exe_g(Variable* obj) { return GLOBAL_module::I().SKEW_WEATHER_u251_exe(); }
int P1_AIR_TEMP_u252_exe_g(Variable* obj) { return GLOBAL_module::I().P1_AIR_TEMP_u252_exe(); }
int P1_LEAF_GROW_SEASON_u253_exe_g(Variable* obj) { return GLOBAL_module::I().P1_LEAF_GROW_SEASON_u253_exe(); }
int P1_PRECIPITATION_u254_exe_g(Variable* obj) { return GLOBAL_module::I().P1_PRECIPITATION_u254_exe(); }
int P1_WIND_DIRECTION_u255_exe_g(Variable* obj) { return GLOBAL_module::I().P1_WIND_DIRECTION_u255_exe(); }
int P1_WIND_SPEED_u256_exe_g(Variable* obj) { return GLOBAL_module::I().P1_WIND_SPEED_u256_exe(); }
// ---------------------------------------------------------------------------
//                    Class PHOSPHATE_module 
// ---------------------------------------------------------------------------

class PHOSPHATE_module : public TModule {
protected:

	PHOSPHATE_module(char* name);

public:

	TTime TIME;
	CAuxVariable P1_RIVER_DATA_CF;
	CAuxVariable P1_PO4_SED_WT_CONC;
	CAuxVariable PO4_SF_WT_CONC;
	CAuxVariable SF_WATER;
	CFluxVariable WRACK_OM_DECOMP;
	CAuxVariable P1_WRACK_OM_PC;
	CAuxVariable PHT_NET_PROD;
	CAuxVariable P1_PHY_PC;
	CAuxVariable P1_MAC_PHBIO_PC;
	CAuxVariable PHBIO_NET_PROD;
	CAuxVariable SF_WT_E_X;
	CAuxVariable SF_WT_N_X;
	CAuxVariable SF_WT_S_X;
	CAuxVariable SF_WT_W_X;
	CStateVariable PO4_SF_WT;
	CFluxVariable PO4_SF_WT_MINER;
	CFluxVariable PO4_SF_X_IN;
	CFluxVariable PO4_DNFLOW;
	CFluxVariable PO4_SF_WT_UPTAK;
	CFluxVariable PO4_X_OUT;
	CStateVariable PO4_SOIL;
	CAuxVariable PO4_E_X;
	CAuxVariable PO4_N_X;
	CAuxVariable PO4_S_X;
	CAuxVariable PO4_W_X;
	CAuxVariable RIVER_P;
	CAuxVariable P1_IC_PO4;
	CAuxVariable P1_PO4_DIFFUSION_COEFF;
protected:

	int PO4_SF_WT_I257_exe();
	friend int PO4_SF_WT_I257_exe_g( Variable* v );
	int PO4_SF_WT_i258_exe();
	friend int PO4_SF_WT_i258_exe_g( Variable* v );
	int PO4_SF_WT_MINER_u259_exe();
	friend int PO4_SF_WT_MINER_u259_exe_g( Variable* v );
	int PO4_SF_X_IN_u260_exe();
	friend int PO4_SF_X_IN_u260_exe_g( Variable* v );
	int PO4_DNFLOW_u261_exe();
	friend int PO4_DNFLOW_u261_exe_g( Variable* v );
	int PO4_SF_WT_UPTAK_u262_exe();
	friend int PO4_SF_WT_UPTAK_u262_exe_g( Variable* v );
	int PO4_X_OUT_u263_exe();
	friend int PO4_X_OUT_u263_exe_g( Variable* v );
	int PO4_SOIL_I264_exe();
	friend int PO4_SOIL_I264_exe_g( Variable* v );
	int PO4_SOIL_i265_exe();
	friend int PO4_SOIL_i265_exe_g( Variable* v );
	int PO4_E_X_u266_exe();
	friend int PO4_E_X_u266_exe_g( Variable* v );
	int PO4_N_X_u267_exe();
	friend int PO4_N_X_u267_exe_g( Variable* v );
	int PO4_SF_WT_CONC_u268_exe();
	friend int PO4_SF_WT_CONC_u268_exe_g( Variable* v );
	int PO4_S_X_u269_exe();
	friend int PO4_S_X_u269_exe_g( Variable* v );
	int PO4_W_X_u270_exe();
	friend int PO4_W_X_u270_exe_g( Variable* v );
	int RIVER_P_u271_exe();
	friend int RIVER_P_u271_exe_g( Variable* v );
	int P1_IC_PO4_u272_exe();
	friend int P1_IC_PO4_u272_exe_g( Variable* v );
	int P1_PO4_DIFFUSION_COEFF_u273_exe();
	friend int P1_PO4_DIFFUSION_COEFF_u273_exe_g( Variable* v );
	int P1_PO4_SED_WT_CONC_u274_exe();
	friend int P1_PO4_SED_WT_CONC_u274_exe_g( Variable* v );
	int P1_RIVER_DATA_CF_u275_exe();
	friend int P1_RIVER_DATA_CF_u275_exe_g( Variable* v );
	static PHOSPHATE_module* fInstance;
	static PHOSPHATE_module* kNullModel;
public:
	inline static PHOSPHATE_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new PHOSPHATE_module("PHOSPHATE_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (PHOSPHATE_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int PO4_SF_WT_I257_exe_g(Variable* obj) { return PHOSPHATE_module::I().PO4_SF_WT_I257_exe(); }
int PO4_SF_WT_i258_exe_g(Variable* obj) { return PHOSPHATE_module::I().PO4_SF_WT_i258_exe(); }
int PO4_SF_WT_MINER_u259_exe_g(Variable* obj) { return PHOSPHATE_module::I().PO4_SF_WT_MINER_u259_exe(); }
int PO4_SF_X_IN_u260_exe_g(Variable* obj) { return PHOSPHATE_module::I().PO4_SF_X_IN_u260_exe(); }
int PO4_DNFLOW_u261_exe_g(Variable* obj) { return PHOSPHATE_module::I().PO4_DNFLOW_u261_exe(); }
int PO4_SF_WT_UPTAK_u262_exe_g(Variable* obj) { return PHOSPHATE_module::I().PO4_SF_WT_UPTAK_u262_exe(); }
int PO4_X_OUT_u263_exe_g(Variable* obj) { return PHOSPHATE_module::I().PO4_X_OUT_u263_exe(); }
int PO4_SOIL_I264_exe_g(Variable* obj) { return PHOSPHATE_module::I().PO4_SOIL_I264_exe(); }
int PO4_SOIL_i265_exe_g(Variable* obj) { return PHOSPHATE_module::I().PO4_SOIL_i265_exe(); }
int PO4_E_X_u266_exe_g(Variable* obj) { return PHOSPHATE_module::I().PO4_E_X_u266_exe(); }
int PO4_N_X_u267_exe_g(Variable* obj) { return PHOSPHATE_module::I().PO4_N_X_u267_exe(); }
int PO4_SF_WT_CONC_u268_exe_g(Variable* obj) { return PHOSPHATE_module::I().PO4_SF_WT_CONC_u268_exe(); }
int PO4_S_X_u269_exe_g(Variable* obj) { return PHOSPHATE_module::I().PO4_S_X_u269_exe(); }
int PO4_W_X_u270_exe_g(Variable* obj) { return PHOSPHATE_module::I().PO4_W_X_u270_exe(); }
int RIVER_P_u271_exe_g(Variable* obj) { return PHOSPHATE_module::I().RIVER_P_u271_exe(); }
int P1_IC_PO4_u272_exe_g(Variable* obj) { return PHOSPHATE_module::I().P1_IC_PO4_u272_exe(); }
int P1_PO4_DIFFUSION_COEFF_u273_exe_g(Variable* obj) { return PHOSPHATE_module::I().P1_PO4_DIFFUSION_COEFF_u273_exe(); }
int P1_PO4_SED_WT_CONC_u274_exe_g(Variable* obj) { return PHOSPHATE_module::I().P1_PO4_SED_WT_CONC_u274_exe(); }
int P1_RIVER_DATA_CF_u275_exe_g(Variable* obj) { return PHOSPHATE_module::I().P1_RIVER_DATA_CF_u275_exe(); }
// ---------------------------------------------------------------------------
//                    Class PHYTOPLANKTON_module 
// ---------------------------------------------------------------------------

class PHYTOPLANKTON_module : public TModule {
protected:

	PHYTOPLANKTON_module(char* name);

public:

	TTime TIME;
	CStateVariable PHYTOPLANKTON;
	CAuxVariable PHT_NET_PROD;
	CAuxVariable P1_PHT_NC;
	CAuxVariable PHT_CONC;
	CAuxVariable P1_PHY_PC;
	CAuxVariable WATER_DEPTH;
	CAuxVariable P1_CELL_SIZE;
	CAuxVariable SF_WATER;
	CAuxVariable CONS_INGEST_PHT;
	CAuxVariable P1_RIVER_DATA_CF;
	CAuxVariable DIN_CONC;
	CAuxVariable PO4_SF_WT_CONC;
	CAuxVariable PHT_LIGHT_LIM;
	CAuxVariable H2O_TEMP;
	CAuxVariable SF_WT_E_X;
	CAuxVariable SF_WT_N_X;
	CAuxVariable SF_WT_S_X;
	CAuxVariable SF_WT_W_X;
	CFluxVariable PHT_GROSS_PP;
	CFluxVariable PHT_X_IN;
	CFluxVariable PHT_X_OUT;
	CFluxVariable PHT_RESP;
	CFluxVariable PHT_CONSUMED;
	CFluxVariable PHT_MORTALITY;
	CFluxVariable PHT_DOWNFLOW;
	CAuxVariable PHT_NUT_LIMIT;
	CAuxVariable PHT_PROD_LIM;
	CAuxVariable PHT_TEMP_LIM;
	CAuxVariable PHT_X_E;
	CAuxVariable PHT_X_N;
	CAuxVariable PHT_X_S;
	CAuxVariable PHT_X_W;
	CAuxVariable RIVER_PHT;
	CAuxVariable P1_IC_PHT;
	CAuxVariable P1_PHT_GROSS_PP_RT;
	CAuxVariable P1_PHT_MORTALITY_RT;
	CAuxVariable P1_PHT_N_SAT;
	CAuxVariable P1_PHT_P_SAT;
	CAuxVariable P1_PHT_RESP_RT;
	CAuxVariable P1_PHT_TEMP_COEFF;
protected:

	int PHYTOPLANKTON_I276_exe();
	friend int PHYTOPLANKTON_I276_exe_g( Variable* v );
	int PHYTOPLANKTON_i277_exe();
	friend int PHYTOPLANKTON_i277_exe_g( Variable* v );
	int PHT_GROSS_PP_u278_exe();
	friend int PHT_GROSS_PP_u278_exe_g( Variable* v );
	int PHT_X_IN_u279_exe();
	friend int PHT_X_IN_u279_exe_g( Variable* v );
	int PHT_X_OUT_u280_exe();
	friend int PHT_X_OUT_u280_exe_g( Variable* v );
	int PHT_RESP_u281_exe();
	friend int PHT_RESP_u281_exe_g( Variable* v );
	int PHT_CONSUMED_u282_exe();
	friend int PHT_CONSUMED_u282_exe_g( Variable* v );
	int PHT_MORTALITY_u283_exe();
	friend int PHT_MORTALITY_u283_exe_g( Variable* v );
	int PHT_DOWNFLOW_u284_exe();
	friend int PHT_DOWNFLOW_u284_exe_g( Variable* v );
	int PHT_CONC_u285_exe();
	friend int PHT_CONC_u285_exe_g( Variable* v );
	int PHT_NET_PROD_u286_exe();
	friend int PHT_NET_PROD_u286_exe_g( Variable* v );
	int PHT_NUT_LIMIT_u287_exe();
	friend int PHT_NUT_LIMIT_u287_exe_g( Variable* v );
	int PHT_PROD_LIM_u288_exe();
	friend int PHT_PROD_LIM_u288_exe_g( Variable* v );
	int PHT_TEMP_LIM_u289_exe();
	friend int PHT_TEMP_LIM_u289_exe_g( Variable* v );
	int PHT_X_E_u290_exe();
	friend int PHT_X_E_u290_exe_g( Variable* v );
	int PHT_X_N_u291_exe();
	friend int PHT_X_N_u291_exe_g( Variable* v );
	int PHT_X_S_u292_exe();
	friend int PHT_X_S_u292_exe_g( Variable* v );
	int PHT_X_W_u293_exe();
	friend int PHT_X_W_u293_exe_g( Variable* v );
	int RIVER_PHT_u294_exe();
	friend int RIVER_PHT_u294_exe_g( Variable* v );
	int P1_IC_PHT_u295_exe();
	friend int P1_IC_PHT_u295_exe_g( Variable* v );
	int P1_PHT_GROSS_PP_RT_u296_exe();
	friend int P1_PHT_GROSS_PP_RT_u296_exe_g( Variable* v );
	int P1_PHT_MORTALITY_RT_u297_exe();
	friend int P1_PHT_MORTALITY_RT_u297_exe_g( Variable* v );
	int P1_PHT_NC_u298_exe();
	friend int P1_PHT_NC_u298_exe_g( Variable* v );
	int P1_PHT_N_SAT_u299_exe();
	friend int P1_PHT_N_SAT_u299_exe_g( Variable* v );
	int P1_PHT_P_SAT_u300_exe();
	friend int P1_PHT_P_SAT_u300_exe_g( Variable* v );
	int P1_PHT_RESP_RT_u301_exe();
	friend int P1_PHT_RESP_RT_u301_exe_g( Variable* v );
	int P1_PHT_TEMP_COEFF_u302_exe();
	friend int P1_PHT_TEMP_COEFF_u302_exe_g( Variable* v );
	int P1_PHY_PC_u303_exe();
	friend int P1_PHY_PC_u303_exe_g( Variable* v );
	static PHYTOPLANKTON_module* fInstance;
	static PHYTOPLANKTON_module* kNullModel;
public:
	inline static PHYTOPLANKTON_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new PHYTOPLANKTON_module("PHYTOPLANKTON_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (PHYTOPLANKTON_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int PHYTOPLANKTON_I276_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHYTOPLANKTON_I276_exe(); }
int PHYTOPLANKTON_i277_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHYTOPLANKTON_i277_exe(); }
int PHT_GROSS_PP_u278_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_GROSS_PP_u278_exe(); }
int PHT_X_IN_u279_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_X_IN_u279_exe(); }
int PHT_X_OUT_u280_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_X_OUT_u280_exe(); }
int PHT_RESP_u281_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_RESP_u281_exe(); }
int PHT_CONSUMED_u282_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_CONSUMED_u282_exe(); }
int PHT_MORTALITY_u283_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_MORTALITY_u283_exe(); }
int PHT_DOWNFLOW_u284_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_DOWNFLOW_u284_exe(); }
int PHT_CONC_u285_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_CONC_u285_exe(); }
int PHT_NET_PROD_u286_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_NET_PROD_u286_exe(); }
int PHT_NUT_LIMIT_u287_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_NUT_LIMIT_u287_exe(); }
int PHT_PROD_LIM_u288_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_PROD_LIM_u288_exe(); }
int PHT_TEMP_LIM_u289_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_TEMP_LIM_u289_exe(); }
int PHT_X_E_u290_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_X_E_u290_exe(); }
int PHT_X_N_u291_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_X_N_u291_exe(); }
int PHT_X_S_u292_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_X_S_u292_exe(); }
int PHT_X_W_u293_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_X_W_u293_exe(); }
int RIVER_PHT_u294_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().RIVER_PHT_u294_exe(); }
int P1_IC_PHT_u295_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().P1_IC_PHT_u295_exe(); }
int P1_PHT_GROSS_PP_RT_u296_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().P1_PHT_GROSS_PP_RT_u296_exe(); }
int P1_PHT_MORTALITY_RT_u297_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().P1_PHT_MORTALITY_RT_u297_exe(); }
int P1_PHT_NC_u298_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().P1_PHT_NC_u298_exe(); }
int P1_PHT_N_SAT_u299_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().P1_PHT_N_SAT_u299_exe(); }
int P1_PHT_P_SAT_u300_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().P1_PHT_P_SAT_u300_exe(); }
int P1_PHT_RESP_RT_u301_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().P1_PHT_RESP_RT_u301_exe(); }
int P1_PHT_TEMP_COEFF_u302_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().P1_PHT_TEMP_COEFF_u302_exe(); }
int P1_PHY_PC_u303_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().P1_PHY_PC_u303_exe(); }
// ---------------------------------------------------------------------------
//                    Class SALT_module 
// ---------------------------------------------------------------------------

class SALT_module : public TModule {
protected:

	SALT_module(char* name);

public:

	TTime TIME;
	CAuxVariable SF_WATER;
	CAuxVariable SF_WT_E_X;
	CAuxVariable SF_WT_N_X;
	CAuxVariable SF_WT_S_X;
	CAuxVariable SF_WT_W_X;
	CStateVariable SALT_SURF_WT;
	CFluxVariable SALT_X_IN;
	CFluxVariable SALT_X_OUT;
	CFluxVariable SALT_DOWNFLOW;
	CAuxVariable RIVER_NACL;
	CAuxVariable SALINITY;
	CAuxVariable SALT_CONC;
	CAuxVariable SALT_E_X;
	CAuxVariable SALT_N_X;
	CAuxVariable SALT_S_X;
	CAuxVariable SALT_W_X;
	CAuxVariable P1_IC_SALT;
protected:

	int SALT_SURF_WT_I304_exe();
	friend int SALT_SURF_WT_I304_exe_g( Variable* v );
	int SALT_SURF_WT_i305_exe();
	friend int SALT_SURF_WT_i305_exe_g( Variable* v );
	int SALT_X_IN_u306_exe();
	friend int SALT_X_IN_u306_exe_g( Variable* v );
	int SALT_X_OUT_u307_exe();
	friend int SALT_X_OUT_u307_exe_g( Variable* v );
	int SALT_DOWNFLOW_u308_exe();
	friend int SALT_DOWNFLOW_u308_exe_g( Variable* v );
	int RIVER_NACL_u309_exe();
	friend int RIVER_NACL_u309_exe_g( Variable* v );
	int SALINITY_u310_exe();
	friend int SALINITY_u310_exe_g( Variable* v );
	int SALT_CONC_u311_exe();
	friend int SALT_CONC_u311_exe_g( Variable* v );
	int SALT_E_X_u312_exe();
	friend int SALT_E_X_u312_exe_g( Variable* v );
	int SALT_N_X_u313_exe();
	friend int SALT_N_X_u313_exe_g( Variable* v );
	int SALT_S_X_u314_exe();
	friend int SALT_S_X_u314_exe_g( Variable* v );
	int SALT_W_X_u315_exe();
	friend int SALT_W_X_u315_exe_g( Variable* v );
	int P1_IC_SALT_u316_exe();
	friend int P1_IC_SALT_u316_exe_g( Variable* v );
	static SALT_module* fInstance;
	static SALT_module* kNullModel;
public:
	inline static SALT_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new SALT_module("SALT_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (SALT_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int SALT_SURF_WT_I304_exe_g(Variable* obj) { return SALT_module::I().SALT_SURF_WT_I304_exe(); }
int SALT_SURF_WT_i305_exe_g(Variable* obj) { return SALT_module::I().SALT_SURF_WT_i305_exe(); }
int SALT_X_IN_u306_exe_g(Variable* obj) { return SALT_module::I().SALT_X_IN_u306_exe(); }
int SALT_X_OUT_u307_exe_g(Variable* obj) { return SALT_module::I().SALT_X_OUT_u307_exe(); }
int SALT_DOWNFLOW_u308_exe_g(Variable* obj) { return SALT_module::I().SALT_DOWNFLOW_u308_exe(); }
int RIVER_NACL_u309_exe_g(Variable* obj) { return SALT_module::I().RIVER_NACL_u309_exe(); }
int SALINITY_u310_exe_g(Variable* obj) { return SALT_module::I().SALINITY_u310_exe(); }
int SALT_CONC_u311_exe_g(Variable* obj) { return SALT_module::I().SALT_CONC_u311_exe(); }
int SALT_E_X_u312_exe_g(Variable* obj) { return SALT_module::I().SALT_E_X_u312_exe(); }
int SALT_N_X_u313_exe_g(Variable* obj) { return SALT_module::I().SALT_N_X_u313_exe(); }
int SALT_S_X_u314_exe_g(Variable* obj) { return SALT_module::I().SALT_S_X_u314_exe(); }
int SALT_W_X_u315_exe_g(Variable* obj) { return SALT_module::I().SALT_W_X_u315_exe(); }
int P1_IC_SALT_u316_exe_g(Variable* obj) { return SALT_module::I().P1_IC_SALT_u316_exe(); }
// ---------------------------------------------------------------------------
//                    Class SEAWEED_module 
// ---------------------------------------------------------------------------

class SEAWEED_module : public TModule {
protected:

	SEAWEED_module(char* name);

public:

	TTime TIME;
	CStateVariable SEAWEEDS;
	CAuxVariable WATER_DEPTH;
	CAuxVariable P1_CELL_SIZE;
	CAuxVariable SF_WATER;
	CAuxVariable CONS_INGEST_SW;
	CAuxVariable P1_IC_MAC_PHBIO;
	CAuxVariable P1_SEPT_TO_JAN_CONV;
	CAuxVariable SF_WT_E_X;
	CAuxVariable DIN_CONC;
	CAuxVariable PO4_SF_WT_CONC;
	CAuxVariable SF_WT_N_X;
	CAuxVariable SW_LIGHT_LIM;
	CAuxVariable SF_WT_S_X;
	CAuxVariable H2O_TEMP;
	CAuxVariable SF_WT_W_X;
	CStateVariable DAYS;
	CAuxVariable CURRENT_VELOCITY;
	CFluxVariable SW_GROSS_PP;
	CFluxVariable SW_X_IN;
	CFluxVariable SW_REPRODUCTION;
	CFluxVariable SW_X_OUT;
	CFluxVariable SW_RESP;
	CFluxVariable SW_CONSUMED;
	CFluxVariable SW_MORT;
	CAuxVariable IC_SEAWEED;
	CAuxVariable SW_CONC;
	CAuxVariable SW_E_X;
	CAuxVariable SW_NET_PROD;
	CAuxVariable SW_NUT_LIMIT;
	CAuxVariable SW_N_X;
	CAuxVariable SW_PROD_LIM;
	CAuxVariable SW_S_X;
	CAuxVariable SW_TEMP_LIM;
	CAuxVariable SW_W_X;
	CAuxVariable P1_SW_MORT_RT;
	CAuxVariable P1_SW_NC;
	CAuxVariable P1_SW_N_SAT;
	CAuxVariable P1_SW_PC;
	CAuxVariable P1_SW_PP_RT;
	CAuxVariable P1_SW_P_SAT;
	CAuxVariable P1_SW_RESP_RT;
	CAuxVariable P1_SW_SEEDING_RT;
	CAuxVariable P1_SW_T_COEFF;
	CAuxVariable REPRODUCTION_SEASON;
	CAuxVariable SEAWEED_RATE;
protected:

	int SEAWEEDS_I317_exe();
	friend int SEAWEEDS_I317_exe_g( Variable* v );
	int SEAWEEDS_i318_exe();
	friend int SEAWEEDS_i318_exe_g( Variable* v );
	int SW_GROSS_PP_u319_exe();
	friend int SW_GROSS_PP_u319_exe_g( Variable* v );
	int SW_X_IN_u320_exe();
	friend int SW_X_IN_u320_exe_g( Variable* v );
	int SW_REPRODUCTION_u321_exe();
	friend int SW_REPRODUCTION_u321_exe_g( Variable* v );
	int SW_X_OUT_u322_exe();
	friend int SW_X_OUT_u322_exe_g( Variable* v );
	int SW_RESP_u323_exe();
	friend int SW_RESP_u323_exe_g( Variable* v );
	int SW_CONSUMED_u324_exe();
	friend int SW_CONSUMED_u324_exe_g( Variable* v );
	int SW_MORT_u325_exe();
	friend int SW_MORT_u325_exe_g( Variable* v );
	int IC_SEAWEED_u326_exe();
	friend int IC_SEAWEED_u326_exe_g( Variable* v );
	int SW_CONC_u327_exe();
	friend int SW_CONC_u327_exe_g( Variable* v );
	int SW_E_X_u328_exe();
	friend int SW_E_X_u328_exe_g( Variable* v );
	int SW_NET_PROD_u329_exe();
	friend int SW_NET_PROD_u329_exe_g( Variable* v );
	int SW_NUT_LIMIT_u330_exe();
	friend int SW_NUT_LIMIT_u330_exe_g( Variable* v );
	int SW_N_X_u331_exe();
	friend int SW_N_X_u331_exe_g( Variable* v );
	int SW_PROD_LIM_u332_exe();
	friend int SW_PROD_LIM_u332_exe_g( Variable* v );
	int SW_S_X_u333_exe();
	friend int SW_S_X_u333_exe_g( Variable* v );
	int SW_TEMP_LIM_u334_exe();
	friend int SW_TEMP_LIM_u334_exe_g( Variable* v );
	int SW_W_X_u335_exe();
	friend int SW_W_X_u335_exe_g( Variable* v );
	int P1_SW_MORT_RT_u336_exe();
	friend int P1_SW_MORT_RT_u336_exe_g( Variable* v );
	int P1_SW_NC_u337_exe();
	friend int P1_SW_NC_u337_exe_g( Variable* v );
	int P1_SW_N_SAT_u338_exe();
	friend int P1_SW_N_SAT_u338_exe_g( Variable* v );
	int P1_SW_PC_u339_exe();
	friend int P1_SW_PC_u339_exe_g( Variable* v );
	int P1_SW_PP_RT_u340_exe();
	friend int P1_SW_PP_RT_u340_exe_g( Variable* v );
	int P1_SW_P_SAT_u341_exe();
	friend int P1_SW_P_SAT_u341_exe_g( Variable* v );
	int P1_SW_RESP_RT_u342_exe();
	friend int P1_SW_RESP_RT_u342_exe_g( Variable* v );
	int P1_SW_SEEDING_RT_u343_exe();
	friend int P1_SW_SEEDING_RT_u343_exe_g( Variable* v );
	int P1_SW_T_COEFF_u344_exe();
	friend int P1_SW_T_COEFF_u344_exe_g( Variable* v );
	int REPRODUCTION_SEASON_u345_exe();
	friend int REPRODUCTION_SEASON_u345_exe_g( Variable* v );
	int SEAWEED_RATE_u346_exe();
	friend int SEAWEED_RATE_u346_exe_g( Variable* v );
	static SEAWEED_module* fInstance;
	static SEAWEED_module* kNullModel;
public:
	inline static SEAWEED_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new SEAWEED_module("SEAWEED_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (SEAWEED_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}

	inline double Graph13(double x) { 
		static double g[13][2] = {
			{ 0.0000E+00, 0.000000E+00},{ 3.0400E+01, 0.000000E+00},{ 6.0800E+01, 0.000000E+00},{ 9.1200E+01, 0.000000E+00},
			{ 1.2200E+02, 1.000000E+00},{ 1.5200E+02, 1.000000E+00},{ 1.8200E+02, 1.000000E+00},{ 2.1300E+02, 1.000000E+00},
			{ 2.4300E+02, 1.000000E+00},{ 2.7400E+02, 1.000000E+00},{ 3.0400E+02, 1.000000E+00},{ 3.3500E+02, 1.000000E+00},
			{ 3.6500E+02, 0.000000E+00}, };
		return SL::Graph( 0, x, 12, g); 
	}

	inline double Graph14(double x) { 
		static double g[13][2] = {
			{ 0.0000E+00, 0.000000E+00},{ 4.1700E-02, 0.000000E+00},{ 8.3300E-02, 0.000000E+00},{ 1.2500E-01, 0.000000E+00},
			{ 1.6700E-01, 0.000000E+00},{ 2.0800E-01, 0.000000E+00},{ 2.5000E-01, 0.000000E+00},{ 2.9200E-01, 1.000000E+00},
			{ 3.3300E-01, 1.000000E+00},{ 3.7500E-01, 1.000000E+00},{ 4.1700E-01, 1.000000E+00},{ 4.5800E-01, 1.000000E+00},
			{ 5.0000E-01, 1.000000E+00}, };
		return SL::Graph( 0, x, 12, g); 
	}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int SEAWEEDS_I317_exe_g(Variable* obj) { return SEAWEED_module::I().SEAWEEDS_I317_exe(); }
int SEAWEEDS_i318_exe_g(Variable* obj) { return SEAWEED_module::I().SEAWEEDS_i318_exe(); }
int SW_GROSS_PP_u319_exe_g(Variable* obj) { return SEAWEED_module::I().SW_GROSS_PP_u319_exe(); }
int SW_X_IN_u320_exe_g(Variable* obj) { return SEAWEED_module::I().SW_X_IN_u320_exe(); }
int SW_REPRODUCTION_u321_exe_g(Variable* obj) { return SEAWEED_module::I().SW_REPRODUCTION_u321_exe(); }
int SW_X_OUT_u322_exe_g(Variable* obj) { return SEAWEED_module::I().SW_X_OUT_u322_exe(); }
int SW_RESP_u323_exe_g(Variable* obj) { return SEAWEED_module::I().SW_RESP_u323_exe(); }
int SW_CONSUMED_u324_exe_g(Variable* obj) { return SEAWEED_module::I().SW_CONSUMED_u324_exe(); }
int SW_MORT_u325_exe_g(Variable* obj) { return SEAWEED_module::I().SW_MORT_u325_exe(); }
int IC_SEAWEED_u326_exe_g(Variable* obj) { return SEAWEED_module::I().IC_SEAWEED_u326_exe(); }
int SW_CONC_u327_exe_g(Variable* obj) { return SEAWEED_module::I().SW_CONC_u327_exe(); }
int SW_E_X_u328_exe_g(Variable* obj) { return SEAWEED_module::I().SW_E_X_u328_exe(); }
int SW_NET_PROD_u329_exe_g(Variable* obj) { return SEAWEED_module::I().SW_NET_PROD_u329_exe(); }
int SW_NUT_LIMIT_u330_exe_g(Variable* obj) { return SEAWEED_module::I().SW_NUT_LIMIT_u330_exe(); }
int SW_N_X_u331_exe_g(Variable* obj) { return SEAWEED_module::I().SW_N_X_u331_exe(); }
int SW_PROD_LIM_u332_exe_g(Variable* obj) { return SEAWEED_module::I().SW_PROD_LIM_u332_exe(); }
int SW_S_X_u333_exe_g(Variable* obj) { return SEAWEED_module::I().SW_S_X_u333_exe(); }
int SW_TEMP_LIM_u334_exe_g(Variable* obj) { return SEAWEED_module::I().SW_TEMP_LIM_u334_exe(); }
int SW_W_X_u335_exe_g(Variable* obj) { return SEAWEED_module::I().SW_W_X_u335_exe(); }
int P1_SW_MORT_RT_u336_exe_g(Variable* obj) { return SEAWEED_module::I().P1_SW_MORT_RT_u336_exe(); }
int P1_SW_NC_u337_exe_g(Variable* obj) { return SEAWEED_module::I().P1_SW_NC_u337_exe(); }
int P1_SW_N_SAT_u338_exe_g(Variable* obj) { return SEAWEED_module::I().P1_SW_N_SAT_u338_exe(); }
int P1_SW_PC_u339_exe_g(Variable* obj) { return SEAWEED_module::I().P1_SW_PC_u339_exe(); }
int P1_SW_PP_RT_u340_exe_g(Variable* obj) { return SEAWEED_module::I().P1_SW_PP_RT_u340_exe(); }
int P1_SW_P_SAT_u341_exe_g(Variable* obj) { return SEAWEED_module::I().P1_SW_P_SAT_u341_exe(); }
int P1_SW_RESP_RT_u342_exe_g(Variable* obj) { return SEAWEED_module::I().P1_SW_RESP_RT_u342_exe(); }
int P1_SW_SEEDING_RT_u343_exe_g(Variable* obj) { return SEAWEED_module::I().P1_SW_SEEDING_RT_u343_exe(); }
int P1_SW_T_COEFF_u344_exe_g(Variable* obj) { return SEAWEED_module::I().P1_SW_T_COEFF_u344_exe(); }
int REPRODUCTION_SEASON_u345_exe_g(Variable* obj) { return SEAWEED_module::I().REPRODUCTION_SEASON_u345_exe(); }
int SEAWEED_RATE_u346_exe_g(Variable* obj) { return SEAWEED_module::I().SEAWEED_RATE_u346_exe(); }
// ---------------------------------------------------------------------------
//                    Class TSS_module 
// ---------------------------------------------------------------------------

class TSS_module : public TModule {
protected:

	TSS_module(char* name);

public:

	TTime TIME;
	CAuxVariable TSS_CONC;
	CAuxVariable SF_WATER;
	CAuxVariable WATER_DEPTH;
	CAuxVariable VEG_STRUCTURE;
	CAuxVariable SHEAR_STRESS;
	CAuxVariable P1_RIVER_DATA_CF;
	CAuxVariable SF_WT_E_X;
	CAuxVariable SF_WT_N_X;
	CAuxVariable SF_WT_S_X;
	CAuxVariable SF_WT_W_X;
	CStateVariable SUS_SED;
	CFluxVariable SED_SUSP;
	CFluxVariable TSS_X_IN;
	CFluxVariable TSS_X_OUT;
	CFluxVariable SED_DEPO;
	CAuxVariable RIVER_TSS;
	CAuxVariable SETTLING_VELOCITY;
	CAuxVariable SHEAR_RES;
	CAuxVariable STRESS_EFFECT;
	CAuxVariable TSS_X_E;
	CAuxVariable TSS_X_N;
	CAuxVariable TSS_X_S;
	CAuxVariable TSS_X_W;
	CAuxVariable P1_IC_TSS;
	CAuxVariable P1_RESISTANCE_COEFF;
	CAuxVariable P1_SETTLING_RT;
	CAuxVariable EDDY_VISCOSITY;
	CAuxVariable POT_EROS;
protected:

	int SUS_SED_I347_exe();
	friend int SUS_SED_I347_exe_g( Variable* v );
	int SUS_SED_i348_exe();
	friend int SUS_SED_i348_exe_g( Variable* v );
	int SED_SUSP_u349_exe();
	friend int SED_SUSP_u349_exe_g( Variable* v );
	int TSS_X_IN_u350_exe();
	friend int TSS_X_IN_u350_exe_g( Variable* v );
	int TSS_X_OUT_u351_exe();
	friend int TSS_X_OUT_u351_exe_g( Variable* v );
	int SED_DEPO_u352_exe();
	friend int SED_DEPO_u352_exe_g( Variable* v );
	int RIVER_TSS_u353_exe();
	friend int RIVER_TSS_u353_exe_g( Variable* v );
	int SETTLING_VELOCITY_u354_exe();
	friend int SETTLING_VELOCITY_u354_exe_g( Variable* v );
	int SHEAR_RES_u355_exe();
	friend int SHEAR_RES_u355_exe_g( Variable* v );
	int STRESS_EFFECT_u356_exe();
	friend int STRESS_EFFECT_u356_exe_g( Variable* v );
	int TSS_CONC_u357_exe();
	friend int TSS_CONC_u357_exe_g( Variable* v );
	int TSS_X_E_u358_exe();
	friend int TSS_X_E_u358_exe_g( Variable* v );
	int TSS_X_N_u359_exe();
	friend int TSS_X_N_u359_exe_g( Variable* v );
	int TSS_X_S_u360_exe();
	friend int TSS_X_S_u360_exe_g( Variable* v );
	int TSS_X_W_u361_exe();
	friend int TSS_X_W_u361_exe_g( Variable* v );
	int P1_IC_TSS_u362_exe();
	friend int P1_IC_TSS_u362_exe_g( Variable* v );
	int P1_RESISTANCE_COEFF_u363_exe();
	friend int P1_RESISTANCE_COEFF_u363_exe_g( Variable* v );
	int P1_SETTLING_RT_u364_exe();
	friend int P1_SETTLING_RT_u364_exe_g( Variable* v );
	int EDDY_VISCOSITY_u365_exe();
	friend int EDDY_VISCOSITY_u365_exe_g( Variable* v );
	int POT_EROS_u366_exe();
	friend int POT_EROS_u366_exe_g( Variable* v );
	static TSS_module* fInstance;
	static TSS_module* kNullModel;
public:
	inline static TSS_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new TSS_module("TSS_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (TSS_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}

	inline double Graph15(double x) { 
		static double g[11][2] = {
			{ 0.0000E+00, 1.000000E-02},{ 1.0000E+01, 1.700000E+01},{ 2.0000E+01, 3.200000E+01},{ 3.0000E+01, 4.200000E+01},
			{ 4.0000E+01, 5.250000E+01},{ 5.0000E+01, 6.300000E+01},{ 6.0000E+01, 7.400000E+01},{ 7.0000E+01, 8.350000E+01},
			{ 8.0000E+01, 9.050000E+01},{ 9.0000E+01, 9.550000E+01},{ 1.0000E+02, 1.000000E+02}, };
		return SL::Graph( 0, x, 10, g); 
	}

	inline double Graph16(double x) { 
		static double g[11][2] = {
			{ 0.0000E+00, 0.000000E+00},{ 1.0000E-02, 2.800000E-04},{ 2.0000E-02, 4.800000E-04},{ 3.0000E-02, 6.200000E-04},
			{ 4.0000E-02, 7.400000E-04},{ 5.0000E-02, 8.250000E-04},{ 6.0000E-02, 8.650000E-04},{ 7.0000E-02, 8.950000E-04},
			{ 8.0000E-02, 9.150000E-04},{ 9.0000E-02, 9.150000E-04},{ 1.0000E-01, 9.200000E-04}, };
		return SL::Graph( 0, x, 10, g); 
	}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int SUS_SED_I347_exe_g(Variable* obj) { return TSS_module::I().SUS_SED_I347_exe(); }
int SUS_SED_i348_exe_g(Variable* obj) { return TSS_module::I().SUS_SED_i348_exe(); }
int SED_SUSP_u349_exe_g(Variable* obj) { return TSS_module::I().SED_SUSP_u349_exe(); }
int TSS_X_IN_u350_exe_g(Variable* obj) { return TSS_module::I().TSS_X_IN_u350_exe(); }
int TSS_X_OUT_u351_exe_g(Variable* obj) { return TSS_module::I().TSS_X_OUT_u351_exe(); }
int SED_DEPO_u352_exe_g(Variable* obj) { return TSS_module::I().SED_DEPO_u352_exe(); }
int RIVER_TSS_u353_exe_g(Variable* obj) { return TSS_module::I().RIVER_TSS_u353_exe(); }
int SETTLING_VELOCITY_u354_exe_g(Variable* obj) { return TSS_module::I().SETTLING_VELOCITY_u354_exe(); }
int SHEAR_RES_u355_exe_g(Variable* obj) { return TSS_module::I().SHEAR_RES_u355_exe(); }
int STRESS_EFFECT_u356_exe_g(Variable* obj) { return TSS_module::I().STRESS_EFFECT_u356_exe(); }
int TSS_CONC_u357_exe_g(Variable* obj) { return TSS_module::I().TSS_CONC_u357_exe(); }
int TSS_X_E_u358_exe_g(Variable* obj) { return TSS_module::I().TSS_X_E_u358_exe(); }
int TSS_X_N_u359_exe_g(Variable* obj) { return TSS_module::I().TSS_X_N_u359_exe(); }
int TSS_X_S_u360_exe_g(Variable* obj) { return TSS_module::I().TSS_X_S_u360_exe(); }
int TSS_X_W_u361_exe_g(Variable* obj) { return TSS_module::I().TSS_X_W_u361_exe(); }
int P1_IC_TSS_u362_exe_g(Variable* obj) { return TSS_module::I().P1_IC_TSS_u362_exe(); }
int P1_RESISTANCE_COEFF_u363_exe_g(Variable* obj) { return TSS_module::I().P1_RESISTANCE_COEFF_u363_exe(); }
int P1_SETTLING_RT_u364_exe_g(Variable* obj) { return TSS_module::I().P1_SETTLING_RT_u364_exe(); }
int EDDY_VISCOSITY_u365_exe_g(Variable* obj) { return TSS_module::I().EDDY_VISCOSITY_u365_exe(); }
int POT_EROS_u366_exe_g(Variable* obj) { return TSS_module::I().POT_EROS_u366_exe(); }

#endif
