#include "HNMD.h"


void gInitializeModel() {
	TModel::I().GlobalMod(&HNMD_module::I());
	HNMD_module::I().Initialize();
	HNMD_module::I().SetMInfo(TModule::kisGlobal,True);
	PAR_module::I().Initialize();
	XXXIMPORTS6_module::I().Initialize();
	MACROPHYTES_module::I().Initialize();
	XXXIMPORTS5_module::I().Initialize();
	HYDROLOGY_module::I().Initialize();
	XXXIMPORTS4_module::I().Initialize();
	GLOBALS_module::I().Initialize();
	XXXIMPORTS3_module::I().Initialize();
	ETPM_module::I().Initialize();
	XXXIMPORTS2_module::I().Initialize();
	DOM_module::I().Initialize();
	XXXIMPORTS1_module::I().Initialize();
	ZDIN_module::I().Initialize();
	XXXIMPORTS0_module::I().Initialize();
	HNMD_module::I().MakeConnections();
	PAR_module::I().MakeConnections();
	XXXIMPORTS6_module::I().MakeConnections();
	MACROPHYTES_module::I().MakeConnections();
	XXXIMPORTS5_module::I().MakeConnections();
	HYDROLOGY_module::I().MakeConnections();
	XXXIMPORTS4_module::I().MakeConnections();
	GLOBALS_module::I().MakeConnections();
	XXXIMPORTS3_module::I().MakeConnections();
	ETPM_module::I().MakeConnections();
	XXXIMPORTS2_module::I().MakeConnections();
	DOM_module::I().MakeConnections();
	XXXIMPORTS1_module::I().MakeConnections();
	ZDIN_module::I().MakeConnections();
	XXXIMPORTS0_module::I().MakeConnections();
}

// ---------------------------------------------------------------------------
//                    Class HNMD_module 
// ---------------------------------------------------------------------------
HNMD_module::HNMD_module(char* name) :
	TIME("TIME"),
	TModule(name) {

}	
HNMD_module* HNMD_module::fInstance = NULL;
HNMD_module* HNMD_module::kNullModel = (HNMD_module*)0x1;
int HNMD_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int HNMD_module::InitVars() {
	
	TIME.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int HNMD_module::Initialize() {
	InitVars();
	HNMD_module::I().AddSubModule(&PAR_module::I());
	HNMD_module::I().AddSubModule(&XXXIMPORTS6_module::I());
	HNMD_module::I().AddSubModule(&MACROPHYTES_module::I());
	HNMD_module::I().AddSubModule(&XXXIMPORTS5_module::I());
	HNMD_module::I().AddSubModule(&HYDROLOGY_module::I());
	HNMD_module::I().AddSubModule(&XXXIMPORTS4_module::I());
	HNMD_module::I().AddSubModule(&GLOBALS_module::I());
	HNMD_module::I().AddSubModule(&XXXIMPORTS3_module::I());
	HNMD_module::I().AddSubModule(&ETPM_module::I());
	HNMD_module::I().AddSubModule(&XXXIMPORTS2_module::I());
	HNMD_module::I().AddSubModule(&DOM_module::I());
	HNMD_module::I().AddSubModule(&XXXIMPORTS1_module::I());
	HNMD_module::I().AddSubModule(&ZDIN_module::I());
	HNMD_module::I().AddSubModule(&XXXIMPORTS0_module::I());
	Model::I0().ModuleList().Alphabetize();
	return 1;
}

int HNMD_module::MakeConnections() {
	PAR_module::I().P1_C_LATDEG.Connect(&(GLOBALS_module::I().P1_C_LATDEG));
	PAR_module::I().CLOUDY.Connect(&(GLOBALS_module::I().CLOUDY));
	PAR_module::I().DAYJUL.Connect(&(GLOBALS_module::I().DAYJUL));
	MACROPHYTES_module::I().AIR_TEMP_C.Connect(&(GLOBALS_module::I().AIR_TEMP_C));
	MACROPHYTES_module::I().HABITATMAP.Connect(&(GLOBALS_module::I().HABITATMAP));
	MACROPHYTES_module::I().DAYJUL.Connect(&(GLOBALS_module::I().DAYJUL));
	MACROPHYTES_module::I().DAYLENGTH.Connect(&(GLOBALS_module::I().DAYLENGTH));
	MACROPHYTES_module::I().SOLRADGR.Connect(&(XXXIMPORTS5_module::I().SOLRADGR));
	MACROPHYTES_module::I().DIN_AVAILABLE.Connect(&(ZDIN_module::I().DIN_AVAILABLE));
	MACROPHYTES_module::I().ELEVATION.Connect(&(GLOBALS_module::I().ELEVATION));
	MACROPHYTES_module::I().SURFACE_WATER.Connect(&(HYDROLOGY_module::I().SURFACE_WATER));
	MACROPHYTES_module::I().UW_DEPTH.Connect(&(HYDROLOGY_module::I().UW_DEPTH));
	MACROPHYTES_module::I().WATER_AVAIL.Connect(&(HYDROLOGY_module::I().WATER_AVAIL));
	HYDROLOGY_module::I().ON_MAP.Connect(&(GLOBALS_module::I().ON_MAP));
	HYDROLOGY_module::I().DIN_SD.Connect(&(ZDIN_module::I().DIN_SD));
	HYDROLOGY_module::I().HABITATMAP.Connect(&(GLOBALS_module::I().HABITATMAP));
	HYDROLOGY_module::I().AIR_TEMP_C.Connect(&(GLOBALS_module::I().AIR_TEMP_C));
	HYDROLOGY_module::I().PRECIP_M.Connect(&(GLOBALS_module::I().PRECIP_M));
	HYDROLOGY_module::I().HYDRO.Connect(&(GLOBALS_module::I().HYDRO));
	HYDROLOGY_module::I().ELEVATION.Connect(&(GLOBALS_module::I().ELEVATION));
	HYDROLOGY_module::I().DIN_SF.Connect(&(ZDIN_module::I().DIN_SF));
	HYDROLOGY_module::I().CELL_SIZE.Connect(&(GLOBALS_module::I().CELL_SIZE));
	HYDROLOGY_module::I().SOLRADGRD.Connect(&(PAR_module::I().SOLRADGRD));
	HYDROLOGY_module::I().MACLAI.Connect(&(MACROPHYTES_module::I().MACLAI));
	HYDROLOGY_module::I().SOIL.Connect(&(GLOBALS_module::I().SOIL));
	HYDROLOGY_module::I().HUMIDITY.Connect(&(GLOBALS_module::I().HUMIDITY));
	HYDROLOGY_module::I().WIND.Connect(&(GLOBALS_module::I().WIND));
	HYDROLOGY_module::I().ELEV_MIN.Connect(&(GLOBALS_module::I().ELEV_MIN));
	HYDROLOGY_module::I().ETPM.Connect(&(ETPM_module::I().ETPM));
	HYDROLOGY_module::I().ROOT_DEPTH.Connect(&(MACROPHYTES_module::I().ROOT_DEPTH));
	HYDROLOGY_module::I().P1_DATUM_TO_MSL.Connect(&(GLOBALS_module::I().P1_DATUM_TO_MSL));
	HYDROLOGY_module::I().P1_DEPTH_MSL_MAP.Connect(&(GLOBALS_module::I().P1_DEPTH_MSL_MAP));
	GLOBALS_module::I().SOLRADATM.Connect(&(PAR_module::I().SOLRADATM));
	GLOBALS_module::I().SOLRADGRD.Connect(&(PAR_module::I().SOLRADGRD));
	XXXIMPORTS3_module::I().DAYJUL.Connect(&(GLOBALS_module::I().DAYJUL));
	ETPM_module::I().VAP_PRESS.Connect(&(GLOBALS_module::I().VAP_PRESS));
	ETPM_module::I().AIR_TEMP_C.Connect(&(GLOBALS_module::I().AIR_TEMP_C));
	ETPM_module::I().SOLRADATM.Connect(&(PAR_module::I().SOLRADATM));
	ETPM_module::I().CLOUDY.Connect(&(GLOBALS_module::I().CLOUDY));
	ETPM_module::I().MACH.Connect(&(MACROPHYTES_module::I().MACH));
	ETPM_module::I().WIND.Connect(&(GLOBALS_module::I().WIND));
	ETPM_module::I().MACLAI.Connect(&(MACROPHYTES_module::I().MACLAI));
	DOM_module::I().PHBIO_MORT.Connect(&(MACROPHYTES_module::I().PHBIO_MORT));
	DOM_module::I().PHBIO_HARVEST.Connect(&(MACROPHYTES_module::I().PHBIO_HARVEST));
	DOM_module::I().NPHBIO_MORT.Connect(&(MACROPHYTES_module::I().NPHBIO_MORT));
	DOM_module::I().NPHBIO_HARVEST.Connect(&(MACROPHYTES_module::I().NPHBIO_HARVEST));
	DOM_module::I().AIR_TEMP_C.Connect(&(GLOBALS_module::I().AIR_TEMP_C));
	ZDIN_module::I().SAT_WATER.Connect(&(HYDROLOGY_module::I().SAT_WATER));
	ZDIN_module::I().UNSAT_WATER.Connect(&(HYDROLOGY_module::I().UNSAT_WATER));
	ZDIN_module::I().UW_FROM_PRECIP.Connect(&(HYDROLOGY_module::I().UW_FROM_PRECIP));
	ZDIN_module::I().SW_TO_SATW_DOWNFLOW.Connect(&(HYDROLOGY_module::I().SW_TO_SATW_DOWNFLOW));
	ZDIN_module::I().SATW_FROM_PRECIP.Connect(&(HYDROLOGY_module::I().SATW_FROM_PRECIP));
	ZDIN_module::I().CELL_SIZE.Connect(&(GLOBALS_module::I().CELL_SIZE));
	ZDIN_module::I().AIR_TEMP_C.Connect(&(GLOBALS_module::I().AIR_TEMP_C));
	ZDIN_module::I().SATW_TO_SW_UPFLOW.Connect(&(HYDROLOGY_module::I().SATW_TO_SW_UPFLOW));
	ZDIN_module::I().PHBIO_NPP.Connect(&(MACROPHYTES_module::I().PHBIO_NPP));
	ZDIN_module::I().UW_DEPTH.Connect(&(HYDROLOGY_module::I().UW_DEPTH));
	ZDIN_module::I().ELEVATION.Connect(&(GLOBALS_module::I().ELEVATION));
	ZDIN_module::I().SATW_OUTFLUX.Connect(&(HYDROLOGY_module::I().SATW_OUTFLUX));
	ZDIN_module::I().SW_OUTFLUX.Connect(&(HYDROLOGY_module::I().SW_OUTFLUX));
	ZDIN_module::I().DAYJUL.Connect(&(GLOBALS_module::I().DAYJUL));
	ZDIN_module::I().HABITATMAP.Connect(&(GLOBALS_module::I().HABITATMAP));
	ZDIN_module::I().ROOT_DEPTH.Connect(&(MACROPHYTES_module::I().ROOT_DEPTH));
	ZDIN_module::I().SURFACE_WATER.Connect(&(HYDROLOGY_module::I().SURFACE_WATER));
	ZDIN_module::I().D_DECOMP.Connect(&(DOM_module::I().D_DECOMP));
	ZDIN_module::I().P1_SEWERMAP.Connect(&(GLOBALS_module::I().P1_SEWERMAP));
	ZDIN_module::I().P1_POP_DENS.Connect(&(GLOBALS_module::I().P1_POP_DENS));
	ZDIN_module::I().HABITATMAPDB.Connect(&(GLOBALS_module::I().HABITATMAPDB));
	ZDIN_module::I().YIELD.Connect(&(MACROPHYTES_module::I().YIELD));
	ZDIN_module::I().OUT_F_SF.Connect(&(HYDROLOGY_module::I().OUT_F_SF));
	ZDIN_module::I().TOT_NPP.Connect(&(MACROPHYTES_module::I().TOT_NPP));
	ZDIN_module::I().SOIL.Connect(&(GLOBALS_module::I().SOIL));
	return 0;
}

int HNMD_module::SetupEvents() {
	return 0;
}

int HNMD_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int HNMD_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int HNMD_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int HNMD_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

int HNMD_module::PostInit() {
	PostEventsByType(TEvent::kInit);
	return 1;
}

// ---------------------------------------------------------------------------
//                    Class PAR_module 
// ---------------------------------------------------------------------------
PAR_module::PAR_module(char* name) :
	TIME("TIME"),
	P1_C_LATDEG("P1_C_LATDEG"),
	CLOUDY("CLOUDY"),
	DAYJUL("DAYJUL"),
	SOLRADGRD("SOLRADGRD"),
	SOLRADATM("SOLRADATM"),
	A("A"),
	ALPHA("ALPHA"),
	B("B"),
	BETTA("BETTA"),
	C("C"),
	T_RAD("T_RAD"),
	TModule(name) {

	P1_C_LATDEG.SetF(FisImport,True,"CG");
	CLOUDY.SetF(FisImport,True,"CG");
	DAYJUL.SetF(FisImport,True,"CG");
	SOLRADGRD.SetF(FisExport,True,"CG");
	SOLRADATM.SetF(FisExport,True,"CG");
}	
int PAR_module::A_u0_exe() {
	float value;

	switch( A.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = A.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)942)-( 6.68*P1_C_LATDEG.Value(p) ) );
			A.Update( p, value );
		}
		A.GrabMemory();
		if( A.GetF(FLinkEdges) ) { A.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)942)-( 6.68*P1_C_LATDEG.Value() ) );
			A.Update( value );
	  } break;
	}
	return 0;
}

int PAR_module::ALPHA_u1_exe() {
	float value;

	switch( ALPHA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ALPHA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( 32.9835-( 64.884*( ((float)1)-( 1.3614*SL::Cos(( ( ( SL::Int(P1_C_LATDEG.Value(p))+( ( P1_C_LATDEG.Value(p)-SL::Int(P1_C_LATDEG.Value(p)) )*1.16666667 ) )*3.141590 )/180 )) ) ) ) );
			ALPHA.Update( p, value );
		}
		ALPHA.GrabMemory();
		if( ALPHA.GetF(FLinkEdges) ) { ALPHA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( 32.9835-( 64.884*( ((float)1)-( 1.3614*SL::Cos(( ( ( SL::Int(P1_C_LATDEG.Value())+( ( P1_C_LATDEG.Value()-SL::Int(P1_C_LATDEG.Value()) )*1.16666667 ) )*3.141590 )/180 )) ) ) ) );
			ALPHA.Update( value );
	  } break;
	}
	return 0;
}

int PAR_module::B_u2_exe() {
	float value;

	switch( B.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = B.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)147)*pow((double)( P1_C_LATDEG.Value(p)-17.48 ),(double)0.27 ) );
			B.Update( p, value );
		}
		B.GrabMemory();
		if( B.GetF(FLinkEdges) ) { B.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)147)*pow((double)( P1_C_LATDEG.Value()-17.48 ),(double)0.27 ) );
			B.Update( value );
	  } break;
	}
	return 0;
}

int PAR_module::BETTA_u3_exe() {
	float value;

	switch( BETTA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = BETTA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( 0.715-( 0.3183*( ((float)1)-( 1.3614*SL::Cos(( ( ( SL::Int(P1_C_LATDEG.Value(p))+( ( P1_C_LATDEG.Value(p)-SL::Int(P1_C_LATDEG.Value(p)) )*1.16666667 ) )*3.141590 )/180 )) ) ) ) );
			BETTA.Update( p, value );
		}
		BETTA.GrabMemory();
		if( BETTA.GetF(FLinkEdges) ) { BETTA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( 0.715-( 0.3183*( ((float)1)-( 1.3614*SL::Cos(( ( ( SL::Int(P1_C_LATDEG.Value())+( ( P1_C_LATDEG.Value()-SL::Int(P1_C_LATDEG.Value()) )*1.16666667 ) )*3.141590 )/180 )) ) ) ) );
			BETTA.Update( value );
	  } break;
	}
	return 0;
}

int PAR_module::C_u4_exe() {
	float value;

	switch( C.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = C.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)175)-( 3.6*P1_C_LATDEG.Value(p) ) );
			C.Update( p, value );
		}
		C.GrabMemory();
		if( C.GetF(FLinkEdges) ) { C.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)175)-( 3.6*P1_C_LATDEG.Value() ) );
			C.Update( value );
	  } break;
	}
	return 0;
}

int PAR_module::SOLRADATM_u5_exe() {
	float value;

	switch( SOLRADATM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SOLRADATM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( A.Value(p)+( B.Value(p)*SL::Cos(T_RAD.Value(p)) ) )+( C.Value(p)*pow((double)SL::Sin(T_RAD.Value(p)),(double)((float)2) ) ) );
			SOLRADATM.Update( p, value );
		}
		SOLRADATM.GrabMemory();
		if( SOLRADATM.GetF(FLinkEdges) ) { SOLRADATM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( A.Value()+( B.Value()*SL::Cos(T_RAD.Value()) ) )+( C.Value()*pow((double)SL::Sin(T_RAD.Value()),(double)((float)2) ) ) );
			SOLRADATM.Update( value );
	  } break;
	}
	return 0;
}

int PAR_module::SOLRADGRD_u6_exe() {
	float value;

	switch( SOLRADGRD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SOLRADGRD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SOLRADATM.Value(p)*( BETTA.Value(p)-( 0.0326*CLOUDY.Value(p) ) ) )-ALPHA.Value(p) );
			SOLRADGRD.Update( p, value );
		}
		SOLRADGRD.GrabMemory();
		if( SOLRADGRD.GetF(FLinkEdges) ) { SOLRADGRD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SOLRADATM.Value()*( BETTA.Value()-( 0.0326*CLOUDY.Value() ) ) )-ALPHA.Value() );
			SOLRADGRD.Update( value );
	  } break;
	}
	return 0;
}

int PAR_module::T_RAD_u7_exe() {
	float value;

	switch( T_RAD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = T_RAD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ((float)2)/365 )*3.141590 )*( DAYJUL.Value(p)-((float)173) ) );
			T_RAD.Update( p, value );
		}
		T_RAD.GrabMemory();
		if( T_RAD.GetF(FLinkEdges) ) { T_RAD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ((float)2)/365 )*3.141590 )*( DAYJUL.Value()-((float)173) ) );
			T_RAD.Update( value );
	  } break;
	}
	return 0;
}

PAR_module* PAR_module::fInstance = NULL;
PAR_module* PAR_module::kNullModel = (PAR_module*)0x1;
int PAR_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int PAR_module::InitVars() {
	
	TIME.SSInit(this);
	P1_C_LATDEG.SSInit(this);
	CLOUDY.SSInit(this);
	DAYJUL.SSInit(this);
	SOLRADGRD.SSInit(this);
	SOLRADATM.SSInit(this);
	A.SSInit(this);
	ALPHA.SSInit(this);
	B.SSInit(this);
	BETTA.SSInit(this);
	C.SSInit(this);
	T_RAD.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int PAR_module::SetupEvents() {
	TImportCommand* P1_C_LATDEG_import = (TImportCommand*) P1_C_LATDEG.GetCommand("P1_C_LATDEG_import",TCommand::kUndefined,TCommand::kImport);
	P1_C_LATDEG_import->Code() = "Import P1_C_LATDEG from GLOBALS_module";
	P1_C_LATDEG_import->AddDependency(P1_C_LATDEG);
	P1_C_LATDEG_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CLOUDY_import = (TImportCommand*) CLOUDY.GetCommand("CLOUDY_import",TCommand::kUndefined,TCommand::kImport);
	CLOUDY_import->Code() = "Import CLOUDY from GLOBALS_module";
	CLOUDY_import->AddDependency(CLOUDY);
	CLOUDY_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DAYJUL_import = (TImportCommand*) DAYJUL.GetCommand("DAYJUL_import",TCommand::kUndefined,TCommand::kImport);
	DAYJUL_import->Code() = "Import DAYJUL from GLOBALS_module";
	DAYJUL_import->AddDependency(DAYJUL);
	DAYJUL_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u6 = (TExecuteCommand*) SOLRADGRD.GetCommand("u6",TCommand::kUpdate,TCommand::kCode);
	u6->SetExecutable(&SOLRADGRD_u6_exe_g);
	u6->Code() = "u6 <- ( ( SOLRADATM*( BETTA-( 0.0326*CLOUDY ) ) )-ALPHA )";
	u6->AddDependency(SOLRADATM);
	u6->AddDependency(BETTA);
	u6->AddDependency(CLOUDY);
	u6->AddDependency(ALPHA);
	u6->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u5 = (TExecuteCommand*) SOLRADATM.GetCommand("u5",TCommand::kUpdate,TCommand::kCode);
	u5->SetExecutable(&SOLRADATM_u5_exe_g);
	u5->Code() = "u5 <- ( ( A+( B*SL::Cos(T_RAD) ) )+( C*pow((double)SL::Sin(T_RAD),(double)((float)2) ) ) )";
	u5->AddDependency(A);
	u5->AddDependency(B);
	u5->AddDependency(T_RAD);
	u5->AddDependency(C);
	u5->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u0 = (TExecuteCommand*) A.GetCommand("u0",TCommand::kUpdate,TCommand::kCode);
	u0->SetExecutable(&A_u0_exe_g);
	u0->Code() = "u0 <- ( ((float)942)-( 6.68*P1_C_LATDEG ) )";
	u0->AddDependency(P1_C_LATDEG);
	u0->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u1 = (TExecuteCommand*) ALPHA.GetCommand("u1",TCommand::kUpdate,TCommand::kCode);
	u1->SetExecutable(&ALPHA_u1_exe_g);
	u1->Code() = "u1 <- ( 32.9835-( 64.884*( ((float)1)-( 1.3614*SL::Cos(( ( ( SL::Int(P1_C_LATDEG)+( ( P1_C_LATDEG-SL::Int(P1_C_LATDEG) )*1.16666667 ) )*3.141590 )/180 )) ) ) ) )";
	u1->AddDependency(P1_C_LATDEG);
	u1->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u2 = (TExecuteCommand*) B.GetCommand("u2",TCommand::kUpdate,TCommand::kCode);
	u2->SetExecutable(&B_u2_exe_g);
	u2->Code() = "u2 <- ( ((float)147)*pow((double)( P1_C_LATDEG-17.48 ),(double)0.27 ) )";
	u2->AddDependency(P1_C_LATDEG);
	u2->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u3 = (TExecuteCommand*) BETTA.GetCommand("u3",TCommand::kUpdate,TCommand::kCode);
	u3->SetExecutable(&BETTA_u3_exe_g);
	u3->Code() = "u3 <- ( 0.715-( 0.3183*( ((float)1)-( 1.3614*SL::Cos(( ( ( SL::Int(P1_C_LATDEG)+( ( P1_C_LATDEG-SL::Int(P1_C_LATDEG) )*1.16666667 ) )*3.141590 )/180 )) ) ) ) )";
	u3->AddDependency(P1_C_LATDEG);
	u3->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u4 = (TExecuteCommand*) C.GetCommand("u4",TCommand::kUpdate,TCommand::kCode);
	u4->SetExecutable(&C_u4_exe_g);
	u4->Code() = "u4 <- ( ((float)175)-( 3.6*P1_C_LATDEG ) )";
	u4->AddDependency(P1_C_LATDEG);
	u4->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u7 = (TExecuteCommand*) T_RAD.GetCommand("u7",TCommand::kUpdate,TCommand::kCode);
	u7->SetExecutable(&T_RAD_u7_exe_g);
	u7->Code() = "u7 <- ( ( ( ((float)2)/365 )*3.141590 )*( DAYJUL-((float)173) ) )";
	u7->AddDependency(DAYJUL);
	u7->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int PAR_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int PAR_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int PAR_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int PAR_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class XXXIMPORTS6_module 
// ---------------------------------------------------------------------------
XXXIMPORTS6_module::XXXIMPORTS6_module(char* name) :
	TIME("TIME"),
	DAYJUL("DAYJUL"),
	P1_C_LATDEG("P1_C_LATDEG"),
	CLOUDY("CLOUDY"),
	TModule(name) {

}	
int XXXIMPORTS6_module::DAYJUL_u8_exe() {
	float value;

	switch( DAYJUL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DAYJUL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SL::Mod(( TIME.Value()-dT() ), ((float)365))+((float)1) );
			DAYJUL.Update( p, value );
		}
		DAYJUL.GrabMemory();
		if( DAYJUL.GetF(FLinkEdges) ) { DAYJUL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SL::Mod(( TIME.Value()-dT() ), ((float)365))+((float)1) );
			DAYJUL.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS6_module::P1_C_LATDEG_u9_exe() {
	float value;

	switch( P1_C_LATDEG.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_LATDEG.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  39.0;
			P1_C_LATDEG.Update( p, P1_C_LATDEG.ParameterValue(value,p) );
		}
		P1_C_LATDEG.GrabMemory();
		if( P1_C_LATDEG.GetF(FLinkEdges) ) { P1_C_LATDEG.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  39.0;
			P1_C_LATDEG.Update( P1_C_LATDEG.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS6_module::CLOUDY_u10_exe() {
	float value;

	switch( CLOUDY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CLOUDY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph0(DAYJUL.Value(p));
			CLOUDY.Update( p, value );
		}
		CLOUDY.GrabMemory();
		if( CLOUDY.GetF(FLinkEdges) ) { CLOUDY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph0(DAYJUL.Value());
			CLOUDY.Update( value );
	  } break;
	}
	return 0;
}

XXXIMPORTS6_module* XXXIMPORTS6_module::fInstance = NULL;
XXXIMPORTS6_module* XXXIMPORTS6_module::kNullModel = (XXXIMPORTS6_module*)0x1;
int XXXIMPORTS6_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int XXXIMPORTS6_module::InitVars() {
	
	TIME.SSInit(this);
	DAYJUL.SSInit(this);
	P1_C_LATDEG.SSInit(this);
	CLOUDY.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int XXXIMPORTS6_module::SetupEvents() {
	TExecuteCommand* u8 = (TExecuteCommand*) DAYJUL.GetCommand("u8",TCommand::kUpdate,TCommand::kCode);
	u8->SetExecutable(&DAYJUL_u8_exe_g);
	u8->Code() = "u8 <- ( SL::Mod(( TIME-dT() ), ((float)365))+((float)1) )";
	u8->AddDependency(TIME);
	u8->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u9 = (TExecuteCommand*) P1_C_LATDEG.GetCommand("u9",TCommand::kUpdate,TCommand::kCode);
	u9->SetExecutable(&P1_C_LATDEG_u9_exe_g);
	u9->Code() = "u9 <- 39.0";
	u9->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u10 = (TExecuteCommand*) CLOUDY.GetCommand("u10",TCommand::kUpdate,TCommand::kCode);
	u10->SetExecutable(&CLOUDY_u10_exe_g);
	u10->Code() = "u10 <- Graph0(DAYJUL)";
	u10->AddDependency(DAYJUL);
	u10->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int XXXIMPORTS6_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int XXXIMPORTS6_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int XXXIMPORTS6_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int XXXIMPORTS6_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class MACROPHYTES_module 
// ---------------------------------------------------------------------------
MACROPHYTES_module::MACROPHYTES_module(char* name) :
	TIME("TIME"),
	AIR_TEMP_C("AIR_TEMP_C"),
	HABITATMAP("HABITATMAP"),
	DAYJUL("DAYJUL"),
	DAYLENGTH("DAYLENGTH"),
	SOLRADGR("SOLRADGR"),
	DIN_AVAILABLE("DIN_AVAILABLE"),
	ELEVATION("ELEVATION"),
	SURFACE_WATER("SURFACE_WATER"),
	UW_DEPTH("UW_DEPTH"),
	WATER_AVAIL("WATER_AVAIL"),
	MACLAI("MACLAI"),
	ROOT_DEPTH("ROOT_DEPTH"),
	MACH("MACH"),
	PHBIO_MORT("PHBIO_MORT"),
	PHBIO_HARVEST("PHBIO_HARVEST"),
	NPHBIO_MORT("NPHBIO_MORT"),
	NPHBIO_HARVEST("NPHBIO_HARVEST"),
	PHBIO_NPP("PHBIO_NPP"),
	YIELD("YIELD"),
	TOT_NPP("TOT_NPP"),
	BIO_TIME("BIO_TIME"),
	CF_AIR_TEMP("CF_AIR_TEMP"),
	MAC_NPH_BIOMAS("MAC_NPH_BIOMAS"),
	NPHBIO_PLANTING("NPHBIO_PLANTING"),
	TRANSDOWN("TRANSDOWN"),
	TRANSUP("TRANSUP"),
	MAC_PH_BIOMAS("MAC_PH_BIOMAS"),
	PHBIO_PLANT("PHBIO_PLANT"),
	PH_MAX("PH_MAX"),
	PH_IN("PH_IN"),
	PH_OUT("PH_OUT"),
	NPP_IN("NPP_IN"),
	HARVEST("HARVEST"),
	INI_YIELD("INI_YIELD"),
	DAY_LENGTH_PREV("DAY_LENGTH_PREV"),
	FALL_LITTER("FALL_LITTER"),
	FALL_LITTER_CALC("FALL_LITTER_CALC"),
	HARVEST_TIME("HARVEST_TIME"),
	IC_NPHBIO("IC_NPHBIO"),
	IC_PHBIO("IC_PHBIO"),
	LIGHT_CF("LIGHT_CF"),
	MAC_LAI_R("MAC_LAI_R"),
	MAC_PROD_CF("MAC_PROD_CF"),
	MAX_BM("MAX_BM"),
	MAX_NPH("MAX_NPH"),
	MAX_PH("MAX_PH"),
	NPH_AB_BM("NPH_AB_BM"),
	NUTR_CF("NUTR_CF"),
	PHBIO_MORT_WATER("PHBIO_MORT_WATER"),
	PHBIO_NPP_CALC("PHBIO_NPP_CALC"),
	PH_TO_ABBM("PH_TO_ABBM"),
	PLANTIME("PLANTIME"),
	PLANTING("PLANTING"),
	PO4SD_CONCTOT("PO4SD_CONCTOT"),
	REMOVAL_TIME("REMOVAL_TIME"),
	ROOT_BM("ROOT_BM"),
	SPROUTING("SPROUTING"),
	TEMP_CF("TEMP_CF"),
	TOTAL_BIOM("TOTAL_BIOM"),
	TRANSDOWN_RT("TRANSDOWN_RT"),
	WATER_CF("WATER_CF"),
	WAT_STRESS_HIGH("WAT_STRESS_HIGH"),
	WAT_STRESS_LOW("WAT_STRESS_LOW"),
	P1_BIO_END("P1_BIO_END"),
	P1_BIO_REPRO("P1_BIO_REPRO"),
	P1_BIO_START("P1_BIO_START"),
	P1_DAYLENG_RQ("P1_DAYLENG_RQ"),
	P1_EST_HEIGHT("P1_EST_HEIGHT"),
	P1_H_DAY("P1_H_DAY"),
	P1_LIGHTSAT("P1_LIGHTSAT"),
	P1_MAC_KS_N("P1_MAC_KS_N"),
	P1_MAC_KS_P("P1_MAC_KS_P"),
	P1_MAX_AB_BM("P1_MAX_AB_BM"),
	P1_MAX_DENS("P1_MAX_DENS"),
	P1_MAX_HT_BM("P1_MAX_HT_BM"),
	P1_MAX_LAI("P1_MAX_LAI"),
	P1_MAX_PH_ABBM("P1_MAX_PH_ABBM"),
	P1_NPH_ABBM_IC("P1_NPH_ABBM_IC"),
	P1_NPH_AB_BEL("P1_NPH_AB_BEL"),
	P1_NPH_MORT("P1_NPH_MORT"),
	P1_NPH_PR_H("P1_NPH_PR_H"),
	P1_NPP("P1_NPP"),
	P1_PHB_C_REC("P1_PHB_C_REC"),
	P1_PHB_EVGRN("P1_PHB_EVGRN"),
	P1_PHB_L_RT("P1_PHB_L_RT"),
	P1_PHB_MORT("P1_PHB_MORT"),
	P1_PHB_PR_H("P1_PHB_PR_H"),
	P1_PH_TO_REP("P1_PH_TO_REP"),
	P1_PROP_LA_TO_B("P1_PROP_LA_TO_B"),
	P1_P_DAY("P1_P_DAY"),
	P1_P_RATIO("P1_P_RATIO"),
	P1_P_WT("P1_P_WT"),
	P1_ROOT_DENS("P1_ROOT_DENS"),
	P1_SPR_RATE("P1_SPR_RATE"),
	P1_TEMPOPT("P1_TEMPOPT"),
	P1_W_T_MAX("P1_W_T_MAX"),
	P1_W_T_MIN("P1_W_T_MIN"),
	TModule(name) {

	AIR_TEMP_C.SetF(FisImport,True,"CG");
	HABITATMAP.SetF(FisImport,True,"CG");
	DAYJUL.SetF(FisImport,True,"CG");
	DAYLENGTH.SetF(FisImport,True,"CG");
	SOLRADGR.SetF(FisImport,True,"CG");
	DIN_AVAILABLE.SetF(FisImport,True,"CG");
	ELEVATION.SetF(FisImport,True,"CG");
	SURFACE_WATER.SetF(FisImport,True,"CG");
	UW_DEPTH.SetF(FisImport,True,"CG");
	WATER_AVAIL.SetF(FisImport,True,"CG");
	MACLAI.SetF(FisExport,True,"CG");
	ROOT_DEPTH.SetF(FisExport,True,"CG");
	MACH.SetF(FisExport,True,"CG");
	PHBIO_MORT.SetF(FisExport,True,"CG");
	PHBIO_HARVEST.SetF(FisExport,True,"CG");
	NPHBIO_MORT.SetF(FisExport,True,"CG");
	NPHBIO_HARVEST.SetF(FisExport,True,"CG");
	PHBIO_NPP.SetF(FisExport,True,"CG");
	YIELD.SetF(FisExport,True,"CG");
	TOT_NPP.SetF(FisExport,True,"CG");
}	
int MACROPHYTES_module::BIO_TIME_I11_exe() {
	float value;

	BIO_TIME.UpdateIntegrator(0);
	switch( BIO_TIME.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = BIO_TIME.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  CF_AIR_TEMP.Value(p);
			BIO_TIME.Update( p, value, dT() );
		}
		BIO_TIME.GrabMemory();
		if( BIO_TIME.GetF(FLinkEdges) ) { BIO_TIME.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  CF_AIR_TEMP.Value();
			BIO_TIME.Update( value, dT() );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::BIO_TIME_i12_exe() {
	float value;

	BIO_TIME.UpdateIntegrator(1);
	switch( BIO_TIME.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = BIO_TIME.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			BIO_TIME.InitValue( p, value );
		}
		BIO_TIME.GrabMemory();
		if( BIO_TIME.GetF(FLinkEdges) ) { BIO_TIME.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			BIO_TIME.InitValue( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::CF_AIR_TEMP_u13_exe() {
	float value;

	switch( CF_AIR_TEMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CF_AIR_TEMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( PLANTIME.Value(p) == ((float)1) ) ) ? ( ( -BIO_TIME.Value(p)/dT() ) ) : (  ( ( ( AIR_TEMP_C.Value(p) >  ((float)5) ) ) ? ( AIR_TEMP_C.Value(p) ) : ( ((float)0) ) )  ) ) ;
			CF_AIR_TEMP.Update( p, value );
		}
		CF_AIR_TEMP.GrabMemory();
		if( CF_AIR_TEMP.GetF(FICFlux) ) CF_AIR_TEMP.Cov().Set(0.0); 
		if( CF_AIR_TEMP.GetF(FLinkEdges) ) { CF_AIR_TEMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( PLANTIME.Value() == ((float)1) ) ) ? ( ( -BIO_TIME.Value()/dT() ) ) : (  ( ( ( AIR_TEMP_C.Value() >  ((float)5) ) ) ? ( AIR_TEMP_C.Value() ) : ( ((float)0) ) )  ) ) ;
			CF_AIR_TEMP.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAC_NPH_BIOMAS_I14_exe() {
	float value;

	MAC_NPH_BIOMAS.UpdateIntegrator(0);
	switch( MAC_NPH_BIOMAS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAC_NPH_BIOMAS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( NPHBIO_PLANTING.Value(p)+TRANSDOWN.Value(p) )-NPHBIO_MORT.Value(p) )-TRANSUP.Value(p) )-NPHBIO_HARVEST.Value(p) );
			MAC_NPH_BIOMAS.Update( p, value, dT() );
		}
		MAC_NPH_BIOMAS.GrabMemory();
		if( MAC_NPH_BIOMAS.GetF(FLinkEdges) ) { MAC_NPH_BIOMAS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( NPHBIO_PLANTING.Value()+TRANSDOWN.Value() )-NPHBIO_MORT.Value() )-TRANSUP.Value() )-NPHBIO_HARVEST.Value() );
			MAC_NPH_BIOMAS.Update( value, dT() );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAC_NPH_BIOMAS_i15_exe() {
	float value;

	MAC_NPH_BIOMAS.UpdateIntegrator(1);
	switch( MAC_NPH_BIOMAS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAC_NPH_BIOMAS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  IC_NPHBIO.Value(p);
			MAC_NPH_BIOMAS.InitValue( p, value );
		}
		MAC_NPH_BIOMAS.GrabMemory();
		if( MAC_NPH_BIOMAS.GetF(FLinkEdges) ) { MAC_NPH_BIOMAS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  IC_NPHBIO.Value();
			MAC_NPH_BIOMAS.InitValue( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::NPHBIO_PLANTING_u16_exe() {
	float value;

	switch( NPHBIO_PLANTING.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NPHBIO_PLANTING.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PLANTING.Value(p)*( ((float)1)-P1_P_RATIO.Value(p) ) );
			NPHBIO_PLANTING.Update( p, value );
		}
		NPHBIO_PLANTING.GrabMemory();
		if( NPHBIO_PLANTING.GetF(FICFlux) ) NPHBIO_PLANTING.Cov().Set(0.0); 
		if( NPHBIO_PLANTING.GetF(FLinkEdges) ) { NPHBIO_PLANTING.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PLANTING.Value()*( ((float)1)-P1_P_RATIO.Value() ) );
			NPHBIO_PLANTING.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::TRANSDOWN_u17_exe() {
	float value;

	switch( TRANSDOWN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TRANSDOWN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( HARVEST_TIME.Value(p) >  ((float)0) ) ) ? ( ((float)0) ) : ( ( ( TRANSDOWN_RT.Value(p)*( PHBIO_NPP.Value(p)+( P1_PH_TO_REP.Value(p)*MAC_PH_BIOMAS.Value(p) ) ) )+( P1_PHB_C_REC.Value(p)*FALL_LITTER.Value(p) ) ) ) ) ;
			TRANSDOWN.Update( p, value );
		}
		TRANSDOWN.GrabMemory();
		if( TRANSDOWN.GetF(FICFlux) ) TRANSDOWN.Cov().Set(0.0); 
		if( TRANSDOWN.GetF(FLinkEdges) ) { TRANSDOWN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( HARVEST_TIME.Value() >  ((float)0) ) ) ? ( ((float)0) ) : ( ( ( TRANSDOWN_RT.Value()*( PHBIO_NPP.Value()+( P1_PH_TO_REP.Value()*MAC_PH_BIOMAS.Value() ) ) )+( P1_PHB_C_REC.Value()*FALL_LITTER.Value() ) ) ) ) ;
			TRANSDOWN.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::NPHBIO_MORT_u18_exe() {
	float value;

	switch( NPHBIO_MORT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NPHBIO_MORT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( MAC_NPH_BIOMAS.Value(p)*P1_NPH_MORT.Value(p) )+( ( HARVEST_TIME.Delay(  p, dT() )*MAC_NPH_BIOMAS.Value(p) )/dT() ) );
			NPHBIO_MORT.Update( p, value );
		}
		NPHBIO_MORT.GrabMemory();
		if( NPHBIO_MORT.GetF(FICFlux) ) NPHBIO_MORT.Cov().Set(0.0); 
		if( NPHBIO_MORT.GetF(FLinkEdges) ) { NPHBIO_MORT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( MAC_NPH_BIOMAS.Value()*P1_NPH_MORT.Value() )+( ( HARVEST_TIME.Delay( dT() )*MAC_NPH_BIOMAS.Value() )/dT() ) );
			NPHBIO_MORT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::TRANSUP_u19_exe() {
	float value;

	switch( TRANSUP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TRANSUP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SPROUTING.Value(p)*P1_SPR_RATE.Value(p) )*MAC_NPH_BIOMAS.Value(p) );
			TRANSUP.Update( p, value );
		}
		TRANSUP.GrabMemory();
		if( TRANSUP.GetF(FICFlux) ) TRANSUP.Cov().Set(0.0); 
		if( TRANSUP.GetF(FLinkEdges) ) { TRANSUP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SPROUTING.Value()*P1_SPR_RATE.Value() )*MAC_NPH_BIOMAS.Value() );
			TRANSUP.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::NPHBIO_HARVEST_u20_exe() {
	float value;

	switch( NPHBIO_HARVEST.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NPHBIO_HARVEST.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( HARVEST_TIME.Value(p)*P1_NPH_PR_H.Value(p) )*MAC_NPH_BIOMAS.Value(p) )/dT() );
			NPHBIO_HARVEST.Update( p, value );
		}
		NPHBIO_HARVEST.GrabMemory();
		if( NPHBIO_HARVEST.GetF(FICFlux) ) NPHBIO_HARVEST.Cov().Set(0.0); 
		if( NPHBIO_HARVEST.GetF(FLinkEdges) ) { NPHBIO_HARVEST.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( HARVEST_TIME.Value()*P1_NPH_PR_H.Value() )*MAC_NPH_BIOMAS.Value() )/dT() );
			NPHBIO_HARVEST.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAC_PH_BIOMAS_I21_exe() {
	float value;

	MAC_PH_BIOMAS.UpdateIntegrator(0);
	switch( MAC_PH_BIOMAS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAC_PH_BIOMAS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( PHBIO_NPP.Value(p)+PHBIO_PLANT.Value(p) )+TRANSUP.Value(p) )-PHBIO_MORT.Value(p) )-PHBIO_HARVEST.Value(p) )-TRANSDOWN.Value(p) );
			MAC_PH_BIOMAS.Update( p, value, dT() );
		}
		MAC_PH_BIOMAS.GrabMemory();
		if( MAC_PH_BIOMAS.GetF(FLinkEdges) ) { MAC_PH_BIOMAS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( PHBIO_NPP.Value()+PHBIO_PLANT.Value() )+TRANSUP.Value() )-PHBIO_MORT.Value() )-PHBIO_HARVEST.Value() )-TRANSDOWN.Value() );
			MAC_PH_BIOMAS.Update( value, dT() );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAC_PH_BIOMAS_i22_exe() {
	float value;

	MAC_PH_BIOMAS.UpdateIntegrator(1);
	switch( MAC_PH_BIOMAS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAC_PH_BIOMAS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  IC_PHBIO.Value(p);
			MAC_PH_BIOMAS.InitValue( p, value );
		}
		MAC_PH_BIOMAS.GrabMemory();
		if( MAC_PH_BIOMAS.GetF(FLinkEdges) ) { MAC_PH_BIOMAS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  IC_PHBIO.Value();
			MAC_PH_BIOMAS.InitValue( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PHBIO_NPP_u23_exe() {
	float value;

	switch( PHBIO_NPP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_NPP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( HARVEST_TIME.Value(p) >  ((float)0) ) ) ? ( ((float)0) ) : ( PHBIO_NPP_CALC.Value(p) ) ) ;
			PHBIO_NPP.Update( p, value );
		}
		PHBIO_NPP.GrabMemory();
		if( PHBIO_NPP.GetF(FICFlux) ) PHBIO_NPP.Cov().Set(0.0); 
		if( PHBIO_NPP.GetF(FLinkEdges) ) { PHBIO_NPP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( HARVEST_TIME.Value() >  ((float)0) ) ) ? ( ((float)0) ) : ( PHBIO_NPP_CALC.Value() ) ) ;
			PHBIO_NPP.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PHBIO_PLANT_u24_exe() {
	float value;

	switch( PHBIO_PLANT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_PLANT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PLANTING.Value(p)*P1_P_RATIO.Value(p) );
			PHBIO_PLANT.Update( p, value );
		}
		PHBIO_PLANT.GrabMemory();
		if( PHBIO_PLANT.GetF(FICFlux) ) PHBIO_PLANT.Cov().Set(0.0); 
		if( PHBIO_PLANT.GetF(FLinkEdges) ) { PHBIO_PLANT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PLANTING.Value()*P1_P_RATIO.Value() );
			PHBIO_PLANT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PHBIO_MORT_u25_exe() {
	float value;

	switch( PHBIO_MORT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_MORT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( HARVEST_TIME.Delay(  p, dT() )*MAC_PH_BIOMAS.Value(p) )/dT() )+( FALL_LITTER.Value(p)*( ((float)1)-P1_PHB_C_REC.Value(p) ) ) )+( MAC_PH_BIOMAS.Value(p)*( PHBIO_MORT_WATER.Value(p)+P1_PHB_MORT.Value(p) ) ) );
			PHBIO_MORT.Update( p, value );
		}
		PHBIO_MORT.GrabMemory();
		if( PHBIO_MORT.GetF(FICFlux) ) PHBIO_MORT.Cov().Set(0.0); 
		if( PHBIO_MORT.GetF(FLinkEdges) ) { PHBIO_MORT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( HARVEST_TIME.Delay( dT() )*MAC_PH_BIOMAS.Value() )/dT() )+( FALL_LITTER.Value()*( ((float)1)-P1_PHB_C_REC.Value() ) ) )+( MAC_PH_BIOMAS.Value()*( PHBIO_MORT_WATER.Value()+P1_PHB_MORT.Value() ) ) );
			PHBIO_MORT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PHBIO_HARVEST_u26_exe() {
	float value;

	switch( PHBIO_HARVEST.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_HARVEST.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( HARVEST_TIME.Value(p)+REMOVAL_TIME.Value(p) )*P1_PHB_PR_H.Value(p) )*MAC_PH_BIOMAS.Value(p) )/dT() );
			PHBIO_HARVEST.Update( p, value );
		}
		PHBIO_HARVEST.GrabMemory();
		if( PHBIO_HARVEST.GetF(FICFlux) ) PHBIO_HARVEST.Cov().Set(0.0); 
		if( PHBIO_HARVEST.GetF(FLinkEdges) ) { PHBIO_HARVEST.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( HARVEST_TIME.Value()+REMOVAL_TIME.Value() )*P1_PHB_PR_H.Value() )*MAC_PH_BIOMAS.Value() )/dT() );
			PHBIO_HARVEST.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PH_MAX_I27_exe() {
	float value;

	PH_MAX.UpdateIntegrator(0);
	switch( PH_MAX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PH_MAX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PH_IN.Value(p)-PH_OUT.Value(p) );
			PH_MAX.Update( p, value, dT() );
		}
		PH_MAX.GrabMemory();
		if( PH_MAX.GetF(FLinkEdges) ) { PH_MAX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PH_IN.Value()-PH_OUT.Value() );
			PH_MAX.Update( value, dT() );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PH_MAX_i28_exe() {
	float value;

	PH_MAX.UpdateIntegrator(1);
	switch( PH_MAX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PH_MAX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			PH_MAX.InitValue( p, value );
		}
		PH_MAX.GrabMemory();
		if( PH_MAX.GetF(FLinkEdges) ) { PH_MAX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			PH_MAX.InitValue( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PH_IN_u29_exe() {
	float value;

	switch( PH_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PH_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( MAC_PH_BIOMAS.Value(p) >  PH_MAX.Value(p) ) ) ? ( ( MAC_PH_BIOMAS.Value(p)/dT() ) ) : ( ((float)0) ) ) ;
			PH_IN.Update( p, value );
		}
		PH_IN.GrabMemory();
		if( PH_IN.GetF(FICFlux) ) PH_IN.Cov().Set(0.0); 
		if( PH_IN.GetF(FLinkEdges) ) { PH_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( MAC_PH_BIOMAS.Value() >  PH_MAX.Value() ) ) ? ( ( MAC_PH_BIOMAS.Value()/dT() ) ) : ( ((float)0) ) ) ;
			PH_IN.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PH_OUT_u30_exe() {
	float value;

	switch( PH_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PH_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( MAC_PH_BIOMAS.Value(p) >  PH_MAX.Value(p) ) || ( PLANTIME.Value(p) == ((float)1) ) ) ) ? ( ( PH_MAX.Value(p)/dT() ) ) : ( ((float)0) ) ) ;
			PH_OUT.Update( p, value );
		}
		PH_OUT.GrabMemory();
		if( PH_OUT.GetF(FICFlux) ) PH_OUT.Cov().Set(0.0); 
		if( PH_OUT.GetF(FLinkEdges) ) { PH_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( MAC_PH_BIOMAS.Value() >  PH_MAX.Value() ) || ( PLANTIME.Value() == ((float)1) ) ) ) ? ( ( PH_MAX.Value()/dT() ) ) : ( ((float)0) ) ) ;
			PH_OUT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::TOT_NPP_I31_exe() {
	float value;

	TOT_NPP.UpdateIntegrator(0);
	switch( TOT_NPP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOT_NPP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  NPP_IN.Value(p);
			TOT_NPP.Update( p, value, dT() );
		}
		TOT_NPP.GrabMemory();
		if( TOT_NPP.GetF(FLinkEdges) ) { TOT_NPP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  NPP_IN.Value();
			TOT_NPP.Update( value, dT() );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::TOT_NPP_i32_exe() {
	float value;

	TOT_NPP.UpdateIntegrator(1);
	switch( TOT_NPP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOT_NPP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			TOT_NPP.InitValue( p, value );
		}
		TOT_NPP.GrabMemory();
		if( TOT_NPP.GetF(FLinkEdges) ) { TOT_NPP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			TOT_NPP.InitValue( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::NPP_IN_u33_exe() {
	float value;

	switch( NPP_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NPP_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( HABITATMAP.Value(p) == ((float)2) ) ) ? ( PHBIO_NPP.Value(p) ) : ( ((float)0) ) ) ;
			NPP_IN.Update( p, value );
		}
		NPP_IN.GrabMemory();
		if( NPP_IN.GetF(FICFlux) ) NPP_IN.Cov().Set(0.0); 
		if( NPP_IN.GetF(FLinkEdges) ) { NPP_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( HABITATMAP.Value() == ((float)2) ) ) ? ( PHBIO_NPP.Value() ) : ( ((float)0) ) ) ;
			NPP_IN.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::YIELD_I34_exe() {
	float value;

	YIELD.UpdateIntegrator(0);
	switch( YIELD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = YIELD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( HARVEST.Value(p)-INI_YIELD.Value(p) );
			YIELD.Update( p, value, dT() );
		}
		YIELD.GrabMemory();
		if( YIELD.GetF(FLinkEdges) ) { YIELD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( HARVEST.Value()-INI_YIELD.Value() );
			YIELD.Update( value, dT() );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::YIELD_i35_exe() {
	float value;

	YIELD.UpdateIntegrator(1);
	switch( YIELD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = YIELD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			YIELD.InitValue( p, value );
		}
		YIELD.GrabMemory();
		if( YIELD.GetF(FLinkEdges) ) { YIELD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			YIELD.InitValue( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::HARVEST_u36_exe() {
	float value;

	switch( HARVEST.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HARVEST.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PHBIO_HARVEST.Value(p)+NPHBIO_HARVEST.Value(p) );
			HARVEST.Update( p, value );
		}
		HARVEST.GrabMemory();
		if( HARVEST.GetF(FICFlux) ) HARVEST.Cov().Set(0.0); 
		if( HARVEST.GetF(FLinkEdges) ) { HARVEST.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PHBIO_HARVEST.Value()+NPHBIO_HARVEST.Value() );
			HARVEST.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::INI_YIELD_u37_exe() {
	float value;

	switch( INI_YIELD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = INI_YIELD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( DAYJUL.Value(p) == ((float)1) ) ) ? ( ( ( YIELD.Value(p)/dT() )*((float)0) ) ) : ( ((float)0) ) ) ;
			INI_YIELD.Update( p, value );
		}
		INI_YIELD.GrabMemory();
		if( INI_YIELD.GetF(FICFlux) ) INI_YIELD.Cov().Set(0.0); 
		if( INI_YIELD.GetF(FLinkEdges) ) { INI_YIELD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( DAYJUL.Value() == ((float)1) ) ) ? ( ( ( YIELD.Value()/dT() )*((float)0) ) ) : ( ((float)0) ) ) ;
			INI_YIELD.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::DAY_LENGTH_PREV_u38_exe() {
	float value;

	switch( DAY_LENGTH_PREV.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DAY_LENGTH_PREV.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  DAYLENGTH.Delay(  p, ((float)1) );
			DAY_LENGTH_PREV.Update( p, value );
		}
		DAY_LENGTH_PREV.GrabMemory();
		if( DAY_LENGTH_PREV.GetF(FLinkEdges) ) { DAY_LENGTH_PREV.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  DAYLENGTH.Delay( ((float)1) );
			DAY_LENGTH_PREV.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::FALL_LITTER_u39_exe() {
	float value;

	switch( FALL_LITTER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FALL_LITTER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(FALL_LITTER_CALC.Value(p), SL::Max(((float)0), ( MAC_PH_BIOMAS.Value(p)-( ( P1_PHB_EVGRN.Value(p)*PH_MAX.Value(p) )/( ((float)1)+P1_PHB_EVGRN.Value(p) ) ) )));
			FALL_LITTER.Update( p, value );
		}
		FALL_LITTER.GrabMemory();
		if( FALL_LITTER.GetF(FLinkEdges) ) { FALL_LITTER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(FALL_LITTER_CALC.Value(), SL::Max(((float)0), ( MAC_PH_BIOMAS.Value()-( ( P1_PHB_EVGRN.Value()*PH_MAX.Value() )/( ((float)1)+P1_PHB_EVGRN.Value() ) ) )));
			FALL_LITTER.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::FALL_LITTER_CALC_u40_exe() {
	float value;

	switch( FALL_LITTER_CALC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FALL_LITTER_CALC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( DAYLENGTH.Value(p) >  P1_DAYLENG_RQ.Value(p) ) || ( DAYLENGTH.Value(p) >= DAY_LENGTH_PREV.Value(p) ) ) ) ? ( ((float)0) ) : (  ( ( ( MAC_PH_BIOMAS.Value(p) <  ( 0.01*( ((float)1)-P1_PHB_EVGRN.Value(p) ) ) ) ) ? ( ( ( ( ((float)1)-P1_PHB_EVGRN.Value(p) )*MAC_PH_BIOMAS.Value(p) )/dT() ) ) : ( ( ( ((float)1)-P1_PHB_EVGRN.Value(p) )*pow((double)( ( PH_MAX.Value(p)*P1_PHB_L_RT.Value(p) )/MAC_PH_BIOMAS.Value(p) ),(double)((float)3) ) ) ) )  ) ) ;
			FALL_LITTER_CALC.Update( p, value );
		}
		FALL_LITTER_CALC.GrabMemory();
		if( FALL_LITTER_CALC.GetF(FLinkEdges) ) { FALL_LITTER_CALC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( DAYLENGTH.Value() >  P1_DAYLENG_RQ.Value() ) || ( DAYLENGTH.Value() >= DAY_LENGTH_PREV.Value() ) ) ) ? ( ((float)0) ) : (  ( ( ( MAC_PH_BIOMAS.Value() <  ( 0.01*( ((float)1)-P1_PHB_EVGRN.Value() ) ) ) ) ? ( ( ( ( ((float)1)-P1_PHB_EVGRN.Value() )*MAC_PH_BIOMAS.Value() )/dT() ) ) : ( ( ( ((float)1)-P1_PHB_EVGRN.Value() )*pow((double)( ( PH_MAX.Value()*P1_PHB_L_RT.Value() )/MAC_PH_BIOMAS.Value() ),(double)((float)3) ) ) ) )  ) ) ;
			FALL_LITTER_CALC.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::HARVEST_TIME_u41_exe() {
	float value;

	switch( HARVEST_TIME.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HARVEST_TIME.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( DAYJUL.Value(p) >  P1_H_DAY.Value(p) ) && ( DAYJUL.Value(p) <  ( P1_H_DAY.Value(p)+((float)3) ) ) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			HARVEST_TIME.Update( p, value );
		}
		HARVEST_TIME.GrabMemory();
		HARVEST_TIME.UpdateDelayData();
		if( HARVEST_TIME.GetF(FLinkEdges) ) { HARVEST_TIME.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( DAYJUL.Value() >  P1_H_DAY.Value() ) && ( DAYJUL.Value() <  ( P1_H_DAY.Value()+((float)3) ) ) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			HARVEST_TIME.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::IC_NPHBIO_u42_exe() {
	float value;

	switch( IC_NPHBIO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = IC_NPHBIO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_NPH_ABBM_IC.Value(p)*( P1_NPH_AB_BEL.Value(p)+((float)1) ) )/P1_NPH_AB_BEL.Value(p) );
			IC_NPHBIO.Update( p, value );
		}
		IC_NPHBIO.GrabMemory();
		if( IC_NPHBIO.GetF(FLinkEdges) ) { IC_NPHBIO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_NPH_ABBM_IC.Value()*( P1_NPH_AB_BEL.Value()+((float)1) ) )/P1_NPH_AB_BEL.Value() );
			IC_NPHBIO.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::IC_PHBIO_u43_exe() {
	float value;

	switch( IC_PHBIO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = IC_PHBIO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( P1_PHB_EVGRN.Value(p)*P1_NPH_ABBM_IC.Value(p) )*P1_MAX_PH_ABBM.Value(p) )/( ((float)1)-P1_MAX_PH_ABBM.Value(p) ) );
			IC_PHBIO.Update( p, value );
		}
		IC_PHBIO.GrabMemory();
		if( IC_PHBIO.GetF(FLinkEdges) ) { IC_PHBIO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( P1_PHB_EVGRN.Value()*P1_NPH_ABBM_IC.Value() )*P1_MAX_PH_ABBM.Value() )/( ((float)1)-P1_MAX_PH_ABBM.Value() ) );
			IC_PHBIO.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::LIGHT_CF_u44_exe() {
	float value;

	switch( LIGHT_CF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LIGHT_CF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SOLRADGR.Value(p)/P1_LIGHTSAT.Value(p) )*SL::Exp(( ((float)1)-( SOLRADGR.Value(p)/P1_LIGHTSAT.Value(p) ) )) );
			LIGHT_CF.Update( p, value );
		}
		LIGHT_CF.GrabMemory();
		if( LIGHT_CF.GetF(FLinkEdges) ) { LIGHT_CF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SOLRADGR.Value()/P1_LIGHTSAT.Value() )*SL::Exp(( ((float)1)-( SOLRADGR.Value()/P1_LIGHTSAT.Value() ) )) );
			LIGHT_CF.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MACH_u45_exe() {
	float value;

	switch( MACH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MACH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_MAX_HT_BM.Value(p)*TOTAL_BIOM.Value(p) )/MAX_BM.Value(p) );
			MACH.Update( p, value );
		}
		MACH.GrabMemory();
		if( MACH.GetF(FLinkEdges) ) { MACH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_MAX_HT_BM.Value()*TOTAL_BIOM.Value() )/MAX_BM.Value() );
			MACH.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MACLAI_u46_exe() {
	float value;

	switch( MACLAI.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MACLAI.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(( MAC_PH_BIOMAS.Value(p)*P1_PROP_LA_TO_B.Value(p) ), P1_MAX_LAI.Value(p));
			MACLAI.Update( p, value );
		}
		MACLAI.GrabMemory();
		if( MACLAI.GetF(FLinkEdges) ) { MACLAI.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(( MAC_PH_BIOMAS.Value()*P1_PROP_LA_TO_B.Value() ), P1_MAX_LAI.Value());
			MACLAI.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAC_LAI_R_u47_exe() {
	float value;

	switch( MAC_LAI_R.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAC_LAI_R.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( MACLAI.Value(p)/P1_MAX_LAI.Value(p) );
			MAC_LAI_R.Update( p, value );
		}
		MAC_LAI_R.GrabMemory();
		if( MAC_LAI_R.GetF(FLinkEdges) ) { MAC_LAI_R.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( MACLAI.Value()/P1_MAX_LAI.Value() );
			MAC_LAI_R.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAC_PROD_CF_u48_exe() {
	float value;

	switch( MAC_PROD_CF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAC_PROD_CF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SL::Min(LIGHT_CF.Value(p), TEMP_CF.Value(p))*WATER_CF.Value(p) )*NUTR_CF.Value(p) );
			MAC_PROD_CF.Update( p, value );
		}
		MAC_PROD_CF.GrabMemory();
		if( MAC_PROD_CF.GetF(FLinkEdges) ) { MAC_PROD_CF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SL::Min(LIGHT_CF.Value(), TEMP_CF.Value())*WATER_CF.Value() )*NUTR_CF.Value() );
			MAC_PROD_CF.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAX_BM_u49_exe() {
	float value;

	switch( MAX_BM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAX_BM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( MAX_NPH.Value(p)+MAX_PH.Value(p) );
			MAX_BM.Update( p, value );
		}
		MAX_BM.GrabMemory();
		if( MAX_BM.GetF(FLinkEdges) ) { MAX_BM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( MAX_NPH.Value()+MAX_PH.Value() );
			MAX_BM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAX_NPH_u50_exe() {
	float value;

	switch( MAX_NPH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAX_NPH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_MAX_AB_BM.Value(p)-MAX_PH.Value(p) )*( ((float)1)+( ((float)1)/P1_NPH_AB_BEL.Value(p) ) ) );
			MAX_NPH.Update( p, value );
		}
		MAX_NPH.GrabMemory();
		if( MAX_NPH.GetF(FLinkEdges) ) { MAX_NPH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_MAX_AB_BM.Value()-MAX_PH.Value() )*( ((float)1)+( ((float)1)/P1_NPH_AB_BEL.Value() ) ) );
			MAX_NPH.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAX_PH_u51_exe() {
	float value;

	switch( MAX_PH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAX_PH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_MAX_AB_BM.Value(p)*P1_MAX_PH_ABBM.Value(p) );
			MAX_PH.Update( p, value );
		}
		MAX_PH.GrabMemory();
		if( MAX_PH.GetF(FLinkEdges) ) { MAX_PH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_MAX_AB_BM.Value()*P1_MAX_PH_ABBM.Value() );
			MAX_PH.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::NPH_AB_BM_u52_exe() {
	float value;

	switch( NPH_AB_BM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NPH_AB_BM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_NPH_AB_BEL.Value(p)*ROOT_BM.Value(p) );
			NPH_AB_BM.Update( p, value );
		}
		NPH_AB_BM.GrabMemory();
		if( NPH_AB_BM.GetF(FLinkEdges) ) { NPH_AB_BM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_NPH_AB_BEL.Value()*ROOT_BM.Value() );
			NPH_AB_BM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::NUTR_CF_u53_exe() {
	float value;

	switch( NUTR_CF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NUTR_CF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(( DIN_AVAILABLE.Value(p)/( DIN_AVAILABLE.Value(p)+P1_MAC_KS_N.Value(p) ) ), ( PO4SD_CONCTOT.Value(p)/( PO4SD_CONCTOT.Value(p)+P1_MAC_KS_P.Value(p) ) ));
			NUTR_CF.Update( p, value );
		}
		NUTR_CF.GrabMemory();
		if( NUTR_CF.GetF(FLinkEdges) ) { NUTR_CF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(( DIN_AVAILABLE.Value()/( DIN_AVAILABLE.Value()+P1_MAC_KS_N.Value() ) ), ( PO4SD_CONCTOT.Value()/( PO4SD_CONCTOT.Value()+P1_MAC_KS_P.Value() ) ));
			NUTR_CF.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PHBIO_MORT_WATER_u54_exe() {
	float value;

	switch( PHBIO_MORT_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_MORT_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( 0.1*SL::Max(((float)0), ( ((float)1)-WATER_CF.Value(p) )) );
			PHBIO_MORT_WATER.Update( p, value );
		}
		PHBIO_MORT_WATER.GrabMemory();
		if( PHBIO_MORT_WATER.GetF(FLinkEdges) ) { PHBIO_MORT_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( 0.1*SL::Max(((float)0), ( ((float)1)-WATER_CF.Value() )) );
			PHBIO_MORT_WATER.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PHBIO_NPP_CALC_u55_exe() {
	float value;

	switch( PHBIO_NPP_CALC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_NPP_CALC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( MAC_PH_BIOMAS.Value(p) <  MAX_PH.Value(p) ) ) ? ( ( ( ( MAC_PROD_CF.Value(p)*P1_NPP.Value(p) )*MAC_PH_BIOMAS.Value(p) )*( ((float)1)-( MAC_PH_BIOMAS.Value(p)/MAX_PH.Value(p) ) ) ) ) : ( ((float)0) ) ) ;
			PHBIO_NPP_CALC.Update( p, value );
		}
		PHBIO_NPP_CALC.GrabMemory();
		if( PHBIO_NPP_CALC.GetF(FLinkEdges) ) { PHBIO_NPP_CALC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( MAC_PH_BIOMAS.Value() <  MAX_PH.Value() ) ) ? ( ( ( ( MAC_PROD_CF.Value()*P1_NPP.Value() )*MAC_PH_BIOMAS.Value() )*( ((float)1)-( MAC_PH_BIOMAS.Value()/MAX_PH.Value() ) ) ) ) : ( ((float)0) ) ) ;
			PHBIO_NPP_CALC.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PH_TO_ABBM_u56_exe() {
	float value;

	switch( PH_TO_ABBM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PH_TO_ABBM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( NPH_AB_BM.Value(p) == ((float)0) ) ) ? ( ((float)0) ) : ( ( MAC_PH_BIOMAS.Value(p)/( MAC_PH_BIOMAS.Value(p)+NPH_AB_BM.Value(p) ) ) ) ) ;
			PH_TO_ABBM.Update( p, value );
		}
		PH_TO_ABBM.GrabMemory();
		if( PH_TO_ABBM.GetF(FLinkEdges) ) { PH_TO_ABBM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( NPH_AB_BM.Value() == ((float)0) ) ) ? ( ((float)0) ) : ( ( MAC_PH_BIOMAS.Value()/( MAC_PH_BIOMAS.Value()+NPH_AB_BM.Value() ) ) ) ) ;
			PH_TO_ABBM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PLANTIME_u57_exe() {
	float value;

	switch( PLANTIME.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PLANTIME.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( DAYJUL.Value(p) == P1_P_DAY.Value(p) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			PLANTIME.Update( p, value );
		}
		PLANTIME.GrabMemory();
		if( PLANTIME.GetF(FLinkEdges) ) { PLANTIME.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( DAYJUL.Value() == P1_P_DAY.Value() ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			PLANTIME.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PLANTING_u58_exe() {
	float value;

	switch( PLANTING.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PLANTING.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( PLANTIME.Value(p)*P1_MAX_DENS.Value(p) )*P1_P_WT.Value(p) );
			PLANTING.Update( p, value );
		}
		PLANTING.GrabMemory();
		if( PLANTING.GetF(FLinkEdges) ) { PLANTING.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( PLANTIME.Value()*P1_MAX_DENS.Value() )*P1_P_WT.Value() );
			PLANTING.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PO4SD_CONCTOT_u59_exe() {
	float value;

	switch( PO4SD_CONCTOT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4SD_CONCTOT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1000;
			PO4SD_CONCTOT.Update( p, PO4SD_CONCTOT.ParameterValue(value,p) );
		}
		PO4SD_CONCTOT.GrabMemory();
		if( PO4SD_CONCTOT.GetF(FLinkEdges) ) { PO4SD_CONCTOT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1000;
			PO4SD_CONCTOT.Update( PO4SD_CONCTOT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::REMOVAL_TIME_u60_exe() {
	float value;

	switch( REMOVAL_TIME.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = REMOVAL_TIME.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( MACH.Value(p)*P1_PHB_PR_H.Value(p) ) >  P1_EST_HEIGHT.Value(p) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			REMOVAL_TIME.Update( p, value );
		}
		REMOVAL_TIME.GrabMemory();
		if( REMOVAL_TIME.GetF(FLinkEdges) ) { REMOVAL_TIME.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( MACH.Value()*P1_PHB_PR_H.Value() ) >  P1_EST_HEIGHT.Value() ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			REMOVAL_TIME.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::ROOT_BM_u61_exe() {
	float value;

	switch( ROOT_BM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ROOT_BM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( MAC_NPH_BIOMAS.Value(p)/( P1_NPH_AB_BEL.Value(p)+((float)1) ) );
			ROOT_BM.Update( p, value );
		}
		ROOT_BM.GrabMemory();
		if( ROOT_BM.GetF(FLinkEdges) ) { ROOT_BM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( MAC_NPH_BIOMAS.Value()/( P1_NPH_AB_BEL.Value()+((float)1) ) );
			ROOT_BM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::ROOT_DEPTH_u62_exe() {
	float value;

	switch( ROOT_DEPTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ROOT_DEPTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(( ELEVATION.Value(p)-((float)1) ), ( ROOT_BM.Value(p)/P1_ROOT_DENS.Value(p) ));
			ROOT_DEPTH.Update( p, value );
		}
		ROOT_DEPTH.GrabMemory();
		if( ROOT_DEPTH.GetF(FLinkEdges) ) { ROOT_DEPTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(( ELEVATION.Value()-((float)1) ), ( ROOT_BM.Value()/P1_ROOT_DENS.Value() ));
			ROOT_DEPTH.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::SPROUTING_u63_exe() {
	float value;

	switch( SPROUTING.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SPROUTING.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( PH_TO_ABBM.Value(p) <  P1_MAX_PH_ABBM.Value(p) ) && ( ( BIO_TIME.Value(p) >  P1_BIO_START.Value(p) ) && ( BIO_TIME.Value(p) <  P1_BIO_END.Value(p) ) ) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			SPROUTING.Update( p, value );
		}
		SPROUTING.GrabMemory();
		if( SPROUTING.GetF(FLinkEdges) ) { SPROUTING.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( PH_TO_ABBM.Value() <  P1_MAX_PH_ABBM.Value() ) && ( ( BIO_TIME.Value() >  P1_BIO_START.Value() ) && ( BIO_TIME.Value() <  P1_BIO_END.Value() ) ) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			SPROUTING.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::TEMP_CF_u64_exe() {
	float value;

	switch( TEMP_CF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TEMP_CF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SL::Exp(( 0.20*( AIR_TEMP_C.Value(p)-P1_TEMPOPT.Value(p) ) ))*pow((double)( ( ((float)40)-AIR_TEMP_C.Value(p) )/( ((float)40)-P1_TEMPOPT.Value(p) ) ),(double)( 0.20*( ((float)40)-P1_TEMPOPT.Value(p) ) ) ) );
			TEMP_CF.Update( p, value );
		}
		TEMP_CF.GrabMemory();
		if( TEMP_CF.GetF(FLinkEdges) ) { TEMP_CF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SL::Exp(( 0.20*( AIR_TEMP_C.Value()-P1_TEMPOPT.Value() ) ))*pow((double)( ( ((float)40)-AIR_TEMP_C.Value() )/( ((float)40)-P1_TEMPOPT.Value() ) ),(double)( 0.20*( ((float)40)-P1_TEMPOPT.Value() ) ) ) );
			TEMP_CF.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::TOTAL_BIOM_u65_exe() {
	float value;

	switch( TOTAL_BIOM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOTAL_BIOM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( MAC_PH_BIOMAS.Value(p)+MAC_NPH_BIOMAS.Value(p) );
			TOTAL_BIOM.Update( p, value );
		}
		TOTAL_BIOM.GrabMemory();
		if( TOTAL_BIOM.GetF(FLinkEdges) ) { TOTAL_BIOM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( MAC_PH_BIOMAS.Value()+MAC_NPH_BIOMAS.Value() );
			TOTAL_BIOM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::TRANSDOWN_RT_u66_exe() {
	float value;

	switch( TRANSDOWN_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TRANSDOWN_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( BIO_TIME.Value(p) >  ( P1_BIO_REPRO.Value(p)+((float)1) ) ) ) ? ( ( ((float)1)-( ((float)1)/pow((double)( BIO_TIME.Value(p)-P1_BIO_REPRO.Value(p) ),(double)0.5 ) ) ) ) : (  ( ( ( PH_TO_ABBM.Value(p) <  P1_MAX_PH_ABBM.Value(p) ) ) ? ( ((float)0) ) : ( pow((double)SL::Cos(( ( ( P1_MAX_PH_ABBM.Value(p)/PH_TO_ABBM.Value(p) )*3.141590 )/2. )),(double)0.1 ) ) )  ) ) ;
			TRANSDOWN_RT.Update( p, value );
		}
		TRANSDOWN_RT.GrabMemory();
		if( TRANSDOWN_RT.GetF(FLinkEdges) ) { TRANSDOWN_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( BIO_TIME.Value() >  ( P1_BIO_REPRO.Value()+((float)1) ) ) ) ? ( ( ((float)1)-( ((float)1)/pow((double)( BIO_TIME.Value()-P1_BIO_REPRO.Value() ),(double)0.5 ) ) ) ) : (  ( ( ( PH_TO_ABBM.Value() <  P1_MAX_PH_ABBM.Value() ) ) ? ( ((float)0) ) : ( pow((double)SL::Cos(( ( ( P1_MAX_PH_ABBM.Value()/PH_TO_ABBM.Value() )*3.141590 )/2. )),(double)0.1 ) ) )  ) ) ;
			TRANSDOWN_RT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::WATER_CF_u67_exe() {
	float value;

	switch( WATER_CF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WATER_CF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(WAT_STRESS_HIGH.Value(p), WAT_STRESS_LOW.Value(p));
			WATER_CF.Update( p, value );
		}
		WATER_CF.GrabMemory();
		if( WATER_CF.GetF(FLinkEdges) ) { WATER_CF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(WAT_STRESS_HIGH.Value(), WAT_STRESS_LOW.Value());
			WATER_CF.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::WAT_STRESS_HIGH_u68_exe() {
	float value;

	switch( WAT_STRESS_HIGH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WAT_STRESS_HIGH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( P1_W_T_MAX.Value(p) <  ((float)0) ) && ( SURFACE_WATER.Value(p) >  -P1_W_T_MAX.Value(p) ) ) ) ? ( SL::Max(((float)0), ( ((float)1)/( ((float)1)+SL::Exp(( SURFACE_WATER.Value(p)+P1_W_T_MAX.Value(p) )) ) )) ) : (  ( ( ( ( P1_W_T_MAX.Value(p) >  ((float)0) ) && ( ROOT_DEPTH.Value(p) >  ((float)0) ) ) ) ? ( SL::Min(((float)1), ( ( UW_DEPTH.Value(p)/ROOT_DEPTH.Value(p) )/P1_W_T_MAX.Value(p) )) ) : ( ((float)1) ) )  ) ) ;
			WAT_STRESS_HIGH.Update( p, value );
		}
		WAT_STRESS_HIGH.GrabMemory();
		if( WAT_STRESS_HIGH.GetF(FLinkEdges) ) { WAT_STRESS_HIGH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( P1_W_T_MAX.Value() <  ((float)0) ) && ( SURFACE_WATER.Value() >  -P1_W_T_MAX.Value() ) ) ) ? ( SL::Max(((float)0), ( ((float)1)/( ((float)1)+SL::Exp(( SURFACE_WATER.Value()+P1_W_T_MAX.Value() )) ) )) ) : (  ( ( ( ( P1_W_T_MAX.Value() >  ((float)0) ) && ( ROOT_DEPTH.Value() >  ((float)0) ) ) ) ? ( SL::Min(((float)1), ( ( UW_DEPTH.Value()/ROOT_DEPTH.Value() )/P1_W_T_MAX.Value() )) ) : ( ((float)1) ) )  ) ) ;
			WAT_STRESS_HIGH.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::WAT_STRESS_LOW_u69_exe() {
	float value;

	switch( WAT_STRESS_LOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WAT_STRESS_LOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  pow((double)SL::Sin(( ( WATER_AVAIL.Value(p)*3.141590 )/2 )),(double)P1_W_T_MIN.Value(p) );
			WAT_STRESS_LOW.Update( p, value );
		}
		WAT_STRESS_LOW.GrabMemory();
		if( WAT_STRESS_LOW.GetF(FLinkEdges) ) { WAT_STRESS_LOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  pow((double)SL::Sin(( ( WATER_AVAIL.Value()*3.141590 )/2 )),(double)P1_W_T_MIN.Value() );
			WAT_STRESS_LOW.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_BIO_END_u70_exe() {
	float value;

	switch( P1_BIO_END.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_BIO_END.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)570);
			P1_BIO_END.Update( p, value );
		}
		P1_BIO_END.GrabMemory();
		if( P1_BIO_END.GetF(FLinkEdges) ) { P1_BIO_END.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)570);
			P1_BIO_END.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_BIO_REPRO_u71_exe() {
	float value;

	switch( P1_BIO_REPRO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_BIO_REPRO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1700);
			P1_BIO_REPRO.Update( p, value );
		}
		P1_BIO_REPRO.GrabMemory();
		if( P1_BIO_REPRO.GetF(FLinkEdges) ) { P1_BIO_REPRO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1700);
			P1_BIO_REPRO.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_BIO_START_u72_exe() {
	float value;

	switch( P1_BIO_START.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_BIO_START.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)500);
			P1_BIO_START.Update( p, value );
		}
		P1_BIO_START.GrabMemory();
		if( P1_BIO_START.GetF(FLinkEdges) ) { P1_BIO_START.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)500);
			P1_BIO_START.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_DAYLENG_RQ_u73_exe() {
	float value;

	switch( P1_DAYLENG_RQ.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DAYLENG_RQ.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)13);
			P1_DAYLENG_RQ.Update( p, value );
		}
		P1_DAYLENG_RQ.GrabMemory();
		if( P1_DAYLENG_RQ.GetF(FLinkEdges) ) { P1_DAYLENG_RQ.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)13);
			P1_DAYLENG_RQ.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_EST_HEIGHT_u74_exe() {
	float value;

	switch( P1_EST_HEIGHT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_EST_HEIGHT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)500);
			P1_EST_HEIGHT.Update( p, value );
		}
		P1_EST_HEIGHT.GrabMemory();
		if( P1_EST_HEIGHT.GetF(FLinkEdges) ) { P1_EST_HEIGHT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)500);
			P1_EST_HEIGHT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_H_DAY_u75_exe() {
	float value;

	switch( P1_H_DAY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_H_DAY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)319);
			P1_H_DAY.Update( p, value );
		}
		P1_H_DAY.GrabMemory();
		if( P1_H_DAY.GetF(FLinkEdges) ) { P1_H_DAY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)319);
			P1_H_DAY.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_LIGHTSAT_u76_exe() {
	float value;

	switch( P1_LIGHTSAT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_LIGHTSAT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)600);
			P1_LIGHTSAT.Update( p, value );
		}
		P1_LIGHTSAT.GrabMemory();
		if( P1_LIGHTSAT.GetF(FLinkEdges) ) { P1_LIGHTSAT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)600);
			P1_LIGHTSAT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_MAC_KS_N_u77_exe() {
	float value;

	switch( P1_MAC_KS_N.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAC_KS_N.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.00265;
			P1_MAC_KS_N.Update( p, value );
		}
		P1_MAC_KS_N.GrabMemory();
		if( P1_MAC_KS_N.GetF(FLinkEdges) ) { P1_MAC_KS_N.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.00265;
			P1_MAC_KS_N.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_MAC_KS_P_u78_exe() {
	float value;

	switch( P1_MAC_KS_P.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAC_KS_P.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000037;
			P1_MAC_KS_P.Update( p, value );
		}
		P1_MAC_KS_P.GrabMemory();
		if( P1_MAC_KS_P.GetF(FLinkEdges) ) { P1_MAC_KS_P.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000037;
			P1_MAC_KS_P.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_MAX_AB_BM_u79_exe() {
	float value;

	switch( P1_MAX_AB_BM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAX_AB_BM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.6;
			P1_MAX_AB_BM.Update( p, value );
		}
		P1_MAX_AB_BM.GrabMemory();
		if( P1_MAX_AB_BM.GetF(FLinkEdges) ) { P1_MAX_AB_BM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.6;
			P1_MAX_AB_BM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_MAX_DENS_u80_exe() {
	float value;

	switch( P1_MAX_DENS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAX_DENS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)40);
			P1_MAX_DENS.Update( p, value );
		}
		P1_MAX_DENS.GrabMemory();
		if( P1_MAX_DENS.GetF(FLinkEdges) ) { P1_MAX_DENS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)40);
			P1_MAX_DENS.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_MAX_HT_BM_u81_exe() {
	float value;

	switch( P1_MAX_HT_BM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAX_HT_BM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.8;
			P1_MAX_HT_BM.Update( p, value );
		}
		P1_MAX_HT_BM.GrabMemory();
		if( P1_MAX_HT_BM.GetF(FLinkEdges) ) { P1_MAX_HT_BM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.8;
			P1_MAX_HT_BM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_MAX_LAI_u82_exe() {
	float value;

	switch( P1_MAX_LAI.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAX_LAI.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)5);
			P1_MAX_LAI.Update( p, value );
		}
		P1_MAX_LAI.GrabMemory();
		if( P1_MAX_LAI.GetF(FLinkEdges) ) { P1_MAX_LAI.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)5);
			P1_MAX_LAI.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_MAX_PH_ABBM_u83_exe() {
	float value;

	switch( P1_MAX_PH_ABBM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAX_PH_ABBM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.75;
			P1_MAX_PH_ABBM.Update( p, value );
		}
		P1_MAX_PH_ABBM.GrabMemory();
		if( P1_MAX_PH_ABBM.GetF(FLinkEdges) ) { P1_MAX_PH_ABBM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.75;
			P1_MAX_PH_ABBM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_NPH_ABBM_IC_u84_exe() {
	float value;

	switch( P1_NPH_ABBM_IC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_NPH_ABBM_IC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_NPH_ABBM_IC.Update( p, value );
		}
		P1_NPH_ABBM_IC.GrabMemory();
		if( P1_NPH_ABBM_IC.GetF(FLinkEdges) ) { P1_NPH_ABBM_IC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_NPH_ABBM_IC.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_NPH_AB_BEL_u85_exe() {
	float value;

	switch( P1_NPH_AB_BEL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_NPH_AB_BEL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.7;
			P1_NPH_AB_BEL.Update( p, value );
		}
		P1_NPH_AB_BEL.GrabMemory();
		if( P1_NPH_AB_BEL.GetF(FLinkEdges) ) { P1_NPH_AB_BEL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.7;
			P1_NPH_AB_BEL.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_NPH_MORT_u86_exe() {
	float value;

	switch( P1_NPH_MORT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_NPH_MORT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.00000053;
			P1_NPH_MORT.Update( p, value );
		}
		P1_NPH_MORT.GrabMemory();
		if( P1_NPH_MORT.GetF(FLinkEdges) ) { P1_NPH_MORT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.00000053;
			P1_NPH_MORT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_NPH_PR_H_u87_exe() {
	float value;

	switch( P1_NPH_PR_H.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_NPH_PR_H.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.85;
			P1_NPH_PR_H.Update( p, value );
		}
		P1_NPH_PR_H.GrabMemory();
		if( P1_NPH_PR_H.GetF(FLinkEdges) ) { P1_NPH_PR_H.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.85;
			P1_NPH_PR_H.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_NPP_u88_exe() {
	float value;

	switch( P1_NPP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_NPP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.25;
			P1_NPP.Update( p, value );
		}
		P1_NPP.GrabMemory();
		if( P1_NPP.GetF(FLinkEdges) ) { P1_NPP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.25;
			P1_NPP.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_PHB_C_REC_u89_exe() {
	float value;

	switch( P1_PHB_C_REC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHB_C_REC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_PHB_C_REC.Update( p, value );
		}
		P1_PHB_C_REC.GrabMemory();
		if( P1_PHB_C_REC.GetF(FLinkEdges) ) { P1_PHB_C_REC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_PHB_C_REC.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_PHB_EVGRN_u90_exe() {
	float value;

	switch( P1_PHB_EVGRN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHB_EVGRN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_PHB_EVGRN.Update( p, value );
		}
		P1_PHB_EVGRN.GrabMemory();
		if( P1_PHB_EVGRN.GetF(FLinkEdges) ) { P1_PHB_EVGRN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_PHB_EVGRN.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_PHB_L_RT_u91_exe() {
	float value;

	switch( P1_PHB_L_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHB_L_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_PHB_L_RT.Update( p, value );
		}
		P1_PHB_L_RT.GrabMemory();
		if( P1_PHB_L_RT.GetF(FLinkEdges) ) { P1_PHB_L_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_PHB_L_RT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_PHB_MORT_u92_exe() {
	float value;

	switch( P1_PHB_MORT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHB_MORT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_PHB_MORT.Update( p, value );
		}
		P1_PHB_MORT.GrabMemory();
		if( P1_PHB_MORT.GetF(FLinkEdges) ) { P1_PHB_MORT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_PHB_MORT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_PHB_PR_H_u93_exe() {
	float value;

	switch( P1_PHB_PR_H.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHB_PR_H.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.8;
			P1_PHB_PR_H.Update( p, value );
		}
		P1_PHB_PR_H.GrabMemory();
		if( P1_PHB_PR_H.GetF(FLinkEdges) ) { P1_PHB_PR_H.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.8;
			P1_PHB_PR_H.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_PH_TO_REP_u94_exe() {
	float value;

	switch( P1_PH_TO_REP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PH_TO_REP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.005;
			P1_PH_TO_REP.Update( p, value );
		}
		P1_PH_TO_REP.GrabMemory();
		if( P1_PH_TO_REP.GetF(FLinkEdges) ) { P1_PH_TO_REP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.005;
			P1_PH_TO_REP.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_PROP_LA_TO_B_u95_exe() {
	float value;

	switch( P1_PROP_LA_TO_B.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PROP_LA_TO_B.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)12);
			P1_PROP_LA_TO_B.Update( p, value );
		}
		P1_PROP_LA_TO_B.GrabMemory();
		if( P1_PROP_LA_TO_B.GetF(FLinkEdges) ) { P1_PROP_LA_TO_B.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)12);
			P1_PROP_LA_TO_B.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_P_DAY_u96_exe() {
	float value;

	switch( P1_P_DAY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_P_DAY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)191);
			P1_P_DAY.Update( p, value );
		}
		P1_P_DAY.GrabMemory();
		if( P1_P_DAY.GetF(FLinkEdges) ) { P1_P_DAY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)191);
			P1_P_DAY.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_P_RATIO_u97_exe() {
	float value;

	switch( P1_P_RATIO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_P_RATIO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_P_RATIO.Update( p, value );
		}
		P1_P_RATIO.GrabMemory();
		if( P1_P_RATIO.GetF(FLinkEdges) ) { P1_P_RATIO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_P_RATIO.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_P_WT_u98_exe() {
	float value;

	switch( P1_P_WT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_P_WT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.0009;
			P1_P_WT.Update( p, value );
		}
		P1_P_WT.GrabMemory();
		if( P1_P_WT.GetF(FLinkEdges) ) { P1_P_WT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.0009;
			P1_P_WT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_ROOT_DENS_u99_exe() {
	float value;

	switch( P1_ROOT_DENS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_ROOT_DENS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)11);
			P1_ROOT_DENS.Update( p, value );
		}
		P1_ROOT_DENS.GrabMemory();
		if( P1_ROOT_DENS.GetF(FLinkEdges) ) { P1_ROOT_DENS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)11);
			P1_ROOT_DENS.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_SPR_RATE_u100_exe() {
	float value;

	switch( P1_SPR_RATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SPR_RATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.01;
			P1_SPR_RATE.Update( p, value );
		}
		P1_SPR_RATE.GrabMemory();
		if( P1_SPR_RATE.GetF(FLinkEdges) ) { P1_SPR_RATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.01;
			P1_SPR_RATE.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_TEMPOPT_u101_exe() {
	float value;

	switch( P1_TEMPOPT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_TEMPOPT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)25);
			P1_TEMPOPT.Update( p, value );
		}
		P1_TEMPOPT.GrabMemory();
		if( P1_TEMPOPT.GetF(FLinkEdges) ) { P1_TEMPOPT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)25);
			P1_TEMPOPT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_W_T_MAX_u102_exe() {
	float value;

	switch( P1_W_T_MAX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_W_T_MAX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.1;
			P1_W_T_MAX.Update( p, value );
		}
		P1_W_T_MAX.GrabMemory();
		if( P1_W_T_MAX.GetF(FLinkEdges) ) { P1_W_T_MAX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.1;
			P1_W_T_MAX.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_W_T_MIN_u103_exe() {
	float value;

	switch( P1_W_T_MIN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_W_T_MIN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.2;
			P1_W_T_MIN.Update( p, value );
		}
		P1_W_T_MIN.GrabMemory();
		if( P1_W_T_MIN.GetF(FLinkEdges) ) { P1_W_T_MIN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.2;
			P1_W_T_MIN.Update( value );
	  } break;
	}
	return 0;
}

MACROPHYTES_module* MACROPHYTES_module::fInstance = NULL;
MACROPHYTES_module* MACROPHYTES_module::kNullModel = (MACROPHYTES_module*)0x1;
int MACROPHYTES_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int MACROPHYTES_module::InitVars() {
	
	TIME.SSInit(this);
	AIR_TEMP_C.SSInit(this);
	HABITATMAP.SSInit(this);
	DAYJUL.SSInit(this);
	DAYLENGTH.SSInit(this);
	SOLRADGR.SSInit(this);
	DIN_AVAILABLE.SSInit(this);
	ELEVATION.SSInit(this);
	SURFACE_WATER.SSInit(this);
	UW_DEPTH.SSInit(this);
	WATER_AVAIL.SSInit(this);
	MACLAI.SSInit(this);
	ROOT_DEPTH.SSInit(this);
	MACH.SSInit(this);
	PHBIO_MORT.SSInit(this);
	PHBIO_MORT.SetOrigin(&MAC_PH_BIOMAS);
	PHBIO_HARVEST.SSInit(this);
	PHBIO_HARVEST.SetOrigin(&MAC_PH_BIOMAS);
	NPHBIO_MORT.SSInit(this);
	NPHBIO_MORT.SetOrigin(&MAC_NPH_BIOMAS);
	NPHBIO_HARVEST.SSInit(this);
	NPHBIO_HARVEST.SetOrigin(&MAC_NPH_BIOMAS);
	PHBIO_NPP.SSInit(this);
	PHBIO_NPP.SetDestination(&MAC_PH_BIOMAS);
	YIELD.SSInit(this);
	TOT_NPP.SSInit(this);
	BIO_TIME.SSInit(this);
	CF_AIR_TEMP.SSInit(this);
	CF_AIR_TEMP.SetDestination(&BIO_TIME);
	MAC_NPH_BIOMAS.SSInit(this);
	NPHBIO_PLANTING.SSInit(this);
	NPHBIO_PLANTING.SetDestination(&MAC_NPH_BIOMAS);
	TRANSDOWN.SSInit(this);
	TRANSDOWN.SetOrigin(&MAC_PH_BIOMAS);
	TRANSDOWN.SetDestination(&MAC_NPH_BIOMAS);
	TRANSUP.SSInit(this);
	TRANSUP.SetOrigin(&MAC_NPH_BIOMAS);
	TRANSUP.SetDestination(&MAC_PH_BIOMAS);
	MAC_PH_BIOMAS.SSInit(this);
	PHBIO_PLANT.SSInit(this);
	PHBIO_PLANT.SetDestination(&MAC_PH_BIOMAS);
	PH_MAX.SSInit(this);
	PH_IN.SSInit(this);
	PH_IN.SetDestination(&PH_MAX);
	PH_OUT.SSInit(this);
	PH_OUT.SetOrigin(&PH_MAX);
	NPP_IN.SSInit(this);
	NPP_IN.SetDestination(&TOT_NPP);
	HARVEST.SSInit(this);
	HARVEST.SetDestination(&YIELD);
	INI_YIELD.SSInit(this);
	INI_YIELD.SetOrigin(&YIELD);
	DAY_LENGTH_PREV.SSInit(this);
	FALL_LITTER.SSInit(this);
	FALL_LITTER_CALC.SSInit(this);
	HARVEST_TIME.SSInit(this);
	IC_NPHBIO.SSInit(this);
	IC_PHBIO.SSInit(this);
	LIGHT_CF.SSInit(this);
	MAC_LAI_R.SSInit(this);
	MAC_PROD_CF.SSInit(this);
	MAX_BM.SSInit(this);
	MAX_NPH.SSInit(this);
	MAX_PH.SSInit(this);
	NPH_AB_BM.SSInit(this);
	NUTR_CF.SSInit(this);
	PHBIO_MORT_WATER.SSInit(this);
	PHBIO_NPP_CALC.SSInit(this);
	PH_TO_ABBM.SSInit(this);
	PLANTIME.SSInit(this);
	PLANTING.SSInit(this);
	PO4SD_CONCTOT.SSInit(this);
	REMOVAL_TIME.SSInit(this);
	ROOT_BM.SSInit(this);
	SPROUTING.SSInit(this);
	TEMP_CF.SSInit(this);
	TOTAL_BIOM.SSInit(this);
	TRANSDOWN_RT.SSInit(this);
	WATER_CF.SSInit(this);
	WAT_STRESS_HIGH.SSInit(this);
	WAT_STRESS_LOW.SSInit(this);
	P1_BIO_END.SSInit(this);
	P1_BIO_REPRO.SSInit(this);
	P1_BIO_START.SSInit(this);
	P1_DAYLENG_RQ.SSInit(this);
	P1_EST_HEIGHT.SSInit(this);
	P1_H_DAY.SSInit(this);
	P1_LIGHTSAT.SSInit(this);
	P1_MAC_KS_N.SSInit(this);
	P1_MAC_KS_P.SSInit(this);
	P1_MAX_AB_BM.SSInit(this);
	P1_MAX_DENS.SSInit(this);
	P1_MAX_HT_BM.SSInit(this);
	P1_MAX_LAI.SSInit(this);
	P1_MAX_PH_ABBM.SSInit(this);
	P1_NPH_ABBM_IC.SSInit(this);
	P1_NPH_AB_BEL.SSInit(this);
	P1_NPH_MORT.SSInit(this);
	P1_NPH_PR_H.SSInit(this);
	P1_NPP.SSInit(this);
	P1_PHB_C_REC.SSInit(this);
	P1_PHB_EVGRN.SSInit(this);
	P1_PHB_L_RT.SSInit(this);
	P1_PHB_MORT.SSInit(this);
	P1_PHB_PR_H.SSInit(this);
	P1_PH_TO_REP.SSInit(this);
	P1_PROP_LA_TO_B.SSInit(this);
	P1_P_DAY.SSInit(this);
	P1_P_RATIO.SSInit(this);
	P1_P_WT.SSInit(this);
	P1_ROOT_DENS.SSInit(this);
	P1_SPR_RATE.SSInit(this);
	P1_TEMPOPT.SSInit(this);
	P1_W_T_MAX.SSInit(this);
	P1_W_T_MIN.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int MACROPHYTES_module::SetupEvents() {
	TImportCommand* AIR_TEMP_C_import = (TImportCommand*) AIR_TEMP_C.GetCommand("AIR_TEMP_C_import",TCommand::kUndefined,TCommand::kImport);
	AIR_TEMP_C_import->Code() = "Import AIR_TEMP_C from GLOBALS_module";
	AIR_TEMP_C_import->AddDependency(AIR_TEMP_C);
	AIR_TEMP_C_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* HABITATMAP_import = (TImportCommand*) HABITATMAP.GetCommand("HABITATMAP_import",TCommand::kUndefined,TCommand::kImport);
	HABITATMAP_import->Code() = "Import HABITATMAP from GLOBALS_module";
	HABITATMAP_import->AddDependency(HABITATMAP);
	HABITATMAP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DAYJUL_import = (TImportCommand*) DAYJUL.GetCommand("DAYJUL_import",TCommand::kUndefined,TCommand::kImport);
	DAYJUL_import->Code() = "Import DAYJUL from GLOBALS_module";
	DAYJUL_import->AddDependency(DAYJUL);
	DAYJUL_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DAYLENGTH_import = (TImportCommand*) DAYLENGTH.GetCommand("DAYLENGTH_import",TCommand::kUndefined,TCommand::kImport);
	DAYLENGTH_import->Code() = "Import DAYLENGTH from GLOBALS_module";
	DAYLENGTH_import->AddDependency(DAYLENGTH);
	DAYLENGTH_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SOLRADGR_import = (TImportCommand*) SOLRADGR.GetCommand("SOLRADGR_import",TCommand::kUndefined,TCommand::kImport);
	SOLRADGR_import->Code() = "Import SOLRADGR from XXXIMPORTS5_module";
	SOLRADGR_import->AddDependency(SOLRADGR);
	SOLRADGR_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DIN_AVAILABLE_import = (TImportCommand*) DIN_AVAILABLE.GetCommand("DIN_AVAILABLE_import",TCommand::kUndefined,TCommand::kImport);
	DIN_AVAILABLE_import->Code() = "Import DIN_AVAILABLE from ZDIN_module";
	DIN_AVAILABLE_import->AddDependency(DIN_AVAILABLE);
	DIN_AVAILABLE_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ELEVATION_import = (TImportCommand*) ELEVATION.GetCommand("ELEVATION_import",TCommand::kUndefined,TCommand::kImport);
	ELEVATION_import->Code() = "Import ELEVATION from GLOBALS_module";
	ELEVATION_import->AddDependency(ELEVATION);
	ELEVATION_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SURFACE_WATER_import = (TImportCommand*) SURFACE_WATER.GetCommand("SURFACE_WATER_import",TCommand::kUndefined,TCommand::kImport);
	SURFACE_WATER_import->Code() = "Import SURFACE_WATER from HYDROLOGY_module";
	SURFACE_WATER_import->AddDependency(SURFACE_WATER);
	SURFACE_WATER_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* UW_DEPTH_import = (TImportCommand*) UW_DEPTH.GetCommand("UW_DEPTH_import",TCommand::kUndefined,TCommand::kImport);
	UW_DEPTH_import->Code() = "Import UW_DEPTH from HYDROLOGY_module";
	UW_DEPTH_import->AddDependency(UW_DEPTH);
	UW_DEPTH_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* WATER_AVAIL_import = (TImportCommand*) WATER_AVAIL.GetCommand("WATER_AVAIL_import",TCommand::kUndefined,TCommand::kImport);
	WATER_AVAIL_import->Code() = "Import WATER_AVAIL from HYDROLOGY_module";
	WATER_AVAIL_import->AddDependency(WATER_AVAIL);
	WATER_AVAIL_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u46 = (TExecuteCommand*) MACLAI.GetCommand("u46",TCommand::kUpdate,TCommand::kCode);
	u46->SetExecutable(&MACLAI_u46_exe_g);
	u46->Code() = "u46 <- SL::Min(( MAC_PH_BIOMAS*P1_PROP_LA_TO_B ), P1_MAX_LAI)";
	u46->AddDependency(MAC_PH_BIOMAS);
	u46->AddDependency(HABITATMAP);
	u46->AddDependency(P1_PROP_LA_TO_B);
	u46->AddDependency(P1_MAX_LAI);
	u46->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u62 = (TExecuteCommand*) ROOT_DEPTH.GetCommand("u62",TCommand::kUpdate,TCommand::kCode);
	u62->SetExecutable(&ROOT_DEPTH_u62_exe_g);
	u62->Code() = "u62 <- SL::Min(( ELEVATION-((float)1) ), ( ROOT_BM/P1_ROOT_DENS ))";
	u62->AddDependency(ELEVATION);
	u62->AddDependency(ROOT_BM);
	u62->AddDependency(HABITATMAP);
	u62->AddDependency(P1_ROOT_DENS);
	u62->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u45 = (TExecuteCommand*) MACH.GetCommand("u45",TCommand::kUpdate,TCommand::kCode);
	u45->SetExecutable(&MACH_u45_exe_g);
	u45->Code() = "u45 <- ( ( P1_MAX_HT_BM*TOTAL_BIOM )/MAX_BM )";
	u45->AddDependency(HABITATMAP);
	u45->AddDependency(P1_MAX_HT_BM);
	u45->AddDependency(TOTAL_BIOM);
	u45->AddDependency(MAX_BM);
	u45->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u25 = (TExecuteCommand*) PHBIO_MORT.GetCommand("u25",TCommand::kUpdate,TCommand::kCode);
	u25->SetExecutable(&PHBIO_MORT_u25_exe_g);
	u25->Code() = "u25 <- ( ( ( ( HARVEST_TIME.Delay( dT() )*MAC_PH_BIOMAS )/dT() )+( FALL_LITTER*( ((float)1)-P1_PHB_C_REC ) ) )+( MAC_PH_BIOMAS*( PHBIO_MORT_WATER+P1_PHB_MORT ) ) )";
	if( MAC_PH_BIOMAS.GetF(FisClamped) ) { u25->AddDependency(MAC_PH_BIOMAS); }
	u25->AddDependency(HARVEST_TIME);
	u25->AddDependency(MAC_PH_BIOMAS);
	u25->AddDependency(FALL_LITTER);
	u25->AddDependency(HABITATMAP);
	u25->AddDependency(P1_PHB_C_REC);
	u25->AddDependency(PHBIO_MORT_WATER);
	u25->AddDependency(P1_PHB_MORT);
	u25->AddDependency(PHBIO_NPP);
	u25->AddDependency(TRANSUP);
	u25->AddDependency(PHBIO_PLANT);
	u25->SetObjInfo(TCommand::kDepIndex, 2);
	TExecuteCommand* u26 = (TExecuteCommand*) PHBIO_HARVEST.GetCommand("u26",TCommand::kUpdate,TCommand::kCode);
	u26->SetExecutable(&PHBIO_HARVEST_u26_exe_g);
	u26->Code() = "u26 <- ( ( ( ( HARVEST_TIME+REMOVAL_TIME )*P1_PHB_PR_H )*MAC_PH_BIOMAS )/dT() )";
	if( MAC_PH_BIOMAS.GetF(FisClamped) ) { u26->AddDependency(MAC_PH_BIOMAS); }
	u26->AddDependency(HARVEST_TIME);
	u26->AddDependency(REMOVAL_TIME);
	u26->AddDependency(HABITATMAP);
	u26->AddDependency(P1_PHB_PR_H);
	u26->AddDependency(MAC_PH_BIOMAS);
	u26->AddDependency(PHBIO_NPP);
	u26->AddDependency(TRANSUP);
	u26->AddDependency(PHBIO_PLANT);
	u26->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u18 = (TExecuteCommand*) NPHBIO_MORT.GetCommand("u18",TCommand::kUpdate,TCommand::kCode);
	u18->SetExecutable(&NPHBIO_MORT_u18_exe_g);
	u18->Code() = "u18 <- ( ( MAC_NPH_BIOMAS*P1_NPH_MORT )+( ( HARVEST_TIME.Delay( dT() )*MAC_NPH_BIOMAS )/dT() ) )";
	if( MAC_NPH_BIOMAS.GetF(FisClamped) ) { u18->AddDependency(MAC_NPH_BIOMAS); }
	u18->AddDependency(MAC_NPH_BIOMAS);
	u18->AddDependency(HABITATMAP);
	u18->AddDependency(P1_NPH_MORT);
	u18->AddDependency(HARVEST_TIME);
	u18->AddDependency(NPHBIO_PLANTING);
	u18->AddDependency(TRANSDOWN);
	u18->SetObjInfo(TCommand::kDepIndex, 2);
	TExecuteCommand* u20 = (TExecuteCommand*) NPHBIO_HARVEST.GetCommand("u20",TCommand::kUpdate,TCommand::kCode);
	u20->SetExecutable(&NPHBIO_HARVEST_u20_exe_g);
	u20->Code() = "u20 <- ( ( ( HARVEST_TIME*P1_NPH_PR_H )*MAC_NPH_BIOMAS )/dT() )";
	if( MAC_NPH_BIOMAS.GetF(FisClamped) ) { u20->AddDependency(MAC_NPH_BIOMAS); }
	u20->AddDependency(HARVEST_TIME);
	u20->AddDependency(HABITATMAP);
	u20->AddDependency(P1_NPH_PR_H);
	u20->AddDependency(MAC_NPH_BIOMAS);
	u20->AddDependency(NPHBIO_PLANTING);
	u20->AddDependency(TRANSDOWN);
	u20->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u23 = (TExecuteCommand*) PHBIO_NPP.GetCommand("u23",TCommand::kUpdate,TCommand::kCode);
	u23->SetExecutable(&PHBIO_NPP_u23_exe_g);
	u23->Code() = "u23 <-  ( ( ( HARVEST_TIME >  ((float)0) ) ) ? ( ((float)0) ) : ( PHBIO_NPP_CALC ) ) ";
	u23->AddDependency(HARVEST_TIME);
	u23->AddDependency(PHBIO_NPP_CALC);
	u23->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I34 = (TExecuteCommand*) YIELD.GetCommand("I34",TCommand::kIntegrate,TCommand::kCode);
	I34->SetExecutable(&YIELD_I34_exe_g);
	I34->Code() = "I34 <- ( HARVEST-INI_YIELD )";
	I34->AddDependency(HARVEST);
	I34->AddDependency(INI_YIELD);
	I34->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i35 = (TExecuteCommand*) YIELD.GetCommand("i35",TCommand::kInit,TCommand::kCode);
	i35->SetExecutable(&YIELD_i35_exe_g);
	i35->Code() = "i35 <- ((float)0)";
	i35->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* I31 = (TExecuteCommand*) TOT_NPP.GetCommand("I31",TCommand::kIntegrate,TCommand::kCode);
	I31->SetExecutable(&TOT_NPP_I31_exe_g);
	I31->Code() = "I31 <- NPP_IN";
	I31->AddDependency(NPP_IN);
	I31->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i32 = (TExecuteCommand*) TOT_NPP.GetCommand("i32",TCommand::kInit,TCommand::kCode);
	i32->SetExecutable(&TOT_NPP_i32_exe_g);
	i32->Code() = "i32 <- ((float)0)";
	i32->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* I11 = (TExecuteCommand*) BIO_TIME.GetCommand("I11",TCommand::kIntegrate,TCommand::kCode);
	I11->SetExecutable(&BIO_TIME_I11_exe_g);
	I11->Code() = "I11 <- CF_AIR_TEMP";
	I11->AddDependency(CF_AIR_TEMP);
	I11->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i12 = (TExecuteCommand*) BIO_TIME.GetCommand("i12",TCommand::kInit,TCommand::kCode);
	i12->SetExecutable(&BIO_TIME_i12_exe_g);
	i12->Code() = "i12 <- ((float)0)";
	i12->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u13 = (TExecuteCommand*) CF_AIR_TEMP.GetCommand("u13",TCommand::kUpdate,TCommand::kCode);
	u13->SetExecutable(&CF_AIR_TEMP_u13_exe_g);
	u13->Code() = "u13 <-  ( ( ( PLANTIME == ((float)1) ) ) ? ( ( -BIO_TIME/dT() ) ) : (  ( ( ( AIR_TEMP_C >  ((float)5) ) ) ? ( AIR_TEMP_C ) : ( ((float)0) ) )  ) ) ";
	u13->AddDependency(PLANTIME);
	u13->AddDependency(BIO_TIME);
	u13->AddDependency(AIR_TEMP_C);
	u13->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I14 = (TExecuteCommand*) MAC_NPH_BIOMAS.GetCommand("I14",TCommand::kIntegrate,TCommand::kCode);
	I14->SetExecutable(&MAC_NPH_BIOMAS_I14_exe_g);
	I14->Code() = "I14 <- ( ( ( ( NPHBIO_PLANTING+TRANSDOWN )-NPHBIO_MORT )-TRANSUP )-NPHBIO_HARVEST )";
	I14->AddDependency(NPHBIO_PLANTING);
	I14->AddDependency(TRANSDOWN);
	I14->AddDependency(NPHBIO_MORT);
	I14->AddDependency(TRANSUP);
	I14->AddDependency(NPHBIO_HARVEST);
	I14->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i15 = (TExecuteCommand*) MAC_NPH_BIOMAS.GetCommand("i15",TCommand::kInit,TCommand::kCode);
	i15->SetExecutable(&MAC_NPH_BIOMAS_i15_exe_g);
	i15->Code() = "i15 <- IC_NPHBIO";
	i15->AddDependency(IC_NPHBIO);
	i15->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u16 = (TExecuteCommand*) NPHBIO_PLANTING.GetCommand("u16",TCommand::kUpdate,TCommand::kCode);
	u16->SetExecutable(&NPHBIO_PLANTING_u16_exe_g);
	u16->Code() = "u16 <- ( PLANTING*( ((float)1)-P1_P_RATIO ) )";
	u16->AddDependency(PLANTING);
	u16->AddDependency(HABITATMAP);
	u16->AddDependency(P1_P_RATIO);
	u16->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u17 = (TExecuteCommand*) TRANSDOWN.GetCommand("u17",TCommand::kUpdate,TCommand::kCode);
	u17->SetExecutable(&TRANSDOWN_u17_exe_g);
	u17->Code() = "u17 <-  ( ( ( HARVEST_TIME >  ((float)0) ) ) ? ( ((float)0) ) : ( ( ( TRANSDOWN_RT*( PHBIO_NPP+( P1_PH_TO_REP*MAC_PH_BIOMAS ) ) )+( P1_PHB_C_REC*FALL_LITTER ) ) ) ) ";
	if( MAC_PH_BIOMAS.GetF(FisClamped) ) { u17->AddDependency(MAC_PH_BIOMAS); }
	u17->AddDependency(HARVEST_TIME);
	u17->AddDependency(TRANSDOWN_RT);
	u17->AddDependency(PHBIO_NPP);
	u17->AddDependency(HABITATMAP);
	u17->AddDependency(P1_PH_TO_REP);
	u17->AddDependency(MAC_PH_BIOMAS);
	u17->AddDependency(P1_PHB_C_REC);
	u17->AddDependency(FALL_LITTER);
	u17->AddDependency(TRANSUP);
	u17->AddDependency(PHBIO_PLANT);
	u17->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u19 = (TExecuteCommand*) TRANSUP.GetCommand("u19",TCommand::kUpdate,TCommand::kCode);
	u19->SetExecutable(&TRANSUP_u19_exe_g);
	u19->Code() = "u19 <- ( ( SPROUTING*P1_SPR_RATE )*MAC_NPH_BIOMAS )";
	if( MAC_NPH_BIOMAS.GetF(FisClamped) ) { u19->AddDependency(MAC_NPH_BIOMAS); }
	u19->AddDependency(SPROUTING);
	u19->AddDependency(HABITATMAP);
	u19->AddDependency(P1_SPR_RATE);
	u19->AddDependency(MAC_NPH_BIOMAS);
	u19->AddDependency(NPHBIO_PLANTING);
	u19->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I21 = (TExecuteCommand*) MAC_PH_BIOMAS.GetCommand("I21",TCommand::kIntegrate,TCommand::kCode);
	I21->SetExecutable(&MAC_PH_BIOMAS_I21_exe_g);
	I21->Code() = "I21 <- ( ( ( ( ( PHBIO_NPP+PHBIO_PLANT )+TRANSUP )-PHBIO_MORT )-PHBIO_HARVEST )-TRANSDOWN )";
	I21->AddDependency(PHBIO_NPP);
	I21->AddDependency(PHBIO_PLANT);
	I21->AddDependency(TRANSUP);
	I21->AddDependency(PHBIO_MORT);
	I21->AddDependency(PHBIO_HARVEST);
	I21->AddDependency(TRANSDOWN);
	I21->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i22 = (TExecuteCommand*) MAC_PH_BIOMAS.GetCommand("i22",TCommand::kInit,TCommand::kCode);
	i22->SetExecutable(&MAC_PH_BIOMAS_i22_exe_g);
	i22->Code() = "i22 <- IC_PHBIO";
	i22->AddDependency(IC_PHBIO);
	i22->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u24 = (TExecuteCommand*) PHBIO_PLANT.GetCommand("u24",TCommand::kUpdate,TCommand::kCode);
	u24->SetExecutable(&PHBIO_PLANT_u24_exe_g);
	u24->Code() = "u24 <- ( PLANTING*P1_P_RATIO )";
	u24->AddDependency(PLANTING);
	u24->AddDependency(HABITATMAP);
	u24->AddDependency(P1_P_RATIO);
	u24->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I27 = (TExecuteCommand*) PH_MAX.GetCommand("I27",TCommand::kIntegrate,TCommand::kCode);
	I27->SetExecutable(&PH_MAX_I27_exe_g);
	I27->Code() = "I27 <- ( PH_IN-PH_OUT )";
	I27->AddDependency(PH_IN);
	I27->AddDependency(PH_OUT);
	I27->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i28 = (TExecuteCommand*) PH_MAX.GetCommand("i28",TCommand::kInit,TCommand::kCode);
	i28->SetExecutable(&PH_MAX_i28_exe_g);
	i28->Code() = "i28 <- ((float)0)";
	i28->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u29 = (TExecuteCommand*) PH_IN.GetCommand("u29",TCommand::kUpdate,TCommand::kCode);
	u29->SetExecutable(&PH_IN_u29_exe_g);
	u29->Code() = "u29 <-  ( ( ( MAC_PH_BIOMAS >  PH_MAX ) ) ? ( ( MAC_PH_BIOMAS/dT() ) ) : ( ((float)0) ) ) ";
	u29->AddDependency(MAC_PH_BIOMAS);
	u29->AddDependency(PH_MAX);
	u29->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u30 = (TExecuteCommand*) PH_OUT.GetCommand("u30",TCommand::kUpdate,TCommand::kCode);
	u30->SetExecutable(&PH_OUT_u30_exe_g);
	u30->Code() = "u30 <-  ( ( ( ( MAC_PH_BIOMAS >  PH_MAX ) || ( PLANTIME == ((float)1) ) ) ) ? ( ( PH_MAX/dT() ) ) : ( ((float)0) ) ) ";
	if( PH_MAX.GetF(FisClamped) ) { u30->AddDependency(PH_MAX); }
	u30->AddDependency(MAC_PH_BIOMAS);
	u30->AddDependency(PH_MAX);
	u30->AddDependency(PLANTIME);
	u30->AddDependency(PH_IN);
	u30->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u33 = (TExecuteCommand*) NPP_IN.GetCommand("u33",TCommand::kUpdate,TCommand::kCode);
	u33->SetExecutable(&NPP_IN_u33_exe_g);
	u33->Code() = "u33 <-  ( ( ( HABITATMAP == ((float)2) ) ) ? ( PHBIO_NPP ) : ( ((float)0) ) ) ";
	u33->AddDependency(HABITATMAP);
	u33->AddDependency(PHBIO_NPP);
	u33->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u36 = (TExecuteCommand*) HARVEST.GetCommand("u36",TCommand::kUpdate,TCommand::kCode);
	u36->SetExecutable(&HARVEST_u36_exe_g);
	u36->Code() = "u36 <- ( PHBIO_HARVEST+NPHBIO_HARVEST )";
	u36->AddDependency(PHBIO_HARVEST);
	u36->AddDependency(NPHBIO_HARVEST);
	u36->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u37 = (TExecuteCommand*) INI_YIELD.GetCommand("u37",TCommand::kUpdate,TCommand::kCode);
	u37->SetExecutable(&INI_YIELD_u37_exe_g);
	u37->Code() = "u37 <-  ( ( ( DAYJUL == ((float)1) ) ) ? ( ( ( YIELD/dT() )*((float)0) ) ) : ( ((float)0) ) ) ";
	if( YIELD.GetF(FisClamped) ) { u37->AddDependency(YIELD); }
	u37->AddDependency(DAYJUL);
	u37->AddDependency(YIELD);
	u37->AddDependency(HARVEST);
	u37->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u38 = (TExecuteCommand*) DAY_LENGTH_PREV.GetCommand("u38",TCommand::kUpdate,TCommand::kCode);
	u38->SetExecutable(&DAY_LENGTH_PREV_u38_exe_g);
	u38->Code() = "u38 <- DAYLENGTH.Delay( ((float)1) )";
	u38->AddDependency(DAYLENGTH);
	u38->SetObjInfo(TCommand::kDepIndex, 2);
	TExecuteCommand* u39 = (TExecuteCommand*) FALL_LITTER.GetCommand("u39",TCommand::kUpdate,TCommand::kCode);
	u39->SetExecutable(&FALL_LITTER_u39_exe_g);
	u39->Code() = "u39 <- SL::Min(FALL_LITTER_CALC, SL::Max(((float)0), ( MAC_PH_BIOMAS-( ( P1_PHB_EVGRN*PH_MAX )/( ((float)1)+P1_PHB_EVGRN ) ) )))";
	u39->AddDependency(FALL_LITTER_CALC);
	u39->AddDependency(MAC_PH_BIOMAS);
	u39->AddDependency(HABITATMAP);
	u39->AddDependency(P1_PHB_EVGRN);
	u39->AddDependency(PH_MAX);
	u39->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u40 = (TExecuteCommand*) FALL_LITTER_CALC.GetCommand("u40",TCommand::kUpdate,TCommand::kCode);
	u40->SetExecutable(&FALL_LITTER_CALC_u40_exe_g);
	u40->Code() = "u40 <-  ( ( ( ( DAYLENGTH >  P1_DAYLENG_RQ ) || ( DAYLENGTH >= DAY_LENGTH_PREV ) ) ) ? ( ((float)0) ) : (  ( ( ( MAC_PH_BIOMAS <  ( 0.01*( ((float)1)-P1_PHB_EVGRN ) ) ) ) ? ( ( ( ( ((float)1)-P1_PHB_EVGRN )*MAC_PH_BIOMAS )/dT() ) ) : ( ( ( ((float)1)-P1_PHB_EVGRN )*pow((double)( ( PH_MAX*P1_PHB_L_RT )/MAC_PH_BIOMAS ),(double)((float)3) ) ) ) )  ) ) ";
	u40->AddDependency(DAYLENGTH);
	u40->AddDependency(HABITATMAP);
	u40->AddDependency(P1_DAYLENG_RQ);
	u40->AddDependency(DAY_LENGTH_PREV);
	u40->AddDependency(MAC_PH_BIOMAS);
	u40->AddDependency(P1_PHB_EVGRN);
	u40->AddDependency(PH_MAX);
	u40->AddDependency(P1_PHB_L_RT);
	u40->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u41 = (TExecuteCommand*) HARVEST_TIME.GetCommand("u41",TCommand::kUpdate,TCommand::kCode);
	u41->SetExecutable(&HARVEST_TIME_u41_exe_g);
	u41->Code() = "u41 <-  ( ( ( ( DAYJUL >  P1_H_DAY ) && ( DAYJUL <  ( P1_H_DAY+((float)3) ) ) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ";
	u41->AddDependency(DAYJUL);
	u41->AddDependency(HABITATMAP);
	u41->AddDependency(P1_H_DAY);
	u41->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u42 = (TExecuteCommand*) IC_NPHBIO.GetCommand("u42",TCommand::kUpdate,TCommand::kCode);
	u42->SetExecutable(&IC_NPHBIO_u42_exe_g);
	u42->Code() = "u42 <- ( ( P1_NPH_ABBM_IC*( P1_NPH_AB_BEL+((float)1) ) )/P1_NPH_AB_BEL )";
	u42->AddDependency(HABITATMAP);
	u42->AddDependency(P1_NPH_ABBM_IC);
	u42->AddDependency(P1_NPH_AB_BEL);
	u42->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u43 = (TExecuteCommand*) IC_PHBIO.GetCommand("u43",TCommand::kUpdate,TCommand::kCode);
	u43->SetExecutable(&IC_PHBIO_u43_exe_g);
	u43->Code() = "u43 <- ( ( ( P1_PHB_EVGRN*P1_NPH_ABBM_IC )*P1_MAX_PH_ABBM )/( ((float)1)-P1_MAX_PH_ABBM ) )";
	u43->AddDependency(HABITATMAP);
	u43->AddDependency(P1_PHB_EVGRN);
	u43->AddDependency(P1_NPH_ABBM_IC);
	u43->AddDependency(P1_MAX_PH_ABBM);
	u43->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u44 = (TExecuteCommand*) LIGHT_CF.GetCommand("u44",TCommand::kUpdate,TCommand::kCode);
	u44->SetExecutable(&LIGHT_CF_u44_exe_g);
	u44->Code() = "u44 <- ( ( SOLRADGR/P1_LIGHTSAT )*SL::Exp(( ((float)1)-( SOLRADGR/P1_LIGHTSAT ) )) )";
	u44->AddDependency(SOLRADGR);
	u44->AddDependency(HABITATMAP);
	u44->AddDependency(P1_LIGHTSAT);
	u44->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u47 = (TExecuteCommand*) MAC_LAI_R.GetCommand("u47",TCommand::kUpdate,TCommand::kCode);
	u47->SetExecutable(&MAC_LAI_R_u47_exe_g);
	u47->Code() = "u47 <- ( MACLAI/P1_MAX_LAI )";
	u47->AddDependency(MACLAI);
	u47->AddDependency(HABITATMAP);
	u47->AddDependency(P1_MAX_LAI);
	u47->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u48 = (TExecuteCommand*) MAC_PROD_CF.GetCommand("u48",TCommand::kUpdate,TCommand::kCode);
	u48->SetExecutable(&MAC_PROD_CF_u48_exe_g);
	u48->Code() = "u48 <- ( ( SL::Min(LIGHT_CF, TEMP_CF)*WATER_CF )*NUTR_CF )";
	u48->AddDependency(LIGHT_CF);
	u48->AddDependency(TEMP_CF);
	u48->AddDependency(WATER_CF);
	u48->AddDependency(NUTR_CF);
	u48->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u49 = (TExecuteCommand*) MAX_BM.GetCommand("u49",TCommand::kUpdate,TCommand::kCode);
	u49->SetExecutable(&MAX_BM_u49_exe_g);
	u49->Code() = "u49 <- ( MAX_NPH+MAX_PH )";
	u49->AddDependency(MAX_NPH);
	u49->AddDependency(MAX_PH);
	u49->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u50 = (TExecuteCommand*) MAX_NPH.GetCommand("u50",TCommand::kUpdate,TCommand::kCode);
	u50->SetExecutable(&MAX_NPH_u50_exe_g);
	u50->Code() = "u50 <- ( ( P1_MAX_AB_BM-MAX_PH )*( ((float)1)+( ((float)1)/P1_NPH_AB_BEL ) ) )";
	u50->AddDependency(HABITATMAP);
	u50->AddDependency(P1_MAX_AB_BM);
	u50->AddDependency(MAX_PH);
	u50->AddDependency(P1_NPH_AB_BEL);
	u50->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u51 = (TExecuteCommand*) MAX_PH.GetCommand("u51",TCommand::kUpdate,TCommand::kCode);
	u51->SetExecutable(&MAX_PH_u51_exe_g);
	u51->Code() = "u51 <- ( P1_MAX_AB_BM*P1_MAX_PH_ABBM )";
	u51->AddDependency(HABITATMAP);
	u51->AddDependency(P1_MAX_AB_BM);
	u51->AddDependency(P1_MAX_PH_ABBM);
	u51->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u52 = (TExecuteCommand*) NPH_AB_BM.GetCommand("u52",TCommand::kUpdate,TCommand::kCode);
	u52->SetExecutable(&NPH_AB_BM_u52_exe_g);
	u52->Code() = "u52 <- ( P1_NPH_AB_BEL*ROOT_BM )";
	u52->AddDependency(HABITATMAP);
	u52->AddDependency(P1_NPH_AB_BEL);
	u52->AddDependency(ROOT_BM);
	u52->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u53 = (TExecuteCommand*) NUTR_CF.GetCommand("u53",TCommand::kUpdate,TCommand::kCode);
	u53->SetExecutable(&NUTR_CF_u53_exe_g);
	u53->Code() = "u53 <- SL::Min(( DIN_AVAILABLE/( DIN_AVAILABLE+P1_MAC_KS_N ) ), ( PO4SD_CONCTOT/( PO4SD_CONCTOT+P1_MAC_KS_P ) ))";
	u53->AddDependency(DIN_AVAILABLE);
	u53->AddDependency(HABITATMAP);
	u53->AddDependency(P1_MAC_KS_N);
	u53->AddDependency(PO4SD_CONCTOT);
	u53->AddDependency(P1_MAC_KS_P);
	u53->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u54 = (TExecuteCommand*) PHBIO_MORT_WATER.GetCommand("u54",TCommand::kUpdate,TCommand::kCode);
	u54->SetExecutable(&PHBIO_MORT_WATER_u54_exe_g);
	u54->Code() = "u54 <- ( 0.1*SL::Max(((float)0), ( ((float)1)-WATER_CF )) )";
	u54->AddDependency(WATER_CF);
	u54->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u55 = (TExecuteCommand*) PHBIO_NPP_CALC.GetCommand("u55",TCommand::kUpdate,TCommand::kCode);
	u55->SetExecutable(&PHBIO_NPP_CALC_u55_exe_g);
	u55->Code() = "u55 <-  ( ( ( MAC_PH_BIOMAS <  MAX_PH ) ) ? ( ( ( ( MAC_PROD_CF*P1_NPP )*MAC_PH_BIOMAS )*( ((float)1)-( MAC_PH_BIOMAS/MAX_PH ) ) ) ) : ( ((float)0) ) ) ";
	u55->AddDependency(MAC_PH_BIOMAS);
	u55->AddDependency(MAX_PH);
	u55->AddDependency(MAC_PROD_CF);
	u55->AddDependency(HABITATMAP);
	u55->AddDependency(P1_NPP);
	u55->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u56 = (TExecuteCommand*) PH_TO_ABBM.GetCommand("u56",TCommand::kUpdate,TCommand::kCode);
	u56->SetExecutable(&PH_TO_ABBM_u56_exe_g);
	u56->Code() = "u56 <-  ( ( ( NPH_AB_BM == ((float)0) ) ) ? ( ((float)0) ) : ( ( MAC_PH_BIOMAS/( MAC_PH_BIOMAS+NPH_AB_BM ) ) ) ) ";
	u56->AddDependency(NPH_AB_BM);
	u56->AddDependency(MAC_PH_BIOMAS);
	u56->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u57 = (TExecuteCommand*) PLANTIME.GetCommand("u57",TCommand::kUpdate,TCommand::kCode);
	u57->SetExecutable(&PLANTIME_u57_exe_g);
	u57->Code() = "u57 <-  ( ( ( DAYJUL == P1_P_DAY ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ";
	u57->AddDependency(DAYJUL);
	u57->AddDependency(HABITATMAP);
	u57->AddDependency(P1_P_DAY);
	u57->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u58 = (TExecuteCommand*) PLANTING.GetCommand("u58",TCommand::kUpdate,TCommand::kCode);
	u58->SetExecutable(&PLANTING_u58_exe_g);
	u58->Code() = "u58 <- ( ( PLANTIME*P1_MAX_DENS )*P1_P_WT )";
	u58->AddDependency(PLANTIME);
	u58->AddDependency(HABITATMAP);
	u58->AddDependency(P1_MAX_DENS);
	u58->AddDependency(P1_P_WT);
	u58->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u59 = (TExecuteCommand*) PO4SD_CONCTOT.GetCommand("u59",TCommand::kUpdate,TCommand::kCode);
	u59->SetExecutable(&PO4SD_CONCTOT_u59_exe_g);
	u59->Code() = "u59 <- 1000";
	u59->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u60 = (TExecuteCommand*) REMOVAL_TIME.GetCommand("u60",TCommand::kUpdate,TCommand::kCode);
	u60->SetExecutable(&REMOVAL_TIME_u60_exe_g);
	u60->Code() = "u60 <-  ( ( ( ( MACH*P1_PHB_PR_H ) >  P1_EST_HEIGHT ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ";
	u60->AddDependency(MACH);
	u60->AddDependency(HABITATMAP);
	u60->AddDependency(P1_PHB_PR_H);
	u60->AddDependency(P1_EST_HEIGHT);
	u60->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u61 = (TExecuteCommand*) ROOT_BM.GetCommand("u61",TCommand::kUpdate,TCommand::kCode);
	u61->SetExecutable(&ROOT_BM_u61_exe_g);
	u61->Code() = "u61 <- ( MAC_NPH_BIOMAS/( P1_NPH_AB_BEL+((float)1) ) )";
	u61->AddDependency(MAC_NPH_BIOMAS);
	u61->AddDependency(HABITATMAP);
	u61->AddDependency(P1_NPH_AB_BEL);
	u61->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u63 = (TExecuteCommand*) SPROUTING.GetCommand("u63",TCommand::kUpdate,TCommand::kCode);
	u63->SetExecutable(&SPROUTING_u63_exe_g);
	u63->Code() = "u63 <-  ( ( ( ( PH_TO_ABBM <  P1_MAX_PH_ABBM ) && ( ( BIO_TIME >  P1_BIO_START ) && ( BIO_TIME <  P1_BIO_END ) ) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ";
	u63->AddDependency(PH_TO_ABBM);
	u63->AddDependency(HABITATMAP);
	u63->AddDependency(P1_MAX_PH_ABBM);
	u63->AddDependency(BIO_TIME);
	u63->AddDependency(P1_BIO_START);
	u63->AddDependency(P1_BIO_END);
	u63->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u64 = (TExecuteCommand*) TEMP_CF.GetCommand("u64",TCommand::kUpdate,TCommand::kCode);
	u64->SetExecutable(&TEMP_CF_u64_exe_g);
	u64->Code() = "u64 <- ( SL::Exp(( 0.20*( AIR_TEMP_C-P1_TEMPOPT ) ))*pow((double)( ( ((float)40)-AIR_TEMP_C )/( ((float)40)-P1_TEMPOPT ) ),(double)( 0.20*( ((float)40)-P1_TEMPOPT ) ) ) )";
	u64->AddDependency(AIR_TEMP_C);
	u64->AddDependency(HABITATMAP);
	u64->AddDependency(P1_TEMPOPT);
	u64->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u65 = (TExecuteCommand*) TOTAL_BIOM.GetCommand("u65",TCommand::kUpdate,TCommand::kCode);
	u65->SetExecutable(&TOTAL_BIOM_u65_exe_g);
	u65->Code() = "u65 <- ( MAC_PH_BIOMAS+MAC_NPH_BIOMAS )";
	u65->AddDependency(MAC_PH_BIOMAS);
	u65->AddDependency(MAC_NPH_BIOMAS);
	u65->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u66 = (TExecuteCommand*) TRANSDOWN_RT.GetCommand("u66",TCommand::kUpdate,TCommand::kCode);
	u66->SetExecutable(&TRANSDOWN_RT_u66_exe_g);
	u66->Code() = "u66 <-  ( ( ( BIO_TIME >  ( P1_BIO_REPRO+((float)1) ) ) ) ? ( ( ((float)1)-( ((float)1)/pow((double)( BIO_TIME-P1_BIO_REPRO ),(double)0.5 ) ) ) ) : (  ( ( ( PH_TO_ABBM <  P1_MAX_PH_ABBM ) ) ? ( ((float)0) ) : ( pow((double)SL::Cos(( ( ( P1_MAX_PH_ABBM/PH_TO_ABBM )*3.141590 )/2. )),(double)0.1 ) ) )  ) ) ";
	u66->AddDependency(BIO_TIME);
	u66->AddDependency(HABITATMAP);
	u66->AddDependency(P1_BIO_REPRO);
	u66->AddDependency(PH_TO_ABBM);
	u66->AddDependency(P1_MAX_PH_ABBM);
	u66->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u67 = (TExecuteCommand*) WATER_CF.GetCommand("u67",TCommand::kUpdate,TCommand::kCode);
	u67->SetExecutable(&WATER_CF_u67_exe_g);
	u67->Code() = "u67 <- SL::Min(WAT_STRESS_HIGH, WAT_STRESS_LOW)";
	u67->AddDependency(WAT_STRESS_HIGH);
	u67->AddDependency(WAT_STRESS_LOW);
	u67->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u68 = (TExecuteCommand*) WAT_STRESS_HIGH.GetCommand("u68",TCommand::kUpdate,TCommand::kCode);
	u68->SetExecutable(&WAT_STRESS_HIGH_u68_exe_g);
	u68->Code() = "u68 <-  ( ( ( ( P1_W_T_MAX <  ((float)0) ) && ( SURFACE_WATER >  -P1_W_T_MAX ) ) ) ? ( SL::Max(((float)0), ( ((float)1)/( ((float)1)+SL::Exp(( SURFACE_WATER+P1_W_T_MAX )) ) )) ) : (  ( ( ( ( P1_W_T_MAX >  ((float)0) ) && ( ROOT_DEPTH >  ((float)0) ) ) ) ? ( SL::Min(((float)1), ( ( UW_DEPTH/ROOT_DEPTH )/P1_W_T_MAX )) ) : ( ((float)1) ) )  ) ) ";
	u68->AddDependency(HABITATMAP);
	u68->AddDependency(P1_W_T_MAX);
	u68->AddDependency(SURFACE_WATER);
	u68->AddDependency(ROOT_DEPTH);
	u68->AddDependency(UW_DEPTH);
	u68->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u69 = (TExecuteCommand*) WAT_STRESS_LOW.GetCommand("u69",TCommand::kUpdate,TCommand::kCode);
	u69->SetExecutable(&WAT_STRESS_LOW_u69_exe_g);
	u69->Code() = "u69 <- pow((double)SL::Sin(( ( WATER_AVAIL*3.141590 )/2 )),(double)P1_W_T_MIN )";
	u69->AddDependency(WATER_AVAIL);
	u69->AddDependency(HABITATMAP);
	u69->AddDependency(P1_W_T_MIN);
	u69->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u70 = (TExecuteCommand*) P1_BIO_END.GetCommand("u70",TCommand::kUpdate,TCommand::kCode);
	u70->SetExecutable(&P1_BIO_END_u70_exe_g);
	u70->Code() = "u70 <- ((float)570)";
	u70->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u71 = (TExecuteCommand*) P1_BIO_REPRO.GetCommand("u71",TCommand::kUpdate,TCommand::kCode);
	u71->SetExecutable(&P1_BIO_REPRO_u71_exe_g);
	u71->Code() = "u71 <- ((float)1700)";
	u71->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u72 = (TExecuteCommand*) P1_BIO_START.GetCommand("u72",TCommand::kUpdate,TCommand::kCode);
	u72->SetExecutable(&P1_BIO_START_u72_exe_g);
	u72->Code() = "u72 <- ((float)500)";
	u72->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u73 = (TExecuteCommand*) P1_DAYLENG_RQ.GetCommand("u73",TCommand::kUpdate,TCommand::kCode);
	u73->SetExecutable(&P1_DAYLENG_RQ_u73_exe_g);
	u73->Code() = "u73 <- ((float)13)";
	u73->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u74 = (TExecuteCommand*) P1_EST_HEIGHT.GetCommand("u74",TCommand::kUpdate,TCommand::kCode);
	u74->SetExecutable(&P1_EST_HEIGHT_u74_exe_g);
	u74->Code() = "u74 <- ((float)500)";
	u74->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u75 = (TExecuteCommand*) P1_H_DAY.GetCommand("u75",TCommand::kUpdate,TCommand::kCode);
	u75->SetExecutable(&P1_H_DAY_u75_exe_g);
	u75->Code() = "u75 <- ((float)319)";
	u75->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u76 = (TExecuteCommand*) P1_LIGHTSAT.GetCommand("u76",TCommand::kUpdate,TCommand::kCode);
	u76->SetExecutable(&P1_LIGHTSAT_u76_exe_g);
	u76->Code() = "u76 <- ((float)600)";
	u76->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u77 = (TExecuteCommand*) P1_MAC_KS_N.GetCommand("u77",TCommand::kUpdate,TCommand::kCode);
	u77->SetExecutable(&P1_MAC_KS_N_u77_exe_g);
	u77->Code() = "u77 <- 0.00265";
	u77->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u78 = (TExecuteCommand*) P1_MAC_KS_P.GetCommand("u78",TCommand::kUpdate,TCommand::kCode);
	u78->SetExecutable(&P1_MAC_KS_P_u78_exe_g);
	u78->Code() = "u78 <- 0.000037";
	u78->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u79 = (TExecuteCommand*) P1_MAX_AB_BM.GetCommand("u79",TCommand::kUpdate,TCommand::kCode);
	u79->SetExecutable(&P1_MAX_AB_BM_u79_exe_g);
	u79->Code() = "u79 <- 0.6";
	u79->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u80 = (TExecuteCommand*) P1_MAX_DENS.GetCommand("u80",TCommand::kUpdate,TCommand::kCode);
	u80->SetExecutable(&P1_MAX_DENS_u80_exe_g);
	u80->Code() = "u80 <- ((float)40)";
	u80->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u81 = (TExecuteCommand*) P1_MAX_HT_BM.GetCommand("u81",TCommand::kUpdate,TCommand::kCode);
	u81->SetExecutable(&P1_MAX_HT_BM_u81_exe_g);
	u81->Code() = "u81 <- 0.8";
	u81->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u82 = (TExecuteCommand*) P1_MAX_LAI.GetCommand("u82",TCommand::kUpdate,TCommand::kCode);
	u82->SetExecutable(&P1_MAX_LAI_u82_exe_g);
	u82->Code() = "u82 <- ((float)5)";
	u82->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u83 = (TExecuteCommand*) P1_MAX_PH_ABBM.GetCommand("u83",TCommand::kUpdate,TCommand::kCode);
	u83->SetExecutable(&P1_MAX_PH_ABBM_u83_exe_g);
	u83->Code() = "u83 <- 0.75";
	u83->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u84 = (TExecuteCommand*) P1_NPH_ABBM_IC.GetCommand("u84",TCommand::kUpdate,TCommand::kCode);
	u84->SetExecutable(&P1_NPH_ABBM_IC_u84_exe_g);
	u84->Code() = "u84 <- ((float)0)";
	u84->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u85 = (TExecuteCommand*) P1_NPH_AB_BEL.GetCommand("u85",TCommand::kUpdate,TCommand::kCode);
	u85->SetExecutable(&P1_NPH_AB_BEL_u85_exe_g);
	u85->Code() = "u85 <- 0.7";
	u85->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u86 = (TExecuteCommand*) P1_NPH_MORT.GetCommand("u86",TCommand::kUpdate,TCommand::kCode);
	u86->SetExecutable(&P1_NPH_MORT_u86_exe_g);
	u86->Code() = "u86 <- 0.00000053";
	u86->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u87 = (TExecuteCommand*) P1_NPH_PR_H.GetCommand("u87",TCommand::kUpdate,TCommand::kCode);
	u87->SetExecutable(&P1_NPH_PR_H_u87_exe_g);
	u87->Code() = "u87 <- 0.85";
	u87->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u88 = (TExecuteCommand*) P1_NPP.GetCommand("u88",TCommand::kUpdate,TCommand::kCode);
	u88->SetExecutable(&P1_NPP_u88_exe_g);
	u88->Code() = "u88 <- 0.25";
	u88->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u89 = (TExecuteCommand*) P1_PHB_C_REC.GetCommand("u89",TCommand::kUpdate,TCommand::kCode);
	u89->SetExecutable(&P1_PHB_C_REC_u89_exe_g);
	u89->Code() = "u89 <- ((float)0)";
	u89->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u90 = (TExecuteCommand*) P1_PHB_EVGRN.GetCommand("u90",TCommand::kUpdate,TCommand::kCode);
	u90->SetExecutable(&P1_PHB_EVGRN_u90_exe_g);
	u90->Code() = "u90 <- ((float)0)";
	u90->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u91 = (TExecuteCommand*) P1_PHB_L_RT.GetCommand("u91",TCommand::kUpdate,TCommand::kCode);
	u91->SetExecutable(&P1_PHB_L_RT_u91_exe_g);
	u91->Code() = "u91 <- ((float)0)";
	u91->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u92 = (TExecuteCommand*) P1_PHB_MORT.GetCommand("u92",TCommand::kUpdate,TCommand::kCode);
	u92->SetExecutable(&P1_PHB_MORT_u92_exe_g);
	u92->Code() = "u92 <- ((float)0)";
	u92->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u93 = (TExecuteCommand*) P1_PHB_PR_H.GetCommand("u93",TCommand::kUpdate,TCommand::kCode);
	u93->SetExecutable(&P1_PHB_PR_H_u93_exe_g);
	u93->Code() = "u93 <- 0.8";
	u93->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u94 = (TExecuteCommand*) P1_PH_TO_REP.GetCommand("u94",TCommand::kUpdate,TCommand::kCode);
	u94->SetExecutable(&P1_PH_TO_REP_u94_exe_g);
	u94->Code() = "u94 <- 0.005";
	u94->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u95 = (TExecuteCommand*) P1_PROP_LA_TO_B.GetCommand("u95",TCommand::kUpdate,TCommand::kCode);
	u95->SetExecutable(&P1_PROP_LA_TO_B_u95_exe_g);
	u95->Code() = "u95 <- ((float)12)";
	u95->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u96 = (TExecuteCommand*) P1_P_DAY.GetCommand("u96",TCommand::kUpdate,TCommand::kCode);
	u96->SetExecutable(&P1_P_DAY_u96_exe_g);
	u96->Code() = "u96 <- ((float)191)";
	u96->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u97 = (TExecuteCommand*) P1_P_RATIO.GetCommand("u97",TCommand::kUpdate,TCommand::kCode);
	u97->SetExecutable(&P1_P_RATIO_u97_exe_g);
	u97->Code() = "u97 <- ((float)0)";
	u97->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u98 = (TExecuteCommand*) P1_P_WT.GetCommand("u98",TCommand::kUpdate,TCommand::kCode);
	u98->SetExecutable(&P1_P_WT_u98_exe_g);
	u98->Code() = "u98 <- 0.0009";
	u98->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u99 = (TExecuteCommand*) P1_ROOT_DENS.GetCommand("u99",TCommand::kUpdate,TCommand::kCode);
	u99->SetExecutable(&P1_ROOT_DENS_u99_exe_g);
	u99->Code() = "u99 <- ((float)11)";
	u99->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u100 = (TExecuteCommand*) P1_SPR_RATE.GetCommand("u100",TCommand::kUpdate,TCommand::kCode);
	u100->SetExecutable(&P1_SPR_RATE_u100_exe_g);
	u100->Code() = "u100 <- 0.01";
	u100->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u101 = (TExecuteCommand*) P1_TEMPOPT.GetCommand("u101",TCommand::kUpdate,TCommand::kCode);
	u101->SetExecutable(&P1_TEMPOPT_u101_exe_g);
	u101->Code() = "u101 <- ((float)25)";
	u101->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u102 = (TExecuteCommand*) P1_W_T_MAX.GetCommand("u102",TCommand::kUpdate,TCommand::kCode);
	u102->SetExecutable(&P1_W_T_MAX_u102_exe_g);
	u102->Code() = "u102 <- 0.1";
	u102->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u103 = (TExecuteCommand*) P1_W_T_MIN.GetCommand("u103",TCommand::kUpdate,TCommand::kCode);
	u103->SetExecutable(&P1_W_T_MIN_u103_exe_g);
	u103->Code() = "u103 <- 0.2";
	u103->SetObjInfo(TCommand::kDepIndex, 5);
	return 0;
}

int MACROPHYTES_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int MACROPHYTES_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int MACROPHYTES_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int MACROPHYTES_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class XXXIMPORTS5_module 
// ---------------------------------------------------------------------------
XXXIMPORTS5_module::XXXIMPORTS5_module(char* name) :
	TIME("TIME"),
	SOLRADGR("SOLRADGR"),
	CELL_SIZE("CELL_SIZE"),
	DAYJUL("DAYJUL"),
	ELEVATION("ELEVATION"),
	HABITATMAP("HABITATMAP"),
	P1_DATUM_TO_MSL("P1_DATUM_TO_MSL"),
	P1_DEPTH_MSL_MAP("P1_DEPTH_MSL_MAP"),
	P1_ELEV_MSL_MAP("P1_ELEV_MSL_MAP"),
	AIR_TEMP_C("AIR_TEMP_C"),
	DAYLENGTH("DAYLENGTH"),
	DIN_AVAILABLE("DIN_AVAILABLE"),
	SATW_FROM_PRECIP("SATW_FROM_PRECIP"),
	SATW_OUTFLUX("SATW_OUTFLUX"),
	SATW_TO_SW_UPFLOW("SATW_TO_SW_UPFLOW"),
	SAT_WATER("SAT_WATER"),
	SURFACE_WATER("SURFACE_WATER"),
	SW_FROM_PRECIP("SW_FROM_PRECIP"),
	SW_OUTFLUX("SW_OUTFLUX"),
	SW_TO_SATW_DOWNFLOW("SW_TO_SATW_DOWNFLOW"),
	UNSAT_WATER("UNSAT_WATER"),
	UW_DEPTH("UW_DEPTH"),
	UW_FROM_PRECIP("UW_FROM_PRECIP"),
	WATER_AVAIL("WATER_AVAIL"),
	TModule(name) {

	SOLRADGR.SetF(FisExport,True,"CG");
}	
int XXXIMPORTS5_module::CELL_SIZE_u104_exe() {
	float value;

	switch( CELL_SIZE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CELL_SIZE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)40000);
			CELL_SIZE.Update( p, CELL_SIZE.ParameterValue(value,p) );
		}
		CELL_SIZE.GrabMemory();
		if( CELL_SIZE.GetF(FLinkEdges) ) { CELL_SIZE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)40000);
			CELL_SIZE.Update( CELL_SIZE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS5_module::DAYJUL_u105_exe() {
	float value;

	switch( DAYJUL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DAYJUL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SL::Mod(( TIME.Value()-dT() ), ((float)365))+((float)1) );
			DAYJUL.Update( p, value );
		}
		DAYJUL.GrabMemory();
		if( DAYJUL.GetF(FLinkEdges) ) { DAYJUL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SL::Mod(( TIME.Value()-dT() ), ((float)365))+((float)1) );
			DAYJUL.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS5_module::ELEVATION_u106_exe() {
	float value;

	switch( ELEVATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ELEVATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( P1_DEPTH_MSL_MAP.Value(p) >  ((float)0) ) ) ? ( ( P1_DATUM_TO_MSL.Value(p)-P1_DEPTH_MSL_MAP.Value(p) ) ) : ( ( P1_ELEV_MSL_MAP.Value(p)+P1_DATUM_TO_MSL.Value(p) ) ) ) ;
			ELEVATION.Update( p, value );
		}
		ELEVATION.GrabMemory();
		if( ELEVATION.GetF(FLinkEdges) ) { ELEVATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( P1_DEPTH_MSL_MAP.Value() >  ((float)0) ) ) ? ( ( P1_DATUM_TO_MSL.Value()-P1_DEPTH_MSL_MAP.Value() ) ) : ( ( P1_ELEV_MSL_MAP.Value()+P1_DATUM_TO_MSL.Value() ) ) ) ;
			ELEVATION.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS5_module::HABITATMAP_u107_exe() {
	float value;

	switch( HABITATMAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HABITATMAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)3);
			HABITATMAP.Update( p, HABITATMAP.ParameterValue(value,p) );
		}
		HABITATMAP.GrabMemory();
		if( HABITATMAP.GetF(FLinkEdges) ) { HABITATMAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)3);
			HABITATMAP.Update( HABITATMAP.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS5_module::P1_DATUM_TO_MSL_u108_exe() {
	float value;

	switch( P1_DATUM_TO_MSL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DATUM_TO_MSL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)30);
			P1_DATUM_TO_MSL.Update( p, P1_DATUM_TO_MSL.ParameterValue(value,p) );
		}
		P1_DATUM_TO_MSL.GrabMemory();
		if( P1_DATUM_TO_MSL.GetF(FLinkEdges) ) { P1_DATUM_TO_MSL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)30);
			P1_DATUM_TO_MSL.Update( P1_DATUM_TO_MSL.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS5_module::P1_DEPTH_MSL_MAP_u109_exe() {
	float value;

	switch( P1_DEPTH_MSL_MAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DEPTH_MSL_MAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_DEPTH_MSL_MAP.Update( p, P1_DEPTH_MSL_MAP.ParameterValue(value,p) );
		}
		P1_DEPTH_MSL_MAP.GrabMemory();
		if( P1_DEPTH_MSL_MAP.GetF(FLinkEdges) ) { P1_DEPTH_MSL_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_DEPTH_MSL_MAP.Update( P1_DEPTH_MSL_MAP.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS5_module::P1_ELEV_MSL_MAP_u110_exe() {
	float value;

	switch( P1_ELEV_MSL_MAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_ELEV_MSL_MAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)30);
			P1_ELEV_MSL_MAP.Update( p, P1_ELEV_MSL_MAP.ParameterValue(value,p) );
		}
		P1_ELEV_MSL_MAP.GrabMemory();
		if( P1_ELEV_MSL_MAP.GetF(FLinkEdges) ) { P1_ELEV_MSL_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)30);
			P1_ELEV_MSL_MAP.Update( P1_ELEV_MSL_MAP.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS5_module::AIR_TEMP_C_u111_exe() {
	float value;

	switch( AIR_TEMP_C.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = AIR_TEMP_C.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph1(DAYJUL.Value(p));
			AIR_TEMP_C.Update( p, value );
		}
		AIR_TEMP_C.GrabMemory();
		if( AIR_TEMP_C.GetF(FLinkEdges) ) { AIR_TEMP_C.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph1(DAYJUL.Value());
			AIR_TEMP_C.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS5_module::DAYLENGTH_u112_exe() {
	float value;

	switch( DAYLENGTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DAYLENGTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph2(DAYJUL.Value(p));
			DAYLENGTH.Update( p, value );
		}
		DAYLENGTH.GrabMemory();
		if( DAYLENGTH.GetF(FLinkEdges) ) { DAYLENGTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph2(DAYJUL.Value());
			DAYLENGTH.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS5_module::DIN_AVAILABLE_u113_exe() {
	float value;

	switch( DIN_AVAILABLE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_AVAILABLE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph3(DAYJUL.Value(p));
			DIN_AVAILABLE.Update( p, value );
		}
		DIN_AVAILABLE.GrabMemory();
		if( DIN_AVAILABLE.GetF(FLinkEdges) ) { DIN_AVAILABLE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph3(DAYJUL.Value());
			DIN_AVAILABLE.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS5_module::SATW_FROM_PRECIP_u114_exe() {
	float value;

	switch( SATW_FROM_PRECIP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_FROM_PRECIP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph4(DAYJUL.Value(p));
			SATW_FROM_PRECIP.Update( p, value );
		}
		SATW_FROM_PRECIP.GrabMemory();
		if( SATW_FROM_PRECIP.GetF(FLinkEdges) ) { SATW_FROM_PRECIP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph4(DAYJUL.Value());
			SATW_FROM_PRECIP.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS5_module::SATW_OUTFLUX_u115_exe() {
	float value;

	switch( SATW_OUTFLUX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_OUTFLUX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph5(DAYJUL.Value(p));
			SATW_OUTFLUX.Update( p, value );
		}
		SATW_OUTFLUX.GrabMemory();
		if( SATW_OUTFLUX.GetF(FLinkEdges) ) { SATW_OUTFLUX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph5(DAYJUL.Value());
			SATW_OUTFLUX.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS5_module::SATW_TO_SW_UPFLOW_u116_exe() {
	float value;

	switch( SATW_TO_SW_UPFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_TO_SW_UPFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph6(DAYJUL.Value(p));
			SATW_TO_SW_UPFLOW.Update( p, value );
		}
		SATW_TO_SW_UPFLOW.GrabMemory();
		if( SATW_TO_SW_UPFLOW.GetF(FLinkEdges) ) { SATW_TO_SW_UPFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph6(DAYJUL.Value());
			SATW_TO_SW_UPFLOW.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS5_module::SAT_WATER_u117_exe() {
	float value;

	switch( SAT_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SAT_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph7(DAYJUL.Value(p));
			SAT_WATER.Update( p, value );
		}
		SAT_WATER.GrabMemory();
		if( SAT_WATER.GetF(FLinkEdges) ) { SAT_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph7(DAYJUL.Value());
			SAT_WATER.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS5_module::SOLRADGR_u118_exe() {
	float value;

	switch( SOLRADGR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SOLRADGR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph8(DAYJUL.Value(p));
			SOLRADGR.Update( p, value );
		}
		SOLRADGR.GrabMemory();
		if( SOLRADGR.GetF(FLinkEdges) ) { SOLRADGR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph8(DAYJUL.Value());
			SOLRADGR.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS5_module::SURFACE_WATER_u119_exe() {
	float value;

	switch( SURFACE_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SURFACE_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph9(DAYJUL.Value(p));
			SURFACE_WATER.Update( p, value );
		}
		SURFACE_WATER.GrabMemory();
		if( SURFACE_WATER.GetF(FLinkEdges) ) { SURFACE_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph9(DAYJUL.Value());
			SURFACE_WATER.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS5_module::SW_FROM_PRECIP_u120_exe() {
	float value;

	switch( SW_FROM_PRECIP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_FROM_PRECIP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph10(DAYJUL.Value(p));
			SW_FROM_PRECIP.Update( p, value );
		}
		SW_FROM_PRECIP.GrabMemory();
		if( SW_FROM_PRECIP.GetF(FLinkEdges) ) { SW_FROM_PRECIP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph10(DAYJUL.Value());
			SW_FROM_PRECIP.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS5_module::SW_OUTFLUX_u121_exe() {
	float value;

	switch( SW_OUTFLUX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_OUTFLUX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph11(DAYJUL.Value(p));
			SW_OUTFLUX.Update( p, value );
		}
		SW_OUTFLUX.GrabMemory();
		if( SW_OUTFLUX.GetF(FLinkEdges) ) { SW_OUTFLUX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph11(DAYJUL.Value());
			SW_OUTFLUX.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS5_module::SW_TO_SATW_DOWNFLOW_u122_exe() {
	float value;

	switch( SW_TO_SATW_DOWNFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_TO_SATW_DOWNFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph12(DAYJUL.Value(p));
			SW_TO_SATW_DOWNFLOW.Update( p, value );
		}
		SW_TO_SATW_DOWNFLOW.GrabMemory();
		if( SW_TO_SATW_DOWNFLOW.GetF(FLinkEdges) ) { SW_TO_SATW_DOWNFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph12(DAYJUL.Value());
			SW_TO_SATW_DOWNFLOW.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS5_module::UNSAT_WATER_u123_exe() {
	float value;

	switch( UNSAT_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UNSAT_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph13(DAYJUL.Value(p));
			UNSAT_WATER.Update( p, value );
		}
		UNSAT_WATER.GrabMemory();
		if( UNSAT_WATER.GetF(FLinkEdges) ) { UNSAT_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph13(DAYJUL.Value());
			UNSAT_WATER.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS5_module::UW_DEPTH_u124_exe() {
	float value;

	switch( UW_DEPTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_DEPTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph14(DAYJUL.Value(p));
			UW_DEPTH.Update( p, value );
		}
		UW_DEPTH.GrabMemory();
		if( UW_DEPTH.GetF(FLinkEdges) ) { UW_DEPTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph14(DAYJUL.Value());
			UW_DEPTH.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS5_module::UW_FROM_PRECIP_u125_exe() {
	float value;

	switch( UW_FROM_PRECIP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_FROM_PRECIP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph15(DAYJUL.Value(p));
			UW_FROM_PRECIP.Update( p, value );
		}
		UW_FROM_PRECIP.GrabMemory();
		if( UW_FROM_PRECIP.GetF(FLinkEdges) ) { UW_FROM_PRECIP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph15(DAYJUL.Value());
			UW_FROM_PRECIP.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS5_module::WATER_AVAIL_u126_exe() {
	float value;

	switch( WATER_AVAIL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WATER_AVAIL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph16(DAYJUL.Value(p));
			WATER_AVAIL.Update( p, value );
		}
		WATER_AVAIL.GrabMemory();
		if( WATER_AVAIL.GetF(FLinkEdges) ) { WATER_AVAIL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph16(DAYJUL.Value());
			WATER_AVAIL.Update( value );
	  } break;
	}
	return 0;
}

XXXIMPORTS5_module* XXXIMPORTS5_module::fInstance = NULL;
XXXIMPORTS5_module* XXXIMPORTS5_module::kNullModel = (XXXIMPORTS5_module*)0x1;
int XXXIMPORTS5_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int XXXIMPORTS5_module::InitVars() {
	
	TIME.SSInit(this);
	SOLRADGR.SSInit(this);
	CELL_SIZE.SSInit(this);
	DAYJUL.SSInit(this);
	ELEVATION.SSInit(this);
	HABITATMAP.SSInit(this);
	P1_DATUM_TO_MSL.SSInit(this);
	P1_DEPTH_MSL_MAP.SSInit(this);
	P1_ELEV_MSL_MAP.SSInit(this);
	AIR_TEMP_C.SSInit(this);
	DAYLENGTH.SSInit(this);
	DIN_AVAILABLE.SSInit(this);
	SATW_FROM_PRECIP.SSInit(this);
	SATW_OUTFLUX.SSInit(this);
	SATW_TO_SW_UPFLOW.SSInit(this);
	SAT_WATER.SSInit(this);
	SURFACE_WATER.SSInit(this);
	SW_FROM_PRECIP.SSInit(this);
	SW_OUTFLUX.SSInit(this);
	SW_TO_SATW_DOWNFLOW.SSInit(this);
	UNSAT_WATER.SSInit(this);
	UW_DEPTH.SSInit(this);
	UW_FROM_PRECIP.SSInit(this);
	WATER_AVAIL.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int XXXIMPORTS5_module::SetupEvents() {
	TExecuteCommand* u118 = (TExecuteCommand*) SOLRADGR.GetCommand("u118",TCommand::kUpdate,TCommand::kCode);
	u118->SetExecutable(&SOLRADGR_u118_exe_g);
	u118->Code() = "u118 <- Graph8(DAYJUL)";
	u118->AddDependency(DAYJUL);
	u118->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u104 = (TExecuteCommand*) CELL_SIZE.GetCommand("u104",TCommand::kUpdate,TCommand::kCode);
	u104->SetExecutable(&CELL_SIZE_u104_exe_g);
	u104->Code() = "u104 <- ((float)40000)";
	u104->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u105 = (TExecuteCommand*) DAYJUL.GetCommand("u105",TCommand::kUpdate,TCommand::kCode);
	u105->SetExecutable(&DAYJUL_u105_exe_g);
	u105->Code() = "u105 <- ( SL::Mod(( TIME-dT() ), ((float)365))+((float)1) )";
	u105->AddDependency(TIME);
	u105->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u106 = (TExecuteCommand*) ELEVATION.GetCommand("u106",TCommand::kUpdate,TCommand::kCode);
	u106->SetExecutable(&ELEVATION_u106_exe_g);
	u106->Code() = "u106 <-  ( ( ( P1_DEPTH_MSL_MAP >  ((float)0) ) ) ? ( ( P1_DATUM_TO_MSL-P1_DEPTH_MSL_MAP ) ) : ( ( P1_ELEV_MSL_MAP+P1_DATUM_TO_MSL ) ) ) ";
	u106->AddDependency(P1_DEPTH_MSL_MAP);
	u106->AddDependency(P1_DATUM_TO_MSL);
	u106->AddDependency(P1_ELEV_MSL_MAP);
	u106->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u107 = (TExecuteCommand*) HABITATMAP.GetCommand("u107",TCommand::kUpdate,TCommand::kCode);
	u107->SetExecutable(&HABITATMAP_u107_exe_g);
	u107->Code() = "u107 <- ((float)3)";
	u107->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u108 = (TExecuteCommand*) P1_DATUM_TO_MSL.GetCommand("u108",TCommand::kUpdate,TCommand::kCode);
	u108->SetExecutable(&P1_DATUM_TO_MSL_u108_exe_g);
	u108->Code() = "u108 <- ((float)30)";
	u108->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u109 = (TExecuteCommand*) P1_DEPTH_MSL_MAP.GetCommand("u109",TCommand::kUpdate,TCommand::kCode);
	u109->SetExecutable(&P1_DEPTH_MSL_MAP_u109_exe_g);
	u109->Code() = "u109 <- ((float)0)";
	u109->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u110 = (TExecuteCommand*) P1_ELEV_MSL_MAP.GetCommand("u110",TCommand::kUpdate,TCommand::kCode);
	u110->SetExecutable(&P1_ELEV_MSL_MAP_u110_exe_g);
	u110->Code() = "u110 <- ((float)30)";
	u110->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u111 = (TExecuteCommand*) AIR_TEMP_C.GetCommand("u111",TCommand::kUpdate,TCommand::kCode);
	u111->SetExecutable(&AIR_TEMP_C_u111_exe_g);
	u111->Code() = "u111 <- Graph1(DAYJUL)";
	u111->AddDependency(DAYJUL);
	u111->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u112 = (TExecuteCommand*) DAYLENGTH.GetCommand("u112",TCommand::kUpdate,TCommand::kCode);
	u112->SetExecutable(&DAYLENGTH_u112_exe_g);
	u112->Code() = "u112 <- Graph2(DAYJUL)";
	u112->AddDependency(DAYJUL);
	u112->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u113 = (TExecuteCommand*) DIN_AVAILABLE.GetCommand("u113",TCommand::kUpdate,TCommand::kCode);
	u113->SetExecutable(&DIN_AVAILABLE_u113_exe_g);
	u113->Code() = "u113 <- Graph3(DAYJUL)";
	u113->AddDependency(DAYJUL);
	u113->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u114 = (TExecuteCommand*) SATW_FROM_PRECIP.GetCommand("u114",TCommand::kUpdate,TCommand::kCode);
	u114->SetExecutable(&SATW_FROM_PRECIP_u114_exe_g);
	u114->Code() = "u114 <- Graph4(DAYJUL)";
	u114->AddDependency(DAYJUL);
	u114->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u115 = (TExecuteCommand*) SATW_OUTFLUX.GetCommand("u115",TCommand::kUpdate,TCommand::kCode);
	u115->SetExecutable(&SATW_OUTFLUX_u115_exe_g);
	u115->Code() = "u115 <- Graph5(DAYJUL)";
	u115->AddDependency(DAYJUL);
	u115->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u116 = (TExecuteCommand*) SATW_TO_SW_UPFLOW.GetCommand("u116",TCommand::kUpdate,TCommand::kCode);
	u116->SetExecutable(&SATW_TO_SW_UPFLOW_u116_exe_g);
	u116->Code() = "u116 <- Graph6(DAYJUL)";
	u116->AddDependency(DAYJUL);
	u116->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u117 = (TExecuteCommand*) SAT_WATER.GetCommand("u117",TCommand::kUpdate,TCommand::kCode);
	u117->SetExecutable(&SAT_WATER_u117_exe_g);
	u117->Code() = "u117 <- Graph7(DAYJUL)";
	u117->AddDependency(DAYJUL);
	u117->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u119 = (TExecuteCommand*) SURFACE_WATER.GetCommand("u119",TCommand::kUpdate,TCommand::kCode);
	u119->SetExecutable(&SURFACE_WATER_u119_exe_g);
	u119->Code() = "u119 <- Graph9(DAYJUL)";
	u119->AddDependency(DAYJUL);
	u119->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u120 = (TExecuteCommand*) SW_FROM_PRECIP.GetCommand("u120",TCommand::kUpdate,TCommand::kCode);
	u120->SetExecutable(&SW_FROM_PRECIP_u120_exe_g);
	u120->Code() = "u120 <- Graph10(DAYJUL)";
	u120->AddDependency(DAYJUL);
	u120->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u121 = (TExecuteCommand*) SW_OUTFLUX.GetCommand("u121",TCommand::kUpdate,TCommand::kCode);
	u121->SetExecutable(&SW_OUTFLUX_u121_exe_g);
	u121->Code() = "u121 <- Graph11(DAYJUL)";
	u121->AddDependency(DAYJUL);
	u121->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u122 = (TExecuteCommand*) SW_TO_SATW_DOWNFLOW.GetCommand("u122",TCommand::kUpdate,TCommand::kCode);
	u122->SetExecutable(&SW_TO_SATW_DOWNFLOW_u122_exe_g);
	u122->Code() = "u122 <- Graph12(DAYJUL)";
	u122->AddDependency(DAYJUL);
	u122->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u123 = (TExecuteCommand*) UNSAT_WATER.GetCommand("u123",TCommand::kUpdate,TCommand::kCode);
	u123->SetExecutable(&UNSAT_WATER_u123_exe_g);
	u123->Code() = "u123 <- Graph13(DAYJUL)";
	u123->AddDependency(DAYJUL);
	u123->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u124 = (TExecuteCommand*) UW_DEPTH.GetCommand("u124",TCommand::kUpdate,TCommand::kCode);
	u124->SetExecutable(&UW_DEPTH_u124_exe_g);
	u124->Code() = "u124 <- Graph14(DAYJUL)";
	u124->AddDependency(DAYJUL);
	u124->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u125 = (TExecuteCommand*) UW_FROM_PRECIP.GetCommand("u125",TCommand::kUpdate,TCommand::kCode);
	u125->SetExecutable(&UW_FROM_PRECIP_u125_exe_g);
	u125->Code() = "u125 <- Graph15(DAYJUL)";
	u125->AddDependency(DAYJUL);
	u125->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u126 = (TExecuteCommand*) WATER_AVAIL.GetCommand("u126",TCommand::kUpdate,TCommand::kCode);
	u126->SetExecutable(&WATER_AVAIL_u126_exe_g);
	u126->Code() = "u126 <- Graph16(DAYJUL)";
	u126->AddDependency(DAYJUL);
	u126->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int XXXIMPORTS5_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int XXXIMPORTS5_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int XXXIMPORTS5_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int XXXIMPORTS5_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class HYDROLOGY_module 
// ---------------------------------------------------------------------------
HYDROLOGY_module::HYDROLOGY_module(char* name) :
	TIME("TIME"),
	SURFACE_WATER("SURFACE_WATER"),
	UW_DEPTH("UW_DEPTH"),
	WATER_AVAIL("WATER_AVAIL"),
	ON_MAP("ON_MAP"),
	DIN_SD("DIN_SD"),
	HABITATMAP("HABITATMAP"),
	AIR_TEMP_C("AIR_TEMP_C"),
	PRECIP_M("PRECIP_M"),
	HYDRO("HYDRO"),
	ELEVATION("ELEVATION"),
	DIN_SF("DIN_SF"),
	CELL_SIZE("CELL_SIZE"),
	SOLRADGRD("SOLRADGRD"),
	MACLAI("MACLAI"),
	SOIL("SOIL"),
	HUMIDITY("HUMIDITY"),
	WIND("WIND"),
	ELEV_MIN("ELEV_MIN"),
	ETPM("ETPM"),
	ROOT_DEPTH("ROOT_DEPTH"),
	P1_DATUM_TO_MSL("P1_DATUM_TO_MSL"),
	P1_DEPTH_MSL_MAP("P1_DEPTH_MSL_MAP"),
	SAT_WATER("SAT_WATER"),
	UNSAT_WATER("UNSAT_WATER"),
	UW_FROM_PRECIP("UW_FROM_PRECIP"),
	SW_TO_SATW_DOWNFLOW("SW_TO_SATW_DOWNFLOW"),
	SATW_FROM_PRECIP("SATW_FROM_PRECIP"),
	SATW_TO_SW_UPFLOW("SATW_TO_SW_UPFLOW"),
	SATW_OUTFLUX("SATW_OUTFLUX"),
	SW_OUTFLUX("SW_OUTFLUX"),
	OUT_F_SF("OUT_F_SF"),
	UW_SATW_EXCHANGE("UW_SATW_EXCHANGE"),
	SATW_RECHARGE("SATW_RECHARGE"),
	SATW_TRANSP("SATW_TRANSP"),
	SATW_UW("SATW_UW"),
	SNOW_ICE("SNOW_ICE"),
	SNOWFALL("SNOWFALL"),
	SW_FREEZE("SW_FREEZE"),
	SNOWMELT("SNOWMELT"),
	SW_IN("SW_IN"),
	SW_EVAP("SW_EVAP"),
	TOT_IN("TOT_IN"),
	TOTAL_INFLOW("TOTAL_INFLOW"),
	TOT_OUT("TOT_OUT"),
	TOTAL_OUTFLOW("TOTAL_OUTFLOW"),
	UW_ETRANSP("UW_ETRANSP"),
	BALANCE("BALANCE"),
	EVAPORATION("EVAPORATION"),
	EVAP_UW("EVAP_UW"),
	H_CONDUCT("H_CONDUCT"),
	IC_SATW("IC_SATW"),
	IC_UW("IC_UW"),
	INFILTRATION("INFILTRATION"),
	INF_COND("INF_COND"),
	INTERCEPT("INTERCEPT"),
	NET_PRECIP("NET_PRECIP"),
	OUT_F_SD("OUT_F_SD"),
	PAN_CH("PAN_CH"),
	PAN_CT("PAN_CT"),
	PAN_CW("PAN_CW"),
	POROSITY("POROSITY"),
	POT_INFILTR("POT_INFILTR"),
	RAINFALL("RAINFALL"),
	SATWMAX("SATWMAX"),
	SATWRUNOFF("SATWRUNOFF"),
	SATW_HEAD("SATW_HEAD"),
	SW_FROM_PS("SW_FROM_PS"),
	TOTAL_OUT("TOTAL_OUT"),
	TOTAL_PRECIP("TOTAL_PRECIP"),
	TRANSPIRATION("TRANSPIRATION"),
	UNSAT_CAP("UNSAT_CAP"),
	UW_CAPIL_EXP("UW_CAPIL_EXP"),
	UW_DELTA("UW_DELTA"),
	UW_DEPTH_BEFORE("UW_DEPTH_BEFORE"),
	UW_EXCESS("UW_EXCESS"),
	UW_MOIST_PRP("UW_MOIST_PRP"),
	UW_MP_R("UW_MP_R"),
	UW_PERC_RATE("UW_PERC_RATE"),
	UW_TRANS_PR("UW_TRANS_PR"),
	WAT_TABLE("WAT_TABLE"),
	P1_C_EVAP("P1_C_EVAP"),
	P1_C_FIELD_CAP("P1_C_FIELD_CAP"),
	P1_C_HORIZ_HC("P1_C_HORIZ_HC"),
	P1_C_HORIZ_HYDR_COND("P1_C_HORIZ_HYDR_COND"),
	P1_C_INFILT("P1_C_INFILT"),
	P1_C_INF_HAB("P1_C_INF_HAB"),
	P1_C_INF_SLOPE("P1_C_INF_SLOPE"),
	P1_C_INF_SOIL("P1_C_INF_SOIL"),
	P1_C_INTERCEP("P1_C_INTERCEP"),
	P1_C_INTERCEPVEG("P1_C_INTERCEPVEG"),
	P1_C_POROSITY("P1_C_POROSITY"),
	P1_C_RECHG("P1_C_RECHG"),
	P1_C_SATW_OUT("P1_C_SATW_OUT"),
	P1_C_SW_MELT("P1_C_SW_MELT"),
	P1_C_SW_OUT("P1_C_SW_OUT"),
	P1_C_TRANSP("P1_C_TRANSP"),
	P1_C_UW_EVAP("P1_C_UW_EVAP"),
	P1_C_VERT_HYDR_COND("P1_C_VERT_HYDR_COND"),
	P1_C_ZIG("P1_C_ZIG"),
	P1_IC_SW_DEPTH("P1_IC_SW_DEPTH"),
	P1_IC_UW_MOIST_PR("P1_IC_UW_MOIST_PR"),
	P1_IC_WT_TABLE("P1_IC_WT_TABLE"),
	TModule(name) {

	SURFACE_WATER.SetF(FisExport,True,"CG");
	UW_DEPTH.SetF(FisExport,True,"CG");
	WATER_AVAIL.SetF(FisExport,True,"CG");
	ON_MAP.SetF(FisImport,True,"CG");
	DIN_SD.SetF(FisImport,True,"CG");
	HABITATMAP.SetF(FisImport,True,"CG");
	AIR_TEMP_C.SetF(FisImport,True,"CG");
	PRECIP_M.SetF(FisImport,True,"CG");
	HYDRO.SetF(FisImport,True,"CG");
	ELEVATION.SetF(FisImport,True,"CG");
	DIN_SF.SetF(FisImport,True,"CG");
	CELL_SIZE.SetF(FisImport,True,"CG");
	SOLRADGRD.SetF(FisImport,True,"CG");
	MACLAI.SetF(FisImport,True,"CG");
	SOIL.SetF(FisImport,True,"CG");
	HUMIDITY.SetF(FisImport,True,"CG");
	WIND.SetF(FisImport,True,"CG");
	ELEV_MIN.SetF(FisImport,True,"CG");
	ETPM.SetF(FisImport,True,"CG");
	ROOT_DEPTH.SetF(FisImport,True,"CG");
	P1_DATUM_TO_MSL.SetF(FisImport,True,"CG");
	P1_DEPTH_MSL_MAP.SetF(FisImport,True,"CG");
	SAT_WATER.SetF(FisExport,True,"CG");
	UNSAT_WATER.SetF(FisExport,True,"CG");
	UW_FROM_PRECIP.SetF(FisExport,True,"CG");
	SW_TO_SATW_DOWNFLOW.SetF(FisExport,True,"CG");
	SATW_FROM_PRECIP.SetF(FisExport,True,"CG");
	SATW_TO_SW_UPFLOW.SetF(FisExport,True,"CG");
	SATW_OUTFLUX.SetF(FisExport,True,"CG");
	SW_OUTFLUX.SetF(FisExport,True,"CG");
	OUT_F_SF.SetF(FisExport,True,"CG");
}	
int HYDROLOGY_module::SAT_WATER_I127_exe() {
	float value;

	SAT_WATER.UpdateIntegrator(0);
	switch( SAT_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SAT_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( ( ( UW_SATW_EXCHANGE.Value(p)+SW_TO_SATW_DOWNFLOW.Value(p) )+SATW_FROM_PRECIP.Value(p) )-SATW_RECHARGE.Value(p) )-SATW_TRANSP.Value(p) )-SATW_TO_SW_UPFLOW.Value(p) )-SATW_OUTFLUX.Value(p) )-SATW_UW.Value(p) );
			SAT_WATER.Update( p, value, dT() );
		}
		SAT_WATER.GrabMemory();
		if( SAT_WATER.GetF(FLinkEdges) ) { SAT_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( ( ( UW_SATW_EXCHANGE.Value()+SW_TO_SATW_DOWNFLOW.Value() )+SATW_FROM_PRECIP.Value() )-SATW_RECHARGE.Value() )-SATW_TRANSP.Value() )-SATW_TO_SW_UPFLOW.Value() )-SATW_OUTFLUX.Value() )-SATW_UW.Value() );
			SAT_WATER.Update( value, dT() );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SAT_WATER_i128_exe() {
	float value;

	SAT_WATER.UpdateIntegrator(1);
	switch( SAT_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SAT_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  IC_SATW.Value(p);
			SAT_WATER.InitValue( p, value );
		}
		SAT_WATER.GrabMemory();
		if( SAT_WATER.GetF(FLinkEdges) ) { SAT_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  IC_SATW.Value();
			SAT_WATER.InitValue( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SAT_WATER_vE436_exe() {
	float value;

			 GWTrans_I(SAT_WATER, POROSITY, H_CONDUCT, ON_MAP, DIN_SD, UNSAT_WATER, OUT_F_SD);
	SAT_WATER.UpdateReserve();
	return 0;
}

int HYDROLOGY_module::UW_SATW_EXCHANGE_u129_exe() {
	float value;

	switch( UW_SATW_EXCHANGE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_SATW_EXCHANGE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( INF_COND.Value(p) == ((float)0) ) ) ? ( ( UNSAT_WATER.Value(p)/dT() ) ) : ( SL::Min(( UNSAT_WATER.Value(p)/dT() ), ( ( SL::Max(((float)0), ( UW_DELTA.Value(p)*UW_MOIST_PRP.Value(p) ))/dT() )+UW_PERC_RATE.Value(p) )) ) ) ;
			UW_SATW_EXCHANGE.Update( p, value );
		}
		UW_SATW_EXCHANGE.GrabMemory();
		if( UW_SATW_EXCHANGE.GetF(FICFlux) ) UW_SATW_EXCHANGE.Cov().Set(0.0); 
		if( UW_SATW_EXCHANGE.GetF(FLinkEdges) ) { UW_SATW_EXCHANGE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( INF_COND.Value() == ((float)0) ) ) ? ( ( UNSAT_WATER.Value()/dT() ) ) : ( SL::Min(( UNSAT_WATER.Value()/dT() ), ( ( SL::Max(((float)0), ( UW_DELTA.Value()*UW_MOIST_PRP.Value() ))/dT() )+UW_PERC_RATE.Value() )) ) ) ;
			UW_SATW_EXCHANGE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SW_TO_SATW_DOWNFLOW_u130_exe() {
	float value;

	switch( SW_TO_SATW_DOWNFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_TO_SATW_DOWNFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( HABITATMAP.Value(p) == ((float)1) ) || ( ( UW_DEPTH_BEFORE.Value(p) == ((float)0) ) && ( UNSAT_CAP.Value(p) >  ((float)0) ) ) ) ) ? ( SL::Min(( UNSAT_CAP.Value(p)/dT() ), ( SURFACE_WATER.Value(p)/dT() )) ) : ( ((float)0) ) ) ;
			SW_TO_SATW_DOWNFLOW.Update( p, value );
		}
		SW_TO_SATW_DOWNFLOW.GrabMemory();
		if( SW_TO_SATW_DOWNFLOW.GetF(FICFlux) ) SW_TO_SATW_DOWNFLOW.Cov().Set(0.0); 
		if( SW_TO_SATW_DOWNFLOW.GetF(FLinkEdges) ) { SW_TO_SATW_DOWNFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( HABITATMAP.Value() == ((float)1) ) || ( ( UW_DEPTH_BEFORE.Value() == ((float)0) ) && ( UNSAT_CAP.Value() >  ((float)0) ) ) ) ) ? ( SL::Min(( UNSAT_CAP.Value()/dT() ), ( SURFACE_WATER.Value()/dT() )) ) : ( ((float)0) ) ) ;
			SW_TO_SATW_DOWNFLOW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATW_FROM_PRECIP_u131_exe() {
	float value;

	switch( SATW_FROM_PRECIP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_FROM_PRECIP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( INF_COND.Value(p) == ((float)0) ) ) ? ( ( ( UNSAT_CAP.Value(p)/dT() )-SW_TO_SATW_DOWNFLOW.Value(p) ) ) : ( ((float)0) ) ) ;
			SATW_FROM_PRECIP.Update( p, value );
		}
		SATW_FROM_PRECIP.GrabMemory();
		if( SATW_FROM_PRECIP.GetF(FICFlux) ) SATW_FROM_PRECIP.Cov().Set(0.0); 
		if( SATW_FROM_PRECIP.GetF(FLinkEdges) ) { SATW_FROM_PRECIP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( INF_COND.Value() == ((float)0) ) ) ? ( ( ( UNSAT_CAP.Value()/dT() )-SW_TO_SATW_DOWNFLOW.Value() ) ) : ( ((float)0) ) ) ;
			SATW_FROM_PRECIP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATW_RECHARGE_u132_exe() {
	float value;

	switch( SATW_RECHARGE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_RECHARGE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  P1_C_RECHG.Value(p);
			SATW_RECHARGE.Update( p, value );
		}
		SATW_RECHARGE.GrabMemory();
		if( SATW_RECHARGE.GetF(FICFlux) ) SATW_RECHARGE.Cov().Set(0.0); 
		if( SATW_RECHARGE.GetF(FLinkEdges) ) { SATW_RECHARGE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  P1_C_RECHG.Value();
			SATW_RECHARGE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATW_TRANSP_u133_exe() {
	float value;

	switch( SATW_TRANSP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_TRANSP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( TRANSPIRATION.Value(p)*( ((float)1)-UW_TRANS_PR.Value(p) ) );
			SATW_TRANSP.Update( p, value );
		}
		SATW_TRANSP.GrabMemory();
		if( SATW_TRANSP.GetF(FICFlux) ) SATW_TRANSP.Cov().Set(0.0); 
		if( SATW_TRANSP.GetF(FLinkEdges) ) { SATW_TRANSP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( TRANSPIRATION.Value()*( ((float)1)-UW_TRANS_PR.Value() ) );
			SATW_TRANSP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATW_TO_SW_UPFLOW_u134_exe() {
	float value;

	switch( SATW_TO_SW_UPFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_TO_SW_UPFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SAT_WATER.Value(p) >  SATWMAX.Value(p) ) ) ? ( ( SAT_WATER.Value(p)-SATWMAX.Value(p) ) ) : (  ( ( ( SAT_WATER.Value(p) >  SATWRUNOFF.Value(p) ) ) ? ( ( ( P1_C_ZIG.Value(p)*( SAT_WATER.Value(p)-SATWRUNOFF.Value(p) ) )*H_CONDUCT.Value(p) ) ) : ( ((float)0) ) )  ) ) ;
			SATW_TO_SW_UPFLOW.Update( p, value );
		}
		SATW_TO_SW_UPFLOW.GrabMemory();
		if( SATW_TO_SW_UPFLOW.GetF(FICFlux) ) SATW_TO_SW_UPFLOW.Cov().Set(0.0); 
		if( SATW_TO_SW_UPFLOW.GetF(FLinkEdges) ) { SATW_TO_SW_UPFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SAT_WATER.Value() >  SATWMAX.Value() ) ) ? ( ( SAT_WATER.Value()-SATWMAX.Value() ) ) : (  ( ( ( SAT_WATER.Value() >  SATWRUNOFF.Value() ) ) ? ( ( ( P1_C_ZIG.Value()*( SAT_WATER.Value()-SATWRUNOFF.Value() ) )*H_CONDUCT.Value() ) ) : ( ((float)0) ) )  ) ) ;
			SATW_TO_SW_UPFLOW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATW_OUTFLUX_u135_exe() {
	float value;

	switch( SATW_OUTFLUX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_OUTFLUX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_C_SATW_OUT.Value(p)*( SAT_WATER.Value(p)-IC_SATW.Value(p) ) );
			SATW_OUTFLUX.Update( p, value );
		}
		SATW_OUTFLUX.GrabMemory();
		if( SATW_OUTFLUX.GetF(FICFlux) ) SATW_OUTFLUX.Cov().Set(0.0); 
		if( SATW_OUTFLUX.GetF(FLinkEdges) ) { SATW_OUTFLUX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_C_SATW_OUT.Value()*( SAT_WATER.Value()-IC_SATW.Value() ) );
			SATW_OUTFLUX.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATW_UW_u136_exe() {
	float value;

	switch( SATW_UW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_UW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Max(((float)0), SL::Min(( -UW_DELTA.Value(p)*P1_C_FIELD_CAP.Value(p) ), ( SAT_WATER.Value(p)/dT() )));
			SATW_UW.Update( p, value );
		}
		SATW_UW.GrabMemory();
		if( SATW_UW.GetF(FICFlux) ) SATW_UW.Cov().Set(0.0); 
		if( SATW_UW.GetF(FLinkEdges) ) { SATW_UW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Max(((float)0), SL::Min(( -UW_DELTA.Value()*P1_C_FIELD_CAP.Value() ), ( SAT_WATER.Value()/dT() )));
			SATW_UW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SNOW_ICE_I137_exe() {
	float value;

	SNOW_ICE.UpdateIntegrator(0);
	switch( SNOW_ICE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SNOW_ICE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SNOWFALL.Value(p)+SW_FREEZE.Value(p) )-SNOWMELT.Value(p) );
			SNOW_ICE.Update( p, value, dT() );
		}
		SNOW_ICE.GrabMemory();
		if( SNOW_ICE.GetF(FLinkEdges) ) { SNOW_ICE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SNOWFALL.Value()+SW_FREEZE.Value() )-SNOWMELT.Value() );
			SNOW_ICE.Update( value, dT() );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SNOW_ICE_i138_exe() {
	float value;

	SNOW_ICE.UpdateIntegrator(1);
	switch( SNOW_ICE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SNOW_ICE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			SNOW_ICE.InitValue( p, value );
		}
		SNOW_ICE.GrabMemory();
		if( SNOW_ICE.GetF(FLinkEdges) ) { SNOW_ICE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			SNOW_ICE.InitValue( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SNOWFALL_u139_exe() {
	float value;

	switch( SNOWFALL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SNOWFALL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( AIR_TEMP_C.Value(p) <= ((float)0) ) ) ? ( PRECIP_M.Value(p) ) : ( ((float)0) ) ) ;
			SNOWFALL.Update( p, value );
		}
		SNOWFALL.GrabMemory();
		if( SNOWFALL.GetF(FICFlux) ) SNOWFALL.Cov().Set(0.0); 
		if( SNOWFALL.GetF(FLinkEdges) ) { SNOWFALL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( AIR_TEMP_C.Value() <= ((float)0) ) ) ? ( PRECIP_M.Value() ) : ( ((float)0) ) ) ;
			SNOWFALL.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SW_FREEZE_u140_exe() {
	float value;

	switch( SW_FREEZE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_FREEZE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( AIR_TEMP_C.Value(p) >  ((float)0) ) ) ? ( ((float)0) ) : ( ( ( -AIR_TEMP_C.Value(p)*SURFACE_WATER.Value(p) )*P1_C_SW_MELT.Value(p) ) ) ) ;
			SW_FREEZE.Update( p, value );
		}
		SW_FREEZE.GrabMemory();
		if( SW_FREEZE.GetF(FICFlux) ) SW_FREEZE.Cov().Set(0.0); 
		if( SW_FREEZE.GetF(FLinkEdges) ) { SW_FREEZE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( AIR_TEMP_C.Value() >  ((float)0) ) ) ? ( ((float)0) ) : ( ( ( -AIR_TEMP_C.Value()*SURFACE_WATER.Value() )*P1_C_SW_MELT.Value() ) ) ) ;
			SW_FREEZE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SNOWMELT_u141_exe() {
	float value;

	switch( SNOWMELT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SNOWMELT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( AIR_TEMP_C.Value(p) >  ((float)0) ) ) ? ( SL::Min(( P1_C_SW_MELT.Value(p)*AIR_TEMP_C.Value(p) ), ( SNOW_ICE.Value(p)/dT() )) ) : ( ((float)0) ) ) ;
			SNOWMELT.Update( p, value );
		}
		SNOWMELT.GrabMemory();
		if( SNOWMELT.GetF(FICFlux) ) SNOWMELT.Cov().Set(0.0); 
		if( SNOWMELT.GetF(FLinkEdges) ) { SNOWMELT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( AIR_TEMP_C.Value() >  ((float)0) ) ) ? ( SL::Min(( P1_C_SW_MELT.Value()*AIR_TEMP_C.Value() ), ( SNOW_ICE.Value()/dT() )) ) : ( ((float)0) ) ) ;
			SNOWMELT.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SURFACE_WATER_I142_exe() {
	float value;

	SURFACE_WATER.UpdateIntegrator(0);
	switch( SURFACE_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SURFACE_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( SW_IN.Value(p)+SATW_TO_SW_UPFLOW.Value(p) )-SW_EVAP.Value(p) )-SW_TO_SATW_DOWNFLOW.Value(p) )-SW_FREEZE.Value(p) )-SW_OUTFLUX.Value(p) );
			SURFACE_WATER.Update( p, value, dT() );
		}
		SURFACE_WATER.GrabMemory();
		if( SURFACE_WATER.GetF(FLinkEdges) ) { SURFACE_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( SW_IN.Value()+SATW_TO_SW_UPFLOW.Value() )-SW_EVAP.Value() )-SW_TO_SATW_DOWNFLOW.Value() )-SW_FREEZE.Value() )-SW_OUTFLUX.Value() );
			SURFACE_WATER.Update( value, dT() );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SURFACE_WATER_i143_exe() {
	float value;

	SURFACE_WATER.UpdateIntegrator(1);
	switch( SURFACE_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SURFACE_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  P1_IC_SW_DEPTH.Value(p);
			SURFACE_WATER.InitValue( p, value );
		}
		SURFACE_WATER.GrabMemory();
		if( SURFACE_WATER.GetF(FLinkEdges) ) { SURFACE_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  P1_IC_SW_DEPTH.Value();
			SURFACE_WATER.InitValue( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SURFACE_WATER_vE437_exe() {
	float value;

			 SWTransport4(SURFACE_WATER, HYDRO, HABITATMAP, ELEVATION, DIN_SF, OUT_F_SF);
	SURFACE_WATER.UpdateReserve();
	return 0;
}

int HYDROLOGY_module::SW_IN_u144_exe() {
	float value;

	switch( SW_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( NET_PRECIP.Value(p)-UW_FROM_PRECIP.Value(p) )-SATW_FROM_PRECIP.Value(p) )+( SW_FROM_PS.Value(p)/CELL_SIZE.Value(p) ) );
			SW_IN.Update( p, value );
		}
		SW_IN.GrabMemory();
		if( SW_IN.GetF(FICFlux) ) SW_IN.Cov().Set(0.0); 
		if( SW_IN.GetF(FLinkEdges) ) { SW_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( NET_PRECIP.Value()-UW_FROM_PRECIP.Value() )-SATW_FROM_PRECIP.Value() )+( SW_FROM_PS.Value()/CELL_SIZE.Value() ) );
			SW_IN.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SW_EVAP_u145_exe() {
	float value;

	switch( SW_EVAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_EVAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(SL::Max(EVAPORATION.Value(p), ((float)0)), ( SURFACE_WATER.Value(p)/dT() ));
			SW_EVAP.Update( p, value );
		}
		SW_EVAP.GrabMemory();
		if( SW_EVAP.GetF(FICFlux) ) SW_EVAP.Cov().Set(0.0); 
		if( SW_EVAP.GetF(FLinkEdges) ) { SW_EVAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(SL::Max(EVAPORATION.Value(), ((float)0)), ( SURFACE_WATER.Value()/dT() ));
			SW_EVAP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SW_OUTFLUX_u146_exe() {
	float value;

	switch( SW_OUTFLUX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_OUTFLUX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_C_SW_OUT.Value(p)*SURFACE_WATER.Value(p) )/dT() );
			SW_OUTFLUX.Update( p, value );
		}
		SW_OUTFLUX.GrabMemory();
		if( SW_OUTFLUX.GetF(FICFlux) ) SW_OUTFLUX.Cov().Set(0.0); 
		if( SW_OUTFLUX.GetF(FLinkEdges) ) { SW_OUTFLUX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_C_SW_OUT.Value()*SURFACE_WATER.Value() )/dT() );
			SW_OUTFLUX.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOT_IN_I147_exe() {
	float value;

	TOT_IN.UpdateIntegrator(0);
	switch( TOT_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOT_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  TOTAL_INFLOW.Value(p);
			TOT_IN.Update( p, value, dT() );
		}
		TOT_IN.GrabMemory();
		if( TOT_IN.GetF(FLinkEdges) ) { TOT_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  TOTAL_INFLOW.Value();
			TOT_IN.Update( value, dT() );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOT_IN_i148_exe() {
	float value;

	TOT_IN.UpdateIntegrator(1);
	switch( TOT_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOT_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			TOT_IN.InitValue( p, value );
		}
		TOT_IN.GrabMemory();
		if( TOT_IN.GetF(FLinkEdges) ) { TOT_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			TOT_IN.InitValue( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOTAL_INFLOW_u149_exe() {
	float value;

	switch( TOTAL_INFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOTAL_INFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PRECIP_M.Value(p)+( SW_FROM_PS.Value(p)/CELL_SIZE.Value(p) ) );
			TOTAL_INFLOW.Update( p, value );
		}
		TOTAL_INFLOW.GrabMemory();
		if( TOTAL_INFLOW.GetF(FICFlux) ) TOTAL_INFLOW.Cov().Set(0.0); 
		if( TOTAL_INFLOW.GetF(FLinkEdges) ) { TOTAL_INFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PRECIP_M.Value()+( SW_FROM_PS.Value()/CELL_SIZE.Value() ) );
			TOTAL_INFLOW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOT_OUT_I150_exe() {
	float value;

	TOT_OUT.UpdateIntegrator(0);
	switch( TOT_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOT_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  TOTAL_OUTFLOW.Value(p);
			TOT_OUT.Update( p, value, dT() );
		}
		TOT_OUT.GrabMemory();
		if( TOT_OUT.GetF(FLinkEdges) ) { TOT_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  TOTAL_OUTFLOW.Value();
			TOT_OUT.Update( value, dT() );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOT_OUT_i151_exe() {
	float value;

	TOT_OUT.UpdateIntegrator(1);
	switch( TOT_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOT_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			TOT_OUT.InitValue( p, value );
		}
		TOT_OUT.GrabMemory();
		if( TOT_OUT.GetF(FLinkEdges) ) { TOT_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			TOT_OUT.InitValue( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOTAL_OUTFLOW_u152_exe() {
	float value;

	switch( TOTAL_OUTFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOTAL_OUTFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  TOTAL_OUT.Value(p);
			TOTAL_OUTFLOW.Update( p, value );
		}
		TOTAL_OUTFLOW.GrabMemory();
		if( TOTAL_OUTFLOW.GetF(FICFlux) ) TOTAL_OUTFLOW.Cov().Set(0.0); 
		if( TOTAL_OUTFLOW.GetF(FLinkEdges) ) { TOTAL_OUTFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  TOTAL_OUT.Value();
			TOTAL_OUTFLOW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UNSAT_WATER_I153_exe() {
	float value;

	UNSAT_WATER.UpdateIntegrator(0);
	switch( UNSAT_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UNSAT_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( UW_FROM_PRECIP.Value(p)+SATW_UW.Value(p) )-UW_SATW_EXCHANGE.Value(p) )-UW_ETRANSP.Value(p) );
			UNSAT_WATER.Update( p, value, dT() );
		}
		UNSAT_WATER.GrabMemory();
		if( UNSAT_WATER.GetF(FLinkEdges) ) { UNSAT_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( UW_FROM_PRECIP.Value()+SATW_UW.Value() )-UW_SATW_EXCHANGE.Value() )-UW_ETRANSP.Value() );
			UNSAT_WATER.Update( value, dT() );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UNSAT_WATER_i154_exe() {
	float value;

	UNSAT_WATER.UpdateIntegrator(1);
	switch( UNSAT_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UNSAT_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  IC_UW.Value(p);
			UNSAT_WATER.InitValue( p, value );
		}
		UNSAT_WATER.GrabMemory();
		if( UNSAT_WATER.GetF(FLinkEdges) ) { UNSAT_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  IC_UW.Value();
			UNSAT_WATER.InitValue( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_FROM_PRECIP_u155_exe() {
	float value;

	switch( UW_FROM_PRECIP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_FROM_PRECIP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( INF_COND.Value(p) >  ((float)0) ) ) ? ( INFILTRATION.Value(p) ) : ( ((float)0) ) ) ;
			UW_FROM_PRECIP.Update( p, value );
		}
		UW_FROM_PRECIP.GrabMemory();
		if( UW_FROM_PRECIP.GetF(FICFlux) ) UW_FROM_PRECIP.Cov().Set(0.0); 
		if( UW_FROM_PRECIP.GetF(FLinkEdges) ) { UW_FROM_PRECIP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( INF_COND.Value() >  ((float)0) ) ) ? ( INFILTRATION.Value() ) : ( ((float)0) ) ) ;
			UW_FROM_PRECIP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_ETRANSP_u156_exe() {
	float value;

	switch( UW_ETRANSP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_ETRANSP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( TRANSPIRATION.Value(p)*UW_TRANS_PR.Value(p) )+EVAP_UW.Value(p) );
			UW_ETRANSP.Update( p, value );
		}
		UW_ETRANSP.GrabMemory();
		if( UW_ETRANSP.GetF(FICFlux) ) UW_ETRANSP.Cov().Set(0.0); 
		if( UW_ETRANSP.GetF(FLinkEdges) ) { UW_ETRANSP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( TRANSPIRATION.Value()*UW_TRANS_PR.Value() )+EVAP_UW.Value() );
			UW_ETRANSP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::BALANCE_u157_exe() {
	float value;

	switch( BALANCE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = BALANCE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( SAT_WATER.Value(p)+SNOW_ICE.Value(p) )+SURFACE_WATER.Value(p) )+UNSAT_WATER.Value(p) )-TOT_IN.Value(p) )+TOT_OUT.Value(p) );
			BALANCE.Update( p, value );
		}
		BALANCE.GrabMemory();
		if( BALANCE.GetF(FLinkEdges) ) { BALANCE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( SAT_WATER.Value()+SNOW_ICE.Value() )+SURFACE_WATER.Value() )+UNSAT_WATER.Value() )-TOT_IN.Value() )+TOT_OUT.Value() );
			BALANCE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::EVAPORATION_u158_exe() {
	float value;

	switch( EVAPORATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EVAPORATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( P1_C_EVAP.Value(p)*SOLRADGRD.Value(p) )/585 )*PAN_CW.Value(p) )*PAN_CT.Value(p) )*PAN_CH.Value(p) );
			EVAPORATION.Update( p, value );
		}
		EVAPORATION.GrabMemory();
		if( EVAPORATION.GetF(FLinkEdges) ) { EVAPORATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( P1_C_EVAP.Value()*SOLRADGRD.Value() )/585 )*PAN_CW.Value() )*PAN_CT.Value() )*PAN_CH.Value() );
			EVAPORATION.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::EVAP_UW_u159_exe() {
	float value;

	switch( EVAP_UW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EVAP_UW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( P1_C_UW_EVAP.Value(p)*EVAPORATION.Value(p) )*( ((float)1)-SL::Min(((float)1), MACLAI.Value(p)) ) )*UW_MP_R.Value(p) );
			EVAP_UW.Update( p, value );
		}
		EVAP_UW.GrabMemory();
		if( EVAP_UW.GetF(FLinkEdges) ) { EVAP_UW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( P1_C_UW_EVAP.Value()*EVAPORATION.Value() )*( ((float)1)-SL::Min(((float)1), MACLAI.Value()) ) )*UW_MP_R.Value() );
			EVAP_UW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::H_CONDUCT_u160_exe() {
	float value;

	switch( H_CONDUCT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = H_CONDUCT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( P1_C_HORIZ_HC.Value(p)*P1_C_HORIZ_HYDR_COND.Value(p) )/SL::Sqrt(CELL_SIZE.Value(p)) )+( SOIL.Value(p)*0.0 ) );
			H_CONDUCT.Update( p, value );
		}
		H_CONDUCT.GrabMemory();
		if( H_CONDUCT.GetF(FLinkEdges) ) { H_CONDUCT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( P1_C_HORIZ_HC.Value()*P1_C_HORIZ_HYDR_COND.Value() )/SL::Sqrt(CELL_SIZE.Value()) )+( SOIL.Value()*0.0 ) );
			H_CONDUCT.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::IC_SATW_u161_exe() {
	float value;

	switch( IC_SATW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = IC_SATW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( WAT_TABLE.Value(p)*P1_C_POROSITY.Value(p) );
			IC_SATW.Update( p, value );
		}
		IC_SATW.GrabMemory();
		if( IC_SATW.GetF(FLinkEdges) ) { IC_SATW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( WAT_TABLE.Value()*P1_C_POROSITY.Value() );
			IC_SATW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::IC_UW_u162_exe() {
	float value;

	switch( IC_UW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = IC_UW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ELEVATION.Value(p) >  WAT_TABLE.Value(p) ) ) ? ( ( ( ELEVATION.Value(p)-WAT_TABLE.Value(p) )*P1_IC_UW_MOIST_PR.Value(p) ) ) : ( ((float)0) ) ) ;
			IC_UW.Update( p, value );
		}
		IC_UW.GrabMemory();
		if( IC_UW.GetF(FLinkEdges) ) { IC_UW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ELEVATION.Value() >  WAT_TABLE.Value() ) ) ? ( ( ( ELEVATION.Value()-WAT_TABLE.Value() )*P1_IC_UW_MOIST_PR.Value() ) ) : ( ((float)0) ) ) ;
			IC_UW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::INFILTRATION_u163_exe() {
	float value;

	switch( INFILTRATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = INFILTRATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(POT_INFILTR.Value(p), NET_PRECIP.Value(p));
			INFILTRATION.Update( p, value );
		}
		INFILTRATION.GrabMemory();
		if( INFILTRATION.GetF(FLinkEdges) ) { INFILTRATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(POT_INFILTR.Value(), NET_PRECIP.Value());
			INFILTRATION.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::INF_COND_u164_exe() {
	float value;

	switch( INF_COND.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = INF_COND.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( SW_TO_SATW_DOWNFLOW.Value(p)*dT() ) == UNSAT_CAP.Value(p) ) ) ? ( ((float)0) ) : ( SL::Max(( UNSAT_CAP.Value(p)-( INFILTRATION.Value(p)*dT() ) ), ((float)0)) ) ) ;
			INF_COND.Update( p, value );
		}
		INF_COND.GrabMemory();
		if( INF_COND.GetF(FLinkEdges) ) { INF_COND.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( SW_TO_SATW_DOWNFLOW.Value()*dT() ) == UNSAT_CAP.Value() ) ) ? ( ((float)0) ) : ( SL::Max(( UNSAT_CAP.Value()-( INFILTRATION.Value()*dT() ) ), ((float)0)) ) ) ;
			INF_COND.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::INTERCEPT_u165_exe() {
	float value;

	switch( INTERCEPT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = INTERCEPT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(TOTAL_PRECIP.Value(p), SL::Max(( P1_C_INTERCEP.Value(p)*TOTAL_PRECIP.Value(p) ), ( P1_C_INTERCEPVEG.Value(p)*MACLAI.Value(p) )));
			INTERCEPT.Update( p, value );
		}
		INTERCEPT.GrabMemory();
		if( INTERCEPT.GetF(FLinkEdges) ) { INTERCEPT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(TOTAL_PRECIP.Value(), SL::Max(( P1_C_INTERCEP.Value()*TOTAL_PRECIP.Value() ), ( P1_C_INTERCEPVEG.Value()*MACLAI.Value() )));
			INTERCEPT.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::NET_PRECIP_u166_exe() {
	float value;

	switch( NET_PRECIP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NET_PRECIP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( TOTAL_PRECIP.Value(p)-INTERCEPT.Value(p) );
			NET_PRECIP.Update( p, value );
		}
		NET_PRECIP.GrabMemory();
		if( NET_PRECIP.GetF(FLinkEdges) ) { NET_PRECIP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( TOTAL_PRECIP.Value()-INTERCEPT.Value() );
			NET_PRECIP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::OUT_F_SD_u167_exe() {
	float value;

	switch( OUT_F_SD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = OUT_F_SD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			OUT_F_SD.Update( p, value );
		}
		OUT_F_SD.GrabMemory();
		if( OUT_F_SD.GetF(FLinkEdges) ) { OUT_F_SD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			OUT_F_SD.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::OUT_F_SF_u168_exe() {
	float value;

	switch( OUT_F_SF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = OUT_F_SF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			OUT_F_SF.Update( p, value );
		}
		OUT_F_SF.GrabMemory();
		if( OUT_F_SF.GetF(FLinkEdges) ) { OUT_F_SF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			OUT_F_SF.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::PAN_CH_u169_exe() {
	float value;

	switch( PAN_CH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PAN_CH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( 1.035+( 0.240*pow((double)( HUMIDITY.Value(p)/60 ),(double)((float)2) ) ) )-( 0.275*pow((double)( HUMIDITY.Value(p)/60 ),(double)((float)3) ) ) );
			PAN_CH.Update( p, value );
		}
		PAN_CH.GrabMemory();
		if( PAN_CH.GetF(FLinkEdges) ) { PAN_CH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( 1.035+( 0.240*pow((double)( HUMIDITY.Value()/60 ),(double)((float)2) ) ) )-( 0.275*pow((double)( HUMIDITY.Value()/60 ),(double)((float)3) ) ) );
			PAN_CH.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::PAN_CT_u170_exe() {
	float value;

	switch( PAN_CT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PAN_CT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( AIR_TEMP_C.Value(p) >  -((float)30) ) ) ? ( ( ( 0.463+( 0.425*( AIR_TEMP_C.Value(p)/20 ) ) )+( 0.112*pow((double)( AIR_TEMP_C.Value(p)/20 ),(double)((float)2) ) ) ) ) : ( ((float)0) ) ) ;
			PAN_CT.Update( p, value );
		}
		PAN_CT.GrabMemory();
		if( PAN_CT.GetF(FLinkEdges) ) { PAN_CT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( AIR_TEMP_C.Value() >  -((float)30) ) ) ? ( ( ( 0.463+( 0.425*( AIR_TEMP_C.Value()/20 ) ) )+( 0.112*pow((double)( AIR_TEMP_C.Value()/20 ),(double)((float)2) ) ) ) ) : ( ((float)0) ) ) ;
			PAN_CT.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::PAN_CW_u171_exe() {
	float value;

	switch( PAN_CW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PAN_CW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( 0.672+( 0.406*( WIND.Value(p)/6.7 ) ) )+( 0.078*pow((double)( WIND.Value(p)/6.7 ),(double)((float)2) ) ) );
			PAN_CW.Update( p, value );
		}
		PAN_CW.GrabMemory();
		if( PAN_CW.GetF(FLinkEdges) ) { PAN_CW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( 0.672+( 0.406*( WIND.Value()/6.7 ) ) )+( 0.078*pow((double)( WIND.Value()/6.7 ),(double)((float)2) ) ) );
			PAN_CW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::POROSITY_u172_exe() {
	float value;

	switch( POROSITY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = POROSITY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_C_POROSITY.Value(p)+( SOIL.Value(p)*0.0 ) );
			POROSITY.Update( p, value );
		}
		POROSITY.GrabMemory();
		if( POROSITY.GetF(FLinkEdges) ) { POROSITY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_C_POROSITY.Value()+( SOIL.Value()*0.0 ) );
			POROSITY.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::POT_INFILTR_u173_exe() {
	float value;

	switch( POT_INFILTR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = POT_INFILTR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( P1_C_INFILT.Value(p)*P1_C_INF_HAB.Value(p) )*P1_C_INF_SOIL.Value(p) )/ ( ( ( P1_C_INF_SLOPE.Value(p) >  ((float)0) ) ) ? ( P1_C_INF_SOIL.Value(p) ) : ( ((float)1) ) )  );
			POT_INFILTR.Update( p, value );
		}
		POT_INFILTR.GrabMemory();
		if( POT_INFILTR.GetF(FLinkEdges) ) { POT_INFILTR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( P1_C_INFILT.Value()*P1_C_INF_HAB.Value() )*P1_C_INF_SOIL.Value() )/ ( ( ( P1_C_INF_SLOPE.Value() >  ((float)0) ) ) ? ( P1_C_INF_SOIL.Value() ) : ( ((float)1) ) )  );
			POT_INFILTR.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::POT_INFILTR_v438_exe() {
	float value;

			 Infilt(POT_INFILTR, PRECIP_M, PRECIP_M, PRECIP_M, PRECIP_M, PRECIP_M);
	return 0;
}

int HYDROLOGY_module::RAINFALL_u174_exe() {
	float value;

	switch( RAINFALL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = RAINFALL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( AIR_TEMP_C.Value(p) >  ((float)0) ) ) ? ( PRECIP_M.Value(p) ) : ( ((float)0) ) ) ;
			RAINFALL.Update( p, value );
		}
		RAINFALL.GrabMemory();
		if( RAINFALL.GetF(FLinkEdges) ) { RAINFALL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( AIR_TEMP_C.Value() >  ((float)0) ) ) ? ( PRECIP_M.Value() ) : ( ((float)0) ) ) ;
			RAINFALL.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATWMAX_u175_exe() {
	float value;

	switch( SATWMAX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATWMAX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ELEVATION.Value(p)*P1_C_POROSITY.Value(p) );
			SATWMAX.Update( p, value );
		}
		SATWMAX.GrabMemory();
		if( SATWMAX.GetF(FLinkEdges) ) { SATWMAX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ELEVATION.Value()*P1_C_POROSITY.Value() );
			SATWMAX.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATWRUNOFF_u176_exe() {
	float value;

	switch( SATWRUNOFF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATWRUNOFF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ELEV_MIN.Value(p)*P1_C_POROSITY.Value(p) );
			SATWRUNOFF.Update( p, value );
		}
		SATWRUNOFF.GrabMemory();
		if( SATWRUNOFF.GetF(FLinkEdges) ) { SATWRUNOFF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ELEV_MIN.Value()*P1_C_POROSITY.Value() );
			SATWRUNOFF.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATW_HEAD_u177_exe() {
	float value;

	switch( SATW_HEAD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_HEAD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SAT_WATER.Value(p)/P1_C_POROSITY.Value(p) );
			SATW_HEAD.Update( p, value );
		}
		SATW_HEAD.GrabMemory();
		if( SATW_HEAD.GetF(FLinkEdges) ) { SATW_HEAD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SAT_WATER.Value()/P1_C_POROSITY.Value() );
			SATW_HEAD.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SW_FROM_PS_u178_exe() {
	float value;

	switch( SW_FROM_PS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_FROM_PS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0;
			SW_FROM_PS.Update( p, SW_FROM_PS.ParameterValue(value,p) );
		}
		SW_FROM_PS.GrabMemory();
		if( SW_FROM_PS.GetF(FLinkEdges) ) { SW_FROM_PS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0;
			SW_FROM_PS.Update( SW_FROM_PS.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOTAL_OUT_u179_exe() {
	float value;

	switch( TOTAL_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOTAL_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( ( INTERCEPT.Value(p)+SATW_OUTFLUX.Value(p) )+SATW_RECHARGE.Value(p) )+SATW_TRANSP.Value(p) )+SW_EVAP.Value(p) )+SW_OUTFLUX.Value(p) )+UW_ETRANSP.Value(p) );
			TOTAL_OUT.Update( p, value );
		}
		TOTAL_OUT.GrabMemory();
		if( TOTAL_OUT.GetF(FLinkEdges) ) { TOTAL_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( ( INTERCEPT.Value()+SATW_OUTFLUX.Value() )+SATW_RECHARGE.Value() )+SATW_TRANSP.Value() )+SW_EVAP.Value() )+SW_OUTFLUX.Value() )+UW_ETRANSP.Value() );
			TOTAL_OUT.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOTAL_PRECIP_u180_exe() {
	float value;

	switch( TOTAL_PRECIP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOTAL_PRECIP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( RAINFALL.Value(p)+SNOWMELT.Value(p) );
			TOTAL_PRECIP.Update( p, value );
		}
		TOTAL_PRECIP.GrabMemory();
		if( TOTAL_PRECIP.GetF(FLinkEdges) ) { TOTAL_PRECIP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( RAINFALL.Value()+SNOWMELT.Value() );
			TOTAL_PRECIP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TRANSPIRATION_u181_exe() {
	float value;

	switch( TRANSPIRATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TRANSPIRATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( P1_C_TRANSP.Value(p)*SL::Min(((float)1), MACLAI.Value(p)) )*ETPM.Value(p) )*WATER_AVAIL.Value(p) );
			TRANSPIRATION.Update( p, value );
		}
		TRANSPIRATION.GrabMemory();
		if( TRANSPIRATION.GetF(FLinkEdges) ) { TRANSPIRATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( P1_C_TRANSP.Value()*SL::Min(((float)1), MACLAI.Value()) )*ETPM.Value() )*WATER_AVAIL.Value() );
			TRANSPIRATION.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UNSAT_CAP_u182_exe() {
	float value;

	switch( UNSAT_CAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UNSAT_CAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Max(( UW_DEPTH.Value(p)*( P1_C_POROSITY.Value(p)-UW_MOIST_PRP.Value(p) ) ), ((float)0));
			UNSAT_CAP.Update( p, value );
		}
		UNSAT_CAP.GrabMemory();
		if( UNSAT_CAP.GetF(FLinkEdges) ) { UNSAT_CAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Max(( UW_DEPTH.Value()*( P1_C_POROSITY.Value()-UW_MOIST_PRP.Value() ) ), ((float)0));
			UNSAT_CAP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_CAPIL_EXP_u183_exe() {
	float value;

	switch( UW_CAPIL_EXP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_CAPIL_EXP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Exp(( -((float)10)*SL::Max(( UW_DEPTH.Value(p)-ROOT_DEPTH.Value(p) ), ((float)0)) ));
			UW_CAPIL_EXP.Update( p, value );
		}
		UW_CAPIL_EXP.GrabMemory();
		if( UW_CAPIL_EXP.GetF(FLinkEdges) ) { UW_CAPIL_EXP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Exp(( -((float)10)*SL::Max(( UW_DEPTH.Value()-ROOT_DEPTH.Value() ), ((float)0)) ));
			UW_CAPIL_EXP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_DELTA_u184_exe() {
	float value;

	switch( UW_DELTA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_DELTA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( UW_DEPTH_BEFORE.Value(p)-UW_DEPTH.Value(p) );
			UW_DELTA.Update( p, value );
		}
		UW_DELTA.GrabMemory();
		if( UW_DELTA.GetF(FLinkEdges) ) { UW_DELTA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( UW_DEPTH_BEFORE.Value()-UW_DEPTH.Value() );
			UW_DELTA.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_DEPTH_u185_exe() {
	float value;

	switch( UW_DEPTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_DEPTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Max(( ELEVATION.Value(p)-SATW_HEAD.Value(p) ), ((float)0));
			UW_DEPTH.Update( p, value );
		}
		UW_DEPTH.GrabMemory();
		UW_DEPTH.UpdateDelayData();
		if( UW_DEPTH.GetF(FLinkEdges) ) { UW_DEPTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Max(( ELEVATION.Value()-SATW_HEAD.Value() ), ((float)0));
			UW_DEPTH.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_DEPTH_BEFORE_u186_exe() {
	float value;

	switch( UW_DEPTH_BEFORE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_DEPTH_BEFORE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  UW_DEPTH.Delay(  p, dT() );
			UW_DEPTH_BEFORE.Update( p, value );
		}
		UW_DEPTH_BEFORE.GrabMemory();
		if( UW_DEPTH_BEFORE.GetF(FLinkEdges) ) { UW_DEPTH_BEFORE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  UW_DEPTH.Delay( dT() );
			UW_DEPTH_BEFORE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_EXCESS_u187_exe() {
	float value;

	switch( UW_EXCESS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_EXCESS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Max(((float)0), ( UW_MOIST_PRP.Value(p)-P1_C_FIELD_CAP.Value(p) ));
			UW_EXCESS.Update( p, value );
		}
		UW_EXCESS.GrabMemory();
		if( UW_EXCESS.GetF(FLinkEdges) ) { UW_EXCESS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Max(((float)0), ( UW_MOIST_PRP.Value()-P1_C_FIELD_CAP.Value() ));
			UW_EXCESS.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_MOIST_PRP_u188_exe() {
	float value;

	switch( UW_MOIST_PRP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_MOIST_PRP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( UW_DEPTH.Value(p) >  ((float)0) ) ) ? ( ( UNSAT_WATER.Value(p)/UW_DEPTH.Value(p) ) ) : ( ((float)0) ) ) ;
			UW_MOIST_PRP.Update( p, value );
		}
		UW_MOIST_PRP.GrabMemory();
		if( UW_MOIST_PRP.GetF(FLinkEdges) ) { UW_MOIST_PRP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( UW_DEPTH.Value() >  ((float)0) ) ) ? ( ( UNSAT_WATER.Value()/UW_DEPTH.Value() ) ) : ( ((float)0) ) ) ;
			UW_MOIST_PRP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_MP_R_u189_exe() {
	float value;

	switch( UW_MP_R.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_MP_R.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( UW_MOIST_PRP.Value(p)/P1_C_POROSITY.Value(p) );
			UW_MP_R.Update( p, value );
		}
		UW_MP_R.GrabMemory();
		if( UW_MP_R.GetF(FLinkEdges) ) { UW_MP_R.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( UW_MOIST_PRP.Value()/P1_C_POROSITY.Value() );
			UW_MP_R.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_PERC_RATE_u190_exe() {
	float value;

	switch( UW_PERC_RATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_PERC_RATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ((float)2)*P1_C_VERT_HYDR_COND.Value(p) )*P1_C_POROSITY.Value(p) )*pow((double)UW_EXCESS.Value(p),(double)0.4 ) )/( pow((double)( P1_C_POROSITY.Value(p)-P1_C_FIELD_CAP.Value(p) ),(double)0.4 )+pow((double)UW_EXCESS.Value(p),(double)0.4 ) ) );
			UW_PERC_RATE.Update( p, value );
		}
		UW_PERC_RATE.GrabMemory();
		if( UW_PERC_RATE.GetF(FLinkEdges) ) { UW_PERC_RATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ((float)2)*P1_C_VERT_HYDR_COND.Value() )*P1_C_POROSITY.Value() )*pow((double)UW_EXCESS.Value(),(double)0.4 ) )/( pow((double)( P1_C_POROSITY.Value()-P1_C_FIELD_CAP.Value() ),(double)0.4 )+pow((double)UW_EXCESS.Value(),(double)0.4 ) ) );
			UW_PERC_RATE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_TRANS_PR_u191_exe() {
	float value;

	switch( UW_TRANS_PR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_TRANS_PR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( ROOT_DEPTH.Value(p)+0.1 ) <  UW_DEPTH.Value(p) ) ) ? ( ((float)1) ) : (  ( ( ( UW_DEPTH.Value(p) >  ((float)0) ) ) ? ( ( WATER_AVAIL.Value(p)*( UW_DEPTH.Value(p)/( ROOT_DEPTH.Value(p)+UW_CAPIL_EXP.Value(p) ) ) ) ) : ( ((float)0) ) )  ) ) ;
			UW_TRANS_PR.Update( p, value );
		}
		UW_TRANS_PR.GrabMemory();
		if( UW_TRANS_PR.GetF(FLinkEdges) ) { UW_TRANS_PR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( ROOT_DEPTH.Value()+0.1 ) <  UW_DEPTH.Value() ) ) ? ( ((float)1) ) : (  ( ( ( UW_DEPTH.Value() >  ((float)0) ) ) ? ( ( WATER_AVAIL.Value()*( UW_DEPTH.Value()/( ROOT_DEPTH.Value()+UW_CAPIL_EXP.Value() ) ) ) ) : ( ((float)0) ) )  ) ) ;
			UW_TRANS_PR.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::WATER_AVAIL_u192_exe() {
	float value;

	switch( WATER_AVAIL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WATER_AVAIL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(1.0, ( UW_CAPIL_EXP.Value(p)+ ( ( ( UW_MOIST_PRP.Value(p) <  ( 0.1*P1_C_FIELD_CAP.Value(p) ) ) ) ? ( ((float)0) ) : (  ( ( ( UW_MOIST_PRP.Value(p) >  ( 0.6*P1_C_FIELD_CAP.Value(p) ) ) ) ? ( ((float)1) ) : ( ( ( ( UW_MOIST_PRP.Value(p)-( 0.1*P1_C_FIELD_CAP.Value(p) ) )/0.5 )/P1_C_FIELD_CAP.Value(p) ) ) )  ) )  ));
			WATER_AVAIL.Update( p, value );
		}
		WATER_AVAIL.GrabMemory();
		if( WATER_AVAIL.GetF(FLinkEdges) ) { WATER_AVAIL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(1.0, ( UW_CAPIL_EXP.Value()+ ( ( ( UW_MOIST_PRP.Value() <  ( 0.1*P1_C_FIELD_CAP.Value() ) ) ) ? ( ((float)0) ) : (  ( ( ( UW_MOIST_PRP.Value() >  ( 0.6*P1_C_FIELD_CAP.Value() ) ) ) ? ( ((float)1) ) : ( ( ( ( UW_MOIST_PRP.Value()-( 0.1*P1_C_FIELD_CAP.Value() ) )/0.5 )/P1_C_FIELD_CAP.Value() ) ) )  ) )  ));
			WATER_AVAIL.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::WAT_TABLE_u193_exe() {
	float value;

	switch( WAT_TABLE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WAT_TABLE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_IC_WT_TABLE.Value(p)+P1_DATUM_TO_MSL.Value(p) )-P1_DEPTH_MSL_MAP.Value(p) );
			WAT_TABLE.Update( p, value );
		}
		WAT_TABLE.GrabMemory();
		if( WAT_TABLE.GetF(FLinkEdges) ) { WAT_TABLE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_IC_WT_TABLE.Value()+P1_DATUM_TO_MSL.Value() )-P1_DEPTH_MSL_MAP.Value() );
			WAT_TABLE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_EVAP_u194_exe() {
	float value;

	switch( P1_C_EVAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_EVAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000482;
			P1_C_EVAP.Update( p, value );
		}
		P1_C_EVAP.GrabMemory();
		if( P1_C_EVAP.GetF(FLinkEdges) ) { P1_C_EVAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000482;
			P1_C_EVAP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_FIELD_CAP_u195_exe() {
	float value;

	switch( P1_C_FIELD_CAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_FIELD_CAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.25;
			P1_C_FIELD_CAP.Update( p, value );
		}
		P1_C_FIELD_CAP.GrabMemory();
		if( P1_C_FIELD_CAP.GetF(FLinkEdges) ) { P1_C_FIELD_CAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.25;
			P1_C_FIELD_CAP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_HORIZ_HC_u196_exe() {
	float value;

	switch( P1_C_HORIZ_HC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_HORIZ_HC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.11;
			P1_C_HORIZ_HC.Update( p, P1_C_HORIZ_HC.ParameterValue(value,p) );
		}
		P1_C_HORIZ_HC.GrabMemory();
		if( P1_C_HORIZ_HC.GetF(FLinkEdges) ) { P1_C_HORIZ_HC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.11;
			P1_C_HORIZ_HC.Update( P1_C_HORIZ_HC.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_HORIZ_HYDR_COND_u197_exe() {
	float value;

	switch( P1_C_HORIZ_HYDR_COND.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_HORIZ_HYDR_COND.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)5);
			P1_C_HORIZ_HYDR_COND.Update( p, value );
		}
		P1_C_HORIZ_HYDR_COND.GrabMemory();
		if( P1_C_HORIZ_HYDR_COND.GetF(FLinkEdges) ) { P1_C_HORIZ_HYDR_COND.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)5);
			P1_C_HORIZ_HYDR_COND.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_INFILT_u198_exe() {
	float value;

	switch( P1_C_INFILT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_INFILT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.06;
			P1_C_INFILT.Update( p, P1_C_INFILT.ParameterValue(value,p) );
		}
		P1_C_INFILT.GrabMemory();
		if( P1_C_INFILT.GetF(FLinkEdges) ) { P1_C_INFILT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.06;
			P1_C_INFILT.Update( P1_C_INFILT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_INF_HAB_u199_exe() {
	float value;

	switch( P1_C_INF_HAB.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_INF_HAB.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			P1_C_INF_HAB.Update( p, value );
		}
		P1_C_INF_HAB.GrabMemory();
		if( P1_C_INF_HAB.GetF(FLinkEdges) ) { P1_C_INF_HAB.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			P1_C_INF_HAB.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_INF_SLOPE_u200_exe() {
	float value;

	switch( P1_C_INF_SLOPE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_INF_SLOPE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)5);
			P1_C_INF_SLOPE.Update( p, value );
		}
		P1_C_INF_SLOPE.GrabMemory();
		if( P1_C_INF_SLOPE.GetF(FLinkEdges) ) { P1_C_INF_SLOPE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)5);
			P1_C_INF_SLOPE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_INF_SOIL_u201_exe() {
	float value;

	switch( P1_C_INF_SOIL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_INF_SOIL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  4.00;
			P1_C_INF_SOIL.Update( p, value );
		}
		P1_C_INF_SOIL.GrabMemory();
		if( P1_C_INF_SOIL.GetF(FLinkEdges) ) { P1_C_INF_SOIL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  4.00;
			P1_C_INF_SOIL.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_INTERCEP_u202_exe() {
	float value;

	switch( P1_C_INTERCEP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_INTERCEP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.002;
			P1_C_INTERCEP.Update( p, value );
		}
		P1_C_INTERCEP.GrabMemory();
		if( P1_C_INTERCEP.GetF(FLinkEdges) ) { P1_C_INTERCEP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.002;
			P1_C_INTERCEP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_INTERCEPVEG_u203_exe() {
	float value;

	switch( P1_C_INTERCEPVEG.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_INTERCEPVEG.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.001;
			P1_C_INTERCEPVEG.Update( p, value );
		}
		P1_C_INTERCEPVEG.GrabMemory();
		if( P1_C_INTERCEPVEG.GetF(FLinkEdges) ) { P1_C_INTERCEPVEG.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.001;
			P1_C_INTERCEPVEG.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_POROSITY_u204_exe() {
	float value;

	switch( P1_C_POROSITY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_POROSITY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.41;
			P1_C_POROSITY.Update( p, value );
		}
		P1_C_POROSITY.GrabMemory();
		if( P1_C_POROSITY.GetF(FLinkEdges) ) { P1_C_POROSITY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.41;
			P1_C_POROSITY.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_RECHG_u205_exe() {
	float value;

	switch( P1_C_RECHG.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_RECHG.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.00001;
			P1_C_RECHG.Update( p, P1_C_RECHG.ParameterValue(value,p) );
		}
		P1_C_RECHG.GrabMemory();
		if( P1_C_RECHG.GetF(FLinkEdges) ) { P1_C_RECHG.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.00001;
			P1_C_RECHG.Update( P1_C_RECHG.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_SATW_OUT_u206_exe() {
	float value;

	switch( P1_C_SATW_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_SATW_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.;
			P1_C_SATW_OUT.Update( p, P1_C_SATW_OUT.ParameterValue(value,p) );
		}
		P1_C_SATW_OUT.GrabMemory();
		if( P1_C_SATW_OUT.GetF(FLinkEdges) ) { P1_C_SATW_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.;
			P1_C_SATW_OUT.Update( P1_C_SATW_OUT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_SW_MELT_u207_exe() {
	float value;

	switch( P1_C_SW_MELT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_SW_MELT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.005;
			P1_C_SW_MELT.Update( p, P1_C_SW_MELT.ParameterValue(value,p) );
		}
		P1_C_SW_MELT.GrabMemory();
		if( P1_C_SW_MELT.GetF(FLinkEdges) ) { P1_C_SW_MELT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.005;
			P1_C_SW_MELT.Update( P1_C_SW_MELT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_SW_OUT_u208_exe() {
	float value;

	switch( P1_C_SW_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_SW_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.;
			P1_C_SW_OUT.Update( p, P1_C_SW_OUT.ParameterValue(value,p) );
		}
		P1_C_SW_OUT.GrabMemory();
		if( P1_C_SW_OUT.GetF(FLinkEdges) ) { P1_C_SW_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.;
			P1_C_SW_OUT.Update( P1_C_SW_OUT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_TRANSP_u209_exe() {
	float value;

	switch( P1_C_TRANSP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_TRANSP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.5;
			P1_C_TRANSP.Update( p, value );
		}
		P1_C_TRANSP.GrabMemory();
		if( P1_C_TRANSP.GetF(FLinkEdges) ) { P1_C_TRANSP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.5;
			P1_C_TRANSP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_UW_EVAP_u210_exe() {
	float value;

	switch( P1_C_UW_EVAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_UW_EVAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.5;
			P1_C_UW_EVAP.Update( p, value );
		}
		P1_C_UW_EVAP.GrabMemory();
		if( P1_C_UW_EVAP.GetF(FLinkEdges) ) { P1_C_UW_EVAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.5;
			P1_C_UW_EVAP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_VERT_HYDR_COND_u211_exe() {
	float value;

	switch( P1_C_VERT_HYDR_COND.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_VERT_HYDR_COND.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.007;
			P1_C_VERT_HYDR_COND.Update( p, value );
		}
		P1_C_VERT_HYDR_COND.GrabMemory();
		if( P1_C_VERT_HYDR_COND.GetF(FLinkEdges) ) { P1_C_VERT_HYDR_COND.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.007;
			P1_C_VERT_HYDR_COND.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_ZIG_u212_exe() {
	float value;

	switch( P1_C_ZIG.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_ZIG.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)25);
			P1_C_ZIG.Update( p, value );
		}
		P1_C_ZIG.GrabMemory();
		if( P1_C_ZIG.GetF(FLinkEdges) ) { P1_C_ZIG.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)25);
			P1_C_ZIG.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_IC_SW_DEPTH_u213_exe() {
	float value;

	switch( P1_IC_SW_DEPTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_IC_SW_DEPTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_IC_SW_DEPTH.Update( p, value );
		}
		P1_IC_SW_DEPTH.GrabMemory();
		if( P1_IC_SW_DEPTH.GetF(FLinkEdges) ) { P1_IC_SW_DEPTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_IC_SW_DEPTH.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_IC_UW_MOIST_PR_u214_exe() {
	float value;

	switch( P1_IC_UW_MOIST_PR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_IC_UW_MOIST_PR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.25;
			P1_IC_UW_MOIST_PR.Update( p, P1_IC_UW_MOIST_PR.ParameterValue(value,p) );
		}
		P1_IC_UW_MOIST_PR.GrabMemory();
		if( P1_IC_UW_MOIST_PR.GetF(FLinkEdges) ) { P1_IC_UW_MOIST_PR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.25;
			P1_IC_UW_MOIST_PR.Update( P1_IC_UW_MOIST_PR.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_IC_WT_TABLE_u215_exe() {
	float value;

	switch( P1_IC_WT_TABLE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_IC_WT_TABLE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)25);
			P1_IC_WT_TABLE.Update( p, value );
		}
		P1_IC_WT_TABLE.GrabMemory();
		if( P1_IC_WT_TABLE.GetF(FLinkEdges) ) { P1_IC_WT_TABLE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)25);
			P1_IC_WT_TABLE.Update( value );
	  } break;
	}
	return 0;
}

HYDROLOGY_module* HYDROLOGY_module::fInstance = NULL;
HYDROLOGY_module* HYDROLOGY_module::kNullModel = (HYDROLOGY_module*)0x1;
int HYDROLOGY_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int HYDROLOGY_module::InitVars() {
	
	TIME.SSInit(this);
	SURFACE_WATER.SSInit(this);
	SURFACE_WATER.SetLinkEdges();
	UW_DEPTH.SSInit(this);
	WATER_AVAIL.SSInit(this);
	ON_MAP.SSInit(this);
	ON_MAP.SetLinkEdges();
	DIN_SD.SSInit(this);
	DIN_SD.SetLinkEdges();
	HABITATMAP.SSInit(this);
	HABITATMAP.SetLinkEdges();
	AIR_TEMP_C.SSInit(this);
	PRECIP_M.SSInit(this);
	PRECIP_M.SetLinkEdges();
	HYDRO.SSInit(this);
	HYDRO.SetLinkEdges();
	ELEVATION.SSInit(this);
	ELEVATION.SetLinkEdges();
	DIN_SF.SSInit(this);
	DIN_SF.SetLinkEdges();
	CELL_SIZE.SSInit(this);
	SOLRADGRD.SSInit(this);
	MACLAI.SSInit(this);
	SOIL.SSInit(this);
	HUMIDITY.SSInit(this);
	WIND.SSInit(this);
	ELEV_MIN.SSInit(this);
	ETPM.SSInit(this);
	ROOT_DEPTH.SSInit(this);
	P1_DATUM_TO_MSL.SSInit(this);
	P1_DEPTH_MSL_MAP.SSInit(this);
	SAT_WATER.SSInit(this);
	SAT_WATER.SetLinkEdges();
	UNSAT_WATER.SSInit(this);
	UNSAT_WATER.SetLinkEdges();
	UW_FROM_PRECIP.SSInit(this);
	UW_FROM_PRECIP.SetDestination(&UNSAT_WATER);
	SW_TO_SATW_DOWNFLOW.SSInit(this);
	SW_TO_SATW_DOWNFLOW.SetOrigin(&SURFACE_WATER);
	SW_TO_SATW_DOWNFLOW.SetDestination(&SAT_WATER);
	SATW_FROM_PRECIP.SSInit(this);
	SATW_FROM_PRECIP.SetDestination(&SAT_WATER);
	SATW_TO_SW_UPFLOW.SSInit(this);
	SATW_TO_SW_UPFLOW.SetOrigin(&SAT_WATER);
	SATW_TO_SW_UPFLOW.SetDestination(&SURFACE_WATER);
	SATW_OUTFLUX.SSInit(this);
	SATW_OUTFLUX.SetOrigin(&SAT_WATER);
	SW_OUTFLUX.SSInit(this);
	SW_OUTFLUX.SetOrigin(&SURFACE_WATER);
	OUT_F_SF.SSInit(this);
	OUT_F_SF.SetLinkEdges();
	UW_SATW_EXCHANGE.SSInit(this);
	UW_SATW_EXCHANGE.SetOrigin(&UNSAT_WATER);
	UW_SATW_EXCHANGE.SetDestination(&SAT_WATER);
	SATW_RECHARGE.SSInit(this);
	SATW_RECHARGE.SetOrigin(&SAT_WATER);
	SATW_TRANSP.SSInit(this);
	SATW_TRANSP.SetOrigin(&SAT_WATER);
	SATW_UW.SSInit(this);
	SATW_UW.SetOrigin(&SAT_WATER);
	SATW_UW.SetDestination(&UNSAT_WATER);
	SNOW_ICE.SSInit(this);
	SNOWFALL.SSInit(this);
	SNOWFALL.SetDestination(&SNOW_ICE);
	SW_FREEZE.SSInit(this);
	SW_FREEZE.SetOrigin(&SURFACE_WATER);
	SW_FREEZE.SetDestination(&SNOW_ICE);
	SNOWMELT.SSInit(this);
	SNOWMELT.SetOrigin(&SNOW_ICE);
	SW_IN.SSInit(this);
	SW_IN.SetDestination(&SURFACE_WATER);
	SW_EVAP.SSInit(this);
	SW_EVAP.SetOrigin(&SURFACE_WATER);
	TOT_IN.SSInit(this);
	TOTAL_INFLOW.SSInit(this);
	TOTAL_INFLOW.SetDestination(&TOT_IN);
	TOT_OUT.SSInit(this);
	TOTAL_OUTFLOW.SSInit(this);
	TOTAL_OUTFLOW.SetDestination(&TOT_OUT);
	UW_ETRANSP.SSInit(this);
	UW_ETRANSP.SetOrigin(&UNSAT_WATER);
	BALANCE.SSInit(this);
	EVAPORATION.SSInit(this);
	EVAP_UW.SSInit(this);
	H_CONDUCT.SSInit(this);
	H_CONDUCT.SetLinkEdges();
	IC_SATW.SSInit(this);
	IC_UW.SSInit(this);
	INFILTRATION.SSInit(this);
	INF_COND.SSInit(this);
	INTERCEPT.SSInit(this);
	NET_PRECIP.SSInit(this);
	OUT_F_SD.SSInit(this);
	OUT_F_SD.SetLinkEdges();
	PAN_CH.SSInit(this);
	PAN_CT.SSInit(this);
	PAN_CW.SSInit(this);
	POROSITY.SSInit(this);
	POROSITY.SetLinkEdges();
	POT_INFILTR.SSInit(this);
	POT_INFILTR.SetLinkEdges();
	RAINFALL.SSInit(this);
	SATWMAX.SSInit(this);
	SATWRUNOFF.SSInit(this);
	SATW_HEAD.SSInit(this);
	SW_FROM_PS.SSInit(this);
	TOTAL_OUT.SSInit(this);
	TOTAL_PRECIP.SSInit(this);
	TRANSPIRATION.SSInit(this);
	UNSAT_CAP.SSInit(this);
	UW_CAPIL_EXP.SSInit(this);
	UW_DELTA.SSInit(this);
	UW_DEPTH_BEFORE.SSInit(this);
	UW_EXCESS.SSInit(this);
	UW_MOIST_PRP.SSInit(this);
	UW_MP_R.SSInit(this);
	UW_PERC_RATE.SSInit(this);
	UW_TRANS_PR.SSInit(this);
	WAT_TABLE.SSInit(this);
	P1_C_EVAP.SSInit(this);
	P1_C_FIELD_CAP.SSInit(this);
	P1_C_HORIZ_HC.SSInit(this);
	P1_C_HORIZ_HYDR_COND.SSInit(this);
	P1_C_INFILT.SSInit(this);
	P1_C_INF_HAB.SSInit(this);
	P1_C_INF_SLOPE.SSInit(this);
	P1_C_INF_SOIL.SSInit(this);
	P1_C_INTERCEP.SSInit(this);
	P1_C_INTERCEPVEG.SSInit(this);
	P1_C_POROSITY.SSInit(this);
	P1_C_RECHG.SSInit(this);
	P1_C_SATW_OUT.SSInit(this);
	P1_C_SW_MELT.SSInit(this);
	P1_C_SW_OUT.SSInit(this);
	P1_C_TRANSP.SSInit(this);
	P1_C_UW_EVAP.SSInit(this);
	P1_C_VERT_HYDR_COND.SSInit(this);
	P1_C_ZIG.SSInit(this);
	P1_IC_SW_DEPTH.SSInit(this);
	P1_IC_UW_MOIST_PR.SSInit(this);
	P1_IC_WT_TABLE.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int HYDROLOGY_module::SetupEvents() {
	TExecuteCommand* I142 = (TExecuteCommand*) SURFACE_WATER.GetCommand("I142",TCommand::kIntegrate,TCommand::kCode);
	I142->SetExecutable(&SURFACE_WATER_I142_exe_g);
	I142->Code() = "I142 <- ( ( ( ( ( SW_IN+SATW_TO_SW_UPFLOW )-SW_EVAP )-SW_TO_SATW_DOWNFLOW )-SW_FREEZE )-SW_OUTFLUX )";
	I142->AddDependency(SW_IN);
	I142->AddDependency(SATW_TO_SW_UPFLOW);
	I142->AddDependency(SW_EVAP);
	I142->AddDependency(SW_TO_SATW_DOWNFLOW);
	I142->AddDependency(SW_FREEZE);
	I142->AddDependency(SW_OUTFLUX);
	I142->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i143 = (TExecuteCommand*) SURFACE_WATER.GetCommand("i143",TCommand::kInit,TCommand::kCode);
	i143->SetExecutable(&SURFACE_WATER_i143_exe_g);
	i143->Code() = "i143 <- P1_IC_SW_DEPTH";
	i143->AddDependency(P1_IC_SW_DEPTH);
	i143->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* vE437 = (TExecuteCommand*) SURFACE_WATER.GetCommand("vE437",TCommand::kFunction,TCommand::kCode);
	vE437->SetExecutable(&SURFACE_WATER_vE437_exe_g);
	vE437->Code() = "vE437 <- Function";
	vE437->GetFunction() = 'P';
	vE437->AddDependency(SURFACE_WATER);
	vE437->AddDependency(HYDRO);
	vE437->AddDependency(HABITATMAP);
	vE437->AddDependency(ELEVATION);
	vE437->AddDependency(DIN_SF);
	vE437->AddDependency(OUT_F_SF);
	vE437->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u185 = (TExecuteCommand*) UW_DEPTH.GetCommand("u185",TCommand::kUpdate,TCommand::kCode);
	u185->SetExecutable(&UW_DEPTH_u185_exe_g);
	u185->Code() = "u185 <- SL::Max(( ELEVATION-SATW_HEAD ), ((float)0))";
	u185->AddDependency(ELEVATION);
	u185->AddDependency(SATW_HEAD);
	u185->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u192 = (TExecuteCommand*) WATER_AVAIL.GetCommand("u192",TCommand::kUpdate,TCommand::kCode);
	u192->SetExecutable(&WATER_AVAIL_u192_exe_g);
	u192->Code() = "u192 <- SL::Min(1.0, ( UW_CAPIL_EXP+ ( ( ( UW_MOIST_PRP <  ( 0.1*P1_C_FIELD_CAP ) ) ) ? ( ((float)0) ) : (  ( ( ( UW_MOIST_PRP >  ( 0.6*P1_C_FIELD_CAP ) ) ) ? ( ((float)1) ) : ( ( ( ( UW_MOIST_PRP-( 0.1*P1_C_FIELD_CAP ) )/0.5 )/P1_C_FIELD_CAP ) ) )  ) )  ))";
	u192->AddDependency(UW_CAPIL_EXP);
	u192->AddDependency(UW_MOIST_PRP);
	u192->AddDependency(SOIL);
	u192->AddDependency(P1_C_FIELD_CAP);
	u192->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ON_MAP_import = (TImportCommand*) ON_MAP.GetCommand("ON_MAP_import",TCommand::kUndefined,TCommand::kImport);
	ON_MAP_import->Code() = "Import ON_MAP from GLOBALS_module";
	ON_MAP_import->AddDependency(ON_MAP);
	ON_MAP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DIN_SD_import = (TImportCommand*) DIN_SD.GetCommand("DIN_SD_import",TCommand::kUndefined,TCommand::kImport);
	DIN_SD_import->Code() = "Import DIN_SD from ZDIN_module";
	DIN_SD_import->AddDependency(DIN_SD);
	DIN_SD_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* HABITATMAP_import = (TImportCommand*) HABITATMAP.GetCommand("HABITATMAP_import",TCommand::kUndefined,TCommand::kImport);
	HABITATMAP_import->Code() = "Import HABITATMAP from GLOBALS_module";
	HABITATMAP_import->AddDependency(HABITATMAP);
	HABITATMAP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* AIR_TEMP_C_import = (TImportCommand*) AIR_TEMP_C.GetCommand("AIR_TEMP_C_import",TCommand::kUndefined,TCommand::kImport);
	AIR_TEMP_C_import->Code() = "Import AIR_TEMP_C from GLOBALS_module";
	AIR_TEMP_C_import->AddDependency(AIR_TEMP_C);
	AIR_TEMP_C_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PRECIP_M_import = (TImportCommand*) PRECIP_M.GetCommand("PRECIP_M_import",TCommand::kUndefined,TCommand::kImport);
	PRECIP_M_import->Code() = "Import PRECIP_M from GLOBALS_module";
	PRECIP_M_import->AddDependency(PRECIP_M);
	PRECIP_M_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* HYDRO_import = (TImportCommand*) HYDRO.GetCommand("HYDRO_import",TCommand::kUndefined,TCommand::kImport);
	HYDRO_import->Code() = "Import HYDRO from GLOBALS_module";
	HYDRO_import->AddDependency(HYDRO);
	HYDRO_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ELEVATION_import = (TImportCommand*) ELEVATION.GetCommand("ELEVATION_import",TCommand::kUndefined,TCommand::kImport);
	ELEVATION_import->Code() = "Import ELEVATION from GLOBALS_module";
	ELEVATION_import->AddDependency(ELEVATION);
	ELEVATION_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DIN_SF_import = (TImportCommand*) DIN_SF.GetCommand("DIN_SF_import",TCommand::kUndefined,TCommand::kImport);
	DIN_SF_import->Code() = "Import DIN_SF from ZDIN_module";
	DIN_SF_import->AddDependency(DIN_SF);
	DIN_SF_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CELL_SIZE_import = (TImportCommand*) CELL_SIZE.GetCommand("CELL_SIZE_import",TCommand::kUndefined,TCommand::kImport);
	CELL_SIZE_import->Code() = "Import CELL_SIZE from GLOBALS_module";
	CELL_SIZE_import->AddDependency(CELL_SIZE);
	CELL_SIZE_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SOLRADGRD_import = (TImportCommand*) SOLRADGRD.GetCommand("SOLRADGRD_import",TCommand::kUndefined,TCommand::kImport);
	SOLRADGRD_import->Code() = "Import SOLRADGRD from PAR_module";
	SOLRADGRD_import->AddDependency(SOLRADGRD);
	SOLRADGRD_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* MACLAI_import = (TImportCommand*) MACLAI.GetCommand("MACLAI_import",TCommand::kUndefined,TCommand::kImport);
	MACLAI_import->Code() = "Import MACLAI from MACROPHYTES_module";
	MACLAI_import->AddDependency(MACLAI);
	MACLAI_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SOIL_import = (TImportCommand*) SOIL.GetCommand("SOIL_import",TCommand::kUndefined,TCommand::kImport);
	SOIL_import->Code() = "Import SOIL from GLOBALS_module";
	SOIL_import->AddDependency(SOIL);
	SOIL_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* HUMIDITY_import = (TImportCommand*) HUMIDITY.GetCommand("HUMIDITY_import",TCommand::kUndefined,TCommand::kImport);
	HUMIDITY_import->Code() = "Import HUMIDITY from GLOBALS_module";
	HUMIDITY_import->AddDependency(HUMIDITY);
	HUMIDITY_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* WIND_import = (TImportCommand*) WIND.GetCommand("WIND_import",TCommand::kUndefined,TCommand::kImport);
	WIND_import->Code() = "Import WIND from GLOBALS_module";
	WIND_import->AddDependency(WIND);
	WIND_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ELEV_MIN_import = (TImportCommand*) ELEV_MIN.GetCommand("ELEV_MIN_import",TCommand::kUndefined,TCommand::kImport);
	ELEV_MIN_import->Code() = "Import ELEV_MIN from GLOBALS_module";
	ELEV_MIN_import->AddDependency(ELEV_MIN);
	ELEV_MIN_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ETPM_import = (TImportCommand*) ETPM.GetCommand("ETPM_import",TCommand::kUndefined,TCommand::kImport);
	ETPM_import->Code() = "Import ETPM from ETPM_module";
	ETPM_import->AddDependency(ETPM);
	ETPM_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ROOT_DEPTH_import = (TImportCommand*) ROOT_DEPTH.GetCommand("ROOT_DEPTH_import",TCommand::kUndefined,TCommand::kImport);
	ROOT_DEPTH_import->Code() = "Import ROOT_DEPTH from MACROPHYTES_module";
	ROOT_DEPTH_import->AddDependency(ROOT_DEPTH);
	ROOT_DEPTH_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_DATUM_TO_MSL_import = (TImportCommand*) P1_DATUM_TO_MSL.GetCommand("P1_DATUM_TO_MSL_import",TCommand::kUndefined,TCommand::kImport);
	P1_DATUM_TO_MSL_import->Code() = "Import P1_DATUM_TO_MSL from GLOBALS_module";
	P1_DATUM_TO_MSL_import->AddDependency(P1_DATUM_TO_MSL);
	P1_DATUM_TO_MSL_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_DEPTH_MSL_MAP_import = (TImportCommand*) P1_DEPTH_MSL_MAP.GetCommand("P1_DEPTH_MSL_MAP_import",TCommand::kUndefined,TCommand::kImport);
	P1_DEPTH_MSL_MAP_import->Code() = "Import P1_DEPTH_MSL_MAP from GLOBALS_module";
	P1_DEPTH_MSL_MAP_import->AddDependency(P1_DEPTH_MSL_MAP);
	P1_DEPTH_MSL_MAP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I127 = (TExecuteCommand*) SAT_WATER.GetCommand("I127",TCommand::kIntegrate,TCommand::kCode);
	I127->SetExecutable(&SAT_WATER_I127_exe_g);
	I127->Code() = "I127 <- ( ( ( ( ( ( ( UW_SATW_EXCHANGE+SW_TO_SATW_DOWNFLOW )+SATW_FROM_PRECIP )-SATW_RECHARGE )-SATW_TRANSP )-SATW_TO_SW_UPFLOW )-SATW_OUTFLUX )-SATW_UW )";
	I127->AddDependency(UW_SATW_EXCHANGE);
	I127->AddDependency(SW_TO_SATW_DOWNFLOW);
	I127->AddDependency(SATW_FROM_PRECIP);
	I127->AddDependency(SATW_RECHARGE);
	I127->AddDependency(SATW_TRANSP);
	I127->AddDependency(SATW_TO_SW_UPFLOW);
	I127->AddDependency(SATW_OUTFLUX);
	I127->AddDependency(SATW_UW);
	I127->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i128 = (TExecuteCommand*) SAT_WATER.GetCommand("i128",TCommand::kInit,TCommand::kCode);
	i128->SetExecutable(&SAT_WATER_i128_exe_g);
	i128->Code() = "i128 <- IC_SATW";
	i128->AddDependency(IC_SATW);
	i128->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* vE436 = (TExecuteCommand*) SAT_WATER.GetCommand("vE436",TCommand::kFunction,TCommand::kCode);
	vE436->SetExecutable(&SAT_WATER_vE436_exe_g);
	vE436->Code() = "vE436 <- Function";
	vE436->GetFunction() = 'P';
	vE436->AddDependency(SAT_WATER);
	vE436->AddDependency(POROSITY);
	vE436->AddDependency(H_CONDUCT);
	vE436->AddDependency(ON_MAP);
	vE436->AddDependency(DIN_SD);
	vE436->AddDependency(UNSAT_WATER);
	vE436->AddDependency(OUT_F_SD);
	vE436->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* I153 = (TExecuteCommand*) UNSAT_WATER.GetCommand("I153",TCommand::kIntegrate,TCommand::kCode);
	I153->SetExecutable(&UNSAT_WATER_I153_exe_g);
	I153->Code() = "I153 <- ( ( ( UW_FROM_PRECIP+SATW_UW )-UW_SATW_EXCHANGE )-UW_ETRANSP )";
	I153->AddDependency(UW_FROM_PRECIP);
	I153->AddDependency(SATW_UW);
	I153->AddDependency(UW_SATW_EXCHANGE);
	I153->AddDependency(UW_ETRANSP);
	I153->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i154 = (TExecuteCommand*) UNSAT_WATER.GetCommand("i154",TCommand::kInit,TCommand::kCode);
	i154->SetExecutable(&UNSAT_WATER_i154_exe_g);
	i154->Code() = "i154 <- IC_UW";
	i154->AddDependency(IC_UW);
	i154->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u155 = (TExecuteCommand*) UW_FROM_PRECIP.GetCommand("u155",TCommand::kUpdate,TCommand::kCode);
	u155->SetExecutable(&UW_FROM_PRECIP_u155_exe_g);
	u155->Code() = "u155 <-  ( ( ( INF_COND >  ((float)0) ) ) ? ( INFILTRATION ) : ( ((float)0) ) ) ";
	u155->AddDependency(INF_COND);
	u155->AddDependency(INFILTRATION);
	u155->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u130 = (TExecuteCommand*) SW_TO_SATW_DOWNFLOW.GetCommand("u130",TCommand::kUpdate,TCommand::kCode);
	u130->SetExecutable(&SW_TO_SATW_DOWNFLOW_u130_exe_g);
	u130->Code() = "u130 <-  ( ( ( ( HABITATMAP == ((float)1) ) || ( ( UW_DEPTH_BEFORE == ((float)0) ) && ( UNSAT_CAP >  ((float)0) ) ) ) ) ? ( SL::Min(( UNSAT_CAP/dT() ), ( SURFACE_WATER/dT() )) ) : ( ((float)0) ) ) ";
	if( SURFACE_WATER.GetF(FisClamped) ) { u130->AddDependency(SURFACE_WATER); }
	u130->AddDependency(HABITATMAP);
	u130->AddDependency(UW_DEPTH_BEFORE);
	u130->AddDependency(UNSAT_CAP);
	u130->AddDependency(SURFACE_WATER);
	u130->AddDependency(SATW_TO_SW_UPFLOW);
	u130->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u131 = (TExecuteCommand*) SATW_FROM_PRECIP.GetCommand("u131",TCommand::kUpdate,TCommand::kCode);
	u131->SetExecutable(&SATW_FROM_PRECIP_u131_exe_g);
	u131->Code() = "u131 <-  ( ( ( INF_COND == ((float)0) ) ) ? ( ( ( UNSAT_CAP/dT() )-SW_TO_SATW_DOWNFLOW ) ) : ( ((float)0) ) ) ";
	u131->AddDependency(INF_COND);
	u131->AddDependency(UNSAT_CAP);
	u131->AddDependency(SW_TO_SATW_DOWNFLOW);
	u131->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u134 = (TExecuteCommand*) SATW_TO_SW_UPFLOW.GetCommand("u134",TCommand::kUpdate,TCommand::kCode);
	u134->SetExecutable(&SATW_TO_SW_UPFLOW_u134_exe_g);
	u134->Code() = "u134 <-  ( ( ( SAT_WATER >  SATWMAX ) ) ? ( ( SAT_WATER-SATWMAX ) ) : (  ( ( ( SAT_WATER >  SATWRUNOFF ) ) ? ( ( ( P1_C_ZIG*( SAT_WATER-SATWRUNOFF ) )*H_CONDUCT ) ) : ( ((float)0) ) )  ) ) ";
	if( SAT_WATER.GetF(FisClamped) ) { u134->AddDependency(SAT_WATER); }
	u134->AddDependency(SAT_WATER);
	u134->AddDependency(SATWMAX);
	u134->AddDependency(SATWRUNOFF);
	u134->AddDependency(HABITATMAP);
	u134->AddDependency(P1_C_ZIG);
	u134->AddDependency(H_CONDUCT);
	u134->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u135 = (TExecuteCommand*) SATW_OUTFLUX.GetCommand("u135",TCommand::kUpdate,TCommand::kCode);
	u135->SetExecutable(&SATW_OUTFLUX_u135_exe_g);
	u135->Code() = "u135 <- ( P1_C_SATW_OUT*( SAT_WATER-IC_SATW ) )";
	if( SAT_WATER.GetF(FisClamped) ) { u135->AddDependency(SAT_WATER); }
	u135->AddDependency(P1_C_SATW_OUT);
	u135->AddDependency(SAT_WATER);
	u135->AddDependency(IC_SATW);
	u135->AddDependency(SW_TO_SATW_DOWNFLOW);
	u135->AddDependency(SATW_FROM_PRECIP);
	u135->AddDependency(UW_SATW_EXCHANGE);
	u135->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u146 = (TExecuteCommand*) SW_OUTFLUX.GetCommand("u146",TCommand::kUpdate,TCommand::kCode);
	u146->SetExecutable(&SW_OUTFLUX_u146_exe_g);
	u146->Code() = "u146 <- ( ( P1_C_SW_OUT*SURFACE_WATER )/dT() )";
	if( SURFACE_WATER.GetF(FisClamped) ) { u146->AddDependency(SURFACE_WATER); }
	u146->AddDependency(P1_C_SW_OUT);
	u146->AddDependency(SURFACE_WATER);
	u146->AddDependency(SATW_TO_SW_UPFLOW);
	u146->AddDependency(SW_IN);
	u146->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u168 = (TExecuteCommand*) OUT_F_SF.GetCommand("u168",TCommand::kUpdate,TCommand::kCode);
	u168->SetExecutable(&OUT_F_SF_u168_exe_g);
	u168->Code() = "u168 <- ((float)0)";
	u168->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u129 = (TExecuteCommand*) UW_SATW_EXCHANGE.GetCommand("u129",TCommand::kUpdate,TCommand::kCode);
	u129->SetExecutable(&UW_SATW_EXCHANGE_u129_exe_g);
	u129->Code() = "u129 <-  ( ( ( INF_COND == ((float)0) ) ) ? ( ( UNSAT_WATER/dT() ) ) : ( SL::Min(( UNSAT_WATER/dT() ), ( ( SL::Max(((float)0), ( UW_DELTA*UW_MOIST_PRP ))/dT() )+UW_PERC_RATE )) ) ) ";
	if( UNSAT_WATER.GetF(FisClamped) ) { u129->AddDependency(UNSAT_WATER); }
	u129->AddDependency(INF_COND);
	u129->AddDependency(UNSAT_WATER);
	u129->AddDependency(UW_DELTA);
	u129->AddDependency(UW_MOIST_PRP);
	u129->AddDependency(UW_PERC_RATE);
	u129->AddDependency(UW_FROM_PRECIP);
	u129->AddDependency(SATW_UW);
	u129->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u132 = (TExecuteCommand*) SATW_RECHARGE.GetCommand("u132",TCommand::kUpdate,TCommand::kCode);
	u132->SetExecutable(&SATW_RECHARGE_u132_exe_g);
	u132->Code() = "u132 <- P1_C_RECHG";
	if( SAT_WATER.GetF(FisClamped) ) { u132->AddDependency(SAT_WATER); }
	u132->AddDependency(P1_C_RECHG);
	u132->AddDependency(SW_TO_SATW_DOWNFLOW);
	u132->AddDependency(SATW_FROM_PRECIP);
	u132->AddDependency(UW_SATW_EXCHANGE);
	u132->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u133 = (TExecuteCommand*) SATW_TRANSP.GetCommand("u133",TCommand::kUpdate,TCommand::kCode);
	u133->SetExecutable(&SATW_TRANSP_u133_exe_g);
	u133->Code() = "u133 <- ( TRANSPIRATION*( ((float)1)-UW_TRANS_PR ) )";
	if( SAT_WATER.GetF(FisClamped) ) { u133->AddDependency(SAT_WATER); }
	u133->AddDependency(TRANSPIRATION);
	u133->AddDependency(UW_TRANS_PR);
	u133->AddDependency(SW_TO_SATW_DOWNFLOW);
	u133->AddDependency(SATW_FROM_PRECIP);
	u133->AddDependency(UW_SATW_EXCHANGE);
	u133->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u136 = (TExecuteCommand*) SATW_UW.GetCommand("u136",TCommand::kUpdate,TCommand::kCode);
	u136->SetExecutable(&SATW_UW_u136_exe_g);
	u136->Code() = "u136 <- SL::Max(((float)0), SL::Min(( -UW_DELTA*P1_C_FIELD_CAP ), ( SAT_WATER/dT() )))";
	if( SAT_WATER.GetF(FisClamped) ) { u136->AddDependency(SAT_WATER); }
	u136->AddDependency(UW_DELTA);
	u136->AddDependency(SOIL);
	u136->AddDependency(P1_C_FIELD_CAP);
	u136->AddDependency(SAT_WATER);
	u136->AddDependency(SW_TO_SATW_DOWNFLOW);
	u136->AddDependency(SATW_FROM_PRECIP);
	u136->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I137 = (TExecuteCommand*) SNOW_ICE.GetCommand("I137",TCommand::kIntegrate,TCommand::kCode);
	I137->SetExecutable(&SNOW_ICE_I137_exe_g);
	I137->Code() = "I137 <- ( ( SNOWFALL+SW_FREEZE )-SNOWMELT )";
	I137->AddDependency(SNOWFALL);
	I137->AddDependency(SW_FREEZE);
	I137->AddDependency(SNOWMELT);
	I137->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i138 = (TExecuteCommand*) SNOW_ICE.GetCommand("i138",TCommand::kInit,TCommand::kCode);
	i138->SetExecutable(&SNOW_ICE_i138_exe_g);
	i138->Code() = "i138 <- ((float)0)";
	i138->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u139 = (TExecuteCommand*) SNOWFALL.GetCommand("u139",TCommand::kUpdate,TCommand::kCode);
	u139->SetExecutable(&SNOWFALL_u139_exe_g);
	u139->Code() = "u139 <-  ( ( ( AIR_TEMP_C <= ((float)0) ) ) ? ( PRECIP_M ) : ( ((float)0) ) ) ";
	u139->AddDependency(AIR_TEMP_C);
	u139->AddDependency(PRECIP_M);
	u139->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u140 = (TExecuteCommand*) SW_FREEZE.GetCommand("u140",TCommand::kUpdate,TCommand::kCode);
	u140->SetExecutable(&SW_FREEZE_u140_exe_g);
	u140->Code() = "u140 <-  ( ( ( AIR_TEMP_C >  ((float)0) ) ) ? ( ((float)0) ) : ( ( ( -AIR_TEMP_C*SURFACE_WATER )*P1_C_SW_MELT ) ) ) ";
	if( SURFACE_WATER.GetF(FisClamped) ) { u140->AddDependency(SURFACE_WATER); }
	u140->AddDependency(AIR_TEMP_C);
	u140->AddDependency(SURFACE_WATER);
	u140->AddDependency(P1_C_SW_MELT);
	u140->AddDependency(SATW_TO_SW_UPFLOW);
	u140->AddDependency(SW_IN);
	u140->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u141 = (TExecuteCommand*) SNOWMELT.GetCommand("u141",TCommand::kUpdate,TCommand::kCode);
	u141->SetExecutable(&SNOWMELT_u141_exe_g);
	u141->Code() = "u141 <-  ( ( ( AIR_TEMP_C >  ((float)0) ) ) ? ( SL::Min(( P1_C_SW_MELT*AIR_TEMP_C ), ( SNOW_ICE/dT() )) ) : ( ((float)0) ) ) ";
	if( SNOW_ICE.GetF(FisClamped) ) { u141->AddDependency(SNOW_ICE); }
	u141->AddDependency(AIR_TEMP_C);
	u141->AddDependency(P1_C_SW_MELT);
	u141->AddDependency(SNOW_ICE);
	u141->AddDependency(SNOWFALL);
	u141->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u144 = (TExecuteCommand*) SW_IN.GetCommand("u144",TCommand::kUpdate,TCommand::kCode);
	u144->SetExecutable(&SW_IN_u144_exe_g);
	u144->Code() = "u144 <- ( ( ( NET_PRECIP-UW_FROM_PRECIP )-SATW_FROM_PRECIP )+( SW_FROM_PS/CELL_SIZE ) )";
	u144->AddDependency(NET_PRECIP);
	u144->AddDependency(UW_FROM_PRECIP);
	u144->AddDependency(SATW_FROM_PRECIP);
	u144->AddDependency(SW_FROM_PS);
	u144->AddDependency(CELL_SIZE);
	u144->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u145 = (TExecuteCommand*) SW_EVAP.GetCommand("u145",TCommand::kUpdate,TCommand::kCode);
	u145->SetExecutable(&SW_EVAP_u145_exe_g);
	u145->Code() = "u145 <- SL::Min(SL::Max(EVAPORATION, ((float)0)), ( SURFACE_WATER/dT() ))";
	if( SURFACE_WATER.GetF(FisClamped) ) { u145->AddDependency(SURFACE_WATER); }
	u145->AddDependency(EVAPORATION);
	u145->AddDependency(SURFACE_WATER);
	u145->AddDependency(SATW_TO_SW_UPFLOW);
	u145->AddDependency(SW_IN);
	u145->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I147 = (TExecuteCommand*) TOT_IN.GetCommand("I147",TCommand::kIntegrate,TCommand::kCode);
	I147->SetExecutable(&TOT_IN_I147_exe_g);
	I147->Code() = "I147 <- TOTAL_INFLOW";
	I147->AddDependency(TOTAL_INFLOW);
	I147->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i148 = (TExecuteCommand*) TOT_IN.GetCommand("i148",TCommand::kInit,TCommand::kCode);
	i148->SetExecutable(&TOT_IN_i148_exe_g);
	i148->Code() = "i148 <- ((float)0)";
	i148->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u149 = (TExecuteCommand*) TOTAL_INFLOW.GetCommand("u149",TCommand::kUpdate,TCommand::kCode);
	u149->SetExecutable(&TOTAL_INFLOW_u149_exe_g);
	u149->Code() = "u149 <- ( PRECIP_M+( SW_FROM_PS/CELL_SIZE ) )";
	u149->AddDependency(PRECIP_M);
	u149->AddDependency(SW_FROM_PS);
	u149->AddDependency(CELL_SIZE);
	u149->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I150 = (TExecuteCommand*) TOT_OUT.GetCommand("I150",TCommand::kIntegrate,TCommand::kCode);
	I150->SetExecutable(&TOT_OUT_I150_exe_g);
	I150->Code() = "I150 <- TOTAL_OUTFLOW";
	I150->AddDependency(TOTAL_OUTFLOW);
	I150->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i151 = (TExecuteCommand*) TOT_OUT.GetCommand("i151",TCommand::kInit,TCommand::kCode);
	i151->SetExecutable(&TOT_OUT_i151_exe_g);
	i151->Code() = "i151 <- ((float)0)";
	i151->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u152 = (TExecuteCommand*) TOTAL_OUTFLOW.GetCommand("u152",TCommand::kUpdate,TCommand::kCode);
	u152->SetExecutable(&TOTAL_OUTFLOW_u152_exe_g);
	u152->Code() = "u152 <- TOTAL_OUT";
	u152->AddDependency(TOTAL_OUT);
	u152->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u156 = (TExecuteCommand*) UW_ETRANSP.GetCommand("u156",TCommand::kUpdate,TCommand::kCode);
	u156->SetExecutable(&UW_ETRANSP_u156_exe_g);
	u156->Code() = "u156 <- ( ( TRANSPIRATION*UW_TRANS_PR )+EVAP_UW )";
	if( UNSAT_WATER.GetF(FisClamped) ) { u156->AddDependency(UNSAT_WATER); }
	u156->AddDependency(TRANSPIRATION);
	u156->AddDependency(UW_TRANS_PR);
	u156->AddDependency(EVAP_UW);
	u156->AddDependency(UW_FROM_PRECIP);
	u156->AddDependency(SATW_UW);
	u156->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u157 = (TExecuteCommand*) BALANCE.GetCommand("u157",TCommand::kUpdate,TCommand::kCode);
	u157->SetExecutable(&BALANCE_u157_exe_g);
	u157->Code() = "u157 <- ( ( ( ( ( SAT_WATER+SNOW_ICE )+SURFACE_WATER )+UNSAT_WATER )-TOT_IN )+TOT_OUT )";
	u157->AddDependency(SAT_WATER);
	u157->AddDependency(SNOW_ICE);
	u157->AddDependency(SURFACE_WATER);
	u157->AddDependency(UNSAT_WATER);
	u157->AddDependency(TOT_IN);
	u157->AddDependency(TOT_OUT);
	u157->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u158 = (TExecuteCommand*) EVAPORATION.GetCommand("u158",TCommand::kUpdate,TCommand::kCode);
	u158->SetExecutable(&EVAPORATION_u158_exe_g);
	u158->Code() = "u158 <- ( ( ( ( ( P1_C_EVAP*SOLRADGRD )/585 )*PAN_CW )*PAN_CT )*PAN_CH )";
	u158->AddDependency(HABITATMAP);
	u158->AddDependency(P1_C_EVAP);
	u158->AddDependency(SOLRADGRD);
	u158->AddDependency(PAN_CW);
	u158->AddDependency(PAN_CT);
	u158->AddDependency(PAN_CH);
	u158->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u159 = (TExecuteCommand*) EVAP_UW.GetCommand("u159",TCommand::kUpdate,TCommand::kCode);
	u159->SetExecutable(&EVAP_UW_u159_exe_g);
	u159->Code() = "u159 <- ( ( ( P1_C_UW_EVAP*EVAPORATION )*( ((float)1)-SL::Min(((float)1), MACLAI) ) )*UW_MP_R )";
	u159->AddDependency(HABITATMAP);
	u159->AddDependency(P1_C_UW_EVAP);
	u159->AddDependency(EVAPORATION);
	u159->AddDependency(MACLAI);
	u159->AddDependency(UW_MP_R);
	u159->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u160 = (TExecuteCommand*) H_CONDUCT.GetCommand("u160",TCommand::kUpdate,TCommand::kCode);
	u160->SetExecutable(&H_CONDUCT_u160_exe_g);
	u160->Code() = "u160 <- ( ( ( P1_C_HORIZ_HC*P1_C_HORIZ_HYDR_COND )/SL::Sqrt(CELL_SIZE) )+( SOIL*0.0 ) )";
	u160->AddDependency(P1_C_HORIZ_HC);
	u160->AddDependency(SOIL);
	u160->AddDependency(P1_C_HORIZ_HYDR_COND);
	u160->AddDependency(CELL_SIZE);
	u160->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u161 = (TExecuteCommand*) IC_SATW.GetCommand("u161",TCommand::kUpdate,TCommand::kCode);
	u161->SetExecutable(&IC_SATW_u161_exe_g);
	u161->Code() = "u161 <- ( WAT_TABLE*P1_C_POROSITY )";
	u161->AddDependency(WAT_TABLE);
	u161->AddDependency(SOIL);
	u161->AddDependency(P1_C_POROSITY);
	u161->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u162 = (TExecuteCommand*) IC_UW.GetCommand("u162",TCommand::kUpdate,TCommand::kCode);
	u162->SetExecutable(&IC_UW_u162_exe_g);
	u162->Code() = "u162 <-  ( ( ( ELEVATION >  WAT_TABLE ) ) ? ( ( ( ELEVATION-WAT_TABLE )*P1_IC_UW_MOIST_PR ) ) : ( ((float)0) ) ) ";
	u162->AddDependency(ELEVATION);
	u162->AddDependency(WAT_TABLE);
	u162->AddDependency(P1_IC_UW_MOIST_PR);
	u162->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u163 = (TExecuteCommand*) INFILTRATION.GetCommand("u163",TCommand::kUpdate,TCommand::kCode);
	u163->SetExecutable(&INFILTRATION_u163_exe_g);
	u163->Code() = "u163 <- SL::Min(POT_INFILTR, NET_PRECIP)";
	u163->AddDependency(POT_INFILTR);
	u163->AddDependency(NET_PRECIP);
	u163->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u164 = (TExecuteCommand*) INF_COND.GetCommand("u164",TCommand::kUpdate,TCommand::kCode);
	u164->SetExecutable(&INF_COND_u164_exe_g);
	u164->Code() = "u164 <-  ( ( ( ( SW_TO_SATW_DOWNFLOW*dT() ) == UNSAT_CAP ) ) ? ( ((float)0) ) : ( SL::Max(( UNSAT_CAP-( INFILTRATION*dT() ) ), ((float)0)) ) ) ";
	u164->AddDependency(SW_TO_SATW_DOWNFLOW);
	u164->AddDependency(UNSAT_CAP);
	u164->AddDependency(INFILTRATION);
	u164->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u165 = (TExecuteCommand*) INTERCEPT.GetCommand("u165",TCommand::kUpdate,TCommand::kCode);
	u165->SetExecutable(&INTERCEPT_u165_exe_g);
	u165->Code() = "u165 <- SL::Min(TOTAL_PRECIP, SL::Max(( P1_C_INTERCEP*TOTAL_PRECIP ), ( P1_C_INTERCEPVEG*MACLAI )))";
	u165->AddDependency(TOTAL_PRECIP);
	u165->AddDependency(HABITATMAP);
	u165->AddDependency(P1_C_INTERCEP);
	u165->AddDependency(P1_C_INTERCEPVEG);
	u165->AddDependency(MACLAI);
	u165->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u166 = (TExecuteCommand*) NET_PRECIP.GetCommand("u166",TCommand::kUpdate,TCommand::kCode);
	u166->SetExecutable(&NET_PRECIP_u166_exe_g);
	u166->Code() = "u166 <- ( TOTAL_PRECIP-INTERCEPT )";
	u166->AddDependency(TOTAL_PRECIP);
	u166->AddDependency(INTERCEPT);
	u166->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u167 = (TExecuteCommand*) OUT_F_SD.GetCommand("u167",TCommand::kUpdate,TCommand::kCode);
	u167->SetExecutable(&OUT_F_SD_u167_exe_g);
	u167->Code() = "u167 <- ((float)0)";
	u167->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u169 = (TExecuteCommand*) PAN_CH.GetCommand("u169",TCommand::kUpdate,TCommand::kCode);
	u169->SetExecutable(&PAN_CH_u169_exe_g);
	u169->Code() = "u169 <- ( ( 1.035+( 0.240*pow((double)( HUMIDITY/60 ),(double)((float)2) ) ) )-( 0.275*pow((double)( HUMIDITY/60 ),(double)((float)3) ) ) )";
	u169->AddDependency(HUMIDITY);
	u169->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u170 = (TExecuteCommand*) PAN_CT.GetCommand("u170",TCommand::kUpdate,TCommand::kCode);
	u170->SetExecutable(&PAN_CT_u170_exe_g);
	u170->Code() = "u170 <-  ( ( ( AIR_TEMP_C >  -((float)30) ) ) ? ( ( ( 0.463+( 0.425*( AIR_TEMP_C/20 ) ) )+( 0.112*pow((double)( AIR_TEMP_C/20 ),(double)((float)2) ) ) ) ) : ( ((float)0) ) ) ";
	u170->AddDependency(AIR_TEMP_C);
	u170->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u171 = (TExecuteCommand*) PAN_CW.GetCommand("u171",TCommand::kUpdate,TCommand::kCode);
	u171->SetExecutable(&PAN_CW_u171_exe_g);
	u171->Code() = "u171 <- ( ( 0.672+( 0.406*( WIND/6.7 ) ) )+( 0.078*pow((double)( WIND/6.7 ),(double)((float)2) ) ) )";
	u171->AddDependency(WIND);
	u171->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u172 = (TExecuteCommand*) POROSITY.GetCommand("u172",TCommand::kUpdate,TCommand::kCode);
	u172->SetExecutable(&POROSITY_u172_exe_g);
	u172->Code() = "u172 <- ( P1_C_POROSITY+( SOIL*0.0 ) )";
	u172->AddDependency(SOIL);
	u172->AddDependency(P1_C_POROSITY);
	u172->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u173 = (TExecuteCommand*) POT_INFILTR.GetCommand("u173",TCommand::kUpdate,TCommand::kCode);
	u173->SetExecutable(&POT_INFILTR_u173_exe_g);
	u173->Code() = "u173 <- ( ( ( P1_C_INFILT*P1_C_INF_HAB )*P1_C_INF_SOIL )/ ( ( ( P1_C_INF_SLOPE >  ((float)0) ) ) ? ( P1_C_INF_SOIL ) : ( ((float)1) ) )  )";
	u173->AddDependency(P1_C_INFILT);
	u173->AddDependency(HABITATMAP);
	u173->AddDependency(P1_C_INF_HAB);
	u173->AddDependency(SOIL);
	u173->AddDependency(P1_C_INF_SOIL);
	u173->AddDependency(P1_C_INF_SLOPE);
	u173->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* v438 = (TExecuteCommand*) POT_INFILTR.GetCommand("v438",TCommand::kFunction,TCommand::kCode);
	v438->SetExecutable(&POT_INFILTR_v438_exe_g);
	v438->Code() = "v438 <- Function";
	v438->GetFunction() = 'P';
	v438->AddDependency(POT_INFILTR);
	v438->AddDependency(PRECIP_M);
	v438->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u174 = (TExecuteCommand*) RAINFALL.GetCommand("u174",TCommand::kUpdate,TCommand::kCode);
	u174->SetExecutable(&RAINFALL_u174_exe_g);
	u174->Code() = "u174 <-  ( ( ( AIR_TEMP_C >  ((float)0) ) ) ? ( PRECIP_M ) : ( ((float)0) ) ) ";
	u174->AddDependency(AIR_TEMP_C);
	u174->AddDependency(PRECIP_M);
	u174->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u175 = (TExecuteCommand*) SATWMAX.GetCommand("u175",TCommand::kUpdate,TCommand::kCode);
	u175->SetExecutable(&SATWMAX_u175_exe_g);
	u175->Code() = "u175 <- ( ELEVATION*P1_C_POROSITY )";
	u175->AddDependency(ELEVATION);
	u175->AddDependency(SOIL);
	u175->AddDependency(P1_C_POROSITY);
	u175->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u176 = (TExecuteCommand*) SATWRUNOFF.GetCommand("u176",TCommand::kUpdate,TCommand::kCode);
	u176->SetExecutable(&SATWRUNOFF_u176_exe_g);
	u176->Code() = "u176 <- ( ELEV_MIN*P1_C_POROSITY )";
	u176->AddDependency(ELEV_MIN);
	u176->AddDependency(SOIL);
	u176->AddDependency(P1_C_POROSITY);
	u176->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u177 = (TExecuteCommand*) SATW_HEAD.GetCommand("u177",TCommand::kUpdate,TCommand::kCode);
	u177->SetExecutable(&SATW_HEAD_u177_exe_g);
	u177->Code() = "u177 <- ( SAT_WATER/P1_C_POROSITY )";
	u177->AddDependency(SAT_WATER);
	u177->AddDependency(SOIL);
	u177->AddDependency(P1_C_POROSITY);
	u177->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u178 = (TExecuteCommand*) SW_FROM_PS.GetCommand("u178",TCommand::kUpdate,TCommand::kCode);
	u178->SetExecutable(&SW_FROM_PS_u178_exe_g);
	u178->Code() = "u178 <- 0";
	u178->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u179 = (TExecuteCommand*) TOTAL_OUT.GetCommand("u179",TCommand::kUpdate,TCommand::kCode);
	u179->SetExecutable(&TOTAL_OUT_u179_exe_g);
	u179->Code() = "u179 <- ( ( ( ( ( ( INTERCEPT+SATW_OUTFLUX )+SATW_RECHARGE )+SATW_TRANSP )+SW_EVAP )+SW_OUTFLUX )+UW_ETRANSP )";
	u179->AddDependency(INTERCEPT);
	u179->AddDependency(SATW_OUTFLUX);
	u179->AddDependency(SATW_RECHARGE);
	u179->AddDependency(SATW_TRANSP);
	u179->AddDependency(SW_EVAP);
	u179->AddDependency(SW_OUTFLUX);
	u179->AddDependency(UW_ETRANSP);
	u179->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u180 = (TExecuteCommand*) TOTAL_PRECIP.GetCommand("u180",TCommand::kUpdate,TCommand::kCode);
	u180->SetExecutable(&TOTAL_PRECIP_u180_exe_g);
	u180->Code() = "u180 <- ( RAINFALL+SNOWMELT )";
	u180->AddDependency(RAINFALL);
	u180->AddDependency(SNOWMELT);
	u180->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u181 = (TExecuteCommand*) TRANSPIRATION.GetCommand("u181",TCommand::kUpdate,TCommand::kCode);
	u181->SetExecutable(&TRANSPIRATION_u181_exe_g);
	u181->Code() = "u181 <- ( ( ( P1_C_TRANSP*SL::Min(((float)1), MACLAI) )*ETPM )*WATER_AVAIL )";
	u181->AddDependency(HABITATMAP);
	u181->AddDependency(P1_C_TRANSP);
	u181->AddDependency(MACLAI);
	u181->AddDependency(ETPM);
	u181->AddDependency(WATER_AVAIL);
	u181->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u182 = (TExecuteCommand*) UNSAT_CAP.GetCommand("u182",TCommand::kUpdate,TCommand::kCode);
	u182->SetExecutable(&UNSAT_CAP_u182_exe_g);
	u182->Code() = "u182 <- SL::Max(( UW_DEPTH*( P1_C_POROSITY-UW_MOIST_PRP ) ), ((float)0))";
	u182->AddDependency(UW_DEPTH);
	u182->AddDependency(SOIL);
	u182->AddDependency(P1_C_POROSITY);
	u182->AddDependency(UW_MOIST_PRP);
	u182->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u183 = (TExecuteCommand*) UW_CAPIL_EXP.GetCommand("u183",TCommand::kUpdate,TCommand::kCode);
	u183->SetExecutable(&UW_CAPIL_EXP_u183_exe_g);
	u183->Code() = "u183 <- SL::Exp(( -((float)10)*SL::Max(( UW_DEPTH-ROOT_DEPTH ), ((float)0)) ))";
	u183->AddDependency(UW_DEPTH);
	u183->AddDependency(ROOT_DEPTH);
	u183->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u184 = (TExecuteCommand*) UW_DELTA.GetCommand("u184",TCommand::kUpdate,TCommand::kCode);
	u184->SetExecutable(&UW_DELTA_u184_exe_g);
	u184->Code() = "u184 <- ( UW_DEPTH_BEFORE-UW_DEPTH )";
	u184->AddDependency(UW_DEPTH_BEFORE);
	u184->AddDependency(UW_DEPTH);
	u184->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u186 = (TExecuteCommand*) UW_DEPTH_BEFORE.GetCommand("u186",TCommand::kUpdate,TCommand::kCode);
	u186->SetExecutable(&UW_DEPTH_BEFORE_u186_exe_g);
	u186->Code() = "u186 <- UW_DEPTH.Delay( dT() )";
	u186->AddDependency(UW_DEPTH);
	u186->SetObjInfo(TCommand::kDepIndex, 2);
	TExecuteCommand* u187 = (TExecuteCommand*) UW_EXCESS.GetCommand("u187",TCommand::kUpdate,TCommand::kCode);
	u187->SetExecutable(&UW_EXCESS_u187_exe_g);
	u187->Code() = "u187 <- SL::Max(((float)0), ( UW_MOIST_PRP-P1_C_FIELD_CAP ))";
	u187->AddDependency(UW_MOIST_PRP);
	u187->AddDependency(SOIL);
	u187->AddDependency(P1_C_FIELD_CAP);
	u187->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u188 = (TExecuteCommand*) UW_MOIST_PRP.GetCommand("u188",TCommand::kUpdate,TCommand::kCode);
	u188->SetExecutable(&UW_MOIST_PRP_u188_exe_g);
	u188->Code() = "u188 <-  ( ( ( UW_DEPTH >  ((float)0) ) ) ? ( ( UNSAT_WATER/UW_DEPTH ) ) : ( ((float)0) ) ) ";
	u188->AddDependency(UW_DEPTH);
	u188->AddDependency(UNSAT_WATER);
	u188->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u189 = (TExecuteCommand*) UW_MP_R.GetCommand("u189",TCommand::kUpdate,TCommand::kCode);
	u189->SetExecutable(&UW_MP_R_u189_exe_g);
	u189->Code() = "u189 <- ( UW_MOIST_PRP/P1_C_POROSITY )";
	u189->AddDependency(UW_MOIST_PRP);
	u189->AddDependency(SOIL);
	u189->AddDependency(P1_C_POROSITY);
	u189->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u190 = (TExecuteCommand*) UW_PERC_RATE.GetCommand("u190",TCommand::kUpdate,TCommand::kCode);
	u190->SetExecutable(&UW_PERC_RATE_u190_exe_g);
	u190->Code() = "u190 <- ( ( ( ( ((float)2)*P1_C_VERT_HYDR_COND )*P1_C_POROSITY )*pow((double)UW_EXCESS,(double)0.4 ) )/( pow((double)( P1_C_POROSITY-P1_C_FIELD_CAP ),(double)0.4 )+pow((double)UW_EXCESS,(double)0.4 ) ) )";
	u190->AddDependency(SOIL);
	u190->AddDependency(P1_C_VERT_HYDR_COND);
	u190->AddDependency(P1_C_POROSITY);
	u190->AddDependency(UW_EXCESS);
	u190->AddDependency(P1_C_FIELD_CAP);
	u190->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u191 = (TExecuteCommand*) UW_TRANS_PR.GetCommand("u191",TCommand::kUpdate,TCommand::kCode);
	u191->SetExecutable(&UW_TRANS_PR_u191_exe_g);
	u191->Code() = "u191 <-  ( ( ( ( ROOT_DEPTH+0.1 ) <  UW_DEPTH ) ) ? ( ((float)1) ) : (  ( ( ( UW_DEPTH >  ((float)0) ) ) ? ( ( WATER_AVAIL*( UW_DEPTH/( ROOT_DEPTH+UW_CAPIL_EXP ) ) ) ) : ( ((float)0) ) )  ) ) ";
	u191->AddDependency(ROOT_DEPTH);
	u191->AddDependency(UW_DEPTH);
	u191->AddDependency(WATER_AVAIL);
	u191->AddDependency(UW_CAPIL_EXP);
	u191->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u193 = (TExecuteCommand*) WAT_TABLE.GetCommand("u193",TCommand::kUpdate,TCommand::kCode);
	u193->SetExecutable(&WAT_TABLE_u193_exe_g);
	u193->Code() = "u193 <- ( ( P1_IC_WT_TABLE+P1_DATUM_TO_MSL )-P1_DEPTH_MSL_MAP )";
	u193->AddDependency(P1_IC_WT_TABLE);
	u193->AddDependency(P1_DATUM_TO_MSL);
	u193->AddDependency(P1_DEPTH_MSL_MAP);
	u193->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u194 = (TExecuteCommand*) P1_C_EVAP.GetCommand("u194",TCommand::kUpdate,TCommand::kCode);
	u194->SetExecutable(&P1_C_EVAP_u194_exe_g);
	u194->Code() = "u194 <- 0.000482";
	u194->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u195 = (TExecuteCommand*) P1_C_FIELD_CAP.GetCommand("u195",TCommand::kUpdate,TCommand::kCode);
	u195->SetExecutable(&P1_C_FIELD_CAP_u195_exe_g);
	u195->Code() = "u195 <- 0.25";
	u195->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u196 = (TExecuteCommand*) P1_C_HORIZ_HC.GetCommand("u196",TCommand::kUpdate,TCommand::kCode);
	u196->SetExecutable(&P1_C_HORIZ_HC_u196_exe_g);
	u196->Code() = "u196 <- 0.11";
	u196->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u197 = (TExecuteCommand*) P1_C_HORIZ_HYDR_COND.GetCommand("u197",TCommand::kUpdate,TCommand::kCode);
	u197->SetExecutable(&P1_C_HORIZ_HYDR_COND_u197_exe_g);
	u197->Code() = "u197 <- ((float)5)";
	u197->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u198 = (TExecuteCommand*) P1_C_INFILT.GetCommand("u198",TCommand::kUpdate,TCommand::kCode);
	u198->SetExecutable(&P1_C_INFILT_u198_exe_g);
	u198->Code() = "u198 <- 0.06";
	u198->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u199 = (TExecuteCommand*) P1_C_INF_HAB.GetCommand("u199",TCommand::kUpdate,TCommand::kCode);
	u199->SetExecutable(&P1_C_INF_HAB_u199_exe_g);
	u199->Code() = "u199 <- ((float)1)";
	u199->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u200 = (TExecuteCommand*) P1_C_INF_SLOPE.GetCommand("u200",TCommand::kUpdate,TCommand::kCode);
	u200->SetExecutable(&P1_C_INF_SLOPE_u200_exe_g);
	u200->Code() = "u200 <- ((float)5)";
	u200->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u201 = (TExecuteCommand*) P1_C_INF_SOIL.GetCommand("u201",TCommand::kUpdate,TCommand::kCode);
	u201->SetExecutable(&P1_C_INF_SOIL_u201_exe_g);
	u201->Code() = "u201 <- 4.00";
	u201->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u202 = (TExecuteCommand*) P1_C_INTERCEP.GetCommand("u202",TCommand::kUpdate,TCommand::kCode);
	u202->SetExecutable(&P1_C_INTERCEP_u202_exe_g);
	u202->Code() = "u202 <- 0.002";
	u202->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u203 = (TExecuteCommand*) P1_C_INTERCEPVEG.GetCommand("u203",TCommand::kUpdate,TCommand::kCode);
	u203->SetExecutable(&P1_C_INTERCEPVEG_u203_exe_g);
	u203->Code() = "u203 <- 0.001";
	u203->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u204 = (TExecuteCommand*) P1_C_POROSITY.GetCommand("u204",TCommand::kUpdate,TCommand::kCode);
	u204->SetExecutable(&P1_C_POROSITY_u204_exe_g);
	u204->Code() = "u204 <- 0.41";
	u204->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u205 = (TExecuteCommand*) P1_C_RECHG.GetCommand("u205",TCommand::kUpdate,TCommand::kCode);
	u205->SetExecutable(&P1_C_RECHG_u205_exe_g);
	u205->Code() = "u205 <- 0.00001";
	u205->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u206 = (TExecuteCommand*) P1_C_SATW_OUT.GetCommand("u206",TCommand::kUpdate,TCommand::kCode);
	u206->SetExecutable(&P1_C_SATW_OUT_u206_exe_g);
	u206->Code() = "u206 <- 0.";
	u206->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u207 = (TExecuteCommand*) P1_C_SW_MELT.GetCommand("u207",TCommand::kUpdate,TCommand::kCode);
	u207->SetExecutable(&P1_C_SW_MELT_u207_exe_g);
	u207->Code() = "u207 <- 0.005";
	u207->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u208 = (TExecuteCommand*) P1_C_SW_OUT.GetCommand("u208",TCommand::kUpdate,TCommand::kCode);
	u208->SetExecutable(&P1_C_SW_OUT_u208_exe_g);
	u208->Code() = "u208 <- 0.";
	u208->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u209 = (TExecuteCommand*) P1_C_TRANSP.GetCommand("u209",TCommand::kUpdate,TCommand::kCode);
	u209->SetExecutable(&P1_C_TRANSP_u209_exe_g);
	u209->Code() = "u209 <- 0.5";
	u209->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u210 = (TExecuteCommand*) P1_C_UW_EVAP.GetCommand("u210",TCommand::kUpdate,TCommand::kCode);
	u210->SetExecutable(&P1_C_UW_EVAP_u210_exe_g);
	u210->Code() = "u210 <- 0.5";
	u210->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u211 = (TExecuteCommand*) P1_C_VERT_HYDR_COND.GetCommand("u211",TCommand::kUpdate,TCommand::kCode);
	u211->SetExecutable(&P1_C_VERT_HYDR_COND_u211_exe_g);
	u211->Code() = "u211 <- 0.007";
	u211->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u212 = (TExecuteCommand*) P1_C_ZIG.GetCommand("u212",TCommand::kUpdate,TCommand::kCode);
	u212->SetExecutable(&P1_C_ZIG_u212_exe_g);
	u212->Code() = "u212 <- ((float)25)";
	u212->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u213 = (TExecuteCommand*) P1_IC_SW_DEPTH.GetCommand("u213",TCommand::kUpdate,TCommand::kCode);
	u213->SetExecutable(&P1_IC_SW_DEPTH_u213_exe_g);
	u213->Code() = "u213 <- ((float)0)";
	u213->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u214 = (TExecuteCommand*) P1_IC_UW_MOIST_PR.GetCommand("u214",TCommand::kUpdate,TCommand::kCode);
	u214->SetExecutable(&P1_IC_UW_MOIST_PR_u214_exe_g);
	u214->Code() = "u214 <- 0.25";
	u214->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u215 = (TExecuteCommand*) P1_IC_WT_TABLE.GetCommand("u215",TCommand::kUpdate,TCommand::kCode);
	u215->SetExecutable(&P1_IC_WT_TABLE_u215_exe_g);
	u215->Code() = "u215 <- ((float)25)";
	u215->SetObjInfo(TCommand::kDepIndex, 5);
	return 0;
}

int HYDROLOGY_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int HYDROLOGY_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int HYDROLOGY_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int HYDROLOGY_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class XXXIMPORTS4_module 
// ---------------------------------------------------------------------------
XXXIMPORTS4_module::XXXIMPORTS4_module(char* name) :
	TIME("TIME"),
	CELL_SIZE("CELL_SIZE"),
	CLOUDY("CLOUDY"),
	DAYJUL("DAYJUL"),
	DIN_SD("DIN_SD"),
	DIN_SF("DIN_SF"),
	ELEVATION("ELEVATION"),
	ELEV_MIN("ELEV_MIN"),
	HABITATMAP("HABITATMAP"),
	HYDRO("HYDRO"),
	ON_MAP("ON_MAP"),
	OUTPUTCOL("OUTPUTCOL"),
	OUTPUTROW("OUTPUTROW"),
	OUTPUTVAR("OUTPUTVAR"),
	ROOT_DEPTH("ROOT_DEPTH"),
	SOIL("SOIL"),
	VAP_PRESS("VAP_PRESS"),
	P1_C_SURF_DELTA("P1_C_SURF_DELTA"),
	P1_DATUM_TO_MSL("P1_DATUM_TO_MSL"),
	P1_DEPTH_MSL_MAP("P1_DEPTH_MSL_MAP"),
	AIR_TEMP_C("AIR_TEMP_C"),
	ETPM("ETPM"),
	HUMIDITY("HUMIDITY"),
	MACH("MACH"),
	MACLAI("MACLAI"),
	PRECIP_M("PRECIP_M"),
	SOLRADATM("SOLRADATM"),
	SOLRADGRD("SOLRADGRD"),
	WIND("WIND"),
	TModule(name) {

}	
int XXXIMPORTS4_module::CELL_SIZE_u216_exe() {
	float value;

	switch( CELL_SIZE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CELL_SIZE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)40000);
			CELL_SIZE.Update( p, CELL_SIZE.ParameterValue(value,p) );
		}
		CELL_SIZE.GrabMemory();
		if( CELL_SIZE.GetF(FLinkEdges) ) { CELL_SIZE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)40000);
			CELL_SIZE.Update( CELL_SIZE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::CLOUDY_u217_exe() {
	float value;

	switch( CLOUDY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CLOUDY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( PRECIP_M.Value(p) >  ((float)0) ) ) ? ( SL::Max(((float)0), ( ((float)10)-( 1.155*pow((double)( VAP_PRESS.Value(p)/( ( PRECIP_M.Value(p)*((float)1000) )*((float)30) ) ),(double)0.5 ) ) )) ) : ( ((float)0) ) ) ;
			CLOUDY.Update( p, value );
		}
		CLOUDY.GrabMemory();
		if( CLOUDY.GetF(FLinkEdges) ) { CLOUDY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( PRECIP_M.Value() >  ((float)0) ) ) ? ( SL::Max(((float)0), ( ((float)10)-( 1.155*pow((double)( VAP_PRESS.Value()/( ( PRECIP_M.Value()*((float)1000) )*((float)30) ) ),(double)0.5 ) ) )) ) : ( ((float)0) ) ) ;
			CLOUDY.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::DAYJUL_u218_exe() {
	float value;

	switch( DAYJUL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DAYJUL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SL::Mod(( TIME.Value()-dT() ), ((float)365))+((float)1) );
			DAYJUL.Update( p, value );
		}
		DAYJUL.GrabMemory();
		if( DAYJUL.GetF(FLinkEdges) ) { DAYJUL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SL::Mod(( TIME.Value()-dT() ), ((float)365))+((float)1) );
			DAYJUL.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::DIN_SD_u219_exe() {
	float value;

	switch( DIN_SD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)1)+( ((float)0)*HABITATMAP.Value(p) ) );
			DIN_SD.Update( p, value );
		}
		DIN_SD.GrabMemory();
		if( DIN_SD.GetF(FLinkEdges) ) { DIN_SD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)1)+( ((float)0)*HABITATMAP.Value() ) );
			DIN_SD.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::DIN_SF_u220_exe() {
	float value;

	switch( DIN_SF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)1)+( ((float)0)*HABITATMAP.Value(p) ) );
			DIN_SF.Update( p, value );
		}
		DIN_SF.GrabMemory();
		if( DIN_SF.GetF(FLinkEdges) ) { DIN_SF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)1)+( ((float)0)*HABITATMAP.Value() ) );
			DIN_SF.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::ELEVATION_u221_exe() {
	float value;

	switch( ELEVATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ELEVATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_DATUM_TO_MSL.Value(p)+((float)30) );
			ELEVATION.Update( p, value );
		}
		ELEVATION.GrabMemory();
		if( ELEVATION.GetF(FLinkEdges) ) { ELEVATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_DATUM_TO_MSL.Value()+((float)30) );
			ELEVATION.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::ELEV_MIN_u222_exe() {
	float value;

	switch( ELEV_MIN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ELEV_MIN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ELEVATION.Value(p)-P1_C_SURF_DELTA.Value(p) );
			ELEV_MIN.Update( p, value );
		}
		ELEV_MIN.GrabMemory();
		if( ELEV_MIN.GetF(FLinkEdges) ) { ELEV_MIN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ELEVATION.Value()-P1_C_SURF_DELTA.Value() );
			ELEV_MIN.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::HABITATMAP_u223_exe() {
	float value;

	switch( HABITATMAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HABITATMAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)2);
			HABITATMAP.Update( p, HABITATMAP.ParameterValue(value,p) );
		}
		HABITATMAP.GrabMemory();
		if( HABITATMAP.GetF(FLinkEdges) ) { HABITATMAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)2);
			HABITATMAP.Update( HABITATMAP.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::HYDRO_u224_exe() {
	float value;

	switch( HYDRO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HYDRO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			HYDRO.Update( p, HYDRO.ParameterValue(value,p) );
		}
		HYDRO.GrabMemory();
		if( HYDRO.GetF(FLinkEdges) ) { HYDRO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			HYDRO.Update( HYDRO.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::ON_MAP_u225_exe() {
	float value;

	switch( ON_MAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ON_MAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			ON_MAP.Update( p, ON_MAP.ParameterValue(value,p) );
		}
		ON_MAP.GrabMemory();
		if( ON_MAP.GetF(FLinkEdges) ) { ON_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			ON_MAP.Update( ON_MAP.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::OUTPUTCOL_u226_exe() {
	float value;

	switch( OUTPUTCOL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = OUTPUTCOL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)57);
			OUTPUTCOL.Update( p, OUTPUTCOL.ParameterValue(value,p) );
		}
		OUTPUTCOL.GrabMemory();
		if( OUTPUTCOL.GetF(FLinkEdges) ) { OUTPUTCOL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)57);
			OUTPUTCOL.Update( OUTPUTCOL.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::OUTPUTROW_u227_exe() {
	float value;

	switch( OUTPUTROW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = OUTPUTROW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)108);
			OUTPUTROW.Update( p, OUTPUTROW.ParameterValue(value,p) );
		}
		OUTPUTROW.GrabMemory();
		if( OUTPUTROW.GetF(FLinkEdges) ) { OUTPUTROW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)108);
			OUTPUTROW.Update( OUTPUTROW.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::OUTPUTVAR_u228_exe() {
	float value;

	switch( OUTPUTVAR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = OUTPUTVAR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( HABITATMAP.Value(p)*((float)0) );
			OUTPUTVAR.Update( p, value );
		}
		OUTPUTVAR.GrabMemory();
		if( OUTPUTVAR.GetF(FLinkEdges) ) { OUTPUTVAR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( HABITATMAP.Value()*((float)0) );
			OUTPUTVAR.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::ROOT_DEPTH_u229_exe() {
	float value;

	switch( ROOT_DEPTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ROOT_DEPTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)2);
			ROOT_DEPTH.Update( p, ROOT_DEPTH.ParameterValue(value,p) );
		}
		ROOT_DEPTH.GrabMemory();
		if( ROOT_DEPTH.GetF(FLinkEdges) ) { ROOT_DEPTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)2);
			ROOT_DEPTH.Update( ROOT_DEPTH.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::SOIL_u230_exe() {
	float value;

	switch( SOIL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SOIL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			SOIL.Update( p, SOIL.ParameterValue(value,p) );
		}
		SOIL.GrabMemory();
		if( SOIL.GetF(FLinkEdges) ) { SOIL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			SOIL.Update( SOIL.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::VAP_PRESS_u231_exe() {
	float value;

	switch( VAP_PRESS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = VAP_PRESS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( HUMIDITY.Value(p)*6.1078 )*SL::Exp(( ( 17.269*AIR_TEMP_C.Value(p) )/( AIR_TEMP_C.Value(p)+237.3 ) )) );
			VAP_PRESS.Update( p, value );
		}
		VAP_PRESS.GrabMemory();
		if( VAP_PRESS.GetF(FLinkEdges) ) { VAP_PRESS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( HUMIDITY.Value()*6.1078 )*SL::Exp(( ( 17.269*AIR_TEMP_C.Value() )/( AIR_TEMP_C.Value()+237.3 ) )) );
			VAP_PRESS.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::P1_C_SURF_DELTA_u232_exe() {
	float value;

	switch( P1_C_SURF_DELTA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_SURF_DELTA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  3.;
			P1_C_SURF_DELTA.Update( p, P1_C_SURF_DELTA.ParameterValue(value,p) );
		}
		P1_C_SURF_DELTA.GrabMemory();
		if( P1_C_SURF_DELTA.GetF(FLinkEdges) ) { P1_C_SURF_DELTA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  3.;
			P1_C_SURF_DELTA.Update( P1_C_SURF_DELTA.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::P1_DATUM_TO_MSL_u233_exe() {
	float value;

	switch( P1_DATUM_TO_MSL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DATUM_TO_MSL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)10);
			P1_DATUM_TO_MSL.Update( p, P1_DATUM_TO_MSL.ParameterValue(value,p) );
		}
		P1_DATUM_TO_MSL.GrabMemory();
		if( P1_DATUM_TO_MSL.GetF(FLinkEdges) ) { P1_DATUM_TO_MSL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)10);
			P1_DATUM_TO_MSL.Update( P1_DATUM_TO_MSL.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::P1_DEPTH_MSL_MAP_u234_exe() {
	float value;

	switch( P1_DEPTH_MSL_MAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DEPTH_MSL_MAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_DEPTH_MSL_MAP.Update( p, P1_DEPTH_MSL_MAP.ParameterValue(value,p) );
		}
		P1_DEPTH_MSL_MAP.GrabMemory();
		if( P1_DEPTH_MSL_MAP.GetF(FLinkEdges) ) { P1_DEPTH_MSL_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_DEPTH_MSL_MAP.Update( P1_DEPTH_MSL_MAP.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::AIR_TEMP_C_u235_exe() {
	float value;

	switch( AIR_TEMP_C.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = AIR_TEMP_C.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph17(DAYJUL.Value(p));
			AIR_TEMP_C.Update( p, value );
		}
		AIR_TEMP_C.GrabMemory();
		if( AIR_TEMP_C.GetF(FLinkEdges) ) { AIR_TEMP_C.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph17(DAYJUL.Value());
			AIR_TEMP_C.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::ETPM_u236_exe() {
	float value;

	switch( ETPM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ETPM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph18(DAYJUL.Value(p));
			ETPM.Update( p, value );
		}
		ETPM.GrabMemory();
		if( ETPM.GetF(FLinkEdges) ) { ETPM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph18(DAYJUL.Value());
			ETPM.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::HUMIDITY_u237_exe() {
	float value;

	switch( HUMIDITY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HUMIDITY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph19(DAYJUL.Value(p));
			HUMIDITY.Update( p, value );
		}
		HUMIDITY.GrabMemory();
		if( HUMIDITY.GetF(FLinkEdges) ) { HUMIDITY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph19(DAYJUL.Value());
			HUMIDITY.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::MACH_u238_exe() {
	float value;

	switch( MACH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MACH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph20(DAYJUL.Value(p));
			MACH.Update( p, value );
		}
		MACH.GrabMemory();
		if( MACH.GetF(FLinkEdges) ) { MACH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph20(DAYJUL.Value());
			MACH.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::MACLAI_u239_exe() {
	float value;

	switch( MACLAI.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MACLAI.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph21(DAYJUL.Value(p));
			MACLAI.Update( p, value );
		}
		MACLAI.GrabMemory();
		if( MACLAI.GetF(FLinkEdges) ) { MACLAI.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph21(DAYJUL.Value());
			MACLAI.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::PRECIP_M_u240_exe() {
	float value;

	switch( PRECIP_M.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PRECIP_M.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph22(DAYJUL.Value(p));
			PRECIP_M.Update( p, value );
		}
		PRECIP_M.GrabMemory();
		if( PRECIP_M.GetF(FLinkEdges) ) { PRECIP_M.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph22(DAYJUL.Value());
			PRECIP_M.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::SOLRADATM_u241_exe() {
	float value;

	switch( SOLRADATM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SOLRADATM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph23(DAYJUL.Value(p));
			SOLRADATM.Update( p, value );
		}
		SOLRADATM.GrabMemory();
		if( SOLRADATM.GetF(FLinkEdges) ) { SOLRADATM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph23(DAYJUL.Value());
			SOLRADATM.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::SOLRADGRD_u242_exe() {
	float value;

	switch( SOLRADGRD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SOLRADGRD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph24(DAYJUL.Value(p));
			SOLRADGRD.Update( p, value );
		}
		SOLRADGRD.GrabMemory();
		if( SOLRADGRD.GetF(FLinkEdges) ) { SOLRADGRD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph24(DAYJUL.Value());
			SOLRADGRD.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS4_module::WIND_u243_exe() {
	float value;

	switch( WIND.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WIND.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph25(DAYJUL.Value(p));
			WIND.Update( p, value );
		}
		WIND.GrabMemory();
		if( WIND.GetF(FLinkEdges) ) { WIND.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph25(DAYJUL.Value());
			WIND.Update( value );
	  } break;
	}
	return 0;
}

XXXIMPORTS4_module* XXXIMPORTS4_module::fInstance = NULL;
XXXIMPORTS4_module* XXXIMPORTS4_module::kNullModel = (XXXIMPORTS4_module*)0x1;
int XXXIMPORTS4_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int XXXIMPORTS4_module::InitVars() {
	
	TIME.SSInit(this);
	CELL_SIZE.SSInit(this);
	CLOUDY.SSInit(this);
	DAYJUL.SSInit(this);
	DIN_SD.SSInit(this);
	DIN_SF.SSInit(this);
	ELEVATION.SSInit(this);
	ELEV_MIN.SSInit(this);
	HABITATMAP.SSInit(this);
	HYDRO.SSInit(this);
	ON_MAP.SSInit(this);
	OUTPUTCOL.SSInit(this);
	OUTPUTROW.SSInit(this);
	OUTPUTVAR.SSInit(this);
	ROOT_DEPTH.SSInit(this);
	SOIL.SSInit(this);
	VAP_PRESS.SSInit(this);
	P1_C_SURF_DELTA.SSInit(this);
	P1_DATUM_TO_MSL.SSInit(this);
	P1_DEPTH_MSL_MAP.SSInit(this);
	AIR_TEMP_C.SSInit(this);
	ETPM.SSInit(this);
	HUMIDITY.SSInit(this);
	MACH.SSInit(this);
	MACLAI.SSInit(this);
	PRECIP_M.SSInit(this);
	SOLRADATM.SSInit(this);
	SOLRADGRD.SSInit(this);
	WIND.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int XXXIMPORTS4_module::SetupEvents() {
	TExecuteCommand* u216 = (TExecuteCommand*) CELL_SIZE.GetCommand("u216",TCommand::kUpdate,TCommand::kCode);
	u216->SetExecutable(&CELL_SIZE_u216_exe_g);
	u216->Code() = "u216 <- ((float)40000)";
	u216->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u217 = (TExecuteCommand*) CLOUDY.GetCommand("u217",TCommand::kUpdate,TCommand::kCode);
	u217->SetExecutable(&CLOUDY_u217_exe_g);
	u217->Code() = "u217 <-  ( ( ( PRECIP_M >  ((float)0) ) ) ? ( SL::Max(((float)0), ( ((float)10)-( 1.155*pow((double)( VAP_PRESS/( ( PRECIP_M*((float)1000) )*((float)30) ) ),(double)0.5 ) ) )) ) : ( ((float)0) ) ) ";
	u217->AddDependency(PRECIP_M);
	u217->AddDependency(VAP_PRESS);
	u217->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u218 = (TExecuteCommand*) DAYJUL.GetCommand("u218",TCommand::kUpdate,TCommand::kCode);
	u218->SetExecutable(&DAYJUL_u218_exe_g);
	u218->Code() = "u218 <- ( SL::Mod(( TIME-dT() ), ((float)365))+((float)1) )";
	u218->AddDependency(TIME);
	u218->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u219 = (TExecuteCommand*) DIN_SD.GetCommand("u219",TCommand::kUpdate,TCommand::kCode);
	u219->SetExecutable(&DIN_SD_u219_exe_g);
	u219->Code() = "u219 <- ( ((float)1)+( ((float)0)*HABITATMAP ) )";
	u219->AddDependency(HABITATMAP);
	u219->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u220 = (TExecuteCommand*) DIN_SF.GetCommand("u220",TCommand::kUpdate,TCommand::kCode);
	u220->SetExecutable(&DIN_SF_u220_exe_g);
	u220->Code() = "u220 <- ( ((float)1)+( ((float)0)*HABITATMAP ) )";
	u220->AddDependency(HABITATMAP);
	u220->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u221 = (TExecuteCommand*) ELEVATION.GetCommand("u221",TCommand::kUpdate,TCommand::kCode);
	u221->SetExecutable(&ELEVATION_u221_exe_g);
	u221->Code() = "u221 <- ( P1_DATUM_TO_MSL+((float)30) )";
	u221->AddDependency(P1_DATUM_TO_MSL);
	u221->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u222 = (TExecuteCommand*) ELEV_MIN.GetCommand("u222",TCommand::kUpdate,TCommand::kCode);
	u222->SetExecutable(&ELEV_MIN_u222_exe_g);
	u222->Code() = "u222 <- ( ELEVATION-P1_C_SURF_DELTA )";
	u222->AddDependency(ELEVATION);
	u222->AddDependency(P1_C_SURF_DELTA);
	u222->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u223 = (TExecuteCommand*) HABITATMAP.GetCommand("u223",TCommand::kUpdate,TCommand::kCode);
	u223->SetExecutable(&HABITATMAP_u223_exe_g);
	u223->Code() = "u223 <- ((float)2)";
	u223->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u224 = (TExecuteCommand*) HYDRO.GetCommand("u224",TCommand::kUpdate,TCommand::kCode);
	u224->SetExecutable(&HYDRO_u224_exe_g);
	u224->Code() = "u224 <- ((float)1)";
	u224->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u225 = (TExecuteCommand*) ON_MAP.GetCommand("u225",TCommand::kUpdate,TCommand::kCode);
	u225->SetExecutable(&ON_MAP_u225_exe_g);
	u225->Code() = "u225 <- ((float)1)";
	u225->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u226 = (TExecuteCommand*) OUTPUTCOL.GetCommand("u226",TCommand::kUpdate,TCommand::kCode);
	u226->SetExecutable(&OUTPUTCOL_u226_exe_g);
	u226->Code() = "u226 <- ((float)57)";
	u226->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u227 = (TExecuteCommand*) OUTPUTROW.GetCommand("u227",TCommand::kUpdate,TCommand::kCode);
	u227->SetExecutable(&OUTPUTROW_u227_exe_g);
	u227->Code() = "u227 <- ((float)108)";
	u227->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u228 = (TExecuteCommand*) OUTPUTVAR.GetCommand("u228",TCommand::kUpdate,TCommand::kCode);
	u228->SetExecutable(&OUTPUTVAR_u228_exe_g);
	u228->Code() = "u228 <- ( HABITATMAP*((float)0) )";
	u228->AddDependency(HABITATMAP);
	u228->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u229 = (TExecuteCommand*) ROOT_DEPTH.GetCommand("u229",TCommand::kUpdate,TCommand::kCode);
	u229->SetExecutable(&ROOT_DEPTH_u229_exe_g);
	u229->Code() = "u229 <- ((float)2)";
	u229->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u230 = (TExecuteCommand*) SOIL.GetCommand("u230",TCommand::kUpdate,TCommand::kCode);
	u230->SetExecutable(&SOIL_u230_exe_g);
	u230->Code() = "u230 <- ((float)1)";
	u230->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u231 = (TExecuteCommand*) VAP_PRESS.GetCommand("u231",TCommand::kUpdate,TCommand::kCode);
	u231->SetExecutable(&VAP_PRESS_u231_exe_g);
	u231->Code() = "u231 <- ( ( HUMIDITY*6.1078 )*SL::Exp(( ( 17.269*AIR_TEMP_C )/( AIR_TEMP_C+237.3 ) )) )";
	u231->AddDependency(HUMIDITY);
	u231->AddDependency(AIR_TEMP_C);
	u231->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u232 = (TExecuteCommand*) P1_C_SURF_DELTA.GetCommand("u232",TCommand::kUpdate,TCommand::kCode);
	u232->SetExecutable(&P1_C_SURF_DELTA_u232_exe_g);
	u232->Code() = "u232 <- 3.";
	u232->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u233 = (TExecuteCommand*) P1_DATUM_TO_MSL.GetCommand("u233",TCommand::kUpdate,TCommand::kCode);
	u233->SetExecutable(&P1_DATUM_TO_MSL_u233_exe_g);
	u233->Code() = "u233 <- ((float)10)";
	u233->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u234 = (TExecuteCommand*) P1_DEPTH_MSL_MAP.GetCommand("u234",TCommand::kUpdate,TCommand::kCode);
	u234->SetExecutable(&P1_DEPTH_MSL_MAP_u234_exe_g);
	u234->Code() = "u234 <- ((float)0)";
	u234->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u235 = (TExecuteCommand*) AIR_TEMP_C.GetCommand("u235",TCommand::kUpdate,TCommand::kCode);
	u235->SetExecutable(&AIR_TEMP_C_u235_exe_g);
	u235->Code() = "u235 <- Graph17(DAYJUL)";
	u235->AddDependency(DAYJUL);
	u235->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u236 = (TExecuteCommand*) ETPM.GetCommand("u236",TCommand::kUpdate,TCommand::kCode);
	u236->SetExecutable(&ETPM_u236_exe_g);
	u236->Code() = "u236 <- Graph18(DAYJUL)";
	u236->AddDependency(DAYJUL);
	u236->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u237 = (TExecuteCommand*) HUMIDITY.GetCommand("u237",TCommand::kUpdate,TCommand::kCode);
	u237->SetExecutable(&HUMIDITY_u237_exe_g);
	u237->Code() = "u237 <- Graph19(DAYJUL)";
	u237->AddDependency(DAYJUL);
	u237->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u238 = (TExecuteCommand*) MACH.GetCommand("u238",TCommand::kUpdate,TCommand::kCode);
	u238->SetExecutable(&MACH_u238_exe_g);
	u238->Code() = "u238 <- Graph20(DAYJUL)";
	u238->AddDependency(DAYJUL);
	u238->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u239 = (TExecuteCommand*) MACLAI.GetCommand("u239",TCommand::kUpdate,TCommand::kCode);
	u239->SetExecutable(&MACLAI_u239_exe_g);
	u239->Code() = "u239 <- Graph21(DAYJUL)";
	u239->AddDependency(DAYJUL);
	u239->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u240 = (TExecuteCommand*) PRECIP_M.GetCommand("u240",TCommand::kUpdate,TCommand::kCode);
	u240->SetExecutable(&PRECIP_M_u240_exe_g);
	u240->Code() = "u240 <- Graph22(DAYJUL)";
	u240->AddDependency(DAYJUL);
	u240->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u241 = (TExecuteCommand*) SOLRADATM.GetCommand("u241",TCommand::kUpdate,TCommand::kCode);
	u241->SetExecutable(&SOLRADATM_u241_exe_g);
	u241->Code() = "u241 <- Graph23(DAYJUL)";
	u241->AddDependency(DAYJUL);
	u241->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u242 = (TExecuteCommand*) SOLRADGRD.GetCommand("u242",TCommand::kUpdate,TCommand::kCode);
	u242->SetExecutable(&SOLRADGRD_u242_exe_g);
	u242->Code() = "u242 <- Graph24(DAYJUL)";
	u242->AddDependency(DAYJUL);
	u242->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u243 = (TExecuteCommand*) WIND.GetCommand("u243",TCommand::kUpdate,TCommand::kCode);
	u243->SetExecutable(&WIND_u243_exe_g);
	u243->Code() = "u243 <- Graph25(DAYJUL)";
	u243->AddDependency(DAYJUL);
	u243->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int XXXIMPORTS4_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int XXXIMPORTS4_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int XXXIMPORTS4_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int XXXIMPORTS4_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class GLOBALS_module 
// ---------------------------------------------------------------------------
GLOBALS_module::GLOBALS_module(char* name) :
	TIME("TIME"),
	P1_C_LATDEG("P1_C_LATDEG"),
	CLOUDY("CLOUDY"),
	DAYJUL("DAYJUL"),
	AIR_TEMP_C("AIR_TEMP_C"),
	HABITATMAP("HABITATMAP"),
	DAYLENGTH("DAYLENGTH"),
	ELEVATION("ELEVATION"),
	ON_MAP("ON_MAP"),
	PRECIP_M("PRECIP_M"),
	HYDRO("HYDRO"),
	CELL_SIZE("CELL_SIZE"),
	SOIL("SOIL"),
	HUMIDITY("HUMIDITY"),
	WIND("WIND"),
	ELEV_MIN("ELEV_MIN"),
	P1_DATUM_TO_MSL("P1_DATUM_TO_MSL"),
	P1_DEPTH_MSL_MAP("P1_DEPTH_MSL_MAP"),
	SOLRADATM("SOLRADATM"),
	SOLRADGRD("SOLRADGRD"),
	VAP_PRESS("VAP_PRESS"),
	P1_SEWERMAP("P1_SEWERMAP"),
	P1_POP_DENS("P1_POP_DENS"),
	HABITATMAPDB("HABITATMAPDB"),
	AMPL("AMPL"),
	LENGTH("LENGTH"),
	PAR("PAR"),
	PAR_G("PAR_G"),
	ROADS("ROADS"),
	VAP_SAT_DEFICIT("VAP_SAT_DEFICIT"),
	P1_BO_COEF("P1_BO_COEF"),
	P1_C_SURF_DELTA("P1_C_SURF_DELTA"),
	P1_ELEV_MSL_MAP("P1_ELEV_MSL_MAP"),
	P1_RAD_CONV("P1_RAD_CONV"),
	P1_RAIN_CONV("P1_RAIN_CONV"),
	P1_WIND_CONV("P1_WIND_CONV"),
	AIR_TEMP_MAX("AIR_TEMP_MAX"),
	AIR_TEMP_MIN("AIR_TEMP_MIN"),
	PRECIPITATION("PRECIPITATION"),
	WIND_SPEED("WIND_SPEED"),
	TModule(name) {

	P1_C_LATDEG.SetF(FisExport,True,"CG");
	CLOUDY.SetF(FisExport,True,"CG");
	DAYJUL.SetF(FisExport,True,"CG");
	AIR_TEMP_C.SetF(FisExport,True,"CG");
	HABITATMAP.SetF(FisExport,True,"CG");
	DAYLENGTH.SetF(FisExport,True,"CG");
	ELEVATION.SetF(FisExport,True,"CG");
	ON_MAP.SetF(FisExport,True,"CG");
	PRECIP_M.SetF(FisExport,True,"CG");
	HYDRO.SetF(FisExport,True,"CG");
	CELL_SIZE.SetF(FisExport,True,"CG");
	SOIL.SetF(FisExport,True,"CG");
	HUMIDITY.SetF(FisExport,True,"CG");
	WIND.SetF(FisExport,True,"CG");
	ELEV_MIN.SetF(FisExport,True,"CG");
	P1_DATUM_TO_MSL.SetF(FisExport,True,"CG");
	P1_DEPTH_MSL_MAP.SetF(FisExport,True,"CG");
	SOLRADATM.SetF(FisImport,True,"CG");
	SOLRADGRD.SetF(FisImport,True,"CG");
	VAP_PRESS.SetF(FisExport,True,"CG");
	P1_SEWERMAP.SetF(FisExport,True,"CG");
	P1_POP_DENS.SetF(FisExport,True,"CG");
	HABITATMAPDB.SetF(FisExport,True,"CG");
}	
int GLOBALS_module::AIR_TEMP_C_u244_exe() {
	float value;

	switch( AIR_TEMP_C.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = AIR_TEMP_C.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( AIR_TEMP_MAX.Value(p)+AIR_TEMP_MIN.Value(p) )/2. )-((float)32) )*((float)5) )/9 );
			AIR_TEMP_C.Update( p, value );
		}
		AIR_TEMP_C.GrabMemory();
		if( AIR_TEMP_C.GetF(FLinkEdges) ) { AIR_TEMP_C.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( AIR_TEMP_MAX.Value()+AIR_TEMP_MIN.Value() )/2. )-((float)32) )*((float)5) )/9 );
			AIR_TEMP_C.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::AMPL_u245_exe() {
	float value;

	switch( AMPL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = AMPL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SL::Exp(( 7.42+( 0.045*P1_C_LATDEG.Value(p) ) ))/3600 );
			AMPL.Update( p, value );
		}
		AMPL.GrabMemory();
		if( AMPL.GetF(FLinkEdges) ) { AMPL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SL::Exp(( 7.42+( 0.045*P1_C_LATDEG.Value() ) ))/3600 );
			AMPL.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::CELL_SIZE_u246_exe() {
	float value;

	switch( CELL_SIZE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CELL_SIZE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  40000;
			CELL_SIZE.Update( p, CELL_SIZE.ParameterValue(value,p) );
		}
		CELL_SIZE.GrabMemory();
		if( CELL_SIZE.GetF(FLinkEdges) ) { CELL_SIZE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  40000;
			CELL_SIZE.Update( CELL_SIZE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::CLOUDY_u247_exe() {
	float value;

	switch( CLOUDY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CLOUDY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( PRECIP_M.Value(p) >  ((float)0) ) ) ? ( SL::Max(((float)0), ( ((float)10)-( 1.155*pow((double)( VAP_PRESS.Value(p)/( ( PRECIP_M.Value(p)*25.4 )*((float)30) ) ),(double)0.5 ) ) )) ) : ( ((float)0) ) ) ;
			CLOUDY.Update( p, value );
		}
		CLOUDY.GrabMemory();
		if( CLOUDY.GetF(FLinkEdges) ) { CLOUDY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( PRECIP_M.Value() >  ((float)0) ) ) ? ( SL::Max(((float)0), ( ((float)10)-( 1.155*pow((double)( VAP_PRESS.Value()/( ( PRECIP_M.Value()*25.4 )*((float)30) ) ),(double)0.5 ) ) )) ) : ( ((float)0) ) ) ;
			CLOUDY.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::DAYJUL_u248_exe() {
	float value;

	switch( DAYJUL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DAYJUL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SL::Mod(( TIME.Value()-dT() ), ((float)365))+((float)1) );
			DAYJUL.Update( p, value );
		}
		DAYJUL.GrabMemory();
		if( DAYJUL.GetF(FLinkEdges) ) { DAYJUL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SL::Mod(( TIME.Value()-dT() ), ((float)365))+((float)1) );
			DAYJUL.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::DAYLENGTH_u249_exe() {
	float value;

	switch( DAYLENGTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DAYLENGTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( AMPL.Value(p)*SL::Sin(( ( DAYJUL.Value(p)-((float)79) )*0.01721 )) )+((float)12) );
			DAYLENGTH.Update( p, value );
		}
		DAYLENGTH.GrabMemory();
		if( DAYLENGTH.GetF(FLinkEdges) ) { DAYLENGTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( AMPL.Value()*SL::Sin(( ( DAYJUL.Value()-((float)79) )*0.01721 )) )+((float)12) );
			DAYLENGTH.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::ELEVATION_u250_exe() {
	float value;

	switch( ELEVATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ELEVATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( P1_DEPTH_MSL_MAP.Value(p) >  ((float)0) ) ) ? ( ( P1_DATUM_TO_MSL.Value(p)-P1_DEPTH_MSL_MAP.Value(p) ) ) : ( ( P1_ELEV_MSL_MAP.Value(p)+P1_DATUM_TO_MSL.Value(p) ) ) ) ;
			ELEVATION.Update( p, value );
		}
		ELEVATION.GrabMemory();
		if( ELEVATION.GetF(FLinkEdges) ) { ELEVATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( P1_DEPTH_MSL_MAP.Value() >  ((float)0) ) ) ? ( ( P1_DATUM_TO_MSL.Value()-P1_DEPTH_MSL_MAP.Value() ) ) : ( ( P1_ELEV_MSL_MAP.Value()+P1_DATUM_TO_MSL.Value() ) ) ) ;
			ELEVATION.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::ELEV_MIN_u251_exe() {
	float value;

	switch( ELEV_MIN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ELEV_MIN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( HABITATMAP.Value(p) == ((float)1) ) ) ? ( ELEVATION.Value(p) ) : (  ( ( ( P1_ELEV_MSL_MAP.Value(p) >  ( 2.*P1_C_SURF_DELTA.Value(p) ) ) ) ? ( ( ELEVATION.Value(p)-P1_C_SURF_DELTA.Value(p) ) ) : ( ( ELEVATION.Value(p)-( P1_ELEV_MSL_MAP.Value(p)/2. ) ) ) )  ) ) ;
			ELEV_MIN.Update( p, value );
		}
		ELEV_MIN.GrabMemory();
		if( ELEV_MIN.GetF(FLinkEdges) ) { ELEV_MIN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( HABITATMAP.Value() == ((float)1) ) ) ? ( ELEVATION.Value() ) : (  ( ( ( P1_ELEV_MSL_MAP.Value() >  ( 2.*P1_C_SURF_DELTA.Value() ) ) ) ? ( ( ELEVATION.Value()-P1_C_SURF_DELTA.Value() ) ) : ( ( ELEVATION.Value()-( P1_ELEV_MSL_MAP.Value()/2. ) ) ) )  ) ) ;
			ELEV_MIN.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::HABITATMAP_u252_exe() {
	float value;

	switch( HABITATMAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HABITATMAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)2);
			HABITATMAP.Update( p, HABITATMAP.ParameterValue(value,p) );
		}
		HABITATMAP.GrabMemory();
		if( HABITATMAP.GetF(FLinkEdges) ) { HABITATMAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)2);
			HABITATMAP.Update( HABITATMAP.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::HABITATMAP_v439_exe() {
	float value;

			 MakeCropMap(HABITATMAP, HABITATMAPDB, DAYJUL);
	return 0;
}

int GLOBALS_module::HABITATMAPDB_u253_exe() {
	float value;

	switch( HABITATMAPDB.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HABITATMAPDB.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)2);
			HABITATMAPDB.Update( p, value );
		}
		HABITATMAPDB.GrabMemory();
		if( HABITATMAPDB.GetF(FLinkEdges) ) { HABITATMAPDB.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)2);
			HABITATMAPDB.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::HYDRO_u254_exe() {
	float value;

	switch( HYDRO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HYDRO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			HYDRO.Update( p, value );
		}
		HYDRO.GrabMemory();
		if( HYDRO.GetF(FLinkEdges) ) { HYDRO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			HYDRO.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::LENGTH_u255_exe() {
	float value;

	switch( LENGTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LENGTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  300;
			LENGTH.Update( p, LENGTH.ParameterValue(value,p) );
		}
		LENGTH.GrabMemory();
		if( LENGTH.GetF(FLinkEdges) ) { LENGTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  300;
			LENGTH.Update( LENGTH.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::ON_MAP_u256_exe() {
	float value;

	switch( ON_MAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ON_MAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			ON_MAP.Update( p, value );
		}
		ON_MAP.GrabMemory();
		if( ON_MAP.GetF(FLinkEdges) ) { ON_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			ON_MAP.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::PAR_u257_exe() {
	float value;

	switch( PAR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PAR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_RAD_CONV.Value(p)*SOLRADATM.Value(p) );
			PAR.Update( p, value );
		}
		PAR.GrabMemory();
		if( PAR.GetF(FLinkEdges) ) { PAR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_RAD_CONV.Value()*SOLRADATM.Value() );
			PAR.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::PAR_G_u258_exe() {
	float value;

	switch( PAR_G.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PAR_G.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_RAD_CONV.Value(p)*SOLRADGRD.Value(p) );
			PAR_G.Update( p, value );
		}
		PAR_G.GrabMemory();
		if( PAR_G.GetF(FLinkEdges) ) { PAR_G.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_RAD_CONV.Value()*SOLRADGRD.Value() );
			PAR_G.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::PRECIP_M_u259_exe() {
	float value;

	switch( PRECIP_M.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PRECIP_M.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_RAIN_CONV.Value(p)*PRECIPITATION.Value(p) );
			PRECIP_M.Update( p, value );
		}
		PRECIP_M.GrabMemory();
		if( PRECIP_M.GetF(FLinkEdges) ) { PRECIP_M.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_RAIN_CONV.Value()*PRECIPITATION.Value() );
			PRECIP_M.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::ROADS_u260_exe() {
	float value;

	switch( ROADS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ROADS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			ROADS.Update( p, value );
		}
		ROADS.GrabMemory();
		if( ROADS.GetF(FLinkEdges) ) { ROADS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			ROADS.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::SOIL_u261_exe() {
	float value;

	switch( SOIL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SOIL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			SOIL.Update( p, value );
		}
		SOIL.GrabMemory();
		if( SOIL.GetF(FLinkEdges) ) { SOIL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			SOIL.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::VAP_PRESS_u262_exe() {
	float value;

	switch( VAP_PRESS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = VAP_PRESS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( HUMIDITY.Value(p)*6.1078 )*SL::Exp(( ( 17.269*AIR_TEMP_C.Value(p) )/( AIR_TEMP_C.Value(p)+237.3 ) )) );
			VAP_PRESS.Update( p, value );
		}
		VAP_PRESS.GrabMemory();
		if( VAP_PRESS.GetF(FLinkEdges) ) { VAP_PRESS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( HUMIDITY.Value()*6.1078 )*SL::Exp(( ( 17.269*AIR_TEMP_C.Value() )/( AIR_TEMP_C.Value()+237.3 ) )) );
			VAP_PRESS.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::VAP_SAT_DEFICIT_u263_exe() {
	float value;

	switch( VAP_SAT_DEFICIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = VAP_SAT_DEFICIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)1)-( HUMIDITY.Value(p)/100 ) );
			VAP_SAT_DEFICIT.Update( p, value );
		}
		VAP_SAT_DEFICIT.GrabMemory();
		if( VAP_SAT_DEFICIT.GetF(FLinkEdges) ) { VAP_SAT_DEFICIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)1)-( HUMIDITY.Value()/100 ) );
			VAP_SAT_DEFICIT.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::WIND_u264_exe() {
	float value;

	switch( WIND.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WIND.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( WIND_SPEED.Value(p)*P1_WIND_CONV.Value(p) );
			WIND.Update( p, value );
		}
		WIND.GrabMemory();
		if( WIND.GetF(FLinkEdges) ) { WIND.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( WIND_SPEED.Value()*P1_WIND_CONV.Value() );
			WIND.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_BO_COEF_u265_exe() {
	float value;

	switch( P1_BO_COEF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_BO_COEF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1.;
			P1_BO_COEF.Update( p, P1_BO_COEF.ParameterValue(value,p) );
		}
		P1_BO_COEF.GrabMemory();
		if( P1_BO_COEF.GetF(FLinkEdges) ) { P1_BO_COEF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1.;
			P1_BO_COEF.Update( P1_BO_COEF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_C_LATDEG_u266_exe() {
	float value;

	switch( P1_C_LATDEG.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_LATDEG.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  39.0;
			P1_C_LATDEG.Update( p, P1_C_LATDEG.ParameterValue(value,p) );
		}
		P1_C_LATDEG.GrabMemory();
		if( P1_C_LATDEG.GetF(FLinkEdges) ) { P1_C_LATDEG.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  39.0;
			P1_C_LATDEG.Update( P1_C_LATDEG.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_C_SURF_DELTA_u267_exe() {
	float value;

	switch( P1_C_SURF_DELTA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_SURF_DELTA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  5.0;
			P1_C_SURF_DELTA.Update( p, P1_C_SURF_DELTA.ParameterValue(value,p) );
		}
		P1_C_SURF_DELTA.GrabMemory();
		if( P1_C_SURF_DELTA.GetF(FLinkEdges) ) { P1_C_SURF_DELTA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  5.0;
			P1_C_SURF_DELTA.Update( P1_C_SURF_DELTA.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_DATUM_TO_MSL_u268_exe() {
	float value;

	switch( P1_DATUM_TO_MSL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DATUM_TO_MSL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  20;
			P1_DATUM_TO_MSL.Update( p, P1_DATUM_TO_MSL.ParameterValue(value,p) );
		}
		P1_DATUM_TO_MSL.GrabMemory();
		if( P1_DATUM_TO_MSL.GetF(FLinkEdges) ) { P1_DATUM_TO_MSL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  20;
			P1_DATUM_TO_MSL.Update( P1_DATUM_TO_MSL.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_DEPTH_MSL_MAP_u269_exe() {
	float value;

	switch( P1_DEPTH_MSL_MAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DEPTH_MSL_MAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_DEPTH_MSL_MAP.Update( p, value );
		}
		P1_DEPTH_MSL_MAP.GrabMemory();
		if( P1_DEPTH_MSL_MAP.GetF(FLinkEdges) ) { P1_DEPTH_MSL_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_DEPTH_MSL_MAP.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_ELEV_MSL_MAP_u270_exe() {
	float value;

	switch( P1_ELEV_MSL_MAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_ELEV_MSL_MAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)30);
			P1_ELEV_MSL_MAP.Update( p, value );
		}
		P1_ELEV_MSL_MAP.GrabMemory();
		if( P1_ELEV_MSL_MAP.GetF(FLinkEdges) ) { P1_ELEV_MSL_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)30);
			P1_ELEV_MSL_MAP.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_POP_DENS_u271_exe() {
	float value;

	switch( P1_POP_DENS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_POP_DENS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)10);
			P1_POP_DENS.Update( p, value );
		}
		P1_POP_DENS.GrabMemory();
		if( P1_POP_DENS.GetF(FLinkEdges) ) { P1_POP_DENS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)10);
			P1_POP_DENS.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_POP_DENS_v440_exe() {
	float value;

			 DwellMap2(P1_POP_DENS, HABITATMAP, P1_BO_COEF);
	return 0;
}

int GLOBALS_module::P1_RAD_CONV_u272_exe() {
	float value;

	switch( P1_RAD_CONV.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_RAD_CONV.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_RAD_CONV.Update( p, P1_RAD_CONV.ParameterValue(value,p) );
		}
		P1_RAD_CONV.GrabMemory();
		if( P1_RAD_CONV.GetF(FLinkEdges) ) { P1_RAD_CONV.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_RAD_CONV.Update( P1_RAD_CONV.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_RAIN_CONV_u273_exe() {
	float value;

	switch( P1_RAIN_CONV.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_RAIN_CONV.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000254;
			P1_RAIN_CONV.Update( p, P1_RAIN_CONV.ParameterValue(value,p) );
		}
		P1_RAIN_CONV.GrabMemory();
		if( P1_RAIN_CONV.GetF(FLinkEdges) ) { P1_RAIN_CONV.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000254;
			P1_RAIN_CONV.Update( P1_RAIN_CONV.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_SEWERMAP_u274_exe() {
	float value;

	switch( P1_SEWERMAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SEWERMAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			P1_SEWERMAP.Update( p, value );
		}
		P1_SEWERMAP.GrabMemory();
		if( P1_SEWERMAP.GetF(FLinkEdges) ) { P1_SEWERMAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			P1_SEWERMAP.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_WIND_CONV_u275_exe() {
	float value;

	switch( P1_WIND_CONV.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_WIND_CONV.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.1609;
			P1_WIND_CONV.Update( p, P1_WIND_CONV.ParameterValue(value,p) );
		}
		P1_WIND_CONV.GrabMemory();
		if( P1_WIND_CONV.GetF(FLinkEdges) ) { P1_WIND_CONV.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.1609;
			P1_WIND_CONV.Update( P1_WIND_CONV.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::AIR_TEMP_MAX_u276_exe() {
	float value;

	switch( AIR_TEMP_MAX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = AIR_TEMP_MAX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph26(DAYJUL.Value(p));
			AIR_TEMP_MAX.Update( p, value );
		}
		AIR_TEMP_MAX.GrabMemory();
		if( AIR_TEMP_MAX.GetF(FLinkEdges) ) { AIR_TEMP_MAX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph26(DAYJUL.Value());
			AIR_TEMP_MAX.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::AIR_TEMP_MIN_u277_exe() {
	float value;

	switch( AIR_TEMP_MIN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = AIR_TEMP_MIN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph27(DAYJUL.Value(p));
			AIR_TEMP_MIN.Update( p, value );
		}
		AIR_TEMP_MIN.GrabMemory();
		if( AIR_TEMP_MIN.GetF(FLinkEdges) ) { AIR_TEMP_MIN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph27(DAYJUL.Value());
			AIR_TEMP_MIN.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::HUMIDITY_u278_exe() {
	float value;

	switch( HUMIDITY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HUMIDITY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph28(DAYJUL.Value(p));
			HUMIDITY.Update( p, value );
		}
		HUMIDITY.GrabMemory();
		if( HUMIDITY.GetF(FLinkEdges) ) { HUMIDITY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph28(DAYJUL.Value());
			HUMIDITY.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::PRECIPITATION_u279_exe() {
	float value;

	switch( PRECIPITATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PRECIPITATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph29(DAYJUL.Value(p));
			PRECIPITATION.Update( p, value );
		}
		PRECIPITATION.GrabMemory();
		if( PRECIPITATION.GetF(FLinkEdges) ) { PRECIPITATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph29(DAYJUL.Value());
			PRECIPITATION.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::WIND_SPEED_u280_exe() {
	float value;

	switch( WIND_SPEED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WIND_SPEED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph30(DAYJUL.Value(p));
			WIND_SPEED.Update( p, value );
		}
		WIND_SPEED.GrabMemory();
		if( WIND_SPEED.GetF(FLinkEdges) ) { WIND_SPEED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph30(DAYJUL.Value());
			WIND_SPEED.Update( value );
	  } break;
	}
	return 0;
}

GLOBALS_module* GLOBALS_module::fInstance = NULL;
GLOBALS_module* GLOBALS_module::kNullModel = (GLOBALS_module*)0x1;
int GLOBALS_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int GLOBALS_module::InitVars() {
	
	TIME.SSInit(this);
	P1_C_LATDEG.SSInit(this);
	CLOUDY.SSInit(this);
	DAYJUL.SSInit(this);
	DAYJUL.SetLinkEdges();
	AIR_TEMP_C.SSInit(this);
	HABITATMAP.SSInit(this);
	HABITATMAP.SetLinkEdges();
	DAYLENGTH.SSInit(this);
	ELEVATION.SSInit(this);
	ON_MAP.SSInit(this);
	PRECIP_M.SSInit(this);
	HYDRO.SSInit(this);
	CELL_SIZE.SSInit(this);
	SOIL.SSInit(this);
	HUMIDITY.SSInit(this);
	WIND.SSInit(this);
	ELEV_MIN.SSInit(this);
	P1_DATUM_TO_MSL.SSInit(this);
	P1_DEPTH_MSL_MAP.SSInit(this);
	SOLRADATM.SSInit(this);
	SOLRADGRD.SSInit(this);
	VAP_PRESS.SSInit(this);
	P1_SEWERMAP.SSInit(this);
	P1_POP_DENS.SSInit(this);
	P1_POP_DENS.SetLinkEdges();
	HABITATMAPDB.SSInit(this);
	HABITATMAPDB.SetLinkEdges();
	AMPL.SSInit(this);
	LENGTH.SSInit(this);
	PAR.SSInit(this);
	PAR_G.SSInit(this);
	ROADS.SSInit(this);
	VAP_SAT_DEFICIT.SSInit(this);
	P1_BO_COEF.SSInit(this);
	P1_BO_COEF.SetLinkEdges();
	P1_C_SURF_DELTA.SSInit(this);
	P1_ELEV_MSL_MAP.SSInit(this);
	P1_RAD_CONV.SSInit(this);
	P1_RAIN_CONV.SSInit(this);
	P1_WIND_CONV.SSInit(this);
	AIR_TEMP_MAX.SSInit(this);
	AIR_TEMP_MIN.SSInit(this);
	PRECIPITATION.SSInit(this);
	WIND_SPEED.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int GLOBALS_module::SetupEvents() {
	TExecuteCommand* u266 = (TExecuteCommand*) P1_C_LATDEG.GetCommand("u266",TCommand::kUpdate,TCommand::kCode);
	u266->SetExecutable(&P1_C_LATDEG_u266_exe_g);
	u266->Code() = "u266 <- 39.0";
	u266->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u247 = (TExecuteCommand*) CLOUDY.GetCommand("u247",TCommand::kUpdate,TCommand::kCode);
	u247->SetExecutable(&CLOUDY_u247_exe_g);
	u247->Code() = "u247 <-  ( ( ( PRECIP_M >  ((float)0) ) ) ? ( SL::Max(((float)0), ( ((float)10)-( 1.155*pow((double)( VAP_PRESS/( ( PRECIP_M*25.4 )*((float)30) ) ),(double)0.5 ) ) )) ) : ( ((float)0) ) ) ";
	u247->AddDependency(PRECIP_M);
	u247->AddDependency(VAP_PRESS);
	u247->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u248 = (TExecuteCommand*) DAYJUL.GetCommand("u248",TCommand::kUpdate,TCommand::kCode);
	u248->SetExecutable(&DAYJUL_u248_exe_g);
	u248->Code() = "u248 <- ( SL::Mod(( TIME-dT() ), ((float)365))+((float)1) )";
	u248->AddDependency(TIME);
	u248->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u244 = (TExecuteCommand*) AIR_TEMP_C.GetCommand("u244",TCommand::kUpdate,TCommand::kCode);
	u244->SetExecutable(&AIR_TEMP_C_u244_exe_g);
	u244->Code() = "u244 <- ( ( ( ( ( AIR_TEMP_MAX+AIR_TEMP_MIN )/2. )-((float)32) )*((float)5) )/9 )";
	u244->AddDependency(AIR_TEMP_MAX);
	u244->AddDependency(AIR_TEMP_MIN);
	u244->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u252 = (TExecuteCommand*) HABITATMAP.GetCommand("u252",TCommand::kUpdate,TCommand::kCode);
	u252->SetExecutable(&HABITATMAP_u252_exe_g);
	u252->Code() = "u252 <- ((float)2)";
	u252->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* v439 = (TExecuteCommand*) HABITATMAP.GetCommand("v439",TCommand::kFunction,TCommand::kCode);
	v439->SetExecutable(&HABITATMAP_v439_exe_g);
	v439->Code() = "v439 <- Function";
	v439->GetFunction() = 'P';
	v439->AddDependency(HABITATMAP);
	v439->AddDependency(HABITATMAPDB);
	v439->AddDependency(DAYJUL);
	v439->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u249 = (TExecuteCommand*) DAYLENGTH.GetCommand("u249",TCommand::kUpdate,TCommand::kCode);
	u249->SetExecutable(&DAYLENGTH_u249_exe_g);
	u249->Code() = "u249 <- ( ( AMPL*SL::Sin(( ( DAYJUL-((float)79) )*0.01721 )) )+((float)12) )";
	u249->AddDependency(AMPL);
	u249->AddDependency(DAYJUL);
	u249->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u250 = (TExecuteCommand*) ELEVATION.GetCommand("u250",TCommand::kUpdate,TCommand::kCode);
	u250->SetExecutable(&ELEVATION_u250_exe_g);
	u250->Code() = "u250 <-  ( ( ( P1_DEPTH_MSL_MAP >  ((float)0) ) ) ? ( ( P1_DATUM_TO_MSL-P1_DEPTH_MSL_MAP ) ) : ( ( P1_ELEV_MSL_MAP+P1_DATUM_TO_MSL ) ) ) ";
	u250->AddDependency(P1_DEPTH_MSL_MAP);
	u250->AddDependency(P1_DATUM_TO_MSL);
	u250->AddDependency(P1_ELEV_MSL_MAP);
	u250->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u256 = (TExecuteCommand*) ON_MAP.GetCommand("u256",TCommand::kUpdate,TCommand::kCode);
	u256->SetExecutable(&ON_MAP_u256_exe_g);
	u256->Code() = "u256 <- ((float)1)";
	u256->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u259 = (TExecuteCommand*) PRECIP_M.GetCommand("u259",TCommand::kUpdate,TCommand::kCode);
	u259->SetExecutable(&PRECIP_M_u259_exe_g);
	u259->Code() = "u259 <- ( P1_RAIN_CONV*PRECIPITATION )";
	u259->AddDependency(P1_RAIN_CONV);
	u259->AddDependency(PRECIPITATION);
	u259->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u254 = (TExecuteCommand*) HYDRO.GetCommand("u254",TCommand::kUpdate,TCommand::kCode);
	u254->SetExecutable(&HYDRO_u254_exe_g);
	u254->Code() = "u254 <- ((float)1)";
	u254->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u246 = (TExecuteCommand*) CELL_SIZE.GetCommand("u246",TCommand::kUpdate,TCommand::kCode);
	u246->SetExecutable(&CELL_SIZE_u246_exe_g);
	u246->Code() = "u246 <- 40000";
	u246->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u261 = (TExecuteCommand*) SOIL.GetCommand("u261",TCommand::kUpdate,TCommand::kCode);
	u261->SetExecutable(&SOIL_u261_exe_g);
	u261->Code() = "u261 <- ((float)1)";
	u261->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u278 = (TExecuteCommand*) HUMIDITY.GetCommand("u278",TCommand::kUpdate,TCommand::kCode);
	u278->SetExecutable(&HUMIDITY_u278_exe_g);
	u278->Code() = "u278 <- Graph28(DAYJUL)";
	u278->AddDependency(DAYJUL);
	u278->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* HUMIDITY_import = (TImportCommand*) HUMIDITY.GetCommand("HUMIDITY_import",TCommand::kUndefined,TCommand::kImport);
	HUMIDITY_import->Code() = "Import HUMIDITY from external";
	HUMIDITY_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u264 = (TExecuteCommand*) WIND.GetCommand("u264",TCommand::kUpdate,TCommand::kCode);
	u264->SetExecutable(&WIND_u264_exe_g);
	u264->Code() = "u264 <- ( WIND_SPEED*P1_WIND_CONV )";
	u264->AddDependency(WIND_SPEED);
	u264->AddDependency(P1_WIND_CONV);
	u264->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u251 = (TExecuteCommand*) ELEV_MIN.GetCommand("u251",TCommand::kUpdate,TCommand::kCode);
	u251->SetExecutable(&ELEV_MIN_u251_exe_g);
	u251->Code() = "u251 <-  ( ( ( HABITATMAP == ((float)1) ) ) ? ( ELEVATION ) : (  ( ( ( P1_ELEV_MSL_MAP >  ( 2.*P1_C_SURF_DELTA ) ) ) ? ( ( ELEVATION-P1_C_SURF_DELTA ) ) : ( ( ELEVATION-( P1_ELEV_MSL_MAP/2. ) ) ) )  ) ) ";
	u251->AddDependency(HABITATMAP);
	u251->AddDependency(ELEVATION);
	u251->AddDependency(P1_ELEV_MSL_MAP);
	u251->AddDependency(P1_C_SURF_DELTA);
	u251->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u268 = (TExecuteCommand*) P1_DATUM_TO_MSL.GetCommand("u268",TCommand::kUpdate,TCommand::kCode);
	u268->SetExecutable(&P1_DATUM_TO_MSL_u268_exe_g);
	u268->Code() = "u268 <- 20";
	u268->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u269 = (TExecuteCommand*) P1_DEPTH_MSL_MAP.GetCommand("u269",TCommand::kUpdate,TCommand::kCode);
	u269->SetExecutable(&P1_DEPTH_MSL_MAP_u269_exe_g);
	u269->Code() = "u269 <- ((float)0)";
	u269->SetObjInfo(TCommand::kDepIndex, 5);
	TImportCommand* SOLRADATM_import = (TImportCommand*) SOLRADATM.GetCommand("SOLRADATM_import",TCommand::kUndefined,TCommand::kImport);
	SOLRADATM_import->Code() = "Import SOLRADATM from PAR_module";
	SOLRADATM_import->AddDependency(SOLRADATM);
	SOLRADATM_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SOLRADGRD_import = (TImportCommand*) SOLRADGRD.GetCommand("SOLRADGRD_import",TCommand::kUndefined,TCommand::kImport);
	SOLRADGRD_import->Code() = "Import SOLRADGRD from PAR_module";
	SOLRADGRD_import->AddDependency(SOLRADGRD);
	SOLRADGRD_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u262 = (TExecuteCommand*) VAP_PRESS.GetCommand("u262",TCommand::kUpdate,TCommand::kCode);
	u262->SetExecutable(&VAP_PRESS_u262_exe_g);
	u262->Code() = "u262 <- ( ( HUMIDITY*6.1078 )*SL::Exp(( ( 17.269*AIR_TEMP_C )/( AIR_TEMP_C+237.3 ) )) )";
	u262->AddDependency(HUMIDITY);
	u262->AddDependency(AIR_TEMP_C);
	u262->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u274 = (TExecuteCommand*) P1_SEWERMAP.GetCommand("u274",TCommand::kUpdate,TCommand::kCode);
	u274->SetExecutable(&P1_SEWERMAP_u274_exe_g);
	u274->Code() = "u274 <- ((float)1)";
	u274->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u271 = (TExecuteCommand*) P1_POP_DENS.GetCommand("u271",TCommand::kUpdate,TCommand::kCode);
	u271->SetExecutable(&P1_POP_DENS_u271_exe_g);
	u271->Code() = "u271 <- ((float)10)";
	u271->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* v440 = (TExecuteCommand*) P1_POP_DENS.GetCommand("v440",TCommand::kFunction,TCommand::kCode);
	v440->SetExecutable(&P1_POP_DENS_v440_exe_g);
	v440->Code() = "v440 <- Function";
	v440->GetFunction() = 'P';
	v440->AddDependency(P1_POP_DENS);
	v440->AddDependency(HABITATMAP);
	v440->AddDependency(P1_BO_COEF);
	v440->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u253 = (TExecuteCommand*) HABITATMAPDB.GetCommand("u253",TCommand::kUpdate,TCommand::kCode);
	u253->SetExecutable(&HABITATMAPDB_u253_exe_g);
	u253->Code() = "u253 <- ((float)2)";
	u253->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u245 = (TExecuteCommand*) AMPL.GetCommand("u245",TCommand::kUpdate,TCommand::kCode);
	u245->SetExecutable(&AMPL_u245_exe_g);
	u245->Code() = "u245 <- ( SL::Exp(( 7.42+( 0.045*P1_C_LATDEG ) ))/3600 )";
	u245->AddDependency(P1_C_LATDEG);
	u245->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u255 = (TExecuteCommand*) LENGTH.GetCommand("u255",TCommand::kUpdate,TCommand::kCode);
	u255->SetExecutable(&LENGTH_u255_exe_g);
	u255->Code() = "u255 <- 300";
	u255->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u257 = (TExecuteCommand*) PAR.GetCommand("u257",TCommand::kUpdate,TCommand::kCode);
	u257->SetExecutable(&PAR_u257_exe_g);
	u257->Code() = "u257 <- ( P1_RAD_CONV*SOLRADATM )";
	u257->AddDependency(P1_RAD_CONV);
	u257->AddDependency(SOLRADATM);
	u257->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u258 = (TExecuteCommand*) PAR_G.GetCommand("u258",TCommand::kUpdate,TCommand::kCode);
	u258->SetExecutable(&PAR_G_u258_exe_g);
	u258->Code() = "u258 <- ( P1_RAD_CONV*SOLRADGRD )";
	u258->AddDependency(P1_RAD_CONV);
	u258->AddDependency(SOLRADGRD);
	u258->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u260 = (TExecuteCommand*) ROADS.GetCommand("u260",TCommand::kUpdate,TCommand::kCode);
	u260->SetExecutable(&ROADS_u260_exe_g);
	u260->Code() = "u260 <- ((float)1)";
	u260->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u263 = (TExecuteCommand*) VAP_SAT_DEFICIT.GetCommand("u263",TCommand::kUpdate,TCommand::kCode);
	u263->SetExecutable(&VAP_SAT_DEFICIT_u263_exe_g);
	u263->Code() = "u263 <- ( ((float)1)-( HUMIDITY/100 ) )";
	u263->AddDependency(HUMIDITY);
	u263->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u265 = (TExecuteCommand*) P1_BO_COEF.GetCommand("u265",TCommand::kUpdate,TCommand::kCode);
	u265->SetExecutable(&P1_BO_COEF_u265_exe_g);
	u265->Code() = "u265 <- 1.";
	u265->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u267 = (TExecuteCommand*) P1_C_SURF_DELTA.GetCommand("u267",TCommand::kUpdate,TCommand::kCode);
	u267->SetExecutable(&P1_C_SURF_DELTA_u267_exe_g);
	u267->Code() = "u267 <- 5.0";
	u267->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u270 = (TExecuteCommand*) P1_ELEV_MSL_MAP.GetCommand("u270",TCommand::kUpdate,TCommand::kCode);
	u270->SetExecutable(&P1_ELEV_MSL_MAP_u270_exe_g);
	u270->Code() = "u270 <- ((float)30)";
	u270->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u272 = (TExecuteCommand*) P1_RAD_CONV.GetCommand("u272",TCommand::kUpdate,TCommand::kCode);
	u272->SetExecutable(&P1_RAD_CONV_u272_exe_g);
	u272->Code() = "u272 <- 1";
	u272->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u273 = (TExecuteCommand*) P1_RAIN_CONV.GetCommand("u273",TCommand::kUpdate,TCommand::kCode);
	u273->SetExecutable(&P1_RAIN_CONV_u273_exe_g);
	u273->Code() = "u273 <- 0.000254";
	u273->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u275 = (TExecuteCommand*) P1_WIND_CONV.GetCommand("u275",TCommand::kUpdate,TCommand::kCode);
	u275->SetExecutable(&P1_WIND_CONV_u275_exe_g);
	u275->Code() = "u275 <- 0.1609";
	u275->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u276 = (TExecuteCommand*) AIR_TEMP_MAX.GetCommand("u276",TCommand::kUpdate,TCommand::kCode);
	u276->SetExecutable(&AIR_TEMP_MAX_u276_exe_g);
	u276->Code() = "u276 <- Graph26(DAYJUL)";
	u276->AddDependency(DAYJUL);
	u276->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* AIR_TEMP_MAX_import = (TImportCommand*) AIR_TEMP_MAX.GetCommand("AIR_TEMP_MAX_import",TCommand::kUndefined,TCommand::kImport);
	AIR_TEMP_MAX_import->Code() = "Import AIR_TEMP_MAX from external";
	AIR_TEMP_MAX_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u277 = (TExecuteCommand*) AIR_TEMP_MIN.GetCommand("u277",TCommand::kUpdate,TCommand::kCode);
	u277->SetExecutable(&AIR_TEMP_MIN_u277_exe_g);
	u277->Code() = "u277 <- Graph27(DAYJUL)";
	u277->AddDependency(DAYJUL);
	u277->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* AIR_TEMP_MIN_import = (TImportCommand*) AIR_TEMP_MIN.GetCommand("AIR_TEMP_MIN_import",TCommand::kUndefined,TCommand::kImport);
	AIR_TEMP_MIN_import->Code() = "Import AIR_TEMP_MIN from external";
	AIR_TEMP_MIN_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u279 = (TExecuteCommand*) PRECIPITATION.GetCommand("u279",TCommand::kUpdate,TCommand::kCode);
	u279->SetExecutable(&PRECIPITATION_u279_exe_g);
	u279->Code() = "u279 <- Graph29(DAYJUL)";
	u279->AddDependency(DAYJUL);
	u279->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PRECIPITATION_import = (TImportCommand*) PRECIPITATION.GetCommand("PRECIPITATION_import",TCommand::kUndefined,TCommand::kImport);
	PRECIPITATION_import->Code() = "Import PRECIPITATION from external";
	PRECIPITATION_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u280 = (TExecuteCommand*) WIND_SPEED.GetCommand("u280",TCommand::kUpdate,TCommand::kCode);
	u280->SetExecutable(&WIND_SPEED_u280_exe_g);
	u280->Code() = "u280 <- Graph30(DAYJUL)";
	u280->AddDependency(DAYJUL);
	u280->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* WIND_SPEED_import = (TImportCommand*) WIND_SPEED.GetCommand("WIND_SPEED_import",TCommand::kUndefined,TCommand::kImport);
	WIND_SPEED_import->Code() = "Import WIND_SPEED from external";
	WIND_SPEED_import->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int GLOBALS_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int GLOBALS_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int GLOBALS_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int GLOBALS_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class XXXIMPORTS3_module 
// ---------------------------------------------------------------------------
XXXIMPORTS3_module::XXXIMPORTS3_module(char* name) :
	TIME("TIME"),
	DAYJUL("DAYJUL"),
	SOLRADATM("SOLRADATM"),
	SOLRADGRD("SOLRADGRD"),
	TModule(name) {

	DAYJUL.SetF(FisImport,True,"CG");
}	
int XXXIMPORTS3_module::SOLRADATM_u281_exe() {
	float value;

	switch( SOLRADATM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SOLRADATM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph31(DAYJUL.Value(p));
			SOLRADATM.Update( p, value );
		}
		SOLRADATM.GrabMemory();
		if( SOLRADATM.GetF(FLinkEdges) ) { SOLRADATM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph31(DAYJUL.Value());
			SOLRADATM.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS3_module::SOLRADGRD_u282_exe() {
	float value;

	switch( SOLRADGRD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SOLRADGRD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph32(DAYJUL.Value(p));
			SOLRADGRD.Update( p, value );
		}
		SOLRADGRD.GrabMemory();
		if( SOLRADGRD.GetF(FLinkEdges) ) { SOLRADGRD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph32(DAYJUL.Value());
			SOLRADGRD.Update( value );
	  } break;
	}
	return 0;
}

XXXIMPORTS3_module* XXXIMPORTS3_module::fInstance = NULL;
XXXIMPORTS3_module* XXXIMPORTS3_module::kNullModel = (XXXIMPORTS3_module*)0x1;
int XXXIMPORTS3_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int XXXIMPORTS3_module::InitVars() {
	
	TIME.SSInit(this);
	DAYJUL.SSInit(this);
	SOLRADATM.SSInit(this);
	SOLRADGRD.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int XXXIMPORTS3_module::SetupEvents() {
	TImportCommand* DAYJUL_import = (TImportCommand*) DAYJUL.GetCommand("DAYJUL_import",TCommand::kUndefined,TCommand::kImport);
	DAYJUL_import->Code() = "Import DAYJUL from GLOBALS_module";
	DAYJUL_import->AddDependency(DAYJUL);
	DAYJUL_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u281 = (TExecuteCommand*) SOLRADATM.GetCommand("u281",TCommand::kUpdate,TCommand::kCode);
	u281->SetExecutable(&SOLRADATM_u281_exe_g);
	u281->Code() = "u281 <- Graph31(DAYJUL)";
	u281->AddDependency(DAYJUL);
	u281->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u282 = (TExecuteCommand*) SOLRADGRD.GetCommand("u282",TCommand::kUpdate,TCommand::kCode);
	u282->SetExecutable(&SOLRADGRD_u282_exe_g);
	u282->Code() = "u282 <- Graph32(DAYJUL)";
	u282->AddDependency(DAYJUL);
	u282->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int XXXIMPORTS3_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int XXXIMPORTS3_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int XXXIMPORTS3_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int XXXIMPORTS3_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class ETPM_module 
// ---------------------------------------------------------------------------
ETPM_module::ETPM_module(char* name) :
	TIME("TIME"),
	ETPM("ETPM"),
	VAP_PRESS("VAP_PRESS"),
	AIR_TEMP_C("AIR_TEMP_C"),
	SOLRADATM("SOLRADATM"),
	CLOUDY("CLOUDY"),
	MACH("MACH"),
	WIND("WIND"),
	MACLAI("MACLAI"),
	D("D"),
	DELTA("DELTA"),
	ENERGY("ENERGY"),
	ES("ES"),
	GAMMA("GAMMA"),
	LAMBDA("LAMBDA"),
	P("P"),
	RA("RA"),
	RO("RO"),
	RS("RS"),
	TModule(name) {

	ETPM.SetF(FisExport,True,"CG");
	VAP_PRESS.SetF(FisImport,True,"CG");
	AIR_TEMP_C.SetF(FisImport,True,"CG");
	SOLRADATM.SetF(FisImport,True,"CG");
	CLOUDY.SetF(FisImport,True,"CG");
	MACH.SetF(FisImport,True,"CG");
	WIND.SetF(FisImport,True,"CG");
	MACLAI.SetF(FisImport,True,"CG");
}	
int ETPM_module::D_u283_exe() {
	float value;

	switch( D.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = D.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ES.Value(p)-( VAP_PRESS.Value(p)/1000 ) );
			D.Update( p, value );
		}
		D.GrabMemory();
		if( D.GetF(FLinkEdges) ) { D.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ES.Value()-( VAP_PRESS.Value()/1000 ) );
			D.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::DELTA_u284_exe() {
	float value;

	switch( DELTA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DELTA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ((float)4098)*ES.Value(p) )/( 237.3+AIR_TEMP_C.Value(p) ) )/( 237.3+AIR_TEMP_C.Value(p) ) );
			DELTA.Update( p, value );
		}
		DELTA.GrabMemory();
		if( DELTA.GetF(FLinkEdges) ) { DELTA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ((float)4098)*ES.Value() )/( 237.3+AIR_TEMP_C.Value() ) )/( 237.3+AIR_TEMP_C.Value() ) );
			DELTA.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::ENERGY_u285_exe() {
	float value;

	switch( ENERGY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ENERGY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( SOLRADATM.Value(p)/23.9 )*( 0.25+( ( 0.5*( ((float)10)-CLOUDY.Value(p) ) )/10 ) ) )-( ( ( ( ( ( ( 0.9*( ((float)10)-CLOUDY.Value(p) ) )/10 )+0.1 )*( 0.34-( 0.14*SL::Sqrt(VAP_PRESS.Value(p)) ) ) )*4.903 )*pow((double)((float)10),(double)-((float)9) ) )*pow((double)AIR_TEMP_C.Value(p),(double)((float)4) ) ) );
			ENERGY.Update( p, value );
		}
		ENERGY.GrabMemory();
		if( ENERGY.GetF(FLinkEdges) ) { ENERGY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( SOLRADATM.Value()/23.9 )*( 0.25+( ( 0.5*( ((float)10)-CLOUDY.Value() ) )/10 ) ) )-( ( ( ( ( ( ( 0.9*( ((float)10)-CLOUDY.Value() ) )/10 )+0.1 )*( 0.34-( 0.14*SL::Sqrt(VAP_PRESS.Value()) ) ) )*4.903 )*pow((double)((float)10),(double)-((float)9) ) )*pow((double)AIR_TEMP_C.Value(),(double)((float)4) ) ) );
			ENERGY.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::ES_u286_exe() {
	float value;

	switch( ES.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ES.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( 0.6108*SL::Exp(( ( 17.27*AIR_TEMP_C.Value(p) )/( 237.3+AIR_TEMP_C.Value(p) ) )) );
			ES.Update( p, value );
		}
		ES.GrabMemory();
		if( ES.GetF(FLinkEdges) ) { ES.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( 0.6108*SL::Exp(( ( 17.27*AIR_TEMP_C.Value() )/( 237.3+AIR_TEMP_C.Value() ) )) );
			ES.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::ETPM_u287_exe() {
	float value;

	switch( ETPM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ETPM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( DELTA.Value(p)*ENERGY.Value(p) )+( ( ( 1.013*RO.Value(p) )*D.Value(p) )/RA.Value(p) ) )/( DELTA.Value(p)+( GAMMA.Value(p)*( ((float)1)+( RS.Value(p)/RA.Value(p) ) ) ) ) )/LAMBDA.Value(p) )/1000 );
			ETPM.Update( p, value );
		}
		ETPM.GrabMemory();
		if( ETPM.GetF(FLinkEdges) ) { ETPM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( DELTA.Value()*ENERGY.Value() )+( ( ( 1.013*RO.Value() )*D.Value() )/RA.Value() ) )/( DELTA.Value()+( GAMMA.Value()*( ((float)1)+( RS.Value()/RA.Value() ) ) ) ) )/LAMBDA.Value() )/1000 );
			ETPM.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::GAMMA_u288_exe() {
	float value;

	switch( GAMMA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = GAMMA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( 0.0016286*P.Value(p) )/LAMBDA.Value(p) );
			GAMMA.Update( p, value );
		}
		GAMMA.GrabMemory();
		if( GAMMA.GetF(FLinkEdges) ) { GAMMA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( 0.0016286*P.Value() )/LAMBDA.Value() );
			GAMMA.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::LAMBDA_u289_exe() {
	float value;

	switch( LAMBDA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LAMBDA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( 2.501-( 0.002361*( AIR_TEMP_C.Value(p)-((float)3) ) ) );
			LAMBDA.Update( p, value );
		}
		LAMBDA.GrabMemory();
		if( LAMBDA.GetF(FLinkEdges) ) { LAMBDA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( 2.501-( 0.002361*( AIR_TEMP_C.Value()-((float)3) ) ) );
			LAMBDA.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::P_u290_exe() {
	float value;

	switch( P.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  101.300003;
			P.Update( p, P.ParameterValue(value,p) );
		}
		P.GrabMemory();
		if( P.GetF(FLinkEdges) ) { P.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  101.300003;
			P.Update( P.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ETPM_module::RA_u291_exe() {
	float value;

	switch( RA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = RA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( MACH.Value(p) >  0.001 ) ) ? ( ( ( ( ( ( SL::Logn(( ( ( ((float)25)/MACH.Value(p) )-0.67 )/0.123 ))*SL::Logn(( ( ( ((float)25)/MACH.Value(p) )-0.67 )/0.0123 )) )/0.41 )/0.41 )/WIND.Value(p) )/3.6 ) ) : ( pow((double)((float)10),(double)((float)10) ) ) ) ;
			RA.Update( p, value );
		}
		RA.GrabMemory();
		if( RA.GetF(FLinkEdges) ) { RA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( MACH.Value() >  0.001 ) ) ? ( ( ( ( ( ( SL::Logn(( ( ( ((float)25)/MACH.Value() )-0.67 )/0.123 ))*SL::Logn(( ( ( ((float)25)/MACH.Value() )-0.67 )/0.0123 )) )/0.41 )/0.41 )/WIND.Value() )/3.6 ) ) : ( pow((double)((float)10),(double)((float)10) ) ) ) ;
			RA.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::RO_u292_exe() {
	float value;

	switch( RO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = RO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( 3.486*P.Value(p) )/( ((float)275)+AIR_TEMP_C.Value(p) ) );
			RO.Update( p, value );
		}
		RO.GrabMemory();
		if( RO.GetF(FLinkEdges) ) { RO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( 3.486*P.Value() )/( ((float)275)+AIR_TEMP_C.Value() ) );
			RO.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::RS_u293_exe() {
	float value;

	switch( RS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = RS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( MACLAI.Value(p) >  0.01 ) ) ? ( ( ((float)4)/MACLAI.Value(p) ) ) : ( pow((double)((float)10),(double)((float)10) ) ) ) ;
			RS.Update( p, value );
		}
		RS.GrabMemory();
		if( RS.GetF(FLinkEdges) ) { RS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( MACLAI.Value() >  0.01 ) ) ? ( ( ((float)4)/MACLAI.Value() ) ) : ( pow((double)((float)10),(double)((float)10) ) ) ) ;
			RS.Update( value );
	  } break;
	}
	return 0;
}

ETPM_module* ETPM_module::fInstance = NULL;
ETPM_module* ETPM_module::kNullModel = (ETPM_module*)0x1;
int ETPM_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int ETPM_module::InitVars() {
	
	TIME.SSInit(this);
	ETPM.SSInit(this);
	VAP_PRESS.SSInit(this);
	AIR_TEMP_C.SSInit(this);
	SOLRADATM.SSInit(this);
	CLOUDY.SSInit(this);
	MACH.SSInit(this);
	WIND.SSInit(this);
	MACLAI.SSInit(this);
	D.SSInit(this);
	DELTA.SSInit(this);
	ENERGY.SSInit(this);
	ES.SSInit(this);
	GAMMA.SSInit(this);
	LAMBDA.SSInit(this);
	P.SSInit(this);
	RA.SSInit(this);
	RO.SSInit(this);
	RS.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int ETPM_module::SetupEvents() {
	TExecuteCommand* u287 = (TExecuteCommand*) ETPM.GetCommand("u287",TCommand::kUpdate,TCommand::kCode);
	u287->SetExecutable(&ETPM_u287_exe_g);
	u287->Code() = "u287 <- ( ( ( ( ( DELTA*ENERGY )+( ( ( 1.013*RO )*D )/RA ) )/( DELTA+( GAMMA*( ((float)1)+( RS/RA ) ) ) ) )/LAMBDA )/1000 )";
	u287->AddDependency(DELTA);
	u287->AddDependency(ENERGY);
	u287->AddDependency(RO);
	u287->AddDependency(D);
	u287->AddDependency(RA);
	u287->AddDependency(GAMMA);
	u287->AddDependency(RS);
	u287->AddDependency(LAMBDA);
	u287->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* VAP_PRESS_import = (TImportCommand*) VAP_PRESS.GetCommand("VAP_PRESS_import",TCommand::kUndefined,TCommand::kImport);
	VAP_PRESS_import->Code() = "Import VAP_PRESS from GLOBALS_module";
	VAP_PRESS_import->AddDependency(VAP_PRESS);
	VAP_PRESS_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* AIR_TEMP_C_import = (TImportCommand*) AIR_TEMP_C.GetCommand("AIR_TEMP_C_import",TCommand::kUndefined,TCommand::kImport);
	AIR_TEMP_C_import->Code() = "Import AIR_TEMP_C from GLOBALS_module";
	AIR_TEMP_C_import->AddDependency(AIR_TEMP_C);
	AIR_TEMP_C_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SOLRADATM_import = (TImportCommand*) SOLRADATM.GetCommand("SOLRADATM_import",TCommand::kUndefined,TCommand::kImport);
	SOLRADATM_import->Code() = "Import SOLRADATM from PAR_module";
	SOLRADATM_import->AddDependency(SOLRADATM);
	SOLRADATM_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CLOUDY_import = (TImportCommand*) CLOUDY.GetCommand("CLOUDY_import",TCommand::kUndefined,TCommand::kImport);
	CLOUDY_import->Code() = "Import CLOUDY from GLOBALS_module";
	CLOUDY_import->AddDependency(CLOUDY);
	CLOUDY_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* MACH_import = (TImportCommand*) MACH.GetCommand("MACH_import",TCommand::kUndefined,TCommand::kImport);
	MACH_import->Code() = "Import MACH from MACROPHYTES_module";
	MACH_import->AddDependency(MACH);
	MACH_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* WIND_import = (TImportCommand*) WIND.GetCommand("WIND_import",TCommand::kUndefined,TCommand::kImport);
	WIND_import->Code() = "Import WIND from GLOBALS_module";
	WIND_import->AddDependency(WIND);
	WIND_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* MACLAI_import = (TImportCommand*) MACLAI.GetCommand("MACLAI_import",TCommand::kUndefined,TCommand::kImport);
	MACLAI_import->Code() = "Import MACLAI from MACROPHYTES_module";
	MACLAI_import->AddDependency(MACLAI);
	MACLAI_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u283 = (TExecuteCommand*) D.GetCommand("u283",TCommand::kUpdate,TCommand::kCode);
	u283->SetExecutable(&D_u283_exe_g);
	u283->Code() = "u283 <- ( ES-( VAP_PRESS/1000 ) )";
	u283->AddDependency(ES);
	u283->AddDependency(VAP_PRESS);
	u283->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u284 = (TExecuteCommand*) DELTA.GetCommand("u284",TCommand::kUpdate,TCommand::kCode);
	u284->SetExecutable(&DELTA_u284_exe_g);
	u284->Code() = "u284 <- ( ( ( ((float)4098)*ES )/( 237.3+AIR_TEMP_C ) )/( 237.3+AIR_TEMP_C ) )";
	u284->AddDependency(ES);
	u284->AddDependency(AIR_TEMP_C);
	u284->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u285 = (TExecuteCommand*) ENERGY.GetCommand("u285",TCommand::kUpdate,TCommand::kCode);
	u285->SetExecutable(&ENERGY_u285_exe_g);
	u285->Code() = "u285 <- ( ( ( SOLRADATM/23.9 )*( 0.25+( ( 0.5*( ((float)10)-CLOUDY ) )/10 ) ) )-( ( ( ( ( ( ( 0.9*( ((float)10)-CLOUDY ) )/10 )+0.1 )*( 0.34-( 0.14*SL::Sqrt(VAP_PRESS) ) ) )*4.903 )*pow((double)((float)10),(double)-((float)9) ) )*pow((double)AIR_TEMP_C,(double)((float)4) ) ) )";
	u285->AddDependency(SOLRADATM);
	u285->AddDependency(CLOUDY);
	u285->AddDependency(VAP_PRESS);
	u285->AddDependency(AIR_TEMP_C);
	u285->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u286 = (TExecuteCommand*) ES.GetCommand("u286",TCommand::kUpdate,TCommand::kCode);
	u286->SetExecutable(&ES_u286_exe_g);
	u286->Code() = "u286 <- ( 0.6108*SL::Exp(( ( 17.27*AIR_TEMP_C )/( 237.3+AIR_TEMP_C ) )) )";
	u286->AddDependency(AIR_TEMP_C);
	u286->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u288 = (TExecuteCommand*) GAMMA.GetCommand("u288",TCommand::kUpdate,TCommand::kCode);
	u288->SetExecutable(&GAMMA_u288_exe_g);
	u288->Code() = "u288 <- ( ( 0.0016286*P )/LAMBDA )";
	u288->AddDependency(P);
	u288->AddDependency(LAMBDA);
	u288->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u289 = (TExecuteCommand*) LAMBDA.GetCommand("u289",TCommand::kUpdate,TCommand::kCode);
	u289->SetExecutable(&LAMBDA_u289_exe_g);
	u289->Code() = "u289 <- ( 2.501-( 0.002361*( AIR_TEMP_C-((float)3) ) ) )";
	u289->AddDependency(AIR_TEMP_C);
	u289->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u290 = (TExecuteCommand*) P.GetCommand("u290",TCommand::kUpdate,TCommand::kCode);
	u290->SetExecutable(&P_u290_exe_g);
	u290->Code() = "u290 <- 101.300003";
	u290->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u291 = (TExecuteCommand*) RA.GetCommand("u291",TCommand::kUpdate,TCommand::kCode);
	u291->SetExecutable(&RA_u291_exe_g);
	u291->Code() = "u291 <-  ( ( ( MACH >  0.001 ) ) ? ( ( ( ( ( ( SL::Logn(( ( ( ((float)25)/MACH )-0.67 )/0.123 ))*SL::Logn(( ( ( ((float)25)/MACH )-0.67 )/0.0123 )) )/0.41 )/0.41 )/WIND )/3.6 ) ) : ( pow((double)((float)10),(double)((float)10) ) ) ) ";
	u291->AddDependency(MACH);
	u291->AddDependency(WIND);
	u291->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u292 = (TExecuteCommand*) RO.GetCommand("u292",TCommand::kUpdate,TCommand::kCode);
	u292->SetExecutable(&RO_u292_exe_g);
	u292->Code() = "u292 <- ( ( 3.486*P )/( ((float)275)+AIR_TEMP_C ) )";
	u292->AddDependency(P);
	u292->AddDependency(AIR_TEMP_C);
	u292->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u293 = (TExecuteCommand*) RS.GetCommand("u293",TCommand::kUpdate,TCommand::kCode);
	u293->SetExecutable(&RS_u293_exe_g);
	u293->Code() = "u293 <-  ( ( ( MACLAI >  0.01 ) ) ? ( ( ((float)4)/MACLAI ) ) : ( pow((double)((float)10),(double)((float)10) ) ) ) ";
	u293->AddDependency(MACLAI);
	u293->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int ETPM_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int ETPM_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int ETPM_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int ETPM_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class XXXIMPORTS2_module 
// ---------------------------------------------------------------------------
XXXIMPORTS2_module::XXXIMPORTS2_module(char* name) :
	TIME("TIME"),
	DAYJUL("DAYJUL"),
	AIR_TEMP_C("AIR_TEMP_C"),
	CLOUDY("CLOUDY"),
	MACH("MACH"),
	MACLAI("MACLAI"),
	SOLRADATM("SOLRADATM"),
	VAP_PRESS("VAP_PRESS"),
	WIND("WIND"),
	TModule(name) {

}	
int XXXIMPORTS2_module::DAYJUL_u294_exe() {
	float value;

	switch( DAYJUL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DAYJUL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SL::Mod(( TIME.Value()-dT() ), ((float)365))+((float)1) );
			DAYJUL.Update( p, value );
		}
		DAYJUL.GrabMemory();
		if( DAYJUL.GetF(FLinkEdges) ) { DAYJUL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SL::Mod(( TIME.Value()-dT() ), ((float)365))+((float)1) );
			DAYJUL.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS2_module::AIR_TEMP_C_u295_exe() {
	float value;

	switch( AIR_TEMP_C.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = AIR_TEMP_C.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph33(DAYJUL.Value(p));
			AIR_TEMP_C.Update( p, value );
		}
		AIR_TEMP_C.GrabMemory();
		if( AIR_TEMP_C.GetF(FLinkEdges) ) { AIR_TEMP_C.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph33(DAYJUL.Value());
			AIR_TEMP_C.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS2_module::CLOUDY_u296_exe() {
	float value;

	switch( CLOUDY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CLOUDY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph34(DAYJUL.Value(p));
			CLOUDY.Update( p, value );
		}
		CLOUDY.GrabMemory();
		if( CLOUDY.GetF(FLinkEdges) ) { CLOUDY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph34(DAYJUL.Value());
			CLOUDY.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS2_module::MACH_u297_exe() {
	float value;

	switch( MACH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MACH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph35(DAYJUL.Value(p));
			MACH.Update( p, value );
		}
		MACH.GrabMemory();
		if( MACH.GetF(FLinkEdges) ) { MACH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph35(DAYJUL.Value());
			MACH.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS2_module::MACLAI_u298_exe() {
	float value;

	switch( MACLAI.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MACLAI.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph36(DAYJUL.Value(p));
			MACLAI.Update( p, value );
		}
		MACLAI.GrabMemory();
		if( MACLAI.GetF(FLinkEdges) ) { MACLAI.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph36(DAYJUL.Value());
			MACLAI.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS2_module::SOLRADATM_u299_exe() {
	float value;

	switch( SOLRADATM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SOLRADATM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph37(DAYJUL.Value(p));
			SOLRADATM.Update( p, value );
		}
		SOLRADATM.GrabMemory();
		if( SOLRADATM.GetF(FLinkEdges) ) { SOLRADATM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph37(DAYJUL.Value());
			SOLRADATM.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS2_module::VAP_PRESS_u300_exe() {
	float value;

	switch( VAP_PRESS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = VAP_PRESS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph38(DAYJUL.Value(p));
			VAP_PRESS.Update( p, value );
		}
		VAP_PRESS.GrabMemory();
		if( VAP_PRESS.GetF(FLinkEdges) ) { VAP_PRESS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph38(DAYJUL.Value());
			VAP_PRESS.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS2_module::WIND_u301_exe() {
	float value;

	switch( WIND.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WIND.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph39(DAYJUL.Value(p));
			WIND.Update( p, value );
		}
		WIND.GrabMemory();
		if( WIND.GetF(FLinkEdges) ) { WIND.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph39(DAYJUL.Value());
			WIND.Update( value );
	  } break;
	}
	return 0;
}

XXXIMPORTS2_module* XXXIMPORTS2_module::fInstance = NULL;
XXXIMPORTS2_module* XXXIMPORTS2_module::kNullModel = (XXXIMPORTS2_module*)0x1;
int XXXIMPORTS2_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int XXXIMPORTS2_module::InitVars() {
	
	TIME.SSInit(this);
	DAYJUL.SSInit(this);
	AIR_TEMP_C.SSInit(this);
	CLOUDY.SSInit(this);
	MACH.SSInit(this);
	MACLAI.SSInit(this);
	SOLRADATM.SSInit(this);
	VAP_PRESS.SSInit(this);
	WIND.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int XXXIMPORTS2_module::SetupEvents() {
	TExecuteCommand* u294 = (TExecuteCommand*) DAYJUL.GetCommand("u294",TCommand::kUpdate,TCommand::kCode);
	u294->SetExecutable(&DAYJUL_u294_exe_g);
	u294->Code() = "u294 <- ( SL::Mod(( TIME-dT() ), ((float)365))+((float)1) )";
	u294->AddDependency(TIME);
	u294->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u295 = (TExecuteCommand*) AIR_TEMP_C.GetCommand("u295",TCommand::kUpdate,TCommand::kCode);
	u295->SetExecutable(&AIR_TEMP_C_u295_exe_g);
	u295->Code() = "u295 <- Graph33(DAYJUL)";
	u295->AddDependency(DAYJUL);
	u295->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u296 = (TExecuteCommand*) CLOUDY.GetCommand("u296",TCommand::kUpdate,TCommand::kCode);
	u296->SetExecutable(&CLOUDY_u296_exe_g);
	u296->Code() = "u296 <- Graph34(DAYJUL)";
	u296->AddDependency(DAYJUL);
	u296->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u297 = (TExecuteCommand*) MACH.GetCommand("u297",TCommand::kUpdate,TCommand::kCode);
	u297->SetExecutable(&MACH_u297_exe_g);
	u297->Code() = "u297 <- Graph35(DAYJUL)";
	u297->AddDependency(DAYJUL);
	u297->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u298 = (TExecuteCommand*) MACLAI.GetCommand("u298",TCommand::kUpdate,TCommand::kCode);
	u298->SetExecutable(&MACLAI_u298_exe_g);
	u298->Code() = "u298 <- Graph36(DAYJUL)";
	u298->AddDependency(DAYJUL);
	u298->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u299 = (TExecuteCommand*) SOLRADATM.GetCommand("u299",TCommand::kUpdate,TCommand::kCode);
	u299->SetExecutable(&SOLRADATM_u299_exe_g);
	u299->Code() = "u299 <- Graph37(DAYJUL)";
	u299->AddDependency(DAYJUL);
	u299->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u300 = (TExecuteCommand*) VAP_PRESS.GetCommand("u300",TCommand::kUpdate,TCommand::kCode);
	u300->SetExecutable(&VAP_PRESS_u300_exe_g);
	u300->Code() = "u300 <- Graph38(DAYJUL)";
	u300->AddDependency(DAYJUL);
	u300->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u301 = (TExecuteCommand*) WIND.GetCommand("u301",TCommand::kUpdate,TCommand::kCode);
	u301->SetExecutable(&WIND_u301_exe_g);
	u301->Code() = "u301 <- Graph39(DAYJUL)";
	u301->AddDependency(DAYJUL);
	u301->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int XXXIMPORTS2_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int XXXIMPORTS2_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int XXXIMPORTS2_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int XXXIMPORTS2_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class DOM_module 
// ---------------------------------------------------------------------------
DOM_module::DOM_module(char* name) :
	TIME("TIME"),
	PHBIO_MORT("PHBIO_MORT"),
	PHBIO_HARVEST("PHBIO_HARVEST"),
	NPHBIO_MORT("NPHBIO_MORT"),
	NPHBIO_HARVEST("NPHBIO_HARVEST"),
	AIR_TEMP_C("AIR_TEMP_C"),
	D_DECOMP("D_DECOMP"),
	DEP_ORG_MAT("DEP_ORG_MAT"),
	SD_TO_DOM("SD_TO_DOM"),
	DOM_DECOMP("DOM_DECOMP"),
	LAB_DETRITUS("LAB_DETRITUS"),
	SD_DECOMP("SD_DECOMP"),
	LD_IN("LD_IN"),
	LD_DECOMP("LD_DECOMP"),
	STAB_DETRITUS("STAB_DETRITUS"),
	SD_IN("SD_IN"),
	F_TEMP("F_TEMP"),
	P1_DOM_DEC_RATE("P1_DOM_DEC_RATE"),
	P1_DOM_INIT("P1_DOM_INIT"),
	P1_HARV_NPH_LEFT("P1_HARV_NPH_LEFT"),
	P1_HARV_PH_LEFT("P1_HARV_PH_LEFT"),
	P1_LD_DEC_RATE("P1_LD_DEC_RATE"),
	P1_LD_INIT("P1_LD_INIT"),
	P1_NPH_LIGNIN_CONTENT("P1_NPH_LIGNIN_CONTENT"),
	P1_PH_LIGNIN_CONTENT("P1_PH_LIGNIN_CONTENT"),
	P1_SD_DEC_RATE("P1_SD_DEC_RATE"),
	P1_SD_INIT("P1_SD_INIT"),
	P1_SD_TO_DOM_RATE("P1_SD_TO_DOM_RATE"),
	TModule(name) {

	PHBIO_MORT.SetF(FisImport,True,"CG");
	PHBIO_HARVEST.SetF(FisImport,True,"CG");
	NPHBIO_MORT.SetF(FisImport,True,"CG");
	NPHBIO_HARVEST.SetF(FisImport,True,"CG");
	AIR_TEMP_C.SetF(FisImport,True,"CG");
	D_DECOMP.SetF(FisExport,True,"CG");
}	
int DOM_module::DEP_ORG_MAT_I302_exe() {
	float value;

	DEP_ORG_MAT.UpdateIntegrator(0);
	switch( DEP_ORG_MAT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DEP_ORG_MAT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SD_TO_DOM.Value(p)-DOM_DECOMP.Value(p) );
			DEP_ORG_MAT.Update( p, value, dT() );
		}
		DEP_ORG_MAT.GrabMemory();
		if( DEP_ORG_MAT.GetF(FLinkEdges) ) { DEP_ORG_MAT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SD_TO_DOM.Value()-DOM_DECOMP.Value() );
			DEP_ORG_MAT.Update( value, dT() );
	  } break;
	}
	return 0;
}

int DOM_module::DEP_ORG_MAT_i303_exe() {
	float value;

	DEP_ORG_MAT.UpdateIntegrator(1);
	switch( DEP_ORG_MAT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DEP_ORG_MAT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  P1_DOM_INIT.Value(p);
			DEP_ORG_MAT.InitValue( p, value );
		}
		DEP_ORG_MAT.GrabMemory();
		if( DEP_ORG_MAT.GetF(FLinkEdges) ) { DEP_ORG_MAT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  P1_DOM_INIT.Value();
			DEP_ORG_MAT.InitValue( value );
	  } break;
	}
	return 0;
}

int DOM_module::SD_TO_DOM_u304_exe() {
	float value;

	switch( SD_TO_DOM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SD_TO_DOM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_SD_TO_DOM_RATE.Value(p)*STAB_DETRITUS.Value(p) );
			SD_TO_DOM.Update( p, value );
		}
		SD_TO_DOM.GrabMemory();
		if( SD_TO_DOM.GetF(FICFlux) ) SD_TO_DOM.Cov().Set(0.0); 
		if( SD_TO_DOM.GetF(FLinkEdges) ) { SD_TO_DOM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_SD_TO_DOM_RATE.Value()*STAB_DETRITUS.Value() );
			SD_TO_DOM.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::DOM_DECOMP_u305_exe() {
	float value;

	switch( DOM_DECOMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DOM_DECOMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_DOM_DEC_RATE.Value(p)*F_TEMP.Value(p) )*DEP_ORG_MAT.Value(p) );
			DOM_DECOMP.Update( p, value );
		}
		DOM_DECOMP.GrabMemory();
		if( DOM_DECOMP.GetF(FICFlux) ) DOM_DECOMP.Cov().Set(0.0); 
		if( DOM_DECOMP.GetF(FLinkEdges) ) { DOM_DECOMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_DOM_DEC_RATE.Value()*F_TEMP.Value() )*DEP_ORG_MAT.Value() );
			DOM_DECOMP.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::LAB_DETRITUS_I306_exe() {
	float value;

	LAB_DETRITUS.UpdateIntegrator(0);
	switch( LAB_DETRITUS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LAB_DETRITUS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SD_DECOMP.Value(p)+LD_IN.Value(p) )-LD_DECOMP.Value(p) );
			LAB_DETRITUS.Update( p, value, dT() );
		}
		LAB_DETRITUS.GrabMemory();
		if( LAB_DETRITUS.GetF(FLinkEdges) ) { LAB_DETRITUS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SD_DECOMP.Value()+LD_IN.Value() )-LD_DECOMP.Value() );
			LAB_DETRITUS.Update( value, dT() );
	  } break;
	}
	return 0;
}

int DOM_module::LAB_DETRITUS_i307_exe() {
	float value;

	LAB_DETRITUS.UpdateIntegrator(1);
	switch( LAB_DETRITUS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LAB_DETRITUS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  P1_LD_INIT.Value(p);
			LAB_DETRITUS.InitValue( p, value );
		}
		LAB_DETRITUS.GrabMemory();
		if( LAB_DETRITUS.GetF(FLinkEdges) ) { LAB_DETRITUS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  P1_LD_INIT.Value();
			LAB_DETRITUS.InitValue( value );
	  } break;
	}
	return 0;
}

int DOM_module::SD_DECOMP_u308_exe() {
	float value;

	switch( SD_DECOMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SD_DECOMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_SD_DEC_RATE.Value(p)*F_TEMP.Value(p) )*STAB_DETRITUS.Value(p) );
			SD_DECOMP.Update( p, value );
		}
		SD_DECOMP.GrabMemory();
		if( SD_DECOMP.GetF(FICFlux) ) SD_DECOMP.Cov().Set(0.0); 
		if( SD_DECOMP.GetF(FLinkEdges) ) { SD_DECOMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_SD_DEC_RATE.Value()*F_TEMP.Value() )*STAB_DETRITUS.Value() );
			SD_DECOMP.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::LD_IN_u309_exe() {
	float value;

	switch( LD_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LD_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ((float)1)-P1_PH_LIGNIN_CONTENT.Value(p) )*( PHBIO_MORT.Value(p)+( PHBIO_HARVEST.Value(p)*P1_HARV_PH_LEFT.Value(p) ) ) )+( ( ((float)1)-P1_NPH_LIGNIN_CONTENT.Value(p) )*( NPHBIO_MORT.Value(p)+( NPHBIO_HARVEST.Value(p)*P1_HARV_NPH_LEFT.Value(p) ) ) ) );
			LD_IN.Update( p, value );
		}
		LD_IN.GrabMemory();
		if( LD_IN.GetF(FICFlux) ) LD_IN.Cov().Set(0.0); 
		if( LD_IN.GetF(FLinkEdges) ) { LD_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ((float)1)-P1_PH_LIGNIN_CONTENT.Value() )*( PHBIO_MORT.Value()+( PHBIO_HARVEST.Value()*P1_HARV_PH_LEFT.Value() ) ) )+( ( ((float)1)-P1_NPH_LIGNIN_CONTENT.Value() )*( NPHBIO_MORT.Value()+( NPHBIO_HARVEST.Value()*P1_HARV_NPH_LEFT.Value() ) ) ) );
			LD_IN.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::LD_DECOMP_u310_exe() {
	float value;

	switch( LD_DECOMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LD_DECOMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_LD_DEC_RATE.Value(p)*F_TEMP.Value(p) )*LAB_DETRITUS.Value(p) );
			LD_DECOMP.Update( p, value );
		}
		LD_DECOMP.GrabMemory();
		if( LD_DECOMP.GetF(FICFlux) ) LD_DECOMP.Cov().Set(0.0); 
		if( LD_DECOMP.GetF(FLinkEdges) ) { LD_DECOMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_LD_DEC_RATE.Value()*F_TEMP.Value() )*LAB_DETRITUS.Value() );
			LD_DECOMP.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::STAB_DETRITUS_I311_exe() {
	float value;

	STAB_DETRITUS.UpdateIntegrator(0);
	switch( STAB_DETRITUS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = STAB_DETRITUS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SD_IN.Value(p)-SD_DECOMP.Value(p) )-SD_TO_DOM.Value(p) );
			STAB_DETRITUS.Update( p, value, dT() );
		}
		STAB_DETRITUS.GrabMemory();
		if( STAB_DETRITUS.GetF(FLinkEdges) ) { STAB_DETRITUS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SD_IN.Value()-SD_DECOMP.Value() )-SD_TO_DOM.Value() );
			STAB_DETRITUS.Update( value, dT() );
	  } break;
	}
	return 0;
}

int DOM_module::STAB_DETRITUS_i312_exe() {
	float value;

	STAB_DETRITUS.UpdateIntegrator(1);
	switch( STAB_DETRITUS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = STAB_DETRITUS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  P1_SD_INIT.Value(p);
			STAB_DETRITUS.InitValue( p, value );
		}
		STAB_DETRITUS.GrabMemory();
		if( STAB_DETRITUS.GetF(FLinkEdges) ) { STAB_DETRITUS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  P1_SD_INIT.Value();
			STAB_DETRITUS.InitValue( value );
	  } break;
	}
	return 0;
}

int DOM_module::SD_IN_u313_exe() {
	float value;

	switch( SD_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SD_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_PH_LIGNIN_CONTENT.Value(p)*( PHBIO_MORT.Value(p)+( PHBIO_HARVEST.Value(p)*P1_HARV_PH_LEFT.Value(p) ) ) )+( P1_NPH_LIGNIN_CONTENT.Value(p)*( NPHBIO_MORT.Value(p)+( NPHBIO_HARVEST.Value(p)*P1_HARV_NPH_LEFT.Value(p) ) ) ) );
			SD_IN.Update( p, value );
		}
		SD_IN.GrabMemory();
		if( SD_IN.GetF(FICFlux) ) SD_IN.Cov().Set(0.0); 
		if( SD_IN.GetF(FLinkEdges) ) { SD_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_PH_LIGNIN_CONTENT.Value()*( PHBIO_MORT.Value()+( PHBIO_HARVEST.Value()*P1_HARV_PH_LEFT.Value() ) ) )+( P1_NPH_LIGNIN_CONTENT.Value()*( NPHBIO_MORT.Value()+( NPHBIO_HARVEST.Value()*P1_HARV_NPH_LEFT.Value() ) ) ) );
			SD_IN.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::D_DECOMP_u314_exe() {
	float value;

	switch( D_DECOMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = D_DECOMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DOM_DECOMP.Value(p)+LD_DECOMP.Value(p) );
			D_DECOMP.Update( p, value );
		}
		D_DECOMP.GrabMemory();
		if( D_DECOMP.GetF(FLinkEdges) ) { D_DECOMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DOM_DECOMP.Value()+LD_DECOMP.Value() );
			D_DECOMP.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::F_TEMP_u315_exe() {
	float value;

	switch( F_TEMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = F_TEMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  pow((double)((float)2),(double)( ( AIR_TEMP_C.Value(p)-((float)20) )/10. ) );
			F_TEMP.Update( p, value );
		}
		F_TEMP.GrabMemory();
		if( F_TEMP.GetF(FLinkEdges) ) { F_TEMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  pow((double)((float)2),(double)( ( AIR_TEMP_C.Value()-((float)20) )/10. ) );
			F_TEMP.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::P1_DOM_DEC_RATE_u316_exe() {
	float value;

	switch( P1_DOM_DEC_RATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DOM_DEC_RATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.001000;
			P1_DOM_DEC_RATE.Update( p, P1_DOM_DEC_RATE.ParameterValue(value,p) );
		}
		P1_DOM_DEC_RATE.GrabMemory();
		if( P1_DOM_DEC_RATE.GetF(FLinkEdges) ) { P1_DOM_DEC_RATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.001000;
			P1_DOM_DEC_RATE.Update( P1_DOM_DEC_RATE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_DOM_INIT_u317_exe() {
	float value;

	switch( P1_DOM_INIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DOM_INIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_DOM_INIT.Update( p, P1_DOM_INIT.ParameterValue(value,p) );
		}
		P1_DOM_INIT.GrabMemory();
		if( P1_DOM_INIT.GetF(FLinkEdges) ) { P1_DOM_INIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_DOM_INIT.Update( P1_DOM_INIT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_HARV_NPH_LEFT_u318_exe() {
	float value;

	switch( P1_HARV_NPH_LEFT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_HARV_NPH_LEFT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.800000;
			P1_HARV_NPH_LEFT.Update( p, P1_HARV_NPH_LEFT.ParameterValue(value,p) );
		}
		P1_HARV_NPH_LEFT.GrabMemory();
		if( P1_HARV_NPH_LEFT.GetF(FLinkEdges) ) { P1_HARV_NPH_LEFT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.800000;
			P1_HARV_NPH_LEFT.Update( P1_HARV_NPH_LEFT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_HARV_PH_LEFT_u319_exe() {
	float value;

	switch( P1_HARV_PH_LEFT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_HARV_PH_LEFT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.100000;
			P1_HARV_PH_LEFT.Update( p, P1_HARV_PH_LEFT.ParameterValue(value,p) );
		}
		P1_HARV_PH_LEFT.GrabMemory();
		if( P1_HARV_PH_LEFT.GetF(FLinkEdges) ) { P1_HARV_PH_LEFT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.100000;
			P1_HARV_PH_LEFT.Update( P1_HARV_PH_LEFT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_LD_DEC_RATE_u320_exe() {
	float value;

	switch( P1_LD_DEC_RATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_LD_DEC_RATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.030000;
			P1_LD_DEC_RATE.Update( p, P1_LD_DEC_RATE.ParameterValue(value,p) );
		}
		P1_LD_DEC_RATE.GrabMemory();
		if( P1_LD_DEC_RATE.GetF(FLinkEdges) ) { P1_LD_DEC_RATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.030000;
			P1_LD_DEC_RATE.Update( P1_LD_DEC_RATE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_LD_INIT_u321_exe() {
	float value;

	switch( P1_LD_INIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_LD_INIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.800000;
			P1_LD_INIT.Update( p, P1_LD_INIT.ParameterValue(value,p) );
		}
		P1_LD_INIT.GrabMemory();
		if( P1_LD_INIT.GetF(FLinkEdges) ) { P1_LD_INIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.800000;
			P1_LD_INIT.Update( P1_LD_INIT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_NPH_LIGNIN_CONTENT_u322_exe() {
	float value;

	switch( P1_NPH_LIGNIN_CONTENT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_NPH_LIGNIN_CONTENT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.500000;
			P1_NPH_LIGNIN_CONTENT.Update( p, P1_NPH_LIGNIN_CONTENT.ParameterValue(value,p) );
		}
		P1_NPH_LIGNIN_CONTENT.GrabMemory();
		if( P1_NPH_LIGNIN_CONTENT.GetF(FLinkEdges) ) { P1_NPH_LIGNIN_CONTENT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.500000;
			P1_NPH_LIGNIN_CONTENT.Update( P1_NPH_LIGNIN_CONTENT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_PH_LIGNIN_CONTENT_u323_exe() {
	float value;

	switch( P1_PH_LIGNIN_CONTENT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PH_LIGNIN_CONTENT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.025000;
			P1_PH_LIGNIN_CONTENT.Update( p, P1_PH_LIGNIN_CONTENT.ParameterValue(value,p) );
		}
		P1_PH_LIGNIN_CONTENT.GrabMemory();
		if( P1_PH_LIGNIN_CONTENT.GetF(FLinkEdges) ) { P1_PH_LIGNIN_CONTENT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.025000;
			P1_PH_LIGNIN_CONTENT.Update( P1_PH_LIGNIN_CONTENT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_SD_DEC_RATE_u324_exe() {
	float value;

	switch( P1_SD_DEC_RATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SD_DEC_RATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.001000;
			P1_SD_DEC_RATE.Update( p, P1_SD_DEC_RATE.ParameterValue(value,p) );
		}
		P1_SD_DEC_RATE.GrabMemory();
		if( P1_SD_DEC_RATE.GetF(FLinkEdges) ) { P1_SD_DEC_RATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.001000;
			P1_SD_DEC_RATE.Update( P1_SD_DEC_RATE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_SD_INIT_u325_exe() {
	float value;

	switch( P1_SD_INIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SD_INIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1.200000;
			P1_SD_INIT.Update( p, P1_SD_INIT.ParameterValue(value,p) );
		}
		P1_SD_INIT.GrabMemory();
		if( P1_SD_INIT.GetF(FLinkEdges) ) { P1_SD_INIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1.200000;
			P1_SD_INIT.Update( P1_SD_INIT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_SD_TO_DOM_RATE_u326_exe() {
	float value;

	switch( P1_SD_TO_DOM_RATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SD_TO_DOM_RATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000700;
			P1_SD_TO_DOM_RATE.Update( p, P1_SD_TO_DOM_RATE.ParameterValue(value,p) );
		}
		P1_SD_TO_DOM_RATE.GrabMemory();
		if( P1_SD_TO_DOM_RATE.GetF(FLinkEdges) ) { P1_SD_TO_DOM_RATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000700;
			P1_SD_TO_DOM_RATE.Update( P1_SD_TO_DOM_RATE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

DOM_module* DOM_module::fInstance = NULL;
DOM_module* DOM_module::kNullModel = (DOM_module*)0x1;
int DOM_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int DOM_module::InitVars() {
	
	TIME.SSInit(this);
	PHBIO_MORT.SSInit(this);
	PHBIO_HARVEST.SSInit(this);
	NPHBIO_MORT.SSInit(this);
	NPHBIO_HARVEST.SSInit(this);
	AIR_TEMP_C.SSInit(this);
	D_DECOMP.SSInit(this);
	DEP_ORG_MAT.SSInit(this);
	SD_TO_DOM.SSInit(this);
	SD_TO_DOM.SetOrigin(&STAB_DETRITUS);
	SD_TO_DOM.SetDestination(&DEP_ORG_MAT);
	DOM_DECOMP.SSInit(this);
	DOM_DECOMP.SetOrigin(&DEP_ORG_MAT);
	LAB_DETRITUS.SSInit(this);
	SD_DECOMP.SSInit(this);
	SD_DECOMP.SetOrigin(&STAB_DETRITUS);
	SD_DECOMP.SetDestination(&LAB_DETRITUS);
	LD_IN.SSInit(this);
	LD_IN.SetDestination(&LAB_DETRITUS);
	LD_DECOMP.SSInit(this);
	LD_DECOMP.SetOrigin(&LAB_DETRITUS);
	STAB_DETRITUS.SSInit(this);
	SD_IN.SSInit(this);
	SD_IN.SetDestination(&STAB_DETRITUS);
	F_TEMP.SSInit(this);
	P1_DOM_DEC_RATE.SSInit(this);
	P1_DOM_INIT.SSInit(this);
	P1_HARV_NPH_LEFT.SSInit(this);
	P1_HARV_PH_LEFT.SSInit(this);
	P1_LD_DEC_RATE.SSInit(this);
	P1_LD_INIT.SSInit(this);
	P1_NPH_LIGNIN_CONTENT.SSInit(this);
	P1_PH_LIGNIN_CONTENT.SSInit(this);
	P1_SD_DEC_RATE.SSInit(this);
	P1_SD_INIT.SSInit(this);
	P1_SD_TO_DOM_RATE.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int DOM_module::SetupEvents() {
	TImportCommand* PHBIO_MORT_import = (TImportCommand*) PHBIO_MORT.GetCommand("PHBIO_MORT_import",TCommand::kUndefined,TCommand::kImport);
	PHBIO_MORT_import->Code() = "Import PHBIO_MORT from MACROPHYTES_module";
	PHBIO_MORT_import->AddDependency(PHBIO_MORT);
	PHBIO_MORT_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PHBIO_HARVEST_import = (TImportCommand*) PHBIO_HARVEST.GetCommand("PHBIO_HARVEST_import",TCommand::kUndefined,TCommand::kImport);
	PHBIO_HARVEST_import->Code() = "Import PHBIO_HARVEST from MACROPHYTES_module";
	PHBIO_HARVEST_import->AddDependency(PHBIO_HARVEST);
	PHBIO_HARVEST_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* NPHBIO_MORT_import = (TImportCommand*) NPHBIO_MORT.GetCommand("NPHBIO_MORT_import",TCommand::kUndefined,TCommand::kImport);
	NPHBIO_MORT_import->Code() = "Import NPHBIO_MORT from MACROPHYTES_module";
	NPHBIO_MORT_import->AddDependency(NPHBIO_MORT);
	NPHBIO_MORT_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* NPHBIO_HARVEST_import = (TImportCommand*) NPHBIO_HARVEST.GetCommand("NPHBIO_HARVEST_import",TCommand::kUndefined,TCommand::kImport);
	NPHBIO_HARVEST_import->Code() = "Import NPHBIO_HARVEST from MACROPHYTES_module";
	NPHBIO_HARVEST_import->AddDependency(NPHBIO_HARVEST);
	NPHBIO_HARVEST_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* AIR_TEMP_C_import = (TImportCommand*) AIR_TEMP_C.GetCommand("AIR_TEMP_C_import",TCommand::kUndefined,TCommand::kImport);
	AIR_TEMP_C_import->Code() = "Import AIR_TEMP_C from GLOBALS_module";
	AIR_TEMP_C_import->AddDependency(AIR_TEMP_C);
	AIR_TEMP_C_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u314 = (TExecuteCommand*) D_DECOMP.GetCommand("u314",TCommand::kUpdate,TCommand::kCode);
	u314->SetExecutable(&D_DECOMP_u314_exe_g);
	u314->Code() = "u314 <- ( DOM_DECOMP+LD_DECOMP )";
	u314->AddDependency(DOM_DECOMP);
	u314->AddDependency(LD_DECOMP);
	u314->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I302 = (TExecuteCommand*) DEP_ORG_MAT.GetCommand("I302",TCommand::kIntegrate,TCommand::kCode);
	I302->SetExecutable(&DEP_ORG_MAT_I302_exe_g);
	I302->Code() = "I302 <- ( SD_TO_DOM-DOM_DECOMP )";
	I302->AddDependency(SD_TO_DOM);
	I302->AddDependency(DOM_DECOMP);
	I302->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i303 = (TExecuteCommand*) DEP_ORG_MAT.GetCommand("i303",TCommand::kInit,TCommand::kCode);
	i303->SetExecutable(&DEP_ORG_MAT_i303_exe_g);
	i303->Code() = "i303 <- P1_DOM_INIT";
	i303->AddDependency(P1_DOM_INIT);
	i303->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u304 = (TExecuteCommand*) SD_TO_DOM.GetCommand("u304",TCommand::kUpdate,TCommand::kCode);
	u304->SetExecutable(&SD_TO_DOM_u304_exe_g);
	u304->Code() = "u304 <- ( P1_SD_TO_DOM_RATE*STAB_DETRITUS )";
	if( STAB_DETRITUS.GetF(FisClamped) ) { u304->AddDependency(STAB_DETRITUS); }
	u304->AddDependency(P1_SD_TO_DOM_RATE);
	u304->AddDependency(STAB_DETRITUS);
	u304->AddDependency(SD_IN);
	u304->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u305 = (TExecuteCommand*) DOM_DECOMP.GetCommand("u305",TCommand::kUpdate,TCommand::kCode);
	u305->SetExecutable(&DOM_DECOMP_u305_exe_g);
	u305->Code() = "u305 <- ( ( P1_DOM_DEC_RATE*F_TEMP )*DEP_ORG_MAT )";
	if( DEP_ORG_MAT.GetF(FisClamped) ) { u305->AddDependency(DEP_ORG_MAT); }
	u305->AddDependency(P1_DOM_DEC_RATE);
	u305->AddDependency(F_TEMP);
	u305->AddDependency(DEP_ORG_MAT);
	u305->AddDependency(SD_TO_DOM);
	u305->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I306 = (TExecuteCommand*) LAB_DETRITUS.GetCommand("I306",TCommand::kIntegrate,TCommand::kCode);
	I306->SetExecutable(&LAB_DETRITUS_I306_exe_g);
	I306->Code() = "I306 <- ( ( SD_DECOMP+LD_IN )-LD_DECOMP )";
	I306->AddDependency(SD_DECOMP);
	I306->AddDependency(LD_IN);
	I306->AddDependency(LD_DECOMP);
	I306->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i307 = (TExecuteCommand*) LAB_DETRITUS.GetCommand("i307",TCommand::kInit,TCommand::kCode);
	i307->SetExecutable(&LAB_DETRITUS_i307_exe_g);
	i307->Code() = "i307 <- P1_LD_INIT";
	i307->AddDependency(P1_LD_INIT);
	i307->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u308 = (TExecuteCommand*) SD_DECOMP.GetCommand("u308",TCommand::kUpdate,TCommand::kCode);
	u308->SetExecutable(&SD_DECOMP_u308_exe_g);
	u308->Code() = "u308 <- ( ( P1_SD_DEC_RATE*F_TEMP )*STAB_DETRITUS )";
	if( STAB_DETRITUS.GetF(FisClamped) ) { u308->AddDependency(STAB_DETRITUS); }
	u308->AddDependency(P1_SD_DEC_RATE);
	u308->AddDependency(F_TEMP);
	u308->AddDependency(STAB_DETRITUS);
	u308->AddDependency(SD_IN);
	u308->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u309 = (TExecuteCommand*) LD_IN.GetCommand("u309",TCommand::kUpdate,TCommand::kCode);
	u309->SetExecutable(&LD_IN_u309_exe_g);
	u309->Code() = "u309 <- ( ( ( ((float)1)-P1_PH_LIGNIN_CONTENT )*( PHBIO_MORT+( PHBIO_HARVEST*P1_HARV_PH_LEFT ) ) )+( ( ((float)1)-P1_NPH_LIGNIN_CONTENT )*( NPHBIO_MORT+( NPHBIO_HARVEST*P1_HARV_NPH_LEFT ) ) ) )";
	u309->AddDependency(P1_PH_LIGNIN_CONTENT);
	u309->AddDependency(PHBIO_MORT);
	u309->AddDependency(PHBIO_HARVEST);
	u309->AddDependency(P1_HARV_PH_LEFT);
	u309->AddDependency(P1_NPH_LIGNIN_CONTENT);
	u309->AddDependency(NPHBIO_MORT);
	u309->AddDependency(NPHBIO_HARVEST);
	u309->AddDependency(P1_HARV_NPH_LEFT);
	u309->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u310 = (TExecuteCommand*) LD_DECOMP.GetCommand("u310",TCommand::kUpdate,TCommand::kCode);
	u310->SetExecutable(&LD_DECOMP_u310_exe_g);
	u310->Code() = "u310 <- ( ( P1_LD_DEC_RATE*F_TEMP )*LAB_DETRITUS )";
	if( LAB_DETRITUS.GetF(FisClamped) ) { u310->AddDependency(LAB_DETRITUS); }
	u310->AddDependency(P1_LD_DEC_RATE);
	u310->AddDependency(F_TEMP);
	u310->AddDependency(LAB_DETRITUS);
	u310->AddDependency(SD_DECOMP);
	u310->AddDependency(LD_IN);
	u310->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I311 = (TExecuteCommand*) STAB_DETRITUS.GetCommand("I311",TCommand::kIntegrate,TCommand::kCode);
	I311->SetExecutable(&STAB_DETRITUS_I311_exe_g);
	I311->Code() = "I311 <- ( ( SD_IN-SD_DECOMP )-SD_TO_DOM )";
	I311->AddDependency(SD_IN);
	I311->AddDependency(SD_DECOMP);
	I311->AddDependency(SD_TO_DOM);
	I311->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i312 = (TExecuteCommand*) STAB_DETRITUS.GetCommand("i312",TCommand::kInit,TCommand::kCode);
	i312->SetExecutable(&STAB_DETRITUS_i312_exe_g);
	i312->Code() = "i312 <- P1_SD_INIT";
	i312->AddDependency(P1_SD_INIT);
	i312->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u313 = (TExecuteCommand*) SD_IN.GetCommand("u313",TCommand::kUpdate,TCommand::kCode);
	u313->SetExecutable(&SD_IN_u313_exe_g);
	u313->Code() = "u313 <- ( ( P1_PH_LIGNIN_CONTENT*( PHBIO_MORT+( PHBIO_HARVEST*P1_HARV_PH_LEFT ) ) )+( P1_NPH_LIGNIN_CONTENT*( NPHBIO_MORT+( NPHBIO_HARVEST*P1_HARV_NPH_LEFT ) ) ) )";
	u313->AddDependency(P1_PH_LIGNIN_CONTENT);
	u313->AddDependency(PHBIO_MORT);
	u313->AddDependency(PHBIO_HARVEST);
	u313->AddDependency(P1_HARV_PH_LEFT);
	u313->AddDependency(P1_NPH_LIGNIN_CONTENT);
	u313->AddDependency(NPHBIO_MORT);
	u313->AddDependency(NPHBIO_HARVEST);
	u313->AddDependency(P1_HARV_NPH_LEFT);
	u313->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u315 = (TExecuteCommand*) F_TEMP.GetCommand("u315",TCommand::kUpdate,TCommand::kCode);
	u315->SetExecutable(&F_TEMP_u315_exe_g);
	u315->Code() = "u315 <- pow((double)((float)2),(double)( ( AIR_TEMP_C-((float)20) )/10. ) )";
	u315->AddDependency(AIR_TEMP_C);
	u315->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u316 = (TExecuteCommand*) P1_DOM_DEC_RATE.GetCommand("u316",TCommand::kUpdate,TCommand::kCode);
	u316->SetExecutable(&P1_DOM_DEC_RATE_u316_exe_g);
	u316->Code() = "u316 <- 0.001000";
	u316->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u317 = (TExecuteCommand*) P1_DOM_INIT.GetCommand("u317",TCommand::kUpdate,TCommand::kCode);
	u317->SetExecutable(&P1_DOM_INIT_u317_exe_g);
	u317->Code() = "u317 <- 1";
	u317->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u318 = (TExecuteCommand*) P1_HARV_NPH_LEFT.GetCommand("u318",TCommand::kUpdate,TCommand::kCode);
	u318->SetExecutable(&P1_HARV_NPH_LEFT_u318_exe_g);
	u318->Code() = "u318 <- 0.800000";
	u318->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u319 = (TExecuteCommand*) P1_HARV_PH_LEFT.GetCommand("u319",TCommand::kUpdate,TCommand::kCode);
	u319->SetExecutable(&P1_HARV_PH_LEFT_u319_exe_g);
	u319->Code() = "u319 <- 0.100000";
	u319->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u320 = (TExecuteCommand*) P1_LD_DEC_RATE.GetCommand("u320",TCommand::kUpdate,TCommand::kCode);
	u320->SetExecutable(&P1_LD_DEC_RATE_u320_exe_g);
	u320->Code() = "u320 <- 0.030000";
	u320->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u321 = (TExecuteCommand*) P1_LD_INIT.GetCommand("u321",TCommand::kUpdate,TCommand::kCode);
	u321->SetExecutable(&P1_LD_INIT_u321_exe_g);
	u321->Code() = "u321 <- 0.800000";
	u321->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u322 = (TExecuteCommand*) P1_NPH_LIGNIN_CONTENT.GetCommand("u322",TCommand::kUpdate,TCommand::kCode);
	u322->SetExecutable(&P1_NPH_LIGNIN_CONTENT_u322_exe_g);
	u322->Code() = "u322 <- 0.500000";
	u322->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u323 = (TExecuteCommand*) P1_PH_LIGNIN_CONTENT.GetCommand("u323",TCommand::kUpdate,TCommand::kCode);
	u323->SetExecutable(&P1_PH_LIGNIN_CONTENT_u323_exe_g);
	u323->Code() = "u323 <- 0.025000";
	u323->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u324 = (TExecuteCommand*) P1_SD_DEC_RATE.GetCommand("u324",TCommand::kUpdate,TCommand::kCode);
	u324->SetExecutable(&P1_SD_DEC_RATE_u324_exe_g);
	u324->Code() = "u324 <- 0.001000";
	u324->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u325 = (TExecuteCommand*) P1_SD_INIT.GetCommand("u325",TCommand::kUpdate,TCommand::kCode);
	u325->SetExecutable(&P1_SD_INIT_u325_exe_g);
	u325->Code() = "u325 <- 1.200000";
	u325->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u326 = (TExecuteCommand*) P1_SD_TO_DOM_RATE.GetCommand("u326",TCommand::kUpdate,TCommand::kCode);
	u326->SetExecutable(&P1_SD_TO_DOM_RATE_u326_exe_g);
	u326->Code() = "u326 <- 0.000700";
	u326->SetObjInfo(TCommand::kDepIndex, 5);
	return 0;
}

int DOM_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int DOM_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int DOM_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int DOM_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class XXXIMPORTS1_module 
// ---------------------------------------------------------------------------
XXXIMPORTS1_module::XXXIMPORTS1_module(char* name) :
	TIME("TIME"),
	DAYJUL("DAYJUL"),
	AIR_TEMP_C("AIR_TEMP_C"),
	NPHBIO_HARVEST("NPHBIO_HARVEST"),
	NPHBIO_MORT("NPHBIO_MORT"),
	PHBIO_HARVEST("PHBIO_HARVEST"),
	PHBIO_MORT("PHBIO_MORT"),
	TModule(name) {

}	
int XXXIMPORTS1_module::DAYJUL_u327_exe() {
	float value;

	switch( DAYJUL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DAYJUL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SL::Mod(( TIME.Value()-dT() ), ((float)365))+((float)1) );
			DAYJUL.Update( p, value );
		}
		DAYJUL.GrabMemory();
		if( DAYJUL.GetF(FLinkEdges) ) { DAYJUL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SL::Mod(( TIME.Value()-dT() ), ((float)365))+((float)1) );
			DAYJUL.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS1_module::AIR_TEMP_C_u328_exe() {
	float value;

	switch( AIR_TEMP_C.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = AIR_TEMP_C.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph40(DAYJUL.Value(p));
			AIR_TEMP_C.Update( p, value );
		}
		AIR_TEMP_C.GrabMemory();
		if( AIR_TEMP_C.GetF(FLinkEdges) ) { AIR_TEMP_C.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph40(DAYJUL.Value());
			AIR_TEMP_C.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS1_module::NPHBIO_HARVEST_u329_exe() {
	float value;

	switch( NPHBIO_HARVEST.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NPHBIO_HARVEST.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph41(DAYJUL.Value(p));
			NPHBIO_HARVEST.Update( p, value );
		}
		NPHBIO_HARVEST.GrabMemory();
		if( NPHBIO_HARVEST.GetF(FLinkEdges) ) { NPHBIO_HARVEST.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph41(DAYJUL.Value());
			NPHBIO_HARVEST.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS1_module::NPHBIO_MORT_u330_exe() {
	float value;

	switch( NPHBIO_MORT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NPHBIO_MORT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph42(DAYJUL.Value(p));
			NPHBIO_MORT.Update( p, value );
		}
		NPHBIO_MORT.GrabMemory();
		if( NPHBIO_MORT.GetF(FLinkEdges) ) { NPHBIO_MORT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph42(DAYJUL.Value());
			NPHBIO_MORT.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS1_module::PHBIO_HARVEST_u331_exe() {
	float value;

	switch( PHBIO_HARVEST.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_HARVEST.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph43(DAYJUL.Value(p));
			PHBIO_HARVEST.Update( p, value );
		}
		PHBIO_HARVEST.GrabMemory();
		if( PHBIO_HARVEST.GetF(FLinkEdges) ) { PHBIO_HARVEST.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph43(DAYJUL.Value());
			PHBIO_HARVEST.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS1_module::PHBIO_MORT_u332_exe() {
	float value;

	switch( PHBIO_MORT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_MORT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph44(DAYJUL.Value(p));
			PHBIO_MORT.Update( p, value );
		}
		PHBIO_MORT.GrabMemory();
		if( PHBIO_MORT.GetF(FLinkEdges) ) { PHBIO_MORT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph44(DAYJUL.Value());
			PHBIO_MORT.Update( value );
	  } break;
	}
	return 0;
}

XXXIMPORTS1_module* XXXIMPORTS1_module::fInstance = NULL;
XXXIMPORTS1_module* XXXIMPORTS1_module::kNullModel = (XXXIMPORTS1_module*)0x1;
int XXXIMPORTS1_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int XXXIMPORTS1_module::InitVars() {
	
	TIME.SSInit(this);
	DAYJUL.SSInit(this);
	AIR_TEMP_C.SSInit(this);
	NPHBIO_HARVEST.SSInit(this);
	NPHBIO_MORT.SSInit(this);
	PHBIO_HARVEST.SSInit(this);
	PHBIO_MORT.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int XXXIMPORTS1_module::SetupEvents() {
	TExecuteCommand* u327 = (TExecuteCommand*) DAYJUL.GetCommand("u327",TCommand::kUpdate,TCommand::kCode);
	u327->SetExecutable(&DAYJUL_u327_exe_g);
	u327->Code() = "u327 <- ( SL::Mod(( TIME-dT() ), ((float)365))+((float)1) )";
	u327->AddDependency(TIME);
	u327->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u328 = (TExecuteCommand*) AIR_TEMP_C.GetCommand("u328",TCommand::kUpdate,TCommand::kCode);
	u328->SetExecutable(&AIR_TEMP_C_u328_exe_g);
	u328->Code() = "u328 <- Graph40(DAYJUL)";
	u328->AddDependency(DAYJUL);
	u328->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u329 = (TExecuteCommand*) NPHBIO_HARVEST.GetCommand("u329",TCommand::kUpdate,TCommand::kCode);
	u329->SetExecutable(&NPHBIO_HARVEST_u329_exe_g);
	u329->Code() = "u329 <- Graph41(DAYJUL)";
	u329->AddDependency(DAYJUL);
	u329->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u330 = (TExecuteCommand*) NPHBIO_MORT.GetCommand("u330",TCommand::kUpdate,TCommand::kCode);
	u330->SetExecutable(&NPHBIO_MORT_u330_exe_g);
	u330->Code() = "u330 <- Graph42(DAYJUL)";
	u330->AddDependency(DAYJUL);
	u330->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u331 = (TExecuteCommand*) PHBIO_HARVEST.GetCommand("u331",TCommand::kUpdate,TCommand::kCode);
	u331->SetExecutable(&PHBIO_HARVEST_u331_exe_g);
	u331->Code() = "u331 <- Graph43(DAYJUL)";
	u331->AddDependency(DAYJUL);
	u331->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u332 = (TExecuteCommand*) PHBIO_MORT.GetCommand("u332",TCommand::kUpdate,TCommand::kCode);
	u332->SetExecutable(&PHBIO_MORT_u332_exe_g);
	u332->Code() = "u332 <- Graph44(DAYJUL)";
	u332->AddDependency(DAYJUL);
	u332->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int XXXIMPORTS1_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int XXXIMPORTS1_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int XXXIMPORTS1_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int XXXIMPORTS1_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class ZDIN_module 
// ---------------------------------------------------------------------------
ZDIN_module::ZDIN_module(char* name) :
	TIME("TIME"),
	DIN_AVAILABLE("DIN_AVAILABLE"),
	DIN_SD("DIN_SD"),
	DIN_SF("DIN_SF"),
	SAT_WATER("SAT_WATER"),
	UNSAT_WATER("UNSAT_WATER"),
	UW_FROM_PRECIP("UW_FROM_PRECIP"),
	SW_TO_SATW_DOWNFLOW("SW_TO_SATW_DOWNFLOW"),
	SATW_FROM_PRECIP("SATW_FROM_PRECIP"),
	CELL_SIZE("CELL_SIZE"),
	AIR_TEMP_C("AIR_TEMP_C"),
	SATW_TO_SW_UPFLOW("SATW_TO_SW_UPFLOW"),
	PHBIO_NPP("PHBIO_NPP"),
	UW_DEPTH("UW_DEPTH"),
	ELEVATION("ELEVATION"),
	SATW_OUTFLUX("SATW_OUTFLUX"),
	SW_OUTFLUX("SW_OUTFLUX"),
	DAYJUL("DAYJUL"),
	HABITATMAP("HABITATMAP"),
	ROOT_DEPTH("ROOT_DEPTH"),
	SURFACE_WATER("SURFACE_WATER"),
	D_DECOMP("D_DECOMP"),
	P1_SEWERMAP("P1_SEWERMAP"),
	P1_POP_DENS("P1_POP_DENS"),
	HABITATMAPDB("HABITATMAPDB"),
	YIELD("YIELD"),
	OUT_F_SF("OUT_F_SF"),
	TOT_NPP("TOT_NPP"),
	SOIL("SOIL"),
	A_IN("A_IN"),
	ATM_FLOW("ATM_FLOW"),
	DIN_DNFLOW("DIN_DNFLOW"),
	FROM_PS_DINSD("FROM_PS_DINSD"),
	DOM_TO_DINSD("DOM_TO_DINSD"),
	DINSD_DENIT("DINSD_DENIT"),
	DIN_UPFLOW("DIN_UPFLOW"),
	DINSD_UPTAKE("DINSD_UPTAKE"),
	DINSD_HOUT("DINSD_HOUT"),
	FROM_ATMOS("FROM_ATMOS"),
	DOM_TO_DINSF("DOM_TO_DINSF"),
	FERT_AV("FERT_AV"),
	FROM_PS("FROM_PS"),
	DINSF_UPTAKE("DINSF_UPTAKE"),
	DINSF_OUT("DINSF_OUT"),
	FERTILIZER("FERTILIZER"),
	FROM_FERT("FROM_FERT"),
	F_IN("F_IN"),
	FERT_FLOW("FERT_FLOW"),
	M_IN("M_IN"),
	MINER_FLOW("MINER_FLOW"),
	S_IN("S_IN"),
	SEPTIC_FLOW("SEPTIC_FLOW"),
	COUNTY("COUNTY"),
	CROP("CROP"),
	DINSD_AVAIL("DINSD_AVAIL"),
	DINSD_CONC("DINSD_CONC"),
	DINSD_PR1("DINSD_PR1"),
	DINSD_PR2("DINSD_PR2"),
	DINSD_PR3("DINSD_PR3"),
	DINSF_AVAIL("DINSF_AVAIL"),
	DINSF_CONC("DINSF_CONC"),
	DINSF_PR1("DINSF_PR1"),
	DINSF_PR2("DINSF_PR2"),
	DOM_TO_DIN("DOM_TO_DIN"),
	N_NPOINTSD("N_NPOINTSD"),
	OUTPUTCOL("OUTPUTCOL"),
	OUTPUTROW("OUTPUTROW"),
	OUTPUTVAR("OUTPUTVAR"),
	SR_WATER("SR_WATER"),
	ZONMAP("ZONMAP"),
	P1_ATMOS_FACTOR("P1_ATMOS_FACTOR"),
	P1_DINSD_OUT("P1_DINSD_OUT"),
	P1_DINSF_OUT("P1_DINSF_OUT"),
	P1_DIN_CR_SED_MIN("P1_DIN_CR_SED_MIN"),
	P1_DIN_DAY_FERT1("P1_DIN_DAY_FERT1"),
	P1_DIN_DAY_FERT2("P1_DIN_DAY_FERT2"),
	P1_DIN_DIFFCOEF("P1_DIN_DIFFCOEF"),
	P1_DIN_FERT_APP("P1_DIN_FERT_APP"),
	P1_DIN_FERT_DIS("P1_DIN_FERT_DIS"),
	P1_DIN_FERT_HAB1("P1_DIN_FERT_HAB1"),
	P1_DIN_FERT_HAB2("P1_DIN_FERT_HAB2"),
	P1_DIN_GRAD("P1_DIN_GRAD"),
	P1_DIN_ICSED("P1_DIN_ICSED"),
	P1_DIN_ICSF("P1_DIN_ICSF"),
	P1_DIN_K_OF_NH4("P1_DIN_K_OF_NH4"),
	P1_DIN_RCDENIT("P1_DIN_RCDENIT"),
	P1_DOMSD_ANAEROB_Z("P1_DOMSD_ANAEROB_Z"),
	P1_DOM_CTOOM("P1_DOM_CTOOM"),
	P1_DOM_NC("P1_DOM_NC"),
	P1_PHBIO_NC("P1_PHBIO_NC"),
	P1_PHBIO_NC_SF("P1_PHBIO_NC_SF"),
	P1_POINTNSF("P1_POINTNSF"),
	P1_PS_FACTOR("P1_PS_FACTOR"),
	P1_R_SUB("P1_R_SUB"),
	P1_SEPTICLOAD("P1_SEPTICLOAD"),
	P1_SEPTIC_RED("P1_SEPTIC_RED"),
	DIN_IN_RAIN("DIN_IN_RAIN"),
	TModule(name) {

	DIN_AVAILABLE.SetF(FisExport,True,"CG");
	DIN_SD.SetF(FisExport,True,"CG");
	DIN_SF.SetF(FisExport,True,"CG");
	SAT_WATER.SetF(FisImport,True,"CG");
	UNSAT_WATER.SetF(FisImport,True,"CG");
	UW_FROM_PRECIP.SetF(FisImport,True,"CG");
	SW_TO_SATW_DOWNFLOW.SetF(FisImport,True,"CG");
	SATW_FROM_PRECIP.SetF(FisImport,True,"CG");
	CELL_SIZE.SetF(FisImport,True,"CG");
	AIR_TEMP_C.SetF(FisImport,True,"CG");
	SATW_TO_SW_UPFLOW.SetF(FisImport,True,"CG");
	PHBIO_NPP.SetF(FisImport,True,"CG");
	UW_DEPTH.SetF(FisImport,True,"CG");
	ELEVATION.SetF(FisImport,True,"CG");
	SATW_OUTFLUX.SetF(FisImport,True,"CG");
	SW_OUTFLUX.SetF(FisImport,True,"CG");
	DAYJUL.SetF(FisImport,True,"CG");
	HABITATMAP.SetF(FisImport,True,"CG");
	ROOT_DEPTH.SetF(FisImport,True,"CG");
	SURFACE_WATER.SetF(FisImport,True,"CG");
	D_DECOMP.SetF(FisImport,True,"CG");
	P1_SEWERMAP.SetF(FisImport,True,"CG");
	P1_POP_DENS.SetF(FisImport,True,"CG");
	HABITATMAPDB.SetF(FisImport,True,"CG");
	YIELD.SetF(FisImport,True,"CG");
	OUT_F_SF.SetF(FisImport,True,"CG");
	TOT_NPP.SetF(FisImport,True,"CG");
	SOIL.SetF(FisImport,True,"CG");
}	
int ZDIN_module::A_IN_I333_exe() {
	float value;

	A_IN.UpdateIntegrator(0);
	switch( A_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = A_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ATM_FLOW.Value(p);
			A_IN.Update( p, value, dT() );
		}
		A_IN.GrabMemory();
		if( A_IN.GetF(FLinkEdges) ) { A_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ATM_FLOW.Value();
			A_IN.Update( value, dT() );
	  } break;
	}
	return 0;
}

int ZDIN_module::A_IN_i334_exe() {
	float value;

	A_IN.UpdateIntegrator(1);
	switch( A_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = A_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			A_IN.InitValue( p, value );
		}
		A_IN.GrabMemory();
		if( A_IN.GetF(FLinkEdges) ) { A_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			A_IN.InitValue( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::ATM_FLOW_u335_exe() {
	float value;

	switch( ATM_FLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ATM_FLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( FROM_ATMOS.Value(p)*((float)10) );
			ATM_FLOW.Update( p, value );
		}
		ATM_FLOW.GrabMemory();
		if( ATM_FLOW.GetF(FICFlux) ) ATM_FLOW.Cov().Set(0.0); 
		if( ATM_FLOW.GetF(FLinkEdges) ) { ATM_FLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( FROM_ATMOS.Value()*((float)10) );
			ATM_FLOW.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_SD_I336_exe() {
	float value;

	DIN_SD.UpdateIntegrator(0);
	switch( DIN_SD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( ( DIN_DNFLOW.Value(p)+FROM_PS_DINSD.Value(p) )+DOM_TO_DINSD.Value(p) )-DINSD_DENIT.Value(p) )-DIN_UPFLOW.Value(p) )-DINSD_UPTAKE.Value(p) )-DINSD_HOUT.Value(p) );
			DIN_SD.Update( p, value, dT() );
		}
		DIN_SD.GrabMemory();
		if( DIN_SD.GetF(FLinkEdges) ) { DIN_SD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( ( DIN_DNFLOW.Value()+FROM_PS_DINSD.Value() )+DOM_TO_DINSD.Value() )-DINSD_DENIT.Value() )-DIN_UPFLOW.Value() )-DINSD_UPTAKE.Value() )-DINSD_HOUT.Value() );
			DIN_SD.Update( value, dT() );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_SD_i337_exe() {
	float value;

	DIN_SD.UpdateIntegrator(1);
	switch( DIN_SD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_DIN_ICSED.Value(p)*( SAT_WATER.Value(p)+UNSAT_WATER.Value(p) ) );
			DIN_SD.InitValue( p, value );
		}
		DIN_SD.GrabMemory();
		if( DIN_SD.GetF(FLinkEdges) ) { DIN_SD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_DIN_ICSED.Value()*( SAT_WATER.Value()+UNSAT_WATER.Value() ) );
			DIN_SD.InitValue( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_DNFLOW_u338_exe() {
	float value;

	switch( DIN_DNFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_DNFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(( DIN_SF.Value(p)/dT() ), ( ( DINSF_CONC.Value(p)*P1_DIN_DIFFCOEF.Value(p) )*( ( UW_FROM_PRECIP.Value(p)+SW_TO_SATW_DOWNFLOW.Value(p) )+SATW_FROM_PRECIP.Value(p) ) ));
			DIN_DNFLOW.Update( p, value );
		}
		DIN_DNFLOW.GrabMemory();
		if( DIN_DNFLOW.GetF(FICFlux) ) DIN_DNFLOW.Cov().Set(0.0); 
		if( DIN_DNFLOW.GetF(FLinkEdges) ) { DIN_DNFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(( DIN_SF.Value()/dT() ), ( ( DINSF_CONC.Value()*P1_DIN_DIFFCOEF.Value() )*( ( UW_FROM_PRECIP.Value()+SW_TO_SATW_DOWNFLOW.Value() )+SATW_FROM_PRECIP.Value() ) ));
			DIN_DNFLOW.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::FROM_PS_DINSD_u339_exe() {
	float value;

	switch( FROM_PS_DINSD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FROM_PS_DINSD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ((float)1000)*N_NPOINTSD.Value(p) )/CELL_SIZE.Value(p) );
			FROM_PS_DINSD.Update( p, value );
		}
		FROM_PS_DINSD.GrabMemory();
		if( FROM_PS_DINSD.GetF(FICFlux) ) FROM_PS_DINSD.Cov().Set(0.0); 
		if( FROM_PS_DINSD.GetF(FLinkEdges) ) { FROM_PS_DINSD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ((float)1000)*N_NPOINTSD.Value() )/CELL_SIZE.Value() );
			FROM_PS_DINSD.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DOM_TO_DINSD_u340_exe() {
	float value;

	switch( DOM_TO_DINSD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DOM_TO_DINSD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DOM_TO_DIN.Value(p)*( ((float)1)-P1_DIN_GRAD.Value(p) ) );
			DOM_TO_DINSD.Update( p, value );
		}
		DOM_TO_DINSD.GrabMemory();
		if( DOM_TO_DINSD.GetF(FICFlux) ) DOM_TO_DINSD.Cov().Set(0.0); 
		if( DOM_TO_DINSD.GetF(FLinkEdges) ) { DOM_TO_DINSD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DOM_TO_DIN.Value()*( ((float)1)-P1_DIN_GRAD.Value() ) );
			DOM_TO_DINSD.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_DENIT_u341_exe() {
	float value;

	switch( DINSD_DENIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_DENIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(( DIN_SD.Value(p)/dT() ), ( ( ( P1_DIN_RCDENIT.Value(p)*pow((double)1.04,(double)( AIR_TEMP_C.Value(p)-((float)20) ) ) )*P1_DOMSD_ANAEROB_Z.Value(p) )*DIN_SD.Value(p) ));
			DINSD_DENIT.Update( p, value );
		}
		DINSD_DENIT.GrabMemory();
		if( DINSD_DENIT.GetF(FICFlux) ) DINSD_DENIT.Cov().Set(0.0); 
		if( DINSD_DENIT.GetF(FLinkEdges) ) { DINSD_DENIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(( DIN_SD.Value()/dT() ), ( ( ( P1_DIN_RCDENIT.Value()*pow((double)1.04,(double)( AIR_TEMP_C.Value()-((float)20) ) ) )*P1_DOMSD_ANAEROB_Z.Value() )*DIN_SD.Value() ));
			DINSD_DENIT.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_UPFLOW_u342_exe() {
	float value;

	switch( DIN_UPFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_UPFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SD.Value(p)/dT() )-DINSD_PR1.Value(p) )), ( DINSD_CONC.Value(p)*SATW_TO_SW_UPFLOW.Value(p) ));
			DIN_UPFLOW.Update( p, value );
		}
		DIN_UPFLOW.GrabMemory();
		if( DIN_UPFLOW.GetF(FICFlux) ) DIN_UPFLOW.Cov().Set(0.0); 
		if( DIN_UPFLOW.GetF(FLinkEdges) ) { DIN_UPFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SD.Value()/dT() )-DINSD_PR1.Value() )), ( DINSD_CONC.Value()*SATW_TO_SW_UPFLOW.Value() ));
			DIN_UPFLOW.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_UPTAKE_u343_exe() {
	float value;

	switch( DINSD_UPTAKE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_UPTAKE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SD.Value(p)/dT() )-DINSD_PR2.Value(p) )), DINSD_AVAIL.Value(p), ( ( ( PHBIO_NPP.Value(p)*P1_PHBIO_NC.Value(p) )*P1_DIN_K_OF_NH4.Value(p) )*((float)1000) ));
			DINSD_UPTAKE.Update( p, value );
		}
		DINSD_UPTAKE.GrabMemory();
		if( DINSD_UPTAKE.GetF(FICFlux) ) DINSD_UPTAKE.Cov().Set(0.0); 
		if( DINSD_UPTAKE.GetF(FLinkEdges) ) { DINSD_UPTAKE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SD.Value()/dT() )-DINSD_PR2.Value() )), DINSD_AVAIL.Value(), ( ( ( PHBIO_NPP.Value()*P1_PHBIO_NC.Value() )*P1_DIN_K_OF_NH4.Value() )*((float)1000) ));
			DINSD_UPTAKE.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_HOUT_u344_exe() {
	float value;

	switch( DINSD_HOUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_HOUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_DINSD_OUT.Value(p)*SL::Min(SL::Max(((float)0), ( ( DIN_SD.Value(p)/dT() )-DINSD_PR3.Value(p) )),  ( ( ( UW_DEPTH.Value(p) <= P1_R_SUB.Value(p) ) ) ? ( ( ( ( ( DIN_SD.Value(p)*( ( ( ( ((float)2)*ELEVATION.Value(p) )-P1_R_SUB.Value(p) )-UW_DEPTH.Value(p) )-SATW_OUTFLUX.Value(p) ) )*SATW_OUTFLUX.Value(p) )/( ELEVATION.Value(p)-P1_R_SUB.Value(p) ) )/( ELEVATION.Value(p)-UW_DEPTH.Value(p) ) ) ) : ( ( ( ( ( DIN_SD.Value(p)*( ( ( ((float)2)*ELEVATION.Value(p) )-( ((float)2)*UW_DEPTH.Value(p) ) )-SATW_OUTFLUX.Value(p) ) )*SATW_OUTFLUX.Value(p) )/( ( ELEVATION.Value(p)+UW_DEPTH.Value(p) )-( ((float)2)*P1_R_SUB.Value(p) ) ) )/( ELEVATION.Value(p)-UW_DEPTH.Value(p) ) ) ) ) ) );
			DINSD_HOUT.Update( p, value );
		}
		DINSD_HOUT.GrabMemory();
		if( DINSD_HOUT.GetF(FICFlux) ) DINSD_HOUT.Cov().Set(0.0); 
		if( DINSD_HOUT.GetF(FLinkEdges) ) { DINSD_HOUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_DINSD_OUT.Value()*SL::Min(SL::Max(((float)0), ( ( DIN_SD.Value()/dT() )-DINSD_PR3.Value() )),  ( ( ( UW_DEPTH.Value() <= P1_R_SUB.Value() ) ) ? ( ( ( ( ( DIN_SD.Value()*( ( ( ( ((float)2)*ELEVATION.Value() )-P1_R_SUB.Value() )-UW_DEPTH.Value() )-SATW_OUTFLUX.Value() ) )*SATW_OUTFLUX.Value() )/( ELEVATION.Value()-P1_R_SUB.Value() ) )/( ELEVATION.Value()-UW_DEPTH.Value() ) ) ) : ( ( ( ( ( DIN_SD.Value()*( ( ( ((float)2)*ELEVATION.Value() )-( ((float)2)*UW_DEPTH.Value() ) )-SATW_OUTFLUX.Value() ) )*SATW_OUTFLUX.Value() )/( ( ELEVATION.Value()+UW_DEPTH.Value() )-( ((float)2)*P1_R_SUB.Value() ) ) )/( ELEVATION.Value()-UW_DEPTH.Value() ) ) ) ) ) );
			DINSD_HOUT.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_SF_I345_exe() {
	float value;

	DIN_SF.UpdateIntegrator(0);
	switch( DIN_SF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( ( ( FROM_ATMOS.Value(p)+DIN_UPFLOW.Value(p) )+DOM_TO_DINSF.Value(p) )+FERT_AV.Value(p) )+FROM_PS.Value(p) )-DIN_DNFLOW.Value(p) )-DINSF_UPTAKE.Value(p) )-DINSF_OUT.Value(p) );
			DIN_SF.Update( p, value, dT() );
		}
		DIN_SF.GrabMemory();
		if( DIN_SF.GetF(FLinkEdges) ) { DIN_SF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( ( ( FROM_ATMOS.Value()+DIN_UPFLOW.Value() )+DOM_TO_DINSF.Value() )+FERT_AV.Value() )+FROM_PS.Value() )-DIN_DNFLOW.Value() )-DINSF_UPTAKE.Value() )-DINSF_OUT.Value() );
			DIN_SF.Update( value, dT() );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_SF_i346_exe() {
	float value;

	DIN_SF.UpdateIntegrator(1);
	switch( DIN_SF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  P1_DIN_ICSF.Value(p);
			DIN_SF.InitValue( p, value );
		}
		DIN_SF.GrabMemory();
		if( DIN_SF.GetF(FLinkEdges) ) { DIN_SF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  P1_DIN_ICSF.Value();
			DIN_SF.InitValue( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::FROM_ATMOS_u347_exe() {
	float value;

	switch( FROM_ATMOS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FROM_ATMOS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DIN_IN_RAIN.Value(p)*P1_ATMOS_FACTOR.Value(p) );
			FROM_ATMOS.Update( p, value );
		}
		FROM_ATMOS.GrabMemory();
		if( FROM_ATMOS.GetF(FICFlux) ) FROM_ATMOS.Cov().Set(0.0); 
		if( FROM_ATMOS.GetF(FLinkEdges) ) { FROM_ATMOS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DIN_IN_RAIN.Value()*P1_ATMOS_FACTOR.Value() );
			FROM_ATMOS.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DOM_TO_DINSF_u348_exe() {
	float value;

	switch( DOM_TO_DINSF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DOM_TO_DINSF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DOM_TO_DIN.Value(p)*P1_DIN_GRAD.Value(p) );
			DOM_TO_DINSF.Update( p, value );
		}
		DOM_TO_DINSF.GrabMemory();
		if( DOM_TO_DINSF.GetF(FICFlux) ) DOM_TO_DINSF.Cov().Set(0.0); 
		if( DOM_TO_DINSF.GetF(FLinkEdges) ) { DOM_TO_DINSF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DOM_TO_DIN.Value()*P1_DIN_GRAD.Value() );
			DOM_TO_DINSF.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::FERT_AV_u349_exe() {
	float value;

	switch( FERT_AV.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FERT_AV.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_DIN_FERT_DIS.Value(p)*FERTILIZER.Value(p) );
			FERT_AV.Update( p, value );
		}
		FERT_AV.GrabMemory();
		if( FERT_AV.GetF(FICFlux) ) FERT_AV.Cov().Set(0.0); 
		if( FERT_AV.GetF(FLinkEdges) ) { FERT_AV.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_DIN_FERT_DIS.Value()*FERTILIZER.Value() );
			FERT_AV.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::FROM_PS_u350_exe() {
	float value;

	switch( FROM_PS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FROM_PS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_POINTNSF.Value(p)*P1_PS_FACTOR.Value(p) )/CELL_SIZE.Value(p) );
			FROM_PS.Update( p, value );
		}
		FROM_PS.GrabMemory();
		if( FROM_PS.GetF(FICFlux) ) FROM_PS.Cov().Set(0.0); 
		if( FROM_PS.GetF(FLinkEdges) ) { FROM_PS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_POINTNSF.Value()*P1_PS_FACTOR.Value() )/CELL_SIZE.Value() );
			FROM_PS.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSF_UPTAKE_u351_exe() {
	float value;

	switch( DINSF_UPTAKE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSF_UPTAKE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SF.Value(p)/dT() )-DINSF_PR1.Value(p) )), DINSF_AVAIL.Value(p), ( ( ( PHBIO_NPP.Value(p)*P1_PHBIO_NC_SF.Value(p) )*P1_DIN_K_OF_NH4.Value(p) )*((float)1000) ));
			DINSF_UPTAKE.Update( p, value );
		}
		DINSF_UPTAKE.GrabMemory();
		if( DINSF_UPTAKE.GetF(FICFlux) ) DINSF_UPTAKE.Cov().Set(0.0); 
		if( DINSF_UPTAKE.GetF(FLinkEdges) ) { DINSF_UPTAKE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SF.Value()/dT() )-DINSF_PR1.Value() )), DINSF_AVAIL.Value(), ( ( ( PHBIO_NPP.Value()*P1_PHBIO_NC_SF.Value() )*P1_DIN_K_OF_NH4.Value() )*((float)1000) ));
			DINSF_UPTAKE.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSF_OUT_u352_exe() {
	float value;

	switch( DINSF_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSF_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SF.Value(p)/dT() )-DINSF_PR2.Value(p) )), ( ( P1_DINSF_OUT.Value(p)*DINSF_CONC.Value(p) )*SW_OUTFLUX.Value(p) ));
			DINSF_OUT.Update( p, value );
		}
		DINSF_OUT.GrabMemory();
		if( DINSF_OUT.GetF(FICFlux) ) DINSF_OUT.Cov().Set(0.0); 
		if( DINSF_OUT.GetF(FLinkEdges) ) { DINSF_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SF.Value()/dT() )-DINSF_PR2.Value() )), ( ( P1_DINSF_OUT.Value()*DINSF_CONC.Value() )*SW_OUTFLUX.Value() ));
			DINSF_OUT.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::FERTILIZER_I353_exe() {
	float value;

	FERTILIZER.UpdateIntegrator(0);
	switch( FERTILIZER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FERTILIZER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( FROM_FERT.Value(p)-FERT_AV.Value(p) );
			FERTILIZER.Update( p, value, dT() );
		}
		FERTILIZER.GrabMemory();
		if( FERTILIZER.GetF(FLinkEdges) ) { FERTILIZER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( FROM_FERT.Value()-FERT_AV.Value() );
			FERTILIZER.Update( value, dT() );
	  } break;
	}
	return 0;
}

int ZDIN_module::FERTILIZER_i354_exe() {
	float value;

	FERTILIZER.UpdateIntegrator(1);
	switch( FERTILIZER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FERTILIZER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			FERTILIZER.InitValue( p, value );
		}
		FERTILIZER.GrabMemory();
		if( FERTILIZER.GetF(FLinkEdges) ) { FERTILIZER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			FERTILIZER.InitValue( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::FROM_FERT_u355_exe() {
	float value;

	switch( FROM_FERT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FROM_FERT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( DAYJUL.Value(p) == P1_DIN_DAY_FERT1.Value(p) ) ) ? ( ( ( P1_DIN_FERT_APP.Value(p)*P1_DIN_FERT_HAB1.Value(p) )*0.1 ) ) : (  ( ( ( DAYJUL.Value(p) == P1_DIN_DAY_FERT2.Value(p) ) ) ? ( ( ( P1_DIN_FERT_APP.Value(p)*P1_DIN_FERT_HAB2.Value(p) )*0.1 ) ) : ( ((float)0) ) )  ) ) ;
			FROM_FERT.Update( p, value );
		}
		FROM_FERT.GrabMemory();
		if( FROM_FERT.GetF(FICFlux) ) FROM_FERT.Cov().Set(0.0); 
		if( FROM_FERT.GetF(FLinkEdges) ) { FROM_FERT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( DAYJUL.Value() == P1_DIN_DAY_FERT1.Value() ) ) ? ( ( ( P1_DIN_FERT_APP.Value()*P1_DIN_FERT_HAB1.Value() )*0.1 ) ) : (  ( ( ( DAYJUL.Value() == P1_DIN_DAY_FERT2.Value() ) ) ? ( ( ( P1_DIN_FERT_APP.Value()*P1_DIN_FERT_HAB2.Value() )*0.1 ) ) : ( ((float)0) ) )  ) ) ;
			FROM_FERT.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::F_IN_I356_exe() {
	float value;

	F_IN.UpdateIntegrator(0);
	switch( F_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = F_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  FERT_FLOW.Value(p);
			F_IN.Update( p, value, dT() );
		}
		F_IN.GrabMemory();
		if( F_IN.GetF(FLinkEdges) ) { F_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  FERT_FLOW.Value();
			F_IN.Update( value, dT() );
	  } break;
	}
	return 0;
}

int ZDIN_module::F_IN_i357_exe() {
	float value;

	F_IN.UpdateIntegrator(1);
	switch( F_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = F_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			F_IN.InitValue( p, value );
		}
		F_IN.GrabMemory();
		if( F_IN.GetF(FLinkEdges) ) { F_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			F_IN.InitValue( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::FERT_FLOW_u358_exe() {
	float value;

	switch( FERT_FLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FERT_FLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( FROM_FERT.Value(p)*((float)10) );
			FERT_FLOW.Update( p, value );
		}
		FERT_FLOW.GrabMemory();
		if( FERT_FLOW.GetF(FICFlux) ) FERT_FLOW.Cov().Set(0.0); 
		if( FERT_FLOW.GetF(FLinkEdges) ) { FERT_FLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( FROM_FERT.Value()*((float)10) );
			FERT_FLOW.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::M_IN_I359_exe() {
	float value;

	M_IN.UpdateIntegrator(0);
	switch( M_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = M_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  MINER_FLOW.Value(p);
			M_IN.Update( p, value, dT() );
		}
		M_IN.GrabMemory();
		if( M_IN.GetF(FLinkEdges) ) { M_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  MINER_FLOW.Value();
			M_IN.Update( value, dT() );
	  } break;
	}
	return 0;
}

int ZDIN_module::M_IN_i360_exe() {
	float value;

	M_IN.UpdateIntegrator(1);
	switch( M_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = M_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			M_IN.InitValue( p, value );
		}
		M_IN.GrabMemory();
		if( M_IN.GetF(FLinkEdges) ) { M_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			M_IN.InitValue( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::MINER_FLOW_u361_exe() {
	float value;

	switch( MINER_FLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MINER_FLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( DOM_TO_DINSD.Value(p)+DOM_TO_DINSF.Value(p) )*((float)10) );
			MINER_FLOW.Update( p, value );
		}
		MINER_FLOW.GrabMemory();
		if( MINER_FLOW.GetF(FICFlux) ) MINER_FLOW.Cov().Set(0.0); 
		if( MINER_FLOW.GetF(FLinkEdges) ) { MINER_FLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( DOM_TO_DINSD.Value()+DOM_TO_DINSF.Value() )*((float)10) );
			MINER_FLOW.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::S_IN_I362_exe() {
	float value;

	S_IN.UpdateIntegrator(0);
	switch( S_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = S_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SEPTIC_FLOW.Value(p);
			S_IN.Update( p, value, dT() );
		}
		S_IN.GrabMemory();
		if( S_IN.GetF(FLinkEdges) ) { S_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SEPTIC_FLOW.Value();
			S_IN.Update( value, dT() );
	  } break;
	}
	return 0;
}

int ZDIN_module::S_IN_i363_exe() {
	float value;

	S_IN.UpdateIntegrator(1);
	switch( S_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = S_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			S_IN.InitValue( p, value );
		}
		S_IN.GrabMemory();
		if( S_IN.GetF(FLinkEdges) ) { S_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			S_IN.InitValue( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::SEPTIC_FLOW_u364_exe() {
	float value;

	switch( SEPTIC_FLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SEPTIC_FLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( FROM_PS_DINSD.Value(p)*((float)10) );
			SEPTIC_FLOW.Update( p, value );
		}
		SEPTIC_FLOW.GrabMemory();
		if( SEPTIC_FLOW.GetF(FICFlux) ) SEPTIC_FLOW.Cov().Set(0.0); 
		if( SEPTIC_FLOW.GetF(FLinkEdges) ) { SEPTIC_FLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( FROM_PS_DINSD.Value()*((float)10) );
			SEPTIC_FLOW.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::COUNTY_u365_exe() {
	float value;

	switch( COUNTY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = COUNTY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)1)+( ((float)0)*HABITATMAP.Value(p) ) );
			COUNTY.Update( p, value );
		}
		COUNTY.GrabMemory();
		if( COUNTY.GetF(FLinkEdges) ) { COUNTY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)1)+( ((float)0)*HABITATMAP.Value() ) );
			COUNTY.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::CROP_u366_exe() {
	float value;

	switch( CROP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CROP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)1)+( ((float)0)*HABITATMAP.Value(p) ) );
			CROP.Update( p, value );
		}
		CROP.GrabMemory();
		if( CROP.GetF(FLinkEdges) ) { CROP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)1)+( ((float)0)*HABITATMAP.Value() ) );
			CROP.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_AVAIL_u367_exe() {
	float value;

	switch( DINSD_AVAIL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_AVAIL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ROOT_DEPTH.Value(p) <= P1_R_SUB.Value(p) ) ) ? ( ((float)0) ) : ( ( DIN_SD.Value(p)* ( ( ( ( ROOT_DEPTH.Value(p) >  P1_R_SUB.Value(p) ) && ( P1_R_SUB.Value(p) >= UW_DEPTH.Value(p) ) ) ) ? ( ( ( ( ( ( ( ((float)2)*ELEVATION.Value(p) )-UW_DEPTH.Value(p) )-ROOT_DEPTH.Value(p) )*( ROOT_DEPTH.Value(p)-P1_R_SUB.Value(p) ) )/( ELEVATION.Value(p)-ROOT_DEPTH.Value(p) ) )/( ELEVATION.Value(p)-UW_DEPTH.Value(p) ) ) ) : (  ( ( ( ( P1_R_SUB.Value(p) <= ROOT_DEPTH.Value(p) ) && ( ROOT_DEPTH.Value(p) <  UW_DEPTH.Value(p) ) ) ) ? ( ( ( ((float)2)*( ROOT_DEPTH.Value(p)-P1_R_SUB.Value(p) ) )/( ELEVATION.Value(p)-P1_R_SUB.Value(p) ) ) ) : ( ( ( ( ((float)2)*( UW_DEPTH.Value(p)-P1_R_SUB.Value(p) ) )+( ( ( ( ( ((float)2)*ELEVATION.Value(p) )-UW_DEPTH.Value(p) )-ROOT_DEPTH.Value(p) )*( ROOT_DEPTH.Value(p)-UW_DEPTH.Value(p) ) )/( ELEVATION.Value(p)-UW_DEPTH.Value(p) ) ) )/( ( ELEVATION.Value(p)+UW_DEPTH.Value(p) )-( ((float)2)*P1_R_SUB.Value(p) ) ) ) ) )  ) )  ) ) ) ;
			DINSD_AVAIL.Update( p, value );
		}
		DINSD_AVAIL.GrabMemory();
		if( DINSD_AVAIL.GetF(FLinkEdges) ) { DINSD_AVAIL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ROOT_DEPTH.Value() <= P1_R_SUB.Value() ) ) ? ( ((float)0) ) : ( ( DIN_SD.Value()* ( ( ( ( ROOT_DEPTH.Value() >  P1_R_SUB.Value() ) && ( P1_R_SUB.Value() >= UW_DEPTH.Value() ) ) ) ? ( ( ( ( ( ( ( ((float)2)*ELEVATION.Value() )-UW_DEPTH.Value() )-ROOT_DEPTH.Value() )*( ROOT_DEPTH.Value()-P1_R_SUB.Value() ) )/( ELEVATION.Value()-ROOT_DEPTH.Value() ) )/( ELEVATION.Value()-UW_DEPTH.Value() ) ) ) : (  ( ( ( ( P1_R_SUB.Value() <= ROOT_DEPTH.Value() ) && ( ROOT_DEPTH.Value() <  UW_DEPTH.Value() ) ) ) ? ( ( ( ((float)2)*( ROOT_DEPTH.Value()-P1_R_SUB.Value() ) )/( ELEVATION.Value()-P1_R_SUB.Value() ) ) ) : ( ( ( ( ((float)2)*( UW_DEPTH.Value()-P1_R_SUB.Value() ) )+( ( ( ( ( ((float)2)*ELEVATION.Value() )-UW_DEPTH.Value() )-ROOT_DEPTH.Value() )*( ROOT_DEPTH.Value()-UW_DEPTH.Value() ) )/( ELEVATION.Value()-UW_DEPTH.Value() ) ) )/( ( ELEVATION.Value()+UW_DEPTH.Value() )-( ((float)2)*P1_R_SUB.Value() ) ) ) ) )  ) )  ) ) ) ;
			DINSD_AVAIL.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_CONC_u368_exe() {
	float value;

	switch( DINSD_CONC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_CONC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DIN_SD.Value(p)/( SAT_WATER.Value(p)+UNSAT_WATER.Value(p) ) );
			DINSD_CONC.Update( p, value );
		}
		DINSD_CONC.GrabMemory();
		if( DINSD_CONC.GetF(FLinkEdges) ) { DINSD_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DIN_SD.Value()/( SAT_WATER.Value()+UNSAT_WATER.Value() ) );
			DINSD_CONC.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_PR1_u369_exe() {
	float value;

	switch( DINSD_PR1.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_PR1.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  DINSD_DENIT.Value(p);
			DINSD_PR1.Update( p, value );
		}
		DINSD_PR1.GrabMemory();
		if( DINSD_PR1.GetF(FLinkEdges) ) { DINSD_PR1.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  DINSD_DENIT.Value();
			DINSD_PR1.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_PR2_u370_exe() {
	float value;

	switch( DINSD_PR2.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_PR2.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DIN_UPFLOW.Value(p)+DINSD_PR1.Value(p) );
			DINSD_PR2.Update( p, value );
		}
		DINSD_PR2.GrabMemory();
		if( DINSD_PR2.GetF(FLinkEdges) ) { DINSD_PR2.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DIN_UPFLOW.Value()+DINSD_PR1.Value() );
			DINSD_PR2.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_PR3_u371_exe() {
	float value;

	switch( DINSD_PR3.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_PR3.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DINSD_UPTAKE.Value(p)+DINSD_PR2.Value(p) );
			DINSD_PR3.Update( p, value );
		}
		DINSD_PR3.GrabMemory();
		if( DINSD_PR3.GetF(FLinkEdges) ) { DINSD_PR3.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DINSD_UPTAKE.Value()+DINSD_PR2.Value() );
			DINSD_PR3.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSF_AVAIL_u372_exe() {
	float value;

	switch( DINSF_AVAIL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSF_AVAIL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SURFACE_WATER.Value(p) >  ((float)0) ) ) ? ( ( DINSF_CONC.Value(p)*( SURFACE_WATER.Value(p)+SR_WATER.Value(p) ) ) ) : ( ( ( DINSF_CONC.Value(p)*( ((float)1)-P1_DIN_DIFFCOEF.Value(p) ) )*SR_WATER.Value(p) ) ) ) ;
			DINSF_AVAIL.Update( p, value );
		}
		DINSF_AVAIL.GrabMemory();
		if( DINSF_AVAIL.GetF(FLinkEdges) ) { DINSF_AVAIL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SURFACE_WATER.Value() >  ((float)0) ) ) ? ( ( DINSF_CONC.Value()*( SURFACE_WATER.Value()+SR_WATER.Value() ) ) ) : ( ( ( DINSF_CONC.Value()*( ((float)1)-P1_DIN_DIFFCOEF.Value() ) )*SR_WATER.Value() ) ) ) ;
			DINSF_AVAIL.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSF_CONC_u373_exe() {
	float value;

	switch( DINSF_CONC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSF_CONC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( SURFACE_WATER.Value(p)+SR_WATER.Value(p) ) >  0.0 ) ) ? ( ( DIN_SF.Value(p)/( SURFACE_WATER.Value(p)+SR_WATER.Value(p) ) ) ) : ( ((float)0) ) ) ;
			DINSF_CONC.Update( p, value );
		}
		DINSF_CONC.GrabMemory();
		if( DINSF_CONC.GetF(FLinkEdges) ) { DINSF_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( SURFACE_WATER.Value()+SR_WATER.Value() ) >  0.0 ) ) ? ( ( DIN_SF.Value()/( SURFACE_WATER.Value()+SR_WATER.Value() ) ) ) : ( ((float)0) ) ) ;
			DINSF_CONC.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSF_PR1_u374_exe() {
	float value;

	switch( DINSF_PR1.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSF_PR1.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  DIN_DNFLOW.Value(p);
			DINSF_PR1.Update( p, value );
		}
		DINSF_PR1.GrabMemory();
		if( DINSF_PR1.GetF(FLinkEdges) ) { DINSF_PR1.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  DIN_DNFLOW.Value();
			DINSF_PR1.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSF_PR2_u375_exe() {
	float value;

	switch( DINSF_PR2.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSF_PR2.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DINSF_PR1.Value(p)+DINSF_UPTAKE.Value(p) );
			DINSF_PR2.Update( p, value );
		}
		DINSF_PR2.GrabMemory();
		if( DINSF_PR2.GetF(FLinkEdges) ) { DINSF_PR2.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DINSF_PR1.Value()+DINSF_UPTAKE.Value() );
			DINSF_PR2.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_AVAILABLE_u376_exe() {
	float value;

	switch( DIN_AVAILABLE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_AVAILABLE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DINSD_AVAIL.Value(p)+DINSF_AVAIL.Value(p) );
			DIN_AVAILABLE.Update( p, value );
		}
		DIN_AVAILABLE.GrabMemory();
		if( DIN_AVAILABLE.GetF(FLinkEdges) ) { DIN_AVAILABLE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DINSD_AVAIL.Value()+DINSF_AVAIL.Value() );
			DIN_AVAILABLE.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DOM_TO_DIN_u377_exe() {
	float value;

	switch( DOM_TO_DIN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DOM_TO_DIN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( D_DECOMP.Value(p)*P1_DOM_NC.Value(p) )*P1_DOM_CTOOM.Value(p) )*P1_DIN_CR_SED_MIN.Value(p) )*((float)1000) );
			DOM_TO_DIN.Update( p, value );
		}
		DOM_TO_DIN.GrabMemory();
		if( DOM_TO_DIN.GetF(FLinkEdges) ) { DOM_TO_DIN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( D_DECOMP.Value()*P1_DOM_NC.Value() )*P1_DOM_CTOOM.Value() )*P1_DIN_CR_SED_MIN.Value() )*((float)1000) );
			DOM_TO_DIN.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::N_NPOINTSD_u378_exe() {
	float value;

	switch( N_NPOINTSD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = N_NPOINTSD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( P1_SEWERMAP.Value(p) == ((float)3) ) ) ? ( ((float)0) ) : ( ( ( P1_SEPTICLOAD.Value(p)*P1_POP_DENS.Value(p) )*P1_SEPTIC_RED.Value(p) ) ) ) ;
			N_NPOINTSD.Update( p, value );
		}
		N_NPOINTSD.GrabMemory();
		if( N_NPOINTSD.GetF(FLinkEdges) ) { N_NPOINTSD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( P1_SEWERMAP.Value() == ((float)3) ) ) ? ( ((float)0) ) : ( ( ( P1_SEPTICLOAD.Value()*P1_POP_DENS.Value() )*P1_SEPTIC_RED.Value() ) ) ) ;
			N_NPOINTSD.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::OUTPUTCOL_u379_exe() {
	float value;

	switch( OUTPUTCOL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = OUTPUTCOL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  40;
			OUTPUTCOL.Update( p, OUTPUTCOL.ParameterValue(value,p) );
		}
		OUTPUTCOL.GrabMemory();
		if( OUTPUTCOL.GetF(FLinkEdges) ) { OUTPUTCOL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  40;
			OUTPUTCOL.Update( OUTPUTCOL.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::OUTPUTROW_u380_exe() {
	float value;

	switch( OUTPUTROW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = OUTPUTROW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  35;
			OUTPUTROW.Update( p, OUTPUTROW.ParameterValue(value,p) );
		}
		OUTPUTROW.GrabMemory();
		if( OUTPUTROW.GetF(FLinkEdges) ) { OUTPUTROW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  35;
			OUTPUTROW.Update( OUTPUTROW.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::OUTPUTVAR_u381_exe() {
	float value;

	switch( OUTPUTVAR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = OUTPUTVAR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( HABITATMAP.Value(p)*((float)0) );
			OUTPUTVAR.Update( p, value );
		}
		OUTPUTVAR.GrabMemory();
		if( OUTPUTVAR.GetF(FLinkEdges) ) { OUTPUTVAR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( HABITATMAP.Value()*((float)0) );
			OUTPUTVAR.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::OUTPUTVAR_v441_exe() {
	float value;

			 Goal_Func(OUTPUTVAR, HABITATMAP, HABITATMAPDB, YIELD, P1_DIN_FERT_APP, OUT_F_SF, TOT_NPP);
	return 0;
}

int ZDIN_module::SR_WATER_u382_exe() {
	float value;

	switch( SR_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SR_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( P1_R_SUB.Value(p) <  UW_DEPTH.Value(p) ) ) ? ( ( ( UNSAT_WATER.Value(p)*P1_R_SUB.Value(p) )/UW_DEPTH.Value(p) ) ) : ( ( UNSAT_WATER.Value(p)+( ( ( P1_R_SUB.Value(p)-UW_DEPTH.Value(p) )/( ELEVATION.Value(p)-UW_DEPTH.Value(p) ) )*SAT_WATER.Value(p) ) ) ) ) ;
			SR_WATER.Update( p, value );
		}
		SR_WATER.GrabMemory();
		if( SR_WATER.GetF(FLinkEdges) ) { SR_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( P1_R_SUB.Value() <  UW_DEPTH.Value() ) ) ? ( ( ( UNSAT_WATER.Value()*P1_R_SUB.Value() )/UW_DEPTH.Value() ) ) : ( ( UNSAT_WATER.Value()+( ( ( P1_R_SUB.Value()-UW_DEPTH.Value() )/( ELEVATION.Value()-UW_DEPTH.Value() ) )*SAT_WATER.Value() ) ) ) ) ;
			SR_WATER.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::ZONMAP_u383_exe() {
	float value;

	switch( ZONMAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ZONMAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)0)+( ((float)0)*HABITATMAP.Value(p) ) );
			ZONMAP.Update( p, value );
		}
		ZONMAP.GrabMemory();
		if( ZONMAP.GetF(FLinkEdges) ) { ZONMAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)0)+( ((float)0)*HABITATMAP.Value() ) );
			ZONMAP.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_ATMOS_FACTOR_u384_exe() {
	float value;

	switch( P1_ATMOS_FACTOR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_ATMOS_FACTOR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.214;
			P1_ATMOS_FACTOR.Update( p, P1_ATMOS_FACTOR.ParameterValue(value,p) );
		}
		P1_ATMOS_FACTOR.GrabMemory();
		if( P1_ATMOS_FACTOR.GetF(FLinkEdges) ) { P1_ATMOS_FACTOR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.214;
			P1_ATMOS_FACTOR.Update( P1_ATMOS_FACTOR.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DINSD_OUT_u385_exe() {
	float value;

	switch( P1_DINSD_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DINSD_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0;
			P1_DINSD_OUT.Update( p, P1_DINSD_OUT.ParameterValue(value,p) );
		}
		P1_DINSD_OUT.GrabMemory();
		if( P1_DINSD_OUT.GetF(FLinkEdges) ) { P1_DINSD_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0;
			P1_DINSD_OUT.Update( P1_DINSD_OUT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DINSF_OUT_u386_exe() {
	float value;

	switch( P1_DINSF_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DINSF_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0;
			P1_DINSF_OUT.Update( p, P1_DINSF_OUT.ParameterValue(value,p) );
		}
		P1_DINSF_OUT.GrabMemory();
		if( P1_DINSF_OUT.GetF(FLinkEdges) ) { P1_DINSF_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0;
			P1_DINSF_OUT.Update( P1_DINSF_OUT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_CR_SED_MIN_u387_exe() {
	float value;

	switch( P1_DIN_CR_SED_MIN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_CR_SED_MIN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.2;
			P1_DIN_CR_SED_MIN.Update( p, P1_DIN_CR_SED_MIN.ParameterValue(value,p) );
		}
		P1_DIN_CR_SED_MIN.GrabMemory();
		if( P1_DIN_CR_SED_MIN.GetF(FLinkEdges) ) { P1_DIN_CR_SED_MIN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.2;
			P1_DIN_CR_SED_MIN.Update( P1_DIN_CR_SED_MIN.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_DAY_FERT1_u388_exe() {
	float value;

	switch( P1_DIN_DAY_FERT1.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_DAY_FERT1.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)191);
			P1_DIN_DAY_FERT1.Update( p, value );
		}
		P1_DIN_DAY_FERT1.GrabMemory();
		if( P1_DIN_DAY_FERT1.GetF(FLinkEdges) ) { P1_DIN_DAY_FERT1.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)191);
			P1_DIN_DAY_FERT1.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_DAY_FERT2_u389_exe() {
	float value;

	switch( P1_DIN_DAY_FERT2.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_DAY_FERT2.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)999);
			P1_DIN_DAY_FERT2.Update( p, value );
		}
		P1_DIN_DAY_FERT2.GrabMemory();
		if( P1_DIN_DAY_FERT2.GetF(FLinkEdges) ) { P1_DIN_DAY_FERT2.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)999);
			P1_DIN_DAY_FERT2.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_DIFFCOEF_u390_exe() {
	float value;

	switch( P1_DIN_DIFFCOEF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_DIFFCOEF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.7;
			P1_DIN_DIFFCOEF.Update( p, P1_DIN_DIFFCOEF.ParameterValue(value,p) );
		}
		P1_DIN_DIFFCOEF.GrabMemory();
		if( P1_DIN_DIFFCOEF.GetF(FLinkEdges) ) { P1_DIN_DIFFCOEF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.7;
			P1_DIN_DIFFCOEF.Update( P1_DIN_DIFFCOEF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_FERT_APP_u391_exe() {
	float value;

	switch( P1_DIN_FERT_APP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_FERT_APP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)145);
			P1_DIN_FERT_APP.Update( p, P1_DIN_FERT_APP.ParameterValue(value,p) );
		}
		P1_DIN_FERT_APP.GrabMemory();
		if( P1_DIN_FERT_APP.GetF(FLinkEdges) ) { P1_DIN_FERT_APP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)145);
			P1_DIN_FERT_APP.Update( P1_DIN_FERT_APP.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_FERT_APP_v442_exe() {
	float value;

			 FertilizerMap(P1_DIN_FERT_APP, HABITATMAP, SOIL, COUNTY);
	return 0;
}

int ZDIN_module::P1_DIN_FERT_DIS_u392_exe() {
	float value;

	switch( P1_DIN_FERT_DIS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_FERT_DIS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.050000;
			P1_DIN_FERT_DIS.Update( p, P1_DIN_FERT_DIS.ParameterValue(value,p) );
		}
		P1_DIN_FERT_DIS.GrabMemory();
		if( P1_DIN_FERT_DIS.GetF(FLinkEdges) ) { P1_DIN_FERT_DIS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.050000;
			P1_DIN_FERT_DIS.Update( P1_DIN_FERT_DIS.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_FERT_HAB1_u393_exe() {
	float value;

	switch( P1_DIN_FERT_HAB1.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_FERT_HAB1.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.75;
			P1_DIN_FERT_HAB1.Update( p, value );
		}
		P1_DIN_FERT_HAB1.GrabMemory();
		if( P1_DIN_FERT_HAB1.GetF(FLinkEdges) ) { P1_DIN_FERT_HAB1.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.75;
			P1_DIN_FERT_HAB1.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_FERT_HAB2_u394_exe() {
	float value;

	switch( P1_DIN_FERT_HAB2.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_FERT_HAB2.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_DIN_FERT_HAB2.Update( p, value );
		}
		P1_DIN_FERT_HAB2.GrabMemory();
		if( P1_DIN_FERT_HAB2.GetF(FLinkEdges) ) { P1_DIN_FERT_HAB2.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_DIN_FERT_HAB2.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_GRAD_u395_exe() {
	float value;

	switch( P1_DIN_GRAD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_GRAD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.7;
			P1_DIN_GRAD.Update( p, P1_DIN_GRAD.ParameterValue(value,p) );
		}
		P1_DIN_GRAD.GrabMemory();
		if( P1_DIN_GRAD.GetF(FLinkEdges) ) { P1_DIN_GRAD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.7;
			P1_DIN_GRAD.Update( P1_DIN_GRAD.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_ICSED_u396_exe() {
	float value;

	switch( P1_DIN_ICSED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_ICSED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.15;
			P1_DIN_ICSED.Update( p, value );
		}
		P1_DIN_ICSED.GrabMemory();
		if( P1_DIN_ICSED.GetF(FLinkEdges) ) { P1_DIN_ICSED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.15;
			P1_DIN_ICSED.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_ICSF_u397_exe() {
	float value;

	switch( P1_DIN_ICSF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_ICSF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.3;
			P1_DIN_ICSF.Update( p, value );
		}
		P1_DIN_ICSF.GrabMemory();
		if( P1_DIN_ICSF.GetF(FLinkEdges) ) { P1_DIN_ICSF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.3;
			P1_DIN_ICSF.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_K_OF_NH4_u398_exe() {
	float value;

	switch( P1_DIN_K_OF_NH4.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_K_OF_NH4.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.5;
			P1_DIN_K_OF_NH4.Update( p, P1_DIN_K_OF_NH4.ParameterValue(value,p) );
		}
		P1_DIN_K_OF_NH4.GrabMemory();
		if( P1_DIN_K_OF_NH4.GetF(FLinkEdges) ) { P1_DIN_K_OF_NH4.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.5;
			P1_DIN_K_OF_NH4.Update( P1_DIN_K_OF_NH4.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_RCDENIT_u399_exe() {
	float value;

	switch( P1_DIN_RCDENIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_RCDENIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.001;
			P1_DIN_RCDENIT.Update( p, P1_DIN_RCDENIT.ParameterValue(value,p) );
		}
		P1_DIN_RCDENIT.GrabMemory();
		if( P1_DIN_RCDENIT.GetF(FLinkEdges) ) { P1_DIN_RCDENIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.001;
			P1_DIN_RCDENIT.Update( P1_DIN_RCDENIT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DOMSD_ANAEROB_Z_u400_exe() {
	float value;

	switch( P1_DOMSD_ANAEROB_Z.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DOMSD_ANAEROB_Z.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_DOMSD_ANAEROB_Z.Update( p, P1_DOMSD_ANAEROB_Z.ParameterValue(value,p) );
		}
		P1_DOMSD_ANAEROB_Z.GrabMemory();
		if( P1_DOMSD_ANAEROB_Z.GetF(FLinkEdges) ) { P1_DOMSD_ANAEROB_Z.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_DOMSD_ANAEROB_Z.Update( P1_DOMSD_ANAEROB_Z.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DOM_CTOOM_u401_exe() {
	float value;

	switch( P1_DOM_CTOOM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DOM_CTOOM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.2;
			P1_DOM_CTOOM.Update( p, value );
		}
		P1_DOM_CTOOM.GrabMemory();
		if( P1_DOM_CTOOM.GetF(FLinkEdges) ) { P1_DOM_CTOOM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.2;
			P1_DOM_CTOOM.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DOM_NC_u402_exe() {
	float value;

	switch( P1_DOM_NC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DOM_NC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_DOM_NC.Update( p, value );
		}
		P1_DOM_NC.GrabMemory();
		if( P1_DOM_NC.GetF(FLinkEdges) ) { P1_DOM_NC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_DOM_NC.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_PHBIO_NC_u403_exe() {
	float value;

	switch( P1_PHBIO_NC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHBIO_NC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.1;
			P1_PHBIO_NC.Update( p, value );
		}
		P1_PHBIO_NC.GrabMemory();
		if( P1_PHBIO_NC.GetF(FLinkEdges) ) { P1_PHBIO_NC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.1;
			P1_PHBIO_NC.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_PHBIO_NC_SF_u404_exe() {
	float value;

	switch( P1_PHBIO_NC_SF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHBIO_NC_SF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.01;
			P1_PHBIO_NC_SF.Update( p, value );
		}
		P1_PHBIO_NC_SF.GrabMemory();
		if( P1_PHBIO_NC_SF.GetF(FLinkEdges) ) { P1_PHBIO_NC_SF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.01;
			P1_PHBIO_NC_SF.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_POINTNSF_u405_exe() {
	float value;

	switch( P1_POINTNSF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_POINTNSF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0;
			P1_POINTNSF.Update( p, P1_POINTNSF.ParameterValue(value,p) );
		}
		P1_POINTNSF.GrabMemory();
		if( P1_POINTNSF.GetF(FLinkEdges) ) { P1_POINTNSF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0;
			P1_POINTNSF.Update( P1_POINTNSF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_PS_FACTOR_u406_exe() {
	float value;

	switch( P1_PS_FACTOR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PS_FACTOR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  454;
			P1_PS_FACTOR.Update( p, P1_PS_FACTOR.ParameterValue(value,p) );
		}
		P1_PS_FACTOR.GrabMemory();
		if( P1_PS_FACTOR.GetF(FLinkEdges) ) { P1_PS_FACTOR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  454;
			P1_PS_FACTOR.Update( P1_PS_FACTOR.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_R_SUB_u407_exe() {
	float value;

	switch( P1_R_SUB.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_R_SUB.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.1;
			P1_R_SUB.Update( p, P1_R_SUB.ParameterValue(value,p) );
		}
		P1_R_SUB.GrabMemory();
		if( P1_R_SUB.GetF(FLinkEdges) ) { P1_R_SUB.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.1;
			P1_R_SUB.Update( P1_R_SUB.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_SEPTICLOAD_u408_exe() {
	float value;

	switch( P1_SEPTICLOAD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SEPTICLOAD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.0132;
			P1_SEPTICLOAD.Update( p, P1_SEPTICLOAD.ParameterValue(value,p) );
		}
		P1_SEPTICLOAD.GrabMemory();
		if( P1_SEPTICLOAD.GetF(FLinkEdges) ) { P1_SEPTICLOAD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.0132;
			P1_SEPTICLOAD.Update( P1_SEPTICLOAD.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_SEPTIC_RED_u409_exe() {
	float value;

	switch( P1_SEPTIC_RED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SEPTIC_RED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.8;
			P1_SEPTIC_RED.Update( p, P1_SEPTIC_RED.ParameterValue(value,p) );
		}
		P1_SEPTIC_RED.GrabMemory();
		if( P1_SEPTIC_RED.GetF(FLinkEdges) ) { P1_SEPTIC_RED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.8;
			P1_SEPTIC_RED.Update( P1_SEPTIC_RED.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_IN_RAIN_u410_exe() {
	float value;

	switch( DIN_IN_RAIN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_IN_RAIN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph45(DAYJUL.Value(p));
			DIN_IN_RAIN.Update( p, value );
		}
		DIN_IN_RAIN.GrabMemory();
		if( DIN_IN_RAIN.GetF(FLinkEdges) ) { DIN_IN_RAIN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph45(DAYJUL.Value());
			DIN_IN_RAIN.Update( value );
	  } break;
	}
	return 0;
}

ZDIN_module* ZDIN_module::fInstance = NULL;
ZDIN_module* ZDIN_module::kNullModel = (ZDIN_module*)0x1;
int ZDIN_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int ZDIN_module::InitVars() {
	
	TIME.SSInit(this);
	DIN_AVAILABLE.SSInit(this);
	DIN_SD.SSInit(this);
	DIN_SF.SSInit(this);
	SAT_WATER.SSInit(this);
	UNSAT_WATER.SSInit(this);
	UW_FROM_PRECIP.SSInit(this);
	SW_TO_SATW_DOWNFLOW.SSInit(this);
	SATW_FROM_PRECIP.SSInit(this);
	CELL_SIZE.SSInit(this);
	AIR_TEMP_C.SSInit(this);
	SATW_TO_SW_UPFLOW.SSInit(this);
	PHBIO_NPP.SSInit(this);
	UW_DEPTH.SSInit(this);
	ELEVATION.SSInit(this);
	SATW_OUTFLUX.SSInit(this);
	SW_OUTFLUX.SSInit(this);
	DAYJUL.SSInit(this);
	HABITATMAP.SSInit(this);
	HABITATMAP.SetLinkEdges();
	ROOT_DEPTH.SSInit(this);
	SURFACE_WATER.SSInit(this);
	D_DECOMP.SSInit(this);
	P1_SEWERMAP.SSInit(this);
	P1_POP_DENS.SSInit(this);
	HABITATMAPDB.SSInit(this);
	HABITATMAPDB.SetLinkEdges();
	YIELD.SSInit(this);
	YIELD.SetLinkEdges();
	OUT_F_SF.SSInit(this);
	OUT_F_SF.SetLinkEdges();
	TOT_NPP.SSInit(this);
	TOT_NPP.SetLinkEdges();
	SOIL.SSInit(this);
	SOIL.SetLinkEdges();
	A_IN.SSInit(this);
	ATM_FLOW.SSInit(this);
	ATM_FLOW.SetDestination(&A_IN);
	DIN_DNFLOW.SSInit(this);
	DIN_DNFLOW.SetOrigin(&DIN_SF);
	DIN_DNFLOW.SetDestination(&DIN_SD);
	FROM_PS_DINSD.SSInit(this);
	FROM_PS_DINSD.SetDestination(&DIN_SD);
	DOM_TO_DINSD.SSInit(this);
	DOM_TO_DINSD.SetDestination(&DIN_SD);
	DINSD_DENIT.SSInit(this);
	DINSD_DENIT.SetOrigin(&DIN_SD);
	DIN_UPFLOW.SSInit(this);
	DIN_UPFLOW.SetOrigin(&DIN_SD);
	DIN_UPFLOW.SetDestination(&DIN_SF);
	DINSD_UPTAKE.SSInit(this);
	DINSD_UPTAKE.SetOrigin(&DIN_SD);
	DINSD_HOUT.SSInit(this);
	DINSD_HOUT.SetOrigin(&DIN_SD);
	FROM_ATMOS.SSInit(this);
	FROM_ATMOS.SetDestination(&DIN_SF);
	DOM_TO_DINSF.SSInit(this);
	DOM_TO_DINSF.SetDestination(&DIN_SF);
	FERT_AV.SSInit(this);
	FERT_AV.SetOrigin(&FERTILIZER);
	FERT_AV.SetDestination(&DIN_SF);
	FROM_PS.SSInit(this);
	FROM_PS.SetDestination(&DIN_SF);
	DINSF_UPTAKE.SSInit(this);
	DINSF_UPTAKE.SetOrigin(&DIN_SF);
	DINSF_OUT.SSInit(this);
	DINSF_OUT.SetOrigin(&DIN_SF);
	FERTILIZER.SSInit(this);
	FROM_FERT.SSInit(this);
	FROM_FERT.SetDestination(&FERTILIZER);
	F_IN.SSInit(this);
	FERT_FLOW.SSInit(this);
	FERT_FLOW.SetDestination(&F_IN);
	M_IN.SSInit(this);
	MINER_FLOW.SSInit(this);
	MINER_FLOW.SetDestination(&M_IN);
	S_IN.SSInit(this);
	SEPTIC_FLOW.SSInit(this);
	SEPTIC_FLOW.SetDestination(&S_IN);
	COUNTY.SSInit(this);
	COUNTY.SetLinkEdges();
	CROP.SSInit(this);
	DINSD_AVAIL.SSInit(this);
	DINSD_CONC.SSInit(this);
	DINSD_PR1.SSInit(this);
	DINSD_PR2.SSInit(this);
	DINSD_PR3.SSInit(this);
	DINSF_AVAIL.SSInit(this);
	DINSF_CONC.SSInit(this);
	DINSF_PR1.SSInit(this);
	DINSF_PR2.SSInit(this);
	DOM_TO_DIN.SSInit(this);
	N_NPOINTSD.SSInit(this);
	OUTPUTCOL.SSInit(this);
	OUTPUTROW.SSInit(this);
	OUTPUTVAR.SSInit(this);
	OUTPUTVAR.SetLinkEdges();
	SR_WATER.SSInit(this);
	ZONMAP.SSInit(this);
	P1_ATMOS_FACTOR.SSInit(this);
	P1_DINSD_OUT.SSInit(this);
	P1_DINSF_OUT.SSInit(this);
	P1_DIN_CR_SED_MIN.SSInit(this);
	P1_DIN_DAY_FERT1.SSInit(this);
	P1_DIN_DAY_FERT2.SSInit(this);
	P1_DIN_DIFFCOEF.SSInit(this);
	P1_DIN_FERT_APP.SSInit(this);
	P1_DIN_FERT_APP.SetLinkEdges();
	P1_DIN_FERT_DIS.SSInit(this);
	P1_DIN_FERT_HAB1.SSInit(this);
	P1_DIN_FERT_HAB2.SSInit(this);
	P1_DIN_GRAD.SSInit(this);
	P1_DIN_ICSED.SSInit(this);
	P1_DIN_ICSF.SSInit(this);
	P1_DIN_K_OF_NH4.SSInit(this);
	P1_DIN_RCDENIT.SSInit(this);
	P1_DOMSD_ANAEROB_Z.SSInit(this);
	P1_DOM_CTOOM.SSInit(this);
	P1_DOM_NC.SSInit(this);
	P1_PHBIO_NC.SSInit(this);
	P1_PHBIO_NC_SF.SSInit(this);
	P1_POINTNSF.SSInit(this);
	P1_PS_FACTOR.SSInit(this);
	P1_R_SUB.SSInit(this);
	P1_SEPTICLOAD.SSInit(this);
	P1_SEPTIC_RED.SSInit(this);
	DIN_IN_RAIN.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int ZDIN_module::SetupEvents() {
	TExecuteCommand* u376 = (TExecuteCommand*) DIN_AVAILABLE.GetCommand("u376",TCommand::kUpdate,TCommand::kCode);
	u376->SetExecutable(&DIN_AVAILABLE_u376_exe_g);
	u376->Code() = "u376 <- ( DINSD_AVAIL+DINSF_AVAIL )";
	u376->AddDependency(DINSD_AVAIL);
	u376->AddDependency(DINSF_AVAIL);
	u376->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I336 = (TExecuteCommand*) DIN_SD.GetCommand("I336",TCommand::kIntegrate,TCommand::kCode);
	I336->SetExecutable(&DIN_SD_I336_exe_g);
	I336->Code() = "I336 <- ( ( ( ( ( ( DIN_DNFLOW+FROM_PS_DINSD )+DOM_TO_DINSD )-DINSD_DENIT )-DIN_UPFLOW )-DINSD_UPTAKE )-DINSD_HOUT )";
	I336->AddDependency(DIN_DNFLOW);
	I336->AddDependency(FROM_PS_DINSD);
	I336->AddDependency(DOM_TO_DINSD);
	I336->AddDependency(DINSD_DENIT);
	I336->AddDependency(DIN_UPFLOW);
	I336->AddDependency(DINSD_UPTAKE);
	I336->AddDependency(DINSD_HOUT);
	I336->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i337 = (TExecuteCommand*) DIN_SD.GetCommand("i337",TCommand::kInit,TCommand::kCode);
	i337->SetExecutable(&DIN_SD_i337_exe_g);
	i337->Code() = "i337 <- ( P1_DIN_ICSED*( SAT_WATER+UNSAT_WATER ) )";
	i337->AddDependency(HABITATMAP);
	i337->AddDependency(P1_DIN_ICSED);
	i337->AddDependency(SAT_WATER);
	i337->AddDependency(UNSAT_WATER);
	i337->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I345 = (TExecuteCommand*) DIN_SF.GetCommand("I345",TCommand::kIntegrate,TCommand::kCode);
	I345->SetExecutable(&DIN_SF_I345_exe_g);
	I345->Code() = "I345 <- ( ( ( ( ( ( ( FROM_ATMOS+DIN_UPFLOW )+DOM_TO_DINSF )+FERT_AV )+FROM_PS )-DIN_DNFLOW )-DINSF_UPTAKE )-DINSF_OUT )";
	I345->AddDependency(FROM_ATMOS);
	I345->AddDependency(DIN_UPFLOW);
	I345->AddDependency(DOM_TO_DINSF);
	I345->AddDependency(FERT_AV);
	I345->AddDependency(FROM_PS);
	I345->AddDependency(DIN_DNFLOW);
	I345->AddDependency(DINSF_UPTAKE);
	I345->AddDependency(DINSF_OUT);
	I345->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i346 = (TExecuteCommand*) DIN_SF.GetCommand("i346",TCommand::kInit,TCommand::kCode);
	i346->SetExecutable(&DIN_SF_i346_exe_g);
	i346->Code() = "i346 <- P1_DIN_ICSF";
	i346->AddDependency(HABITATMAP);
	i346->AddDependency(P1_DIN_ICSF);
	i346->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SAT_WATER_import = (TImportCommand*) SAT_WATER.GetCommand("SAT_WATER_import",TCommand::kUndefined,TCommand::kImport);
	SAT_WATER_import->Code() = "Import SAT_WATER from HYDROLOGY_module";
	SAT_WATER_import->AddDependency(SAT_WATER);
	SAT_WATER_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* UNSAT_WATER_import = (TImportCommand*) UNSAT_WATER.GetCommand("UNSAT_WATER_import",TCommand::kUndefined,TCommand::kImport);
	UNSAT_WATER_import->Code() = "Import UNSAT_WATER from HYDROLOGY_module";
	UNSAT_WATER_import->AddDependency(UNSAT_WATER);
	UNSAT_WATER_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* UW_FROM_PRECIP_import = (TImportCommand*) UW_FROM_PRECIP.GetCommand("UW_FROM_PRECIP_import",TCommand::kUndefined,TCommand::kImport);
	UW_FROM_PRECIP_import->Code() = "Import UW_FROM_PRECIP from HYDROLOGY_module";
	UW_FROM_PRECIP_import->AddDependency(UW_FROM_PRECIP);
	UW_FROM_PRECIP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SW_TO_SATW_DOWNFLOW_import = (TImportCommand*) SW_TO_SATW_DOWNFLOW.GetCommand("SW_TO_SATW_DOWNFLOW_import",TCommand::kUndefined,TCommand::kImport);
	SW_TO_SATW_DOWNFLOW_import->Code() = "Import SW_TO_SATW_DOWNFLOW from HYDROLOGY_module";
	SW_TO_SATW_DOWNFLOW_import->AddDependency(SW_TO_SATW_DOWNFLOW);
	SW_TO_SATW_DOWNFLOW_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SATW_FROM_PRECIP_import = (TImportCommand*) SATW_FROM_PRECIP.GetCommand("SATW_FROM_PRECIP_import",TCommand::kUndefined,TCommand::kImport);
	SATW_FROM_PRECIP_import->Code() = "Import SATW_FROM_PRECIP from HYDROLOGY_module";
	SATW_FROM_PRECIP_import->AddDependency(SATW_FROM_PRECIP);
	SATW_FROM_PRECIP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CELL_SIZE_import = (TImportCommand*) CELL_SIZE.GetCommand("CELL_SIZE_import",TCommand::kUndefined,TCommand::kImport);
	CELL_SIZE_import->Code() = "Import CELL_SIZE from GLOBALS_module";
	CELL_SIZE_import->AddDependency(CELL_SIZE);
	CELL_SIZE_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* AIR_TEMP_C_import = (TImportCommand*) AIR_TEMP_C.GetCommand("AIR_TEMP_C_import",TCommand::kUndefined,TCommand::kImport);
	AIR_TEMP_C_import->Code() = "Import AIR_TEMP_C from GLOBALS_module";
	AIR_TEMP_C_import->AddDependency(AIR_TEMP_C);
	AIR_TEMP_C_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SATW_TO_SW_UPFLOW_import = (TImportCommand*) SATW_TO_SW_UPFLOW.GetCommand("SATW_TO_SW_UPFLOW_import",TCommand::kUndefined,TCommand::kImport);
	SATW_TO_SW_UPFLOW_import->Code() = "Import SATW_TO_SW_UPFLOW from HYDROLOGY_module";
	SATW_TO_SW_UPFLOW_import->AddDependency(SATW_TO_SW_UPFLOW);
	SATW_TO_SW_UPFLOW_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PHBIO_NPP_import = (TImportCommand*) PHBIO_NPP.GetCommand("PHBIO_NPP_import",TCommand::kUndefined,TCommand::kImport);
	PHBIO_NPP_import->Code() = "Import PHBIO_NPP from MACROPHYTES_module";
	PHBIO_NPP_import->AddDependency(PHBIO_NPP);
	PHBIO_NPP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* UW_DEPTH_import = (TImportCommand*) UW_DEPTH.GetCommand("UW_DEPTH_import",TCommand::kUndefined,TCommand::kImport);
	UW_DEPTH_import->Code() = "Import UW_DEPTH from HYDROLOGY_module";
	UW_DEPTH_import->AddDependency(UW_DEPTH);
	UW_DEPTH_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ELEVATION_import = (TImportCommand*) ELEVATION.GetCommand("ELEVATION_import",TCommand::kUndefined,TCommand::kImport);
	ELEVATION_import->Code() = "Import ELEVATION from GLOBALS_module";
	ELEVATION_import->AddDependency(ELEVATION);
	ELEVATION_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SATW_OUTFLUX_import = (TImportCommand*) SATW_OUTFLUX.GetCommand("SATW_OUTFLUX_import",TCommand::kUndefined,TCommand::kImport);
	SATW_OUTFLUX_import->Code() = "Import SATW_OUTFLUX from HYDROLOGY_module";
	SATW_OUTFLUX_import->AddDependency(SATW_OUTFLUX);
	SATW_OUTFLUX_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SW_OUTFLUX_import = (TImportCommand*) SW_OUTFLUX.GetCommand("SW_OUTFLUX_import",TCommand::kUndefined,TCommand::kImport);
	SW_OUTFLUX_import->Code() = "Import SW_OUTFLUX from HYDROLOGY_module";
	SW_OUTFLUX_import->AddDependency(SW_OUTFLUX);
	SW_OUTFLUX_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DAYJUL_import = (TImportCommand*) DAYJUL.GetCommand("DAYJUL_import",TCommand::kUndefined,TCommand::kImport);
	DAYJUL_import->Code() = "Import DAYJUL from GLOBALS_module";
	DAYJUL_import->AddDependency(DAYJUL);
	DAYJUL_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* HABITATMAP_import = (TImportCommand*) HABITATMAP.GetCommand("HABITATMAP_import",TCommand::kUndefined,TCommand::kImport);
	HABITATMAP_import->Code() = "Import HABITATMAP from GLOBALS_module";
	HABITATMAP_import->AddDependency(HABITATMAP);
	HABITATMAP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ROOT_DEPTH_import = (TImportCommand*) ROOT_DEPTH.GetCommand("ROOT_DEPTH_import",TCommand::kUndefined,TCommand::kImport);
	ROOT_DEPTH_import->Code() = "Import ROOT_DEPTH from MACROPHYTES_module";
	ROOT_DEPTH_import->AddDependency(ROOT_DEPTH);
	ROOT_DEPTH_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SURFACE_WATER_import = (TImportCommand*) SURFACE_WATER.GetCommand("SURFACE_WATER_import",TCommand::kUndefined,TCommand::kImport);
	SURFACE_WATER_import->Code() = "Import SURFACE_WATER from HYDROLOGY_module";
	SURFACE_WATER_import->AddDependency(SURFACE_WATER);
	SURFACE_WATER_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* D_DECOMP_import = (TImportCommand*) D_DECOMP.GetCommand("D_DECOMP_import",TCommand::kUndefined,TCommand::kImport);
	D_DECOMP_import->Code() = "Import D_DECOMP from DOM_module";
	D_DECOMP_import->AddDependency(D_DECOMP);
	D_DECOMP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_SEWERMAP_import = (TImportCommand*) P1_SEWERMAP.GetCommand("P1_SEWERMAP_import",TCommand::kUndefined,TCommand::kImport);
	P1_SEWERMAP_import->Code() = "Import P1_SEWERMAP from GLOBALS_module";
	P1_SEWERMAP_import->AddDependency(P1_SEWERMAP);
	P1_SEWERMAP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_POP_DENS_import = (TImportCommand*) P1_POP_DENS.GetCommand("P1_POP_DENS_import",TCommand::kUndefined,TCommand::kImport);
	P1_POP_DENS_import->Code() = "Import P1_POP_DENS from GLOBALS_module";
	P1_POP_DENS_import->AddDependency(P1_POP_DENS);
	P1_POP_DENS_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* HABITATMAPDB_import = (TImportCommand*) HABITATMAPDB.GetCommand("HABITATMAPDB_import",TCommand::kUndefined,TCommand::kImport);
	HABITATMAPDB_import->Code() = "Import HABITATMAPDB from GLOBALS_module";
	HABITATMAPDB_import->AddDependency(HABITATMAPDB);
	HABITATMAPDB_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* YIELD_import = (TImportCommand*) YIELD.GetCommand("YIELD_import",TCommand::kUndefined,TCommand::kImport);
	YIELD_import->Code() = "Import YIELD from MACROPHYTES_module";
	YIELD_import->AddDependency(YIELD);
	YIELD_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* OUT_F_SF_import = (TImportCommand*) OUT_F_SF.GetCommand("OUT_F_SF_import",TCommand::kUndefined,TCommand::kImport);
	OUT_F_SF_import->Code() = "Import OUT_F_SF from HYDROLOGY_module";
	OUT_F_SF_import->AddDependency(OUT_F_SF);
	OUT_F_SF_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* TOT_NPP_import = (TImportCommand*) TOT_NPP.GetCommand("TOT_NPP_import",TCommand::kUndefined,TCommand::kImport);
	TOT_NPP_import->Code() = "Import TOT_NPP from MACROPHYTES_module";
	TOT_NPP_import->AddDependency(TOT_NPP);
	TOT_NPP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SOIL_import = (TImportCommand*) SOIL.GetCommand("SOIL_import",TCommand::kUndefined,TCommand::kImport);
	SOIL_import->Code() = "Import SOIL from GLOBALS_module";
	SOIL_import->AddDependency(SOIL);
	SOIL_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I333 = (TExecuteCommand*) A_IN.GetCommand("I333",TCommand::kIntegrate,TCommand::kCode);
	I333->SetExecutable(&A_IN_I333_exe_g);
	I333->Code() = "I333 <- ATM_FLOW";
	I333->AddDependency(ATM_FLOW);
	I333->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i334 = (TExecuteCommand*) A_IN.GetCommand("i334",TCommand::kInit,TCommand::kCode);
	i334->SetExecutable(&A_IN_i334_exe_g);
	i334->Code() = "i334 <- ((float)0)";
	i334->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u335 = (TExecuteCommand*) ATM_FLOW.GetCommand("u335",TCommand::kUpdate,TCommand::kCode);
	u335->SetExecutable(&ATM_FLOW_u335_exe_g);
	u335->Code() = "u335 <- ( FROM_ATMOS*((float)10) )";
	u335->AddDependency(FROM_ATMOS);
	u335->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u338 = (TExecuteCommand*) DIN_DNFLOW.GetCommand("u338",TCommand::kUpdate,TCommand::kCode);
	u338->SetExecutable(&DIN_DNFLOW_u338_exe_g);
	u338->Code() = "u338 <- SL::Min(( DIN_SF/dT() ), ( ( DINSF_CONC*P1_DIN_DIFFCOEF )*( ( UW_FROM_PRECIP+SW_TO_SATW_DOWNFLOW )+SATW_FROM_PRECIP ) ))";
	if( DIN_SF.GetF(FisClamped) ) { u338->AddDependency(DIN_SF); }
	u338->AddDependency(DIN_SF);
	u338->AddDependency(DINSF_CONC);
	u338->AddDependency(P1_DIN_DIFFCOEF);
	u338->AddDependency(UW_FROM_PRECIP);
	u338->AddDependency(SW_TO_SATW_DOWNFLOW);
	u338->AddDependency(SATW_FROM_PRECIP);
	u338->AddDependency(DIN_UPFLOW);
	u338->AddDependency(FROM_ATMOS);
	u338->AddDependency(DOM_TO_DINSF);
	u338->AddDependency(FERT_AV);
	u338->AddDependency(FROM_PS);
	u338->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u339 = (TExecuteCommand*) FROM_PS_DINSD.GetCommand("u339",TCommand::kUpdate,TCommand::kCode);
	u339->SetExecutable(&FROM_PS_DINSD_u339_exe_g);
	u339->Code() = "u339 <- ( ( ((float)1000)*N_NPOINTSD )/CELL_SIZE )";
	u339->AddDependency(N_NPOINTSD);
	u339->AddDependency(CELL_SIZE);
	u339->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u340 = (TExecuteCommand*) DOM_TO_DINSD.GetCommand("u340",TCommand::kUpdate,TCommand::kCode);
	u340->SetExecutable(&DOM_TO_DINSD_u340_exe_g);
	u340->Code() = "u340 <- ( DOM_TO_DIN*( ((float)1)-P1_DIN_GRAD ) )";
	u340->AddDependency(DOM_TO_DIN);
	u340->AddDependency(P1_DIN_GRAD);
	u340->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u341 = (TExecuteCommand*) DINSD_DENIT.GetCommand("u341",TCommand::kUpdate,TCommand::kCode);
	u341->SetExecutable(&DINSD_DENIT_u341_exe_g);
	u341->Code() = "u341 <- SL::Min(( DIN_SD/dT() ), ( ( ( P1_DIN_RCDENIT*pow((double)1.04,(double)( AIR_TEMP_C-((float)20) ) ) )*P1_DOMSD_ANAEROB_Z )*DIN_SD ))";
	if( DIN_SD.GetF(FisClamped) ) { u341->AddDependency(DIN_SD); }
	u341->AddDependency(DIN_SD);
	u341->AddDependency(P1_DIN_RCDENIT);
	u341->AddDependency(AIR_TEMP_C);
	u341->AddDependency(P1_DOMSD_ANAEROB_Z);
	u341->AddDependency(FROM_PS_DINSD);
	u341->AddDependency(DOM_TO_DINSD);
	u341->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u342 = (TExecuteCommand*) DIN_UPFLOW.GetCommand("u342",TCommand::kUpdate,TCommand::kCode);
	u342->SetExecutable(&DIN_UPFLOW_u342_exe_g);
	u342->Code() = "u342 <- SL::Min(SL::Max(((float)0), ( ( DIN_SD/dT() )-DINSD_PR1 )), ( DINSD_CONC*SATW_TO_SW_UPFLOW ))";
	if( DIN_SD.GetF(FisClamped) ) { u342->AddDependency(DIN_SD); }
	u342->AddDependency(DIN_SD);
	u342->AddDependency(DINSD_PR1);
	u342->AddDependency(DINSD_CONC);
	u342->AddDependency(SATW_TO_SW_UPFLOW);
	u342->AddDependency(FROM_PS_DINSD);
	u342->AddDependency(DOM_TO_DINSD);
	u342->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u343 = (TExecuteCommand*) DINSD_UPTAKE.GetCommand("u343",TCommand::kUpdate,TCommand::kCode);
	u343->SetExecutable(&DINSD_UPTAKE_u343_exe_g);
	u343->Code() = "u343 <- SL::Min(SL::Max(((float)0), ( ( DIN_SD/dT() )-DINSD_PR2 )), DINSD_AVAIL, ( ( ( PHBIO_NPP*P1_PHBIO_NC )*P1_DIN_K_OF_NH4 )*((float)1000) ))";
	if( DIN_SD.GetF(FisClamped) ) { u343->AddDependency(DIN_SD); }
	u343->AddDependency(DIN_SD);
	u343->AddDependency(DINSD_PR2);
	u343->AddDependency(DINSD_AVAIL);
	u343->AddDependency(PHBIO_NPP);
	u343->AddDependency(HABITATMAP);
	u343->AddDependency(P1_PHBIO_NC);
	u343->AddDependency(P1_DIN_K_OF_NH4);
	u343->AddDependency(DIN_DNFLOW);
	u343->AddDependency(FROM_PS_DINSD);
	u343->AddDependency(DOM_TO_DINSD);
	u343->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u344 = (TExecuteCommand*) DINSD_HOUT.GetCommand("u344",TCommand::kUpdate,TCommand::kCode);
	u344->SetExecutable(&DINSD_HOUT_u344_exe_g);
	u344->Code() = "u344 <- ( P1_DINSD_OUT*SL::Min(SL::Max(((float)0), ( ( DIN_SD/dT() )-DINSD_PR3 )),  ( ( ( UW_DEPTH <= P1_R_SUB ) ) ? ( ( ( ( ( DIN_SD*( ( ( ( ((float)2)*ELEVATION )-P1_R_SUB )-UW_DEPTH )-SATW_OUTFLUX ) )*SATW_OUTFLUX )/( ELEVATION-P1_R_SUB ) )/( ELEVATION-UW_DEPTH ) ) ) : ( ( ( ( ( DIN_SD*( ( ( ((float)2)*ELEVATION )-( ((float)2)*UW_DEPTH ) )-SATW_OUTFLUX ) )*SATW_OUTFLUX )/( ( ELEVATION+UW_DEPTH )-( ((float)2)*P1_R_SUB ) ) )/( ELEVATION-UW_DEPTH ) ) ) ) ) )";
	if( DIN_SD.GetF(FisClamped) ) { u344->AddDependency(DIN_SD); }
	u344->AddDependency(P1_DINSD_OUT);
	u344->AddDependency(DIN_SD);
	u344->AddDependency(DINSD_PR3);
	u344->AddDependency(UW_DEPTH);
	u344->AddDependency(P1_R_SUB);
	u344->AddDependency(ELEVATION);
	u344->AddDependency(SATW_OUTFLUX);
	u344->AddDependency(DIN_DNFLOW);
	u344->AddDependency(FROM_PS_DINSD);
	u344->AddDependency(DOM_TO_DINSD);
	u344->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u347 = (TExecuteCommand*) FROM_ATMOS.GetCommand("u347",TCommand::kUpdate,TCommand::kCode);
	u347->SetExecutable(&FROM_ATMOS_u347_exe_g);
	u347->Code() = "u347 <- ( DIN_IN_RAIN*P1_ATMOS_FACTOR )";
	u347->AddDependency(DIN_IN_RAIN);
	u347->AddDependency(P1_ATMOS_FACTOR);
	u347->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u348 = (TExecuteCommand*) DOM_TO_DINSF.GetCommand("u348",TCommand::kUpdate,TCommand::kCode);
	u348->SetExecutable(&DOM_TO_DINSF_u348_exe_g);
	u348->Code() = "u348 <- ( DOM_TO_DIN*P1_DIN_GRAD )";
	u348->AddDependency(DOM_TO_DIN);
	u348->AddDependency(P1_DIN_GRAD);
	u348->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u349 = (TExecuteCommand*) FERT_AV.GetCommand("u349",TCommand::kUpdate,TCommand::kCode);
	u349->SetExecutable(&FERT_AV_u349_exe_g);
	u349->Code() = "u349 <- ( P1_DIN_FERT_DIS*FERTILIZER )";
	if( FERTILIZER.GetF(FisClamped) ) { u349->AddDependency(FERTILIZER); }
	u349->AddDependency(P1_DIN_FERT_DIS);
	u349->AddDependency(FERTILIZER);
	u349->AddDependency(FROM_FERT);
	u349->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u350 = (TExecuteCommand*) FROM_PS.GetCommand("u350",TCommand::kUpdate,TCommand::kCode);
	u350->SetExecutable(&FROM_PS_u350_exe_g);
	u350->Code() = "u350 <- ( ( P1_POINTNSF*P1_PS_FACTOR )/CELL_SIZE )";
	u350->AddDependency(P1_POINTNSF);
	u350->AddDependency(P1_PS_FACTOR);
	u350->AddDependency(CELL_SIZE);
	u350->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u351 = (TExecuteCommand*) DINSF_UPTAKE.GetCommand("u351",TCommand::kUpdate,TCommand::kCode);
	u351->SetExecutable(&DINSF_UPTAKE_u351_exe_g);
	u351->Code() = "u351 <- SL::Min(SL::Max(((float)0), ( ( DIN_SF/dT() )-DINSF_PR1 )), DINSF_AVAIL, ( ( ( PHBIO_NPP*P1_PHBIO_NC_SF )*P1_DIN_K_OF_NH4 )*((float)1000) ))";
	if( DIN_SF.GetF(FisClamped) ) { u351->AddDependency(DIN_SF); }
	u351->AddDependency(DIN_SF);
	u351->AddDependency(DINSF_PR1);
	u351->AddDependency(DINSF_AVAIL);
	u351->AddDependency(PHBIO_NPP);
	u351->AddDependency(HABITATMAP);
	u351->AddDependency(P1_PHBIO_NC_SF);
	u351->AddDependency(P1_DIN_K_OF_NH4);
	u351->AddDependency(DIN_UPFLOW);
	u351->AddDependency(FROM_ATMOS);
	u351->AddDependency(DOM_TO_DINSF);
	u351->AddDependency(FERT_AV);
	u351->AddDependency(FROM_PS);
	u351->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u352 = (TExecuteCommand*) DINSF_OUT.GetCommand("u352",TCommand::kUpdate,TCommand::kCode);
	u352->SetExecutable(&DINSF_OUT_u352_exe_g);
	u352->Code() = "u352 <- SL::Min(SL::Max(((float)0), ( ( DIN_SF/dT() )-DINSF_PR2 )), ( ( P1_DINSF_OUT*DINSF_CONC )*SW_OUTFLUX ))";
	if( DIN_SF.GetF(FisClamped) ) { u352->AddDependency(DIN_SF); }
	u352->AddDependency(DIN_SF);
	u352->AddDependency(DINSF_PR2);
	u352->AddDependency(P1_DINSF_OUT);
	u352->AddDependency(DINSF_CONC);
	u352->AddDependency(SW_OUTFLUX);
	u352->AddDependency(DIN_UPFLOW);
	u352->AddDependency(FROM_ATMOS);
	u352->AddDependency(DOM_TO_DINSF);
	u352->AddDependency(FERT_AV);
	u352->AddDependency(FROM_PS);
	u352->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I353 = (TExecuteCommand*) FERTILIZER.GetCommand("I353",TCommand::kIntegrate,TCommand::kCode);
	I353->SetExecutable(&FERTILIZER_I353_exe_g);
	I353->Code() = "I353 <- ( FROM_FERT-FERT_AV )";
	I353->AddDependency(FROM_FERT);
	I353->AddDependency(FERT_AV);
	I353->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i354 = (TExecuteCommand*) FERTILIZER.GetCommand("i354",TCommand::kInit,TCommand::kCode);
	i354->SetExecutable(&FERTILIZER_i354_exe_g);
	i354->Code() = "i354 <- ((float)0)";
	i354->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u355 = (TExecuteCommand*) FROM_FERT.GetCommand("u355",TCommand::kUpdate,TCommand::kCode);
	u355->SetExecutable(&FROM_FERT_u355_exe_g);
	u355->Code() = "u355 <-  ( ( ( DAYJUL == P1_DIN_DAY_FERT1 ) ) ? ( ( ( P1_DIN_FERT_APP*P1_DIN_FERT_HAB1 )*0.1 ) ) : (  ( ( ( DAYJUL == P1_DIN_DAY_FERT2 ) ) ? ( ( ( P1_DIN_FERT_APP*P1_DIN_FERT_HAB2 )*0.1 ) ) : ( ((float)0) ) )  ) ) ";
	u355->AddDependency(DAYJUL);
	u355->AddDependency(HABITATMAP);
	u355->AddDependency(P1_DIN_DAY_FERT1);
	u355->AddDependency(P1_DIN_FERT_APP);
	u355->AddDependency(P1_DIN_FERT_HAB1);
	u355->AddDependency(P1_DIN_DAY_FERT2);
	u355->AddDependency(P1_DIN_FERT_HAB2);
	u355->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I356 = (TExecuteCommand*) F_IN.GetCommand("I356",TCommand::kIntegrate,TCommand::kCode);
	I356->SetExecutable(&F_IN_I356_exe_g);
	I356->Code() = "I356 <- FERT_FLOW";
	I356->AddDependency(FERT_FLOW);
	I356->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i357 = (TExecuteCommand*) F_IN.GetCommand("i357",TCommand::kInit,TCommand::kCode);
	i357->SetExecutable(&F_IN_i357_exe_g);
	i357->Code() = "i357 <- ((float)0)";
	i357->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u358 = (TExecuteCommand*) FERT_FLOW.GetCommand("u358",TCommand::kUpdate,TCommand::kCode);
	u358->SetExecutable(&FERT_FLOW_u358_exe_g);
	u358->Code() = "u358 <- ( FROM_FERT*((float)10) )";
	u358->AddDependency(FROM_FERT);
	u358->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I359 = (TExecuteCommand*) M_IN.GetCommand("I359",TCommand::kIntegrate,TCommand::kCode);
	I359->SetExecutable(&M_IN_I359_exe_g);
	I359->Code() = "I359 <- MINER_FLOW";
	I359->AddDependency(MINER_FLOW);
	I359->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i360 = (TExecuteCommand*) M_IN.GetCommand("i360",TCommand::kInit,TCommand::kCode);
	i360->SetExecutable(&M_IN_i360_exe_g);
	i360->Code() = "i360 <- ((float)0)";
	i360->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u361 = (TExecuteCommand*) MINER_FLOW.GetCommand("u361",TCommand::kUpdate,TCommand::kCode);
	u361->SetExecutable(&MINER_FLOW_u361_exe_g);
	u361->Code() = "u361 <- ( ( DOM_TO_DINSD+DOM_TO_DINSF )*((float)10) )";
	u361->AddDependency(DOM_TO_DINSD);
	u361->AddDependency(DOM_TO_DINSF);
	u361->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I362 = (TExecuteCommand*) S_IN.GetCommand("I362",TCommand::kIntegrate,TCommand::kCode);
	I362->SetExecutable(&S_IN_I362_exe_g);
	I362->Code() = "I362 <- SEPTIC_FLOW";
	I362->AddDependency(SEPTIC_FLOW);
	I362->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i363 = (TExecuteCommand*) S_IN.GetCommand("i363",TCommand::kInit,TCommand::kCode);
	i363->SetExecutable(&S_IN_i363_exe_g);
	i363->Code() = "i363 <- ((float)0)";
	i363->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u364 = (TExecuteCommand*) SEPTIC_FLOW.GetCommand("u364",TCommand::kUpdate,TCommand::kCode);
	u364->SetExecutable(&SEPTIC_FLOW_u364_exe_g);
	u364->Code() = "u364 <- ( FROM_PS_DINSD*((float)10) )";
	u364->AddDependency(FROM_PS_DINSD);
	u364->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u365 = (TExecuteCommand*) COUNTY.GetCommand("u365",TCommand::kUpdate,TCommand::kCode);
	u365->SetExecutable(&COUNTY_u365_exe_g);
	u365->Code() = "u365 <- ( ((float)1)+( ((float)0)*HABITATMAP ) )";
	u365->AddDependency(HABITATMAP);
	u365->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u366 = (TExecuteCommand*) CROP.GetCommand("u366",TCommand::kUpdate,TCommand::kCode);
	u366->SetExecutable(&CROP_u366_exe_g);
	u366->Code() = "u366 <- ( ((float)1)+( ((float)0)*HABITATMAP ) )";
	u366->AddDependency(HABITATMAP);
	u366->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u367 = (TExecuteCommand*) DINSD_AVAIL.GetCommand("u367",TCommand::kUpdate,TCommand::kCode);
	u367->SetExecutable(&DINSD_AVAIL_u367_exe_g);
	u367->Code() = "u367 <-  ( ( ( ROOT_DEPTH <= P1_R_SUB ) ) ? ( ((float)0) ) : ( ( DIN_SD* ( ( ( ( ROOT_DEPTH >  P1_R_SUB ) && ( P1_R_SUB >= UW_DEPTH ) ) ) ? ( ( ( ( ( ( ( ((float)2)*ELEVATION )-UW_DEPTH )-ROOT_DEPTH )*( ROOT_DEPTH-P1_R_SUB ) )/( ELEVATION-ROOT_DEPTH ) )/( ELEVATION-UW_DEPTH ) ) ) : (  ( ( ( ( P1_R_SUB <= ROOT_DEPTH ) && ( ROOT_DEPTH <  UW_DEPTH ) ) ) ? ( ( ( ((float)2)*( ROOT_DEPTH-P1_R_SUB ) )/( ELEVATION-P1_R_SUB ) ) ) : ( ( ( ( ((float)2)*( UW_DEPTH-P1_R_SUB ) )+( ( ( ( ( ((float)2)*ELEVATION )-UW_DEPTH )-ROOT_DEPTH )*( ROOT_DEPTH-UW_DEPTH ) )/( ELEVATION-UW_DEPTH ) ) )/( ( ELEVATION+UW_DEPTH )-( ((float)2)*P1_R_SUB ) ) ) ) )  ) )  ) ) ) ";
	u367->AddDependency(ROOT_DEPTH);
	u367->AddDependency(P1_R_SUB);
	u367->AddDependency(DIN_SD);
	u367->AddDependency(UW_DEPTH);
	u367->AddDependency(ELEVATION);
	u367->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u368 = (TExecuteCommand*) DINSD_CONC.GetCommand("u368",TCommand::kUpdate,TCommand::kCode);
	u368->SetExecutable(&DINSD_CONC_u368_exe_g);
	u368->Code() = "u368 <- ( DIN_SD/( SAT_WATER+UNSAT_WATER ) )";
	u368->AddDependency(DIN_SD);
	u368->AddDependency(SAT_WATER);
	u368->AddDependency(UNSAT_WATER);
	u368->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u369 = (TExecuteCommand*) DINSD_PR1.GetCommand("u369",TCommand::kUpdate,TCommand::kCode);
	u369->SetExecutable(&DINSD_PR1_u369_exe_g);
	u369->Code() = "u369 <- DINSD_DENIT";
	u369->AddDependency(DINSD_DENIT);
	u369->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u370 = (TExecuteCommand*) DINSD_PR2.GetCommand("u370",TCommand::kUpdate,TCommand::kCode);
	u370->SetExecutable(&DINSD_PR2_u370_exe_g);
	u370->Code() = "u370 <- ( DIN_UPFLOW+DINSD_PR1 )";
	u370->AddDependency(DIN_UPFLOW);
	u370->AddDependency(DINSD_PR1);
	u370->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u371 = (TExecuteCommand*) DINSD_PR3.GetCommand("u371",TCommand::kUpdate,TCommand::kCode);
	u371->SetExecutable(&DINSD_PR3_u371_exe_g);
	u371->Code() = "u371 <- ( DINSD_UPTAKE+DINSD_PR2 )";
	u371->AddDependency(DINSD_UPTAKE);
	u371->AddDependency(DINSD_PR2);
	u371->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u372 = (TExecuteCommand*) DINSF_AVAIL.GetCommand("u372",TCommand::kUpdate,TCommand::kCode);
	u372->SetExecutable(&DINSF_AVAIL_u372_exe_g);
	u372->Code() = "u372 <-  ( ( ( SURFACE_WATER >  ((float)0) ) ) ? ( ( DINSF_CONC*( SURFACE_WATER+SR_WATER ) ) ) : ( ( ( DINSF_CONC*( ((float)1)-P1_DIN_DIFFCOEF ) )*SR_WATER ) ) ) ";
	u372->AddDependency(SURFACE_WATER);
	u372->AddDependency(DINSF_CONC);
	u372->AddDependency(SR_WATER);
	u372->AddDependency(P1_DIN_DIFFCOEF);
	u372->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u373 = (TExecuteCommand*) DINSF_CONC.GetCommand("u373",TCommand::kUpdate,TCommand::kCode);
	u373->SetExecutable(&DINSF_CONC_u373_exe_g);
	u373->Code() = "u373 <-  ( ( ( ( SURFACE_WATER+SR_WATER ) >  0.0 ) ) ? ( ( DIN_SF/( SURFACE_WATER+SR_WATER ) ) ) : ( ((float)0) ) ) ";
	u373->AddDependency(SURFACE_WATER);
	u373->AddDependency(SR_WATER);
	u373->AddDependency(DIN_SF);
	u373->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u374 = (TExecuteCommand*) DINSF_PR1.GetCommand("u374",TCommand::kUpdate,TCommand::kCode);
	u374->SetExecutable(&DINSF_PR1_u374_exe_g);
	u374->Code() = "u374 <- DIN_DNFLOW";
	u374->AddDependency(DIN_DNFLOW);
	u374->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u375 = (TExecuteCommand*) DINSF_PR2.GetCommand("u375",TCommand::kUpdate,TCommand::kCode);
	u375->SetExecutable(&DINSF_PR2_u375_exe_g);
	u375->Code() = "u375 <- ( DINSF_PR1+DINSF_UPTAKE )";
	u375->AddDependency(DINSF_PR1);
	u375->AddDependency(DINSF_UPTAKE);
	u375->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u377 = (TExecuteCommand*) DOM_TO_DIN.GetCommand("u377",TCommand::kUpdate,TCommand::kCode);
	u377->SetExecutable(&DOM_TO_DIN_u377_exe_g);
	u377->Code() = "u377 <- ( ( ( ( D_DECOMP*P1_DOM_NC )*P1_DOM_CTOOM )*P1_DIN_CR_SED_MIN )*((float)1000) )";
	u377->AddDependency(D_DECOMP);
	u377->AddDependency(HABITATMAP);
	u377->AddDependency(P1_DOM_NC);
	u377->AddDependency(P1_DOM_CTOOM);
	u377->AddDependency(P1_DIN_CR_SED_MIN);
	u377->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u378 = (TExecuteCommand*) N_NPOINTSD.GetCommand("u378",TCommand::kUpdate,TCommand::kCode);
	u378->SetExecutable(&N_NPOINTSD_u378_exe_g);
	u378->Code() = "u378 <-  ( ( ( P1_SEWERMAP == ((float)3) ) ) ? ( ((float)0) ) : ( ( ( P1_SEPTICLOAD*P1_POP_DENS )*P1_SEPTIC_RED ) ) ) ";
	u378->AddDependency(P1_SEWERMAP);
	u378->AddDependency(P1_SEPTICLOAD);
	u378->AddDependency(P1_POP_DENS);
	u378->AddDependency(P1_SEPTIC_RED);
	u378->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u379 = (TExecuteCommand*) OUTPUTCOL.GetCommand("u379",TCommand::kUpdate,TCommand::kCode);
	u379->SetExecutable(&OUTPUTCOL_u379_exe_g);
	u379->Code() = "u379 <- 40";
	u379->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u380 = (TExecuteCommand*) OUTPUTROW.GetCommand("u380",TCommand::kUpdate,TCommand::kCode);
	u380->SetExecutable(&OUTPUTROW_u380_exe_g);
	u380->Code() = "u380 <- 35";
	u380->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u381 = (TExecuteCommand*) OUTPUTVAR.GetCommand("u381",TCommand::kUpdate,TCommand::kCode);
	u381->SetExecutable(&OUTPUTVAR_u381_exe_g);
	u381->Code() = "u381 <- ( HABITATMAP*((float)0) )";
	u381->AddDependency(HABITATMAP);
	u381->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* v441 = (TExecuteCommand*) OUTPUTVAR.GetCommand("v441",TCommand::kFunction,TCommand::kCode);
	v441->SetExecutable(&OUTPUTVAR_v441_exe_g);
	v441->Code() = "v441 <- Function";
	v441->GetFunction() = 'P';
	v441->AddDependency(OUTPUTVAR);
	v441->AddDependency(HABITATMAP);
	v441->AddDependency(HABITATMAPDB);
	v441->AddDependency(YIELD);
	v441->AddDependency(P1_DIN_FERT_APP);
	v441->AddDependency(OUT_F_SF);
	v441->AddDependency(TOT_NPP);
	v441->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u382 = (TExecuteCommand*) SR_WATER.GetCommand("u382",TCommand::kUpdate,TCommand::kCode);
	u382->SetExecutable(&SR_WATER_u382_exe_g);
	u382->Code() = "u382 <-  ( ( ( P1_R_SUB <  UW_DEPTH ) ) ? ( ( ( UNSAT_WATER*P1_R_SUB )/UW_DEPTH ) ) : ( ( UNSAT_WATER+( ( ( P1_R_SUB-UW_DEPTH )/( ELEVATION-UW_DEPTH ) )*SAT_WATER ) ) ) ) ";
	u382->AddDependency(P1_R_SUB);
	u382->AddDependency(UW_DEPTH);
	u382->AddDependency(UNSAT_WATER);
	u382->AddDependency(ELEVATION);
	u382->AddDependency(SAT_WATER);
	u382->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u383 = (TExecuteCommand*) ZONMAP.GetCommand("u383",TCommand::kUpdate,TCommand::kCode);
	u383->SetExecutable(&ZONMAP_u383_exe_g);
	u383->Code() = "u383 <- ( ((float)0)+( ((float)0)*HABITATMAP ) )";
	u383->AddDependency(HABITATMAP);
	u383->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u384 = (TExecuteCommand*) P1_ATMOS_FACTOR.GetCommand("u384",TCommand::kUpdate,TCommand::kCode);
	u384->SetExecutable(&P1_ATMOS_FACTOR_u384_exe_g);
	u384->Code() = "u384 <- 0.214";
	u384->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u385 = (TExecuteCommand*) P1_DINSD_OUT.GetCommand("u385",TCommand::kUpdate,TCommand::kCode);
	u385->SetExecutable(&P1_DINSD_OUT_u385_exe_g);
	u385->Code() = "u385 <- 0";
	u385->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u386 = (TExecuteCommand*) P1_DINSF_OUT.GetCommand("u386",TCommand::kUpdate,TCommand::kCode);
	u386->SetExecutable(&P1_DINSF_OUT_u386_exe_g);
	u386->Code() = "u386 <- 0";
	u386->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u387 = (TExecuteCommand*) P1_DIN_CR_SED_MIN.GetCommand("u387",TCommand::kUpdate,TCommand::kCode);
	u387->SetExecutable(&P1_DIN_CR_SED_MIN_u387_exe_g);
	u387->Code() = "u387 <- 0.2";
	u387->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u388 = (TExecuteCommand*) P1_DIN_DAY_FERT1.GetCommand("u388",TCommand::kUpdate,TCommand::kCode);
	u388->SetExecutable(&P1_DIN_DAY_FERT1_u388_exe_g);
	u388->Code() = "u388 <- ((float)191)";
	u388->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u389 = (TExecuteCommand*) P1_DIN_DAY_FERT2.GetCommand("u389",TCommand::kUpdate,TCommand::kCode);
	u389->SetExecutable(&P1_DIN_DAY_FERT2_u389_exe_g);
	u389->Code() = "u389 <- ((float)999)";
	u389->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u390 = (TExecuteCommand*) P1_DIN_DIFFCOEF.GetCommand("u390",TCommand::kUpdate,TCommand::kCode);
	u390->SetExecutable(&P1_DIN_DIFFCOEF_u390_exe_g);
	u390->Code() = "u390 <- 0.7";
	u390->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u391 = (TExecuteCommand*) P1_DIN_FERT_APP.GetCommand("u391",TCommand::kUpdate,TCommand::kCode);
	u391->SetExecutable(&P1_DIN_FERT_APP_u391_exe_g);
	u391->Code() = "u391 <- ((float)145)";
	u391->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* v442 = (TExecuteCommand*) P1_DIN_FERT_APP.GetCommand("v442",TCommand::kFunction,TCommand::kCode);
	v442->SetExecutable(&P1_DIN_FERT_APP_v442_exe_g);
	v442->Code() = "v442 <- Function";
	v442->GetFunction() = 'P';
	v442->AddDependency(P1_DIN_FERT_APP);
	v442->AddDependency(HABITATMAP);
	v442->AddDependency(SOIL);
	v442->AddDependency(COUNTY);
	v442->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u392 = (TExecuteCommand*) P1_DIN_FERT_DIS.GetCommand("u392",TCommand::kUpdate,TCommand::kCode);
	u392->SetExecutable(&P1_DIN_FERT_DIS_u392_exe_g);
	u392->Code() = "u392 <- 0.050000";
	u392->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u393 = (TExecuteCommand*) P1_DIN_FERT_HAB1.GetCommand("u393",TCommand::kUpdate,TCommand::kCode);
	u393->SetExecutable(&P1_DIN_FERT_HAB1_u393_exe_g);
	u393->Code() = "u393 <- 0.75";
	u393->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u394 = (TExecuteCommand*) P1_DIN_FERT_HAB2.GetCommand("u394",TCommand::kUpdate,TCommand::kCode);
	u394->SetExecutable(&P1_DIN_FERT_HAB2_u394_exe_g);
	u394->Code() = "u394 <- ((float)0)";
	u394->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u395 = (TExecuteCommand*) P1_DIN_GRAD.GetCommand("u395",TCommand::kUpdate,TCommand::kCode);
	u395->SetExecutable(&P1_DIN_GRAD_u395_exe_g);
	u395->Code() = "u395 <- 0.7";
	u395->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u396 = (TExecuteCommand*) P1_DIN_ICSED.GetCommand("u396",TCommand::kUpdate,TCommand::kCode);
	u396->SetExecutable(&P1_DIN_ICSED_u396_exe_g);
	u396->Code() = "u396 <- 0.15";
	u396->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u397 = (TExecuteCommand*) P1_DIN_ICSF.GetCommand("u397",TCommand::kUpdate,TCommand::kCode);
	u397->SetExecutable(&P1_DIN_ICSF_u397_exe_g);
	u397->Code() = "u397 <- 0.3";
	u397->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u398 = (TExecuteCommand*) P1_DIN_K_OF_NH4.GetCommand("u398",TCommand::kUpdate,TCommand::kCode);
	u398->SetExecutable(&P1_DIN_K_OF_NH4_u398_exe_g);
	u398->Code() = "u398 <- 0.5";
	u398->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u399 = (TExecuteCommand*) P1_DIN_RCDENIT.GetCommand("u399",TCommand::kUpdate,TCommand::kCode);
	u399->SetExecutable(&P1_DIN_RCDENIT_u399_exe_g);
	u399->Code() = "u399 <- 0.001";
	u399->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u400 = (TExecuteCommand*) P1_DOMSD_ANAEROB_Z.GetCommand("u400",TCommand::kUpdate,TCommand::kCode);
	u400->SetExecutable(&P1_DOMSD_ANAEROB_Z_u400_exe_g);
	u400->Code() = "u400 <- 1";
	u400->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u401 = (TExecuteCommand*) P1_DOM_CTOOM.GetCommand("u401",TCommand::kUpdate,TCommand::kCode);
	u401->SetExecutable(&P1_DOM_CTOOM_u401_exe_g);
	u401->Code() = "u401 <- 0.2";
	u401->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u402 = (TExecuteCommand*) P1_DOM_NC.GetCommand("u402",TCommand::kUpdate,TCommand::kCode);
	u402->SetExecutable(&P1_DOM_NC_u402_exe_g);
	u402->Code() = "u402 <- ((float)0)";
	u402->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u403 = (TExecuteCommand*) P1_PHBIO_NC.GetCommand("u403",TCommand::kUpdate,TCommand::kCode);
	u403->SetExecutable(&P1_PHBIO_NC_u403_exe_g);
	u403->Code() = "u403 <- 0.1";
	u403->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u404 = (TExecuteCommand*) P1_PHBIO_NC_SF.GetCommand("u404",TCommand::kUpdate,TCommand::kCode);
	u404->SetExecutable(&P1_PHBIO_NC_SF_u404_exe_g);
	u404->Code() = "u404 <- 0.01";
	u404->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u405 = (TExecuteCommand*) P1_POINTNSF.GetCommand("u405",TCommand::kUpdate,TCommand::kCode);
	u405->SetExecutable(&P1_POINTNSF_u405_exe_g);
	u405->Code() = "u405 <- 0";
	u405->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u406 = (TExecuteCommand*) P1_PS_FACTOR.GetCommand("u406",TCommand::kUpdate,TCommand::kCode);
	u406->SetExecutable(&P1_PS_FACTOR_u406_exe_g);
	u406->Code() = "u406 <- 454";
	u406->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u407 = (TExecuteCommand*) P1_R_SUB.GetCommand("u407",TCommand::kUpdate,TCommand::kCode);
	u407->SetExecutable(&P1_R_SUB_u407_exe_g);
	u407->Code() = "u407 <- 0.1";
	u407->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u408 = (TExecuteCommand*) P1_SEPTICLOAD.GetCommand("u408",TCommand::kUpdate,TCommand::kCode);
	u408->SetExecutable(&P1_SEPTICLOAD_u408_exe_g);
	u408->Code() = "u408 <- 0.0132";
	u408->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u409 = (TExecuteCommand*) P1_SEPTIC_RED.GetCommand("u409",TCommand::kUpdate,TCommand::kCode);
	u409->SetExecutable(&P1_SEPTIC_RED_u409_exe_g);
	u409->Code() = "u409 <- 0.8";
	u409->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u410 = (TExecuteCommand*) DIN_IN_RAIN.GetCommand("u410",TCommand::kUpdate,TCommand::kCode);
	u410->SetExecutable(&DIN_IN_RAIN_u410_exe_g);
	u410->Code() = "u410 <- Graph45(DAYJUL)";
	u410->AddDependency(DAYJUL);
	u410->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DIN_IN_RAIN_import = (TImportCommand*) DIN_IN_RAIN.GetCommand("DIN_IN_RAIN_import",TCommand::kUndefined,TCommand::kImport);
	DIN_IN_RAIN_import->Code() = "Import DIN_IN_RAIN from external";
	DIN_IN_RAIN_import->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int ZDIN_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int ZDIN_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int ZDIN_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int ZDIN_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class XXXIMPORTS0_module 
// ---------------------------------------------------------------------------
XXXIMPORTS0_module::XXXIMPORTS0_module(char* name) :
	TIME("TIME"),
	CELL_SIZE("CELL_SIZE"),
	DAYJUL("DAYJUL"),
	ELEVATION("ELEVATION"),
	HABITATMAP("HABITATMAP"),
	ROOT_DEPTH("ROOT_DEPTH"),
	P1_DATUM_TO_MSL("P1_DATUM_TO_MSL"),
	P1_DEPTH_MSL_MAP("P1_DEPTH_MSL_MAP"),
	P1_ELEV_MSL_MAP("P1_ELEV_MSL_MAP"),
	P1_POP_DENS("P1_POP_DENS"),
	P1_SEWERMAP("P1_SEWERMAP"),
	AIR_TEMP_C("AIR_TEMP_C"),
	D_DECOMP("D_DECOMP"),
	PHBIO_NPP("PHBIO_NPP"),
	PRECIP_M("PRECIP_M"),
	SATW_FROM_PRECIP("SATW_FROM_PRECIP"),
	SATW_OUTFLUX("SATW_OUTFLUX"),
	SATW_TO_SW_UPFLOW("SATW_TO_SW_UPFLOW"),
	SAT_WATER("SAT_WATER"),
	SURFACE_WATER("SURFACE_WATER"),
	SW_FROM_PRECIP("SW_FROM_PRECIP"),
	SW_OUTFLUX("SW_OUTFLUX"),
	SW_TO_SATW_DOWNFLOW("SW_TO_SATW_DOWNFLOW"),
	UNSAT_WATER("UNSAT_WATER"),
	UW_DEPTH("UW_DEPTH"),
	UW_FROM_PRECIP("UW_FROM_PRECIP"),
	TModule(name) {

}	
int XXXIMPORTS0_module::CELL_SIZE_u411_exe() {
	float value;

	switch( CELL_SIZE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CELL_SIZE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)40000);
			CELL_SIZE.Update( p, CELL_SIZE.ParameterValue(value,p) );
		}
		CELL_SIZE.GrabMemory();
		if( CELL_SIZE.GetF(FLinkEdges) ) { CELL_SIZE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)40000);
			CELL_SIZE.Update( CELL_SIZE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::DAYJUL_u412_exe() {
	float value;

	switch( DAYJUL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DAYJUL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SL::Mod(( TIME.Value()-dT() ), ((float)365))+((float)1) );
			DAYJUL.Update( p, value );
		}
		DAYJUL.GrabMemory();
		if( DAYJUL.GetF(FLinkEdges) ) { DAYJUL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SL::Mod(( TIME.Value()-dT() ), ((float)365))+((float)1) );
			DAYJUL.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::ELEVATION_u413_exe() {
	float value;

	switch( ELEVATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ELEVATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( P1_DEPTH_MSL_MAP.Value(p) >  ((float)0) ) ) ? ( ( P1_DATUM_TO_MSL.Value(p)-P1_DEPTH_MSL_MAP.Value(p) ) ) : ( ( P1_ELEV_MSL_MAP.Value(p)+P1_DATUM_TO_MSL.Value(p) ) ) ) ;
			ELEVATION.Update( p, value );
		}
		ELEVATION.GrabMemory();
		if( ELEVATION.GetF(FLinkEdges) ) { ELEVATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( P1_DEPTH_MSL_MAP.Value() >  ((float)0) ) ) ? ( ( P1_DATUM_TO_MSL.Value()-P1_DEPTH_MSL_MAP.Value() ) ) : ( ( P1_ELEV_MSL_MAP.Value()+P1_DATUM_TO_MSL.Value() ) ) ) ;
			ELEVATION.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::HABITATMAP_u414_exe() {
	float value;

	switch( HABITATMAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HABITATMAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)3);
			HABITATMAP.Update( p, HABITATMAP.ParameterValue(value,p) );
		}
		HABITATMAP.GrabMemory();
		if( HABITATMAP.GetF(FLinkEdges) ) { HABITATMAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)3);
			HABITATMAP.Update( HABITATMAP.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::ROOT_DEPTH_u415_exe() {
	float value;

	switch( ROOT_DEPTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ROOT_DEPTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.3;
			ROOT_DEPTH.Update( p, ROOT_DEPTH.ParameterValue(value,p) );
		}
		ROOT_DEPTH.GrabMemory();
		if( ROOT_DEPTH.GetF(FLinkEdges) ) { ROOT_DEPTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.3;
			ROOT_DEPTH.Update( ROOT_DEPTH.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::P1_DATUM_TO_MSL_u416_exe() {
	float value;

	switch( P1_DATUM_TO_MSL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DATUM_TO_MSL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)30);
			P1_DATUM_TO_MSL.Update( p, P1_DATUM_TO_MSL.ParameterValue(value,p) );
		}
		P1_DATUM_TO_MSL.GrabMemory();
		if( P1_DATUM_TO_MSL.GetF(FLinkEdges) ) { P1_DATUM_TO_MSL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)30);
			P1_DATUM_TO_MSL.Update( P1_DATUM_TO_MSL.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::P1_DEPTH_MSL_MAP_u417_exe() {
	float value;

	switch( P1_DEPTH_MSL_MAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DEPTH_MSL_MAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_DEPTH_MSL_MAP.Update( p, P1_DEPTH_MSL_MAP.ParameterValue(value,p) );
		}
		P1_DEPTH_MSL_MAP.GrabMemory();
		if( P1_DEPTH_MSL_MAP.GetF(FLinkEdges) ) { P1_DEPTH_MSL_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_DEPTH_MSL_MAP.Update( P1_DEPTH_MSL_MAP.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::P1_ELEV_MSL_MAP_u418_exe() {
	float value;

	switch( P1_ELEV_MSL_MAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_ELEV_MSL_MAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)30);
			P1_ELEV_MSL_MAP.Update( p, P1_ELEV_MSL_MAP.ParameterValue(value,p) );
		}
		P1_ELEV_MSL_MAP.GrabMemory();
		if( P1_ELEV_MSL_MAP.GetF(FLinkEdges) ) { P1_ELEV_MSL_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)30);
			P1_ELEV_MSL_MAP.Update( P1_ELEV_MSL_MAP.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::P1_POP_DENS_u419_exe() {
	float value;

	switch( P1_POP_DENS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_POP_DENS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)10);
			P1_POP_DENS.Update( p, P1_POP_DENS.ParameterValue(value,p) );
		}
		P1_POP_DENS.GrabMemory();
		if( P1_POP_DENS.GetF(FLinkEdges) ) { P1_POP_DENS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)10);
			P1_POP_DENS.Update( P1_POP_DENS.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::P1_SEWERMAP_u420_exe() {
	float value;

	switch( P1_SEWERMAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SEWERMAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			P1_SEWERMAP.Update( p, P1_SEWERMAP.ParameterValue(value,p) );
		}
		P1_SEWERMAP.GrabMemory();
		if( P1_SEWERMAP.GetF(FLinkEdges) ) { P1_SEWERMAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			P1_SEWERMAP.Update( P1_SEWERMAP.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::AIR_TEMP_C_u421_exe() {
	float value;

	switch( AIR_TEMP_C.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = AIR_TEMP_C.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph46(DAYJUL.Value(p));
			AIR_TEMP_C.Update( p, value );
		}
		AIR_TEMP_C.GrabMemory();
		if( AIR_TEMP_C.GetF(FLinkEdges) ) { AIR_TEMP_C.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph46(DAYJUL.Value());
			AIR_TEMP_C.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::D_DECOMP_u422_exe() {
	float value;

	switch( D_DECOMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = D_DECOMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph47(DAYJUL.Value(p));
			D_DECOMP.Update( p, value );
		}
		D_DECOMP.GrabMemory();
		if( D_DECOMP.GetF(FLinkEdges) ) { D_DECOMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph47(DAYJUL.Value());
			D_DECOMP.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::PHBIO_NPP_u423_exe() {
	float value;

	switch( PHBIO_NPP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_NPP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph48(DAYJUL.Value(p));
			PHBIO_NPP.Update( p, value );
		}
		PHBIO_NPP.GrabMemory();
		if( PHBIO_NPP.GetF(FLinkEdges) ) { PHBIO_NPP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph48(DAYJUL.Value());
			PHBIO_NPP.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::PRECIP_M_u424_exe() {
	float value;

	switch( PRECIP_M.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PRECIP_M.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph49(DAYJUL.Value(p));
			PRECIP_M.Update( p, value );
		}
		PRECIP_M.GrabMemory();
		if( PRECIP_M.GetF(FLinkEdges) ) { PRECIP_M.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph49(DAYJUL.Value());
			PRECIP_M.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::SATW_FROM_PRECIP_u425_exe() {
	float value;

	switch( SATW_FROM_PRECIP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_FROM_PRECIP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph50(DAYJUL.Value(p));
			SATW_FROM_PRECIP.Update( p, value );
		}
		SATW_FROM_PRECIP.GrabMemory();
		if( SATW_FROM_PRECIP.GetF(FLinkEdges) ) { SATW_FROM_PRECIP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph50(DAYJUL.Value());
			SATW_FROM_PRECIP.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::SATW_OUTFLUX_u426_exe() {
	float value;

	switch( SATW_OUTFLUX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_OUTFLUX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph51(DAYJUL.Value(p));
			SATW_OUTFLUX.Update( p, value );
		}
		SATW_OUTFLUX.GrabMemory();
		if( SATW_OUTFLUX.GetF(FLinkEdges) ) { SATW_OUTFLUX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph51(DAYJUL.Value());
			SATW_OUTFLUX.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::SATW_TO_SW_UPFLOW_u427_exe() {
	float value;

	switch( SATW_TO_SW_UPFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_TO_SW_UPFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph52(DAYJUL.Value(p));
			SATW_TO_SW_UPFLOW.Update( p, value );
		}
		SATW_TO_SW_UPFLOW.GrabMemory();
		if( SATW_TO_SW_UPFLOW.GetF(FLinkEdges) ) { SATW_TO_SW_UPFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph52(DAYJUL.Value());
			SATW_TO_SW_UPFLOW.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::SAT_WATER_u428_exe() {
	float value;

	switch( SAT_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SAT_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph53(DAYJUL.Value(p));
			SAT_WATER.Update( p, value );
		}
		SAT_WATER.GrabMemory();
		if( SAT_WATER.GetF(FLinkEdges) ) { SAT_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph53(DAYJUL.Value());
			SAT_WATER.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::SURFACE_WATER_u429_exe() {
	float value;

	switch( SURFACE_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SURFACE_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph54(DAYJUL.Value(p));
			SURFACE_WATER.Update( p, value );
		}
		SURFACE_WATER.GrabMemory();
		if( SURFACE_WATER.GetF(FLinkEdges) ) { SURFACE_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph54(DAYJUL.Value());
			SURFACE_WATER.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::SW_FROM_PRECIP_u430_exe() {
	float value;

	switch( SW_FROM_PRECIP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_FROM_PRECIP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph55(DAYJUL.Value(p));
			SW_FROM_PRECIP.Update( p, value );
		}
		SW_FROM_PRECIP.GrabMemory();
		if( SW_FROM_PRECIP.GetF(FLinkEdges) ) { SW_FROM_PRECIP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph55(DAYJUL.Value());
			SW_FROM_PRECIP.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::SW_OUTFLUX_u431_exe() {
	float value;

	switch( SW_OUTFLUX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_OUTFLUX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph56(DAYJUL.Value(p));
			SW_OUTFLUX.Update( p, value );
		}
		SW_OUTFLUX.GrabMemory();
		if( SW_OUTFLUX.GetF(FLinkEdges) ) { SW_OUTFLUX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph56(DAYJUL.Value());
			SW_OUTFLUX.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::SW_TO_SATW_DOWNFLOW_u432_exe() {
	float value;

	switch( SW_TO_SATW_DOWNFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_TO_SATW_DOWNFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph57(DAYJUL.Value(p));
			SW_TO_SATW_DOWNFLOW.Update( p, value );
		}
		SW_TO_SATW_DOWNFLOW.GrabMemory();
		if( SW_TO_SATW_DOWNFLOW.GetF(FLinkEdges) ) { SW_TO_SATW_DOWNFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph57(DAYJUL.Value());
			SW_TO_SATW_DOWNFLOW.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::UNSAT_WATER_u433_exe() {
	float value;

	switch( UNSAT_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UNSAT_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph58(DAYJUL.Value(p));
			UNSAT_WATER.Update( p, value );
		}
		UNSAT_WATER.GrabMemory();
		if( UNSAT_WATER.GetF(FLinkEdges) ) { UNSAT_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph58(DAYJUL.Value());
			UNSAT_WATER.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::UW_DEPTH_u434_exe() {
	float value;

	switch( UW_DEPTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_DEPTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph59(DAYJUL.Value(p));
			UW_DEPTH.Update( p, value );
		}
		UW_DEPTH.GrabMemory();
		if( UW_DEPTH.GetF(FLinkEdges) ) { UW_DEPTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph59(DAYJUL.Value());
			UW_DEPTH.Update( value );
	  } break;
	}
	return 0;
}

int XXXIMPORTS0_module::UW_FROM_PRECIP_u435_exe() {
	float value;

	switch( UW_FROM_PRECIP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_FROM_PRECIP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph60(DAYJUL.Value(p));
			UW_FROM_PRECIP.Update( p, value );
		}
		UW_FROM_PRECIP.GrabMemory();
		if( UW_FROM_PRECIP.GetF(FLinkEdges) ) { UW_FROM_PRECIP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph60(DAYJUL.Value());
			UW_FROM_PRECIP.Update( value );
	  } break;
	}
	return 0;
}

XXXIMPORTS0_module* XXXIMPORTS0_module::fInstance = NULL;
XXXIMPORTS0_module* XXXIMPORTS0_module::kNullModel = (XXXIMPORTS0_module*)0x1;
int XXXIMPORTS0_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int XXXIMPORTS0_module::InitVars() {
	
	TIME.SSInit(this);
	CELL_SIZE.SSInit(this);
	DAYJUL.SSInit(this);
	ELEVATION.SSInit(this);
	HABITATMAP.SSInit(this);
	ROOT_DEPTH.SSInit(this);
	P1_DATUM_TO_MSL.SSInit(this);
	P1_DEPTH_MSL_MAP.SSInit(this);
	P1_ELEV_MSL_MAP.SSInit(this);
	P1_POP_DENS.SSInit(this);
	P1_SEWERMAP.SSInit(this);
	AIR_TEMP_C.SSInit(this);
	D_DECOMP.SSInit(this);
	PHBIO_NPP.SSInit(this);
	PRECIP_M.SSInit(this);
	SATW_FROM_PRECIP.SSInit(this);
	SATW_OUTFLUX.SSInit(this);
	SATW_TO_SW_UPFLOW.SSInit(this);
	SAT_WATER.SSInit(this);
	SURFACE_WATER.SSInit(this);
	SW_FROM_PRECIP.SSInit(this);
	SW_OUTFLUX.SSInit(this);
	SW_TO_SATW_DOWNFLOW.SSInit(this);
	UNSAT_WATER.SSInit(this);
	UW_DEPTH.SSInit(this);
	UW_FROM_PRECIP.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int XXXIMPORTS0_module::SetupEvents() {
	TExecuteCommand* u411 = (TExecuteCommand*) CELL_SIZE.GetCommand("u411",TCommand::kUpdate,TCommand::kCode);
	u411->SetExecutable(&CELL_SIZE_u411_exe_g);
	u411->Code() = "u411 <- ((float)40000)";
	u411->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u412 = (TExecuteCommand*) DAYJUL.GetCommand("u412",TCommand::kUpdate,TCommand::kCode);
	u412->SetExecutable(&DAYJUL_u412_exe_g);
	u412->Code() = "u412 <- ( SL::Mod(( TIME-dT() ), ((float)365))+((float)1) )";
	u412->AddDependency(TIME);
	u412->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u413 = (TExecuteCommand*) ELEVATION.GetCommand("u413",TCommand::kUpdate,TCommand::kCode);
	u413->SetExecutable(&ELEVATION_u413_exe_g);
	u413->Code() = "u413 <-  ( ( ( P1_DEPTH_MSL_MAP >  ((float)0) ) ) ? ( ( P1_DATUM_TO_MSL-P1_DEPTH_MSL_MAP ) ) : ( ( P1_ELEV_MSL_MAP+P1_DATUM_TO_MSL ) ) ) ";
	u413->AddDependency(P1_DEPTH_MSL_MAP);
	u413->AddDependency(P1_DATUM_TO_MSL);
	u413->AddDependency(P1_ELEV_MSL_MAP);
	u413->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u414 = (TExecuteCommand*) HABITATMAP.GetCommand("u414",TCommand::kUpdate,TCommand::kCode);
	u414->SetExecutable(&HABITATMAP_u414_exe_g);
	u414->Code() = "u414 <- ((float)3)";
	u414->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u415 = (TExecuteCommand*) ROOT_DEPTH.GetCommand("u415",TCommand::kUpdate,TCommand::kCode);
	u415->SetExecutable(&ROOT_DEPTH_u415_exe_g);
	u415->Code() = "u415 <- 0.3";
	u415->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u416 = (TExecuteCommand*) P1_DATUM_TO_MSL.GetCommand("u416",TCommand::kUpdate,TCommand::kCode);
	u416->SetExecutable(&P1_DATUM_TO_MSL_u416_exe_g);
	u416->Code() = "u416 <- ((float)30)";
	u416->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u417 = (TExecuteCommand*) P1_DEPTH_MSL_MAP.GetCommand("u417",TCommand::kUpdate,TCommand::kCode);
	u417->SetExecutable(&P1_DEPTH_MSL_MAP_u417_exe_g);
	u417->Code() = "u417 <- ((float)0)";
	u417->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u418 = (TExecuteCommand*) P1_ELEV_MSL_MAP.GetCommand("u418",TCommand::kUpdate,TCommand::kCode);
	u418->SetExecutable(&P1_ELEV_MSL_MAP_u418_exe_g);
	u418->Code() = "u418 <- ((float)30)";
	u418->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u419 = (TExecuteCommand*) P1_POP_DENS.GetCommand("u419",TCommand::kUpdate,TCommand::kCode);
	u419->SetExecutable(&P1_POP_DENS_u419_exe_g);
	u419->Code() = "u419 <- ((float)10)";
	u419->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u420 = (TExecuteCommand*) P1_SEWERMAP.GetCommand("u420",TCommand::kUpdate,TCommand::kCode);
	u420->SetExecutable(&P1_SEWERMAP_u420_exe_g);
	u420->Code() = "u420 <- ((float)1)";
	u420->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u421 = (TExecuteCommand*) AIR_TEMP_C.GetCommand("u421",TCommand::kUpdate,TCommand::kCode);
	u421->SetExecutable(&AIR_TEMP_C_u421_exe_g);
	u421->Code() = "u421 <- Graph46(DAYJUL)";
	u421->AddDependency(DAYJUL);
	u421->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u422 = (TExecuteCommand*) D_DECOMP.GetCommand("u422",TCommand::kUpdate,TCommand::kCode);
	u422->SetExecutable(&D_DECOMP_u422_exe_g);
	u422->Code() = "u422 <- Graph47(DAYJUL)";
	u422->AddDependency(DAYJUL);
	u422->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u423 = (TExecuteCommand*) PHBIO_NPP.GetCommand("u423",TCommand::kUpdate,TCommand::kCode);
	u423->SetExecutable(&PHBIO_NPP_u423_exe_g);
	u423->Code() = "u423 <- Graph48(DAYJUL)";
	u423->AddDependency(DAYJUL);
	u423->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u424 = (TExecuteCommand*) PRECIP_M.GetCommand("u424",TCommand::kUpdate,TCommand::kCode);
	u424->SetExecutable(&PRECIP_M_u424_exe_g);
	u424->Code() = "u424 <- Graph49(DAYJUL)";
	u424->AddDependency(DAYJUL);
	u424->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u425 = (TExecuteCommand*) SATW_FROM_PRECIP.GetCommand("u425",TCommand::kUpdate,TCommand::kCode);
	u425->SetExecutable(&SATW_FROM_PRECIP_u425_exe_g);
	u425->Code() = "u425 <- Graph50(DAYJUL)";
	u425->AddDependency(DAYJUL);
	u425->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u426 = (TExecuteCommand*) SATW_OUTFLUX.GetCommand("u426",TCommand::kUpdate,TCommand::kCode);
	u426->SetExecutable(&SATW_OUTFLUX_u426_exe_g);
	u426->Code() = "u426 <- Graph51(DAYJUL)";
	u426->AddDependency(DAYJUL);
	u426->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u427 = (TExecuteCommand*) SATW_TO_SW_UPFLOW.GetCommand("u427",TCommand::kUpdate,TCommand::kCode);
	u427->SetExecutable(&SATW_TO_SW_UPFLOW_u427_exe_g);
	u427->Code() = "u427 <- Graph52(DAYJUL)";
	u427->AddDependency(DAYJUL);
	u427->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u428 = (TExecuteCommand*) SAT_WATER.GetCommand("u428",TCommand::kUpdate,TCommand::kCode);
	u428->SetExecutable(&SAT_WATER_u428_exe_g);
	u428->Code() = "u428 <- Graph53(DAYJUL)";
	u428->AddDependency(DAYJUL);
	u428->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u429 = (TExecuteCommand*) SURFACE_WATER.GetCommand("u429",TCommand::kUpdate,TCommand::kCode);
	u429->SetExecutable(&SURFACE_WATER_u429_exe_g);
	u429->Code() = "u429 <- Graph54(DAYJUL)";
	u429->AddDependency(DAYJUL);
	u429->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u430 = (TExecuteCommand*) SW_FROM_PRECIP.GetCommand("u430",TCommand::kUpdate,TCommand::kCode);
	u430->SetExecutable(&SW_FROM_PRECIP_u430_exe_g);
	u430->Code() = "u430 <- Graph55(DAYJUL)";
	u430->AddDependency(DAYJUL);
	u430->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u431 = (TExecuteCommand*) SW_OUTFLUX.GetCommand("u431",TCommand::kUpdate,TCommand::kCode);
	u431->SetExecutable(&SW_OUTFLUX_u431_exe_g);
	u431->Code() = "u431 <- Graph56(DAYJUL)";
	u431->AddDependency(DAYJUL);
	u431->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u432 = (TExecuteCommand*) SW_TO_SATW_DOWNFLOW.GetCommand("u432",TCommand::kUpdate,TCommand::kCode);
	u432->SetExecutable(&SW_TO_SATW_DOWNFLOW_u432_exe_g);
	u432->Code() = "u432 <- Graph57(DAYJUL)";
	u432->AddDependency(DAYJUL);
	u432->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u433 = (TExecuteCommand*) UNSAT_WATER.GetCommand("u433",TCommand::kUpdate,TCommand::kCode);
	u433->SetExecutable(&UNSAT_WATER_u433_exe_g);
	u433->Code() = "u433 <- Graph58(DAYJUL)";
	u433->AddDependency(DAYJUL);
	u433->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u434 = (TExecuteCommand*) UW_DEPTH.GetCommand("u434",TCommand::kUpdate,TCommand::kCode);
	u434->SetExecutable(&UW_DEPTH_u434_exe_g);
	u434->Code() = "u434 <- Graph59(DAYJUL)";
	u434->AddDependency(DAYJUL);
	u434->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u435 = (TExecuteCommand*) UW_FROM_PRECIP.GetCommand("u435",TCommand::kUpdate,TCommand::kCode);
	u435->SetExecutable(&UW_FROM_PRECIP_u435_exe_g);
	u435->Code() = "u435 <- Graph60(DAYJUL)";
	u435->AddDependency(DAYJUL);
	u435->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int XXXIMPORTS0_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int XXXIMPORTS0_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int XXXIMPORTS0_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int XXXIMPORTS0_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}
