/*
 * file:    compare.c
 * project: LOSEEM Library for optimization of spatially explicit ecosystem models
 * author:  r.s.
 * date:    10/2001
 * aim:     multiscape comparison of grid maps using ArcView Ascii Map format
 */

#define MAX_HAB 10

#include "../smeopt/smeopt.h"
#include <math.h>
#include <stdio.h>

#undef AGGREGATE_TO_AGRICULTURE

int main(int argc, char *argv[])
{
  int i, nrows, ncols, nodata;   
  float xll, yll, cells;
  FILE *ofp, *pltfp;
  int hab0[MAX_ROWS][MAX_COLS];	/* In: Karte 1 */
  int hab1[MAX_ROWS][MAX_COLS];	/* In: Karte 2 */
  int hab2[MAX_ROWS][MAX_COLS];	/* In: Karte 2 */
  
  int max_w, min_w;			/* window size */
  float res_rho[MAX_MAP_SIZE][10];

  float rho[MAX_MAP_SIZE];
  float rho_0, rho_int, rho_inf, rho_min;
  int loop;
  int attr_list[4] = {6,7,8,9};

  printf("compare 1.0 - (c) r.s multiscale comparison of grid maps\n");
#ifdef AGGREGATE_TO_AGRICULTURE
  printf("note: aggregation to agricultural cells performed!\n");
#endif
  if (argc<2)
    {
      printf("\nusage compare.exe <map1> <map2> .... \n");
      printf("   map1 and map2 are filenames of ArcView ASCII-Grid maps\n");
      printf("Compares one ore more ArcView ASCII grid maps. \n");
      printf("First map is taken as reference map. \n");
      printf("All following maps are compare with it. \n");
      printf("(c) r.s. tu-bs.\n");
      exit(1);
    }

  read_arcinfo_int_grid(argv[1], &ncols, &nrows, &xll, &yll, &cells, 
			&nodata, hab0);        

  pltfp = fopen("compare.plt", "w");
  fprintf(pltfp, "set data style lines\nset grid\nplot ");

  for (loop=2; loop < argc; loop++)
    {
      fprintf(pltfp, "\"compare.dat\" using 1:%d title \"%s-%s\"",loop, argv[1], argv[loop]);

      read_arcinfo_int_grid(argv[loop], &ncols, &nrows, &xll, &yll, &cells, 
			    &nodata, hab1);        /*um 2. Karte einzulesen*/

      printf("compare %s, %s ...\n", argv[1], argv[loop]);

#ifdef AGGREGATE_TO_AGRICULTURE
      reclass_map(hab1, ncols, nrows, nodata, attr_list, 4, 3, hab2);
      map_distance(hab0, hab2, ncols, nrows, nodata, 
		   rho, &max_w, &rho_0, &rho_inf, &rho_int, &rho_min, &min_w,
		   1.0);
#endif
#ifndef AGGREGATE_TO_AGRICULTURE
      map_distance(hab0, hab1, ncols, nrows, nodata, 
		   rho, &max_w, &rho_0, &rho_inf, &rho_int, &rho_min, &min_w,
		   1.0);
#endif

      
      printf(" rho_0   = %7.3f\n rho_inf = %7.3f\n rho_int = %7.3f\n rho_min = %7.3f at w_min = %6d\n", 
	     rho_0, rho_inf, rho_int, rho_min, min_w);

      for (i=1; i<max_w; i++)
	res_rho[i][loop-2] = rho[i];

      if (loop+1<argc)
	fprintf(pltfp, ",\\\n");
      else
	fprintf(pltfp, "\n");
    }

  ofp = fopen("compare.dat", "w");
  for (i=1; i<max_w; i++)
    {
      fprintf(ofp, "%6d ", i);
      for (loop=2; loop<argc; loop++)
	fprintf(ofp, " %7.3f", res_rho[i][loop-2]);
      fprintf(ofp, "\n");
    }
  fclose(ofp);
  fprintf(pltfp, "pause -1 \" map distance functions\"\n");
  fclose(pltfp);

}


