/* 
 * file: gridopt2.c
 * author: r.s.
 * date: 8/2001
 * aim: more general land use patter optimization based on
 *  - leaching nutrien 
 *  - surface run-of of nutrients
 *  - net primary production
 *  - co2 - fixcation
 *  - agroeconomic yield
 *  - fertilizer input
 */

#include "../smeopt/smeopt.h"
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "hooke.h"


/* gnu-c on solaris does not like to hold 17MByte static in 
 * a local function (e.g. main())
 * so here are al function global again, sorry. */

FILE *lfp;
int fnc_call;

float co2w[MAX_LAYER][MAX_ROWS][MAX_COLS];
float co2c[MAX_LAYER][MAX_ROWS][MAX_COLS];
float co2s[MAX_LAYER][MAX_ROWS][MAX_COLS];
float co2fa[MAX_ROWS][MAX_COLS];
float co2fo[MAX_ROWS][MAX_COLS];

float nppw[MAX_LAYER][MAX_ROWS][MAX_COLS];
float nppc[MAX_LAYER][MAX_ROWS][MAX_COLS];
float npps[MAX_LAYER][MAX_ROWS][MAX_COLS];
float nppfa[MAX_ROWS][MAX_COLS];
float nppfo[MAX_ROWS][MAX_COLS];

float sdw[MAX_LAYER][MAX_ROWS][MAX_COLS];
float sdc[MAX_LAYER][MAX_ROWS][MAX_COLS];
float sds[MAX_LAYER][MAX_ROWS][MAX_COLS];
float sdfa[MAX_ROWS][MAX_COLS];
float sdfo[MAX_ROWS][MAX_COLS];

float sfw[MAX_LAYER][MAX_ROWS][MAX_COLS];
float sfc[MAX_LAYER][MAX_ROWS][MAX_COLS];
float sfs[MAX_LAYER][MAX_ROWS][MAX_COLS];
float sffa[MAX_ROWS][MAX_COLS];
float sffo[MAX_ROWS][MAX_COLS];

float yw[MAX_LAYER][MAX_ROWS][MAX_COLS];
float yc[MAX_LAYER][MAX_ROWS][MAX_COLS];
float ys[MAX_LAYER][MAX_ROWS][MAX_COLS];

float jmin_map[MAX_ROWS][MAX_COLS];
float jmax_map[MAX_ROWS][MAX_COLS];

int refmap[MAX_ROWS][MAX_COLS];

  
int hab[MAX_ROWS][MAX_COLS];
int nohab, ncols, nrows;
int no_habs, count_habs;
int nodata;

int it = 0;
float lambda[6];

/* arbitrary distribution of crops */

#define INIT_S   0.35
#define INIT_C   0.4
#define INIT_FA  0.05
#define INIT_W   0.2

/* Performance Creterion for hooke unconstrained optimization */
double f(x, n)
     double x[VARS];
     int n;
{
  int opthab[MAX_ROWS][MAX_COLS];
  int rcopthab[MAX_ROWS][MAX_COLS];
  float optfert[MAX_ROWS][MAX_COLS];
  float sum_fert;
  float rho_0, rho_inf, rho_int;
  float rho[MAX_MAP_SIZE];
  int max_w, i,j;		       
  int sum;
  float dist1;
  int nr_c, nr_w, nr_s, nr_fa, nr_fo;
  int attr_list[4] = {6,7,8,9};
  float e1, err;

  it++;

  lambda[2] = x[0];
  lambda[4] = x[1];
  lambda[5] = x[2];

  calculate_optimum_2(sfc, sfs, sfw, sffa, sffo, 
		      sdc, sds, sdw, sdfa, sdfo, 
		      co2c, co2s, co2w, co2fa, co2fo,
		      nppc, npps, nppw, nppfa, nppfo,
		      yc, ys, yw, 
		      hab, ncols, nrows, 6, nohab, lambda,
		      opthab, optfert, jmin_map, jmax_map, &count_habs,
		      &nr_c, &nr_s, &nr_w, &nr_fa, &nr_fo, &sum_fert);

  nr_c = 0; nr_s = 0; nr_w = 0; nr_fa = 0;
  for(i=0; i<nrows; i++)
    for (j=0; j<ncols; j++)
      switch (opthab[i][j])
	{
	case WHEAT : 
	  nr_w++;
	  break;
	case FALLOW : 
	  nr_fa++;
	  break;
	case CORN :
	  nr_c++;
	  break;
	case SOY :
	  nr_s++;
	  break;
	}
  sum = nr_c+nr_s+nr_w+nr_fa;
  dist1 = (fabs((double)nr_c - sum*INIT_C) 
	   + fabs((double)nr_s - sum*INIT_S) 
	   + fabs((double)nr_w - sum*INIT_W) 
	   + fabs((double)nr_fa - sum*INIT_FA))/sum;

  reclass_map(opthab, ncols, nrows, nohab, attr_list, 4, 3, rcopthab);

  map_distance(refmap, rcopthab, ncols, nrows, nodata, rho, &max_w, &rho_0, &rho_inf, &rho_int, 0.5);

  e1 = exp(-0.001*(double)it);
  err = e1*dist1 + (1.0-e1)*rho_int;

  printf("rho_0 = %8.6f rho_int = %8.6f rho_inf = %8.6f \n", 
	 rho_0, rho_int, rho_inf);
  printf("dist2 = %8.6f exp(it) = %8.6f err = %8.6f\n", dist1, e1,  err);

  /* write log-file */
  fprintf(lfp, "%8d", fnc_call++);
  for (i=0; i<6;i++)
    fprintf(lfp, " %8.4f", lambda[i]);
  fprintf(lfp, " %8.6f %8.6f %8.6f %8.6f %8.6f\n", rho_0, rho_int, rho_inf, dist1, err);
  fflush(lfp);

  return (double)(err);
}


int main(int argc, char *argv[])
{
  char in_map_dir[255];
  char out_map_dir[255];
  char par_dir[255];
  char data_dir[255];
  char arcview_map_dir[255];
  
  int i, j;
  float xll, yll, cells;
  char fn[255];

  double startpt[VARS], endpt[VARS];
  int nvars, itermax;
  double rho, epsilon;

  fnc_call =0;
  lfp = fopen("ess.log", "w");
  /* szenario auslesen und entsprechende Verzeichnisstring aufbauen */
  
  if (argc<9)
    {
      printf("usage gridopt2.exe <scenario> <run> <l_y> <l_f> <l_n1> <l_n2> <l_npp> <l_co2>\n");
      printf("with J = <l_y> * Y_US$(crop) + <l_f> * lambda_f * F - l_n1 * (SF + l_n2 * SD) + l_npp*NPP + l_co2*CO2\n");
      printf("recommendation: l_y, l_f from {0,1}\n");
      printf("defining l_x < 0 makes gridopt2 vary this weight for optimization.\n"); 
      exit(1);
    }
  
  in_map_dir[0] = '\0'; strcat(in_map_dir, IN_MAPS_PATH);
  out_map_dir[0] = '\0'; strcat(out_map_dir, OUT_MAPS_PATH);
  arcview_map_dir[0] = '\0'; strcat(arcview_map_dir, OUT_MAPS_PATH);
  par_dir[0] = '\0'; strcat(par_dir, PARAM_PATH);
  data_dir[0] = '\0'; strcat(data_dir, SME_DATA_PATH);
  
  strcat(in_map_dir, argv[1]); strcat(in_map_dir, argv[2]); strcat(in_map_dir, "/");
  strcat(data_dir, argv[1]); strcat(data_dir, argv[2]); strcat(data_dir, "/");
  strcat(out_map_dir, argv[1]); strcat(out_map_dir, argv[2]); strcat(out_map_dir, "/");

  printf("set up directory structure:\n");
  printf("map input:%s\nmap output:%s\nparameter:%s\ndata:%s\nArcVIEW:%s\n",
	 in_map_dir, out_map_dir, par_dir, data_dir, arcview_map_dir);

  /* Einlesen der Karten */

  read_arcinfo_int_grid("refmap.asc", &ncols, &nrows, &xll, &yll, &cells, &nohab, refmap);

  make_fn(fn, "habmapdb", in_map_dir);
  read_arcinfo_int_grid(fn, &ncols, &nrows, &xll, &yll, &cells, &nohab, hab);

  read_multilayer_float_map(in_map_dir, "nppc", 0.0001, nppc, 6);  
  correct_SME_multilayer_float_map(nppc, 0.0, ncols, nrows, 6, hab, nohab);
  read_multilayer_float_map(in_map_dir, "nppw", 0.0001, nppw, 6);  
  correct_SME_multilayer_float_map(nppw, 0.0, ncols, nrows, 6, hab, nohab);
  read_multilayer_float_map(in_map_dir, "npps", 0.0001, npps, 6);  
  correct_SME_multilayer_float_map(npps, 0.0, ncols, nrows, 6, hab, nohab);

  make_fn(fn, "nppfo0", in_map_dir);
  read_arcinfo_float_grid(fn, 0.0001, &ncols, &nrows, 
			  &xll, &yll, &cells, nppfo);
  correct_SME_float_map(nppfo, 0.0, ncols, nrows, hab, nohab);

  make_fn(fn, "nppfa0", in_map_dir);
  read_arcinfo_float_grid(fn, 0.0001, &ncols, &nrows, 
			  &xll, &yll, &cells, nppfa);
  correct_SME_float_map(nppfa, 0.0, ncols, nrows, hab, nohab);

  read_multilayer_float_map(in_map_dir, "co2c", 0.0001, co2c, 6);  
  correct_SME_multilayer_float_map(co2c, 0.0, ncols, nrows, 6, hab, nohab);
  read_multilayer_float_map(in_map_dir, "co2w", 0.0001, co2w, 6);  
  correct_SME_multilayer_float_map(co2w, 0.0, ncols, nrows, 6, hab, nohab);
  read_multilayer_float_map(in_map_dir, "co2s", 0.0001, co2s, 6);  
  correct_SME_multilayer_float_map(co2s, 0.0, ncols, nrows, 6, hab, nohab);

  make_fn(fn, "co2fo0", in_map_dir);
  read_arcinfo_float_grid(fn, 0.0001, &ncols, &nrows, 
			  &xll, &yll, &cells, co2fo);
  correct_SME_float_map(co2fo, 0.0, ncols, nrows, hab, nohab);

  make_fn(fn, "co2fa0", in_map_dir);
  read_arcinfo_float_grid(fn, 0.0001, &ncols, &nrows, 
			  &xll, &yll, &cells, co2fa);
  correct_SME_float_map(co2fa, 0.0, ncols, nrows, hab, nohab);

  read_multilayer_float_map(in_map_dir, "sdc", 0.0001, sdc, 6);  
  correct_SME_multilayer_float_map(sdc, 0.0, ncols, nrows, 6, hab, nohab);
  read_multilayer_float_map(in_map_dir, "sdw", 0.0001, sdw, 6);  
  correct_SME_multilayer_float_map(sdw, 0.0, ncols, nrows, 6, hab, nohab);
  read_multilayer_float_map(in_map_dir, "sds", 0.0001, sds, 6);  
  correct_SME_multilayer_float_map(sds, 0.0, ncols, nrows, 6, hab, nohab);

  make_fn(fn, "sdfo0", in_map_dir);
  read_arcinfo_float_grid(fn, 0.0001, &ncols, &nrows, 
			  &xll, &yll, &cells, sdfo);
  correct_SME_float_map(sdfo, 0.0, ncols, nrows, hab, nohab);

  make_fn(fn, "sdfa0", in_map_dir);
  read_arcinfo_float_grid(fn, 0.0001, &ncols, &nrows, 
			  &xll, &yll, &cells, sdfa);
  correct_SME_float_map(sdfa, 0.0, ncols, nrows, hab, nohab);

  read_multilayer_float_map(in_map_dir, "sfc", 0.0001, sfc, 6);  
  correct_SME_multilayer_float_map(sfc, 0.0, ncols, nrows, 6, hab, nohab);
  read_multilayer_float_map(in_map_dir, "sfw", 0.0001, sfw, 6);    
  correct_SME_multilayer_float_map(sfw, 0.0, ncols, nrows, 6, hab, nohab);
  read_multilayer_float_map(in_map_dir, "sfs", 0.0001, sfs, 6);  
  correct_SME_multilayer_float_map(sfs, 0.0, ncols, nrows, 6, hab, nohab);
  make_fn(fn, "sffo0", in_map_dir);
  read_arcinfo_float_grid(fn, 0.0001, &ncols, &nrows, 
			  &xll, &yll, &cells, sffo);
  correct_SME_float_map(sffo, 0.0, ncols, nrows, hab, nohab);
  make_fn(fn, "sffa0", in_map_dir);
  read_arcinfo_float_grid(fn, 0.0001, &ncols, &nrows, 
			  &xll, &yll, &cells, sffa);
  correct_SME_float_map(sffa, 0.0, ncols, nrows, hab, nohab);

  read_multilayer_float_map(in_map_dir, "yc", 0.0001, yc, 6);  
  correct_SME_multilayer_float_map(yc, 0.0, ncols, nrows, 6, hab, nohab);
  read_multilayer_float_map(in_map_dir, "ys", 0.0001, ys, 6);  
  correct_SME_multilayer_float_map(ys, 0.0, ncols, nrows, 6, hab, nohab);
  read_multilayer_float_map(in_map_dir, "yw", 0.0001, yw, 6);  
  correct_SME_multilayer_float_map(yw, 0.0, ncols, nrows, 6, hab, nohab);

  /* starting guess */
  for (i=3; i<9;i++)
    sscanf(argv[i], "%f", &lambda[i-3]);

  
  nvars = 3;
  startpt[0] = lambda[2];
  startpt[1] = lambda[4];
  startpt[2] = lambda[5];
  
  itermax = IMAX;
  rho = 0.1;
  epsilon = EPSMIN;

  j = hooke(nvars, startpt, endpt, rho, epsilon, itermax);

  printf("\n\n\nhooke used %d iterations, and returned\n", j);

  for (i = 0; i < nvars; i++)
    printf("x[%3d] = %15.7f \n", i, endpt[i]);
      
  return 0;		      
}





