/* uncmin.f -- translated by f2c (version 20000706).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Table of constant values */

static integer c__1 = 1;
static integer c__60 = 60;
static integer c_n1 = -1;
static integer c__0 = 0;
static integer c__4 = 4;
static doublereal c_b8 = .3333333333333333;
static integer c__62 = 62;
static integer c__51 = 51;
static integer c__47 = 47;
static integer c__68 = 68;
static real c_b58 = (float)1.;
static real c_b84 = (float)10.;
static integer c__3 = 3;

/* Subroutine */ int uncmin_(n, x0, fcn, x, f, info, w, lw)
integer *n;
real *x0;
/* Subroutine */ int (*fcn) ();
real *x, *f;
integer *info;
real *w;
integer *lw;
{
    /* System generated locals */
    integer i__1;
    doublereal d__1;

    /* Builtin functions */
    integer s_wsfi(), do_fio(), e_wsfi();
    double pow_dd(), sqrt();

    /* Local variables */
    static real epsm;
    static integer iexp;
    extern /* Subroutine */ int d1fcn_(), d2fcn_();
    static integer lwmin;
    extern doublereal r1mach_();
    static integer ia, ig, iagflg, iahflg, it;
    static real fscale;
    static integer nr, lt;
    static real gradtl;
    static integer ndigit, method, itnlim;
    static char errmsg[68];
    static real steptl;
    extern /* Subroutine */ int optdrv_();
    static real stepmx;
    static integer iw1, iw2, iw3, iw4, iw5, iw6, iw7, iw8;
    extern /* Subroutine */ int xerror_();
    static real dlt;
    static integer msg, ipr;

    /* Fortran I/O blocks */
    static icilist io___14 = { 0, errmsg, 0, "(                             \
                       'UNCMIN ERROR (INFO=-1) -- INSUFFICIENT WORKSPACE',  \
           ', LW = ', I5 )", 68, 1 };
    static icilist io___31 = { 0, errmsg, 0, "(                             \
                       'UNCMIN WARNING -- INFO = 1',                        \
           ': PROBABLY CONVERGED, GRADIENT SMALL')", 68, 1 };
    static icilist io___32 = { 0, errmsg, 0, "(                             \
                       'UNCMIN WARNING -- INFO = 2',                        \
           ': PROBABLY CONVERGED, STEPSIZE SMALL')", 68, 1 };
    static icilist io___33 = { 0, errmsg, 0, "(                             \
                       'UNCMIN WARNING -- INFO = 3',                        \
           ': CANNOT FIND LOWER POINT')", 68, 1 };
    static icilist io___34 = { 0, errmsg, 0, "(                             \
                       'UNCMIN WARNING -- INFO = 4',                        \
           ': TOO MANY ITERATIONS')", 68, 1 };
    static icilist io___35 = { 0, errmsg, 0, "(                             \
                       'UNCMIN WARNING -- INFO = 5',                        \
           ': TOO MANY LARGE STEPS, POSSIBLY UNBOUNDED')", 68, 1 };


/* ***BEGIN PROLOGUE  UNCMIN */
/* ***DATE WRITTEN   870923    (YYMMDD) */
/* ***REVISION DATE  871222    (YYMMDD) */
/* ***CATEGORY NO.  G1B1A1 */
/* ***KEYWORDS  UNCONSTRAINED MINIMIZATION */
/* ***AUTHOR  NASH, S.G., (GEORGE MASON UNIVERSITY) */
/* ***PURPOSE  UNCMIN minimizes a smooth nonlinear function of n variables. */
/*            A subroutine that computes the function value at any point */
/*            must be supplied, but derivative values are not required. */
/*            UNCMIN provides a simple interface to more flexible lower */
/*            level routines.  User has no control over options. */

/* ***DESCRIPTION */
/*     From the book, "Numerical Methods and Software" by */
/*                D. Kahaner, C. Moler, S. Nash */
/*                Prentice Hall, 1988 */

/*     This routine uses a quasi-Newton algorithm with line search */
/*     to minimize the function represented by the subroutine FCN. */
/*     At each iteration, the nonlinear function is approximated */
/*     by a quadratic function derived from a Taylor series. */
/*     The quadratic function is minimized to obtain a search direction, */
/*     and an approximate minimum of the nonlinear function along */
/*     the search direction is found using a line search.  The */
/*     algorithm computes an approximation to the second derivative */
/*     matrix of the nonlinear function using quasi-Newton techniques. */

/*     The UNCMIN package is quite general, and provides many options */
/*     for the user.  However, this subroutine is designed to be */
/*     easy to use, with few choices allowed.  For example: */

/*     1.  Only function values need be computed.  First derivative */
/*     values are obtained by finite-differencing.  This can be */
/*     very costly when the number of variables is large. */

/*     2.  It is assumed that the function values can be obtained */
/*     accurately (to an accuracy comparable to the precision of */
/*     the computer arithmetic). */

/*     3.  At most 150 iterations are allowed. */

/*     4.  It is assumed that the function values are well-scaled, */
/*     that is, that the optimal function value is not pathologically */
/*     large or small. */

/*     For more information, see the reference listed below. */

/* PARAMETERS */
/* ---------- */
/* N            --> INTEGER */
/*                  Dimension of problem */
/* X0(N)        --> REAL */
/*                  Initial estimate of minimum */
/* FCN          --> Name of routine to evaluate minimization function. */
/*                  Must be declared EXTERNAL in calling routine, and */
/*                  have calling sequence */
/*                      SUBROUTINE FCN(N, X, F) */
/*                  with N and X as here, F the computed function value. */
/* X(N)        <--  REAL */
/*                  Local minimum */
/* F           <--  REAL */
/*                  Function value at local minimum X */
/* INFO        <--  INTEGER */
/*                  Termination code */
/*                      INFO =  0:  Optimal solution found */
/*                      INFO =  1:  Terminated with gradient small, */
/*                                  X is probably optimal */
/*                      INFO =  2:  Terminated with stepsize small, */
/*                                  X is probably optimal */
/*                      INFO =  3:  Lower point cannot be found, */
/*                                  X is probably optimal */
/*                      INFO =  4:  Iteration limit (150) exceeded */
/*                      INFO =  5:  Too many large steps, */
/*                                  function may be unbounded */
/*                      INFO = -1:  Insufficient workspace */
/* W(LW)        --> REAL */
/*                  Workspace */
/* LW           --> INTEGER */
/*                  Size of workspace, at least N*(N+10) */

/* ***REFERENCES  R.B. SCHNABEL, J.E. KOONTZ, AND BE.E. WEISS, A MODULAR */
/*                 SYSTEM OF ALGORITHMS FOR UNCONSTRAINED MINIMIZATION, */
/*                 REPORT CU-CS-240-82, COMP. SCI. DEPT., UNIV. OF */
/*                 COLORADO AT BOULDER, 1982. */
/* ***ROUTINES CALLED  OPTDRV, XERROR */
/* ***END PROLOGUE  UNCMIN */
/* ---------------------------------------------------------------- */
/* SUBDIVIDE WORKSPACE */
/* ---------------------------------------------------------------- */
/* ***FIRST EXECUTABLE STATEMENT  UNCMIN */
    /* Parameter adjustments */
    --x;
    --x0;
    --w;

    /* Function Body */
    ig = 1;
    it = ig + *n;
    iw1 = it + *n;
    iw2 = iw1 + *n;
    iw3 = iw2 + *n;
    iw4 = iw3 + *n;
    iw5 = iw4 + *n;
    iw6 = iw5 + *n;
    iw7 = iw6 + *n;
    iw8 = iw7 + *n;
    ia = iw8 + *n;
    lwmin = ia + *n * *n - 1;
    if (lwmin > *lw) {
	*info = -1;
	s_wsfi(&io___14);
	do_fio(&c__1, (char *)&(*lw), (ftnlen)sizeof(integer));
	e_wsfi();
	xerror_(errmsg, &c__60, &c_n1, &c__0, (ftnlen)60);
	return 0;
    }
/* ---------------------------------------------------------------- */
/* SET UP PARAMETERS FOR OPTIF9 */
/* ---------------------------------------------------------------- */
/* PARAMETERS THAT SHOULD NOT BE CHANGED */

/* NR     = PARAMETER USED TO DIVIDE WORKSPACE */
/* METHOD = 1 (LINE SEARCH) -- DO NOT CHANGE */
/* MSG    = 9 => NO PRINTING, N=1 ALLOWED */
/* IAGFLG = 1 => ANALYTIC GRADIENT SUPPLIED (0 OTHERWISE) */
/* IAHFLG = 1 => ANALYTIC HESSIAN  SUPPLIED (0 OTHERWISE) */
/* IPR    = DEVICE FOR OUTPUT (IRRELEVANT IN CURRENT VERSION) */
/* DLT    = (IRRELEVANT PARAMETER FOR METHOD = 1) */
/* EPSM   = MACHINE EPSILON */
/* IEXP   = 1 => FUNCTION EXPENSIVE TO EVALUATE (IEXP = 0 => CHEAP) */

    nr = *n;
    method = 1;
    msg = 9;
    iagflg = 0;
    iahflg = 0;
    ipr = 0;
    dlt = (float)-1.;
    epsm = r1mach_(&c__4);
    iexp = 1;

/* PARAMETERS THAT MAY BE CHANGED: */

/* NDIGIT = -1 => OPTIF9 ASSUMES F IS FULLY ACCURATE */
/* ITNLIM = 150 = MAXIMUM NUMBER OF ITERATIONS ALLOWED */
/* GRADTL = ZERO TOLERANCE FOR GRADIENT, FOR CONVERGENCE TESTS */
/* STEPMX = MAXIMUM ALLOWABLE STEP SIZE */
/* STEPTL = ZERO TOLERANCE FOR STEP, FOR CONVERGENCE TESTS */
/* FSCALE = TYPICAL ORDER-OF-MAGNITUDE SIZE OF FUNCTION */
/* TYPSIZ = TYPICAL ORDER-OF-MAGNITUDE SIZE OF X (STORED IN W(LT)) */

    ndigit = -1;
    itnlim = 150;
    d__1 = (doublereal) epsm;
    gradtl = pow_dd(&d__1, &c_b8);
    stepmx = (float)0.;
    steptl = sqrt(epsm);
    fscale = (float)1.;
    i__1 = it + *n - 1;
    for (lt = it; lt <= i__1; ++lt) {
	w[lt] = (float)1.;
/* L10: */
    }

/* MINIMIZE FUNCTION */

    optdrv_(&nr, n, &x0[1], fcn, d1fcn_, d2fcn_, &w[it], &fscale, &method, &
	    iexp, &msg, &ndigit, &itnlim, &iagflg, &iahflg, &ipr, &dlt, &
	    gradtl, &stepmx, &steptl, &x[1], f, &w[ig], info, &w[ia], &w[iw1],
	     &w[iw2], &w[iw3], &w[iw4], &w[iw5], &w[iw6], &w[iw7], &w[iw8]);

    if (*info == 1) {
	s_wsfi(&io___31);
	e_wsfi();
	xerror_(errmsg, &c__62, info, &c__0, (ftnlen)62);
    }
    if (*info == 2) {
	s_wsfi(&io___32);
	e_wsfi();
	xerror_(errmsg, &c__62, info, &c__0, (ftnlen)62);
    }
    if (*info == 3) {
	s_wsfi(&io___33);
	e_wsfi();
	xerror_(errmsg, &c__51, info, &c__0, (ftnlen)51);
    }
    if (*info == 4) {
	s_wsfi(&io___34);
	e_wsfi();
	xerror_(errmsg, &c__47, info, &c__0, (ftnlen)47);
    }
    if (*info == 5) {
	s_wsfi(&io___35);
	e_wsfi();
	xerror_(errmsg, &c__68, info, &c__0, (ftnlen)68);
    }

    return 0;
} /* uncmin_ */

/* Subroutine */ int dummy_()
{
/* *DUMMY SUBROUTINE (REPRESENTS UNUSED ROUTINES FROM FULL VERSION)* */
    return 0;
} /* dummy_ */

/* Subroutine */ int bakslv_(nr, n, a, x, b)
integer *nr, *n;
real *a, *x, *b;
{
    /* System generated locals */
    integer a_dim1, a_offset, i__1;

    /* Local variables */
    static integer i__, j, ip1;
    static real sum;

/*     THIS PROLOGUE HAS BEEN REMOVED FOR REASONS OF SPACE */
/*     FOR A COMPLETE COPY OF THIS ROUTINE CONTACT THE AUTHORS */
/*     From the book "Numerical Methods and Software" */
/*          by  D. Kahaner, C. Moler, S. Nash */
/*               Prentice Hall 1988 */


/* SOLVE (L-TRANSPOSE)X=B. (BACK SOLVE) */

    /* Parameter adjustments */
    a_dim1 = *nr;
    a_offset = 1 + a_dim1 * 1;
    a -= a_offset;
    --b;
    --x;

    /* Function Body */
    i__ = *n;
    x[i__] = b[i__] / a[i__ + i__ * a_dim1];
    if (*n == 1) {
	return 0;
    }
L30:
    ip1 = i__;
    --i__;
    sum = (float)0.;
    i__1 = *n;
    for (j = ip1; j <= i__1; ++j) {
	sum += a[j + i__ * a_dim1] * x[j];
/* L40: */
    }
    x[i__] = (b[i__] - sum) / a[i__ + i__ * a_dim1];
    if (i__ > 1) {
	goto L30;
    }
    return 0;
} /* bakslv_ */

/* Subroutine */ int d1fcn_()
{
/* *DUMMY* */
    return 0;
} /* d1fcn_ */

/* Subroutine */ int d2fcn_()
{
/* *DUMMY* */
    return 0;
} /* d2fcn_ */

/* Subroutine */ int forslv_(nr, n, a, x, b)
integer *nr, *n;
real *a, *x, *b;
{
    /* System generated locals */
    integer a_dim1, a_offset, i__1, i__2;

    /* Local variables */
    static integer i__, j, im1;
    static real sum;

/*     THIS PROLOGUE HAS BEEN REMOVED FOR REASONS OF SPACE */
/*     FOR A COMPLETE COPY OF THIS ROUTINE CONTACT THE AUTHORS */
/*     From the book "Numerical Methods and Software" */
/*          by  D. Kahaner, C. Moler, S. Nash */
/*               Prentice Hall 1988 */


/* SOLVE LX=B. (FOREWARD SOLVE) */

    /* Parameter adjustments */
    a_dim1 = *nr;
    a_offset = 1 + a_dim1 * 1;
    a -= a_offset;
    --b;
    --x;

    /* Function Body */
    x[1] = b[1] / a[a_dim1 + 1];
    if (*n == 1) {
	return 0;
    }
    i__1 = *n;
    for (i__ = 2; i__ <= i__1; ++i__) {
	sum = (float)0.;
	im1 = i__ - 1;
	i__2 = im1;
	for (j = 1; j <= i__2; ++j) {
	    sum += a[i__ + j * a_dim1] * x[j];
/* L10: */
	}
	x[i__] = (b[i__] - sum) / a[i__ + i__ * a_dim1];
/* L20: */
    }
    return 0;
} /* forslv_ */

/* Subroutine */ int fstocd_(n, x, fcn, sx, rnoise, g)
integer *n;
real *x;
/* Subroutine */ int (*fcn) ();
real *sx, *rnoise, *g;
{
    /* System generated locals */
    integer i__1;
    real r__1, r__2, r__3;
    doublereal d__1, d__2;

    /* Builtin functions */
    double pow_dd();

    /* Local variables */
    static integer i__;
    static real third, stepi, fplus, fminus, xtempi;

/*     THIS PROLOGUE HAS BEEN REMOVED FOR REASONS OF SPACE */
/*     FOR A COMPLETE COPY OF THIS ROUTINE CONTACT THE AUTHORS */
/*     From the book "Numerical Methods and Software" */
/*          by  D. Kahaner, C. Moler, S. Nash */
/*               Prentice Hall 1988 */


/* FIND I TH  STEPSIZE, EVALUATE TWO NEIGHBORS IN DIRECTION OF I TH */
/* UNIT VECTOR, AND EVALUATE I TH  COMPONENT OF GRADIENT. */

    /* Parameter adjustments */
    --g;
    --sx;
    --x;

    /* Function Body */
    third = (float).3333333333333333;
    i__1 = *n;
    for (i__ = 1; i__ <= i__1; ++i__) {
	d__1 = (doublereal) (*rnoise);
	d__2 = (doublereal) third;
/* Computing MAX */
	r__2 = (r__1 = x[i__], dabs(r__1)), r__3 = (float)1. / sx[i__];
	stepi = pow_dd(&d__1, &d__2) * dmax(r__2,r__3);
	xtempi = x[i__];
	x[i__] = xtempi + stepi;
	(*fcn)(n, &x[1], &fplus);
	x[i__] = xtempi - stepi;
	(*fcn)(n, &x[1], &fminus);
	x[i__] = xtempi;
	g[i__] = (fplus - fminus) / (stepi * (float)2.);
/* L10: */
    }
    return 0;
} /* fstocd_ */

/* Subroutine */ int fstofd_(nr, m, n, xpls, fcn, fpls, a, sx, rnoise, fhat, 
	icase)
integer *nr, *m, *n;
real *xpls;
/* Subroutine */ int (*fcn) ();
real *fpls, *a, *sx, *rnoise, *fhat;
integer *icase;
{
    /* System generated locals */
    integer a_dim1, a_offset, i__1, i__2;
    real r__1, r__2, r__3;

    /* Builtin functions */
    double sqrt();

    /* Local variables */
    static integer i__, j;
    static real xtmpj;
    static integer jp1, nm1;
    static real stepsz;

/*     THIS PROLOGUE HAS BEEN REMOVED FOR REASONS OF SPACE */
/*     FOR A COMPLETE COPY OF THIS ROUTINE CONTACT THE AUTHORS */
/*     From the book "Numerical Methods and Software" */
/*          by  D. Kahaner, C. Moler, S. Nash */
/*               Prentice Hall 1988 */


/* FIND J-TH COLUMN OF A */
/* EACH COLUMN IS DERIVATIVE OF F(FCN) WITH RESPECT TO XPLS(J) */

    /* Parameter adjustments */
    a_dim1 = *nr;
    a_offset = 1 + a_dim1 * 1;
    a -= a_offset;
    --fhat;
    --fpls;
    --sx;
    --xpls;

    /* Function Body */
    i__1 = *n;
    for (j = 1; j <= i__1; ++j) {
/* Computing MAX */
	r__2 = (r__1 = xpls[j], dabs(r__1)), r__3 = (float)1. / sx[j];
	stepsz = sqrt(*rnoise) * dmax(r__2,r__3);
	xtmpj = xpls[j];
	xpls[j] = xtmpj + stepsz;
	(*fcn)(n, &xpls[1], &fhat[1]);
	xpls[j] = xtmpj;
	i__2 = *m;
	for (i__ = 1; i__ <= i__2; ++i__) {
	    a[i__ + j * a_dim1] = (fhat[i__] - fpls[i__]) / stepsz;
/* L20: */
	}
/* L30: */
    }
    if (*icase != 3) {
	return 0;
    }

/* IF COMPUTING HESSIAN, A MUST BE SYMMETRIC */

    if (*n == 1) {
	return 0;
    }
    nm1 = *n - 1;
    i__1 = nm1;
    for (j = 1; j <= i__1; ++j) {
	jp1 = j + 1;
	i__2 = *m;
	for (i__ = jp1; i__ <= i__2; ++i__) {
	    a[i__ + j * a_dim1] = (a[i__ + j * a_dim1] + a[j + i__ * a_dim1]) 
		    / (float)2.;
/* L40: */
	}
/* L50: */
    }
    return 0;
} /* fstofd_ */

/* Subroutine */ int hsnint_(nr, n, a, sx, method)
integer *nr, *n;
real *a, *sx;
integer *method;
{
    /* System generated locals */
    integer a_dim1, a_offset, i__1, i__2;

    /* Local variables */
    static integer i__, j, jp1;

/*     THIS PROLOGUE HAS BEEN REMOVED FOR REASONS OF SPACE */
/*     FOR A COMPLETE COPY OF THIS ROUTINE CONTACT THE AUTHORS */
/*     From the book "Numerical Methods and Software" */
/*          by  D. Kahaner, C. Moler, S. Nash */
/*               Prentice Hall 1988 */


    /* Parameter adjustments */
    a_dim1 = *nr;
    a_offset = 1 + a_dim1 * 1;
    a -= a_offset;
    --sx;

    /* Function Body */
    i__1 = *n;
    for (j = 1; j <= i__1; ++j) {
	if (*method == 3) {
	    a[j + j * a_dim1] = sx[j] * sx[j];
	}
	if (*method != 3) {
	    a[j + j * a_dim1] = sx[j];
	}
	if (j == *n) {
	    goto L100;
	}
	jp1 = j + 1;
	i__2 = *n;
	for (i__ = jp1; i__ <= i__2; ++i__) {
	    a[i__ + j * a_dim1] = (float)0.;
/* L90: */
	}
L100:
	;
    }
    return 0;
} /* hsnint_ */

/* Subroutine */ int lltslv_(nr, n, a, x, b)
integer *nr, *n;
real *a, *x, *b;
{
    /* System generated locals */
    integer a_dim1, a_offset;

    /* Local variables */
    extern /* Subroutine */ int bakslv_(), forslv_();

/*     THIS PROLOGUE HAS BEEN REMOVED FOR REASONS OF SPACE */
/*     FOR A COMPLETE COPY OF THIS ROUTINE CONTACT THE AUTHORS */
/*     From the book "Numerical Methods and Software" */
/*          by  D. Kahaner, C. Moler, S. Nash */
/*               Prentice Hall 1988 */


/* FORWARD SOLVE, RESULT IN X */

    /* Parameter adjustments */
    a_dim1 = *nr;
    a_offset = 1 + a_dim1 * 1;
    a -= a_offset;
    --b;
    --x;

    /* Function Body */
    forslv_(nr, n, &a[a_offset], &x[1], &b[1]);

/* BACK SOLVE, RESULT IN X */

    bakslv_(nr, n, &a[a_offset], &x[1], &x[1]);
    return 0;
} /* lltslv_ */

/* Subroutine */ int lnsrch_(n, x, f, g, p, xpls, fpls, fcn, mxtake, iretcd, 
	stepmx, steptl, sx, ipr)
integer *n;
real *x, *f, *g, *p, *xpls, *fpls;
/* Subroutine */ int (*fcn) ();
logical *mxtake;
integer *iretcd;
real *stepmx, *steptl, *sx;
integer *ipr;
{
    /* System generated locals */
    integer i__1;
    real r__1, r__2, r__3, r__4, r__5, r__6;

    /* Builtin functions */
    double sqrt(), r_sign();

    /* Local variables */
    static real disc;
    extern doublereal sdot_();
    static real a, b;
    static integer i__;
    static real pfpls, t1, t2, t3, almbda, plmbda, tlmbda, rmnlmb;
    extern /* Subroutine */ int sclmul_();
    static real scl, rln, sln, slp, tmp;

/*     THIS PROLOGUE HAS BEEN REMOVED FOR REASONS OF SPACE */
/*     FOR A COMPLETE COPY OF THIS ROUTINE CONTACT THE AUTHORS */
/*     From the book "Numerical Methods and Software" */
/*          by  D. Kahaner, C. Moler, S. Nash */
/*               Prentice Hall 1988 */


    /* Parameter adjustments */
    --sx;
    --xpls;
    --p;
    --g;
    --x;

    /* Function Body */
    *ipr = *ipr;
    *mxtake = FALSE_;
    *iretcd = 2;
    tmp = (float)0.;
    i__1 = *n;
    for (i__ = 1; i__ <= i__1; ++i__) {
	tmp += sx[i__] * sx[i__] * p[i__] * p[i__];
/* L5: */
    }
    sln = sqrt(tmp);
    if (sln <= *stepmx) {
	goto L10;
    }

/* NEWTON STEP LONGER THAN MAXIMUM ALLOWED */
    scl = *stepmx / sln;
    sclmul_(n, &scl, &p[1], &p[1]);
    sln = *stepmx;
L10:
    slp = sdot_(n, &g[1], &c__1, &p[1], &c__1);
    rln = (float)0.;
    i__1 = *n;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* Computing MAX */
/* Computing MAX */
	r__5 = (r__2 = x[i__], dabs(r__2)), r__6 = (float)1. / sx[i__];
	r__3 = rln, r__4 = (r__1 = p[i__], dabs(r__1)) / dmax(r__5,r__6);
	rln = dmax(r__3,r__4);
/* L15: */
    }
    rmnlmb = *steptl / rln;
    almbda = (float)1.;

/* LOOP */
/* CHECK IF NEW ITERATE SATISFACTORY.  GENERATE NEW LAMBDA IF NECESSARY. */

L100:
    if (*iretcd < 2) {
	return 0;
    }
    i__1 = *n;
    for (i__ = 1; i__ <= i__1; ++i__) {
	xpls[i__] = x[i__] + almbda * p[i__];
/* L105: */
    }
    (*fcn)(n, &xpls[1], fpls);
    if (*fpls > *f + slp * (float)1e-4 * almbda) {
	goto L130;
    }
/*     IF(FPLS.LE. F+SLP*1.E-4*ALMBDA) */
/*     THEN */

/* SOLUTION FOUND */

    *iretcd = 0;
    if (almbda == (float)1. && sln > *stepmx * (float).99) {
	*mxtake = TRUE_;
    }
    goto L100;

/* SOLUTION NOT (YET) FOUND */

/*     ELSE */
L130:
    if (almbda >= rmnlmb) {
	goto L140;
    }
/*       IF(ALMBDA .LT. RMNLMB) */
/*       THEN */

/* NO SATISFACTORY XPLS FOUND SUFFICIENTLY DISTINCT FROM X */

    *iretcd = 1;
    goto L100;
/*       ELSE */

/* CALCULATE NEW LAMBDA */

L140:
    if (almbda != (float)1.) {
	goto L150;
    }
/*         IF(ALMBDA.EQ.1.0) */
/*         THEN */

/* FIRST BACKTRACK: QUADRATIC FIT */

    tlmbda = -slp / ((*fpls - *f - slp) * (float)2.);
    goto L170;
/*         ELSE */

/* ALL SUBSEQUENT BACKTRACKS: CUBIC FIT */

L150:
    t1 = *fpls - *f - almbda * slp;
    t2 = pfpls - *f - plmbda * slp;
    t3 = (float)1. / (almbda - plmbda);
    a = t3 * (t1 / (almbda * almbda) - t2 / (plmbda * plmbda));
    b = t3 * (t2 * almbda / (plmbda * plmbda) - t1 * plmbda / (almbda * 
	    almbda));
    disc = b * b - a * (float)3. * slp;
    if (disc <= b * b) {
	goto L160;
    }
/*           IF(DISC.GT. B*B) */
/*           THEN */

/* ONLY ONE POSITIVE CRITICAL POINT, MUST BE MINIMUM */

    tlmbda = (-b + r_sign(&c_b58, &a) * sqrt(disc)) / (a * (float)3.);
    goto L165;
/*           ELSE */

/* BOTH CRITICAL POINTS POSITIVE, FIRST IS MINIMUM */

L160:
    tlmbda = (-b - r_sign(&c_b58, &a) * sqrt(disc)) / (a * (float)3.);
/*           ENDIF */
L165:
    if (tlmbda > almbda * (float).5) {
	tlmbda = almbda * (float).5;
    }
/*         ENDIF */
L170:
    plmbda = almbda;
    pfpls = *fpls;
    if (tlmbda >= almbda * (float).1) {
	goto L180;
    }
/*         IF(TLMBDA.LT.ALMBDA/10.) */
/*         THEN */
    almbda *= (float).1;
    goto L190;
/*         ELSE */
L180:
    almbda = tlmbda;
/*         ENDIF */
/*       ENDIF */
/*     ENDIF */
L190:
    goto L100;
} /* lnsrch_ */

/* Subroutine */ int mvmltl_(nr, n, a, x, y)
integer *nr, *n;
real *a, *x, *y;
{
    /* System generated locals */
    integer a_dim1, a_offset, i__1, i__2;

    /* Local variables */
    static integer i__, j;
    static real sum;

/*     THIS PROLOGUE HAS BEEN REMOVED FOR REASONS OF SPACE */
/*     FOR A COMPLETE COPY OF THIS ROUTINE CONTACT THE AUTHORS */
/*     From the book "Numerical Methods and Software" */
/*          by  D. Kahaner, C. Moler, S. Nash */
/*               Prentice Hall 1988 */

    /* Parameter adjustments */
    a_dim1 = *nr;
    a_offset = 1 + a_dim1 * 1;
    a -= a_offset;
    --y;
    --x;

    /* Function Body */
    i__1 = *n;
    for (i__ = 1; i__ <= i__1; ++i__) {
	sum = (float)0.;
	i__2 = i__;
	for (j = 1; j <= i__2; ++j) {
	    sum += a[i__ + j * a_dim1] * x[j];
/* L10: */
	}
	y[i__] = sum;
/* L30: */
    }
    return 0;
} /* mvmltl_ */

/* Subroutine */ int mvmltu_(nr, n, a, x, y)
integer *nr, *n;
real *a, *x, *y;
{
    /* System generated locals */
    integer a_dim1, a_offset, i__1, i__2;

    /* Local variables */
    static integer i__, j;
    static real sum;

/*     THIS PROLOGUE HAS BEEN REMOVED FOR REASONS OF SPACE */
/*     FOR A COMPLETE COPY OF THIS ROUTINE CONTACT THE AUTHORS */
/*     From the book "Numerical Methods and Software" */
/*          by  D. Kahaner, C. Moler, S. Nash */
/*               Prentice Hall 1988 */

    /* Parameter adjustments */
    a_dim1 = *nr;
    a_offset = 1 + a_dim1 * 1;
    a -= a_offset;
    --y;
    --x;

    /* Function Body */
    i__1 = *n;
    for (i__ = 1; i__ <= i__1; ++i__) {
	sum = (float)0.;
	i__2 = *n;
	for (j = i__; j <= i__2; ++j) {
	    sum += a[j + i__ * a_dim1] * x[j];
/* L10: */
	}
	y[i__] = sum;
/* L30: */
    }
    return 0;
} /* mvmltu_ */

/* Subroutine */ int optchk_(n, x, typsiz, sx, fscale, gradtl, itnlim, ndigit,
	 epsm, dlt, method, iexp, iagflg, iahflg, stepmx, msg, ipr)
integer *n;
real *x, *typsiz, *sx, *fscale, *gradtl;
integer *itnlim, *ndigit;
real *epsm, *dlt;
integer *method, *iexp, *iagflg, *iahflg;
real *stepmx;
integer *msg, *ipr;
{
    /* System generated locals */
    integer i__1;
    real r__1;

    /* Builtin functions */
    double sqrt(), r_lg10();

    /* Local variables */
    static integer i__;
    static real stpsiz;

/*     THIS PROLOGUE HAS BEEN REMOVED FOR REASONS OF SPACE */
/*     FOR A COMPLETE COPY OF THIS ROUTINE CONTACT THE AUTHORS */
/*     From the book "Numerical Methods and Software" */
/*          by  D. Kahaner, C. Moler, S. Nash */
/*               Prentice Hall 1988 */


/* CHECK THAT PARAMETERS ONLY TAKE ON ACCEPTABLE VALUES. */
/* IF NOT, SET THEM TO DEFAULT VALUES. */
    /* Parameter adjustments */
    --sx;
    --typsiz;
    --x;

    /* Function Body */
    *ipr = *ipr;
    if (*method < 1 || *method > 3) {
	*method = 1;
    }
    if (*iagflg != 1) {
	*iagflg = 0;
    }
    if (*iahflg != 1) {
	*iahflg = 0;
    }
    if (*iexp != 0) {
	*iexp = 1;
    }
    if (*msg / 2 % 2 == 1 && *iagflg == 0) {
	goto L830;
    }
    if (*msg / 4 % 2 == 1 && *iahflg == 0) {
	goto L835;
    }

/* CHECK DIMENSION OF PROBLEM */

    if (*n <= 0) {
	goto L805;
    }
    if (*n == 1 && *msg % 2 == 0) {
	goto L810;
    }

/* COMPUTE SCALE MATRIX */

    i__1 = *n;
    for (i__ = 1; i__ <= i__1; ++i__) {
	if (typsiz[i__] == (float)0.) {
	    typsiz[i__] = (float)1.;
	}
	if (typsiz[i__] < (float)0.) {
	    typsiz[i__] = -typsiz[i__];
	}
	sx[i__] = (float)1. / typsiz[i__];
/* L10: */
    }

/* CHECK MAXIMUM STEP SIZE */

    if (*stepmx > (float)0.) {
	goto L20;
    }
    stpsiz = (float)0.;
    i__1 = *n;
    for (i__ = 1; i__ <= i__1; ++i__) {
	stpsiz += x[i__] * x[i__] * sx[i__] * sx[i__];
/* L15: */
    }
    stpsiz = sqrt(stpsiz);
/* Computing MAX */
    r__1 = stpsiz * (float)1e3;
    *stepmx = dmax(r__1,(float)1e3);
L20:
/* CHECK FUNCTION SCALE */
    if (*fscale == (float)0.) {
	*fscale = (float)1.;
    }
    if (*fscale < (float)0.) {
	*fscale = -(*fscale);
    }

/* CHECK GRADIENT TOLERANCE */
    if (*gradtl < (float)0.) {
	goto L815;
    }

/* CHECK ITERATION LIMIT */
    if (*itnlim <= 0) {
	goto L820;
    }

/* CHECK NUMBER OF DIGITS OF ACCURACY IN FUNCTION FCN */
    if (*ndigit == 0) {
	goto L825;
    }
    if (*ndigit < 0) {
	*ndigit = -r_lg10(epsm);
    }

/* CHECK TRUST REGION RADIUS */
    if (*dlt <= (float)0.) {
	*dlt = (float)-1.;
    }
    if (*dlt > *stepmx) {
	*dlt = *stepmx;
    }
    return 0;

/* ERROR EXITS */

/* INSERT CALLS TO XERROR */
/* OPTCHK: ILLEGAL DIMENSION, N */
L805:
    *msg = -1;
    goto L895;
/* OPTCHK: WARNING +++  THIS PACKAGE IS INEFFICIENT FOR N=1 */
/* (CANNOT BE GENERATED WITH CURRENT VALUE OF MSG) */
L810:
    *msg = -2;
    goto L895;
/* OPTCHK: ILLEGAL TOLERANCE.  GRADTL */
L815:
    *msg = -3;
    goto L895;
/* OPTCHK: ILLEGAL ITERATION LIMIT.  ITNLIM */
L820:
    *msg = -4;
    goto L895;
/* OPTCHK: MINIMIZATION FUNCTION HAS NO GOOD DIGITS */
L825:
    *msg = -5;
    goto L895;
/* OPTCHK: USER REQUESTS THAT ANALYTIC GRADIENT BE USED */
/*         BUT ANALYTIC GRADIENT NOT SUPPLIED */
L830:
    *msg = -6;
    goto L895;
/* OPTCHK: USER REQUESTS THAT ANALYTIC HESSIAN BE USED */
/*         BUT ANALYTIC HESSIAN NOT SUPPLIED */
L835:
    *msg = -7;
L895:
    return 0;
} /* optchk_ */

/* Subroutine */ int optdrv_(nr, n, x, fcn, d1fcn, d2fcn, typsiz, fscale, 
	method, iexp, msg, ndigit, itnlim, iagflg, iahflg, ipr, dlt, gradtl, 
	stepmx, steptl, xpls, fpls, gpls, itrmcd, a, udiag, g, p, sx, wrk0, 
	wrk1, wrk2, wrk3)
integer *nr, *n;
real *x;
/* Subroutine */ int (*fcn) (), (*d1fcn) (), (*d2fcn) ();
real *typsiz, *fscale;
integer *method, *iexp, *msg, *ndigit, *itnlim, *iagflg, *iahflg, *ipr;
real *dlt, *gradtl, *stepmx, *steptl, *xpls, *fpls, *gpls;
integer *itrmcd;
real *a, *udiag, *g, *p, *sx, *wrk0, *wrk1, *wrk2, *wrk3;
{
    /* System generated locals */
    integer a_dim1, a_offset, i__1;
    real r__1;

    /* Builtin functions */
    double pow_ri();

    /* Local variables */
    static real dltp, epsm, phip0, f;
    static integer i__;
    extern /* Subroutine */ int dummy_();
    extern doublereal r1mach_();
    extern /* Subroutine */ int secfac_();
    static integer iretcd;
    extern /* Subroutine */ int fstocd_(), fstofd_();
    static integer icscmx;
    extern /* Subroutine */ int optchk_();
    static logical mxtake;
    static real dlpsav, phisav, dltsav, amusav;
    static integer itncnt;
    extern /* Subroutine */ int lnsrch_();
    static real phpsav;
    extern /* Subroutine */ int hsnint_();
    static logical noupdt;
    extern /* Subroutine */ int lltslv_(), optstp_();
    static real phi, amu, rnf, wrk;

/*     THIS PROLOGUE HAS BEEN REMOVED FOR REASONS OF SPACE */
/*     FOR A COMPLETE COPY OF THIS ROUTINE CONTACT THE AUTHORS */
/*     From the book "Numerical Methods and Software" */
/*          by  D. Kahaner, C. Moler, S. Nash */
/*               Prentice Hall 1988 */


/* INITIALIZATION */
/* -------------- */
    /* Parameter adjustments */
    a_dim1 = *nr;
    a_offset = 1 + a_dim1 * 1;
    a -= a_offset;
    --wrk3;
    --wrk2;
    --wrk1;
    --wrk0;
    --sx;
    --p;
    --g;
    --udiag;
    --gpls;
    --xpls;
    --typsiz;
    --x;

    /* Function Body */
    i__1 = *n;
    for (i__ = 1; i__ <= i__1; ++i__) {
	p[i__] = (float)0.;
/* L10: */
    }
    itncnt = 0;
    iretcd = -1;
    epsm = r1mach_(&c__4);
    optchk_(n, &x[1], &typsiz[1], &sx[1], fscale, gradtl, itnlim, ndigit, &
	    epsm, dlt, method, iexp, iagflg, iahflg, stepmx, msg, ipr);
    if (*msg < 0) {
	return 0;
    }
/* Computing MAX */
    i__1 = -(*ndigit);
    r__1 = pow_ri(&c_b84, &i__1);
    rnf = dmax(r__1,epsm);

/* EVALUATE FCN(X) */

    (*fcn)(n, &x[1], &f);

/* EVALUATE ANALYTIC OR FINITE DIFFERENCE GRADIENT AND CHECK ANALYTIC */
/* GRADIENT, IF REQUESTED. */

    if (*iagflg == 1) {
	goto L20;
    }
/*     IF (IAGFLG .EQ. 0) */
/*     THEN */
    fstofd_(&c__1, &c__1, n, &x[1], fcn, &f, &g[1], &sx[1], &rnf, &wrk, &c__1)
	    ;
    goto L25;

L20:
    (*d1fcn)();
    if (*msg / 2 % 2 == 1) {
	goto L25;
    }
/*     IF (MOD(MSG/2,2).EQ.0) */
/*     THEN */
    dummy_();
    if (*msg < 0) {
	return 0;
    }
L25:

    optstp_(n, &x[1], &f, &g[1], &wrk1[1], &itncnt, &icscmx, itrmcd, gradtl, 
	    steptl, &sx[1], fscale, itnlim, &iretcd, &mxtake, ipr, msg);
    if (*itrmcd != 0) {
	goto L700;
    }

    if (*iexp != 1) {
	goto L80;
    }

/* IF OPTIMIZATION FUNCTION EXPENSIVE TO EVALUATE (IEXP=1), THEN */
/* HESSIAN WILL BE OBTAINED BY SECANT UPDATES.  GET INITIAL HESSIAN. */

    hsnint_(nr, n, &a[a_offset], &sx[1], method);
    goto L90;
L80:

/* EVALUATE ANALYTIC OR FINITE DIFFERENCE HESSIAN AND CHECK ANALYTIC */
/* HESSIAN IF REQUESTED (ONLY IF USER-SUPPLIED ANALYTIC HESSIAN */
/* ROUTINE D2FCN FILLS ONLY LOWER TRIANGULAR PART AND DIAGONAL OF A). */

    if (*iahflg == 1) {
	goto L82;
    }
/*     IF (IAHFLG .EQ. 0) */
/*     THEN */
    if (*iagflg == 1) {
	fstofd_(nr, n, n, &x[1], d1fcn, &g[1], &a[a_offset], &sx[1], &rnf, &
		wrk1[1], &c__3);
    }
    if (*iagflg != 1) {
	dummy_();
    }
    goto L88;

/*     ELSE */
L82:
    if (*msg / 4 % 2 == 0) {
	goto L85;
    }
/*        IF (MOD(MSG/4, 2) .EQ. 1) */
/*        THEN */
    (*d2fcn)();
    goto L88;

/*        ELSE */
L85:
    dummy_();

/*           HESCHK EVALUATES D2FCN AND CHECKS IT AGAINST THE FINITE */
/*           DIFFERENCE HESSIAN WHICH IT CALCULATES BY CALLING FSTOFD */
/*           (IF IAGFLG .EQ. 1) OR SNDOFD (OTHERWISE). */

    if (*msg < 0) {
	return 0;
    }
L88:

L90:
    if (*msg / 8 % 2 == 0) {
	dummy_();
    }


/* ITERATION */
/* --------- */
L100:
    ++itncnt;

/* FIND PERTURBED LOCAL MODEL HESSIAN AND ITS LL+ DECOMPOSITION */
/* (SKIP THIS STEP IF LINE SEARCH OR DOGSTEP TECHNIQUES BEING USED WITH */
/* SECANT UPDATES.  CHOLESKY DECOMPOSITION L ALREADY OBTAINED FROM */
/* SECFAC.) */

    if (*iexp == 1 && *method != 3) {
	goto L105;
    }
L103:
    dummy_();
L105:

/* SOLVE FOR NEWTON STEP:  AP=-G */

    i__1 = *n;
    for (i__ = 1; i__ <= i__1; ++i__) {
	wrk1[i__] = -g[i__];
/* L110: */
    }
    lltslv_(nr, n, &a[a_offset], &p[1], &wrk1[1]);

/* DECIDE WHETHER TO ACCEPT NEWTON STEP  XPLS=X + P */
/* OR TO CHOOSE XPLS BY A GLOBAL STRATEGY. */

    if (*iagflg != 0 || *method == 1) {
	goto L111;
    }
    dltsav = *dlt;
    if (*method == 2) {
	goto L111;
    }
    amusav = amu;
    dlpsav = dltp;
    phisav = phi;
    phpsav = phip0;
L111:
    if (*method == 1) {
	lnsrch_(n, &x[1], &f, &g[1], &p[1], &xpls[1], fpls, fcn, &mxtake, &
		iretcd, stepmx, steptl, &sx[1], ipr);
    }
    if (*method == 2) {
	dummy_();
    }
    if (*method == 3) {
	dummy_();
    }

/* IF COULD NOT FIND SATISFACTORY STEP AND FORWARD DIFFERENCE */
/* GRADIENT WAS USED, RETRY USING CENTRAL DIFFERENCE GRADIENT. */

    if (iretcd != 1 || *iagflg != 0) {
	goto L112;
    }
/*     IF (IRETCD .EQ. 1 .AND. IAGFLG .EQ. 0) */
/*     THEN */

/*        SET IAGFLG FOR CENTRAL DIFFERENCES */

    *iagflg = -1;

    fstocd_(n, &x[1], fcn, &sx[1], &rnf, &g[1]);
    if (*method == 1) {
	goto L105;
    }
    *dlt = dltsav;
    if (*method == 2) {
	goto L105;
    }
    amu = amusav;
    dltp = dlpsav;
    phi = phisav;
    phip0 = phpsav;
    goto L103;
/*     ENDIF */

/* CALCULATE STEP FOR OUTPUT */

L112:
    i__1 = *n;
    for (i__ = 1; i__ <= i__1; ++i__) {
	p[i__] = xpls[i__] - x[i__];
/* L114: */
    }

/* CALCULATE GRADIENT AT XPLS */

    if (*iagflg == -1) {
	goto L116;
    }
    if (*iagflg == 0) {
	goto L118;
    }

/* ANALYTIC GRADIENT */
    (*d1fcn)();
    goto L120;

/* CENTRAL DIFFERENCE GRADIENT */
L116:
    fstocd_(n, &xpls[1], fcn, &sx[1], &rnf, &gpls[1]);
    goto L120;

/* FORWARD DIFFERENCE GRADIENT */
L118:
    fstofd_(&c__1, &c__1, n, &xpls[1], fcn, fpls, &gpls[1], &sx[1], &rnf, &
	    wrk, &c__1);
L120:

/* CHECK WHETHER STOPPING CRITERIA SATISFIED */

    optstp_(n, &xpls[1], fpls, &gpls[1], &x[1], &itncnt, &icscmx, itrmcd, 
	    gradtl, steptl, &sx[1], fscale, itnlim, &iretcd, &mxtake, ipr, 
	    msg);
    if (*itrmcd != 0) {
	goto L690;
    }

/* EVALUATE HESSIAN AT XPLS */

    if (*iexp == 0) {
	goto L130;
    }
    if (*method == 3) {
	dummy_();
    }
    if (*method != 3) {
	secfac_(nr, n, &x[1], &g[1], &a[a_offset], &xpls[1], &gpls[1], &epsm, 
		&itncnt, &rnf, iagflg, &noupdt, &wrk0[1], &wrk1[1], &wrk2[1], 
		&wrk3[1]);
    }
    goto L150;
L130:
    if (*iahflg == 1) {
	goto L140;
    }
    if (*iagflg == 1) {
	fstofd_(nr, n, n, &xpls[1], d1fcn, &gpls[1], &a[a_offset], &sx[1], &
		rnf, &wrk1[1], &c__3);
    }
    if (*iagflg != 1) {
	dummy_();
    }
    goto L150;
L140:
    (*d2fcn)();
L150:
    if (*msg / 16 % 2 == 1) {
	dummy_();
    }

/* X <-- XPLS  AND  G <-- GPLS  AND  F <-- FPLS */

    f = *fpls;
    i__1 = *n;
    for (i__ = 1; i__ <= i__1; ++i__) {
	x[i__] = xpls[i__];
	g[i__] = gpls[i__];
/* L160: */
    }
    goto L100;

/* TERMINATION */
/* ----------- */
/* RESET XPLS,FPLS,GPLS,  IF PREVIOUS ITERATE SOLUTION */

L690:
    if (*itrmcd != 3) {
	goto L710;
    }
L700:
    *fpls = f;
    i__1 = *n;
    for (i__ = 1; i__ <= i__1; ++i__) {
	xpls[i__] = x[i__];
	gpls[i__] = g[i__];
/* L705: */
    }

/* PRINT RESULTS */

L710:
    if (*msg / 8 % 2 == 0) {
	dummy_();
    }
    *msg = 0;
    return 0;

} /* optdrv_ */

/* Subroutine */ int optstp_(n, xpls, fpls, gpls, x, itncnt, icscmx, itrmcd, 
	gradtl, steptl, sx, fscale, itnlim, iretcd, mxtake, ipr, msg)
integer *n;
real *xpls, *fpls, *gpls, *x;
integer *itncnt, *icscmx, *itrmcd;
real *gradtl, *steptl, *sx, *fscale;
integer *itnlim, *iretcd;
logical *mxtake;
integer *ipr, *msg;
{
    /* System generated locals */
    integer i__1;
    real r__1, r__2, r__3, r__4;

    /* Local variables */
    static real d__;
    static integer i__;
    static real relgrd;
    static integer jtrmcd;
    static real relstp, rgx, rsx;

/*     THIS PROLOGUE HAS BEEN REMOVED FOR REASONS OF SPACE */
/*     FOR A COMPLETE COPY OF THIS ROUTINE CONTACT THE AUTHORS */
/*     From the book "Numerical Methods and Software" */
/*          by  D. Kahaner, C. Moler, S. Nash */
/*               Prentice Hall 1988 */


    /* Parameter adjustments */
    --sx;
    --x;
    --gpls;
    --xpls;

    /* Function Body */
    *ipr = *ipr;
    *itrmcd = 0;

/* LAST GLOBAL STEP FAILED TO LOCATE A POINT LOWER THAN X */
    if (*iretcd != 1) {
	goto L50;
    }
/*     IF(IRETCD.EQ.1) */
/*     THEN */
    jtrmcd = 3;
    goto L600;
/*     ENDIF */
L50:

/* FIND DIRECTION IN WHICH RELATIVE GRADIENT MAXIMUM. */
/* CHECK WHETHER WITHIN TOLERANCE */

/* Computing MAX */
    r__1 = dabs(*fpls);
    d__ = dmax(r__1,*fscale);
    rgx = (float)0.;
    i__1 = *n;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* Computing MAX */
	r__3 = (r__2 = xpls[i__], dabs(r__2)), r__4 = (float)1. / sx[i__];
	relgrd = (r__1 = gpls[i__], dabs(r__1)) * dmax(r__3,r__4) / d__;
	rgx = dmax(rgx,relgrd);
/* L100: */
    }
    jtrmcd = 1;
    if (rgx <= *gradtl) {
	goto L600;
    }

    if (*itncnt == 0) {
	return 0;
    }

/* FIND DIRECTION IN WHICH RELATIVE STEPSIZE MAXIMUM */
/* CHECK WHETHER WITHIN TOLERANCE. */

    rsx = (float)0.;
    i__1 = *n;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* Computing MAX */
	r__3 = (r__2 = xpls[i__], dabs(r__2)), r__4 = (float)1. / sx[i__];
	relstp = (r__1 = xpls[i__] - x[i__], dabs(r__1)) / dmax(r__3,r__4);
	rsx = dmax(rsx,relstp);
/* L120: */
    }
    jtrmcd = 2;
    if (rsx <= *steptl) {
	goto L600;
    }

/* CHECK ITERATION LIMIT */

    jtrmcd = 4;
    if (*itncnt >= *itnlim) {
	goto L600;
    }

/* CHECK NUMBER OF CONSECUTIVE STEPS \ STEPMX */

    if (*mxtake) {
	goto L140;
    }
/*     IF(.NOT.MXTAKE) */
/*     THEN */
    *icscmx = 0;
    return 0;
/*     ELSE */
L140:
    ++(*icscmx);
    if (*icscmx < 5) {
	return 0;
    }
    jtrmcd = 5;
/*     ENDIF */


/* PRINT TERMINATION CODE */

L600:
    *itrmcd = jtrmcd;
    if (*msg / 8 % 2 == 0) {
	switch ((int)*itrmcd) {
	    case 1:  goto L601;
	    case 2:  goto L602;
	    case 3:  goto L603;
	    case 4:  goto L604;
	    case 5:  goto L605;
	}
    }
    goto L700;
/* INSERT CALLS TO XERROR */
/* OPTSTP:  RELATIVE GRADIENT CLOSE TO ZERO. */
/*          CURRENT ITERATE IS PROBABLY SOLUTION. */
L601:
    goto L700;
/* OPTSTP:  SUCCESSIVE ITERATES WITHIN TOLERANCE. */
/*          CURRENT ITERATE IS PROBABLY SOLUTION. */
L602:
    goto L700;
/* OPTSTP:  LAST GLOBAL STEP FAILED TO LOCATE A POINT LOWER THAN X. */
/*          EITHER X IS AN APPROXIMATE LOCAL MINIMUM OF THE FUNCTION, */
/*          THE FUNCTION IS TOO NON-LINEAR FOR THIS ALGORITHM, */
/*          OR STEPTL IS TOO LARGE. */
L603:
    goto L700;
/* OPTSTP:  ITERATION LIMIT EXCEEDED.  ALGORITHM FAILED. */
L604:
    goto L700;
/* OPTSTP:  MAXIMUM STEP SIZE EXCEEDED 5 CONSECUTIVE TIMES. */
/*          EITHER THE FUNCTION IS UNBOUNDED BELOW, */
/*          BECOMES ASYMPTOTIC TO A FINITE VALUE FROM ABOVE, */
/*          OR STEPMX IS TOO SMALL */
L605:

L700:
    return 0;

} /* optstp_ */

/* Subroutine */ int qraux1_(nr, n, r__, i__)
integer *nr, *n;
real *r__;
integer *i__;
{
    /* System generated locals */
    integer r_dim1, r_offset, i__1;

    /* Local variables */
    static integer j;
    static real tmp;

/*     THIS PROLOGUE HAS BEEN REMOVED FOR REASONS OF SPACE */
/*     FOR A COMPLETE COPY OF THIS ROUTINE CONTACT THE AUTHORS */
/*     From the book "Numerical Methods and Software" */
/*          by  D. Kahaner, C. Moler, S. Nash */
/*               Prentice Hall 1988 */

    /* Parameter adjustments */
    r_dim1 = *nr;
    r_offset = 1 + r_dim1 * 1;
    r__ -= r_offset;

    /* Function Body */
    i__1 = *n;
    for (j = *i__; j <= i__1; ++j) {
	tmp = r__[*i__ + j * r_dim1];
	r__[*i__ + j * r_dim1] = r__[*i__ + 1 + j * r_dim1];
	r__[*i__ + 1 + j * r_dim1] = tmp;
/* L10: */
    }
    return 0;
} /* qraux1_ */

/* Subroutine */ int qraux2_(nr, n, r__, i__, a, b)
integer *nr, *n;
real *r__;
integer *i__;
real *a, *b;
{
    /* System generated locals */
    integer r_dim1, r_offset, i__1;

    /* Builtin functions */
    double sqrt();

    /* Local variables */
    static real c__;
    static integer j;
    static real s, y, z__, den;

/*     THIS PROLOGUE HAS BEEN REMOVED FOR REASONS OF SPACE */
/*     FOR A COMPLETE COPY OF THIS ROUTINE CONTACT THE AUTHORS */
/*     From the book "Numerical Methods and Software" */
/*          by  D. Kahaner, C. Moler, S. Nash */
/*               Prentice Hall 1988 */

    /* Parameter adjustments */
    r_dim1 = *nr;
    r_offset = 1 + r_dim1 * 1;
    r__ -= r_offset;

    /* Function Body */
    den = sqrt(*a * *a + *b * *b);
    c__ = *a / den;
    s = *b / den;
    i__1 = *n;
    for (j = *i__; j <= i__1; ++j) {
	y = r__[*i__ + j * r_dim1];
	z__ = r__[*i__ + 1 + j * r_dim1];
	r__[*i__ + j * r_dim1] = c__ * y - s * z__;
	r__[*i__ + 1 + j * r_dim1] = s * y + c__ * z__;
/* L10: */
    }
    return 0;
} /* qraux2_ */

/* Subroutine */ int qrupdt_(nr, n, a, u, v)
integer *nr, *n;
real *a, *u, *v;
{
    /* System generated locals */
    integer a_dim1, a_offset, i__1;
    real r__1;

    /* Builtin functions */
    double sqrt();

    /* Local variables */
    static integer i__, j, k;
    static real t1, t2;
    extern /* Subroutine */ int qraux1_();
    static integer ii;
    extern /* Subroutine */ int qraux2_();
    static integer km1;

/*     THIS PROLOGUE HAS BEEN REMOVED FOR REASONS OF SPACE */
/*     FOR A COMPLETE COPY OF THIS ROUTINE CONTACT THE AUTHORS */
/*     From the book "Numerical Methods and Software" */
/*          by  D. Kahaner, C. Moler, S. Nash */
/*               Prentice Hall 1988 */


/* DETERMINE LAST NON-ZERO IN U(.) */

    /* Parameter adjustments */
    a_dim1 = *nr;
    a_offset = 1 + a_dim1 * 1;
    a -= a_offset;
    --v;
    --u;

    /* Function Body */
    k = *n;
L10:
    if (u[k] != (float)0. || k == 1) {
	goto L20;
    }
/*     IF(U(K).EQ.0. .AND. K.GT.1) */
/*     THEN */
    --k;
    goto L10;
/*     ENDIF */

/* (K-1) JACOBI ROTATIONS TRANSFORM */
/*     R + U(V+) --> (R*) + (U(1)*E1)(V+) */
/* WHICH IS UPPER HESSENBERG */

L20:
    if (k <= 1) {
	goto L40;
    }
    km1 = k - 1;
    i__1 = km1;
    for (ii = 1; ii <= i__1; ++ii) {
	i__ = km1 - ii + 1;
	if (u[i__] != (float)0.) {
	    goto L25;
	}
/*         IF(U(I).EQ.0.) */
/*         THEN */
	qraux1_(nr, n, &a[a_offset], &i__);
	u[i__] = u[i__ + 1];
	goto L30;
/*         ELSE */
L25:
	r__1 = -u[i__ + 1];
	qraux2_(nr, n, &a[a_offset], &i__, &u[i__], &r__1);
	u[i__] = sqrt(u[i__] * u[i__] + u[i__ + 1] * u[i__ + 1]);
/*         ENDIF */
L30:
	;
    }
/*     ENDIF */

/* R <-- R + (U(1)*E1)(V+) */

L40:
    i__1 = *n;
    for (j = 1; j <= i__1; ++j) {
	a[j * a_dim1 + 1] += u[1] * v[j];
/* L50: */
    }

/* (K-1) JACOBI ROTATIONS TRANSFORM UPPER HESSENBERG R */
/* TO UPPER TRIANGULAR (R*) */

    if (k <= 1) {
	goto L100;
    }
    km1 = k - 1;
    i__1 = km1;
    for (i__ = 1; i__ <= i__1; ++i__) {
	if (a[i__ + i__ * a_dim1] != (float)0.) {
	    goto L70;
	}
/*         IF(A(I,I).EQ.0.) */
/*         THEN */
	qraux1_(nr, n, &a[a_offset], &i__);
	goto L80;
/*         ELSE */
L70:
	t1 = a[i__ + i__ * a_dim1];
	t2 = -a[i__ + 1 + i__ * a_dim1];
	qraux2_(nr, n, &a[a_offset], &i__, &t1, &t2);
/*         ENDIF */
L80:
	;
    }
/*     ENDIF */
L100:
    return 0;
} /* qrupdt_ */

/* Subroutine */ int sclmul_(n, s, v, z__)
integer *n;
real *s, *v, *z__;
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    static integer i__;

/*     THIS PROLOGUE HAS BEEN REMOVED FOR REASONS OF SPACE */
/*     FOR A COMPLETE COPY OF THIS ROUTINE CONTACT THE AUTHORS */
/*     From the book "Numerical Methods and Software" */
/*          by  D. Kahaner, C. Moler, S. Nash */
/*               Prentice Hall 1988 */

    /* Parameter adjustments */
    --z__;
    --v;

    /* Function Body */
    i__1 = *n;
    for (i__ = 1; i__ <= i__1; ++i__) {
	z__[i__] = *s * v[i__];
/* L100: */
    }
    return 0;
} /* sclmul_ */

/* Subroutine */ int secfac_(nr, n, x, g, a, xpls, gpls, epsm, itncnt, rnf, 
	iagflg, noupdt, s, y, u, w)
integer *nr, *n;
real *x, *g, *a, *xpls, *gpls, *epsm;
integer *itncnt;
real *rnf;
integer *iagflg;
logical *noupdt;
real *s, *y, *u, *w;
{
    /* System generated locals */
    integer a_dim1, a_offset, i__1, i__2;
    real r__1, r__2, r__3, r__4, r__5;

    /* Builtin functions */
    double sqrt();

    /* Local variables */
    extern doublereal sdot_(), snrm2_();
    static real ynrm2;
    static integer i__, j;
    static real snorm2, reltol;
    static logical skpupd;
    static integer im1;
    extern /* Subroutine */ int mvmltl_(), qrupdt_(), mvmltu_();
    static real alp, den1, den2;

/*     THIS PROLOGUE HAS BEEN REMOVED FOR REASONS OF SPACE */
/*     FOR A COMPLETE COPY OF THIS ROUTINE CONTACT THE AUTHORS */
/*     From the book "Numerical Methods and Software" */
/*          by  D. Kahaner, C. Moler, S. Nash */
/*               Prentice Hall 1988 */


    /* Parameter adjustments */
    a_dim1 = *nr;
    a_offset = 1 + a_dim1 * 1;
    a -= a_offset;
    --w;
    --u;
    --y;
    --s;
    --gpls;
    --xpls;
    --g;
    --x;

    /* Function Body */
    if (*itncnt == 1) {
	*noupdt = TRUE_;
    }
    i__1 = *n;
    for (i__ = 1; i__ <= i__1; ++i__) {
	s[i__] = xpls[i__] - x[i__];
	y[i__] = gpls[i__] - g[i__];
/* L10: */
    }
    den1 = sdot_(n, &s[1], &c__1, &y[1], &c__1);
    snorm2 = snrm2_(n, &s[1], &c__1);
    ynrm2 = snrm2_(n, &y[1], &c__1);
    if (den1 < sqrt(*epsm) * snorm2 * ynrm2) {
	goto L110;
    }
/*     IF(DEN1.GE.SQRT(EPSM)*SNORM2*YNRM2) */
/*     THEN */
    mvmltu_(nr, n, &a[a_offset], &s[1], &u[1]);
    den2 = sdot_(n, &u[1], &c__1, &u[1], &c__1);

/*       L <-- SQRT(DEN1/DEN2)*L */

    alp = sqrt(den1 / den2);
    if (! (*noupdt)) {
	goto L50;
    }
/*       IF(NOUPDT) */
/*       THEN */
    i__1 = *n;
    for (j = 1; j <= i__1; ++j) {
	u[j] = alp * u[j];
	i__2 = *n;
	for (i__ = j; i__ <= i__2; ++i__) {
	    a[i__ + j * a_dim1] = alp * a[i__ + j * a_dim1];
/* L20: */
	}
/* L30: */
    }
    *noupdt = FALSE_;
    den2 = den1;
    alp = (float)1.;
/*       ENDIF */
L50:
    skpupd = TRUE_;

/*       W = L(L+)S = HS */

    mvmltl_(nr, n, &a[a_offset], &u[1], &w[1]);
    i__ = 1;
    if (*iagflg != 0) {
	goto L55;
    }
/*       IF(IAGFLG.EQ.0) */
/*       THEN */
    reltol = sqrt(*rnf);
    goto L60;
/*       ELSE */
L55:
    reltol = *rnf;
/*       ENDIF */
L60:
    if (i__ > *n || ! skpupd) {
	goto L70;
    }
/*       IF(I.LE.N .AND. SKPUPD) */
/*       THEN */
/* Computing MAX */
    r__4 = (r__1 = g[i__], dabs(r__1)), r__5 = (r__2 = gpls[i__], dabs(r__2));
    if ((r__3 = y[i__] - w[i__], dabs(r__3)) < reltol * dmax(r__4,r__5)) {
	goto L65;
    }
/*         IF(ABS(Y(I)-W(I)) .GE. RELTOL*AMAX1(ABS(G(I)),ABS(GPLS(I)))) */
/*         THEN */
    skpupd = FALSE_;
    goto L60;
/*         ELSE */
L65:
    ++i__;
    goto L60;
/*         ENDIF */
/*       ENDIF */
L70:
    if (skpupd) {
	goto L110;
    }
/*       IF(.NOT.SKPUPD) */
/*       THEN */

/*         W=Y-ALP*L(L+)S */

    i__1 = *n;
    for (i__ = 1; i__ <= i__1; ++i__) {
	w[i__] = y[i__] - alp * w[i__];
/* L75: */
    }

/*         ALP=1/SQRT(DEN1*DEN2) */

    alp /= den1;

/*         U=(L+)/SQRT(DEN1*DEN2) = (L+)S/SQRT((Y+)S * (S+)L(L+)S) */

    i__1 = *n;
    for (i__ = 1; i__ <= i__1; ++i__) {
	u[i__] = alp * u[i__];
/* L80: */
    }

/*         COPY L INTO UPPER TRIANGULAR PART.  ZERO L. */

    if (*n == 1) {
	goto L93;
    }
    i__1 = *n;
    for (i__ = 2; i__ <= i__1; ++i__) {
	im1 = i__ - 1;
	i__2 = im1;
	for (j = 1; j <= i__2; ++j) {
	    a[j + i__ * a_dim1] = a[i__ + j * a_dim1];
	    a[i__ + j * a_dim1] = (float)0.;
/* L85: */
	}
/* L90: */
    }

/*         FIND Q, (L+) SUCH THAT  Q(L+) = (L+) + U(W+) */

L93:
    qrupdt_(nr, n, &a[a_offset], &u[1], &w[1]);

/*         UPPER TRIANGULAR PART AND DIAGONAL OF A NOW CONTAIN UPDATED */
/*         CHOLESKY DECOMPOSITION OF HESSIAN.  COPY BACK TO LOWER */
/*         TRIANGULAR PART. */

    if (*n == 1) {
	goto L110;
    }
    i__1 = *n;
    for (i__ = 2; i__ <= i__1; ++i__) {
	im1 = i__ - 1;
	i__2 = im1;
	for (j = 1; j <= i__2; ++j) {
	    a[i__ + j * a_dim1] = a[j + i__ * a_dim1];
/* L95: */
	}
/* L100: */
    }
/*       ENDIF */
/*     ENDIF */
L110:
    return 0;
} /* secfac_ */

