/* Genetischer Algorithmus zur optimierung der Landnutzung. Allelen
   Konstruktion stellt Landnutzungskennungen dar. Dabei beschreibt das
   Genom nur die nderung gegenber einer vorher berechneten
   Landnutzung. Dazu verwendet die initialisierung einen zweistufigen
   stochastischen Proze: z1 ist die Variable, die aussagt, ob eine
   Modifikation im String vorgenommen werden soll, danach wird die
   entsprechende nuee Landnutzung gleichverteilt bestimmt.*/

#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>
#include <math.h>
#include <unistd.h>
#include <ga/ga.h>
#include <ga/garandom.h>

#define PROJECT         "HUNT0"
#define MODEL           "HNMD"
#define WRITE_MAP_IT    1
#define SME_IN_LU       "CropData"                        /* exchange file to SME */
#define SME_IN_F        "FertData"                        /* exchange file to SME */

#define SME_OUTPUT      "GoalFunctionProtocol"            /* exchange file from SME */
#define NO_COLUMN       15	                   /* No. of Cols. in exchange file from SME */
#define GF_COLUMN       10                         /* Column with Perf. crit */


#define PROJECT_PATH   "../../"
// #define PROJECT_PATH   "/data/Projects/HUNT0/"

#define LOG_FILE        "galu.log"
#define MAX_LENGTH      1700

#define WATER           1
#define FOREST          2
#define AGRI            3
#define FALLOW          6
#define CORN            7
#define WHEAT           8
#define SOY             9


char scenario[255];
char run[255];
char init_lu[255];
char init_fert_file[255];
char run_lu[255];
char run_fert[255];
float p0_mc;

FILE *inf;
FILE *inf1;
FILE *inf2;
FILE *lfp;

static int loop_count = 0;

void fatal(char* fn)
{
  printf("cannot open/write %s\n", fn);
  exit(0);
}


float fert_allel[] = { 0.0, 25.0, 50.0, 75.0, 100.0, 150.0 };
#define NO_FERT_ALLEL 6
float init_fert[MAX_LENGTH];

float objective(GAGenome &);
void TwoStageInitializer(GAGenome &);



int main(int argc, char *argv[])
{
  int length;
  unsigned int seed = 0;
  char wrkstr[255];
  if (argc<5)
    {
      printf("usage mc <scenario> <run> <map> <p>\n");
      printf("  <scenario> scenraio identifer (see SME)\n");
      printf("  <run>      identifer of optimization run\n");
      printf("  <map>=0..9 number of map, written bei gridopt\n");
      printf("  <p>=0..1   probability of initial disturbance of solution\n");
      exit(1);
    }


  // remove log-file
  system("/bin/rm -f gasme.log");

  // init SME
  /*
  wrkstr[0] = '\0';
  strcat(wrkstr, "SME project ");
  strcat(wrkstr, PROJECT);
  strcat(wrkstr, " ~/HUNT0");
  system(wrkstr);
  */

  wrkstr[0] = '\0';
  strcat(wrkstr, "SME model ");
  strcat(wrkstr, MODEL);
  strcat(wrkstr, " >> gasme.log");
  system(wrkstr);

  wrkstr[0] = '\0';
  strcat(wrkstr, "SME scenario ");
  strcat(wrkstr, scenario);
  strcat(wrkstr, " >> gasme.log");
  system(wrkstr);



  scenario[0] = '\0';
  strcat(scenario, argv[1]);
  run[0] = '\0';
  strcat(run, argv[2]);

  init_lu[0] =  '\0';
  strcat(init_lu, PROJECT_PATH); strcat(init_lu, "Data/OptMaps/");
  strcat(init_lu, argv[1]); strcat(init_lu, argv[2]);
  strcat(init_lu, "/"); strcat(init_lu, SME_IN_LU);
  strcat(init_lu, argv[3]);

  run_lu[0] ='\0';
  strcat(run_lu, PROJECT_PATH); strcat(run_lu, "Data/");
  strcat(run_lu, SME_IN_LU);

  init_fert_file[0] = '\0';
  strcat(init_fert_file, PROJECT_PATH); strcat(init_fert_file, "Data/OptMaps/");
  strcat(init_fert_file, argv[1]); strcat(init_fert_file, argv[2]);
  strcat(init_fert_file, "/"); strcat(init_fert_file, SME_IN_F);
  strcat(init_fert_file, argv[3]);

  run_fert[0] ='\0';
  strcat(run_fert, PROJECT_PATH); strcat(run_fert, "Data/");
  strcat(run_fert, SME_IN_F);

  sscanf(argv[4], "%f", &p0_mc);

  printf("Initfile %s %s\n", init_lu, init_fert_file);
  printf("SME file %s %s\n", run_lu, run_fert);
  printf("modification probability of initial generation: %4.2f\n", p0_mc);

  // This is where we Start, may be derived from stochastig generation of from 
  // local decision.


 
  lfp = fopen(LOG_FILE, "w");
 
  int aset[] = {20, 60, 
		70, 71, 72, 73, 74, 75, 
		80, 81, 82, 83, 84, 85,
		90, 91, 92, 93, 94, 95};

  GAAlleleSet<int> alleles(20, aset);

  inf = fopen(init_lu, "r");
  if (inf == NULL) fatal(init_lu);

  fscanf(inf, "%d", &length);
  fclose(inf);

  GA1DArrayAlleleGenome<int> genome(length, alleles, objective);

  genome.initializer(TwoStageInitializer);

  genome.mutator(GA1DArrayAlleleGenome<int>::FlipMutator);
  genome.crossover(GA1DArrayGenome<int>::OnePointCrossover);

  GASimpleGA ga(genome);


  cout << "population size " << ga.populationSize() << endl; 
  GASigmaTruncationScaling trunc;
  ga.scaling(trunc);
  // read these parameters from settings.txt
  // ga.set(gaNpopulationSize, 10);
  // ga.set(gaNpCrossover, 0.6); 
  // ga.set(gaNpMutation, 0.001);
  // ga.set(gaNnGenerations, 100);
  // ga.set(gaNpReplacement, 0.25);
  ga.terminator(GAGeneticAlgorithm::TerminateUponGeneration);

  ga.parameters("settings.txt");
  ga.parameters(argc, argv);
  ga.initialize(seed);
  

  cout << "the ga initiated:\n" << ga.statistics().bestIndividual() << endl;
  cout << "population size " << ga.populationSize() << endl; 
  cout << "evolving...";
  while(!ga.done()){
    ga.step();
    if(ga.generation() % 5 == 0){
      cout << "best individual so far:\n" << ga.statistics().bestIndividual() << endl;
    }
  }
  cout << "\n\n";

  cout << "the ga generated:\n" << ga.statistics().bestIndividual() << endl;

  fclose(lfp);
  return 0;
}


//
// Initilizer:
// swo-staged process:
// Z = {0,1} changing the initial gene? P(Z=0) > P(Z=1)
// Z = {0,1,2,3, 4} change of intital gene
void 
TwoStageInitializer(GAGenome & c) 
{
  int count, l1;
  float p0[5];
  float r;

  int lu[MAX_LENGTH];

  char wrkstr[255];

  GA1DArrayAlleleGenome<int> & genome = (GA1DArrayAlleleGenome<int> &)c;

  inf1 = fopen(init_lu, "r");
  if (inf1 == NULL) fatal(init_lu);

  fscanf(inf1, "%d", &count);

  inf2 = fopen(init_fert_file, "r");
  if (inf2 == NULL) fatal(init_lu);


  fscanf(inf2, "%d", &count);

  int nr_w = int(count*0.01);
  int nr_c = int(count*0.01);
  int nr_s = int(count*0.01);
  int nr_fa = int(count*0.01);
  int nr_fo = int(count*0.01);

  for (int i=0; i<count; i++)
    {
      fscanf(inf2, " %f", &init_fert[i]);
      fscanf(inf1, " %d", &lu[i]);
      switch (lu[i])
	{
	case CORN:
	  nr_c++;
	  break;
	case WHEAT:
	  nr_w++;
	  break;
	case SOY:
	  nr_s++;
	  break;
	case FOREST:
	  nr_fo++;
	  break;
	case FALLOW:
	  nr_fa++;
	  break;
	}
    }

  /* ga from scratch */
  if (p0_mc>1.0)
    {
      float psum = 0.0;
      
      for(int i=0; i<5; i++)
	p0[i] = GARandomFloat();
      for(int i=0; i<5; i++)
	psum += p0[i];
      for(int i=0; i<5; i++)
	p0[i] = p0[i] / psum;
    }
  else
    {
      p0[0] = nr_fa/(double)(nr_c+nr_w+nr_s+nr_fa+nr_fo);
      p0[1] = nr_c/(double)(nr_c+nr_w+nr_s+nr_fa+nr_fo);
      p0[2] = nr_w/(double)(nr_c+nr_w+nr_s+nr_fa+nr_fo);
      p0[3] = nr_s/(double)(nr_c+nr_w+nr_s+nr_fa+nr_fo);
      p0[4] = nr_fo/(double)(nr_c+nr_w+nr_s+nr_fa+nr_fo);
    } 

  // p[i] is discrete denisity function,
  // now calculate distribution function
  for (int i=1; i<5; i++)
    p0[i] += p0[i-1];
    
  for(int i=0; i<genome.length(); i++)
    {
      float z1 = GARandomFloat();
      l1 = lu[i];

      if (z1 <= p0_mc)
	{
	  r = GARandomFloat();
	  l1 = 6;
	  for(int j=0; j<4; j++)
	    if(r>p0[j])
	      l1 = (int)(j+7);
	  
	  if (l1 == 10)
	    l1 = 2;

	  if (l1>6)
	    {
	      float z3 = GARandomFloat();
	      z3 = z3 * 100.0;
	      int l2 = l1*10+(((int)z3) % NO_FERT_ALLEL); 
	      genome.gene(i, l2);
	    }
	  else
	    genome.gene(i, l1*10);	  
  	}
      else
	{
	  int j0 = 0;
	  for (int j=0; j<NO_FERT_ALLEL; j++)
	    {
	      if (fert_allel[j] == init_fert[i])
		j0 = j;
	    }
	  genome.gene(i, l1*10+j0);	  
	}
    }
  fclose(inf1);
  fclose(inf2);
}  
 

// run SME
// important: make shure we're on the right project, model, scenrio
void
run_sme()
{
  char wrkstr[255];

  system("cat ../../Data/FertData >> gasme.log");
  system("cat ../../Data/CropData >> gasme.log");

  system("SME -batch run >> gasme.log");

  wrkstr[0] = '\0';
  strcat(wrkstr, "tail -1 ");
  strcat(wrkstr, PROJECT_PATH);
  strcat(wrkstr, "DriverOutput/GoalFunctionProtocol >> ");
  strcat(wrkstr, PROJECT_PATH);
  strcat(wrkstr, "/DriverOutput/ga.dat");
  system(wrkstr);
}



// SME Anbindung im Getefunktional. 

float
objective(GAGenome & c)
{
  GA1DArrayAlleleGenome<int> & genome = (GA1DArrayAlleleGenome<int> &)c;
  
  // todo: write out CropData File of current GEnome
  //       start SME
  //       read in last line of Goal Function Protocol and select perf crit.
  //       return als value

  ofstream outfile;
  char wrkstr[255], ws2[20];
  float value, x;
  FILE *rfp;  
  FILE *wfp1;
  FILE *wfp2;

  loop_count++;

  // 1. Akt: write current gene to CropData input file of SME

  wfp1 = fopen(run_lu, "w");
  wfp2 = fopen(run_fert, "w");


  fprintf(wfp1,"%d\n", genome.length());
  fprintf(wfp2,"%d\n", genome.length());

  for(int i=0; i<genome.length(); i++)
    {
      fprintf(wfp1, " %d", (int)(genome.gene(i)/10));	  
      if (genome.gene(i) > 60)
	x = fert_allel[(genome.gene(i) % 10)];
      else
	x = 0.0;
      fprintf(wfp2, " %5.1f", x);	  
    }
  fclose(wfp1);
  fclose(wfp2);

  run_sme();

  // Intermezzo alle WRITE_MAP_IT Iterationsschritte die Aktuellen Karten wegschreiben

  if ((loop_count % WRITE_MAP_IT)==0)
    {
      printf("logging maps %s %s\n", scenario, run);
      wrkstr[0] ='\0';
      strcat(wrkstr, "cp_ga_maps ");
      strcat(wrkstr, scenario);
      strcat(wrkstr, " ");
      strcat(wrkstr, run);
      sprintf(ws2, " %d", loop_count);
      strcat(wrkstr, ws2);
      system(wrkstr);
    }


  // 3. Akt: get last line of SME Output File

  system("/bin/rm smeout.tmp");

  wrkstr[0] = '\0';
  strcat(wrkstr, "tail -1 ");
  strcat(wrkstr, PROJECT_PATH);
  strcat(wrkstr, "DriverOutput/");
  strcat(wrkstr, SME_OUTPUT);
  strcat(wrkstr, " > smeout.tmp");
    
  system(wrkstr);

  // 4. Readin Outputfile results
  rfp = fopen("smeout.tmp", "r");

  fprintf(lfp, "%3d ", loop_count);

  if (rfp != NULL)
    {
      for(int i=0; i<=NO_COLUMN; i++)
	{
	  fscanf(rfp, " %f", &x);

	  if (i>0)		// ignore time
	    fprintf(lfp, "%8.6f ", x);

	  if (i == GF_COLUMN)
	    value = 1000.0*(x+4.702);

	}
      fprintf(lfp, "%6.3f \n", value);
      fclose(rfp);
    }
  else
    {
      cerr << "Cannot open smeout.tmp for output.\n";
      exit(1);  
    }
  fflush(lfp);

  return(value);
}



// Here we override the built-in write method for the 1DArray genome so
// that we get better spacing.  The default just stacks the characters one
// after another.  Here we do fixed spacing so that the -1 and 1 don't screw
// each other up.

int
GA1DArrayAlleleGenome<int>::write(ostream & os) const 
{
  os << nx << "\n";
  
  for(unsigned int i=0; i<nx; i++){
    os.width(4);
    os << gene(i);
  }
  os << "\n";

  return os.fail() ? 1 : 0;
}


// If your compiler does not do automatic instantiation (e.g. g++ 2.6.8),
// then define the NO_AUTO_INST directive.
#ifdef NO_AUTO_INST
#include <ga/GAAllele.C>
#include <ga/GA1DArrayGenome.C>
#if defined(__GNUG__)
template class GAAlleleSet<int>;
template class GAAlleleSetCore<int>;
template class GAArray<int>;
template class GA1DArrayGenome<int>;
template class GA1DArrayAlleleGenome<int>;
#else
GAAlleleSet<int>;
GAAlleleSetCore<int>;
GAArray<int>;
GA1DArrayGenome<int>;
GA1DArrayAlleleGenome<int>;
#endif
#endif



