
/* Diese Programm soll die lokae Entscheidung realisieren,
 * wir lesen die entsprechenden Maps ein, und zwar
 * - ausgehend von der Habitatmap, werden
 * - die sf?? y?? files gelesen und die lokae entscheidung aus UCOde.cc
 *   realisiert.
 * - In abhngigkeit  Parameterkonstellationen werden 
 *   dann eine ganze Reihe mglicher karten im ArcView und im GA/SME transfer
 *   format geschreiben
 * Und wenn Du Zeit hast, kannst Du das auch hbsch machen, d.h. ber den 
 * Dialog Designer in ArcView einbinden und als Projekt vielleicht sogar
 * fr den ganzen Patuxent verkaufen! 
 */

#include "../smeopt/smeopt.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <math.h>


/* gnu-c on solaris does not like to hold 17MByte static in 
 * a local function (e.g. main())
 * so here are al function global again, sorry. */


float sfw[MAX_LAYER][MAX_ROWS][MAX_COLS];
float sfw[MAX_LAYER][MAX_ROWS][MAX_COLS];
float sfc[MAX_LAYER][MAX_ROWS][MAX_COLS];
float sfs[MAX_LAYER][MAX_ROWS][MAX_COLS];
float sffa[MAX_ROWS][MAX_COLS];
float sffo[MAX_ROWS][MAX_COLS];

float yw[MAX_LAYER][MAX_ROWS][MAX_COLS];
float yc[MAX_LAYER][MAX_ROWS][MAX_COLS];
float ys[MAX_LAYER][MAX_ROWS][MAX_COLS];

float jmin_map[MAX_ROWS][MAX_COLS];
float jmax_map[MAX_ROWS][MAX_COLS];

float sfc[MAX_LAYER][MAX_ROWS][MAX_COLS];
float sfs[MAX_LAYER][MAX_ROWS][MAX_COLS];
float sffa[MAX_ROWS][MAX_COLS];
float sffo[MAX_ROWS][MAX_COLS];

float yw[MAX_LAYER][MAX_ROWS][MAX_COLS];
float yc[MAX_LAYER][MAX_ROWS][MAX_COLS];
float ys[MAX_LAYER][MAX_ROWS][MAX_COLS];
  
  float jmin_map[MAX_ROWS][MAX_COLS];
  float jmax_map[MAX_ROWS][MAX_COLS];


int main(int argc, char *argv[])
{
  char in_map_dir[255];
  char out_map_dir[255];
  char par_dir[255];
  char data_dir[255];
  char arcview_map_dir[255];
  
  int nr_c, nr_w, nr_s, nr_fa, nr_fo;
  float sum_fert;
  
  FILE *cfp;
  FILE *wfp;
  FILE *hfp;
  FILE *ffp;
  
  float draw_map[30];
  float lambda_step, to_lambda;
  int cur_map, no_maps;
  
  int hab[MAX_ROWS][MAX_COLS];
  int nohab;
  int no_habs, count_habs;
  
  int hab1[MAX_ROWS][MAX_COLS];
  float fert1[MAX_ROWS][MAX_COLS];
  
  float reg_jmax, reg_jmin, reg_jsum;
  
  
  int i, j, ncols, nrows;
  float xll, yll, cells;
  char fn[255];

  char idx[2];
  
  /* szenario auslesen und entsprechende Verzeichnisstring aufbauen */
  
  if (argc<2)
    {
      printf("usage gridopt.exe <scenario> <run> \n");
      printf("      gridopt.exe <scenario> <run> <lambda>\n");
      exit(1);
    }
  
  in_map_dir[0] = '\0'; strcat(in_map_dir, IN_MAPS_PATH);
  out_map_dir[0] = '\0'; strcat(out_map_dir, OUT_MAPS_PATH);
  arcview_map_dir[0] = '\0'; strcat(arcview_map_dir, OUT_MAPS_PATH);
  par_dir[0] = '\0'; strcat(par_dir, PARAM_PATH);
  data_dir[0] = '\0'; strcat(data_dir, SME_DATA_PATH);
  
  strcat(in_map_dir, argv[1]); strcat(in_map_dir, argv[2]); strcat(in_map_dir, "/");
  strcat(data_dir, argv[1]); strcat(data_dir, argv[2]); strcat(data_dir, "/");
  strcat(out_map_dir, argv[1]); strcat(out_map_dir, argv[2]); strcat(out_map_dir, "/");

  printf("set up directory structure:\n");
  printf("map input:%s\nmap output:%s\nparameter:%s\ndata:%s\nArcVIEW:%s\n",
	 in_map_dir, out_map_dir, par_dir, data_dir, arcview_map_dir);

  /* Einlesen der Karten */

  make_fn(fn, "habmapdb", in_map_dir);
  read_arcinfo_int_grid(fn, &ncols, &nrows, &xll, &yll, &cells, &nohab, hab);

  read_multilayer_float_map(in_map_dir, "sfc", 0.0001, sfc, 6);  
  read_multilayer_float_map(in_map_dir, "sfw", 0.0001, sfw, 6);  
  read_multilayer_float_map(in_map_dir, "sfs", 0.0001, sfs, 6);  
  read_multilayer_float_map(in_map_dir, "yc", 0.0001, yc, 6);  
  read_multilayer_float_map(in_map_dir, "ys", 0.0001, ys, 6);  
  read_multilayer_float_map(in_map_dir, "yw", 0.0001, yw, 6);  

  make_fn(fn, "sffo0", in_map_dir);
  read_arcinfo_float_grid(fn, 0.0001, &ncols, &nrows, 
			  &xll, &yll, &cells, sffo);

  make_fn(fn, "sffa0", in_map_dir);
  read_arcinfo_float_grid(fn, 0.0001, &ncols, &nrows, 
			  &xll, &yll, &cells, sffa);

  if (argc == 4)
    {
      sscanf(argv[3], "%g", &lambda_n);

      printf("generating maps for ArcView\nlambda_n= %6.2f\n", lambda_n);


      /* Warum hier nicht auch SME Karten Erstelen und im Anschlu SME Rechnung durchfhren? */

      calculate_optimum(sfc, sfs, sfw, sffa, sffo, yc, ys, yw, hab, ncols, nrows, 6, nohab,
			hab1, fert1, jmin_map, jmax_map, &count_habs,
			&nr_c, &nr_s, &nr_w, &nr_fa, &nr_fo, &sum_fert);
		
      make_fn(fn, "habmap", arcview_map_dir);
      strcat(fn, ".asc");
      write_arcinfo_int_grid(fn, ncols, nrows, xll, yll, cells, 
			     nohab, hab1);	
      
      make_fn(fn, "fertmap", arcview_map_dir);
      strcat(fn, ".asc");
      write_arcinfo_float_grid(fn, ncols, nrows, xll, yll, cells, 
			       NODATA, fert1);	

      
      make_fn(fn, "jmin", arcview_map_dir);
      strcat(fn, ".asc");
      write_arcinfo_float_grid(fn, ncols, nrows, xll, yll, cells, 
			       NODATA, jmin_map);	

      make_fn(fn, "jmax", arcview_map_dir);
      strcat(fn, ".asc");
      
      write_arcinfo_float_grid(fn, ncols, nrows, xll, yll, cells, 
			       NODATA, jmax_map);	
    }
  else
    {
      printf("drawing maps for lambda_n = ");
      
      make_fn(fn, argv[1], par_dir);
      strcat(fn, argv[2]);
      strcat(fn, ".par");
      cfp = fopen(fn, "r");
      if (cfp == NULL)
	{
	  printf("cannot open %s\n", fn);
	  exit(0);
	}
      
      i = -1;
      do
	{
	  fscanf(cfp, "%f", &draw_map[++i]);
	  if (draw_map[i]> -1.0)
	    printf("%g ", draw_map[i]);
	}
      while (draw_map[i] > -1.0);
      no_maps = (i < 10 ? i : 9);
      
      printf("\n");
      
      make_fn(fn, "habitat.dat", OUT_DATA_PATH);
      wfp = fopen(fn, "w");
      if (wfp == NULL) fatal(fn);

      fprintf(wfp, "lambda_n #c #s #w #fa #fo fert #agri jmin jmax jsum\n");
      
      lambda_n = 0.0;
      cur_map = 0;
      no_habs = 0;
      count_habs = 0;
      idx[0] = '0';
      idx[1] = '\0';

      printf("calculation habitats lambda_n = ");
      while (fscanf(cfp, "%f %f \n", &to_lambda, &lambda_step) != EOF)
	for (; lambda_n<to_lambda; lambda_n += lambda_step)
	  {
	    printf("%g ", lambda_n); fflush(stdout);
	    
	    calculate_optimum(sfc, sfs, sfw, sffa, sffo, 
			      yc, ys, yw, 
			      hab, 
			      ncols, nrows, 6, nohab,
			      hab1, fert1, jmin_map, jmax_map, &count_habs,
			      &nr_c, &nr_s, &nr_w, &nr_fa, &nr_fo, &sum_fert);

	    if (!(no_habs))
	      no_habs = count_habs;
	    
	    fprintf(wfp, "%g %6d  %6d  %6d  %6d  %6d  %6.2f %6d %8.2f %8.2f %8.2f\n", 
		    lambda_n, nr_c, nr_s, nr_w, nr_fa, nr_fo, 
		    sum_fert/(double)(nr_c+nr_s+nr_w), nr_c+nr_s+nr_w, reg_jmin, reg_jmax, reg_jsum);
	    
	    if ((lambda_n>=draw_map[cur_map]) && (cur_map < no_maps))
	      {
		printf("no_habs %d\n", no_habs);
		printf("\n");
		fn[0] = '\0';
		strcat(fn, data_dir);
		strcat(fn, "CropData");
		strcat(fn, idx);
		hfp = fopen(fn, "w");
		if (hfp == NULL) 
		  fatal(fn);

		fn[0] = '\0';
		strcat(fn, data_dir);
		strcat(fn, "FertData");
		strcat(fn, idx);
		ffp = fopen(fn, "w");
		if (ffp == NULL) 
		  fatal(fn);

		fprintf(hfp, " %d\n", no_habs);
		fprintf(ffp, " %d\n", no_habs);
		for (i=0; i<nrows; i++)
		  for (j=0; j<ncols; j++)
		    if (is_control(hab1[i][j]))
		      {
			fprintf(hfp, " %d", hab1[i][j]);
			fprintf(ffp, " %5.1f", fert1[i][j]);
		      }
		
		fprintf(hfp, "\n");
		fclose(hfp);
		fprintf(ffp, "\n");
		fclose(ffp);
		
		make_fn(fn, "habmap", out_map_dir);
		strcat(fn, idx);
		strcat(fn, ".asc");
		write_arcinfo_int_grid(fn, ncols, nrows, xll, yll, cells, 
				       nohab, hab1);	
		
       		make_fn(fn, "fertmap", out_map_dir);
		strcat(fn, idx);
		strcat(fn, ".asc");
		write_arcinfo_float_grid(fn, ncols, nrows, xll, yll, cells, 
					 NODATA, fert1);	
		
		make_fn(fn, "jmin", out_map_dir);
		strcat(fn, idx);
		strcat(fn, ".asc");
		write_arcinfo_float_grid(fn, ncols, nrows, xll, yll, cells, 
					 NODATA, jmin_map);	
		make_fn(fn, "jmax", out_map_dir);
		strcat(fn, idx);
		strcat(fn, ".asc");
		
		write_arcinfo_float_grid(fn, ncols, nrows, xll, yll, cells, 
					 NODATA, jmax_map);	
		
		cur_map++;
		idx[0]++;
	      }
	  }
      fclose(cfp);
      fclose(wfp);
    }

  printf("\n");
      
  return 0;		      
}





