/* 
 * file: gridopt2.c
 * author: r.s.
 * date: 8/2001
 * aim: more general land use patter optimization based on
 *  - leaching nutrien 
 *  - surface run-of of nutrients
 *  - net primary production
 *  - co2 - fixcation
 *  - agroeconomic yield
 *  - fertilizer input
 */

#include "../smeopt/smeopt.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <math.h>


/* gnu-c on solaris does not like to hold 17MByte static in 
 * a local function (e.g. main())
 * so here are al function global again, sorry. */

float co2w[MAX_LAYER][MAX_ROWS][MAX_COLS];
float co2c[MAX_LAYER][MAX_ROWS][MAX_COLS];
float co2s[MAX_LAYER][MAX_ROWS][MAX_COLS];
float co2fa[MAX_ROWS][MAX_COLS];
float co2fo[MAX_ROWS][MAX_COLS];

float nppw[MAX_LAYER][MAX_ROWS][MAX_COLS];
float nppc[MAX_LAYER][MAX_ROWS][MAX_COLS];
float npps[MAX_LAYER][MAX_ROWS][MAX_COLS];
float nppfa[MAX_ROWS][MAX_COLS];
float nppfo[MAX_ROWS][MAX_COLS];

float sdw[MAX_LAYER][MAX_ROWS][MAX_COLS];
float sdc[MAX_LAYER][MAX_ROWS][MAX_COLS];
float sds[MAX_LAYER][MAX_ROWS][MAX_COLS];
float sdfa[MAX_ROWS][MAX_COLS];
float sdfo[MAX_ROWS][MAX_COLS];

float sfw[MAX_LAYER][MAX_ROWS][MAX_COLS];
float sfc[MAX_LAYER][MAX_ROWS][MAX_COLS];
float sfs[MAX_LAYER][MAX_ROWS][MAX_COLS];
float sffa[MAX_ROWS][MAX_COLS];
float sffo[MAX_ROWS][MAX_COLS];

float yw[MAX_LAYER][MAX_ROWS][MAX_COLS];
float yc[MAX_LAYER][MAX_ROWS][MAX_COLS];
float ys[MAX_LAYER][MAX_ROWS][MAX_COLS];

float jmin_map[MAX_ROWS][MAX_COLS];
float jmax_map[MAX_ROWS][MAX_COLS];

int main(int argc, char *argv[])
{
  char in_map_dir[255];
  char out_map_dir[255];
  char par_dir[255];
  char data_dir[255];
  char arcview_map_dir[255];
  
  int nr_c, nr_w, nr_s, nr_fa, nr_fo;
  float sum_fert;
  
  FILE *cfp;
  FILE *wfp;
  FILE *hfp;
  FILE *ffp;
  
  float draw_map[30];
  float lambda_step, to_lambda;
  int cur_map, no_maps;
  
  int hab[MAX_ROWS][MAX_COLS];
  int nohab;
  int no_habs, count_habs;
  
  int hab1[MAX_ROWS][MAX_COLS];
  float fert1[MAX_ROWS][MAX_COLS];
  
  float reg_jmax, reg_jmin, reg_jsum;
  
  int loop_index;
  float lambda[6];
  int i, j, ncols, nrows;
  float xll, yll, cells;
  char fn[255];

  char idx[2];
  
  /* szenario auslesen und entsprechende Verzeichnisstring aufbauen */
  
  if (argc<9)
    {
      printf("usage gridopt2.exe <scenario> <run> <l_y> <l_f> <l_n1> <l_n2> <l_npp> <l_co2>\n");
      printf("with J = <l_y> * Y_US$(crop) + <l_f> * lambda_f * F - l_n1 * (SF + l_n2 * SD) + l_npp*NPP + l_co2*CO2\n");
      printf("recommendation: l_y, l_f from {0,1}\n");
      printf("defining l_x < 0 makes gridopt2 vary this weight for optimization.\n"); 
      exit(1);
    }
  
  in_map_dir[0] = '\0'; strcat(in_map_dir, IN_MAPS_PATH);
  out_map_dir[0] = '\0'; strcat(out_map_dir, OUT_MAPS_PATH);
  arcview_map_dir[0] = '\0'; strcat(arcview_map_dir, OUT_MAPS_PATH);
  par_dir[0] = '\0'; strcat(par_dir, PARAM_PATH);
  data_dir[0] = '\0'; strcat(data_dir, SME_DATA_PATH);
  
  strcat(in_map_dir, argv[1]); strcat(in_map_dir, argv[2]); strcat(in_map_dir, "/");
  strcat(data_dir, argv[1]); strcat(data_dir, argv[2]); strcat(data_dir, "/");
  strcat(out_map_dir, argv[1]); strcat(out_map_dir, argv[2]); strcat(out_map_dir, "/");

  printf("set up directory structure:\n");
  printf("map input:%s\nmap output:%s\nparameter:%s\ndata:%s\nArcVIEW:%s\n",
	 in_map_dir, out_map_dir, par_dir, data_dir, arcview_map_dir);

  /* Einlesen der Karten */

  make_fn(fn, "habmapdb", in_map_dir);
  read_arcinfo_int_grid(fn, &ncols, &nrows, &xll, &yll, &cells, &nohab, hab);

  read_multilayer_float_map(in_map_dir, "nppc", 0.0001, nppc, 6);  
  correct_SME_multilayer_float_map(nppc, 0.0, ncols, nrows, 6, hab, nohab);
  read_multilayer_float_map(in_map_dir, "nppw", 0.0001, nppw, 6);  
  correct_SME_multilayer_float_map(nppw, 0.0, ncols, nrows, 6, hab, nohab);
  read_multilayer_float_map(in_map_dir, "npps", 0.0001, npps, 6);  
  correct_SME_multilayer_float_map(npps, 0.0, ncols, nrows, 6, hab, nohab);

  make_fn(fn, "nppfo0", in_map_dir);
  read_arcinfo_float_grid(fn, 0.0001, &ncols, &nrows, 
			  &xll, &yll, &cells, nppfo);
  correct_SME_float_map(nppfo, 0.0, ncols, nrows, hab, nohab);

  make_fn(fn, "nppfa0", in_map_dir);
  read_arcinfo_float_grid(fn, 0.0001, &ncols, &nrows, 
			  &xll, &yll, &cells, nppfa);
  correct_SME_float_map(nppfa, 0.0, ncols, nrows, hab, nohab);

  read_multilayer_float_map(in_map_dir, "co2c", 0.0001, co2c, 6);  
  correct_SME_multilayer_float_map(co2c, 0.0, ncols, nrows, 6, hab, nohab);
  read_multilayer_float_map(in_map_dir, "co2w", 0.0001, co2w, 6);  
  correct_SME_multilayer_float_map(co2w, 0.0, ncols, nrows, 6, hab, nohab);
  read_multilayer_float_map(in_map_dir, "co2s", 0.0001, co2s, 6);  
  correct_SME_multilayer_float_map(co2s, 0.0, ncols, nrows, 6, hab, nohab);

  make_fn(fn, "co2fo0", in_map_dir);
  read_arcinfo_float_grid(fn, 0.0001, &ncols, &nrows, 
			  &xll, &yll, &cells, co2fo);
  correct_SME_float_map(co2fo, 0.0, ncols, nrows, hab, nohab);

  make_fn(fn, "co2fa0", in_map_dir);
  read_arcinfo_float_grid(fn, 0.0001, &ncols, &nrows, 
			  &xll, &yll, &cells, co2fa);
  correct_SME_float_map(co2fa, 0.0, ncols, nrows, hab, nohab);

  read_multilayer_float_map(in_map_dir, "sdc", 0.0001, sdc, 6);  
  correct_SME_multilayer_float_map(sdc, 0.0, ncols, nrows, 6, hab, nohab);
  read_multilayer_float_map(in_map_dir, "sdw", 0.0001, sdw, 6);  
  correct_SME_multilayer_float_map(sdw, 0.0, ncols, nrows, 6, hab, nohab);
  read_multilayer_float_map(in_map_dir, "sds", 0.0001, sds, 6);  
  correct_SME_multilayer_float_map(sds, 0.0, ncols, nrows, 6, hab, nohab);

  make_fn(fn, "sdfo0", in_map_dir);
  read_arcinfo_float_grid(fn, 0.0001, &ncols, &nrows, 
			  &xll, &yll, &cells, sdfo);
  correct_SME_float_map(sdfo, 0.0, ncols, nrows, hab, nohab);

  make_fn(fn, "sdfa0", in_map_dir);
  read_arcinfo_float_grid(fn, 0.0001, &ncols, &nrows, 
			  &xll, &yll, &cells, sdfa);
  correct_SME_float_map(sdfa, 0.0, ncols, nrows, hab, nohab);

  read_multilayer_float_map(in_map_dir, "sfc", 0.0001, sfc, 6);  
  correct_SME_multilayer_float_map(sfc, 0.0, ncols, nrows, 6, hab, nohab);
  read_multilayer_float_map(in_map_dir, "sfw", 0.0001, sfw, 6);    
  correct_SME_multilayer_float_map(sfw, 0.0, ncols, nrows, 6, hab, nohab);
  read_multilayer_float_map(in_map_dir, "sfs", 0.0001, sfs, 6);  
  correct_SME_multilayer_float_map(sfs, 0.0, ncols, nrows, 6, hab, nohab);
  make_fn(fn, "sffo0", in_map_dir);
  read_arcinfo_float_grid(fn, 0.0001, &ncols, &nrows, 
			  &xll, &yll, &cells, sffo);
  correct_SME_float_map(sffo, 0.0, ncols, nrows, hab, nohab);
  make_fn(fn, "sffa0", in_map_dir);
  read_arcinfo_float_grid(fn, 0.0001, &ncols, &nrows, 
			  &xll, &yll, &cells, sffa);
  correct_SME_float_map(sffa, 0.0, ncols, nrows, hab, nohab);

  read_multilayer_float_map(in_map_dir, "yc", 0.0001, yc, 6);  
  correct_SME_multilayer_float_map(yc, 0.0, ncols, nrows, 6, hab, nohab);
  read_multilayer_float_map(in_map_dir, "ys", 0.0001, ys, 6);  
  correct_SME_multilayer_float_map(ys, 0.0, ncols, nrows, 6, hab, nohab);
  read_multilayer_float_map(in_map_dir, "yw", 0.0001, yw, 6);  
  correct_SME_multilayer_float_map(yw, 0.0, ncols, nrows, 6, hab, nohab);

  loop_index = 0;
  for (i=3; i<9;i++)
    {
      sscanf(argv[i], "%g", &lambda[i-3]);
      if (lambda[i-3] < 0)
	loop_index = i-3;
    }

  if (!(loop_index))
    {
      calculate_optimum_2(sfc, sfs, sfw, sffa, sffo, 
			  sdc, sds, sdw, sdfa, sdfo, 
			  co2c, co2s, co2w, co2fa, co2fo,
			  nppc, npps, nppw, nppfa, nppfo,
			  yc, ys, yw, 
			  hab, ncols, nrows, 6, nohab, lambda,
			  hab1, fert1, jmin_map, jmax_map, &count_habs,
			  &nr_c, &nr_s, &nr_w, &nr_fa, &nr_fo, &sum_fert);
		
      make_fn(fn, "habmap", arcview_map_dir);
      strcat(fn, ".asc");
      write_arcinfo_int_grid(fn, ncols, nrows, xll, yll, cells, 
			     nohab, hab1);	
      
      make_fn(fn, "fertmap", arcview_map_dir);
      strcat(fn, ".asc");
      write_arcinfo_float_grid(fn, ncols, nrows, xll, yll , cells, 
			       NODATA, fert1);	

      
      make_fn(fn, "jmin", arcview_map_dir);
      strcat(fn, ".asc");
      write_arcinfo_float_grid(fn, ncols, nrows, xll, yll, cells, 
			       NODATA, jmin_map);	

      make_fn(fn, "jmax", arcview_map_dir);
      strcat(fn, ".asc");
      
      write_arcinfo_float_grid(fn, ncols, nrows, xll, yll, cells, 
			       NODATA, jmax_map);	
    }
  else
    {
      make_fn(fn, argv[1], par_dir);
      strcat(fn, argv[2]);
      strcat(fn, ".par");
      cfp = fopen(fn, "r");
      if (cfp == NULL)
	{
	  printf("cannot open %s\n", fn);
	  exit(0);
	}
      i = -1;
      do
	{
	  fscanf(cfp, "%f", &draw_map[++i]);
	  if (draw_map[i]> -1.0)
	    printf("%g ", draw_map[i]);
	}
      while (draw_map[i] > -1.0);
      no_maps = (i < 10 ? i : 9);
      
      make_fn(fn, "habitat.dat", OUT_DATA_PATH);
      wfp = fopen(fn, "w");
      if (wfp == NULL) fatal(fn);

      fprintf(wfp, "lambda #c #s #w #fa #fo fert #agri jmin jmax jsum\n");
      
      lambda[loop_index] = 0.0;
      cur_map = 0;
      no_habs = 0;
      count_habs = 0;
      idx[0] = '0';
      idx[1] = '\0';

      printf("calculation of habitat maps depending on lambda_%d\n ", loop_index);

      while (fscanf(cfp, "%f %f \n", &to_lambda, &lambda_step) != EOF)
	for (; lambda[loop_index]<to_lambda; lambda[loop_index] += lambda_step)
	  {
	    calculate_optimum_2(sfc, sfs, sfw, sffa, sffo, 
				sdc, sds, sdw, sdfa, sdfo, 
				co2c, co2s, co2w, co2fa, co2fo,
				nppc, npps, nppw, nppfa, nppfo,
				yc, ys, yw, 
				hab, 
				ncols, nrows, 6, nohab, lambda, 
				hab1, fert1, jmin_map, jmax_map, &count_habs,
				&nr_c, &nr_s, &nr_w, &nr_fa, &nr_fo, &sum_fert);

	    no_habs = count_habs;
	    
	    fprintf(wfp, "%6.2f %6d  %6d  %6d  %6d  %6d  %6.2f %6d %8.2f %8.2f %8.2f\n", 
		    lambda[loop_index], nr_c, nr_s, nr_w, nr_fa, nr_fo, 
		    sum_fert/(double)(nr_c+nr_s+nr_w), nr_c+nr_s+nr_w, reg_jmin, reg_jmax, reg_jsum);
	    
	    if ((lambda[loop_index]>=draw_map[cur_map]) && (cur_map < no_maps))
	      {
		printf("\n");
		fn[0] = '\0';
		strcat(fn, data_dir);
		strcat(fn, "CropData");
		strcat(fn, idx);
		hfp = fopen(fn, "w");
		if (hfp == NULL) 
		  fatal(fn);

		fn[0] = '\0';
		strcat(fn, data_dir);
		strcat(fn, "FertData");
		strcat(fn, idx);
		ffp = fopen(fn, "w");
		if (ffp == NULL) 
		  fatal(fn);

		fprintf(hfp, " %d\n", no_habs);
		fprintf(ffp, " %d\n", no_habs);
		for (i=0; i<nrows; i++)
		  for (j=0; j<ncols; j++)
		    if (is_control(hab1[i][j]))
		      {
			fprintf(hfp, " %d", hab1[i][j]);
			fprintf(ffp, " %5.1f", fert1[i][j]);
		      }

		fprintf(hfp, "\n");
		fclose(hfp);
		fprintf(ffp, "\n");
		fclose(ffp);
		
		make_fn(fn, "habmap", out_map_dir);
		strcat(fn, idx);
		strcat(fn, ".asc");
		write_arcinfo_int_grid(fn, ncols, nrows, xll, yll, cells, 
				       nohab, hab1);	
		
		
		make_fn(fn, "fertmap", out_map_dir);
		strcat(fn, idx);
		strcat(fn, ".asc");
		write_arcinfo_float_grid(fn, ncols, nrows, xll, yll, cells, 
					 NODATA, fert1);	
		
		make_fn(fn, "jmin", out_map_dir);
		strcat(fn, idx);
		strcat(fn, ".asc");
		write_arcinfo_float_grid(fn, ncols, nrows, xll, yll, cells, 
					 NODATA, jmin_map);	
		make_fn(fn, "jmax", out_map_dir);
		strcat(fn, idx);
		strcat(fn, ".asc");
		
		write_arcinfo_float_grid(fn, ncols, nrows, xll, yll, cells, 
					 NODATA, jmax_map);	
		
		cur_map++;
		idx[0]++;
	      }
	  }
      fclose(cfp);
      fclose(wfp);
    }

  printf("\n");
      
  return 0;		      
}





