#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <unistd.h>

#define PROJECT         "HUNT"
#define MODEL           "HNMD"
#define SME_IN_LU       "CropData"                        /* exchange file to SME */
#define SME_IN_F        "FertData"                        /* exchange file to SME */

#define SME_OUTPUT      "GoalFunctionProtocol"            /* exchange file from SME */
#define NO_COLUMN       15	                   /* No. of Cols. in exchange file from SME */
#define GF_COLUMN       10                         /* Column with Perf. crit */
#define PROJECT_PATH   "../../"
//#define PROJECT_PATH   "/data/Projects/HUNT/"
#define MAX_LENGTH      1700


FILE *rfp;
FILE *wfp;

static int landuse0[MAX_LENGTH];
static int landuse1[MAX_LENGTH];
static float fert0[MAX_LENGTH];
static float fert1[MAX_LENGTH];


#define WATER           1
#define FOREST          2
#define AGRI            3
#define FALLOW          6
#define CORN            7
#define WHEAT           8
#define SOY             9

char scenario[255];
char init_lu[255];
char init_fert[255];
char run_lu[255];
char run_fert[255];

float p0_mc;


void fatal(char* fn)
{
  printf("cannot open/write %s\n", fn);
  exit(0);
}


/*run SME
  important: make shure we're on the right project, model, scenrio */

void run_sme()
{
  char wrkstr[255];

  wrkstr[0] = '\0';
  strcat(wrkstr, "SME project ");
  strcat(wrkstr, PROJECT);
  strcat(wrkstr, " /data/Projects");
  system(wrkstr);

  wrkstr[0] = '\0';
  strcat(wrkstr, "SME model ");
  strcat(wrkstr, MODEL);
  system(wrkstr);

  wrkstr[0] = '\0';
  strcat(wrkstr, "SME scenario ");
  strcat(wrkstr, scenario);
  system(wrkstr);

  system("SME -batch run");

  wrkstr[0] = '\0';
  strcat(wrkstr, "tail -1 ");
  strcat(wrkstr, PROJECT_PATH);
  strcat(wrkstr, "DriverOutput/GoalFunctionProtocol >> ");
  strcat(wrkstr, PROJECT_PATH);
  strcat(wrkstr, "/DriverOutput/mc.dat");
  system(wrkstr);
}



int main(int argc, char *argv[])
{
  int count;
  char wrkstr[255];
  char datapath[255];
  unsigned short xi[3];
  float r;

  scenario[0] = '\0';
  init_lu[0] = '\0';
  init_fert[0] = '\0';

  xi[0] = getpid();

	
  float p0[5];

  if (argc<5)
    {
      printf("usage mc <scenario> <run> <map> <p>\n");
      printf("  <scenario> scenraio identifer (see SME)\n");
      printf("  <run>      identifer of optimization run\n");
      printf("  <map>=0..9 number of map, written bei gridopt\n");
      printf("  <p>=0..1   probability of initial disturbance of solution\n");
      printf("              p=0 no change to given map\n");
      printf("              p=0.01x change x percent of landuse map, \n");
      printf("                stick to relative distribution of map\n");
      printf("              p<0 generate new map, generate new distribution\n");
	

      exit(1);
    }

  scenario[0] = '\0';
  strcat(scenario, argv[1]);

  init_lu[0] =  '\0';
  strcat(init_lu, PROJECT_PATH); strcat(init_lu, "Data/OptMaps/");
  strcat(init_lu, argv[1]); strcat(init_lu, argv[2]);
  strcat(init_lu, "/"); strcat(init_lu, SME_IN_LU);
  strcat(init_lu, argv[3]);

  run_lu[0] ='\0';
  strcat(run_lu, PROJECT_PATH); strcat(run_lu, "Data/");
  strcat(run_lu, SME_IN_LU);

  init_fert[0] = '\0';
  strcat(init_fert, PROJECT_PATH); strcat(init_fert, "Data/OptMaps/");
  strcat(init_fert, argv[1]); strcat(init_fert, argv[2]);
  strcat(init_fert, "/"); strcat(init_fert, SME_IN_F);
  strcat(init_fert, argv[3]);

  run_fert[0] ='\0';
  strcat(run_fert, PROJECT_PATH); strcat(run_fert, "Data/");
  strcat(run_fert, SME_IN_F);

  sscanf(argv[4], "%f", &p0_mc);

  printf("Initfile %s %s\n", init_lu, init_fert);
  printf("SME file %s %s\n", run_lu, run_fert);

  if (p0_mc>= 0.0)
    {
      printf("disturbance of solution in map %s be p0=%5.3f\n",argv[3], p0_mc);

      rfp = fopen(init_lu, "r");
      if (rfp == NULL) fatal(init_lu);
      
      fscanf(rfp, " %d\n", &count);
      
      int nr_w = int(count*0.01);
      int nr_c = int(count*0.01);
      int nr_s = int(count*0.01);
      int nr_fa = int(count*0.01);
      int nr_fo = int(count*0.01);
      
      for (int i=0; i< count; i++)
	{
	  fscanf(rfp, " %d", &landuse0[i]);
	  switch (landuse0[i])
	    {
	    case CORN:
	      nr_c++;
	      break;
	    case WHEAT:
	      nr_w++;
	      break;
	    case SOY:
	      nr_s++;
	      break;
	    case FOREST:
	      nr_fo++;
	      break;
	    case FALLOW:
	      nr_fa++;
	      break;
	    }
	}
      fclose(rfp);
      
      
      p0[0] = nr_fa/(double)(nr_c+nr_w+nr_s+nr_fa+nr_fo);
      p0[1] = nr_c/(double)(nr_c+nr_w+nr_s+nr_fa+nr_fo);
      p0[2] = nr_w/(double)(nr_c+nr_w+nr_s+nr_fa+nr_fo);
      p0[3] = nr_s/(double)(nr_c+nr_w+nr_s+nr_fa+nr_fo);
      p0[4] = nr_fo/(double)(nr_c+nr_w+nr_s+nr_fa+nr_fo);
      
      printf("initial distrib.: ");
      
      for (int i=0; i<5; i++)
	printf(" %5.4f", p0[i]);
      printf("\n");
      
      /* for(int i=0; i<5; i++) 
	 p0[i] = 0.2; */
      printf("distrib. used:    ");      
      for (int i=0; i<5; i++)
	printf(" %5.4f", p0[i]);
      printf("\n");
      

      // p[i] is discrete denisity function,
      // now calculate distribution function
      for (int i=1; i<5; i++)
	p0[i] += p0[i-1];
    }

  rfp = fopen(init_fert, "r");
  fscanf(rfp, " %d\n", &count);
  for (int i=0; i< count; i++)
    fscanf(rfp, " %f", &fert0[i]);
  fclose(rfp);
  
  while (1)
    {
      if (p0_mc<0.0)
	{
	  float sum = 0.0;
	  for (int i=0; i<5; i++)
	    {
	      p0[i] =  (float)erand48(xi);
	      sum += p0[i];
	    }
	  for (int i=0; i<5; i++)
	    p0[i] /= sum;

	  printf("distrib. used:    ");      
	  for (int i=0; i<5; i++)
	    printf("%5.4f", p0[i]);
	  printf("\n");

	  // p[i] is discrete denisity function,
	  // now calculate distribution function
	  for (int i=1; i<5; i++)
	    p0[i] += p0[i-1];	  
	}

      /* stochastisch aendern */
      for(int i=0; i<count; i++)
	{
	  landuse1[i] = landuse0[i];
	  
	  r = (float)erand48(xi);
	  
	  if ((r<p0_mc) || (p0_mc<0.0))
	    {
	      while (landuse1[i] == landuse0[i])
		{
		  r = (float)erand48(xi);
		  landuse1[i] = 6;
		  for(int j=0; j<4; j++)
		    if(r>p0[j])
		      landuse1[i] = (int)(j+7);

		  if (landuse1[i] == 10)
		    landuse1[i] = 2;
		}
	    }
	  
	  fert1[i] = 0.0;

	  if (landuse1[i] > 6)
	    {
	      r = (float)erand48(xi);

	      fert1[i] = 1.5*fert0[i] * r;
	    }
	}


      /* neue lu, fert schreiben */

      wfp = fopen(run_lu, "w");
      fprintf(wfp, " %d\n", count);
      for (int i=0; i< count; i++)
	fprintf(wfp, " %d", landuse1[i]);
      fclose(wfp);

      wfp = fopen(run_fert, "w");
      fprintf(wfp, " %d\n", count);
      for (int i=0; i< count; i++)
	fprintf(wfp, " %5.2f", fert1[i]);
      fclose(wfp);

      run_sme();
    }

}  






