#include "../smeopt/smeopt.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <math.h>


/* gnu-c on solaris does not like to hold 17MByte static in 
 * a local function (e.g. main())
 * so here are al function global again, sorry. */




int main(int argc, char *argv[])
{
  float map[MAX_ROWS][MAX_COLS];
  float min, max, sum, avg;
  int xll, yll, cells, ncols, nrows;
  
  if (argc<2)
    {
      printf("usage mapstat.exe <map> \n");
      exit(1);
    }

  read_arcinfo_float_grid(argv[1], 0.0001, &ncols, &nrows, &xll, &yll, &cells, map);
  statistics_on_float_map(map, ncols, nrows, &min, &max, &avg, &sum);
  printf("min: %13.6f\nmax: %13.6f\nsum: %13.6f\navg: %13.6f\n", min, max, sum, avg);
}
