#include "smeopt.h"


float yield_usd(crop, yield)
     int crop;
     float yield;
{
  return (lambda_y[crop-1]*yield);
}

float performance_criterion(crop, yield, nout, fertilizer)
     int crop;
     float yield;
     float nout;
     float fertilizer;
{

  return (yield_usd(crop, yield) - lambda_n * nout - lambda_f * fertilizer);
}


/* calculate_optimum
 * =================
 * In:  multilayer maps: sfw, sfc, sfs, yw, yc, ys
 *      single layer maps: sffa, sffo
 *      sizes specs.: nrows, ncols, nlayer
 * Out: Optimum Habitat map: 
 */

void calculate_optimum(sfc, sfs, sfw, sffa, sffo, yc, ys, yw, hab, ncols, nrows, n_layer, no_habs, 
		       opthab, optfert, jmin_map, jmax_map, count_habs,
		       nr_c, nr_s, nr_w, nr_fa, nr_fo, sum_fert)
     float sfw[MAX_LAYER][MAX_ROWS][MAX_COLS];
     float sfc[MAX_LAYER][MAX_ROWS][MAX_COLS];
     float sfs[MAX_LAYER][MAX_ROWS][MAX_COLS];
     float sffa[MAX_ROWS][MAX_COLS];
     float sffo[MAX_ROWS][MAX_COLS];

     float yw[MAX_LAYER][MAX_ROWS][MAX_COLS];
     float yc[MAX_LAYER][MAX_ROWS][MAX_COLS];
     float ys[MAX_LAYER][MAX_ROWS][MAX_COLS];

     int hab[MAX_ROWS][MAX_COLS];
     int ncols, nrows, n_layer, no_habs;
     int *count_habs;

     int opthab[MAX_ROWS][MAX_COLS];
     float optfert[MAX_COLS][MAX_ROWS];
     float jmin_map[MAX_COLS][MAX_ROWS];
     float jmax_map[MAX_COLS][MAX_ROWS];

     int *nr_c, *nr_s, *nr_w, *nr_fa, *nr_fo;
     float *sum_fert;
{
  int i,j, k;

  float reg_jmax, reg_jmin, reg_jsum;
  
  float jmax, jakt, jmin;

  *count_habs = 0;

  *sum_fert = 0.0;
  *nr_c = 0;
  *nr_s = 0;
  *nr_fa = 0;
  *nr_fo = 0;
  *nr_w = 0;
	
  reg_jmax = -10.0e+5;
  reg_jmin =  10.0e+5;
  reg_jsum = 0.0;
  
  for (i=0; i<nrows; i++)
    for (j=0; j<ncols; j++)
      {
	opthab[i][j] = hab[i][j];
	
	optfert[i][j] = NODATA;
	
	jmin_map[i][j] = NODATA;
	jmax_map[i][j] = NODATA;
	
	if (is_control(hab[i][j]))
	  {
	    *count_habs = *count_habs + 1;
	    
	    jmax = -10.0e+5;
	    jmin =  10.0e+5;
	    for(k=0; k<n_layer; k++)
	      {
		jakt = performance_criterion(WHEAT, 
					     yw[k][i][j], 
					     sfw[k][i][j], 
					     fert_level[k]);
		if (jakt>jmax)
		  {
		    jmax = jakt;
		    opthab[i][j] = WHEAT;
		    optfert[i][j] = fert_level[k];
		  }
		jmin = (jakt<jmin ? jakt : jmin);
	      }
	    for(k=0; k<n_layer; k++)
	      {
		jakt = performance_criterion(CORN, 
					     yc[k][i][j], 
					     sfc[k][i][j], 
					     fert_level[k]);
		if (jakt>jmax)
		  {
		    jmax = jakt;
		    opthab[i][j] = CORN;
		    optfert[i][j] = fert_level[k];
		  }
		jmin = (jakt<jmin ? jakt : jmin);
	      }
	    for(k=0; k<n_layer; k++)
	      {
		jakt = performance_criterion(SOY, 
					     ys[k][i][j], 
					     sfs[k][i][j], 
					     fert_level[k]);
		if (jakt>jmax)
		  {
		    jmax = jakt;
		    opthab[i][j] = SOY;
		    optfert[i][j] = fert_level[k];
		  }
		jmin = (jakt<jmin ? jakt : jmin);
	      }
	    jakt = performance_criterion(FOREST, 0.0, 
					 sffo[i][j], 
					 0.0);
	    if (jakt>jmax)
	      {
		jmax = jakt;
		opthab[i][j] = FOREST;
		optfert[i][j]= 0.0;
	      }
	    jmin = (jakt<jmin ? jakt : jmin);
	    jakt = performance_criterion(FALLOW, 0.0, 
					 sffa[i][j], 
					 0.0);
	    if (jakt>jmax)
	      {
		jmax = jakt;
		opthab[i][j] = FALLOW;
		optfert[i][j] = 0.0;
	      }
	    jmin = (jakt<jmin ? jakt : jmin);
	    
	    *sum_fert = *sum_fert + (optfert[i][j] < 0.0 ? 0.0 : optfert[i][j]);
	    
	    if (jmax>reg_jmax) /* statistics on regional j */
	      reg_jmax = jmax;
	    if (jmin<reg_jmin)
	      reg_jmin = jmin;
	    
	    jmin_map[i][j] = jmin;
	    jmax_map[i][j] = jmax;
	    reg_jsum += jmax;
	  }
	switch (opthab[i][j])
	  {
	  case FALLOW : 
	    *nr_fa = *nr_fa + 1;
	    break;
	  case FOREST : 
	    *nr_fo = *nr_fo + 1;
	    break;
	  case WHEAT  : 
	    *nr_w = *nr_w + 1;
	    break;
	  case CORN   : 
	    *nr_c = *nr_c + 1;
	    break;
	  case SOY    : 
	    *nr_s = *nr_s + 1;
	    break;
	  }
      }
}


float performance_criterion_2(crop_id, yield, nout1, nout2, npp, co2, fertilizer, lambda)
     int crop_id;
     float yield;
     float nout1, nout2, npp, co2;
     float fertilizer;
     float lambda[6];
{
  float res;
 
  res =  lambda[0]*yield_usd(crop_id, yield) - (lambda[1]*lambda_f*fertilizer);
  res += -lambda[2]*(nout1 + lambda[3]*nout2);
  res += lambda[4]*npp;
  res += lambda[5]*co2;

  return res;
}


/* calculate_optimum_2
 * =================
 * In:  multilayer maps: sfw, sfc, sfs, yw, yc, ys, 
 *                       sdw, sdc, sds, co2w, co2s, co2c, co2fa, co2fo, 
 *                       nppw, nppc, npp2, nppfa, nppfo, 
 *      single layer maps: sffa, sffo
 *      sizes specs.: nrows, ncols, nlayer
 * Out: Optimum Habitat map: 
 */

void calculate_optimum_2(sfc, sfs, sfw, sffa, sffo, 
			 sdc, sds, sdw, sdfa, sdfo, 
			 co2c, co2s, co2w, co2fa, co2fo,
			 nppc, npps, nppw, nppfa, nppfo,
			 yc, ys, yw, 
			 hab, 
			 ncols, nrows, n_layer, no_habs, lambda, 
			 opthab, optfert, jmin_map, jmax_map, count_habs,
			 nr_c, nr_s, nr_w, nr_fa, nr_fo, sum_fert)
     float lambda[6];

     float sfw[MAX_LAYER][MAX_ROWS][MAX_COLS];
     float sfc[MAX_LAYER][MAX_ROWS][MAX_COLS];
     float sfs[MAX_LAYER][MAX_ROWS][MAX_COLS];
     float sffa[MAX_ROWS][MAX_COLS];
     float sffo[MAX_ROWS][MAX_COLS];

     float co2w[MAX_LAYER][MAX_ROWS][MAX_COLS];
     float co2c[MAX_LAYER][MAX_ROWS][MAX_COLS];
     float co2s[MAX_LAYER][MAX_ROWS][MAX_COLS];
     float co2fa[MAX_ROWS][MAX_COLS];
     float co2fo[MAX_ROWS][MAX_COLS];

     float nppw[MAX_LAYER][MAX_ROWS][MAX_COLS];
     float nppc[MAX_LAYER][MAX_ROWS][MAX_COLS];
     float npps[MAX_LAYER][MAX_ROWS][MAX_COLS];
     float nppfa[MAX_ROWS][MAX_COLS];
     float nppfo[MAX_ROWS][MAX_COLS];

     float sdw[MAX_LAYER][MAX_ROWS][MAX_COLS];
     float sdc[MAX_LAYER][MAX_ROWS][MAX_COLS];
     float sds[MAX_LAYER][MAX_ROWS][MAX_COLS];
     float sdfa[MAX_ROWS][MAX_COLS];
     float sdfo[MAX_ROWS][MAX_COLS];

     float yw[MAX_LAYER][MAX_ROWS][MAX_COLS];
     float yc[MAX_LAYER][MAX_ROWS][MAX_COLS];
     float ys[MAX_LAYER][MAX_ROWS][MAX_COLS];

     int hab[MAX_ROWS][MAX_COLS];
     int ncols, nrows, n_layer, no_habs;
     int *count_habs;

     int opthab[MAX_ROWS][MAX_COLS];
     float optfert[MAX_ROWS][MAX_COLS];
     float jmin_map[MAX_ROWS][MAX_COLS];
     float jmax_map[MAX_ROWS][MAX_COLS];

     int *nr_c, *nr_s, *nr_w, *nr_fa, *nr_fo;
     float *sum_fert;
{
  int i,j, k;

  float reg_jmax, reg_jmin, reg_jsum;
  
  float jmax, jakt, jmin;

  *count_habs = 0;

  *sum_fert = 0.0;
  *nr_c = 0;
  *nr_s = 0;
  *nr_fa = 0;
  *nr_fo = 0;
  *nr_w = 0;
	
  reg_jmax = -10.0e+5;
  reg_jmin =  10.0e+5;
  reg_jsum = 0.0;
  
  printf("lambda = (");
  for (i=0; i<6;i++)
    {
      printf("%6.2f", lambda[i]);
      if (i != 5)
	printf(",");
    }
  printf(")\n");

  for (i=0; i<nrows; i++)
    for (j=0; j<ncols; j++)
      {
	opthab[i][j] = hab[i][j];
	
	optfert[i][j] = NODATA;
	
	jmin_map[i][j] = NODATA;
	jmax_map[i][j] = NODATA;
	
	if (is_control(hab[i][j]))
	  {
	    *count_habs = *count_habs + 1;
	    
	    jmax = -10.0e+5;
	    jmin =  10.0e+5;
	    for(k=0; k<n_layer; k++)
	      {
		jakt = performance_criterion_2(WHEAT, 
					       yw[k][i][j], sfw[k][i][j], sdw[k][i][j], nppw[k][i][j], co2w[k][i][j],
					       fert_level[k], lambda);
		if (jakt>jmax)
		  {
		    jmax = jakt;
		    opthab[i][j] = WHEAT;
		    optfert[i][j] = fert_level[k];
		  }
		jmin = (jakt<jmin ? jakt : jmin);
	      }
	    for(k=0; k<n_layer; k++)
	      {
		jakt = performance_criterion_2(CORN, 
					       yc[k][i][j], sfc[k][i][j], sdc[k][i][j], nppc[k][i][j], co2c[k][i][j],
					       fert_level[k], lambda);
		if (jakt>jmax)
		  {
		    jmax = jakt;
		    opthab[i][j] = CORN;
		    optfert[i][j] = fert_level[k];
		  }
		jmin = (jakt<jmin ? jakt : jmin);
	      }
	    for(k=0; k<n_layer; k++)
	      {
		jakt = performance_criterion_2(SOY, 
					       ys[k][i][j], sfs[k][i][j], sds[k][i][j], npps[k][i][j], co2s[k][i][j],
					       fert_level[k], lambda);
		if (jakt>jmax)
		  {
		    jmax = jakt;
		    opthab[i][j] = SOY;
		    optfert[i][j] = fert_level[k];
		  }
		jmin = (jakt<jmin ? jakt : jmin);
	      }
	    jakt = performance_criterion_2(FOREST, 
					   0.0, sffo[i][j], sdfo[i][j], nppfo[i][j], co2fo[i][j],
					   0.0, lambda);
	    if (jakt>jmax)
	      {
		jmax = jakt;
		opthab[i][j] = FOREST;
		optfert[i][j]= 0.0;
	      }
	    jmin = (jakt<jmin ? jakt : jmin);
	    jakt = performance_criterion_2(FALLOW, 
					   0.0, sffa[i][j], sdfa[i][j], nppfa[i][j], co2fa[i][j],
					   0.0, lambda);
	    if (jakt>jmax)
	      {
		jmax = jakt;
		opthab[i][j] = FALLOW;
		optfert[i][j] = 0.0;
	      }
	    jmin = (jakt<jmin ? jakt : jmin);
	    
	    *sum_fert = *sum_fert + (optfert[i][j] < 0.0 ? 0.0 : optfert[i][j]);
	    
	    if (jmax>reg_jmax) /* statistics on regional j */
	      reg_jmax = jmax;
	    if (jmin<reg_jmin)
	      reg_jmin = jmin;
	    
	    jmin_map[i][j] = jmin;
	    jmax_map[i][j] = jmax;
	    reg_jsum += jmax;
	  }
	switch (opthab[i][j])
	  {
	  case FALLOW : 
	    *nr_fa = *nr_fa + 1;
	    break;
	  case FOREST : 
	    *nr_fo = *nr_fo + 1;
	    break;
	  case WHEAT  : 
	    *nr_w = *nr_w + 1;
	    break;
	  case CORN   : 
	    *nr_c = *nr_c + 1;
	    break;
	  case SOY    : 
	    *nr_s = *nr_s + 1;
	    break;
	  }
      }
}

