#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>

#include "smeopt.h"

/* if gridopt is used in a SME Project Data-Structure on a Workstation
  this is the default */


void fatal(fn)
     char* fn;
{
  printf("cannot open/write %s\n", fn);
  exit(0);
}

void copy_into_layer(lmap, map, layer, ncols, nrows)
     float lmap[MAX_LAYER][MAX_ROWS][MAX_COLS];
     float map[MAX_ROWS][MAX_COLS];
     int ncols, nrows;
     int layer;
{
  int i,j;
  
  for (i=0; i<nrows; i++)
    for (j=0; j<ncols; j++)
      lmap[layer][i][j] = map[i][j];
}


int is_float_nodata(cell)
     double cell;
{
  double upper, lower;
  upper = NODATA + fabs(NODATA/10000.0);
  lower = NODATA - fabs(NODATA/10000.0);
  return ((cell <= upper) && (cell >= lower));
}

void copy_layer_maps(in_map, out_map, ncols, nrows, no_layer, layer_offset)
     float in_map[MAX_LAYER][MAX_ROWS][MAX_COLS];
     float out_map[MAX_LAYER][MAX_ROWS][MAX_COLS];
     int ncols, nrows, no_layer, layer_offset;
{
  int i,j,k;
  for (i=0; i<nrows; i++)
    for (j=0; j<ncols; j++)
      for (k=0; k<6; k++)
	out_map[k+layer_offset][i][j] = in_map[k+layer_offset][i][j];
}
  
/* korr. */
void write_arcinfo_int_grid(fn, ncols, nrows, xll, yll, cells, nodata, map)
     char *fn;
     int ncols, nrows, nodata;
     float xll, yll, cells;
     int map[MAX_ROWS][MAX_COLS];
{
  FILE *wfp;
  int i, j;

  wfp = fopen(fn, "w");

  if (wfp == NULL) fatal(fn);

  printf("writing %s.", fn);

  fprintf(wfp, "ncols          %d\n", ncols);
  fprintf(wfp, "nrows          %d\n", nrows);
  fprintf(wfp, "xllcorner      %f\n", xll);
  fprintf(wfp, "yllcorner      %f\n", yll);
  fprintf(wfp, "cellsize       %f\n", cells);
  fprintf(wfp, "nodata_value   %d\n", nodata);

  for (i=0; i<nrows; i++)
    {
      if ((i % 5) == 0)
	  {
	    printf(".");
	    fflush(stdout);
	  }
      for (j=0; j<ncols; j++)
	fprintf(wfp, " %d", map[i][j]);
      fprintf(wfp, "\n");
    }
  printf("\n");
  fclose(wfp);
}

/* Fehler korrigiert */  
void write_arcinfo_float_grid(fn, ncols, nrows, xll, yll, cells, nodata, map)
     char *fn;
     int ncols, nrows;
     float nodata;
     float xll, yll, cells;
     float map[MAX_ROWS][MAX_COLS];
{
  FILE *wfp;
  int i, j;

  wfp = fopen(fn, "w");

  if (wfp == NULL) fatal(fn);

  printf("writing %s.", fn);

  fprintf(wfp, "ncols          %d\n", ncols);
  fprintf(wfp, "nrows          %d\n", nrows);
  fprintf(wfp, "xllcorner      %f\n", xll);
  fprintf(wfp, "yllcorner      %f\n", yll);
  fprintf(wfp, "cellsize       %f\n", cells);
  fprintf(wfp, "nodata_value   %g\n", nodata);

  for (i=0; i<nrows; i++)
    {
      if ((i % 5) == 0)
	  {
	    printf(".");
	    fflush(stdout);
	  }

      for (j=0; j<ncols; j++)
	if (map[i][j] == NODATA)
	  fprintf(wfp, " %g", nodata);
	else
	  fprintf(wfp, " %g", map[i][j]);
      fprintf(wfp, "\n");
    }
  printf("\n");
  fclose(wfp);
}

  
/* Fehler korrigiert ! */
void read_arcinfo_int_grid(fn, ncols, nrows, xll, yll, cells, nodata, map)
     char *fn;
     int *ncols, *nrows, *nodata;
     float *xll, *yll, *cells;
     int map[MAX_ROWS][MAX_COLS];
{
  FILE *rfp;
  int i, j;
  float x;

  rfp=fopen(fn, "r");

  if (rfp == NULL) fatal(fn);

  printf("reading %s.", fn);

  fscanf(rfp, "%*s %d\n", ncols);
  fscanf(rfp, "%*s %d\n", nrows);
  fscanf(rfp, "%*s %f\n", xll);
  fscanf(rfp, "%*s %f\n", yll);
  fscanf(rfp, "%*s %f\n", cells);
  fscanf(rfp, "%*s %d\n", nodata);

  for (i=0; i<*nrows; i++)
    {
      if ((i % 5) == 0)
	  {
	    printf(".");
	    fflush(stdout);
	  }


      for (j=0; j<*ncols; j++)
	{
	  fscanf(rfp, " %f", &x);
	  map[i][j] = (int)x;
	}
    }
  printf("\n");
  fclose(rfp);
}

/* Fehler korrigierte */
void read_arcinfo_float_grid(fn, scale, ncols, nrows, xll, yll, cells, map)
     char *fn;
     int *ncols, *nrows;
     float scale;
     float *xll, *yll, *cells;
     float map[MAX_ROWS][MAX_COLS];
{
  FILE *rfp;
  int x, i, j, nodata;

  rfp=fopen(fn, "r");

  if (rfp == NULL) 
    fatal(fn);

  printf("reading %s.", fn);

  fscanf(rfp, "%*s %d\n", ncols);
  fscanf(rfp, "%*s %d\n", nrows);
  fscanf(rfp, "%*s %f\n", xll);
  fscanf(rfp, "%*s %f\n", yll);
  fscanf(rfp, "%*s %f\n", cells);
  fscanf(rfp, "%*s %d\n", &nodata);


  for (i=0; i<*nrows; i++)
    {
      if ((i % 5) == 0)
	{
	  printf(".");
	  fflush(stdout);
	}
      for (j=0; j<*ncols; j++)
	{
	  fscanf(rfp, "%d", &x);
	  if (x==nodata)
	    map[i][j] = NODATA;
	  else
	    map[i][j] = x*scale;
	}
    }
  printf("\n");
  fclose(rfp);
}
  
void read_multilayer_float_map(in_map_dir, fn, scale, lmap, n_layer)
     char *in_map_dir;
     char *fn;
     float scale;
     float lmap[MAX_LAYER][MAX_ROWS][MAX_COLS];
     int n_layer;
{
  int k, ncols, nrows;
  float xll, yll, cells;
  float *map[MAX_ROWS][MAX_COLS];
  char ffn[255];
  char idx[] = "0";

  for (k=0; k<n_layer; k++)
    {
      ffn[0]='\0';
      strcat(ffn, in_map_dir);
      strcat(ffn, fn);
      strcat(ffn, idx);
      read_arcinfo_float_grid(ffn, scale, &ncols, &nrows, &xll, &yll, &cells, map);
      copy_into_layer(lmap, map, k, ncols, nrows); 
      idx[0]++;
    }
}

  
/* Fehler korrigiert */

void write_multilayer_float_map(out_map_dir, fn, ncols, nrows, xll, yll, cells, lmap, n_layer)
     char *out_map_dir;
     char *fn;
     float lmap[MAX_LAYER][MAX_ROWS][MAX_COLS];
     int n_layer;
     int ncols, nrows;
     float xll, yll;
     float cells;
{
  FILE *wfp;
  int i, j, k;
  char ffn[255];
  char idx[] = "0";

  for (k=0; k<n_layer; k++)
    {
      ffn[0]='\0';
      strcat(ffn, out_map_dir);
      strcat(ffn, fn);
      strcat(ffn, idx);
      strcat(ffn, ".asc");

      wfp = fopen(ffn, "w");

      if (wfp == NULL) fatal(ffn);
      
      printf("writing %s.", ffn);

      fprintf(wfp, "ncols          %d\n", ncols);
      fprintf(wfp, "nrows          %d\n", nrows);
      fprintf(wfp, "xllcorner      %f\n", xll);
      fprintf(wfp, "yllcorner      %f\n", yll);
      fprintf(wfp, "cellsize       %f\n", cells);
      fprintf(wfp, "nodata_value   %g\n", NODATA);

      for (i=0; i<nrows; i++)
	{
	  if ((i % 5) == 0)
	    printf(".");
	  
	  for (j=0; j<ncols; j++)
	    fprintf(wfp, " %g", lmap[k][i][j]);

	  fprintf(wfp, "\n");
	}
      printf("\n");
      fclose(wfp);
      idx[0]++; 
    }
}

statistics_on_float_map(f_map, ncols, nrows, min, max, avg, sum)
     float f_map[MAX_ROWS][MAX_COLS];
     int ncols, nrows;
     float *min, *max, *avg, *sum;
{
  int i,j, cnt;

  *sum = 0.0;
  *min = 1e99;
  *max = -1e99;
  cnt = 0;

  for (i=0; i<nrows; i++)
    for (j=0; j<ncols; j++)
      if (!is_float_nodata(f_map[i][j]))
	{
	  *sum = *sum + f_map[i][j];
	  *min = (f_map[i][j] < *min ? f_map[i][j] : *min);
	  *max = (f_map[i][j] > *max ? f_map[i][j] : *max);
	  cnt++;
      }
  *avg = *sum/(float)(cnt);
}

void correct_SME_float_map(f_map, correct_value, ncols, nrows, studyarea, nodata)
     float f_map[MAX_ROWS][MAX_COLS];     
     float correct_value;
     int ncols, nrows, nodata;
     int studyarea[MAX_ROWS][MAX_COLS];
{
  int i, j;

  for (i=0; i<nrows; i++)
    for (j=0; j<ncols; j++)
      if ((studyarea[i][j] != nodata) && (is_float_nodata(f_map[i][j])))
	f_map[i][j] = correct_value;
}

void correct_SME_multilayer_float_map(f_map, correct_value, ncols, nrows, n_layer, studyarea, nodata)
     float f_map[MAX_LAYER][MAX_ROWS][MAX_COLS];     
     float correct_value;
     int n_layer;
     int ncols, nrows, nodata;
     int studyarea[MAX_ROWS][MAX_COLS];
{
  int i, j, k;

  for (i=0; i<nrows; i++)
    for (j=0; j<ncols; j++)
      for (k=0; k<n_layer; k++)
	if ((studyarea[i][j] != nodata) && (is_float_nodata(f_map[k][i][j])))
	  f_map[k][i][j] = correct_value;
}
				       
  



