#!/bin/sh
#####################################################################
#
#		Configures SME3 dist
#
#####################################################################

# You may edit the following options to configure for your machine.
# Copy the sme distribution to the $SME_HOME directory and unpack it there.
# Edit the SME version number below to correspond to the version of the 
# distribution.  Add $SME_HOME/bin/ to your PATH and copy this script to
# that directory.  Execute "sme_install.sh" and then "make install" in the
# root of the unpacked distribution ( $SME_HOME/sme-$SME_VERSION/ ). 
# You can then download, build, and run a demo model.  See the SME User's
# Guide for further information.
#
# This configuration assumes that the following packages have been 
# installed in your linux environment: j2sdk v. 1.4, g++, gcc, libxml2.
# The j2sdk package can be obtained from java.sun.com- the rest are
# included in the linux distribution (but not necessarily included in 
# the default installation package set).

SME_VERSION=3.2.71
SME_HOME=/usr/share/sme

CC=gcc
CXX=g++
#CC=cc
#CXX=CC
CFLAGS="-w"
OPTFLAGS="-O3"
DBGFLAGS="-g"

export CFLAGS
export OPTFLAGS
export DBGFLAGS
export CC
export CXX

ENABLE_DBG="no"
ENABLE_OPT="yes"

SME3_DIR=$SME_HOME/sme-$SME_VERSION
TARGET=$SME_HOME

cd $SME3_DIR
 
./configure --enable-rpm=yes --enable-debug=$ENABLE_DBG --enable-opt=$ENABLE_OPT --enable-mpi=no --prefix=$TARGET


# The configure script should complete with the message "Configure completed successfully!".
# Check for error messages after completion.
# If configure is successful, install the SME using "make install".
# If you get lost, send email to: maxwell@cbl.umces.edu.








