#!/usr/bin/perl
#[you may need to change the first line to point to the directory containing Perl on your server]

# survserv.pl -- the Perseus Survey Server
# (c) 1997-1998 Perseus Development Corp.
# for assistance, contact techsupport@perseus.com

# this form handler is designed to be dumb as a brick:
# the HTML file that uses this handler is automatically generated;
# the processing of the results sent by this handler is automatic.
# If you want to replace this with a more powerful handler, simply
# ensure that the response e-mail is a series of name/value pairs,
# such as 1 = 15 (each separated by a line feed), where 1 is the form
# name and 15 is the corresponding form value.  Three fields are 
# required to be in the HTML form:  PDCPDCEmailAddress, PDCPDCProjectID,
# and PDCPDCThankYouPage.

# read the data
read(STDIN, $frmdat, $ENV{'CONTENT_LENGTH'});
# [on DOS servers, use this instead: read(STDIN, $frmdat, 32767);]

# parse the form data into name/value pairs
@namval = sort(split(/&/,$frmdat));
foreach (@namval) {
   tr/+/ /;
   s/=/ = /;
   s/%(..)/pack("C",hex($1))/ge;
   ($nam, $val) = split(/ = /,$_,2);
   $dat{$nam} = $val;
}


#################################################
# MODIFIED: Steve Traver (12/8/2000)
# Server log reported invalid header info being
# sent. Added the following code to prevent this:
#################################################
print "Content-type: text/html\n\n";


# set the email address to mail to, from a hidden field in the survey form
$email = $dat{'PDCPDCEmailAddress'};

# open the mail program
# [make sure the next statement points to the mail system on your server;  one alternative: open(MAILOUT, "| mail $email") || ]
open(MAILOUT, "| /usr/lib/sendmail $email") || 
   die "Can't start mail program."; 
# [to test on a system without mail: open (MAILOUT, ">mail.txt");]

# print the subject header
print MAILOUT "Subject: ", $dat{'PDCPDCProjectID'}, "\n";

# print a sender e-mail address (change this to your own address);
# this is a redundancy in case of error messages, such as setting the
# PDCPDCEmailAddress to an account that doesn't exist yet
print MAILOUT "From: ssusr\@tahiti.sfwmd.gov\n";    #survserv\@perseus.com\n";

# no need to print the Thank You Page HTML to the mail message
# -- first store the Thank You Page so it can be displayed later
$thankyoupage = $dat{'PDCPDCThankYouPage'};
# -- set it to null
$dat{'PDCPDCThankYouPage'} = "";

# print the form data to the mail message
foreach $nam (keys(%dat)) {
   print MAILOUT $nam, " = ", $dat{$nam}, "\n";
}

# print desired environmental variables
print MAILOUT "HTTP_USER_AGENT = ", $ENV{'HTTP_USER_AGENT'}, "\n";
print MAILOUT "REMOTE_ADDR = ", $ENV{'REMOTE_ADDR'}, "\n";
print MAILOUT "REMOTE_HOST = ", $ENV{'REMOTE_HOST'}, "\n";
print MAILOUT "REMOTE_NAME = ", $ENV{'REMOTE_NAME'}, "\n";
print MAILOUT "REMOTE_USER = ", $ENV{'REMOTE_USER'}, "\n";
	
# close the mail message
close(MAILOUT); 

# provide a thank you page (set by a hidden field in the survey form; always present)

# Inserted by RST 1/8/99
  open(RET_PAGE, $thankyoupage) || die "Can't find return page.";
  @newpagebuffer = <RET_PAGE>;
  close (RET_PAGE);

##########print "Content-type: text/html\n\n";
print @newpagebuffer;

# close standard output
