#include "HNMD.h"


void gInitializeModel() {
	TModel::I().GlobalMod(&HNMD_module::I());
	HNMD_module::I().Initialize();
	HNMD_module::I().SetMInfo(TModule::kisGlobal,True);
	DOM_module::I().Initialize();
	ETPM_module::I().Initialize();
	GLOBALS_module::I().Initialize();
	PAR_module::I().Initialize();
	MACROPHYTES_module::I().Initialize();
	XXXImports2_module::I().Initialize();
	HYDROLOGY_module::I().Initialize();
	ZDIN_module::I().Initialize();
	HNMD_module::I().MakeConnections();
	DOM_module::I().MakeConnections();
	ETPM_module::I().MakeConnections();
	GLOBALS_module::I().MakeConnections();
	PAR_module::I().MakeConnections();
	MACROPHYTES_module::I().MakeConnections();
	XXXImports2_module::I().MakeConnections();
	HYDROLOGY_module::I().MakeConnections();
	ZDIN_module::I().MakeConnections();
}

// ---------------------------------------------------------------------------
//                    Class HNMD_module 
// ---------------------------------------------------------------------------
HNMD_module::HNMD_module(char* name) :
	TIME("TIME"),
	TModule(name) {

}	
HNMD_module* HNMD_module::fInstance = NULL;
HNMD_module* HNMD_module::kNullModel = (HNMD_module*)0x1;
int HNMD_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int HNMD_module::InitVars() {
	
	TIME.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int HNMD_module::Initialize() {
	InitVars();
	HNMD_module::I().AddSubModule(&DOM_module::I());
	HNMD_module::I().AddSubModule(&ETPM_module::I());
	HNMD_module::I().AddSubModule(&GLOBALS_module::I());
	HNMD_module::I().AddSubModule(&PAR_module::I());
	HNMD_module::I().AddSubModule(&MACROPHYTES_module::I());
	HNMD_module::I().AddSubModule(&XXXImports2_module::I());
	HNMD_module::I().AddSubModule(&HYDROLOGY_module::I());
	HNMD_module::I().AddSubModule(&ZDIN_module::I());
	Model::I0().ModuleList().Alphabetize();
	return 1;
}

int HNMD_module::MakeConnections() {
	DOM_module::I().PHBIO_MORT.Connect(&(MACROPHYTES_module::I().PHBIO_MORT));
	DOM_module::I().PHBIO_HARVEST.Connect(&(MACROPHYTES_module::I().PHBIO_HARVEST));
	DOM_module::I().NPHBIO_MORT.Connect(&(MACROPHYTES_module::I().NPHBIO_MORT));
	DOM_module::I().NPHBIO_HARVEST.Connect(&(MACROPHYTES_module::I().NPHBIO_HARVEST));
	DOM_module::I().AIR_TEMP_C.Connect(&(GLOBALS_module::I().AIR_TEMP_C));
	ETPM_module::I().VAP_PRESS.Connect(&(GLOBALS_module::I().VAP_PRESS));
	ETPM_module::I().AIR_TEMP_C.Connect(&(GLOBALS_module::I().AIR_TEMP_C));
	ETPM_module::I().SOLRADATM.Connect(&(PAR_module::I().SOLRADATM));
	ETPM_module::I().CLOUDY.Connect(&(GLOBALS_module::I().CLOUDY));
	ETPM_module::I().MACH.Connect(&(MACROPHYTES_module::I().MACH));
	ETPM_module::I().WIND.Connect(&(GLOBALS_module::I().WIND));
	ETPM_module::I().MACLAI.Connect(&(MACROPHYTES_module::I().MACLAI));
	GLOBALS_module::I().SOLRADATM.Connect(&(PAR_module::I().SOLRADATM));
	GLOBALS_module::I().SOLRADGRD.Connect(&(PAR_module::I().SOLRADGRD));
	PAR_module::I().P1_C_LATDEG.Connect(&(GLOBALS_module::I().P1_C_LATDEG));
	PAR_module::I().CLOUDY.Connect(&(GLOBALS_module::I().CLOUDY));
	PAR_module::I().DAYJUL.Connect(&(GLOBALS_module::I().DAYJUL));
	MACROPHYTES_module::I().AIR_TEMP_C.Connect(&(GLOBALS_module::I().AIR_TEMP_C));
	MACROPHYTES_module::I().HABITATMAP.Connect(&(GLOBALS_module::I().HABITATMAP));
	MACROPHYTES_module::I().DAYJUL.Connect(&(GLOBALS_module::I().DAYJUL));
	MACROPHYTES_module::I().DAYLENGTH.Connect(&(GLOBALS_module::I().DAYLENGTH));
	MACROPHYTES_module::I().SOLRADGR.Connect(&(XXXImports2_module::I().SOLRADGR));
	MACROPHYTES_module::I().DIN_AVAILABLE.Connect(&(ZDIN_module::I().DIN_AVAILABLE));
	MACROPHYTES_module::I().ELEVATION.Connect(&(GLOBALS_module::I().ELEVATION));
	MACROPHYTES_module::I().SURFACE_WATER.Connect(&(HYDROLOGY_module::I().SURFACE_WATER));
	MACROPHYTES_module::I().UW_DEPTH.Connect(&(HYDROLOGY_module::I().UW_DEPTH));
	MACROPHYTES_module::I().WATER_AVAIL.Connect(&(HYDROLOGY_module::I().WATER_AVAIL));
	XXXImports2_module::I().DAYJUL.Connect(&(GLOBALS_module::I().DAYJUL));
	HYDROLOGY_module::I().ON_MAP.Connect(&(GLOBALS_module::I().ON_MAP));
	HYDROLOGY_module::I().DIN_SD.Connect(&(ZDIN_module::I().DIN_SD));
	HYDROLOGY_module::I().HABITATMAP.Connect(&(GLOBALS_module::I().HABITATMAP));
	HYDROLOGY_module::I().AIR_TEMP_C.Connect(&(GLOBALS_module::I().AIR_TEMP_C));
	HYDROLOGY_module::I().PRECIP_M.Connect(&(GLOBALS_module::I().PRECIP_M));
	HYDROLOGY_module::I().HYDRO.Connect(&(GLOBALS_module::I().HYDRO));
	HYDROLOGY_module::I().ELEVATION.Connect(&(GLOBALS_module::I().ELEVATION));
	HYDROLOGY_module::I().DIN_SF.Connect(&(ZDIN_module::I().DIN_SF));
	HYDROLOGY_module::I().CELL_SIZE.Connect(&(GLOBALS_module::I().CELL_SIZE));
	HYDROLOGY_module::I().SOLRADGRD.Connect(&(PAR_module::I().SOLRADGRD));
	HYDROLOGY_module::I().MACLAI.Connect(&(MACROPHYTES_module::I().MACLAI));
	HYDROLOGY_module::I().SOIL.Connect(&(GLOBALS_module::I().SOIL));
	HYDROLOGY_module::I().HUMIDITY.Connect(&(GLOBALS_module::I().HUMIDITY));
	HYDROLOGY_module::I().WIND.Connect(&(GLOBALS_module::I().WIND));
	HYDROLOGY_module::I().A_IN.Connect(&(ZDIN_module::I().A_IN));
	HYDROLOGY_module::I().ELEV_MIN.Connect(&(GLOBALS_module::I().ELEV_MIN));
	HYDROLOGY_module::I().ETPM.Connect(&(ETPM_module::I().ETPM));
	HYDROLOGY_module::I().ROOT_DEPTH.Connect(&(MACROPHYTES_module::I().ROOT_DEPTH));
	HYDROLOGY_module::I().P1_DATUM_TO_MSL.Connect(&(GLOBALS_module::I().P1_DATUM_TO_MSL));
	ZDIN_module::I().SAT_WATER.Connect(&(HYDROLOGY_module::I().SAT_WATER));
	ZDIN_module::I().UNSAT_WATER.Connect(&(HYDROLOGY_module::I().UNSAT_WATER));
	ZDIN_module::I().UW_FROM_PRECIP.Connect(&(HYDROLOGY_module::I().UW_FROM_PRECIP));
	ZDIN_module::I().SW_TO_SATW_DOWNFLOW.Connect(&(HYDROLOGY_module::I().SW_TO_SATW_DOWNFLOW));
	ZDIN_module::I().SATW_FROM_PRECIP.Connect(&(HYDROLOGY_module::I().SATW_FROM_PRECIP));
	ZDIN_module::I().CELL_SIZE.Connect(&(GLOBALS_module::I().CELL_SIZE));
	ZDIN_module::I().AIR_TEMP_C.Connect(&(GLOBALS_module::I().AIR_TEMP_C));
	ZDIN_module::I().SATW_TO_SW_UPFLOW.Connect(&(HYDROLOGY_module::I().SATW_TO_SW_UPFLOW));
	ZDIN_module::I().PHBIO_NPP.Connect(&(MACROPHYTES_module::I().PHBIO_NPP));
	ZDIN_module::I().UW_DEPTH.Connect(&(HYDROLOGY_module::I().UW_DEPTH));
	ZDIN_module::I().ELEVATION.Connect(&(GLOBALS_module::I().ELEVATION));
	ZDIN_module::I().SATW_OUTFLUX.Connect(&(HYDROLOGY_module::I().SATW_OUTFLUX));
	ZDIN_module::I().SW_OUTFLUX.Connect(&(HYDROLOGY_module::I().SW_OUTFLUX));
	ZDIN_module::I().DAYJUL.Connect(&(GLOBALS_module::I().DAYJUL));
	ZDIN_module::I().HABITATMAP.Connect(&(GLOBALS_module::I().HABITATMAP));
	ZDIN_module::I().ROOT_DEPTH.Connect(&(MACROPHYTES_module::I().ROOT_DEPTH));
	ZDIN_module::I().SURFACE_WATER.Connect(&(HYDROLOGY_module::I().SURFACE_WATER));
	ZDIN_module::I().D_DECOMP.Connect(&(DOM_module::I().D_DECOMP));
	ZDIN_module::I().P1_SEWERMAP.Connect(&(GLOBALS_module::I().P1_SEWERMAP));
	ZDIN_module::I().P1_POP_DENS.Connect(&(GLOBALS_module::I().P1_POP_DENS));
	MACROPHYTES_module::I().SOLRADGR.Connect(&(XXXImports2_module::I().SOLRADGR));
	XXXImports2_module::I().DAYJUL.Connect(&(GLOBALS_module::I().DAYJUL));
	return 0;
}

int HNMD_module::SetupEvents() {
	return 0;
}

int HNMD_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int HNMD_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int HNMD_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int HNMD_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

int HNMD_module::PostInit() {
	PostEventsByType(TEvent::kInit);
	return 1;
}

// ---------------------------------------------------------------------------
//                    Class DOM_module 
// ---------------------------------------------------------------------------
DOM_module::DOM_module(char* name) :
	TIME("TIME"),
	PHBIO_MORT("PHBIO_MORT"),
	PHBIO_HARVEST("PHBIO_HARVEST"),
	NPHBIO_MORT("NPHBIO_MORT"),
	NPHBIO_HARVEST("NPHBIO_HARVEST"),
	AIR_TEMP_C("AIR_TEMP_C"),
	D_DECOMP("D_DECOMP"),
	DEP_ORG_MAT("DEP_ORG_MAT"),
	SD_TO_DOM("SD_TO_DOM"),
	DOM_DECOMP("DOM_DECOMP"),
	LAB_DETRITUS("LAB_DETRITUS"),
	SD_DECOMP("SD_DECOMP"),
	LD_IN("LD_IN"),
	LD_DECOMP("LD_DECOMP"),
	STAB_DETRITUS("STAB_DETRITUS"),
	SD_IN("SD_IN"),
	F_TEMP("F_TEMP"),
	P1_DOM_DEC_RATE("P1_DOM_DEC_RATE"),
	P1_DOM_INIT("P1_DOM_INIT"),
	P1_HARV_NPH_LEFT("P1_HARV_NPH_LEFT"),
	P1_HARV_PH_LEFT("P1_HARV_PH_LEFT"),
	P1_LD_DEC_RATE("P1_LD_DEC_RATE"),
	P1_LD_INIT("P1_LD_INIT"),
	P1_NPH_LIGNIN_CONTENT("P1_NPH_LIGNIN_CONTENT"),
	P1_PH_LIGNIN_CONTENT("P1_PH_LIGNIN_CONTENT"),
	P1_SD_DEC_RATE("P1_SD_DEC_RATE"),
	P1_SD_INIT("P1_SD_INIT"),
	P1_SD_TO_DOM_RATE("P1_SD_TO_DOM_RATE"),
	TModule(name) {

	PHBIO_MORT.SetF(FisImport,True,"CG");
	PHBIO_HARVEST.SetF(FisImport,True,"CG");
	NPHBIO_MORT.SetF(FisImport,True,"CG");
	NPHBIO_HARVEST.SetF(FisImport,True,"CG");
	AIR_TEMP_C.SetF(FisImport,True,"CG");
	D_DECOMP.SetF(FisExport,True,"CG");
}	
int DOM_module::DEP_ORG_MAT_I0_exe() {
	float value;

	DEP_ORG_MAT.UpdateIntegrator();
	switch( DEP_ORG_MAT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DEP_ORG_MAT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SD_TO_DOM.Value(p)-DOM_DECOMP.Value(p) );
			DEP_ORG_MAT.Update( p, value, dT() );
		}
		DEP_ORG_MAT.GrabMemory();
		if( DEP_ORG_MAT.GetF(FLinkEdges) ) { DEP_ORG_MAT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SD_TO_DOM.Value()-DOM_DECOMP.Value() );
			DEP_ORG_MAT.Update( value, dT() );
	  } break;
	}
	return 0;
}

int DOM_module::DEP_ORG_MAT_i1_exe() {
	float value;

	DEP_ORG_MAT.UpdateIntegrator();
	switch( DEP_ORG_MAT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DEP_ORG_MAT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  P1_DOM_INIT.Value(p);
			DEP_ORG_MAT.InitValue( p, value );
		}
		DEP_ORG_MAT.GrabMemory();
		if( DEP_ORG_MAT.GetF(FLinkEdges) ) { DEP_ORG_MAT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  P1_DOM_INIT.Value();
			DEP_ORG_MAT.InitValue( value );
	  } break;
	}
	return 0;
}

int DOM_module::SD_TO_DOM_u2_exe() {
	float value;

	switch( SD_TO_DOM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SD_TO_DOM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_SD_TO_DOM_RATE.Value(p)*STAB_DETRITUS.Value(p) );
			SD_TO_DOM.Update( p, value );
		}
		SD_TO_DOM.GrabMemory();
		if( SD_TO_DOM.GetF(FICFlux) ) SD_TO_DOM.Cov().Set(0.0); 
		if( SD_TO_DOM.GetF(FLinkEdges) ) { SD_TO_DOM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_SD_TO_DOM_RATE.Value()*STAB_DETRITUS.Value() );
			SD_TO_DOM.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::DOM_DECOMP_u3_exe() {
	float value;

	switch( DOM_DECOMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DOM_DECOMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_DOM_DEC_RATE.Value(p)*F_TEMP.Value(p) )*DEP_ORG_MAT.Value(p) );
			DOM_DECOMP.Update( p, value );
		}
		DOM_DECOMP.GrabMemory();
		if( DOM_DECOMP.GetF(FICFlux) ) DOM_DECOMP.Cov().Set(0.0); 
		if( DOM_DECOMP.GetF(FLinkEdges) ) { DOM_DECOMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_DOM_DEC_RATE.Value()*F_TEMP.Value() )*DEP_ORG_MAT.Value() );
			DOM_DECOMP.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::LAB_DETRITUS_I4_exe() {
	float value;

	LAB_DETRITUS.UpdateIntegrator();
	switch( LAB_DETRITUS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LAB_DETRITUS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SD_DECOMP.Value(p)+LD_IN.Value(p) )-LD_DECOMP.Value(p) );
			LAB_DETRITUS.Update( p, value, dT() );
		}
		LAB_DETRITUS.GrabMemory();
		if( LAB_DETRITUS.GetF(FLinkEdges) ) { LAB_DETRITUS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SD_DECOMP.Value()+LD_IN.Value() )-LD_DECOMP.Value() );
			LAB_DETRITUS.Update( value, dT() );
	  } break;
	}
	return 0;
}

int DOM_module::LAB_DETRITUS_i5_exe() {
	float value;

	LAB_DETRITUS.UpdateIntegrator();
	switch( LAB_DETRITUS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LAB_DETRITUS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  P1_LD_INIT.Value(p);
			LAB_DETRITUS.InitValue( p, value );
		}
		LAB_DETRITUS.GrabMemory();
		if( LAB_DETRITUS.GetF(FLinkEdges) ) { LAB_DETRITUS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  P1_LD_INIT.Value();
			LAB_DETRITUS.InitValue( value );
	  } break;
	}
	return 0;
}

int DOM_module::SD_DECOMP_u6_exe() {
	float value;

	switch( SD_DECOMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SD_DECOMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_SD_DEC_RATE.Value(p)*F_TEMP.Value(p) )*STAB_DETRITUS.Value(p) );
			SD_DECOMP.Update( p, value );
		}
		SD_DECOMP.GrabMemory();
		if( SD_DECOMP.GetF(FICFlux) ) SD_DECOMP.Cov().Set(0.0); 
		if( SD_DECOMP.GetF(FLinkEdges) ) { SD_DECOMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_SD_DEC_RATE.Value()*F_TEMP.Value() )*STAB_DETRITUS.Value() );
			SD_DECOMP.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::LD_IN_u7_exe() {
	float value;

	switch( LD_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LD_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ((float)1)-P1_PH_LIGNIN_CONTENT.Value(p) )*( PHBIO_MORT.Value(p)+( PHBIO_HARVEST.Value(p)*P1_HARV_PH_LEFT.Value(p) ) ) )+( ( ((float)1)-P1_NPH_LIGNIN_CONTENT.Value(p) )*( NPHBIO_MORT.Value(p)+( NPHBIO_HARVEST.Value(p)*P1_HARV_NPH_LEFT.Value(p) ) ) ) );
			LD_IN.Update( p, value );
		}
		LD_IN.GrabMemory();
		if( LD_IN.GetF(FICFlux) ) LD_IN.Cov().Set(0.0); 
		if( LD_IN.GetF(FLinkEdges) ) { LD_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ((float)1)-P1_PH_LIGNIN_CONTENT.Value() )*( PHBIO_MORT.Value()+( PHBIO_HARVEST.Value()*P1_HARV_PH_LEFT.Value() ) ) )+( ( ((float)1)-P1_NPH_LIGNIN_CONTENT.Value() )*( NPHBIO_MORT.Value()+( NPHBIO_HARVEST.Value()*P1_HARV_NPH_LEFT.Value() ) ) ) );
			LD_IN.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::LD_DECOMP_u8_exe() {
	float value;

	switch( LD_DECOMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LD_DECOMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_LD_DEC_RATE.Value(p)*F_TEMP.Value(p) )*LAB_DETRITUS.Value(p) );
			LD_DECOMP.Update( p, value );
		}
		LD_DECOMP.GrabMemory();
		if( LD_DECOMP.GetF(FICFlux) ) LD_DECOMP.Cov().Set(0.0); 
		if( LD_DECOMP.GetF(FLinkEdges) ) { LD_DECOMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_LD_DEC_RATE.Value()*F_TEMP.Value() )*LAB_DETRITUS.Value() );
			LD_DECOMP.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::STAB_DETRITUS_I9_exe() {
	float value;

	STAB_DETRITUS.UpdateIntegrator();
	switch( STAB_DETRITUS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = STAB_DETRITUS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SD_IN.Value(p)-SD_DECOMP.Value(p) )-SD_TO_DOM.Value(p) );
			STAB_DETRITUS.Update( p, value, dT() );
		}
		STAB_DETRITUS.GrabMemory();
		if( STAB_DETRITUS.GetF(FLinkEdges) ) { STAB_DETRITUS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SD_IN.Value()-SD_DECOMP.Value() )-SD_TO_DOM.Value() );
			STAB_DETRITUS.Update( value, dT() );
	  } break;
	}
	return 0;
}

int DOM_module::STAB_DETRITUS_i10_exe() {
	float value;

	STAB_DETRITUS.UpdateIntegrator();
	switch( STAB_DETRITUS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = STAB_DETRITUS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  P1_SD_INIT.Value(p);
			STAB_DETRITUS.InitValue( p, value );
		}
		STAB_DETRITUS.GrabMemory();
		if( STAB_DETRITUS.GetF(FLinkEdges) ) { STAB_DETRITUS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  P1_SD_INIT.Value();
			STAB_DETRITUS.InitValue( value );
	  } break;
	}
	return 0;
}

int DOM_module::SD_IN_u11_exe() {
	float value;

	switch( SD_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SD_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_PH_LIGNIN_CONTENT.Value(p)*( PHBIO_MORT.Value(p)+( PHBIO_HARVEST.Value(p)*P1_HARV_PH_LEFT.Value(p) ) ) )+( P1_NPH_LIGNIN_CONTENT.Value(p)*( NPHBIO_MORT.Value(p)+( NPHBIO_HARVEST.Value(p)*P1_HARV_NPH_LEFT.Value(p) ) ) ) );
			SD_IN.Update( p, value );
		}
		SD_IN.GrabMemory();
		if( SD_IN.GetF(FICFlux) ) SD_IN.Cov().Set(0.0); 
		if( SD_IN.GetF(FLinkEdges) ) { SD_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_PH_LIGNIN_CONTENT.Value()*( PHBIO_MORT.Value()+( PHBIO_HARVEST.Value()*P1_HARV_PH_LEFT.Value() ) ) )+( P1_NPH_LIGNIN_CONTENT.Value()*( NPHBIO_MORT.Value()+( NPHBIO_HARVEST.Value()*P1_HARV_NPH_LEFT.Value() ) ) ) );
			SD_IN.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::D_DECOMP_u12_exe() {
	float value;

	switch( D_DECOMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = D_DECOMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DOM_DECOMP.Value(p)+LD_DECOMP.Value(p) );
			D_DECOMP.Update( p, value );
		}
		D_DECOMP.GrabMemory();
		if( D_DECOMP.GetF(FLinkEdges) ) { D_DECOMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DOM_DECOMP.Value()+LD_DECOMP.Value() );
			D_DECOMP.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::F_TEMP_u13_exe() {
	float value;

	switch( F_TEMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = F_TEMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  pow((double)((float)2),(double)( ( AIR_TEMP_C.Value(p)-((float)20) )/10. ) );
			F_TEMP.Update( p, value );
		}
		F_TEMP.GrabMemory();
		if( F_TEMP.GetF(FLinkEdges) ) { F_TEMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  pow((double)((float)2),(double)( ( AIR_TEMP_C.Value()-((float)20) )/10. ) );
			F_TEMP.Update( value );
	  } break;
	}
	return 0;
}

int DOM_module::P1_DOM_DEC_RATE_u14_exe() {
	float value;

	switch( P1_DOM_DEC_RATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DOM_DEC_RATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.001000;
			P1_DOM_DEC_RATE.Update( p, P1_DOM_DEC_RATE.ParameterValue(value,p) );
		}
		P1_DOM_DEC_RATE.GrabMemory();
		if( P1_DOM_DEC_RATE.GetF(FLinkEdges) ) { P1_DOM_DEC_RATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.001000;
			P1_DOM_DEC_RATE.Update( P1_DOM_DEC_RATE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_DOM_INIT_u15_exe() {
	float value;

	switch( P1_DOM_INIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DOM_INIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_DOM_INIT.Update( p, P1_DOM_INIT.ParameterValue(value,p) );
		}
		P1_DOM_INIT.GrabMemory();
		if( P1_DOM_INIT.GetF(FLinkEdges) ) { P1_DOM_INIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_DOM_INIT.Update( P1_DOM_INIT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_HARV_NPH_LEFT_u16_exe() {
	float value;

	switch( P1_HARV_NPH_LEFT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_HARV_NPH_LEFT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.800000;
			P1_HARV_NPH_LEFT.Update( p, P1_HARV_NPH_LEFT.ParameterValue(value,p) );
		}
		P1_HARV_NPH_LEFT.GrabMemory();
		if( P1_HARV_NPH_LEFT.GetF(FLinkEdges) ) { P1_HARV_NPH_LEFT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.800000;
			P1_HARV_NPH_LEFT.Update( P1_HARV_NPH_LEFT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_HARV_PH_LEFT_u17_exe() {
	float value;

	switch( P1_HARV_PH_LEFT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_HARV_PH_LEFT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.100000;
			P1_HARV_PH_LEFT.Update( p, P1_HARV_PH_LEFT.ParameterValue(value,p) );
		}
		P1_HARV_PH_LEFT.GrabMemory();
		if( P1_HARV_PH_LEFT.GetF(FLinkEdges) ) { P1_HARV_PH_LEFT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.100000;
			P1_HARV_PH_LEFT.Update( P1_HARV_PH_LEFT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_LD_DEC_RATE_u18_exe() {
	float value;

	switch( P1_LD_DEC_RATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_LD_DEC_RATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.030000;
			P1_LD_DEC_RATE.Update( p, P1_LD_DEC_RATE.ParameterValue(value,p) );
		}
		P1_LD_DEC_RATE.GrabMemory();
		if( P1_LD_DEC_RATE.GetF(FLinkEdges) ) { P1_LD_DEC_RATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.030000;
			P1_LD_DEC_RATE.Update( P1_LD_DEC_RATE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_LD_INIT_u19_exe() {
	float value;

	switch( P1_LD_INIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_LD_INIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.800000;
			P1_LD_INIT.Update( p, P1_LD_INIT.ParameterValue(value,p) );
		}
		P1_LD_INIT.GrabMemory();
		if( P1_LD_INIT.GetF(FLinkEdges) ) { P1_LD_INIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.800000;
			P1_LD_INIT.Update( P1_LD_INIT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_NPH_LIGNIN_CONTENT_u20_exe() {
	float value;

	switch( P1_NPH_LIGNIN_CONTENT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_NPH_LIGNIN_CONTENT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.500000;
			P1_NPH_LIGNIN_CONTENT.Update( p, P1_NPH_LIGNIN_CONTENT.ParameterValue(value,p) );
		}
		P1_NPH_LIGNIN_CONTENT.GrabMemory();
		if( P1_NPH_LIGNIN_CONTENT.GetF(FLinkEdges) ) { P1_NPH_LIGNIN_CONTENT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.500000;
			P1_NPH_LIGNIN_CONTENT.Update( P1_NPH_LIGNIN_CONTENT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_PH_LIGNIN_CONTENT_u21_exe() {
	float value;

	switch( P1_PH_LIGNIN_CONTENT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PH_LIGNIN_CONTENT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.025000;
			P1_PH_LIGNIN_CONTENT.Update( p, P1_PH_LIGNIN_CONTENT.ParameterValue(value,p) );
		}
		P1_PH_LIGNIN_CONTENT.GrabMemory();
		if( P1_PH_LIGNIN_CONTENT.GetF(FLinkEdges) ) { P1_PH_LIGNIN_CONTENT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.025000;
			P1_PH_LIGNIN_CONTENT.Update( P1_PH_LIGNIN_CONTENT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_SD_DEC_RATE_u22_exe() {
	float value;

	switch( P1_SD_DEC_RATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SD_DEC_RATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.001000;
			P1_SD_DEC_RATE.Update( p, P1_SD_DEC_RATE.ParameterValue(value,p) );
		}
		P1_SD_DEC_RATE.GrabMemory();
		if( P1_SD_DEC_RATE.GetF(FLinkEdges) ) { P1_SD_DEC_RATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.001000;
			P1_SD_DEC_RATE.Update( P1_SD_DEC_RATE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_SD_INIT_u23_exe() {
	float value;

	switch( P1_SD_INIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SD_INIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1.200000;
			P1_SD_INIT.Update( p, P1_SD_INIT.ParameterValue(value,p) );
		}
		P1_SD_INIT.GrabMemory();
		if( P1_SD_INIT.GetF(FLinkEdges) ) { P1_SD_INIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1.200000;
			P1_SD_INIT.Update( P1_SD_INIT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DOM_module::P1_SD_TO_DOM_RATE_u24_exe() {
	float value;

	switch( P1_SD_TO_DOM_RATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SD_TO_DOM_RATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000700;
			P1_SD_TO_DOM_RATE.Update( p, P1_SD_TO_DOM_RATE.ParameterValue(value,p) );
		}
		P1_SD_TO_DOM_RATE.GrabMemory();
		if( P1_SD_TO_DOM_RATE.GetF(FLinkEdges) ) { P1_SD_TO_DOM_RATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000700;
			P1_SD_TO_DOM_RATE.Update( P1_SD_TO_DOM_RATE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

DOM_module* DOM_module::fInstance = NULL;
DOM_module* DOM_module::kNullModel = (DOM_module*)0x1;
int DOM_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int DOM_module::InitVars() {
	
	TIME.SSInit(this);
	PHBIO_MORT.SSInit(this);
	PHBIO_HARVEST.SSInit(this);
	NPHBIO_MORT.SSInit(this);
	NPHBIO_HARVEST.SSInit(this);
	AIR_TEMP_C.SSInit(this);
	D_DECOMP.SSInit(this);
	DEP_ORG_MAT.SSInit(this);
	SD_TO_DOM.SSInit(this);
	SD_TO_DOM.SetOrigin(&STAB_DETRITUS);
	SD_TO_DOM.SetDestination(&DEP_ORG_MAT);
	DOM_DECOMP.SSInit(this);
	DOM_DECOMP.SetOrigin(&DEP_ORG_MAT);
	LAB_DETRITUS.SSInit(this);
	SD_DECOMP.SSInit(this);
	SD_DECOMP.SetOrigin(&STAB_DETRITUS);
	SD_DECOMP.SetDestination(&LAB_DETRITUS);
	LD_IN.SSInit(this);
	LD_IN.SetDestination(&LAB_DETRITUS);
	LD_DECOMP.SSInit(this);
	LD_DECOMP.SetOrigin(&LAB_DETRITUS);
	STAB_DETRITUS.SSInit(this);
	SD_IN.SSInit(this);
	SD_IN.SetDestination(&STAB_DETRITUS);
	F_TEMP.SSInit(this);
	P1_DOM_DEC_RATE.SSInit(this);
	P1_DOM_INIT.SSInit(this);
	P1_HARV_NPH_LEFT.SSInit(this);
	P1_HARV_PH_LEFT.SSInit(this);
	P1_LD_DEC_RATE.SSInit(this);
	P1_LD_INIT.SSInit(this);
	P1_NPH_LIGNIN_CONTENT.SSInit(this);
	P1_PH_LIGNIN_CONTENT.SSInit(this);
	P1_SD_DEC_RATE.SSInit(this);
	P1_SD_INIT.SSInit(this);
	P1_SD_TO_DOM_RATE.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int DOM_module::SetupEvents() {
	TImportCommand* PHBIO_MORT_import = (TImportCommand*) PHBIO_MORT.GetCommand("PHBIO_MORT_import",TCommand::kUndefined,TCommand::kImport);
	PHBIO_MORT_import->Code() = "Import PHBIO_MORT from MACROPHYTES_module";
	PHBIO_MORT_import->AddDependency(PHBIO_MORT);
	PHBIO_MORT_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PHBIO_HARVEST_import = (TImportCommand*) PHBIO_HARVEST.GetCommand("PHBIO_HARVEST_import",TCommand::kUndefined,TCommand::kImport);
	PHBIO_HARVEST_import->Code() = "Import PHBIO_HARVEST from MACROPHYTES_module";
	PHBIO_HARVEST_import->AddDependency(PHBIO_HARVEST);
	PHBIO_HARVEST_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* NPHBIO_MORT_import = (TImportCommand*) NPHBIO_MORT.GetCommand("NPHBIO_MORT_import",TCommand::kUndefined,TCommand::kImport);
	NPHBIO_MORT_import->Code() = "Import NPHBIO_MORT from MACROPHYTES_module";
	NPHBIO_MORT_import->AddDependency(NPHBIO_MORT);
	NPHBIO_MORT_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* NPHBIO_HARVEST_import = (TImportCommand*) NPHBIO_HARVEST.GetCommand("NPHBIO_HARVEST_import",TCommand::kUndefined,TCommand::kImport);
	NPHBIO_HARVEST_import->Code() = "Import NPHBIO_HARVEST from MACROPHYTES_module";
	NPHBIO_HARVEST_import->AddDependency(NPHBIO_HARVEST);
	NPHBIO_HARVEST_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* AIR_TEMP_C_import = (TImportCommand*) AIR_TEMP_C.GetCommand("AIR_TEMP_C_import",TCommand::kUndefined,TCommand::kImport);
	AIR_TEMP_C_import->Code() = "Import AIR_TEMP_C from GLOBALS_module";
	AIR_TEMP_C_import->AddDependency(AIR_TEMP_C);
	AIR_TEMP_C_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u12 = (TExecuteCommand*) D_DECOMP.GetCommand("u12",TCommand::kUpdate,TCommand::kCode);
	u12->SetExecutable(&D_DECOMP_u12_exe_g);
	u12->Code() = "u12 <- ( DOM_DECOMP+LD_DECOMP )";
	u12->AddDependency(DOM_DECOMP);
	u12->AddDependency(LD_DECOMP);
	u12->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I0 = (TExecuteCommand*) DEP_ORG_MAT.GetCommand("I0",TCommand::kIntegrate,TCommand::kCode);
	I0->SetExecutable(&DEP_ORG_MAT_I0_exe_g);
	I0->Code() = "I0 <- ( SD_TO_DOM-DOM_DECOMP )";
	I0->AddDependency(SD_TO_DOM);
	I0->AddDependency(DOM_DECOMP);
	I0->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i1 = (TExecuteCommand*) DEP_ORG_MAT.GetCommand("i1",TCommand::kInit,TCommand::kCode);
	i1->SetExecutable(&DEP_ORG_MAT_i1_exe_g);
	i1->Code() = "i1 <- P1_DOM_INIT";
	i1->AddDependency(P1_DOM_INIT);
	i1->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u2 = (TExecuteCommand*) SD_TO_DOM.GetCommand("u2",TCommand::kUpdate,TCommand::kCode);
	u2->SetExecutable(&SD_TO_DOM_u2_exe_g);
	u2->Code() = "u2 <- ( P1_SD_TO_DOM_RATE*STAB_DETRITUS )";
	if( SD_TO_DOM.GetF(FisClamped) ) { u2->AddDependency(STAB_DETRITUS); }
	u2->AddDependency(P1_SD_TO_DOM_RATE);
	u2->AddDependency(STAB_DETRITUS);
	u2->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u3 = (TExecuteCommand*) DOM_DECOMP.GetCommand("u3",TCommand::kUpdate,TCommand::kCode);
	u3->SetExecutable(&DOM_DECOMP_u3_exe_g);
	u3->Code() = "u3 <- ( ( P1_DOM_DEC_RATE*F_TEMP )*DEP_ORG_MAT )";
	if( DOM_DECOMP.GetF(FisClamped) ) { u3->AddDependency(DEP_ORG_MAT); }
	u3->AddDependency(P1_DOM_DEC_RATE);
	u3->AddDependency(F_TEMP);
	u3->AddDependency(DEP_ORG_MAT);
	u3->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I4 = (TExecuteCommand*) LAB_DETRITUS.GetCommand("I4",TCommand::kIntegrate,TCommand::kCode);
	I4->SetExecutable(&LAB_DETRITUS_I4_exe_g);
	I4->Code() = "I4 <- ( ( SD_DECOMP+LD_IN )-LD_DECOMP )";
	I4->AddDependency(SD_DECOMP);
	I4->AddDependency(LD_IN);
	I4->AddDependency(LD_DECOMP);
	I4->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i5 = (TExecuteCommand*) LAB_DETRITUS.GetCommand("i5",TCommand::kInit,TCommand::kCode);
	i5->SetExecutable(&LAB_DETRITUS_i5_exe_g);
	i5->Code() = "i5 <- P1_LD_INIT";
	i5->AddDependency(P1_LD_INIT);
	i5->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u6 = (TExecuteCommand*) SD_DECOMP.GetCommand("u6",TCommand::kUpdate,TCommand::kCode);
	u6->SetExecutable(&SD_DECOMP_u6_exe_g);
	u6->Code() = "u6 <- ( ( P1_SD_DEC_RATE*F_TEMP )*STAB_DETRITUS )";
	if( SD_DECOMP.GetF(FisClamped) ) { u6->AddDependency(STAB_DETRITUS); }
	u6->AddDependency(P1_SD_DEC_RATE);
	u6->AddDependency(F_TEMP);
	u6->AddDependency(STAB_DETRITUS);
	u6->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u7 = (TExecuteCommand*) LD_IN.GetCommand("u7",TCommand::kUpdate,TCommand::kCode);
	u7->SetExecutable(&LD_IN_u7_exe_g);
	u7->Code() = "u7 <- ( ( ( ((float)1)-P1_PH_LIGNIN_CONTENT )*( PHBIO_MORT+( PHBIO_HARVEST*P1_HARV_PH_LEFT ) ) )+( ( ((float)1)-P1_NPH_LIGNIN_CONTENT )*( NPHBIO_MORT+( NPHBIO_HARVEST*P1_HARV_NPH_LEFT ) ) ) )";
	u7->AddDependency(P1_PH_LIGNIN_CONTENT);
	u7->AddDependency(PHBIO_MORT);
	u7->AddDependency(PHBIO_HARVEST);
	u7->AddDependency(P1_HARV_PH_LEFT);
	u7->AddDependency(P1_NPH_LIGNIN_CONTENT);
	u7->AddDependency(NPHBIO_MORT);
	u7->AddDependency(NPHBIO_HARVEST);
	u7->AddDependency(P1_HARV_NPH_LEFT);
	u7->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u8 = (TExecuteCommand*) LD_DECOMP.GetCommand("u8",TCommand::kUpdate,TCommand::kCode);
	u8->SetExecutable(&LD_DECOMP_u8_exe_g);
	u8->Code() = "u8 <- ( ( P1_LD_DEC_RATE*F_TEMP )*LAB_DETRITUS )";
	if( LD_DECOMP.GetF(FisClamped) ) { u8->AddDependency(LAB_DETRITUS); }
	u8->AddDependency(P1_LD_DEC_RATE);
	u8->AddDependency(F_TEMP);
	u8->AddDependency(LAB_DETRITUS);
	u8->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I9 = (TExecuteCommand*) STAB_DETRITUS.GetCommand("I9",TCommand::kIntegrate,TCommand::kCode);
	I9->SetExecutable(&STAB_DETRITUS_I9_exe_g);
	I9->Code() = "I9 <- ( ( SD_IN-SD_DECOMP )-SD_TO_DOM )";
	I9->AddDependency(SD_IN);
	I9->AddDependency(SD_DECOMP);
	I9->AddDependency(SD_TO_DOM);
	I9->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i10 = (TExecuteCommand*) STAB_DETRITUS.GetCommand("i10",TCommand::kInit,TCommand::kCode);
	i10->SetExecutable(&STAB_DETRITUS_i10_exe_g);
	i10->Code() = "i10 <- P1_SD_INIT";
	i10->AddDependency(P1_SD_INIT);
	i10->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u11 = (TExecuteCommand*) SD_IN.GetCommand("u11",TCommand::kUpdate,TCommand::kCode);
	u11->SetExecutable(&SD_IN_u11_exe_g);
	u11->Code() = "u11 <- ( ( P1_PH_LIGNIN_CONTENT*( PHBIO_MORT+( PHBIO_HARVEST*P1_HARV_PH_LEFT ) ) )+( P1_NPH_LIGNIN_CONTENT*( NPHBIO_MORT+( NPHBIO_HARVEST*P1_HARV_NPH_LEFT ) ) ) )";
	u11->AddDependency(P1_PH_LIGNIN_CONTENT);
	u11->AddDependency(PHBIO_MORT);
	u11->AddDependency(PHBIO_HARVEST);
	u11->AddDependency(P1_HARV_PH_LEFT);
	u11->AddDependency(P1_NPH_LIGNIN_CONTENT);
	u11->AddDependency(NPHBIO_MORT);
	u11->AddDependency(NPHBIO_HARVEST);
	u11->AddDependency(P1_HARV_NPH_LEFT);
	u11->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u13 = (TExecuteCommand*) F_TEMP.GetCommand("u13",TCommand::kUpdate,TCommand::kCode);
	u13->SetExecutable(&F_TEMP_u13_exe_g);
	u13->Code() = "u13 <- pow((double)((float)2),(double)( ( AIR_TEMP_C-((float)20) )/10. ) )";
	u13->AddDependency(AIR_TEMP_C);
	u13->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u14 = (TExecuteCommand*) P1_DOM_DEC_RATE.GetCommand("u14",TCommand::kUpdate,TCommand::kCode);
	u14->SetExecutable(&P1_DOM_DEC_RATE_u14_exe_g);
	u14->Code() = "u14 <- 0.001000";
	u14->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u15 = (TExecuteCommand*) P1_DOM_INIT.GetCommand("u15",TCommand::kUpdate,TCommand::kCode);
	u15->SetExecutable(&P1_DOM_INIT_u15_exe_g);
	u15->Code() = "u15 <- 1";
	u15->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u16 = (TExecuteCommand*) P1_HARV_NPH_LEFT.GetCommand("u16",TCommand::kUpdate,TCommand::kCode);
	u16->SetExecutable(&P1_HARV_NPH_LEFT_u16_exe_g);
	u16->Code() = "u16 <- 0.800000";
	u16->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u17 = (TExecuteCommand*) P1_HARV_PH_LEFT.GetCommand("u17",TCommand::kUpdate,TCommand::kCode);
	u17->SetExecutable(&P1_HARV_PH_LEFT_u17_exe_g);
	u17->Code() = "u17 <- 0.100000";
	u17->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u18 = (TExecuteCommand*) P1_LD_DEC_RATE.GetCommand("u18",TCommand::kUpdate,TCommand::kCode);
	u18->SetExecutable(&P1_LD_DEC_RATE_u18_exe_g);
	u18->Code() = "u18 <- 0.030000";
	u18->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u19 = (TExecuteCommand*) P1_LD_INIT.GetCommand("u19",TCommand::kUpdate,TCommand::kCode);
	u19->SetExecutable(&P1_LD_INIT_u19_exe_g);
	u19->Code() = "u19 <- 0.800000";
	u19->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u20 = (TExecuteCommand*) P1_NPH_LIGNIN_CONTENT.GetCommand("u20",TCommand::kUpdate,TCommand::kCode);
	u20->SetExecutable(&P1_NPH_LIGNIN_CONTENT_u20_exe_g);
	u20->Code() = "u20 <- 0.500000";
	u20->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u21 = (TExecuteCommand*) P1_PH_LIGNIN_CONTENT.GetCommand("u21",TCommand::kUpdate,TCommand::kCode);
	u21->SetExecutable(&P1_PH_LIGNIN_CONTENT_u21_exe_g);
	u21->Code() = "u21 <- 0.025000";
	u21->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u22 = (TExecuteCommand*) P1_SD_DEC_RATE.GetCommand("u22",TCommand::kUpdate,TCommand::kCode);
	u22->SetExecutable(&P1_SD_DEC_RATE_u22_exe_g);
	u22->Code() = "u22 <- 0.001000";
	u22->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u23 = (TExecuteCommand*) P1_SD_INIT.GetCommand("u23",TCommand::kUpdate,TCommand::kCode);
	u23->SetExecutable(&P1_SD_INIT_u23_exe_g);
	u23->Code() = "u23 <- 1.200000";
	u23->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u24 = (TExecuteCommand*) P1_SD_TO_DOM_RATE.GetCommand("u24",TCommand::kUpdate,TCommand::kCode);
	u24->SetExecutable(&P1_SD_TO_DOM_RATE_u24_exe_g);
	u24->Code() = "u24 <- 0.000700";
	u24->SetObjInfo(TCommand::kDepIndex, 5);
	return 0;
}

int DOM_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int DOM_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int DOM_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int DOM_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class ETPM_module 
// ---------------------------------------------------------------------------
ETPM_module::ETPM_module(char* name) :
	TIME("TIME"),
	VAP_PRESS("VAP_PRESS"),
	AIR_TEMP_C("AIR_TEMP_C"),
	SOLRADATM("SOLRADATM"),
	CLOUDY("CLOUDY"),
	MACH("MACH"),
	WIND("WIND"),
	MACLAI("MACLAI"),
	ETPM("ETPM"),
	D("D"),
	DELTA("DELTA"),
	ENERGY("ENERGY"),
	ES("ES"),
	GAMMA("GAMMA"),
	LAMBDA("LAMBDA"),
	P("P"),
	RA("RA"),
	RO("RO"),
	RS("RS"),
	TModule(name) {

	VAP_PRESS.SetF(FisImport,True,"CG");
	AIR_TEMP_C.SetF(FisImport,True,"CG");
	SOLRADATM.SetF(FisImport,True,"CG");
	CLOUDY.SetF(FisImport,True,"CG");
	MACH.SetF(FisImport,True,"CG");
	WIND.SetF(FisImport,True,"CG");
	MACLAI.SetF(FisImport,True,"CG");
	ETPM.SetF(FisExport,True,"CG");
}	
int ETPM_module::D_u31_exe() {
	float value;

	switch( D.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = D.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ES.Value(p)-( VAP_PRESS.Value(p)/1000 ) );
			D.Update( p, value );
		}
		D.GrabMemory();
		if( D.GetF(FLinkEdges) ) { D.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ES.Value()-( VAP_PRESS.Value()/1000 ) );
			D.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::DELTA_u32_exe() {
	float value;

	switch( DELTA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DELTA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ((float)4098)*ES.Value(p) )/( 237.3+AIR_TEMP_C.Value(p) ) )/( 237.3+AIR_TEMP_C.Value(p) ) );
			DELTA.Update( p, value );
		}
		DELTA.GrabMemory();
		if( DELTA.GetF(FLinkEdges) ) { DELTA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ((float)4098)*ES.Value() )/( 237.3+AIR_TEMP_C.Value() ) )/( 237.3+AIR_TEMP_C.Value() ) );
			DELTA.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::ENERGY_u33_exe() {
	float value;

	switch( ENERGY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ENERGY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( SOLRADATM.Value(p)/23.9 )*( 0.25+( ( 0.5*( ((float)10)-CLOUDY.Value(p) ) )/10 ) ) )-( ( ( ( ( ( ( 0.9*( ((float)10)-CLOUDY.Value(p) ) )/10 )+0.1 )*( 0.34-( 0.14*SL::Sqrt(VAP_PRESS.Value(p)) ) ) )*4.903 )*pow((double)((float)10),(double)-((float)9) ) )*pow((double)AIR_TEMP_C.Value(p),(double)((float)4) ) ) );
			ENERGY.Update( p, value );
		}
		ENERGY.GrabMemory();
		if( ENERGY.GetF(FLinkEdges) ) { ENERGY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( SOLRADATM.Value()/23.9 )*( 0.25+( ( 0.5*( ((float)10)-CLOUDY.Value() ) )/10 ) ) )-( ( ( ( ( ( ( 0.9*( ((float)10)-CLOUDY.Value() ) )/10 )+0.1 )*( 0.34-( 0.14*SL::Sqrt(VAP_PRESS.Value()) ) ) )*4.903 )*pow((double)((float)10),(double)-((float)9) ) )*pow((double)AIR_TEMP_C.Value(),(double)((float)4) ) ) );
			ENERGY.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::ES_u34_exe() {
	float value;

	switch( ES.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ES.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( 0.6108*SL::Exp(( ( 17.27*AIR_TEMP_C.Value(p) )/( 237.3+AIR_TEMP_C.Value(p) ) )) );
			ES.Update( p, value );
		}
		ES.GrabMemory();
		if( ES.GetF(FLinkEdges) ) { ES.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( 0.6108*SL::Exp(( ( 17.27*AIR_TEMP_C.Value() )/( 237.3+AIR_TEMP_C.Value() ) )) );
			ES.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::ETPM_u35_exe() {
	float value;

	switch( ETPM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ETPM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( DELTA.Value(p)*ENERGY.Value(p) )+( ( ( 1.013*RO.Value(p) )*D.Value(p) )/RA.Value(p) ) )/( DELTA.Value(p)+( GAMMA.Value(p)*( ((float)1)+( RS.Value(p)/RA.Value(p) ) ) ) ) )/LAMBDA.Value(p) )/1000 );
			ETPM.Update( p, value );
		}
		ETPM.GrabMemory();
		if( ETPM.GetF(FLinkEdges) ) { ETPM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( DELTA.Value()*ENERGY.Value() )+( ( ( 1.013*RO.Value() )*D.Value() )/RA.Value() ) )/( DELTA.Value()+( GAMMA.Value()*( ((float)1)+( RS.Value()/RA.Value() ) ) ) ) )/LAMBDA.Value() )/1000 );
			ETPM.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::GAMMA_u36_exe() {
	float value;

	switch( GAMMA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = GAMMA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( 0.0016286*P.Value(p) )/LAMBDA.Value(p) );
			GAMMA.Update( p, value );
		}
		GAMMA.GrabMemory();
		if( GAMMA.GetF(FLinkEdges) ) { GAMMA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( 0.0016286*P.Value() )/LAMBDA.Value() );
			GAMMA.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::LAMBDA_u37_exe() {
	float value;

	switch( LAMBDA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LAMBDA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( 2.501-( 0.002361*( AIR_TEMP_C.Value(p)-((float)3) ) ) );
			LAMBDA.Update( p, value );
		}
		LAMBDA.GrabMemory();
		if( LAMBDA.GetF(FLinkEdges) ) { LAMBDA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( 2.501-( 0.002361*( AIR_TEMP_C.Value()-((float)3) ) ) );
			LAMBDA.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::P_u38_exe() {
	float value;

	switch( P.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  101.300003;
			P.Update( p, P.ParameterValue(value,p) );
		}
		P.GrabMemory();
		if( P.GetF(FLinkEdges) ) { P.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  101.300003;
			P.Update( P.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ETPM_module::RA_u39_exe() {
	float value;

	switch( RA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = RA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( MACH.Value(p) >  0.001 ) ) ? ( ( ( ( ( ( SL::Logn(( ( ( ((float)25)/MACH.Value(p) )-0.67 )/0.123 ))*SL::Logn(( ( ( ((float)25)/MACH.Value(p) )-0.67 )/0.0123 )) )/0.41 )/0.41 )/WIND.Value(p) )/3.6 ) ) : ( pow((double)((float)10),(double)((float)10) ) ) ) ;
			RA.Update( p, value );
		}
		RA.GrabMemory();
		if( RA.GetF(FLinkEdges) ) { RA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( MACH.Value() >  0.001 ) ) ? ( ( ( ( ( ( SL::Logn(( ( ( ((float)25)/MACH.Value() )-0.67 )/0.123 ))*SL::Logn(( ( ( ((float)25)/MACH.Value() )-0.67 )/0.0123 )) )/0.41 )/0.41 )/WIND.Value() )/3.6 ) ) : ( pow((double)((float)10),(double)((float)10) ) ) ) ;
			RA.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::RO_u40_exe() {
	float value;

	switch( RO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = RO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( 3.486*P.Value(p) )/( ((float)275)+AIR_TEMP_C.Value(p) ) );
			RO.Update( p, value );
		}
		RO.GrabMemory();
		if( RO.GetF(FLinkEdges) ) { RO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( 3.486*P.Value() )/( ((float)275)+AIR_TEMP_C.Value() ) );
			RO.Update( value );
	  } break;
	}
	return 0;
}

int ETPM_module::RS_u41_exe() {
	float value;

	switch( RS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = RS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( MACLAI.Value(p) >  0.01 ) ) ? ( ( ((float)4)/MACLAI.Value(p) ) ) : ( pow((double)((float)10),(double)((float)10) ) ) ) ;
			RS.Update( p, value );
		}
		RS.GrabMemory();
		if( RS.GetF(FLinkEdges) ) { RS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( MACLAI.Value() >  0.01 ) ) ? ( ( ((float)4)/MACLAI.Value() ) ) : ( pow((double)((float)10),(double)((float)10) ) ) ) ;
			RS.Update( value );
	  } break;
	}
	return 0;
}

ETPM_module* ETPM_module::fInstance = NULL;
ETPM_module* ETPM_module::kNullModel = (ETPM_module*)0x1;
int ETPM_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int ETPM_module::InitVars() {
	
	TIME.SSInit(this);
	VAP_PRESS.SSInit(this);
	AIR_TEMP_C.SSInit(this);
	SOLRADATM.SSInit(this);
	CLOUDY.SSInit(this);
	MACH.SSInit(this);
	WIND.SSInit(this);
	MACLAI.SSInit(this);
	ETPM.SSInit(this);
	D.SSInit(this);
	DELTA.SSInit(this);
	ENERGY.SSInit(this);
	ES.SSInit(this);
	GAMMA.SSInit(this);
	LAMBDA.SSInit(this);
	P.SSInit(this);
	RA.SSInit(this);
	RO.SSInit(this);
	RS.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int ETPM_module::SetupEvents() {
	TImportCommand* VAP_PRESS_import = (TImportCommand*) VAP_PRESS.GetCommand("VAP_PRESS_import",TCommand::kUndefined,TCommand::kImport);
	VAP_PRESS_import->Code() = "Import VAP_PRESS from GLOBALS_module";
	VAP_PRESS_import->AddDependency(VAP_PRESS);
	VAP_PRESS_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* AIR_TEMP_C_import = (TImportCommand*) AIR_TEMP_C.GetCommand("AIR_TEMP_C_import",TCommand::kUndefined,TCommand::kImport);
	AIR_TEMP_C_import->Code() = "Import AIR_TEMP_C from GLOBALS_module";
	AIR_TEMP_C_import->AddDependency(AIR_TEMP_C);
	AIR_TEMP_C_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SOLRADATM_import = (TImportCommand*) SOLRADATM.GetCommand("SOLRADATM_import",TCommand::kUndefined,TCommand::kImport);
	SOLRADATM_import->Code() = "Import SOLRADATM from PAR_module";
	SOLRADATM_import->AddDependency(SOLRADATM);
	SOLRADATM_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CLOUDY_import = (TImportCommand*) CLOUDY.GetCommand("CLOUDY_import",TCommand::kUndefined,TCommand::kImport);
	CLOUDY_import->Code() = "Import CLOUDY from GLOBALS_module";
	CLOUDY_import->AddDependency(CLOUDY);
	CLOUDY_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* MACH_import = (TImportCommand*) MACH.GetCommand("MACH_import",TCommand::kUndefined,TCommand::kImport);
	MACH_import->Code() = "Import MACH from MACROPHYTES_module";
	MACH_import->AddDependency(MACH);
	MACH_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* WIND_import = (TImportCommand*) WIND.GetCommand("WIND_import",TCommand::kUndefined,TCommand::kImport);
	WIND_import->Code() = "Import WIND from GLOBALS_module";
	WIND_import->AddDependency(WIND);
	WIND_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* MACLAI_import = (TImportCommand*) MACLAI.GetCommand("MACLAI_import",TCommand::kUndefined,TCommand::kImport);
	MACLAI_import->Code() = "Import MACLAI from MACROPHYTES_module";
	MACLAI_import->AddDependency(MACLAI);
	MACLAI_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u35 = (TExecuteCommand*) ETPM.GetCommand("u35",TCommand::kUpdate,TCommand::kCode);
	u35->SetExecutable(&ETPM_u35_exe_g);
	u35->Code() = "u35 <- ( ( ( ( ( DELTA*ENERGY )+( ( ( 1.013*RO )*D )/RA ) )/( DELTA+( GAMMA*( ((float)1)+( RS/RA ) ) ) ) )/LAMBDA )/1000 )";
	u35->AddDependency(DELTA);
	u35->AddDependency(ENERGY);
	u35->AddDependency(RO);
	u35->AddDependency(D);
	u35->AddDependency(RA);
	u35->AddDependency(GAMMA);
	u35->AddDependency(RS);
	u35->AddDependency(LAMBDA);
	u35->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u31 = (TExecuteCommand*) D.GetCommand("u31",TCommand::kUpdate,TCommand::kCode);
	u31->SetExecutable(&D_u31_exe_g);
	u31->Code() = "u31 <- ( ES-( VAP_PRESS/1000 ) )";
	u31->AddDependency(ES);
	u31->AddDependency(VAP_PRESS);
	u31->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u32 = (TExecuteCommand*) DELTA.GetCommand("u32",TCommand::kUpdate,TCommand::kCode);
	u32->SetExecutable(&DELTA_u32_exe_g);
	u32->Code() = "u32 <- ( ( ( ((float)4098)*ES )/( 237.3+AIR_TEMP_C ) )/( 237.3+AIR_TEMP_C ) )";
	u32->AddDependency(ES);
	u32->AddDependency(AIR_TEMP_C);
	u32->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u33 = (TExecuteCommand*) ENERGY.GetCommand("u33",TCommand::kUpdate,TCommand::kCode);
	u33->SetExecutable(&ENERGY_u33_exe_g);
	u33->Code() = "u33 <- ( ( ( SOLRADATM/23.9 )*( 0.25+( ( 0.5*( ((float)10)-CLOUDY ) )/10 ) ) )-( ( ( ( ( ( ( 0.9*( ((float)10)-CLOUDY ) )/10 )+0.1 )*( 0.34-( 0.14*SL::Sqrt(VAP_PRESS) ) ) )*4.903 )*pow((double)((float)10),(double)-((float)9) ) )*pow((double)AIR_TEMP_C,(double)((float)4) ) ) )";
	u33->AddDependency(SOLRADATM);
	u33->AddDependency(CLOUDY);
	u33->AddDependency(VAP_PRESS);
	u33->AddDependency(AIR_TEMP_C);
	u33->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u34 = (TExecuteCommand*) ES.GetCommand("u34",TCommand::kUpdate,TCommand::kCode);
	u34->SetExecutable(&ES_u34_exe_g);
	u34->Code() = "u34 <- ( 0.6108*SL::Exp(( ( 17.27*AIR_TEMP_C )/( 237.3+AIR_TEMP_C ) )) )";
	u34->AddDependency(AIR_TEMP_C);
	u34->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u36 = (TExecuteCommand*) GAMMA.GetCommand("u36",TCommand::kUpdate,TCommand::kCode);
	u36->SetExecutable(&GAMMA_u36_exe_g);
	u36->Code() = "u36 <- ( ( 0.0016286*P )/LAMBDA )";
	u36->AddDependency(P);
	u36->AddDependency(LAMBDA);
	u36->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u37 = (TExecuteCommand*) LAMBDA.GetCommand("u37",TCommand::kUpdate,TCommand::kCode);
	u37->SetExecutable(&LAMBDA_u37_exe_g);
	u37->Code() = "u37 <- ( 2.501-( 0.002361*( AIR_TEMP_C-((float)3) ) ) )";
	u37->AddDependency(AIR_TEMP_C);
	u37->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u38 = (TExecuteCommand*) P.GetCommand("u38",TCommand::kUpdate,TCommand::kCode);
	u38->SetExecutable(&P_u38_exe_g);
	u38->Code() = "u38 <- 101.300003";
	u38->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u39 = (TExecuteCommand*) RA.GetCommand("u39",TCommand::kUpdate,TCommand::kCode);
	u39->SetExecutable(&RA_u39_exe_g);
	u39->Code() = "u39 <-  ( ( ( MACH >  0.001 ) ) ? ( ( ( ( ( ( SL::Logn(( ( ( ((float)25)/MACH )-0.67 )/0.123 ))*SL::Logn(( ( ( ((float)25)/MACH )-0.67 )/0.0123 )) )/0.41 )/0.41 )/WIND )/3.6 ) ) : ( pow((double)((float)10),(double)((float)10) ) ) ) ";
	u39->AddDependency(MACH);
	u39->AddDependency(WIND);
	u39->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u40 = (TExecuteCommand*) RO.GetCommand("u40",TCommand::kUpdate,TCommand::kCode);
	u40->SetExecutable(&RO_u40_exe_g);
	u40->Code() = "u40 <- ( ( 3.486*P )/( ((float)275)+AIR_TEMP_C ) )";
	u40->AddDependency(P);
	u40->AddDependency(AIR_TEMP_C);
	u40->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u41 = (TExecuteCommand*) RS.GetCommand("u41",TCommand::kUpdate,TCommand::kCode);
	u41->SetExecutable(&RS_u41_exe_g);
	u41->Code() = "u41 <-  ( ( ( MACLAI >  0.01 ) ) ? ( ( ((float)4)/MACLAI ) ) : ( pow((double)((float)10),(double)((float)10) ) ) ) ";
	u41->AddDependency(MACLAI);
	u41->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int ETPM_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int ETPM_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int ETPM_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int ETPM_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class GLOBALS_module 
// ---------------------------------------------------------------------------
GLOBALS_module::GLOBALS_module(char* name) :
	TIME("TIME"),
	AIR_TEMP_C("AIR_TEMP_C"),
	VAP_PRESS("VAP_PRESS"),
	CLOUDY("CLOUDY"),
	WIND("WIND"),
	SOLRADATM("SOLRADATM"),
	SOLRADGRD("SOLRADGRD"),
	P1_C_LATDEG("P1_C_LATDEG"),
	DAYJUL("DAYJUL"),
	HABITATMAP("HABITATMAP"),
	DAYLENGTH("DAYLENGTH"),
	ELEVATION("ELEVATION"),
	ON_MAP("ON_MAP"),
	PRECIP_M("PRECIP_M"),
	HYDRO("HYDRO"),
	CELL_SIZE("CELL_SIZE"),
	SOIL("SOIL"),
	HUMIDITY("HUMIDITY"),
	ELEV_MIN("ELEV_MIN"),
	P1_DATUM_TO_MSL("P1_DATUM_TO_MSL"),
	P1_SEWERMAP("P1_SEWERMAP"),
	P1_POP_DENS("P1_POP_DENS"),
	AMPL("AMPL"),
	LENGTH("LENGTH"),
	PAR("PAR"),
	PAR_G("PAR_G"),
	ROADS("ROADS"),
	VAP_SAT_DEFICIT("VAP_SAT_DEFICIT"),
	P1_BO_COEF("P1_BO_COEF"),
	P1_C_SURF_DELTA("P1_C_SURF_DELTA"),
	P1_DEPTH_MSL_MAP("P1_DEPTH_MSL_MAP"),
	P1_ELEV_MSL_MAP("P1_ELEV_MSL_MAP"),
	P1_RAD_CONV("P1_RAD_CONV"),
	P1_RAIN_CONV("P1_RAIN_CONV"),
	P1_WIND_CONV("P1_WIND_CONV"),
	AIR_TEMP_MAX("AIR_TEMP_MAX"),
	AIR_TEMP_MIN("AIR_TEMP_MIN"),
	PRECIPITATION("PRECIPITATION"),
	WIND_SPEED("WIND_SPEED"),
	TModule(name) {

	AIR_TEMP_C.SetF(FisExport,True,"CG");
	VAP_PRESS.SetF(FisExport,True,"CG");
	CLOUDY.SetF(FisExport,True,"CG");
	WIND.SetF(FisExport,True,"CG");
	SOLRADATM.SetF(FisImport,True,"CG");
	SOLRADGRD.SetF(FisImport,True,"CG");
	P1_C_LATDEG.SetF(FisExport,True,"CG");
	DAYJUL.SetF(FisExport,True,"CG");
	HABITATMAP.SetF(FisExport,True,"CG");
	DAYLENGTH.SetF(FisExport,True,"CG");
	ELEVATION.SetF(FisExport,True,"CG");
	ON_MAP.SetF(FisExport,True,"CG");
	PRECIP_M.SetF(FisExport,True,"CG");
	HYDRO.SetF(FisExport,True,"CG");
	CELL_SIZE.SetF(FisExport,True,"CG");
	SOIL.SetF(FisExport,True,"CG");
	HUMIDITY.SetF(FisExport,True,"CG");
	ELEV_MIN.SetF(FisExport,True,"CG");
	P1_DATUM_TO_MSL.SetF(FisExport,True,"CG");
	P1_SEWERMAP.SetF(FisExport,True,"CG");
	P1_POP_DENS.SetF(FisExport,True,"CG");
}	
int GLOBALS_module::AIR_TEMP_C_u50_exe() {
	float value;

	switch( AIR_TEMP_C.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = AIR_TEMP_C.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( AIR_TEMP_MAX.Value(p)+AIR_TEMP_MIN.Value(p) )/2. )-((float)32) )*((float)5) )/9 );
			AIR_TEMP_C.Update( p, value );
		}
		AIR_TEMP_C.GrabMemory();
		if( AIR_TEMP_C.GetF(FLinkEdges) ) { AIR_TEMP_C.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( AIR_TEMP_MAX.Value()+AIR_TEMP_MIN.Value() )/2. )-((float)32) )*((float)5) )/9 );
			AIR_TEMP_C.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::AMPL_u51_exe() {
	float value;

	switch( AMPL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = AMPL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SL::Exp(( 7.42+( 0.045*P1_C_LATDEG.Value(p) ) ))/3600 );
			AMPL.Update( p, value );
		}
		AMPL.GrabMemory();
		if( AMPL.GetF(FLinkEdges) ) { AMPL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SL::Exp(( 7.42+( 0.045*P1_C_LATDEG.Value() ) ))/3600 );
			AMPL.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::CELL_SIZE_u52_exe() {
	float value;

	switch( CELL_SIZE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CELL_SIZE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1000000;
			CELL_SIZE.Update( p, CELL_SIZE.ParameterValue(value,p) );
		}
		CELL_SIZE.GrabMemory();
		if( CELL_SIZE.GetF(FLinkEdges) ) { CELL_SIZE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1000000;
			CELL_SIZE.Update( CELL_SIZE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::CLOUDY_u53_exe() {
	float value;

	switch( CLOUDY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CLOUDY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( PRECIP_M.Value(p) >  ((float)0) ) ) ? ( SL::Max(((float)0), ( ((float)10)-( 1.155*pow((double)( VAP_PRESS.Value(p)/( ( PRECIP_M.Value(p)*25.4 )*((float)30) ) ),(double)0.5 ) ) )) ) : ( ((float)0) ) ) ;
			CLOUDY.Update( p, value );
		}
		CLOUDY.GrabMemory();
		if( CLOUDY.GetF(FLinkEdges) ) { CLOUDY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( PRECIP_M.Value() >  ((float)0) ) ) ? ( SL::Max(((float)0), ( ((float)10)-( 1.155*pow((double)( VAP_PRESS.Value()/( ( PRECIP_M.Value()*25.4 )*((float)30) ) ),(double)0.5 ) ) )) ) : ( ((float)0) ) ) ;
			CLOUDY.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::DAYJUL_u54_exe() {
	float value;

	switch( DAYJUL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DAYJUL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SL::Mod(( TIME.Value()-dT() ), ((float)365))+((float)1) );
			DAYJUL.Update( p, value );
		}
		DAYJUL.GrabMemory();
		if( DAYJUL.GetF(FLinkEdges) ) { DAYJUL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SL::Mod(( TIME.Value()-dT() ), ((float)365))+((float)1) );
			DAYJUL.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::DAYLENGTH_u55_exe() {
	float value;

	switch( DAYLENGTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DAYLENGTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( AMPL.Value(p)*SL::Sin(( ( DAYJUL.Value(p)-((float)79) )*0.01721 )) )+((float)12) );
			DAYLENGTH.Update( p, value );
		}
		DAYLENGTH.GrabMemory();
		if( DAYLENGTH.GetF(FLinkEdges) ) { DAYLENGTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( AMPL.Value()*SL::Sin(( ( DAYJUL.Value()-((float)79) )*0.01721 )) )+((float)12) );
			DAYLENGTH.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::ELEVATION_u56_exe() {
	float value;

	switch( ELEVATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ELEVATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( P1_DEPTH_MSL_MAP.Value(p) >  ((float)0) ) ) ? ( ( P1_DATUM_TO_MSL.Value(p)-P1_DEPTH_MSL_MAP.Value(p) ) ) : ( ( P1_ELEV_MSL_MAP.Value(p)+P1_DATUM_TO_MSL.Value(p) ) ) ) ;
			ELEVATION.Update( p, value );
		}
		ELEVATION.GrabMemory();
		if( ELEVATION.GetF(FLinkEdges) ) { ELEVATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( P1_DEPTH_MSL_MAP.Value() >  ((float)0) ) ) ? ( ( P1_DATUM_TO_MSL.Value()-P1_DEPTH_MSL_MAP.Value() ) ) : ( ( P1_ELEV_MSL_MAP.Value()+P1_DATUM_TO_MSL.Value() ) ) ) ;
			ELEVATION.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::ELEV_MIN_u57_exe() {
	float value;

	switch( ELEV_MIN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ELEV_MIN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( HABITATMAP.Value(p) == ((float)1) ) ) ? ( ELEVATION.Value(p) ) : (  ( ( ( P1_ELEV_MSL_MAP.Value(p) >  ( 2.*P1_C_SURF_DELTA.Value(p) ) ) ) ? ( ( ELEVATION.Value(p)-P1_C_SURF_DELTA.Value(p) ) ) : ( ( ELEVATION.Value(p)-( P1_ELEV_MSL_MAP.Value(p)/2. ) ) ) )  ) ) ;
			ELEV_MIN.Update( p, value );
		}
		ELEV_MIN.GrabMemory();
		if( ELEV_MIN.GetF(FLinkEdges) ) { ELEV_MIN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( HABITATMAP.Value() == ((float)1) ) ) ? ( ELEVATION.Value() ) : (  ( ( ( P1_ELEV_MSL_MAP.Value() >  ( 2.*P1_C_SURF_DELTA.Value() ) ) ) ? ( ( ELEVATION.Value()-P1_C_SURF_DELTA.Value() ) ) : ( ( ELEVATION.Value()-( P1_ELEV_MSL_MAP.Value()/2. ) ) ) )  ) ) ;
			ELEV_MIN.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::HABITATMAP_u58_exe() {
	float value;

	switch( HABITATMAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HABITATMAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)2);
			HABITATMAP.Update( p, value );
		}
		HABITATMAP.GrabMemory();
		if( HABITATMAP.GetF(FLinkEdges) ) { HABITATMAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)2);
			HABITATMAP.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::HYDRO_u59_exe() {
	float value;

	switch( HYDRO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HYDRO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			HYDRO.Update( p, value );
		}
		HYDRO.GrabMemory();
		if( HYDRO.GetF(FLinkEdges) ) { HYDRO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			HYDRO.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::LENGTH_u60_exe() {
	float value;

	switch( LENGTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LENGTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  300;
			LENGTH.Update( p, LENGTH.ParameterValue(value,p) );
		}
		LENGTH.GrabMemory();
		if( LENGTH.GetF(FLinkEdges) ) { LENGTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  300;
			LENGTH.Update( LENGTH.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::ON_MAP_u61_exe() {
	float value;

	switch( ON_MAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ON_MAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			ON_MAP.Update( p, value );
		}
		ON_MAP.GrabMemory();
		if( ON_MAP.GetF(FLinkEdges) ) { ON_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			ON_MAP.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::PAR_u62_exe() {
	float value;

	switch( PAR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PAR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_RAD_CONV.Value(p)*SOLRADATM.Value(p) );
			PAR.Update( p, value );
		}
		PAR.GrabMemory();
		if( PAR.GetF(FLinkEdges) ) { PAR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_RAD_CONV.Value()*SOLRADATM.Value() );
			PAR.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::PAR_G_u63_exe() {
	float value;

	switch( PAR_G.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PAR_G.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_RAD_CONV.Value(p)*SOLRADGRD.Value(p) );
			PAR_G.Update( p, value );
		}
		PAR_G.GrabMemory();
		if( PAR_G.GetF(FLinkEdges) ) { PAR_G.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_RAD_CONV.Value()*SOLRADGRD.Value() );
			PAR_G.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::PRECIP_M_u64_exe() {
	float value;

	switch( PRECIP_M.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PRECIP_M.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_RAIN_CONV.Value(p)*PRECIPITATION.Value(p) );
			PRECIP_M.Update( p, value );
		}
		PRECIP_M.GrabMemory();
		if( PRECIP_M.GetF(FLinkEdges) ) { PRECIP_M.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_RAIN_CONV.Value()*PRECIPITATION.Value() );
			PRECIP_M.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::ROADS_u65_exe() {
	float value;

	switch( ROADS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ROADS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			ROADS.Update( p, value );
		}
		ROADS.GrabMemory();
		if( ROADS.GetF(FLinkEdges) ) { ROADS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			ROADS.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::SOIL_u66_exe() {
	float value;

	switch( SOIL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SOIL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			SOIL.Update( p, value );
		}
		SOIL.GrabMemory();
		if( SOIL.GetF(FLinkEdges) ) { SOIL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			SOIL.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::VAP_PRESS_u67_exe() {
	float value;

	switch( VAP_PRESS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = VAP_PRESS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( HUMIDITY.Value(p)*6.1078 )*SL::Exp(( ( 17.269*AIR_TEMP_C.Value(p) )/( AIR_TEMP_C.Value(p)+237.3 ) )) );
			VAP_PRESS.Update( p, value );
		}
		VAP_PRESS.GrabMemory();
		if( VAP_PRESS.GetF(FLinkEdges) ) { VAP_PRESS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( HUMIDITY.Value()*6.1078 )*SL::Exp(( ( 17.269*AIR_TEMP_C.Value() )/( AIR_TEMP_C.Value()+237.3 ) )) );
			VAP_PRESS.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::VAP_SAT_DEFICIT_u68_exe() {
	float value;

	switch( VAP_SAT_DEFICIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = VAP_SAT_DEFICIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)1)-( HUMIDITY.Value(p)/100 ) );
			VAP_SAT_DEFICIT.Update( p, value );
		}
		VAP_SAT_DEFICIT.GrabMemory();
		if( VAP_SAT_DEFICIT.GetF(FLinkEdges) ) { VAP_SAT_DEFICIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)1)-( HUMIDITY.Value()/100 ) );
			VAP_SAT_DEFICIT.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::WIND_u69_exe() {
	float value;

	switch( WIND.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WIND.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( WIND_SPEED.Value(p)*P1_WIND_CONV.Value(p) );
			WIND.Update( p, value );
		}
		WIND.GrabMemory();
		if( WIND.GetF(FLinkEdges) ) { WIND.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( WIND_SPEED.Value()*P1_WIND_CONV.Value() );
			WIND.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_BO_COEF_u70_exe() {
	float value;

	switch( P1_BO_COEF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_BO_COEF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  3.58;
			P1_BO_COEF.Update( p, P1_BO_COEF.ParameterValue(value,p) );
		}
		P1_BO_COEF.GrabMemory();
		if( P1_BO_COEF.GetF(FLinkEdges) ) { P1_BO_COEF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  3.58;
			P1_BO_COEF.Update( P1_BO_COEF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_C_LATDEG_u71_exe() {
	float value;

	switch( P1_C_LATDEG.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_LATDEG.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  39.0;
			P1_C_LATDEG.Update( p, P1_C_LATDEG.ParameterValue(value,p) );
		}
		P1_C_LATDEG.GrabMemory();
		if( P1_C_LATDEG.GetF(FLinkEdges) ) { P1_C_LATDEG.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  39.0;
			P1_C_LATDEG.Update( P1_C_LATDEG.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_C_SURF_DELTA_u72_exe() {
	float value;

	switch( P1_C_SURF_DELTA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_SURF_DELTA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  5.0;
			P1_C_SURF_DELTA.Update( p, P1_C_SURF_DELTA.ParameterValue(value,p) );
		}
		P1_C_SURF_DELTA.GrabMemory();
		if( P1_C_SURF_DELTA.GetF(FLinkEdges) ) { P1_C_SURF_DELTA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  5.0;
			P1_C_SURF_DELTA.Update( P1_C_SURF_DELTA.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_DATUM_TO_MSL_u73_exe() {
	float value;

	switch( P1_DATUM_TO_MSL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DATUM_TO_MSL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  20;
			P1_DATUM_TO_MSL.Update( p, P1_DATUM_TO_MSL.ParameterValue(value,p) );
		}
		P1_DATUM_TO_MSL.GrabMemory();
		if( P1_DATUM_TO_MSL.GetF(FLinkEdges) ) { P1_DATUM_TO_MSL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  20;
			P1_DATUM_TO_MSL.Update( P1_DATUM_TO_MSL.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_DEPTH_MSL_MAP_u74_exe() {
	float value;

	switch( P1_DEPTH_MSL_MAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DEPTH_MSL_MAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_DEPTH_MSL_MAP.Update( p, value );
		}
		P1_DEPTH_MSL_MAP.GrabMemory();
		if( P1_DEPTH_MSL_MAP.GetF(FLinkEdges) ) { P1_DEPTH_MSL_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_DEPTH_MSL_MAP.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_ELEV_MSL_MAP_u75_exe() {
	float value;

	switch( P1_ELEV_MSL_MAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_ELEV_MSL_MAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)30);
			P1_ELEV_MSL_MAP.Update( p, value );
		}
		P1_ELEV_MSL_MAP.GrabMemory();
		if( P1_ELEV_MSL_MAP.GetF(FLinkEdges) ) { P1_ELEV_MSL_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)30);
			P1_ELEV_MSL_MAP.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_POP_DENS_u76_exe() {
	float value;

	switch( P1_POP_DENS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_POP_DENS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)10);
			P1_POP_DENS.Update( p, value );
		}
		P1_POP_DENS.GrabMemory();
		if( P1_POP_DENS.GetF(FLinkEdges) ) { P1_POP_DENS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)10);
			P1_POP_DENS.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_RAD_CONV_u77_exe() {
	float value;

	switch( P1_RAD_CONV.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_RAD_CONV.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_RAD_CONV.Update( p, P1_RAD_CONV.ParameterValue(value,p) );
		}
		P1_RAD_CONV.GrabMemory();
		if( P1_RAD_CONV.GetF(FLinkEdges) ) { P1_RAD_CONV.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_RAD_CONV.Update( P1_RAD_CONV.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_RAIN_CONV_u78_exe() {
	float value;

	switch( P1_RAIN_CONV.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_RAIN_CONV.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000254;
			P1_RAIN_CONV.Update( p, P1_RAIN_CONV.ParameterValue(value,p) );
		}
		P1_RAIN_CONV.GrabMemory();
		if( P1_RAIN_CONV.GetF(FLinkEdges) ) { P1_RAIN_CONV.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000254;
			P1_RAIN_CONV.Update( P1_RAIN_CONV.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_SEWERMAP_u79_exe() {
	float value;

	switch( P1_SEWERMAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SEWERMAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			P1_SEWERMAP.Update( p, value );
		}
		P1_SEWERMAP.GrabMemory();
		if( P1_SEWERMAP.GetF(FLinkEdges) ) { P1_SEWERMAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			P1_SEWERMAP.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::P1_WIND_CONV_u80_exe() {
	float value;

	switch( P1_WIND_CONV.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_WIND_CONV.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.1609;
			P1_WIND_CONV.Update( p, P1_WIND_CONV.ParameterValue(value,p) );
		}
		P1_WIND_CONV.GrabMemory();
		if( P1_WIND_CONV.GetF(FLinkEdges) ) { P1_WIND_CONV.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.1609;
			P1_WIND_CONV.Update( P1_WIND_CONV.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBALS_module::AIR_TEMP_MAX_u81_exe() {
	float value;

	switch( AIR_TEMP_MAX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = AIR_TEMP_MAX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph12(DAYJUL.Value(p));
			AIR_TEMP_MAX.Update( p, value );
		}
		AIR_TEMP_MAX.GrabMemory();
		if( AIR_TEMP_MAX.GetF(FLinkEdges) ) { AIR_TEMP_MAX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph12(DAYJUL.Value());
			AIR_TEMP_MAX.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::AIR_TEMP_MIN_u82_exe() {
	float value;

	switch( AIR_TEMP_MIN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = AIR_TEMP_MIN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph13(DAYJUL.Value(p));
			AIR_TEMP_MIN.Update( p, value );
		}
		AIR_TEMP_MIN.GrabMemory();
		if( AIR_TEMP_MIN.GetF(FLinkEdges) ) { AIR_TEMP_MIN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph13(DAYJUL.Value());
			AIR_TEMP_MIN.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::HUMIDITY_u83_exe() {
	float value;

	switch( HUMIDITY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HUMIDITY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph14(DAYJUL.Value(p));
			HUMIDITY.Update( p, value );
		}
		HUMIDITY.GrabMemory();
		if( HUMIDITY.GetF(FLinkEdges) ) { HUMIDITY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph14(DAYJUL.Value());
			HUMIDITY.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::PRECIPITATION_u84_exe() {
	float value;

	switch( PRECIPITATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PRECIPITATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph15(DAYJUL.Value(p));
			PRECIPITATION.Update( p, value );
		}
		PRECIPITATION.GrabMemory();
		if( PRECIPITATION.GetF(FLinkEdges) ) { PRECIPITATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph15(DAYJUL.Value());
			PRECIPITATION.Update( value );
	  } break;
	}
	return 0;
}

int GLOBALS_module::WIND_SPEED_u85_exe() {
	float value;

	switch( WIND_SPEED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WIND_SPEED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph16(DAYJUL.Value(p));
			WIND_SPEED.Update( p, value );
		}
		WIND_SPEED.GrabMemory();
		if( WIND_SPEED.GetF(FLinkEdges) ) { WIND_SPEED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph16(DAYJUL.Value());
			WIND_SPEED.Update( value );
	  } break;
	}
	return 0;
}

GLOBALS_module* GLOBALS_module::fInstance = NULL;
GLOBALS_module* GLOBALS_module::kNullModel = (GLOBALS_module*)0x1;
int GLOBALS_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int GLOBALS_module::InitVars() {
	
	TIME.SSInit(this);
	AIR_TEMP_C.SSInit(this);
	VAP_PRESS.SSInit(this);
	CLOUDY.SSInit(this);
	WIND.SSInit(this);
	SOLRADATM.SSInit(this);
	SOLRADGRD.SSInit(this);
	P1_C_LATDEG.SSInit(this);
	DAYJUL.SSInit(this);
	HABITATMAP.SSInit(this);
	DAYLENGTH.SSInit(this);
	ELEVATION.SSInit(this);
	ON_MAP.SSInit(this);
	PRECIP_M.SSInit(this);
	HYDRO.SSInit(this);
	CELL_SIZE.SSInit(this);
	SOIL.SSInit(this);
	HUMIDITY.SSInit(this);
	ELEV_MIN.SSInit(this);
	P1_DATUM_TO_MSL.SSInit(this);
	P1_SEWERMAP.SSInit(this);
	P1_POP_DENS.SSInit(this);
	AMPL.SSInit(this);
	LENGTH.SSInit(this);
	PAR.SSInit(this);
	PAR_G.SSInit(this);
	ROADS.SSInit(this);
	VAP_SAT_DEFICIT.SSInit(this);
	P1_BO_COEF.SSInit(this);
	P1_C_SURF_DELTA.SSInit(this);
	P1_DEPTH_MSL_MAP.SSInit(this);
	P1_ELEV_MSL_MAP.SSInit(this);
	P1_RAD_CONV.SSInit(this);
	P1_RAIN_CONV.SSInit(this);
	P1_WIND_CONV.SSInit(this);
	AIR_TEMP_MAX.SSInit(this);
	AIR_TEMP_MIN.SSInit(this);
	PRECIPITATION.SSInit(this);
	WIND_SPEED.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int GLOBALS_module::SetupEvents() {
	TExecuteCommand* u50 = (TExecuteCommand*) AIR_TEMP_C.GetCommand("u50",TCommand::kUpdate,TCommand::kCode);
	u50->SetExecutable(&AIR_TEMP_C_u50_exe_g);
	u50->Code() = "u50 <- ( ( ( ( ( AIR_TEMP_MAX+AIR_TEMP_MIN )/2. )-((float)32) )*((float)5) )/9 )";
	u50->AddDependency(AIR_TEMP_MAX);
	u50->AddDependency(AIR_TEMP_MIN);
	u50->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u67 = (TExecuteCommand*) VAP_PRESS.GetCommand("u67",TCommand::kUpdate,TCommand::kCode);
	u67->SetExecutable(&VAP_PRESS_u67_exe_g);
	u67->Code() = "u67 <- ( ( HUMIDITY*6.1078 )*SL::Exp(( ( 17.269*AIR_TEMP_C )/( AIR_TEMP_C+237.3 ) )) )";
	u67->AddDependency(HUMIDITY);
	u67->AddDependency(AIR_TEMP_C);
	u67->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u53 = (TExecuteCommand*) CLOUDY.GetCommand("u53",TCommand::kUpdate,TCommand::kCode);
	u53->SetExecutable(&CLOUDY_u53_exe_g);
	u53->Code() = "u53 <-  ( ( ( PRECIP_M >  ((float)0) ) ) ? ( SL::Max(((float)0), ( ((float)10)-( 1.155*pow((double)( VAP_PRESS/( ( PRECIP_M*25.4 )*((float)30) ) ),(double)0.5 ) ) )) ) : ( ((float)0) ) ) ";
	u53->AddDependency(PRECIP_M);
	u53->AddDependency(VAP_PRESS);
	u53->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u69 = (TExecuteCommand*) WIND.GetCommand("u69",TCommand::kUpdate,TCommand::kCode);
	u69->SetExecutable(&WIND_u69_exe_g);
	u69->Code() = "u69 <- ( WIND_SPEED*P1_WIND_CONV )";
	u69->AddDependency(WIND_SPEED);
	u69->AddDependency(P1_WIND_CONV);
	u69->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SOLRADATM_import = (TImportCommand*) SOLRADATM.GetCommand("SOLRADATM_import",TCommand::kUndefined,TCommand::kImport);
	SOLRADATM_import->Code() = "Import SOLRADATM from PAR_module";
	SOLRADATM_import->AddDependency(SOLRADATM);
	SOLRADATM_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SOLRADGRD_import = (TImportCommand*) SOLRADGRD.GetCommand("SOLRADGRD_import",TCommand::kUndefined,TCommand::kImport);
	SOLRADGRD_import->Code() = "Import SOLRADGRD from PAR_module";
	SOLRADGRD_import->AddDependency(SOLRADGRD);
	SOLRADGRD_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u71 = (TExecuteCommand*) P1_C_LATDEG.GetCommand("u71",TCommand::kUpdate,TCommand::kCode);
	u71->SetExecutable(&P1_C_LATDEG_u71_exe_g);
	u71->Code() = "u71 <- 39.0";
	u71->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u54 = (TExecuteCommand*) DAYJUL.GetCommand("u54",TCommand::kUpdate,TCommand::kCode);
	u54->SetExecutable(&DAYJUL_u54_exe_g);
	u54->Code() = "u54 <- ( SL::Mod(( TIME-dT() ), ((float)365))+((float)1) )";
	u54->AddDependency(TIME);
	u54->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u58 = (TExecuteCommand*) HABITATMAP.GetCommand("u58",TCommand::kUpdate,TCommand::kCode);
	u58->SetExecutable(&HABITATMAP_u58_exe_g);
	u58->Code() = "u58 <- ((float)2)";
	u58->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u55 = (TExecuteCommand*) DAYLENGTH.GetCommand("u55",TCommand::kUpdate,TCommand::kCode);
	u55->SetExecutable(&DAYLENGTH_u55_exe_g);
	u55->Code() = "u55 <- ( ( AMPL*SL::Sin(( ( DAYJUL-((float)79) )*0.01721 )) )+((float)12) )";
	u55->AddDependency(AMPL);
	u55->AddDependency(DAYJUL);
	u55->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u56 = (TExecuteCommand*) ELEVATION.GetCommand("u56",TCommand::kUpdate,TCommand::kCode);
	u56->SetExecutable(&ELEVATION_u56_exe_g);
	u56->Code() = "u56 <-  ( ( ( P1_DEPTH_MSL_MAP >  ((float)0) ) ) ? ( ( P1_DATUM_TO_MSL-P1_DEPTH_MSL_MAP ) ) : ( ( P1_ELEV_MSL_MAP+P1_DATUM_TO_MSL ) ) ) ";
	u56->AddDependency(P1_DEPTH_MSL_MAP);
	u56->AddDependency(P1_DATUM_TO_MSL);
	u56->AddDependency(P1_ELEV_MSL_MAP);
	u56->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u61 = (TExecuteCommand*) ON_MAP.GetCommand("u61",TCommand::kUpdate,TCommand::kCode);
	u61->SetExecutable(&ON_MAP_u61_exe_g);
	u61->Code() = "u61 <- ((float)1)";
	u61->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u64 = (TExecuteCommand*) PRECIP_M.GetCommand("u64",TCommand::kUpdate,TCommand::kCode);
	u64->SetExecutable(&PRECIP_M_u64_exe_g);
	u64->Code() = "u64 <- ( P1_RAIN_CONV*PRECIPITATION )";
	u64->AddDependency(P1_RAIN_CONV);
	u64->AddDependency(PRECIPITATION);
	u64->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u59 = (TExecuteCommand*) HYDRO.GetCommand("u59",TCommand::kUpdate,TCommand::kCode);
	u59->SetExecutable(&HYDRO_u59_exe_g);
	u59->Code() = "u59 <- ((float)1)";
	u59->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u52 = (TExecuteCommand*) CELL_SIZE.GetCommand("u52",TCommand::kUpdate,TCommand::kCode);
	u52->SetExecutable(&CELL_SIZE_u52_exe_g);
	u52->Code() = "u52 <- 1000000";
	u52->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u66 = (TExecuteCommand*) SOIL.GetCommand("u66",TCommand::kUpdate,TCommand::kCode);
	u66->SetExecutable(&SOIL_u66_exe_g);
	u66->Code() = "u66 <- ((float)1)";
	u66->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u83 = (TExecuteCommand*) HUMIDITY.GetCommand("u83",TCommand::kUpdate,TCommand::kCode);
	u83->SetExecutable(&HUMIDITY_u83_exe_g);
	u83->Code() = "u83 <- Graph14(DAYJUL)";
	u83->AddDependency(DAYJUL);
	u83->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* HUMIDITY_import = (TImportCommand*) HUMIDITY.GetCommand("HUMIDITY_import",TCommand::kUndefined,TCommand::kImport);
	HUMIDITY_import->Code() = "Import HUMIDITY from external";
	HUMIDITY_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u57 = (TExecuteCommand*) ELEV_MIN.GetCommand("u57",TCommand::kUpdate,TCommand::kCode);
	u57->SetExecutable(&ELEV_MIN_u57_exe_g);
	u57->Code() = "u57 <-  ( ( ( HABITATMAP == ((float)1) ) ) ? ( ELEVATION ) : (  ( ( ( P1_ELEV_MSL_MAP >  ( 2.*P1_C_SURF_DELTA ) ) ) ? ( ( ELEVATION-P1_C_SURF_DELTA ) ) : ( ( ELEVATION-( P1_ELEV_MSL_MAP/2. ) ) ) )  ) ) ";
	u57->AddDependency(HABITATMAP);
	u57->AddDependency(ELEVATION);
	u57->AddDependency(P1_ELEV_MSL_MAP);
	u57->AddDependency(P1_C_SURF_DELTA);
	u57->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u73 = (TExecuteCommand*) P1_DATUM_TO_MSL.GetCommand("u73",TCommand::kUpdate,TCommand::kCode);
	u73->SetExecutable(&P1_DATUM_TO_MSL_u73_exe_g);
	u73->Code() = "u73 <- 20";
	u73->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u79 = (TExecuteCommand*) P1_SEWERMAP.GetCommand("u79",TCommand::kUpdate,TCommand::kCode);
	u79->SetExecutable(&P1_SEWERMAP_u79_exe_g);
	u79->Code() = "u79 <- ((float)1)";
	u79->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u76 = (TExecuteCommand*) P1_POP_DENS.GetCommand("u76",TCommand::kUpdate,TCommand::kCode);
	u76->SetExecutable(&P1_POP_DENS_u76_exe_g);
	u76->Code() = "u76 <- ((float)10)";
	u76->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u51 = (TExecuteCommand*) AMPL.GetCommand("u51",TCommand::kUpdate,TCommand::kCode);
	u51->SetExecutable(&AMPL_u51_exe_g);
	u51->Code() = "u51 <- ( SL::Exp(( 7.42+( 0.045*P1_C_LATDEG ) ))/3600 )";
	u51->AddDependency(P1_C_LATDEG);
	u51->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u60 = (TExecuteCommand*) LENGTH.GetCommand("u60",TCommand::kUpdate,TCommand::kCode);
	u60->SetExecutable(&LENGTH_u60_exe_g);
	u60->Code() = "u60 <- 300";
	u60->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u62 = (TExecuteCommand*) PAR.GetCommand("u62",TCommand::kUpdate,TCommand::kCode);
	u62->SetExecutable(&PAR_u62_exe_g);
	u62->Code() = "u62 <- ( P1_RAD_CONV*SOLRADATM )";
	u62->AddDependency(P1_RAD_CONV);
	u62->AddDependency(SOLRADATM);
	u62->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u63 = (TExecuteCommand*) PAR_G.GetCommand("u63",TCommand::kUpdate,TCommand::kCode);
	u63->SetExecutable(&PAR_G_u63_exe_g);
	u63->Code() = "u63 <- ( P1_RAD_CONV*SOLRADGRD )";
	u63->AddDependency(P1_RAD_CONV);
	u63->AddDependency(SOLRADGRD);
	u63->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u65 = (TExecuteCommand*) ROADS.GetCommand("u65",TCommand::kUpdate,TCommand::kCode);
	u65->SetExecutable(&ROADS_u65_exe_g);
	u65->Code() = "u65 <- ((float)1)";
	u65->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u68 = (TExecuteCommand*) VAP_SAT_DEFICIT.GetCommand("u68",TCommand::kUpdate,TCommand::kCode);
	u68->SetExecutable(&VAP_SAT_DEFICIT_u68_exe_g);
	u68->Code() = "u68 <- ( ((float)1)-( HUMIDITY/100 ) )";
	u68->AddDependency(HUMIDITY);
	u68->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u70 = (TExecuteCommand*) P1_BO_COEF.GetCommand("u70",TCommand::kUpdate,TCommand::kCode);
	u70->SetExecutable(&P1_BO_COEF_u70_exe_g);
	u70->Code() = "u70 <- 3.58";
	u70->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u72 = (TExecuteCommand*) P1_C_SURF_DELTA.GetCommand("u72",TCommand::kUpdate,TCommand::kCode);
	u72->SetExecutable(&P1_C_SURF_DELTA_u72_exe_g);
	u72->Code() = "u72 <- 5.0";
	u72->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u74 = (TExecuteCommand*) P1_DEPTH_MSL_MAP.GetCommand("u74",TCommand::kUpdate,TCommand::kCode);
	u74->SetExecutable(&P1_DEPTH_MSL_MAP_u74_exe_g);
	u74->Code() = "u74 <- ((float)0)";
	u74->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u75 = (TExecuteCommand*) P1_ELEV_MSL_MAP.GetCommand("u75",TCommand::kUpdate,TCommand::kCode);
	u75->SetExecutable(&P1_ELEV_MSL_MAP_u75_exe_g);
	u75->Code() = "u75 <- ((float)30)";
	u75->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u77 = (TExecuteCommand*) P1_RAD_CONV.GetCommand("u77",TCommand::kUpdate,TCommand::kCode);
	u77->SetExecutable(&P1_RAD_CONV_u77_exe_g);
	u77->Code() = "u77 <- 1";
	u77->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u78 = (TExecuteCommand*) P1_RAIN_CONV.GetCommand("u78",TCommand::kUpdate,TCommand::kCode);
	u78->SetExecutable(&P1_RAIN_CONV_u78_exe_g);
	u78->Code() = "u78 <- 0.000254";
	u78->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u80 = (TExecuteCommand*) P1_WIND_CONV.GetCommand("u80",TCommand::kUpdate,TCommand::kCode);
	u80->SetExecutable(&P1_WIND_CONV_u80_exe_g);
	u80->Code() = "u80 <- 0.1609";
	u80->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u81 = (TExecuteCommand*) AIR_TEMP_MAX.GetCommand("u81",TCommand::kUpdate,TCommand::kCode);
	u81->SetExecutable(&AIR_TEMP_MAX_u81_exe_g);
	u81->Code() = "u81 <- Graph12(DAYJUL)";
	u81->AddDependency(DAYJUL);
	u81->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* AIR_TEMP_MAX_import = (TImportCommand*) AIR_TEMP_MAX.GetCommand("AIR_TEMP_MAX_import",TCommand::kUndefined,TCommand::kImport);
	AIR_TEMP_MAX_import->Code() = "Import AIR_TEMP_MAX from external";
	AIR_TEMP_MAX_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u82 = (TExecuteCommand*) AIR_TEMP_MIN.GetCommand("u82",TCommand::kUpdate,TCommand::kCode);
	u82->SetExecutable(&AIR_TEMP_MIN_u82_exe_g);
	u82->Code() = "u82 <- Graph13(DAYJUL)";
	u82->AddDependency(DAYJUL);
	u82->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* AIR_TEMP_MIN_import = (TImportCommand*) AIR_TEMP_MIN.GetCommand("AIR_TEMP_MIN_import",TCommand::kUndefined,TCommand::kImport);
	AIR_TEMP_MIN_import->Code() = "Import AIR_TEMP_MIN from external";
	AIR_TEMP_MIN_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u84 = (TExecuteCommand*) PRECIPITATION.GetCommand("u84",TCommand::kUpdate,TCommand::kCode);
	u84->SetExecutable(&PRECIPITATION_u84_exe_g);
	u84->Code() = "u84 <- Graph15(DAYJUL)";
	u84->AddDependency(DAYJUL);
	u84->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PRECIPITATION_import = (TImportCommand*) PRECIPITATION.GetCommand("PRECIPITATION_import",TCommand::kUndefined,TCommand::kImport);
	PRECIPITATION_import->Code() = "Import PRECIPITATION from external";
	PRECIPITATION_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u85 = (TExecuteCommand*) WIND_SPEED.GetCommand("u85",TCommand::kUpdate,TCommand::kCode);
	u85->SetExecutable(&WIND_SPEED_u85_exe_g);
	u85->Code() = "u85 <- Graph16(DAYJUL)";
	u85->AddDependency(DAYJUL);
	u85->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* WIND_SPEED_import = (TImportCommand*) WIND_SPEED.GetCommand("WIND_SPEED_import",TCommand::kUndefined,TCommand::kImport);
	WIND_SPEED_import->Code() = "Import WIND_SPEED from external";
	WIND_SPEED_import->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int GLOBALS_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int GLOBALS_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int GLOBALS_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int GLOBALS_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class PAR_module 
// ---------------------------------------------------------------------------
PAR_module::PAR_module(char* name) :
	TIME("TIME"),
	SOLRADATM("SOLRADATM"),
	SOLRADGRD("SOLRADGRD"),
	P1_C_LATDEG("P1_C_LATDEG"),
	CLOUDY("CLOUDY"),
	DAYJUL("DAYJUL"),
	A("A"),
	ALPHA("ALPHA"),
	B("B"),
	BETTA("BETTA"),
	C("C"),
	T_RAD("T_RAD"),
	TModule(name) {

	SOLRADATM.SetF(FisExport,True,"CG");
	SOLRADGRD.SetF(FisExport,True,"CG");
	P1_C_LATDEG.SetF(FisImport,True,"CG");
	CLOUDY.SetF(FisImport,True,"CG");
	DAYJUL.SetF(FisImport,True,"CG");
}	
int PAR_module::A_u88_exe() {
	float value;

	switch( A.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = A.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)942)-( 6.68*P1_C_LATDEG.Value(p) ) );
			A.Update( p, value );
		}
		A.GrabMemory();
		if( A.GetF(FLinkEdges) ) { A.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)942)-( 6.68*P1_C_LATDEG.Value() ) );
			A.Update( value );
	  } break;
	}
	return 0;
}

int PAR_module::ALPHA_u89_exe() {
	float value;

	switch( ALPHA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ALPHA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( 32.9835-( 64.884*( ((float)1)-( 1.3614*SL::Cos(( ( ( SL::Int(P1_C_LATDEG.Value(p))+( ( P1_C_LATDEG.Value(p)-SL::Int(P1_C_LATDEG.Value(p)) )*1.16666667 ) )*3.141590 )/180 )) ) ) ) );
			ALPHA.Update( p, value );
		}
		ALPHA.GrabMemory();
		if( ALPHA.GetF(FLinkEdges) ) { ALPHA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( 32.9835-( 64.884*( ((float)1)-( 1.3614*SL::Cos(( ( ( SL::Int(P1_C_LATDEG.Value())+( ( P1_C_LATDEG.Value()-SL::Int(P1_C_LATDEG.Value()) )*1.16666667 ) )*3.141590 )/180 )) ) ) ) );
			ALPHA.Update( value );
	  } break;
	}
	return 0;
}

int PAR_module::B_u90_exe() {
	float value;

	switch( B.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = B.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)147)*pow((double)( P1_C_LATDEG.Value(p)-17.48 ),(double)0.27 ) );
			B.Update( p, value );
		}
		B.GrabMemory();
		if( B.GetF(FLinkEdges) ) { B.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)147)*pow((double)( P1_C_LATDEG.Value()-17.48 ),(double)0.27 ) );
			B.Update( value );
	  } break;
	}
	return 0;
}

int PAR_module::BETTA_u91_exe() {
	float value;

	switch( BETTA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = BETTA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( 0.715-( 0.3183*( ((float)1)-( 1.3614*SL::Cos(( ( ( SL::Int(P1_C_LATDEG.Value(p))+( ( P1_C_LATDEG.Value(p)-SL::Int(P1_C_LATDEG.Value(p)) )*1.16666667 ) )*3.141590 )/180 )) ) ) ) );
			BETTA.Update( p, value );
		}
		BETTA.GrabMemory();
		if( BETTA.GetF(FLinkEdges) ) { BETTA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( 0.715-( 0.3183*( ((float)1)-( 1.3614*SL::Cos(( ( ( SL::Int(P1_C_LATDEG.Value())+( ( P1_C_LATDEG.Value()-SL::Int(P1_C_LATDEG.Value()) )*1.16666667 ) )*3.141590 )/180 )) ) ) ) );
			BETTA.Update( value );
	  } break;
	}
	return 0;
}

int PAR_module::C_u92_exe() {
	float value;

	switch( C.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = C.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)175)-( 3.6*P1_C_LATDEG.Value(p) ) );
			C.Update( p, value );
		}
		C.GrabMemory();
		if( C.GetF(FLinkEdges) ) { C.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)175)-( 3.6*P1_C_LATDEG.Value() ) );
			C.Update( value );
	  } break;
	}
	return 0;
}

int PAR_module::SOLRADATM_u93_exe() {
	float value;

	switch( SOLRADATM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SOLRADATM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( A.Value(p)+( B.Value(p)*SL::Cos(T_RAD.Value(p)) ) )+( C.Value(p)*pow((double)SL::Sin(T_RAD.Value(p)),(double)((float)2) ) ) );
			SOLRADATM.Update( p, value );
		}
		SOLRADATM.GrabMemory();
		if( SOLRADATM.GetF(FLinkEdges) ) { SOLRADATM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( A.Value()+( B.Value()*SL::Cos(T_RAD.Value()) ) )+( C.Value()*pow((double)SL::Sin(T_RAD.Value()),(double)((float)2) ) ) );
			SOLRADATM.Update( value );
	  } break;
	}
	return 0;
}

int PAR_module::SOLRADGRD_u94_exe() {
	float value;

	switch( SOLRADGRD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SOLRADGRD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SOLRADATM.Value(p)*( BETTA.Value(p)-( 0.0326*CLOUDY.Value(p) ) ) )-ALPHA.Value(p) );
			SOLRADGRD.Update( p, value );
		}
		SOLRADGRD.GrabMemory();
		if( SOLRADGRD.GetF(FLinkEdges) ) { SOLRADGRD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SOLRADATM.Value()*( BETTA.Value()-( 0.0326*CLOUDY.Value() ) ) )-ALPHA.Value() );
			SOLRADGRD.Update( value );
	  } break;
	}
	return 0;
}

int PAR_module::T_RAD_u95_exe() {
	float value;

	switch( T_RAD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = T_RAD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ((float)2)/365 )*3.141590 )*( DAYJUL.Value(p)-((float)173) ) );
			T_RAD.Update( p, value );
		}
		T_RAD.GrabMemory();
		if( T_RAD.GetF(FLinkEdges) ) { T_RAD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ((float)2)/365 )*3.141590 )*( DAYJUL.Value()-((float)173) ) );
			T_RAD.Update( value );
	  } break;
	}
	return 0;
}

PAR_module* PAR_module::fInstance = NULL;
PAR_module* PAR_module::kNullModel = (PAR_module*)0x1;
int PAR_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int PAR_module::InitVars() {
	
	TIME.SSInit(this);
	SOLRADATM.SSInit(this);
	SOLRADGRD.SSInit(this);
	P1_C_LATDEG.SSInit(this);
	CLOUDY.SSInit(this);
	DAYJUL.SSInit(this);
	A.SSInit(this);
	ALPHA.SSInit(this);
	B.SSInit(this);
	BETTA.SSInit(this);
	C.SSInit(this);
	T_RAD.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int PAR_module::SetupEvents() {
	TExecuteCommand* u93 = (TExecuteCommand*) SOLRADATM.GetCommand("u93",TCommand::kUpdate,TCommand::kCode);
	u93->SetExecutable(&SOLRADATM_u93_exe_g);
	u93->Code() = "u93 <- ( ( A+( B*SL::Cos(T_RAD) ) )+( C*pow((double)SL::Sin(T_RAD),(double)((float)2) ) ) )";
	u93->AddDependency(A);
	u93->AddDependency(B);
	u93->AddDependency(T_RAD);
	u93->AddDependency(C);
	u93->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u94 = (TExecuteCommand*) SOLRADGRD.GetCommand("u94",TCommand::kUpdate,TCommand::kCode);
	u94->SetExecutable(&SOLRADGRD_u94_exe_g);
	u94->Code() = "u94 <- ( ( SOLRADATM*( BETTA-( 0.0326*CLOUDY ) ) )-ALPHA )";
	u94->AddDependency(SOLRADATM);
	u94->AddDependency(BETTA);
	u94->AddDependency(CLOUDY);
	u94->AddDependency(ALPHA);
	u94->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_C_LATDEG_import = (TImportCommand*) P1_C_LATDEG.GetCommand("P1_C_LATDEG_import",TCommand::kUndefined,TCommand::kImport);
	P1_C_LATDEG_import->Code() = "Import P1_C_LATDEG from GLOBALS_module";
	P1_C_LATDEG_import->AddDependency(P1_C_LATDEG);
	P1_C_LATDEG_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CLOUDY_import = (TImportCommand*) CLOUDY.GetCommand("CLOUDY_import",TCommand::kUndefined,TCommand::kImport);
	CLOUDY_import->Code() = "Import CLOUDY from GLOBALS_module";
	CLOUDY_import->AddDependency(CLOUDY);
	CLOUDY_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DAYJUL_import = (TImportCommand*) DAYJUL.GetCommand("DAYJUL_import",TCommand::kUndefined,TCommand::kImport);
	DAYJUL_import->Code() = "Import DAYJUL from GLOBALS_module";
	DAYJUL_import->AddDependency(DAYJUL);
	DAYJUL_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u88 = (TExecuteCommand*) A.GetCommand("u88",TCommand::kUpdate,TCommand::kCode);
	u88->SetExecutable(&A_u88_exe_g);
	u88->Code() = "u88 <- ( ((float)942)-( 6.68*P1_C_LATDEG ) )";
	u88->AddDependency(P1_C_LATDEG);
	u88->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u89 = (TExecuteCommand*) ALPHA.GetCommand("u89",TCommand::kUpdate,TCommand::kCode);
	u89->SetExecutable(&ALPHA_u89_exe_g);
	u89->Code() = "u89 <- ( 32.9835-( 64.884*( ((float)1)-( 1.3614*SL::Cos(( ( ( SL::Int(P1_C_LATDEG)+( ( P1_C_LATDEG-SL::Int(P1_C_LATDEG) )*1.16666667 ) )*3.141590 )/180 )) ) ) ) )";
	u89->AddDependency(P1_C_LATDEG);
	u89->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u90 = (TExecuteCommand*) B.GetCommand("u90",TCommand::kUpdate,TCommand::kCode);
	u90->SetExecutable(&B_u90_exe_g);
	u90->Code() = "u90 <- ( ((float)147)*pow((double)( P1_C_LATDEG-17.48 ),(double)0.27 ) )";
	u90->AddDependency(P1_C_LATDEG);
	u90->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u91 = (TExecuteCommand*) BETTA.GetCommand("u91",TCommand::kUpdate,TCommand::kCode);
	u91->SetExecutable(&BETTA_u91_exe_g);
	u91->Code() = "u91 <- ( 0.715-( 0.3183*( ((float)1)-( 1.3614*SL::Cos(( ( ( SL::Int(P1_C_LATDEG)+( ( P1_C_LATDEG-SL::Int(P1_C_LATDEG) )*1.16666667 ) )*3.141590 )/180 )) ) ) ) )";
	u91->AddDependency(P1_C_LATDEG);
	u91->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u92 = (TExecuteCommand*) C.GetCommand("u92",TCommand::kUpdate,TCommand::kCode);
	u92->SetExecutable(&C_u92_exe_g);
	u92->Code() = "u92 <- ( ((float)175)-( 3.6*P1_C_LATDEG ) )";
	u92->AddDependency(P1_C_LATDEG);
	u92->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u95 = (TExecuteCommand*) T_RAD.GetCommand("u95",TCommand::kUpdate,TCommand::kCode);
	u95->SetExecutable(&T_RAD_u95_exe_g);
	u95->Code() = "u95 <- ( ( ( ((float)2)/365 )*3.141590 )*( DAYJUL-((float)173) ) )";
	u95->AddDependency(DAYJUL);
	u95->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int PAR_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int PAR_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int PAR_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int PAR_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class MACROPHYTES_module 
// ---------------------------------------------------------------------------
MACROPHYTES_module::MACROPHYTES_module(char* name) :
	TIME("TIME"),
	PHBIO_MORT("PHBIO_MORT"),
	PHBIO_HARVEST("PHBIO_HARVEST"),
	NPHBIO_MORT("NPHBIO_MORT"),
	NPHBIO_HARVEST("NPHBIO_HARVEST"),
	MACH("MACH"),
	MACLAI("MACLAI"),
	AIR_TEMP_C("AIR_TEMP_C"),
	HABITATMAP("HABITATMAP"),
	DAYJUL("DAYJUL"),
	DAYLENGTH("DAYLENGTH"),
	DIN_AVAILABLE("DIN_AVAILABLE"),
	ELEVATION("ELEVATION"),
	SURFACE_WATER("SURFACE_WATER"),
	UW_DEPTH("UW_DEPTH"),
	WATER_AVAIL("WATER_AVAIL"),
	ROOT_DEPTH("ROOT_DEPTH"),
	PHBIO_NPP("PHBIO_NPP"),
	BIO_TIME("BIO_TIME"),
	CF_AIR_TEMP("CF_AIR_TEMP"),
	MAC_NPH_BIOMAS("MAC_NPH_BIOMAS"),
	NPHBIO_PLANTING("NPHBIO_PLANTING"),
	TRANSDOWN("TRANSDOWN"),
	TRANSUP("TRANSUP"),
	MAC_PH_BIOMAS("MAC_PH_BIOMAS"),
	PHBIO_PLANT("PHBIO_PLANT"),
	PH_MAX("PH_MAX"),
	PH_IN("PH_IN"),
	PH_OUT("PH_OUT"),
	TOT_NPP("TOT_NPP"),
	NPP_IN("NPP_IN"),
	YIELD("YIELD"),
	HARVEST("HARVEST"),
	INI_YIELD("INI_YIELD"),
	DAY_LENGTH_PREV("DAY_LENGTH_PREV"),
	FALL_LITTER("FALL_LITTER"),
	FALL_LITTER_CALC("FALL_LITTER_CALC"),
	HARVEST_TIME("HARVEST_TIME"),
	IC_NPHBIO("IC_NPHBIO"),
	IC_PHBIO("IC_PHBIO"),
	LIGHT_CF("LIGHT_CF"),
	MAC_LAI_R("MAC_LAI_R"),
	MAC_PROD_CF("MAC_PROD_CF"),
	MAX_BM("MAX_BM"),
	MAX_NPH("MAX_NPH"),
	MAX_PH("MAX_PH"),
	NPH_AB_BM("NPH_AB_BM"),
	NUTR_CF("NUTR_CF"),
	PHBIO_MORT_WATER("PHBIO_MORT_WATER"),
	PHBIO_NPP_CALC("PHBIO_NPP_CALC"),
	PH_TO_ABBM("PH_TO_ABBM"),
	PLANTIME("PLANTIME"),
	PLANTING("PLANTING"),
	PO4SD_CONCTOT("PO4SD_CONCTOT"),
	REMOVAL_TIME("REMOVAL_TIME"),
	ROOT_BM("ROOT_BM"),
	SPROUTING("SPROUTING"),
	TEMP_CF("TEMP_CF"),
	TOTAL_BIOM("TOTAL_BIOM"),
	TRANSDOWN_RT("TRANSDOWN_RT"),
	WATER_CF("WATER_CF"),
	WAT_STRESS_HIGH("WAT_STRESS_HIGH"),
	WAT_STRESS_LOW("WAT_STRESS_LOW"),
	P1_BIO_END("P1_BIO_END"),
	P1_BIO_REPRO("P1_BIO_REPRO"),
	P1_BIO_START("P1_BIO_START"),
	P1_DAYLENG_RQ("P1_DAYLENG_RQ"),
	P1_EST_HEIGHT("P1_EST_HEIGHT"),
	P1_H_DAY("P1_H_DAY"),
	P1_LIGHTSAT("P1_LIGHTSAT"),
	P1_MAC_KS_N("P1_MAC_KS_N"),
	P1_MAC_KS_P("P1_MAC_KS_P"),
	P1_MAX_AB_BM("P1_MAX_AB_BM"),
	P1_MAX_DENS("P1_MAX_DENS"),
	P1_MAX_HT_BM("P1_MAX_HT_BM"),
	P1_MAX_LAI("P1_MAX_LAI"),
	P1_MAX_PH_ABBM("P1_MAX_PH_ABBM"),
	P1_NPH_ABBM_IC("P1_NPH_ABBM_IC"),
	P1_NPH_AB_BEL("P1_NPH_AB_BEL"),
	P1_NPH_MORT("P1_NPH_MORT"),
	P1_NPH_PR_H("P1_NPH_PR_H"),
	P1_NPP("P1_NPP"),
	P1_PHB_C_REC("P1_PHB_C_REC"),
	P1_PHB_EVGRN("P1_PHB_EVGRN"),
	P1_PHB_L_RT("P1_PHB_L_RT"),
	P1_PHB_MORT("P1_PHB_MORT"),
	P1_PHB_PR_H("P1_PHB_PR_H"),
	P1_PH_TO_REP("P1_PH_TO_REP"),
	P1_PROP_LA_TO_B("P1_PROP_LA_TO_B"),
	P1_P_DAY("P1_P_DAY"),
	P1_P_RATIO("P1_P_RATIO"),
	P1_P_WT("P1_P_WT"),
	P1_ROOT_DENS("P1_ROOT_DENS"),
	P1_SPR_RATE("P1_SPR_RATE"),
	P1_TEMPOPT("P1_TEMPOPT"),
	P1_W_T_MAX("P1_W_T_MAX"),
	P1_W_T_MIN("P1_W_T_MIN"),
	SOLRADGR("SOLRADGR"),
	TModule(name) {

	PHBIO_MORT.SetF(FisExport,True,"CG");
	PHBIO_HARVEST.SetF(FisExport,True,"CG");
	NPHBIO_MORT.SetF(FisExport,True,"CG");
	NPHBIO_HARVEST.SetF(FisExport,True,"CG");
	MACH.SetF(FisExport,True,"CG");
	MACLAI.SetF(FisExport,True,"CG");
	AIR_TEMP_C.SetF(FisImport,True,"CG");
	HABITATMAP.SetF(FisImport,True,"CG");
	DAYJUL.SetF(FisImport,True,"CG");
	DAYLENGTH.SetF(FisImport,True,"CG");
	DIN_AVAILABLE.SetF(FisImport,True,"CG");
	ELEVATION.SetF(FisImport,True,"CG");
	SURFACE_WATER.SetF(FisImport,True,"CG");
	UW_DEPTH.SetF(FisImport,True,"CG");
	WATER_AVAIL.SetF(FisImport,True,"CG");
	ROOT_DEPTH.SetF(FisExport,True,"CG");
	PHBIO_NPP.SetF(FisExport,True,"CG");
	SOLRADGR.SetF(FisImport,True,"CG");
}	
int MACROPHYTES_module::BIO_TIME_I99_exe() {
	float value;

	BIO_TIME.UpdateIntegrator();
	switch( BIO_TIME.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = BIO_TIME.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  CF_AIR_TEMP.Value(p);
			BIO_TIME.Update( p, value, dT() );
		}
		BIO_TIME.GrabMemory();
		if( BIO_TIME.GetF(FLinkEdges) ) { BIO_TIME.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  CF_AIR_TEMP.Value();
			BIO_TIME.Update( value, dT() );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::BIO_TIME_i100_exe() {
	float value;

	BIO_TIME.UpdateIntegrator();
	switch( BIO_TIME.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = BIO_TIME.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			BIO_TIME.InitValue( p, value );
		}
		BIO_TIME.GrabMemory();
		if( BIO_TIME.GetF(FLinkEdges) ) { BIO_TIME.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			BIO_TIME.InitValue( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::CF_AIR_TEMP_u101_exe() {
	float value;

	switch( CF_AIR_TEMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CF_AIR_TEMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( PLANTIME.Value(p) == ((float)1) ) ) ? ( ( -BIO_TIME.Value(p)/dT() ) ) : (  ( ( ( AIR_TEMP_C.Value(p) >  ((float)5) ) ) ? ( AIR_TEMP_C.Value(p) ) : ( ((float)0) ) )  ) ) ;
			CF_AIR_TEMP.Update( p, value );
		}
		CF_AIR_TEMP.GrabMemory();
		if( CF_AIR_TEMP.GetF(FICFlux) ) CF_AIR_TEMP.Cov().Set(0.0); 
		if( CF_AIR_TEMP.GetF(FLinkEdges) ) { CF_AIR_TEMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( PLANTIME.Value() == ((float)1) ) ) ? ( ( -BIO_TIME.Value()/dT() ) ) : (  ( ( ( AIR_TEMP_C.Value() >  ((float)5) ) ) ? ( AIR_TEMP_C.Value() ) : ( ((float)0) ) )  ) ) ;
			CF_AIR_TEMP.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAC_NPH_BIOMAS_I102_exe() {
	float value;

	MAC_NPH_BIOMAS.UpdateIntegrator();
	switch( MAC_NPH_BIOMAS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAC_NPH_BIOMAS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( NPHBIO_PLANTING.Value(p)+TRANSDOWN.Value(p) )-NPHBIO_MORT.Value(p) )-TRANSUP.Value(p) )-NPHBIO_HARVEST.Value(p) );
			MAC_NPH_BIOMAS.Update( p, value, dT() );
		}
		MAC_NPH_BIOMAS.GrabMemory();
		if( MAC_NPH_BIOMAS.GetF(FLinkEdges) ) { MAC_NPH_BIOMAS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( NPHBIO_PLANTING.Value()+TRANSDOWN.Value() )-NPHBIO_MORT.Value() )-TRANSUP.Value() )-NPHBIO_HARVEST.Value() );
			MAC_NPH_BIOMAS.Update( value, dT() );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAC_NPH_BIOMAS_i103_exe() {
	float value;

	MAC_NPH_BIOMAS.UpdateIntegrator();
	switch( MAC_NPH_BIOMAS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAC_NPH_BIOMAS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  IC_NPHBIO.Value(p);
			MAC_NPH_BIOMAS.InitValue( p, value );
		}
		MAC_NPH_BIOMAS.GrabMemory();
		if( MAC_NPH_BIOMAS.GetF(FLinkEdges) ) { MAC_NPH_BIOMAS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  IC_NPHBIO.Value();
			MAC_NPH_BIOMAS.InitValue( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::NPHBIO_PLANTING_u104_exe() {
	float value;

	switch( NPHBIO_PLANTING.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NPHBIO_PLANTING.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PLANTING.Value(p)*( ((float)1)-P1_P_RATIO.Value(p) ) );
			NPHBIO_PLANTING.Update( p, value );
		}
		NPHBIO_PLANTING.GrabMemory();
		if( NPHBIO_PLANTING.GetF(FICFlux) ) NPHBIO_PLANTING.Cov().Set(0.0); 
		if( NPHBIO_PLANTING.GetF(FLinkEdges) ) { NPHBIO_PLANTING.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PLANTING.Value()*( ((float)1)-P1_P_RATIO.Value() ) );
			NPHBIO_PLANTING.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::TRANSDOWN_u105_exe() {
	float value;

	switch( TRANSDOWN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TRANSDOWN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( HARVEST_TIME.Value(p) >  ((float)0) ) ) ? ( ((float)0) ) : ( ( ( TRANSDOWN_RT.Value(p)*( PHBIO_NPP.Value(p)+( P1_PH_TO_REP.Value(p)*MAC_PH_BIOMAS.Value(p) ) ) )+( P1_PHB_C_REC.Value(p)*FALL_LITTER.Value(p) ) ) ) ) ;
			TRANSDOWN.Update( p, value );
		}
		TRANSDOWN.GrabMemory();
		if( TRANSDOWN.GetF(FICFlux) ) TRANSDOWN.Cov().Set(0.0); 
		if( TRANSDOWN.GetF(FLinkEdges) ) { TRANSDOWN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( HARVEST_TIME.Value() >  ((float)0) ) ) ? ( ((float)0) ) : ( ( ( TRANSDOWN_RT.Value()*( PHBIO_NPP.Value()+( P1_PH_TO_REP.Value()*MAC_PH_BIOMAS.Value() ) ) )+( P1_PHB_C_REC.Value()*FALL_LITTER.Value() ) ) ) ) ;
			TRANSDOWN.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::NPHBIO_MORT_u106_exe() {
	float value;

	switch( NPHBIO_MORT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NPHBIO_MORT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( MAC_NPH_BIOMAS.Value(p)*P1_NPH_MORT.Value(p) )+( ( HARVEST_TIME.Delay(  p, dT() )*MAC_NPH_BIOMAS.Value(p) )/dT() ) );
			NPHBIO_MORT.Update( p, value );
		}
		NPHBIO_MORT.GrabMemory();
		if( NPHBIO_MORT.GetF(FICFlux) ) NPHBIO_MORT.Cov().Set(0.0); 
		if( NPHBIO_MORT.GetF(FLinkEdges) ) { NPHBIO_MORT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( MAC_NPH_BIOMAS.Value()*P1_NPH_MORT.Value() )+( ( HARVEST_TIME.Delay( dT() )*MAC_NPH_BIOMAS.Value() )/dT() ) );
			NPHBIO_MORT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::TRANSUP_u107_exe() {
	float value;

	switch( TRANSUP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TRANSUP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SPROUTING.Value(p)*P1_SPR_RATE.Value(p) )*MAC_NPH_BIOMAS.Value(p) );
			TRANSUP.Update( p, value );
		}
		TRANSUP.GrabMemory();
		if( TRANSUP.GetF(FICFlux) ) TRANSUP.Cov().Set(0.0); 
		if( TRANSUP.GetF(FLinkEdges) ) { TRANSUP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SPROUTING.Value()*P1_SPR_RATE.Value() )*MAC_NPH_BIOMAS.Value() );
			TRANSUP.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::NPHBIO_HARVEST_u108_exe() {
	float value;

	switch( NPHBIO_HARVEST.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NPHBIO_HARVEST.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( HARVEST_TIME.Value(p)*P1_NPH_PR_H.Value(p) )*MAC_NPH_BIOMAS.Value(p) )/dT() );
			NPHBIO_HARVEST.Update( p, value );
		}
		NPHBIO_HARVEST.GrabMemory();
		if( NPHBIO_HARVEST.GetF(FICFlux) ) NPHBIO_HARVEST.Cov().Set(0.0); 
		if( NPHBIO_HARVEST.GetF(FLinkEdges) ) { NPHBIO_HARVEST.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( HARVEST_TIME.Value()*P1_NPH_PR_H.Value() )*MAC_NPH_BIOMAS.Value() )/dT() );
			NPHBIO_HARVEST.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAC_PH_BIOMAS_I109_exe() {
	float value;

	MAC_PH_BIOMAS.UpdateIntegrator();
	switch( MAC_PH_BIOMAS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAC_PH_BIOMAS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( PHBIO_NPP.Value(p)+PHBIO_PLANT.Value(p) )+TRANSUP.Value(p) )-PHBIO_MORT.Value(p) )-PHBIO_HARVEST.Value(p) )-TRANSDOWN.Value(p) );
			MAC_PH_BIOMAS.Update( p, value, dT() );
		}
		MAC_PH_BIOMAS.GrabMemory();
		if( MAC_PH_BIOMAS.GetF(FLinkEdges) ) { MAC_PH_BIOMAS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( PHBIO_NPP.Value()+PHBIO_PLANT.Value() )+TRANSUP.Value() )-PHBIO_MORT.Value() )-PHBIO_HARVEST.Value() )-TRANSDOWN.Value() );
			MAC_PH_BIOMAS.Update( value, dT() );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAC_PH_BIOMAS_i110_exe() {
	float value;

	MAC_PH_BIOMAS.UpdateIntegrator();
	switch( MAC_PH_BIOMAS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAC_PH_BIOMAS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  IC_PHBIO.Value(p);
			MAC_PH_BIOMAS.InitValue( p, value );
		}
		MAC_PH_BIOMAS.GrabMemory();
		if( MAC_PH_BIOMAS.GetF(FLinkEdges) ) { MAC_PH_BIOMAS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  IC_PHBIO.Value();
			MAC_PH_BIOMAS.InitValue( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PHBIO_NPP_u111_exe() {
	float value;

	switch( PHBIO_NPP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_NPP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( HARVEST_TIME.Value(p) >  ((float)0) ) ) ? ( ((float)0) ) : ( PHBIO_NPP_CALC.Value(p) ) ) ;
			PHBIO_NPP.Update( p, value );
		}
		PHBIO_NPP.GrabMemory();
		if( PHBIO_NPP.GetF(FICFlux) ) PHBIO_NPP.Cov().Set(0.0); 
		if( PHBIO_NPP.GetF(FLinkEdges) ) { PHBIO_NPP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( HARVEST_TIME.Value() >  ((float)0) ) ) ? ( ((float)0) ) : ( PHBIO_NPP_CALC.Value() ) ) ;
			PHBIO_NPP.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PHBIO_PLANT_u112_exe() {
	float value;

	switch( PHBIO_PLANT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_PLANT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PLANTING.Value(p)*P1_P_RATIO.Value(p) );
			PHBIO_PLANT.Update( p, value );
		}
		PHBIO_PLANT.GrabMemory();
		if( PHBIO_PLANT.GetF(FICFlux) ) PHBIO_PLANT.Cov().Set(0.0); 
		if( PHBIO_PLANT.GetF(FLinkEdges) ) { PHBIO_PLANT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PLANTING.Value()*P1_P_RATIO.Value() );
			PHBIO_PLANT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PHBIO_MORT_u113_exe() {
	float value;

	switch( PHBIO_MORT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_MORT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( HARVEST_TIME.Delay(  p, dT() )*MAC_PH_BIOMAS.Value(p) )/dT() )+( FALL_LITTER.Value(p)*( ((float)1)-P1_PHB_C_REC.Value(p) ) ) )+( MAC_PH_BIOMAS.Value(p)*( PHBIO_MORT_WATER.Value(p)+P1_PHB_MORT.Value(p) ) ) );
			PHBIO_MORT.Update( p, value );
		}
		PHBIO_MORT.GrabMemory();
		if( PHBIO_MORT.GetF(FICFlux) ) PHBIO_MORT.Cov().Set(0.0); 
		if( PHBIO_MORT.GetF(FLinkEdges) ) { PHBIO_MORT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( HARVEST_TIME.Delay( dT() )*MAC_PH_BIOMAS.Value() )/dT() )+( FALL_LITTER.Value()*( ((float)1)-P1_PHB_C_REC.Value() ) ) )+( MAC_PH_BIOMAS.Value()*( PHBIO_MORT_WATER.Value()+P1_PHB_MORT.Value() ) ) );
			PHBIO_MORT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PHBIO_HARVEST_u114_exe() {
	float value;

	switch( PHBIO_HARVEST.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_HARVEST.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( HARVEST_TIME.Value(p)+REMOVAL_TIME.Value(p) )*P1_PHB_PR_H.Value(p) )*MAC_PH_BIOMAS.Value(p) )/dT() );
			PHBIO_HARVEST.Update( p, value );
		}
		PHBIO_HARVEST.GrabMemory();
		if( PHBIO_HARVEST.GetF(FICFlux) ) PHBIO_HARVEST.Cov().Set(0.0); 
		if( PHBIO_HARVEST.GetF(FLinkEdges) ) { PHBIO_HARVEST.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( HARVEST_TIME.Value()+REMOVAL_TIME.Value() )*P1_PHB_PR_H.Value() )*MAC_PH_BIOMAS.Value() )/dT() );
			PHBIO_HARVEST.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PH_MAX_I115_exe() {
	float value;

	PH_MAX.UpdateIntegrator();
	switch( PH_MAX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PH_MAX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PH_IN.Value(p)-PH_OUT.Value(p) );
			PH_MAX.Update( p, value, dT() );
		}
		PH_MAX.GrabMemory();
		if( PH_MAX.GetF(FLinkEdges) ) { PH_MAX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PH_IN.Value()-PH_OUT.Value() );
			PH_MAX.Update( value, dT() );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PH_MAX_i116_exe() {
	float value;

	PH_MAX.UpdateIntegrator();
	switch( PH_MAX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PH_MAX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			PH_MAX.InitValue( p, value );
		}
		PH_MAX.GrabMemory();
		if( PH_MAX.GetF(FLinkEdges) ) { PH_MAX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			PH_MAX.InitValue( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PH_IN_u117_exe() {
	float value;

	switch( PH_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PH_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( MAC_PH_BIOMAS.Value(p) >  PH_MAX.Value(p) ) ) ? ( ( MAC_PH_BIOMAS.Value(p)/dT() ) ) : ( ((float)0) ) ) ;
			PH_IN.Update( p, value );
		}
		PH_IN.GrabMemory();
		if( PH_IN.GetF(FICFlux) ) PH_IN.Cov().Set(0.0); 
		if( PH_IN.GetF(FLinkEdges) ) { PH_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( MAC_PH_BIOMAS.Value() >  PH_MAX.Value() ) ) ? ( ( MAC_PH_BIOMAS.Value()/dT() ) ) : ( ((float)0) ) ) ;
			PH_IN.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PH_OUT_u118_exe() {
	float value;

	switch( PH_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PH_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( MAC_PH_BIOMAS.Value(p) >  PH_MAX.Value(p) ) || ( PLANTIME.Value(p) == ((float)1) ) ) ) ? ( ( PH_MAX.Value(p)/dT() ) ) : ( ((float)0) ) ) ;
			PH_OUT.Update( p, value );
		}
		PH_OUT.GrabMemory();
		if( PH_OUT.GetF(FICFlux) ) PH_OUT.Cov().Set(0.0); 
		if( PH_OUT.GetF(FLinkEdges) ) { PH_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( MAC_PH_BIOMAS.Value() >  PH_MAX.Value() ) || ( PLANTIME.Value() == ((float)1) ) ) ) ? ( ( PH_MAX.Value()/dT() ) ) : ( ((float)0) ) ) ;
			PH_OUT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::TOT_NPP_I119_exe() {
	float value;

	TOT_NPP.UpdateIntegrator();
	switch( TOT_NPP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOT_NPP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  NPP_IN.Value(p);
			TOT_NPP.Update( p, value, dT() );
		}
		TOT_NPP.GrabMemory();
		if( TOT_NPP.GetF(FLinkEdges) ) { TOT_NPP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  NPP_IN.Value();
			TOT_NPP.Update( value, dT() );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::TOT_NPP_i120_exe() {
	float value;

	TOT_NPP.UpdateIntegrator();
	switch( TOT_NPP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOT_NPP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			TOT_NPP.InitValue( p, value );
		}
		TOT_NPP.GrabMemory();
		if( TOT_NPP.GetF(FLinkEdges) ) { TOT_NPP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			TOT_NPP.InitValue( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::NPP_IN_u121_exe() {
	float value;

	switch( NPP_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NPP_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( HABITATMAP.Value(p) == ((float)2) ) ) ? ( PHBIO_NPP.Value(p) ) : ( ((float)0) ) ) ;
			NPP_IN.Update( p, value );
		}
		NPP_IN.GrabMemory();
		if( NPP_IN.GetF(FICFlux) ) NPP_IN.Cov().Set(0.0); 
		if( NPP_IN.GetF(FLinkEdges) ) { NPP_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( HABITATMAP.Value() == ((float)2) ) ) ? ( PHBIO_NPP.Value() ) : ( ((float)0) ) ) ;
			NPP_IN.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::YIELD_I122_exe() {
	float value;

	YIELD.UpdateIntegrator();
	switch( YIELD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = YIELD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( HARVEST.Value(p)-INI_YIELD.Value(p) );
			YIELD.Update( p, value, dT() );
		}
		YIELD.GrabMemory();
		if( YIELD.GetF(FLinkEdges) ) { YIELD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( HARVEST.Value()-INI_YIELD.Value() );
			YIELD.Update( value, dT() );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::YIELD_i123_exe() {
	float value;

	YIELD.UpdateIntegrator();
	switch( YIELD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = YIELD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			YIELD.InitValue( p, value );
		}
		YIELD.GrabMemory();
		if( YIELD.GetF(FLinkEdges) ) { YIELD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			YIELD.InitValue( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::HARVEST_u124_exe() {
	float value;

	switch( HARVEST.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HARVEST.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PHBIO_HARVEST.Value(p)+NPHBIO_HARVEST.Value(p) );
			HARVEST.Update( p, value );
		}
		HARVEST.GrabMemory();
		if( HARVEST.GetF(FICFlux) ) HARVEST.Cov().Set(0.0); 
		if( HARVEST.GetF(FLinkEdges) ) { HARVEST.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PHBIO_HARVEST.Value()+NPHBIO_HARVEST.Value() );
			HARVEST.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::INI_YIELD_u125_exe() {
	float value;

	switch( INI_YIELD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = INI_YIELD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( DAYJUL.Value(p) == ((float)1) ) ) ? ( ( ( YIELD.Value(p)/dT() )*((float)0) ) ) : ( ((float)0) ) ) ;
			INI_YIELD.Update( p, value );
		}
		INI_YIELD.GrabMemory();
		if( INI_YIELD.GetF(FICFlux) ) INI_YIELD.Cov().Set(0.0); 
		if( INI_YIELD.GetF(FLinkEdges) ) { INI_YIELD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( DAYJUL.Value() == ((float)1) ) ) ? ( ( ( YIELD.Value()/dT() )*((float)0) ) ) : ( ((float)0) ) ) ;
			INI_YIELD.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::DAY_LENGTH_PREV_u126_exe() {
	float value;

	switch( DAY_LENGTH_PREV.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DAY_LENGTH_PREV.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  DAYLENGTH.Delay(  p, ((float)1) );
			DAY_LENGTH_PREV.Update( p, value );
		}
		DAY_LENGTH_PREV.GrabMemory();
		if( DAY_LENGTH_PREV.GetF(FLinkEdges) ) { DAY_LENGTH_PREV.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  DAYLENGTH.Delay( ((float)1) );
			DAY_LENGTH_PREV.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::FALL_LITTER_u127_exe() {
	float value;

	switch( FALL_LITTER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FALL_LITTER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(FALL_LITTER_CALC.Value(p), SL::Max(((float)0), ( MAC_PH_BIOMAS.Value(p)-( ( P1_PHB_EVGRN.Value(p)*PH_MAX.Value(p) )/( ((float)1)+P1_PHB_EVGRN.Value(p) ) ) )));
			FALL_LITTER.Update( p, value );
		}
		FALL_LITTER.GrabMemory();
		if( FALL_LITTER.GetF(FLinkEdges) ) { FALL_LITTER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(FALL_LITTER_CALC.Value(), SL::Max(((float)0), ( MAC_PH_BIOMAS.Value()-( ( P1_PHB_EVGRN.Value()*PH_MAX.Value() )/( ((float)1)+P1_PHB_EVGRN.Value() ) ) )));
			FALL_LITTER.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::FALL_LITTER_CALC_u128_exe() {
	float value;

	switch( FALL_LITTER_CALC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FALL_LITTER_CALC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( DAYLENGTH.Value(p) >  P1_DAYLENG_RQ.Value(p) ) || ( DAYLENGTH.Value(p) >= DAY_LENGTH_PREV.Value(p) ) ) ) ? ( ((float)0) ) : (  ( ( ( MAC_PH_BIOMAS.Value(p) <  ( 0.01*( ((float)1)-P1_PHB_EVGRN.Value(p) ) ) ) ) ? ( ( ( ( ((float)1)-P1_PHB_EVGRN.Value(p) )*MAC_PH_BIOMAS.Value(p) )/dT() ) ) : ( ( ( ((float)1)-P1_PHB_EVGRN.Value(p) )*pow((double)( ( PH_MAX.Value(p)*P1_PHB_L_RT.Value(p) )/MAC_PH_BIOMAS.Value(p) ),(double)((float)3) ) ) ) )  ) ) ;
			FALL_LITTER_CALC.Update( p, value );
		}
		FALL_LITTER_CALC.GrabMemory();
		if( FALL_LITTER_CALC.GetF(FLinkEdges) ) { FALL_LITTER_CALC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( DAYLENGTH.Value() >  P1_DAYLENG_RQ.Value() ) || ( DAYLENGTH.Value() >= DAY_LENGTH_PREV.Value() ) ) ) ? ( ((float)0) ) : (  ( ( ( MAC_PH_BIOMAS.Value() <  ( 0.01*( ((float)1)-P1_PHB_EVGRN.Value() ) ) ) ) ? ( ( ( ( ((float)1)-P1_PHB_EVGRN.Value() )*MAC_PH_BIOMAS.Value() )/dT() ) ) : ( ( ( ((float)1)-P1_PHB_EVGRN.Value() )*pow((double)( ( PH_MAX.Value()*P1_PHB_L_RT.Value() )/MAC_PH_BIOMAS.Value() ),(double)((float)3) ) ) ) )  ) ) ;
			FALL_LITTER_CALC.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::HARVEST_TIME_u129_exe() {
	float value;

	switch( HARVEST_TIME.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HARVEST_TIME.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( DAYJUL.Value(p) >  P1_H_DAY.Value(p) ) && ( DAYJUL.Value(p) <  ( P1_H_DAY.Value(p)+((float)3) ) ) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			HARVEST_TIME.Update( p, value );
		}
		HARVEST_TIME.GrabMemory();
		HARVEST_TIME.UpdateDelayData();
		if( HARVEST_TIME.GetF(FLinkEdges) ) { HARVEST_TIME.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( DAYJUL.Value() >  P1_H_DAY.Value() ) && ( DAYJUL.Value() <  ( P1_H_DAY.Value()+((float)3) ) ) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			HARVEST_TIME.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::IC_NPHBIO_u130_exe() {
	float value;

	switch( IC_NPHBIO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = IC_NPHBIO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_NPH_ABBM_IC.Value(p)*( P1_NPH_AB_BEL.Value(p)+((float)1) ) )/P1_NPH_AB_BEL.Value(p) );
			IC_NPHBIO.Update( p, value );
		}
		IC_NPHBIO.GrabMemory();
		if( IC_NPHBIO.GetF(FLinkEdges) ) { IC_NPHBIO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_NPH_ABBM_IC.Value()*( P1_NPH_AB_BEL.Value()+((float)1) ) )/P1_NPH_AB_BEL.Value() );
			IC_NPHBIO.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::IC_PHBIO_u131_exe() {
	float value;

	switch( IC_PHBIO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = IC_PHBIO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( P1_PHB_EVGRN.Value(p)*P1_NPH_ABBM_IC.Value(p) )*P1_MAX_PH_ABBM.Value(p) )/( ((float)1)-P1_MAX_PH_ABBM.Value(p) ) );
			IC_PHBIO.Update( p, value );
		}
		IC_PHBIO.GrabMemory();
		if( IC_PHBIO.GetF(FLinkEdges) ) { IC_PHBIO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( P1_PHB_EVGRN.Value()*P1_NPH_ABBM_IC.Value() )*P1_MAX_PH_ABBM.Value() )/( ((float)1)-P1_MAX_PH_ABBM.Value() ) );
			IC_PHBIO.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::LIGHT_CF_u132_exe() {
	float value;

	switch( LIGHT_CF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LIGHT_CF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SOLRADGR.Value(p)/P1_LIGHTSAT.Value(p) )*SL::Exp(( ((float)1)-( SOLRADGR.Value(p)/P1_LIGHTSAT.Value(p) ) )) );
			LIGHT_CF.Update( p, value );
		}
		LIGHT_CF.GrabMemory();
		if( LIGHT_CF.GetF(FLinkEdges) ) { LIGHT_CF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SOLRADGR.Value()/P1_LIGHTSAT.Value() )*SL::Exp(( ((float)1)-( SOLRADGR.Value()/P1_LIGHTSAT.Value() ) )) );
			LIGHT_CF.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MACH_u133_exe() {
	float value;

	switch( MACH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MACH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_MAX_HT_BM.Value(p)*TOTAL_BIOM.Value(p) )/MAX_BM.Value(p) );
			MACH.Update( p, value );
		}
		MACH.GrabMemory();
		if( MACH.GetF(FLinkEdges) ) { MACH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_MAX_HT_BM.Value()*TOTAL_BIOM.Value() )/MAX_BM.Value() );
			MACH.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MACLAI_u134_exe() {
	float value;

	switch( MACLAI.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MACLAI.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(( MAC_PH_BIOMAS.Value(p)*P1_PROP_LA_TO_B.Value(p) ), P1_MAX_LAI.Value(p));
			MACLAI.Update( p, value );
		}
		MACLAI.GrabMemory();
		if( MACLAI.GetF(FLinkEdges) ) { MACLAI.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(( MAC_PH_BIOMAS.Value()*P1_PROP_LA_TO_B.Value() ), P1_MAX_LAI.Value());
			MACLAI.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAC_LAI_R_u135_exe() {
	float value;

	switch( MAC_LAI_R.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAC_LAI_R.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( MACLAI.Value(p)/P1_MAX_LAI.Value(p) );
			MAC_LAI_R.Update( p, value );
		}
		MAC_LAI_R.GrabMemory();
		if( MAC_LAI_R.GetF(FLinkEdges) ) { MAC_LAI_R.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( MACLAI.Value()/P1_MAX_LAI.Value() );
			MAC_LAI_R.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAC_PROD_CF_u136_exe() {
	float value;

	switch( MAC_PROD_CF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAC_PROD_CF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SL::Min(LIGHT_CF.Value(p), TEMP_CF.Value(p))*WATER_CF.Value(p) )*NUTR_CF.Value(p) );
			MAC_PROD_CF.Update( p, value );
		}
		MAC_PROD_CF.GrabMemory();
		if( MAC_PROD_CF.GetF(FLinkEdges) ) { MAC_PROD_CF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SL::Min(LIGHT_CF.Value(), TEMP_CF.Value())*WATER_CF.Value() )*NUTR_CF.Value() );
			MAC_PROD_CF.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAX_BM_u137_exe() {
	float value;

	switch( MAX_BM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAX_BM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( MAX_NPH.Value(p)+MAX_PH.Value(p) );
			MAX_BM.Update( p, value );
		}
		MAX_BM.GrabMemory();
		if( MAX_BM.GetF(FLinkEdges) ) { MAX_BM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( MAX_NPH.Value()+MAX_PH.Value() );
			MAX_BM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAX_NPH_u138_exe() {
	float value;

	switch( MAX_NPH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAX_NPH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_MAX_AB_BM.Value(p)-MAX_PH.Value(p) )*( ((float)1)+( ((float)1)/P1_NPH_AB_BEL.Value(p) ) ) );
			MAX_NPH.Update( p, value );
		}
		MAX_NPH.GrabMemory();
		if( MAX_NPH.GetF(FLinkEdges) ) { MAX_NPH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_MAX_AB_BM.Value()-MAX_PH.Value() )*( ((float)1)+( ((float)1)/P1_NPH_AB_BEL.Value() ) ) );
			MAX_NPH.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::MAX_PH_u139_exe() {
	float value;

	switch( MAX_PH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAX_PH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_MAX_AB_BM.Value(p)*P1_MAX_PH_ABBM.Value(p) );
			MAX_PH.Update( p, value );
		}
		MAX_PH.GrabMemory();
		if( MAX_PH.GetF(FLinkEdges) ) { MAX_PH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_MAX_AB_BM.Value()*P1_MAX_PH_ABBM.Value() );
			MAX_PH.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::NPH_AB_BM_u140_exe() {
	float value;

	switch( NPH_AB_BM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NPH_AB_BM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_NPH_AB_BEL.Value(p)*ROOT_BM.Value(p) );
			NPH_AB_BM.Update( p, value );
		}
		NPH_AB_BM.GrabMemory();
		if( NPH_AB_BM.GetF(FLinkEdges) ) { NPH_AB_BM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_NPH_AB_BEL.Value()*ROOT_BM.Value() );
			NPH_AB_BM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::NUTR_CF_u141_exe() {
	float value;

	switch( NUTR_CF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NUTR_CF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(( DIN_AVAILABLE.Value(p)/( DIN_AVAILABLE.Value(p)+P1_MAC_KS_N.Value(p) ) ), ( PO4SD_CONCTOT.Value(p)/( PO4SD_CONCTOT.Value(p)+P1_MAC_KS_P.Value(p) ) ));
			NUTR_CF.Update( p, value );
		}
		NUTR_CF.GrabMemory();
		if( NUTR_CF.GetF(FLinkEdges) ) { NUTR_CF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(( DIN_AVAILABLE.Value()/( DIN_AVAILABLE.Value()+P1_MAC_KS_N.Value() ) ), ( PO4SD_CONCTOT.Value()/( PO4SD_CONCTOT.Value()+P1_MAC_KS_P.Value() ) ));
			NUTR_CF.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PHBIO_MORT_WATER_u142_exe() {
	float value;

	switch( PHBIO_MORT_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_MORT_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( 0.1*SL::Max(((float)0), ( ((float)1)-WATER_CF.Value(p) )) );
			PHBIO_MORT_WATER.Update( p, value );
		}
		PHBIO_MORT_WATER.GrabMemory();
		if( PHBIO_MORT_WATER.GetF(FLinkEdges) ) { PHBIO_MORT_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( 0.1*SL::Max(((float)0), ( ((float)1)-WATER_CF.Value() )) );
			PHBIO_MORT_WATER.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PHBIO_NPP_CALC_u143_exe() {
	float value;

	switch( PHBIO_NPP_CALC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_NPP_CALC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( MAC_PH_BIOMAS.Value(p) <  MAX_PH.Value(p) ) ) ? ( ( ( ( MAC_PROD_CF.Value(p)*P1_NPP.Value(p) )*MAC_PH_BIOMAS.Value(p) )*( ((float)1)-( MAC_PH_BIOMAS.Value(p)/MAX_PH.Value(p) ) ) ) ) : ( ((float)0) ) ) ;
			PHBIO_NPP_CALC.Update( p, value );
		}
		PHBIO_NPP_CALC.GrabMemory();
		if( PHBIO_NPP_CALC.GetF(FLinkEdges) ) { PHBIO_NPP_CALC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( MAC_PH_BIOMAS.Value() <  MAX_PH.Value() ) ) ? ( ( ( ( MAC_PROD_CF.Value()*P1_NPP.Value() )*MAC_PH_BIOMAS.Value() )*( ((float)1)-( MAC_PH_BIOMAS.Value()/MAX_PH.Value() ) ) ) ) : ( ((float)0) ) ) ;
			PHBIO_NPP_CALC.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PH_TO_ABBM_u144_exe() {
	float value;

	switch( PH_TO_ABBM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PH_TO_ABBM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( NPH_AB_BM.Value(p) == ((float)0) ) ) ? ( ((float)0) ) : ( ( MAC_PH_BIOMAS.Value(p)/( MAC_PH_BIOMAS.Value(p)+NPH_AB_BM.Value(p) ) ) ) ) ;
			PH_TO_ABBM.Update( p, value );
		}
		PH_TO_ABBM.GrabMemory();
		if( PH_TO_ABBM.GetF(FLinkEdges) ) { PH_TO_ABBM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( NPH_AB_BM.Value() == ((float)0) ) ) ? ( ((float)0) ) : ( ( MAC_PH_BIOMAS.Value()/( MAC_PH_BIOMAS.Value()+NPH_AB_BM.Value() ) ) ) ) ;
			PH_TO_ABBM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PLANTIME_u145_exe() {
	float value;

	switch( PLANTIME.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PLANTIME.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( DAYJUL.Value(p) == P1_P_DAY.Value(p) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			PLANTIME.Update( p, value );
		}
		PLANTIME.GrabMemory();
		if( PLANTIME.GetF(FLinkEdges) ) { PLANTIME.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( DAYJUL.Value() == P1_P_DAY.Value() ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			PLANTIME.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PLANTING_u146_exe() {
	float value;

	switch( PLANTING.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PLANTING.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( PLANTIME.Value(p)*P1_MAX_DENS.Value(p) )*P1_P_WT.Value(p) );
			PLANTING.Update( p, value );
		}
		PLANTING.GrabMemory();
		if( PLANTING.GetF(FLinkEdges) ) { PLANTING.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( PLANTIME.Value()*P1_MAX_DENS.Value() )*P1_P_WT.Value() );
			PLANTING.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::PO4SD_CONCTOT_u147_exe() {
	float value;

	switch( PO4SD_CONCTOT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4SD_CONCTOT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1000;
			PO4SD_CONCTOT.Update( p, PO4SD_CONCTOT.ParameterValue(value,p) );
		}
		PO4SD_CONCTOT.GrabMemory();
		if( PO4SD_CONCTOT.GetF(FLinkEdges) ) { PO4SD_CONCTOT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1000;
			PO4SD_CONCTOT.Update( PO4SD_CONCTOT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::REMOVAL_TIME_u148_exe() {
	float value;

	switch( REMOVAL_TIME.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = REMOVAL_TIME.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( MACH.Value(p)*P1_PHB_PR_H.Value(p) ) >  P1_EST_HEIGHT.Value(p) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			REMOVAL_TIME.Update( p, value );
		}
		REMOVAL_TIME.GrabMemory();
		if( REMOVAL_TIME.GetF(FLinkEdges) ) { REMOVAL_TIME.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( MACH.Value()*P1_PHB_PR_H.Value() ) >  P1_EST_HEIGHT.Value() ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			REMOVAL_TIME.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::ROOT_BM_u149_exe() {
	float value;

	switch( ROOT_BM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ROOT_BM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( MAC_NPH_BIOMAS.Value(p)/( P1_NPH_AB_BEL.Value(p)+((float)1) ) );
			ROOT_BM.Update( p, value );
		}
		ROOT_BM.GrabMemory();
		if( ROOT_BM.GetF(FLinkEdges) ) { ROOT_BM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( MAC_NPH_BIOMAS.Value()/( P1_NPH_AB_BEL.Value()+((float)1) ) );
			ROOT_BM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::ROOT_DEPTH_u150_exe() {
	float value;

	switch( ROOT_DEPTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ROOT_DEPTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(( ELEVATION.Value(p)-((float)1) ), ( ROOT_BM.Value(p)/P1_ROOT_DENS.Value(p) ));
			ROOT_DEPTH.Update( p, value );
		}
		ROOT_DEPTH.GrabMemory();
		if( ROOT_DEPTH.GetF(FLinkEdges) ) { ROOT_DEPTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(( ELEVATION.Value()-((float)1) ), ( ROOT_BM.Value()/P1_ROOT_DENS.Value() ));
			ROOT_DEPTH.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::SPROUTING_u151_exe() {
	float value;

	switch( SPROUTING.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SPROUTING.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( PH_TO_ABBM.Value(p) <  P1_MAX_PH_ABBM.Value(p) ) && ( ( BIO_TIME.Value(p) >  P1_BIO_START.Value(p) ) && ( BIO_TIME.Value(p) <  P1_BIO_END.Value(p) ) ) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			SPROUTING.Update( p, value );
		}
		SPROUTING.GrabMemory();
		if( SPROUTING.GetF(FLinkEdges) ) { SPROUTING.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( PH_TO_ABBM.Value() <  P1_MAX_PH_ABBM.Value() ) && ( ( BIO_TIME.Value() >  P1_BIO_START.Value() ) && ( BIO_TIME.Value() <  P1_BIO_END.Value() ) ) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			SPROUTING.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::TEMP_CF_u152_exe() {
	float value;

	switch( TEMP_CF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TEMP_CF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SL::Exp(( 0.20*( AIR_TEMP_C.Value(p)-P1_TEMPOPT.Value(p) ) ))*pow((double)( ( ((float)40)-AIR_TEMP_C.Value(p) )/( ((float)40)-P1_TEMPOPT.Value(p) ) ),(double)( 0.20*( ((float)40)-P1_TEMPOPT.Value(p) ) ) ) );
			TEMP_CF.Update( p, value );
		}
		TEMP_CF.GrabMemory();
		if( TEMP_CF.GetF(FLinkEdges) ) { TEMP_CF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SL::Exp(( 0.20*( AIR_TEMP_C.Value()-P1_TEMPOPT.Value() ) ))*pow((double)( ( ((float)40)-AIR_TEMP_C.Value() )/( ((float)40)-P1_TEMPOPT.Value() ) ),(double)( 0.20*( ((float)40)-P1_TEMPOPT.Value() ) ) ) );
			TEMP_CF.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::TOTAL_BIOM_u153_exe() {
	float value;

	switch( TOTAL_BIOM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOTAL_BIOM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( MAC_PH_BIOMAS.Value(p)+MAC_NPH_BIOMAS.Value(p) );
			TOTAL_BIOM.Update( p, value );
		}
		TOTAL_BIOM.GrabMemory();
		if( TOTAL_BIOM.GetF(FLinkEdges) ) { TOTAL_BIOM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( MAC_PH_BIOMAS.Value()+MAC_NPH_BIOMAS.Value() );
			TOTAL_BIOM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::TRANSDOWN_RT_u154_exe() {
	float value;

	switch( TRANSDOWN_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TRANSDOWN_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( BIO_TIME.Value(p) >  ( P1_BIO_REPRO.Value(p)+((float)1) ) ) ) ? ( ( ((float)1)-( ((float)1)/pow((double)( BIO_TIME.Value(p)-P1_BIO_REPRO.Value(p) ),(double)0.5 ) ) ) ) : (  ( ( ( PH_TO_ABBM.Value(p) <  P1_MAX_PH_ABBM.Value(p) ) ) ? ( ((float)0) ) : ( pow((double)SL::Cos(( ( ( P1_MAX_PH_ABBM.Value(p)/PH_TO_ABBM.Value(p) )*3.141590 )/2. )),(double)0.1 ) ) )  ) ) ;
			TRANSDOWN_RT.Update( p, value );
		}
		TRANSDOWN_RT.GrabMemory();
		if( TRANSDOWN_RT.GetF(FLinkEdges) ) { TRANSDOWN_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( BIO_TIME.Value() >  ( P1_BIO_REPRO.Value()+((float)1) ) ) ) ? ( ( ((float)1)-( ((float)1)/pow((double)( BIO_TIME.Value()-P1_BIO_REPRO.Value() ),(double)0.5 ) ) ) ) : (  ( ( ( PH_TO_ABBM.Value() <  P1_MAX_PH_ABBM.Value() ) ) ? ( ((float)0) ) : ( pow((double)SL::Cos(( ( ( P1_MAX_PH_ABBM.Value()/PH_TO_ABBM.Value() )*3.141590 )/2. )),(double)0.1 ) ) )  ) ) ;
			TRANSDOWN_RT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::WATER_CF_u155_exe() {
	float value;

	switch( WATER_CF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WATER_CF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(WAT_STRESS_HIGH.Value(p), WAT_STRESS_LOW.Value(p));
			WATER_CF.Update( p, value );
		}
		WATER_CF.GrabMemory();
		if( WATER_CF.GetF(FLinkEdges) ) { WATER_CF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(WAT_STRESS_HIGH.Value(), WAT_STRESS_LOW.Value());
			WATER_CF.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::WAT_STRESS_HIGH_u156_exe() {
	float value;

	switch( WAT_STRESS_HIGH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WAT_STRESS_HIGH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( P1_W_T_MAX.Value(p) <  ((float)0) ) && ( SURFACE_WATER.Value(p) >  -P1_W_T_MAX.Value(p) ) ) ) ? ( SL::Max(((float)0), ( ((float)1)/( ((float)1)+SL::Exp(( SURFACE_WATER.Value(p)+P1_W_T_MAX.Value(p) )) ) )) ) : (  ( ( ( ( P1_W_T_MAX.Value(p) >  ((float)0) ) && ( ROOT_DEPTH.Value(p) >  ((float)0) ) ) ) ? ( SL::Min(((float)1), ( ( UW_DEPTH.Value(p)/ROOT_DEPTH.Value(p) )/P1_W_T_MAX.Value(p) )) ) : ( ((float)1) ) )  ) ) ;
			WAT_STRESS_HIGH.Update( p, value );
		}
		WAT_STRESS_HIGH.GrabMemory();
		if( WAT_STRESS_HIGH.GetF(FLinkEdges) ) { WAT_STRESS_HIGH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( P1_W_T_MAX.Value() <  ((float)0) ) && ( SURFACE_WATER.Value() >  -P1_W_T_MAX.Value() ) ) ) ? ( SL::Max(((float)0), ( ((float)1)/( ((float)1)+SL::Exp(( SURFACE_WATER.Value()+P1_W_T_MAX.Value() )) ) )) ) : (  ( ( ( ( P1_W_T_MAX.Value() >  ((float)0) ) && ( ROOT_DEPTH.Value() >  ((float)0) ) ) ) ? ( SL::Min(((float)1), ( ( UW_DEPTH.Value()/ROOT_DEPTH.Value() )/P1_W_T_MAX.Value() )) ) : ( ((float)1) ) )  ) ) ;
			WAT_STRESS_HIGH.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::WAT_STRESS_LOW_u157_exe() {
	float value;

	switch( WAT_STRESS_LOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WAT_STRESS_LOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  pow((double)SL::Sin(( ( WATER_AVAIL.Value(p)*3.141590 )/2 )),(double)P1_W_T_MIN.Value(p) );
			WAT_STRESS_LOW.Update( p, value );
		}
		WAT_STRESS_LOW.GrabMemory();
		if( WAT_STRESS_LOW.GetF(FLinkEdges) ) { WAT_STRESS_LOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  pow((double)SL::Sin(( ( WATER_AVAIL.Value()*3.141590 )/2 )),(double)P1_W_T_MIN.Value() );
			WAT_STRESS_LOW.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_BIO_END_u158_exe() {
	float value;

	switch( P1_BIO_END.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_BIO_END.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)570);
			P1_BIO_END.Update( p, value );
		}
		P1_BIO_END.GrabMemory();
		if( P1_BIO_END.GetF(FLinkEdges) ) { P1_BIO_END.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)570);
			P1_BIO_END.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_BIO_REPRO_u159_exe() {
	float value;

	switch( P1_BIO_REPRO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_BIO_REPRO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1700);
			P1_BIO_REPRO.Update( p, value );
		}
		P1_BIO_REPRO.GrabMemory();
		if( P1_BIO_REPRO.GetF(FLinkEdges) ) { P1_BIO_REPRO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1700);
			P1_BIO_REPRO.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_BIO_START_u160_exe() {
	float value;

	switch( P1_BIO_START.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_BIO_START.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)500);
			P1_BIO_START.Update( p, value );
		}
		P1_BIO_START.GrabMemory();
		if( P1_BIO_START.GetF(FLinkEdges) ) { P1_BIO_START.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)500);
			P1_BIO_START.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_DAYLENG_RQ_u161_exe() {
	float value;

	switch( P1_DAYLENG_RQ.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DAYLENG_RQ.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)13);
			P1_DAYLENG_RQ.Update( p, value );
		}
		P1_DAYLENG_RQ.GrabMemory();
		if( P1_DAYLENG_RQ.GetF(FLinkEdges) ) { P1_DAYLENG_RQ.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)13);
			P1_DAYLENG_RQ.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_EST_HEIGHT_u162_exe() {
	float value;

	switch( P1_EST_HEIGHT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_EST_HEIGHT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)500);
			P1_EST_HEIGHT.Update( p, value );
		}
		P1_EST_HEIGHT.GrabMemory();
		if( P1_EST_HEIGHT.GetF(FLinkEdges) ) { P1_EST_HEIGHT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)500);
			P1_EST_HEIGHT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_H_DAY_u163_exe() {
	float value;

	switch( P1_H_DAY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_H_DAY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)319);
			P1_H_DAY.Update( p, value );
		}
		P1_H_DAY.GrabMemory();
		if( P1_H_DAY.GetF(FLinkEdges) ) { P1_H_DAY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)319);
			P1_H_DAY.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_LIGHTSAT_u164_exe() {
	float value;

	switch( P1_LIGHTSAT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_LIGHTSAT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)600);
			P1_LIGHTSAT.Update( p, value );
		}
		P1_LIGHTSAT.GrabMemory();
		if( P1_LIGHTSAT.GetF(FLinkEdges) ) { P1_LIGHTSAT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)600);
			P1_LIGHTSAT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_MAC_KS_N_u165_exe() {
	float value;

	switch( P1_MAC_KS_N.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAC_KS_N.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.00265;
			P1_MAC_KS_N.Update( p, value );
		}
		P1_MAC_KS_N.GrabMemory();
		if( P1_MAC_KS_N.GetF(FLinkEdges) ) { P1_MAC_KS_N.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.00265;
			P1_MAC_KS_N.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_MAC_KS_P_u166_exe() {
	float value;

	switch( P1_MAC_KS_P.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAC_KS_P.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000037;
			P1_MAC_KS_P.Update( p, value );
		}
		P1_MAC_KS_P.GrabMemory();
		if( P1_MAC_KS_P.GetF(FLinkEdges) ) { P1_MAC_KS_P.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000037;
			P1_MAC_KS_P.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_MAX_AB_BM_u167_exe() {
	float value;

	switch( P1_MAX_AB_BM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAX_AB_BM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.6;
			P1_MAX_AB_BM.Update( p, value );
		}
		P1_MAX_AB_BM.GrabMemory();
		if( P1_MAX_AB_BM.GetF(FLinkEdges) ) { P1_MAX_AB_BM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.6;
			P1_MAX_AB_BM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_MAX_DENS_u168_exe() {
	float value;

	switch( P1_MAX_DENS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAX_DENS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)40);
			P1_MAX_DENS.Update( p, value );
		}
		P1_MAX_DENS.GrabMemory();
		if( P1_MAX_DENS.GetF(FLinkEdges) ) { P1_MAX_DENS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)40);
			P1_MAX_DENS.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_MAX_HT_BM_u169_exe() {
	float value;

	switch( P1_MAX_HT_BM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAX_HT_BM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.8;
			P1_MAX_HT_BM.Update( p, value );
		}
		P1_MAX_HT_BM.GrabMemory();
		if( P1_MAX_HT_BM.GetF(FLinkEdges) ) { P1_MAX_HT_BM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.8;
			P1_MAX_HT_BM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_MAX_LAI_u170_exe() {
	float value;

	switch( P1_MAX_LAI.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAX_LAI.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)5);
			P1_MAX_LAI.Update( p, value );
		}
		P1_MAX_LAI.GrabMemory();
		if( P1_MAX_LAI.GetF(FLinkEdges) ) { P1_MAX_LAI.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)5);
			P1_MAX_LAI.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_MAX_PH_ABBM_u171_exe() {
	float value;

	switch( P1_MAX_PH_ABBM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAX_PH_ABBM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.75;
			P1_MAX_PH_ABBM.Update( p, value );
		}
		P1_MAX_PH_ABBM.GrabMemory();
		if( P1_MAX_PH_ABBM.GetF(FLinkEdges) ) { P1_MAX_PH_ABBM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.75;
			P1_MAX_PH_ABBM.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_NPH_ABBM_IC_u172_exe() {
	float value;

	switch( P1_NPH_ABBM_IC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_NPH_ABBM_IC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_NPH_ABBM_IC.Update( p, value );
		}
		P1_NPH_ABBM_IC.GrabMemory();
		if( P1_NPH_ABBM_IC.GetF(FLinkEdges) ) { P1_NPH_ABBM_IC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_NPH_ABBM_IC.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_NPH_AB_BEL_u173_exe() {
	float value;

	switch( P1_NPH_AB_BEL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_NPH_AB_BEL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.7;
			P1_NPH_AB_BEL.Update( p, value );
		}
		P1_NPH_AB_BEL.GrabMemory();
		if( P1_NPH_AB_BEL.GetF(FLinkEdges) ) { P1_NPH_AB_BEL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.7;
			P1_NPH_AB_BEL.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_NPH_MORT_u174_exe() {
	float value;

	switch( P1_NPH_MORT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_NPH_MORT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.00000053;
			P1_NPH_MORT.Update( p, value );
		}
		P1_NPH_MORT.GrabMemory();
		if( P1_NPH_MORT.GetF(FLinkEdges) ) { P1_NPH_MORT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.00000053;
			P1_NPH_MORT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_NPH_PR_H_u175_exe() {
	float value;

	switch( P1_NPH_PR_H.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_NPH_PR_H.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.85;
			P1_NPH_PR_H.Update( p, value );
		}
		P1_NPH_PR_H.GrabMemory();
		if( P1_NPH_PR_H.GetF(FLinkEdges) ) { P1_NPH_PR_H.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.85;
			P1_NPH_PR_H.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_NPP_u176_exe() {
	float value;

	switch( P1_NPP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_NPP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.25;
			P1_NPP.Update( p, value );
		}
		P1_NPP.GrabMemory();
		if( P1_NPP.GetF(FLinkEdges) ) { P1_NPP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.25;
			P1_NPP.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_PHB_C_REC_u177_exe() {
	float value;

	switch( P1_PHB_C_REC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHB_C_REC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_PHB_C_REC.Update( p, value );
		}
		P1_PHB_C_REC.GrabMemory();
		if( P1_PHB_C_REC.GetF(FLinkEdges) ) { P1_PHB_C_REC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_PHB_C_REC.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_PHB_EVGRN_u178_exe() {
	float value;

	switch( P1_PHB_EVGRN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHB_EVGRN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_PHB_EVGRN.Update( p, value );
		}
		P1_PHB_EVGRN.GrabMemory();
		if( P1_PHB_EVGRN.GetF(FLinkEdges) ) { P1_PHB_EVGRN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_PHB_EVGRN.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_PHB_L_RT_u179_exe() {
	float value;

	switch( P1_PHB_L_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHB_L_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_PHB_L_RT.Update( p, value );
		}
		P1_PHB_L_RT.GrabMemory();
		if( P1_PHB_L_RT.GetF(FLinkEdges) ) { P1_PHB_L_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_PHB_L_RT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_PHB_MORT_u180_exe() {
	float value;

	switch( P1_PHB_MORT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHB_MORT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_PHB_MORT.Update( p, value );
		}
		P1_PHB_MORT.GrabMemory();
		if( P1_PHB_MORT.GetF(FLinkEdges) ) { P1_PHB_MORT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_PHB_MORT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_PHB_PR_H_u181_exe() {
	float value;

	switch( P1_PHB_PR_H.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHB_PR_H.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.8;
			P1_PHB_PR_H.Update( p, value );
		}
		P1_PHB_PR_H.GrabMemory();
		if( P1_PHB_PR_H.GetF(FLinkEdges) ) { P1_PHB_PR_H.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.8;
			P1_PHB_PR_H.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_PH_TO_REP_u182_exe() {
	float value;

	switch( P1_PH_TO_REP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PH_TO_REP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.005;
			P1_PH_TO_REP.Update( p, value );
		}
		P1_PH_TO_REP.GrabMemory();
		if( P1_PH_TO_REP.GetF(FLinkEdges) ) { P1_PH_TO_REP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.005;
			P1_PH_TO_REP.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_PROP_LA_TO_B_u183_exe() {
	float value;

	switch( P1_PROP_LA_TO_B.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PROP_LA_TO_B.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)12);
			P1_PROP_LA_TO_B.Update( p, value );
		}
		P1_PROP_LA_TO_B.GrabMemory();
		if( P1_PROP_LA_TO_B.GetF(FLinkEdges) ) { P1_PROP_LA_TO_B.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)12);
			P1_PROP_LA_TO_B.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_P_DAY_u184_exe() {
	float value;

	switch( P1_P_DAY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_P_DAY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)191);
			P1_P_DAY.Update( p, value );
		}
		P1_P_DAY.GrabMemory();
		if( P1_P_DAY.GetF(FLinkEdges) ) { P1_P_DAY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)191);
			P1_P_DAY.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_P_RATIO_u185_exe() {
	float value;

	switch( P1_P_RATIO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_P_RATIO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_P_RATIO.Update( p, value );
		}
		P1_P_RATIO.GrabMemory();
		if( P1_P_RATIO.GetF(FLinkEdges) ) { P1_P_RATIO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_P_RATIO.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_P_WT_u186_exe() {
	float value;

	switch( P1_P_WT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_P_WT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.0009;
			P1_P_WT.Update( p, value );
		}
		P1_P_WT.GrabMemory();
		if( P1_P_WT.GetF(FLinkEdges) ) { P1_P_WT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.0009;
			P1_P_WT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_ROOT_DENS_u187_exe() {
	float value;

	switch( P1_ROOT_DENS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_ROOT_DENS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)11);
			P1_ROOT_DENS.Update( p, value );
		}
		P1_ROOT_DENS.GrabMemory();
		if( P1_ROOT_DENS.GetF(FLinkEdges) ) { P1_ROOT_DENS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)11);
			P1_ROOT_DENS.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_SPR_RATE_u188_exe() {
	float value;

	switch( P1_SPR_RATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SPR_RATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.01;
			P1_SPR_RATE.Update( p, value );
		}
		P1_SPR_RATE.GrabMemory();
		if( P1_SPR_RATE.GetF(FLinkEdges) ) { P1_SPR_RATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.01;
			P1_SPR_RATE.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_TEMPOPT_u189_exe() {
	float value;

	switch( P1_TEMPOPT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_TEMPOPT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)25);
			P1_TEMPOPT.Update( p, value );
		}
		P1_TEMPOPT.GrabMemory();
		if( P1_TEMPOPT.GetF(FLinkEdges) ) { P1_TEMPOPT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)25);
			P1_TEMPOPT.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_W_T_MAX_u190_exe() {
	float value;

	switch( P1_W_T_MAX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_W_T_MAX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.1;
			P1_W_T_MAX.Update( p, value );
		}
		P1_W_T_MAX.GrabMemory();
		if( P1_W_T_MAX.GetF(FLinkEdges) ) { P1_W_T_MAX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.1;
			P1_W_T_MAX.Update( value );
	  } break;
	}
	return 0;
}

int MACROPHYTES_module::P1_W_T_MIN_u191_exe() {
	float value;

	switch( P1_W_T_MIN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_W_T_MIN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.2;
			P1_W_T_MIN.Update( p, value );
		}
		P1_W_T_MIN.GrabMemory();
		if( P1_W_T_MIN.GetF(FLinkEdges) ) { P1_W_T_MIN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.2;
			P1_W_T_MIN.Update( value );
	  } break;
	}
	return 0;
}

MACROPHYTES_module* MACROPHYTES_module::fInstance = NULL;
MACROPHYTES_module* MACROPHYTES_module::kNullModel = (MACROPHYTES_module*)0x1;
int MACROPHYTES_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int MACROPHYTES_module::InitVars() {
	
	TIME.SSInit(this);
	PHBIO_MORT.SSInit(this);
	PHBIO_MORT.SetOrigin(&MAC_PH_BIOMAS);
	PHBIO_HARVEST.SSInit(this);
	PHBIO_HARVEST.SetOrigin(&MAC_PH_BIOMAS);
	NPHBIO_MORT.SSInit(this);
	NPHBIO_MORT.SetOrigin(&MAC_NPH_BIOMAS);
	NPHBIO_HARVEST.SSInit(this);
	NPHBIO_HARVEST.SetOrigin(&MAC_NPH_BIOMAS);
	MACH.SSInit(this);
	MACLAI.SSInit(this);
	AIR_TEMP_C.SSInit(this);
	HABITATMAP.SSInit(this);
	DAYJUL.SSInit(this);
	DAYLENGTH.SSInit(this);
	DIN_AVAILABLE.SSInit(this);
	ELEVATION.SSInit(this);
	SURFACE_WATER.SSInit(this);
	UW_DEPTH.SSInit(this);
	WATER_AVAIL.SSInit(this);
	ROOT_DEPTH.SSInit(this);
	PHBIO_NPP.SSInit(this);
	PHBIO_NPP.SetDestination(&MAC_PH_BIOMAS);
	BIO_TIME.SSInit(this);
	CF_AIR_TEMP.SSInit(this);
	CF_AIR_TEMP.SetDestination(&BIO_TIME);
	MAC_NPH_BIOMAS.SSInit(this);
	NPHBIO_PLANTING.SSInit(this);
	NPHBIO_PLANTING.SetDestination(&MAC_NPH_BIOMAS);
	TRANSDOWN.SSInit(this);
	TRANSDOWN.SetOrigin(&MAC_PH_BIOMAS);
	TRANSDOWN.SetDestination(&MAC_NPH_BIOMAS);
	TRANSUP.SSInit(this);
	TRANSUP.SetOrigin(&MAC_NPH_BIOMAS);
	TRANSUP.SetDestination(&MAC_PH_BIOMAS);
	MAC_PH_BIOMAS.SSInit(this);
	PHBIO_PLANT.SSInit(this);
	PHBIO_PLANT.SetDestination(&MAC_PH_BIOMAS);
	PH_MAX.SSInit(this);
	PH_IN.SSInit(this);
	PH_IN.SetDestination(&PH_MAX);
	PH_OUT.SSInit(this);
	PH_OUT.SetOrigin(&PH_MAX);
	TOT_NPP.SSInit(this);
	NPP_IN.SSInit(this);
	NPP_IN.SetDestination(&TOT_NPP);
	YIELD.SSInit(this);
	HARVEST.SSInit(this);
	HARVEST.SetDestination(&YIELD);
	INI_YIELD.SSInit(this);
	INI_YIELD.SetOrigin(&YIELD);
	DAY_LENGTH_PREV.SSInit(this);
	FALL_LITTER.SSInit(this);
	FALL_LITTER_CALC.SSInit(this);
	HARVEST_TIME.SSInit(this);
	IC_NPHBIO.SSInit(this);
	IC_PHBIO.SSInit(this);
	LIGHT_CF.SSInit(this);
	MAC_LAI_R.SSInit(this);
	MAC_PROD_CF.SSInit(this);
	MAX_BM.SSInit(this);
	MAX_NPH.SSInit(this);
	MAX_PH.SSInit(this);
	NPH_AB_BM.SSInit(this);
	NUTR_CF.SSInit(this);
	PHBIO_MORT_WATER.SSInit(this);
	PHBIO_NPP_CALC.SSInit(this);
	PH_TO_ABBM.SSInit(this);
	PLANTIME.SSInit(this);
	PLANTING.SSInit(this);
	PO4SD_CONCTOT.SSInit(this);
	REMOVAL_TIME.SSInit(this);
	ROOT_BM.SSInit(this);
	SPROUTING.SSInit(this);
	TEMP_CF.SSInit(this);
	TOTAL_BIOM.SSInit(this);
	TRANSDOWN_RT.SSInit(this);
	WATER_CF.SSInit(this);
	WAT_STRESS_HIGH.SSInit(this);
	WAT_STRESS_LOW.SSInit(this);
	P1_BIO_END.SSInit(this);
	P1_BIO_REPRO.SSInit(this);
	P1_BIO_START.SSInit(this);
	P1_DAYLENG_RQ.SSInit(this);
	P1_EST_HEIGHT.SSInit(this);
	P1_H_DAY.SSInit(this);
	P1_LIGHTSAT.SSInit(this);
	P1_MAC_KS_N.SSInit(this);
	P1_MAC_KS_P.SSInit(this);
	P1_MAX_AB_BM.SSInit(this);
	P1_MAX_DENS.SSInit(this);
	P1_MAX_HT_BM.SSInit(this);
	P1_MAX_LAI.SSInit(this);
	P1_MAX_PH_ABBM.SSInit(this);
	P1_NPH_ABBM_IC.SSInit(this);
	P1_NPH_AB_BEL.SSInit(this);
	P1_NPH_MORT.SSInit(this);
	P1_NPH_PR_H.SSInit(this);
	P1_NPP.SSInit(this);
	P1_PHB_C_REC.SSInit(this);
	P1_PHB_EVGRN.SSInit(this);
	P1_PHB_L_RT.SSInit(this);
	P1_PHB_MORT.SSInit(this);
	P1_PHB_PR_H.SSInit(this);
	P1_PH_TO_REP.SSInit(this);
	P1_PROP_LA_TO_B.SSInit(this);
	P1_P_DAY.SSInit(this);
	P1_P_RATIO.SSInit(this);
	P1_P_WT.SSInit(this);
	P1_ROOT_DENS.SSInit(this);
	P1_SPR_RATE.SSInit(this);
	P1_TEMPOPT.SSInit(this);
	P1_W_T_MAX.SSInit(this);
	P1_W_T_MIN.SSInit(this);
	SOLRADGR.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int MACROPHYTES_module::SetupEvents() {
	TExecuteCommand* u113 = (TExecuteCommand*) PHBIO_MORT.GetCommand("u113",TCommand::kUpdate,TCommand::kCode);
	u113->SetExecutable(&PHBIO_MORT_u113_exe_g);
	u113->Code() = "u113 <- ( ( ( ( HARVEST_TIME.Delay( dT() )*MAC_PH_BIOMAS )/dT() )+( FALL_LITTER*( ((float)1)-P1_PHB_C_REC ) ) )+( MAC_PH_BIOMAS*( PHBIO_MORT_WATER+P1_PHB_MORT ) ) )";
	if( PHBIO_MORT.GetF(FisClamped) ) { u113->AddDependency(MAC_PH_BIOMAS); }
	u113->AddDependency(HARVEST_TIME);
	u113->AddDependency(MAC_PH_BIOMAS);
	u113->AddDependency(FALL_LITTER);
	u113->AddDependency(HABITATMAP);
	u113->AddDependency(P1_PHB_C_REC);
	u113->AddDependency(PHBIO_MORT_WATER);
	u113->AddDependency(P1_PHB_MORT);
	u113->SetObjInfo(TCommand::kDepIndex, 2);
	TExecuteCommand* u114 = (TExecuteCommand*) PHBIO_HARVEST.GetCommand("u114",TCommand::kUpdate,TCommand::kCode);
	u114->SetExecutable(&PHBIO_HARVEST_u114_exe_g);
	u114->Code() = "u114 <- ( ( ( ( HARVEST_TIME+REMOVAL_TIME )*P1_PHB_PR_H )*MAC_PH_BIOMAS )/dT() )";
	if( PHBIO_HARVEST.GetF(FisClamped) ) { u114->AddDependency(MAC_PH_BIOMAS); }
	u114->AddDependency(HARVEST_TIME);
	u114->AddDependency(REMOVAL_TIME);
	u114->AddDependency(HABITATMAP);
	u114->AddDependency(P1_PHB_PR_H);
	u114->AddDependency(MAC_PH_BIOMAS);
	u114->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u106 = (TExecuteCommand*) NPHBIO_MORT.GetCommand("u106",TCommand::kUpdate,TCommand::kCode);
	u106->SetExecutable(&NPHBIO_MORT_u106_exe_g);
	u106->Code() = "u106 <- ( ( MAC_NPH_BIOMAS*P1_NPH_MORT )+( ( HARVEST_TIME.Delay( dT() )*MAC_NPH_BIOMAS )/dT() ) )";
	if( NPHBIO_MORT.GetF(FisClamped) ) { u106->AddDependency(MAC_NPH_BIOMAS); }
	u106->AddDependency(MAC_NPH_BIOMAS);
	u106->AddDependency(HABITATMAP);
	u106->AddDependency(P1_NPH_MORT);
	u106->AddDependency(HARVEST_TIME);
	u106->SetObjInfo(TCommand::kDepIndex, 2);
	TExecuteCommand* u108 = (TExecuteCommand*) NPHBIO_HARVEST.GetCommand("u108",TCommand::kUpdate,TCommand::kCode);
	u108->SetExecutable(&NPHBIO_HARVEST_u108_exe_g);
	u108->Code() = "u108 <- ( ( ( HARVEST_TIME*P1_NPH_PR_H )*MAC_NPH_BIOMAS )/dT() )";
	if( NPHBIO_HARVEST.GetF(FisClamped) ) { u108->AddDependency(MAC_NPH_BIOMAS); }
	u108->AddDependency(HARVEST_TIME);
	u108->AddDependency(HABITATMAP);
	u108->AddDependency(P1_NPH_PR_H);
	u108->AddDependency(MAC_NPH_BIOMAS);
	u108->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u133 = (TExecuteCommand*) MACH.GetCommand("u133",TCommand::kUpdate,TCommand::kCode);
	u133->SetExecutable(&MACH_u133_exe_g);
	u133->Code() = "u133 <- ( ( P1_MAX_HT_BM*TOTAL_BIOM )/MAX_BM )";
	u133->AddDependency(HABITATMAP);
	u133->AddDependency(P1_MAX_HT_BM);
	u133->AddDependency(TOTAL_BIOM);
	u133->AddDependency(MAX_BM);
	u133->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u134 = (TExecuteCommand*) MACLAI.GetCommand("u134",TCommand::kUpdate,TCommand::kCode);
	u134->SetExecutable(&MACLAI_u134_exe_g);
	u134->Code() = "u134 <- SL::Min(( MAC_PH_BIOMAS*P1_PROP_LA_TO_B ), P1_MAX_LAI)";
	u134->AddDependency(MAC_PH_BIOMAS);
	u134->AddDependency(HABITATMAP);
	u134->AddDependency(P1_PROP_LA_TO_B);
	u134->AddDependency(P1_MAX_LAI);
	u134->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* AIR_TEMP_C_import = (TImportCommand*) AIR_TEMP_C.GetCommand("AIR_TEMP_C_import",TCommand::kUndefined,TCommand::kImport);
	AIR_TEMP_C_import->Code() = "Import AIR_TEMP_C from GLOBALS_module";
	AIR_TEMP_C_import->AddDependency(AIR_TEMP_C);
	AIR_TEMP_C_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* HABITATMAP_import = (TImportCommand*) HABITATMAP.GetCommand("HABITATMAP_import",TCommand::kUndefined,TCommand::kImport);
	HABITATMAP_import->Code() = "Import HABITATMAP from GLOBALS_module";
	HABITATMAP_import->AddDependency(HABITATMAP);
	HABITATMAP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DAYJUL_import = (TImportCommand*) DAYJUL.GetCommand("DAYJUL_import",TCommand::kUndefined,TCommand::kImport);
	DAYJUL_import->Code() = "Import DAYJUL from GLOBALS_module";
	DAYJUL_import->AddDependency(DAYJUL);
	DAYJUL_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DAYLENGTH_import = (TImportCommand*) DAYLENGTH.GetCommand("DAYLENGTH_import",TCommand::kUndefined,TCommand::kImport);
	DAYLENGTH_import->Code() = "Import DAYLENGTH from GLOBALS_module";
	DAYLENGTH_import->AddDependency(DAYLENGTH);
	DAYLENGTH_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DIN_AVAILABLE_import = (TImportCommand*) DIN_AVAILABLE.GetCommand("DIN_AVAILABLE_import",TCommand::kUndefined,TCommand::kImport);
	DIN_AVAILABLE_import->Code() = "Import DIN_AVAILABLE from ZDIN_module";
	DIN_AVAILABLE_import->AddDependency(DIN_AVAILABLE);
	DIN_AVAILABLE_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ELEVATION_import = (TImportCommand*) ELEVATION.GetCommand("ELEVATION_import",TCommand::kUndefined,TCommand::kImport);
	ELEVATION_import->Code() = "Import ELEVATION from GLOBALS_module";
	ELEVATION_import->AddDependency(ELEVATION);
	ELEVATION_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SURFACE_WATER_import = (TImportCommand*) SURFACE_WATER.GetCommand("SURFACE_WATER_import",TCommand::kUndefined,TCommand::kImport);
	SURFACE_WATER_import->Code() = "Import SURFACE_WATER from HYDROLOGY_module";
	SURFACE_WATER_import->AddDependency(SURFACE_WATER);
	SURFACE_WATER_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* UW_DEPTH_import = (TImportCommand*) UW_DEPTH.GetCommand("UW_DEPTH_import",TCommand::kUndefined,TCommand::kImport);
	UW_DEPTH_import->Code() = "Import UW_DEPTH from HYDROLOGY_module";
	UW_DEPTH_import->AddDependency(UW_DEPTH);
	UW_DEPTH_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* WATER_AVAIL_import = (TImportCommand*) WATER_AVAIL.GetCommand("WATER_AVAIL_import",TCommand::kUndefined,TCommand::kImport);
	WATER_AVAIL_import->Code() = "Import WATER_AVAIL from HYDROLOGY_module";
	WATER_AVAIL_import->AddDependency(WATER_AVAIL);
	WATER_AVAIL_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u150 = (TExecuteCommand*) ROOT_DEPTH.GetCommand("u150",TCommand::kUpdate,TCommand::kCode);
	u150->SetExecutable(&ROOT_DEPTH_u150_exe_g);
	u150->Code() = "u150 <- SL::Min(( ELEVATION-((float)1) ), ( ROOT_BM/P1_ROOT_DENS ))";
	u150->AddDependency(ELEVATION);
	u150->AddDependency(ROOT_BM);
	u150->AddDependency(HABITATMAP);
	u150->AddDependency(P1_ROOT_DENS);
	u150->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u111 = (TExecuteCommand*) PHBIO_NPP.GetCommand("u111",TCommand::kUpdate,TCommand::kCode);
	u111->SetExecutable(&PHBIO_NPP_u111_exe_g);
	u111->Code() = "u111 <-  ( ( ( HARVEST_TIME >  ((float)0) ) ) ? ( ((float)0) ) : ( PHBIO_NPP_CALC ) ) ";
	u111->AddDependency(HARVEST_TIME);
	u111->AddDependency(PHBIO_NPP_CALC);
	u111->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I99 = (TExecuteCommand*) BIO_TIME.GetCommand("I99",TCommand::kIntegrate,TCommand::kCode);
	I99->SetExecutable(&BIO_TIME_I99_exe_g);
	I99->Code() = "I99 <- CF_AIR_TEMP";
	I99->AddDependency(CF_AIR_TEMP);
	I99->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i100 = (TExecuteCommand*) BIO_TIME.GetCommand("i100",TCommand::kInit,TCommand::kCode);
	i100->SetExecutable(&BIO_TIME_i100_exe_g);
	i100->Code() = "i100 <- ((float)0)";
	i100->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u101 = (TExecuteCommand*) CF_AIR_TEMP.GetCommand("u101",TCommand::kUpdate,TCommand::kCode);
	u101->SetExecutable(&CF_AIR_TEMP_u101_exe_g);
	u101->Code() = "u101 <-  ( ( ( PLANTIME == ((float)1) ) ) ? ( ( -BIO_TIME/dT() ) ) : (  ( ( ( AIR_TEMP_C >  ((float)5) ) ) ? ( AIR_TEMP_C ) : ( ((float)0) ) )  ) ) ";
	u101->AddDependency(PLANTIME);
	u101->AddDependency(BIO_TIME);
	u101->AddDependency(AIR_TEMP_C);
	u101->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I102 = (TExecuteCommand*) MAC_NPH_BIOMAS.GetCommand("I102",TCommand::kIntegrate,TCommand::kCode);
	I102->SetExecutable(&MAC_NPH_BIOMAS_I102_exe_g);
	I102->Code() = "I102 <- ( ( ( ( NPHBIO_PLANTING+TRANSDOWN )-NPHBIO_MORT )-TRANSUP )-NPHBIO_HARVEST )";
	I102->AddDependency(NPHBIO_PLANTING);
	I102->AddDependency(TRANSDOWN);
	I102->AddDependency(NPHBIO_MORT);
	I102->AddDependency(TRANSUP);
	I102->AddDependency(NPHBIO_HARVEST);
	I102->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i103 = (TExecuteCommand*) MAC_NPH_BIOMAS.GetCommand("i103",TCommand::kInit,TCommand::kCode);
	i103->SetExecutable(&MAC_NPH_BIOMAS_i103_exe_g);
	i103->Code() = "i103 <- IC_NPHBIO";
	i103->AddDependency(IC_NPHBIO);
	i103->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u104 = (TExecuteCommand*) NPHBIO_PLANTING.GetCommand("u104",TCommand::kUpdate,TCommand::kCode);
	u104->SetExecutable(&NPHBIO_PLANTING_u104_exe_g);
	u104->Code() = "u104 <- ( PLANTING*( ((float)1)-P1_P_RATIO ) )";
	u104->AddDependency(PLANTING);
	u104->AddDependency(HABITATMAP);
	u104->AddDependency(P1_P_RATIO);
	u104->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u105 = (TExecuteCommand*) TRANSDOWN.GetCommand("u105",TCommand::kUpdate,TCommand::kCode);
	u105->SetExecutable(&TRANSDOWN_u105_exe_g);
	u105->Code() = "u105 <-  ( ( ( HARVEST_TIME >  ((float)0) ) ) ? ( ((float)0) ) : ( ( ( TRANSDOWN_RT*( PHBIO_NPP+( P1_PH_TO_REP*MAC_PH_BIOMAS ) ) )+( P1_PHB_C_REC*FALL_LITTER ) ) ) ) ";
	if( TRANSDOWN.GetF(FisClamped) ) { u105->AddDependency(MAC_PH_BIOMAS); }
	u105->AddDependency(HARVEST_TIME);
	u105->AddDependency(TRANSDOWN_RT);
	u105->AddDependency(PHBIO_NPP);
	u105->AddDependency(HABITATMAP);
	u105->AddDependency(P1_PH_TO_REP);
	u105->AddDependency(MAC_PH_BIOMAS);
	u105->AddDependency(P1_PHB_C_REC);
	u105->AddDependency(FALL_LITTER);
	u105->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u107 = (TExecuteCommand*) TRANSUP.GetCommand("u107",TCommand::kUpdate,TCommand::kCode);
	u107->SetExecutable(&TRANSUP_u107_exe_g);
	u107->Code() = "u107 <- ( ( SPROUTING*P1_SPR_RATE )*MAC_NPH_BIOMAS )";
	if( TRANSUP.GetF(FisClamped) ) { u107->AddDependency(MAC_NPH_BIOMAS); }
	u107->AddDependency(SPROUTING);
	u107->AddDependency(HABITATMAP);
	u107->AddDependency(P1_SPR_RATE);
	u107->AddDependency(MAC_NPH_BIOMAS);
	u107->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I109 = (TExecuteCommand*) MAC_PH_BIOMAS.GetCommand("I109",TCommand::kIntegrate,TCommand::kCode);
	I109->SetExecutable(&MAC_PH_BIOMAS_I109_exe_g);
	I109->Code() = "I109 <- ( ( ( ( ( PHBIO_NPP+PHBIO_PLANT )+TRANSUP )-PHBIO_MORT )-PHBIO_HARVEST )-TRANSDOWN )";
	I109->AddDependency(PHBIO_NPP);
	I109->AddDependency(PHBIO_PLANT);
	I109->AddDependency(TRANSUP);
	I109->AddDependency(PHBIO_MORT);
	I109->AddDependency(PHBIO_HARVEST);
	I109->AddDependency(TRANSDOWN);
	I109->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i110 = (TExecuteCommand*) MAC_PH_BIOMAS.GetCommand("i110",TCommand::kInit,TCommand::kCode);
	i110->SetExecutable(&MAC_PH_BIOMAS_i110_exe_g);
	i110->Code() = "i110 <- IC_PHBIO";
	i110->AddDependency(IC_PHBIO);
	i110->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u112 = (TExecuteCommand*) PHBIO_PLANT.GetCommand("u112",TCommand::kUpdate,TCommand::kCode);
	u112->SetExecutable(&PHBIO_PLANT_u112_exe_g);
	u112->Code() = "u112 <- ( PLANTING*P1_P_RATIO )";
	u112->AddDependency(PLANTING);
	u112->AddDependency(HABITATMAP);
	u112->AddDependency(P1_P_RATIO);
	u112->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I115 = (TExecuteCommand*) PH_MAX.GetCommand("I115",TCommand::kIntegrate,TCommand::kCode);
	I115->SetExecutable(&PH_MAX_I115_exe_g);
	I115->Code() = "I115 <- ( PH_IN-PH_OUT )";
	I115->AddDependency(PH_IN);
	I115->AddDependency(PH_OUT);
	I115->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i116 = (TExecuteCommand*) PH_MAX.GetCommand("i116",TCommand::kInit,TCommand::kCode);
	i116->SetExecutable(&PH_MAX_i116_exe_g);
	i116->Code() = "i116 <- ((float)0)";
	i116->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u117 = (TExecuteCommand*) PH_IN.GetCommand("u117",TCommand::kUpdate,TCommand::kCode);
	u117->SetExecutable(&PH_IN_u117_exe_g);
	u117->Code() = "u117 <-  ( ( ( MAC_PH_BIOMAS >  PH_MAX ) ) ? ( ( MAC_PH_BIOMAS/dT() ) ) : ( ((float)0) ) ) ";
	u117->AddDependency(MAC_PH_BIOMAS);
	u117->AddDependency(PH_MAX);
	u117->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u118 = (TExecuteCommand*) PH_OUT.GetCommand("u118",TCommand::kUpdate,TCommand::kCode);
	u118->SetExecutable(&PH_OUT_u118_exe_g);
	u118->Code() = "u118 <-  ( ( ( ( MAC_PH_BIOMAS >  PH_MAX ) || ( PLANTIME == ((float)1) ) ) ) ? ( ( PH_MAX/dT() ) ) : ( ((float)0) ) ) ";
	if( PH_OUT.GetF(FisClamped) ) { u118->AddDependency(PH_MAX); }
	u118->AddDependency(MAC_PH_BIOMAS);
	u118->AddDependency(PH_MAX);
	u118->AddDependency(PLANTIME);
	u118->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I119 = (TExecuteCommand*) TOT_NPP.GetCommand("I119",TCommand::kIntegrate,TCommand::kCode);
	I119->SetExecutable(&TOT_NPP_I119_exe_g);
	I119->Code() = "I119 <- NPP_IN";
	I119->AddDependency(NPP_IN);
	I119->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i120 = (TExecuteCommand*) TOT_NPP.GetCommand("i120",TCommand::kInit,TCommand::kCode);
	i120->SetExecutable(&TOT_NPP_i120_exe_g);
	i120->Code() = "i120 <- ((float)0)";
	i120->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u121 = (TExecuteCommand*) NPP_IN.GetCommand("u121",TCommand::kUpdate,TCommand::kCode);
	u121->SetExecutable(&NPP_IN_u121_exe_g);
	u121->Code() = "u121 <-  ( ( ( HABITATMAP == ((float)2) ) ) ? ( PHBIO_NPP ) : ( ((float)0) ) ) ";
	u121->AddDependency(HABITATMAP);
	u121->AddDependency(PHBIO_NPP);
	u121->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I122 = (TExecuteCommand*) YIELD.GetCommand("I122",TCommand::kIntegrate,TCommand::kCode);
	I122->SetExecutable(&YIELD_I122_exe_g);
	I122->Code() = "I122 <- ( HARVEST-INI_YIELD )";
	I122->AddDependency(HARVEST);
	I122->AddDependency(INI_YIELD);
	I122->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i123 = (TExecuteCommand*) YIELD.GetCommand("i123",TCommand::kInit,TCommand::kCode);
	i123->SetExecutable(&YIELD_i123_exe_g);
	i123->Code() = "i123 <- ((float)0)";
	i123->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u124 = (TExecuteCommand*) HARVEST.GetCommand("u124",TCommand::kUpdate,TCommand::kCode);
	u124->SetExecutable(&HARVEST_u124_exe_g);
	u124->Code() = "u124 <- ( PHBIO_HARVEST+NPHBIO_HARVEST )";
	u124->AddDependency(PHBIO_HARVEST);
	u124->AddDependency(NPHBIO_HARVEST);
	u124->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u125 = (TExecuteCommand*) INI_YIELD.GetCommand("u125",TCommand::kUpdate,TCommand::kCode);
	u125->SetExecutable(&INI_YIELD_u125_exe_g);
	u125->Code() = "u125 <-  ( ( ( DAYJUL == ((float)1) ) ) ? ( ( ( YIELD/dT() )*((float)0) ) ) : ( ((float)0) ) ) ";
	if( INI_YIELD.GetF(FisClamped) ) { u125->AddDependency(YIELD); }
	u125->AddDependency(DAYJUL);
	u125->AddDependency(YIELD);
	u125->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u126 = (TExecuteCommand*) DAY_LENGTH_PREV.GetCommand("u126",TCommand::kUpdate,TCommand::kCode);
	u126->SetExecutable(&DAY_LENGTH_PREV_u126_exe_g);
	u126->Code() = "u126 <- DAYLENGTH.Delay( ((float)1) )";
	u126->AddDependency(DAYLENGTH);
	u126->SetObjInfo(TCommand::kDepIndex, 2);
	TExecuteCommand* u127 = (TExecuteCommand*) FALL_LITTER.GetCommand("u127",TCommand::kUpdate,TCommand::kCode);
	u127->SetExecutable(&FALL_LITTER_u127_exe_g);
	u127->Code() = "u127 <- SL::Min(FALL_LITTER_CALC, SL::Max(((float)0), ( MAC_PH_BIOMAS-( ( P1_PHB_EVGRN*PH_MAX )/( ((float)1)+P1_PHB_EVGRN ) ) )))";
	u127->AddDependency(FALL_LITTER_CALC);
	u127->AddDependency(MAC_PH_BIOMAS);
	u127->AddDependency(HABITATMAP);
	u127->AddDependency(P1_PHB_EVGRN);
	u127->AddDependency(PH_MAX);
	u127->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u128 = (TExecuteCommand*) FALL_LITTER_CALC.GetCommand("u128",TCommand::kUpdate,TCommand::kCode);
	u128->SetExecutable(&FALL_LITTER_CALC_u128_exe_g);
	u128->Code() = "u128 <-  ( ( ( ( DAYLENGTH >  P1_DAYLENG_RQ ) || ( DAYLENGTH >= DAY_LENGTH_PREV ) ) ) ? ( ((float)0) ) : (  ( ( ( MAC_PH_BIOMAS <  ( 0.01*( ((float)1)-P1_PHB_EVGRN ) ) ) ) ? ( ( ( ( ((float)1)-P1_PHB_EVGRN )*MAC_PH_BIOMAS )/dT() ) ) : ( ( ( ((float)1)-P1_PHB_EVGRN )*pow((double)( ( PH_MAX*P1_PHB_L_RT )/MAC_PH_BIOMAS ),(double)((float)3) ) ) ) )  ) ) ";
	u128->AddDependency(DAYLENGTH);
	u128->AddDependency(HABITATMAP);
	u128->AddDependency(P1_DAYLENG_RQ);
	u128->AddDependency(DAY_LENGTH_PREV);
	u128->AddDependency(MAC_PH_BIOMAS);
	u128->AddDependency(P1_PHB_EVGRN);
	u128->AddDependency(PH_MAX);
	u128->AddDependency(P1_PHB_L_RT);
	u128->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u129 = (TExecuteCommand*) HARVEST_TIME.GetCommand("u129",TCommand::kUpdate,TCommand::kCode);
	u129->SetExecutable(&HARVEST_TIME_u129_exe_g);
	u129->Code() = "u129 <-  ( ( ( ( DAYJUL >  P1_H_DAY ) && ( DAYJUL <  ( P1_H_DAY+((float)3) ) ) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ";
	u129->AddDependency(DAYJUL);
	u129->AddDependency(HABITATMAP);
	u129->AddDependency(P1_H_DAY);
	u129->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u130 = (TExecuteCommand*) IC_NPHBIO.GetCommand("u130",TCommand::kUpdate,TCommand::kCode);
	u130->SetExecutable(&IC_NPHBIO_u130_exe_g);
	u130->Code() = "u130 <- ( ( P1_NPH_ABBM_IC*( P1_NPH_AB_BEL+((float)1) ) )/P1_NPH_AB_BEL )";
	u130->AddDependency(HABITATMAP);
	u130->AddDependency(P1_NPH_ABBM_IC);
	u130->AddDependency(P1_NPH_AB_BEL);
	u130->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u131 = (TExecuteCommand*) IC_PHBIO.GetCommand("u131",TCommand::kUpdate,TCommand::kCode);
	u131->SetExecutable(&IC_PHBIO_u131_exe_g);
	u131->Code() = "u131 <- ( ( ( P1_PHB_EVGRN*P1_NPH_ABBM_IC )*P1_MAX_PH_ABBM )/( ((float)1)-P1_MAX_PH_ABBM ) )";
	u131->AddDependency(HABITATMAP);
	u131->AddDependency(P1_PHB_EVGRN);
	u131->AddDependency(P1_NPH_ABBM_IC);
	u131->AddDependency(P1_MAX_PH_ABBM);
	u131->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u132 = (TExecuteCommand*) LIGHT_CF.GetCommand("u132",TCommand::kUpdate,TCommand::kCode);
	u132->SetExecutable(&LIGHT_CF_u132_exe_g);
	u132->Code() = "u132 <- ( ( SOLRADGR/P1_LIGHTSAT )*SL::Exp(( ((float)1)-( SOLRADGR/P1_LIGHTSAT ) )) )";
	u132->AddDependency(SOLRADGR);
	u132->AddDependency(HABITATMAP);
	u132->AddDependency(P1_LIGHTSAT);
	u132->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u135 = (TExecuteCommand*) MAC_LAI_R.GetCommand("u135",TCommand::kUpdate,TCommand::kCode);
	u135->SetExecutable(&MAC_LAI_R_u135_exe_g);
	u135->Code() = "u135 <- ( MACLAI/P1_MAX_LAI )";
	u135->AddDependency(MACLAI);
	u135->AddDependency(HABITATMAP);
	u135->AddDependency(P1_MAX_LAI);
	u135->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u136 = (TExecuteCommand*) MAC_PROD_CF.GetCommand("u136",TCommand::kUpdate,TCommand::kCode);
	u136->SetExecutable(&MAC_PROD_CF_u136_exe_g);
	u136->Code() = "u136 <- ( ( SL::Min(LIGHT_CF, TEMP_CF)*WATER_CF )*NUTR_CF )";
	u136->AddDependency(LIGHT_CF);
	u136->AddDependency(TEMP_CF);
	u136->AddDependency(WATER_CF);
	u136->AddDependency(NUTR_CF);
	u136->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u137 = (TExecuteCommand*) MAX_BM.GetCommand("u137",TCommand::kUpdate,TCommand::kCode);
	u137->SetExecutable(&MAX_BM_u137_exe_g);
	u137->Code() = "u137 <- ( MAX_NPH+MAX_PH )";
	u137->AddDependency(MAX_NPH);
	u137->AddDependency(MAX_PH);
	u137->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u138 = (TExecuteCommand*) MAX_NPH.GetCommand("u138",TCommand::kUpdate,TCommand::kCode);
	u138->SetExecutable(&MAX_NPH_u138_exe_g);
	u138->Code() = "u138 <- ( ( P1_MAX_AB_BM-MAX_PH )*( ((float)1)+( ((float)1)/P1_NPH_AB_BEL ) ) )";
	u138->AddDependency(HABITATMAP);
	u138->AddDependency(P1_MAX_AB_BM);
	u138->AddDependency(MAX_PH);
	u138->AddDependency(P1_NPH_AB_BEL);
	u138->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u139 = (TExecuteCommand*) MAX_PH.GetCommand("u139",TCommand::kUpdate,TCommand::kCode);
	u139->SetExecutable(&MAX_PH_u139_exe_g);
	u139->Code() = "u139 <- ( P1_MAX_AB_BM*P1_MAX_PH_ABBM )";
	u139->AddDependency(HABITATMAP);
	u139->AddDependency(P1_MAX_AB_BM);
	u139->AddDependency(P1_MAX_PH_ABBM);
	u139->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u140 = (TExecuteCommand*) NPH_AB_BM.GetCommand("u140",TCommand::kUpdate,TCommand::kCode);
	u140->SetExecutable(&NPH_AB_BM_u140_exe_g);
	u140->Code() = "u140 <- ( P1_NPH_AB_BEL*ROOT_BM )";
	u140->AddDependency(HABITATMAP);
	u140->AddDependency(P1_NPH_AB_BEL);
	u140->AddDependency(ROOT_BM);
	u140->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u141 = (TExecuteCommand*) NUTR_CF.GetCommand("u141",TCommand::kUpdate,TCommand::kCode);
	u141->SetExecutable(&NUTR_CF_u141_exe_g);
	u141->Code() = "u141 <- SL::Min(( DIN_AVAILABLE/( DIN_AVAILABLE+P1_MAC_KS_N ) ), ( PO4SD_CONCTOT/( PO4SD_CONCTOT+P1_MAC_KS_P ) ))";
	u141->AddDependency(DIN_AVAILABLE);
	u141->AddDependency(HABITATMAP);
	u141->AddDependency(P1_MAC_KS_N);
	u141->AddDependency(PO4SD_CONCTOT);
	u141->AddDependency(P1_MAC_KS_P);
	u141->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u142 = (TExecuteCommand*) PHBIO_MORT_WATER.GetCommand("u142",TCommand::kUpdate,TCommand::kCode);
	u142->SetExecutable(&PHBIO_MORT_WATER_u142_exe_g);
	u142->Code() = "u142 <- ( 0.1*SL::Max(((float)0), ( ((float)1)-WATER_CF )) )";
	u142->AddDependency(WATER_CF);
	u142->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u143 = (TExecuteCommand*) PHBIO_NPP_CALC.GetCommand("u143",TCommand::kUpdate,TCommand::kCode);
	u143->SetExecutable(&PHBIO_NPP_CALC_u143_exe_g);
	u143->Code() = "u143 <-  ( ( ( MAC_PH_BIOMAS <  MAX_PH ) ) ? ( ( ( ( MAC_PROD_CF*P1_NPP )*MAC_PH_BIOMAS )*( ((float)1)-( MAC_PH_BIOMAS/MAX_PH ) ) ) ) : ( ((float)0) ) ) ";
	u143->AddDependency(MAC_PH_BIOMAS);
	u143->AddDependency(MAX_PH);
	u143->AddDependency(MAC_PROD_CF);
	u143->AddDependency(HABITATMAP);
	u143->AddDependency(P1_NPP);
	u143->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u144 = (TExecuteCommand*) PH_TO_ABBM.GetCommand("u144",TCommand::kUpdate,TCommand::kCode);
	u144->SetExecutable(&PH_TO_ABBM_u144_exe_g);
	u144->Code() = "u144 <-  ( ( ( NPH_AB_BM == ((float)0) ) ) ? ( ((float)0) ) : ( ( MAC_PH_BIOMAS/( MAC_PH_BIOMAS+NPH_AB_BM ) ) ) ) ";
	u144->AddDependency(NPH_AB_BM);
	u144->AddDependency(MAC_PH_BIOMAS);
	u144->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u145 = (TExecuteCommand*) PLANTIME.GetCommand("u145",TCommand::kUpdate,TCommand::kCode);
	u145->SetExecutable(&PLANTIME_u145_exe_g);
	u145->Code() = "u145 <-  ( ( ( DAYJUL == P1_P_DAY ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ";
	u145->AddDependency(DAYJUL);
	u145->AddDependency(HABITATMAP);
	u145->AddDependency(P1_P_DAY);
	u145->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u146 = (TExecuteCommand*) PLANTING.GetCommand("u146",TCommand::kUpdate,TCommand::kCode);
	u146->SetExecutable(&PLANTING_u146_exe_g);
	u146->Code() = "u146 <- ( ( PLANTIME*P1_MAX_DENS )*P1_P_WT )";
	u146->AddDependency(PLANTIME);
	u146->AddDependency(HABITATMAP);
	u146->AddDependency(P1_MAX_DENS);
	u146->AddDependency(P1_P_WT);
	u146->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u147 = (TExecuteCommand*) PO4SD_CONCTOT.GetCommand("u147",TCommand::kUpdate,TCommand::kCode);
	u147->SetExecutable(&PO4SD_CONCTOT_u147_exe_g);
	u147->Code() = "u147 <- 1000";
	u147->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u148 = (TExecuteCommand*) REMOVAL_TIME.GetCommand("u148",TCommand::kUpdate,TCommand::kCode);
	u148->SetExecutable(&REMOVAL_TIME_u148_exe_g);
	u148->Code() = "u148 <-  ( ( ( ( MACH*P1_PHB_PR_H ) >  P1_EST_HEIGHT ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ";
	u148->AddDependency(MACH);
	u148->AddDependency(HABITATMAP);
	u148->AddDependency(P1_PHB_PR_H);
	u148->AddDependency(P1_EST_HEIGHT);
	u148->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u149 = (TExecuteCommand*) ROOT_BM.GetCommand("u149",TCommand::kUpdate,TCommand::kCode);
	u149->SetExecutable(&ROOT_BM_u149_exe_g);
	u149->Code() = "u149 <- ( MAC_NPH_BIOMAS/( P1_NPH_AB_BEL+((float)1) ) )";
	u149->AddDependency(MAC_NPH_BIOMAS);
	u149->AddDependency(HABITATMAP);
	u149->AddDependency(P1_NPH_AB_BEL);
	u149->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u151 = (TExecuteCommand*) SPROUTING.GetCommand("u151",TCommand::kUpdate,TCommand::kCode);
	u151->SetExecutable(&SPROUTING_u151_exe_g);
	u151->Code() = "u151 <-  ( ( ( ( PH_TO_ABBM <  P1_MAX_PH_ABBM ) && ( ( BIO_TIME >  P1_BIO_START ) && ( BIO_TIME <  P1_BIO_END ) ) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ";
	u151->AddDependency(PH_TO_ABBM);
	u151->AddDependency(HABITATMAP);
	u151->AddDependency(P1_MAX_PH_ABBM);
	u151->AddDependency(BIO_TIME);
	u151->AddDependency(P1_BIO_START);
	u151->AddDependency(P1_BIO_END);
	u151->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u152 = (TExecuteCommand*) TEMP_CF.GetCommand("u152",TCommand::kUpdate,TCommand::kCode);
	u152->SetExecutable(&TEMP_CF_u152_exe_g);
	u152->Code() = "u152 <- ( SL::Exp(( 0.20*( AIR_TEMP_C-P1_TEMPOPT ) ))*pow((double)( ( ((float)40)-AIR_TEMP_C )/( ((float)40)-P1_TEMPOPT ) ),(double)( 0.20*( ((float)40)-P1_TEMPOPT ) ) ) )";
	u152->AddDependency(AIR_TEMP_C);
	u152->AddDependency(HABITATMAP);
	u152->AddDependency(P1_TEMPOPT);
	u152->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u153 = (TExecuteCommand*) TOTAL_BIOM.GetCommand("u153",TCommand::kUpdate,TCommand::kCode);
	u153->SetExecutable(&TOTAL_BIOM_u153_exe_g);
	u153->Code() = "u153 <- ( MAC_PH_BIOMAS+MAC_NPH_BIOMAS )";
	u153->AddDependency(MAC_PH_BIOMAS);
	u153->AddDependency(MAC_NPH_BIOMAS);
	u153->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u154 = (TExecuteCommand*) TRANSDOWN_RT.GetCommand("u154",TCommand::kUpdate,TCommand::kCode);
	u154->SetExecutable(&TRANSDOWN_RT_u154_exe_g);
	u154->Code() = "u154 <-  ( ( ( BIO_TIME >  ( P1_BIO_REPRO+((float)1) ) ) ) ? ( ( ((float)1)-( ((float)1)/pow((double)( BIO_TIME-P1_BIO_REPRO ),(double)0.5 ) ) ) ) : (  ( ( ( PH_TO_ABBM <  P1_MAX_PH_ABBM ) ) ? ( ((float)0) ) : ( pow((double)SL::Cos(( ( ( P1_MAX_PH_ABBM/PH_TO_ABBM )*3.141590 )/2. )),(double)0.1 ) ) )  ) ) ";
	u154->AddDependency(BIO_TIME);
	u154->AddDependency(HABITATMAP);
	u154->AddDependency(P1_BIO_REPRO);
	u154->AddDependency(PH_TO_ABBM);
	u154->AddDependency(P1_MAX_PH_ABBM);
	u154->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u155 = (TExecuteCommand*) WATER_CF.GetCommand("u155",TCommand::kUpdate,TCommand::kCode);
	u155->SetExecutable(&WATER_CF_u155_exe_g);
	u155->Code() = "u155 <- SL::Min(WAT_STRESS_HIGH, WAT_STRESS_LOW)";
	u155->AddDependency(WAT_STRESS_HIGH);
	u155->AddDependency(WAT_STRESS_LOW);
	u155->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u156 = (TExecuteCommand*) WAT_STRESS_HIGH.GetCommand("u156",TCommand::kUpdate,TCommand::kCode);
	u156->SetExecutable(&WAT_STRESS_HIGH_u156_exe_g);
	u156->Code() = "u156 <-  ( ( ( ( P1_W_T_MAX <  ((float)0) ) && ( SURFACE_WATER >  -P1_W_T_MAX ) ) ) ? ( SL::Max(((float)0), ( ((float)1)/( ((float)1)+SL::Exp(( SURFACE_WATER+P1_W_T_MAX )) ) )) ) : (  ( ( ( ( P1_W_T_MAX >  ((float)0) ) && ( ROOT_DEPTH >  ((float)0) ) ) ) ? ( SL::Min(((float)1), ( ( UW_DEPTH/ROOT_DEPTH )/P1_W_T_MAX )) ) : ( ((float)1) ) )  ) ) ";
	u156->AddDependency(HABITATMAP);
	u156->AddDependency(P1_W_T_MAX);
	u156->AddDependency(SURFACE_WATER);
	u156->AddDependency(ROOT_DEPTH);
	u156->AddDependency(UW_DEPTH);
	u156->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u157 = (TExecuteCommand*) WAT_STRESS_LOW.GetCommand("u157",TCommand::kUpdate,TCommand::kCode);
	u157->SetExecutable(&WAT_STRESS_LOW_u157_exe_g);
	u157->Code() = "u157 <- pow((double)SL::Sin(( ( WATER_AVAIL*3.141590 )/2 )),(double)P1_W_T_MIN )";
	u157->AddDependency(WATER_AVAIL);
	u157->AddDependency(HABITATMAP);
	u157->AddDependency(P1_W_T_MIN);
	u157->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u158 = (TExecuteCommand*) P1_BIO_END.GetCommand("u158",TCommand::kUpdate,TCommand::kCode);
	u158->SetExecutable(&P1_BIO_END_u158_exe_g);
	u158->Code() = "u158 <- ((float)570)";
	u158->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u159 = (TExecuteCommand*) P1_BIO_REPRO.GetCommand("u159",TCommand::kUpdate,TCommand::kCode);
	u159->SetExecutable(&P1_BIO_REPRO_u159_exe_g);
	u159->Code() = "u159 <- ((float)1700)";
	u159->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u160 = (TExecuteCommand*) P1_BIO_START.GetCommand("u160",TCommand::kUpdate,TCommand::kCode);
	u160->SetExecutable(&P1_BIO_START_u160_exe_g);
	u160->Code() = "u160 <- ((float)500)";
	u160->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u161 = (TExecuteCommand*) P1_DAYLENG_RQ.GetCommand("u161",TCommand::kUpdate,TCommand::kCode);
	u161->SetExecutable(&P1_DAYLENG_RQ_u161_exe_g);
	u161->Code() = "u161 <- ((float)13)";
	u161->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u162 = (TExecuteCommand*) P1_EST_HEIGHT.GetCommand("u162",TCommand::kUpdate,TCommand::kCode);
	u162->SetExecutable(&P1_EST_HEIGHT_u162_exe_g);
	u162->Code() = "u162 <- ((float)500)";
	u162->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u163 = (TExecuteCommand*) P1_H_DAY.GetCommand("u163",TCommand::kUpdate,TCommand::kCode);
	u163->SetExecutable(&P1_H_DAY_u163_exe_g);
	u163->Code() = "u163 <- ((float)319)";
	u163->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u164 = (TExecuteCommand*) P1_LIGHTSAT.GetCommand("u164",TCommand::kUpdate,TCommand::kCode);
	u164->SetExecutable(&P1_LIGHTSAT_u164_exe_g);
	u164->Code() = "u164 <- ((float)600)";
	u164->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u165 = (TExecuteCommand*) P1_MAC_KS_N.GetCommand("u165",TCommand::kUpdate,TCommand::kCode);
	u165->SetExecutable(&P1_MAC_KS_N_u165_exe_g);
	u165->Code() = "u165 <- 0.00265";
	u165->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u166 = (TExecuteCommand*) P1_MAC_KS_P.GetCommand("u166",TCommand::kUpdate,TCommand::kCode);
	u166->SetExecutable(&P1_MAC_KS_P_u166_exe_g);
	u166->Code() = "u166 <- 0.000037";
	u166->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u167 = (TExecuteCommand*) P1_MAX_AB_BM.GetCommand("u167",TCommand::kUpdate,TCommand::kCode);
	u167->SetExecutable(&P1_MAX_AB_BM_u167_exe_g);
	u167->Code() = "u167 <- 0.6";
	u167->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u168 = (TExecuteCommand*) P1_MAX_DENS.GetCommand("u168",TCommand::kUpdate,TCommand::kCode);
	u168->SetExecutable(&P1_MAX_DENS_u168_exe_g);
	u168->Code() = "u168 <- ((float)40)";
	u168->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u169 = (TExecuteCommand*) P1_MAX_HT_BM.GetCommand("u169",TCommand::kUpdate,TCommand::kCode);
	u169->SetExecutable(&P1_MAX_HT_BM_u169_exe_g);
	u169->Code() = "u169 <- 0.8";
	u169->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u170 = (TExecuteCommand*) P1_MAX_LAI.GetCommand("u170",TCommand::kUpdate,TCommand::kCode);
	u170->SetExecutable(&P1_MAX_LAI_u170_exe_g);
	u170->Code() = "u170 <- ((float)5)";
	u170->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u171 = (TExecuteCommand*) P1_MAX_PH_ABBM.GetCommand("u171",TCommand::kUpdate,TCommand::kCode);
	u171->SetExecutable(&P1_MAX_PH_ABBM_u171_exe_g);
	u171->Code() = "u171 <- 0.75";
	u171->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u172 = (TExecuteCommand*) P1_NPH_ABBM_IC.GetCommand("u172",TCommand::kUpdate,TCommand::kCode);
	u172->SetExecutable(&P1_NPH_ABBM_IC_u172_exe_g);
	u172->Code() = "u172 <- ((float)0)";
	u172->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u173 = (TExecuteCommand*) P1_NPH_AB_BEL.GetCommand("u173",TCommand::kUpdate,TCommand::kCode);
	u173->SetExecutable(&P1_NPH_AB_BEL_u173_exe_g);
	u173->Code() = "u173 <- 0.7";
	u173->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u174 = (TExecuteCommand*) P1_NPH_MORT.GetCommand("u174",TCommand::kUpdate,TCommand::kCode);
	u174->SetExecutable(&P1_NPH_MORT_u174_exe_g);
	u174->Code() = "u174 <- 0.00000053";
	u174->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u175 = (TExecuteCommand*) P1_NPH_PR_H.GetCommand("u175",TCommand::kUpdate,TCommand::kCode);
	u175->SetExecutable(&P1_NPH_PR_H_u175_exe_g);
	u175->Code() = "u175 <- 0.85";
	u175->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u176 = (TExecuteCommand*) P1_NPP.GetCommand("u176",TCommand::kUpdate,TCommand::kCode);
	u176->SetExecutable(&P1_NPP_u176_exe_g);
	u176->Code() = "u176 <- 0.25";
	u176->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u177 = (TExecuteCommand*) P1_PHB_C_REC.GetCommand("u177",TCommand::kUpdate,TCommand::kCode);
	u177->SetExecutable(&P1_PHB_C_REC_u177_exe_g);
	u177->Code() = "u177 <- ((float)0)";
	u177->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u178 = (TExecuteCommand*) P1_PHB_EVGRN.GetCommand("u178",TCommand::kUpdate,TCommand::kCode);
	u178->SetExecutable(&P1_PHB_EVGRN_u178_exe_g);
	u178->Code() = "u178 <- ((float)0)";
	u178->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u179 = (TExecuteCommand*) P1_PHB_L_RT.GetCommand("u179",TCommand::kUpdate,TCommand::kCode);
	u179->SetExecutable(&P1_PHB_L_RT_u179_exe_g);
	u179->Code() = "u179 <- ((float)0)";
	u179->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u180 = (TExecuteCommand*) P1_PHB_MORT.GetCommand("u180",TCommand::kUpdate,TCommand::kCode);
	u180->SetExecutable(&P1_PHB_MORT_u180_exe_g);
	u180->Code() = "u180 <- ((float)0)";
	u180->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u181 = (TExecuteCommand*) P1_PHB_PR_H.GetCommand("u181",TCommand::kUpdate,TCommand::kCode);
	u181->SetExecutable(&P1_PHB_PR_H_u181_exe_g);
	u181->Code() = "u181 <- 0.8";
	u181->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u182 = (TExecuteCommand*) P1_PH_TO_REP.GetCommand("u182",TCommand::kUpdate,TCommand::kCode);
	u182->SetExecutable(&P1_PH_TO_REP_u182_exe_g);
	u182->Code() = "u182 <- 0.005";
	u182->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u183 = (TExecuteCommand*) P1_PROP_LA_TO_B.GetCommand("u183",TCommand::kUpdate,TCommand::kCode);
	u183->SetExecutable(&P1_PROP_LA_TO_B_u183_exe_g);
	u183->Code() = "u183 <- ((float)12)";
	u183->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u184 = (TExecuteCommand*) P1_P_DAY.GetCommand("u184",TCommand::kUpdate,TCommand::kCode);
	u184->SetExecutable(&P1_P_DAY_u184_exe_g);
	u184->Code() = "u184 <- ((float)191)";
	u184->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u185 = (TExecuteCommand*) P1_P_RATIO.GetCommand("u185",TCommand::kUpdate,TCommand::kCode);
	u185->SetExecutable(&P1_P_RATIO_u185_exe_g);
	u185->Code() = "u185 <- ((float)0)";
	u185->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u186 = (TExecuteCommand*) P1_P_WT.GetCommand("u186",TCommand::kUpdate,TCommand::kCode);
	u186->SetExecutable(&P1_P_WT_u186_exe_g);
	u186->Code() = "u186 <- 0.0009";
	u186->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u187 = (TExecuteCommand*) P1_ROOT_DENS.GetCommand("u187",TCommand::kUpdate,TCommand::kCode);
	u187->SetExecutable(&P1_ROOT_DENS_u187_exe_g);
	u187->Code() = "u187 <- ((float)11)";
	u187->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u188 = (TExecuteCommand*) P1_SPR_RATE.GetCommand("u188",TCommand::kUpdate,TCommand::kCode);
	u188->SetExecutable(&P1_SPR_RATE_u188_exe_g);
	u188->Code() = "u188 <- 0.01";
	u188->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u189 = (TExecuteCommand*) P1_TEMPOPT.GetCommand("u189",TCommand::kUpdate,TCommand::kCode);
	u189->SetExecutable(&P1_TEMPOPT_u189_exe_g);
	u189->Code() = "u189 <- ((float)25)";
	u189->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u190 = (TExecuteCommand*) P1_W_T_MAX.GetCommand("u190",TCommand::kUpdate,TCommand::kCode);
	u190->SetExecutable(&P1_W_T_MAX_u190_exe_g);
	u190->Code() = "u190 <- 0.1";
	u190->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u191 = (TExecuteCommand*) P1_W_T_MIN.GetCommand("u191",TCommand::kUpdate,TCommand::kCode);
	u191->SetExecutable(&P1_W_T_MIN_u191_exe_g);
	u191->Code() = "u191 <- 0.2";
	u191->SetObjInfo(TCommand::kDepIndex, 5);
	TImportCommand* SOLRADGR_import = (TImportCommand*) SOLRADGR.GetCommand("SOLRADGR_import",TCommand::kUndefined,TCommand::kImport);
	SOLRADGR_import->Code() = "Import SOLRADGR from XXXImports2_module";
	SOLRADGR_import->AddDependency(SOLRADGR);
	SOLRADGR_import->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int MACROPHYTES_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int MACROPHYTES_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int MACROPHYTES_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int MACROPHYTES_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class XXXImports2_module 
// ---------------------------------------------------------------------------
XXXImports2_module::XXXImports2_module(char* name) :
	TIME("TIME"),
	SOLRADGR("SOLRADGR"),
	DAYJUL("DAYJUL"),
	TModule(name) {

	SOLRADGR.SetF(FisExport,True,"CG");
	DAYJUL.SetF(FisImport,True,"CG");
}	
int XXXImports2_module::SOLRADGR_u206_exe() {
	float value;

	switch( SOLRADGR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SOLRADGR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph27(DAYJUL.Value(p));
			SOLRADGR.Update( p, value );
		}
		SOLRADGR.GrabMemory();
		if( SOLRADGR.GetF(FLinkEdges) ) { SOLRADGR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph27(DAYJUL.Value());
			SOLRADGR.Update( value );
	  } break;
	}
	return 0;
}

XXXImports2_module* XXXImports2_module::fInstance = NULL;
XXXImports2_module* XXXImports2_module::kNullModel = (XXXImports2_module*)0x1;
int XXXImports2_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int XXXImports2_module::InitVars() {
	
	TIME.SSInit(this);
	SOLRADGR.SSInit(this);
	SOLRADGR.SetF(FisIgnored,False,"InitVars");
	DAYJUL.SSInit(this);
	DAYJUL.SetF(FisIgnored,False,"InitVars");
	fVarList.Alphabetize();
	return 0;
}

int XXXImports2_module::SetupEvents() {
	TExecuteCommand* u206 = (TExecuteCommand*) SOLRADGR.GetCommand("u206",TCommand::kUpdate,TCommand::kCode);
	u206->SetExecutable(&SOLRADGR_u206_exe_g);
	u206->Code() = "u206 <- Graph27(DAYJUL)";
	u206->AddDependency(DAYJUL);
	u206->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DAYJUL_import = (TImportCommand*) DAYJUL.GetCommand("DAYJUL_import",TCommand::kUndefined,TCommand::kImport);
	DAYJUL_import->Code() = "Import DAYJUL from GLOBALS_module";
	DAYJUL_import->AddDependency(DAYJUL);
	DAYJUL_import->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int XXXImports2_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int XXXImports2_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int XXXImports2_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int XXXImports2_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class HYDROLOGY_module 
// ---------------------------------------------------------------------------
HYDROLOGY_module::HYDROLOGY_module(char* name) :
	TIME("TIME"),
	SURFACE_WATER("SURFACE_WATER"),
	UW_DEPTH("UW_DEPTH"),
	WATER_AVAIL("WATER_AVAIL"),
	ON_MAP("ON_MAP"),
	DIN_SD("DIN_SD"),
	HABITATMAP("HABITATMAP"),
	AIR_TEMP_C("AIR_TEMP_C"),
	PRECIP_M("PRECIP_M"),
	HYDRO("HYDRO"),
	ELEVATION("ELEVATION"),
	DIN_SF("DIN_SF"),
	CELL_SIZE("CELL_SIZE"),
	SOLRADGRD("SOLRADGRD"),
	MACLAI("MACLAI"),
	SOIL("SOIL"),
	HUMIDITY("HUMIDITY"),
	WIND("WIND"),
	A_IN("A_IN"),
	ELEV_MIN("ELEV_MIN"),
	ETPM("ETPM"),
	ROOT_DEPTH("ROOT_DEPTH"),
	P1_DATUM_TO_MSL("P1_DATUM_TO_MSL"),
	SAT_WATER("SAT_WATER"),
	UNSAT_WATER("UNSAT_WATER"),
	UW_FROM_PRECIP("UW_FROM_PRECIP"),
	SW_TO_SATW_DOWNFLOW("SW_TO_SATW_DOWNFLOW"),
	SATW_FROM_PRECIP("SATW_FROM_PRECIP"),
	SATW_TO_SW_UPFLOW("SATW_TO_SW_UPFLOW"),
	SATW_OUTFLUX("SATW_OUTFLUX"),
	SW_OUTFLUX("SW_OUTFLUX"),
	UW_SATW_EXCHANGE("UW_SATW_EXCHANGE"),
	SATW_RECHARGE("SATW_RECHARGE"),
	SATW_TRANSP("SATW_TRANSP"),
	SATW_UW("SATW_UW"),
	SNOW_ICE("SNOW_ICE"),
	SNOWFALL("SNOWFALL"),
	SW_FREEZE("SW_FREEZE"),
	SNOWMELT("SNOWMELT"),
	SW_IN("SW_IN"),
	SW_EVAP("SW_EVAP"),
	TOT_IN("TOT_IN"),
	TOTAL_INFLOW("TOTAL_INFLOW"),
	TOT_OUT("TOT_OUT"),
	TOTAL_OUTFLOW("TOTAL_OUTFLOW"),
	UW_ETRANSP("UW_ETRANSP"),
	BALANCE("BALANCE"),
	EVAPORATION("EVAPORATION"),
	EVAP_UW("EVAP_UW"),
	H_CONDUCT("H_CONDUCT"),
	IC_SATW("IC_SATW"),
	IC_UW("IC_UW"),
	INFILTRATION("INFILTRATION"),
	INF_COND("INF_COND"),
	INTERCEPT("INTERCEPT"),
	NET_PRECIP("NET_PRECIP"),
	OUT_F_SD("OUT_F_SD"),
	OUT_F_SF("OUT_F_SF"),
	PAN_CH("PAN_CH"),
	PAN_CT("PAN_CT"),
	PAN_CW("PAN_CW"),
	POROSITY("POROSITY"),
	POT_INFILTR("POT_INFILTR"),
	RAINFALL("RAINFALL"),
	SATWMAX("SATWMAX"),
	SATWRUNOFF("SATWRUNOFF"),
	SATW_HEAD("SATW_HEAD"),
	SW_FROM_PS("SW_FROM_PS"),
	TOTAL_OUT("TOTAL_OUT"),
	TOTAL_PRECIP("TOTAL_PRECIP"),
	TRANSPIRATION("TRANSPIRATION"),
	UNSAT_CAP("UNSAT_CAP"),
	UW_CAPIL_EXP("UW_CAPIL_EXP"),
	UW_DELTA("UW_DELTA"),
	UW_DEPTH_BEFORE("UW_DEPTH_BEFORE"),
	UW_EXCESS("UW_EXCESS"),
	UW_MOIST_PRP("UW_MOIST_PRP"),
	UW_MP_R("UW_MP_R"),
	UW_PERC_RATE("UW_PERC_RATE"),
	UW_TRANS_PR("UW_TRANS_PR"),
	WAT_TABLE("WAT_TABLE"),
	P1_C_EVAP("P1_C_EVAP"),
	P1_C_FIELD_CAP("P1_C_FIELD_CAP"),
	P1_C_HORIZ_HYDR_COND("P1_C_HORIZ_HYDR_COND"),
	P1_C_INFILT("P1_C_INFILT"),
	P1_C_INF_HAB("P1_C_INF_HAB"),
	P1_C_INF_SLOPE("P1_C_INF_SLOPE"),
	P1_C_INF_SOIL("P1_C_INF_SOIL"),
	P1_C_INTERCEP("P1_C_INTERCEP"),
	P1_C_INTERCEPVEG("P1_C_INTERCEPVEG"),
	P1_C_POROSITY("P1_C_POROSITY"),
	P1_C_RECHG("P1_C_RECHG"),
	P1_C_SATW_OUT("P1_C_SATW_OUT"),
	P1_C_SW_MELT("P1_C_SW_MELT"),
	P1_C_SW_OUT("P1_C_SW_OUT"),
	P1_C_TRANSP("P1_C_TRANSP"),
	P1_C_UW_EVAP("P1_C_UW_EVAP"),
	P1_C_VERT_HYDR_COND("P1_C_VERT_HYDR_COND"),
	P1_C_ZIG("P1_C_ZIG"),
	P1_IC_SW_DEPTH("P1_IC_SW_DEPTH"),
	P1_IC_UW_MOIST_PR("P1_IC_UW_MOIST_PR"),
	P1_IC_WT_TABLE("P1_IC_WT_TABLE"),
	TModule(name) {

	SURFACE_WATER.SetF(FisExport,True,"CG");
	UW_DEPTH.SetF(FisExport,True,"CG");
	WATER_AVAIL.SetF(FisExport,True,"CG");
	ON_MAP.SetF(FisImport,True,"CG");
	DIN_SD.SetF(FisImport,True,"CG");
	HABITATMAP.SetF(FisImport,True,"CG");
	AIR_TEMP_C.SetF(FisImport,True,"CG");
	PRECIP_M.SetF(FisImport,True,"CG");
	HYDRO.SetF(FisImport,True,"CG");
	ELEVATION.SetF(FisImport,True,"CG");
	DIN_SF.SetF(FisImport,True,"CG");
	CELL_SIZE.SetF(FisImport,True,"CG");
	SOLRADGRD.SetF(FisImport,True,"CG");
	MACLAI.SetF(FisImport,True,"CG");
	SOIL.SetF(FisImport,True,"CG");
	HUMIDITY.SetF(FisImport,True,"CG");
	WIND.SetF(FisImport,True,"CG");
	A_IN.SetF(FisImport,True,"CG");
	ELEV_MIN.SetF(FisImport,True,"CG");
	ETPM.SetF(FisImport,True,"CG");
	ROOT_DEPTH.SetF(FisImport,True,"CG");
	P1_DATUM_TO_MSL.SetF(FisImport,True,"CG");
	SAT_WATER.SetF(FisExport,True,"CG");
	UNSAT_WATER.SetF(FisExport,True,"CG");
	UW_FROM_PRECIP.SetF(FisExport,True,"CG");
	SW_TO_SATW_DOWNFLOW.SetF(FisExport,True,"CG");
	SATW_FROM_PRECIP.SetF(FisExport,True,"CG");
	SATW_TO_SW_UPFLOW.SetF(FisExport,True,"CG");
	SATW_OUTFLUX.SetF(FisExport,True,"CG");
	SW_OUTFLUX.SetF(FisExport,True,"CG");
}	
int HYDROLOGY_module::SAT_WATER_I215_exe() {
	float value;

	SAT_WATER.UpdateIntegrator();
	switch( SAT_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SAT_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( ( ( UW_SATW_EXCHANGE.Value(p)+SW_TO_SATW_DOWNFLOW.Value(p) )+SATW_FROM_PRECIP.Value(p) )-SATW_RECHARGE.Value(p) )-SATW_TRANSP.Value(p) )-SATW_TO_SW_UPFLOW.Value(p) )-SATW_OUTFLUX.Value(p) )-SATW_UW.Value(p) );
			SAT_WATER.Update( p, value, dT() );
		}
		SAT_WATER.GrabMemory();
		if( SAT_WATER.GetF(FLinkEdges) ) { SAT_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( ( ( UW_SATW_EXCHANGE.Value()+SW_TO_SATW_DOWNFLOW.Value() )+SATW_FROM_PRECIP.Value() )-SATW_RECHARGE.Value() )-SATW_TRANSP.Value() )-SATW_TO_SW_UPFLOW.Value() )-SATW_OUTFLUX.Value() )-SATW_UW.Value() );
			SAT_WATER.Update( value, dT() );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SAT_WATER_i216_exe() {
	float value;

	SAT_WATER.UpdateIntegrator();
	switch( SAT_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SAT_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  IC_SATW.Value(p);
			SAT_WATER.InitValue( p, value );
		}
		SAT_WATER.GrabMemory();
		if( SAT_WATER.GetF(FLinkEdges) ) { SAT_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  IC_SATW.Value();
			SAT_WATER.InitValue( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SAT_WATER_vE433_exe() {
	float value;

			 GWTrans_I(SAT_WATER, POROSITY, H_CONDUCT, ON_MAP, DIN_SD, UNSAT_WATER, OUT_F_SD);
	SAT_WATER.UpdateReserve();
	return 0;
}

int HYDROLOGY_module::UW_SATW_EXCHANGE_u217_exe() {
	float value;

	switch( UW_SATW_EXCHANGE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_SATW_EXCHANGE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( INF_COND.Value(p) == ((float)0) ) ) ? ( ( UNSAT_WATER.Value(p)/dT() ) ) : ( SL::Min(( UNSAT_WATER.Value(p)/dT() ), ( ( SL::Max(((float)0), ( UW_DELTA.Value(p)*UW_MOIST_PRP.Value(p) ))/dT() )+UW_PERC_RATE.Value(p) )) ) ) ;
			UW_SATW_EXCHANGE.Update( p, value );
		}
		UW_SATW_EXCHANGE.GrabMemory();
		if( UW_SATW_EXCHANGE.GetF(FICFlux) ) UW_SATW_EXCHANGE.Cov().Set(0.0); 
		if( UW_SATW_EXCHANGE.GetF(FLinkEdges) ) { UW_SATW_EXCHANGE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( INF_COND.Value() == ((float)0) ) ) ? ( ( UNSAT_WATER.Value()/dT() ) ) : ( SL::Min(( UNSAT_WATER.Value()/dT() ), ( ( SL::Max(((float)0), ( UW_DELTA.Value()*UW_MOIST_PRP.Value() ))/dT() )+UW_PERC_RATE.Value() )) ) ) ;
			UW_SATW_EXCHANGE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SW_TO_SATW_DOWNFLOW_u218_exe() {
	float value;

	switch( SW_TO_SATW_DOWNFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_TO_SATW_DOWNFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( HABITATMAP.Value(p) == ((float)1) ) || ( ( UW_DEPTH_BEFORE.Value(p) == ((float)0) ) && ( UNSAT_CAP.Value(p) >  ((float)0) ) ) ) ) ? ( SL::Min(( UNSAT_CAP.Value(p)/dT() ), ( SURFACE_WATER.Value(p)/dT() )) ) : ( ((float)0) ) ) ;
			SW_TO_SATW_DOWNFLOW.Update( p, value );
		}
		SW_TO_SATW_DOWNFLOW.GrabMemory();
		if( SW_TO_SATW_DOWNFLOW.GetF(FICFlux) ) SW_TO_SATW_DOWNFLOW.Cov().Set(0.0); 
		if( SW_TO_SATW_DOWNFLOW.GetF(FLinkEdges) ) { SW_TO_SATW_DOWNFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( HABITATMAP.Value() == ((float)1) ) || ( ( UW_DEPTH_BEFORE.Value() == ((float)0) ) && ( UNSAT_CAP.Value() >  ((float)0) ) ) ) ) ? ( SL::Min(( UNSAT_CAP.Value()/dT() ), ( SURFACE_WATER.Value()/dT() )) ) : ( ((float)0) ) ) ;
			SW_TO_SATW_DOWNFLOW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATW_FROM_PRECIP_u219_exe() {
	float value;

	switch( SATW_FROM_PRECIP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_FROM_PRECIP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( INF_COND.Value(p) == ((float)0) ) ) ? ( ( ( UNSAT_CAP.Value(p)/dT() )-SW_TO_SATW_DOWNFLOW.Value(p) ) ) : ( ((float)0) ) ) ;
			SATW_FROM_PRECIP.Update( p, value );
		}
		SATW_FROM_PRECIP.GrabMemory();
		if( SATW_FROM_PRECIP.GetF(FICFlux) ) SATW_FROM_PRECIP.Cov().Set(0.0); 
		if( SATW_FROM_PRECIP.GetF(FLinkEdges) ) { SATW_FROM_PRECIP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( INF_COND.Value() == ((float)0) ) ) ? ( ( ( UNSAT_CAP.Value()/dT() )-SW_TO_SATW_DOWNFLOW.Value() ) ) : ( ((float)0) ) ) ;
			SATW_FROM_PRECIP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATW_RECHARGE_u220_exe() {
	float value;

	switch( SATW_RECHARGE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_RECHARGE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  P1_C_RECHG.Value(p);
			SATW_RECHARGE.Update( p, value );
		}
		SATW_RECHARGE.GrabMemory();
		if( SATW_RECHARGE.GetF(FICFlux) ) SATW_RECHARGE.Cov().Set(0.0); 
		if( SATW_RECHARGE.GetF(FLinkEdges) ) { SATW_RECHARGE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  P1_C_RECHG.Value();
			SATW_RECHARGE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATW_TRANSP_u221_exe() {
	float value;

	switch( SATW_TRANSP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_TRANSP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( TRANSPIRATION.Value(p)*( ((float)1)-UW_TRANS_PR.Value(p) ) );
			SATW_TRANSP.Update( p, value );
		}
		SATW_TRANSP.GrabMemory();
		if( SATW_TRANSP.GetF(FICFlux) ) SATW_TRANSP.Cov().Set(0.0); 
		if( SATW_TRANSP.GetF(FLinkEdges) ) { SATW_TRANSP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( TRANSPIRATION.Value()*( ((float)1)-UW_TRANS_PR.Value() ) );
			SATW_TRANSP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATW_TO_SW_UPFLOW_u222_exe() {
	float value;

	switch( SATW_TO_SW_UPFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_TO_SW_UPFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SAT_WATER.Value(p) >  SATWMAX.Value(p) ) ) ? ( ( SAT_WATER.Value(p)-SATWMAX.Value(p) ) ) : (  ( ( ( SAT_WATER.Value(p) >  SATWRUNOFF.Value(p) ) ) ? ( ( ( P1_C_ZIG.Value(p)*( SAT_WATER.Value(p)-SATWRUNOFF.Value(p) ) )*H_CONDUCT.Value(p) ) ) : ( ((float)0) ) )  ) ) ;
			SATW_TO_SW_UPFLOW.Update( p, value );
		}
		SATW_TO_SW_UPFLOW.GrabMemory();
		if( SATW_TO_SW_UPFLOW.GetF(FICFlux) ) SATW_TO_SW_UPFLOW.Cov().Set(0.0); 
		if( SATW_TO_SW_UPFLOW.GetF(FLinkEdges) ) { SATW_TO_SW_UPFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SAT_WATER.Value() >  SATWMAX.Value() ) ) ? ( ( SAT_WATER.Value()-SATWMAX.Value() ) ) : (  ( ( ( SAT_WATER.Value() >  SATWRUNOFF.Value() ) ) ? ( ( ( P1_C_ZIG.Value()*( SAT_WATER.Value()-SATWRUNOFF.Value() ) )*H_CONDUCT.Value() ) ) : ( ((float)0) ) )  ) ) ;
			SATW_TO_SW_UPFLOW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATW_OUTFLUX_u223_exe() {
	float value;

	switch( SATW_OUTFLUX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_OUTFLUX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_C_SATW_OUT.Value(p)*( SAT_WATER.Value(p)-IC_SATW.Value(p) ) );
			SATW_OUTFLUX.Update( p, value );
		}
		SATW_OUTFLUX.GrabMemory();
		if( SATW_OUTFLUX.GetF(FICFlux) ) SATW_OUTFLUX.Cov().Set(0.0); 
		if( SATW_OUTFLUX.GetF(FLinkEdges) ) { SATW_OUTFLUX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_C_SATW_OUT.Value()*( SAT_WATER.Value()-IC_SATW.Value() ) );
			SATW_OUTFLUX.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATW_UW_u224_exe() {
	float value;

	switch( SATW_UW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_UW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Max(((float)0), SL::Min(( -UW_DELTA.Value(p)*P1_C_FIELD_CAP.Value(p) ), ( SAT_WATER.Value(p)/dT() )));
			SATW_UW.Update( p, value );
		}
		SATW_UW.GrabMemory();
		if( SATW_UW.GetF(FICFlux) ) SATW_UW.Cov().Set(0.0); 
		if( SATW_UW.GetF(FLinkEdges) ) { SATW_UW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Max(((float)0), SL::Min(( -UW_DELTA.Value()*P1_C_FIELD_CAP.Value() ), ( SAT_WATER.Value()/dT() )));
			SATW_UW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SNOW_ICE_I225_exe() {
	float value;

	SNOW_ICE.UpdateIntegrator();
	switch( SNOW_ICE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SNOW_ICE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SNOWFALL.Value(p)+SW_FREEZE.Value(p) )-SNOWMELT.Value(p) );
			SNOW_ICE.Update( p, value, dT() );
		}
		SNOW_ICE.GrabMemory();
		if( SNOW_ICE.GetF(FLinkEdges) ) { SNOW_ICE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SNOWFALL.Value()+SW_FREEZE.Value() )-SNOWMELT.Value() );
			SNOW_ICE.Update( value, dT() );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SNOW_ICE_i226_exe() {
	float value;

	SNOW_ICE.UpdateIntegrator();
	switch( SNOW_ICE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SNOW_ICE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			SNOW_ICE.InitValue( p, value );
		}
		SNOW_ICE.GrabMemory();
		if( SNOW_ICE.GetF(FLinkEdges) ) { SNOW_ICE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			SNOW_ICE.InitValue( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SNOWFALL_u227_exe() {
	float value;

	switch( SNOWFALL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SNOWFALL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( AIR_TEMP_C.Value(p) <= ((float)0) ) ) ? ( PRECIP_M.Value(p) ) : ( ((float)0) ) ) ;
			SNOWFALL.Update( p, value );
		}
		SNOWFALL.GrabMemory();
		if( SNOWFALL.GetF(FICFlux) ) SNOWFALL.Cov().Set(0.0); 
		if( SNOWFALL.GetF(FLinkEdges) ) { SNOWFALL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( AIR_TEMP_C.Value() <= ((float)0) ) ) ? ( PRECIP_M.Value() ) : ( ((float)0) ) ) ;
			SNOWFALL.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SW_FREEZE_u228_exe() {
	float value;

	switch( SW_FREEZE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_FREEZE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( AIR_TEMP_C.Value(p) >  ((float)0) ) ) ? ( ((float)0) ) : ( ( ( -AIR_TEMP_C.Value(p)*SURFACE_WATER.Value(p) )*P1_C_SW_MELT.Value(p) ) ) ) ;
			SW_FREEZE.Update( p, value );
		}
		SW_FREEZE.GrabMemory();
		if( SW_FREEZE.GetF(FICFlux) ) SW_FREEZE.Cov().Set(0.0); 
		if( SW_FREEZE.GetF(FLinkEdges) ) { SW_FREEZE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( AIR_TEMP_C.Value() >  ((float)0) ) ) ? ( ((float)0) ) : ( ( ( -AIR_TEMP_C.Value()*SURFACE_WATER.Value() )*P1_C_SW_MELT.Value() ) ) ) ;
			SW_FREEZE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SNOWMELT_u229_exe() {
	float value;

	switch( SNOWMELT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SNOWMELT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( AIR_TEMP_C.Value(p) >  ((float)0) ) ) ? ( SL::Min(( P1_C_SW_MELT.Value(p)*AIR_TEMP_C.Value(p) ), ( SNOW_ICE.Value(p)/dT() )) ) : ( ((float)0) ) ) ;
			SNOWMELT.Update( p, value );
		}
		SNOWMELT.GrabMemory();
		if( SNOWMELT.GetF(FICFlux) ) SNOWMELT.Cov().Set(0.0); 
		if( SNOWMELT.GetF(FLinkEdges) ) { SNOWMELT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( AIR_TEMP_C.Value() >  ((float)0) ) ) ? ( SL::Min(( P1_C_SW_MELT.Value()*AIR_TEMP_C.Value() ), ( SNOW_ICE.Value()/dT() )) ) : ( ((float)0) ) ) ;
			SNOWMELT.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SURFACE_WATER_I230_exe() {
	float value;

	SURFACE_WATER.UpdateIntegrator();
	switch( SURFACE_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SURFACE_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( SW_IN.Value(p)+SATW_TO_SW_UPFLOW.Value(p) )-SW_EVAP.Value(p) )-SW_TO_SATW_DOWNFLOW.Value(p) )-SW_FREEZE.Value(p) )-SW_OUTFLUX.Value(p) );
			SURFACE_WATER.Update( p, value, dT() );
		}
		SURFACE_WATER.GrabMemory();
		if( SURFACE_WATER.GetF(FLinkEdges) ) { SURFACE_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( SW_IN.Value()+SATW_TO_SW_UPFLOW.Value() )-SW_EVAP.Value() )-SW_TO_SATW_DOWNFLOW.Value() )-SW_FREEZE.Value() )-SW_OUTFLUX.Value() );
			SURFACE_WATER.Update( value, dT() );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SURFACE_WATER_i231_exe() {
	float value;

	SURFACE_WATER.UpdateIntegrator();
	switch( SURFACE_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SURFACE_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  P1_IC_SW_DEPTH.Value(p);
			SURFACE_WATER.InitValue( p, value );
		}
		SURFACE_WATER.GrabMemory();
		if( SURFACE_WATER.GetF(FLinkEdges) ) { SURFACE_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  P1_IC_SW_DEPTH.Value();
			SURFACE_WATER.InitValue( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SURFACE_WATER_vE434_exe() {
	float value;

			 SWTransport_b(SURFACE_WATER, HYDRO, HABITATMAP, ELEVATION, P1_C_INF_SLOPE, DIN_SF, OUT_F_SF);
	SURFACE_WATER.UpdateReserve();
	return 0;
}

int HYDROLOGY_module::SW_IN_u232_exe() {
	float value;

	switch( SW_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( NET_PRECIP.Value(p)-UW_FROM_PRECIP.Value(p) )-SATW_FROM_PRECIP.Value(p) )+( ( SW_FROM_PS.Value(p)/CELL_SIZE.Value(p) )/10 ) );
			SW_IN.Update( p, value );
		}
		SW_IN.GrabMemory();
		if( SW_IN.GetF(FICFlux) ) SW_IN.Cov().Set(0.0); 
		if( SW_IN.GetF(FLinkEdges) ) { SW_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( NET_PRECIP.Value()-UW_FROM_PRECIP.Value() )-SATW_FROM_PRECIP.Value() )+( ( SW_FROM_PS.Value()/CELL_SIZE.Value() )/10 ) );
			SW_IN.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SW_EVAP_u233_exe() {
	float value;

	switch( SW_EVAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_EVAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(SL::Max(EVAPORATION.Value(p), ((float)0)), ( SURFACE_WATER.Value(p)/dT() ));
			SW_EVAP.Update( p, value );
		}
		SW_EVAP.GrabMemory();
		if( SW_EVAP.GetF(FICFlux) ) SW_EVAP.Cov().Set(0.0); 
		if( SW_EVAP.GetF(FLinkEdges) ) { SW_EVAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(SL::Max(EVAPORATION.Value(), ((float)0)), ( SURFACE_WATER.Value()/dT() ));
			SW_EVAP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SW_OUTFLUX_u234_exe() {
	float value;

	switch( SW_OUTFLUX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_OUTFLUX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_C_SW_OUT.Value(p)*SURFACE_WATER.Value(p) )/dT() );
			SW_OUTFLUX.Update( p, value );
		}
		SW_OUTFLUX.GrabMemory();
		if( SW_OUTFLUX.GetF(FICFlux) ) SW_OUTFLUX.Cov().Set(0.0); 
		if( SW_OUTFLUX.GetF(FLinkEdges) ) { SW_OUTFLUX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_C_SW_OUT.Value()*SURFACE_WATER.Value() )/dT() );
			SW_OUTFLUX.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOT_IN_I235_exe() {
	float value;

	TOT_IN.UpdateIntegrator();
	switch( TOT_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOT_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  TOTAL_INFLOW.Value(p);
			TOT_IN.Update( p, value, dT() );
		}
		TOT_IN.GrabMemory();
		if( TOT_IN.GetF(FLinkEdges) ) { TOT_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  TOTAL_INFLOW.Value();
			TOT_IN.Update( value, dT() );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOT_IN_i236_exe() {
	float value;

	TOT_IN.UpdateIntegrator();
	switch( TOT_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOT_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			TOT_IN.InitValue( p, value );
		}
		TOT_IN.GrabMemory();
		if( TOT_IN.GetF(FLinkEdges) ) { TOT_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			TOT_IN.InitValue( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOTAL_INFLOW_u237_exe() {
	float value;

	switch( TOTAL_INFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOTAL_INFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  PRECIP_M.Value(p);
			TOTAL_INFLOW.Update( p, value );
		}
		TOTAL_INFLOW.GrabMemory();
		if( TOTAL_INFLOW.GetF(FICFlux) ) TOTAL_INFLOW.Cov().Set(0.0); 
		if( TOTAL_INFLOW.GetF(FLinkEdges) ) { TOTAL_INFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  PRECIP_M.Value();
			TOTAL_INFLOW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOT_OUT_I238_exe() {
	float value;

	TOT_OUT.UpdateIntegrator();
	switch( TOT_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOT_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  TOTAL_OUTFLOW.Value(p);
			TOT_OUT.Update( p, value, dT() );
		}
		TOT_OUT.GrabMemory();
		if( TOT_OUT.GetF(FLinkEdges) ) { TOT_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  TOTAL_OUTFLOW.Value();
			TOT_OUT.Update( value, dT() );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOT_OUT_i239_exe() {
	float value;

	TOT_OUT.UpdateIntegrator();
	switch( TOT_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOT_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			TOT_OUT.InitValue( p, value );
		}
		TOT_OUT.GrabMemory();
		if( TOT_OUT.GetF(FLinkEdges) ) { TOT_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			TOT_OUT.InitValue( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOTAL_OUTFLOW_u240_exe() {
	float value;

	switch( TOTAL_OUTFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOTAL_OUTFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  TOTAL_OUT.Value(p);
			TOTAL_OUTFLOW.Update( p, value );
		}
		TOTAL_OUTFLOW.GrabMemory();
		if( TOTAL_OUTFLOW.GetF(FICFlux) ) TOTAL_OUTFLOW.Cov().Set(0.0); 
		if( TOTAL_OUTFLOW.GetF(FLinkEdges) ) { TOTAL_OUTFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  TOTAL_OUT.Value();
			TOTAL_OUTFLOW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UNSAT_WATER_I241_exe() {
	float value;

	UNSAT_WATER.UpdateIntegrator();
	switch( UNSAT_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UNSAT_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( UW_FROM_PRECIP.Value(p)+SATW_UW.Value(p) )-UW_SATW_EXCHANGE.Value(p) )-UW_ETRANSP.Value(p) );
			UNSAT_WATER.Update( p, value, dT() );
		}
		UNSAT_WATER.GrabMemory();
		if( UNSAT_WATER.GetF(FLinkEdges) ) { UNSAT_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( UW_FROM_PRECIP.Value()+SATW_UW.Value() )-UW_SATW_EXCHANGE.Value() )-UW_ETRANSP.Value() );
			UNSAT_WATER.Update( value, dT() );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UNSAT_WATER_i242_exe() {
	float value;

	UNSAT_WATER.UpdateIntegrator();
	switch( UNSAT_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UNSAT_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  IC_UW.Value(p);
			UNSAT_WATER.InitValue( p, value );
		}
		UNSAT_WATER.GrabMemory();
		if( UNSAT_WATER.GetF(FLinkEdges) ) { UNSAT_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  IC_UW.Value();
			UNSAT_WATER.InitValue( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_FROM_PRECIP_u243_exe() {
	float value;

	switch( UW_FROM_PRECIP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_FROM_PRECIP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( INF_COND.Value(p) >  ((float)0) ) ) ? ( INFILTRATION.Value(p) ) : ( ((float)0) ) ) ;
			UW_FROM_PRECIP.Update( p, value );
		}
		UW_FROM_PRECIP.GrabMemory();
		if( UW_FROM_PRECIP.GetF(FICFlux) ) UW_FROM_PRECIP.Cov().Set(0.0); 
		if( UW_FROM_PRECIP.GetF(FLinkEdges) ) { UW_FROM_PRECIP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( INF_COND.Value() >  ((float)0) ) ) ? ( INFILTRATION.Value() ) : ( ((float)0) ) ) ;
			UW_FROM_PRECIP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_ETRANSP_u244_exe() {
	float value;

	switch( UW_ETRANSP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_ETRANSP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( TRANSPIRATION.Value(p)*UW_TRANS_PR.Value(p) )+EVAP_UW.Value(p) );
			UW_ETRANSP.Update( p, value );
		}
		UW_ETRANSP.GrabMemory();
		if( UW_ETRANSP.GetF(FICFlux) ) UW_ETRANSP.Cov().Set(0.0); 
		if( UW_ETRANSP.GetF(FLinkEdges) ) { UW_ETRANSP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( TRANSPIRATION.Value()*UW_TRANS_PR.Value() )+EVAP_UW.Value() );
			UW_ETRANSP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::BALANCE_u245_exe() {
	float value;

	switch( BALANCE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = BALANCE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( SAT_WATER.Value(p)+SNOW_ICE.Value(p) )+SURFACE_WATER.Value(p) )+UNSAT_WATER.Value(p) )-TOT_IN.Value(p) )+TOT_OUT.Value(p) );
			BALANCE.Update( p, value );
		}
		BALANCE.GrabMemory();
		if( BALANCE.GetF(FLinkEdges) ) { BALANCE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( SAT_WATER.Value()+SNOW_ICE.Value() )+SURFACE_WATER.Value() )+UNSAT_WATER.Value() )-TOT_IN.Value() )+TOT_OUT.Value() );
			BALANCE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::EVAPORATION_u246_exe() {
	float value;

	switch( EVAPORATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EVAPORATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( P1_C_EVAP.Value(p)*SOLRADGRD.Value(p) )/585 )*PAN_CW.Value(p) )*PAN_CT.Value(p) )*PAN_CH.Value(p) );
			EVAPORATION.Update( p, value );
		}
		EVAPORATION.GrabMemory();
		if( EVAPORATION.GetF(FLinkEdges) ) { EVAPORATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( P1_C_EVAP.Value()*SOLRADGRD.Value() )/585 )*PAN_CW.Value() )*PAN_CT.Value() )*PAN_CH.Value() );
			EVAPORATION.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::EVAP_UW_u247_exe() {
	float value;

	switch( EVAP_UW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EVAP_UW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( P1_C_UW_EVAP.Value(p)*EVAPORATION.Value(p) )*( ((float)1)-SL::Min(((float)1), MACLAI.Value(p)) ) )*UW_MP_R.Value(p) );
			EVAP_UW.Update( p, value );
		}
		EVAP_UW.GrabMemory();
		if( EVAP_UW.GetF(FLinkEdges) ) { EVAP_UW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( P1_C_UW_EVAP.Value()*EVAPORATION.Value() )*( ((float)1)-SL::Min(((float)1), MACLAI.Value()) ) )*UW_MP_R.Value() );
			EVAP_UW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::H_CONDUCT_u248_exe() {
	float value;

	switch( H_CONDUCT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = H_CONDUCT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_C_HORIZ_HYDR_COND.Value(p)/SL::Sqrt(CELL_SIZE.Value(p)) )+( SOIL.Value(p)*0.0 ) );
			H_CONDUCT.Update( p, value );
		}
		H_CONDUCT.GrabMemory();
		if( H_CONDUCT.GetF(FLinkEdges) ) { H_CONDUCT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_C_HORIZ_HYDR_COND.Value()/SL::Sqrt(CELL_SIZE.Value()) )+( SOIL.Value()*0.0 ) );
			H_CONDUCT.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::IC_SATW_u249_exe() {
	float value;

	switch( IC_SATW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = IC_SATW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( WAT_TABLE.Value(p)*P1_C_POROSITY.Value(p) );
			IC_SATW.Update( p, value );
		}
		IC_SATW.GrabMemory();
		if( IC_SATW.GetF(FLinkEdges) ) { IC_SATW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( WAT_TABLE.Value()*P1_C_POROSITY.Value() );
			IC_SATW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::IC_UW_u250_exe() {
	float value;

	switch( IC_UW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = IC_UW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ELEVATION.Value(p) >  WAT_TABLE.Value(p) ) ) ? ( ( ( ELEVATION.Value(p)-WAT_TABLE.Value(p) )*P1_IC_UW_MOIST_PR.Value(p) ) ) : ( ((float)0) ) ) ;
			IC_UW.Update( p, value );
		}
		IC_UW.GrabMemory();
		if( IC_UW.GetF(FLinkEdges) ) { IC_UW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ELEVATION.Value() >  WAT_TABLE.Value() ) ) ? ( ( ( ELEVATION.Value()-WAT_TABLE.Value() )*P1_IC_UW_MOIST_PR.Value() ) ) : ( ((float)0) ) ) ;
			IC_UW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::INFILTRATION_u251_exe() {
	float value;

	switch( INFILTRATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = INFILTRATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(POT_INFILTR.Value(p), NET_PRECIP.Value(p));
			INFILTRATION.Update( p, value );
		}
		INFILTRATION.GrabMemory();
		if( INFILTRATION.GetF(FLinkEdges) ) { INFILTRATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(POT_INFILTR.Value(), NET_PRECIP.Value());
			INFILTRATION.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::INF_COND_u252_exe() {
	float value;

	switch( INF_COND.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = INF_COND.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( SW_TO_SATW_DOWNFLOW.Value(p)*dT() ) == UNSAT_CAP.Value(p) ) ) ? ( ((float)0) ) : ( SL::Max(( UNSAT_CAP.Value(p)-( INFILTRATION.Value(p)*dT() ) ), ((float)0)) ) ) ;
			INF_COND.Update( p, value );
		}
		INF_COND.GrabMemory();
		if( INF_COND.GetF(FLinkEdges) ) { INF_COND.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( SW_TO_SATW_DOWNFLOW.Value()*dT() ) == UNSAT_CAP.Value() ) ) ? ( ((float)0) ) : ( SL::Max(( UNSAT_CAP.Value()-( INFILTRATION.Value()*dT() ) ), ((float)0)) ) ) ;
			INF_COND.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::INTERCEPT_u253_exe() {
	float value;

	switch( INTERCEPT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = INTERCEPT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(TOTAL_PRECIP.Value(p), SL::Max(( P1_C_INTERCEP.Value(p)*TOTAL_PRECIP.Value(p) ), ( P1_C_INTERCEPVEG.Value(p)*MACLAI.Value(p) )));
			INTERCEPT.Update( p, value );
		}
		INTERCEPT.GrabMemory();
		if( INTERCEPT.GetF(FLinkEdges) ) { INTERCEPT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(TOTAL_PRECIP.Value(), SL::Max(( P1_C_INTERCEP.Value()*TOTAL_PRECIP.Value() ), ( P1_C_INTERCEPVEG.Value()*MACLAI.Value() )));
			INTERCEPT.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::NET_PRECIP_u254_exe() {
	float value;

	switch( NET_PRECIP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NET_PRECIP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( TOTAL_PRECIP.Value(p)-INTERCEPT.Value(p) );
			NET_PRECIP.Update( p, value );
		}
		NET_PRECIP.GrabMemory();
		if( NET_PRECIP.GetF(FLinkEdges) ) { NET_PRECIP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( TOTAL_PRECIP.Value()-INTERCEPT.Value() );
			NET_PRECIP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::OUT_F_SD_u255_exe() {
	float value;

	switch( OUT_F_SD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = OUT_F_SD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			OUT_F_SD.Update( p, value );
		}
		OUT_F_SD.GrabMemory();
		if( OUT_F_SD.GetF(FLinkEdges) ) { OUT_F_SD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			OUT_F_SD.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::OUT_F_SF_u256_exe() {
	float value;

	switch( OUT_F_SF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = OUT_F_SF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			OUT_F_SF.Update( p, value );
		}
		OUT_F_SF.GrabMemory();
		if( OUT_F_SF.GetF(FLinkEdges) ) { OUT_F_SF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			OUT_F_SF.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::PAN_CH_u257_exe() {
	float value;

	switch( PAN_CH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PAN_CH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( 1.035+( 0.240*pow((double)( HUMIDITY.Value(p)/60 ),(double)((float)2) ) ) )-( 0.275*pow((double)( HUMIDITY.Value(p)/60 ),(double)((float)3) ) ) );
			PAN_CH.Update( p, value );
		}
		PAN_CH.GrabMemory();
		if( PAN_CH.GetF(FLinkEdges) ) { PAN_CH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( 1.035+( 0.240*pow((double)( HUMIDITY.Value()/60 ),(double)((float)2) ) ) )-( 0.275*pow((double)( HUMIDITY.Value()/60 ),(double)((float)3) ) ) );
			PAN_CH.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::PAN_CT_u258_exe() {
	float value;

	switch( PAN_CT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PAN_CT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( AIR_TEMP_C.Value(p) >  -((float)30) ) ) ? ( ( ( 0.463+( 0.425*( AIR_TEMP_C.Value(p)/20 ) ) )+( 0.112*pow((double)( AIR_TEMP_C.Value(p)/20 ),(double)((float)2) ) ) ) ) : ( ((float)0) ) ) ;
			PAN_CT.Update( p, value );
		}
		PAN_CT.GrabMemory();
		if( PAN_CT.GetF(FLinkEdges) ) { PAN_CT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( AIR_TEMP_C.Value() >  -((float)30) ) ) ? ( ( ( 0.463+( 0.425*( AIR_TEMP_C.Value()/20 ) ) )+( 0.112*pow((double)( AIR_TEMP_C.Value()/20 ),(double)((float)2) ) ) ) ) : ( ((float)0) ) ) ;
			PAN_CT.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::PAN_CW_u259_exe() {
	float value;

	switch( PAN_CW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PAN_CW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( 0.672+( 0.406*( WIND.Value(p)/6.7 ) ) )+( 0.078*pow((double)( WIND.Value(p)/6.7 ),(double)((float)2) ) ) );
			PAN_CW.Update( p, value );
		}
		PAN_CW.GrabMemory();
		if( PAN_CW.GetF(FLinkEdges) ) { PAN_CW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( 0.672+( 0.406*( WIND.Value()/6.7 ) ) )+( 0.078*pow((double)( WIND.Value()/6.7 ),(double)((float)2) ) ) );
			PAN_CW.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::POROSITY_u260_exe() {
	float value;

	switch( POROSITY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = POROSITY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_C_POROSITY.Value(p)+( SOIL.Value(p)*0.0 ) );
			POROSITY.Update( p, value );
		}
		POROSITY.GrabMemory();
		if( POROSITY.GetF(FLinkEdges) ) { POROSITY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_C_POROSITY.Value()+( SOIL.Value()*0.0 ) );
			POROSITY.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::POT_INFILTR_u261_exe() {
	float value;

	switch( POT_INFILTR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = POT_INFILTR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( P1_C_INFILT.Value(p)*P1_C_INF_HAB.Value(p) )*P1_C_INF_SOIL.Value(p) )/ ( ( ( P1_C_INF_SLOPE.Value(p) >  ((float)0) ) ) ? ( P1_C_INF_SOIL.Value(p) ) : ( ((float)1) ) )  );
			POT_INFILTR.Update( p, value );
		}
		POT_INFILTR.GrabMemory();
		if( POT_INFILTR.GetF(FLinkEdges) ) { POT_INFILTR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( P1_C_INFILT.Value()*P1_C_INF_HAB.Value() )*P1_C_INF_SOIL.Value() )/ ( ( ( P1_C_INF_SLOPE.Value() >  ((float)0) ) ) ? ( P1_C_INF_SOIL.Value() ) : ( ((float)1) ) )  );
			POT_INFILTR.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::POT_INFILTR_v435_exe() {
	float value;

			 Infilt(POT_INFILTR, PRECIP_M, TOTAL_INFLOW, TOTAL_OUTFLOW, BALANCE, A_IN);
	return 0;
}

int HYDROLOGY_module::RAINFALL_u262_exe() {
	float value;

	switch( RAINFALL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = RAINFALL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( AIR_TEMP_C.Value(p) >  ((float)0) ) ) ? ( PRECIP_M.Value(p) ) : ( ((float)0) ) ) ;
			RAINFALL.Update( p, value );
		}
		RAINFALL.GrabMemory();
		if( RAINFALL.GetF(FLinkEdges) ) { RAINFALL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( AIR_TEMP_C.Value() >  ((float)0) ) ) ? ( PRECIP_M.Value() ) : ( ((float)0) ) ) ;
			RAINFALL.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATWMAX_u263_exe() {
	float value;

	switch( SATWMAX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATWMAX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ELEVATION.Value(p)*P1_C_POROSITY.Value(p) );
			SATWMAX.Update( p, value );
		}
		SATWMAX.GrabMemory();
		if( SATWMAX.GetF(FLinkEdges) ) { SATWMAX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ELEVATION.Value()*P1_C_POROSITY.Value() );
			SATWMAX.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATWRUNOFF_u264_exe() {
	float value;

	switch( SATWRUNOFF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATWRUNOFF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ELEV_MIN.Value(p)*P1_C_POROSITY.Value(p) );
			SATWRUNOFF.Update( p, value );
		}
		SATWRUNOFF.GrabMemory();
		if( SATWRUNOFF.GetF(FLinkEdges) ) { SATWRUNOFF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ELEV_MIN.Value()*P1_C_POROSITY.Value() );
			SATWRUNOFF.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SATW_HEAD_u265_exe() {
	float value;

	switch( SATW_HEAD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATW_HEAD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SAT_WATER.Value(p)/P1_C_POROSITY.Value(p) );
			SATW_HEAD.Update( p, value );
		}
		SATW_HEAD.GrabMemory();
		if( SATW_HEAD.GetF(FLinkEdges) ) { SATW_HEAD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SAT_WATER.Value()/P1_C_POROSITY.Value() );
			SATW_HEAD.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::SW_FROM_PS_u266_exe() {
	float value;

	switch( SW_FROM_PS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_FROM_PS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			SW_FROM_PS.Update( p, value );
		}
		SW_FROM_PS.GrabMemory();
		if( SW_FROM_PS.GetF(FLinkEdges) ) { SW_FROM_PS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			SW_FROM_PS.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOTAL_OUT_u267_exe() {
	float value;

	switch( TOTAL_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOTAL_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( ( INTERCEPT.Value(p)+SATW_OUTFLUX.Value(p) )+SATW_RECHARGE.Value(p) )+SATW_TRANSP.Value(p) )+SW_EVAP.Value(p) )+SW_OUTFLUX.Value(p) )+UW_ETRANSP.Value(p) );
			TOTAL_OUT.Update( p, value );
		}
		TOTAL_OUT.GrabMemory();
		if( TOTAL_OUT.GetF(FLinkEdges) ) { TOTAL_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( ( INTERCEPT.Value()+SATW_OUTFLUX.Value() )+SATW_RECHARGE.Value() )+SATW_TRANSP.Value() )+SW_EVAP.Value() )+SW_OUTFLUX.Value() )+UW_ETRANSP.Value() );
			TOTAL_OUT.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TOTAL_PRECIP_u268_exe() {
	float value;

	switch( TOTAL_PRECIP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOTAL_PRECIP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( RAINFALL.Value(p)+SNOWMELT.Value(p) );
			TOTAL_PRECIP.Update( p, value );
		}
		TOTAL_PRECIP.GrabMemory();
		if( TOTAL_PRECIP.GetF(FLinkEdges) ) { TOTAL_PRECIP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( RAINFALL.Value()+SNOWMELT.Value() );
			TOTAL_PRECIP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::TRANSPIRATION_u269_exe() {
	float value;

	switch( TRANSPIRATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TRANSPIRATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( P1_C_TRANSP.Value(p)*SL::Min(((float)1), MACLAI.Value(p)) )*ETPM.Value(p) )*WATER_AVAIL.Value(p) );
			TRANSPIRATION.Update( p, value );
		}
		TRANSPIRATION.GrabMemory();
		if( TRANSPIRATION.GetF(FLinkEdges) ) { TRANSPIRATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( P1_C_TRANSP.Value()*SL::Min(((float)1), MACLAI.Value()) )*ETPM.Value() )*WATER_AVAIL.Value() );
			TRANSPIRATION.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UNSAT_CAP_u270_exe() {
	float value;

	switch( UNSAT_CAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UNSAT_CAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Max(( UW_DEPTH.Value(p)*( P1_C_POROSITY.Value(p)-UW_MOIST_PRP.Value(p) ) ), ((float)0));
			UNSAT_CAP.Update( p, value );
		}
		UNSAT_CAP.GrabMemory();
		if( UNSAT_CAP.GetF(FLinkEdges) ) { UNSAT_CAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Max(( UW_DEPTH.Value()*( P1_C_POROSITY.Value()-UW_MOIST_PRP.Value() ) ), ((float)0));
			UNSAT_CAP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_CAPIL_EXP_u271_exe() {
	float value;

	switch( UW_CAPIL_EXP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_CAPIL_EXP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Exp(( -((float)10)*SL::Max(( UW_DEPTH.Value(p)-ROOT_DEPTH.Value(p) ), ((float)0)) ));
			UW_CAPIL_EXP.Update( p, value );
		}
		UW_CAPIL_EXP.GrabMemory();
		if( UW_CAPIL_EXP.GetF(FLinkEdges) ) { UW_CAPIL_EXP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Exp(( -((float)10)*SL::Max(( UW_DEPTH.Value()-ROOT_DEPTH.Value() ), ((float)0)) ));
			UW_CAPIL_EXP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_DELTA_u272_exe() {
	float value;

	switch( UW_DELTA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_DELTA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( UW_DEPTH_BEFORE.Value(p)-UW_DEPTH.Value(p) );
			UW_DELTA.Update( p, value );
		}
		UW_DELTA.GrabMemory();
		if( UW_DELTA.GetF(FLinkEdges) ) { UW_DELTA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( UW_DEPTH_BEFORE.Value()-UW_DEPTH.Value() );
			UW_DELTA.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_DEPTH_u273_exe() {
	float value;

	switch( UW_DEPTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_DEPTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Max(( ELEVATION.Value(p)-SATW_HEAD.Value(p) ), ((float)0));
			UW_DEPTH.Update( p, value );
		}
		UW_DEPTH.GrabMemory();
		UW_DEPTH.UpdateDelayData();
		if( UW_DEPTH.GetF(FLinkEdges) ) { UW_DEPTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Max(( ELEVATION.Value()-SATW_HEAD.Value() ), ((float)0));
			UW_DEPTH.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_DEPTH_BEFORE_u274_exe() {
	float value;

	switch( UW_DEPTH_BEFORE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_DEPTH_BEFORE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  UW_DEPTH.Delay(  p, dT() );
			UW_DEPTH_BEFORE.Update( p, value );
		}
		UW_DEPTH_BEFORE.GrabMemory();
		if( UW_DEPTH_BEFORE.GetF(FLinkEdges) ) { UW_DEPTH_BEFORE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  UW_DEPTH.Delay( dT() );
			UW_DEPTH_BEFORE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_EXCESS_u275_exe() {
	float value;

	switch( UW_EXCESS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_EXCESS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Max(((float)0), ( UW_MOIST_PRP.Value(p)-P1_C_FIELD_CAP.Value(p) ));
			UW_EXCESS.Update( p, value );
		}
		UW_EXCESS.GrabMemory();
		if( UW_EXCESS.GetF(FLinkEdges) ) { UW_EXCESS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Max(((float)0), ( UW_MOIST_PRP.Value()-P1_C_FIELD_CAP.Value() ));
			UW_EXCESS.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_MOIST_PRP_u276_exe() {
	float value;

	switch( UW_MOIST_PRP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_MOIST_PRP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( UW_DEPTH.Value(p) >  ((float)0) ) ) ? ( ( UNSAT_WATER.Value(p)/UW_DEPTH.Value(p) ) ) : ( ((float)0) ) ) ;
			UW_MOIST_PRP.Update( p, value );
		}
		UW_MOIST_PRP.GrabMemory();
		if( UW_MOIST_PRP.GetF(FLinkEdges) ) { UW_MOIST_PRP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( UW_DEPTH.Value() >  ((float)0) ) ) ? ( ( UNSAT_WATER.Value()/UW_DEPTH.Value() ) ) : ( ((float)0) ) ) ;
			UW_MOIST_PRP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_MP_R_u277_exe() {
	float value;

	switch( UW_MP_R.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_MP_R.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( UW_MOIST_PRP.Value(p)/P1_C_POROSITY.Value(p) );
			UW_MP_R.Update( p, value );
		}
		UW_MP_R.GrabMemory();
		if( UW_MP_R.GetF(FLinkEdges) ) { UW_MP_R.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( UW_MOIST_PRP.Value()/P1_C_POROSITY.Value() );
			UW_MP_R.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_PERC_RATE_u278_exe() {
	float value;

	switch( UW_PERC_RATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_PERC_RATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ((float)2)*P1_C_VERT_HYDR_COND.Value(p) )*P1_C_POROSITY.Value(p) )*pow((double)UW_EXCESS.Value(p),(double)0.4 ) )/( pow((double)( P1_C_POROSITY.Value(p)-P1_C_FIELD_CAP.Value(p) ),(double)0.4 )+pow((double)UW_EXCESS.Value(p),(double)0.4 ) ) );
			UW_PERC_RATE.Update( p, value );
		}
		UW_PERC_RATE.GrabMemory();
		if( UW_PERC_RATE.GetF(FLinkEdges) ) { UW_PERC_RATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ((float)2)*P1_C_VERT_HYDR_COND.Value() )*P1_C_POROSITY.Value() )*pow((double)UW_EXCESS.Value(),(double)0.4 ) )/( pow((double)( P1_C_POROSITY.Value()-P1_C_FIELD_CAP.Value() ),(double)0.4 )+pow((double)UW_EXCESS.Value(),(double)0.4 ) ) );
			UW_PERC_RATE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::UW_TRANS_PR_u279_exe() {
	float value;

	switch( UW_TRANS_PR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UW_TRANS_PR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( ROOT_DEPTH.Value(p)+0.1 ) <  UW_DEPTH.Value(p) ) ) ? ( ((float)1) ) : (  ( ( ( UW_DEPTH.Value(p) >  ((float)0) ) ) ? ( ( WATER_AVAIL.Value(p)*( UW_DEPTH.Value(p)/( ROOT_DEPTH.Value(p)+UW_CAPIL_EXP.Value(p) ) ) ) ) : ( ((float)0) ) )  ) ) ;
			UW_TRANS_PR.Update( p, value );
		}
		UW_TRANS_PR.GrabMemory();
		if( UW_TRANS_PR.GetF(FLinkEdges) ) { UW_TRANS_PR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( ROOT_DEPTH.Value()+0.1 ) <  UW_DEPTH.Value() ) ) ? ( ((float)1) ) : (  ( ( ( UW_DEPTH.Value() >  ((float)0) ) ) ? ( ( WATER_AVAIL.Value()*( UW_DEPTH.Value()/( ROOT_DEPTH.Value()+UW_CAPIL_EXP.Value() ) ) ) ) : ( ((float)0) ) )  ) ) ;
			UW_TRANS_PR.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::WATER_AVAIL_u280_exe() {
	float value;

	switch( WATER_AVAIL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WATER_AVAIL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(1.0, ( UW_CAPIL_EXP.Value(p)+ ( ( ( UW_MOIST_PRP.Value(p) <  ( 0.1*P1_C_FIELD_CAP.Value(p) ) ) ) ? ( ((float)0) ) : (  ( ( ( UW_MOIST_PRP.Value(p) >  ( 0.6*P1_C_FIELD_CAP.Value(p) ) ) ) ? ( ((float)1) ) : ( ( ( ( UW_MOIST_PRP.Value(p)-( 0.1*P1_C_FIELD_CAP.Value(p) ) )/0.5 )/P1_C_FIELD_CAP.Value(p) ) ) )  ) )  ));
			WATER_AVAIL.Update( p, value );
		}
		WATER_AVAIL.GrabMemory();
		if( WATER_AVAIL.GetF(FLinkEdges) ) { WATER_AVAIL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(1.0, ( UW_CAPIL_EXP.Value()+ ( ( ( UW_MOIST_PRP.Value() <  ( 0.1*P1_C_FIELD_CAP.Value() ) ) ) ? ( ((float)0) ) : (  ( ( ( UW_MOIST_PRP.Value() >  ( 0.6*P1_C_FIELD_CAP.Value() ) ) ) ? ( ((float)1) ) : ( ( ( ( UW_MOIST_PRP.Value()-( 0.1*P1_C_FIELD_CAP.Value() ) )/0.5 )/P1_C_FIELD_CAP.Value() ) ) )  ) )  ));
			WATER_AVAIL.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::WAT_TABLE_u281_exe() {
	float value;

	switch( WAT_TABLE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WAT_TABLE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_IC_WT_TABLE.Value(p)+P1_DATUM_TO_MSL.Value(p) );
			WAT_TABLE.Update( p, value );
		}
		WAT_TABLE.GrabMemory();
		if( WAT_TABLE.GetF(FLinkEdges) ) { WAT_TABLE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_IC_WT_TABLE.Value()+P1_DATUM_TO_MSL.Value() );
			WAT_TABLE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_EVAP_u282_exe() {
	float value;

	switch( P1_C_EVAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_EVAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000482;
			P1_C_EVAP.Update( p, value );
		}
		P1_C_EVAP.GrabMemory();
		if( P1_C_EVAP.GetF(FLinkEdges) ) { P1_C_EVAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000482;
			P1_C_EVAP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_FIELD_CAP_u283_exe() {
	float value;

	switch( P1_C_FIELD_CAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_FIELD_CAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.25;
			P1_C_FIELD_CAP.Update( p, value );
		}
		P1_C_FIELD_CAP.GrabMemory();
		if( P1_C_FIELD_CAP.GetF(FLinkEdges) ) { P1_C_FIELD_CAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.25;
			P1_C_FIELD_CAP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_HORIZ_HYDR_COND_u284_exe() {
	float value;

	switch( P1_C_HORIZ_HYDR_COND.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_HORIZ_HYDR_COND.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)5);
			P1_C_HORIZ_HYDR_COND.Update( p, value );
		}
		P1_C_HORIZ_HYDR_COND.GrabMemory();
		if( P1_C_HORIZ_HYDR_COND.GetF(FLinkEdges) ) { P1_C_HORIZ_HYDR_COND.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)5);
			P1_C_HORIZ_HYDR_COND.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_INFILT_u285_exe() {
	float value;

	switch( P1_C_INFILT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_INFILT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.055;
			P1_C_INFILT.Update( p, P1_C_INFILT.ParameterValue(value,p) );
		}
		P1_C_INFILT.GrabMemory();
		if( P1_C_INFILT.GetF(FLinkEdges) ) { P1_C_INFILT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.055;
			P1_C_INFILT.Update( P1_C_INFILT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_INF_HAB_u286_exe() {
	float value;

	switch( P1_C_INF_HAB.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_INF_HAB.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			P1_C_INF_HAB.Update( p, value );
		}
		P1_C_INF_HAB.GrabMemory();
		if( P1_C_INF_HAB.GetF(FLinkEdges) ) { P1_C_INF_HAB.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			P1_C_INF_HAB.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_INF_SLOPE_u287_exe() {
	float value;

	switch( P1_C_INF_SLOPE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_INF_SLOPE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)5);
			P1_C_INF_SLOPE.Update( p, value );
		}
		P1_C_INF_SLOPE.GrabMemory();
		if( P1_C_INF_SLOPE.GetF(FLinkEdges) ) { P1_C_INF_SLOPE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)5);
			P1_C_INF_SLOPE.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_INF_SOIL_u288_exe() {
	float value;

	switch( P1_C_INF_SOIL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_INF_SOIL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  4.00;
			P1_C_INF_SOIL.Update( p, value );
		}
		P1_C_INF_SOIL.GrabMemory();
		if( P1_C_INF_SOIL.GetF(FLinkEdges) ) { P1_C_INF_SOIL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  4.00;
			P1_C_INF_SOIL.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_INTERCEP_u289_exe() {
	float value;

	switch( P1_C_INTERCEP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_INTERCEP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.002;
			P1_C_INTERCEP.Update( p, value );
		}
		P1_C_INTERCEP.GrabMemory();
		if( P1_C_INTERCEP.GetF(FLinkEdges) ) { P1_C_INTERCEP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.002;
			P1_C_INTERCEP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_INTERCEPVEG_u290_exe() {
	float value;

	switch( P1_C_INTERCEPVEG.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_INTERCEPVEG.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.001;
			P1_C_INTERCEPVEG.Update( p, value );
		}
		P1_C_INTERCEPVEG.GrabMemory();
		if( P1_C_INTERCEPVEG.GetF(FLinkEdges) ) { P1_C_INTERCEPVEG.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.001;
			P1_C_INTERCEPVEG.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_POROSITY_u291_exe() {
	float value;

	switch( P1_C_POROSITY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_POROSITY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.41;
			P1_C_POROSITY.Update( p, value );
		}
		P1_C_POROSITY.GrabMemory();
		if( P1_C_POROSITY.GetF(FLinkEdges) ) { P1_C_POROSITY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.41;
			P1_C_POROSITY.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_RECHG_u292_exe() {
	float value;

	switch( P1_C_RECHG.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_RECHG.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.0001;
			P1_C_RECHG.Update( p, P1_C_RECHG.ParameterValue(value,p) );
		}
		P1_C_RECHG.GrabMemory();
		if( P1_C_RECHG.GetF(FLinkEdges) ) { P1_C_RECHG.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.0001;
			P1_C_RECHG.Update( P1_C_RECHG.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_SATW_OUT_u293_exe() {
	float value;

	switch( P1_C_SATW_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_SATW_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.;
			P1_C_SATW_OUT.Update( p, P1_C_SATW_OUT.ParameterValue(value,p) );
		}
		P1_C_SATW_OUT.GrabMemory();
		if( P1_C_SATW_OUT.GetF(FLinkEdges) ) { P1_C_SATW_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.;
			P1_C_SATW_OUT.Update( P1_C_SATW_OUT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_SW_MELT_u294_exe() {
	float value;

	switch( P1_C_SW_MELT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_SW_MELT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.005;
			P1_C_SW_MELT.Update( p, P1_C_SW_MELT.ParameterValue(value,p) );
		}
		P1_C_SW_MELT.GrabMemory();
		if( P1_C_SW_MELT.GetF(FLinkEdges) ) { P1_C_SW_MELT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.005;
			P1_C_SW_MELT.Update( P1_C_SW_MELT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_SW_OUT_u295_exe() {
	float value;

	switch( P1_C_SW_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_SW_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.;
			P1_C_SW_OUT.Update( p, P1_C_SW_OUT.ParameterValue(value,p) );
		}
		P1_C_SW_OUT.GrabMemory();
		if( P1_C_SW_OUT.GetF(FLinkEdges) ) { P1_C_SW_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.;
			P1_C_SW_OUT.Update( P1_C_SW_OUT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_TRANSP_u296_exe() {
	float value;

	switch( P1_C_TRANSP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_TRANSP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.5;
			P1_C_TRANSP.Update( p, value );
		}
		P1_C_TRANSP.GrabMemory();
		if( P1_C_TRANSP.GetF(FLinkEdges) ) { P1_C_TRANSP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.5;
			P1_C_TRANSP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_UW_EVAP_u297_exe() {
	float value;

	switch( P1_C_UW_EVAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_UW_EVAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.5;
			P1_C_UW_EVAP.Update( p, value );
		}
		P1_C_UW_EVAP.GrabMemory();
		if( P1_C_UW_EVAP.GetF(FLinkEdges) ) { P1_C_UW_EVAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.5;
			P1_C_UW_EVAP.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_VERT_HYDR_COND_u298_exe() {
	float value;

	switch( P1_C_VERT_HYDR_COND.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_VERT_HYDR_COND.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.007;
			P1_C_VERT_HYDR_COND.Update( p, value );
		}
		P1_C_VERT_HYDR_COND.GrabMemory();
		if( P1_C_VERT_HYDR_COND.GetF(FLinkEdges) ) { P1_C_VERT_HYDR_COND.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.007;
			P1_C_VERT_HYDR_COND.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_C_ZIG_u299_exe() {
	float value;

	switch( P1_C_ZIG.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_ZIG.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)25);
			P1_C_ZIG.Update( p, value );
		}
		P1_C_ZIG.GrabMemory();
		if( P1_C_ZIG.GetF(FLinkEdges) ) { P1_C_ZIG.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)25);
			P1_C_ZIG.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_IC_SW_DEPTH_u300_exe() {
	float value;

	switch( P1_IC_SW_DEPTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_IC_SW_DEPTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_IC_SW_DEPTH.Update( p, value );
		}
		P1_IC_SW_DEPTH.GrabMemory();
		if( P1_IC_SW_DEPTH.GetF(FLinkEdges) ) { P1_IC_SW_DEPTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_IC_SW_DEPTH.Update( value );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_IC_UW_MOIST_PR_u301_exe() {
	float value;

	switch( P1_IC_UW_MOIST_PR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_IC_UW_MOIST_PR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.2;
			P1_IC_UW_MOIST_PR.Update( p, P1_IC_UW_MOIST_PR.ParameterValue(value,p) );
		}
		P1_IC_UW_MOIST_PR.GrabMemory();
		if( P1_IC_UW_MOIST_PR.GetF(FLinkEdges) ) { P1_IC_UW_MOIST_PR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.2;
			P1_IC_UW_MOIST_PR.Update( P1_IC_UW_MOIST_PR.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int HYDROLOGY_module::P1_IC_WT_TABLE_u302_exe() {
	float value;

	switch( P1_IC_WT_TABLE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_IC_WT_TABLE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)25);
			P1_IC_WT_TABLE.Update( p, value );
		}
		P1_IC_WT_TABLE.GrabMemory();
		if( P1_IC_WT_TABLE.GetF(FLinkEdges) ) { P1_IC_WT_TABLE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)25);
			P1_IC_WT_TABLE.Update( value );
	  } break;
	}
	return 0;
}

HYDROLOGY_module* HYDROLOGY_module::fInstance = NULL;
HYDROLOGY_module* HYDROLOGY_module::kNullModel = (HYDROLOGY_module*)0x1;
int HYDROLOGY_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int HYDROLOGY_module::InitVars() {
	
	TIME.SSInit(this);
	SURFACE_WATER.SSInit(this);
	SURFACE_WATER.SetLinkEdges();
	UW_DEPTH.SSInit(this);
	WATER_AVAIL.SSInit(this);
	ON_MAP.SSInit(this);
	ON_MAP.SetLinkEdges();
	DIN_SD.SSInit(this);
	DIN_SD.SetLinkEdges();
	HABITATMAP.SSInit(this);
	HABITATMAP.SetLinkEdges();
	AIR_TEMP_C.SSInit(this);
	PRECIP_M.SSInit(this);
	PRECIP_M.SetLinkEdges();
	HYDRO.SSInit(this);
	HYDRO.SetLinkEdges();
	ELEVATION.SSInit(this);
	ELEVATION.SetLinkEdges();
	DIN_SF.SSInit(this);
	DIN_SF.SetLinkEdges();
	CELL_SIZE.SSInit(this);
	SOLRADGRD.SSInit(this);
	MACLAI.SSInit(this);
	SOIL.SSInit(this);
	HUMIDITY.SSInit(this);
	WIND.SSInit(this);
	A_IN.SSInit(this);
	A_IN.SetLinkEdges();
	ELEV_MIN.SSInit(this);
	ETPM.SSInit(this);
	ROOT_DEPTH.SSInit(this);
	P1_DATUM_TO_MSL.SSInit(this);
	SAT_WATER.SSInit(this);
	SAT_WATER.SetLinkEdges();
	UNSAT_WATER.SSInit(this);
	UNSAT_WATER.SetLinkEdges();
	UW_FROM_PRECIP.SSInit(this);
	UW_FROM_PRECIP.SetDestination(&UNSAT_WATER);
	SW_TO_SATW_DOWNFLOW.SSInit(this);
	SW_TO_SATW_DOWNFLOW.SetOrigin(&SURFACE_WATER);
	SW_TO_SATW_DOWNFLOW.SetDestination(&SAT_WATER);
	SATW_FROM_PRECIP.SSInit(this);
	SATW_FROM_PRECIP.SetDestination(&SAT_WATER);
	SATW_TO_SW_UPFLOW.SSInit(this);
	SATW_TO_SW_UPFLOW.SetOrigin(&SAT_WATER);
	SATW_TO_SW_UPFLOW.SetDestination(&SURFACE_WATER);
	SATW_OUTFLUX.SSInit(this);
	SATW_OUTFLUX.SetOrigin(&SAT_WATER);
	SW_OUTFLUX.SSInit(this);
	SW_OUTFLUX.SetOrigin(&SURFACE_WATER);
	UW_SATW_EXCHANGE.SSInit(this);
	UW_SATW_EXCHANGE.SetOrigin(&UNSAT_WATER);
	UW_SATW_EXCHANGE.SetDestination(&SAT_WATER);
	SATW_RECHARGE.SSInit(this);
	SATW_RECHARGE.SetOrigin(&SAT_WATER);
	SATW_TRANSP.SSInit(this);
	SATW_TRANSP.SetOrigin(&SAT_WATER);
	SATW_UW.SSInit(this);
	SATW_UW.SetOrigin(&SAT_WATER);
	SATW_UW.SetDestination(&UNSAT_WATER);
	SNOW_ICE.SSInit(this);
	SNOWFALL.SSInit(this);
	SNOWFALL.SetDestination(&SNOW_ICE);
	SW_FREEZE.SSInit(this);
	SW_FREEZE.SetOrigin(&SURFACE_WATER);
	SW_FREEZE.SetDestination(&SNOW_ICE);
	SNOWMELT.SSInit(this);
	SNOWMELT.SetOrigin(&SNOW_ICE);
	SW_IN.SSInit(this);
	SW_IN.SetDestination(&SURFACE_WATER);
	SW_EVAP.SSInit(this);
	SW_EVAP.SetOrigin(&SURFACE_WATER);
	TOT_IN.SSInit(this);
	TOTAL_INFLOW.SSInit(this);
	TOTAL_INFLOW.SetLinkEdges();
	TOTAL_INFLOW.SetDestination(&TOT_IN);
	TOT_OUT.SSInit(this);
	TOTAL_OUTFLOW.SSInit(this);
	TOTAL_OUTFLOW.SetLinkEdges();
	TOTAL_OUTFLOW.SetDestination(&TOT_OUT);
	UW_ETRANSP.SSInit(this);
	UW_ETRANSP.SetOrigin(&UNSAT_WATER);
	BALANCE.SSInit(this);
	BALANCE.SetLinkEdges();
	EVAPORATION.SSInit(this);
	EVAP_UW.SSInit(this);
	H_CONDUCT.SSInit(this);
	H_CONDUCT.SetLinkEdges();
	IC_SATW.SSInit(this);
	IC_UW.SSInit(this);
	INFILTRATION.SSInit(this);
	INF_COND.SSInit(this);
	INTERCEPT.SSInit(this);
	NET_PRECIP.SSInit(this);
	OUT_F_SD.SSInit(this);
	OUT_F_SD.SetLinkEdges();
	OUT_F_SF.SSInit(this);
	OUT_F_SF.SetLinkEdges();
	PAN_CH.SSInit(this);
	PAN_CT.SSInit(this);
	PAN_CW.SSInit(this);
	POROSITY.SSInit(this);
	POROSITY.SetLinkEdges();
	POT_INFILTR.SSInit(this);
	POT_INFILTR.SetLinkEdges();
	RAINFALL.SSInit(this);
	SATWMAX.SSInit(this);
	SATWRUNOFF.SSInit(this);
	SATW_HEAD.SSInit(this);
	SW_FROM_PS.SSInit(this);
	TOTAL_OUT.SSInit(this);
	TOTAL_PRECIP.SSInit(this);
	TRANSPIRATION.SSInit(this);
	UNSAT_CAP.SSInit(this);
	UW_CAPIL_EXP.SSInit(this);
	UW_DELTA.SSInit(this);
	UW_DEPTH_BEFORE.SSInit(this);
	UW_EXCESS.SSInit(this);
	UW_MOIST_PRP.SSInit(this);
	UW_MP_R.SSInit(this);
	UW_PERC_RATE.SSInit(this);
	UW_TRANS_PR.SSInit(this);
	WAT_TABLE.SSInit(this);
	P1_C_EVAP.SSInit(this);
	P1_C_FIELD_CAP.SSInit(this);
	P1_C_HORIZ_HYDR_COND.SSInit(this);
	P1_C_INFILT.SSInit(this);
	P1_C_INF_HAB.SSInit(this);
	P1_C_INF_SLOPE.SSInit(this);
	P1_C_INF_SLOPE.SetLinkEdges();
	P1_C_INF_SOIL.SSInit(this);
	P1_C_INTERCEP.SSInit(this);
	P1_C_INTERCEPVEG.SSInit(this);
	P1_C_POROSITY.SSInit(this);
	P1_C_RECHG.SSInit(this);
	P1_C_SATW_OUT.SSInit(this);
	P1_C_SW_MELT.SSInit(this);
	P1_C_SW_OUT.SSInit(this);
	P1_C_TRANSP.SSInit(this);
	P1_C_UW_EVAP.SSInit(this);
	P1_C_VERT_HYDR_COND.SSInit(this);
	P1_C_ZIG.SSInit(this);
	P1_IC_SW_DEPTH.SSInit(this);
	P1_IC_UW_MOIST_PR.SSInit(this);
	P1_IC_WT_TABLE.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int HYDROLOGY_module::SetupEvents() {
	TExecuteCommand* I230 = (TExecuteCommand*) SURFACE_WATER.GetCommand("I230",TCommand::kIntegrate,TCommand::kCode);
	I230->SetExecutable(&SURFACE_WATER_I230_exe_g);
	I230->Code() = "I230 <- ( ( ( ( ( SW_IN+SATW_TO_SW_UPFLOW )-SW_EVAP )-SW_TO_SATW_DOWNFLOW )-SW_FREEZE )-SW_OUTFLUX )";
	I230->AddDependency(SW_IN);
	I230->AddDependency(SATW_TO_SW_UPFLOW);
	I230->AddDependency(SW_EVAP);
	I230->AddDependency(SW_TO_SATW_DOWNFLOW);
	I230->AddDependency(SW_FREEZE);
	I230->AddDependency(SW_OUTFLUX);
	I230->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i231 = (TExecuteCommand*) SURFACE_WATER.GetCommand("i231",TCommand::kInit,TCommand::kCode);
	i231->SetExecutable(&SURFACE_WATER_i231_exe_g);
	i231->Code() = "i231 <- P1_IC_SW_DEPTH";
	i231->AddDependency(P1_IC_SW_DEPTH);
	i231->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* vE434 = (TExecuteCommand*) SURFACE_WATER.GetCommand("vE434",TCommand::kFunction,TCommand::kCode);
	vE434->SetExecutable(&SURFACE_WATER_vE434_exe_g);
	vE434->Code() = "vE434 <- Function";
	vE434->GetFunction() = 'P';
	vE434->AddDependency(SURFACE_WATER);
	vE434->AddDependency(HYDRO);
	vE434->AddDependency(HABITATMAP);
	vE434->AddDependency(ELEVATION);
	vE434->AddDependency(P1_C_INF_SLOPE);
	vE434->AddDependency(DIN_SF);
	vE434->AddDependency(OUT_F_SF);
	vE434->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u273 = (TExecuteCommand*) UW_DEPTH.GetCommand("u273",TCommand::kUpdate,TCommand::kCode);
	u273->SetExecutable(&UW_DEPTH_u273_exe_g);
	u273->Code() = "u273 <- SL::Max(( ELEVATION-SATW_HEAD ), ((float)0))";
	u273->AddDependency(ELEVATION);
	u273->AddDependency(SATW_HEAD);
	u273->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u280 = (TExecuteCommand*) WATER_AVAIL.GetCommand("u280",TCommand::kUpdate,TCommand::kCode);
	u280->SetExecutable(&WATER_AVAIL_u280_exe_g);
	u280->Code() = "u280 <- SL::Min(1.0, ( UW_CAPIL_EXP+ ( ( ( UW_MOIST_PRP <  ( 0.1*P1_C_FIELD_CAP ) ) ) ? ( ((float)0) ) : (  ( ( ( UW_MOIST_PRP >  ( 0.6*P1_C_FIELD_CAP ) ) ) ? ( ((float)1) ) : ( ( ( ( UW_MOIST_PRP-( 0.1*P1_C_FIELD_CAP ) )/0.5 )/P1_C_FIELD_CAP ) ) )  ) )  ))";
	u280->AddDependency(UW_CAPIL_EXP);
	u280->AddDependency(UW_MOIST_PRP);
	u280->AddDependency(SOIL);
	u280->AddDependency(P1_C_FIELD_CAP);
	u280->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ON_MAP_import = (TImportCommand*) ON_MAP.GetCommand("ON_MAP_import",TCommand::kUndefined,TCommand::kImport);
	ON_MAP_import->Code() = "Import ON_MAP from GLOBALS_module";
	ON_MAP_import->AddDependency(ON_MAP);
	ON_MAP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DIN_SD_import = (TImportCommand*) DIN_SD.GetCommand("DIN_SD_import",TCommand::kUndefined,TCommand::kImport);
	DIN_SD_import->Code() = "Import DIN_SD from ZDIN_module";
	DIN_SD_import->AddDependency(DIN_SD);
	DIN_SD_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* HABITATMAP_import = (TImportCommand*) HABITATMAP.GetCommand("HABITATMAP_import",TCommand::kUndefined,TCommand::kImport);
	HABITATMAP_import->Code() = "Import HABITATMAP from GLOBALS_module";
	HABITATMAP_import->AddDependency(HABITATMAP);
	HABITATMAP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* AIR_TEMP_C_import = (TImportCommand*) AIR_TEMP_C.GetCommand("AIR_TEMP_C_import",TCommand::kUndefined,TCommand::kImport);
	AIR_TEMP_C_import->Code() = "Import AIR_TEMP_C from GLOBALS_module";
	AIR_TEMP_C_import->AddDependency(AIR_TEMP_C);
	AIR_TEMP_C_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PRECIP_M_import = (TImportCommand*) PRECIP_M.GetCommand("PRECIP_M_import",TCommand::kUndefined,TCommand::kImport);
	PRECIP_M_import->Code() = "Import PRECIP_M from GLOBALS_module";
	PRECIP_M_import->AddDependency(PRECIP_M);
	PRECIP_M_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* HYDRO_import = (TImportCommand*) HYDRO.GetCommand("HYDRO_import",TCommand::kUndefined,TCommand::kImport);
	HYDRO_import->Code() = "Import HYDRO from GLOBALS_module";
	HYDRO_import->AddDependency(HYDRO);
	HYDRO_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ELEVATION_import = (TImportCommand*) ELEVATION.GetCommand("ELEVATION_import",TCommand::kUndefined,TCommand::kImport);
	ELEVATION_import->Code() = "Import ELEVATION from GLOBALS_module";
	ELEVATION_import->AddDependency(ELEVATION);
	ELEVATION_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DIN_SF_import = (TImportCommand*) DIN_SF.GetCommand("DIN_SF_import",TCommand::kUndefined,TCommand::kImport);
	DIN_SF_import->Code() = "Import DIN_SF from ZDIN_module";
	DIN_SF_import->AddDependency(DIN_SF);
	DIN_SF_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CELL_SIZE_import = (TImportCommand*) CELL_SIZE.GetCommand("CELL_SIZE_import",TCommand::kUndefined,TCommand::kImport);
	CELL_SIZE_import->Code() = "Import CELL_SIZE from GLOBALS_module";
	CELL_SIZE_import->AddDependency(CELL_SIZE);
	CELL_SIZE_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SOLRADGRD_import = (TImportCommand*) SOLRADGRD.GetCommand("SOLRADGRD_import",TCommand::kUndefined,TCommand::kImport);
	SOLRADGRD_import->Code() = "Import SOLRADGRD from PAR_module";
	SOLRADGRD_import->AddDependency(SOLRADGRD);
	SOLRADGRD_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* MACLAI_import = (TImportCommand*) MACLAI.GetCommand("MACLAI_import",TCommand::kUndefined,TCommand::kImport);
	MACLAI_import->Code() = "Import MACLAI from MACROPHYTES_module";
	MACLAI_import->AddDependency(MACLAI);
	MACLAI_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SOIL_import = (TImportCommand*) SOIL.GetCommand("SOIL_import",TCommand::kUndefined,TCommand::kImport);
	SOIL_import->Code() = "Import SOIL from GLOBALS_module";
	SOIL_import->AddDependency(SOIL);
	SOIL_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* HUMIDITY_import = (TImportCommand*) HUMIDITY.GetCommand("HUMIDITY_import",TCommand::kUndefined,TCommand::kImport);
	HUMIDITY_import->Code() = "Import HUMIDITY from GLOBALS_module";
	HUMIDITY_import->AddDependency(HUMIDITY);
	HUMIDITY_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* WIND_import = (TImportCommand*) WIND.GetCommand("WIND_import",TCommand::kUndefined,TCommand::kImport);
	WIND_import->Code() = "Import WIND from GLOBALS_module";
	WIND_import->AddDependency(WIND);
	WIND_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* A_IN_import = (TImportCommand*) A_IN.GetCommand("A_IN_import",TCommand::kUndefined,TCommand::kImport);
	A_IN_import->Code() = "Import A_IN from ZDIN_module";
	A_IN_import->AddDependency(A_IN);
	A_IN_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ELEV_MIN_import = (TImportCommand*) ELEV_MIN.GetCommand("ELEV_MIN_import",TCommand::kUndefined,TCommand::kImport);
	ELEV_MIN_import->Code() = "Import ELEV_MIN from GLOBALS_module";
	ELEV_MIN_import->AddDependency(ELEV_MIN);
	ELEV_MIN_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ETPM_import = (TImportCommand*) ETPM.GetCommand("ETPM_import",TCommand::kUndefined,TCommand::kImport);
	ETPM_import->Code() = "Import ETPM from ETPM_module";
	ETPM_import->AddDependency(ETPM);
	ETPM_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ROOT_DEPTH_import = (TImportCommand*) ROOT_DEPTH.GetCommand("ROOT_DEPTH_import",TCommand::kUndefined,TCommand::kImport);
	ROOT_DEPTH_import->Code() = "Import ROOT_DEPTH from MACROPHYTES_module";
	ROOT_DEPTH_import->AddDependency(ROOT_DEPTH);
	ROOT_DEPTH_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_DATUM_TO_MSL_import = (TImportCommand*) P1_DATUM_TO_MSL.GetCommand("P1_DATUM_TO_MSL_import",TCommand::kUndefined,TCommand::kImport);
	P1_DATUM_TO_MSL_import->Code() = "Import P1_DATUM_TO_MSL from GLOBALS_module";
	P1_DATUM_TO_MSL_import->AddDependency(P1_DATUM_TO_MSL);
	P1_DATUM_TO_MSL_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I215 = (TExecuteCommand*) SAT_WATER.GetCommand("I215",TCommand::kIntegrate,TCommand::kCode);
	I215->SetExecutable(&SAT_WATER_I215_exe_g);
	I215->Code() = "I215 <- ( ( ( ( ( ( ( UW_SATW_EXCHANGE+SW_TO_SATW_DOWNFLOW )+SATW_FROM_PRECIP )-SATW_RECHARGE )-SATW_TRANSP )-SATW_TO_SW_UPFLOW )-SATW_OUTFLUX )-SATW_UW )";
	I215->AddDependency(UW_SATW_EXCHANGE);
	I215->AddDependency(SW_TO_SATW_DOWNFLOW);
	I215->AddDependency(SATW_FROM_PRECIP);
	I215->AddDependency(SATW_RECHARGE);
	I215->AddDependency(SATW_TRANSP);
	I215->AddDependency(SATW_TO_SW_UPFLOW);
	I215->AddDependency(SATW_OUTFLUX);
	I215->AddDependency(SATW_UW);
	I215->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i216 = (TExecuteCommand*) SAT_WATER.GetCommand("i216",TCommand::kInit,TCommand::kCode);
	i216->SetExecutable(&SAT_WATER_i216_exe_g);
	i216->Code() = "i216 <- IC_SATW";
	i216->AddDependency(IC_SATW);
	i216->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* vE433 = (TExecuteCommand*) SAT_WATER.GetCommand("vE433",TCommand::kFunction,TCommand::kCode);
	vE433->SetExecutable(&SAT_WATER_vE433_exe_g);
	vE433->Code() = "vE433 <- Function";
	vE433->GetFunction() = 'P';
	vE433->AddDependency(SAT_WATER);
	vE433->AddDependency(POROSITY);
	vE433->AddDependency(H_CONDUCT);
	vE433->AddDependency(ON_MAP);
	vE433->AddDependency(DIN_SD);
	vE433->AddDependency(UNSAT_WATER);
	vE433->AddDependency(OUT_F_SD);
	vE433->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* I241 = (TExecuteCommand*) UNSAT_WATER.GetCommand("I241",TCommand::kIntegrate,TCommand::kCode);
	I241->SetExecutable(&UNSAT_WATER_I241_exe_g);
	I241->Code() = "I241 <- ( ( ( UW_FROM_PRECIP+SATW_UW )-UW_SATW_EXCHANGE )-UW_ETRANSP )";
	I241->AddDependency(UW_FROM_PRECIP);
	I241->AddDependency(SATW_UW);
	I241->AddDependency(UW_SATW_EXCHANGE);
	I241->AddDependency(UW_ETRANSP);
	I241->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i242 = (TExecuteCommand*) UNSAT_WATER.GetCommand("i242",TCommand::kInit,TCommand::kCode);
	i242->SetExecutable(&UNSAT_WATER_i242_exe_g);
	i242->Code() = "i242 <- IC_UW";
	i242->AddDependency(IC_UW);
	i242->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u243 = (TExecuteCommand*) UW_FROM_PRECIP.GetCommand("u243",TCommand::kUpdate,TCommand::kCode);
	u243->SetExecutable(&UW_FROM_PRECIP_u243_exe_g);
	u243->Code() = "u243 <-  ( ( ( INF_COND >  ((float)0) ) ) ? ( INFILTRATION ) : ( ((float)0) ) ) ";
	u243->AddDependency(INF_COND);
	u243->AddDependency(INFILTRATION);
	u243->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u218 = (TExecuteCommand*) SW_TO_SATW_DOWNFLOW.GetCommand("u218",TCommand::kUpdate,TCommand::kCode);
	u218->SetExecutable(&SW_TO_SATW_DOWNFLOW_u218_exe_g);
	u218->Code() = "u218 <-  ( ( ( ( HABITATMAP == ((float)1) ) || ( ( UW_DEPTH_BEFORE == ((float)0) ) && ( UNSAT_CAP >  ((float)0) ) ) ) ) ? ( SL::Min(( UNSAT_CAP/dT() ), ( SURFACE_WATER/dT() )) ) : ( ((float)0) ) ) ";
	if( SW_TO_SATW_DOWNFLOW.GetF(FisClamped) ) { u218->AddDependency(SURFACE_WATER); }
	u218->AddDependency(HABITATMAP);
	u218->AddDependency(UW_DEPTH_BEFORE);
	u218->AddDependency(UNSAT_CAP);
	u218->AddDependency(SURFACE_WATER);
	u218->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u219 = (TExecuteCommand*) SATW_FROM_PRECIP.GetCommand("u219",TCommand::kUpdate,TCommand::kCode);
	u219->SetExecutable(&SATW_FROM_PRECIP_u219_exe_g);
	u219->Code() = "u219 <-  ( ( ( INF_COND == ((float)0) ) ) ? ( ( ( UNSAT_CAP/dT() )-SW_TO_SATW_DOWNFLOW ) ) : ( ((float)0) ) ) ";
	u219->AddDependency(INF_COND);
	u219->AddDependency(UNSAT_CAP);
	u219->AddDependency(SW_TO_SATW_DOWNFLOW);
	u219->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u222 = (TExecuteCommand*) SATW_TO_SW_UPFLOW.GetCommand("u222",TCommand::kUpdate,TCommand::kCode);
	u222->SetExecutable(&SATW_TO_SW_UPFLOW_u222_exe_g);
	u222->Code() = "u222 <-  ( ( ( SAT_WATER >  SATWMAX ) ) ? ( ( SAT_WATER-SATWMAX ) ) : (  ( ( ( SAT_WATER >  SATWRUNOFF ) ) ? ( ( ( P1_C_ZIG*( SAT_WATER-SATWRUNOFF ) )*H_CONDUCT ) ) : ( ((float)0) ) )  ) ) ";
	if( SATW_TO_SW_UPFLOW.GetF(FisClamped) ) { u222->AddDependency(SAT_WATER); }
	u222->AddDependency(SAT_WATER);
	u222->AddDependency(SATWMAX);
	u222->AddDependency(SATWRUNOFF);
	u222->AddDependency(HABITATMAP);
	u222->AddDependency(P1_C_ZIG);
	u222->AddDependency(H_CONDUCT);
	u222->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u223 = (TExecuteCommand*) SATW_OUTFLUX.GetCommand("u223",TCommand::kUpdate,TCommand::kCode);
	u223->SetExecutable(&SATW_OUTFLUX_u223_exe_g);
	u223->Code() = "u223 <- ( P1_C_SATW_OUT*( SAT_WATER-IC_SATW ) )";
	if( SATW_OUTFLUX.GetF(FisClamped) ) { u223->AddDependency(SAT_WATER); }
	u223->AddDependency(P1_C_SATW_OUT);
	u223->AddDependency(SAT_WATER);
	u223->AddDependency(IC_SATW);
	u223->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u234 = (TExecuteCommand*) SW_OUTFLUX.GetCommand("u234",TCommand::kUpdate,TCommand::kCode);
	u234->SetExecutable(&SW_OUTFLUX_u234_exe_g);
	u234->Code() = "u234 <- ( ( P1_C_SW_OUT*SURFACE_WATER )/dT() )";
	if( SW_OUTFLUX.GetF(FisClamped) ) { u234->AddDependency(SURFACE_WATER); }
	u234->AddDependency(P1_C_SW_OUT);
	u234->AddDependency(SURFACE_WATER);
	u234->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u217 = (TExecuteCommand*) UW_SATW_EXCHANGE.GetCommand("u217",TCommand::kUpdate,TCommand::kCode);
	u217->SetExecutable(&UW_SATW_EXCHANGE_u217_exe_g);
	u217->Code() = "u217 <-  ( ( ( INF_COND == ((float)0) ) ) ? ( ( UNSAT_WATER/dT() ) ) : ( SL::Min(( UNSAT_WATER/dT() ), ( ( SL::Max(((float)0), ( UW_DELTA*UW_MOIST_PRP ))/dT() )+UW_PERC_RATE )) ) ) ";
	if( UW_SATW_EXCHANGE.GetF(FisClamped) ) { u217->AddDependency(UNSAT_WATER); }
	u217->AddDependency(INF_COND);
	u217->AddDependency(UNSAT_WATER);
	u217->AddDependency(UW_DELTA);
	u217->AddDependency(UW_MOIST_PRP);
	u217->AddDependency(UW_PERC_RATE);
	u217->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u220 = (TExecuteCommand*) SATW_RECHARGE.GetCommand("u220",TCommand::kUpdate,TCommand::kCode);
	u220->SetExecutable(&SATW_RECHARGE_u220_exe_g);
	u220->Code() = "u220 <- P1_C_RECHG";
	if( SATW_RECHARGE.GetF(FisClamped) ) { u220->AddDependency(SAT_WATER); }
	u220->AddDependency(P1_C_RECHG);
	u220->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u221 = (TExecuteCommand*) SATW_TRANSP.GetCommand("u221",TCommand::kUpdate,TCommand::kCode);
	u221->SetExecutable(&SATW_TRANSP_u221_exe_g);
	u221->Code() = "u221 <- ( TRANSPIRATION*( ((float)1)-UW_TRANS_PR ) )";
	if( SATW_TRANSP.GetF(FisClamped) ) { u221->AddDependency(SAT_WATER); }
	u221->AddDependency(TRANSPIRATION);
	u221->AddDependency(UW_TRANS_PR);
	u221->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u224 = (TExecuteCommand*) SATW_UW.GetCommand("u224",TCommand::kUpdate,TCommand::kCode);
	u224->SetExecutable(&SATW_UW_u224_exe_g);
	u224->Code() = "u224 <- SL::Max(((float)0), SL::Min(( -UW_DELTA*P1_C_FIELD_CAP ), ( SAT_WATER/dT() )))";
	if( SATW_UW.GetF(FisClamped) ) { u224->AddDependency(SAT_WATER); }
	u224->AddDependency(UW_DELTA);
	u224->AddDependency(SOIL);
	u224->AddDependency(P1_C_FIELD_CAP);
	u224->AddDependency(SAT_WATER);
	u224->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I225 = (TExecuteCommand*) SNOW_ICE.GetCommand("I225",TCommand::kIntegrate,TCommand::kCode);
	I225->SetExecutable(&SNOW_ICE_I225_exe_g);
	I225->Code() = "I225 <- ( ( SNOWFALL+SW_FREEZE )-SNOWMELT )";
	I225->AddDependency(SNOWFALL);
	I225->AddDependency(SW_FREEZE);
	I225->AddDependency(SNOWMELT);
	I225->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i226 = (TExecuteCommand*) SNOW_ICE.GetCommand("i226",TCommand::kInit,TCommand::kCode);
	i226->SetExecutable(&SNOW_ICE_i226_exe_g);
	i226->Code() = "i226 <- ((float)0)";
	i226->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u227 = (TExecuteCommand*) SNOWFALL.GetCommand("u227",TCommand::kUpdate,TCommand::kCode);
	u227->SetExecutable(&SNOWFALL_u227_exe_g);
	u227->Code() = "u227 <-  ( ( ( AIR_TEMP_C <= ((float)0) ) ) ? ( PRECIP_M ) : ( ((float)0) ) ) ";
	u227->AddDependency(AIR_TEMP_C);
	u227->AddDependency(PRECIP_M);
	u227->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u228 = (TExecuteCommand*) SW_FREEZE.GetCommand("u228",TCommand::kUpdate,TCommand::kCode);
	u228->SetExecutable(&SW_FREEZE_u228_exe_g);
	u228->Code() = "u228 <-  ( ( ( AIR_TEMP_C >  ((float)0) ) ) ? ( ((float)0) ) : ( ( ( -AIR_TEMP_C*SURFACE_WATER )*P1_C_SW_MELT ) ) ) ";
	if( SW_FREEZE.GetF(FisClamped) ) { u228->AddDependency(SURFACE_WATER); }
	u228->AddDependency(AIR_TEMP_C);
	u228->AddDependency(SURFACE_WATER);
	u228->AddDependency(P1_C_SW_MELT);
	u228->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u229 = (TExecuteCommand*) SNOWMELT.GetCommand("u229",TCommand::kUpdate,TCommand::kCode);
	u229->SetExecutable(&SNOWMELT_u229_exe_g);
	u229->Code() = "u229 <-  ( ( ( AIR_TEMP_C >  ((float)0) ) ) ? ( SL::Min(( P1_C_SW_MELT*AIR_TEMP_C ), ( SNOW_ICE/dT() )) ) : ( ((float)0) ) ) ";
	if( SNOWMELT.GetF(FisClamped) ) { u229->AddDependency(SNOW_ICE); }
	u229->AddDependency(AIR_TEMP_C);
	u229->AddDependency(P1_C_SW_MELT);
	u229->AddDependency(SNOW_ICE);
	u229->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u232 = (TExecuteCommand*) SW_IN.GetCommand("u232",TCommand::kUpdate,TCommand::kCode);
	u232->SetExecutable(&SW_IN_u232_exe_g);
	u232->Code() = "u232 <- ( ( ( NET_PRECIP-UW_FROM_PRECIP )-SATW_FROM_PRECIP )+( ( SW_FROM_PS/CELL_SIZE )/10 ) )";
	u232->AddDependency(NET_PRECIP);
	u232->AddDependency(UW_FROM_PRECIP);
	u232->AddDependency(SATW_FROM_PRECIP);
	u232->AddDependency(SW_FROM_PS);
	u232->AddDependency(CELL_SIZE);
	u232->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u233 = (TExecuteCommand*) SW_EVAP.GetCommand("u233",TCommand::kUpdate,TCommand::kCode);
	u233->SetExecutable(&SW_EVAP_u233_exe_g);
	u233->Code() = "u233 <- SL::Min(SL::Max(EVAPORATION, ((float)0)), ( SURFACE_WATER/dT() ))";
	if( SW_EVAP.GetF(FisClamped) ) { u233->AddDependency(SURFACE_WATER); }
	u233->AddDependency(EVAPORATION);
	u233->AddDependency(SURFACE_WATER);
	u233->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I235 = (TExecuteCommand*) TOT_IN.GetCommand("I235",TCommand::kIntegrate,TCommand::kCode);
	I235->SetExecutable(&TOT_IN_I235_exe_g);
	I235->Code() = "I235 <- TOTAL_INFLOW";
	I235->AddDependency(TOTAL_INFLOW);
	I235->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i236 = (TExecuteCommand*) TOT_IN.GetCommand("i236",TCommand::kInit,TCommand::kCode);
	i236->SetExecutable(&TOT_IN_i236_exe_g);
	i236->Code() = "i236 <- ((float)0)";
	i236->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u237 = (TExecuteCommand*) TOTAL_INFLOW.GetCommand("u237",TCommand::kUpdate,TCommand::kCode);
	u237->SetExecutable(&TOTAL_INFLOW_u237_exe_g);
	u237->Code() = "u237 <- PRECIP_M";
	u237->AddDependency(PRECIP_M);
	u237->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I238 = (TExecuteCommand*) TOT_OUT.GetCommand("I238",TCommand::kIntegrate,TCommand::kCode);
	I238->SetExecutable(&TOT_OUT_I238_exe_g);
	I238->Code() = "I238 <- TOTAL_OUTFLOW";
	I238->AddDependency(TOTAL_OUTFLOW);
	I238->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i239 = (TExecuteCommand*) TOT_OUT.GetCommand("i239",TCommand::kInit,TCommand::kCode);
	i239->SetExecutable(&TOT_OUT_i239_exe_g);
	i239->Code() = "i239 <- ((float)0)";
	i239->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u240 = (TExecuteCommand*) TOTAL_OUTFLOW.GetCommand("u240",TCommand::kUpdate,TCommand::kCode);
	u240->SetExecutable(&TOTAL_OUTFLOW_u240_exe_g);
	u240->Code() = "u240 <- TOTAL_OUT";
	u240->AddDependency(TOTAL_OUT);
	u240->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u244 = (TExecuteCommand*) UW_ETRANSP.GetCommand("u244",TCommand::kUpdate,TCommand::kCode);
	u244->SetExecutable(&UW_ETRANSP_u244_exe_g);
	u244->Code() = "u244 <- ( ( TRANSPIRATION*UW_TRANS_PR )+EVAP_UW )";
	if( UW_ETRANSP.GetF(FisClamped) ) { u244->AddDependency(UNSAT_WATER); }
	u244->AddDependency(TRANSPIRATION);
	u244->AddDependency(UW_TRANS_PR);
	u244->AddDependency(EVAP_UW);
	u244->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u245 = (TExecuteCommand*) BALANCE.GetCommand("u245",TCommand::kUpdate,TCommand::kCode);
	u245->SetExecutable(&BALANCE_u245_exe_g);
	u245->Code() = "u245 <- ( ( ( ( ( SAT_WATER+SNOW_ICE )+SURFACE_WATER )+UNSAT_WATER )-TOT_IN )+TOT_OUT )";
	u245->AddDependency(SAT_WATER);
	u245->AddDependency(SNOW_ICE);
	u245->AddDependency(SURFACE_WATER);
	u245->AddDependency(UNSAT_WATER);
	u245->AddDependency(TOT_IN);
	u245->AddDependency(TOT_OUT);
	u245->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u246 = (TExecuteCommand*) EVAPORATION.GetCommand("u246",TCommand::kUpdate,TCommand::kCode);
	u246->SetExecutable(&EVAPORATION_u246_exe_g);
	u246->Code() = "u246 <- ( ( ( ( ( P1_C_EVAP*SOLRADGRD )/585 )*PAN_CW )*PAN_CT )*PAN_CH )";
	u246->AddDependency(HABITATMAP);
	u246->AddDependency(P1_C_EVAP);
	u246->AddDependency(SOLRADGRD);
	u246->AddDependency(PAN_CW);
	u246->AddDependency(PAN_CT);
	u246->AddDependency(PAN_CH);
	u246->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u247 = (TExecuteCommand*) EVAP_UW.GetCommand("u247",TCommand::kUpdate,TCommand::kCode);
	u247->SetExecutable(&EVAP_UW_u247_exe_g);
	u247->Code() = "u247 <- ( ( ( P1_C_UW_EVAP*EVAPORATION )*( ((float)1)-SL::Min(((float)1), MACLAI) ) )*UW_MP_R )";
	u247->AddDependency(HABITATMAP);
	u247->AddDependency(P1_C_UW_EVAP);
	u247->AddDependency(EVAPORATION);
	u247->AddDependency(MACLAI);
	u247->AddDependency(UW_MP_R);
	u247->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u248 = (TExecuteCommand*) H_CONDUCT.GetCommand("u248",TCommand::kUpdate,TCommand::kCode);
	u248->SetExecutable(&H_CONDUCT_u248_exe_g);
	u248->Code() = "u248 <- ( ( P1_C_HORIZ_HYDR_COND/SL::Sqrt(CELL_SIZE) )+( SOIL*0.0 ) )";
	u248->AddDependency(SOIL);
	u248->AddDependency(P1_C_HORIZ_HYDR_COND);
	u248->AddDependency(CELL_SIZE);
	u248->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u249 = (TExecuteCommand*) IC_SATW.GetCommand("u249",TCommand::kUpdate,TCommand::kCode);
	u249->SetExecutable(&IC_SATW_u249_exe_g);
	u249->Code() = "u249 <- ( WAT_TABLE*P1_C_POROSITY )";
	u249->AddDependency(WAT_TABLE);
	u249->AddDependency(SOIL);
	u249->AddDependency(P1_C_POROSITY);
	u249->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u250 = (TExecuteCommand*) IC_UW.GetCommand("u250",TCommand::kUpdate,TCommand::kCode);
	u250->SetExecutable(&IC_UW_u250_exe_g);
	u250->Code() = "u250 <-  ( ( ( ELEVATION >  WAT_TABLE ) ) ? ( ( ( ELEVATION-WAT_TABLE )*P1_IC_UW_MOIST_PR ) ) : ( ((float)0) ) ) ";
	u250->AddDependency(ELEVATION);
	u250->AddDependency(WAT_TABLE);
	u250->AddDependency(P1_IC_UW_MOIST_PR);
	u250->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u251 = (TExecuteCommand*) INFILTRATION.GetCommand("u251",TCommand::kUpdate,TCommand::kCode);
	u251->SetExecutable(&INFILTRATION_u251_exe_g);
	u251->Code() = "u251 <- SL::Min(POT_INFILTR, NET_PRECIP)";
	u251->AddDependency(POT_INFILTR);
	u251->AddDependency(NET_PRECIP);
	u251->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u252 = (TExecuteCommand*) INF_COND.GetCommand("u252",TCommand::kUpdate,TCommand::kCode);
	u252->SetExecutable(&INF_COND_u252_exe_g);
	u252->Code() = "u252 <-  ( ( ( ( SW_TO_SATW_DOWNFLOW*dT() ) == UNSAT_CAP ) ) ? ( ((float)0) ) : ( SL::Max(( UNSAT_CAP-( INFILTRATION*dT() ) ), ((float)0)) ) ) ";
	u252->AddDependency(SW_TO_SATW_DOWNFLOW);
	u252->AddDependency(UNSAT_CAP);
	u252->AddDependency(INFILTRATION);
	u252->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u253 = (TExecuteCommand*) INTERCEPT.GetCommand("u253",TCommand::kUpdate,TCommand::kCode);
	u253->SetExecutable(&INTERCEPT_u253_exe_g);
	u253->Code() = "u253 <- SL::Min(TOTAL_PRECIP, SL::Max(( P1_C_INTERCEP*TOTAL_PRECIP ), ( P1_C_INTERCEPVEG*MACLAI )))";
	u253->AddDependency(TOTAL_PRECIP);
	u253->AddDependency(HABITATMAP);
	u253->AddDependency(P1_C_INTERCEP);
	u253->AddDependency(P1_C_INTERCEPVEG);
	u253->AddDependency(MACLAI);
	u253->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u254 = (TExecuteCommand*) NET_PRECIP.GetCommand("u254",TCommand::kUpdate,TCommand::kCode);
	u254->SetExecutable(&NET_PRECIP_u254_exe_g);
	u254->Code() = "u254 <- ( TOTAL_PRECIP-INTERCEPT )";
	u254->AddDependency(TOTAL_PRECIP);
	u254->AddDependency(INTERCEPT);
	u254->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u255 = (TExecuteCommand*) OUT_F_SD.GetCommand("u255",TCommand::kUpdate,TCommand::kCode);
	u255->SetExecutable(&OUT_F_SD_u255_exe_g);
	u255->Code() = "u255 <- ((float)0)";
	u255->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u256 = (TExecuteCommand*) OUT_F_SF.GetCommand("u256",TCommand::kUpdate,TCommand::kCode);
	u256->SetExecutable(&OUT_F_SF_u256_exe_g);
	u256->Code() = "u256 <- ((float)0)";
	u256->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u257 = (TExecuteCommand*) PAN_CH.GetCommand("u257",TCommand::kUpdate,TCommand::kCode);
	u257->SetExecutable(&PAN_CH_u257_exe_g);
	u257->Code() = "u257 <- ( ( 1.035+( 0.240*pow((double)( HUMIDITY/60 ),(double)((float)2) ) ) )-( 0.275*pow((double)( HUMIDITY/60 ),(double)((float)3) ) ) )";
	u257->AddDependency(HUMIDITY);
	u257->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u258 = (TExecuteCommand*) PAN_CT.GetCommand("u258",TCommand::kUpdate,TCommand::kCode);
	u258->SetExecutable(&PAN_CT_u258_exe_g);
	u258->Code() = "u258 <-  ( ( ( AIR_TEMP_C >  -((float)30) ) ) ? ( ( ( 0.463+( 0.425*( AIR_TEMP_C/20 ) ) )+( 0.112*pow((double)( AIR_TEMP_C/20 ),(double)((float)2) ) ) ) ) : ( ((float)0) ) ) ";
	u258->AddDependency(AIR_TEMP_C);
	u258->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u259 = (TExecuteCommand*) PAN_CW.GetCommand("u259",TCommand::kUpdate,TCommand::kCode);
	u259->SetExecutable(&PAN_CW_u259_exe_g);
	u259->Code() = "u259 <- ( ( 0.672+( 0.406*( WIND/6.7 ) ) )+( 0.078*pow((double)( WIND/6.7 ),(double)((float)2) ) ) )";
	u259->AddDependency(WIND);
	u259->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u260 = (TExecuteCommand*) POROSITY.GetCommand("u260",TCommand::kUpdate,TCommand::kCode);
	u260->SetExecutable(&POROSITY_u260_exe_g);
	u260->Code() = "u260 <- ( P1_C_POROSITY+( SOIL*0.0 ) )";
	u260->AddDependency(SOIL);
	u260->AddDependency(P1_C_POROSITY);
	u260->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u261 = (TExecuteCommand*) POT_INFILTR.GetCommand("u261",TCommand::kUpdate,TCommand::kCode);
	u261->SetExecutable(&POT_INFILTR_u261_exe_g);
	u261->Code() = "u261 <- ( ( ( P1_C_INFILT*P1_C_INF_HAB )*P1_C_INF_SOIL )/ ( ( ( P1_C_INF_SLOPE >  ((float)0) ) ) ? ( P1_C_INF_SOIL ) : ( ((float)1) ) )  )";
	u261->AddDependency(P1_C_INFILT);
	u261->AddDependency(HABITATMAP);
	u261->AddDependency(P1_C_INF_HAB);
	u261->AddDependency(SOIL);
	u261->AddDependency(P1_C_INF_SOIL);
	u261->AddDependency(P1_C_INF_SLOPE);
	u261->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* v435 = (TExecuteCommand*) POT_INFILTR.GetCommand("v435",TCommand::kFunction,TCommand::kCode);
	v435->SetExecutable(&POT_INFILTR_v435_exe_g);
	v435->Code() = "v435 <- Function";
	v435->GetFunction() = 'P';
	v435->AddDependency(POT_INFILTR);
	v435->AddDependency(PRECIP_M);
	v435->AddDependency(TOTAL_INFLOW);
	v435->AddDependency(TOTAL_OUTFLOW);
	v435->AddDependency(BALANCE);
	v435->AddDependency(A_IN);
	v435->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u262 = (TExecuteCommand*) RAINFALL.GetCommand("u262",TCommand::kUpdate,TCommand::kCode);
	u262->SetExecutable(&RAINFALL_u262_exe_g);
	u262->Code() = "u262 <-  ( ( ( AIR_TEMP_C >  ((float)0) ) ) ? ( PRECIP_M ) : ( ((float)0) ) ) ";
	u262->AddDependency(AIR_TEMP_C);
	u262->AddDependency(PRECIP_M);
	u262->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u263 = (TExecuteCommand*) SATWMAX.GetCommand("u263",TCommand::kUpdate,TCommand::kCode);
	u263->SetExecutable(&SATWMAX_u263_exe_g);
	u263->Code() = "u263 <- ( ELEVATION*P1_C_POROSITY )";
	u263->AddDependency(ELEVATION);
	u263->AddDependency(SOIL);
	u263->AddDependency(P1_C_POROSITY);
	u263->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u264 = (TExecuteCommand*) SATWRUNOFF.GetCommand("u264",TCommand::kUpdate,TCommand::kCode);
	u264->SetExecutable(&SATWRUNOFF_u264_exe_g);
	u264->Code() = "u264 <- ( ELEV_MIN*P1_C_POROSITY )";
	u264->AddDependency(ELEV_MIN);
	u264->AddDependency(SOIL);
	u264->AddDependency(P1_C_POROSITY);
	u264->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u265 = (TExecuteCommand*) SATW_HEAD.GetCommand("u265",TCommand::kUpdate,TCommand::kCode);
	u265->SetExecutable(&SATW_HEAD_u265_exe_g);
	u265->Code() = "u265 <- ( SAT_WATER/P1_C_POROSITY )";
	u265->AddDependency(SAT_WATER);
	u265->AddDependency(SOIL);
	u265->AddDependency(P1_C_POROSITY);
	u265->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u266 = (TExecuteCommand*) SW_FROM_PS.GetCommand("u266",TCommand::kUpdate,TCommand::kCode);
	u266->SetExecutable(&SW_FROM_PS_u266_exe_g);
	u266->Code() = "u266 <- ((float)0)";
	u266->SetObjInfo(TCommand::kDepIndex, 5);
	TImportCommand* SW_FROM_PS_import = (TImportCommand*) SW_FROM_PS.GetCommand("SW_FROM_PS_import",TCommand::kUndefined,TCommand::kImport);
	SW_FROM_PS_import->Code() = "Import SW_FROM_PS from external";
	SW_FROM_PS_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u267 = (TExecuteCommand*) TOTAL_OUT.GetCommand("u267",TCommand::kUpdate,TCommand::kCode);
	u267->SetExecutable(&TOTAL_OUT_u267_exe_g);
	u267->Code() = "u267 <- ( ( ( ( ( ( INTERCEPT+SATW_OUTFLUX )+SATW_RECHARGE )+SATW_TRANSP )+SW_EVAP )+SW_OUTFLUX )+UW_ETRANSP )";
	u267->AddDependency(INTERCEPT);
	u267->AddDependency(SATW_OUTFLUX);
	u267->AddDependency(SATW_RECHARGE);
	u267->AddDependency(SATW_TRANSP);
	u267->AddDependency(SW_EVAP);
	u267->AddDependency(SW_OUTFLUX);
	u267->AddDependency(UW_ETRANSP);
	u267->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u268 = (TExecuteCommand*) TOTAL_PRECIP.GetCommand("u268",TCommand::kUpdate,TCommand::kCode);
	u268->SetExecutable(&TOTAL_PRECIP_u268_exe_g);
	u268->Code() = "u268 <- ( RAINFALL+SNOWMELT )";
	u268->AddDependency(RAINFALL);
	u268->AddDependency(SNOWMELT);
	u268->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u269 = (TExecuteCommand*) TRANSPIRATION.GetCommand("u269",TCommand::kUpdate,TCommand::kCode);
	u269->SetExecutable(&TRANSPIRATION_u269_exe_g);
	u269->Code() = "u269 <- ( ( ( P1_C_TRANSP*SL::Min(((float)1), MACLAI) )*ETPM )*WATER_AVAIL )";
	u269->AddDependency(HABITATMAP);
	u269->AddDependency(P1_C_TRANSP);
	u269->AddDependency(MACLAI);
	u269->AddDependency(ETPM);
	u269->AddDependency(WATER_AVAIL);
	u269->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u270 = (TExecuteCommand*) UNSAT_CAP.GetCommand("u270",TCommand::kUpdate,TCommand::kCode);
	u270->SetExecutable(&UNSAT_CAP_u270_exe_g);
	u270->Code() = "u270 <- SL::Max(( UW_DEPTH*( P1_C_POROSITY-UW_MOIST_PRP ) ), ((float)0))";
	u270->AddDependency(UW_DEPTH);
	u270->AddDependency(SOIL);
	u270->AddDependency(P1_C_POROSITY);
	u270->AddDependency(UW_MOIST_PRP);
	u270->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u271 = (TExecuteCommand*) UW_CAPIL_EXP.GetCommand("u271",TCommand::kUpdate,TCommand::kCode);
	u271->SetExecutable(&UW_CAPIL_EXP_u271_exe_g);
	u271->Code() = "u271 <- SL::Exp(( -((float)10)*SL::Max(( UW_DEPTH-ROOT_DEPTH ), ((float)0)) ))";
	u271->AddDependency(UW_DEPTH);
	u271->AddDependency(ROOT_DEPTH);
	u271->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u272 = (TExecuteCommand*) UW_DELTA.GetCommand("u272",TCommand::kUpdate,TCommand::kCode);
	u272->SetExecutable(&UW_DELTA_u272_exe_g);
	u272->Code() = "u272 <- ( UW_DEPTH_BEFORE-UW_DEPTH )";
	u272->AddDependency(UW_DEPTH_BEFORE);
	u272->AddDependency(UW_DEPTH);
	u272->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u274 = (TExecuteCommand*) UW_DEPTH_BEFORE.GetCommand("u274",TCommand::kUpdate,TCommand::kCode);
	u274->SetExecutable(&UW_DEPTH_BEFORE_u274_exe_g);
	u274->Code() = "u274 <- UW_DEPTH.Delay( dT() )";
	u274->AddDependency(UW_DEPTH);
	u274->SetObjInfo(TCommand::kDepIndex, 2);
	TExecuteCommand* u275 = (TExecuteCommand*) UW_EXCESS.GetCommand("u275",TCommand::kUpdate,TCommand::kCode);
	u275->SetExecutable(&UW_EXCESS_u275_exe_g);
	u275->Code() = "u275 <- SL::Max(((float)0), ( UW_MOIST_PRP-P1_C_FIELD_CAP ))";
	u275->AddDependency(UW_MOIST_PRP);
	u275->AddDependency(SOIL);
	u275->AddDependency(P1_C_FIELD_CAP);
	u275->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u276 = (TExecuteCommand*) UW_MOIST_PRP.GetCommand("u276",TCommand::kUpdate,TCommand::kCode);
	u276->SetExecutable(&UW_MOIST_PRP_u276_exe_g);
	u276->Code() = "u276 <-  ( ( ( UW_DEPTH >  ((float)0) ) ) ? ( ( UNSAT_WATER/UW_DEPTH ) ) : ( ((float)0) ) ) ";
	u276->AddDependency(UW_DEPTH);
	u276->AddDependency(UNSAT_WATER);
	u276->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u277 = (TExecuteCommand*) UW_MP_R.GetCommand("u277",TCommand::kUpdate,TCommand::kCode);
	u277->SetExecutable(&UW_MP_R_u277_exe_g);
	u277->Code() = "u277 <- ( UW_MOIST_PRP/P1_C_POROSITY )";
	u277->AddDependency(UW_MOIST_PRP);
	u277->AddDependency(SOIL);
	u277->AddDependency(P1_C_POROSITY);
	u277->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u278 = (TExecuteCommand*) UW_PERC_RATE.GetCommand("u278",TCommand::kUpdate,TCommand::kCode);
	u278->SetExecutable(&UW_PERC_RATE_u278_exe_g);
	u278->Code() = "u278 <- ( ( ( ( ((float)2)*P1_C_VERT_HYDR_COND )*P1_C_POROSITY )*pow((double)UW_EXCESS,(double)0.4 ) )/( pow((double)( P1_C_POROSITY-P1_C_FIELD_CAP ),(double)0.4 )+pow((double)UW_EXCESS,(double)0.4 ) ) )";
	u278->AddDependency(SOIL);
	u278->AddDependency(P1_C_VERT_HYDR_COND);
	u278->AddDependency(P1_C_POROSITY);
	u278->AddDependency(UW_EXCESS);
	u278->AddDependency(P1_C_FIELD_CAP);
	u278->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u279 = (TExecuteCommand*) UW_TRANS_PR.GetCommand("u279",TCommand::kUpdate,TCommand::kCode);
	u279->SetExecutable(&UW_TRANS_PR_u279_exe_g);
	u279->Code() = "u279 <-  ( ( ( ( ROOT_DEPTH+0.1 ) <  UW_DEPTH ) ) ? ( ((float)1) ) : (  ( ( ( UW_DEPTH >  ((float)0) ) ) ? ( ( WATER_AVAIL*( UW_DEPTH/( ROOT_DEPTH+UW_CAPIL_EXP ) ) ) ) : ( ((float)0) ) )  ) ) ";
	u279->AddDependency(ROOT_DEPTH);
	u279->AddDependency(UW_DEPTH);
	u279->AddDependency(WATER_AVAIL);
	u279->AddDependency(UW_CAPIL_EXP);
	u279->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u281 = (TExecuteCommand*) WAT_TABLE.GetCommand("u281",TCommand::kUpdate,TCommand::kCode);
	u281->SetExecutable(&WAT_TABLE_u281_exe_g);
	u281->Code() = "u281 <- ( P1_IC_WT_TABLE+P1_DATUM_TO_MSL )";
	u281->AddDependency(P1_IC_WT_TABLE);
	u281->AddDependency(P1_DATUM_TO_MSL);
	u281->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u282 = (TExecuteCommand*) P1_C_EVAP.GetCommand("u282",TCommand::kUpdate,TCommand::kCode);
	u282->SetExecutable(&P1_C_EVAP_u282_exe_g);
	u282->Code() = "u282 <- 0.000482";
	u282->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u283 = (TExecuteCommand*) P1_C_FIELD_CAP.GetCommand("u283",TCommand::kUpdate,TCommand::kCode);
	u283->SetExecutable(&P1_C_FIELD_CAP_u283_exe_g);
	u283->Code() = "u283 <- 0.25";
	u283->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u284 = (TExecuteCommand*) P1_C_HORIZ_HYDR_COND.GetCommand("u284",TCommand::kUpdate,TCommand::kCode);
	u284->SetExecutable(&P1_C_HORIZ_HYDR_COND_u284_exe_g);
	u284->Code() = "u284 <- ((float)5)";
	u284->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u285 = (TExecuteCommand*) P1_C_INFILT.GetCommand("u285",TCommand::kUpdate,TCommand::kCode);
	u285->SetExecutable(&P1_C_INFILT_u285_exe_g);
	u285->Code() = "u285 <- 0.055";
	u285->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u286 = (TExecuteCommand*) P1_C_INF_HAB.GetCommand("u286",TCommand::kUpdate,TCommand::kCode);
	u286->SetExecutable(&P1_C_INF_HAB_u286_exe_g);
	u286->Code() = "u286 <- ((float)1)";
	u286->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u287 = (TExecuteCommand*) P1_C_INF_SLOPE.GetCommand("u287",TCommand::kUpdate,TCommand::kCode);
	u287->SetExecutable(&P1_C_INF_SLOPE_u287_exe_g);
	u287->Code() = "u287 <- ((float)5)";
	u287->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u288 = (TExecuteCommand*) P1_C_INF_SOIL.GetCommand("u288",TCommand::kUpdate,TCommand::kCode);
	u288->SetExecutable(&P1_C_INF_SOIL_u288_exe_g);
	u288->Code() = "u288 <- 4.00";
	u288->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u289 = (TExecuteCommand*) P1_C_INTERCEP.GetCommand("u289",TCommand::kUpdate,TCommand::kCode);
	u289->SetExecutable(&P1_C_INTERCEP_u289_exe_g);
	u289->Code() = "u289 <- 0.002";
	u289->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u290 = (TExecuteCommand*) P1_C_INTERCEPVEG.GetCommand("u290",TCommand::kUpdate,TCommand::kCode);
	u290->SetExecutable(&P1_C_INTERCEPVEG_u290_exe_g);
	u290->Code() = "u290 <- 0.001";
	u290->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u291 = (TExecuteCommand*) P1_C_POROSITY.GetCommand("u291",TCommand::kUpdate,TCommand::kCode);
	u291->SetExecutable(&P1_C_POROSITY_u291_exe_g);
	u291->Code() = "u291 <- 0.41";
	u291->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u292 = (TExecuteCommand*) P1_C_RECHG.GetCommand("u292",TCommand::kUpdate,TCommand::kCode);
	u292->SetExecutable(&P1_C_RECHG_u292_exe_g);
	u292->Code() = "u292 <- 0.0001";
	u292->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u293 = (TExecuteCommand*) P1_C_SATW_OUT.GetCommand("u293",TCommand::kUpdate,TCommand::kCode);
	u293->SetExecutable(&P1_C_SATW_OUT_u293_exe_g);
	u293->Code() = "u293 <- 0.";
	u293->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u294 = (TExecuteCommand*) P1_C_SW_MELT.GetCommand("u294",TCommand::kUpdate,TCommand::kCode);
	u294->SetExecutable(&P1_C_SW_MELT_u294_exe_g);
	u294->Code() = "u294 <- 0.005";
	u294->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u295 = (TExecuteCommand*) P1_C_SW_OUT.GetCommand("u295",TCommand::kUpdate,TCommand::kCode);
	u295->SetExecutable(&P1_C_SW_OUT_u295_exe_g);
	u295->Code() = "u295 <- 0.";
	u295->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u296 = (TExecuteCommand*) P1_C_TRANSP.GetCommand("u296",TCommand::kUpdate,TCommand::kCode);
	u296->SetExecutable(&P1_C_TRANSP_u296_exe_g);
	u296->Code() = "u296 <- 0.5";
	u296->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u297 = (TExecuteCommand*) P1_C_UW_EVAP.GetCommand("u297",TCommand::kUpdate,TCommand::kCode);
	u297->SetExecutable(&P1_C_UW_EVAP_u297_exe_g);
	u297->Code() = "u297 <- 0.5";
	u297->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u298 = (TExecuteCommand*) P1_C_VERT_HYDR_COND.GetCommand("u298",TCommand::kUpdate,TCommand::kCode);
	u298->SetExecutable(&P1_C_VERT_HYDR_COND_u298_exe_g);
	u298->Code() = "u298 <- 0.007";
	u298->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u299 = (TExecuteCommand*) P1_C_ZIG.GetCommand("u299",TCommand::kUpdate,TCommand::kCode);
	u299->SetExecutable(&P1_C_ZIG_u299_exe_g);
	u299->Code() = "u299 <- ((float)25)";
	u299->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u300 = (TExecuteCommand*) P1_IC_SW_DEPTH.GetCommand("u300",TCommand::kUpdate,TCommand::kCode);
	u300->SetExecutable(&P1_IC_SW_DEPTH_u300_exe_g);
	u300->Code() = "u300 <- ((float)0)";
	u300->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u301 = (TExecuteCommand*) P1_IC_UW_MOIST_PR.GetCommand("u301",TCommand::kUpdate,TCommand::kCode);
	u301->SetExecutable(&P1_IC_UW_MOIST_PR_u301_exe_g);
	u301->Code() = "u301 <- 0.2";
	u301->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u302 = (TExecuteCommand*) P1_IC_WT_TABLE.GetCommand("u302",TCommand::kUpdate,TCommand::kCode);
	u302->SetExecutable(&P1_IC_WT_TABLE_u302_exe_g);
	u302->Code() = "u302 <- ((float)25)";
	u302->SetObjInfo(TCommand::kDepIndex, 5);
	return 0;
}

int HYDROLOGY_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int HYDROLOGY_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int HYDROLOGY_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int HYDROLOGY_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class ZDIN_module 
// ---------------------------------------------------------------------------
ZDIN_module::ZDIN_module(char* name) :
	TIME("TIME"),
	DIN_AVAILABLE("DIN_AVAILABLE"),
	DIN_SD("DIN_SD"),
	DIN_SF("DIN_SF"),
	A_IN("A_IN"),
	SAT_WATER("SAT_WATER"),
	UNSAT_WATER("UNSAT_WATER"),
	UW_FROM_PRECIP("UW_FROM_PRECIP"),
	SW_TO_SATW_DOWNFLOW("SW_TO_SATW_DOWNFLOW"),
	SATW_FROM_PRECIP("SATW_FROM_PRECIP"),
	CELL_SIZE("CELL_SIZE"),
	AIR_TEMP_C("AIR_TEMP_C"),
	SATW_TO_SW_UPFLOW("SATW_TO_SW_UPFLOW"),
	PHBIO_NPP("PHBIO_NPP"),
	UW_DEPTH("UW_DEPTH"),
	ELEVATION("ELEVATION"),
	SATW_OUTFLUX("SATW_OUTFLUX"),
	SW_OUTFLUX("SW_OUTFLUX"),
	DAYJUL("DAYJUL"),
	HABITATMAP("HABITATMAP"),
	ROOT_DEPTH("ROOT_DEPTH"),
	SURFACE_WATER("SURFACE_WATER"),
	D_DECOMP("D_DECOMP"),
	P1_SEWERMAP("P1_SEWERMAP"),
	P1_POP_DENS("P1_POP_DENS"),
	ATM_FLOW("ATM_FLOW"),
	DIN_DNFLOW("DIN_DNFLOW"),
	FROM_PS_DINSD("FROM_PS_DINSD"),
	DOM_TO_DINSD("DOM_TO_DINSD"),
	DINSD_DENIT("DINSD_DENIT"),
	DIN_UPFLOW("DIN_UPFLOW"),
	DINSD_UPTAKE("DINSD_UPTAKE"),
	DINSD_HOUT("DINSD_HOUT"),
	FROM_ATMOS("FROM_ATMOS"),
	DOM_TO_DINSF("DOM_TO_DINSF"),
	FERT_AV("FERT_AV"),
	FROM_PS("FROM_PS"),
	DINSF_UPTAKE("DINSF_UPTAKE"),
	DINSF_OUT("DINSF_OUT"),
	FERTILIZER("FERTILIZER"),
	FROM_FERT("FROM_FERT"),
	F_IN("F_IN"),
	FERT_FLOW("FERT_FLOW"),
	M_IN("M_IN"),
	MINER_FLOW("MINER_FLOW"),
	S_IN("S_IN"),
	SEPTIC_FLOW("SEPTIC_FLOW"),
	COUNTY("COUNTY"),
	CROP("CROP"),
	DINSD_AVAIL("DINSD_AVAIL"),
	DINSD_CONC("DINSD_CONC"),
	DINSD_PR1("DINSD_PR1"),
	DINSD_PR2("DINSD_PR2"),
	DINSD_PR3("DINSD_PR3"),
	DINSF_AVAIL("DINSF_AVAIL"),
	DINSF_CONC("DINSF_CONC"),
	DINSF_PR1("DINSF_PR1"),
	DINSF_PR2("DINSF_PR2"),
	DOM_TO_DIN("DOM_TO_DIN"),
	N_NPOINTSD("N_NPOINTSD"),
	OUTPUTCOL("OUTPUTCOL"),
	OUTPUTROW("OUTPUTROW"),
	OUTPUTVAR("OUTPUTVAR"),
	SR_WATER("SR_WATER"),
	ZONMAP("ZONMAP"),
	P1_ATMOS_FACTOR("P1_ATMOS_FACTOR"),
	P1_DINSD_OUT("P1_DINSD_OUT"),
	P1_DINSF_OUT("P1_DINSF_OUT"),
	P1_DIN_CR_SED_MIN("P1_DIN_CR_SED_MIN"),
	P1_DIN_DAY_FERT1("P1_DIN_DAY_FERT1"),
	P1_DIN_DAY_FERT2("P1_DIN_DAY_FERT2"),
	P1_DIN_DIFFCOEF("P1_DIN_DIFFCOEF"),
	P1_DIN_FERT_APP("P1_DIN_FERT_APP"),
	P1_DIN_FERT_DIS("P1_DIN_FERT_DIS"),
	P1_DIN_FERT_HAB1("P1_DIN_FERT_HAB1"),
	P1_DIN_FERT_HAB2("P1_DIN_FERT_HAB2"),
	P1_DIN_GRAD("P1_DIN_GRAD"),
	P1_DIN_ICSED("P1_DIN_ICSED"),
	P1_DIN_ICSF("P1_DIN_ICSF"),
	P1_DIN_K_OF_NH4("P1_DIN_K_OF_NH4"),
	P1_DIN_RCDENIT("P1_DIN_RCDENIT"),
	P1_DOMSD_ANAEROB_Z("P1_DOMSD_ANAEROB_Z"),
	P1_DOM_CTOOM("P1_DOM_CTOOM"),
	P1_DOM_NC("P1_DOM_NC"),
	P1_PHBIO_NC("P1_PHBIO_NC"),
	P1_PHBIO_NC_SF("P1_PHBIO_NC_SF"),
	P1_POINTNSF("P1_POINTNSF"),
	P1_PS_FACTOR("P1_PS_FACTOR"),
	P1_R_SUB("P1_R_SUB"),
	P1_SEPTICLOAD("P1_SEPTICLOAD"),
	P1_SEPTIC_RED("P1_SEPTIC_RED"),
	DIN_IN_RAIN("DIN_IN_RAIN"),
	TModule(name) {

	DIN_AVAILABLE.SetF(FisExport,True,"CG");
	DIN_SD.SetF(FisExport,True,"CG");
	DIN_SF.SetF(FisExport,True,"CG");
	A_IN.SetF(FisExport,True,"CG");
	SAT_WATER.SetF(FisImport,True,"CG");
	UNSAT_WATER.SetF(FisImport,True,"CG");
	UW_FROM_PRECIP.SetF(FisImport,True,"CG");
	SW_TO_SATW_DOWNFLOW.SetF(FisImport,True,"CG");
	SATW_FROM_PRECIP.SetF(FisImport,True,"CG");
	CELL_SIZE.SetF(FisImport,True,"CG");
	AIR_TEMP_C.SetF(FisImport,True,"CG");
	SATW_TO_SW_UPFLOW.SetF(FisImport,True,"CG");
	PHBIO_NPP.SetF(FisImport,True,"CG");
	UW_DEPTH.SetF(FisImport,True,"CG");
	ELEVATION.SetF(FisImport,True,"CG");
	SATW_OUTFLUX.SetF(FisImport,True,"CG");
	SW_OUTFLUX.SetF(FisImport,True,"CG");
	DAYJUL.SetF(FisImport,True,"CG");
	HABITATMAP.SetF(FisImport,True,"CG");
	ROOT_DEPTH.SetF(FisImport,True,"CG");
	SURFACE_WATER.SetF(FisImport,True,"CG");
	D_DECOMP.SetF(FisImport,True,"CG");
	P1_SEWERMAP.SetF(FisImport,True,"CG");
	P1_POP_DENS.SetF(FisImport,True,"CG");
}	
int ZDIN_module::A_IN_I330_exe() {
	float value;

	A_IN.UpdateIntegrator();
	switch( A_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = A_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ATM_FLOW.Value(p);
			A_IN.Update( p, value, dT() );
		}
		A_IN.GrabMemory();
		if( A_IN.GetF(FLinkEdges) ) { A_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ATM_FLOW.Value();
			A_IN.Update( value, dT() );
	  } break;
	}
	return 0;
}

int ZDIN_module::A_IN_i331_exe() {
	float value;

	A_IN.UpdateIntegrator();
	switch( A_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = A_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			A_IN.InitValue( p, value );
		}
		A_IN.GrabMemory();
		if( A_IN.GetF(FLinkEdges) ) { A_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			A_IN.InitValue( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::ATM_FLOW_u332_exe() {
	float value;

	switch( ATM_FLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ATM_FLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( FROM_ATMOS.Value(p)*((float)10) );
			ATM_FLOW.Update( p, value );
		}
		ATM_FLOW.GrabMemory();
		if( ATM_FLOW.GetF(FICFlux) ) ATM_FLOW.Cov().Set(0.0); 
		if( ATM_FLOW.GetF(FLinkEdges) ) { ATM_FLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( FROM_ATMOS.Value()*((float)10) );
			ATM_FLOW.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_SD_I333_exe() {
	float value;

	DIN_SD.UpdateIntegrator();
	switch( DIN_SD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( ( DIN_DNFLOW.Value(p)+FROM_PS_DINSD.Value(p) )+DOM_TO_DINSD.Value(p) )-DINSD_DENIT.Value(p) )-DIN_UPFLOW.Value(p) )-DINSD_UPTAKE.Value(p) )-DINSD_HOUT.Value(p) );
			DIN_SD.Update( p, value, dT() );
		}
		DIN_SD.GrabMemory();
		if( DIN_SD.GetF(FLinkEdges) ) { DIN_SD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( ( DIN_DNFLOW.Value()+FROM_PS_DINSD.Value() )+DOM_TO_DINSD.Value() )-DINSD_DENIT.Value() )-DIN_UPFLOW.Value() )-DINSD_UPTAKE.Value() )-DINSD_HOUT.Value() );
			DIN_SD.Update( value, dT() );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_SD_i334_exe() {
	float value;

	DIN_SD.UpdateIntegrator();
	switch( DIN_SD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_DIN_ICSED.Value(p)*( SAT_WATER.Value(p)+UNSAT_WATER.Value(p) ) );
			DIN_SD.InitValue( p, value );
		}
		DIN_SD.GrabMemory();
		if( DIN_SD.GetF(FLinkEdges) ) { DIN_SD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_DIN_ICSED.Value()*( SAT_WATER.Value()+UNSAT_WATER.Value() ) );
			DIN_SD.InitValue( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_DNFLOW_u335_exe() {
	float value;

	switch( DIN_DNFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_DNFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(( DIN_SF.Value(p)/dT() ), ( ( DINSF_CONC.Value(p)*P1_DIN_DIFFCOEF.Value(p) )*( ( UW_FROM_PRECIP.Value(p)+SW_TO_SATW_DOWNFLOW.Value(p) )+SATW_FROM_PRECIP.Value(p) ) ));
			DIN_DNFLOW.Update( p, value );
		}
		DIN_DNFLOW.GrabMemory();
		if( DIN_DNFLOW.GetF(FICFlux) ) DIN_DNFLOW.Cov().Set(0.0); 
		if( DIN_DNFLOW.GetF(FLinkEdges) ) { DIN_DNFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(( DIN_SF.Value()/dT() ), ( ( DINSF_CONC.Value()*P1_DIN_DIFFCOEF.Value() )*( ( UW_FROM_PRECIP.Value()+SW_TO_SATW_DOWNFLOW.Value() )+SATW_FROM_PRECIP.Value() ) ));
			DIN_DNFLOW.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::FROM_PS_DINSD_u336_exe() {
	float value;

	switch( FROM_PS_DINSD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FROM_PS_DINSD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ((float)1000)*N_NPOINTSD.Value(p) )/CELL_SIZE.Value(p) );
			FROM_PS_DINSD.Update( p, value );
		}
		FROM_PS_DINSD.GrabMemory();
		if( FROM_PS_DINSD.GetF(FICFlux) ) FROM_PS_DINSD.Cov().Set(0.0); 
		if( FROM_PS_DINSD.GetF(FLinkEdges) ) { FROM_PS_DINSD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ((float)1000)*N_NPOINTSD.Value() )/CELL_SIZE.Value() );
			FROM_PS_DINSD.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DOM_TO_DINSD_u337_exe() {
	float value;

	switch( DOM_TO_DINSD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DOM_TO_DINSD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DOM_TO_DIN.Value(p)*( ((float)1)-P1_DIN_GRAD.Value(p) ) );
			DOM_TO_DINSD.Update( p, value );
		}
		DOM_TO_DINSD.GrabMemory();
		if( DOM_TO_DINSD.GetF(FICFlux) ) DOM_TO_DINSD.Cov().Set(0.0); 
		if( DOM_TO_DINSD.GetF(FLinkEdges) ) { DOM_TO_DINSD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DOM_TO_DIN.Value()*( ((float)1)-P1_DIN_GRAD.Value() ) );
			DOM_TO_DINSD.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_DENIT_u338_exe() {
	float value;

	switch( DINSD_DENIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_DENIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(( DIN_SD.Value(p)/dT() ), ( ( ( P1_DIN_RCDENIT.Value(p)*pow((double)1.04,(double)( AIR_TEMP_C.Value(p)-((float)20) ) ) )*P1_DOMSD_ANAEROB_Z.Value(p) )*DIN_SD.Value(p) ));
			DINSD_DENIT.Update( p, value );
		}
		DINSD_DENIT.GrabMemory();
		if( DINSD_DENIT.GetF(FICFlux) ) DINSD_DENIT.Cov().Set(0.0); 
		if( DINSD_DENIT.GetF(FLinkEdges) ) { DINSD_DENIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(( DIN_SD.Value()/dT() ), ( ( ( P1_DIN_RCDENIT.Value()*pow((double)1.04,(double)( AIR_TEMP_C.Value()-((float)20) ) ) )*P1_DOMSD_ANAEROB_Z.Value() )*DIN_SD.Value() ));
			DINSD_DENIT.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_UPFLOW_u339_exe() {
	float value;

	switch( DIN_UPFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_UPFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SD.Value(p)/dT() )-DINSD_PR1.Value(p) )), ( DINSD_CONC.Value(p)*SATW_TO_SW_UPFLOW.Value(p) ));
			DIN_UPFLOW.Update( p, value );
		}
		DIN_UPFLOW.GrabMemory();
		if( DIN_UPFLOW.GetF(FICFlux) ) DIN_UPFLOW.Cov().Set(0.0); 
		if( DIN_UPFLOW.GetF(FLinkEdges) ) { DIN_UPFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SD.Value()/dT() )-DINSD_PR1.Value() )), ( DINSD_CONC.Value()*SATW_TO_SW_UPFLOW.Value() ));
			DIN_UPFLOW.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_UPTAKE_u340_exe() {
	float value;

	switch( DINSD_UPTAKE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_UPTAKE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SD.Value(p)/dT() )-DINSD_PR2.Value(p) )), DINSD_AVAIL.Value(p), ( ( ( PHBIO_NPP.Value(p)*P1_PHBIO_NC.Value(p) )*P1_DIN_K_OF_NH4.Value(p) )*((float)1000) ));
			DINSD_UPTAKE.Update( p, value );
		}
		DINSD_UPTAKE.GrabMemory();
		if( DINSD_UPTAKE.GetF(FICFlux) ) DINSD_UPTAKE.Cov().Set(0.0); 
		if( DINSD_UPTAKE.GetF(FLinkEdges) ) { DINSD_UPTAKE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SD.Value()/dT() )-DINSD_PR2.Value() )), DINSD_AVAIL.Value(), ( ( ( PHBIO_NPP.Value()*P1_PHBIO_NC.Value() )*P1_DIN_K_OF_NH4.Value() )*((float)1000) ));
			DINSD_UPTAKE.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_HOUT_u341_exe() {
	float value;

	switch( DINSD_HOUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_HOUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_DINSD_OUT.Value(p)*SL::Min(SL::Max(((float)0), ( ( DIN_SD.Value(p)/dT() )-DINSD_PR3.Value(p) )),  ( ( ( UW_DEPTH.Value(p) <= P1_R_SUB.Value(p) ) ) ? ( ( ( ( ( DIN_SD.Value(p)*( ( ( ( ((float)2)*ELEVATION.Value(p) )-P1_R_SUB.Value(p) )-UW_DEPTH.Value(p) )-SATW_OUTFLUX.Value(p) ) )*SATW_OUTFLUX.Value(p) )/( ELEVATION.Value(p)-P1_R_SUB.Value(p) ) )/( ELEVATION.Value(p)-UW_DEPTH.Value(p) ) ) ) : ( ( ( ( ( DIN_SD.Value(p)*( ( ( ((float)2)*ELEVATION.Value(p) )-( ((float)2)*UW_DEPTH.Value(p) ) )-SATW_OUTFLUX.Value(p) ) )*SATW_OUTFLUX.Value(p) )/( ( ELEVATION.Value(p)+UW_DEPTH.Value(p) )-( ((float)2)*P1_R_SUB.Value(p) ) ) )/( ELEVATION.Value(p)-UW_DEPTH.Value(p) ) ) ) ) ) );
			DINSD_HOUT.Update( p, value );
		}
		DINSD_HOUT.GrabMemory();
		if( DINSD_HOUT.GetF(FICFlux) ) DINSD_HOUT.Cov().Set(0.0); 
		if( DINSD_HOUT.GetF(FLinkEdges) ) { DINSD_HOUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_DINSD_OUT.Value()*SL::Min(SL::Max(((float)0), ( ( DIN_SD.Value()/dT() )-DINSD_PR3.Value() )),  ( ( ( UW_DEPTH.Value() <= P1_R_SUB.Value() ) ) ? ( ( ( ( ( DIN_SD.Value()*( ( ( ( ((float)2)*ELEVATION.Value() )-P1_R_SUB.Value() )-UW_DEPTH.Value() )-SATW_OUTFLUX.Value() ) )*SATW_OUTFLUX.Value() )/( ELEVATION.Value()-P1_R_SUB.Value() ) )/( ELEVATION.Value()-UW_DEPTH.Value() ) ) ) : ( ( ( ( ( DIN_SD.Value()*( ( ( ((float)2)*ELEVATION.Value() )-( ((float)2)*UW_DEPTH.Value() ) )-SATW_OUTFLUX.Value() ) )*SATW_OUTFLUX.Value() )/( ( ELEVATION.Value()+UW_DEPTH.Value() )-( ((float)2)*P1_R_SUB.Value() ) ) )/( ELEVATION.Value()-UW_DEPTH.Value() ) ) ) ) ) );
			DINSD_HOUT.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_SF_I342_exe() {
	float value;

	DIN_SF.UpdateIntegrator();
	switch( DIN_SF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( ( ( FROM_ATMOS.Value(p)+DIN_UPFLOW.Value(p) )+DOM_TO_DINSF.Value(p) )+FERT_AV.Value(p) )+FROM_PS.Value(p) )-DIN_DNFLOW.Value(p) )-DINSF_UPTAKE.Value(p) )-DINSF_OUT.Value(p) );
			DIN_SF.Update( p, value, dT() );
		}
		DIN_SF.GrabMemory();
		if( DIN_SF.GetF(FLinkEdges) ) { DIN_SF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( ( ( FROM_ATMOS.Value()+DIN_UPFLOW.Value() )+DOM_TO_DINSF.Value() )+FERT_AV.Value() )+FROM_PS.Value() )-DIN_DNFLOW.Value() )-DINSF_UPTAKE.Value() )-DINSF_OUT.Value() );
			DIN_SF.Update( value, dT() );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_SF_i343_exe() {
	float value;

	DIN_SF.UpdateIntegrator();
	switch( DIN_SF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  P1_DIN_ICSF.Value(p);
			DIN_SF.InitValue( p, value );
		}
		DIN_SF.GrabMemory();
		if( DIN_SF.GetF(FLinkEdges) ) { DIN_SF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  P1_DIN_ICSF.Value();
			DIN_SF.InitValue( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::FROM_ATMOS_u344_exe() {
	float value;

	switch( FROM_ATMOS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FROM_ATMOS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DIN_IN_RAIN.Value(p)*P1_ATMOS_FACTOR.Value(p) );
			FROM_ATMOS.Update( p, value );
		}
		FROM_ATMOS.GrabMemory();
		if( FROM_ATMOS.GetF(FICFlux) ) FROM_ATMOS.Cov().Set(0.0); 
		if( FROM_ATMOS.GetF(FLinkEdges) ) { FROM_ATMOS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DIN_IN_RAIN.Value()*P1_ATMOS_FACTOR.Value() );
			FROM_ATMOS.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DOM_TO_DINSF_u345_exe() {
	float value;

	switch( DOM_TO_DINSF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DOM_TO_DINSF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DOM_TO_DIN.Value(p)*P1_DIN_GRAD.Value(p) );
			DOM_TO_DINSF.Update( p, value );
		}
		DOM_TO_DINSF.GrabMemory();
		if( DOM_TO_DINSF.GetF(FICFlux) ) DOM_TO_DINSF.Cov().Set(0.0); 
		if( DOM_TO_DINSF.GetF(FLinkEdges) ) { DOM_TO_DINSF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DOM_TO_DIN.Value()*P1_DIN_GRAD.Value() );
			DOM_TO_DINSF.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::FERT_AV_u346_exe() {
	float value;

	switch( FERT_AV.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FERT_AV.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_DIN_FERT_DIS.Value(p)*FERTILIZER.Value(p) );
			FERT_AV.Update( p, value );
		}
		FERT_AV.GrabMemory();
		if( FERT_AV.GetF(FICFlux) ) FERT_AV.Cov().Set(0.0); 
		if( FERT_AV.GetF(FLinkEdges) ) { FERT_AV.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_DIN_FERT_DIS.Value()*FERTILIZER.Value() );
			FERT_AV.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::FROM_PS_u347_exe() {
	float value;

	switch( FROM_PS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FROM_PS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_POINTNSF.Value(p)*P1_PS_FACTOR.Value(p) )/CELL_SIZE.Value(p) );
			FROM_PS.Update( p, value );
		}
		FROM_PS.GrabMemory();
		if( FROM_PS.GetF(FICFlux) ) FROM_PS.Cov().Set(0.0); 
		if( FROM_PS.GetF(FLinkEdges) ) { FROM_PS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_POINTNSF.Value()*P1_PS_FACTOR.Value() )/CELL_SIZE.Value() );
			FROM_PS.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSF_UPTAKE_u348_exe() {
	float value;

	switch( DINSF_UPTAKE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSF_UPTAKE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SF.Value(p)/dT() )-DINSF_PR1.Value(p) )), DINSF_AVAIL.Value(p), ( ( ( PHBIO_NPP.Value(p)*P1_PHBIO_NC_SF.Value(p) )*P1_DIN_K_OF_NH4.Value(p) )*((float)1000) ));
			DINSF_UPTAKE.Update( p, value );
		}
		DINSF_UPTAKE.GrabMemory();
		if( DINSF_UPTAKE.GetF(FICFlux) ) DINSF_UPTAKE.Cov().Set(0.0); 
		if( DINSF_UPTAKE.GetF(FLinkEdges) ) { DINSF_UPTAKE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SF.Value()/dT() )-DINSF_PR1.Value() )), DINSF_AVAIL.Value(), ( ( ( PHBIO_NPP.Value()*P1_PHBIO_NC_SF.Value() )*P1_DIN_K_OF_NH4.Value() )*((float)1000) ));
			DINSF_UPTAKE.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSF_OUT_u349_exe() {
	float value;

	switch( DINSF_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSF_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SF.Value(p)/dT() )-DINSF_PR2.Value(p) )), ( ( P1_DINSF_OUT.Value(p)*DINSF_CONC.Value(p) )*SW_OUTFLUX.Value(p) ));
			DINSF_OUT.Update( p, value );
		}
		DINSF_OUT.GrabMemory();
		if( DINSF_OUT.GetF(FICFlux) ) DINSF_OUT.Cov().Set(0.0); 
		if( DINSF_OUT.GetF(FLinkEdges) ) { DINSF_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(SL::Max(((float)0), ( ( DIN_SF.Value()/dT() )-DINSF_PR2.Value() )), ( ( P1_DINSF_OUT.Value()*DINSF_CONC.Value() )*SW_OUTFLUX.Value() ));
			DINSF_OUT.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::FERTILIZER_I350_exe() {
	float value;

	FERTILIZER.UpdateIntegrator();
	switch( FERTILIZER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FERTILIZER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( FROM_FERT.Value(p)-FERT_AV.Value(p) );
			FERTILIZER.Update( p, value, dT() );
		}
		FERTILIZER.GrabMemory();
		if( FERTILIZER.GetF(FLinkEdges) ) { FERTILIZER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( FROM_FERT.Value()-FERT_AV.Value() );
			FERTILIZER.Update( value, dT() );
	  } break;
	}
	return 0;
}

int ZDIN_module::FERTILIZER_i351_exe() {
	float value;

	FERTILIZER.UpdateIntegrator();
	switch( FERTILIZER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FERTILIZER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			FERTILIZER.InitValue( p, value );
		}
		FERTILIZER.GrabMemory();
		if( FERTILIZER.GetF(FLinkEdges) ) { FERTILIZER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			FERTILIZER.InitValue( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::FROM_FERT_u352_exe() {
	float value;

	switch( FROM_FERT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FROM_FERT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( DAYJUL.Value(p) == P1_DIN_DAY_FERT1.Value(p) ) ) ? ( ( ( P1_DIN_FERT_APP.Value(p)*P1_DIN_FERT_HAB1.Value(p) )*0.1 ) ) : (  ( ( ( DAYJUL.Value(p) == P1_DIN_DAY_FERT2.Value(p) ) ) ? ( ( ( P1_DIN_FERT_APP.Value(p)*P1_DIN_FERT_HAB2.Value(p) )*0.1 ) ) : ( ((float)0) ) )  ) ) ;
			FROM_FERT.Update( p, value );
		}
		FROM_FERT.GrabMemory();
		if( FROM_FERT.GetF(FICFlux) ) FROM_FERT.Cov().Set(0.0); 
		if( FROM_FERT.GetF(FLinkEdges) ) { FROM_FERT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( DAYJUL.Value() == P1_DIN_DAY_FERT1.Value() ) ) ? ( ( ( P1_DIN_FERT_APP.Value()*P1_DIN_FERT_HAB1.Value() )*0.1 ) ) : (  ( ( ( DAYJUL.Value() == P1_DIN_DAY_FERT2.Value() ) ) ? ( ( ( P1_DIN_FERT_APP.Value()*P1_DIN_FERT_HAB2.Value() )*0.1 ) ) : ( ((float)0) ) )  ) ) ;
			FROM_FERT.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::F_IN_I353_exe() {
	float value;

	F_IN.UpdateIntegrator();
	switch( F_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = F_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  FERT_FLOW.Value(p);
			F_IN.Update( p, value, dT() );
		}
		F_IN.GrabMemory();
		if( F_IN.GetF(FLinkEdges) ) { F_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  FERT_FLOW.Value();
			F_IN.Update( value, dT() );
	  } break;
	}
	return 0;
}

int ZDIN_module::F_IN_i354_exe() {
	float value;

	F_IN.UpdateIntegrator();
	switch( F_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = F_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			F_IN.InitValue( p, value );
		}
		F_IN.GrabMemory();
		if( F_IN.GetF(FLinkEdges) ) { F_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			F_IN.InitValue( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::FERT_FLOW_u355_exe() {
	float value;

	switch( FERT_FLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FERT_FLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( FROM_FERT.Value(p)*((float)10) );
			FERT_FLOW.Update( p, value );
		}
		FERT_FLOW.GrabMemory();
		if( FERT_FLOW.GetF(FICFlux) ) FERT_FLOW.Cov().Set(0.0); 
		if( FERT_FLOW.GetF(FLinkEdges) ) { FERT_FLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( FROM_FERT.Value()*((float)10) );
			FERT_FLOW.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::M_IN_I356_exe() {
	float value;

	M_IN.UpdateIntegrator();
	switch( M_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = M_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  MINER_FLOW.Value(p);
			M_IN.Update( p, value, dT() );
		}
		M_IN.GrabMemory();
		if( M_IN.GetF(FLinkEdges) ) { M_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  MINER_FLOW.Value();
			M_IN.Update( value, dT() );
	  } break;
	}
	return 0;
}

int ZDIN_module::M_IN_i357_exe() {
	float value;

	M_IN.UpdateIntegrator();
	switch( M_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = M_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			M_IN.InitValue( p, value );
		}
		M_IN.GrabMemory();
		if( M_IN.GetF(FLinkEdges) ) { M_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			M_IN.InitValue( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::MINER_FLOW_u358_exe() {
	float value;

	switch( MINER_FLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MINER_FLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( DOM_TO_DINSD.Value(p)+DOM_TO_DINSF.Value(p) )*((float)10) );
			MINER_FLOW.Update( p, value );
		}
		MINER_FLOW.GrabMemory();
		if( MINER_FLOW.GetF(FICFlux) ) MINER_FLOW.Cov().Set(0.0); 
		if( MINER_FLOW.GetF(FLinkEdges) ) { MINER_FLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( DOM_TO_DINSD.Value()+DOM_TO_DINSF.Value() )*((float)10) );
			MINER_FLOW.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::S_IN_I359_exe() {
	float value;

	S_IN.UpdateIntegrator();
	switch( S_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = S_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SEPTIC_FLOW.Value(p);
			S_IN.Update( p, value, dT() );
		}
		S_IN.GrabMemory();
		if( S_IN.GetF(FLinkEdges) ) { S_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SEPTIC_FLOW.Value();
			S_IN.Update( value, dT() );
	  } break;
	}
	return 0;
}

int ZDIN_module::S_IN_i360_exe() {
	float value;

	S_IN.UpdateIntegrator();
	switch( S_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = S_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			S_IN.InitValue( p, value );
		}
		S_IN.GrabMemory();
		if( S_IN.GetF(FLinkEdges) ) { S_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			S_IN.InitValue( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::SEPTIC_FLOW_u361_exe() {
	float value;

	switch( SEPTIC_FLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SEPTIC_FLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( FROM_PS_DINSD.Value(p)*((float)10) );
			SEPTIC_FLOW.Update( p, value );
		}
		SEPTIC_FLOW.GrabMemory();
		if( SEPTIC_FLOW.GetF(FICFlux) ) SEPTIC_FLOW.Cov().Set(0.0); 
		if( SEPTIC_FLOW.GetF(FLinkEdges) ) { SEPTIC_FLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( FROM_PS_DINSD.Value()*((float)10) );
			SEPTIC_FLOW.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::COUNTY_u362_exe() {
	float value;

	switch( COUNTY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = COUNTY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)1)+( ((float)0)*HABITATMAP.Value(p) ) );
			COUNTY.Update( p, value );
		}
		COUNTY.GrabMemory();
		if( COUNTY.GetF(FLinkEdges) ) { COUNTY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)1)+( ((float)0)*HABITATMAP.Value() ) );
			COUNTY.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::CROP_u363_exe() {
	float value;

	switch( CROP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CROP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)1)+( ((float)0)*HABITATMAP.Value(p) ) );
			CROP.Update( p, value );
		}
		CROP.GrabMemory();
		if( CROP.GetF(FLinkEdges) ) { CROP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)1)+( ((float)0)*HABITATMAP.Value() ) );
			CROP.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_AVAIL_u364_exe() {
	float value;

	switch( DINSD_AVAIL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_AVAIL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ROOT_DEPTH.Value(p) <= P1_R_SUB.Value(p) ) ) ? ( ((float)0) ) : ( ( DIN_SD.Value(p)* ( ( ( ( ROOT_DEPTH.Value(p) >  P1_R_SUB.Value(p) ) && ( P1_R_SUB.Value(p) >= UW_DEPTH.Value(p) ) ) ) ? ( ( ( ( ( ( ( ((float)2)*ELEVATION.Value(p) )-UW_DEPTH.Value(p) )-ROOT_DEPTH.Value(p) )*( ROOT_DEPTH.Value(p)-P1_R_SUB.Value(p) ) )/( ELEVATION.Value(p)-ROOT_DEPTH.Value(p) ) )/( ELEVATION.Value(p)-UW_DEPTH.Value(p) ) ) ) : (  ( ( ( ( P1_R_SUB.Value(p) <= ROOT_DEPTH.Value(p) ) && ( ROOT_DEPTH.Value(p) <  UW_DEPTH.Value(p) ) ) ) ? ( ( ( ((float)2)*( ROOT_DEPTH.Value(p)-P1_R_SUB.Value(p) ) )/( ELEVATION.Value(p)-P1_R_SUB.Value(p) ) ) ) : ( ( ( ( ((float)2)*( UW_DEPTH.Value(p)-P1_R_SUB.Value(p) ) )+( ( ( ( ( ((float)2)*ELEVATION.Value(p) )-UW_DEPTH.Value(p) )-ROOT_DEPTH.Value(p) )*( ROOT_DEPTH.Value(p)-UW_DEPTH.Value(p) ) )/( ELEVATION.Value(p)-UW_DEPTH.Value(p) ) ) )/( ( ELEVATION.Value(p)+UW_DEPTH.Value(p) )-( ((float)2)*P1_R_SUB.Value(p) ) ) ) ) )  ) )  ) ) ) ;
			DINSD_AVAIL.Update( p, value );
		}
		DINSD_AVAIL.GrabMemory();
		if( DINSD_AVAIL.GetF(FLinkEdges) ) { DINSD_AVAIL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ROOT_DEPTH.Value() <= P1_R_SUB.Value() ) ) ? ( ((float)0) ) : ( ( DIN_SD.Value()* ( ( ( ( ROOT_DEPTH.Value() >  P1_R_SUB.Value() ) && ( P1_R_SUB.Value() >= UW_DEPTH.Value() ) ) ) ? ( ( ( ( ( ( ( ((float)2)*ELEVATION.Value() )-UW_DEPTH.Value() )-ROOT_DEPTH.Value() )*( ROOT_DEPTH.Value()-P1_R_SUB.Value() ) )/( ELEVATION.Value()-ROOT_DEPTH.Value() ) )/( ELEVATION.Value()-UW_DEPTH.Value() ) ) ) : (  ( ( ( ( P1_R_SUB.Value() <= ROOT_DEPTH.Value() ) && ( ROOT_DEPTH.Value() <  UW_DEPTH.Value() ) ) ) ? ( ( ( ((float)2)*( ROOT_DEPTH.Value()-P1_R_SUB.Value() ) )/( ELEVATION.Value()-P1_R_SUB.Value() ) ) ) : ( ( ( ( ((float)2)*( UW_DEPTH.Value()-P1_R_SUB.Value() ) )+( ( ( ( ( ((float)2)*ELEVATION.Value() )-UW_DEPTH.Value() )-ROOT_DEPTH.Value() )*( ROOT_DEPTH.Value()-UW_DEPTH.Value() ) )/( ELEVATION.Value()-UW_DEPTH.Value() ) ) )/( ( ELEVATION.Value()+UW_DEPTH.Value() )-( ((float)2)*P1_R_SUB.Value() ) ) ) ) )  ) )  ) ) ) ;
			DINSD_AVAIL.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_CONC_u365_exe() {
	float value;

	switch( DINSD_CONC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_CONC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DIN_SD.Value(p)/( SAT_WATER.Value(p)+UNSAT_WATER.Value(p) ) );
			DINSD_CONC.Update( p, value );
		}
		DINSD_CONC.GrabMemory();
		if( DINSD_CONC.GetF(FLinkEdges) ) { DINSD_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DIN_SD.Value()/( SAT_WATER.Value()+UNSAT_WATER.Value() ) );
			DINSD_CONC.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_PR1_u366_exe() {
	float value;

	switch( DINSD_PR1.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_PR1.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  DINSD_DENIT.Value(p);
			DINSD_PR1.Update( p, value );
		}
		DINSD_PR1.GrabMemory();
		if( DINSD_PR1.GetF(FLinkEdges) ) { DINSD_PR1.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  DINSD_DENIT.Value();
			DINSD_PR1.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_PR2_u367_exe() {
	float value;

	switch( DINSD_PR2.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_PR2.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DIN_UPFLOW.Value(p)+DINSD_PR1.Value(p) );
			DINSD_PR2.Update( p, value );
		}
		DINSD_PR2.GrabMemory();
		if( DINSD_PR2.GetF(FLinkEdges) ) { DINSD_PR2.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DIN_UPFLOW.Value()+DINSD_PR1.Value() );
			DINSD_PR2.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSD_PR3_u368_exe() {
	float value;

	switch( DINSD_PR3.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSD_PR3.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DINSD_UPTAKE.Value(p)+DINSD_PR2.Value(p) );
			DINSD_PR3.Update( p, value );
		}
		DINSD_PR3.GrabMemory();
		if( DINSD_PR3.GetF(FLinkEdges) ) { DINSD_PR3.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DINSD_UPTAKE.Value()+DINSD_PR2.Value() );
			DINSD_PR3.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSF_AVAIL_u369_exe() {
	float value;

	switch( DINSF_AVAIL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSF_AVAIL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SURFACE_WATER.Value(p) >  ((float)0) ) ) ? ( ( DINSF_CONC.Value(p)*( SURFACE_WATER.Value(p)+SR_WATER.Value(p) ) ) ) : ( ( ( DINSF_CONC.Value(p)*( ((float)1)-P1_DIN_DIFFCOEF.Value(p) ) )*SR_WATER.Value(p) ) ) ) ;
			DINSF_AVAIL.Update( p, value );
		}
		DINSF_AVAIL.GrabMemory();
		if( DINSF_AVAIL.GetF(FLinkEdges) ) { DINSF_AVAIL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SURFACE_WATER.Value() >  ((float)0) ) ) ? ( ( DINSF_CONC.Value()*( SURFACE_WATER.Value()+SR_WATER.Value() ) ) ) : ( ( ( DINSF_CONC.Value()*( ((float)1)-P1_DIN_DIFFCOEF.Value() ) )*SR_WATER.Value() ) ) ) ;
			DINSF_AVAIL.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSF_CONC_u370_exe() {
	float value;

	switch( DINSF_CONC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSF_CONC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( SURFACE_WATER.Value(p)+SR_WATER.Value(p) ) >  0.0 ) ) ? ( ( DIN_SF.Value(p)/( SURFACE_WATER.Value(p)+SR_WATER.Value(p) ) ) ) : ( ((float)0) ) ) ;
			DINSF_CONC.Update( p, value );
		}
		DINSF_CONC.GrabMemory();
		if( DINSF_CONC.GetF(FLinkEdges) ) { DINSF_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( SURFACE_WATER.Value()+SR_WATER.Value() ) >  0.0 ) ) ? ( ( DIN_SF.Value()/( SURFACE_WATER.Value()+SR_WATER.Value() ) ) ) : ( ((float)0) ) ) ;
			DINSF_CONC.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSF_PR1_u371_exe() {
	float value;

	switch( DINSF_PR1.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSF_PR1.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  DIN_DNFLOW.Value(p);
			DINSF_PR1.Update( p, value );
		}
		DINSF_PR1.GrabMemory();
		if( DINSF_PR1.GetF(FLinkEdges) ) { DINSF_PR1.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  DIN_DNFLOW.Value();
			DINSF_PR1.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DINSF_PR2_u372_exe() {
	float value;

	switch( DINSF_PR2.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSF_PR2.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DINSF_PR1.Value(p)+DINSF_UPTAKE.Value(p) );
			DINSF_PR2.Update( p, value );
		}
		DINSF_PR2.GrabMemory();
		if( DINSF_PR2.GetF(FLinkEdges) ) { DINSF_PR2.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DINSF_PR1.Value()+DINSF_UPTAKE.Value() );
			DINSF_PR2.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_AVAILABLE_u373_exe() {
	float value;

	switch( DIN_AVAILABLE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_AVAILABLE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DINSD_AVAIL.Value(p)+DINSF_AVAIL.Value(p) );
			DIN_AVAILABLE.Update( p, value );
		}
		DIN_AVAILABLE.GrabMemory();
		if( DIN_AVAILABLE.GetF(FLinkEdges) ) { DIN_AVAILABLE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DINSD_AVAIL.Value()+DINSF_AVAIL.Value() );
			DIN_AVAILABLE.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::DOM_TO_DIN_u374_exe() {
	float value;

	switch( DOM_TO_DIN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DOM_TO_DIN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( D_DECOMP.Value(p)*P1_DOM_NC.Value(p) )*P1_DOM_CTOOM.Value(p) )*P1_DIN_CR_SED_MIN.Value(p) )*((float)1000) );
			DOM_TO_DIN.Update( p, value );
		}
		DOM_TO_DIN.GrabMemory();
		if( DOM_TO_DIN.GetF(FLinkEdges) ) { DOM_TO_DIN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( D_DECOMP.Value()*P1_DOM_NC.Value() )*P1_DOM_CTOOM.Value() )*P1_DIN_CR_SED_MIN.Value() )*((float)1000) );
			DOM_TO_DIN.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::N_NPOINTSD_u375_exe() {
	float value;

	switch( N_NPOINTSD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = N_NPOINTSD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( P1_SEWERMAP.Value(p) == ((float)3) ) ) ? ( ((float)0) ) : ( ( ( P1_SEPTICLOAD.Value(p)*P1_POP_DENS.Value(p) )*P1_SEPTIC_RED.Value(p) ) ) ) ;
			N_NPOINTSD.Update( p, value );
		}
		N_NPOINTSD.GrabMemory();
		if( N_NPOINTSD.GetF(FLinkEdges) ) { N_NPOINTSD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( P1_SEWERMAP.Value() == ((float)3) ) ) ? ( ((float)0) ) : ( ( ( P1_SEPTICLOAD.Value()*P1_POP_DENS.Value() )*P1_SEPTIC_RED.Value() ) ) ) ;
			N_NPOINTSD.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::OUTPUTCOL_u376_exe() {
	float value;

	switch( OUTPUTCOL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = OUTPUTCOL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  23;
			OUTPUTCOL.Update( p, OUTPUTCOL.ParameterValue(value,p) );
		}
		OUTPUTCOL.GrabMemory();
		if( OUTPUTCOL.GetF(FLinkEdges) ) { OUTPUTCOL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  23;
			OUTPUTCOL.Update( OUTPUTCOL.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::OUTPUTROW_u377_exe() {
	float value;

	switch( OUTPUTROW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = OUTPUTROW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  12;
			OUTPUTROW.Update( p, OUTPUTROW.ParameterValue(value,p) );
		}
		OUTPUTROW.GrabMemory();
		if( OUTPUTROW.GetF(FLinkEdges) ) { OUTPUTROW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  12;
			OUTPUTROW.Update( OUTPUTROW.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::OUTPUTVAR_u378_exe() {
	float value;

	switch( OUTPUTVAR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = OUTPUTVAR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( HABITATMAP.Value(p)*((float)0) );
			OUTPUTVAR.Update( p, value );
		}
		OUTPUTVAR.GrabMemory();
		if( OUTPUTVAR.GetF(FLinkEdges) ) { OUTPUTVAR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( HABITATMAP.Value()*((float)0) );
			OUTPUTVAR.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::SR_WATER_u379_exe() {
	float value;

	switch( SR_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SR_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( P1_R_SUB.Value(p) <  UW_DEPTH.Value(p) ) ) ? ( ( ( UNSAT_WATER.Value(p)*P1_R_SUB.Value(p) )/UW_DEPTH.Value(p) ) ) : ( ( UNSAT_WATER.Value(p)+( ( ( P1_R_SUB.Value(p)-UW_DEPTH.Value(p) )/( ELEVATION.Value(p)-UW_DEPTH.Value(p) ) )*SAT_WATER.Value(p) ) ) ) ) ;
			SR_WATER.Update( p, value );
		}
		SR_WATER.GrabMemory();
		if( SR_WATER.GetF(FLinkEdges) ) { SR_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( P1_R_SUB.Value() <  UW_DEPTH.Value() ) ) ? ( ( ( UNSAT_WATER.Value()*P1_R_SUB.Value() )/UW_DEPTH.Value() ) ) : ( ( UNSAT_WATER.Value()+( ( ( P1_R_SUB.Value()-UW_DEPTH.Value() )/( ELEVATION.Value()-UW_DEPTH.Value() ) )*SAT_WATER.Value() ) ) ) ) ;
			SR_WATER.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::ZONMAP_u380_exe() {
	float value;

	switch( ZONMAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ZONMAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)0)+( ((float)0)*HABITATMAP.Value(p) ) );
			ZONMAP.Update( p, value );
		}
		ZONMAP.GrabMemory();
		if( ZONMAP.GetF(FLinkEdges) ) { ZONMAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)0)+( ((float)0)*HABITATMAP.Value() ) );
			ZONMAP.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_ATMOS_FACTOR_u381_exe() {
	float value;

	switch( P1_ATMOS_FACTOR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_ATMOS_FACTOR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.214;
			P1_ATMOS_FACTOR.Update( p, P1_ATMOS_FACTOR.ParameterValue(value,p) );
		}
		P1_ATMOS_FACTOR.GrabMemory();
		if( P1_ATMOS_FACTOR.GetF(FLinkEdges) ) { P1_ATMOS_FACTOR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.214;
			P1_ATMOS_FACTOR.Update( P1_ATMOS_FACTOR.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DINSD_OUT_u382_exe() {
	float value;

	switch( P1_DINSD_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DINSD_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0;
			P1_DINSD_OUT.Update( p, P1_DINSD_OUT.ParameterValue(value,p) );
		}
		P1_DINSD_OUT.GrabMemory();
		if( P1_DINSD_OUT.GetF(FLinkEdges) ) { P1_DINSD_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0;
			P1_DINSD_OUT.Update( P1_DINSD_OUT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DINSF_OUT_u383_exe() {
	float value;

	switch( P1_DINSF_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DINSF_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0;
			P1_DINSF_OUT.Update( p, P1_DINSF_OUT.ParameterValue(value,p) );
		}
		P1_DINSF_OUT.GrabMemory();
		if( P1_DINSF_OUT.GetF(FLinkEdges) ) { P1_DINSF_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0;
			P1_DINSF_OUT.Update( P1_DINSF_OUT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_CR_SED_MIN_u384_exe() {
	float value;

	switch( P1_DIN_CR_SED_MIN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_CR_SED_MIN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.2;
			P1_DIN_CR_SED_MIN.Update( p, P1_DIN_CR_SED_MIN.ParameterValue(value,p) );
		}
		P1_DIN_CR_SED_MIN.GrabMemory();
		if( P1_DIN_CR_SED_MIN.GetF(FLinkEdges) ) { P1_DIN_CR_SED_MIN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.2;
			P1_DIN_CR_SED_MIN.Update( P1_DIN_CR_SED_MIN.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_DAY_FERT1_u385_exe() {
	float value;

	switch( P1_DIN_DAY_FERT1.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_DAY_FERT1.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)191);
			P1_DIN_DAY_FERT1.Update( p, value );
		}
		P1_DIN_DAY_FERT1.GrabMemory();
		if( P1_DIN_DAY_FERT1.GetF(FLinkEdges) ) { P1_DIN_DAY_FERT1.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)191);
			P1_DIN_DAY_FERT1.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_DAY_FERT2_u386_exe() {
	float value;

	switch( P1_DIN_DAY_FERT2.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_DAY_FERT2.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)999);
			P1_DIN_DAY_FERT2.Update( p, value );
		}
		P1_DIN_DAY_FERT2.GrabMemory();
		if( P1_DIN_DAY_FERT2.GetF(FLinkEdges) ) { P1_DIN_DAY_FERT2.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)999);
			P1_DIN_DAY_FERT2.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_DIFFCOEF_u387_exe() {
	float value;

	switch( P1_DIN_DIFFCOEF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_DIFFCOEF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.7;
			P1_DIN_DIFFCOEF.Update( p, P1_DIN_DIFFCOEF.ParameterValue(value,p) );
		}
		P1_DIN_DIFFCOEF.GrabMemory();
		if( P1_DIN_DIFFCOEF.GetF(FLinkEdges) ) { P1_DIN_DIFFCOEF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.7;
			P1_DIN_DIFFCOEF.Update( P1_DIN_DIFFCOEF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_FERT_APP_u388_exe() {
	float value;

	switch( P1_DIN_FERT_APP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_FERT_APP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)145);
			P1_DIN_FERT_APP.Update( p, value );
		}
		P1_DIN_FERT_APP.GrabMemory();
		if( P1_DIN_FERT_APP.GetF(FLinkEdges) ) { P1_DIN_FERT_APP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)145);
			P1_DIN_FERT_APP.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_FERT_DIS_u389_exe() {
	float value;

	switch( P1_DIN_FERT_DIS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_FERT_DIS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.050000;
			P1_DIN_FERT_DIS.Update( p, P1_DIN_FERT_DIS.ParameterValue(value,p) );
		}
		P1_DIN_FERT_DIS.GrabMemory();
		if( P1_DIN_FERT_DIS.GetF(FLinkEdges) ) { P1_DIN_FERT_DIS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.050000;
			P1_DIN_FERT_DIS.Update( P1_DIN_FERT_DIS.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_FERT_HAB1_u390_exe() {
	float value;

	switch( P1_DIN_FERT_HAB1.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_FERT_HAB1.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.75;
			P1_DIN_FERT_HAB1.Update( p, value );
		}
		P1_DIN_FERT_HAB1.GrabMemory();
		if( P1_DIN_FERT_HAB1.GetF(FLinkEdges) ) { P1_DIN_FERT_HAB1.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.75;
			P1_DIN_FERT_HAB1.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_FERT_HAB2_u391_exe() {
	float value;

	switch( P1_DIN_FERT_HAB2.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_FERT_HAB2.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_DIN_FERT_HAB2.Update( p, value );
		}
		P1_DIN_FERT_HAB2.GrabMemory();
		if( P1_DIN_FERT_HAB2.GetF(FLinkEdges) ) { P1_DIN_FERT_HAB2.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_DIN_FERT_HAB2.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_GRAD_u392_exe() {
	float value;

	switch( P1_DIN_GRAD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_GRAD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.7;
			P1_DIN_GRAD.Update( p, P1_DIN_GRAD.ParameterValue(value,p) );
		}
		P1_DIN_GRAD.GrabMemory();
		if( P1_DIN_GRAD.GetF(FLinkEdges) ) { P1_DIN_GRAD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.7;
			P1_DIN_GRAD.Update( P1_DIN_GRAD.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_ICSED_u393_exe() {
	float value;

	switch( P1_DIN_ICSED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_ICSED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.15;
			P1_DIN_ICSED.Update( p, value );
		}
		P1_DIN_ICSED.GrabMemory();
		if( P1_DIN_ICSED.GetF(FLinkEdges) ) { P1_DIN_ICSED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.15;
			P1_DIN_ICSED.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_ICSF_u394_exe() {
	float value;

	switch( P1_DIN_ICSF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_ICSF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.3;
			P1_DIN_ICSF.Update( p, value );
		}
		P1_DIN_ICSF.GrabMemory();
		if( P1_DIN_ICSF.GetF(FLinkEdges) ) { P1_DIN_ICSF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.3;
			P1_DIN_ICSF.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_K_OF_NH4_u395_exe() {
	float value;

	switch( P1_DIN_K_OF_NH4.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_K_OF_NH4.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.5;
			P1_DIN_K_OF_NH4.Update( p, P1_DIN_K_OF_NH4.ParameterValue(value,p) );
		}
		P1_DIN_K_OF_NH4.GrabMemory();
		if( P1_DIN_K_OF_NH4.GetF(FLinkEdges) ) { P1_DIN_K_OF_NH4.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.5;
			P1_DIN_K_OF_NH4.Update( P1_DIN_K_OF_NH4.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DIN_RCDENIT_u396_exe() {
	float value;

	switch( P1_DIN_RCDENIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_RCDENIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.001;
			P1_DIN_RCDENIT.Update( p, P1_DIN_RCDENIT.ParameterValue(value,p) );
		}
		P1_DIN_RCDENIT.GrabMemory();
		if( P1_DIN_RCDENIT.GetF(FLinkEdges) ) { P1_DIN_RCDENIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.001;
			P1_DIN_RCDENIT.Update( P1_DIN_RCDENIT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DOMSD_ANAEROB_Z_u397_exe() {
	float value;

	switch( P1_DOMSD_ANAEROB_Z.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DOMSD_ANAEROB_Z.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_DOMSD_ANAEROB_Z.Update( p, P1_DOMSD_ANAEROB_Z.ParameterValue(value,p) );
		}
		P1_DOMSD_ANAEROB_Z.GrabMemory();
		if( P1_DOMSD_ANAEROB_Z.GetF(FLinkEdges) ) { P1_DOMSD_ANAEROB_Z.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_DOMSD_ANAEROB_Z.Update( P1_DOMSD_ANAEROB_Z.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DOM_CTOOM_u398_exe() {
	float value;

	switch( P1_DOM_CTOOM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DOM_CTOOM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.2;
			P1_DOM_CTOOM.Update( p, value );
		}
		P1_DOM_CTOOM.GrabMemory();
		if( P1_DOM_CTOOM.GetF(FLinkEdges) ) { P1_DOM_CTOOM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.2;
			P1_DOM_CTOOM.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_DOM_NC_u399_exe() {
	float value;

	switch( P1_DOM_NC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DOM_NC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_DOM_NC.Update( p, value );
		}
		P1_DOM_NC.GrabMemory();
		if( P1_DOM_NC.GetF(FLinkEdges) ) { P1_DOM_NC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_DOM_NC.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_PHBIO_NC_u400_exe() {
	float value;

	switch( P1_PHBIO_NC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHBIO_NC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.1;
			P1_PHBIO_NC.Update( p, value );
		}
		P1_PHBIO_NC.GrabMemory();
		if( P1_PHBIO_NC.GetF(FLinkEdges) ) { P1_PHBIO_NC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.1;
			P1_PHBIO_NC.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_PHBIO_NC_SF_u401_exe() {
	float value;

	switch( P1_PHBIO_NC_SF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHBIO_NC_SF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.01;
			P1_PHBIO_NC_SF.Update( p, value );
		}
		P1_PHBIO_NC_SF.GrabMemory();
		if( P1_PHBIO_NC_SF.GetF(FLinkEdges) ) { P1_PHBIO_NC_SF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.01;
			P1_PHBIO_NC_SF.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_POINTNSF_u402_exe() {
	float value;

	switch( P1_POINTNSF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_POINTNSF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_POINTNSF.Update( p, value );
		}
		P1_POINTNSF.GrabMemory();
		if( P1_POINTNSF.GetF(FLinkEdges) ) { P1_POINTNSF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_POINTNSF.Update( value );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_PS_FACTOR_u403_exe() {
	float value;

	switch( P1_PS_FACTOR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PS_FACTOR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  454;
			P1_PS_FACTOR.Update( p, P1_PS_FACTOR.ParameterValue(value,p) );
		}
		P1_PS_FACTOR.GrabMemory();
		if( P1_PS_FACTOR.GetF(FLinkEdges) ) { P1_PS_FACTOR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  454;
			P1_PS_FACTOR.Update( P1_PS_FACTOR.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_R_SUB_u404_exe() {
	float value;

	switch( P1_R_SUB.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_R_SUB.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.1;
			P1_R_SUB.Update( p, P1_R_SUB.ParameterValue(value,p) );
		}
		P1_R_SUB.GrabMemory();
		if( P1_R_SUB.GetF(FLinkEdges) ) { P1_R_SUB.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.1;
			P1_R_SUB.Update( P1_R_SUB.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_SEPTICLOAD_u405_exe() {
	float value;

	switch( P1_SEPTICLOAD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SEPTICLOAD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.0132;
			P1_SEPTICLOAD.Update( p, P1_SEPTICLOAD.ParameterValue(value,p) );
		}
		P1_SEPTICLOAD.GrabMemory();
		if( P1_SEPTICLOAD.GetF(FLinkEdges) ) { P1_SEPTICLOAD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.0132;
			P1_SEPTICLOAD.Update( P1_SEPTICLOAD.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::P1_SEPTIC_RED_u406_exe() {
	float value;

	switch( P1_SEPTIC_RED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SEPTIC_RED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.4;
			P1_SEPTIC_RED.Update( p, P1_SEPTIC_RED.ParameterValue(value,p) );
		}
		P1_SEPTIC_RED.GrabMemory();
		if( P1_SEPTIC_RED.GetF(FLinkEdges) ) { P1_SEPTIC_RED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.4;
			P1_SEPTIC_RED.Update( P1_SEPTIC_RED.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int ZDIN_module::DIN_IN_RAIN_u407_exe() {
	float value;

	switch( DIN_IN_RAIN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_IN_RAIN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph45(DAYJUL.Value(p));
			DIN_IN_RAIN.Update( p, value );
		}
		DIN_IN_RAIN.GrabMemory();
		if( DIN_IN_RAIN.GetF(FLinkEdges) ) { DIN_IN_RAIN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph45(DAYJUL.Value());
			DIN_IN_RAIN.Update( value );
	  } break;
	}
	return 0;
}

ZDIN_module* ZDIN_module::fInstance = NULL;
ZDIN_module* ZDIN_module::kNullModel = (ZDIN_module*)0x1;
int ZDIN_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int ZDIN_module::InitVars() {
	
	TIME.SSInit(this);
	DIN_AVAILABLE.SSInit(this);
	DIN_SD.SSInit(this);
	DIN_SF.SSInit(this);
	A_IN.SSInit(this);
	SAT_WATER.SSInit(this);
	UNSAT_WATER.SSInit(this);
	UW_FROM_PRECIP.SSInit(this);
	SW_TO_SATW_DOWNFLOW.SSInit(this);
	SATW_FROM_PRECIP.SSInit(this);
	CELL_SIZE.SSInit(this);
	AIR_TEMP_C.SSInit(this);
	SATW_TO_SW_UPFLOW.SSInit(this);
	PHBIO_NPP.SSInit(this);
	UW_DEPTH.SSInit(this);
	ELEVATION.SSInit(this);
	SATW_OUTFLUX.SSInit(this);
	SW_OUTFLUX.SSInit(this);
	DAYJUL.SSInit(this);
	HABITATMAP.SSInit(this);
	ROOT_DEPTH.SSInit(this);
	SURFACE_WATER.SSInit(this);
	D_DECOMP.SSInit(this);
	P1_SEWERMAP.SSInit(this);
	P1_POP_DENS.SSInit(this);
	ATM_FLOW.SSInit(this);
	ATM_FLOW.SetDestination(&A_IN);
	DIN_DNFLOW.SSInit(this);
	DIN_DNFLOW.SetOrigin(&DIN_SF);
	DIN_DNFLOW.SetDestination(&DIN_SD);
	FROM_PS_DINSD.SSInit(this);
	FROM_PS_DINSD.SetDestination(&DIN_SD);
	DOM_TO_DINSD.SSInit(this);
	DOM_TO_DINSD.SetDestination(&DIN_SD);
	DINSD_DENIT.SSInit(this);
	DINSD_DENIT.SetOrigin(&DIN_SD);
	DIN_UPFLOW.SSInit(this);
	DIN_UPFLOW.SetOrigin(&DIN_SD);
	DIN_UPFLOW.SetDestination(&DIN_SF);
	DINSD_UPTAKE.SSInit(this);
	DINSD_UPTAKE.SetOrigin(&DIN_SD);
	DINSD_HOUT.SSInit(this);
	DINSD_HOUT.SetOrigin(&DIN_SD);
	FROM_ATMOS.SSInit(this);
	FROM_ATMOS.SetDestination(&DIN_SF);
	DOM_TO_DINSF.SSInit(this);
	DOM_TO_DINSF.SetDestination(&DIN_SF);
	FERT_AV.SSInit(this);
	FERT_AV.SetOrigin(&FERTILIZER);
	FERT_AV.SetDestination(&DIN_SF);
	FROM_PS.SSInit(this);
	FROM_PS.SetDestination(&DIN_SF);
	DINSF_UPTAKE.SSInit(this);
	DINSF_UPTAKE.SetOrigin(&DIN_SF);
	DINSF_OUT.SSInit(this);
	DINSF_OUT.SetOrigin(&DIN_SF);
	FERTILIZER.SSInit(this);
	FROM_FERT.SSInit(this);
	FROM_FERT.SetDestination(&FERTILIZER);
	F_IN.SSInit(this);
	FERT_FLOW.SSInit(this);
	FERT_FLOW.SetDestination(&F_IN);
	M_IN.SSInit(this);
	MINER_FLOW.SSInit(this);
	MINER_FLOW.SetDestination(&M_IN);
	S_IN.SSInit(this);
	SEPTIC_FLOW.SSInit(this);
	SEPTIC_FLOW.SetDestination(&S_IN);
	COUNTY.SSInit(this);
	CROP.SSInit(this);
	DINSD_AVAIL.SSInit(this);
	DINSD_CONC.SSInit(this);
	DINSD_PR1.SSInit(this);
	DINSD_PR2.SSInit(this);
	DINSD_PR3.SSInit(this);
	DINSF_AVAIL.SSInit(this);
	DINSF_CONC.SSInit(this);
	DINSF_PR1.SSInit(this);
	DINSF_PR2.SSInit(this);
	DOM_TO_DIN.SSInit(this);
	N_NPOINTSD.SSInit(this);
	OUTPUTCOL.SSInit(this);
	OUTPUTROW.SSInit(this);
	OUTPUTVAR.SSInit(this);
	SR_WATER.SSInit(this);
	ZONMAP.SSInit(this);
	P1_ATMOS_FACTOR.SSInit(this);
	P1_DINSD_OUT.SSInit(this);
	P1_DINSF_OUT.SSInit(this);
	P1_DIN_CR_SED_MIN.SSInit(this);
	P1_DIN_DAY_FERT1.SSInit(this);
	P1_DIN_DAY_FERT2.SSInit(this);
	P1_DIN_DIFFCOEF.SSInit(this);
	P1_DIN_FERT_APP.SSInit(this);
	P1_DIN_FERT_DIS.SSInit(this);
	P1_DIN_FERT_HAB1.SSInit(this);
	P1_DIN_FERT_HAB2.SSInit(this);
	P1_DIN_GRAD.SSInit(this);
	P1_DIN_ICSED.SSInit(this);
	P1_DIN_ICSF.SSInit(this);
	P1_DIN_K_OF_NH4.SSInit(this);
	P1_DIN_RCDENIT.SSInit(this);
	P1_DOMSD_ANAEROB_Z.SSInit(this);
	P1_DOM_CTOOM.SSInit(this);
	P1_DOM_NC.SSInit(this);
	P1_PHBIO_NC.SSInit(this);
	P1_PHBIO_NC_SF.SSInit(this);
	P1_POINTNSF.SSInit(this);
	P1_PS_FACTOR.SSInit(this);
	P1_R_SUB.SSInit(this);
	P1_SEPTICLOAD.SSInit(this);
	P1_SEPTIC_RED.SSInit(this);
	DIN_IN_RAIN.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int ZDIN_module::SetupEvents() {
	TExecuteCommand* u373 = (TExecuteCommand*) DIN_AVAILABLE.GetCommand("u373",TCommand::kUpdate,TCommand::kCode);
	u373->SetExecutable(&DIN_AVAILABLE_u373_exe_g);
	u373->Code() = "u373 <- ( DINSD_AVAIL+DINSF_AVAIL )";
	u373->AddDependency(DINSD_AVAIL);
	u373->AddDependency(DINSF_AVAIL);
	u373->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I333 = (TExecuteCommand*) DIN_SD.GetCommand("I333",TCommand::kIntegrate,TCommand::kCode);
	I333->SetExecutable(&DIN_SD_I333_exe_g);
	I333->Code() = "I333 <- ( ( ( ( ( ( DIN_DNFLOW+FROM_PS_DINSD )+DOM_TO_DINSD )-DINSD_DENIT )-DIN_UPFLOW )-DINSD_UPTAKE )-DINSD_HOUT )";
	I333->AddDependency(DIN_DNFLOW);
	I333->AddDependency(FROM_PS_DINSD);
	I333->AddDependency(DOM_TO_DINSD);
	I333->AddDependency(DINSD_DENIT);
	I333->AddDependency(DIN_UPFLOW);
	I333->AddDependency(DINSD_UPTAKE);
	I333->AddDependency(DINSD_HOUT);
	I333->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i334 = (TExecuteCommand*) DIN_SD.GetCommand("i334",TCommand::kInit,TCommand::kCode);
	i334->SetExecutable(&DIN_SD_i334_exe_g);
	i334->Code() = "i334 <- ( P1_DIN_ICSED*( SAT_WATER+UNSAT_WATER ) )";
	i334->AddDependency(HABITATMAP);
	i334->AddDependency(P1_DIN_ICSED);
	i334->AddDependency(SAT_WATER);
	i334->AddDependency(UNSAT_WATER);
	i334->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I342 = (TExecuteCommand*) DIN_SF.GetCommand("I342",TCommand::kIntegrate,TCommand::kCode);
	I342->SetExecutable(&DIN_SF_I342_exe_g);
	I342->Code() = "I342 <- ( ( ( ( ( ( ( FROM_ATMOS+DIN_UPFLOW )+DOM_TO_DINSF )+FERT_AV )+FROM_PS )-DIN_DNFLOW )-DINSF_UPTAKE )-DINSF_OUT )";
	I342->AddDependency(FROM_ATMOS);
	I342->AddDependency(DIN_UPFLOW);
	I342->AddDependency(DOM_TO_DINSF);
	I342->AddDependency(FERT_AV);
	I342->AddDependency(FROM_PS);
	I342->AddDependency(DIN_DNFLOW);
	I342->AddDependency(DINSF_UPTAKE);
	I342->AddDependency(DINSF_OUT);
	I342->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i343 = (TExecuteCommand*) DIN_SF.GetCommand("i343",TCommand::kInit,TCommand::kCode);
	i343->SetExecutable(&DIN_SF_i343_exe_g);
	i343->Code() = "i343 <- P1_DIN_ICSF";
	i343->AddDependency(HABITATMAP);
	i343->AddDependency(P1_DIN_ICSF);
	i343->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I330 = (TExecuteCommand*) A_IN.GetCommand("I330",TCommand::kIntegrate,TCommand::kCode);
	I330->SetExecutable(&A_IN_I330_exe_g);
	I330->Code() = "I330 <- ATM_FLOW";
	I330->AddDependency(ATM_FLOW);
	I330->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i331 = (TExecuteCommand*) A_IN.GetCommand("i331",TCommand::kInit,TCommand::kCode);
	i331->SetExecutable(&A_IN_i331_exe_g);
	i331->Code() = "i331 <- ((float)0)";
	i331->SetObjInfo(TCommand::kDepIndex, 5);
	TImportCommand* SAT_WATER_import = (TImportCommand*) SAT_WATER.GetCommand("SAT_WATER_import",TCommand::kUndefined,TCommand::kImport);
	SAT_WATER_import->Code() = "Import SAT_WATER from HYDROLOGY_module";
	SAT_WATER_import->AddDependency(SAT_WATER);
	SAT_WATER_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* UNSAT_WATER_import = (TImportCommand*) UNSAT_WATER.GetCommand("UNSAT_WATER_import",TCommand::kUndefined,TCommand::kImport);
	UNSAT_WATER_import->Code() = "Import UNSAT_WATER from HYDROLOGY_module";
	UNSAT_WATER_import->AddDependency(UNSAT_WATER);
	UNSAT_WATER_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* UW_FROM_PRECIP_import = (TImportCommand*) UW_FROM_PRECIP.GetCommand("UW_FROM_PRECIP_import",TCommand::kUndefined,TCommand::kImport);
	UW_FROM_PRECIP_import->Code() = "Import UW_FROM_PRECIP from HYDROLOGY_module";
	UW_FROM_PRECIP_import->AddDependency(UW_FROM_PRECIP);
	UW_FROM_PRECIP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SW_TO_SATW_DOWNFLOW_import = (TImportCommand*) SW_TO_SATW_DOWNFLOW.GetCommand("SW_TO_SATW_DOWNFLOW_import",TCommand::kUndefined,TCommand::kImport);
	SW_TO_SATW_DOWNFLOW_import->Code() = "Import SW_TO_SATW_DOWNFLOW from HYDROLOGY_module";
	SW_TO_SATW_DOWNFLOW_import->AddDependency(SW_TO_SATW_DOWNFLOW);
	SW_TO_SATW_DOWNFLOW_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SATW_FROM_PRECIP_import = (TImportCommand*) SATW_FROM_PRECIP.GetCommand("SATW_FROM_PRECIP_import",TCommand::kUndefined,TCommand::kImport);
	SATW_FROM_PRECIP_import->Code() = "Import SATW_FROM_PRECIP from HYDROLOGY_module";
	SATW_FROM_PRECIP_import->AddDependency(SATW_FROM_PRECIP);
	SATW_FROM_PRECIP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CELL_SIZE_import = (TImportCommand*) CELL_SIZE.GetCommand("CELL_SIZE_import",TCommand::kUndefined,TCommand::kImport);
	CELL_SIZE_import->Code() = "Import CELL_SIZE from GLOBALS_module";
	CELL_SIZE_import->AddDependency(CELL_SIZE);
	CELL_SIZE_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* AIR_TEMP_C_import = (TImportCommand*) AIR_TEMP_C.GetCommand("AIR_TEMP_C_import",TCommand::kUndefined,TCommand::kImport);
	AIR_TEMP_C_import->Code() = "Import AIR_TEMP_C from GLOBALS_module";
	AIR_TEMP_C_import->AddDependency(AIR_TEMP_C);
	AIR_TEMP_C_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SATW_TO_SW_UPFLOW_import = (TImportCommand*) SATW_TO_SW_UPFLOW.GetCommand("SATW_TO_SW_UPFLOW_import",TCommand::kUndefined,TCommand::kImport);
	SATW_TO_SW_UPFLOW_import->Code() = "Import SATW_TO_SW_UPFLOW from HYDROLOGY_module";
	SATW_TO_SW_UPFLOW_import->AddDependency(SATW_TO_SW_UPFLOW);
	SATW_TO_SW_UPFLOW_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PHBIO_NPP_import = (TImportCommand*) PHBIO_NPP.GetCommand("PHBIO_NPP_import",TCommand::kUndefined,TCommand::kImport);
	PHBIO_NPP_import->Code() = "Import PHBIO_NPP from MACROPHYTES_module";
	PHBIO_NPP_import->AddDependency(PHBIO_NPP);
	PHBIO_NPP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* UW_DEPTH_import = (TImportCommand*) UW_DEPTH.GetCommand("UW_DEPTH_import",TCommand::kUndefined,TCommand::kImport);
	UW_DEPTH_import->Code() = "Import UW_DEPTH from HYDROLOGY_module";
	UW_DEPTH_import->AddDependency(UW_DEPTH);
	UW_DEPTH_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ELEVATION_import = (TImportCommand*) ELEVATION.GetCommand("ELEVATION_import",TCommand::kUndefined,TCommand::kImport);
	ELEVATION_import->Code() = "Import ELEVATION from GLOBALS_module";
	ELEVATION_import->AddDependency(ELEVATION);
	ELEVATION_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SATW_OUTFLUX_import = (TImportCommand*) SATW_OUTFLUX.GetCommand("SATW_OUTFLUX_import",TCommand::kUndefined,TCommand::kImport);
	SATW_OUTFLUX_import->Code() = "Import SATW_OUTFLUX from HYDROLOGY_module";
	SATW_OUTFLUX_import->AddDependency(SATW_OUTFLUX);
	SATW_OUTFLUX_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SW_OUTFLUX_import = (TImportCommand*) SW_OUTFLUX.GetCommand("SW_OUTFLUX_import",TCommand::kUndefined,TCommand::kImport);
	SW_OUTFLUX_import->Code() = "Import SW_OUTFLUX from HYDROLOGY_module";
	SW_OUTFLUX_import->AddDependency(SW_OUTFLUX);
	SW_OUTFLUX_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DAYJUL_import = (TImportCommand*) DAYJUL.GetCommand("DAYJUL_import",TCommand::kUndefined,TCommand::kImport);
	DAYJUL_import->Code() = "Import DAYJUL from GLOBALS_module";
	DAYJUL_import->AddDependency(DAYJUL);
	DAYJUL_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* HABITATMAP_import = (TImportCommand*) HABITATMAP.GetCommand("HABITATMAP_import",TCommand::kUndefined,TCommand::kImport);
	HABITATMAP_import->Code() = "Import HABITATMAP from GLOBALS_module";
	HABITATMAP_import->AddDependency(HABITATMAP);
	HABITATMAP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ROOT_DEPTH_import = (TImportCommand*) ROOT_DEPTH.GetCommand("ROOT_DEPTH_import",TCommand::kUndefined,TCommand::kImport);
	ROOT_DEPTH_import->Code() = "Import ROOT_DEPTH from MACROPHYTES_module";
	ROOT_DEPTH_import->AddDependency(ROOT_DEPTH);
	ROOT_DEPTH_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SURFACE_WATER_import = (TImportCommand*) SURFACE_WATER.GetCommand("SURFACE_WATER_import",TCommand::kUndefined,TCommand::kImport);
	SURFACE_WATER_import->Code() = "Import SURFACE_WATER from HYDROLOGY_module";
	SURFACE_WATER_import->AddDependency(SURFACE_WATER);
	SURFACE_WATER_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* D_DECOMP_import = (TImportCommand*) D_DECOMP.GetCommand("D_DECOMP_import",TCommand::kUndefined,TCommand::kImport);
	D_DECOMP_import->Code() = "Import D_DECOMP from DOM_module";
	D_DECOMP_import->AddDependency(D_DECOMP);
	D_DECOMP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_SEWERMAP_import = (TImportCommand*) P1_SEWERMAP.GetCommand("P1_SEWERMAP_import",TCommand::kUndefined,TCommand::kImport);
	P1_SEWERMAP_import->Code() = "Import P1_SEWERMAP from GLOBALS_module";
	P1_SEWERMAP_import->AddDependency(P1_SEWERMAP);
	P1_SEWERMAP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_POP_DENS_import = (TImportCommand*) P1_POP_DENS.GetCommand("P1_POP_DENS_import",TCommand::kUndefined,TCommand::kImport);
	P1_POP_DENS_import->Code() = "Import P1_POP_DENS from GLOBALS_module";
	P1_POP_DENS_import->AddDependency(P1_POP_DENS);
	P1_POP_DENS_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u332 = (TExecuteCommand*) ATM_FLOW.GetCommand("u332",TCommand::kUpdate,TCommand::kCode);
	u332->SetExecutable(&ATM_FLOW_u332_exe_g);
	u332->Code() = "u332 <- ( FROM_ATMOS*((float)10) )";
	u332->AddDependency(FROM_ATMOS);
	u332->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u335 = (TExecuteCommand*) DIN_DNFLOW.GetCommand("u335",TCommand::kUpdate,TCommand::kCode);
	u335->SetExecutable(&DIN_DNFLOW_u335_exe_g);
	u335->Code() = "u335 <- SL::Min(( DIN_SF/dT() ), ( ( DINSF_CONC*P1_DIN_DIFFCOEF )*( ( UW_FROM_PRECIP+SW_TO_SATW_DOWNFLOW )+SATW_FROM_PRECIP ) ))";
	if( DIN_DNFLOW.GetF(FisClamped) ) { u335->AddDependency(DIN_SF); }
	u335->AddDependency(DIN_SF);
	u335->AddDependency(DINSF_CONC);
	u335->AddDependency(P1_DIN_DIFFCOEF);
	u335->AddDependency(UW_FROM_PRECIP);
	u335->AddDependency(SW_TO_SATW_DOWNFLOW);
	u335->AddDependency(SATW_FROM_PRECIP);
	u335->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u336 = (TExecuteCommand*) FROM_PS_DINSD.GetCommand("u336",TCommand::kUpdate,TCommand::kCode);
	u336->SetExecutable(&FROM_PS_DINSD_u336_exe_g);
	u336->Code() = "u336 <- ( ( ((float)1000)*N_NPOINTSD )/CELL_SIZE )";
	u336->AddDependency(N_NPOINTSD);
	u336->AddDependency(CELL_SIZE);
	u336->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u337 = (TExecuteCommand*) DOM_TO_DINSD.GetCommand("u337",TCommand::kUpdate,TCommand::kCode);
	u337->SetExecutable(&DOM_TO_DINSD_u337_exe_g);
	u337->Code() = "u337 <- ( DOM_TO_DIN*( ((float)1)-P1_DIN_GRAD ) )";
	u337->AddDependency(DOM_TO_DIN);
	u337->AddDependency(P1_DIN_GRAD);
	u337->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u338 = (TExecuteCommand*) DINSD_DENIT.GetCommand("u338",TCommand::kUpdate,TCommand::kCode);
	u338->SetExecutable(&DINSD_DENIT_u338_exe_g);
	u338->Code() = "u338 <- SL::Min(( DIN_SD/dT() ), ( ( ( P1_DIN_RCDENIT*pow((double)1.04,(double)( AIR_TEMP_C-((float)20) ) ) )*P1_DOMSD_ANAEROB_Z )*DIN_SD ))";
	if( DINSD_DENIT.GetF(FisClamped) ) { u338->AddDependency(DIN_SD); }
	u338->AddDependency(DIN_SD);
	u338->AddDependency(P1_DIN_RCDENIT);
	u338->AddDependency(AIR_TEMP_C);
	u338->AddDependency(P1_DOMSD_ANAEROB_Z);
	u338->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u339 = (TExecuteCommand*) DIN_UPFLOW.GetCommand("u339",TCommand::kUpdate,TCommand::kCode);
	u339->SetExecutable(&DIN_UPFLOW_u339_exe_g);
	u339->Code() = "u339 <- SL::Min(SL::Max(((float)0), ( ( DIN_SD/dT() )-DINSD_PR1 )), ( DINSD_CONC*SATW_TO_SW_UPFLOW ))";
	if( DIN_UPFLOW.GetF(FisClamped) ) { u339->AddDependency(DIN_SD); }
	u339->AddDependency(DIN_SD);
	u339->AddDependency(DINSD_PR1);
	u339->AddDependency(DINSD_CONC);
	u339->AddDependency(SATW_TO_SW_UPFLOW);
	u339->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u340 = (TExecuteCommand*) DINSD_UPTAKE.GetCommand("u340",TCommand::kUpdate,TCommand::kCode);
	u340->SetExecutable(&DINSD_UPTAKE_u340_exe_g);
	u340->Code() = "u340 <- SL::Min(SL::Max(((float)0), ( ( DIN_SD/dT() )-DINSD_PR2 )), DINSD_AVAIL, ( ( ( PHBIO_NPP*P1_PHBIO_NC )*P1_DIN_K_OF_NH4 )*((float)1000) ))";
	if( DINSD_UPTAKE.GetF(FisClamped) ) { u340->AddDependency(DIN_SD); }
	u340->AddDependency(DIN_SD);
	u340->AddDependency(DINSD_PR2);
	u340->AddDependency(DINSD_AVAIL);
	u340->AddDependency(PHBIO_NPP);
	u340->AddDependency(HABITATMAP);
	u340->AddDependency(P1_PHBIO_NC);
	u340->AddDependency(P1_DIN_K_OF_NH4);
	u340->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u341 = (TExecuteCommand*) DINSD_HOUT.GetCommand("u341",TCommand::kUpdate,TCommand::kCode);
	u341->SetExecutable(&DINSD_HOUT_u341_exe_g);
	u341->Code() = "u341 <- ( P1_DINSD_OUT*SL::Min(SL::Max(((float)0), ( ( DIN_SD/dT() )-DINSD_PR3 )),  ( ( ( UW_DEPTH <= P1_R_SUB ) ) ? ( ( ( ( ( DIN_SD*( ( ( ( ((float)2)*ELEVATION )-P1_R_SUB )-UW_DEPTH )-SATW_OUTFLUX ) )*SATW_OUTFLUX )/( ELEVATION-P1_R_SUB ) )/( ELEVATION-UW_DEPTH ) ) ) : ( ( ( ( ( DIN_SD*( ( ( ((float)2)*ELEVATION )-( ((float)2)*UW_DEPTH ) )-SATW_OUTFLUX ) )*SATW_OUTFLUX )/( ( ELEVATION+UW_DEPTH )-( ((float)2)*P1_R_SUB ) ) )/( ELEVATION-UW_DEPTH ) ) ) ) ) )";
	if( DINSD_HOUT.GetF(FisClamped) ) { u341->AddDependency(DIN_SD); }
	u341->AddDependency(P1_DINSD_OUT);
	u341->AddDependency(DIN_SD);
	u341->AddDependency(DINSD_PR3);
	u341->AddDependency(UW_DEPTH);
	u341->AddDependency(P1_R_SUB);
	u341->AddDependency(ELEVATION);
	u341->AddDependency(SATW_OUTFLUX);
	u341->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u344 = (TExecuteCommand*) FROM_ATMOS.GetCommand("u344",TCommand::kUpdate,TCommand::kCode);
	u344->SetExecutable(&FROM_ATMOS_u344_exe_g);
	u344->Code() = "u344 <- ( DIN_IN_RAIN*P1_ATMOS_FACTOR )";
	u344->AddDependency(DIN_IN_RAIN);
	u344->AddDependency(P1_ATMOS_FACTOR);
	u344->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u345 = (TExecuteCommand*) DOM_TO_DINSF.GetCommand("u345",TCommand::kUpdate,TCommand::kCode);
	u345->SetExecutable(&DOM_TO_DINSF_u345_exe_g);
	u345->Code() = "u345 <- ( DOM_TO_DIN*P1_DIN_GRAD )";
	u345->AddDependency(DOM_TO_DIN);
	u345->AddDependency(P1_DIN_GRAD);
	u345->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u346 = (TExecuteCommand*) FERT_AV.GetCommand("u346",TCommand::kUpdate,TCommand::kCode);
	u346->SetExecutable(&FERT_AV_u346_exe_g);
	u346->Code() = "u346 <- ( P1_DIN_FERT_DIS*FERTILIZER )";
	if( FERT_AV.GetF(FisClamped) ) { u346->AddDependency(FERTILIZER); }
	u346->AddDependency(P1_DIN_FERT_DIS);
	u346->AddDependency(FERTILIZER);
	u346->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u347 = (TExecuteCommand*) FROM_PS.GetCommand("u347",TCommand::kUpdate,TCommand::kCode);
	u347->SetExecutable(&FROM_PS_u347_exe_g);
	u347->Code() = "u347 <- ( ( P1_POINTNSF*P1_PS_FACTOR )/CELL_SIZE )";
	u347->AddDependency(P1_POINTNSF);
	u347->AddDependency(P1_PS_FACTOR);
	u347->AddDependency(CELL_SIZE);
	u347->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u348 = (TExecuteCommand*) DINSF_UPTAKE.GetCommand("u348",TCommand::kUpdate,TCommand::kCode);
	u348->SetExecutable(&DINSF_UPTAKE_u348_exe_g);
	u348->Code() = "u348 <- SL::Min(SL::Max(((float)0), ( ( DIN_SF/dT() )-DINSF_PR1 )), DINSF_AVAIL, ( ( ( PHBIO_NPP*P1_PHBIO_NC_SF )*P1_DIN_K_OF_NH4 )*((float)1000) ))";
	if( DINSF_UPTAKE.GetF(FisClamped) ) { u348->AddDependency(DIN_SF); }
	u348->AddDependency(DIN_SF);
	u348->AddDependency(DINSF_PR1);
	u348->AddDependency(DINSF_AVAIL);
	u348->AddDependency(PHBIO_NPP);
	u348->AddDependency(HABITATMAP);
	u348->AddDependency(P1_PHBIO_NC_SF);
	u348->AddDependency(P1_DIN_K_OF_NH4);
	u348->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u349 = (TExecuteCommand*) DINSF_OUT.GetCommand("u349",TCommand::kUpdate,TCommand::kCode);
	u349->SetExecutable(&DINSF_OUT_u349_exe_g);
	u349->Code() = "u349 <- SL::Min(SL::Max(((float)0), ( ( DIN_SF/dT() )-DINSF_PR2 )), ( ( P1_DINSF_OUT*DINSF_CONC )*SW_OUTFLUX ))";
	if( DINSF_OUT.GetF(FisClamped) ) { u349->AddDependency(DIN_SF); }
	u349->AddDependency(DIN_SF);
	u349->AddDependency(DINSF_PR2);
	u349->AddDependency(P1_DINSF_OUT);
	u349->AddDependency(DINSF_CONC);
	u349->AddDependency(SW_OUTFLUX);
	u349->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I350 = (TExecuteCommand*) FERTILIZER.GetCommand("I350",TCommand::kIntegrate,TCommand::kCode);
	I350->SetExecutable(&FERTILIZER_I350_exe_g);
	I350->Code() = "I350 <- ( FROM_FERT-FERT_AV )";
	I350->AddDependency(FROM_FERT);
	I350->AddDependency(FERT_AV);
	I350->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i351 = (TExecuteCommand*) FERTILIZER.GetCommand("i351",TCommand::kInit,TCommand::kCode);
	i351->SetExecutable(&FERTILIZER_i351_exe_g);
	i351->Code() = "i351 <- ((float)0)";
	i351->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u352 = (TExecuteCommand*) FROM_FERT.GetCommand("u352",TCommand::kUpdate,TCommand::kCode);
	u352->SetExecutable(&FROM_FERT_u352_exe_g);
	u352->Code() = "u352 <-  ( ( ( DAYJUL == P1_DIN_DAY_FERT1 ) ) ? ( ( ( P1_DIN_FERT_APP*P1_DIN_FERT_HAB1 )*0.1 ) ) : (  ( ( ( DAYJUL == P1_DIN_DAY_FERT2 ) ) ? ( ( ( P1_DIN_FERT_APP*P1_DIN_FERT_HAB2 )*0.1 ) ) : ( ((float)0) ) )  ) ) ";
	u352->AddDependency(DAYJUL);
	u352->AddDependency(HABITATMAP);
	u352->AddDependency(P1_DIN_DAY_FERT1);
	u352->AddDependency(P1_DIN_FERT_APP);
	u352->AddDependency(P1_DIN_FERT_HAB1);
	u352->AddDependency(P1_DIN_DAY_FERT2);
	u352->AddDependency(P1_DIN_FERT_HAB2);
	u352->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I353 = (TExecuteCommand*) F_IN.GetCommand("I353",TCommand::kIntegrate,TCommand::kCode);
	I353->SetExecutable(&F_IN_I353_exe_g);
	I353->Code() = "I353 <- FERT_FLOW";
	I353->AddDependency(FERT_FLOW);
	I353->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i354 = (TExecuteCommand*) F_IN.GetCommand("i354",TCommand::kInit,TCommand::kCode);
	i354->SetExecutable(&F_IN_i354_exe_g);
	i354->Code() = "i354 <- ((float)0)";
	i354->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u355 = (TExecuteCommand*) FERT_FLOW.GetCommand("u355",TCommand::kUpdate,TCommand::kCode);
	u355->SetExecutable(&FERT_FLOW_u355_exe_g);
	u355->Code() = "u355 <- ( FROM_FERT*((float)10) )";
	u355->AddDependency(FROM_FERT);
	u355->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I356 = (TExecuteCommand*) M_IN.GetCommand("I356",TCommand::kIntegrate,TCommand::kCode);
	I356->SetExecutable(&M_IN_I356_exe_g);
	I356->Code() = "I356 <- MINER_FLOW";
	I356->AddDependency(MINER_FLOW);
	I356->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i357 = (TExecuteCommand*) M_IN.GetCommand("i357",TCommand::kInit,TCommand::kCode);
	i357->SetExecutable(&M_IN_i357_exe_g);
	i357->Code() = "i357 <- ((float)0)";
	i357->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u358 = (TExecuteCommand*) MINER_FLOW.GetCommand("u358",TCommand::kUpdate,TCommand::kCode);
	u358->SetExecutable(&MINER_FLOW_u358_exe_g);
	u358->Code() = "u358 <- ( ( DOM_TO_DINSD+DOM_TO_DINSF )*((float)10) )";
	u358->AddDependency(DOM_TO_DINSD);
	u358->AddDependency(DOM_TO_DINSF);
	u358->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I359 = (TExecuteCommand*) S_IN.GetCommand("I359",TCommand::kIntegrate,TCommand::kCode);
	I359->SetExecutable(&S_IN_I359_exe_g);
	I359->Code() = "I359 <- SEPTIC_FLOW";
	I359->AddDependency(SEPTIC_FLOW);
	I359->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i360 = (TExecuteCommand*) S_IN.GetCommand("i360",TCommand::kInit,TCommand::kCode);
	i360->SetExecutable(&S_IN_i360_exe_g);
	i360->Code() = "i360 <- ((float)0)";
	i360->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u361 = (TExecuteCommand*) SEPTIC_FLOW.GetCommand("u361",TCommand::kUpdate,TCommand::kCode);
	u361->SetExecutable(&SEPTIC_FLOW_u361_exe_g);
	u361->Code() = "u361 <- ( FROM_PS_DINSD*((float)10) )";
	u361->AddDependency(FROM_PS_DINSD);
	u361->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u362 = (TExecuteCommand*) COUNTY.GetCommand("u362",TCommand::kUpdate,TCommand::kCode);
	u362->SetExecutable(&COUNTY_u362_exe_g);
	u362->Code() = "u362 <- ( ((float)1)+( ((float)0)*HABITATMAP ) )";
	u362->AddDependency(HABITATMAP);
	u362->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u363 = (TExecuteCommand*) CROP.GetCommand("u363",TCommand::kUpdate,TCommand::kCode);
	u363->SetExecutable(&CROP_u363_exe_g);
	u363->Code() = "u363 <- ( ((float)1)+( ((float)0)*HABITATMAP ) )";
	u363->AddDependency(HABITATMAP);
	u363->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u364 = (TExecuteCommand*) DINSD_AVAIL.GetCommand("u364",TCommand::kUpdate,TCommand::kCode);
	u364->SetExecutable(&DINSD_AVAIL_u364_exe_g);
	u364->Code() = "u364 <-  ( ( ( ROOT_DEPTH <= P1_R_SUB ) ) ? ( ((float)0) ) : ( ( DIN_SD* ( ( ( ( ROOT_DEPTH >  P1_R_SUB ) && ( P1_R_SUB >= UW_DEPTH ) ) ) ? ( ( ( ( ( ( ( ((float)2)*ELEVATION )-UW_DEPTH )-ROOT_DEPTH )*( ROOT_DEPTH-P1_R_SUB ) )/( ELEVATION-ROOT_DEPTH ) )/( ELEVATION-UW_DEPTH ) ) ) : (  ( ( ( ( P1_R_SUB <= ROOT_DEPTH ) && ( ROOT_DEPTH <  UW_DEPTH ) ) ) ? ( ( ( ((float)2)*( ROOT_DEPTH-P1_R_SUB ) )/( ELEVATION-P1_R_SUB ) ) ) : ( ( ( ( ((float)2)*( UW_DEPTH-P1_R_SUB ) )+( ( ( ( ( ((float)2)*ELEVATION )-UW_DEPTH )-ROOT_DEPTH )*( ROOT_DEPTH-UW_DEPTH ) )/( ELEVATION-UW_DEPTH ) ) )/( ( ELEVATION+UW_DEPTH )-( ((float)2)*P1_R_SUB ) ) ) ) )  ) )  ) ) ) ";
	u364->AddDependency(ROOT_DEPTH);
	u364->AddDependency(P1_R_SUB);
	u364->AddDependency(DIN_SD);
	u364->AddDependency(UW_DEPTH);
	u364->AddDependency(ELEVATION);
	u364->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u365 = (TExecuteCommand*) DINSD_CONC.GetCommand("u365",TCommand::kUpdate,TCommand::kCode);
	u365->SetExecutable(&DINSD_CONC_u365_exe_g);
	u365->Code() = "u365 <- ( DIN_SD/( SAT_WATER+UNSAT_WATER ) )";
	u365->AddDependency(DIN_SD);
	u365->AddDependency(SAT_WATER);
	u365->AddDependency(UNSAT_WATER);
	u365->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u366 = (TExecuteCommand*) DINSD_PR1.GetCommand("u366",TCommand::kUpdate,TCommand::kCode);
	u366->SetExecutable(&DINSD_PR1_u366_exe_g);
	u366->Code() = "u366 <- DINSD_DENIT";
	u366->AddDependency(DINSD_DENIT);
	u366->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u367 = (TExecuteCommand*) DINSD_PR2.GetCommand("u367",TCommand::kUpdate,TCommand::kCode);
	u367->SetExecutable(&DINSD_PR2_u367_exe_g);
	u367->Code() = "u367 <- ( DIN_UPFLOW+DINSD_PR1 )";
	u367->AddDependency(DIN_UPFLOW);
	u367->AddDependency(DINSD_PR1);
	u367->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u368 = (TExecuteCommand*) DINSD_PR3.GetCommand("u368",TCommand::kUpdate,TCommand::kCode);
	u368->SetExecutable(&DINSD_PR3_u368_exe_g);
	u368->Code() = "u368 <- ( DINSD_UPTAKE+DINSD_PR2 )";
	u368->AddDependency(DINSD_UPTAKE);
	u368->AddDependency(DINSD_PR2);
	u368->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u369 = (TExecuteCommand*) DINSF_AVAIL.GetCommand("u369",TCommand::kUpdate,TCommand::kCode);
	u369->SetExecutable(&DINSF_AVAIL_u369_exe_g);
	u369->Code() = "u369 <-  ( ( ( SURFACE_WATER >  ((float)0) ) ) ? ( ( DINSF_CONC*( SURFACE_WATER+SR_WATER ) ) ) : ( ( ( DINSF_CONC*( ((float)1)-P1_DIN_DIFFCOEF ) )*SR_WATER ) ) ) ";
	u369->AddDependency(SURFACE_WATER);
	u369->AddDependency(DINSF_CONC);
	u369->AddDependency(SR_WATER);
	u369->AddDependency(P1_DIN_DIFFCOEF);
	u369->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u370 = (TExecuteCommand*) DINSF_CONC.GetCommand("u370",TCommand::kUpdate,TCommand::kCode);
	u370->SetExecutable(&DINSF_CONC_u370_exe_g);
	u370->Code() = "u370 <-  ( ( ( ( SURFACE_WATER+SR_WATER ) >  0.0 ) ) ? ( ( DIN_SF/( SURFACE_WATER+SR_WATER ) ) ) : ( ((float)0) ) ) ";
	u370->AddDependency(SURFACE_WATER);
	u370->AddDependency(SR_WATER);
	u370->AddDependency(DIN_SF);
	u370->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u371 = (TExecuteCommand*) DINSF_PR1.GetCommand("u371",TCommand::kUpdate,TCommand::kCode);
	u371->SetExecutable(&DINSF_PR1_u371_exe_g);
	u371->Code() = "u371 <- DIN_DNFLOW";
	u371->AddDependency(DIN_DNFLOW);
	u371->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u372 = (TExecuteCommand*) DINSF_PR2.GetCommand("u372",TCommand::kUpdate,TCommand::kCode);
	u372->SetExecutable(&DINSF_PR2_u372_exe_g);
	u372->Code() = "u372 <- ( DINSF_PR1+DINSF_UPTAKE )";
	u372->AddDependency(DINSF_PR1);
	u372->AddDependency(DINSF_UPTAKE);
	u372->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u374 = (TExecuteCommand*) DOM_TO_DIN.GetCommand("u374",TCommand::kUpdate,TCommand::kCode);
	u374->SetExecutable(&DOM_TO_DIN_u374_exe_g);
	u374->Code() = "u374 <- ( ( ( ( D_DECOMP*P1_DOM_NC )*P1_DOM_CTOOM )*P1_DIN_CR_SED_MIN )*((float)1000) )";
	u374->AddDependency(D_DECOMP);
	u374->AddDependency(HABITATMAP);
	u374->AddDependency(P1_DOM_NC);
	u374->AddDependency(P1_DOM_CTOOM);
	u374->AddDependency(P1_DIN_CR_SED_MIN);
	u374->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u375 = (TExecuteCommand*) N_NPOINTSD.GetCommand("u375",TCommand::kUpdate,TCommand::kCode);
	u375->SetExecutable(&N_NPOINTSD_u375_exe_g);
	u375->Code() = "u375 <-  ( ( ( P1_SEWERMAP == ((float)3) ) ) ? ( ((float)0) ) : ( ( ( P1_SEPTICLOAD*P1_POP_DENS )*P1_SEPTIC_RED ) ) ) ";
	u375->AddDependency(P1_SEWERMAP);
	u375->AddDependency(P1_SEPTICLOAD);
	u375->AddDependency(P1_POP_DENS);
	u375->AddDependency(P1_SEPTIC_RED);
	u375->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u376 = (TExecuteCommand*) OUTPUTCOL.GetCommand("u376",TCommand::kUpdate,TCommand::kCode);
	u376->SetExecutable(&OUTPUTCOL_u376_exe_g);
	u376->Code() = "u376 <- 23";
	u376->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u377 = (TExecuteCommand*) OUTPUTROW.GetCommand("u377",TCommand::kUpdate,TCommand::kCode);
	u377->SetExecutable(&OUTPUTROW_u377_exe_g);
	u377->Code() = "u377 <- 12";
	u377->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u378 = (TExecuteCommand*) OUTPUTVAR.GetCommand("u378",TCommand::kUpdate,TCommand::kCode);
	u378->SetExecutable(&OUTPUTVAR_u378_exe_g);
	u378->Code() = "u378 <- ( HABITATMAP*((float)0) )";
	u378->AddDependency(HABITATMAP);
	u378->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u379 = (TExecuteCommand*) SR_WATER.GetCommand("u379",TCommand::kUpdate,TCommand::kCode);
	u379->SetExecutable(&SR_WATER_u379_exe_g);
	u379->Code() = "u379 <-  ( ( ( P1_R_SUB <  UW_DEPTH ) ) ? ( ( ( UNSAT_WATER*P1_R_SUB )/UW_DEPTH ) ) : ( ( UNSAT_WATER+( ( ( P1_R_SUB-UW_DEPTH )/( ELEVATION-UW_DEPTH ) )*SAT_WATER ) ) ) ) ";
	u379->AddDependency(P1_R_SUB);
	u379->AddDependency(UW_DEPTH);
	u379->AddDependency(UNSAT_WATER);
	u379->AddDependency(ELEVATION);
	u379->AddDependency(SAT_WATER);
	u379->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u380 = (TExecuteCommand*) ZONMAP.GetCommand("u380",TCommand::kUpdate,TCommand::kCode);
	u380->SetExecutable(&ZONMAP_u380_exe_g);
	u380->Code() = "u380 <- ( ((float)0)+( ((float)0)*HABITATMAP ) )";
	u380->AddDependency(HABITATMAP);
	u380->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u381 = (TExecuteCommand*) P1_ATMOS_FACTOR.GetCommand("u381",TCommand::kUpdate,TCommand::kCode);
	u381->SetExecutable(&P1_ATMOS_FACTOR_u381_exe_g);
	u381->Code() = "u381 <- 0.214";
	u381->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u382 = (TExecuteCommand*) P1_DINSD_OUT.GetCommand("u382",TCommand::kUpdate,TCommand::kCode);
	u382->SetExecutable(&P1_DINSD_OUT_u382_exe_g);
	u382->Code() = "u382 <- 0";
	u382->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u383 = (TExecuteCommand*) P1_DINSF_OUT.GetCommand("u383",TCommand::kUpdate,TCommand::kCode);
	u383->SetExecutable(&P1_DINSF_OUT_u383_exe_g);
	u383->Code() = "u383 <- 0";
	u383->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u384 = (TExecuteCommand*) P1_DIN_CR_SED_MIN.GetCommand("u384",TCommand::kUpdate,TCommand::kCode);
	u384->SetExecutable(&P1_DIN_CR_SED_MIN_u384_exe_g);
	u384->Code() = "u384 <- 0.2";
	u384->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u385 = (TExecuteCommand*) P1_DIN_DAY_FERT1.GetCommand("u385",TCommand::kUpdate,TCommand::kCode);
	u385->SetExecutable(&P1_DIN_DAY_FERT1_u385_exe_g);
	u385->Code() = "u385 <- ((float)191)";
	u385->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u386 = (TExecuteCommand*) P1_DIN_DAY_FERT2.GetCommand("u386",TCommand::kUpdate,TCommand::kCode);
	u386->SetExecutable(&P1_DIN_DAY_FERT2_u386_exe_g);
	u386->Code() = "u386 <- ((float)999)";
	u386->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u387 = (TExecuteCommand*) P1_DIN_DIFFCOEF.GetCommand("u387",TCommand::kUpdate,TCommand::kCode);
	u387->SetExecutable(&P1_DIN_DIFFCOEF_u387_exe_g);
	u387->Code() = "u387 <- 0.7";
	u387->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u388 = (TExecuteCommand*) P1_DIN_FERT_APP.GetCommand("u388",TCommand::kUpdate,TCommand::kCode);
	u388->SetExecutable(&P1_DIN_FERT_APP_u388_exe_g);
	u388->Code() = "u388 <- ((float)145)";
	u388->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u389 = (TExecuteCommand*) P1_DIN_FERT_DIS.GetCommand("u389",TCommand::kUpdate,TCommand::kCode);
	u389->SetExecutable(&P1_DIN_FERT_DIS_u389_exe_g);
	u389->Code() = "u389 <- 0.050000";
	u389->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u390 = (TExecuteCommand*) P1_DIN_FERT_HAB1.GetCommand("u390",TCommand::kUpdate,TCommand::kCode);
	u390->SetExecutable(&P1_DIN_FERT_HAB1_u390_exe_g);
	u390->Code() = "u390 <- 0.75";
	u390->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u391 = (TExecuteCommand*) P1_DIN_FERT_HAB2.GetCommand("u391",TCommand::kUpdate,TCommand::kCode);
	u391->SetExecutable(&P1_DIN_FERT_HAB2_u391_exe_g);
	u391->Code() = "u391 <- ((float)0)";
	u391->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u392 = (TExecuteCommand*) P1_DIN_GRAD.GetCommand("u392",TCommand::kUpdate,TCommand::kCode);
	u392->SetExecutable(&P1_DIN_GRAD_u392_exe_g);
	u392->Code() = "u392 <- 0.7";
	u392->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u393 = (TExecuteCommand*) P1_DIN_ICSED.GetCommand("u393",TCommand::kUpdate,TCommand::kCode);
	u393->SetExecutable(&P1_DIN_ICSED_u393_exe_g);
	u393->Code() = "u393 <- 0.15";
	u393->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u394 = (TExecuteCommand*) P1_DIN_ICSF.GetCommand("u394",TCommand::kUpdate,TCommand::kCode);
	u394->SetExecutable(&P1_DIN_ICSF_u394_exe_g);
	u394->Code() = "u394 <- 0.3";
	u394->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u395 = (TExecuteCommand*) P1_DIN_K_OF_NH4.GetCommand("u395",TCommand::kUpdate,TCommand::kCode);
	u395->SetExecutable(&P1_DIN_K_OF_NH4_u395_exe_g);
	u395->Code() = "u395 <- 0.5";
	u395->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u396 = (TExecuteCommand*) P1_DIN_RCDENIT.GetCommand("u396",TCommand::kUpdate,TCommand::kCode);
	u396->SetExecutable(&P1_DIN_RCDENIT_u396_exe_g);
	u396->Code() = "u396 <- 0.001";
	u396->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u397 = (TExecuteCommand*) P1_DOMSD_ANAEROB_Z.GetCommand("u397",TCommand::kUpdate,TCommand::kCode);
	u397->SetExecutable(&P1_DOMSD_ANAEROB_Z_u397_exe_g);
	u397->Code() = "u397 <- 1";
	u397->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u398 = (TExecuteCommand*) P1_DOM_CTOOM.GetCommand("u398",TCommand::kUpdate,TCommand::kCode);
	u398->SetExecutable(&P1_DOM_CTOOM_u398_exe_g);
	u398->Code() = "u398 <- 0.2";
	u398->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u399 = (TExecuteCommand*) P1_DOM_NC.GetCommand("u399",TCommand::kUpdate,TCommand::kCode);
	u399->SetExecutable(&P1_DOM_NC_u399_exe_g);
	u399->Code() = "u399 <- ((float)0)";
	u399->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u400 = (TExecuteCommand*) P1_PHBIO_NC.GetCommand("u400",TCommand::kUpdate,TCommand::kCode);
	u400->SetExecutable(&P1_PHBIO_NC_u400_exe_g);
	u400->Code() = "u400 <- 0.1";
	u400->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u401 = (TExecuteCommand*) P1_PHBIO_NC_SF.GetCommand("u401",TCommand::kUpdate,TCommand::kCode);
	u401->SetExecutable(&P1_PHBIO_NC_SF_u401_exe_g);
	u401->Code() = "u401 <- 0.01";
	u401->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u402 = (TExecuteCommand*) P1_POINTNSF.GetCommand("u402",TCommand::kUpdate,TCommand::kCode);
	u402->SetExecutable(&P1_POINTNSF_u402_exe_g);
	u402->Code() = "u402 <- ((float)0)";
	u402->SetObjInfo(TCommand::kDepIndex, 5);
	TImportCommand* P1_POINTNSF_import = (TImportCommand*) P1_POINTNSF.GetCommand("P1_POINTNSF_import",TCommand::kUndefined,TCommand::kImport);
	P1_POINTNSF_import->Code() = "Import P1_POINTNSF from external";
	P1_POINTNSF_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u403 = (TExecuteCommand*) P1_PS_FACTOR.GetCommand("u403",TCommand::kUpdate,TCommand::kCode);
	u403->SetExecutable(&P1_PS_FACTOR_u403_exe_g);
	u403->Code() = "u403 <- 454";
	u403->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u404 = (TExecuteCommand*) P1_R_SUB.GetCommand("u404",TCommand::kUpdate,TCommand::kCode);
	u404->SetExecutable(&P1_R_SUB_u404_exe_g);
	u404->Code() = "u404 <- 0.1";
	u404->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u405 = (TExecuteCommand*) P1_SEPTICLOAD.GetCommand("u405",TCommand::kUpdate,TCommand::kCode);
	u405->SetExecutable(&P1_SEPTICLOAD_u405_exe_g);
	u405->Code() = "u405 <- 0.0132";
	u405->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u406 = (TExecuteCommand*) P1_SEPTIC_RED.GetCommand("u406",TCommand::kUpdate,TCommand::kCode);
	u406->SetExecutable(&P1_SEPTIC_RED_u406_exe_g);
	u406->Code() = "u406 <- 0.4";
	u406->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u407 = (TExecuteCommand*) DIN_IN_RAIN.GetCommand("u407",TCommand::kUpdate,TCommand::kCode);
	u407->SetExecutable(&DIN_IN_RAIN_u407_exe_g);
	u407->Code() = "u407 <- Graph45(DAYJUL)";
	u407->AddDependency(DAYJUL);
	u407->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DIN_IN_RAIN_import = (TImportCommand*) DIN_IN_RAIN.GetCommand("DIN_IN_RAIN_import",TCommand::kUndefined,TCommand::kImport);
	DIN_IN_RAIN_import->Code() = "Import DIN_IN_RAIN from external";
	DIN_IN_RAIN_import->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int ZDIN_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int ZDIN_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int ZDIN_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int ZDIN_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}
