/* gcc -g -o process process.c 
   
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define MAX 10
#define TOTAL 3000
#define MAXLENGTH 1000
#define MAXPERC 10
#define MINPERC 50
#define NOUTCOL 7   //was 8
#define WSOUTCOL 1
#define GOUTCOL 6
#define OUTFCOL 7
#define INFILTCOL 3   //was 5

void errormessage ( char *ss)
    	{ printf ("%s\n",ss); 
    	  exit (0);
    	}



void main(int argc, char *argv[])  
{
    int i, j, k, jj, col, nummax, nummin, p, total, start ;
    FILE *fin, *fout;
    char s[MAXLENGTH];
    float *ffmax, *ffmin;
    float vv, sum, mini, maxi, toti;

    
    if (argc < 4) errormessage ("Usage: process scen_name #n_lines #first_line");
    
    if ( (fout = fopen ( "Table.file", "r" )) == NULL )
    {
	if ( (fout = fopen ( "Table.file", "w" )) == NULL )
	             errormessage ("Can't open output Table file!"); 
	fprintf ( fout, "scenario\tL atmosph\tL fertil\tL mineral\tL septic\taverage N\tmaximal N\tminimal N\tpeakflow W\tbaseflow W\taverage NGW\tNPP (kg/m2/y)" );
    }
    else
        if ( (fout = fopen ( "Table.file", "a" )) == NULL )
	         errormessage ("Can't open output Table file!"); 

    
    fprintf ( fout, "\n%s\t", argv[1] );

    sscanf ( argv[2], "%d", &total );
    sscanf ( argv[3], "%d", &start );
        
// do the INFILT file

    toti = 0.0;

    if ( (fin = fopen ( "Infilter", "r" )) == NULL )
	errormessage ("Can't open Infilter file!"); 
       
    for ( i = 0; i < total; i++ ) 
    	{ fgets(s, MAXLENGTH, fin ); /* skip the header and the first total lines */
    	}
          
    jj = 0;

    for ( j = 0; j < INFILTCOL; j++ ) jj += Skip ( s + jj ) + 1;

    sscanf ( s + jj, "%f", &vv );  jj += Skip ( s + jj ) + 1;
    fprintf ( fout, "%12.3f\t", vv/total);

    sscanf ( s + jj, "%f", &vv );  jj += Skip ( s + jj ) + 1;
    fprintf ( fout, "%12.3f\t", vv/total);

    sscanf ( s + jj, "%f", &vv );  jj += Skip ( s + jj ) + 1;
    fprintf ( fout, "%12.3f\t", vv/total);

    sscanf ( s + jj, "%f", &vv );  
    fprintf ( fout, "%12.3f\t", vv/total);

    fclose (fin);

// do the NOut file

    maxi = 0.0;
    mini = 9999999999.;
    toti = 0.0;

    if ( (fin = fopen ( "NOut", "r" )) == NULL )
	errormessage ("Can't open Nout file!"); 
       
     for ( i = 0; i < start+1; i++ ) 
    	{ fgets(s, MAXLENGTH, fin ); /* skip the header and the first start lines */
    	}

     while ( i < total ) 
       { 
          fgets(s, MAXLENGTH, fin );
          
          jj = 0;

          for ( j = 0; j < NOUTCOL; j++ ) jj += Skip ( s + jj ) + 1;
          sscanf ( s + jj, "%f", &vv );

	  if ( vv > maxi ) maxi = vv;
	  if ( vv < mini ) mini = vv;
	  toti += vv;
	  i++;
       }

    fprintf ( fout, "%12.3f\t%12.3f\t%12.3f\t", toti/(total-start), maxi, mini );
    fclose (fin);
fflush(fout);
// do the WSOut file

    if ( (fin = fopen ( "WSOut", "r" )) == NULL )
	errormessage ("Can't open WSOut file!"); 

    nummax = (total-start-2)*MAXPERC/100;
    ffmax = malloc ( sizeof(float)*(nummax+1) );
    for ( i = 0; i < nummax; i++ ) *(ffmax+i) = 0.; 

    nummin = (total-start-2)*MINPERC/100;
    ffmin = malloc ( sizeof(float)*(nummin+1) );
    for ( i = 0; i < nummin; i++ ) *(ffmin+i) = 9999999999.; 
 
    for ( k = 0; k < start+2; k++ ) 
    	{ fgets(s, MAXLENGTH, fin ); /* skip the two headers and the first start lines */
    	}

    while ( k++ < total ) 
       { 
          fgets(s, MAXLENGTH, fin );
          
          jj = 0;

          for ( i = 0; i < WSOUTCOL; i++ ) jj += Skip ( s + jj ) + 1;
          sscanf ( s + jj, "%f", &vv );

          for ( i = 0; i < nummax; i++ ) 
             if (vv > *(ffmax+i)) 
                 { 
                   for ( j = nummax; j > i; j-- ) *(ffmax+j) = *(ffmax+j-1);
                   *(ffmax+i) = vv; 
                   break;
                 }

          for ( i = 0; i < nummin; i++ ) 
             if (vv < *(ffmin+i)) 
                 { 
                   for ( j = nummin; j > i; j-- ) *(ffmin+j) = *(ffmin+j-1);
                   *(ffmin+i) = vv; 
                   break;
                 }
       }
    


    sum = 0.;
    for ( i = 0; i < nummax; i++ ) sum += *(ffmax+i);
    fprintf ( fout, "%12.3f\t", sum );
    
    sum = 0.;
    for ( i = 0; i < nummin; i++ ) sum += *(ffmin+i);
    fprintf ( fout, "%12.3f\t", sum );

    fclose (fin);

// do the GOut file

    toti = 0.0;

    if ( (fin = fopen ( "GOut", "r" )) == NULL )
	errormessage ("Can't open Gout file!"); 
       
     for ( i = 0; i < start+2; i++ ) 
    	{ fgets(s, MAXLENGTH, fin ); /* skip the two headers and the first start lines */
    	}

     while ( i++ < total ) 
       { 
          fgets(s, MAXLENGTH, fin );
          
          jj = 0;

          for ( j = 0; j < GOUTCOL; j++ ) jj += Skip ( s + jj ) + 1;
          sscanf ( s + jj, "%f", &vv );

	  toti += vv;
       }

    fprintf ( fout, "%12.3f\t", toti/(total-start) );
    fclose (fin);

// do the OUTPUT file

    toti = 0.0;

    if ( (fin = fopen ( "OutPutFile", "r" )) == NULL )
	errormessage ("Can't open Gout file!"); 
       
     for ( i = 0; i < start+1; i++ ) 
    	{ fgets(s, MAXLENGTH, fin ); /* skip the header and the first start lines */
    	}

     while ( i++ < total ) 
       { 
          fgets(s, MAXLENGTH, fin );
          
          jj = 0;

          for ( j = 0; j < OUTFCOL; j++ ) jj += Skip ( s + jj ) + 1;
          sscanf ( s + jj, "%f", &vv );

	  toti += vv;
       }

    fprintf ( fout, "%12.3f\t", toti);    //        *1000)/(total-start) );  in kg 
    fclose (fin);

    fclose (fout);

}
/***********************************************************/
/**** Skips chars in a string until TAB is encountered  ****/
/****         and returns number of chars skipped       ****/

int Skip (char *ss)
{ int i = 0;

	while (*ss++ != '\t') i++;
	return i;
}

