/**************************************************************************/
// Map Comparison routines
//@ 
/**************************************************************************/

#include "MapCompare.h"

/* das Programm soll mal zwei Karten vergleichen */

#define MAX_HAB 10
#define CLOSE_FILES_EACH_TIMESTEP 0

inline int round( float fval ) { 
  register int rv = (int)fval;
  return ( (fval-rv) > 0.5 ) ? ++rv : rv;
}


/* Berechnungverteilung 
 * ====================
 * calculates distribution of habitat id's for a given window with size w at location i,j */


int get_hab_window_stat( CVariable& hab, int r0, int c0, int w, int *a ) {
  int anz = 0;
  for(int i=0; i<MAX_HAB; i++) { a[i] = 0; }			/* reset a */

  DistributedGrid& grid = hab.Grid();
  grid.SetPointOrdering(0);	                 // Sets grid ordering to default

  for( Pix p = grid.first(); p; grid.next(p) ) {
    const OrderedPoint& pt = grid.GetPoint(p);
    int ir = pt.row();
    int ic = pt.col();
    int dr = ir-r0;
    int dc = ic-c0;
    if( ( dr >= 0 ) && ( dr < w ) && ( dc >= 0 ) && ( dc < w ) ) {
      int hab_index = round(hab(pt));
      a[ hab_index ]++;  /* increment element a indexed by habitat number */           
      anz++;
    }
  }
  return anz;
}


void MultiCompare2( CVariable& hab0, CVariable& hab1 ) {

  static FILE *outfile = NULL;
  CPathString pathName(Env::ArchivePath()); 
  pathName.Add("fw_out.dat");
  if( outfile == NULL ) {
    if ( (outfile = fopen (pathName, "w")) == NULL)  {
      gFatal( "UserCode MultiCompare2: Can't open output file! " );
    }
  }

  DistributedGrid& grid = hab0.Grid();
  Region2& r = grid.Region();
  int max_rows = r.extents(0);
  int max_cols = r.extents(1);
 
  int anz, count, test, empty; 			                         /* window size */
  int a0[MAX_HAB], a1[MAX_HAB];	                         /* distribution of habitats */
  int aux1;
  int cell_valid;
  float comp, sum, res;
  
  for (int w=1; w<30; w++) {

      count = 0;
      comp = 0;
      empty = 0.0;
      int nrows = max_rows-w+1;
      int ncols = max_cols-w+1;

      for(int ir=0; ir<nrows; ir++) {
	for(int ic=0; ic<ncols; ic++) {
	    anz = get_hab_window_stat(hab0, ir, ic, w, a0);
	    get_hab_window_stat(hab1, ir, ic, w, a1);	    
            count++;
	    aux1 = 0;
	    test = 0;
	    cell_valid = 0;
	    for (int k=0; k<MAX_HAB; k++) {
		cell_valid = ((a0[k]>0) || (a1[k]>0) || (cell_valid));
		aux1 += abs(a0[k] - a1[k]);
		if (a0[k]>0) test++;
	    }
	    if (cell_valid) {
              comp += 1.0 - (float)aux1/(2*anz);
             }
	    if (test == 0) empty++;
	}
      }
      sum = 0.0;
      res = comp/(count-empty);
     
      fprintf(outfile, " %g %g %d %d\n", (float)w, res, anz, comp);
  }
  if( CLOSE_FILES_EACH_TIMESTEP ) {
    fclose(outfile);
    outfile = null;
  }
}




