// Opt.cc
// Date: 6/19/01
// Project: HUNT0
// SME Version 3.2.41
// Contents:
// This files contains all functions required for calculating optimum land use
// maps. These function used to be in the File UCode.cc. For sake of clarity 
// and modularity I used to set up this file. Be shure to modify 
// <model>.MML.config when using this file.
//
// Funktions included are 
// void FertilizerMap( C... )
// void Goal_Func ( ... )
// MakeCropMap ( ... )

#include "Opt.h"

// Global vars from SWater.CC hand over total nutrient outflow 

// float  n_out_sum;
// float  n_out_conc;

#include <stdlib.h>

#define TIME0   1
#define TIME1 118
#define TIME2 190
#define TIME3 280
#define TIME4 324

#define WATER           1
#define FOREST          2
#define AGRI            3
#define FALLOW          6
#define CORN            7
#define WHEAT           8
#define SOY             9
#define CROPS           9
#define MAXFERTILIZER 150.0

static float lambda_n   = 0.4;

static float lambda_f   = 199.0*1.0e-6;
static float lambda_y[] = { 0.0, 0.0, 0.117, 0.0, 0.0, 0.0, 0.117, 0.153, 0.295 };

#define DIN_SF_OW_LIMIT 0.0
#define N_OUT_LIMIT     0.0
#define MAX_LAYER   6
#define MAX_POINT 2000

float fert_level[] = {0.0, 25.0, 50.0, 75.0, 100.0, 150.0};

/**************************************************************************/
/**************************************************************************/

/**************************************************************************/
#define COUNTY 7
#define SOILS 41

void FertilizerMap( CVariable& FertMap, CVariable& LuMap, CVariable& Soils, CVariable& Counties)   
// arguments gotten from config file, first arg is always variable being configured.

{
  static int once = 0;
  int count = 0;
  FILE *ffile;
  int crop, no_agric_grids;
  float fert;

  int i, j;
	
  unsigned short xi[3];

  if (once == 1) return;

  xi[0] = getpid();
	
  printf("(r.s.) generating fertilizer map: ");
  
  CPathString pathName(Env::DataPath()); 
  pathName.Add("FertData");
  if ( (ffile = fopen (pathName, "r")) == NULL)  gFatal( "Can't open FertData file! " );

  fscanf(ffile, " %d\n", &count);

  DistributedGrid& grid = LuMap.Grid();
  grid.SetPointOrdering(0);


  if (count > 0)
    {
      printf("from file: %d grid points", count);

      no_agric_grids = 0;
      for( Pix p = grid.first(); p; grid.next(p) ) 
	{ 
	  const OrderedPoint& pt = grid.GetPoint(p); // sets currentPoint
	  
	  if( ((int)LuMap(pt) == 3) || ((int)LuMap(pt) > 5))
	    {
	      fscanf(ffile, " %f", &fert);
	      
	      FertMap(pt) = (int)fert;
	      no_agric_grids++;
	      
	      if (no_agric_grids > count)
		printf("input file incompatible to map\n");
	    }
	} // end loop over all area
    }

  if (count == 0)
    {
      printf(" local optimization, see messages from MakeCropMap\n");
    }
  fclose(ffile);


  // Write Back file
  CPathString pathName2(Env::ArchivePath()); 
  pathName2.Add("FertData");
  if ( (ffile = fopen (pathName2, "w")) == NULL)  gFatal( "Can't write FertilizerData file!");
  fprintf(ffile, "%d\n", no_agric_grids);
  for( Pix p = grid.first(); p; grid.next(p) ) 
    { 
      const OrderedPoint& pt = grid.GetPoint(p); 
      
      if( ((int)LuMap(pt) == AGRI) || ((int)LuMap(pt) > 5))
	fprintf(ffile, " %d ", (int)FertMap(pt));
    } 
  fclose(ffile);


  once = 1;
  
}


/*************************************************************************/
/* Performance Criterion/Goal Function o.w.s.e
 * weightings througout
 * - prices crop (references)
 * - prices fertilizer (references)
 * - prices nitrogen outflow (external costs, shadow prices) play parameter*/

float yield_usd(int crop, float yield)
{
  return (lambda_y[crop-1]*yield);
}

float performance_criterion(int crop, float yield, float nout, float fertilizer)
{
  float j;

  j = yield_usd(crop, yield)
    - lambda_n * nout 
    - lambda_f * fertilizer;
  return j;
}

float performance_criterion_local(int crop, float yield, float nout, float fertilizer)
{
  float j;

  j = yield_usd(crop, yield)
    - lambda_n * nout
    - lambda_f * fertilizer;
  return j;
}

float last_performance_criterion(float yield, float nout, float fertilizer)
{
  float j;

  j = yield - lambda_n * nout - lambda_f * fertilizer;

  return j;
}


/**************************************************************************								     
 * returns TRUE = 1, is crop belongs to controlable landuse*/
 

int is_control_space(int crop)
{
  int b;
  
  b = 0;

  b = b || (crop == FOREST);
  b = b || (crop == AGRI);
  b = b || (crop == CORN);
  b = b || (crop == WHEAT);
  b = b || (crop == SOY);
  b = b || (crop == FALLOW);

  return b;
}

/**************************************************************************/
/* basic principle
   - with start of simulation HABITATMAPDB=LuMapDB is initialized with
     landuse data coming from Data/CropData File. (May be either scenario
     driven or output from genetic programming algorithms.
   - HABITATMAP ist initialized with FALLOW. HABITATMAP drives all other
     Modelequations
   - Durin Simulation at 4 specific date (TIME1,...,TIME4) HabitatMApDB is
     checked, if there is an upcoming crop to be planted. If so (is if cases)
     the code of the crop is written to HABITATMAP. TIME4 is used to reset 
     Soybean and corn landuse to fallow*/    
     

void MakeCropMap ( CVariable& LuMap, CVariable& LuMapDB, CVariable& DayJul)
{       
  static int init = 0;
  int count = 0;
  FILE *ffile, *ffile1, *ffile2;
  int crop, no_agric_grids;
  int DD, hab;
  int total_grids;
  float fert;
  float jakt;

  int LuArray[MAX_POINT];

  DistributedGrid& grid = LuMapDB.Grid(0);
  grid.SetPointOrdering(0);

  unsigned short xi[3];

  // Initialization part
  // Read in CropData File, first number deternins the general Behaviour of MakeCropMap()
  //  count < 0 : stochastic generation of LandUse Map, 
  //  count = 0 : Read in Array-Maps of preverious calculated yield and nutrient outflow maps
  //              and local optimum decision of landuse
  //  cound > 0 : read in count LanUse numbers from opened files (CropData) and setup 
  //              LandUseMap from this data 

  printf("\n(r.s.) MakeCropMap:"); 
  if ( init == 0 )
    {
      xi[0] = getpid();

      // Einlesen Crop Map //

      CPathString pathName(Env::DataPath()); 
      pathName.Add("CropData");
      if ( (ffile = fopen (pathName, "r")) == NULL)  gFatal( "Can't open LandUseData file! " );

      fscanf(ffile, " %d\n", &count);
      
      if (count > 0)
	{
	  printf(" init HABITATMAPDB from file: %d grid points\n", count);

	  no_agric_grids = 0;
	  for( Pix p = grid.first(); p; grid.next(p) ) 
	    { 
	      const OrderedPoint& pt = grid.GetPoint(p); // sets currentPoint
	      
	      if (is_control_space((int)LuMap(pt)))
		{
		  fscanf(ffile, " %d", &crop);
		  
		  // LuMapDB gets Landuse data from input file
		  LuMapDB(pt) = (int)crop;
		  no_agric_grids++;
		  
		  // LuMap is reset to Fallow
		  LuMap(pt) = FALLOW;
		  
		  if (no_agric_grids > count)
		    printf("input file incompatible to map\n");
		}
	    } // end loop over all area
	  
	  fclose(ffile);
	}

      
      // and: write back a land use string to archive path, some thing to start again.
      
      CPathString pathName2(Env::ArchivePath()); 
      pathName2.Add("CropData");
      if ( (ffile = fopen (pathName2, "w")) == NULL)  gFatal( "Can't write LandUseData file!");
      fprintf(ffile, "%d\n", no_agric_grids);
      for( Pix p = grid.first(); p; grid.next(p) ) 
	{ 
	  const OrderedPoint& pt = grid.GetPoint(p); 
		
	  if (is_control_space((int)LuMapDB(pt)))		
	    fprintf(ffile, " %d ", (int)LuMapDB(pt));
	} // end loop over all area
      fclose(ffile);
      
      init = 1; 
    } // end of initialization 
    
  // The following code ist executed every time step 

  DD=(int)DayJul.Value();

  int i=0;

  if (DD == TIME0) 
    {
      printf(" set up HABITATMAP from HABITATMAPDB for forest ");
      
      for( Pix p = grid.first(); p; grid.next(p) ) 
	{ 
	  const OrderedPoint& pt = grid.GetPoint(p); // sets currentPoint

	  if ((int)LuMapDB(pt) == FOREST)
	    {
	      LuMap(pt) = FOREST;
	      i++;
	    }
	}
      printf("%d \n", i);
    }

  if (DD == TIME1) 
    {
      printf(" set up HABITATMAP from HABITATMAPDB for corn ");
      
      for( Pix p = grid.first(); p; grid.next(p) ) 
	{ 
	  const OrderedPoint& pt = grid.GetPoint(p); // sets currentPoint

	  if ((int)LuMapDB(pt) == CORN)
	    {
	      LuMap(pt) = CORN;
	      i++;
	    }
	}
      printf("%d \n", i);
    }

  if (DD == TIME2) 
    {
      printf(" set up HABITATMAP from HABITATMAPDB for soybean ");
      
      for( Pix p = grid.first(); p; grid.next(p) ) 
	{ 
	  const OrderedPoint& pt = grid.GetPoint(p); // sets currentPoint
	  int i=0;
	  if ((int)LuMapDB(pt) == SOY)
	    {
	      LuMap(pt) = SOY;
	      i++;
	    }
	}
      printf("%d \n", i);
    }

  if (DD == TIME3) 
    {
      printf(" set up HABITATMAP from HABITATMAPDB, for wheat ");


      for( Pix p = grid.first(); p; grid.next(p) ) 
	{ 
	  const OrderedPoint& pt = grid.GetPoint(p); // sets currentPoint
	  if ((int)LuMapDB(pt) == WHEAT)
	    {
	      LuMap(pt) = WHEAT;
	      i++;
	    }
	}
      printf("%d \n", i);
    }
  if (DD == TIME4) 
    {
      printf(" set up HABITATMAP from HABITATMAPDB, for fallow ");
      for( Pix p = grid.first(); p; grid.next(p) ) 
	{ 
	  const OrderedPoint& pt = grid.GetPoint(p); // sets currentPoint
	  if (((int)LuMapDB(pt) == CORN) || ((int)LuMapDB(pt) == SOY))
	    {
	      LuMap(pt) = FALLOW;
	      i++;
	    }
	}
      printf("%d \n", i);
    }
  printf("\n");


}


// **************************************************************************
// Goal Function.
// Calculating overall yield, plot in column 1
// ROW and COL are not used, in the code coordinates are fixed to an agric grid point

void Goal_Func ( CVariable& Map, CVariable& HabitatMap, 
		 CVariable& HabitatMapDB, CVariable& Yield, CVariable& Fert, 
		 CVariable& din_sf, CVariable& NPP)

{	
  static int ttt;
  static FILE *goalfile;

  int nr_agri, nr_cells;
 
  DistributedGrid& grid = HabitatMap.Grid();
  grid.SetPointOrdering(0);	                 // Sets grid ordering to default

  float sum_yield;		// areal sum of yield
  float min_yield;		// areal maximum of yield
  float max_yield;		// areal minimumof yield
  float y;

  static float sum_nout;		// intragral(time) over nitrogen mass leaving wshed (sum over all mouth's grids
				// cummulted n_out_sum from SWater.cc
  static float sum_fert;		// total amount of fertilizer applied in reagion
  static float sum_npp;

  sum_yield = 0.0;
  min_yield = 9999999.9;
  max_yield = -9999999.9;
  
  float o_sum_yield, o_sum_fert, o_sum_nout, o_sum_npp;

  printf("(r.s.) goalfunction %g %g\n", n_out_conc, n_out_sum);

  // Initialisation:
  // - open Resultsfile
  // - reset static variables
  //
  if (goalfile == NULL) 
    { 
      // open output file
      CPathString pathName(Env::ArchivePath()); 
      pathName.Add("GoalFunctionProtocol");
      if ( (goalfile = fopen (pathName, "w")) == NULL) 
	gFatal( "Can't open OutPutFile! " ); 

      fprintf ( goalfile, " t J sum_yield min_yield max_yield sum_fert n_out sum_n_out sum_npp #corn #soyb # wheat #fallow #forest\n");

      // further steps of initialization
      ttt = 0;	  
      sum_npp = 0.0;
      sum_nout = 0.0;
    }

  ttt++;
  nr_agri = 0;
  nr_cells = 0;

  sum_fert = 0.0;

  int nr_w = 0;
  int nr_c = 0;
  int nr_s = 0;
  int nr_fa = 0;
  int nr_fo = 0;

  // Fist part:
  // calulate all indicees based on map data

  for( Pix p = grid.first(); p; grid.next(p) )     // loop over the whole area
    { 
      const OrderedPoint& pt = grid.GetPoint(p);     // pt same as p, but ordered

      // well is an really useless part, for debuggin purposes it may remain in the code.
      // the distribution of corn, wheat etc. cells remains contant over time, and 
      // can be derived from other tools (-> GIS)

      switch ((int)HabitatMapDB(pt))
	{
	case CORN:
	  nr_c++;
	  break;
	case WHEAT:
	  nr_w++;
	  break;
	case SOY:
	  nr_s++;
	  break;
	case FOREST:
	  nr_fo++;
	  break;
	case FALLOW:
	  nr_fa++;
	  break;
	}

      // is_control = either Agriculture (3) in general or a specific crop (5,6,7,8) no fallow 
      if (is_control_space((int)HabitatMap(pt)))		
	{
	  nr_agri++;

	  y = yield_usd((int)HabitatMapDB(pt), (float)Yield(pt));

	  sum_yield += y;
	  if (min_yield>y)
	    min_yield = y;
	  if (max_yield<y)
	    max_yield = y;	  

	  sum_fert += (float)Fert(pt);
	}

      sum_npp += NPP(pt); nr_cells++;

    }
  // Second, all indicees, which are derived from entire study area

  sum_nout += n_out_sum;

  // Third, setup appropriate units:
  // per day and per square meter

  o_sum_yield = sum_yield/(float)nr_agri;
  o_sum_fert = 0.1*sum_fert/(float)nr_agri;    // g/m2
  o_sum_nout = sum_nout/(float)ttt;
  o_sum_npp = 365.0*sum_npp/(float)ttt/(float)nr_cells;



  fprintf ( goalfile, "%4d %12.4f %8.3f %8.3f %8.3f %8.3f %8.3f %f %8.3f %5d %5d %5d %5d %5d\n",
	    ttt,
	    last_performance_criterion(o_sum_yield, o_sum_nout, o_sum_fert),
	    o_sum_yield,
	    min_yield,
	    max_yield,
	    o_sum_fert,
	    sum_nout, 
	    o_sum_nout,
	    o_sum_npp,
	    nr_c,
	    nr_s,
	    nr_w,
	    nr_fa,
	    nr_fo);
   
  fflush(goalfile); 
}

