#include "sme.h"

void SWTransport1( CVariable& AvailWater, CVariable& HydMap, CVariable& Fluxx, CVariable& Stuff );
// Simplest fluxing procedure over steep areas, assuming that fluxes are
// already known (say defined by a Stella algorithm). Also moves 'Stuff' together 
// with water. 


void SWTransport2( CVariable& AvailWater, CVariable& HydMap, CVariable& Stuff );
// Simplest fluxing procedure over steep areas, assuming that all the water 
// is moved downhill. Also moves 'Stuff' together with water


void SWTransport3( CVariable& AvailWater, CVariable& HydMap, CVariable& Slop, CVariable& Stuff );
// Fluxing procedure over steep areas, assuming that all the water 
// is moved downhill. Allows fluxing over a path of several cells. 
// Also moves 'Stuff' together with water

void SWTransport4( CVariable& AvailWater, CVariable& HydMap, CVariable& HabMap, 
	CVariable& Elev, CVariable& Stuff, CVariable& outFlux  );
// Combines fluxing over steep areas and fluxing by equilibrating in open water
// Also moves 'Stuff' together with water. 

void SWTransport_b( CVariable& AvailWater, CVariable& HydMap, CVariable& HabMap, 
	CVariable& Elev, CVariable& Slop, CVariable& Stuff, CVariable& outFlux);
// combines fluxing over steep areas and fluxes in open water
// keeps track of the amount of nutrient leaked from each cell
// calculates the budgets from different areas, designated on the 
// HYDRO map by numbers > 10


void SWTransML( CVariable& AvailWater, CVariable& outFluxMap, CVariable& HabMap, 
	CVariable& Elev, CVariable& Nitrogen );
void SWTransportML( CVariable& AvailWater, CVariable& outFluxMap, CVariable& HabMap, 
	CVariable& Elev, CVariable& Slop, CVariable& Nitrogen );
void SWTransML_I( CVariable& AvailWater, CVariable& OnMap, CVariable& HabMap, 
	CVariable& Elev, CVariable& Slop, CVariable& Nitrogen, CVariable& outFlux );
void SWTransML_I_b( CVariable& AvailWater, CVariable& HydMap, CVariable& HabMap, 
	CVariable& Elev, CVariable& Slop, CVariable& Nitrogen, CVariable& outFlux);

