#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define MAX 10
#define TOTAL 3000
#define MAXLENGTH 1000


void errormessage ( char *ss)
    	{ printf ("%s\n",ss); 
    	  exit (0);
    	}



void main(int argc, char *argv[]) 
{
    int i, j, jj, col, num, p, total ;
    FILE *fin, *fout;
    char s[MAXLENGTH];
    float *ff;
    float vv, sum;

    
    if (argc < 4) errormessage ("Usage: max filename #column(first column=0) #% #n_lines");
    
    if ( (fin = fopen ( argv[1], "r" )) == NULL )
	errormessage ("Can't open input file!"); 
       
    sscanf ( argv[4], "%d", &total );
    sscanf ( argv[3], "%d", &p );
    sscanf ( argv[2], "%d", &col );
    
    printf ( "Calculating the sum of the highest %d percent \nof the %d values\nin the %d column\n", 
	     p, total, col );
    
    num = total*p/100;

    ff = malloc ( sizeof(float)*num );
    
    for ( i = 0; i < num; i++ ) *(ff+i) = 0.; 
    
    fgets(s, MAXLENGTH, fin );
    fgets(s, MAXLENGTH, fin ); /* skip two headers */
    
    while ( total-- ) 
       { 
          fgets(s, MAXLENGTH, fin );
          
          jj = 0;

          for ( i = 0; i < col; i++ ) jj += Skip ( s + jj ) + 1;
          sscanf ( s + jj, "%f", &vv );

          for ( i = 0; i < num; i++ ) 
             if (vv > *(ff+i)) 
                 { 
                   for ( j = num; j > i; j-- ) *(ff+j) = *(ff+j-1);
                   *(ff+i) = vv; 
                   break;
                 }
       }
    
    sum = 0.;
    for ( i = 0; i < num; i++ ) sum += *(ff+i);
    
    printf ("\n sum = %f \n", sum ); 

    fclose (fin);


}

/***********************************************************/
/**** Skips chars in a string until TAB is encountered  ****/
/****         and returns number of chars skipped       ****/

int Skip (char *ss)
{ int i = 0;

	while (*ss++ != '\t') i++;
	return i;
}

