****************************************************************************
*  nuts.86-96.sas     Program reads in, corrects, and selects data
                          from long-term water-quality data sets 

Questions? Call Joy (410)238-4302
****************************************************************************;

filename wy86 'wy86wq-s.dat';
filename wy87 'wy87wq-s.dat';
filename wy88 'wy88wq-s.dat';
filename wy89 'wy89wq-s.dat';
filename wy90 'wy90wq-s.dat';
filename wy91 'wy91wq-s.dat';
filename wy92 'wy92wq-s.dat';
filename wy93 'wy93wq-s.dat';
filename wy94 'wy94wq-s.dat';
filename wy95 'wy95wq-s.dat';
filename wy96 'wy96wq-s.dat';

options pagesize=50 linesize=132;
goptions reset=all;

data pax86; infile wy86;
input
#1 stan 1-9 stax $ 11-19 dte1   21-29 tim1 31-39 dte2 41-49 tim2 51-59
            aagn $ 61-69 smpn $ 71-79
#2 smtp $ 1-9 strm $ 11-19 c__d $ 21-29 c_dur 31-39 wtmp 41-49 .2
               atmp 51-59 .2 barm 61-69 .2 qcfs 71-79 .2
#3 stge 1-9 .2 ph1x 11-19 .2 ph2x 21-29 .2 cndf 31-39    cndl 41-49
               alkf 51-59 .2 diso 61-69 .2 used 71-79 .2
#4 tssx_g $  1 tssx  2- 9 .2   trbn_g $ 11 trbn 12-19 .2
   bod5_g $ 21 bod5 22-29 .2   codX_g $ 31 codX 32-39 .2
   docx_g $ 41 docx 42-49 .2   tocx_g $ 51 tocx 52-59 .2
   nh4X_g $ 61 nh4X 62-69 .4   no2x_g $ 71 no2x 72-79 .4
#5 no3x_g $  1 no3x  2- 9 .4   no23_g $ 11 no23 12-19 .4
   tknf_g $ 21 tknf 22-29 .4   tknw_g $ 31 tknw 32-39 .4
               tnxx 42-49 .4   po4x_g $ 51 po4x 52-59 .4
   tdpx_g $ 61 tdpx 62-69 .4   tpxx_g $ 71 tpxx 72-79 .4
#6 siox_g $  1 siox  2- 9 .3   fcol_g $ 11 fcol 12-19
   tcol_g $ 21 tcol 22-29      chaa 31-39  .4    chla 41-49  .4
   chlb 51-59 .4      chlc 61-69 .4      phea 71-79 .4
#7 flag $ 1-5 fldc $ 21-39 labc $ 41-59;
wyr='1986';
if tnxx=. then tnxx=tknw+no23;
keep stax wyr dte1 tim1 dte2 tim2 aagn smpn smtp strm c__d c_dur
     qcfs cndf used tssx_g tssx tnxx tpxx_g tpxx no23_g no23 tocx_g tocx;
run;

data pax87; infile wy87;
input
#1 stan 1-9 stax $ 11-19 dte1   21-29 tim1 31-39 dte2 41-49 tim2 51-59
             aagn $ 61-69 smpn $ 71-79
#2 smtp $ 1-9 strm $ 11-19 c__d $ 21-29 c_dur 31-39 wtmp 41-49 .2
               atmp 51-59 .2 barm 61-69 .2 qcfs 71-79 .2
#3 stge 1-9 .2 ph1x 11-19 .2 ph2x 21-29 .2 cndf 31-39    cndl 41-49
               alkf 51-59 .2 diso 61-69 .2 used 71-79 .2
#4 tssx_g $  1 tssx  2- 9 .2   trbn_g $ 11 trbn 12-19 .2
   bod5_g $ 21 bod5 22-29 .2   codX_g $ 31 codX 32-39 .2
   docx_g $ 41 docx 42-49 .2   tocx_g $ 51 tocx 52-59 .2
   nh4X_g $ 61 nh4X 62-69 .4   no2x_g $ 71 no2x 72-79 .4
#5             no3x  2- 9 .4   no23_g $ 11 no23 12-19 .4
   tknf_g $ 21 tknf 22-29 .4   tknw_g $ 31 tknw 32-39 .4
               tnxx 42-49 .4   po4x_g $ 51 po4x 52-59 .4
   tdpx_g $ 61 tdpx 62-69 .4   tpxx_g $ 71 tpxx 72-79 .4
#6 siox_g $  1 siox  2- 9 .3   fcol_g $ 11 fcol 12-19
   tcol_g $ 21 tcol 22-29      chaa 31-39  .4    chla 41-49  .4
   chlb 51-59 .4      chlc 61-69 .4      phea 71-79 .4
#7 flag $ 1-5 fldc $ 21-39 labc $ 41-59;
wyr='1987';
if tnxx=. then tnxx=tknw+no23;
keep stax wyr dte1 tim1 dte2 tim2 aagn smpn smtp strm c__d c_dur
     qcfs cndf used tssx_g tssx tnxx tpxx_g tpxx no23_g no23 tocx_g tocx;
run;

data pax88; infile wy88;
input
#1 stan 1-9 stax $ 11-19 dte1   21-29 tim1 31-39 dte2 41-49 tim2 51-59
             aagn $ 61-69 smpn $ 71-79
#2 smtp $ 1-9 strm $ 11-19 c__d $ 21-29 c_dur 31-39 wtmp 41-49 .2
               atmp 51-59 .2 barm 61-69 .2 qcfs 71-79 .2
#3 stge 1-9 .2 ph1x 11-19 .2 ph2x 21-29 .2 cndf 31-39    cndl 41-49
               alkf 51-59 .2 diso 61-69 .2 used 71-79 .2
#4 tssx_g $  1 tssx  2- 9 .2   trbn_g $ 11 trbn 12-19 .2
   bod5_g $ 21 bod5 22-29 .2   codX_g $ 31 codX 32-39 .2
   docx_g $ 41 docx 42-49 .2   tocx_g $ 51 tocx 52-59 .2
   nh4X_g $ 61 nh4X 62-69 .4   no2x_g $ 71 no2x 72-79 .4
#5             no3x  2- 9 .4   no23_g $ 11 no23 12-19 .4
   tknf_g $ 21 tknf 22-29 .4   tknw_g $ 31 tknw 32-39 .4
               tnxx 42-49 .4   po4x_g $ 51 po4x 52-59 .4
   tdpx_g $ 61 tdpx 62-69 .4   tpxx_g $ 71 tpxx 72-79 .4
#6 siox_g $  1 siox  2- 9 .3   fcol_g $ 11 fcol 12-19
   tcol_g $ 21 tcol 22-29      chaa 31-39  .4    chla 41-49  .4
   chlb 51-59 .4      chlc 61-69 .4      phea 71-79 .4
#7 flag $ 1-5 fldc $ 21-39 labc $ 41-59        ;
wyr='1988';
if tnxx=. then tnxx=tknw+no23;
keep stax wyr dte1 tim1 dte2 tim2 aagn smpn smtp strm c__d c_dur
     qcfs cndf used tssx_g tssx tnxx tpxx_g tpxx no23_g no23 tocx_g tocx;
run;

data pax89; infile wy89;
input
#1 stan 1-9 stax $ 11-19 dte1   21-29 tim1 31-39 dte2 41-49 tim2 51-59
             aagn $ 61-69 smpn $ 71-79
#2 smtp $ 1-9 strm $ 11-19 c__d $ 21-29 c_dur 31-39 wtmp 41-49 .2
               atmp 51-59 .2 barm 61-69 .2 qcfs 71-79 .2
#3 stge 1-9 .2 ph1x 11-19 .2 ph2x 21-29 .2 cndf 31-39    cndl 41-49
               alkf 51-59 .2 diso 61-69 .2 used 71-79 .2
#4 tssx_g $  1 tssx  2- 9 .2   trbn_g $ 11 trbn 12-19 .2
   bod5_g $ 21 bod5 22-29 .2   codX_g $ 31 codX 32-39 .2
   docx_g $ 41 docx 42-49 .2   tocx_g $ 51 tocx 52-59 .2
   nh4X_g $ 61 nh4X 62-69 .4   no2x_g $ 71 no2x 72-79 .4
#5             no3x  2- 9 .4   no23_g $ 11 no23 12-19 .4
   tknf_g $ 21 tknf 22-29 .4   tknw_g $ 31 tknw 32-39 .4
               tnxx 42-49 .4   po4x_g $ 51 po4x 52-59 .4
   tdpx_g $ 61 tdpx 62-69 .4   tpxx_g $ 71 tpxx 72-79 .4
#6 siox_g $  1 siox  2- 9 .3   fcol_g $ 11 fcol 12-19
   tcol_g $ 21 tcol 22-29      chaa 31-39  .4    chla 41-49  .4
   chlb 51-59 .4      chlc 61-69 .4      phea 71-79 .4
#7 flag $ 1-5 fldc $ 21-39 labc $ 41-59        ;
wyr='1989';
if tnxx=. then tnxx=tknw+no23;
keep stax wyr dte1 tim1 dte2 tim2 aagn smpn smtp strm c__d c_dur
     qcfs cndf used tssx_g tssx tnxx tpxx_g tpxx no23_g no23 tocx_g tocx;
run;

data pax90; infile wy90;
input
#1 stan 1-9 stax $ 11-19 dte1   21-29 tim1 31-39 dte2 41-49 tim2 51-59
             aagn $ 61-69 smpn $ 71-79
#2 smtp $ 1-9 strm $ 11-19 c__d $ 21-29 c_dur 31-39 wtmp 41-49 .2
               atmp 51-59 .2 barm 61-69 .2 qcfs 71-79 .2
#3 stge 1-9 .2 ph1x 11-19 .2 ph2x 21-29 .2 cndf 31-39    cndl 41-49
               alkf 51-59 .2 diso 61-69 .2 used 71-79 .2
#4 tssx_g $  1 tssx  2- 9 .2   trbn_g $ 11 trbn 12-19 .2
   bod5_g $ 21 bod5 22-29 .2   codX_g $ 31 codX 32-39 .2
   docx_g $ 41 docx 42-49 .2   tocx_g $ 51 tocx 52-59 .2
   nh4X_g $ 61 nh4X 62-69 .4   no2x_g $ 71 no2x 72-79 .4
#5             no3x  2- 9 .4   no23_g $ 11 no23 12-19 .4
   tknf_g $ 21 tknf 22-29 .4   tknw_g $ 31 tknw 32-39 .4
               tnxx 42-49 .4   po4x_g $ 51 po4x 52-59 .4
   tdpx_g $ 61 tdpx 62-69 .4   tpxx_g $ 71 tpxx 72-79 .4
#6 siox_g $  1 siox  2- 9 .3   fcol_g $ 11 fcol 12-19
   tcol_g $ 21 tcol 22-29      chaa 31-39  .4    chla 41-49  .4
   chlb 51-59 .4      chlc 61-69 .4      phea 71-79 .4
#7 flag $ 1-5 fldc $ 21-39 labc $ 41-59        ;
wyr='1990';
if tnxx=. then tnxx=tknw+no23;
keep stax wyr dte1 tim1 dte2 tim2 aagn smpn smtp strm c__d c_dur
     qcfs cndf used tssx_g tssx tnxx tpxx_g tpxx no23_g no23 tocx_g tocx;
run;

data pax91; infile wy91;
input
#1 stan 1-9 stax $ 11-19 dte1   21-29 tim1 31-39 dte2 41-49 tim2 51-59
             aagn $ 61-69 smpn $ 71-79
#2 smtp $ 1-9 strm $ 11-19 c__d $ 21-29 c_dur 31-39 wtmp 41-49 .2
               atmp 51-59 .2 barm 61-69 .2 qcfs 71-79 .2
#3 stge 1-9 .2 ph1x 11-19 .2 ph2x 21-29 .2 cndf 31-39    cndl 41-49
               alkf 51-59 .2 diso 61-69 .2 used 71-79 .2
#4 tssx_g $  1 tssx  2- 9 .2   trbn_g $ 11 trbn 12-19 .2
   bod5_g $ 21 bod5 22-29 .2   codx_g $ 31 codx 32-39 .2
   docx_g $ 41 docx 42-49 .2   tocx_g $ 51 tocx 52-59 .2
   nh4x_g $ 61 nh4x 62-69 .4   no2x_g $ 71 no2x 72-79 .4
#5             no3x  2- 9 .4   no23_g $ 11 no23 12-19 .4
   tknf_g $ 21 tknf 22-29 .4   tknw_g $ 31 tknw 32-39 .4
               tnxx 42-49 .4   po4x_g $ 51 po4x 52-59 .4
   tdpx_g $ 61 tdpx 62-69 .4   tpxx_g $ 71 tpxx 72-79 .4
#6 siox_g $  1 siox  2- 9 .3   fcol_g $ 11 fcol 12-19
   tcol_g $ 21 tcol 22-29      chaa 31-39  .4    chla 41-49  .4
   chlb 51-59 .4      chlc 61-69 .4      phea 71-79 .4
#7 flag $ 1-5 fldc $ 21-50 labc $ 51-80;
wyr='1991';
if tnxx=. then tnxx=tknw+no23;
keep stax wyr dte1 tim1 dte2 tim2 aagn smpn smtp strm c__d c_dur
     qcfs cndf used tssx_g tssx tnxx tpxx_g tpxx no23_g no23 tocx_g tocx;
run;

data pax92; infile wy92;
input
#1 stan 1-9 stax $ 11-19 dte1   21-29 tim1 31-39 dte2 41-49 tim2 51-59
             aagn $ 61-69 smpn $ 71-79
#2 smtp $ 1-9 strm $ 11-19 c__d $ 21-29 c_dur 31-39 wtmp 41-49 .2
               atmp 51-59 .2 barm 61-69 .2 qcfs 71-79 .2
#3 stge 1-9 .2 ph1x 11-19 .2 ph2x 21-29 .2 cndf 31-39    cndl 41-49
               alkf 51-59 .2 diso 61-69 .2 used 71-79 .2
#4 tssx_g $  1 tssx  2- 9 .2   trbn_g $ 11 trbn 12-19 .2
   bod5_g $ 21 bod5 22-29 .2   codx_g $ 31 codx 32-39 .2
   docx_g $ 41 docx 42-49 .2   tocx_g $ 51 tocx 52-59 .2
   nh4x_g $ 61 nh4x 62-69 .4   no2x_g $ 71 no2x 72-79 .4
#5             no3x  2- 9 .4   no23_g $ 11 no23 12-19 .4
   tknf_g $ 21 tknf 22-29 .4   tknw_g $ 31 tknw 32-39 .4
               tnxx 42-49 .4   po4x_g $ 51 po4x 52-59 .4
   tdpx_g $ 61 tdpx 62-69 .4   tpxx_g $ 71 tpxx 72-79 .4
#6 siox_g $  1 siox  2- 9 .3   fcol_g $ 11 fcol 12-19
   tcol_g $ 21 tcol 22-29      chaa 31-39  .4    chla 41-49  .4
   chlb 51-59 .4      chlc 61-69 .4      phea 71-79 .4
#7 flag $ 1-5 fldc $ 21-50 labc $ 51-80;
wyr='1992';
if tnxx=. then tnxx=tknw+no23;
keep stax wyr dte1 tim1 dte2 tim2 aagn smpn smtp strm c__d c_dur
     qcfs cndf used tssx_g tssx tnxx tpxx_g tpxx no23_g no23 tocx_g tocx;
run;

data pax93; infile wy93;
input
#1 stan 1-9 stax $ 11-19 dte1   21-29 tim1 31-39 dte2 41-49 tim2 51-59
             aagn $ 61-69 smpn $ 71-79
#2 smtp $ 1-9 strm $ 11-19 c__d $ 21-29 c_dur 31-39 wtmp 41-49 .2
               atmp 51-59 .2 barm 61-69 .2 qcfs 71-79 .2
#3 stge 1-9 .2 ph1x 11-19 .2 ph2x 21-29 .2 cndf 31-39    cndl 41-49
               alkf 51-59 .2 diso 61-69 .2 used 71-79 .2
#4 tssx_g $  1 tssx  2- 9 .2   trbn_g $ 11 trbn 12-19 .2
   bod5_g $ 21 bod5 22-29 .2   codx_g $ 31 codx 32-39 .2
   docx_g $ 41 docx 42-49 .2   tocx_g $ 51 tocx 52-59 .2
   nh4x_g $ 61 nh4x 62-69 .4   no2x_g $ 71 no2x 72-79 .4
#5             no3x  2- 9 .4   no23_g $ 11 no23 12-19 .4
   tknf_g $ 21 tknf 22-29 .4   tknw_g $ 31 tknw 32-39 .4
               tnxx 42-49 .4   po4x_g $ 51 po4x 52-59 .4
   tdpx_g $ 61 tdpx 62-69 .4   tpxx_g $ 71 tpxx 72-79 .4
#6 siox_g $  1 siox  2- 9 .3   fcol_g $ 11 fcol 12-19
   tcol_g $ 21 tcol 22-29      chaa 31-39  .4    chla 41-49  .4
   chlb 51-59 .4      chlc 61-69 .4      phea 71-79 .4
#7 flag $ 1-5 fldc $ 21-50 labc $ 51-80;
wyr='1993';
if tnxx=. then tnxx=tknw+no23;
keep stax wyr dte1 tim1 dte2 tim2 aagn smpn smtp strm c__d c_dur
     qcfs cndf used tssx_g tssx tnxx tpxx_g tpxx no23_g no23 tocx_g tocx;
run;

data pax94; infile wy94;
input
#1 stan 1-9 stax $ 11-19 dte1   21-29 tim1 31-39 dte2 41-49 tim2 51-59
             aagn $ 61-69 smpn $ 71-79
#2 smtp $ 1-9 strm $ 11-19 c__d $ 21-29 c_dur 31-39 wtmp 41-49 .2
               atmp 51-59 .2 barm 61-69 .2 qcfs 71-79 .2
#3 stge 1-9 .2 ph1x 11-19 .2 ph2x 21-29 .2 cndf 31-39    cndl 41-49
               alkf 51-59 .2 diso 61-69 .2 used 71-79 .2
#4 tssx_g $  1 tssx  2- 9 .2   trbn_g $ 11 trbn 12-19 .2
   bod5_g $ 21 bod5 22-29 .2   codx_g $ 31 codx 32-39 .2
   docx_g $ 41 docx 42-49 .2   tocx_g $ 51 tocx 52-59 .2
   nh4x_g $ 61 nh4x 62-69 .4   no2x_g $ 71 no2x 72-79 .4
#5             no3x  2- 9 .4   no23_g $ 11 no23 12-19 .4
   tknf_g $ 21 tknf 22-29 .4   tknw_g $ 31 tknw 32-39 .4
               tnxx 42-49 .4   po4x_g $ 51 po4x 52-59 .4
   tdpx_g $ 61 tdpx 62-69 .4   tpxx_g $ 71 tpxx 72-79 .4
#6 siox_g $  1 siox  2- 9 .3   fcol_g $ 11 fcol 12-19
   tcol_g $ 21 tcol 22-29      chaa 31-39  .4    chla 41-49  .4
   chlb 51-59 .4      chlc 61-69 .4      phea 71-79 .4
#7 flag $ 1-5 fldc $ 21-50 labc $ 51-80;
wyr='1994';
     if stax='UPX' and dte1=940124 and tim1=2106 then delete;
else if stax='LPX' and smpn='PAS71' then dte1=931128;
else if stax='BOW' and dte1=931129 and aagn='OEPC' then delete;
else if stax='BOW' and dte1=931130 and aagn='OEPS' then delete;
else if stax='BOW' and dte1=931206 and aagn='OEPC' then delete;
else if stax='BOW' and dte1=940225 and aagn='OEPS' then delete;
else if stax='WBR' and dte1=940328 and aagn='OEPS' then delete;
else if stax='WBR' and smpn='PAU87' then delete;
keep stax wyr dte1 tim1 dte2 tim2 aagn smpn smtp strm c__d c_dur
     qcfs used tssx_g tssx tnxx tpxx_g tpxx no23_g no23 tocx_g tocx;
run;

data pax95; infile wy95;
input
#1 stan 1-9 stax $ 11-19 dte1   21-29 tim1 31-39 dte2 41-49 tim2 51-59
             aagn $ 61-69 smpn $ 71-79
#2 smtp $ 1-9 strm $ 11-19 c__d $ 21-29 c_dur 31-39 wtmp 41-49 .2
               atmp 51-59 .2 barm 61-69 .2 qcfs 71-79 .2
#3 stge 1-9 .2 ph1x 11-19 .2 ph2x 21-29 .2 cndf 31-39    cndl 41-49
               alkf 51-59 .2 diso 61-69 .2 used 71-79 .2
#4 tssx_g $  1 tssx  2- 9 .2   trbn_g $ 11 trbn 12-19 .2
   bod5_g $ 21 bod5 22-29 .2   codx_g $ 31 codx 32-39 .2
   docx_g $ 41 docx 42-49 .2   tocx_g $ 51 tocx 52-59 .2
   nh4x_g $ 61 nh4x 62-69 .4   no2x_g $ 71 no2x 72-79 .4
#5             no3x  2- 9 .4   no23_g $ 11 no23 12-19 .4
   tknf_g $ 21 tknf 22-29 .4   tknw_g $ 31 tknw 32-39 .4
               tnxx 42-49 .4   po4x_g $ 51 po4x 52-59 .4
   tdpx_g $ 61 tdpx 62-69 .4   tpxx_g $ 71 tpxx 72-79 .4
#6 siox_g $  1 siox  2- 9 .3   fcol_g $ 11 fcol 12-19
   tcol_g $ 21 tcol 22-29      chaa 31-39  .4    chla 41-49  .4
   chlb 51-59 .4      chlc 61-69 .4      phea 71-79 .4
#7 flag $ 1-5 fldc $ 21-50 labc $ 51-80;
wyr='1995';
keep stax wyr dte1 tim1 dte2 tim2 aagn smpn smtp strm c__d c_dur
     qcfs cndf used tssx_g tssx tnxx tpxx_g tpxx no23_g no23 tocx_g tocx;
run;

data pax96; infile wy96;
input
#1 stan 1-9 stax $ 11-19 dte1   21-29 tim1 31-39 dte2 41-49 tim2 51-59
             aagn $ 61-69 smpn $ 71-79
#2 smtp $ 1-9 strm $ 11-19 c__d $ 21-29 c_dur 31-39 wtmp 41-49 .2
               atmp 51-59 .2 barm 61-69 .2 qcfs 71-79 .2
#3 stge 1-9 .2 ph1x 11-19 .2 ph2x 21-29 .2 cndf 31-39    cndl 41-49
               alkf 51-59 .2 diso 61-69 .2 used 71-79 .2
#4 tssx_g $  1 tssx  2- 9 .2   trbn_g $ 11 trbn 12-19 .2
   bod5_g $ 21 bod5 22-29 .2   codx_g $ 31 codx 32-39 .2
   docx_g $ 41 docx 42-49 .2   tocx_g $ 51 tocx 52-59 .2
   nh4x_g $ 61 nh4x 62-69 .4   no2x_g $ 71 no2x 72-79 .4
#5             no3x  2- 9 .4   no23_g $ 11 no23 12-19 .4
   tknf_g $ 21 tknf 22-29 .4   tknw_g $ 31 tknw 32-39 .4
               tnxx 42-49 .4   po4x_g $ 51 po4x 52-59 .4
   tdpx_g $ 61 tdpx 62-69 .4   tpxx_g $ 71 tpxx 72-79 .4
#6 siox_g $  1 siox  2- 9 .3   fcol_g $ 11 fcol 12-19
   tcol_g $ 21 tcol 22-29      chaa 31-39  .4    chla 41-49  .4
   chlb 51-59 .4      chlc 61-69 .4      phea 71-79 .4
#7 flag $ 1-5 fldc $ 21-50 labc $ 51-80;
wyr='1996';
keep stax wyr dte1 tim1 dte2 tim2 aagn smpn smtp strm c__d c_dur
     qcfs cndf used tssx_g tssx tnxx tpxx_g tpxx no23_g no23 tocx_g tocx;
run;

data all; set pax86 pax87 pax88 pax89 pax90 pax91 pax92 pax93 pax94
pax95 pax96;
if dte1 ge 851001;
if smpn='AA01'  then delete;
if smpn='PAC85A' then dte1=880524;
if smpn='PAB21'  then dte1=870504;
if smpn='PAH62' then delete;
if smpn='PAD36'  then delete;
if smpn='PAF74'  then delete;
if smpn='PAG80' then dte1=891117;
if smpn='PAG84' then delete;
if smpn='PAL79' then delete;
if smpn='PAL83' then dte1=910924;
     if stax='UPX' then stax='AUPX';
else if stax='LPX' then stax='BLPX';
else if stax='BOW' then stax='CBOW';
else if stax='WBR' then stax='DWBR';
else if stax='HUN' then stax='EHUN';
else if stax='KIL' then stax='FKIL';
proc sort; by stax wyr;
run;


/*** Joy's corrections to overall database to streamline and fix
some errors */

data me; set all;
if stax='AUPX' and smtp=' ' then smtp='GR1';
if stax='AUPX' and dte1=891220 then smtp='QWX';
if stax='DWBR' and smtp=' ' then smtp='GR1';
if aagn='PNPN' then aagn='PNPS';
if stax='CBOW' and dte1=940630 then smtp='QWDUP';
if smtp=' ' then delete;
if smtp='SMDE' or smtp='SUGS' then delete;
if smtp='C' or smtp='D' or smtp='Q' then delete;
if smtp='GR3' or smtp='GR4' then delete;
if smtp='QWTRP2' or smtp='QWTRP3' then delete;
if smtp='GR' then smtp='GR1';
if aagn='PNPS' and smtp='GR1' then delete;
run;

/*  Bowie duplicate data are identified */

data fixbow; set me; proc sort; by stax dte1; run;

data fixbow; set fixbow;
if stax='CBOW' and smtp='QWDUP';
psmtp=lag(smtp); pdte1=lag(dte1);
if pdte1=dte1 then smtp='QWDUP2';
else if pdte1 ne dte1 then smtp='QWDUP1';
run;

data pax.all10; set fixbow me;
if smtp='QWDUP' then delete;
drop pdte1 psmtp;
run;

/*  Interesting frequency plots of who collected what samples where 

proc sort data=pax.all10; by aagn smtp; run;
proc freq; tables aagn*smtp; run;

proc sort data=pax.all10; by stax smtp; run;
proc freq; tables stax*smtp; run;

proc sort data=pax.all10; by stax aagn; run;
proc freq; tables stax*aagn; run;

proc sort data=pax.all10; by stax dte1; run;

  This is a subset of the data base of just the grab samples 
collected by the State of Maryland */

data grab; set gr;
if smtp='GR1' or smtp='GR2';
*proc print; run;

/*  This is a sas data set in the pax library without all the
duplicate data -- just the first duplicate is retained 

data pax.allnodup; set pax.all10;
if smtp='GR2' then delete;
if smtp='QWDUP1' then smtp='QWX';
if smtp='QWDUP2' then delete;
if smtp='QWDUP3' then delete;
run;*/
