      SUBROUTINE OPACITY(DL,TL,X,Y,Z,C,O,FKAP,IDERIV,DLKLT,DLKLD)
      implicit double precision (a-h,o-z)
C
C General suburoutine  to return the total opacity for a mixture with a
c composition specified by X,Y,C,O, and metallicity Z (=1-X-Y) at
c a given value of log10(rho) (=DL) and log10(T) (=TL).
c
c radiative opacities from H&K ZAMS code
c
c Returns opacity as fkap,
c   if IDERIV=1 then computes logarithmic derivatives DLKLD and DLKLT
c
c First evaluate the radiative opacities by calling your favorite
c radiative opacity routine
c and evaluate the conductive opacities with another favorite routine
      call OPACZAMS(DL,TL,X,Y,z,fkrad)
      call iocond(DL,TL,X,Y,FKCON)
c
      fkap=(fkcon*fkrad)/(fkcon+fkrad)
      fkap=fkrad
c
c logarithmic derivatives, if requested:
c
      if (ideriv.eq.1) then
        delta=1.d-4
c
        call OPACZAMS(dl,tl+delta,x,y,z,fkrad1)
        call iocond(dl,tl+delta,x,y,fkcon1)
        fkap1=(fkcon1*fkrad1)/(fkcon1+fkrad1)
        fkap1=fkrad1
        dlklt=(dlog10(fkap1)-dlog10(fkap))/delta
c
        call OPACZAMS(dl+delta,tl,x,y,z,fkrad2)
        call iocond(dl+delta,tl,x,y,fkcon2)
        fkap2=(fkcon2*fkrad2)/(fkcon2+fkrad2)
        fkap2=fkrad2
        dlkld=(dlog10(fkap2)-dlog10(fkap))/delta
      endif
c
      return
      END
c
c ***********************************************
      SUBROUTINE OPACZAMS(DL,TL,X,Y,z,OP)
c ***********************************************
c This routine computes the opacity (OP) given the
c density (RHO), temperature (T), Hydrogen mass fraction
c (X), Helium mass fraction (Y), and electron pressure (Pe
c from the equation of state routine called EOS).
c Taken from Stellingwerf 1975, {\sl Ap.J.}, {\bf 195},
c 441., with corrections given in Stellingwerf 1975,
c {\sl Ap.J.}, {\bf 199}, 705.
c This routine is to be used for 0.6<X<0.8, 0.2<Y<0.4,
c and 0.001<Z<0.02.
c You may use it outside these bounds but, if you do, use
c with caution!
c Constructing these sorts of fits is not for the amateur.
c Try it!
c ***********************************************
c Temperature and volume in these fits are given in 10^4 K
c and 1/RHO.
c ***********************************************
      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
c Set up variables.
      t=10.d0**tl
      T4=t/1.d4
      rho=10.d0**dl
      V=1.0D0/RHO
c need pe
      call GETEOS (t,v,5.5d0,X,Y,z,P,PE,PV,PT,CV,U,OOMU)
      V1=V**0.35D0
      V2=DSQRT(V1)
      Y1=6.294D-5-(6.0D-5*Y)
      Y2=3.53D6*Y-3.0447D5
      Z1=21.0D0*Z+0.979D0
      Z2=105.0D0*Z+0.895D0
c ***********************************************
c  Compute kappa (OP) from equation D3 of Stellingwerf
c  1975 which involves some continued fractions
c  (temp1, temp2).
c ***********************************************
      TEMP1=Y1*V1*DSQRT(T4)*T4**3+1.0D0/(760.0D0*T4**5
     *   +316.0D0/V2)
      TEMP1=1.0D0/(10.0D0*T4**6+1.0D0/TEMP1)
      TEMP2=1780.0D0*DSQRT(T4)*T4*T4/Z1+1.0D0/(Z1*Y2/T4**10
     *   +2.13D-3*Z2*V2/DSQRT(T4)/T4**4)
      TEMP2=47.3D0/T4**8+1.0D0/TEMP2
      TEMP2=1.0D0/(4.0D3+1.0D0/TEMP2)
      OP=PE*(4.819D-13*V/T4+TEMP1+TEMP2)
      RETURN
      END
c
