      SUBROUTINE OPACITY(DL,TL,X,Y,Z,C,O,FKAP,IDERIV,DLKLT,DLKLD)
      implicit double precision (a-h,o-z)
C
C General suburoutine  to return the total opacity for a mixture with a
c composition specified by X,Y,C,O, and metallicity Z (=1-X-Y) at
c a given value of log10(rho) (=DL) and log10(T) (=TL).
c
c uses Icko Iben's fits to the Cox & Stewart radiative opacities
c
c Returns opacity as fkap,
c   if IDERIV=1 then computes logarithmic derivatives DLKLD and DLKLT
c
c First evaluate the radiative opacities by calling your favorite
c radiative opacity routine
      call iorad(DL,TL,X,Y,Z,C,O,FKRAD)
c and evaluate the conductive opacities with another favorite routine
      call iocond(DL,TL,X,Y,FKCON)
c 
      fkap=(fkcon*fkrad)/(fkcon+fkrad)
c
c logarithmic derivatives, if requested:
c
      if (ideriv.eq.1) then
        delta=1.d-4
c
        call iorad(dl,tl+delta,x,y,z,c,o,fkrad1)
        call iocond(dl,tl+delta,x,y,fkcon1)
        fkap1=(fkcon1*fkrad1)/(fkcon1+fkrad1)
        dlklt=(dlog10(fkap1)-dlog10(fkap))/delta
c
        call iorad(dl+delta,tl,x,y,z,c,o,fkrad2)
        call iocond(dl+delta,tl,x,y,fkcon2)
        fkap2=(fkcon2*fkrad2)/(fkcon2+fkrad2)
        dlkld=(dlog10(fkap2)-dlog10(fkap))/delta
      endif
c
      return
      END
