      subroutine iocond(dlin,tlin,xin,yin,ochl)
      implicit double precision (a-h,o-z)
c
c Returns the conductive opacity for a mixture (X,Y,Z=1-X-Y) at 
c a given value of log density and log temperature.  Uses the Iben 
c fit to the Hubbard and Lampe opacity tables (Ap. J. 196, 545).
c Implementation by S.Kawaler, August 1990.  Checked against
c actual H&L tables for helium and carbon. Well within 20%
c agreement for log rho>0, can be way off at lower densities, so
c caveat emptor...
c
      dl=dlin
      tl=tlin
      x=xin
      y=yin
      cln=dlog(10.d0)
c
c   If log rho is greater than 6, use Lamb(1974)'s extrapolation
c   of the tables for the conductive opacity when relativistically
c   degenerate...  Though I suppose you could use the Itoh et al.
c   opacities in this regime...
c
      if (dlin.gt.6.d0) then
        ochl1=-1.d0
        dl=6.d0
      endif
c   coarse approximation to <Z^2/A> and ue:
      ue=1.d0/(0.5d0*(1.d0+X))
      avz2oa=x+y+(1.d0-x-y)*3.d0
c (the statement number here is for branching to when dlin > 6)
 10   fldelt=dl-dlog10(ue)-1.5d0*(tl-6.d0)
c      delta=10.d0**fldelt
      delta=dexp(cln*fldelt)
      fleta=-0.55255+(2.d0/3.d0)*fldelt
c      eta=10.d0**fleta
      eta=dexp(cln*fleta)
c Iben equations (A2)-(A5)
      if (fldelt.lt.0.645d0) then
        fltokt=-3.2862d0+dlog10(delta*(1.d0+0.024417*delta))
      else
        a1=-3.29243d0+dlog10(delta*(1.d0+0.02804*delta))
        if (fldelt.lt.2.0d0) then
          fltokt=a1
        else
          b1=-4.80946d0+dlog10(delta*delta*(1.d0+9.376d0/eta/eta))
          if (fldelt.gt.2.5d0) then
            fltokt=b1
          else
            fltokt=2.d0*a1*(2.5d0-fldelt)+2.d0*b1*(fldelt-2.d0)
          endif
        endif
      endif
c (A8) thru (A10) for Pe/NkT
      a2=dlog10(1.d0+0.021876*delta)
      if (fldelt.lt.1.5d0) then
        peonkt=a2
      else
        b2=dlog10(0.4d0*eta*(1.d0+4.1124d0/eta/eta))
        if (fldelt.gt.2.0d0) then
          peonkt=b2
        else
          peonkt=2.d0*a2*(2.d0-fldelt)+2.0d0*b2*(fldelt-1.5d0)
        endif
      endif
c (A11) and (A12) for nednedeta
      if (delta.lt.40.d0) then
        dlnede=1.d0-0.01d0*delta*(2.8966d0-0.034838d0*delta)
      else
        dlnede=(1.5d0/eta)*(1.d0-0.8225/eta/eta)
      endif
c and (A7) for alfa
      temp=dlog10(ue*avz2oa+dlnede)
      alfa=-2.033983d0+fldelt-0.5d0*(tl-6.d0)-peonkt+temp
c
c Now calculate the value of Theta
c
c for Hydrogen
      if (x.le.0.d0) then
        flthx=0.d0
      else
        if (alfa.le.-3.d0) then
          flthx=1.048d0-0.124d0*alfa
        elseif (alfa.gt.-1.d0) then
          flthx=0.185d0-0.585d0*alfa
c note that .585 in above is from Iben's code; paper says 0.558
        else
          flthx=0.13d0-alfa*(0.745d0+0.105d0*alfa)
        endif
      endif
c for Helium
      if (y.le.0.d0) then
        flthy=0.d0
      else
        if (alfa.le.-3.d0) then
          flthy=0.937d0-0.111d0*alfa
        elseif (alfa.gt.0.d0) then
          flthy=0.24d0-0.6d0*alfa
        else
          flthy=0.24d0-alfa*(0.55d0+0.0689d0*alfa)
        endif
      endif
c for Carbon
      if (alfa.lt.-2.5d0) then
        flthc=1.27d0-0.1d0*alfa
      elseif (alfa.gt.0.5d0) then
        flthc=0.843d0-0.785d0*alfa
      else
        flthc=0.727d0-alfa*(0.511d0+0.0778d0*alfa)
      endif
c
      Zhere=1.d0-x-y
c      ochl=x*10.d0**flthx+y*10.d0**flthy+zhere*10.d0**flthc
      ochl= x*dexp(cln*flthx)+y*dexp(cln*flthy)+zhere*dexp(cln*flthc)
c      ochl=ochl/10.d0**(tl-6.d0)/10.d0**fltokt
c      ochl=ochl/10.d0**(tl-6.d0+fltokt)
      ochl=ochl/dexp(cln*(tl-6.d0+fltokt))
c
c If input density greater than 10^6, then extrapolate H&L opacities
c linearly using the opacity at 10^5 and 10^6
c
      if (dlin.gt.6.d0.and.ochl1.le.0.d0) then
         ochl1=ochl
         dl=5.d0
         go to 10
      elseif (dlin.gt.6.d0.and.ochl1.gt.0.d0) then
        flochl=dlog10(ochl1)+(dlog10(ochl1)-dlog10(ochl))*(dlin-6.d0)
        ochl=10.d0**flochl
        return
      endif
c
      return
      end
