      SUBROUTINE OPACITY(DL,TL,X,Y,Z,C,O,FKAP,IDERIV,DLKLT,DLKLD)
      implicit double precision (a-h,o-z)
C
C General suburoutine  to return the total opacity for a mixture with a
c composition specified by X,Y,C,O, and metallicity Z (=1-X-Y) at
c a given value of log10(rho) (=DL) and log10(T) (=TL).
c
c Returns opacity as fkap,
c   if IDERIV=1 then computes logarithmic derivatives DLKLD and DLKLT.
c
c First evaluate the radiative opacities by calling your favorite
c radiative opacity routine
      call csorad(dl,tl,x,y,z,c,o,fkrad,dlkrlt,dlkrld)
c and evaluate the conductive opacities with another favorite routine
      call iocond(DL,TL,X,Y,FKCON)
c 
      fkap=(fkcon*fkrad)/(fkcon+fkrad)
c
c logarithmic derivatives, if requested:
c
      if (ideriv.eq.1) then
        delta=1.d-4
c
        call iocond(dl,tl+delta,x,y,fkcon1)
        dlkclt=(dlog10(fkcon1)-dlog10(fkcon))/delta
        dlklt=fkap/fkrad*dlkrlt+fkap/fkcon*dlkclt
c
        call iocond(dl+delta,tl,x,y,fkcon1)
        dlkcld=(dlog10(fkcon1)-dlog10(fkcon))/delta
        dlkld=fkap/fkrad*dlkrld+fkap/fkcon*dlkcld
      endif
c
      return
      END
