cbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb
cbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb
cbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb
c
c  Begin of the file "k02.for"                        date: September 30, 1991

c ==========                                    ==========
c      <<<<<<    Stellar evolution package    >>>>>>
c ==========                                    ==========
c
c        This code has been originally developed by
c         Bohdan Paczynski  and  Maciej Kozlowski,
c          some parts of it have been written by
c                   Stephen J. Ratcliff
c
c            and this version has been prepared
c                   and distributed by:
c
c      Ryszard Sienkiewicz
c      Nicolaus Copernicus Astronomical Center
c      Bartycka 18, 00-716 Warsaw, POLAND
c
c      e-mail: rs@camk.edu.pl
c      FAX   : (intl) - 48 (Poland) - 22 (Warsaw) - 410046
c      telex : 81 3978  (zapan pl)
c
c ==========                                    ==========
c               ANY COMMENTS ARE MOST WELCOME
c ==========                                    ==========

c*************************************************************************
c   These programs and data come with absolutely no warranty of any kind.
c   The entire risk as to the quality and performance of this package is
c   with you.
c*************************************************************************
c
c   Attention:  read "readme.03" file, please.


c
c  The following program is based on a version by Stephen J. Ratcliff (1985)
c
c
      program k02
c ----------------------------------------------------------------------------
c   The program "k02" prepares an opacity table "envopa" for programs
c   "s02" and "h02" which calculate stellar envelopes.
c
c      It uses the Alexander et al. (molecular + dust) opacities 
c      for log10 T < 4.0   (disk files "molgr.ajr", "minigrid.ajr"),
c      and the Los Alamos radiative opacities + Hubbard-Lampe/Canuto
c      conductive opacities for log10 T >= 4.0 (disk files "opint1...opint7").
C ----------------------------------------------------------------------------
c
c        This file contains ...
c    subroutine:        subject:
c    -----------        --------
c main program - prepares the envelope opacity table "envopa"
c                (to be read and used then by the subroutine "opacit"
c                 in the "s02" and "h02" programs).
c                The main program interpolates between the opacity files
c                "opint1...opint7" for given value of hydrogen content
c                and metal content and fills in a common block /kinter/.
C                -------------------------------------------------------------
c  The output file "envopa" contains log10 of the Rosseland mean absorption
c  coefficient which includes:

c   - the Los Alamos radiative opacities;
c   Huebner, W.F., Merts, A.L., Magee, N.H.,Jr., and Argo, M.F. 1977, Astro-
c   physical Opacity Library, Los Alamos Scientific Lab. Report No. LA-6760-M.

c   - conductive opacities;
c   Hubbard, W.B., and Lampe, M. 1969, Ap.J. Suppl., vol.18, 297.
c   Canuto, V. 1970, Ap.J., vol.159, 641.

c   - molecules + grains opacities;
c   Alexander, D.R., Johnson, H.R., and Rypma, R.L. 1983, Ap.J., vol. 272, 773.
c

c   - "ajrkap" - calculates Alexander et al.(1983) opacities
c   - "setajr" - calls "setalx" and "setamg"
c   - "setalx" - reads in the Alexander et al.(1983) main grid of opacities 
c   - "setamg" - reads in the Alexander et al.(1983) minigrids for
c                metal content,  Z = 0.002 , Z = 0.0002 , Y = 0.20.

c   - "opintr" - interpolates the radiative + conductive opacities and its log
c                derivs. from the current table contained in "common/kinter/"
c.............................................................................
c
C
C   INPUT:    disk files:  opint1...opint7, molgr.ajr, minigrid.ajr
C             TERMINAL:    hydrogen mass fraction, X
c                          heavy elements (metals) mass fraction, Z
C
C---------------------------------------------------------------------------
C   OUTPUT:
C             UNIT=7, FILE='envopa' : the envelope opacity table
C
c---------------------------------------------------------------------------
        implicit logical (a-z)
        common /kinter/totkap(50,55,6),XX(6),ZK
        character*6     fintkp(7)
        character*40    opfile
        real*4          XX,ZK,totkap
        real*4          X,XP,Y,Z,F,T
        real*4		ALT,RHO,FKAP,DKT,DKR
C**************************************   changed by R.S.
      REAL*4 ZTAB,FACZ,ZK1,TTK
      logical ex1
      INTEGER*4 K,K1,I,IN,IN1,IX,IRO,KS,KE,IO,JX,JRO,J,KK
      DIMENSION F(31)
      DIMENSION ZTAB(7),TTK(50,2)
C**************************************   changed by R.S.
        save /kinter/
c
        data fintkp/'opint1','opint2','opint3','opint4','opint5',
     *              'opint6','opint7'/
c
  143 format(1x,' Select chemical composition:',/,
     *       '            hydrogen mass fraction, ( 0 < X < 0.80) = ',$)
  144 format('heavy elements mass fraction, ( 0.00003 < Z < 0.03) = ',$)
      write(*,143)
      read(*,*)xp
      write(*,144)
      read(*,*)z
  
      ex1=.false.
      inquire(file='envopa',exist=ex1)
      if(ex1)stop ' : file "envopa" already exists, rename it ...'

      OPEN(7,FILE='envopa',status='new')
      REWIND(7)
  224 format(/,' Thanks ! - end of screen input - now, wait...')
      write(*,224)
C
      X=XP
C**************************************   changed by R.S.
      ZTAB(1)=.00003
      ZTAB(2)=.00010
      ZTAB(3)=.00030
      ZTAB(4)=.00100
      ZTAB(5)=.00300
      ZTAB(6)=.01000
      ZTAB(7)=.03000
C
      XX(1)=.0
      XX(2)=.1
      XX(3)=.2
      XX(4)=.4
      XX(5)=.6
      XX(6)=.8
C
C
      DO 20 I=1,6
   20 IF(Z.GE.ZTAB(I).AND.Z.LE.ZTAB(I+1))GO TO 21
      IF(Z.LT.ZTAB(1))GO TO 22
      IN=6
      GO TO 23
   22 IN=1
      GO TO 23
   21 IN=I
   23 IN1=IN+1
      FACZ=ALOG10(Z/ZTAB(IN))/ALOG10(ZTAB(IN1)/ZTAB(IN))
C
C
      OPFILE=FINTKP(IN)
      WRITE(*,215)OPFILE,ZTAB(IN)
  215 format('  interpolation between ',a6,'  (Z = ',f6.5,')')
  216 format('                    and ',a6,'  (Z = ',f6.5,')')
      OPEN(UNIT=2,FILE=OPFILE,STATUS='OLD')
      OPFILE=FINTKP(IN1)
      WRITE(*,216)OPFILE,ZTAB(IN1)
      OPEN(UNIT=3,FILE=OPFILE,STATUS='OLD')
C
C
   24 FORMAT(F10.6)
      READ(2,24)ZK
      IF(ABS(ZK-ZTAB(IN)).GT.1.E-6)GO TO 25
      READ(3,24)ZK1
      IF(ABS(ZK1-ZTAB(IN1)).GT.1.E-6)GO TO 25
      GO TO 26
   25 STOP 'wrong metal content for this file name'
   26 CONTINUE
      DO 28 IX=1,6
      DO 29 IRO=1,55
      DO 130 I=1,5
      KS=10*I-9
      KE=KS+9
      DO 134 IO=2,3
      READ(IO,131,END=132)(TTK(K,IO-1),K=KS,KE),JX,JRO,J
  134 IF((IX.NE.JX).OR.(IRO.NE.JRO).OR.(I.NE.J))GO TO 133
  130 CONTINUE
      DO 135 KK=1,50
  135 TOTKAP(KK,IRO,IX)=FACZ*TTK(KK,2)+(1.-FACZ)*TTK(KK,1)
   29 CONTINUE
   28 CONTINUE
  131 FORMAT(10F7.3,3I3)
      CLOSE(UNIT=2)
      CLOSE(UNIT=3)
      GO TO 137
  132 stop '   EOF ON FILE'
  133 stop '   WRONG OPACITY DATA'
  137 ZK=Z
C
C**************************************   changed by R.S.
C
        Y = 1.0-X-Z
c
        call SETAJR

  202 FORMAT(2F8.5)
  204 FORMAT(1X,I5,14F5.2)
      WRITE(7,202)X,Z
c
      K=0
      K1=0
c
   31 CONTINUE
      K=K+1
      ALT=0.05*K+3.25
      IF(K.LE.35)GO TO 32
      ALT=0.2*K-2.0
   32 CONTINUE
c
      IF(K.GT.51)GO TO 37
      T=10.0**ALT
      DO 33 I=1,31
      RHO=10.0**(0.5*I-12.5)
c
      if (ALT .lt. 4.0) then
c
      CALL AJRKAP(RHO,T,X,Z,FKAP)
      F(I) = FKAP
c
                        else
c
      call opintr(RHO,T,X,FKAP,DKR,DKT)
      F(I)=ALOG10(FKAP)
c
        end if
c
   33 CONTINUE
      K1=K1+1
      WRITE (7,204) K1,(F(I),I=1,14)
      K1=K1+1
      WRITE (7,204) K1,(F(I),I=15,28)
      K1=K1+1
      WRITE (7,204) K1,(F(I),I=29,31)
      GO TO 31
   37 CONTINUE
c
      close(7)
      write(*,204)
      write(*,205)X,Z
  205 format(' new file "envopa" created for X = ',f6.5,'   Z = ',f6.5)
      stop '=> k02 - okay'
      END
c****************************************************************************
c   revised 31 Oct 1984 SJR
c
        subroutine AJRKAP(RHO,T,X,Z,FKPajr)
c -----------------------------
c   input:
c       RHO             density [c.g.s.]
c       T               temp         [K]
c       X               H mass frac.
c       Z               metals mass frac.
c   output:
c       FKPajr          log10 Alexander et al. opacity (incl. mols.+grains)
c----------------------------------------------------------------------
        implicit logical (a-z)
        real*4          RHO,T,X,Z,FKPajr
        integer*4 iR,iT,idelgZ
        real*4  fR,fT,RHOlog,Tlog,Y
        common /ALEX/ grmolk
        common /ALEXMG/ztenth,zhundr,y20
        real*4  ztenth(12,9),zhundr(12,9),y20(12,9)
        real*4 grmolk(17,22),dely,dellgZ,fdelgZ,corrY,corrZ1,corrZ2
c
                 save /ALEX/,/ALEXMG/
c
        Y = 0.27-(X-0.71)
c                               yes, I mean Y=0.27-(X-0.71)
c
        RHOlog = alog10(RHO)
        Tlog   = alog10(T)
        fR = (RHOlog+19.0)
        iR = fR
        iR = min(iR,16)
        iR = max(iR,1)
        fR = fR-iR
        if (Tlog .le. 3.70) then
                fT = (Tlog-2.75)/0.05
        else
                fT = (Tlog-3.70)/0.10 + 19.0
        end if
                iT = fT
                iT = min(iT,21)
                iT = max(iT,1)
                fT = fT-iT
        FKPajr = (1.-fT)*((1.-fR)*grmolk(iR,iT)+fR*grmolk(iR+1,iT))
     *          + fT*((1.-fR)*grmolk(iR,iT+1)+fR*grmolk(iR+1,iT+1))
c
        dellgZ = -alog10(Z/0.02)
        idelgZ = dellgZ
        if (dellgZ .lt. 0.) idelgZ = 0
        if (dellgZ .ge. 2.) idelgZ = 1
        fdelgZ = dellgZ - idelgZ
c
        delY = -(Y-0.27)/0.07
c
        fR = RHOlog+16.0
        iR = fR
        iR = min(iR,11)
        iR = max(iR,1)
        fR = fR-iR
        fT = (Tlog-3.1)/0.1
        iT = fT
        iT = min(iT,8)
        iT = max(iT,1)
        fT = fT-iT
c
        corrY = (1.-fT)*((1.-fR)*y20(iR,iT)+fR*y20(iR+1,iT))
     *            +fT*((1.-fR)*y20(iR,iT+1)+fR*y20(iR+1,iT+1))
c
        FKPajr = FKPajr + delY*corrY
c
        corrZ1 = (1.-fT)*((1.-fR)*ztenth(iR,iT)+fR*ztenth(iR+1,iT))
     *            +fT*((1.-fR)*ztenth(iR,iT+1)+fR*ztenth(iR+1,iT+1))
c
        corrZ2 = (1.-fT)*((1.-fR)*zhundr(iR,iT)+fR*zhundr(iR+1,iT))
     *            +fT*((1.-fR)*zhundr(iR,iT+1)+fR*zhundr(iR+1,iT+1))
c
        if (idelgZ .eq. 0) FKPajr = FKPajr + fdelgZ*corrZ1
        if (idelgZ .eq. 1) FKPajr = FKPajr + corrZ1 + fdelgZ*corrZ2
c
        return
        end
c----------------------------------------------------------------
c   created 22 Jan 1985 SJR
c
        subroutine SETAJR
c --------------------------
c   subroutines needed: SETALX  SETAMG
c--------------------------------------------------------------
        call SETALX(1,'molgr.ajr   ')
        call SETAMG(1,'minigrid.ajr')
c
        return
        end
c---------------------------------------------------------------
c---------------------------------
c   revised 19 Oct 1984 SJR
c   revised 22 Jan 1985 SJR
c   IBM PC version
c
        subroutine SETALX(unitno,filnam)
c --------------------------------
c   read in the Alexander et al. main grid of opacities (1983 Ap J)
c---------------------------------
        implicit logical (a-z)
        character*12 filnam
        integer*4 unitno,iR,iTX,iT,i,istart,iend
        common /ALEX/ grmolk
        real*4 grmolk(17,22),temp(10)
        integer*4 indent(22),length(22)
        data indent/3*0,2*1,3*2,2*3,4,3*5,3*6,4*7,8/
        data length/7,6*8,9,8,9,10,11*9/
c
        open(unit=unitno,file=filnam,status='old')
c
        do 110 iT=1,22
c
                do 100 iR=1,17
                        grmolk(iR,iT) = -30.0
  100                   continue
c
                read (unitno,150,err=5200) (temp(i),i=1,10),iTX
  150           format(10f7.3,i3)
                if (iT .ne. iTX) go to 5100
c
                istart = indent(iT)+1
                iend = indent(iT) + length(iT)
                do 105 iR=istart,iend
                        grmolk(iR,iT) = temp(iR-istart+1)
  105                   continue
c
  110           continue
c -------------------------------------------------
c  extrapolate linearly into the corners
c
        do 1100 iT=1,22
                do 1110 iR=indent(iT),1,-1
                        grmolk(iR,iT) = grmolk(iR+1,iT)+grmolk(iR,iT-1)
     *                                  -grmolk(iR+1,iT-1)
 1110                   continue
 1100           continue
c
        do 1200 iT=22,1,-1
                do 1210 iR=indent(iT)+length(iT)+1,17
                        grmolk(iR,iT) = grmolk(iR-1,iT)+grmolk(iR,iT+1)
     *                                  -grmolk(iR-1,iT+1)
 1210                   continue
 1200           continue
c
c
        close(unitno)
        return
c
 5100   continue
        write (*,*) 'SETALX: wrong data card in ''',filnam,''''
        close(unitno)
        stop 5100
 5200   continue
        write (*,*) 'SETALX: error in reading from ''',filnam,''''
        close(unitno)
        stop 5200
        end
c---------------------------------
c------------------------------------
c   revised 24 Oct 1984 SJR
c   revised 22 Jan 1985 SJR
c
        subroutine SETAMG(unitno,filnam)
c --------------------------
c   reads in the Alexander et al. (1983 Ap J) minigrids for
c   Z = 0.002 , Z = 0.0002 , Y = 0.20
c-------------------------------------
        implicit logical (a-z)
        character*12 filnam
        integer*4 unitno,i,j,iR,iT,iitest
        common/ALEX/grmolk
        common/ALEXMG/ztenth,zhundr,y20
c
        real*4    ztenth(12,9),zhundr(12,9),y20(12,9),grmolk(17,22)
        real*4  LAdkZ1(12),LAdkZ2(12),LAdkY(12)
c
c               12: log rho=-15(1)-4   9: log T=3.2(0.1)4.0
c
        integer*4 ii(12),jj(6)
        data ii/4,5,6,7,8,9,10,11,12,13,14,15/
        data jj/9,11,13,15,17,19/
c
        data LAdkZ1/ 0.036, 0.011,-0.012,-0.035,-0.057,-0.077,
     *              -0.074,-0.042,-0.029,-0.034,-0.044,-0.050/
        data LAdkZ2/ 0.009,-0.018,-0.042,-0.065,-0.087,-0.107,
     *              -0.098,-0.053,-0.034,-0.040,-0.053,-0.055/
        data LAdkY /-0.037,-0.015, 0.005, 0.024, 0.042, 0.058,
     *               0.070, 0.066, 0.053, 0.046, 0.046, 0.043/
c
        open(unit=unitno,file=filnam,status='old')
c
                iitest = 1
        read(unitno,100,err=5100) i
        if (i .ne. iitest) go to 5200
        read(unitno,200,err=5100) ((ztenth(j,i),j=1,12),i=6,1,-1)
                iitest = 2
        read(unitno,100,err=5100) i
        if (i .ne. iitest) go to 5200
        read(unitno,200,err=5100) ((zhundr(j,i),j=1,12),i=6,1,-1)
                iitest = 3
        read(unitno,100,err=5100) i
        if (i .ne. iitest) go to 5200
        read(unitno,200,err=5100) ((y20(j,i),j=1,12),i=6,1,-1)
c
  100   format(i5)
  200   format(6(12f8.3:/))
        close(unitno)
c ----------------------------------------------
c   extrapolate linearly to all densities, for log T <= 3.7 .
c   Filling-in of the table for log T >= 3.8 occurs later.
c   Here, ztenth, zhundr, and y20 have opacities, not differences.
c
        do 1100 iT=1,6
                do 1110 iR=5,1,-1
                        if (ztenth(iR,iT) .le. -20.0)
     *                  ztenth(iR,iT) = ztenth(iR+1,iT)+ztenth(iR,iT-1)
     *                                  -ztenth(iR+1,iT-1)
                        if (zhundr(iR,iT) .le. -20.0)
     *                  zhundr(iR,iT) = zhundr(iR+1,iT)+zhundr(iR,iT-1)
     *                                  -zhundr(iR+1,iT-1)
                        if (y20(iR,iT) .le. -20.0)
     *                     y20(iR,iT) =    y20(iR+1,iT)+   y20(iR,iT-1)
     *                                  -   y20(iR+1,iT-1)
 1110                   continue
 1100           continue
c
        do 1200 iT=6,1,-1
                do 1210 iR=7,12
                        if (ztenth(iR,iT) .le. -20.0)
     *                  ztenth(iR,iT) = ztenth(iR-1,iT)+ztenth(iR,iT+1)
     *                                  -ztenth(iR-1,iT+1)
                        if (zhundr(iR,iT) .le. -20.0)
     *                  zhundr(iR,iT) = zhundr(iR-1,iT)+zhundr(iR,iT+1)
     *                                  -zhundr(iR-1,iT+1)
                        if (y20(iR,iT) .le. -20.0)
     *                     y20(iR,iT) =    y20(iR-1,iT)+   y20(iR,iT+1)
     *                                  -   y20(iR-1,iT+1)
 1210                   continue
 1200           continue
c ---------------------------------------------------------------
c   Now make ztenth, zhundr, and y20 the opacity DIFFERENCES,
c   for log T <= 3.7
c
        do 108 i=1,12
                do 108 j=1,6
                        zhundr(i,j) = zhundr(i,j)-ztenth(i,j)
                        ztenth(i,j) = ztenth(i,j)-grmolk(ii(i),jj(j))
                        y20(i,j) = y20(i,j)-grmolk(ii(i),jj(j))
  108                   continue
c ---------------------------------------------------------------
c   Now fill in the ad hoc differences for log T >= 3.8
c   These rules are based on the approximate behavior of the
c   Cox-Stewart opacities in 3.7 <= log T <= 4.1 , -9 <= log rho <= -1
c   The values af the differences LAdkZ1,LAdkZ2,LAdkY were computed
c   from the Los Alamos interiors opacities at log T  = 4.1, with
c   z = 0.01, 0.001, and 0.0001, WHICH ALREADY INCLUDED CONDUCTIVE
c   OPACITIES.
c
        do 300 i=1,10
                do 300 j=7,9
                        ztenth(i,j) = LAdkZ1(i)
                        zhundr(i,j) = LAdkZ2(i)
                        y20(i,j)    = LAdkY(i)
  300                   continue
c
        do 400 i=11,12
                do 401 j=8,9
                        ztenth(i,j) = LAdkZ1(i)
                        zhundr(i,j) = LAdkZ2(i)
                        y20(i,j)    = LAdkY(i)
  401                   continue
                ztenth(i,7) = (2*ztenth(i,8)+ztenth(i,6))/3.
                zhundr(i,7) = (2*zhundr(i,8)+zhundr(i,6))/3.
                y20(i,7) = LAdkY(i)
  400           continue
c
        return
c
 5100   continue
        write (*,*) 'SETAMG: error reading file ',filnam
        close(unitno)
        stop 5100
 5200   continue
        write (*,*) 'SETAMG: wrong data in ',filnam,': i=',iitest
        stop 5200
        end
c---------------------------------------
c--------------------------------------------------------------
c   revised  2 Oct 1984 SJR
c
        subroutine opintr(RHO,T,X,FKAP,DKR,DKT)
c -------------------------------------------------------------
c   "opintr" interpolates the radiative + conductive opacities
c   and its log derivs from the current table contained in
c   the common block /kinter/.
c -------------------------------------------------------------
c   input:
c       RHO             density        [c.g.s.]
c       T               temperature         [K]
c       X               hydrogen mass fraction
c       /kinter/        common block with the interiors opacities
c
c   output:
c       FKAP            opacity        [c.g.s.]
c       DKR             d log10(kap) / d log10(RHO)
c       DKT             d log10(kap) / d log10(T)
c -------------------------------------------------------------
        implicit logical (a-z)
        real*4  RHO,T,X,FKAP,DKR,DKT
        common  /kinter/totkap(50,55,6),XX(6),ZK
        real*4  ZK,totkap,XX
        integer*4       indxR,indxT,indxX,int
        real*4  tempR,tempT,RHOlog,Tlog,RHfrac,Tfrac
        real*4  totka1,totka2,comRfr,comTfr,t1,t2,r1,r2
        real*4  XminX0,X1minX,delXX
c
        save /kinter/
c
        Tlog   = alog10(T)
        RHOlog = alog10(RHO)
c
        tempR  = 3.0*RHOlog + 31.0
        tempT  = 10.0*Tlog - 40.0
        indxR  = int(tempR)
        indxT  = int(tempT)
c
        if (indxT .lt.  1) indxT = 1
        if (indxT .gt. 49) indxT = 49
        if (indxR .lt.  1) indxR = 1
        if (indxR .gt. 54) indxR = 54
c
        RHfrac = tempR - float(indxR)
        Tfrac  = tempT - float(indxT)
c
        comRfr = 1.0-RHfrac
        comTfr = 1.0-Tfrac
c
        indxX = 1
        if (X .gt. 0.10) indxX = 2
        if (X .gt. 0.20) indxX = 3
        if (X .gt. 0.40) indxX = 4
        if (X .gt. 0.60) indxX = 5
c
        XminX0 = X - XX(indxX)
        X1minX = XX(indxX+1) - X
        delXX  = XminX0 + X1minX
c
c
c       INTERPOLATE OPACITY
c
        totka1 = comRfr*(comTfr*totkap(indxT,  indxR,indxX)
     *                   +Tfrac*totkap(indxT+1,indxR,indxX))
     *          +RHfrac*(comTfr*totkap(indxT,  indxR+1,indxX)
     *                   +Tfrac*totkap(indxT+1,indxR+1,indxX))
c
        indxX = indxX + 1
c
        totka2 = comRfr*(comTfr*totkap(indxT,  indxR,indxX)
     *                   +Tfrac*totkap(indxT+1,indxR,indxX))
     *          +RHfrac*(comTfr*totkap(indxT,  indxR+1,indxX)
     *                   +Tfrac*totkap(indxT+1,indxR+1,indxX))
c
        totka1 = 10.0**totka1
        totka2 = 10.0**totka2
c
        FKAP = X1minX*totka1 + XminX0*totka2
        FKAP = FKAP/delXX
c
c       ... OPACITY GRADIENTS
c
        t2 = totkap(indxT+1,indxR,indxX)-totkap(indxT,indxR,indxX)
        r2 = totkap(indxT,indxR+1,indxX)-totkap(indxT,indxR,indxX)
        indxX = indxX - 1
        t1 = totkap(indxT+1,indxR,indxX)-totkap(indxT,indxR,indxX)
        r1 = totkap(indxT,indxR+1,indxX)-totkap(indxT,indxR,indxX)
c
        DKR = (X1minX*r1 + XminX0*r2)/delXX*3.0
        DKT = (X1minX*t1 + XminX0*t2)/delXX*10.0
c
        return
        end
c**************************************************************
c.............................................................................
c        This file contains the following five subroutines:
c              - "ajrkap" -
c              - "setajr" -
c              - "setalx" -
c              - "setamg" -
c              - "opintr" -
c                                                    end of the file "k02.for"
ceeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee
ceeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee
ceeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee




