cbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb
cbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb
cbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb
c   *************************  Attempts made to make this work. 1 July 03
c  *************************   Carl Hansen  *******************************
c
c  Begin of the file "s03.f"                        date: November 14, 1992


c ==========                                    ==========
c      <<<<<<    Stellar evolution package    >>>>>>
c ==========                                    ==========
c
c        This code has been originally developed by
c         Bohdan Paczynski  and  Maciej Kozlowski,
c          some parts of it have been written by
c                   Stephen J. Ratcliff
c
c            and this version has been prepared
c                   and distributed by:
c
c      Ryszard Sienkiewicz
c      Nicolaus Copernicus Astronomical Center
c      Bartycka 18, 00-716 Warsaw, POLAND
c
c      e-mail: rs@camk.edu.pl
c      FAX   : (intl) - 48 (Poland) - 22 (Warsaw) - 410046
c      telex : 81 3978  (zapan pl)
c
c ==========                                    ==========
c               ANY COMMENTS ARE MOST WELCOME
c ==========                                    ==========

c*************************************************************************
c   These programs and data come with absolutely no warranty of any kind.
c   The entire risk as to the quality and performance of this package is
c   with you.
c*************************************************************************
c
c   Attention:  read "readme.03" file, please.


c        This file contains "Schwarzschild-type" program "s03",
c        providing the evolutionary program "h03" with first, static
c        Zero-age Hydrogen Main Sequence model.

c        When compiling, the program is automatically supplemented with
c        five extra disk files:
c         - "commonsb.03"
c         - "data.03"
c         - "opacity.03"
c         - "nuclear.03"
c         - "eostate.03"                (see following comments)
c
c ----------------------------------------------------------------------------
c Input data:
c    -) screen input
c         starm = total stellar mass                 [M Sun]
c         telg  = log10 (surface temperature)        [K]
c         fllg  = log10 (surface luminosity)         [L Sun]
c         tclg  = log10 (central temperature)        [K]
c         rhclg = log10 (central density)            [g/cm**3]
c         x, z  = hydrogen and heavy element content [by mass fraction]
c   notice:
c         telg, fllg, tclg, rhclg are guessed values of the boundary
c         parameters to be improved by the subroutine "sch"
c
c    -) other input data files, as requested by included subroutines
c       (see "include" directives at the end of the code) i.e.:
c        -) opacity data files - "opint1",....,"opint7"
c        -) opacity data file  - "envopa" prepared with program "k02"
c            for given values of hydrogen and heavy elements content
c        -) equation-of-state data file - "electron.gas"
c
c Output data:
c    -) to a disk file "mod0000.h03"
c    -) screen output (see explanations inside the code).
c
c ----------------------------------------------------------------------------
c WARNING: rename, or remove existing "mod0000.h03" file
c          before running the program again !
c          Real*8 (double precision) has extended exponents.
c          On other machines there may be fatal underflows or zero divides.
c ----------------------------------------------------------------------------
c
c "s03.f"  is the main part of the code and includes the main program
c            and the following nine subroutines, all others subroutines
c            are located and described on separate disk files and are
c            included through "include" directives.
c
c    subroutine:        subject:
c    -----------        --------
c
c   - "setsch" -    sets parameters, reads data for iterations
c   - "sch"    -    iterations, Scwarzschild method
c                     SUBROUTINES CALLED:
c                     - "upintg" -
c                     - "dnintg" -
c                     - "solve"  -
c   - "solve"  -    finds corrections, Newton method
c   - "dnintg" -    downward integration to the fitting point
c                     SUBROUTINES CALLED:
c                     - "env"    - (included - file "commonsb.03")
c                     - "integ"  -
c   - "upintg" -    upward integration to the fitting point
c                     SUBROUTINES CALLED:
c                     - "center" - (included - file "commonsb.03")
c                     - "integ"  -
c   - "integ"  -    conducts integrations
c                     SUBROUTINES CALLED:
c                     - "step"   -
c   - "step"   -    used by "integ"
c                     SUBROUTINES CALLED:
c                     - "rhs"    -
c   - "rhs"    -    used by "step" to calculate the right-hand sides
c                   of stellar structure equations
c                     SUBROUTINES CALLED:
c                     - "opact" -  (included - file "opacity.03")
c                     - "state" -  (included - file "eostate.03")
c                     - "nburn" -  (included - file "nuclear.03")
c                     - "mixlen"-  (included - file "commonsb.03")
c   - "storeh" -    stores results for the evolutionary program "h03"
c                     SUBROUTINES CALLED:
c                     - "upintg" -
c                     - "dnintg" -
c                     - "grid1"  - (included - file "commonsb.03")
c                          redistributes mass points
c                     - "writeh" - (included - file "commonsb.03")
c                          writes a model on the disk file "mod0000.h03"
c ----------------------------------------------------------------------------
c ----------------------------------------------------------------------------
c
c There are some separated files which provide the code with "standard"
c       physics and boundary conditions. They are listed below.
c T h e s e   f i l e s   m a y   b e   e a s i l y   r e p l a c e d, if ne-
c cessary. However, to avoid changes in the main part, new SUBROUTINES should:
c   -) provide the program with actually requested data
c   -) have the same names as the old ones
c   -) be connected with the code in the same manner (i.e., through proper
c      parameters and/or common blocks - see appropriate "call" statements).
c
c   disk file:             subject:
c   ----------             --------
c
c "data.03"     - model parameters and constants
c "eostate.03"  - equation of state includes contributions from:
c                  nondegenerate/degenerate electrons, nondegenerate ions
c                  and radiation as well as from partially ionized gas
c                  (reads the disk file "electron.gas")
c "opacity.03"  - reads and interpolates coefficient of opacity from
c                  the Los Alamos radiative opacity tables with conductive
c                  opacities and Alexander's molecular opacities added
c                  (the disk files "opint1"..."opint7" are used in the
c                  internal part of a model and the disk file "envopa"
c                  with the molecular + grains opacities included is used
c                  in the envelope)
c "nuclear.03"  - calculates nuclear reaction rates for p-p chain and CN cycle
c                  + neutrino energy loss rate (if hydrogen content = 0)
c "commonsb.03" - includes subroutines common for the "s03" and "h03" codes.
c
c ----------------------------------------------------------------------------
c ----------------------------------------------------------------------------
c
c
c HEREAFTER:  "time difference" (or "time change") stands for the change
c             of a variable (the array "hx") during the current time step
c             (the array "dh").
c
c             "Gradient" alone stands for the temperature gradient.
c
c..............................................................................
c$DEBUG
      implicit double precision(a-h,o-z)
      include 'data.03'

      dimension xvec(nx)
c                                                        --- set the constants,
c                                                            read the parameters
      call setsch(starm,telg,fllg,tclg,rhclg,fmf,fmcen,
     *            xvec)
c                                                        --- converge the model
      call sch   (starm,telg,fllg,tclg,rhclg,fmf,fmcen,
     *            xvec,npts)
c                                                        --- store the model
      call storeh(starm,telg,fllg,tclg,rhclg,fmf,fmcen,
     *            xvec,npts)
      stop '=> s03 - okay'
c                                                        --- end of main program
      end
c
c............................................................................
      subroutine setsch(starm,telg,fllg,tclg,rhclg,fmf,fmcen,
     *                  xvec)
      implicit double precision(a-h,o-z)
      include 'data.03'
      dimension xvec(nx)
      common/hen/ hx(m2,nt), dh(m2,nt), nh
c
c subject:
c     this subroutine sets the constants and reads the parameters of a
c     stellar main sequence model to be calculated by the program "s03"
c output:
c     starm   = total stellar mass                          [M Sun]
c     telg    = log10 (surface temperature)   (a guess)     [K]
c     fllg    = log10 (surface luminosity)    (a guess)     [L Sun]
c     tclg    = log10 (central temperature)   (a guess)     [K]
c     rhclg   = log10 (central density)       (a guess)     [g/cm**3]
c     fmf     = mass at the fitting point  / total stellar mass
c     fmcen   = mass of the central sphere / total stellar mass
c     xvec(1) = x = hydrogen content                        [by mass fraction]
c     xvec(2) = y = helium content                          [by mass fraction]
c     xvec(3) = zn= primordial C + N content                [by mass fraction]
c..........................................................................

c                              --- read the model parameters from the keyboard:
      write(*,100)
      write(*,1021)
      read(*,*)starm
      write(*,1026)
      read(*,*)x
      write(*,1027)
      read(*,*)z
      write(*,1022)
      read(*,*)telg
      write(*,1023)
      read(*,*)fllg
      write(*,1024)
      read(*,*)tclg
      write(*,1025)
      read(*,*)rhclg
  224 format(/,' Thanks ! - end of screen input - now, wait...')
      write(*,224)
c                              --- set the constants related to the actual
c                                   stellar mass and luminosity
      flunit=10.0**fllg*sunl
      fmtot=starm*sunm
c                              --- set data in common /heninc/
      model=0
      time=0
      dtime=0
c                              --- set mass of outer envelope, mass of central
c                                  ball and position of the fitting point
c                                  (it concerns all following models)
      fmcen=3d-6
      fmf=0.3d0
c                              --- set vector of chemical abundances
      zn=z*0.26d0
      xvec(1)=x
      xvec(2)=1.0d0-x-z
      xvec(3)=zn
c                              --- initiate common /heninc/
      do 1 i=1,20
         com(i)=0.0d0
         icom(i)=0
    1 continue

  100 format(/,' This program "s03"',
     *' calculates a Zero-age Hydrogen Main Sequence model'
     *,/,' - results will be stored on a disk file "mod0000.h03"')
 1021 format(//,
     $       '               select stellar parameters :',//,
     $       '                mass of the star / solar mass  = ',$)
 1022 format(/,
     $       '               select initial values of :',//,
     $       '      log10 (surface temperature in degrees K) = ',$)
 1023 format('         log10 (luminosity / solar luminosity) = ',$)
 1024 format('      log10 (central temperature in degrees K) = ',$)
 1025 format('            log10 (central density in g/cm**3) = ',$)
 1026 format('         the following element abundances must be',/,
     $       '         the same as those used in file "envopa":',/,
     $       '                initial hydrogen mass fraction = ',$)
 1027 format('                  heavy elements mass fraction = ',$)

c                              --- end of "setsch"
      end
c
c...........................................................................
c
      subroutine sch(starm,telg,fllg,tclg,rhclg,fmf,fmcen,
     *               xvec,npts)
      implicit double precision(a-h,o-z)
      include 'data.03'
      dimension xvec(nx)

c subject:
c     calculate chemically homogeneous stellar model in a thermal
c     equilibrium, i.e. a model on a zero age main sequence by means of
c     fitting results of integrations of envelope and core at the
c     fitting mass, fmf.
c input:
c     starm   = total stellar mass                            [M Sun]
c     telg    = log10 (surface temperature)   (a guess)       [K]
c     fllg    = log10 (surface luminosity)    (a guess)       [L Sun]
c     tclg    = log10 (central temperature)   (a guess)       [K]
c     rhclg   = log10 (central density)       (a guess)       [g/cm**3]
c     fmf     = mass at the fitting point / total mass
c     fmcen   = mass of the central sphere / total mass
c     xvec(1) = x = hydrogen content                         [by mass fraction]
c     xvec(2) = y = helium content                           [by mass fraction]
c     xvec(3) = zn= primordial C + N content                 [by mass fraction]
c output:
c     telg    = log10 (surface temperature) in fitted model   [K]
c     fllg    = log10 (surface luminosity)  in fitted model   [L Sun]
c     tclg    = log10 (central temperature) in fitted model   [K]
c     rhclg   = log10 (central density)     in fitted model   [g/cm**3]
c     npts    = number of mass points needed to store the fitted model
c called
c     upintg, dnintg, solve
c auxiliary variables:
c     difacc     = the maximum difference allowed at the fitting point
c     del        = perturbations of the logarithms of boundary parameters
c     itmax      = the maximum number of iterations
c     iter       = the iteration counter
c     difmax     = the maximum difference calculated at the fitting point
c     delfit(i)  = the calculated differences at the fitting point for
c                     the four variables = xe(i)/xc(i)-1 , i=1,2,3,4
c     xe(i)      = results of the downward integrations at the fitting point
c     xc(i)      = results of the upward integrations at the fitting point
c     deriv(i,j) = partial derivatives of the differences at the fitting
c                     point with respect to the boundary parameters
c     delce(i)   = corrections added to the boundary parameters
c............................................................................

      common /comsch/ xe(20),xe1(20),xe2(20),xc(m2),xc3(m2),xc4(m2),
     *                delfit(4),delce(4),deriv(4,5)
c               --- the common above is declared for needs of SVS/386 v.01
c                   fortran compiler. It is not used outside of this subroutine

c                               --- set the constants for fitting and iterations
      difacc=1.0d-8
      del=1.0d-9
      itmax=15
c                               --- iterations
      iter=0
    1 continue
      iter=iter+1
c                               --- emergency exit if iterations do not converge
      if (iter.gt.itmax) then
         write(*,*)' iterations have not converged - increase "itmax"'
         write(*,*)' ... or try again using another initial values
     $ of the stellar parameters'
         write(*,*)' ... or decrease values of the "delmax" array'
         stop ': file "s03.f" - subroutine "sch" - '
      end if
c                              --- basic downward and upward integrations

      istore=0
      call upintg (tclg,rhclg,fmcen,fmf,xvec,istore,xc,nptup)
      call dnintg (starm,telg,fllg,fmf,xvec,istore,xe,nptdn)

c                              --- number of mass points needed to store results
c                                  (not including space for boundary values)
      npts=nptdn+nptup-1
c                              --- compute differences between downward and
c                                  upward integrations.
      difmax=0.0d0
      do 2 i=1,4
         delfit(i)=xe(i)/xc(i)-1.0d0
         dif=dabs(delfit(i))
c Changed to  dabs. CJH
         if (difmax.lt.dif) difmax=dif
    2 continue
c                              --- check if downward and upward integrations
c                                  fit each other
      if(difmax.lt.difacc)go to 5

c                              --- calculate derivatives of differences with
c                                  respect to the boundary telg,fllg,tclg,rhclg

      istore=0
      call dnintg (starm,telg+del,fllg,fmf,xvec,istore,xe1,nptdn)
      call dnintg (starm,telg,fllg+del,fmf,xvec,istore,xe2,nptdn)
      call upintg (tclg+del,rhclg,fmcen,fmf,xvec,istore,xc3,nptup)
      call upintg (tclg,rhclg+del,fmcen,fmf,xvec,istore,xc4,nptup)

      do 3 i=1,4
         deriv(i,1)=((xe1(i)/xc(i)-1.0)-delfit(i))/del
         deriv(i,2)=((xe2(i)/xc(i)-1.0)-delfit(i))/del
         deriv(i,3)=((xe(i)/xc3(i)-1.0)-delfit(i))/del
         deriv(i,4)=((xe(i)/xc4(i)-1.0)-delfit(i))/del
         deriv(i,5)=delfit(i)
    3 continue
c                              --- calculate corrections to the boundary
c                                  parameters. Newton method
      call solve(deriv,delce,facdel)

c                              --- write results of iteration

      if(iter.eq.1)write(*,149)difacc
      if(iter.eq.1)write(*,159)
      write(*,101)iter-1,telg,fllg,tclg,rhclg,facdel,difmax

c                              --- add corrections to the boundary parameters
      telg=telg+delce(1)
      fllg=fllg+delce(2)
      tclg=tclg+delce(3)
      rhclg=rhclg+delce(4)
c                              --- end of an iteration
      go to 1
c                              --- iterations have converged, downward and
c                                  upward integrations fit each other
    5 continue

      write(*,101)iter-1,telg,fllg,tclg,rhclg,facdel,difmax

      write(*,103)
      x=xvec(1)
      z=1.d0-xvec(1)-xvec(2)
      write(*,104)x,z,starm,telg,fllg,tclg,rhclg
      return

  101 format(1x,i5,4f8.4,3x,2f15.9)
  103 format(1x,'   X        Z       M     log Ts   log L  log Tc'
     *,'  log rhc')
  104 format(1x,f6.3,f10.7,5f8.4,i4)
  149 format (1x,/,
     $' iter    = the iteration counter                       ',/,
     $' log Ts  = log10 (surface temperature)        [K]      ',/,
     $' log L   = log10 (surface luminosity)         [L Sun]  ',/,
     $' log Tc  = log10 (central temperature)        [K]      ',/,
     $' log rhc = log10 (central density)            [g/cm**3]',/,
     $' facdel  = reduction factor for the corrections, if no
     $ reduction',/,
     $'           is applied then "facdel" indicates
     $ the largest correction',/,
     $'           (in units of "delmax")',/,
     $' difmax  = the maximum relative difference calculated
     $ at the fitting point,',/,
     $'           in a fitted model, it is less than  ',1pd6.0)
  159 format(/,'  iter  log Ts  log L   log Tc  log rhc        facdel',
     $'         difmax')

c                              --- end of "sch"
      end
c
c............................................................................

      subroutine solve(deriv,delce,facdel)
      implicit double precision(a-h,o-z)
      include 'data.03'
      dimension deriv(4,5),delce(4)

c subject:
c     solve n=4 linear algebraic equations
c input:
c     deriv(n,n+1) = array of coefficients of "n" linear algebraic equations
c output:
c     delce(n)   = n corrections, without delmax(i) they should satisfy n
c                  equations: sum over j: deriv(i,j)*delce(j)+deriv(i,n+1)=0
c                  however, delce(i) are reduced so as to make them not larger
c                  than delmax(i)
c     facdel     = reduction factor for the corrections, if no reduction is
c                  applied then "facdel" indicates the largest correction
c                  (in units of "delmax")
c auxiliary variables:
c     delmax(n)  = maximum acceptable values of corrections
c     n = 4      = number of equations = number of unknowns (i.e. corrections)
c............................................................................

      dimension delmax(4)
c                                --- set maximum acceptable values for
c                                    corrections to the boundary parameters:
c                                    telg, fllg, tclg, rhclg respectively
      delmax(1)=0.02d0
      delmax(2)=0.05d0
      delmax(3)=0.02d0
      delmax(4)=0.06d0

      n=4
      nm=n-1
      np=n+1
c                                --- solving n * n set of linear equations
      do 1,k=1,nm
         kp=k+1
         fac1=deriv(k,k)
         do 2 i=kp,n
            fac2=deriv(i,k)
            do 3 j=kp,np
               deriv(i,j)=deriv(i,j)*fac1-deriv(k,j)*fac2
    3       continue
    2    continue
    1 continue

c                              --- the matrix of the set is now triangular

      delce(n)=-deriv(n,np)/deriv(n,n)

      do 4 i=2,n
         i1=n-i+1
         i2=i1+1
         delce(i1)=-deriv(i1,np)
         do 5 j=i2,n
            delce(i1)=delce(i1)-deriv(i1,j)*delce(j)
    5    continue
         delce(i1)=delce(i1)/deriv(i1,i1)
    4 continue
c                              --- the unknowns delce(i) have been found

c                              --- find the largest "delce" in units of "delmax"
      dm=0.0d0
      do 6 i=1,n
         d=dabs(delce(i)/delmax(i))
c Changed to dabs. CJH
         if(dm.lt.d)dm=d
    6 continue
c                              --- reduce corrections to the boundary parameters
      facdel=1.0d0
      if(dm.gt.1.0d0)facdel=dm
      do 7 i=1,n
         delce(i)=delce(i)/facdel
    7 continue

      facdel=dm
c                              --- end of "solve"
      end
c
c............................................................................

      subroutine dnintg(starm,telg,fllg,fmf,xvec,istore,
     *                  xx,npts)
      implicit double precision(a-h,o-z)
      include 'data.03'
      dimension xvec(nx)
      dimension xx(m2)

c subject:
c     integrate stellar structure equations from the surface to the fitting
c     point for a chemically homogeneous star
c input:
c     starm   = total stellar mass                            [M Sun]
c     telg    = log10 (surface temperature)                   [K]
c     fllg    = log10 (surface luminosity)                    [L Sun]
c     fmf     = mass at the fitting point / total stellar mass
c     xvec(1) = x = hydrogen content                         [by mass fraction]
c     xvec(2) = y = helium content                           [by mass fraction]
c     xvec(3) = zn= primordial C + N content                 [by mass fraction]
c     istore  = control variable. See "integ" for description
c output:
c     xx at the fitting point:
c     xx(1)   = log10 (density)                               [g/cm**3]
c     xx(2)   = log10 (temperature)                           [K]
c     xx(3)   = log10 (radius)                                [cm]
c     xx(4)   = luminosity / luminosity unit
c     xx(5)   = log (mass / (total stellar mass - mass))
c     xx(6)...xx(5+nx) = vector of chemical abundances
c     npts    = number of mass points used through integration
c called
c     env        to calculate all variables at the stellar surface
c     integ      to integrate to the fitting point
c predefined in 'data.03'
c     mm, nx
c...........................................................................

      dimension resenv(20)

      call env(telg,fllg,starm,xvec,resenv)

c                                               --- prepare starting vector for
c                                                   downward integrations
      do 1 i=1,mm
      xx(i)=resenv(i)
    1 continue
      do 2 i=1,nx
      xx(mm+i)=xvec(i)
    2 continue
c                                               --- downward integrations
      call integ(xx,fmf,npts,istore)
c                                               --- end of "dnintg"
      end
c
c............................................................................
c
      subroutine upintg(tclg,rhclg,fmcen,fmf,xvec,istore,
     *                  xx,npts)
      implicit double precision(a-h,o-z)
      include 'data.03'
      dimension xvec(nx), xx(m2)

c subject:
c     integrate stellar structure equations from the center to the fitting
c     point for a chemically homogeneous star
c input:
c     rhclg   = log10 (central density)                       [g/cm**3]
c     tclg    = log10 (central temperature)                   [K]
c     fmf     = mass at the fitting point / total stellar mass
c     xvec(1) = x = hydrogen content                         [by mass fraction]
c     xvec(2) = y = helium content                           [by mass fraction]
c     xvec(3) = zn= primordial C + N content                 [by mass fraction]
c     istore  = control variable. See "integ" for description
c output:
c     xx at the fitting point:
c     xx(1)   = log10 (density)                               [g/cm**3]
c     xx(2)   = log10 (temperature)                           [K]
c     xx(3)   = log10 (radius)                                [cm]
c     xx(4)   = luminosity / luminosity unit
c     xx(5)   = log (mass / (total stellar mass - mass))
c     xx(6)...xx(5+nx) = vector of chemical abundances
c     npts    = number of mass points used through integration
c called
c     center     to calculate all variables at the surface of the
c                innermost sphere
c     integ      to calculate all variables at the fitting point
c............................................................................

      call center(rhclg,tclg,fmcen,xvec,0.d0,0.d0,0.d0,xx)
      call integ(xx,fmf,npts,istore)
c                                               --- end of "upintg"
      end
c
c............................................................................
c
      subroutine integ(xx,fmf,npts,istore)
      implicit double precision(a-h,o-z)
      include 'data.03'
      common/hen/ hx(m2,nt), dh(m2,nt), nh
      dimension xx(m2)

c subject:
c     integrate stellar structure equations from the starting point
c     defined by the vector "xs" to the fitting point "fmf" for a chemically
c     homogeneous star
c input:
c     xx     = vector of starting values
c     xx(1)  = log10 (density)                                     (g/cm**3)
c     xx(2)  = log10 (temperature)                                 (K)
c     xx(3)  = log10 (radius)                                      (cm)
c     xx(4)  = luminosity / luminosity unit
c     xx(mm=5)   = log (mass / (total stellar mass - mass))
c     xx(mm+1)...xx(mm+nx) = vector of chem. abundances: hydrogen, helium etc
c     fmf    = mass at the fitting point / total stellar mass
c     istore = control variable
c            = 0 - results of integration will not be stored
c            = 1 - results will be stored in hx(i,2), hx(i,3) and up
c            = 2 - results will be stored in hx(i,nt-1), hx(i,nt-2) and down
c output:
c     xx     = vector of results of integration in the fitting point.
c              all variables have the same meaning as on input
c     npts   = number of integration points (including starting one)
c called
c     step       to make integration steps
c common/hen/
c     hx     = array for (temporary) storing results.
c predefined in 'data.03'
c     nt, mm, m2
c............................................................................

      dimension acc(5)
c                                    --- set upper limits for step size in all
c                                        variables, using those defined in
c                                        'data.03' as ss1, ss2, ss3, ss4, ss5
c                                        and multiplied by "facss"
      acc(1)=ss1*facss
      acc(2)=ss2*facss
      acc(3)=ss3*facss
      acc(4)=ss4*facss
      acc(5)=ss5*facss
c                                    --- set maximum number of mass points
      nptmax=1000
      if (istore.ne.0) nptmax=nt-2
c                                    --- store starting data in the array "hx"
      if (istore.ne.0) then
         khx=2
         if (istore.eq.2) khx=nt-1
         do 1 i=1,m2
            hx(i,khx)=xx(i)
    1    continue
      end if
c                                    --- switch on nuclear reactions
      inuc=1
c                                    --- carry integrations
      npts=1
    2 continue
         npts=npts+1
         call step(xx,acc,fmf,inuc)
c                                    --- store results in the array "hx"
         if (istore.ne.0) then
            if (istore.eq.1) khx=khx+1
            if (istore.eq.2) khx=khx-1
            do 3 i=1,m2
               hx(i,khx)=xx(i)
    3       continue
         end if
c                                    --- check end-of-integration conditions
      if(dabs(dexp(xx(mm))/(1.d0+dexp(xx(mm)))/fmf-1.d0).lt.1.d-6)
     $ return
c                                    --- emergency exit
         if (npts.ge.nptmax) stop ': file "s03.f" - subroutine "sch"
     * - too many mass points'
      go to 2
c                                    --- end of "integ"
      end
c
c..............................................................................
c
      subroutine step(xx,acc,fmf,inuc)
      implicit double precision(a-h,o-z)
      include 'data.03'
      dimension xx(m2),acc(mm)
c subject:
c     make one integration step for a stellar core or envelope with a second
c     order Runge-Kutta method. The steps are carried up to the mass = fmf.
c     Step is positive if on input fmf > mass and negative in the other case.
c input:
c     xx(1) = log10 (density)                      [g/cm**3]
c     xx(2) = log10 (temperature)                  [K]
c     xx(3) = log10 (radius)                       [cm]
c     xx(4) = luminosity / luminosity unit
c     xx(mm=5)   = log (mass / (total stellar mass - mass))
c     xx(mm+1)...xx(mm+nx) = vector of chem. abundances: hydrogen, helium etc.
c     acc(1)...acc(mm) = upper limits for step size in all variables (positive)
c     fmf   = mass at the fitting point / total stellar mass
c     inuc  = control variable. If inuc=0 then nuclear reactions are neglected.
c output:
c     xx(i), i=1..m2   at the end of integration step
c called:
c     rhs     to calculate right hand sides of differential equations
c auxiliary variables:
c     h   = integration step size
c     yy(i) = d xx(i) / d xx(mm) as calculated by subroutine rhs
c     xi(i) = values of xx(i) variables at the middle of the integration step
c     extra = vector of extra results produced by "rhs". Not used here.
c predefined in 'data.03'
c     mm = number of variables (incl. indep. one)
c     m2 = number of variables (incl. indep. one) + number of chemical elements
c.............................................................................

      dimension yy(m2),xs(m2),extra(20)

c                              --- preserve variables at the beginning of step
      do 1 i=1,mm
      xs(i)=xx(i)
    1 continue

      call rhs(xx,yy,extra,inuc)
c                              --- estimate the integration step
      hi=0.
      do 2 i=1,mm
         h=dabs(yy(i)/acc(i))
         if (hi.lt.h) hi=h
    2 continue
      h=1.d0/hi
c                              --- choose direction of integration
      xxmm=dexp(xx(mm))/(1.d0+dexp(xx(mm)))
      if(xxmm.gt.fmf) h=-h
c                              --- match the fitting point exactly
      if((xxmm-fmf)*(dexp(xx(mm)+h)/(1.d0+dexp(xx(mm)+h))-fmf).lt.0.d0)
     $ h = dlog(fmf/(1-fmf)) - xx(mm)

c                              --- make the first half of the integration step
      do 3 i=1,mm
      xx(i)=xs(i)+0.5d0*h*yy(i)
    3 continue
c                              --- compute right hand sides in the half of step
      call rhs(xx,yy,extra,inuc)
c                              --- make the whole integration step
      do 4 i=1,mm
      xx(i)=xs(i)+h*yy(i)
    4 continue
c                              --- end of "step"
      end
c
c.............................................................................
c
      subroutine rhs(xx,yy,extra,inuc)
      implicit double precision(a-h,o-z)
      include 'data.03'
      dimension xx(m2),yy(m2),extra(20)
c
c subject:
c     calculate right hand sides of the stellar structure equations
c     for the thermally static case (time-dependent terms not included)
c     If inuc=0 then nuclear reactions are switched off
c input:
c     xx(1) = log10 (density)                      [g/cm**3]
c     xx(2) = log10 (temperature)                  [K]
c     xx(3) = log10 (radius)                       [cm]
c     xx(4) = luminosity / unit luminosity
c     xx(5) = log (mass / (total stellar mass - mass))
c     xx(6) = hydrogen content                     [by mass fraction]
c     xx(7) = helium content                       [by mass fraction]
c     xx(8..5+nx) = subsequent elements content    [by mass fraction]
c     inuc  = if inuc=0 then nuclear reactions are not taken into account
c output:
c     yy(1) = d log10 rh/ d xx(5)   attention: this is different than in "rhsh"
c     yy(2) = d log10 t / d xx(5)
c     yy(3) = d log10 r / d xx(5)
c     yy(4) = d l/lunit / d xx(5) = 0. if inuc=0.
c     yy(5) = d xx(5)   / d xx(5) = 1.0
c     yy(6)...yy(m2) = 0.
c     extra = number of additional functions. See "rhsh" for description
c called:
c     state    to calculate thermodynamic functions
c     opact    to calculate opacity (total: radiative and conductive)
c     nburn    to calculate energy generation rate in hydrogen burning
c              + neutrino energy loss rate (if hydrogen content = 0)
c              (if inuc=0 then no call of "nburn")
c     mixlen   to calculate effective temperature gradient
c              according to the "mixing length theory"
c common /heninc/
c     flunit  = luminosity unit, close to maximum or surface lumin.  [erg/s]
c     fmtot   = total stellar mass                                   [g]
c auxiliary variables:
c     p      = total pressure                                        [c.g.s.]
c     prad   = radiation pressure                                    [c.g.s.]
c     grad   = d ln t / d ln p     at constant entropy (adiabatic temperature
c                                  gradient)
c     grrad  = d ln t / d ln p     radiative temperature gradient
c     grt    = d ln t / d ln p     temperature gradient in the star
c     grrh   = d ln rh / d ln p    density gradient in the star
c     dpm    = d log10 p / d ( Mr / total mass ) pressure gradient in the star
c.............................................................................

      dimension xvec(nx),dxtvec(nx)

      fcon1   = (flunit/fmtot)/(16.d0*pi*clight*gconst)
      fcon2   = gconst/4.d0/pi*fmtot**2/fln10
      fcon3   = fmtot/4.d0/pi/fln10
      fcon4   = fmtot/flunit

      rh=10.**xx(1)
      t=10.**xx(2)
      r=10.**xx(3)
      flr=xx(4)
      e5=dexp(xx(5))
      fmr=e5/(1.d0+e5)

      epsx=0.d0

      do 1 i=1,nx
      xvec(i)=xx(mm+i)
      dxtvec(i)=0.d0
    1 continue

      call opact(rh,t,xvec,fkap)
      call state(rh,t,xvec,extra)
      if (inuc.ne.0) call nburn(rh,t,xvec,epsx,dxtvec)
      p    = extra(1)
      pt   = extra(2)
      pr   = extra(3)
      pgas = extra(4)
      prad = extra(5)
      grad = extra(6)
      qt   = extra(7)
      qr   = extra(8)

      plog=dlog10(p)
      grrad=fcon1*fkap*p/prad*flr/fmr
      grt=grad
      if(grt.gt.grrad)grt=grrad

c  ...........................................
      if (grrad.gt.grad) then
c                                 --- calculation of an effective temperature
c                                     gradient according to the "mixing length
c                                     theory" for t < te1
      if (t.lt.te1)
     $call mixlen(rh,t,r,fmr,p,extra(10),extra(11),fkap,grad,grrad,grt)

c                                 --- checking if covection is really adiabatic
c                                     in the intermediate zone, te1 < t < te2,
c                                     within relative accuracy of 0.001
      if (t.gt.te1.and.t.lt.te2) then
      grrad1=fcon1*com(14)*com(15)/prad*flr/fmr
      call mixlen(rh,t,r,fmr,com(15),com(16),com(17),com(14),com(18),
     $grrad1,grt12)
      if(dabs(grt12/com(18)-1.d0).gt.0.001d0)
     $stop 'nonadiabatic convection for t > te1, make "te1" higher'
      end if
      end if
c  ...........................................

      grrh=(1.d0-grt*pt)/pr
      dpm=-fcon2*fmr/r**4/p

      do 2 i=1,m2
      yy(i)=0.d0
   2  continue

      yy(1)=grrh*dpm
      yy(2)=grt*dpm
      yy(3)=fcon3/(rh*r**3)
      if (inuc.ne.0) yy(4)=fcon4*epsx

      do 3 i=1,m2
      yy(i)=yy(i)*e5/(1.d0+e5)**2
    3 continue
      yy(5)=1.d0

c                              --- end of "rhs"
      end
c
c..............................................................................
c
      subroutine storeh(starm,telg,fllg,tclg,rhclg,fmf,fmcen,
     *                  xvec,npts)
      implicit double precision (a-h,o-z)
      include 'data.03'
      dimension xvec(nx)
      common/hen/ hx(m2,nt), dh(m2,nt), nh

c subject:
c     store on disk the results of model integrations in format convenient
c     for the main evolutionary program
c input:
c     starm   = total stellar mass                           [M Sun]
c     telg    = log10 (surface temperature) in fitted model  [K]
c     fllg    = log10 (surface luminosity)  in fitted model  [L Sun]
c     tclg    = log10 (central temperature) in fitted model  [K]
c     rhclg   = log10 (central density)     in fitted model  [g/cm**3]
c     fmf     = mass at the fitting point / total mass
c     fmcen   = mass of the central sphere / total mass
c     xvec(1) = x = hydrogen content                         [by mass fraction]
c     xvec(2) = y = helium content                           [by mass fraction]
c     xvec(3) = zn= primordial C + N content                 [by mass fraction]
c     npts    = number of mass points needed to store the fitted model
c output:
c     first goes to the common /hen/ in temporary format. Then format is
c     changed to a standard form. The final results are written as a disk file.
c common/hen/ - all mass points
c     hx(1,k) = log10 (density)                              [g/cm**3]
c     hx(2,k) = log10 (temperature)                          [K]
c     hx(3,k) = log10 (radius)                               [cm]
c     hx(4,k) = luminosity / luminosity unit
c     hx(mm=5,k) = log (mass / (total stellar mass - mass))
c     hx(6,k) = x  = hydrogen content                        [by mass fraction]
c     hx(7,k) = y  = helium content                          [by mass fraction]
c     hx(8,k) = zn = nitrogen content for CNO burning        [by mass fraction]
c common/hen/ - the boundary parameters:
c     hx(1,nh)= telg    = log10 ( surface temperature )      [K]
c     hx(2,nh)= fllg    = log10 ( surface luminosity / solar luminosity )
c     hx(5=mm,nh)= starm   = total stellar mass / solar mass
c     hx(1,1) = tclg    = log10 ( central temperature )      [K]
c     hx(2,1) = rhclg   = log10 ( central density )          [g/cm**3]
c common/hen/ - the other parameters
c     nh      = total number of mass points including two boundary points
c     dh      = not used here
c predefined in 'data.03'
c     nt,mm,m2
c     m2      = the number of variables in every mass zone
c............................................................................

      dimension xe(20),xc(m2)

c                            --- the total number of mass points to store
c                                fitted model is known. If there is no space
c                                enough in the array "hx" then emergency exit
      if (npts.gt.nt-2) then
         write(*,*) 'no space enough in array "hx" to store the model'
         stop ': file "s03.f" - subroutine "storeh" - '
      end if

c                            --- store results of integrations in the array "hx"
c                                on positions 2,3,... and nt-1,nt-2,... resp.
      istore=2
      call dnintg (starm,telg,fllg,fmf,xvec,istore,xe,nptdn)
      istore=1
      call upintg (tclg,rhclg,fmcen,fmf,xvec,istore,xc,nptup)

c                            --- shift down results of downward integrations
      nh=nptup+1
      do 2 k=nt-nptdn+1,nt-1
         nh=nh+1
         do 1 i=1,m2
            hx(i,nh)=hx(i,k)
    1    continue
    2 continue
c                            --- store boundary values in array "hx"
      nh=nh+1
      do 3 i=1,m2
         hx(i,1)=0.d0
         hx(i,nh)=0.d0
    3 continue
      do 4 i=1,nx
         hx(mm+i,1)=xvec(i)
    4 continue
      hx(1,1)=rhclg
      hx(2,1)=tclg
      hx(1,nh)=telg
      hx(2,nh)=fllg
      hx(mm,nh)=starm
c                            --- renormalize luminosity in every mass zone:
      nh1=nh-1
      faclum=hx(4,nh1)
      flunit=flunit*faclum
      do 5 k=2,nh1
         hx(4,k)=hx(4,k)/faclum
    5 continue
c                            --- redistribute mass zones so, as to make them
c                                about the same width in units of ss(i).
      call grid1(2,nh-1)
c                            --- write the model as disk file
      call writeh
c                            --- end of "storeh"
      end
c.............................................................................

c this is a good place to include some extra code
      include 'eostate.03'
      include 'opacity.03'
      include 'nuclear.03'
      include 'commonsb.03'


      subroutine stupid
c This is stupid but NDP Fortran compiler needs here the "end" statement
      end
c..............................................................................
c        This file contains "Schwarzschild-type" program "s03" -
c         main program and nine subroutines called:
c               - "setsch" -
c               - "sch"    -
c               - "solve"  -
c               - "dnintg" -
c               - "upintg" -
c               - "integ"  -
c               - "step"   -
c               - "rhs"    -
c               - "storeh" -
c                                                    end of the file "s03.f"
ceeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee
ceeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee
ceeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee