//
// generated by Qedo
//

#include "dinner_PhilosopherImpl.h"


// BEGIN USER INSERT SECTION file
#include <iostream>

using namespace std;

#ifdef _WIN32
#define sleep(X) Sleep(X*1000)
#endif


namespace dinner {

#ifdef ORBACUS_ORB
JTCThreadWithTimer::JTCThreadWithTimer()
{
}


JTCThreadWithTimer::~JTCThreadWithTimer()
{
	cout << "JTCThreadWithTimer: Destructor called" << endl;
}


void
JTCThreadWithTimer::timer_sleep (long millis)
{
	JTCSynchronized synchronized (*this);	

	bool done_ = false;

	while (! done_)
	{
		try
		{ 
			this -> wait (millis);
			done_ = true;
		}
		catch (JTCInterruptedException&)
		{
		}
	}
}


void
JTCThreadWithTimer::wake_up()
{
	JTCSynchronized synchronized (*this);	

	this->notify();
}

PhilosopherThread::PhilosopherThread (PhilosopherSessionImpl* phil)
: phil_ (phil)
{
	phil->_add_ref();
}


PhilosopherThread::~PhilosopherThread()
{
	cout << "PhilosopherThread: Destructor called" << endl;

	phil_->_remove_ref();
}


void 
PhilosopherThread::run()
{
	phil_->run();
}


void 
PhilosopherThread::stop()
{
	// Remove this thread friendly
	JTCThreadHandle my_handle = this;

	phil_->stopped_ = true;

	this->wake_up();

	do
	{
		try
		{
			my_handle->join();
		}
		catch (...)
		{
			cerr << "Exception during join()" << endl;
		}
	} while (my_handle->isAlive());
}

#endif
}
// END USER INSERT SECTION file


namespace dinner {


// BEGIN USER INSERT SECTION PhilosopherSessionImpl
#ifdef ORBACUS_ORB
void
PhilosopherSessionImpl::run()
#else
void*
PhilosopherSessionImpl::run(void *p)
#endif
{
	PhilosopherSessionImpl* impl;
#ifndef MICO_ORB
	impl = this;
#else
	impl = static_cast<PhilosopherSessionImpl*>(p);
#endif
	bool have_left = false, have_right = false;
	Components::Cookie_var leftcook = 0;
	Components::Cookie_var rightcook = 0;
	
	dinner::Fork_var left_hand = impl->context_->get_connection_left_hand();
	dinner::Fork_var right_hand = impl->context_->get_connection_right_hand();
	dinner::PhilosopherStatus status;
	dinner::PhilosopherState_var report;
	unsigned short dead_counter;

	while (! impl->stopped_)
	{
		status = dinner::THINKING;
		cout << "PhilosopherSessionImpl: Philosopher is thinking -> " << impl->id_ << endl;
		report = new PhilosopherStateImpl (status, impl->id_.c_str(),
			dinner::Philosopher::_narrow (impl->context_->get_CCM_object()));
		impl->context_->push_philosopher_state (report);
		sleep (impl->tsec_);
	
		if (impl->stopped_)
			break;

		status = dinner::HUNGRY;
		cout << "PhilosopherSessionImpl: Philosopher is hungry -> " << impl->id_ << endl;
		report = new PhilosopherStateImpl (status, impl->id_.c_str(),
			dinner::Philosopher::_narrow (impl->context_->get_CCM_object()));
		impl->context_->push_philosopher_state (report);
		dead_counter = 4;

		while ( status == dinner::HUNGRY && ! impl->stopped_)
		{
			sleep (2);

			if (--dead_counter == 0)
			{
				cout << "PhilosopherSessionImpl: Philosopher is dead... aaaaaahhhhhhhhhhhhhh...  -> " << impl->id_ << endl;
				status = dinner::DEAD;
				report = new PhilosopherStateImpl (status, impl->id_.c_str(),
					dinner::Philosopher::_narrow (impl->context_->get_CCM_object()));
				impl->context_->push_philosopher_state (report);

#ifdef ORBACUS_ORB
				while (! impl->stopped_)
				{
					JTCSynchronized synchronized (*phil_thread_);
					phil_thread_->wait();
				}
#endif
			}
			try
			{
				// Philosophers with even eating seconds first try to get the left fork, the others the right fork
				if (impl->esec_ % 2)
				{
					rightcook = right_hand->obtain_fork();
					have_right = true;

					cout << "PhilosopherSessionImpl: Got right fork -> " << impl->id_ << endl;
				}
				else
				{
					leftcook = left_hand->obtain_fork();
					have_left = true;

					cout << "PhilosopherSessionImpl: Got left fork -> " << impl->id_ << endl;
				}
			}
			catch (dinner::ForkNotAvailable&)
			{
				cout << "PhilosopherSessionImpl: Fork in use -> " << impl->id_ << endl;
				continue;
			}
			catch (CORBA::SystemException& ex)
			{
				cerr << "PhilosopherSessionImpl: CORBA system exception during obtain_fork(), continue..." << endl;
				cerr << ex << endl;
				continue;
			}

			try
			{
				// Philosophers with even eating seconds second try to get the right fork, the others the left fork
				if (impl->esec_ % 2)
				{
					leftcook = left_hand->obtain_fork();
					have_left = true;

					cout << "PhilosopherSessionImpl: Got left fork -> " << impl->id_ << endl;
				}
				else
				{
					rightcook = right_hand->obtain_fork();
					have_right = true;

					cout << "PhilosopherSessionImpl: Got right fork -> " << impl->id_ << endl;
				}
			}
			catch (dinner::ForkNotAvailable&)
			{
				cout << "PhilosopherSessionImpl: Fork in use -> " << impl->id_ << endl;

				if (impl->esec_ % 2)
				{
					right_hand->release_fork (rightcook);
					have_right = false;
				}
				else
				{
					left_hand->release_fork (leftcook);
					have_left = false;
				}

				continue;
			}
			catch (CORBA::SystemException&)
			{
				cerr << "PhilosopherSessionImpl: CORBA system exception during obtain_fork(), continue..." << endl;
				continue;
			}

			break;
		}

		if (impl->stopped_)
			break;

		status = dinner::EATING;
		cout << "PhilosopherSessionImpl: Philosopher is eating -> " << impl->id_ << endl;
		report = new PhilosopherStateImpl (status, impl->id_.c_str(),
			dinner::Philosopher::_narrow (impl->context_->get_CCM_object()));
		impl->context_->push_philosopher_state (report);
		sleep (impl->esec_);

		if (impl->stopped_)
			break;

		try
		{
			right_hand->release_fork (rightcook);
			have_right = false;

			left_hand->release_fork (leftcook);
			have_left = false;
		}
		catch (dinner::NotTheEater&)
		{
			cout << "PhilosopherSessionImpl: Unexpected dinner::NotTheEater exception. I'm in hell, aborting... -> " << impl->id_ << endl;
			abort();
		}
		catch (CORBA::SystemException&)
		{
			cout << "PhilosopherSessionImpl: CORBA system exception during release_fork(). I'm in hell, aborting... -> " << impl->id_ << endl;
			abort();
		}

		status = dinner::SLEEPING;
		cout << "PhilosopherSessionImpl: Philosopher is sleeping -> " << impl->id_ << endl;
		report = new PhilosopherStateImpl (status, impl->id_.c_str(),
			dinner::Philosopher::_narrow (impl->context_->get_CCM_object()));
			impl->context_->push_philosopher_state (report);
		sleep (impl->ssec_);

		if (impl->stopped_)
			break;
	}
}


void
PhilosopherSessionImpl::stop()
{
#ifdef ORBACUS_ORB
	phil_thread_->stop();
#else
	stopped_ = true;
	phil_thread_->join();
#endif
}

// END USER INSERT SECTION PhilosopherSessionImpl


PhilosopherSessionImpl::PhilosopherSessionImpl()
{
// BEGIN USER INSERT SECTION PhilosopherSessionImpl::PhilosopherSessionImpl
	stopped_ = false;

#ifdef ORBACUS_ORB
	phil_thread_ = new PhilosopherThread (this);
#endif
// END USER INSERT SECTION PhilosopherSessionImpl::PhilosopherSessionImpl
}


PhilosopherSessionImpl::~PhilosopherSessionImpl()
{
// BEGIN USER INSERT SECTION PhilosopherSessionImpl::~PhilosopherSessionImpl
	cout << "PhilosopherSessionImpl: Destructor called" << endl;
// END USER INSERT SECTION PhilosopherSessionImpl::~PhilosopherSessionImpl

}


void
PhilosopherSessionImpl::set_context(::dinner::CCM_Philosopher_ContextImpl_ptr context)
    throw (CORBA::SystemException, Components::CCMException)
{
    context_ = ::dinner::CCM_Philosopher_ContextImpl::_duplicate(context);
}


void
PhilosopherSessionImpl::configuration_complete()
    throw (CORBA::SystemException, Components::InvalidConfiguration)
{
// BEGIN USER INSERT SECTION PhilosopherSessionImpl::configuration_complete
#ifdef ORBACUS_ORB
	phil_thread_->start();
#else
	phil_thread_ = context_->start_thread(run,this);
#endif
// END USER INSERT SECTION PhilosopherSessionImpl::configuration_complete
}


void
PhilosopherSessionImpl::remove()
    throw (CORBA::SystemException)
{
// BEGIN USER INSERT SECTION PhilosopherSessionImpl::remove
// END USER INSERT SECTION PhilosopherSessionImpl::remove
}


void
PhilosopherSessionImpl::thinking_seconds(CORBA::ULong param)
	throw(CORBA::SystemException)
{
// BEGIN USER INSERT SECTION PhilosopherSessionImpl::_thinking_seconds
	tsec_ = param;
// END USER INSERT SECTION PhilosopherSessionImpl::_thinking_seconds
}


CORBA::ULong
PhilosopherSessionImpl::thinking_seconds()
	throw(CORBA::SystemException)
{
// BEGIN USER INSERT SECTION PhilosopherSessionImpl::thinking_seconds
	return tsec_;
// END USER INSERT SECTION PhilosopherSessionImpl::thinking_seconds
}


void
PhilosopherSessionImpl::eating_seconds(CORBA::ULong param)
	throw(CORBA::SystemException)
{
// BEGIN USER INSERT SECTION PhilosopherSessionImpl::_eating_seconds
	esec_ = param;
// END USER INSERT SECTION PhilosopherSessionImpl::_eating_seconds
}


CORBA::ULong
PhilosopherSessionImpl::eating_seconds()
	throw(CORBA::SystemException)
{
// BEGIN USER INSERT SECTION PhilosopherSessionImpl::eating_seconds
	return esec_;
// END USER INSERT SECTION PhilosopherSessionImpl::eating_seconds
}


void
PhilosopherSessionImpl::sleeping_seconds(CORBA::ULong param)
	throw(CORBA::SystemException)
{
// BEGIN USER INSERT SECTION PhilosopherSessionImpl::_sleeping_seconds
	ssec_ = param;
// END USER INSERT SECTION PhilosopherSessionImpl::_sleeping_seconds
}


CORBA::ULong
PhilosopherSessionImpl::sleeping_seconds()
	throw(CORBA::SystemException)
{
// BEGIN USER INSERT SECTION PhilosopherSessionImpl::sleeping_seconds
	return ssec_;
// END USER INSERT SECTION PhilosopherSessionImpl::sleeping_seconds
}


void
PhilosopherSessionImpl::name(const char* param)
	throw(CORBA::SystemException)
{
// BEGIN USER INSERT SECTION PhilosopherSessionImpl::_name
	cout << "PhilosopherSessionImpl: Name set to " << param << endl;

	id_ = CORBA::string_dup (param);
// END USER INSERT SECTION PhilosopherSessionImpl::_name
}


char*
PhilosopherSessionImpl::name()
	throw(CORBA::SystemException)
{
// BEGIN USER INSERT SECTION PhilosopherSessionImpl::name
	cout << "PhilosopherSessionImpl: Name is " << id_.c_str() << endl;

	return CORBA::string_dup (id_.c_str());
// END USER INSERT SECTION PhilosopherSessionImpl::name
}


// BEGIN USER INSERT SECTION PhilosopherImpl
// END USER INSERT SECTION PhilosopherImpl


PhilosopherImpl::PhilosopherImpl()
:component_(new PhilosopherSessionImpl())
{
// BEGIN USER INSERT SECTION PhilosopherImpl::PhilosopherImpl
// END USER INSERT SECTION PhilosopherImpl::PhilosopherImpl
}


PhilosopherImpl::~PhilosopherImpl()
{
// BEGIN USER INSERT SECTION PhilosopherImpl::~PhilosopherImpl
	cout << "PhilosopherImpl: Destructor called" << endl;
// END USER INSERT SECTION PhilosopherImpl::~PhilosopherImpl

    component_->_remove_ref();
}


::CORBA::Object*
PhilosopherImpl::obtain_executor(const char* name)
    throw (CORBA::SystemException)
{
    if (! strcmp ( name, "component" ) ) {
        return Components::EnterpriseComponent::_duplicate (component_);
    }
    
    return Components::EnterpriseComponent::_nil();
}


void
PhilosopherImpl::release_executor(::CORBA::Object_ptr executor)
    throw (CORBA::SystemException)
{
    CORBA::release (executor);
}


void
PhilosopherImpl::configuration_complete()
    throw (CORBA::SystemException, Components::InvalidConfiguration)
{
    component_->configuration_complete();

// BEGIN USER INSERT SECTION PhilosopherImpl::configuration_complete
// END USER INSERT SECTION PhilosopherImpl::configuration_complete
}


void
PhilosopherImpl::set_session_context(::Components::SessionContext_ptr context)
    throw (CORBA::SystemException, Components::CCMException)
{
    #ifdef TAO_ORB
    ::dinner::CCM_Philosopher_Context_ptr tmp_context;
    
    tmp_context = dynamic_cast<::dinner::CCM_Philosopher_ContextImpl*>(context);
    
    if (tmp_context)
        context_ = ::dinner::CCM_Philosopher_ContextImpl::_duplicate(tmp_context);
    else
        context_ = ::dinner::CCM_Philosopher_ContextImpl::_nil();
        
    #else
    context_ = ::dinner::CCM_Philosopher_ContextImpl::_narrow(context);
    
    #endif
    component_->set_context(context_);
}


void
PhilosopherImpl::ccm_activate()
    throw (CORBA::SystemException, Components::CCMException)
{
// BEGIN USER INSERT SECTION PhilosopherImpl::ccm_activate
	cout << "PhilosopherImpl: ccm_activate() called" << endl;
// END USER INSERT SECTION PhilosopherImpl::ccm_activate
}


void
PhilosopherImpl::ccm_passivate()
    throw (CORBA::SystemException, Components::CCMException)
{
// BEGIN USER INSERT SECTION PhilosopherImpl::ccm_passivate
	cout << "PhilosopherImpl: ccm_passivate() called" << endl;
// END USER INSERT SECTION PhilosopherImpl::ccm_passivate
}


void
PhilosopherImpl::ccm_remove()
    throw (CORBA::SystemException, Components::CCMException)
{
// BEGIN USER INSERT SECTION PhilosopherImpl::ccm_remove
	cout << "PhilosopherImpl: ccm_remove() called" << endl;

	component_->stop();
// END USER INSERT SECTION PhilosopherImpl::ccm_remove
}


// BEGIN USER INSERT SECTION PhilosopherHomeImpl
// END USER INSERT SECTION PhilosopherHomeImpl


PhilosopherHomeImpl::PhilosopherHomeImpl()
{
// BEGIN USER INSERT SECTION PhilosopherHomeImpl::PhilosopherHomeImpl
// END USER INSERT SECTION PhilosopherHomeImpl::PhilosopherHomeImpl
}


PhilosopherHomeImpl::~PhilosopherHomeImpl()
{
// BEGIN USER INSERT SECTION PhilosopherHomeImpl::~PhilosopherHomeImpl
	cout << "PhilosopherHomeImpl: Destructor called" << endl;
// END USER INSERT SECTION PhilosopherHomeImpl::~PhilosopherHomeImpl

}


void
PhilosopherHomeImpl::set_context(Components::HomeContext_ptr ctx)
    throw (CORBA::SystemException, Components::CCMException)
{
    context_ = Components::HomeContext::_duplicate(ctx);
}


::Components::EnterpriseComponent_ptr
PhilosopherHomeImpl::create ()
    throw (CORBA::SystemException, Components::CreateFailure)
{
// BEGIN USER INSERT SECTION PhilosopherHomeImpl::create
// END USER INSERT SECTION PhilosopherHomeImpl::create
    return new PhilosopherImpl();
}


};


//
// entry point
//
::Components::HomeExecutorBase_ptr
create_PhilosopherHomeE(void)
{
// BEGIN USER INSERT SECTION create_PhilosopherHome
// END USER INSERT SECTION create_PhilosopherHome

    return new ::dinner::PhilosopherHomeImpl();
}

