(* ------------------------------------------------------------------------ *)
(* writer_env.sml                                                           *)
(* environment writer for the casl standalone tool                          *)
(* Pascal Schmidt <pharao90@tzi.de>                                         *)
(* ------------------------------------------------------------------------ *)

(* $Id: writer_env.sml,v 1.1 2004/02/13 11:29:10 7till Exp $ *)

(* todo: Output names of all files that are written
*)

signature WriterEnvSig
=
sig
  val write_envs : Options.casl_options ->
                    (string * (GlobalEnv.lib_env * GlobalEnv.global_env
                     * AS.LIB_DEFN)) list ->
                    unit list
end

structure WriterEnv : WriterEnvSig
=
struct

open Utils

fun basen []       = []
  | basen ("/"::t) = []
  | basen (h::t)   = h :: (basen t)

fun basename x = (implode o rev o basen o rev o explode) x

fun w_casenv l (x,(le,ge,tr)) = if (x<>"") then
                                  if (Options.env_casenv l) then
                                  let
                                    val _ = writeln "Converting global environment to ATerms";
                                    val at1 = AT.S_GLOBAL_ENV ge tr;
                                    val _ = writeln "Converting annotations";
                                    val at = AT.conv_at at1;
                                  in
                                    ( if (Options.env_aterm l) then
                                        ATLib.aterm_to_file (out (x^".env.trm")) at
                                      else
                                        ();
                                      if (Options.env_text l) then
                                        StructuredPrint.output_global_env
                                        (out (x^".env.txt")) ge tr
                                      else
                                        ();
                                      if (Options.env_latex l) then
                                        StructuredPrint.latex_global_env
                                        (out (x^".env.tex")) ge tr
                                      else
                                        ();
                                      if (Options.env_xml l) then
                                        xml_iface.casenv2file true ge
                                        (out (x^".env.xml"))
                                      else
                                        ()
                                    )
                                  end
                                  else
                                    ()
                                else
                                  ()

fun w_fcasenv l (x,(le,ge,tr)) = if (x<>"") then
                                   if (Options.env_fcasenv l) then
                                   let
                                     val en = Flatten.flatten ge
                                     val at = AT.conv_at (AT.S_F_GLOBAL_ENV en)
                                   in
                                     ( if (Options.env_aterm l) then
                                         ATLib.aterm_to_file (out (x^".fenv.trm")) at
                                       else
                                         ();
                                       if (Options.env_text l) then
                                         StructuredPrint.output_f_global_env
                                         (out (x^".fenv.txt")) en tr
                                       else
                                         ();
                                       if (Options.env_latex l) then
                                         StructuredPrint.latex_f_global_env
                                         (out (x^".fenv.tex")) en tr
                                       else
                                         ();
                                       if (Options.env_xml l) then
                                         xml_iface.fcasenv2file true en
                                         (out (x^".fenv.xml"))
                                       else
                                         ()
                                     )
                                   end
                                   else
                                     ()
                                 else
                                   ()

fun writer l n = ( (map (w_casenv l)) n;
               (* (map (w_hcasenv l)) n; *)
                   (map (w_fcasenv l)) n )
                 

fun dobin l (x,(le,ge,tr)) = if (x<>"") then
                               if ((Options.output_bin l) andalso
                                 (Options.env_aterm l)) then (
                  if (Options.env_casenv l) then
                    ( writeln ("Compressing "^x^".env.trm to "^x^".env.baf");
                      OS.Process.system ("mv "^x^".env.trm /tmp/"^(basename x));
                      OS.Process.system ("trm2baf < /tmp/"^(basename x)^" > "^x^".env.baf");
                      OS.Process.system ("rm /tmp/"^(basename x));
                      () )
                  else
                    ();
                  if (Options.env_fcasenv l) then
                    ( writeln ("Compressing "^x^".fenv.trm to "^x^".fenv.baf");
                      OS.Process.system ("mv "^x^".fenv.trm /tmp/"^(basename x));
                      OS.Process.system ("trm2baf < /tmp/"^(basename x)^" > "^x^".fenv.baf");
                      OS.Process.system ("rm /tmp/"^(basename x));
                      () )
                  else
                    () )
                else
                  ()
              else
                ()

fun dobins l n = (map (dobin l)) n

fun write_envs l n = if (Options.output_env l) then
                       ( writer l n ; (dobins l n) )
                     else
                       [()]

end
