
structure CASL98 =
struct

local open Library Term Mixfix
in

infix |>

val sign =

CASL98Pure.sign
   |> Sign.prep_ext
   |> Sign.add_path "/"
   |> curry Sign.add_modesyntax
("", true)
[("predication1", "PredSymb  => Atom ", Mixfix ("_ ", [], 30)),
 ("predication2", "[PredSymb , TTerms ] => Atom ", Mixfix ("_ '(_ ')", [20, 0], 30)),
 ("literal", "[Literal ] => TTerm ", Mixfix (" _ ", [], 1000)),
 ("idterm", "[ID ] => TTerm ", Mixfix (" _ ", [], 1000)),
 ("varterm", "[SIMPLE_ID , TOKEN_ID ] => TTerm ", Mixfix ("'( var _ : _ ')", [], 1000)),
 ("qualconstterm", "[ID , OpType ] => TTerm ", Mixfix ("'( op  _ : _ ')", [], 1000)),
 ("whenElseTerm", "[TTerm , Formula , TTerm ] => TTerm ", Mixfix ("_ when _ else _", [31, 0, 30], 30)),
 ("cast", "[TTerm , TOKEN_ID ] => TTerm ", Mixfix (" _ as _", [990], 990)),
 ("application1", "[OpSymb , TTerms ] => TTerm ", Mixfix (" _ '( _ ')", [], 1000)),
 ("sortedTerm", "[TTerm , TOKEN_ID ] => TTerm ", Mixfix (" _ : _", [990], 990)),
 ("parTerm", "TTerm  => TTerm ", Mixfix (" '( _ ')", [0], 1000)),
 ("_idT", "TTerm  => TTerms ", Mixfix ("_", [], max_pri)),
 ("_consT", "[TTerm , TTerms ] => TTerms ", Mixfix ("_ ,/ _", [], max_pri)),
 ("opensqbra", "TOKEN ", Mixfix ("[", [], max_pri)),
 ("closesqbra", "TOKEN ", Mixfix ("]", [], max_pri)),
 ("openbrace", "TOKEN ", Mixfix ("{", [], max_pri)),
 ("closebrace", "TOKEN ", Mixfix ("}", [], max_pri))]


|> curry Sign.add_modesyntax
("latex", false)
[("LatexVarConst", "[SIMPLE_ID ] => TTerm ", Mixfix ("_", [], 1000)),
 ("LatexQualVar", "[SIMPLE_ID , SIMPLE_ID ] => TTerm ", Mixfix ("( '( (4)\\Var~ _ (3)~:~ _ ') )", [], 1000)),
 ("LatexWhen", "[TTerm , Formula , TTerm ] => TTerm ", Mixfix ("( _ /(6)~\\WHEN~/ _ /(6)~\\ELSE~/ _ )", [31, 0, 30], 30)),
 ("LatexCast", "[TTerm , SIMPLE_ID ] => TTerm ", Mixfix ("( _ /(4)~\\AS~ _ )", [990], 990)),
 ("LatexSorted", "[TTerm , SIMPLE_ID ] => TTerm ", Mixfix ("( _ (3)~:~ _ )", [990], 990)),
 ("parTerm", "TTerm  => TTerm ", Mixfix ("'( _ ')", [0], 1000)),
 ("_idT", "TTerm  => TTerms ", Mixfix ("_", [], max_pri)),
 ("_consT", "[TTerm , TTerms ] => TTerms ", Mixfix ("( _ ,/ _ )", [], max_pri)),
 ("LatexPrec", "[TTerms , TTerms ] => TTerm ", Mixfix ("(_ /< _)", [], max_pri)),
 ("LatexNPrec", "[TTerms , TTerms ] => TTerm ", Mixfix ("(_ /<> _)", [], max_pri)),
 ("LatexList", "TTerms  => TTerms ", Mixfix ("((1)\\{ _ (1)\\})", [], max_pri)),
 ("LatexSingle", "TTerm  => TTerms ", Mixfix ("_", [], max_pri)),
 ("LatexLDot", "[TTerm , TTerm ] => TTerm ", Mixfix ("(_._)", [], max_pri)),
 ("LatexLE", "[TTerm , TTerm ] => TTerm ", Mixfix ("(_E_)", [], max_pri)),
 ("LatexLNum", "[TTerm , TTerm ] => TTerm ", Mixfix ("(__)", [], max_pri)),
 ("LatexLNum_", "TTerms  => TTerm ", Mixfix ("(_)", [], max_pri)),
 ("LatexLEStr", "TTerm ", Mixfix ("(\"\")", [], max_pri)),
 ("LatexLStr", "TTerm  => TTerm ", Mixfix ("(\"_\")", [], max_pri)),
 ("LatexLSEnd", "TTerm  => TTerm ", Mixfix ("(_)", [], max_pri)),
 ("LatexLLCons", "[TTerm , TTerm ] => TTerm ", Mixfix ("(_,/_)", [], max_pri)),
 ("opensqbra", "TOKEN ", Mixfix ("[", [], max_pri)),
 ("closesqbra", "TOKEN ", Mixfix ("]", [], max_pri)),
 ("openbrace", "TOKEN ", Mixfix ("\\{", [], max_pri)),
 ("closebrace", "TOKEN ", Mixfix ("\\}", [], max_pri))]

|> Sign.add_name "CASL98";




end;
end;


