(* *********************************************************************** *)
(*									   *)
(* Project: HOL-CASL 							   *)
(* Author: Till Mossakowski, University of Bremen          		   *)
(* Date: 05.11.2001				 			   *)
(* Purpose of this file: Proof script for Basic/RelationsAndOrders         *)
(*			 						   *)	
(*									   *)
(* *********************************************************************** *)

print_mode := ["Inj"];  (* Show injections, but not types *)


(********************* Specification BooleanAlgebra ****************************)

CASL_context BooleanAlgebra.casl;

(* Abbreviations for getting axioms *)
val getBA = get_caslaxiom BooleanAlgebra.casl;

(* Feed all axioms into simplifier - a bit dangerous ... *)

AddsimpAll ();

Goal "forall x:Elem . x cup x = x";
by (res_inst_tac [("y3","1")] (absorption_def2 RS sym RS trans RS sym) 1);      
by (Simp_tac 1);
qed "BA_idem_cup";

Goal "forall x:Elem . x cap x = x";
by (res_inst_tac [("y3","0")] (absorption_def1 RS sym RS trans RS sym) 1);      
by (Simp_tac 1);
qed "BA_idem_cap";

